use thiserror::Error;

/// Errors returned while loading/parsing a serialized SymCache.
///
/// After a SymCache was successfully parsed via [`SymCache::parse`](crate::new::SymCache::parse), an Error that occurs during
/// access of any data indicates either corruption of the serialized file, or a bug in the
/// converter/serializer.
#[derive(Debug, Error)]
#[non_exhaustive]
pub enum Error {
    /// The buffer is not correctly aligned.
    #[error("source buffer is not correctly aligned")]
    BufferNotAligned,
    /// The header's size doesn't match our expected size.
    #[error("header is too small")]
    HeaderTooSmall,
    /// The file was generated by a system with different endianness.
    #[error("endianness mismatch")]
    WrongEndianness,
    /// The file magic does not match.
    #[error("wrong format magic")]
    WrongFormat,
    /// The format version in the header is wrong/unknown.
    #[error("unknown SymCache version")]
    WrongVersion,
    /// The self-advertised size of the buffer is not correct.
    #[error("incorrect buffer length")]
    BadFormatLength,
}
