#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" checkbutton with the pop-up tooltip """

# pytkapp.tkw: checkbutton with the pop-up tooltip
#
# Copyright (c) 2015 Paul "Mid.Tier"
# Author e-mail: mid.tier@gmail.com

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

###################################
## import
###################################
import sys

import gettext
if __name__ == '__main__':
    if sys.hexversion >= 0x03000000:
        gettext.install(__name__)
    else:
        gettext.install(__name__, unicode=True)
elif '_' not in __builtins__:
    _ = gettext.gettext

if sys.hexversion >= 0x03000000:
    from tkinter import Checkbutton
else:
    from Tkinter import Checkbutton

from pytkapp.tkw.tkw_tooltip import ToolTip, split_tooltip_cnf

# fixme: uncomment this block to run script directly OR set pythonpath for your package
#if __name__ == '__main__':
    #import sys
    #import os.path
    #lv_file = __file__
    #while os.path.split(lv_file)[1] != '':
        #lv_file = os.path.split(lv_file)[0]
        #print('append %s'%lv_file)
        #sys.path.append(lv_file)

###################################
## classes
###################################


class ToolTippedCBtn(Checkbutton, ToolTip):
    """ entry with some tooltip """

    def __init__(self, master, **kw):
        """ init widget """

        # separate kw
        ld_kw, ld_tkw = split_tooltip_cnf(**kw)

        # init main widget
        Checkbutton.__init__(self, master, **ld_kw)

        # init tooltip
        ToolTip.__init__(self, master, **ld_tkw)

    def configure(self, **kw):
        """ configure widget """

        # separate kw
        ld_kw, ld_tkw = split_tooltip_cnf(**kw)

        # configure main widget
        Checkbutton.configure(self, **ld_kw)

        # configure tooltip
        ToolTip.configure(self, **ld_tkw)
