#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" icons for additional tkinter widgets """

# pytkapp.tkw: icons for additional tkinter widgets
#
# Copyright (c) 2015 Paul "Mid.Tier"
# Author e-mail: mid.tier@gmail.com

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

###################################
## import
###################################
import sys
if sys.hexversion >= 0x03000000:
    from tkinter import Tk, PhotoImage
else:
    from Tkinter import Tk, PhotoImage
from pytkapp.tkw.tkw_tooltippedbtn import ToolTippedBtn

###################################
## globals
###################################
__NOICONDATA = '''\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'''

gv_xscrolledtext_import = '''\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'''

gv_xscrolledtext_unload = '''\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'''

gv_xscrolledtext_export = '''\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'''

# clear log
gv_xscrolledtext_clear = '''\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'''

gv_xscrolledtext_print = '''\
R0lGODlhEAAQAPcAAAAAAHJxb3RzcnZ0cnZ1dHh2dXp5eH1+fIWGhIaFhIiKhYyLip+fn6mpqaqq
qqqrqaurq66urrKysrOzs7W1tba2tre3t7i4t7i4uLm5ubu7u76+vsTExMXFxcbGxsfHx8zLy83M
y9TU1NXV1dbW1tfX19jY2NnZ2dzc3N3d3d7e3t/f3+Dg4OHh4eLi4uPj4+Xl5ebm5ufn5+jo6Ozs
7O3t7fDw8PHx8fLy8vPz8/T09PX19fX19vb29vf39/j4+Pn5+fz8/P39/QAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAA
hwAAAHJxb3RzcnZ0cnZ1dHh2dXp5eH1+fIWGhIaFhIiKhYyLip+fn6mpqaqqqqqrqaurq66urrKy
srOzs7W1tba2tre3t7i4t7i4uLm5ubu7u76+vsTExMXFxcbGxsfHx8zLy83My9TU1NXV1dbW1tfX
19jY2NnZ2dzc3N3d3d7e3t/f3+Dg4OHh4eLi4uPj4+Xl5ebm5ufn5+jo6Ozs7O3t7fDw8PHx8fLy
8vPz8/T09PX19fX19vb29vf39/j4+Pn5+fz8/P39/QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAi4AAEIHEiwIMEHCBMqfFDwAZCHQBRA/MHwIBAO
HBRoxEixIZAbGkPm8FFx4AMfGD0o8PDhQ8eDPli4eKEARgwZJBv22MFzBw8ePXIKPHAAAYQGEJIm
beAAAVEAB4IA0UG1atUYMw5AFSKiRoQcK160cMECBYMQWg/YAJEihYq3KNqeWNAhLY4NCQwYIFBg
QAABBSTUhYpDQ4YMGDBcqDCBggUMH9LSKGHCRInLl0eUICEiLdHPoEMHBAA7
'''

gv_alistbox_search = '''\
R0lGODlhEAAQAMQUAF2UuqqqqpjM85LE76HW+I+/7dz0/9ju/JTG8Kjf/OPj4/j4+Ozs7NHm+Nft
/Nrx/tHn+M/k99Pp+vn5+f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABQALAAAAAAQABAAAAVQICWOZFkCKGCeRmuoKwU8SZ088OkQfO/kI4BEQCxKgCJAY8BsNpCySGFK
jUBlEIQWAQEEYoCD+ABQML6rlHdhRsdEAfb5PYpP3PQAns6nhwAAOw==
'''

gv_alistbox_add = '''\
R0lGODlhEAAQALMMAJy4ZLjyctX2p8L6e8numMj/gbLtba3pZ6PhXqjlY8X9fr32dv///wAAAAAA
AAAAACH5BAEAAAwALAAAAAAQABAAAAQ6kMlJq714ApApKAXXMYCiiB0wDKi1bcvytmRg33gLCLxg
GD0BbXY4zDKARIJ2ASAQTBeBEHVVR1hMBAA7
'''

gv_alistbox_remove = '''\
R0lGODlhEAAQAJEDALhkZPanp/+Bgf///yH5BAEAAAMALAAAAAAQABAAAAIbnI+py+0PIwO02gSE
3hwgEITi6H3WKaXqyrYFADs=
'''

gv_mlistbox_selectall = '''\
R0lGODlhEAAQAPcAAF2UunC48nfA97TY9n3G/Gmw7WKp6Ljc+bHU9IHL/6/S8v///wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAsALAAAAAAQABAA
h12UunC48nfA97TY9n3G/Gmw7WKp6Ljc+bHU9IHL/6/S8v///wAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAhYABcIHEiwoMGCAAAcNAggQACFCwU2DDAA4sKJ
FRlCnHhAYcKBExM6zBhS4gCHIz2mBKlAoAKVFC2C3OiwI0OHImMeBHASZcaLCgwYeBlRogKiRSXK
TBoxIAA7
'''

gv_mlistbox_moveup = '''\
R0lGODlhEAAQALMAAF2UunrD+rrf+37I/Wqy7mWs6nW+9nC48rDT84HL/////wAAAAAAAAAAAAAA
AAAAACH5BAEAAAoALAAAAAAQABAAg12UunrD+rrf+37I/Wqy7mWs6nW+9nC48rDT84HL/////wAA
AAAAAAAAAAAAAAAAAAQwUMlJq704a6ApSFwHDGSIAUGamhUgCEb8shNgH7hNe0S/t4Xgz4MoDmu6
Y2fJzEQAADs=
'''

gv_mlistbox_movedown = '''\
R0lGODlhEAAQALMAAF2UunC48n7I/XW+9nrD+mqy7oHL/6nZ+KDR9KTV9mWs6p3O8////wAAAAAA
AAAAACH5BAEAAAwALAAAAAAQABAAg12UunC48n7I/XW+9nrD+mqy7oHL/6nZ+KDR9KTV9mWs6p3O
8////wAAAAAAAAAAAAQxkMlJq704Y8C5ZoAhAh8gnKQGEGx6dUPcvUdg24dbAUnhJzoLAKFABF+L
4+bDbDotEQA7
'''

gv_mlistbox_reset = '''\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'''

gv_xtablelist_resizebydata = '''\
R0lGODlhEAAQANUyAP///wBmzCgzP4CNmmBpdPv8/fz9/vP3+vr8/dTc5Ozy94GOm+jt9NDZ4e7z
97/J04KPm+fu9MvT3HSAjNnh6XiEkGRueNDY4PT3+/z9/crT3LnDzM3V3cXO1yo1QOrv9b3H0nJ9
hm95hE9SVnV7gUpTXWFpdH6Kl2lyfgBlzXB8hwBlzgBmzYCLlmJpcpCXnYeUoGtzff///wAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADIALAAAAAAQABAAAAaDQJlw
SCwaj8hkQAiDDBaD5wDykqUC2MAJAIhwvYDWcCmrcClnbmUsnAAyCYMhkQFM2DIVAHEpFC4IACF4
Ig0aHBISHBoNJDIrWQEoAAcdGBgdBwAxeBYACg8ODg8KABZ4BAAMGx8fGwwABHgmXCC1XC54JQIC
Hry+AiMyLJFJRGTGRkEAOw==
'''

gv_xtablelist_resizebyheaders = '''\
R0lGODlhEAAQANUsAP///wBmzICNmigzPyczPgBiz9ri6tPb4vX4+8DK1MHL1PL2+fP3+fj5/IeU
oGJrdnV/i4KPm+zy9vf5+0pTXdTc43iEj8bQ2m96hWp1gfr7/cDJ09Pb42FrdOju9Onv9GhyfH2J
lsTN1s7W3sjQ2ufu9L3I0rvFzyo1QIGOm9rh6dbd5f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACwALAAAAAAQABAAAAZ9QBYr
IBQSi0dkcbhMDgPQqBTarCqXBax2ye1yHRGBOCUWRBzcEGANKLEBIa7lrXpbuBDDgVNZVTgHBhBc
GAATDRojGg0TABhcGQALDAgkCAwLABlcIBcbCQoiCgkbFyBcDwAeHxInEh8eAA9cHW8mbx1cFAME
BAMovL4URUEAOw==
'''

gv_xtablelist_export = '''\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'''

gv_xtablelist_import = '''\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'''

gv_icon_tree_collapseall = '''\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'''

gv_icon_tree_expandall = '''\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'''

gv_icon_dialog_error = '''\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'''

gv_icon_dialog_information = '''\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'''

gv_icon_dialog_warning = '''\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'''

gv_icon_widget_configure = '''\
R0lGODlhEAAQAMQXAHF6hf///93m7uDf9664w6OtuOrw9j1IUjpDTzI+Sf3//8XQ2+/1+vD2/DtF
ULrF0GJrdeLq8r/K1b7J1bjEzzlDTsLN2f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABcALAAAAAAQABAAAAVU4CWOI2ACZCoCiiIkKskGbyy78IqqQJBfAMouBTBMIECJYFgKBBgLwCOy
JAYKhsFCwD1YsQPCYeyVXbNiWw9MqKjPYcSbLVcXGnFbyUKo61cOfyIhADs=
'''

gv_icon_toolgroup_collapse = '''\
R0lGODlhBwAHAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAAkALAAAAAAHAAcA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///wgbABMIHEgwQapUAw9SQ2gwFbUHDBsuLHiw4MCA
ADs=
'''

gv_icon_toolgroup_expand = '''\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'''

gv_icon_txtl_up = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAA8ALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///whHAB8IHEiwIEEuhgwqfIBwocGGDg8amkjRkKqF
qrho3AgxosAsCT0+yDIoi0iSrkpGzMLSFUuTK12KHKnyJMuZDEOK7IhTYEAAOw==
'''

gv_icon_txtl_lup = '''\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=
'''

gv_icon_txtl_down = '''\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==
'''

gv_icon_txtl_ldown = '''\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'''

###################################
## routines
###################################


def __acceptname(pv_iconname):
    """check some rules about icons"""

    return (isinstance(pv_iconname, str)
            and not pv_iconname.startswith('__')
            and pv_iconname not in ('PhotoImage', 'run_demo', 'get_icon', 'Tk', 'ToolTippedBtn')
            and pv_iconname not in sys.modules)


def get_icon(pv_iconname, pv_defdata=None):
    """get local icon"""

    lv_defdata = pv_defdata if pv_defdata is not None else __NOICONDATA

    icon_data = lv_defdata
    try:
        if __acceptname(pv_iconname):
            icon_data = globals().get(pv_iconname, lv_defdata)
    except:
        pass
    return icon_data


def run_demo():
    """ local demo """

    def name2clipboard(wroot, pv_name=''):
        wroot.clipboard_clear()
        wroot.clipboard_append(pv_name)

    root = Tk()
    root.title(__file__)

    ll_imgs = [x for x in globals() if __acceptname(x)]
    ll_imgs.sort()
    lv_lenimgs = len(ll_imgs)

    lv_pos = 0
    lv_x = int(len(ll_imgs) ** 0.6)

    lv_r = 0
    while lv_pos < lv_lenimgs:
        lv_c = 0
        for i in range(lv_x):
            if lv_pos >= lv_lenimgs:
                break
            try:
                img = PhotoImage(data=globals()[ll_imgs[lv_pos]])
                b = ToolTippedBtn(root,
                                  tooltip=ll_imgs[lv_pos],
                                  image=img,
                                  command=lambda ev=None, wr=root, wt=ll_imgs[lv_pos]: name2clipboard(wr, wt))
                b.grid(row=lv_r, column=lv_c)
                lv_c += 1
                lv_pos += 1
            except Exception as err:
                print(err.message)
        lv_r += 1

    root.resizable(width=False, height=False)
    root.mainloop()

if __name__ == '__main__':
    run_demo()
