#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" common icons """

# pytkapp: common icons
#
# Copyright (c) 2015 Paul "Mid.Tier"
# Author e-mail: mid.tier@gmail.com

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

###################################
## import
###################################
import sys
if sys.hexversion >= 0x03000000:
    from tkinter import Tk, PhotoImage
else:
    from Tkinter import Tk, PhotoImage
from pytkapp.tkw.tkw_tooltippedbtn import ToolTippedBtn

###################################
## globals
###################################
__NOICONDATA = '''\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'''

###################################
## icons
###################################
gv_child_header_icon = '''\
R0lGODlhEAAQAPczAJGX/3H/eZAAh3H/rpxx/2OQAJH/mP///3F6///r0f/70QCQdJHB/0wAcExw
AP/5sfD/0QB0kPDR/wBNsACOsABbz3BoAFHd/3Gv/1Gd/9H2///R69Hl/9H/9hF5/zGK/3Hk/5Hq
/3AAabHS/7Hw/1AASwBwWjdQAABQQP+/sQA+kLBjAHA/APDhAM92AJCGAFAtAM/DAP+mMQAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABL07AAAAMgAAHyRBRXLGPW4
AFEAEnyRBRUTeAVtAAB8kQAAAJEEPQAAfAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIoAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAS9gC/v/MIAAAAEgAVABL2rO4YAMB8kHyRQP///0C7/458
kQAB1gAARfT8AIAAEsAQABL2rO4YAHB8kHyRBf///wAA/z0AAHyRBBL2MAlfAAB8gQAAANubxP//
AMQAzwDbmwAAGAAAABgAAAAS9gAAQAAAAPwAAAAS9QAAAAAAAAAAAAAAAAAADAACAAEAAHyQAf38
AOXlfzB8kHyBDAAC9PZMAFQAEgAS9gAACAAOAIgAAADboAAAAAL0AE8AAHyAGgAC9AAAAADAAAAA
AAAAAAACAAAAAAAAAAAAAAAAAAAAAAAAAJDl5SDAfPR8gwAAAoD2EiH5BAkAAP8ALAAAAAAQABAA
AAikAAEEEDCAQAEABv4pXKgQwYEEBx4CUACA4cIFCiJGnHggoUWHGhUwaOAAgcV/CB5A0Pgw4skI
ESWwnEChQgWGFjSuPFDhAoYMF242PKBhAweeDA508PABhNAICiAerQDiANAQThWKYMkzxIELIzqQ
EFrCxIkSKHiOSAGChIaxJxeqCKFBQ4gJFlbEVaiirwoWLVy82MsQRgwZegkvhMFisGKLAQEAOw==
'''

gv_subchild_header_icon = '''\
R0lGODlhEAAQAPcAAAAAAG5wbYGDgHN0cK66yKK61Ke5zG1va6e3yIqs0cXX6pu52ZCsy4WHg4iK
hY2PiqKuu4Soz9zm8uTs9cra7I2x2Jewy////6K40KTA3tnk8d3n8sPV6qK/34Cl0PDw749ZAqe1
woiq0LvQ6M3c7t7o86jB3JSwzsfHxu7qxs+tcZ+40ZGz1rvQ5qa+2Je109HS0O/rx9KsaqGDVYSE
gqOko7PI3X+n0Zm00ZWWk6SHV7i4t42OjLCxr+3mxc+qaaCDVu3lxMifZKCEV4mAaomLhu/v7nBb
OcKriqOFVefcyoeJhP7+/UxCJmtXNszBr+/v74KEf/r6+e7u7bOplsLCwsvLyuLi4n1/e/7+/vf3
9+np6eXl5erq6oyOiYaIg4WHgouNiAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABL03AAAAMgAAHyRBRavePWo
AFEAEnyRBRYTeAVtAAB8kQAAAJEEPQAAfAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIoAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAANgAAABX3gBQ/vL4AAAAEgAWABL2nO4YAMB8kHyRQP///0C7/458
kQAB1gAARfTsAIAAEsAQABL2nO4YAHB8kHyRBf///wAA/z0AAHyRBBL2IAlfAAB8gQAAAOPciP//
AIgA2QDj3AAAGAAAAAgAAAAS9gAAQAAAAOwAAAAS9QAAAAAAAAAAAAAAAAAADAACAAEAAHyQAf3s
AOXlfzB8kHyBDAABsPY8AEQAEgAS9gAACAAOANQAAADj7wAAAAGwAE8AAHyAGgABsAAAAADAAAAA
AAAAAAACAAAAAAAAAAAAAAAAAAAAAAAAAJDl5SDAfLB8gwAAAXD2EiH5BAkAAP8ALAAAAAAQABAA
AAjDAP8J/Ceg4MCDCAX8K0AQYUIECRQsYCCggYOLBwVAiCBhAoUKFgRcGOlgoAAMGTRs4NDBg4AP
Hy6AACFQQAgRI0iUMHFCAIoPIFKooElwBYsWLl4IgAE0hox/NGnUEGDjBg4BOVCAcKojao0dPAoK
6AHUxw8gRGmAvfABhVsQQYQMAUFkII9/bGEaOYIkCQglSxAy0QuiiRMQT6BEQSgF5hQAIKhUsXIF
C8KRF7Jo2XKFSxfFCItcdLDkC5gvqB2qdhgQADs=
'''

gv_child_header_close = '''\
R0lGODlhDAAMAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/iD2EiH5BAkAAP8ALAAAAAAMAAwA
AAgoAP8JHEiwoMGCAAAQTIhQ4T+GBhNCPDgxokSKDis+dChQ48GPIEEGBAA7
'''

gv_child_header_maximize = '''\
R0lGODlhDAAMAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/iD2EiH5BAkAAP8ALAAAAAAMAAwA
AAgsAP8JHEhwIICDCBEaTJjQYEGBABw+jAjx4T+KFy1ixEhwo8aFDA9aHElSYEAAOw==
'''

gv_child_header_restore = '''\
R0lGODlhDAAMAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/iD2EiH5BAkAAP8ALAAAAAAMAAwA
AAgsAP8JHEiwIICDCAv+Q5jQIEEADxlChDhQ4sSHESkK1LhQIUeOGyUqHEmSZEAAOw==
'''

gv_child_header_help = '''\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'''

gv_icon_action_move = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAAkALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///wg+ABMIHEiwoMGDBQEgJKhwIcKGCSBGHCgxokQA
FRVi3MhRI8WOIClaBIlxIsOLGUWqNOnQYMWDL1uyXBjTYUAAOw==
'''

gv_icon_action_select = '''\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'''

gv_icon_dotted_grid = '''\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'''

gv_icon_solid_grid = '''\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'''

gv_app_toolbar_toggle_logpane = '''\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'''

gv_app_toolbar_cascade = '''\
R0lGODlhEAAQAPcAAFFxqVFyqVZ2rVd5rlh7sVx+tF6Bt1+DuWCFumGFu2OHvWSIvmaLwGiOw2yS
yG6XzG+QwXCZznKaz3Od0nWe1Hag1Xei13ii2HmaxHmi2Hmj2Xqk2nqk23qm3Hun3ICk1IGn1oOp
2YWs3Yar3Iat3Yet3oev34iw342x3Y2045G03pG04JK56Jy74Z3A6rG/2LTC2u7x9+7y9+/y9+/y
+PDz+PDz+fP2+f7+/v7+//7//////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADwALAAAAAAQABAA
h1FxqVFyqVZ2rVd5rlh7sVx+tF6Bt1+DuWCFumGFu2OHvWSIvmaLwGiOw2ySyG6XzG+QwXCZznKa
z3Od0nWe1Hag1Xei13ii2HmaxHmi2Hmj2Xqk2nqk23qm3Hun3ICk1IGn1oOp2YWs3Yar3Iat3Yet
3oev34iw342x3Y2045G03pG04JK56Jy74Z3A6rG/2LTC2u7x9+7y9+/y9+/y+PDz+PDz+fP2+f7+
/v7+//7//////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiXAAGg8NBhQwUKEyREwACAh0MeIlhInEgRwkMe
HjJq3OiBwUUOO0KKHKngooYdMFqcMFFiRAgQHx4wdJhhxwoXOHPiTMHCIg8HO04IHTrUQkeHABpc
GMl0R8mHJ1+oILghQ4WECxvyqEmCoteeDoFyHOuRR1KQTUU+dXgybUgEF2u63WHgItC5AS4mZbAg
wYECBAYIAAAgIAA7
'''

gv_app_toolbar_tile = '''\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'''

gv_app_toolbar_overview = '''\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==
'''

gv_icon_config_ui = '''\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'''

gv_icon_clear = '''\
R0lGODlhEAAQAPdxAHhIAHxLAHtKAP///6ZpCqttC7JyDMF9EKlrCoppAJyLAHlJAIZSA7x6D4RS
AZqFAIBOAbJ2C6GIAb6uMrGgHYdkAJyIAM29Qeved7BpF6A2AKCPAZ2MAJ6NAdjIT+zcaMhtM6sb
DdexYurccsy9Q6KQCZ+OAZ6NALulKbtKKLg4HfbYYf3qY/3rbP3uffjqiM2+RZ+PBZ+OAKEkAK1C
E/vqhP3sa/3vhP3sbf3pUvvlRPPjZevdd8/BSa6eG5x/AMCwL/3viv3qX/3rYf3mPPPbKufQGNzG
EOTSSeLUZ5+NAaWUEfvti/zlPPvkN/beL+7XI+XNFNvDBNrCA+bWVsa2M6COAd3PXu3aRuPLEdzE
B+TTTNzNWJ+OBKubGujabNzFENzGFefXW9bIVqCPBcW1NufYX9/KJuXUTufZbcW0MtLDT+HTW8a1
MKGQCJ+NAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABL03AAAAMgAAHyRBRavePWo
AFEAEnyRBRYTeAVtAAB8kQAAAJEEPQAAfAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIoAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAANgAAABX3gARCPL4AAAAEgAWABL2nO4YAMB8kHyRQP///0C7/458
kQAB1gAARfTsAIAAEsAQABL2nO4YAHB8kHyRBf///wAA/z0AAHyRBBL2IAlfAAB8gQAAAONdNP//
ADQA2QDjXQAAGAAAAAgAAAAS9gAAQAAAAOwAAAAS9QAAAAAAAAAAAAAAAAAADAACAAEAAHyQAf38
AOXlfzB8kHyBDAABsPY8AEQAEgAS9gAACAAOAIQAAADjbwAAAAGwAE8AAHyAGgABsAAAAADAAAAA
AAAAAAACAAAAAAAAAAAAAAAAAAAAAAAAAJDl5SDAfLB8gwAAAXD2EiH5BAkAAP8ALAAAAAAQABAA
AAhzAP8JHEiwoEACBQwq/GfgAIKFBhscEKgA4sAIEiwWvIBBo0APH0CEEDFCYwoVK1i0cPHCYg0b
N3Dk0LGDx8IgQobkIFLEyBEkSQwyaeLkCZQoUqZQUXgFi5EsWqZM2cJl4RcwUsOI0WjmDJo0Hv+x
CWsxIAA7
'''

gv_icon_refresh_green = '''\
R0lGODlhEAAQAMQAALnik2aXQv7+/dPut73llbfala3LmW6gSWqdQ2eYRGqaSLfck568iYrUQN7y
zF6RPLTXlYjUP8XwmYfQQLbYl4jRQGiaQsPumNbyu7nglNPzsLXYlf7+/lCHK////////yH5BAEA
AAIALAAAAAAQABAAhLnik2aXQv7+/dPut73llbfala3LmW6gSWqdQ2eYRGqaSLfck568iYrUQN7y
zF6RPLTXlYjUP8XwmYfQQLbYl4jRQGiaQsPumNbyu7nglNPzsLXYlf7+/lCHK////////wVboCCO
ZGkKShAo4nM6CDZg2GF0ZzcAQNUsGFypw+gYKZMIQUjqWEadCyHDHCWgxuxpa8pqRdeh5iJhWqqi
jiQyoWSLXcmiUeFB0GnDoVDYQBQOJy4oKixch4hbIQA7
'''

gv_icon_refresh_blue = '''\
R0lGODlhEAAQAMQAAJXG2JXa+ZLO5ChrlkCy4TZ1kiVvpCN0trvo9SN5xTd4lrfh7iR9zo3S+EGz
7JDJ4TaCromrvC9ymyV+0Dd3mTl1koe72YvN7LTj+9ne6N3g6v7+/0Cw2Stoh////////yH5BAEA
ABsALAAAAAAQABAAhJXG2JXa+ZLO5ChrlkCy4TZ1kiVvpCN0trvo9SN5xTd4lrfh7iR9zo3S+EGz
7JDJ4TaCromrvC9ymyV+0Dd3mTl1koe72YvN7LTj+9ne6N3g6v7+/0Cw2Stoh////////wVq4CaO
ZGluVVFQonRmCrIgCGQZZ7cIAkdcmIOpE+l0Bg+Co5EYKkaGQKPBMBVGA8MhwZicvqYJI3EwDEbX
EgMTCOBEio4pEXAQHoMBUV46BC4EHDwAfCUGFhAPDwAAChonLhsUKhVglpdgIQA7
'''

gv_icon_error_sign = '''\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'''

gv_app_toolbar_closeall = '''\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==
'''

gv_app_toolbar_closeoth = '''\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'''

gv_app_toolbar_add = '''\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'''

gv_icon_action_gcross = '''\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'''

gv_app_toolbar_close = '''\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'''

gv_app_toolbar_restore_child = '''\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'''

gv_app_toolbar_maximize_child = '''\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=
'''

gv_app_options = '''\
R0lGODlhEAAQANUAAP///yg0P9HZ4VNeae7x9oOQnKSor1NgaUxWYXeDkN7f3/T3+N3l7bS+yNfg
6HR+ieLn66mwtquxt3N9h3iDjtHZ4+Dn7ZujrKissL7FzNLb5XB7h5Ccqf39/KCnri45RLrE0e/v
7ri8v9PY37/GzS87Rp2su3eDjmx5hEJNV2Ztd+Pn64iVoba8wd3j6MXN1oCNmdzh5GNsdigzPnJ9
idPV2LnCydrd4lBdZ0VPWZagqYOPmU1WYP///wAAAAAAACH5BAEAAAAALAAAAAAQABAAhf///yg0
P9HZ4VNeae7x9oOQnKSor1NgaUxWYXeDkN7f3/T3+N3l7bS+yNfg6HR+ieLn66mwtquxt3N9h3iD
jtHZ4+Dn7ZujrKissL7FzNLb5XB7h5Ccqf39/KCnri45RLrE0e/v7ri8v9PY37/GzS87Rp2su3eD
jmx5hEJNV2Ztd+Pn64iVoba8wd3j6MXN1oCNmdzh5GNsdigzPnJ9idPV2LnCydrd4lBdZ0VPWZag
qYOPmU1WYP///wAAAAAAAAavQIBwyCoUWMOk0AiACZ3M5C5DSCQsFishoxviSITFAtDpAMQE0kF4
IJhGIUilAgmNTIQ1W6EAnT4fJyB8ehQ0KDU2HDlCPBw2NSg0FBtCIi8DSQMvIkIbDw4OGC6ZQwMu
GKEPJTMIBi0GpQOvBggzJUIIAhcxsbMxFwIIQwECKwIeNxISNx7GAgFCARECDdUMDNbWEdHSEwIp
MtgyKQIT3cTRKhoaKgAB6Erv8PFCQQA7
'''

gv_options_openfile = '''\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'''

gv_options_openfolder = '''\
R0lGODlhEAAQALMAAMqjN///ovrvgPbhRfvyafPYM/biZvz1j/jpVfjpdP///wAAAAAAAAAAAAAA
AAAAACH5BAEAAAoALAAAAAAQABAAg8qjN///ovrvgPbhRfvyafPYM/biZvz1j/jpVfjpdP///wAA
AAAAAAAAAAAAAAAAAAQ+UMlJq7046w36VkAgdqRHAQKCCGwrAKdRzvDUiXge1CBgFMAgUGYDJAbI
JDLB6xwI0Cj00AzpcrwejfTpaiIAOw==
'''

gv_options_calendar = '''\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'''

gv_icon_clock = '''\
R0lGODlhEAAQAOZqAJlmAP/UAFw6AP///9HZ///ea/r/////5f/VAPz//9La///TJdHX////z9Tc
/6Gi/8e6ufL6/9bh/5KT/5GV/9HW/tDV/5aZ/1FRx8TE/nF18Hd697Gx/oyQ/8C5uKq28hwnMBwn
MY+T9YmJ+P//5q21+Nvm/3t+4IiTnXR9h9zp/8fW/HZ+iBciKd/r/+Dr/5ye+o6S9oWPmN/q/4iK
+IWJ5P/fNPL9//T8//H8/6+16YaN4MXQ++jq+Xt/2szY/3J03/n///P9//b//+Hs/+74/5eb2uHt
//3//4uVnez2/6m18YOOm6+3+rC36nd55Gls1ISI5eDf5Xl91mhr08O3sFVfivH9/5eb2+j0/+/6
/9Xg/+f0/+fq+eDf5MTT+Xd828O4s/P7/4iVmf/fM//WAEpTWvD//5qd+l9ocf///wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAGoALAAAAAAQABAAAAfLgGqCggCFhoOIaoUDjI2FiQCMXkYYGFhSjACDAAcHU1ROXT06UD4k
B5qKDWA7CUgGBoxWJw2aAAUeQGc4ERFiCUljTx4FhQVRSzlKRUJBKDIGHzXFADYaK1c3QyxpTFpZ
XxpkhWUbPy0gIWYpXC4qPBsIhQExTS9HRDMmElsSJSIB5oWh4UABgYMEFDgYUSWgGgEBKMCowMCC
BQYV0FAIIEAQxAUXJnDIkIHDhAsLOA6CiADCgw4dHkBAoBKRAIgBcua8mWjlzZ+JAgEAOw==
'''

gv_icon_escalate = '''\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'''

gv_icon_case = '''\
R0lGODlhEAAQAOZFAP//AP/MAP/SAP///5NgAP/QAF49AJRhAMWWAJJfAP/sAP/fAJlmAMqVAMma
AP+aOsuYAJtjAseXAHpRAMyXAP+ZO45bAP/YAP/RANmAJv3OAMx0Ev/yAPTBAPK/AP/jAPjFAI2U
5f/+AOawAJViAP+WN+i0AMmPAJ9iCV09AGBAAMyZAM2aAF8+AOj4///TAMaWAIxcAPKMMf6TOYtY
AMaRAOy5AP3KANijANagAMmWAImR8f/OAOv6/49dAJZjAN2mAK9mA+aGLOWGLK1mA////wAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAEUALAAAAAAQABAAAAfLgEWCggwPJSUPDIOLhD4CGhoCPoqMgjEdNBYWNB0xiwcsCBUOOhAr
KxA6DhUILAcJAwMzCLG1AwgzsQkJNxgyCAUBwgEFCDIYN7sgAkIwwcMFMEMCIAkEHi8ZEs/CBRIZ
Lx4EBDYCGzU8wwE8NRsCNuMmFz0uAvb3Lj0XJgQHIzshTnxYQHDBhxMhdow4cACIiCANOCiYqIBD
AyIigBwgkQMACgoAQoqkgAJADhI/QkbAIVIkjgghfxSZkEJFCwM4c7ZQkWJCpZ+LAgEAOw==
'''

gv_icon_briefcase = '''\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'''

gv_app_action_back = '''\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==
'''

gv_icon_netmap_cloud = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAAkALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///whVABMIHEiwoEGBAAAcNAjgwAGFBxMmdOgQIsGG
FTE+lIiQYsWPGRNozDjyYUeKGDVaFCnRY8OEDD1uXCkSoUSYDBfWvIiwp8+BEIMCvQhTIUeOOhcG
BAA7
'''

gv_icon_netmap_datacenter = '''\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'''

gv_icon_netmap_hub = '''\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==
'''

gv_icon_netmap_operator = '''\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'''

gv_icon_netmap_operators = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAAsALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///whGABcIHEiwoMGDCAEAIKjwIIAHDxYueBjRIEWJ
Fx1KFNgQoUeLGyeG5KiwYcmSIBmOJNnxpEWOMCe+lElzJcaYNnHG/HgwIAA7
'''

gv_icon_netmap_powersupply = '''\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'''

gv_icon_netmap_server = '''\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'''

gv_icon_netmap_storage = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAAkALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///whOABMIHEiwoMGDCBMAWMiQ4UEADxZGhAjg4cSL
FQ1S3BixYEWOEjMO/IiR4siFCkt2JEjygcuXIgWSbGhSY8SbNT2+3BnzJE2UCYMKHRgQADs=
'''

gv_icon_netmap_terminal = '''\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'''

gv_icon_netmap_wirednet = '''\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'''

gv_icon_netmap_wirelessnet = '''\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'''

gv_icon_netmap_firewall = '''\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'''

gv_icon_netmap_workstation = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAAkALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///whPABMIHEiwoMGDBwEoXMjQIIADCCJKPADAIUSJ
ESlaxJixYsGHHBFo/HigpMmSHgkyXJkSoUuBLBuqpIgAQM2bIxM8tPnwpM2RMWO+HEo0IAA7
'''

gv_icon_computer = '''\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=
'''
gv_icon_db = '''\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'''

gv_icon_tux = '''\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'''

gv_icon_shield = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAMWUJP///+KuEfPhcPvGAPvTJf3mXe66
B9ajGf3udfzKCP73kf7ra/zgT/rVMOu2CvvcQe24CN+sEfnLGOKzHPjHCtmmFtKgHOOvD//4jPHH
JOq3CfzscvzpaP3vffPjefzXM/rRJv3ra/nTL/zoZv7wev3qb/3lY/70hf3vd/vnZP/xevnMGPvc
SfzgVvvfS/zcQfnKEfraP/rMFfzPF/G8B/vYPPnQJPrFAPvOF/rdSvrVMvvXM+CsEt2pFNypFNyp
FcaUJdCdHtmmF8iWI/jGCu25CPjHCeu2Cey5CO7DIvnLF/rICc+cHvzkW/viV+WxDvzjWPnYPPra
PfvgTvzhT+q3Cui1C+i0DOayDeKvEeayDuWyDeOvEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAe+gAAACIKCCISFiIISR4JKBARRixKFAFcEEEkEAhwEHBCYlVggDKUC
WRoaKQRblV0KJgofAloKLCodXJVeDSMlJwIZDQ0eKxmVEwcHUigCyQdPUD6VPw4OMC8CQQ5WVTtA
lRcRMVQuAuIRM1NElQkPIQ83Au49PCQJlRgbBjgiBvsGDCzBUGlIhRoUmMig0YKCjgpOKgUYsGAB
EiMWLDRZMCBAJQATC+QoQLJAx4+CAkwcYGNAEY8oC6kUArNSIAA7
'''

gv_icon_user = '''\
R0lGODlhEAAQAMQTAGShuKaigbSxp5rU73rO8XjF6nva+e3im+/t1cbDn8nGp////+/t1o2/znzi
/4y7y+3t7Yy1x/Tz4////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABMALAAAAAAQABAAAAVT4CSOZGkGKGqS6OGq6xQcSn0EsZwk0o7HAoRQKMgJBIzkMQc4OgExgKOx
qDYc0BLAwH1AHlxDdgQgmAmRM2EsAgwK8HhhwG4P7nh6FMDv5/6AKyEAOw==
'''

gv_icon_group = '''\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'''

gv_icon_action_add = '''\
R0lGODlhEAAQALMMAJy4ZLjyctX2p8L6e8numMj/gbLtba3pZ6PhXqjlY8X9fr32dv///wAAAAAA
AAAAACH5BAEAAAwALAAAAAAQABAAAAQ6kMlJq714ApApKAXXMYCiiB0wDKi1bcvytmRg33gLCLxg
GD0BbXY4zDKARIJ2ASAQTBeBEHVVR1hMBAA7
'''

gv_icon_navsup = '''\
R0lGODlhEAAQAOYAAAEAAAB8w3XF8Eeo3l225lKv4me86hhAiy6Z1W/B7RFRm1Kv42/B7gthqQ6F
yAllrhiLzCOS0C+Z1Ro9iA1cpQJ2vhZEjw9WoEao3hk+iDuh2QaAxjqg2i6Y1QVvtl225wVvt123
5w1bpGe96jqh2hVIklOv4me86wdqsw1bpRdFjkeo3wtgqSKR0COR0QF6wBdEjw9XoBiKzNjf7Eao
3xRIkjug2Tqh2RNMlxNNlhdBjCKR0RZFj3XF7w9XnwthqgRzu2e96waAxQRzum7B7Qdrsg6EyBeL
zAF5wQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAAAALAAAAAAQABAAhgEAAAB8w3XF8Eeo3l225lKv4me86hhAiy6Z1W/B7RFRm1Kv42/B7gth
qQ6FyAllrhiLzCOS0C+Z1Ro9iA1cpQJ2vhZEjw9WoEao3hk+iDuh2QaAxjqg2i6Y1QVvtl225wVv
t1235w1bpGe96jqh2hVIklOv4me86wdqsw1bpRdFjkeo3wtgqSKR0COR0QF6wBdEjw9XoBiKzNjf
7Eao3xRIkjug2Tqh2RNMlxNNlhdBjCKR0RZFj3XF7w9XnwthqgRzu2e96waAxQRzum7B7Qdrsg6E
yBeLzAF5wQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAeRgAABg4SFAQCIiC8CjI0CPUiJiRUJDAyVCUQVkolDJwZBBgYjQJyJHgQfIQSsIKaIKAsFBbIm
C0WvDxgrAwM0AxgDD6YsJBo/DTc2HBocDZwUEiKIKRII1x0Ukj4XkjERLS47Ed2ICqYKMkcQEOev
iTkODkY474k1QhsbJfaIPDAqLFjop0DHgYP9AGSYsFBSIAA7
'''

gv_icon_navsub = '''\
R0lGODlhEAAQAOYAAAEAAAB8w3XF8Eeo3l225lKv4me86hhAiy6Z1W/B7RFRm1Kv42/B7gthqQ6F
yAllrhiLzCOS0C+Z1Ro9iA1cpQJ2vhZEjw9WoEao3hk+iDuh2QaAxjqg2i6Y1QVvtl225wVvt123
5w1bpGe96jqh2hVIklOv4me86wdqsw1bpRdFjkeo3wtgqSKR0COR0QF6wBdEjw9XoBiKzNjf7Eao
3xRIkjug2Tqh2RNMlxNNlhdBjCKR0RZFj3XF7w9XnwthqgRzu2e96waAxQRzum7B7Qdrsg6EyBeL
zAF5wQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAAAALAAAAAAQABAAhgEAAAB8w3XF8Eeo3l225lKv4me86hhAiy6Z1W/B7RFRm1Kv42/B7gth
qQ6FyAllrhiLzCOS0C+Z1Ro9iA1cpQJ2vhZEjw9WoEao3hk+iDuh2QaAxjqg2i6Y1QVvtl225wVv
t1235w1bpGe96jqh2hVIklOv4me86wdqsw1bpRdFjkeo3wtgqSKR0COR0QF6wBdEjw9XoBiKzNjf
7Eao3xRIkjug2Tqh2RNMlxNNlhdBjCKR0RZFj3XF7w9XnwthqgRzu2e96waAxQRzum7B7Qdrsg6E
yBeLzAF5wQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAeNgACCABMZhYOIiAeLOomOFhYqMDyOiSUbG0I1lYg4Rg4OOZyDChAQRzIKjqqCFxE7Li0RMYgX
PogUHQi7EimCIhIUiQ0cGhw2Nw0/GiQsjg8DGAM0AwMrGA+VRQsmBQsF3iicIATlIR8EHpxAIwYG
QQYnQ5UVRAkM9/gVjkg9Av8ABbxIFKCgwYMBAAQCADs=
'''

gv_icon_action_divide = '''\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'''

gv_icon_action_join = '''\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'''

gv_icon_lightning = '''\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'''

gv_icon_burn = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAPrZTvvgaed1F/nSNPzqif3vjvvbNeVn
GP//u/jLG/jFBPzqivnQGuNdGP72sP74xPvdZ/nGAP75tPrNAP72r//7tfjBAPvcT/rQG+RbRfnR
NPjFAPjEBPjGAPnIBOdsEPa3AuZwFeqBH/jKG/zqs/e/BvrTSuhtEfzobv31wfnKAPviava2A/bJ
h+2KC+p9D+VsHeFPGeNWDuRfFtslFdwsHeJPFeNXH+FLCuZpGt8/Eeh0TeRlGN9CDONZC+VhEOBC
FORcNt8/HNsrD901F9ojDtwuE9spE9wwHOJMMdkeD+ZeVtkfENkbDNgYDtomGtolHeNHPwAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAeEgACCUk9RTIKIiYo1TUs2ipCCSElQTpGKGkcoN0aXiEpBEi07noJE
MCsUL0WeQ0AXHB4hPpdCMyYfHQsLP5c5DQ0kCgoZIDyQOAcHGwTNBCMykDQnGAHW1w6QMREsAt7e
KdmKOgYGBQwMBeo9kQgWExUPCQkIngMlECouIqUAA/8DIAUCADs=
'''

gv_icon_zoom_def = '''\
R0lGODlhEAAQAOZBAAAzmQBmzP///1o7AJlmAOazAMTz/9mmAEW5//nNT+W5ToPV/5TW/cyZAAyf
/7Dp/yOn/2jD/q3h/le8/sz3/5zg/7bt/73l/7Xs/2fH/4DT///bnZXb/97//2rK/wWb/8np/6zf
/1S//77x/73w/8Xv/1+//wmc/1jA/5Db/5LV/6rn/6Xb/zCt/33O/9X3/4LO/7jj/4PT/x+m/7nk
/3XP/3PJ/3bQ/6Tb/5Td/zCv/3fM/029/4za/6Pf/ZHc/6Pk/////wAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAEEALAAAAAAQABAAAAeYgEGCg4IBhgGEiUGGERETE4aKiwwxFyYtEDMQiIkBOCACLCcfDg6c
gwEMKiE0MDoIPAgIp5M7LjYoHgs9Cwu0ABIyGSI1OQ8kDz4AhMAcGjcpKwYdBgbLzBUVP0AYBhQU
14IEBAACAiUWIy/m4QQKGwUA5eYC8oPuCQUHA0Hy9vcK8h1owE9SEAICCRoUNECfwoUMBxSEGAgA
Ow==
'''

gv_icon_zoom_inc = '''\
R0lGODlhEAAQANUrAAAzmQBmzP///1o7AJlmALTi/+azANmmAMTz/8yZAJTW/fnNT+W5Tgyf/1e8
/q3h/sz3/4PV/2jD/pzg/0W5/yOn/97//77x/7bt/6Tb/7jj/3bQ/6Pf/cnp/wWb/8Xv/73l/4PT
/3fM/5Xb/5Hc/x+m///bnYDT/5LV/9X3/7Dp/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACsALAAAAAAQABAAAAZ9wJVw
KAwYA8TkyiiROBxG5VKhARUKlVIFmQxkOgIAwNNocIcBBeoqvlIo56lITAdEInHAI1QXqzgARHoj
JxtiCBYICIGCExMkhxAQjEIEBAACAh8YFymZlAQMJgZimZ+gDAsGBwMrdUShqgcJrVIrBLK0tkID
q7q7vAO1wEEAOw==
'''

gv_icon_zoom_dec = '''\
R0lGODlhEAAQANUzAAAzmQBmzP///1o7AJlmALTi/+azANmmAMTz/5TW/cyZAOW5TvnNT4PV/8z3
/1e8/gyf/yOn/5zg/63h/mjD/kW5/77x/6Pf/aTb///bnZXb/3bQ/5Hc/4PT/6Xb/zCt/5LV/4DT
/x+m/7bt/8Xv/73l/wmc/3fM/9X3/97//7jj/wWb/5Db/7Xs/6rn/1+//8np/6Pk/7Dp/////wAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADMALAAAAAAQABAAAAaAwJlw
KAwYA8TkzEihPB5G5TKhKr0+EVEEmQxgYAKPaQWBcIeBBKjAblcq5+kJQK83GnHApFOvyy4ARHoa
IRssLggpCAiBghISHDEtCA4OjUIEBAACAiQjFiiclwQLGQZ0nKKjCwwGBwMzfUSkrQcKsFIzBLW3
uUIDrr2+vwO4w0EAOw==
'''

gv_icon_binocular = '''\
R0lGODlhEAAQAOZdAP///3N/i8jO1mBncHV9hkZPWbXAy3WAi3+MmcvR14qXo8rQ1mt1f4aToMfN
0+Hm6sbN0+Ln64KPnCs2QnV/il5lbtDZ4WFqc/v//2Rsd2NrdMDGzU1WYCg0P19ncCo1QM3T2GZv
eCk0QO7w86m0vLK7w9je4pqlsGhxe295hMTL0Wt1geXo6nN8heTn6n2LmG13g2dxe6Stt8jO1IeU
oHB6hHF6g6GqtNDV2o2apoaTn+fr752nslZeZ1tjbN7j6LC5w1JaZN/k6cbN1HB7hVdgadvh5VVd
Zp2mscnO1IGPnKCqtZWirW94gZ6ps/Hz9622wGt0fU9YYVZfaKOtuFpia+bq7qKrtaCps1tjbWx3
g8nP1Vhhav///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAF0ALAAAAAAQABAAAAe8gF2Cg4SFgwGIhogBhAEAAIyHj5GCAQ4QlF2WmIMHAQYGmZ+hB4IH
j48UghSoAKVdWhsuPC8rOjQpSlgsGzBdNSCPJI8jJipQOY8LRAwLPydRHBxSQUc9TUhCMwwxCQ9O
JY9PRkNATDcRSSgZ3ks2U0VcVVk+LVcRWxkXOFZUBCGEQhCQsQPEhQENEEhQUEGDIA0VFEhA0GCA
BwECMFggMEDQAAIWMGD0UGBCBxEfChAq8EFEhwkqDckUFAgAOw==
'''

gv_icon_card_add = '''\
R0lGODlhEAAQAOZSAP///wBdAP//AABayPn7/cHK1M7W37O+yfX4+/j6/ABgyZnb/xij/wBeyABE
AP///KDh/2x2gvH1+L/J08/X33iBi2NtdwBIAMHK1Wlzf2ZwfG96hSg0QABJAABky6GqsmBpdPX3
+ie6IxytHiczPn6ChhimDheuESgzPwBcyu3y9yivGxuqD+vx9/v8/UlTXrG8xwBWxfL1+P///c7V
383V3vP4/ABCAP//+/T3+l1mcenv9Q6iDvL3/DK1G/P2+Ryo/+70+B2q/+7y9vb5+/b4+wBAAABd
zAOhEX2Bherw9+Xr8l9nci04Qy+6HQBiz1DVPuzx9v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAFIALAAAAAAQABAAAAe7gB4KDYQNCh5SiYqJChALjwsQCouLR0IMmAxAMQOdnilPSQA4DzMP
AKipqSUbAEU0FBQGs7Q1IQAbEQAyRAkJBMDBCT8AERkAEhMYGAXNzhMSABkaAEM5CNjYLqoAGhYA
UTAH4+MAAecBABYgADs9NkEqCagBAgLpADoAShUVLUvmzgkYgY4Jqg8fUtWzt0LEvRcoOEhpwoGE
OQFIeJhgcSIAJUUXjASA4iOAgw4fF9Vz4jHlogs3TiYKBAA7
'''

gv_icon_card_copy = '''\
R0lGODlhEAAQAOZgAP////b5+pnb/83V3QBayABgyfX4/ABSxhij/7bByuDf4aGqsig0QKDh///+
+19ocniBi////QBkywBeyCczPu7y90pUX2RveSgzP2dyfW54hPP2+evx9+7z97O/yBik/2t1geXr
8vX4+hyo/11nci04Qx2q/2Frdfb5+8zT3e/z+ABey+zw9GBreABYx+3y9uvw9wBdzPT2+e3n4+nw
93eBiwBTxOrv9ElTXgBTxwBiz19rdvT4/N7e4ABUxv/++V5ocyYyPX2BhvH1+vH1+QBfymNve+7z
+P///gBTyGRueO/z9/P3/ABOyABcyurw9QBUxQBRxXyAhfT4+wBWxe3x9fP1+ABUxPL2+fT3+/H0
+PD1+mVwe3B4fo2GfwBayv///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAGAALAAAAAAQABAAAAfWgGBgEgUThgUSgoqLBQ0Cjw0Fi5MrJggfCCNUBJycTjqCXgARSBEA
p6inQhJFXz42UFERAbQBIhsAGo2PAg0uMwrBCj0OACAxlpgjVzkHzgdJTQAZUgA/DsWpqF0AFxoA
MgEoKLW2uEYAJyAAWikD7/ApVgAtACQZAEtZBvwGU1hEOgDYAeDBBQAvPCRYmMBDhyosAHAJYuEE
gCdMeKioUOHIkC03ACgRRAIADQgQOIQIwQFCDRgAgAh6cGrBglQ2Tz0QhAMDAzAlGFCgwKAEGAYY
LAgKBAA7
'''

gv_icon_card_delete = '''\
R0lGODlhEAAQAOZOAP///8opAJMAAP/M/wBayM7W3/n7/cHK1ABeyP8pAP+DIJnb/wBgyf8zABij
//9MDP9sFPX4+/j6/LO+ycHK1aGqss/X32lzf2x2gig0QKDh/3iBi296hQBky7/J0////PH1+F9n
ci04Q11mcaarsOrw98DEyX6Chu3y9/n6/ODk6fv8/e7y9gBdzGNtd2ZwfByo/+70+ElTXvL1+Cgz
P/T3+s7V3/X3+vb4+/L3/Onv9eXr8uvx9wBWxf/+/gBcyvb5+7G8xx2q//P2+f///WBpdCczPv//
+32Bhfr7/c3V3uzx9vP4/ABiz////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAE4ALAAAAAAQABAAAAe/gB0MCIQIDB1OiYqJDBoLjwsaDIuLLUIOmA4wPQSdnj9NSABHH0Qf
AKipqSccADg2FhYFs7RKNwAcGAAzQBISBsDBEkMAGBcAIB4UFAfNzh4gABcvACw1EdgRK6hJKagm
LgBLQRPlKj4BAajpAEUAOjlMMSgAAQMD6fcBIwAlGxs8dgAQoEDBvYICQqCqUEGVAAgQIQgAIING
BiciMhghUe+BxwfqKCmyl6BBgwT4RCYSUFKAgJMCVK6M6cSlk0AAOw==
'''

gv_icon_card_edit = '''\
R0lGODlhEAAQAOZXAP///wBayM7W3/X4+wA0oZNfADGU4vn7/aXX9ABeyLO+ycHK1NH6/xij/wCd
/wBgyZnb//j6/CgzP/YkAAxszaarsP///F06AP/65wBky//LUsgVAMHK1XiBi6Dh//T3+qGqsl9n
cs/X336Chh2q/8UTAH2BhWNtdwBcyvL3/AZp0C04QwBdzM7V37G8x2BpdOXp7f/50F1mcb/J08TI
zQhpzP///Wx2gmlzfwBiz+Dk6evx9+zx9vb4++rw97zAxfb5+0pTXwBWxWZwfPH1+PL1+G96hf//
++nv9UlTXhyo/886Fc0yC+ru8Sg0QP39/vv8/fP4/O70+P/M/+7y9gNr1e3y9////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAFcALAAAAAAQABAAAAe+gBkPCYQJDxlXiYqJDx4QjxAeD4uLLCQNmA1KQgGdnig5JgBHFjYW
AKipqSNGAD0tIiICs7RNqDQ3AEVAEREHv79PAEwlADgARDMcHAvNCzAAFBNTS0MAVB8D2tpQ0QgA
ExsnADwuCucKOgA1CAwG4S8ASClRUlYRACrtBg4EADIAfHTosOMDgCr7+gH4EQIVCBCoCiT0ByBE
EglOrqyoAKCABn7+KkgIQqkjhhgaKFJSZPLCBVQrWUookIpSIAA7
'''

gv_icon_card_empty = '''\
R0lGODlhEAAQAOZMAP///7O+ycHK1ABayM7W3/X4+/n7/QBeyKGqshij/yg0QJnb/+Xr8iczPgBg
yXiBi+7y9/j6/O3y98HK1b/J06Dh/2lzfygzP/H1+GZwfM/X37G8x2BpdGx2gm96hWNtdwBky///
/Ovx9y04Q19ncl1mce70+H6ChvL1+fH1+u7y9v///erw9+zx9QBWxfL3/ABiz+nw9/D0+Ozx9s3V
3gBcyurv9PL1+Pb4+/D1+vb5++7z+H2BhUlTXvT4+///+/P2+R2q/87V3+3y9hyo//X3+kpTX+rw
9ABdzOnv9fP4/PT3+v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAEwALAAAAAAQABAAAAewgEyCg4SFhoeEIA4HjAcOIIgOFQuUCxUOiEhBCZwJRC4DoaI1MDwA
PyErIQCsra0nHgA4QhoaBLe4NEUAHh0ANzoREQbExRFAAB0WABgUExMC0dIUGAAWGQAqSwXc3T4o
MkMAGR8AMxsB6eobEC1HAB8cAEkvSiYSEhAQOyk5NgAcSgBg8eCBCAYIGYgoGANACRKsECBwFXEi
ABI9LihgMkJBg48NFIxgouCCEUSIAgEAOw==
'''

gv_icon_paste = '''\
R0lGODlhEAAQAOZuAP///5NgACs2Ql08AFJecZRgAObs8iIxRvP2+e/z92d1ievw9YCMmPr7/Pb4
+pSfq/3+/v/XCOi1AO7y996rAOjq/ys3QlNecdShAObr8erv9eOwAOHj/8uYANmmAO26AFFdcZVf
AJhlALC1yP/hl//TAP/nrv7HAJdeAOq0AEtVYOCpAP/JAJOSzP/aB//ed/rDAPP3+uy4APrEANKf
AIiWoVJgfsiVAPC5AGt2gP/WGFFcbdqkADtLapNfAOezAFFaYv/cAv/lhmNsd4+PyFxmc9GbANyp
AFJec//KAP/IAFVgbv/LAGdwe/S+AP3GAP/aSJ2evuWvAPL2+YaSn0tUXv/dZ/z9/pZiAF87AP/g
iOGuAP/XKOru8lNec32IlP/ZOH5UAPK+ADxNbGJqdff5+tekAP7IAMnP1W95hFZeZ//cWP7//1hi
cf///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAG4ALAAAAAAQABAAAAfRgG6CbgyFDIOIbiIFIQojAAAjCiEFIogFJiUKFRwcFQolJgWIASRn
YwepBz1KJD6kWmIzTydJTCwwQiikLzIfH042SCAgO0s1D4IBVj8SEjhekNItAMkBa1sbGykEABDf
AESQDwFQRxQUUt0N7GxRQGpfAWBmHh4r3Q76ZVddaFQBuNDAgIHHBQBTEChEEANAmgA6bnToYOTg
hAQYE0wAkAOLiwggg3TTsKDkAg0AmoQZwHJAljYAMhiYaSADgCGJ3BSRxhMAmZwqLAgYStRClUAA
Ow==
'''

gv_icon_revert = '''\
R0lGODlhEAAQALMAAABmzACZ/wAzmZTN//3//97//wBlzOX//4/Q/wBgygBVxQZrzQBhyv///wAA
AAAAACH5BAEAAA4ALAAAAAAQABAAgwBmzACZ/wAzmZTN//3//97//wBlzOX//4/Q/wBgygBVxQZr
zQBhyv///wAAAAAAAARG0MlJq704a8B55kMYCoIFHAMSrMFYMWjQFW05AYRqOwAd7LhfpfdbGBIK
QsDAtBFLuBALSHMSBqudBCDcKrU3LQCsKZspEQA7
'''

gv_icon_applyblue = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAACK3VSx42C56ABxvFWx4wCJ2i2Y002t
4ABpswBmrwB0wWS76QBiqgB1wk2s4Eao3gB8ywB5xwB4xj2i2h+PzhyFxR6T1xiU3BJ/wABuuABt
twBqtBmQ1RiLywB4xwBwvACD0wCA0ABtuABdowBxvReBwgB1wQ58vyGIxwCL3RKQ2iCa4RuW3RWR
2xWGyx6Y3x6X3gCAzyOX2SWU0B6Pzi6Y0zWd1yOb4GC45yWc4Sed4lu15kWn3SaU0QCG11u25Vq1
5gCD1ABgpgCG2Dad11u15TWe1yma2yaU0Dae1wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAeIgACCg4SEAQGFiQABKiyIioMGOwwMBpCCPzo5AwNElyE4QUZAPEKX
MgICBQUCIpARMQ8PCAgwEYMfEoMSED0QLRMTgg4LSA6CCxgUFBgngwQvRUozBAAgRzcuJYUbKTYH
FyMXByscigkWSTQdPhYJlwomFRU1CpeCDRkeGQ33gkMoNPgbROJSIAA7
'''

gv_icon_rotateclockwise = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAAByuQB5wABnrQBkqnXF8ABeowBxt1Wp
2wB1vCCPzgBqsAB6wAR3vABcoQBboABprwB4vwBjqQBorgBgpQB8w1Gm2V225wBip0eo3gButAaA
xQ6FyQZ/xQBlq2e86jee1xiLzABxuQBjqgBhpgBjqABkqQp6vjyZ0SKJxw1ytQB0uySAvQBmrABl
rABepABnrAButQBxtgBvtABrsQBssgBtswBprgB6wQB7whJ/wUSe1QBttAR3vUuj2AByuFGn2lKw
416352/B7W/C7me96m/C7QB2vBeLzA6FyBmExF235yCOzSCOziB+vQB3vTqg2SB6uABzuhdysxFx
syCMzCOR0SKS0CCKyS6Z1Uqj2Duh2gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAfEgACCggcJAgIJB4MAAoMHDAogBQUgCgyKh4IBOQiTCJ0FCAoRCBEA
MgIWQ00MAjgCTEBGFkRPAEc+RVUBPII2AQlaHx8JMywXWIqLKzsXQktSMShBPzWLASIB2tkaGRka
i+GDC1BbNOLiNylZAxDiEAMDMBMDKldOLuItSlYjAwAYdIQgQeAfgAEEJoRAgkGQBwMnkkR5YaDi
FA4cDHgYVMJBjw4bGjQA2YCAhHAEHkhYUKEClQUPTKADQICCAwcUCIQLBAA7
'''

gv_icon_splitedge = '''\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'''

gv_icon_squareedge = '''\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'''

gv_icon_rotateanticlockwise = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAAByuQB5wABnrQBkqnXF8ABeowBxt1Wp
2wB1vCCPzgBqsAB6wAR3vABcoQBboABprwB4vwBjqQBorgBgpQB8w1Gm2V225wBip0eo3gButAaA
xQ6FyQZ/xQBlq2e86jee1xiLzABxuQBjqgBhpgBjqABkqQp6vjyZ0SKJxw1ytQB0uySAvQBmrABl
rABepABnrAButQBxtgBvtABrsQBssgBtswBprgB6wQB7whJ/wUSe1QBttAR3vUuj2AByuFGn2lKw
416352/B7W/C7me96m/C7QB2vBeLzA6FyBmExF235yCOzSCOziB+vQB3vTqg2SB6uABzuhdysxFx
syCMzCOR0SKS0CCKyS6Z1Uqj2Duh2gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAfDgAIAgwAHCQICCQeEg4iFDAogBQUgCgyLgxEIEQoIkwieBQg5AYNP
RBZGQEwCOAIMTUMWAjIACR8fWgkBNoM8AVVFPkcAUktCFzsrjIVYFywzASIB1NOMNT9BKDHM3QAa
GRka3sw0W1ALEzADAxDdEANZKTcDI1ZKLd0uTlcqAwAYkISYQOAfgAEESITQgWGQBwMcOEwxQPFF
lCQnDHggJIFAgw0dGnzs0MNBCWYmHiygUqHCAgkPCJAjQMGBAwoyGQUCADs=
'''

gv_icon_action_add_multy = '''\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'''

gv_icon_action_check = '''\
R0lGODlhEAAQALMPAJy4ZKvoZrLtbcT8fqXjYMrumMj/gc3xnLnzc9Hzob/4edX2p9n5q+D9s937
sP///yH5BAEAAA8ALAAAAAAQABAAAAQ38MlJq704awrAloBheBowDA2JAYriqFMHIggDg4LQ5csN
JoFgIOGLHQiEQ5FTKCwrso90SpVEAAA7
'''

gv_icon_action_accept = gv_icon_action_check

gv_icon_action_multiaccept = '''\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'''

gv_icon_action_delete = '''\
R0lGODlhEAAQALMNALhkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/GcnPuwsP///wAA
AAAAACH5BAEAAA0ALAAAAAAQABAAAAQ+sMlJq704XwAo34bRNUA4eoogcKpyekwgB8xbAUVe2Dfi
I7wJgEBIJIhBwOGw4CyWPMBgMJJSN6+PZsvtViIAOw==
'''

gv_icon_action_delete_multy = '''\
R0lGODlhEAAQALMAALhkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/GcnPuwsP///wAA
AAAAACH5BAEAAA0ALAAAAAAQABAAg7hkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/Gc
nPuwsP///wAAAAAAAARWsMlJqwSAYtuAMVn3hZoiCNipkBoTvEGhcFdhr+x2IUjhgZdRh0BIrEwo
gApzOCw2ABeMkQEMBjmbjaS7AHg8VgVATCSI4kvzCVg001bs5Zru5Oo0SQQAOw==
'''

gv_icon_action_remove = '''\
R0lGODlhEAAQAJEDALhkZPanp/+Bgf///yH5BAEAAAMALAAAAAAQABAAAAIbnI+py+0PIwO02gSE
3hwgEITi6H3WKaXqyrYFADs=
'''

gv_icon_search = '''\
R0lGODlhEAAQAMQUAF2UuqqqqpjM85LE76HW+I+/7dz0/9ju/JTG8Kjf/OPj4/j4+Ozs7NHm+Nft
/Nrx/tHn+M/k99Pp+vn5+f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABQALAAAAAAQABAAAAVQICWOZFkCKGCeRmuoKwU8SZ088OkQfO/kI4BEQCxKgCJAY8BsNpCySGFK
jUBlEIQWAQEEYoCD+ABQML6rlHdhRsdEAfb5PYpP3PQAns6nhwAAOw==
'''

gv_icon_edit = '''\
R0lGODlhEAAQAMQSAF2UurBUVrq6uuDg4Hm67HOv5W+n3/ZZeIy55ZvX+ZnR9o+/6nOu5NxFU5TI
8I++6X/F9H5+fv///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABIALAAAAAAQABAAAAVCoCSOZGmeaBkEKRkcB9sCSdA08gk8DPPmJQDCQEQASYBFYbkAoAAOgtTh
PAkGAAVEUbUOsImu9YptSSKCtHnNbqNCADs=
'''

gv_icon_eye = '''\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'''

gv_icon_save = '''\
R0lGODlhEAAQAMQZAGONqVuNr66urvj4+P39/cLCwpDJ9/Pz8/T09ICHkpzJ8ZrH8KTR963d/aHO
9Z++0Kva/abU+anX+vv7+7W6wcLf9vX19Z3L89Pt/////wAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABkALAAAAAAQABAAAAVvYCaOZCkCASCsrACUAfYQNEFRxBOQQQMMwEEiMQA0dqIABIBoIoYIAASZ
CUgA2GxWQg1EDOBwONJlaM+MrgNQawMc3QtgUqjXJ4BLV/ELBgEKXQsAFnZ1FgALXRUAB46PBwAV
VCgqLSuVJpqbnCQhADs=
'''

gv_icon_player_forward = '''\
R0lGODlhEAAQAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/nD2EiH5BAkAAP8ALAAAAAAQABAA
AAixAP99GkiwYEGB+hIqXLhwID54ECNKhIhv4D12GDNqxHhvYD10IEOKBFlvIL1y5chcQ6kSJUp6
A+WFC+ehSS5vNXPNDCdvYLxu3UTIENJJqBBQQOMNRKdNm1AppJ6maopuoDlr1krMqdWsRJxeWK2Z
G0hu2rQzv5IlG5PW7DRyA8U9m0usrt25z8QN/Las76+/gPsu+zbQGzJkuxIrTnzY28BtkN1KngZ5
2yeBBjMP/BcQADs=
'''

gv_icon_player_play = '''\
R0lGODlhEAAQAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/nD2EiH5BAkAAP8ALAAAAAAQABAA
AAipAP99GkiwYEGB+hIqXLhwID54ECNKhIhv4D12GDNqxHhvYD10IEOKBFlvIL1yKMthSZYyJb2B
8sLJDOfhhp+ZMuUNjNetZzcRMmL0iOUz3kB02pJqAyrjiyyl6Aaas0bVWokpoIZVtWZuILlpYJNB
wZWsLNhp5AaKe8aWmNu3bJ+JG/htmd1fePPaXfZtoDdkyHYJHiwYsLeB2xKfXTwt8bZPAg1KHvgv
IAA7
'''

gv_icon_player_rewind = '''\
R0lGODlhEAAQAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/nD2EiH5BAkAAP8ALAAAAAAQABAA
AAivAP99GkiwYEGB+hIqXLhwID54ECNKhIhv4D12GDNqxHhvYD10IEOKBFlvIL1yKMtdM4NyJUp6
A+WFm3mryBBvNYfMlDcwXrduj2DIsMLoxdCf8Qai06btEY2hip5aYYpuoDlrWGEl4dIs1RIuWM0N
JDetbLJelZKdzVSW3EBxz+ISm0s37jNxA78t2/urr9+9y74N9IYM2a7DiA8X9jZwm+OykCE73vZJ
oMHLA/8FBAA7
'''

gv_icon_player_back = '''\
R0lGODlhEAAQAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEh
ISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0
NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdH
R0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpa
WltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1t
bW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CA
gIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOT
k5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaam
pqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5
ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f
3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy
8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/nD2EiH5BAkAAP8ALAAAAAAQABAA
AAipAP99GkiwYEGB+hIqXLhwID54ECNKhIhv4D12GDNqxHhvYD10IEOKBFlvIL1yKFMm05KyHL2B
8sLJlFnnxZCZ4eQNjNetJ6oYJGRY6dkz3kB02pJu+iFDaNKk6Aaas0bVWrA6PLhUtWZuILlpYJOJ
jcUoGdhp5AaKe8aWmNu3bJ+JG/htmd1fePPaXfZtoDdkyHYJHiwYsLeB2xKfXTwt8bZPAg1KHvgv
IAA7
'''

gv_icon_fullscr_quick_nav_left = '''\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==
'''

gv_icon_fullscr_quick_nav_right = '''\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==
'''

gv_icon_arrow_blue_back = '''\
R0lGODlhEAAQALMAAF2UunC48nfA97TY9n3G/Gmw7WKp6Ljc+bHU9IHL/6/S8v///wAAAAAAAAAA
AAAAACH5BAEAAAsALAAAAAAQABAAg12UunC48nfA97TY9n3G/Gmw7WKp6Ljc+bHU9IHL/6/S8v//
/wAAAAAAAAAAAAAAAAQwcMlJq704awD0BEnnAQTBnRcgrKwgUsARzHTwwkNRDPxwwwjDiZMBKH5F
pGfJbDojADs=
'''

gv_icon_arrow_blue_down = '''\
R0lGODlhEAAQALMAAF2UunC48n7I/XW+9nrD+mqy7oHL/6nZ+KDR9KTV9mWs6p3O8////wAAAAAA
AAAAACH5BAEAAAwALAAAAAAQABAAg12UunC48n7I/XW+9nrD+mqy7oHL/6nZ+KDR9KTV9mWs6p3O
8////wAAAAAAAAAAAAQxkMlJq704Y8C5ZoAhAh8gnKQGEGx6dUPcvUdg24dbAUnhJzoLAKFABF+L
4+bDbDotEQA7
'''

gv_icon_arrow_blue_next = '''\
R0lGODlhEAAQALMAAF2UunC48nfA97TY9n3G/Gmw7WKp6Ljc+bHU9IHL/6/S8v///wAAAAAAAAAA
AAAAACH5BAEAAAsALAAAAAAQABAAg12UunC48nfA97TY9n3G/Gmw7WKp6Ljc+bHU9IHL/6/S8v//
/wAAAAAAAAAAAAAAAAQwcMlJq704awA0BUmHcSRBiBYgrKyAfkEsB8crAUM+FMVg3ySAAfFLKYop
pGfJbDIjADs=
'''

gv_icon_arrow_blue_top = '''\
R0lGODlhEAAQALMAAF2UunrD+rrf+37I/Wqy7mWs6nW+9nC48rDT84HL/////wAAAAAAAAAAAAAA
AAAAACH5BAEAAAoALAAAAAAQABAAg12UunrD+rrf+37I/Wqy7mWs6nW+9nC48rDT84HL/////wAA
AAAAAAAAAAAAAAAAAAQwUMlJq704a6ApSFwHDGSIAUGamhUgCEb8shNgH7hNe0S/t4Xgz4MoDmu6
Y2fJzEQAADs=
'''

gv_icon_arrow_blue_ne = '''\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'''

gv_icon_arrow_blue_nw = '''\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'''

gv_icon_arrow_blue_se = '''\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'''

gv_icon_arrow_blue_sw = '''\
R0lGODlhEAAQAPcAAF2UunC48n7I/XW+9nrD+mqy7oHL/6nZ+KDR9KTV9mWs6p3O8////wAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAA0ALAAAAAAQABAA
h12UunC48n7I/XW+9nrD+mqy7oHL/6nZ+KDR9KTV9mWs6p3O8////wAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAhBABsIHEiwoMGDCBMqFAhg4UAABRoiBNAQYoGI
ExdYvIjRIIAFHC9K9LgApMiEH0t2zFiy5EiPFGO+dEizps2FAQEAOw==
'''

gv_icon_arrow_green_down = '''\
R0lGODlhEAAQALMAAJLNXpDEaZPNX4/NU5bUWJnXWpDNVIvFWXyuWmOPRf///////wAAAAAAAAAA
AAAAACH5BAEAAAoALAAAAAAQABAAg5LNXpDEaZPNX4/NU5bUWJnXWpDNVIvFWXyuWmOPRf//////
/wAAAAAAAAAAAAAAAAQkUMlJq704602TT1wyAOCWGKT2EcGXJUAhHOULILWac3zv/7wIADs=
'''

gv_icon_arrow_green_left = '''\
R0lGODlhEAAQALMAAJLNXpDEaZPNX4/NU5bUWJnXWpDNVIvFWXyuWmOPRf///////wAAAAAAAAAA
AAAAACH5BAEAAAoALAAAAAAQABAAg5LNXpDEaZPNX4/NU5bUWJnXWpDNVIvFWXyuWmOPRf//////
/wAAAAAAAAAAAAAAAAQnUMlJq704620Tl4nHJUAYZmRBGIN4JYgQAKWWHKaLnZ+i98CgsBIBADs=
'''

gv_icon_arrow_green_right = '''\
R0lGODlhEAAQALMAAJLNXpDEaZPNX4/NU5bUWJnXWpDNVIvFWXyuWmOPRf///////wAAAAAAAAAA
AAAAACH5BAEAAAoALAAAAAAQABAAg5LNXpDEaZPNX4/NU5bUWJnXWpDNVIvFWXyuWmOPRf//////
/wAAAAAAAAAAAAAAAAQmUMlJq704610Tn4mnhSEgYslgEIWZJQAQCMhpkclhv/v7/cDgLwIAOw==
'''

gv_icon_arrow_green_up = '''\
R0lGODlhEAAQALMAAJLNXpDEaZPNX4/NU5bUWJnXWpDNVIvFWXyuWmOPRf///////wAAAAAAAAAA
AAAAACH5BAEAAAoALAAAAAAQABAAg5LNXpDEaZPNX4/NU5bUWJnXWpDNVIvFWXyuWmOPRf//////
/wAAAAAAAAAAAAAAAAQjUMlJq704681zSl0CIKAmFsJRXl9CBK1pAKs30Fxbd3zvYxEAOw==
'''

gv_icon_darrow_red_back = '''\
R0lGODlhEAAQALMAALhkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/GcnPuwsP///wAA
AAAAACH5BAEAAA0ALAAAAAAQABAAg7hkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/Gc
nPuwsP///wAAAAAAAAQ8sMlJq714grov6NLnGSBAWoAgdOnKBQFBNAAsU0BSFHK+37hEjyYkgDSL
Ayt51AxKT4xI08RxMtisFhMBADs=
'''

gv_icon_darrow_red_down = '''\
R0lGODlhEAAQALMAALhkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/GcnPuwsP///wAA
AAAAACH5BAEAAA0ALAAAAAAQABAAg7hkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/Gc
nPuwsP///wAAAAAAAAQ3sMlJq70XaE3IBhYwHB0hGGC2EEUgpBiQtDDWyLV96x/QfaFR6ZSbAFat
F28WKIYSzoxuSrVEAAA7
'''

gv_icon_darrow_red_next = '''\
R0lGODlhEAAQALMAALhkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/GcnPuwsP///wAA
AAAAACH5BAEAAA0ALAAAAAAQABAAg7hkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/Gc
nPuwsP///wAAAAAAAAQ7sMlJq70WVI0Bl15nfMB4AYLAoapFEEGgvfEnvUWRALhu84RdAyikAA6L
FdIGGpCcpx9zwpxirthsNgIAOw==
'''

gv_icon_darrow_red_top = '''\
R0lGODlhEAAQALMAALhkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/GcnPuwsP///wAA
AAAAACH5BAEAAA0ALAAAAAAQABAAg7hkZPh5efx+fu6YmOhmZvNzc/+BgeNgYO1tbfOhof2zs/Gc
nPuwsP///wAAAAAAAAQ3sMlJq72YglxB2lzjFQGIAQtBCmY3HEQsGK0E3HeM1104eTzLqMRBqQKs
0ytGmPF2AB3OR81EAAA7
'''

gv_icon_arrow_state_blue_collapsed = '''\
R0lGODlhEAAQAPcAAAAAAABdlACIuwCVxwCVygCf1ACm3gCp4QCv6QAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAA
hwAAAABdlACIuwCVxwCVygCf1ACm3gCp4QCv6QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAhBAAEIHEiwoMGDCBMqXMgwYYAADQMgQABRYYAD
BgwcqHgwQIECBAh85EgwwICTAgScHEBS4MOXMFs2nEmzps2BAQEAOw==
'''

gv_icon_arrow_state_blue_expanded = '''\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'''

gv_icon_arrow_state_blue_left = '''\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'''

gv_icon_arrow_state_blue_right = '''\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'''

gv_icon_arrow_state_grey_collapsed = '''\
R0lGODlhEAAQAPcAAAAAAKCgoMjIyNTU1NXV1d/f3+jo6Ovr6/Hx8QAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAA
hwAAAKCgoMjIyNTU1NXV1d/f3+jo6Ovr6/Hx8QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAhBAAEIHEiwoMGDCBMqXMgwYYAADQMgQABRYYAD
BgwcqHgwQIECBAh85EgwwICTAgScHEBS4MOXMFs2nEmzps2BAQEAOw==
'''

gv_icon_arrow_state_grey_expanded = '''\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'''

gv_icon_arrow_state_grey_left = '''\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'''

gv_icon_arrow_state_grey_right = '''\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'''

gv_icon_bullet_black = '''\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'''

gv_icon_bullet_blue = '''\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'''

gv_icon_bullet_green = '''\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'''

gv_icon_bullet_yellow = '''\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'''

gv_icon_bullet_orange = '''\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'''

gv_icon_bullet_pink = '''\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'''

gv_icon_bullet_purple = '''\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'''

gv_icon_bullet_red = '''\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'''

gv_icon_bullet_white = '''\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'''

gv_icon_unfavorite = '''\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'''

gv_icon_favorite = '''\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'''

gv_icon_building = '''\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==
'''

gv_icon_house = '''\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'''

gv_icon_lorry = '''\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'''

gv_icon_world = '''\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'''

gv_icon_face0 = '''\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'''

gv_icon_face1 = '''\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'''

gv_icon_face2 = '''\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'''

gv_icon_face3 = '''\
R0lGODlhEAAQAPcAAAAAAAQDAQ8SEhEXGxMRCR8hISxQgi1ShjlWfztWezxfjz5fkT9KUz9Uc0FC
Q0FZeUVANUZggUdHP045HE5ablBxoFE7HVI7HVI7HlI9ElJxnVM7HVQ8HFQ+H1U8HFU8HVVAI1db
RVg/H1hthVpAIV5DI19FI2KCr2NGImVCGGaAlWdLJWhKI2pIHGtGGm5MIG9PKHBRK3FOK3FlXnRT
KndWLHlKEntXKXxYK3x2Z31aLn1cFX5LEYBcMoJkQ4RgM4hmGYplM4plNY1lMY2lv5BrPpRrNpZr
NJaejpdVCphnOJhyQJpuN5xxOZ5XCqByOaGFRaKGS6NxOaN6SKRzGaR1QaR4PaS626Z+SKeOQah9
Qql6O6pdBqp5K6+IUq+saLCKU7C3w7KJU7ZgBLaHIbbK57d2Nbd6MbiLQLlhBLmVZbzL576aa7+X
ZcBkBMSZT8iAGsmldcyTMM2mZM2mes6tRtCofNJqANJ/LNKGLtOfatTSeNWGE9W4i9mEEtmKFdug
LNy7hd26hd5vAt6DEt+0bN/AS+C8leFxAeGPFuG+meJ1BOJ3BeJ4COKEDOKEDuN4BuOGEePAl+R8
F+R9DOR+D+SACuSyN+WACuWEDuaFDeaOG+eOFOiOL+iPLOi+XumTHOmVHeqbJ+rmbOu8XuvOr+yg
OOygOe6rYe7Jou7Xnu7XoO7tdu/oavC2SvC3aPHRrPHTsfLVrvPLcfPQdfPUX/PdsPPhX/TnaPXF
OvXJPPXYYfXeX/XfX/bZkvbdsvbmZvb0cvb1dffbqvfdUvfnr/fosff1dvf7fPjybvj8fvj8f/nh
sfniVvn2dAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAA
hwAAAAQDAQ8SEhEXGxMRCR8hISxQgi1ShjlWfztWezxfjz5fkT9KUz9Uc0FCQ0FZeUVANUZggUdH
P045HE5ablBxoFE7HVI7HVI7HlI9ElJxnVM7HVQ8HFQ+H1U8HFU8HVVAI1dbRVg/H1hthVpAIV5D
I19FI2KCr2NGImVCGGaAlWdLJWhKI2pIHGtGGm5MIG9PKHBRK3FOK3FlXnRTKndWLHlKEntXKXxY
K3x2Z31aLn1cFX5LEYBcMoJkQ4RgM4hmGYplM4plNY1lMY2lv5BrPpRrNpZrNJaejpdVCphnOJhy
QJpuN5xxOZ5XCqByOaGFRaKGS6NxOaN6SKRzGaR1QaR4PaS626Z+SKeOQah9Qql6O6pdBqp5K6+I
Uq+saLCKU7C3w7KJU7ZgBLaHIbbK57d2Nbd6MbiLQLlhBLmVZbzL576aa7+XZcBkBMSZT8iAGsml
dcyTMM2mZM2mes6tRtCofNJqANJ/LNKGLtOfatTSeNWGE9W4i9mEEtmKFdugLNy7hd26hd5vAt6D
Et+0bN/AS+C8leFxAeGPFuG+meJ1BOJ3BeJ4COKEDOKEDuN4BuOGEePAl+R8F+R9DOR+D+SACuSy
N+WACuWEDuaFDeaOG+eOFOiOL+iPLOi+XumTHOmVHeqbJ+rmbOu8XuvOr+ygOOygOe6rYe7Jou7X
nu7XoO7tdu/oavC2SvC3aPHRrPHTsfLVrvPLcfPQdfPUX/PdsPPhX/TnaPXFOvXJPPXYYfXeX/Xf
X/bZkvbdsvbmZvb0cvb1dffbqvfdUvfnr/fosff1dvf7fPjybvj8fvj8f/nhsfniVvn2dAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAj+AAEIBCDFyhYtWrZYkTKwIRgvglQVM7YqEBYm
DQGI6fNrVi1evXbRssXmyMAncYa5ygLsmDBcIT4xUxMEQJMpsE4BIjBqmbJgApD4klWkhxE7qEJl
CNAK2TJWAwqQekVHxxBFnkRBkHArmbM9DBzIMSXphpBSlEBFUWGIWLMvRMJE2BSLxo9DjSLlGHEp
l646CspoOJMKBo42k2aceEBlBxAyUA4gyKOHRY0lZhasSYBmTqE3XeAQ6lSlhIwYPipcoeCHz59E
nDJVwmMCBIAVLxoYUIJJ0yNHliANctFhIIoWXO4gWsRoESI3KT5kJCHCRpIxaZzw2GAho8AJFzgJ
YMDg4cKEhgEBADs=
'''

gv_icon_face4 = '''\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'''

gv_icon_player2_frewind = '''\
R0lGODlhEAAQANU9AEJCpmZmzP///6io/zk5c7i4/9fX/1tbwMzM/3V12I+P+mJiyXd33Zub/ZeX
94mJ6oiI6G1t0mpq0K6u/25u1Hp64JaW85qa/3t74JOT+pSU/VdXu3x84m5u0nh43mlpy4yM82Vl
yYmJ8FdXvF1dwnJy2FhYvI+P9YOD64GB4mtry2xsy3d323V1221t03Z23FFRtpSU+mVlzIKC6XR0
3HBw1qam/4SE6qGh/m1t1FVVuomJ72Vly////wAAAAAAACH5BAEAAD0ALAAAAAAQABAAAAaYwJ5Q
GCgah8he0cBsFpMBBAKnqCos0sAwUGh8AKtLDISCQApaZRcgANhCAMAhhVY7NGyAit2mJdBcDhl5
fHIvf0UFIid5Am0kHC05gAU3O41tBx4lEoADDzOEjgAbLgkDRZ8VeQeFMqdaBAMYeQwjcTAREwRC
siwmADo1FBI8HREDvL0DAwwLzwsMzMpDBLLM2NZJ1dbdSUEAOw==
'''

gv_icon_player2_fforward = '''\
R0lGODlhEAAQANU8AEJCpmZmzP///6io/zk5c7i4/9fX/8zM/2JiyY+P+nV12G1t0nd323V125SU
+peX93d33YmJ6pub/WVlyVhYvXBw1l5ew25u1Xt74G1t1GJix21t042N82try3Z23JaW84+P9Wpq
0ISE6nJy2K6u/4mJ75aW/HR03KGh/21ty4mJ8GBgxlpav1RUuJSU/amp/1JSt5OT+oiI6GVlzF9f
wYKC6WZmy5qa/6Gh/np64IGB4m5u1P///wAAAAAAAAAAACH5BAEAADwALAAAAAAQABAAAAaYQJ5Q
GCgah0he0cBsFpOBwwGXqCY+0sAwUJCgXoObYwWgyQpaZTcFAHRMAAFAh1Y/XHH5JA44KdBcDzE2
eW1yHn9FBSogDnsCcnINGYAFIiUcGoVyIyGAAxE1FoV8GwoDRaA5hSx8M6daBAMYFG0UDXwLJARC
sgwMFxUVOzAALQsDvL0DAxAIzwgQzMpDBLLM2NZJ1dbdSUEAOw==
'''

gv_icon_email = '''\
R0lGODlhEAAMAKIAAM/Pz7Ozs//////UBgAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAQAAwAAAM0
SLrcOzBKuASZkwQlLKbARnReBoQceUUEIKBjNzLWK8pkbsG1nmuLk3AoXASOyGTSwWQkAAA7
'''

gv_icon_email_red = '''\
R0lGODlhEgAMANUAAMRGAP+NTv/BoP+jcf+OUP+bZP+qe/9+OP+SVvlYAOdSAP9sG8yJc/9dBf9y
Jf90J/+HRv+3j9tOAP96Mf+DQP9xI+9VAP+yh/9mE/+7lf/EpP+JSP+nd/9iDddNAP9qGf+eaelT
AP9kD/9aAOtUAP+FQv+LTNVMALRAALA/AP9cA+1UAM1JAPNWANFLAP+XXvFWAN9PAP+cZvVXAMxI
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAaNQAZg
SCwaAUKXTMBsOpkv2lCCsgQI2Cw2EEpJhg3RacQxmM+cGUvUGGIeDkXiEqlHLrCY44EZVg6AJC0Z
GhoZJAqABxVDExAQHx4qFkwKIx4fjxNDFAgLCiUIDyshDwglCgsIFEMmCwkIBbIODrIFCAkLJmAd
IAO/wMEgHW0ACRsBycrLyRsJSEfRRAxBADs=
'''

gv_icon_email_green = '''\
R0lGODlhEgAMANUAAP//////AP8A//8AAAD//wD/AAAA/wAAAMnX1kl7SnjJelGIU1mUWlWOVlSM
VVGHU0+EUE6CT0l6SlqVW0+DUE6BT6LupK/3sURzRHXEdmqyamChYFGIUYPahILZg4DVgXXDdnC7
cG22bmqxammvaWiuaFyZXE+ET0NwQzxkPDphOnzNfXvMfHXCdnO/dG+4b221bmerZ2SmZGCfYE2A
TUd2R0RxREFrQdjY2AAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADgALAAAAAASAAwAAAaNQMRt
SCwab0IMyMJsOpku1FCSgohe2CxWVFFJho1JzcFamc+shW3SGE42Mxrn46l7PqfEbDMZzmKAEQ8d
FxcdETSAMTNDMiMjJjUNEEw0DjUmjzJDJSEmNCQhGxQVGyEkNCYhJUMwJhwhLbIzM7ItIRwmMGAM
GQq/wMEZDG03HBoiycrLyRocSEfRRAhBADs=
'''

gv_icon_chem = '''\
R0lGODlhEAAQAOZPAABmzGrO////AN/9/6njOwBax/r//wBfxwCZ//7//53YAACYAISRnYqWoouX
o4WSngAnpcDqEmbNMAAppSguNWPMMCkvNafbOgAspAAkpS2rAAApoSSnAHTIAN79/zW3AGvEAMnq
ANT2AABcyQAkpPf8ALPvFBCfAFzGAK7mAP//m2bNMky3ANvwOgBfyQBg1v//eCUqMv///yIpMozY
JmBrdJvXBeH//4LVAASbAP//W///TXzdMuT0YAAmogAmpV9pc0GzAP/+//3/AD+yAAAqpdv0DF2/
AP//qej//8jqAABi1hSpAAAlpfH6iP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAE8ALAAAAAAQABAAAAeMgE+Cgg0PDAwPDYOLgw4JBgYJDoyMQBQzMRY1lIwvSQFLnIwjNwEu
oosFHgEHqIMFA6yuTwADMgEIAK61Qri6ogBIKjA7AgK/lAAETj0XQTnIiwAVBDotNkcaC9GCABIR
AkoKIEQn3AArNEYlIQodLBzb0jwmQwIiKTgoH0zcGz4kMjT5AWFCEQyDAgEAOw==
'''

gv_icon_doc = '''\
R0lGODlhEAAQALMAAP8A/8mDIP/35P/go//iqv/rwf/w0f/lsf/z2P/uyf/ouf/13//56P/env70
3QAAACH5BAEAAAAALAAAAAAQABAAAARZEMhJ6ww43EwD+0wGhlIgnKiJnlqwvHDgwG+L3HiA50Bg
/EAf8NdKGI+BI7JXaDoDzmdPQa0GqtbeYcsNcLs9gngcGJN7g7Q6oF73GpkAHJ6BlzqYjmVfiQAA
Ow==
'''

gv_icon_female = '''\
R0lGODlhEAAQANUAAP8A/+KC0daXPf///KNgAL95AP+63v+w2f+x2v/P6bZxAP/++f+23P/C4v/4
5//Tf//77v/lsqViAOSzav/W7P+53bp1AP+z2qllAP/u9f/txuu6auvDhevCgv/H5fXgvf/Yjf/d
m+uQ07FsAP/F5P/y1P/j8//b761oAOu+eP/vzf/////foAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAAAAadQIAQ
UCgaC8MkwCJoOgUWJUChmHwWg8VnQlWOBBzIYDWAcAQjJUrQcWAXjo4ApcQIUiUHxFFKCTBKEgIb
ERoqGhEbAhJKBAQCICEsISACjo2OAg+blpdJAR4UJgOkJhQeAZ8MDQknpAMnCQ0MqUIBCAYkCa8J
JAYItQABBxcGDRkDGQ0GFwfBASIHCAwVBhUMCAciwcIB3t/gUuJSQQA7
'''

gv_icon_group = '''\
R0lGODlhEAAQAMQAAP8A/9aXPTaa/6Da/2K1SJ3fVv/jrP/Tf7Xqhf/35Lbl/+u1XsDq/7/umf//
/+X8/+b+5Gq5/6Pc/9j5yt2pXtykUaHhXf/WhuvLnP/99tf2///qvvrz6H/JTwAAAAAAACH5BAEA
AAAALAAAAAAQABAAAAVzICAGZCCe6FhhHGWmaGAkWfLC42Vsxo0Hi8NhYSr5AARjcuVwnQgNiAPS
KMhoNhGhgJhAJgirjvfaWhANhMUaHJY7hbhcYBQ8CXi8YMB4OB4MdjB7AwoaDxoKA4IohBIKDAoS
i4MRA5eYEYyNAp2emzgwIQA7
'''

gv_icon_male = '''\
R0lGODlhEAAQANUAAP8A/9aXPTaa///Tf8Xt/6je/7Di///lstn3///45//txrXk/1at///dm//+
+aPb///clurJlbHj/6bd/9u/i7vo/6Hb/////P/Yjbjm/6fd/9Dy/6zg/9Lz/83x///y1KDa/8Ps
/9/5/7/q///vzevMntujVP/foP/77rbl/+S7gKnf/9T0/+H6/+W8gQAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAAAAaNQIBQ
GCgWh8ih0VU6JomBiMp0iTiTAUXCcXEkFIEnIHD4JFCJzyH8DEAOCpLiAGFjB5jGqYEZ2O8DgX5i
AAIIFEYUCAJPAgQbCCItIggbBIxDAgYVBB4dLB0eBBUGmIUFBhkjIQQhIxkGBaYCFhocEgspCxIc
GhazDCAPEwUrBRMPIAymhQLOz9CE0kJBADs=
'''

gv_icon_tag = '''\
R0lGODlhEAAQANUAAP8A/+CfIf/fTv/nhf/fSf/gVP/jY//ka//hW//ldP/1mv/mfP//q+CgIv/p
jv/+qf/xgP/ra//ynu/OUe/CTf//k//6gf/oYv/rZf//mP/whv/sYP/+s///of/3cf/qav/nW///
qgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAAAAZoQIBw
KAwYjcQkIMAJdTKVgLL4cAwoiUNEmgwwFINGoGFAcIdesEYcwBTOy+9gAbFMPBvBOT3Pfi4gAgRc
AQ9gC1llBYKEEoeJCIuDaFaIB4qMRAF9l5GZXZCScJqYk1NFoqeaSKqtSUEAOw==
'''

gv_icon_app = '''\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'''

gv_icon_download = '''\
R0lGODlhEAAQALMMAJy4ZMj/gbLtbb/4eavoZrnzc8T8ftX0s9n2ttLxsKXjYNDvrf///wAAAAAA
AAAAACH5BAEAAAwALAAAAAAQABAAAAQ3kMlJqwUY2wqCBxsFGCQYSsCgmltWvFmLCDSNsNxB7Ad+
JYqEr7UYhoyijNLY8TgDzGXsRK1WIgA7
'''

gv_icon_upload = '''\
R0lGODlhEAAQALMAAJy4ZMj/gbLtbb/4eavoZrnzc8T8ftX0s9n2ttLxsKXjYNDvrf///wAAAAAA
AAAAACH5BAEAAA0ALAAAAAAQABAAg5y4ZMj/gbLtbb/4eavoZrnzc8T8ftX0s9n2ttLxsKXjYNDv
rf///wAAAAAAAAAAAAQ3sMlJawU4Z9tA+GAAcFrJUeN5LanaJUrSkgdhHzOKCDyP5JJMYbg5AQZI
4MXAVKJAzonJRa1OIgA7
'''

gv_icon_wallet = '''\
R0lGODlhEAAQAOZUAJFdAP/bB1o6AJFeAMqXAP3JAP/jmvfEANShAJNfAO26AOi1ANmmAN6rAPK/
AMyZAOOwAJVhAH1TAP3IAP3KAP/dAP/fBtajAFEyAMeTANyoAP//AP/ijP//6//jmf/pm9qnAP/Z
E//bAPG+APzJAHdNAIxYAOKvALB8APPAAItXAOm2AFExAP/jI5djAP/ZANqlANKoKnxTAJNeAJdk
ANOpKuy4AP/eZP/hAPjFAP/fcpxoAP/YAPC9AOGtAPbCAP/nheazAFY2ANGdANqmAP/TAP/bL//n
APG9AP/hgP/eWO67ANCcAP/PAK97AJtoAP/dSv/cPP/bIc2vAP///wAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAFQALAAAAAAQABAAAAe0gFSCg4SFggkAiYqLAAmHHx4GkpOTHh+OABwTBZydnRMcAFQAST8H
p6g5JBQUQI4DOkgOs7MpPQ+4uDQDNzYKv78jO1MdHRsbMwNKQQvNzUsqRzUxIjgAA1A+ENvbKyYv
KE5NRQMDURoN6eknT0wVIjwVEQNGFwz39yAgJRgYLEIyBkgZgqCgwQtENMBo4YLKgBAZCEicODFD
iAFUIlgIwLGjxwAWIgiSIKCkyZMCJBhaWSgQADs=
'''

gv_icon_triangular = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAMGPKPjEBcqYIffsivrSLP/7nPjDAPXg
af7zhfzfUOayDfnHD/jIDs6bHsqYItOgG/vZPvnMHNypFPnNHPjHD9KgG92pFPHAEeKuEPXBAfLJ
K/7yhvzmZPG9CfXbWfXaWfjID/3yhcaUJPTPOvK9BPLEHPbBAtekF+u2Cvfpgv73kuu2Cf74kvXU
Sv3tdcuYIfPOOvbkdu+6B+GuEdikGOKtEPO+BP/4k/XVSvnHDvnID8SRJu+7B/zmY86bH/3sddil
F/zgUfnIDv7sddikF/jHDsqXIv3mY8+bHvPKK8eUJMSRJ/vYPQAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAeNgACCg4SFB4WIgweHiYUnBBqNhCUEBjeSgjOVBj2YKSo4LSsskgsy
IgkcCQuNNAhECBlALzaJEyAdHxcTPkgXiDUuCjlBACgKQkWFEDFNJBCCFhERFoRJSgUbDoMOBQU/
g0cmEhQD5g8wA+QPgiMYOwwMQw06RhUhFQ1LAEweAv8AA/7jEaCgwYMIAwQCADs=
'''

gv_icon_calc = '''\
R0lGODlhEAAQAOZrAP//AP///5SWroSRn7C4vqeutQA0AIKPnC46RdDZ4mdvebbCzKSssn+NmlrI
N/Dy/wCVAKmxuKCor666xS45RABZAHR9iQAyAGRtdwCSAIiPoG7QNy05RIqPo8jR2gCUAJOVrWVs
doiMoIKQnW13gJ6mrW13gjA8RwA2AHaBjI2UpkpUX4iQoWNrdGFpcrbCzWpzfX+HloqWo6evtcvd
6enr+Mrb6P8XAL7+qm14g3zsWAAzAACRAOjq93PLd+Tv/IGOm3WqfOb1/1jGNXiOnQBVAMHV4gCT
AHSCjleDZXfNfI2Xq3V/iuvv+X+Wpv90Pf/g//8VAIHjSqf/jWvZSOv3//9xOo+WqXSCj8b7pVmF
Z23SM253gm3PNmPQOGt/jv91PqWts26EkwBXAJT2XX2Klnusg4aRnXF7hqX/bdz8xf///wAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAGsALAAAAAAQABAAAAfQgGsyKiAChocCICoya40sPjwZGUcfEJYfSiyNaxpBallpZFJdGxtb
ZhqbHUU4UzpUQw6yXmMdmyIVALq7uxUimzFJFwYoBjvEBhdaMZspTT0PVw81D0tVP0JYm0xAAQ1n
Dd5OUVA3YptoYSUMZQzrRE9WYF+bXAkeCSn3CUg2RjQ5NpEYEeCAhQMFDwYYQWITjBkSCpgoEHGi
hBkwNil4MWGBggUdP054oWAThgEBBrRAqZIlhk0hCEQg4EImTZshNq3gQAHBCQQ9f1LgsKJRIAA7
'''

gv_icon_clock2 = '''\
R0lGODlhEAAQAEQAACH5BAEAAAAALAAAAAAQABAApAEAAP///waCyaLY9svr/PD5/7Pg+Kfb9iiV
07bh+KDZ91+46Umr4Uyv5U6q3QWAxtjt+dvv+pnP7ZfR8YvM8CuV0kem22S1443M7gAAAAAAAAAA
AAAAAAAAAAAAAAAAAAV3ICCKS2mOKNA0WBQEEbamjfveb9SMDIQLuACEIWIEgUEiQ3IMBiQMBKRA
pQqqVQgCQeh6Bd7wNkEuC85o8nZiaBsE7vhk6zjYBfZ83oEACAYDf4CDgwIiAheEigMXhocWFAqS
kxQWjiMCDxUOnA4VD5cpoGgPKSEAOw==
'''

gv_icon_puzzle = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAABkN06uMGu5KkOqMheaOzmmNCafOHO8
KGK1LACSPwB0On/AJgCQPgCQPwBmOFiyLi+jNi+jN1myLkSqMgBpOABsOB6cOQCBPGK2LGu4KnO7
KQCGPQCPPjmnNB6cOiagOGK1K3q+Jx6dOh2dOiWgOASHPC+iNwCJPi+iNjCjNjinNACKPQCNP0Or
MgCNPgCPP02uLwR0OU6tMAB5OgB9O1iyLU6uL1ixLgB+OwCCPQCCPGu5KwBxOQB1OgB4O3O7KHO8
KXS8KQBtOQBwOQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAetgACCgwoKg4eIAAoMDIaJiIuNjw4wDZYdIiINDh0ODoMvCEFACKUI
QhsIGy2DKAOvGq8DGjyvLIMcIQkJGbq7vBkcgzsYJhMQOBDKEzYTOhgYhzkCMwLW1wI3MTWDPwQu
FBQE4+PiNAvoBgYrBh4e6gY+6ABEEikRJyoSEfv7PYMWQJQ4cMDCEIIgCFoYVGEEiQ8VBMn4cKFi
REEPCmh8gFHjxkEBQoYUJFLkoEAAOw==
'''

gv_icon_piechart = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAACSPwBan9olHTapaF+041y5hO6TjxiK
y3jD7PW4t0awdAB8wwyXSHfD7Ol5dul6dTuf2OFNRwBjqQBvtVO1feVjXhmdUyyMyEWc0Vin1w+Y
ShKaTV+05BJ+wDug1zyf1yyNyQBqsBJ9wBCZTGC05HfC7BKaThyeVSeiXSejXBOaTQSUQ1+14xye
VCajXOyFgu6Rje6TkPOpp/Kpp/Kqp0awc0OucSylYDGmY1K1fUavcxiLyxmKy+RjXjyg1zug2BiK
zOVjXeVkXul6duZqZeh1ceJRTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAengACCggEBAAOIg4oAhYWHRRKJioU5BoYDCgoxkowBNwaWhzU0MzCS
ATg6FRWXB64yRgOMKws2OwuXDxBEEA+RARsEwgSXPkIWFkNHAwEuLykqKJeI1IgBHBcXJ4aLkywk
DdwC4+TkheGCAhoJJgkODgkiAp3pGR0FLQUFJQXzjOkhIkT4AeQDCAzjFAnwgIBHEAQ9EIxIqFDA
BAoMGFCYQLFbuY6CAgEAOw==
'''

gv_icon_cart = '''\
R0lGODlhEAAQAMQAAP8A/5GRkeCfIf///+/v7/z8/Pj4+PT09P/fSf/ka9/f3//5gOXl5f//tv//
yf/eRerq6v/qluLi4tPT0wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
AAAALAAAAAAQABAAAAVhIBAEQGmeZjAMY+u25bjO9EzGbK7u7BkUhZ8wGEQFDMckEokSHQ4BqPTm
I1ivhAk1BoG8RkYGY9sUmCUvs8AkcDQWAoVc0X6vAYJIAiFw5fd3AnsPdyWCCIRsZmWLTY4nIQA7
'''

gv_icon_cut = '''\
R0lGODlhEAAQALMKAF9ncGRsdwBjAACZAJafqABGAMLL1MzU2wCbACg0P////wAAAAAAAAAAAAAA
AAAAACH5BAEAAAoALAAAAAAQABAAAARFUEkg67QVUKvxPJsCgN4UdqVoUMCaTkRAhCkQz2+G5kGg
9LmfD/hKAHuJ1AAhqAgQA09U0ZRUp05rloqpVrlgS6GAGVsiADs=
'''

gv_icon_announcement = '''\
R0lGODlhEAAQANU4AJlmAISPnP///10+AP+0Jv//AP/mcv+aM//BH/+1H//zk//0Lf3+/pCcqP+f
My45RKOtt//nEP/tBk5WYFpibF1lbpGeqtDW2v/HHP+zIv/4j//kDf/qbv+4Dv+lG/L1+f/ndP+5
KFdgaVhgaf+zHFlha/+kKf+pKWBncP+sKfP19f+kMv/PHZ2nssjO0/3///+mJ/+YNP//If/vdi46
Rf//AklTXf/yjf///wAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADgALAAAAAAQABAAAAZxQJxw
OAQAiEgiQHBMIpeaplO4vM2kxIA2IFCAFlhhSSDgKgwL2dE4FL0+AY6hUKiFcSOGKkCXbCJ3FBcu
ASQICBgsdxUQLQEeBwcpIXcoFg0BHQkmMStrWDYPNBMECTAOd0gDBBknqaoEBK+ws6oDSEEAOw==
'''

gv_icon_conversation = '''\
R0lGODlhEAAQAFUAACH5BAEAAAAALAAAAAAQABAApQEAAP///wB8w8rp+crp+uDy/ABmrKLY9QBa
n9/y/LTg9/L6/fP6/rTg+PL5/oK+4gBmqwBrsd/y++Hz/LXg9wB1vJXT9ABwt+Dy+/L6/rXh9wBc
ogB5wABlrABhpvP5/gBhpwBdogBwtvP5/QB5vwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAaIQIBg
SCwCjkfBJMBsMicCpNBJDUSRnMXiw2A4Mo7FiCStSBKFBKbATkgq0suAMJjTCXQRERB5NDQKDQoU
FAoPEU9REAeMHQaPEBBOVx4WIAAIXw5dH1ocSBshmGwFGGhucEgImHd0cwMXUkcID4WCGg2HskeP
Bh2MBxC7uyAWHsO7IRvIu6tIQQA7
'''

gv_icon_telephone = '''\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==
'''

gv_icon_table = '''\
R0lGODlhEAAQAOYAAP///yczPoGOmxglMfz9/r/J09j8/8zV3fT4+wAXigBPwgBRxAAZisPN1gBP
xMTO2HOBjWd0gL7I0tDY4QAWiXiFksLM1XN/i11ndIOQnHaBjmVwem54hACU/2t1gYiVoVtmcABX
yLzG0AAbixonM3+MmcrT3WhyfhckMHB8iACb/1xmcWNtd214hl9ncs/X32BpdCgzP8HL1eXq6mVw
e3yIlMfQ2dHa43iEkQAYigBTxfP3+/39/svV3TU/TDQ/S9D5/wA3rPr7/ABQwhglMklTXq/o/wBU
xfD1+Nr8/7Dp/4SOltH6//H1+f7+/vn7/ISNlkpTXwA2qgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAQABAAAAfIgB8ZAoSFhoQZHyUAjI2OjiU1AA46Qx0KCwqXC0cOADU4ACFKSSoG
QAamTEYhADgaAFIMOSMJFAm1FAxBABoXAEuMM43DjFAAFykAFYwTjc6MzCkcABA3PS8HJgfZJjcQ
ABweAC2MNgBOAOc85AAeJwARAAQNBEL0BE/xACcbADQPClgoIEEgwQc0AGxgAQADgB0iEDRBEBFJ
QwAsYAAAwUhGI4+MOMJYAeAHkQEkBqBAqXKADwArXDya2chFkRgBcurcmTNGlEAAOw==
'''

gv_icon_file = '''\
R0lGODlhEAAQANU8AP///ys2Qvb4+uvw9e3y9vH1+Onu9O/z9+Xs8vT2+fr7/Pj5+4SQnfz9/f7+
/pSfq2Bpc/D1+GBoc+jt8+rv9eXr8fP2+XB7h3J+imt1gGhyfWNsd+7y9ys3Quzx9kpUX214hGZv
elRcZnaBjYSRnfH09tPY3oSRnomVofn6+4CKlnmEkI+PyI6Ox5KRy/j6/J2evn6KlnuHk4GOmoiU
n/f5+/7///3+/7jBx1dfaFBZYYiUof///wAAAAAAAAAAACH5BAEAADwALAAAAAAQABAAAAahQB7q
xCgaSbQHb7mcAZ7QpwugZMYAjqwW0HpWeTJAY0wGsKDVFUDBbttgOlFOtRwBFvh86lYy4XZLGAAC
hIWENS8AGEsXABYJkJGQFgAXSyAAEQWbnJsRACBLGQAcB6anphwAGUsaAB4EsbKxHgAaSyEAFAO8
vbwUACFLGwATBsfIxxMAG0sQABUI0tPSFQAQSxJR21ASSx8dAeLj5B0fPEEAOw==
'''

gv_icon_files = '''\
R0lGODlhEAAQANU4AP///ys2QvP2+e/z95Sfq/3+/vb4+ubs8uvw9YKPnPr7/GJqdSs3Qu7y9+br
8UtUXurv9WNsd4OQnYCMmIOQnIiUoWdwe3uHkvP3+v7//4+PyOru8lFaYp2evmt2gJKRy8nP1XeC
jvz9/lZeZ/f5+nWBjHF8hnJ9h4eTnm96hfP3+4SRnGdxe/L2+e7z93J+iSg0QG95hIGOm/f6/X2I
lG55g+zx94aSn////wAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADgALAAAAAAQABAAAAaUQJxw
WJEkjhQUYcjETQBQ6AewbOIugIIWoIFWmSGAYpzpcEY06wlgaJNEG9CteExQVoSZYC/AAGJPUQBT
BCoDhw0AHlhaBVxeLggIEAAWYWMKZWclNgcHDgARL2xucCAyggALKQAtfH0AJjABtAwPHgANh4gA
NVYWABCSkpQsVhEADp6eoBFWC6lRC1YPDLTXAbZWQQA7
'''

gv_icon_folder = '''\
R0lGODlhEAAQAOZAAP/MAJNgAF06AP//AP/UAP/lAP/////JAJViAOy5AJRhAOazANShAJRgAMCK
AJZiAM6bAP3KAKBqAP/KAP/SAH5UAMuXAP/RANCqPf/rjJxmANiwOv/IAP/PAMOOAP/LAP/YRc2a
AF08AP/tkv/gcv/aAP/UG55oAM2ZAOu4AOSxAP/ilZNfAP/WANGdAJZgAL+KAJhlANejAP/XO+m2
ANOgAP/mAP/eX//sAP/WK//nrvC9AP3JAP/RCP/gg5ReAP///wAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAEAALAAAAAAQABAAAAePgECCg4SFhoeGDQ0KjAqIQA06PBERAAABCJmZMYIBKyoLoTQpCaUJ
OwidPi4MrTUyMA6yHg+dJBYQECEoGwa+vj+dNxoSEicYIxwHyx0BnSC/BhkTlpYUzkABM8vL1NUA
1505H9/lF9gBJgTr7O0l6D02BfP09Dgsgg8tA/z9/gMvBFUQIaCgwYMCKjxCFAgAOw==
'''

gv_icon_horizontal_chart = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAABan0Wn3gCSP9olHX/AJvO4tgB8w3DC
7iiV0h6Pz+2Wk2m4Kkip3xaaOzemNDemNUisMeFOR1Kv4hSIyg2DyAWAxTOb1uVlYGS66Wu/7Ol+
evGqp1mzLnW9KFu15t06Mlu151Kw41y15mS66kip3mu+7AmWPWO66Wq/7FKw4j6i2j6j2zKc1gmW
PgmVPQqVPT2j2xaaOiWgN0msMCWfOCagNyWgOEisMDKb1nW9JxWJy1myLul/eu6Wkx6PzhSIy3a9
KN06M1qyLWi4Kt46MwZ/xeVmYORlYOFNRz6j2iiV0wyEyAV/xfCqp/CqqAyEx+BOR+p/egAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAe9gACCg4QBhoeEiQABCI0IAYqFGikmGpCRggEZGSQol4MDoaEBHyMf
IZ+CAwWsBQEqExMiqQCrrQENuSUBBL29A0EeHjoBMSssSrwGywYDRAzQARcXOS28T04cHAMdQx08
AQniS7wLCz4LAxERNDgBCj8KCrw9GxtSAxAQDw8BFBRAdvDCgOQIhgE2atyYEQBKhQpMeCWRICHK
AAcyHDgIYKGJEQu8hBQBAWIAjBMuXgQ4wPJAAAEwY8qcKSAQADs=
'''

gv_icon_vertical_chart = '''\
R0lGODlhEAAQAEQAACH5BAEAAAAALAAAAAAQABAApAEAAABan0Wn3gCSPwB8wxSIy1Kv4nDC7tol
HQmVPTemNFmyLn/AJuVmYN06Mu2Wk/O4tgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAVaoICM5AicKCBAbAshKSo8dP3AsdrsfIPHAodw6PilBIOkcjk4Mp7QaFO2
qFqv05NAwe16s6qEeEwGCwLotHotOLjfcHhAYKjb7/d5Yc/v9+cEgYKDg3Nrh2ohADs=
'''

gv_icon_pr0 = '''\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'''

gv_icon_pr1 = '''\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'''

gv_icon_pr2 = '''\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'''

gv_icon_pr3 = '''\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'''

gv_icon_pr4 = '''\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'''

gv_icon_pr5 = '''\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'''

gv_icon_pr6 = '''\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'''

gv_icon_pr7 = '''\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'''

gv_icon_pr8 = '''\
R0lGODlhEAAQAPcAANK+rNK/rdPNxdS1nNS1ndW/rdXArtiqi9iri9irjdisjd2abd2bbd+JTd+K
Tt+QW9+RXeCQWOCQWeCRW+CRXOCTYOCTYeKGSOKLT+KMT+KMUeKNUuOFR+OGSOZlD+dqFudsGuhs
HOhuIOhxJOhyKOl2LOl3Lul3L+l9N+l+Oup6M+p+N+p+Oep+OuqBP+qCQuqEReqFRuqOV+uBQOuD
Q+uFReuHSOuKTuuKT+uRW+yGRuyGSuyHSuyIS+yITOyJTOyJTeyKTeyMTeyMUOyPVuyWY+17MO2K
T+2KUO2LUO2MU+2NU+2PVe2QV+2QWu2XZu2cb+2fc+57Lu6RWu6RW+6UY+6WY+6dbu6lfu+AN++D
Pe+EP++bae+cZ++ecu+gdu+hdu+kfPCFQvCQUvCecvCfb/Chc/CiePCke/CngPCsivCwkfGQUfGl
fPGmgPGngfGqhvGrffGrfvGrgfGsiPG0lvKthPKtiPKti/Kuh/KvjfKvjvKwj/KxkPO0kPO4lPO5
n/S4m/S4nPS8ovS9mfTCpvW7o/W8pPXBpfXBqfXBrPXCrvXEpPXEpfXSyvbArPbBrPbEsfbGrPbG
tfbIr/bJu/fGtffLv/fOwvfPtvfSvfjNwPjPwfjTw/jUzPjZxvjby/nc0frg1frj1vrm2frm2vrn
2/vl2/vr4Pzt5Pzw6Pz07v3z7f307v307/308P318f328P328v328/339P349f77+f77+v78+v79
+/79/P79/f8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAALwALAAAAAAQABAA
h9K+rNK/rdPNxdS1nNS1ndW/rdXArtiqi9iri9irjdisjd2abd2bbd+JTd+KTt+QW9+RXeCQWOCQ
WeCRW+CRXOCTYOCTYeKGSOKLT+KMT+KMUeKNUuOFR+OGSOZlD+dqFudsGuhsHOhuIOhxJOhyKOl2
LOl3Lul3L+l9N+l+Oup6M+p+N+p+Oep+OuqBP+qCQuqEReqFRuqOV+uBQOuDQ+uFReuHSOuKTuuK
T+uRW+yGRuyGSuyHSuyIS+yITOyJTOyJTeyKTeyMTeyMUOyPVuyWY+17MO2KT+2KUO2LUO2MU+2N
U+2PVe2QV+2QWu2XZu2cb+2fc+57Lu6RWu6RW+6UY+6WY+6dbu6lfu+AN++DPe+EP++bae+cZ++e
cu+gdu+hdu+kfPCFQvCQUvCecvCfb/Chc/CiePCke/CngPCsivCwkfGQUfGlfPGmgPGngfGqhvGr
ffGrfvGrgfGsiPG0lvKthPKtiPKti/Kuh/KvjfKvjvKwj/KxkPO0kPO4lPO5n/S4m/S4nPS8ovS9
mfTCpvW7o/W8pPXBpfXBqfXBrPXCrvXEpPXEpfXSyvbArPbBrPbEsfbGrPbGtfbIr/bJu/fGtffL
v/fOwvfPtvfSvfjNwPjPwfjTw/jUzPjZxvjby/nc0frg1frj1vrm2frm2vrn2/vl2/vr4Pzt5Pzw
6Pz07v3z7f307v307/308P318f328P328v328/339P349f77+f77+v78+v79+/79/P79/f8AAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAj+AHkJFHiAQocLExAMXMgLQAUoavbAAZPjAQCG
A8ZEusRJVKhEe9BoGTAQABtHlTrdOjXKFqIzWLIE4CXAwiRMh2aBIlNFUysrV55o4JUgiqdHgnZR
crLjj64pTLi4MCChziZDeDSl8jPHVKMWPKgEWcBhkKVAbvLAesVKlpARM5IoacAB0CI+d2plolGC
kKsVJ3wgaRCBDqQ3knAtURHCQyw5Io7oYKCgiKI0hXI1MQHiw6o4JIigMCAAgp4+bWR9GsKCEa0a
MG5kEAhAzJowdkqpQkWqywsZUmYKHLDlixcrZsr86IHDCAGGATbEIKIEiI0UGIQz5FWAgQMHDAwD
MAwIADs=
'''

gv_icon_pr9 = '''\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'''

gv_icon_form = '''\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==
'''

gv_icon_hand = '''\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=
'''

gv_icon_scroll = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAP///wB8w9ft+q/b9ABVktft+QBenuHx
+83p+MTk97vg9sfi8vP6/vr9/vP6/eHy++v2/Ov1/Pr8/7vh9gBbmgB4vgBfnonG6QBkpsPk9/n9
/gBvswBZl83o+MTl9gB6wQBenQB2u/P5/rzg9gBoq7Te9c3o+QBYlwBiogBpqwBzt6jU7YzI6gBr
rgBsrwByt7vg9QB4v+r2/ABWlABXlOHx+s3p+QBhogBUksPl9+r1/Ov2/er1/fL6/rzh9fr8/gAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAergACCAAKFhoeDggIMAY2OjQwCgyCMj5YMIIIyEw5ADhMboA4OFqWC
Ig8jDQ0+DamuIokwMz08EjsRERISESuJHDYIwhDCCBAQHIkvAwbMBs0D0S6JJQke1gk3CdsnKokZ
HxoK4wriHzoZiSkLJD8LCzEU8gs4giEH+BcX+Af3LSYXBFWwZKkCgQqCOrCIxizaMwMdMKAYVAMD
gYsYL2KgkQhAgRwFQooMmSgQADs=
'''

gv_icon_script = '''\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'''

gv_icon_complex = '''\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'''

gv_icon_network = '''\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'''

gv_icon_system = '''\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'''

gv_icon_environment = '''\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'''

gv_icon_picture = '''\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'''

gv_icon_menu = '''\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'''

gv_icon_button = '''\
R0lGODlhEAAQAOYAAP8A/zaa/9bv/+r3//L6/+Dz//r9/87s/xal/6jd/8bp/////3nL/xqn/0q5
/y6u/xun/xel/6fd/2nF/3vM/3rM/0S3/2bE/1i+/4vS/yKq/zqz/zmy/2LC/zuz/5DU/4nR/4rS
/ySr/ySq/y2u/0u6/yGp/zOw/y+v/1a+/2fE/1q//z20/1C7/3fK/1vA/9Lt/2jF/yOq/zCv/3bK
/5LV/xyn/9Tu/xim/5HU/3LI/3PJ/x6o/6vf/6re/z+0/3jL/33N/026/1m//z60/yWr/1zA/0m5
/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAAAALAAAAAAQABAAAAeSgACCg4SFhAGIiYqFAT0Jj48SEgk+AYMBHyEUFQwMQC40QRkglgAB
Ozo3C6usMBMxpQEqFwa1trUvK7FDGAS+v75CJbEORwPHyMdELLEeGwXQ0dAzKLEPJALZ2tkiI7Ey
Ggfi4+I2ELENDTUK7O05EQixCPP0ETgQPCZFpaYPJxw/LDhokcJIB36CFClEaKihoEAAOw==
'''

gv_icon_organisation = '''\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=
'''

gv_icon_bad_mark = '''\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'''

gv_icon_normal_mark = '''\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'''

gv_icon_good_mark = '''\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'''

gv_icon_roundedquestion = '''\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'''

gv_icon_roundedinformation = '''\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==
'''

gv_icon_star = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAPrVQf3ph/3qh/zkdvvfZPvaUv/5vfnR
MOOzGvvgZPzldvzldee0DPnNIu7LTey4COSxDtOiIPfjg+W0Ffrmhfzph/rRMO3BKPPXZvzgZOK2
LvvbUvvaU//2tP3ul/7vl/73tPvjc/7yp/7zpvjWTvvlgP3ldv7umPreYvrWQfbXWfbZZf7ypvbI
IvnMIvrQMO+9EPfgefbdbvnIFPHFLvrNIfrslv3vmPnMIfnNIfPCFvnJFNOnOtCeItimG86bIMmZ
Ms+dINCeH/DBIe28GOi/M/rQMeCvGuW4LOOyG/XOPM+nStioJdGfH+K1L9ioIvrWQPjQMNurJdel
HMaUJsmXI8qbMNuqINyqHd2sHt6vIgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAeigACCgwA1MYSIhBAyBxCJiRgHBxiPhA0THiETDZUAERQ3LSQjFBGI
CUYPGRU4KCAfFRkPCQkASDMCA7m6vBYCFiZJAFosDAQnBAvJyQwiG4NYKwUFChrUGgopz4RQJR0c
HB0G40+JQ0sBASoBUelNiUBSCBcICDAXR1OJPg4vOi5EcthwsCWRBBo7sli5IqEIDyWJnFCpQiiI
kB+JelRiMigQADs=
'''

gv_icon_action_call = '''\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'''

gv_icon_action_subprocess = '''\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'''

gv_icon_action_task = '''\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'''

gv_icon_action_transaction = '''\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'''

gv_icon_activator_bgbutton = '''\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=
'''

gv_icon_activator_brbutton = '''\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=
'''

gv_icon_activator_button = '''\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'''

gv_icon_activator_link = '''\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'''

gv_icon_activator_touch = '''\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'''

gv_icon_annotation_bold = '''\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'''

gv_icon_annotation_default = '''\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'''

gv_icon_annotation_header = '''\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'''

gv_icon_annotation_red = '''\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'''

gv_icon_annotation_table = '''\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'''

gv_icon_annotation_vbold = '''\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'''

gv_icon_annotation_vdefault = '''\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'''

gv_icon_annotation_vheader = '''\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'''

gv_icon_annotation_vred = '''\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'''

gv_icon_center_horizontal = '''\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'''

gv_icon_center_vertical = '''\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'''

gv_icon_event_default = '''\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'''

gv_icon_lighton = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAAPnSKeW9RTKe2fnRKPzaPOW8RN+uFEep
3+/IMf/LBfG9BFy357HIiu/HLwpkqwplqxpprP///wBVn2vD+v/3rip0sSt0sRtprABWn1u38hyF
xVy59Ax5wQ5ztQBUngBVngtwsxJ5uxyExfzoZTyg2T2Hn2zD+lCu4T2h2T6Gmaa/h/3veaa+hf//
/k6s4P7ucv3oZP7xhf/2mv7zhP3iUP3wfv7uc/3oZfzkW/vfUvjdUv/74/3iUfjeV+7IRu/IL9+v
FfvYOuu2A/vfTfrXOPrmafziX/72x/7zrvvfTvrYO/vZO+/JMv3tk+3HRfzFBPO/BO+6BPzFBfO/
BgtxtApxtA9+xvnkZQx0uO3JO+i3HeK6NuK5OMeXHsaWHvPQQO3JN+u3A/G9BvPRRAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAeRgACCg1QLC1GDiYlSOyw2PmOKiUNYMxUyNEZikgA/QDc8EkkkME1P
klpgMUguTjk4ZGGSXQ41OkdESj0JXJICDgVCRUtMBQkGvgcBAQQEy0HIkl8HUAoKU1tenIImKw0N
LSrbglccFCcaHeMAIigMDC9Z6x4pCAglIesQIwMDGw/rLnywUgWEhXUAMGSYEEFSIAA7
'''

gv_icon_lightoff = '''\
R0lGODlhEAAQAFUAACH5BAEAAAAALAAAAAAQABAApQEAAG/B7sTm+On2/CeV0qDW9ly355LM7cXl
9k6t4fn8/mzD+tnv+hyFxd7x+9Ts+bri94fN8sPl+ajZ9l6y4Eep3zKe2QR/xeHx+9bt+2vD+gpk
q1u38ly59Aplqyt0sRyExTyg2T2h2RJ5uyp0sU6s4FCu4Q5ztRtprBpprABVng9+xgx0uABUngtx
tAx5wQBWnwBVnwpxtP///wtws////gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZ/QIBw
GCgGhkhk4DEYPI5JIkZBVWCgyQRikJllmohENOEYSGqSwsAhThIYjIJcziBECQiBYDLRI+xuFAd6
egcUgEkNCwcQEAcLDVFDFwYREQYXkkMrHRoLHC+aQiMmBgYlLKIAJyIVFSE0qh4gFhYNG6ofLTIu
KiSqACgwMSlRQQA7
'''

gv_icon_semaphore = '''\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'''

gv_icon_event_end = '''\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'''

gv_icon_event_terminate = '''\
R0lGODlhEAAQAPcAAABAgP8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAA
hwBAgP8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAhGAAEIHEiwoMEACBMaHJiwYYCFCA8+JBgRQEOB
FS1OdLixo0aOGjE+5BixYkmSIUOSHOnxo8KUKS/CFCkRIsqFLjPi3AkgIAA7
'''

gv_icon_event_linkout = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAAoALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///whMABUIHEiwoEFuCBMaHMjt4MKGDwtCXKhg4sSB
OSQKvCjwR0aGGwd6HPmxYkiBOUj+AGmyYEqCEDkqWAmTJUWOMk9q3PkwIUKKQAkGBAA7
'''

gv_icon_event_linkin = '''\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'''

gv_icon_event_inter = '''\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'''

gv_icon_event_start = '''\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'''

gv_icon_gateway_default = '''\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'''

gv_icon_gateway_complex = '''\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'''

gv_icon_gateway_eventbased = '''\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'''

gv_icon_gateway_exclusive = '''\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'''

gv_icon_gateway_inclusive = '''\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'''

gv_icon_gateway_parallel = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAAsALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///wg/ABcIHEiwoEGBAAAcNKhwQcOFDgk+ZEixosOH
EyMOTChx48aEID1qvAgSo0iEEzNiNGnxZMuMFWEe5Aix5sCAADs=
'''

gv_icon_mouse_b1 = '''\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=
'''

gv_icon_mouse_b2 = '''\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=
'''

gv_icon_point_dempty = '''\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'''

gv_icon_point_dfilled = '''\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'''

gv_icon_point_empty = '''\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'''

gv_icon_point_filled = '''\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'''

gv_icon_separator_lazy = '''\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'''

gv_icon_separator_vlazy = '''\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'''

gv_icon_separator_bold = '''\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'''

gv_icon_separator_default = '''\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'''

gv_icon_separator_vbold = '''\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'''

gv_icon_separator_vdefault = '''\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'''

gv_icon_threshold_default = '''\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==
'''

gv_icon_threshold_wakeup = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAA4ALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///whGAB0IHEiwoMGDCA8CAJBQoIKHBxgaHLCg4kMF
EQ9StAhRYsGNCy5mnFhxgYCTIz8OGHBgYMqGDl42lJmQJkKbCj3C3JkwIAA7
'''

gv_icon_flag_green = '''\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'''

gv_icon_flag_red = '''\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'''

gv_icon_flag_yellow = '''\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'''

gv_icon_threshold_deadline = '''\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=
'''

gv_icon_filter = '''\
R0lGODlhEAAQAFUAACH5BAEAAAAALAAAAAAQABAApQEAAACH1On2/QBanwCG1Ge96wBmrczp+bzi
9wBrswBdowB2wMPm+ACE0Tuh2pbT9eT0/Nzx/KDX9QB8xg+FySGQ0ABwuVWy5VWx5Fyt3YfM847P
8wCAzAB7x6vb9rXg+LTf9+Tz/cno+QBhp9Tt+9zw/OT0/ePz/OTz/ACCzo7Q86rc9sDl+ABxucrp
+cno+NPt+93w/ABgpwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZlQIBw
SCwCAsgkksBUBo4HgXRKPTyFAZEJFYIUCifIi1BsMEqRyDfGaBgBHASMdMEgUm9hB+RyOCZ5Qwss
FQuBQxYfFC2HQgkeKwmNAAYSEgaTIw8PMpMKKhsKkwMaGQOjA6eTh0EAOw==
'''

gv_icon_wrench = '''\
R0lGODlhEAAQAGYAACH5BAEAAAAALAAAAAAQABAApgEAACiQzBuAvxFztYXA4qDO6AZnrJPG5Qpr
rwRkqXe53xh8vABfpXe43nKz2imJxGmx2x6EwySLyDmRyGit2CGIxZfG4xR4uRR3uA1vsoO73oS8
3hBztSKFwyKGwzCMxgJhpgJipgxvslql0zGMxkaazlqk0nq33Hu33JLD4YvA4IW/4lCf0IzA4JLD
4iKIxiaNyieOyiSMyGiu2Fyq2JPH5TiYz0Kd0ziY0L/d76vU68bh8bfZ7k+k1VCg0B6Ewh+FwyGI
xluq2HGz2ne430+j1UKe00abzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAeEgACCg4MBhoSIhRY7FgGJhDEuOSkwj4MSKjwtEoMyjxU6GxWDLxpB
iT8FKBGCEScFQIkCBzVDAgIOBw4CiQsrBAQUM8ELiRgjDUQNCgomF4kDLBAQPgMDHAOJGUdCNCUi
lgAIEz1FEwjhBh9GNyQG4QkPNjgPCeGCIB4dIfeDDAz9AAQCADs=
'''

gv_icon_timer_green = '''\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'''

gv_icon_timer_red = '''\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'''

gv_icon_timer_yellow = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAALcALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///whYAG8JHEiwoMEBCBMaHDhggcOHAxY2PECx4oKI
BBs6PLARIsOHCziGBIlRY0eKJAWa3CjS462VI1teVAlSpMySNTu6fPnQ5k6aFS1iLAhz5sKXCREe
XUowIAA7
'''

gv_icon_role_manager = '''\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'''

gv_icon_role_worker = '''\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'''

gv_icon_role_oldmanager = '''\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=
'''

gv_icon_role_oldworker = '''\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'''

gv_icon_role_manager32 = '''\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=
'''

gv_icon_role_worker32 = '''\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'''

gv_icon_role_oldmanager32 = '''\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'''

gv_icon_role_oldworker32 = '''\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'''

gv_icon_role_secmanager = '''\
R0lGODlhEAAQAPcAAAAAAAD//0hISklJS0pKTEpKTUtLTUtLTkxLTkxMTk1MT01NT01NUF1dXV5e
XmBgYWNjY2NkZ2RjY2VlZWZmZmdnZmdnZ3Bxc3Byc4JpOYlrNJd7Qp6ho5+hoqCho6CipaKmqqSn
qqWnqqiqramsrqmtr6yusK2wtq6wtK6wta6xt66yuK+xtK+xt6+yua+ztrCwsbCxsrCytLCztrC0
urGvrLGxsbGxsrGxs7GysrGys7KysrK0uLK1u7OzsrOzs7SWXLS0tLi4uLi5vLi7wLm8wLq6uru7
u7y8vMGzl8HBwcaobMbIysnLzcqjYc+yfNDS1NOuadPV2NTV19XW2Na0dNbZ29fFm9m/jN3d3t3e
397f3+C8c+Dg4ODg4eG/fOjEfOrJhfPPhf///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAAQABAA
hwAAAAD//0hISklJS0pKTEpKTUtLTUtLTkxLTkxMTk1MT01NT01NUF1dXV5eXmBgYWNjY2NkZ2Rj
Y2VlZWZmZmdnZmdnZ3Bxc3Byc4JpOYlrNJd7Qp6ho5+hoqCho6CipaKmqqSnqqWnqqiqramsrqmt
r6yusK2wtq6wtK6wta6xt66yuK+xtK+xt6+yua+ztrCwsbCxsrCytLCztrC0urGvrLGxsbGxsrGx
s7GysrGys7KysrK0uLK1u7OzsrOzs7SWXLS0tLi4uLi5vLi7wLm8wLq6uru7u7y8vMGzl8HBwcao
bMbIysnLzcqjYc+yfNDS1NOuadPV2NTV19XW2Na0dNbZ29fFm9m/jN3d3t3e397f3+C8c+Dg4ODg
4eG/fOjEfOrJhfPPhf///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAi0AAMIFMiBhQwTHwYqHDiiCZUpTGaQWKiwBBQr
Uoq8CEFxoIghRGpgSQKiYwAfN1BcCcPFhY4fHW1kOSHmS5QVWmx03AFDBZgqTmjE2NExiJYWS4Bo
6LElSEchNlI82ZCBRw4hFB0Y6QJjjFccXow4UDgBgxIkRzqM8XAEiZILEgZOiKAAgQECAggYQKAg
woSBDxgMKJDggIEDCQoMWEBhoIMKFiJLllyhwUAAmDNrzmyyc4CAADs=
'''

gv_icon_role_secinspector = '''\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'''

gv_icon_role_secworker = '''\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==
'''

gv_icon_role_secmanager32 = '''\
R0lGODlhIAAgAPcAAAD//ykpKikpMTAwMTw8PTlCQkJCQ0VGR0pKS01OT05PUFFSU1RVV1ZXWFhY
WV1eYV5fYWJjY2hpaW5vcG9wc3FVHnBvcH5pRn1+gYVpNoGChISEjIqMj42Pko+Rk5B2RJGTlpaZ
nJWapJmbnpueo5ycrZ+hpKWKVaSek6Kkp6SnrKirrqmGRa6onK6urauus7CztbOSUbSYYrWtrbWy
qbKys7O2u7i6vr6cXLudZLqpirq9v77Bw7/DxMWvhMO5o8TGyMfJy8nLzMutcczO0NDR09HT1Na1
dNS6h9a9i9DAmtPAotPV19bW3t61a926dN29fePIkNvEkuO/eue9hOfEfuXFhOfOlODg4O/Ge+3L
h+7OjPrWjffXkvHixPHy8fzakP/flP/nlP/nmf///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAgACAA
hwD//ykpKikpMTAwMTw8PTlCQkJCQ0VGR0pKS01OT05PUFFSU1RVV1ZXWFhYWV1eYV5fYWJjY2hp
aW5vcG9wc3FVHnBvcH5pRn1+gYVpNoGChISEjIqMj42Pko+Rk5B2RJGTlpaZnJWapJmbnpueo5yc
rZ+hpKWKVaSek6Kkp6SnrKirrqmGRa6onK6urauus7CztbOSUbSYYrWtrbWyqbKys7O2u7i6vr6c
XLudZLqpirq9v77Bw7/DxMWvhMO5o8TGyMfJy8nLzMutcczO0NDR09HT1Na1dNS6h9a9i9DAmtPA
otPV19bW3t61a926dN29fePIkNvEkuO/eue9hOfEfuXFhOfOlODg4O/Ge+3Lh+7OjPrWjffXkvHi
xPHy8fzakP/flP/nlP/nmf///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAj+AAEIHEiwoMGDCBGCCMGQIYiEEAlqCGHCBhAg
PWqYCKEhIsQQL4gYMUIkCJAdKkJ4RMghhciRJE/WSNFhpcEQO2COJCLThUqbBEkAebmzJwmgAzmY
GKoTiA0bNVyQ4IAUwAghJ4EE2fHih5QkLoQEMVGVRJAeP1TQ+LFli5YqSc6SRdqBoZIxYbq0tVJF
B0MPVUeUFJF3r5UpIogImQuUhJAehPVasQLliQi5VeuGaBFmL5TKKEKMAIxUcBARXLZM/nwk8eKy
j0lc0UIZypHWj1NkZijCB5TaOS6QEP0QqYmSJKAMyXHiQ4YKJBTrRuoSshckOGKwkLEkxEUXQCO8
RGgpmIz582SIhKAp3mMEChooMPiCvv6X9/EjQHyP4cEDBjXUh14NEfiHgQX6IRRBfwz8h8ADWNSH
xQMINNggBgkahMAE8jHgIQMKGKDBeRoYoMCHHlIwAQIHMTBBBCeiiAACBtQ4I4ogRjABAwc9MAGF
MwYp5JBC+vjAQeIFOQCRTC45Y3sGiVejAQNMaeWVVE75QIYERcAAAQQYEIABYJZpJphikkkAA1wO
tOUEcMYp55x0QlnVnXh6FBAAOw==
'''

gv_icon_role_secinspector32 = '''\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'''

gv_icon_role_secworker32 = '''\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'''

gv_icon_role_supmanager = '''\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'''

gv_icon_role_supmanager32 = '''\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'''

gv_icon_role_supworker = '''\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==
'''

gv_icon_role_supworker32 = '''\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'''

gv_icon_service_core = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAAsALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///whFABcIHEiwYEEUCAUiRGFQ4QKGDyMaTLiQYcKB
Cxs+vAhRo8ONHQ9e/DixZMOQGU9y9IhR4UiRKC1mfNkSokWNKVOy1BgQADs=
'''

gv_icon_service_enabling = '''\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=
'''

gv_icon_service_enhancing = '''\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==
'''

gv_icon_service_portfolio = '''\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==
'''

gv_icon_condense_content = '''\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'''

gv_icon_collapse_pane = '''\
R0lGODlhEAAQAPcAAAAAANbTzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAAQABAA
hwAAANbTzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgvAAMIHEiwoMGDCBMqXGgQAEOBACIylCgxYcUA
Fy0+xJgRIUWHFkFy3EiypEmDAQEAOw==
'''

gv_icon_expand_pane = '''\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'''

gv_icon_dualleft = '''\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'''

gv_icon_dualright = '''\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'''

gv_icon_expand_content = '''\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'''

gv_icon_signdanger = '''\
R0lGODlhEAAQAPcAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBm
AABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/
MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNm
ZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/
mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZm
zGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZ
AJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwA
M8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZ
ZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8A
mf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///yH5BAEAAAoALAAAAAAQABAA
hwAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBm
zABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD/
/zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZ
ADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYA
M2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZ
ZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkA
mZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZ
zJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA
/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zM
AMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//M
Zv/Mmf/MzP/M////AP//M///Zv//mf//zP///whdABUIHEiwoMGDCBMSDMCwoUOHAgM8SJDgwcSK
Fx8EiEjRYseMGjl6xPgxwUYFEkGWNBlRJcmKJx/KbEgQwAGDNnHeLJiT54GdA20CVQCg6NCiPQX+
/Elw6VCFBAMCADs=
'''

gv_icon_signprocess = '''\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'''

gv_icon_signschema = '''\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'''

gv_icon_signservice = '''\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'''

gv_icon_blackline = '''\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'''

gv_icon_blueline = '''\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'''

gv_icon_greenline = '''\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'''

gv_icon_purpleline = '''\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'''

gv_icon_redline = '''\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'''

gv_icon_wand = '''\
R0lGODlhEAAQAMQZAP95S///AJlmAFo6ADc3c729/3Fx121uyJqa5zM/Sf+hNWZmwJGap7u/wv/X
Fllidevx9f+gNb6+/3V12aCg6jU1b3Bwzv/XF//M/////wAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABkALAAAAAAQABAAAAVQYCaOZAaUqJkJgKCmohDMLrwGQB7UqK4oEdwpNQg4HJfAwJYpzpapg2oA
WA5JBwRmdC1lC4YE04IAE5iPhhndgDAqzAXFLY5LJnVmhnDWZ0IAOw==
'''

gv_icon_nlist = '''\
R0lGODlhEAAQALMIAAAzmYqVoXeBi2NsdQAwlgBt0wAvlQAymP///wAAAAAAAAAAAAAAAAAAAAAA
AAAAACH5BAEAAAgALAAAAAAQABAAAAQvEBlEq7WF3G1PDWAoBkDJnWiqAkShWtqLAJVg37hQ0nLv
U7serxcbGI/IAcv1igAAOw==
'''

gv_icon_dlist = '''\
R0lGODlhEAAQAKIGAAAxl32HkoqVoWNsdXB6hABz2f///wAAACH5BAEAAAYALAAAAAAQABAAAAMt
aLrcCi4aUKAROGsxpf+MBU6VEpxoGnRj24ggZRF0bROsq8OfrAzAoHCQAyUAADs=
'''

gv_icon_trash = '''\
R0lGODlhEAAQAOZcAHF6hf///664w5KeqfHz9JqksMTL1Nbc4rjE0eTr8bnEzyw3QvD1/Ovx+O/0
+2BqdFlha/X4+e71+rG7xig0P1xlbys2QeDo8Sk0QNXd5pGdqsHN2bjEz7/K1Fhha56lrLjE0LrF
0JGdp5qiqXF7hoeRm6Krtio1QH+Klaayvtrb3VZfabLAzvDz9JymsnF8h15mb3J+ioyZpcfR2cHM
14GMl9zk62pzfGlyfmx2gmVueCYyPrC7x1xkbXuGkejv9cfP146Xn5iirpSgq5uotPj9/6OnrbnF
0MLK011lbm53grnE0EZOWOPq8GFqc0FLVc/U2rjDztDa5M/X4JWcpbC9ynaBi7vH1NXb4tnf5i04
Q2RueP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAFwALAAAAAAQABAAAAeggFyCgwCFAIOIiAAMDQ0Mh4lchpOUhAGXmJkBUJAADjYZUzMdCjwp
RBoynTEqRh8jVEElNSgmPpBcLwFAET8uWVdDEwpWiDkBBgQJBQcIAwJRJIg4yMrMzgIcSohb1cvN
zwo3iA/e1+E6iBXm4AJLToge7NhHMIgrAUgtTUJYICICQvRABOFSEQkXpGxgUYVGkkRPdlDAcMLC
Ai0LmAwKBAA7
'''

###################################
## routines
###################################


def __acceptname(pv_iconname):
    """check some rules about icons"""

    return (isinstance(pv_iconname, str)
            and not pv_iconname.startswith('__')
            and pv_iconname not in ('PhotoImage', 'run_demo', 'get_icon', 'Tk', 'ToolTippedBtn')
            and pv_iconname not in sys.modules)


def get_icon(pv_iconname, pv_defdata=None):
    """get local icon"""

    lv_defdata = pv_defdata if pv_defdata is not None else __NOICONDATA

    icon_data = lv_defdata
    try:
        if __acceptname(pv_iconname):
            icon_data = globals().get(pv_iconname, lv_defdata)
    except:
        pass
    return icon_data


def run_demo():
    """ local demo """

    def name2clipboard(wroot, pv_name=''):
        wroot.clipboard_clear()
        wroot.clipboard_append(pv_name)

    root = Tk()
    root.title(__file__)

    ll_imgs = [x for x in globals() if __acceptname(x)]
    ll_imgs.sort()
    lv_lenimgs = len(ll_imgs)

    lv_pos = 0
    lv_x = int(len(ll_imgs) ** 0.6)

    lv_r = 0
    while lv_pos < lv_lenimgs:
        lv_c = 0
        for i in range(lv_x):
            if lv_pos >= lv_lenimgs:
                break
            try:
                img = PhotoImage(data=globals()[ll_imgs[lv_pos]])
                b = ToolTippedBtn(root,
                                  tooltip=ll_imgs[lv_pos],
                                  image=img,
                                  command=lambda ev=None, wr=root, wt=ll_imgs[lv_pos]: name2clipboard(wr, wt))
                b.grid(row=lv_r, column=lv_c)
                lv_c += 1
                lv_pos += 1
            except Exception as err:
                print(err.message)
        lv_r += 1

    root.resizable(width=False, height=False)
    root.mainloop()

if __name__ == '__main__':
    run_demo()
