#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" demo icons """

# pytkapp: demo icons
#
# Copyright (c) 2015 Paul "Mid.Tier"
# Author e-mail: mid.tier@gmail.com

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

###################################
## import
###################################
import sys
if sys.hexversion >= 0x03000000:
    from tkinter import Tk, PhotoImage
else:
    from Tkinter import Tk, PhotoImage

# pytkapp
from pytkapp.tkw.tkw_tooltippedbtn import ToolTippedBtn

###################################
## globals
###################################
__NOICONDATA = '''\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'''

###################################
## icons
###################################
gv_icon_demo_excel = '''\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'''

gv_icon_demo_lightning = '''\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'''

gv_icon_demo_word = '''\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'''

###################################
## routines
###################################


def __acceptname(pv_iconname):
    """check some rules about icons"""

    return (isinstance(pv_iconname, str)
            and not pv_iconname.startswith('__')
            and pv_iconname not in ('PhotoImage', 'run_demo', 'get_icon', 'Tk', 'ToolTippedBtn')
            and pv_iconname not in sys.modules)


def get_icon(pv_iconname, pv_defdata=None):
    """get local icon"""

    lv_defdata = pv_defdata if pv_defdata is not None else __NOICONDATA

    icon_data = lv_defdata
    try:
        if __acceptname(pv_iconname):
            icon_data = globals().get(pv_iconname, lv_defdata)
    except:
        pass
    return icon_data


def run_demo():
    """ local demo """

    def name2clipboard(wroot, pv_name=''):
        wroot.clipboard_clear()
        wroot.clipboard_append(pv_name)

    root = Tk()
    root.title(__file__)

    ll_imgs = [x for x in globals() if __acceptname(x)]
    ll_imgs.sort()
    lv_lenimgs = len(ll_imgs)

    lv_pos = 0
    lv_x = int(len(ll_imgs) ** 0.6)

    lv_r = 0
    while lv_pos < lv_lenimgs:
        lv_c = 0
        for i in range(lv_x):
            if lv_pos >= lv_lenimgs:
                break
            try:
                img = PhotoImage(data=globals()[ll_imgs[lv_pos]])
                b = ToolTippedBtn(root,
                                  tooltip=ll_imgs[lv_pos],
                                  image=img,
                                  command=lambda ev=None, wr=root, wt=ll_imgs[lv_pos]: name2clipboard(wr, wt))
                b.grid(row=lv_r, column=lv_c)
                lv_c += 1
                lv_pos += 1
            except Exception as err:
                print(err.message)
        lv_r += 1

    root.resizable(width=False, height=False)
    root.mainloop()

if __name__ == '__main__':
    run_demo()

