# Copyright (c) 2013, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Apr 11 15:06:23 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import stix.bindings.stix_common as stix_common_binding
import stix.bindings.data_marking as data_marking_binding

import base64
from datetime import datetime, tzinfo, timedelta

XML_NS = "http://stix.mitre.org/ExploitTarget-1"

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
# lxml
from lxml import etree as etree_
XMLParser_import_library = XMLParser_import_lxml
if Verbose_import_:
    print("running with lxml.etree")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser(huge_tree=True)
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class VulnerabilityType(GeneratedsSuper):
    """Characterizes an individual vulnerability. In addition to capturing
    basic information and references to vulnerability registries,
    this type is intended to be extended to enable the structured
    description of a vulnerability by using the XML Schema extension
    feature. The STIX default extension uses the Common
    Vulnerability Reporting Format (CVRF) schema to do so. The
    extension that defines this is captured in the
    CVRF1.1InstanceType in the
    http://stix.mitre.org/extensions/Vulnerability#CVRF1.1-1
    namespace. This type is defined in the
    extensions/vulnerability/cvrf_1.1.xsd file or at the URL http://
    stix.mitre.org/XMLSchema/extensions/vulnerability/cvrf_1.1/1.0/c
    vrf_1.1.xsd."""
    subclass = None
    superclass = None
    def __init__(self, Description=None, CVE_ID=None, OSVDB_ID=None, CVSS_Score=None):
        self.Description = Description
        self.CVE_ID = CVE_ID
        self.OSVDB_ID = OSVDB_ID
        self.CVSS_Score = CVSS_Score
    def factory(*args_, **kwargs_):
        if VulnerabilityType.subclass:
            return VulnerabilityType.subclass(*args_, **kwargs_)
        else:
            return VulnerabilityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_CVE_ID(self): return self.CVE_ID
    def set_CVE_ID(self, CVE_ID): self.CVE_ID = CVE_ID
    def get_OSVDB_ID(self): return self.OSVDB_ID
    def set_OSVDB_ID(self, OSVDB_ID): self.OSVDB_ID = OSVDB_ID
    def get_CVSS_Score(self): return self.CVSS_Score
    def set_CVSS_Score(self, CVSS_Score): self.CVSS_Score = CVSS_Score
    def hasContent_(self):
        if (
            self.Description is not None or
            self.CVE_ID is not None or
            self.OSVDB_ID is not None or
            self.CVSS_Score is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='VulnerabilityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VulnerabilityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='et:', name_='VulnerabilityType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='VulnerabilityType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            self.Description.export(outfile, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
        if self.CVE_ID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%s:CVE_ID>%s</%s:CVE_ID>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.CVE_ID).encode(ExternalEncoding), input_name='CVE_ID'), nsmap[namespace_], eol_))
        if self.OSVDB_ID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%s:OSVDB_ID>%s</%s:OSVDB_ID>%s' % (nsmap[namespace_], self.gds_format_integer(self.OSVDB_ID, input_name='OSVDB_ID'), nsmap[namespace_], eol_))
        if self.CVSS_Score is not None:
            self.CVSS_Score.export(outfile, level, nsmap, namespace_, name_='CVSS_Score', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VulnerabilityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            outfile.write('Description=model_.stix_common_binding.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            outfile.write('),\n')
        if self.CVE_ID is not None:
            showIndent(outfile, level)
            outfile.write('CVE_ID=%s,\n' % quote_python(self.CVE_ID).encode(ExternalEncoding))
        if self.OSVDB_ID is not None:
            showIndent(outfile, level)
            outfile.write('OSVDB_ID=%d,\n' % self.OSVDB_ID)
        if self.CVSS_Score is not None:
            outfile.write('CVSS_Score=model_.CVSSVectorType(\n')
            self.CVSS_Score.exportLiteral(outfile, level, name_='CVSS_Score')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'CVE_ID':
            CVE_ID_ = child_.text
            CVE_ID_ = self.gds_validate_string(CVE_ID_, node, 'CVE_ID')
            self.CVE_ID = CVE_ID_
        elif nodeName_ == 'OSVDB_ID':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'OSVDB_ID')
            self.OSVDB_ID = ival_
        elif nodeName_ == 'CVSS_Score':
            obj_ = CVSSVectorType.factory()
            obj_.build(child_)
            self.set_CVSS_Score(obj_)
# end class VulnerabilityType

class ConfigurationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Description=None, CCE_ID=None):
        self.Description = Description
        self.CCE_ID = CCE_ID
    def factory(*args_, **kwargs_):
        if ConfigurationType.subclass:
            return ConfigurationType.subclass(*args_, **kwargs_)
        else:
            return ConfigurationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_CCE_ID(self): return self.CCE_ID
    def set_CCE_ID(self, CCE_ID): self.CCE_ID = CCE_ID
    def hasContent_(self):
        if (
            self.Description is not None or
            self.CCE_ID is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='ConfigurationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConfigurationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='et:', name_='ConfigurationType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='ConfigurationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            self.Description.export(outfile, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
        if self.CCE_ID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%s:CCE_ID>%s</%s:CCE_ID>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.CCE_ID).encode(ExternalEncoding), input_name='CCE_ID'), nsmap[namespace_], eol_))
    def exportLiteral(self, outfile, level, name_='ConfigurationType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            outfile.write('Description=model_.stix_common_binding.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            outfile.write('),\n')
        if self.CCE_ID is not None:
            showIndent(outfile, level)
            outfile.write('CCE_ID=%s,\n' % quote_python(self.CCE_ID).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'CCE_ID':
            CCE_ID_ = child_.text
            CCE_ID_ = self.gds_validate_string(CCE_ID_, node, 'CCE_ID')
            self.CCE_ID = CCE_ID_
# end class ConfigurationType

class WeaknessType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Description=None, CWE_ID=None):
        self.Description = Description
        self.CWE_ID = CWE_ID
    def factory(*args_, **kwargs_):
        if WeaknessType.subclass:
            return WeaknessType.subclass(*args_, **kwargs_)
        else:
            return WeaknessType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_CWE_ID(self): return self.CWE_ID
    def set_CWE_ID(self, CWE_ID): self.CWE_ID = CWE_ID
    def hasContent_(self):
        if (
            self.Description is not None or
            self.CWE_ID is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='WeaknessType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WeaknessType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='et:', name_='WeaknessType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='WeaknessType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            self.Description.export(outfile, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
        if self.CWE_ID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%s:CWE_ID>%s</%s:CWE_ID>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.CWE_ID).encode(ExternalEncoding), input_name='CWE_ID'), nsmap[namespace_], eol_))
    def exportLiteral(self, outfile, level, name_='WeaknessType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            outfile.write('Description=model_.stix_common_binding.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            outfile.write('),\n')
        if self.CWE_ID is not None:
            showIndent(outfile, level)
            outfile.write('CWE_ID=%s,\n' % quote_python(self.CWE_ID).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'CWE_ID':
            CWE_ID_ = child_.text
            CWE_ID_ = self.gds_validate_string(CWE_ID_, node, 'CWE_ID')
            self.CWE_ID = CWE_ID_
# end class WeaknessType

class CVSSVectorType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Overall_Score=None, Base_Score=None, Base_Vector=None, Temporal_Score=None, Temporal_Vector=None, Environmental_Score=None, Environmental_Vector=None):
        self.Overall_Score = Overall_Score
        self.Base_Score = Base_Score
        self.Base_Vector = Base_Vector
        self.Temporal_Score = Temporal_Score
        self.Temporal_Vector = Temporal_Vector
        self.Environmental_Score = Environmental_Score
        self.Environmental_Vector = Environmental_Vector
    def factory(*args_, **kwargs_):
        if CVSSVectorType.subclass:
            return CVSSVectorType.subclass(*args_, **kwargs_)
        else:
            return CVSSVectorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Overall_Score(self): return self.Overall_Score
    def set_Overall_Score(self, Overall_Score): self.Overall_Score = Overall_Score
    def validate_CVSSScoreType(self, value):
        # Validate type CVSSScoreType, a restriction on xs:string.
        pass
    def get_Base_Score(self): return self.Base_Score
    def set_Base_Score(self, Base_Score): self.Base_Score = Base_Score
    def get_Base_Vector(self): return self.Base_Vector
    def set_Base_Vector(self, Base_Vector): self.Base_Vector = Base_Vector
    def validate_CVSSBaseVectorType(self, value):
        # Validate type CVSSBaseVectorType, a restriction on xs:string.
        pass
    def get_Temporal_Score(self): return self.Temporal_Score
    def set_Temporal_Score(self, Temporal_Score): self.Temporal_Score = Temporal_Score
    def get_Temporal_Vector(self): return self.Temporal_Vector
    def set_Temporal_Vector(self, Temporal_Vector): self.Temporal_Vector = Temporal_Vector
    def validate_CVSSTemporalVectorType(self, value):
        # Validate type CVSSTemporalVectorType, a restriction on xs:string.
        pass
    def get_Environmental_Score(self): return self.Environmental_Score
    def set_Environmental_Score(self, Environmental_Score): self.Environmental_Score = Environmental_Score
    def get_Environmental_Vector(self): return self.Environmental_Vector
    def set_Environmental_Vector(self, Environmental_Vector): self.Environmental_Vector = Environmental_Vector
    def validate_CVSSEnvironmentalVectorType(self, value):
        # Validate type CVSSEnvironmentalVectorType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.Overall_Score is not None or
            self.Base_Score is not None or
            self.Base_Vector is not None or
            self.Temporal_Score is not None or
            self.Temporal_Vector is not None or
            self.Environmental_Score is not None or
            self.Environmental_Vector is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='CVSSVectorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CVSSVectorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='et:', name_='CVSSVectorType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='CVSSVectorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Overall_Score is not None:
            outfile.write('<%s:Overall_Score>%s</%s:Overall_Score>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.Overall_Score).encode(ExternalEncoding), input_name='Overall_Score'), nsmap[namespace_], eol_))
        if self.Base_Score is not None:
            outfile.write('<%s:Base_Score>%s</%s:Base_Score>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.Base_Score).encode(ExternalEncoding), input_name='Base_Score'), nsmap[namespace_], eol_))
        if self.Base_Vector is not None:
            outfile.write('<%s:Base_Vector>%s</%s:Base_Vector>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.Base_Vector).encode(ExternalEncoding), input_name='Base_Vector'), nsmap[namespace_], eol_))
        if self.Temporal_Score is not None:
            outfile.write('<%s:Temporal_Score>%s</%s:Temporal_Score>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.Temporal_Score).encode(ExternalEncoding), input_name='Temporal_Score'), nsmap[namespace_], eol_))
        if self.Temporal_Vector is not None:
            outfile.write('<%s:Temporal_Vector>%s</%s:Temporal_Vector>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.Temporal_Vector).encode(ExternalEncoding), input_name='Temporal_Vector'), nsmap[namespace_], eol_))
        if self.Environmental_Score is not None:
            outfile.write('<%s:Environmental_Score>%s</%s:Environmental_Score>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.Environmental_Score).encode(ExternalEncoding), input_name='Environmental_Score'), nsmap[namespace_], eol_))
        if self.Environmental_Vector is not None:
            outfile.write('<%s:Environmental_Vector>%s</%s:Environmental_Vector>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.Environmental_Vector).encode(ExternalEncoding), input_name='Environmental_Vector'), nsmap[namespace_], eol_))
    def exportLiteral(self, outfile, level, name_='CVSSVectorType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Overall_Score is not None:
            outfile.write('Overall_Score=%s,\n' % quote_python(self.Overall_Score).encode(ExternalEncoding))
        if self.Base_Score is not None:
            outfile.write('Base_Score=%s,\n' % quote_python(self.Base_Score).encode(ExternalEncoding))
        if self.Base_Vector is not None:
            outfile.write('Base_Vector=%s,\n' % quote_python(self.Base_Vector).encode(ExternalEncoding))
        if self.Temporal_Score is not None:
            outfile.write('Temporal_Score=%s,\n' % quote_python(self.Temporal_Score).encode(ExternalEncoding))
        if self.Temporal_Vector is not None:
            outfile.write('Temporal_Vector=%s,\n' % quote_python(self.Temporal_Vector).encode(ExternalEncoding))
        if self.Environmental_Score is not None:
            outfile.write('Environmental_Score=%s,\n' % quote_python(self.Environmental_Score).encode(ExternalEncoding))
        if self.Environmental_Vector is not None:
            outfile.write('Environmental_Vector=%s,\n' % quote_python(self.Environmental_Vector).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Overall_Score':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Overall_Score')
            self.set_Overall_Score(text_)
        elif nodeName_ == 'Base_Score':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Base_Score')
            self.set_Base_Score(text_)
        elif nodeName_ == 'Base_Vector':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Base_Vector')
            self.set_Base_Vector(text_)
        elif nodeName_ == 'Temporal_Score':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Temporal_Score')
            self.set_Temporal_Score(text_)
        elif nodeName_ == 'Temporal_Vector':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Temporal_Vector')
            self.set_Temporal_Vector(text_)
        elif nodeName_ == 'Environmental_Score':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Environmental_Score')
            self.set_Environmental_Score(text_)
        elif nodeName_ == 'Environmental_Vector':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Environmental_Vector')
            self.set_Environmental_Vector(text_)
# end class CVSSVectorType

class PotentialCOAsType(stix_common_binding.GenericRelationshipListType):
    subclass = None
    superclass = stix_common_binding.GenericRelationshipListType
    def __init__(self, scope='exclusive', Potential_COA=None):
        super(PotentialCOAsType, self).__init__(scope, )
        if Potential_COA is None:
            self.Potential_COA = []
        else:
            self.Potential_COA = Potential_COA
    def factory(*args_, **kwargs_):
        if PotentialCOAsType.subclass:
            return PotentialCOAsType.subclass(*args_, **kwargs_)
        else:
            return PotentialCOAsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Potential_COA(self): return self.Potential_COA
    def set_Potential_COA(self, Potential_COA): self.Potential_COA = Potential_COA
    def add_Potential_COA(self, value): self.Potential_COA.append(value)
    def insert_Potential_COA(self, index, value): self.Potential_COA[index] = value
    def hasContent_(self):
        if (
            self.Potential_COA or
            super(PotentialCOAsType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='PotentialCOAsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PotentialCOAsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='et:', name_='PotentialCOAsType'):
        super(PotentialCOAsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PotentialCOAsType')
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='PotentialCOAsType', fromsubclass_=False, pretty_print=True):
        super(PotentialCOAsType, self).exportChildren(outfile, level, nsmap, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Potential_COA_ in self.Potential_COA:
            Potential_COA_.export(outfile, level, nsmap, namespace_, name_='Potential_COA', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PotentialCOAsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(PotentialCOAsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(PotentialCOAsType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Potential_COA=[\n')
        level += 1
        for Potential_COA_ in self.Potential_COA:
            outfile.write('model_.stix_common_binding.RelatedCourseOfActionType(\n')
            Potential_COA_.exportLiteral(outfile, level, name_='stix_common_binding.RelatedCourseOfActionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(PotentialCOAsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Potential_COA':
            obj_ = stix_common_binding.RelatedCourseOfActionType.factory()
            obj_.build(child_)
            self.Potential_COA.append(obj_)
        super(PotentialCOAsType, self).buildChildren(child_, node, nodeName_, True)
# end class PotentialCOAsType

class ExploitTargetType(stix_common_binding.ExploitTargetBaseType):
    """Specifies the relevant STIX-ExploitTarget schema version for this
    content."""
    subclass = None
    superclass = stix_common_binding.ExploitTargetBaseType
    def __init__(self, idref=None, id=None, version='1.0', Title=None, Vulnerability=None, Weakness=None, Configuration=None, Potential_COAs=None, Information_Source=None, Handling=None):
        super(ExploitTargetType, self).__init__(idref, id, )
        self.xmlns          = "http://stix.mitre.org/ExploitTarget-1"
        self.xmlns_prefix   = "et"
        self.xml_type       = "ExploitTargetType"
        self.version = _cast(None, version)
        self.Title = Title
        if Vulnerability is None:
            self.Vulnerability = []
        else:
            self.Vulnerability = Vulnerability
        if Weakness is None:
            self.Weakness = []
        else:
            self.Weakness = Weakness
        if Configuration is None:
            self.Configuration = []
        else:
            self.Configuration = Configuration
        self.Potential_COAs = Potential_COAs
        self.Information_Source = Information_Source
        self.Handling = Handling
    def factory(*args_, **kwargs_):
        if ExploitTargetType.subclass:
            return ExploitTargetType.subclass(*args_, **kwargs_)
        else:
            return ExploitTargetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Title(self): return self.Title
    def set_Title(self, Title): self.Title = Title
    def get_Vulnerability(self): return self.Vulnerability
    def set_Vulnerability(self, Vulnerability): self.Vulnerability = Vulnerability
    def add_Vulnerability(self, value): self.Vulnerability.append(value)
    def insert_Vulnerability(self, index, value): self.Vulnerability[index] = value
    def get_Weakness(self): return self.Weakness
    def set_Weakness(self, Weakness): self.Weakness = Weakness
    def add_Weakness(self, value): self.Weakness.append(value)
    def insert_Weakness(self, index, value): self.Weakness[index] = value
    def get_Configuration(self): return self.Configuration
    def set_Configuration(self, Configuration): self.Configuration = Configuration
    def add_Configuration(self, value): self.Configuration.append(value)
    def insert_Configuration(self, index, value): self.Configuration[index] = value
    def get_Potential_COAs(self): return self.Potential_COAs
    def set_Potential_COAs(self, Potential_COAs): self.Potential_COAs = Potential_COAs
    def get_Information_Source(self): return self.Information_Source
    def set_Information_Source(self, Information_Source): self.Information_Source = Information_Source
    def get_Handling(self): return self.Handling
    def set_Handling(self, Handling): self.Handling = Handling
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def hasContent_(self):
        if (
            self.Title is not None or
            self.Vulnerability or
            self.Weakness or
            self.Configuration or
            self.Potential_COAs is not None or
            self.Information_Source is not None or
            self.Handling is not None or
            super(ExploitTargetType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='ExploitTargetType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExploitTargetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='et:', name_='ExploitTargetType'):
        super(ExploitTargetType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ExploitTargetType')
        if 'xmlns' not in already_processed:
            already_processed.add('xmlns')
            xmlns = " xmlns:%s='%s'" % (self.xmlns_prefix, self.xmlns)
            outfile.write(xmlns)   
        if 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            xsi_type = " xsi:type='%s:%s'" % (self.xmlns_prefix, self.xml_type)
            outfile.write(xsi_type)
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (quote_attrib(self.version), ))
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='ExploitTargetType', fromsubclass_=False, pretty_print=True):
        super(ExploitTargetType, self).exportChildren(outfile, level, nsmap, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%s:Title>%s</%s:Title>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.Title).encode(ExternalEncoding), input_name='Title'), nsmap[namespace_], eol_))
        for Vulnerability_ in self.Vulnerability:
            Vulnerability_.export(outfile, level, nsmap, namespace_, name_='Vulnerability', pretty_print=pretty_print)
        for Weakness_ in self.Weakness:
            Weakness_.export(outfile, level, nsmap, namespace_, name_='Weakness', pretty_print=pretty_print)
        for Configuration_ in self.Configuration:
            Configuration_.export(outfile, level, nsmap, namespace_, name_='Configuration', pretty_print=pretty_print)
        if self.Potential_COAs is not None:
            self.Potential_COAs.export(outfile, level, nsmap, namespace_, name_='Potential_COAs', pretty_print=pretty_print)
        if self.Information_Source is not None:
            self.Information_Source.export(outfile, level, nsmap, namespace_, name_='Information_Source', pretty_print=pretty_print)
        if self.Handling is not None:
            self.Handling.export(outfile, level, nsmap, namespace_, name_='Handling', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ExploitTargetType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            showIndent(outfile, level)
            outfile.write('version = %s,\n' % (self.version,))
        super(ExploitTargetType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ExploitTargetType, self).exportLiteralChildren(outfile, level, name_)
        if self.Title is not None:
            showIndent(outfile, level)
            outfile.write('Title=%s,\n' % quote_python(self.Title).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('Vulnerability=[\n')
        level += 1
        for Vulnerability_ in self.Vulnerability:
            outfile.write('model_.VulnerabilityType(\n')
            Vulnerability_.exportLiteral(outfile, level, name_='VulnerabilityType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Weakness=[\n')
        level += 1
        for Weakness_ in self.Weakness:
            outfile.write('model_.WeaknessType(\n')
            Weakness_.exportLiteral(outfile, level, name_='WeaknessType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Configuration=[\n')
        level += 1
        for Configuration_ in self.Configuration:
            outfile.write('model_.ConfigurationType(\n')
            Configuration_.exportLiteral(outfile, level, name_='ConfigurationType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Potential_COAs is not None:
            outfile.write('Potential_COAs=model_.PotentialCOAsType(\n')
            self.Potential_COAs.exportLiteral(outfile, level, name_='Potential_COAs')
            outfile.write('),\n')
        if self.Information_Source is not None:
            outfile.write('Information_Source=model_.stix_common_binding.InformationSourceType(\n')
            self.Information_Source.exportLiteral(outfile, level, name_='Information_Source')
            outfile.write('),\n')
        if self.Handling is not None:
            outfile.write('Handling=model_.data_marking_binding.MarkingType(\n')
            self.Handling.exportLiteral(outfile, level, name_='Handling')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
        super(ExploitTargetType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Title':
            Title_ = child_.text
            Title_ = self.gds_validate_string(Title_, node, 'Title')
            self.Title = Title_
        elif nodeName_ == 'Vulnerability':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                    
                if type_name_ == "CVRF1.1InstanceType":
                    import stix.bindings.extensions.vulnerability.cvrf_1_1 as cvrf_1_1_binding
                    obj_ = cvrf_1_1_binding.CVRF1_1InstanceType.factory()
                else:
                    raise NotImplementedError('No implementation class for Vulnerability: ' + type_name_)
            else:
                obj_ = VulnerabilityType.factory() # VulnerabilityType not abstract
            
            obj_.build(child_)
            self.Vulnerability.append(obj_)
        elif nodeName_ == 'Weakness':
            obj_ = WeaknessType.factory()
            obj_.build(child_)
            self.Weakness.append(obj_)
        elif nodeName_ == 'Configuration':
            obj_ = ConfigurationType.factory()
            obj_.build(child_)
            self.Configuration.append(obj_)
        elif nodeName_ == 'Potential_COAs':
            obj_ = PotentialCOAsType.factory()
            obj_.build(child_)
            self.set_Potential_COAs(obj_)
        elif nodeName_ == 'Information_Source':
            obj_ = stix_common_binding.InformationSourceType.factory()
            obj_.build(child_)
            self.set_Information_Source(obj_)
        elif nodeName_ == 'Handling':
            obj_ = data_marking_binding.MarkingType.factory()
            obj_.build(child_)
            self.set_Handling(obj_)
        super(ExploitTargetType, self).buildChildren(child_, node, nodeName_, True)
# end class ExploitTargetType

GDSClassesMapping = {
    'Information_Source': stix_common_binding.InformationSourceType,
    'Indicator': stix_common_binding.IndicatorBaseType,
    'Exploit_Target': stix_common_binding.ExploitTargetBaseType,
    'Incident': stix_common_binding.IncidentBaseType,
    'Information_Source_Type': stix_common_binding.ControlledVocabularyStringType,
    'Confidence_Assertion_Chain': stix_common_binding.ConfidenceAssertionChainType,
    'Confidence_Assertion': stix_common_binding.ConfidenceType,
    'Campaign': stix_common_binding.CampaignBaseType,
    'Encoding': stix_common_binding.ControlledVocabularyStringType,
    'Source': stix_common_binding.ControlledVocabularyStringType,
    'State': stix_common_binding.ControlledVocabularyStringType,
    'Marking_Structure': data_marking_binding.MarkingStructureType,
    'Type': stix_common_binding.ControlledVocabularyStringType,
    'Tool_Type': stix_common_binding.ControlledVocabularyStringType,
    'Relationship': stix_common_binding.ControlledVocabularyStringType,
    'TTP': stix_common_binding.TTPBaseType,
    'Course_Of_Action': stix_common_binding.CourseOfActionBaseType,
    'Potential_COA': stix_common_binding.RelatedCourseOfActionType,
    'Reference_Description': stix_common_binding.StructuredTextType,
    'Association_Type': stix_common_binding.ControlledVocabularyStringType,
    'Marking': data_marking_binding.MarkingSpecificationType,
    'Related_Identities': stix_common_binding.RelatedIdentitiesType,
    'Identity': stix_common_binding.IdentityType,
    'Usage_Context_Assumption': stix_common_binding.StructuredTextType,
    'Threat_Actor': stix_common_binding.ThreatActorBaseType,
    'Confidence': stix_common_binding.ConfidenceType,
    'Kill_Chain': stix_common_binding.KillChainType,
    'Description': stix_common_binding.StructuredTextType,
    'Handling': data_marking_binding.MarkingType,
    'Name': stix_common_binding.ControlledVocabularyStringType,
    'Kill_Chain_Phase': stix_common_binding.KillChainPhaseReferenceType,
    'Related_Identity': stix_common_binding.RelatedIdentityType,
    'Argument_Name': stix_common_binding.ControlledVocabularyStringType,
    'Dependency_Description': stix_common_binding.StructuredTextType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Exploit_Target'
        rootClass = ExploitTargetType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Exploit_Target'
        rootClass = ExploitTargetType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Exploit_Target'
        rootClass = ExploitTargetType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="Exploit_Target",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Exploit_Target'
        rootClass = ExploitTargetType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from exploit_target import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import exploit_target as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "VulnerabilityType",
    "ConfigurationType",
    "WeaknessType",
    "CVSSVectorType",
    "PotentialCOAsType",
    "ExploitTargetType"
    ]