# This file was auto-generated by zetup
#
# https://bitbucket.org/userzimmermann/zetup.py


from __future__ import absolute_import

import sys
import os
from collections import OrderedDict

from zetup.version import Version
from zetup.dist import Distribution
from zetup.requires import Requirements
from zetup.extras import Extras
from zetup.package import Packages, Package
from zetup.notebook import Notebook



zfg = sys.modules[__name__]

NAME = 'robotframework-tools'

LICENSE = 'GPLv3'

TITLE = 'robotframework-tools'

PYTHON = ['2.7', '3.3', '3.4']

MODULES = ['ToolsLibrary']

FORCE_MAKE = True

KEYWORDS = ['robottools', 'robot', 'framework', 'robotframework', 'tools', 'test', 'automation', 'testautomation', 'testlibrary', 'testcase', 'keyword', 'pybot', 'robotshell', 'ipython', 'python3']

PACKAGES = Packages([

Package('robottools',
  sources=[
    '__init__.py'
    ],
  subpackages=[
    
Package('robottools.libdoc',
  sources=[
    'html.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library',
  sources=[
    'base.py',
    '__init__.py'
    ],
  subpackages=[
    
Package('robottools.library.context',
  sources=[
    'method.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library.inspector',
  sources=[
    'arguments.py',
    'keyword.py',
    'multi.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library.keywords',
  sources=[
    'deco.py',
    'errors.py',
    'utils.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.library.session',
  sources=[
    'meta.py',
    'metaoptions.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )
,
    
Package('robottools.remote',
  sources=[
    'keywords.py',
    'library.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.testrobot',
  sources=[
    'context.py',
    'highlighting.py',
    'keyword.py',
    'library.py',
    'output.py',
    'result.py',
    'variables.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )
,
    
Package('robottools.utils',
  sources=[
    'normbool.py',
    'normdict.py',
    'normstr.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )
,
  
Package('robotshell',
  sources=[
    'base.py',
    'extension.py',
    'library.py',
    'result.py',
    'shell.py',
    '__init__.py'
    ],
  subpackages=[
    
Package('robotshell.magic',
  sources=[
    'base.py',
    'keyword.py',
    'robot.py',
    'variable.py',
    '__init__.py'
    ],
  subpackages=[
    
    ],
  )

    ],
  )

  ], root=os.path.dirname(os.path.dirname(os.path.realpath(__file__))))

EMAIL = 'zimmermann.code@gmail.com'

AUTHOR = 'Stefan Zimmermann'

REQUIRES = Requirements("""
zetup >= 0.2.31
six >= 1.10
path.py >= 8.0 #import path
moretools >= 0.1.8
modeled >= 0.1.8

""", zfg=zfg)

URL = 'http://bitbucket.org/userzimmermann/robotframework-tools'

SETUP_HOOKS = []

VERSION = Version('0.1a141')

KEEP_MADE = ['setup.py', 'tox.ini']

NO_MAKE = ['VERSION', 'tox.ini']

TEST_COMMANDS = ['py.test -v test']

DESCRIPTION = 'Python Tools for Robot Framework and Test Libraries.'

SETUP_REQUIRES = None

EXTRAS = Extras([
('remote', Requirements("""
robotremoteserver >= 1.0.1

""")),
('robotshell', Requirements("""
ipython >= 4.0 #import IPython

"""))
], zfg=zfg)

SCRIPTS = None

SETUP_KEYWORDS = None

DISTRIBUTION = Distribution(zfg)

CLASSIFIERS = ['Development Status :: 3 - Alpha', 'Intended Audience :: Developers', 'License :: OSI Approved :: GNU General Public License (GPL)', 'Operating System :: OS Independent', 'Topic :: Software Development', 'Topic :: Utilities', 'Programming Language :: Python', 'Programming Language :: Python :: 2.7', 'Programming Language :: Python :: 3.3', 'Programming Language :: Python :: 3.4']