
# -*- coding: utf-8 -*-

u'''Coeficients for C{_AUXLATITUDE_ORDER} 8 from I{Karney}'s C++ class U{AuxLatitude
<https://GeographicLib.SourceForge.io/C++/doc/classGeographicLib_1_1AuxLatitude.html>}
trancoded to a double, uniquified Python C{dict[auxout][auxin]}.

Copyright (C) Charles Karney (2022-2023) Karney@Alum.MIT.edu> and licensed under the
MIT/X11 License.  For more information, see <https:#GeographicLib.SourceForge.io>.
'''
# make sure int/int division yields float quotient
from __future__ import division as _; del _  # PYCHOK semicolon

from pygeodesy.auxilats.auxily import Aux, _Ufloats
from pygeodesy.constants import _0_0, _0_125, _0_25, _0_5, _1_0, _N_1_0, _1_5, \
                                _2_0, _N_2_0, _4_0, _6_0, _8_0, _16_0, _32_0

__all__ = ()
__version__ = '23.08.19'

_f, _u = float, _Ufloats()
_coeffs_8 = _u._Coeffs(8, {  # GEOGRAPHICLIB_AUXLATITUDE_ORDER == 8
    Aux.PHI: {
        # C[phi,phi] skipped
        Aux.BETA: _u(  # C[phi,beta]; even coeffs only
            _0_0, _0_0, _0_0, _1_0,
            _0_0, _0_0, _0_0, _0_5,
            _0_0, _0_0, 1 / _f(3),
            _0_0, _0_0, _0_25,
            _0_0, 1 / _f(5),
            _0_0, 1 / _f(6),
            1 / _f(7),
            _0_125,),
        Aux.THETA: _u(  # C[phi,theta]; even coeffs only
            _N_2_0, _2_0, _N_2_0, _2_0,
            -_8_0, _6_0, -_4_0, _2_0,
            _16_0, -_8_0, 8 / _f(3),
            40, -_16_0, _4_0,
            -_32_0, 32 / _f(5),
            -64, 32 / _f(3),
            128 / _f(7),
            _32_0,),
        Aux.MU: _u(  # C[phi,mu]; even coeffs only
            -6607 / _f(24576), 269 / _f(512), -27 / _f(32), _1_5,
            -155113 / _f(122880), 6759 / _f(4096), -55 / _f(32), 21 / _f(16),
            87963 / _f(20480), -417 / _f(128), 151 / _f(96),
            2514467 / _f(245760), -15543 / _f(2560), 1097 / _f(512),
            -69119 / _f(6144), 8011 / _f(2560),
            -5962461 / _f(286720), 293393 / _f(61440),
            6459601 / _f(860160),
            332287993 / _f(27525120),),
        Aux.CHI: _u(  # C[phi,chi]
            189416 / _f(99225), 16822 / _f(4725), -2854 / _f(675), 26 / _f(45),
            116 / _f(45), _N_2_0, -2 / _f(3), _2_0,
            141514 / _f(8505), -31256 / _f(1575), 2323 / _f(945), 2704 / _f(315),
            -227 / _f(45), -8 / _f(5), 7 / _f(3),
            -2363828 / _f(31185), 98738 / _f(14175), 73814 / _f(2835),
            -1262 / _f(105), -136 / _f(35), 56 / _f(15),
            14416399 / _f(935550), 11763988 / _f(155925), -399572 / _f(14175),
            -332 / _f(35), 4279 / _f(630),
            258316372 / _f(1216215), -2046082 / _f(31185), -144838 / _f(6237),
            4174 / _f(315),
            -2155215124 / _f(14189175), -115444544 / _f(2027025),
            601676 / _f(22275),
            -170079376 / _f(1216215), 38341552 / _f(675675),
            1383243703 / _f(11351340),),
        Aux.XI: _u(  # C[phi,xi]
            -1683291094 / _f(37574026875), 22947844 / _f(1915538625),
            28112932 / _f(212837625), 60136 / _f(467775), -2582 / _f(14175),
            -16 / _f(35), 4 / _f(45), 4 / _f(3),
            -14351220203 / _f(488462349375), 1228352 / _f(3007125),
            251310128 / _f(638512875), -21016 / _f(51975), -11966 / _f(14175),
            152 / _f(945), 46 / _f(45),
            505559334506 / _f(488462349375), 138128272 / _f(147349125),
            -8797648 / _f(10945935), -94388 / _f(66825), 3802 / _f(14175),
            3044 / _f(2835),
            973080708361 / _f(488462349375), -45079184 / _f(29469825),
            -1472637812 / _f(638512875), 41072 / _f(93555), 6059 / _f(4725),
            -1385645336626 / _f(488462349375), -550000184 / _f(147349125),
            455935736 / _f(638512875), 768272 / _f(467775),
            -2939205114427 / _f(488462349375), 443810768 / _f(383107725),
            4210684958 / _f(1915538625),
            101885255158 / _f(54273594375), 387227992 / _f(127702575),
            1392441148867 / _f(325641566250),)
    },
    Aux.BETA: {
        Aux.PHI: _u(  # C[beta,phi]; even coeffs only
            _0_0, _0_0, _0_0, _N_1_0,
            _0_0, _0_0, _0_0, _0_5,
            _0_0, _0_0, -1 / _f(3),
            _0_0, _0_0, _0_25,
            _0_0, -1 / _f(5),
            _0_0, 1 / _f(6),
            -1 / _f(7),
            _0_125,),
        # C[beta,beta] skipped
        Aux.THETA: _u(  # C[beta,theta]; even coeffs only
            _0_0, _0_0, _0_0, _1_0,
            _0_0, _0_0, _0_0, _0_5,
            _0_0, _0_0, 1 / _f(3),
            _0_0, _0_0, _0_25,
            _0_0, 1 / _f(5),
            _0_0, 1 / _f(6),
            1 / _f(7),
            _0_125,),
        Aux.MU: _u(  # C[beta,mu]; even coeffs only
            -4879 / _f(73728), 205 / _f(1536), -9 / _f(32), _0_5,
            -86171 / _f(368640), 1335 / _f(4096), -37 / _f(96), 5 / _f(16),
            2901 / _f(4096), -75 / _f(128), 29 / _f(96),
            1082857 / _f(737280), -2391 / _f(2560), 539 / _f(1536),
            -28223 / _f(18432), 3467 / _f(7680),
            -733437 / _f(286720), 38081 / _f(61440),
            459485 / _f(516096),
            109167851 / _f(82575360),),
        Aux.CHI: _u(  # C[beta,chi]
            -25666 / _f(99225), 4769 / _f(4725), -3118 / _f(4725), -1 / _f(3),
            38 / _f(45), -1 / _f(3), -2 / _f(3), _1_0,
            193931 / _f(42525), -14404 / _f(4725), -247 / _f(270), 50 / _f(21),
            -7 / _f(9), -14 / _f(15), 5 / _f(6),
            -1709614 / _f(155925), -36521 / _f(14175), 17564 / _f(2835), -5 / _f(3),
            -34 / _f(21), 16 / _f(15),
            -637699 / _f(85050), 2454416 / _f(155925), -49877 / _f(14175),
            -28 / _f(9), 2069 / _f(1260),
            48124558 / _f(1216215), -20989 / _f(2835), -28244 / _f(4455),
            883 / _f(315),
            -16969807 / _f(1091475), -2471888 / _f(184275), 797222 / _f(155925),
            -1238578 / _f(42525), 2199332 / _f(225225),
            87600385 / _f(4540536),),
        Aux.XI: _u(  # C[beta,xi]
            -5946082372 / _f(488462349375), 9708931 / _f(1915538625),
            7947332 / _f(212837625), 11824 / _f(467775), -1082 / _f(14175),
            -46 / _f(315), 4 / _f(45), 1 / _f(3),
            190673521 / _f(69780335625), 164328266 / _f(1915538625),
            39946703 / _f(638512875), -16672 / _f(155925), -338 / _f(2025),
            68 / _f(945), 17 / _f(90),
            86402898356 / _f(488462349375), 236067184 / _f(1915538625),
            -255454 / _f(1563705), -101069 / _f(467775), 1102 / _f(14175),
            461 / _f(2835),
            110123070361 / _f(488462349375), -98401826 / _f(383107725),
            -189032762 / _f(638512875), 1786 / _f(18711), 3161 / _f(18900),
            -200020620676 / _f(488462349375), -802887278 / _f(1915538625),
            80274086 / _f(638512875), 88868 / _f(467775),
            -296107325077 / _f(488462349375), 66263486 / _f(383107725),
            880980241 / _f(3831077250),
            4433064236 / _f(18091198125), 37151038 / _f(127702575),
            495248998393 / _f(1302566265000),)
    },
    Aux.THETA: {
        Aux.PHI: _u(  # C[theta,phi]; even coeffs only
            _2_0, _N_2_0, _2_0, _N_2_0,
            -_8_0, _6_0, -_4_0, _2_0,
            -_16_0, _8_0, -8 / _f(3),
            40, -_16_0, _4_0,
            _32_0, -32 / _f(5),
            -64, 32 / _f(3),
            -128 / _f(7),
            _32_0,),
        Aux.BETA: _u(  # C[theta,beta]; even coeffs only
            _0_0, _0_0, _0_0, _N_1_0,
            _0_0, _0_0, _0_0, _0_5,
            _0_0, _0_0, -1 / _f(3),
            _0_0, _0_0, _0_25,
            _0_0, -1 / _f(5),
            _0_0, 1 / _f(6),
            -1 / _f(7),
            _0_125,),
        # C[theta,theta] skipped
        Aux.MU: _u(  # C[theta,mu]; even coeffs only
            -14321 / _f(73728), 499 / _f(1536), -23 / _f(32), -1 / _f(2),
            -201467 / _f(368640), 6565 / _f(12288), -5 / _f(96), 5 / _f(16),
            2939 / _f(4096), -77 / _f(128), 1 / _f(32),
            1155049 / _f(737280), -4037 / _f(7680), 283 / _f(1536),
            -19465 / _f(18432), 1301 / _f(7680),
            -442269 / _f(286720), 17089 / _f(61440),
            198115 / _f(516096),
            48689387 / _f(82575360),),
        Aux.CHI: _u(  # C[theta,chi]
            64424 / _f(99225), 76 / _f(225), -3658 / _f(4725), 2 / _f(9), 4 / _f(9),
            -2 / _f(3), -2 / _f(3), _0_0,
            2146 / _f(1215), -2728 / _f(945), 61 / _f(135), 68 / _f(45),
            -23 / _f(45), -4 / _f(15), 1 / _f(3),
            -95948 / _f(10395), 428 / _f(945), 9446 / _f(2835), -46 / _f(35),
            -24 / _f(35), 2 / _f(5),
            29741 / _f(85050), 4472 / _f(525), -34712 / _f(14175), -80 / _f(63),
            83 / _f(126),
            280108 / _f(13365), -17432 / _f(3465), -2362 / _f(891), 52 / _f(45),
            -48965632 / _f(4729725), -548752 / _f(96525), 335882 / _f(155925),
            -197456 / _f(15795), 51368 / _f(12285),
            1461335 / _f(174636),),
        Aux.XI: _u(  # C[theta,xi]
            -230886326 / _f(6343666875), -189115382 / _f(1915538625),
            216932 / _f(2627625), 109042 / _f(467775), -2102 / _f(14175),
            -158 / _f(315), 4 / _f(45), -2 / _f(3),
            -11696145869 / _f(69780335625), 288456008 / _f(1915538625),
            117952358 / _f(638512875), -7256 / _f(155925), 934 / _f(14175),
            -16 / _f(945), 16 / _f(45),
            91546732346 / _f(488462349375), 478700902 / _f(1915538625),
            -7391576 / _f(54729675), -25286 / _f(66825), 922 / _f(14175),
            -232 / _f(2835),
            218929662961 / _f(488462349375), -67330724 / _f(383107725),
            -67048172 / _f(638512875), 268 / _f(18711), 719 / _f(4725),
            -129039188386 / _f(488462349375), -117954842 / _f(273648375),
            46774256 / _f(638512875), 14354 / _f(467775),
            -178084928947 / _f(488462349375), 2114368 / _f(34827975),
            253129538 / _f(1915538625),
            6489189398 / _f(54273594375), 13805944 / _f(127702575),
            59983985827 / _f(325641566250),)
    },
    Aux.MU: {
        Aux.PHI: _u(  # C[mu,phi]; even coeffs only
            57 / _f(2048), -3 / _f(32), 9 / _f(16), -3 / _f(2),
            -105 / _f(4096), 135 / _f(2048), -15 / _f(32), 15 / _f(16),
            -105 / _f(2048), 105 / _f(256), -35 / _f(48),
            693 / _f(16384), -189 / _f(512), 315 / _f(512),
            693 / _f(2048), -693 / _f(1280),
            -1287 / _f(4096), 1001 / _f(2048),
            -6435 / _f(14336),
            109395 / _f(262144),),
        Aux.BETA: _u(  # C[mu,beta]; even coeffs only
            19 / _f(2048), -1 / _f(32), 3 / _f(16), -1 / _f(2),
            7 / _f(4096), -9 / _f(2048), 1 / _f(32), -1 / _f(16),
            -3 / _f(2048), 3 / _f(256), -1 / _f(48),
            -11 / _f(16384), 3 / _f(512), -5 / _f(512),
            7 / _f(2048), -7 / _f(1280),
            9 / _f(4096), -7 / _f(2048),
            -33 / _f(14336),
            -429 / _f(262144),),
        Aux.THETA: _u(  # C[mu,theta]; even coeffs only
            509 / _f(2048), -15 / _f(32), 13 / _f(16), _0_5,
            2599 / _f(4096), -1673 / _f(2048), 33 / _f(32), -1 / _f(16),
            -2989 / _f(2048), 349 / _f(256), -5 / _f(16),
            -43531 / _f(16384), 963 / _f(512), -261 / _f(512),
            5545 / _f(2048), -921 / _f(1280),
            16617 / _f(4096), -6037 / _f(6144),
            -19279 / _f(14336),
            -490925 / _f(262144),),
        # C[mu,mu] skipped
        Aux.CHI: _u(  # C[mu,chi]
            -18975107 / _f(50803200), 72161 / _f(387072), 7891 / _f(37800),
            -127 / _f(288), 41 / _f(180), 5 / _f(16), -2 / _f(3), _0_5,
            148003883 / _f(174182400), 13769 / _f(28800), -1983433 / _f(1935360),
            281 / _f(630), 557 / _f(1440), -3 / _f(5), 13 / _f(48),
            79682431 / _f(79833600), -67102379 / _f(29030400), 167603 / _f(181440),
            15061 / _f(26880), -103 / _f(140), 61 / _f(240),
            -40176129013 / _f(7664025600), 97445 / _f(49896),
            6601661 / _f(7257600), -179 / _f(168), 49561 / _f(161280),
            2605413599 / _f(622702080), 14644087 / _f(9123840),
            -3418889 / _f(1995840), 34729 / _f(80640),
            175214326799 / _f(58118860800), -30705481 / _f(10378368),
            212378941 / _f(319334400),
            -16759934899 / _f(3113510400), 1522256789 / _f(1383782400),
            1424729850961 / _f(743921418240),),
        Aux.XI: _u(  # C[mu,xi]
            -375027460897 / _f(125046361440000),
            7183403063 / _f(560431872000), 12674323 / _f(851350500),
            -384229 / _f(14968800), -1609 / _f(28350), 121 / _f(1680), 4 / _f(45),
            -1 / _f(6),
            30410873385097 / _f(2000741783040000),
            1117820213 / _f(122594472000), -31621753811 / _f(1307674368000),
            -431 / _f(17325), 16463 / _f(453600), 26 / _f(945), -29 / _f(720),
            151567502183 / _f(17863765920000),
            -116359346641 / _f(3923023104000), -32844781 / _f(1751349600),
            3746047 / _f(119750400), 449 / _f(28350), -1003 / _f(45360),
            -317251099510901 / _f(8002967132160000), -13060303 / _f(766215450),
            10650637121 / _f(326918592000), 629 / _f(53460),
            -40457 / _f(2419200),
            -2105440822861 / _f(125046361440000),
            146875240637 / _f(3923023104000), 205072597 / _f(20432412000),
            -1800439 / _f(119750400),
            91496147778023 / _f(2000741783040000), 228253559 / _f(24518894400),
            -59109051671 / _f(3923023104000),
            126430355893 / _f(13894040160000),
            -4255034947 / _f(261534873600),
            -791820407649841 / _f(42682491371520000),)
    },
    Aux.CHI: {
        Aux.PHI: _u(  # C[chi,phi]
            1514 / _f(1323), -8384 / _f(4725), 4642 / _f(4725), 32 / _f(45),
            -82 / _f(45), 4 / _f(3), 2 / _f(3), _N_2_0,
            142607 / _f(42525), -2288 / _f(1575), -1522 / _f(945), 904 / _f(315),
            -13 / _f(9), -16 / _f(15), 5 / _f(3),
            120202 / _f(51975), 44644 / _f(14175), -12686 / _f(2835), 8 / _f(5),
            34 / _f(21), -26 / _f(15),
            -1097407 / _f(187110), 1077964 / _f(155925), -24832 / _f(14175),
            -12 / _f(5), 1237 / _f(630),
            -12870194 / _f(1216215), 1040 / _f(567), 109598 / _f(31185),
            -734 / _f(315),
            -126463 / _f(72765), -941912 / _f(184275), 444337 / _f(155925),
            3463678 / _f(467775), -2405834 / _f(675675),
            256663081 / _f(56756700),),
        Aux.BETA: _u(  # C[chi,beta]
            1384 / _f(11025), -34 / _f(4725), -998 / _f(4725), 2 / _f(5),
            -16 / _f(45), _0_0, 2 / _f(3), _N_1_0,
            -12616 / _f(42525), 1268 / _f(4725), -2 / _f(27), -22 / _f(105),
            19 / _f(45), -2 / _f(5), 1 / _f(6),
            1724 / _f(51975), -1858 / _f(14175), 116 / _f(567), -22 / _f(105),
            16 / _f(105), -1 / _f(15),
            115249 / _f(935550), -26836 / _f(155925), 2123 / _f(14175), -8 / _f(105),
            17 / _f(1260),
            140836 / _f(1216215), -424 / _f(6237), 128 / _f(4455), -1 / _f(105),
            210152 / _f(4729725), -31232 / _f(2027025), 149 / _f(311850),
            30208 / _f(6081075), -499 / _f(225225),
            -68251 / _f(113513400),),
        Aux.THETA: _u(  # C[chi,theta]
            -1738 / _f(11025), 18 / _f(175), 1042 / _f(4725), -14 / _f(45),
            -2 / _f(9), 2 / _f(3), 2 / _f(3), _0_0,
            23159 / _f(42525), 332 / _f(945), -712 / _f(945), -4 / _f(45),
            43 / _f(45), 4 / _f(15), -1 / _f(3),
            13102 / _f(31185), -1352 / _f(945), 274 / _f(2835), 124 / _f(105),
            2 / _f(105), -2 / _f(5),
            -2414843 / _f(935550), 1528 / _f(4725), 21068 / _f(14175), -16 / _f(105),
            -55 / _f(126),
            60334 / _f(93555), 20704 / _f(10395), -9202 / _f(31185), -22 / _f(45),
            40458083 / _f(14189175), -299444 / _f(675675), -90263 / _f(155925),
            -3818498 / _f(6081075), -8962 / _f(12285),
            -4259027 / _f(4365900),),
        Aux.MU: _u(  # C[chi,mu]
            -7944359 / _f(67737600), 5406467 / _f(38707200), -96199 / _f(604800),
            81 / _f(512), 1 / _f(360), -37 / _f(96), 2 / _f(3), -1 / _f(2),
            -24749483 / _f(348364800), -51841 / _f(1209600), 1118711 / _f(3870720),
            -46 / _f(105), 437 / _f(1440), -1 / _f(15), -1 / _f(48),
            6457463 / _f(17740800), -9261899 / _f(58060800), -5569 / _f(90720),
            209 / _f(4480), 37 / _f(840), -17 / _f(480),
            -324154477 / _f(7664025600), -466511 / _f(2494800),
            830251 / _f(7257600), 11 / _f(504), -4397 / _f(161280),
            -22894433 / _f(124540416), 8005831 / _f(63866880), 108847 / _f(3991680),
            -4583 / _f(161280),
            2204645983 / _f(12915302400), 16363163 / _f(518918400),
            -20648693 / _f(638668800),
            497323811 / _f(12454041600), -219941297 / _f(5535129600),
            -191773887257 / _f(3719607091200),),
        # C[chi,chi] skipped
        Aux.XI: _u(  # C[chi,xi]
            -17451293242 / _f(488462349375), 308365186 / _f(1915538625),
            -55271278 / _f(212837625), 27128 / _f(93555), -2312 / _f(14175),
            -88 / _f(315), 34 / _f(45), -2 / _f(3),
            -101520127208 / _f(488462349375), 149984636 / _f(1915538625),
            106691108 / _f(638512875), -65864 / _f(155925), 6079 / _f(14175),
            -184 / _f(945), 1 / _f(45),
            10010741462 / _f(37574026875), -99534832 / _f(383107725),
            5921152 / _f(54729675), -14246 / _f(467775), 772 / _f(14175),
            -106 / _f(2835),
            1615002539 / _f(75148053750), -35573728 / _f(273648375),
            75594328 / _f(638512875), -5312 / _f(467775), -167 / _f(9450),
            -3358119706 / _f(488462349375), 130601488 / _f(1915538625),
            2837636 / _f(638512875), -248 / _f(13365),
            46771947158 / _f(488462349375), -3196 / _f(3553875),
            -34761247 / _f(1915538625),
            -18696014 / _f(18091198125), -2530364 / _f(127702575),
            -14744861191 / _f(651283132500),)
    },
    Aux.XI: {
        Aux.PHI: _u(  # C[xi,phi]
            -88002076 / _f(13956067125), -86728 / _f(16372125),
            -44732 / _f(2837835), 20824 / _f(467775), 538 / _f(4725), 88 / _f(315),
            -4 / _f(45), -4 / _f(3),
            -2641983469 / _f(488462349375), -895712 / _f(147349125),
            -12467764 / _f(212837625), -37192 / _f(467775), -2482 / _f(14175),
            8 / _f(105), 34 / _f(45),
            8457703444 / _f(488462349375), 240616 / _f(4209975),
            100320856 / _f(1915538625), 54968 / _f(467775), -898 / _f(14175),
            -1532 / _f(2835),
            -4910552477 / _f(97692469875), -4832848 / _f(147349125),
            -5884124 / _f(70945875), 24496 / _f(467775), 6007 / _f(14175),
            9393713176 / _f(488462349375), 816824 / _f(13395375),
            -839792 / _f(19348875), -23356 / _f(66825),
            -4532926649 / _f(97692469875), 1980656 / _f(54729675),
            570284222 / _f(1915538625),
            -14848113968 / _f(488462349375), -496894276 / _f(1915538625),
            224557742191 / _f(976924698750),),
        Aux.BETA: _u(  # C[xi,beta]
            29232878 / _f(97692469875), -18484 / _f(4343625), -70496 / _f(8513505),
            2476 / _f(467775), 34 / _f(675), 32 / _f(315), -4 / _f(45), -1 / _f(3),
            -324943819 / _f(488462349375), -4160804 / _f(1915538625),
            53836 / _f(212837625), 3992 / _f(467775), 74 / _f(2025), -4 / _f(315),
            -7 / _f(90),
            -168643106 / _f(488462349375), 237052 / _f(383107725),
            -661844 / _f(1915538625), 7052 / _f(467775), 2 / _f(14175),
            -83 / _f(2835),
            113042383 / _f(97692469875), -2915326 / _f(1915538625),
            1425778 / _f(212837625), 934 / _f(467775), -797 / _f(56700),
            -558526274 / _f(488462349375), 6064888 / _f(1915538625),
            390088 / _f(212837625), -3673 / _f(467775),
            155665021 / _f(97692469875), 41288 / _f(29469825),
            -18623681 / _f(3831077250),
            504234982 / _f(488462349375), -6205669 / _f(1915538625),
            -8913001661 / _f(3907698795000),),
        Aux.THETA: _u(  # C[xi,theta]
            182466964 / _f(8881133625), 53702182 / _f(212837625),
            -4286228 / _f(42567525), -193082 / _f(467775), 778 / _f(4725),
            62 / _f(105), -4 / _f(45), 2 / _f(3),
            367082779691 / _f(488462349375), -32500616 / _f(273648375),
            -61623938 / _f(70945875), 92696 / _f(467775), 12338 / _f(14175),
            -32 / _f(315), 4 / _f(45),
            -42668482796 / _f(488462349375), -663111728 / _f(383107725),
            427003576 / _f(1915538625), 612536 / _f(467775), -1618 / _f(14175),
            -524 / _f(2835),
            -327791986997 / _f(97692469875), 421877252 / _f(1915538625),
            427770788 / _f(212837625), -8324 / _f(66825), -5933 / _f(14175),
            74612072536 / _f(488462349375), 6024982024 / _f(1915538625),
            -9153184 / _f(70945875), -320044 / _f(467775),
            489898512247 / _f(97692469875), -46140784 / _f(383107725),
            -1978771378 / _f(1915538625),
            -42056042768 / _f(488462349375), -2926201612 / _f(1915538625),
            -2209250801969 / _f(976924698750),),
        Aux.MU: _u(  # C[xi,mu]
            39534358147 / _f(2858202547200),
            -25359310709 / _f(1743565824000), -9292991 / _f(302702400),
            7764059 / _f(239500800), 1297 / _f(18900), -817 / _f(10080), -4 / _f(45),
            1 / _f(6),
            -13216941177599 / _f(571640509440000),
            -14814966289 / _f(245188944000), 36019108271 / _f(871782912000),
            35474 / _f(467775), -29609 / _f(453600), -2 / _f(35), 49 / _f(720),
            -27782109847927 / _f(250092722880000),
            99871724539 / _f(1569209241600), 3026004511 / _f(30648618000),
            -4306823 / _f(59875200), -2917 / _f(56700), 4463 / _f(90720),
            168979300892599 / _f(1600593426432000),
            2123926699 / _f(15324309000), -368661577 / _f(4036032000),
            -102293 / _f(1871100), 331799 / _f(7257600),
            1959350112697 / _f(9618950880000),
            -493031379277 / _f(3923023104000), -875457073 / _f(13621608000),
            11744233 / _f(239500800),
            -145659994071373 / _f(800296713216000),
            -793693009 / _f(9807557760), 453002260127 / _f(7846046208000),
            -53583096419057 / _f(500185445760000),
            103558761539 / _f(1426553856000),
            _f(12272105438887727) / _f(128047474114560000),),
        Aux.CHI: _u(  # C[xi,chi]
            -64724382148 / _f(97692469875), 16676974 / _f(30405375),
            2706758 / _f(42567525), -55222 / _f(93555), 2458 / _f(4725),
            46 / _f(315), -34 / _f(45), 2 / _f(3),
            85904355287 / _f(37574026875), 158999572 / _f(1915538625),
            -340492279 / _f(212837625), 516944 / _f(467775), 3413 / _f(14175),
            -256 / _f(315), 19 / _f(45),
            2986003168 / _f(37574026875), -7597644214 / _f(1915538625),
            4430783356 / _f(1915538625), 206834 / _f(467775), -15958 / _f(14175),
            248 / _f(567),
            -375566203 / _f(39037950), 851209552 / _f(174139875),
            62016436 / _f(70945875), -832976 / _f(467775), 16049 / _f(28350),
            5106181018156 / _f(488462349375), 3475643362 / _f(1915538625),
            -651151712 / _f(212837625), 15602 / _f(18711),
            34581190223 / _f(8881133625), -10656173804 / _f(1915538625),
            2561772812 / _f(1915538625),
            -5150169424688 / _f(488462349375), 873037408 / _f(383107725),
            7939103697617 / _f(1953849397500),)  # PYCHOK exported
        # C[xi,xi] skipped
    }
})
# _ptrs_8 = (0,   0,  20,  40,  60,  96, 132, 152, 152, 172, 192, 228,
#          264, 284, 304, 304, 324, 360, 396, 416, 436, 456, 456, 492,
#          528, 564, 600, 636, 672, 672, 708, 744, 780, 816, 852, 888,
#          888)  # PYCHOK exported
del _f, _u

# **) MIT License
#
# Copyright (C) 2023-2023 -- mrJean1 at Gmail -- All Rights Reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
