/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.reporting.CheckMessage;
import com.adobe.epubcheck.util.KeyValue;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.XmlReportAbstract;
import java.io.PrintWriter;
import java.util.ArrayList;

public class XmlReportImpl
extends XmlReportAbstract {
    public XmlReportImpl(PrintWriter out, String ePubName, String versionEpubCheck) {
        super(out, ePubName, versionEpubCheck);
    }

    @Override
    public int generateReport() {
        if (this.out == null) {
            return 1;
        }
        int returnCode = 1;
        int ident = 0;
        this.generationDate = XmlReportImpl.fromTime(System.currentTimeMillis());
        try {
            String[] cs;
            this.output(ident, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            ArrayList<KeyValue<String, String>> attrs = new ArrayList<KeyValue<String, String>>();
            attrs.add(KeyValue.with("xmlns", "http://hul.harvard.edu/ois/xml/ns/jhove"));
            attrs.add(KeyValue.with("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
            attrs.add(KeyValue.with("name", this.epubCheckName));
            attrs.add(KeyValue.with("release", this.epubCheckVersion));
            attrs.add(KeyValue.with("date", this.epubCheckDate));
            this.startElement(ident++, "jhove", attrs);
            this.generateElement(ident, "date", this.generationDate);
            this.startElement(ident++, "repInfo", KeyValue.with("uri", this.getNameFromPath(this.getEpubFileName())));
            this.generateElement(ident, "created", this.creationDate);
            this.generateElement(ident, "lastModified", this.lastModifiedDate);
            if (this.formatName == null) {
                this.generateElement(ident, "format", "application/octet-stream");
            } else {
                this.generateElement(ident, "format", this.formatName);
            }
            this.generateElement(ident, "version", this.formatVersion);
            String customMessageFileName = this.getCustomMessageFile();
            if (customMessageFileName != null && !customMessageFileName.isEmpty()) {
                this.generateElement(ident, "customMessageFileName", customMessageFileName);
            }
            if (this.fatalErrors.isEmpty() && this.errors.isEmpty()) {
                this.generateElement(ident, "status", "Well-formed");
            } else {
                this.generateElement(ident, "status", "Not well-formed");
            }
            if (!(this.warns.isEmpty() && this.fatalErrors.isEmpty() && this.errors.isEmpty() && this.hints.isEmpty())) {
                String loc;
                String m;
                this.startElement(ident++, "messages");
                for (CheckMessage c : this.fatalErrors) {
                    m = c.getID() + ", FATAL, [" + XmlReportImpl.encodeContent(c.getMessage()) + "], ";
                    for (EPUBLocation ml : c.getLocations()) {
                        loc = "";
                        if (ml.getLine() > 0 || ml.getColumn() > 0) {
                            loc = " (" + ml.getLine() + "-" + ml.getColumn() + ")";
                        }
                        this.generateElement(ident, "message", m + PathUtil.removeWorkingDirectory(ml.getPath()) + loc);
                    }
                }
                for (CheckMessage c : this.errors) {
                    m = c.getID() + ", ERROR, [" + XmlReportImpl.encodeContent(c.getMessage()) + "], ";
                    for (EPUBLocation ml : c.getLocations()) {
                        loc = "";
                        if (ml.getLine() > 0 || ml.getColumn() > 0) {
                            loc = " (" + ml.getLine() + "-" + ml.getColumn() + ")";
                        }
                        this.generateElement(ident, "message", m + PathUtil.removeWorkingDirectory(ml.getPath()) + loc);
                    }
                }
                for (CheckMessage c : this.warns) {
                    m = c.getID() + ", WARN, [" + XmlReportImpl.encodeContent(c.getMessage()) + "], ";
                    for (EPUBLocation ml : c.getLocations()) {
                        loc = "";
                        if (ml.getLine() > 0 || ml.getColumn() > 0) {
                            loc = " (" + ml.getLine() + "-" + ml.getColumn() + ")";
                        }
                        this.generateElement(ident, "message", m + PathUtil.removeWorkingDirectory(ml.getPath()) + loc);
                    }
                }
                for (CheckMessage c : this.hints) {
                    m = c.getID() + ", HINT, [" + XmlReportImpl.encodeContent(c.getMessage()) + "], ";
                    for (EPUBLocation ml : c.getLocations()) {
                        loc = "";
                        if (ml.getLine() > 0 || ml.getColumn() > 0) {
                            loc = " (" + ml.getLine() + "-" + ml.getColumn() + ")";
                        }
                        this.generateElement(ident, "message", m + PathUtil.removeWorkingDirectory(ml.getPath()) + loc);
                    }
                }
                this.endElement(--ident, "messages");
            }
            this.generateElement(ident, "mimeType", this.formatName);
            this.startElement(ident++, "properties");
            this.generateProperty(ident, "PageCount", this.pagesCount);
            this.generateProperty(ident, "CharacterCount", this.charsCount);
            this.generateProperty(ident, "Language", this.language, "String");
            this.startElement(ident++, "property");
            this.generateElement(ident, "name", "Info");
            this.startElement(ident++, "values", KeyValue.with("arity", "List"), KeyValue.with("type", "Property"));
            this.generateProperty(ident, "Identifier", this.identifier, "String");
            this.generateProperty(ident, "CreationDate", this.creationDate, "Date");
            this.generateProperty(ident, "ModDate", this.lastModifiedDate, "Date");
            if (!this.titles.isEmpty()) {
                cs = this.titles.toArray(new String[this.titles.size()]);
                this.generateProperty(ident, "Title", cs, "String");
            }
            if (!this.creators.isEmpty()) {
                cs = this.creators.toArray(new String[this.creators.size()]);
                this.generateProperty(ident, "Creator", cs, "String");
            }
            if (!this.contributors.isEmpty()) {
                cs = this.contributors.toArray(new String[this.contributors.size()]);
                this.generateProperty(ident, "Contributor", cs, "String");
            }
            this.generateProperty(ident, "Date", this.date, "String");
            this.generateProperty(ident, "Publisher", this.publisher, "String");
            if (!this.subjects.isEmpty()) {
                cs = this.subjects.toArray(new String[this.subjects.size()]);
                this.generateProperty(ident, "Subject", cs, "String");
            }
            if (!this.rights.isEmpty()) {
                cs = this.rights.toArray(new String[this.rights.size()]);
                this.generateProperty(ident, "Rights", cs, "String");
            }
            this.endElement(--ident, "values");
            this.endElement(--ident, "property");
            if (!this.embeddedFonts.isEmpty() || !this.refFonts.isEmpty()) {
                this.startElement(ident++, "property");
                this.generateElement(ident, "name", "Fonts");
                this.startElement(ident++, "values", KeyValue.with("arity", "List"), KeyValue.with("type", "Property"));
                for (String f : this.embeddedFonts) {
                    this.startElement(ident++, "property");
                    this.generateElement(ident, "name", "Font");
                    this.startElement(ident++, "values", KeyValue.with("arity", "List"), KeyValue.with("type", "Property"));
                    this.generateProperty(ident, "FontName", XmlReportImpl.encodeContent(this.getNameFromPath(f)), "String");
                    this.generateProperty(ident, "FontFile", false);
                    this.endElement(--ident, "values");
                    this.endElement(--ident, "property");
                }
                for (String f : this.refFonts) {
                    this.startElement(ident++, "property");
                    this.generateElement(ident, "name", "Font");
                    this.startElement(ident++, "values", KeyValue.with("arity", "List"), KeyValue.with("type", "Property"));
                    this.generateProperty(ident, "FontName", XmlReportImpl.encodeContent(this.getNameFromPath(f)), "String");
                    this.generateProperty(ident, "FontFile", false);
                    this.endElement(--ident, "values");
                    this.endElement(--ident, "property");
                }
                this.endElement(--ident, "values");
                this.endElement(--ident, "property");
            }
            if (!this.references.isEmpty()) {
                this.startElement(ident++, "property");
                this.generateElement(ident++, "name", "References");
                this.startElement(ident++, "values", KeyValue.with("arity", "List"), KeyValue.with("type", "Property"));
                for (String r : this.references) {
                    this.generateProperty(ident, "Reference", XmlReportImpl.encodeContent(r), "String");
                }
                this.endElement(--ident, "values");
                this.endElement(--ident, "property");
            }
            if (this.hasEncryption) {
                this.generateProperty(ident, "hasEncryption", this.hasEncryption);
            }
            if (this.hasSignatures) {
                this.generateProperty(ident, "hasSignatures", this.hasSignatures);
            }
            if (this.hasAudio) {
                this.generateProperty(ident, "hasAudio", this.hasAudio);
            }
            if (this.hasVideo) {
                this.generateProperty(ident, "hasVideo", this.hasVideo);
            }
            if (this.hasFixedLayout) {
                this.generateProperty(ident, "hasFixedLayout", this.hasFixedLayout);
            }
            if (this.hasScripts) {
                this.generateProperty(ident, "hasScripts", this.hasScripts);
            }
            this.endElement(--ident, "properties");
            this.endElement(--ident, "repInfo");
            this.endElement(--ident, "jhove");
            returnCode = 0;
        }
        catch (Exception e) {
            System.err.println("Exception encountered: " + e.getMessage());
            returnCode = 1;
        }
        return returnCode;
    }

    private void generateProperty(int ident, String name, String[] value, String type) {
        if (value == null || value.length == 0) {
            return;
        }
        this.startElement(ident++, "property");
        this.generateElement(ident, "name", name);
        this.startElement(ident++, "values", KeyValue.with("arity", value.length == 1 ? "Scalar" : "Array"), KeyValue.with("type", type));
        for (String v : value) {
            this.generateElement(ident, "value", v);
        }
        this.endElement(--ident, "values");
        this.endElement(--ident, "property");
    }

    private void generateProperty(int ident, String name, String value, String type) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        this.startElement(ident++, "property");
        this.generateElement(ident, "name", name);
        this.startElement(ident++, "values", KeyValue.with("arity", "Scalar"), KeyValue.with("type", type));
        this.generateElement(ident, "value", value);
        this.endElement(--ident, "values");
        this.endElement(--ident, "property");
    }

    private void generateProperty(int ident, String name, long value) {
        if (value == 0L) {
            return;
        }
        this.generateProperty(ident, name, Long.toString(value), "Long");
    }

    private void generateProperty(int ident, String name, boolean value) {
        this.generateProperty(ident, name, value ? "true" : "false", "Boolean");
    }
}

