/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.MasterReport;
import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.messages.Severity;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.outWriter;
import java.io.PrintWriter;

public class WriterReportImpl
extends MasterReport {
    static boolean DEBUG = false;
    boolean quiet;
    final PrintWriter out;

    public WriterReportImpl(PrintWriter out) {
        this(out, "", false);
    }

    public WriterReportImpl(PrintWriter out, String info) {
        this(out, info, false);
    }

    public WriterReportImpl(PrintWriter out, String info, boolean quiet) {
        this.out = out;
        this.warning("", 0, 0, info);
        this.quiet = quiet;
    }

    String fixMessage(String message) {
        if (message == null) {
            return "";
        }
        return message.replaceAll("[\\s]+", " ");
    }

    @Override
    public void message(Message message, EPUBLocation location, Object ... args) {
        if (message.getSeverity().equals((Object)Severity.ERROR)) {
            this.error(PathUtil.removeWorkingDirectory(location.getPath()), location.getLine(), location.getColumn(), message.getMessage(args));
        } else if (message.getSeverity().equals((Object)Severity.WARNING)) {
            this.warning(PathUtil.removeWorkingDirectory(location.getPath()), location.getLine(), location.getColumn(), message.getMessage(args));
        } else if (message.getSeverity().equals((Object)Severity.FATAL)) {
            this.fatalError(PathUtil.removeWorkingDirectory(location.getPath()), location.getLine(), location.getColumn(), message.getMessage(args));
        }
    }

    void error(String resource, int line, int column, String message) {
        message = this.fixMessage(message);
        this.out.println("ERROR: " + (resource == null ? "[top level]" : resource) + (line <= 0 ? "" : "(" + line + (column <= 0 ? "" : "," + column) + ")") + ": " + message);
    }

    void fatalError(String resource, int line, int column, String message) {
        message = this.fixMessage(message);
        this.out.println("ERROR: " + (resource == null ? "[top level]" : resource) + (line <= 0 ? "" : "(" + line + (column <= 0 ? "" : "," + column) + ")") + ": " + message);
    }

    void warning(String resource, int line, int column, String message) {
        message = this.fixMessage(message);
        this.out.println("WARNING: " + (resource == null ? "[top level]" : resource) + (line <= 0 ? "" : "(" + line + (column <= 0 ? "" : "," + column) + ")") + ": " + message);
    }

    @Override
    public void info(String resource, FeatureEnum feature, String value) {
        if (2 >= this.getReportingLevel()) {
            switch (feature) {
                case FORMAT_VERSION: {
                    if (!DEBUG || this.quiet) break;
                    outWriter.println(String.format(Messages.get("validating_version_message"), value));
                    break;
                }
                default: {
                    if (this.quiet) break;
                    if (resource == null) {
                        outWriter.println("INFO: [" + (Object)((Object)feature) + "]=" + value);
                        break;
                    }
                    outWriter.println("INFO: [" + (Object)((Object)feature) + " (" + resource + ")]=" + value);
                }
            }
        }
    }

    @Override
    public void initialize() {
    }

    public void hint(String resource, int line, int column, String message) {
        if (!this.quiet) {
            this.out.println("HINT: " + (resource == null ? "[top level]" : resource) + (line <= 0 ? "" : "(" + line + (column <= 0 ? "" : "," + column) + ")") + ": " + message);
        }
    }

    @Override
    public int generate() {
        this.out.flush();
        return 0;
    }
}

