/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.EncryptionFilter;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.util.FeatureEnum;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OCFZipPackage
extends OCFPackage {
    private final ZipFile zip;
    private List<String> allEntries = null;
    private Set<String> fileEntries;
    private Set<String> dirEntries;

    public OCFZipPackage(ZipFile zip) {
        this.zip = zip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listEntries() throws IOException {
        ZipFile zipFile = this.zip;
        synchronized (zipFile) {
            this.allEntries = new LinkedList<String>();
            this.fileEntries = new TreeSet<String>();
            this.dirEntries = new TreeSet<String>();
            try {
                Enumeration<? extends ZipEntry> entries = this.zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    this.allEntries.add(entry.getName());
                    if (entry.isDirectory()) {
                        this.dirEntries.add(entry.getName());
                        continue;
                    }
                    this.fileEntries.add(entry.getName());
                }
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    @Override
    public boolean hasEntry(String name) {
        return this.zip.getEntry(name) != null;
    }

    @Override
    public long getTimeEntry(String name) {
        ZipEntry entry = this.zip.getEntry(name);
        if (entry == null) {
            return 0L;
        }
        return entry.getTime();
    }

    @Override
    public InputStream getInputStream(String name) throws IOException {
        ZipEntry entry = this.zip.getEntry(name);
        if (entry == null) {
            return null;
        }
        InputStream in = this.zip.getInputStream(entry);
        EncryptionFilter filter = (EncryptionFilter)this.enc.get(name);
        if (filter == null) {
            return in;
        }
        if (filter.canDecrypt()) {
            return filter.decrypt(in);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getEntries() throws IOException {
        ZipFile zipFile = this.zip;
        synchronized (zipFile) {
            if (this.allEntries == null) {
                this.listEntries();
            }
        }
        return Collections.unmodifiableList(this.allEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getFileEntries() throws IOException {
        ZipFile zipFile = this.zip;
        synchronized (zipFile) {
            if (this.allEntries == null) {
                this.listEntries();
            }
            return Collections.unmodifiableSet(this.fileEntries);
        }
    }

    @Override
    public Set<String> getDirectoryEntries() throws IOException {
        HashSet<String> entryNames = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.isDirectory()) continue;
            entryNames.add(entry.getName());
        }
        return entryNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportMetadata(String fileName, Report report) {
        ZipEntry entry = this.zip.getEntry(fileName);
        if (entry != null) {
            report.info(fileName, FeatureEnum.SIZE, String.valueOf(entry.getSize()));
            report.info(fileName, FeatureEnum.COMPRESSED_SIZE, String.valueOf(entry.getCompressedSize()));
            report.info(fileName, FeatureEnum.COMPRESSION_METHOD, this.getCompressionMethod(entry));
            InputStream inputStream = null;
            try {
                inputStream = this.zip.getInputStream(entry);
                if (inputStream != null) {
                    report.info(fileName, FeatureEnum.SHA_256, OCFZipPackage.getSHAHash(inputStream));
                }
            }
            catch (IOException e) {
                report.message(MessageId.PKG_008, EPUBLocation.create(fileName), fileName);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private String getCompressionMethod(ZipEntry entry) {
        if (entry == null) {
            return "";
        }
        int method = entry.getMethod();
        if (method == 8) {
            return "Deflated";
        }
        if (method == 0) {
            return "Stored";
        }
        return "Unsupported";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSHAHash(InputStream fis) {
        try {
            int nread;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] dataBytes = new byte[1024];
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] bytes = md.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte aByte : bytes) {
                hexString.append(Integer.toHexString(0xFF & aByte));
            }
            String string = hexString.toString();
            return string;
        }
        catch (Exception e) {
            String string = "error!";
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String getName() {
        return new File(this.zip.getName()).getName();
    }

    @Override
    public String getPackagePath() {
        return this.zip.getName();
    }
}

