Python-oletools Changelog
=========================

- **2019-04-04 v0.54**:
    - olevba, msodde: added support for encrypted MS Office files 
    - olevba: added detection and extraction of XLM/XLF Excel 4 macros (thanks to plugin_biff from Didier Stevens' oledump)
    - olevba, mraptor: added detection of VBA running Excel 4 macros
    - olevba: detect and display special characters such as backspace
    - olevba: colorized output showing suspicious keywords in the VBA code
    - olevba, mraptor: full Python 3 compatibility, no separate olevba3/mraptor3 anymore
    - olevba: improved handling of code pages and unicode
    - olevba: fixed a false-positive in VBA macro detection
    - rtfobj: improved OLE Package handling, improved Equation object detection
    - oleobj: added detection of external links to objects in OpenXML
    - replaced third party packages by PyPI dependencies
- **2018-06-13 v0.53.1**:
    - rtfobj: fixed issue #316, whitespace after \bin on Python 3
    - olevba3: fixed #320, chr instead of unichr on python 3
    - olevba3: fixed #322, import reduce from functools
- **2018-05-30 v0.53**:
    - olevba and mraptor can now parse Word/PowerPoint 2007+ pure XML files (aka Flat OPC format)
    - improved support for VBA forms in olevba (oleform)
    - rtfobj now displays the CLSID of OLE objects, which is the best way to identify them. Known-bad CLSIDs such as MS Equation Editor are highlighted in red.
    - Updated rtfobj to handle obfuscated RTF samples.
    - rtfobj now handles the "\\'" obfuscation trick seen in recent samples such as https://twitter.com/buffaloverflow/status/989798880295444480, by emulating the MS Word bug described in https://securelist.com/disappearing-bytes/84017/
    - msodde: improved detection of DDE formulas in CSV files
    - oledir now displays the tree of storage/streams, along with CLSIDs and their meaning.
    - common.clsid contains the list of known CLSIDs, and their links to CVE vulnerabilities when relevant.
    - oleid now detects encrypted OpenXML files
    - fixed bugs in oleobj, rtfobj, oleid, olevba
- **2018-03-11 v0.52.2**:
    - Fixed issue #265 (error when installing on Python 3)
- **2018-02-18 v0.52**:
    - New tool [msodde](https://github.com/decalage2/oletools/wiki/msodde) to detect and extract DDE links from MS Office files, RTF and CSV;
    - Fixed bugs in olevba, rtfobj and olefile, to better handle malformed/obfuscated files;
    - Performance improvements in olevba and rtfobj;
    - VBA form parsing in olevba;
    - Office 2007+ support in oleobj.
- 2017-06-29 v0.51:
    - added the [oletools cheatsheet](https://github.com/decalage2/oletools/blob/master/cheatsheet/oletools_cheatsheet.pdf)
    - improved [rtfobj](https://github.com/decalage2/oletools/wiki/rtfobj) to handle malformed RTF files, detect vulnerability CVE-2017-0199
    - olevba: improved deobfuscation and Mac files support
    - [mraptor](https://github.com/decalage2/oletools/wiki/mraptor): added more ActiveX macro triggers
    - added [DocVarDump.vba](https://github.com/decalage2/oletools/blob/master/oletools/DocVarDump.vba) to dump document variables using Word
    - olemap: can now detect and extract [extra data at end of file](http://decalage.info/en/ole_extradata), improved display
    - oledir, olemeta, oletimes: added support for zip files and wildcards
    - many [bugfixes](https://github.com/decalage2/oletools/milestone/3?closed=1) in all the tools
    - improved Python 2+3 support
    
- 2016-11-01 v0.50: all oletools now support python 2 and 3.
    - olevba: several bugfixes and improvements.
    - mraptor: improved detection, added mraptor_milter for Sendmail/Postfix integration.
    - rtfobj: brand new RTF parser, obfuscation-aware, improved display, detect
    executable files in OLE Package objects.
    - setup: now creates handy command-line scripts to run oletools from any directory.
- 2016-06-10 v0.47: [olevba](https://github.com/decalage2/oletools/wiki/olevba) added PPT97 macros support,
improved handling of malformed/incomplete documents, improved error handling and JSON output,
now returns an exit code based on analysis results, new --relaxed option.
[rtfobj](https://github.com/decalage2/oletools/wiki/rtfobj): improved parsing to handle obfuscated RTF documents,
added -d option to set output dir. Moved repository and documentation to GitHub.
- 2016-04-19 v0.46: [olevba](https://github.com/decalage2/oletools/wiki/olevba)
does not deobfuscate VBA expressions by default (much faster), new option --deobf
to enable it. Fixed color display bug on Windows for several tools.
- 2016-04-12 v0.45: improved [rtfobj](https://github.com/decalage2/oletools/wiki/rtfobj)
to handle several [anti-analysis tricks](http://www.decalage.info/rtf_tricks),
improved [olevba](https://github.com/decalage2/oletools/wiki/olevba)
to export results in JSON format.
- 2016-03-11 v0.44: improved [olevba](https://github.com/decalage2/oletools/wiki/olevba)
to extract and analyse strings from VBA Forms.
- 2016-03-04 v0.43: added new tool [MacroRaptor](https://github.com/decalage2/oletools/wiki/mraptor) (mraptor)
to detect malicious macros, bugfix and slight improvements in [olevba](https://github.com/decalage2/oletools/wiki/olevba).
- 2016-02-07 v0.42: added two new tools oledir and olemap, better handling of malformed
files and several bugfixes in [olevba](https://github.com/decalage2/oletools/wiki/olevba),
improved display for [olemeta](https://github.com/decalage2/oletools/wiki/olemeta).
- 2015-09-22 v0.41: added new --reveal option to [olevba](https://github.com/decalage2/oletools/wiki/olevba),
to show the macro code with VBA strings deobfuscated.
- 2015-09-17 v0.40: Improved macro deobfuscation in [olevba](https://github.com/decalage2/oletools/wiki/olevba),
to decode Hex and Base64 within VBA expressions. Display printable deobfuscated strings by
default. Improved the VBA_Parser API. Improved performance.
Fixed [issue #23](https://github.com/decalage2/oletools/issues/23) with sys.stderr.
- 2015-06-19 v0.12: [olevba](https://github.com/decalage2/oletools/wiki/olevba) can now deobfuscate VBA
expressions with any combination of Chr, Asc, Val, StrReverse, Environ, +, &, using a VBA parser built with
[pyparsing](http://pyparsing.wikispaces.com). New options to display only the analysis results or only the macros source code.
The analysis is now done on all the VBA modules at once.
- 2015-05-29 v0.11: Improved parsing of MHTML and ActiveMime/MSO files in
[olevba](https://github.com/decalage2/oletools/wiki/olevba), added several suspicious keywords to VBA scanner
(thanks to @ozhermit and Davy Douhine for the suggestions)
- 2015-05-06 v0.10: [olevba](https://github.com/decalage2/oletools/wiki/olevba) now supports Word MHTML files
with macros, aka "Single File Web Page" (.mht) - see [issue #10](https://github.com/decalage2/oletools/issues/10) for more info
- 2015-03-23 v0.09: [olevba](https://github.com/decalage2/oletools/wiki/olevba) now supports Word 2003 XML files,
added anti-sandboxing/VM detection
- 2015-02-08 v0.08: [olevba](https://github.com/decalage2/oletools/wiki/olevba) can now decode strings
obfuscated with Hex/StrReverse/Base64/Dridex and extract IOCs. Added new triage mode, support for non-western
codepages with olefile 0.42, improved API and display, several bugfixes.
- 2015-01-05 v0.07: improved [olevba](https://github.com/decalage2/oletools/wiki/olevba) to detect suspicious
keywords and IOCs in VBA macros, can now scan several files and open password-protected zip archives, added a Python API,
upgraded OleFileIO_PL to olefile v0.41
- 2014-08-28 v0.06: added [olevba](https://github.com/decalage2/oletools/wiki/olevba), a new tool to extract VBA Macro
source code from MS Office documents (97-2003 and 2007+). Improved [documentation](https://github.com/decalage2/oletools/wiki)
- 2013-07-24 v0.05: added new tools [olemeta](https://github.com/decalage2/oletools/wiki/olemeta) and
[oletimes](https://github.com/decalage2/oletools/wiki/oletimes)
- 2013-04-18 v0.04: fixed bug in rtfobj, added documentation for [rtfobj](https://github.com/decalage2/oletools/wiki/rtfobj)
- 2012-11-09 v0.03: Improved [pyxswf](https://github.com/decalage2/oletools/wiki/pyxswf) to extract Flash objects from RTF
- 2012-10-29 v0.02: Added [oleid](https://github.com/decalage2/oletools/wiki/oleid)
- 2012-10-09 v0.01: Initial version of [olebrowse](https://github.com/decalage2/oletools/wiki/olebrowse) and pyxswf

See also the changelog in each source file for more details.
