/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Pad;
import com.fluendo.plugin.OggPayload;
import com.fluendo.utils.Debug;
import com.fluendo.utils.MemUtils;
import com.jcraft.jogg.Packet;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VorbisDec
extends Element
implements OggPayload {
    private static final byte[] signature = new byte[]{1, 118, 111, 114, 98, 105, 115};
    private long packet;
    private long offset;
    private Info vi;
    private Comment vc;
    private DspState vd;
    private Block vb;
    private boolean discont;
    private Packet op;
    private float[][][] _pcmf;
    private int[] _index;
    private Pad srcPad;
    private Pad sinkPad;

    public boolean isType(Packet op) {
        boolean bl = false;
        if (this.typeFind(op.packet_base, op.packet, op.bytes) > 0) {
            bl = true;
        }
        return bl;
    }

    public int takeHeader(Packet op) {
        return this.vi.synthesis_headerin(this.vc, op);
    }

    public boolean isHeader(Packet op) {
        boolean bl = false;
        if ((op.packet_base[op.packet] & 1) == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isKeyFrame(Packet op) {
        return true;
    }

    public long getFirstTs(Vector packets) {
        int len = packets.size();
        long total = 0L;
        long prevSamples = 0L;
        Packet p = new Packet();
        int i = 0;
        while (i < len) {
            boolean ignore;
            Buffer buf = (Buffer)packets.elementAt(i);
            p.packet_base = buf.data;
            p.packet = buf.offset;
            p.bytes = buf.length;
            long samples = this.vi.blocksize(p);
            if (samples <= 0L) {
                return -1;
            }
            if (prevSamples == 0L) {
                prevSamples = samples;
                ignore = true;
            } else {
                ignore = false;
            }
            long temp = (samples + prevSamples) / (long)4;
            prevSamples = samples;
            if (!ignore) {
                total += temp;
            }
            if (buf.time_offset != (long)-1) {
                total = buf.time_offset - total;
                long result = this.granuleToTime(total);
                buf = (Buffer)packets.elementAt(0);
                buf.timestamp = result;
                return result;
            }
            ++i;
        }
        return -1;
    }

    public long granuleToTime(long gp) {
        if (gp < 0L) {
            return -1;
        }
        return gp * 1000000L / (long)this.vi.rate;
    }

    protected int changeState(int transition) {
        switch (transition) {
            case 18: {
                this.packet = 0L;
                this.offset = -1;
                this.vi.init();
                this.vc.init();
                break;
            }
        }
        int res = super.changeState(transition);
        return res;
    }

    public String getFactoryName() {
        return "vorbisdec";
    }

    public String getMime() {
        return "audio/x-vorbis";
    }

    public int typeFind(byte[] data, int offset, int length) {
        if (MemUtils.startsWith(data, offset, length, signature)) {
            return 10;
        }
        return -1;
    }

    private final /* synthetic */ void this() {
        this._pcmf = new float[1][][];
        this.srcPad = new Pad(1, "src"){

            protected final boolean eventFunc(Event event) {
                return VorbisDec.this.sinkPad.pushEvent(event);
            }
        };
        this.sinkPad = new Pad(2, "sink"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected final boolean eventFunc(Event event) {
                switch (event.getType()) {
                    case 1: {
                        boolean result = VorbisDec.this.srcPad.pushEvent(event);
                        Object object = this.streamLock;
                        synchronized (object) {
                            Debug.log(4, "synced " + this);
                            return result;
                        }
                    }
                    case 2: {
                        return VorbisDec.this.srcPad.pushEvent(event);
                    }
                    case 3: {
                        Debug.log(3, "got EOS " + this);
                        return VorbisDec.this.srcPad.pushEvent(event);
                    }
                }
                return VorbisDec.this.srcPad.pushEvent(event);
            }

            /*
             * Enabled aggressive block sorting
             */
            protected final int chainFunc(Buffer buf) {
                int samples;
                int result = 0;
                ((VorbisDec)VorbisDec.this).op.packet_base = buf.data;
                ((VorbisDec)VorbisDec.this).op.packet = buf.offset;
                ((VorbisDec)VorbisDec.this).op.bytes = buf.length;
                Packet packet = VorbisDec.this.op;
                int n = 0;
                if (VorbisDec.this.packet == 0L) {
                    n = 1;
                }
                packet.b_o_s = n;
                ((VorbisDec)VorbisDec.this).op.e_o_s = 0;
                ((VorbisDec)VorbisDec.this).op.packetno = VorbisDec.this.packet;
                if (buf.isFlagSet(1)) {
                    VorbisDec.this.offset = -1;
                    VorbisDec.this.discont = true;
                    Debug.log(3, "vorbis: got discont");
                    VorbisDec.this.vd.synthesis_init(VorbisDec.this.vi);
                }
                if (VorbisDec.this.packet < (long)3) {
                    if (VorbisDec.this.vi.synthesis_headerin(VorbisDec.this.vc, VorbisDec.this.op) < 0) {
                        Debug.log(1, "This Ogg bitstream does not contain Vorbis audio data.");
                        return -5;
                    }
                    if (VorbisDec.this.packet == (long)2) {
                        VorbisDec.this.vd.synthesis_init(VorbisDec.this.vi);
                        VorbisDec.this.vb.init(VorbisDec.this.vd);
                        Debug.log(3, "vorbis rate: " + ((VorbisDec)VorbisDec.this).vi.rate);
                        Debug.log(3, "vorbis channels: " + ((VorbisDec)VorbisDec.this).vi.channels);
                        VorbisDec.this._index = new int[((VorbisDec)VorbisDec.this).vi.channels];
                        this.caps = new Caps("audio/raw");
                        this.caps.setFieldInt("width", 16);
                        this.caps.setFieldInt("depth", 16);
                        this.caps.setFieldInt("rate", ((VorbisDec)VorbisDec.this).vi.rate);
                        this.caps.setFieldInt("channels", ((VorbisDec)VorbisDec.this).vi.channels);
                    }
                    buf.free();
                    VorbisDec vorbisDec = VorbisDec.this;
                    vorbisDec.packet = vorbisDec.packet + 1L;
                    return 0;
                }
                if (VorbisDec.this.isHeader(VorbisDec.this.op)) {
                    Debug.log(3, "ignoring header");
                    return 0;
                }
                long timestamp = buf.timestamp;
                if (timestamp != (long)-1) {
                    VorbisDec.this.offset = timestamp * (long)((VorbisDec)VorbisDec.this).vi.rate / 1000000L;
                } else {
                    timestamp = VorbisDec.this.offset * 1000000L / (long)((VorbisDec)VorbisDec.this).vi.rate;
                }
                if (VorbisDec.this.vb.synthesis(VorbisDec.this.op) != 0) {
                    Debug.log(1, "decoding error");
                    return -5;
                }
                VorbisDec.this.vd.synthesis_blockin(VorbisDec.this.vb);
                while ((samples = VorbisDec.this.vd.synthesis_pcmout(VorbisDec.this._pcmf, VorbisDec.this._index)) > 0) {
                    float[][] pcmf = VorbisDec.this._pcmf[0];
                    int numbytes = samples * 2 * ((VorbisDec)VorbisDec.this).vi.channels;
                    int k = 0;
                    buf.ensureSize(numbytes);
                    buf.offset = 0;
                    buf.timestamp = timestamp;
                    buf.time_offset = VorbisDec.this.offset;
                    buf.length = numbytes;
                    buf.caps = this.caps;
                    buf.setFlag(1, VorbisDec.this.discont);
                    VorbisDec.this.discont = false;
                    int j = 0;
                    while (j < samples) {
                        int i = 0;
                        while (i < ((VorbisDec)VorbisDec.this).vi.channels) {
                            int val = (int)((double)pcmf[i][VorbisDec.this._index[i] + j] * 32767.0);
                            if (val > Short.MAX_VALUE) {
                                val = Short.MAX_VALUE;
                            } else if (val < Short.MIN_VALUE) {
                                val = Short.MIN_VALUE;
                            }
                            buf.data[k] = (byte)(val >> 8 & 0xFF);
                            buf.data[k + 1] = (byte)(val & 0xFF);
                            k += 2;
                            ++i;
                        }
                        ++j;
                    }
                    VorbisDec.this.vd.synthesis_read(samples);
                    VorbisDec vorbisDec = VorbisDec.this;
                    vorbisDec.offset = vorbisDec.offset + (long)samples;
                    result = VorbisDec.this.srcPad.push(buf);
                    if (result != 0) break;
                }
                VorbisDec vorbisDec = VorbisDec.this;
                vorbisDec.packet = vorbisDec.packet + 1L;
                return result;
            }
        };
    }

    public VorbisDec() {
        this.this();
        this.vi = new Info();
        this.vc = new Comment();
        this.vd = new DspState();
        this.vb = new Block(this.vd);
        this.op = new Packet();
        this.addPad(this.srcPad);
        this.addPad(this.sinkPad);
    }
}

