/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.ElementFactory;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.utils.Base64Converter;
import com.fluendo.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HTTPSrc
extends Element {
    private static final int DEFAULT_READSIZE = 4096;
    private String userId;
    private String password;
    private String userAgent;
    private String urlString;
    private InputStream input;
    private long contentLength;
    private String mime;
    private Caps outCaps;
    private boolean discont;
    private URL documentBase;
    private int readSize;
    private Pad srcpad;

    private final InputStream openWithConnection(URL url, long offset) throws IOException {
        InputStream dis = null;
        URLConnection uc = url.openConnection();
        uc.setRequestProperty("Connection", "Keep-Alive");
        String range = offset != 0L && this.contentLength != (long)-1 ? "bytes=" + offset + '-' + (this.contentLength - 1L) : (offset != 0L ? "bytes=" + offset + '-' : null);
        if (range != null) {
            Debug.log(3, "doing range: " + range);
            uc.setRequestProperty("Range", range);
        }
        uc.setRequestProperty("User-Agent", this.userAgent);
        if (this.userId != null && this.password != null) {
            String userPassword = this.userId + ':' + this.password;
            String encoding = Base64Converter.encode(userPassword.getBytes());
            uc.setRequestProperty("Authorization", "Basic " + encoding);
        }
        uc.setRequestProperty("Content-Type", "application/octet-stream");
        dis = uc.getInputStream();
        this.contentLength = (long)uc.getHeaderFieldInt("Content-Length", 0) + offset;
        this.mime = uc.getContentType();
        return dis;
    }

    private final InputStream openWithSocket(URL url, long offset) throws IOException {
        InputStream dis = null;
        String hostname = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        InetAddress addr = InetAddress.getByName(hostname);
        Socket socket = new Socket(addr, port);
        String file = url.getFile();
        OutputStream os = socket.getOutputStream();
        StringBuffer sb = new StringBuffer();
        sb.append("GET ").append(file).append(" HTTP/1.0\r\n");
        sb.append("Content-Type: application/octet-stream\r\n");
        sb.append("Connection: Keep-Alive\r\n");
        String range = offset != 0L && this.contentLength != (long)-1 ? "bytes=" + offset + '-' + (this.contentLength - 1L) : (offset != 0L ? "bytes=" + offset + '-' : null);
        if (range != null) {
            Debug.log(3, "doing range: " + range);
            sb.append("Range: ").append(range).append("\r\n");
        }
        sb.append("User-Agent: Cortado\r\n");
        if (this.userId != null && this.password != null) {
            String userPassword = this.userId + ':' + this.password;
            String encoding = Base64Converter.encode(userPassword.getBytes());
            sb.append("Authorization: Basic ").append(encoding).append("\r\n");
        }
        sb.append("\r\n\r\n");
        os.write(sb.toString().getBytes());
        os.flush();
        dis = socket.getInputStream();
        this.contentLength = 10000000L;
        this.mime = "application/ogg";
        return dis;
    }

    private final InputStream getInputStream(long offset) throws Exception {
        InputStream dis = null;
        try {
            URL url;
            this.postMessage(Message.newResource(this, "Opening " + this.urlString));
            Debug.log(3, "reading from url " + this.urlString);
            boolean isAbsolute = this.urlString.startsWith("http://");
            if (!isAbsolute && this.documentBase != null) {
                Debug.log(3, "parsing in document base");
                url = new URL(this.documentBase, this.urlString);
            } else {
                Debug.log(3, "parsing as abslute URL");
                url = new URL(this.urlString);
            }
            Debug.log(3, "trying to open " + url + " at offset " + offset);
            dis = this.openWithConnection(url, offset);
            this.discont = true;
            Debug.log(3, "opened " + url);
            Debug.log(3, "contentLength: " + this.contentLength);
            Debug.log(3, "server contentType: " + this.mime);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            this.postMessage(Message.newError(this, "Not allowed " + this.urlString + "..."));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.postMessage(Message.newError(this, "Failed opening " + this.urlString + "..."));
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.postMessage(Message.newError(this, "Failed opening " + this.urlString + "..."));
        }
        return dis;
    }

    public String getFactoryName() {
        return "httpsrc";
    }

    public synchronized boolean setProperty(String name, Object value) {
        boolean res = true;
        if (name.equals("url")) {
            this.urlString = String.valueOf(value);
        } else if (name.equals("documentBase")) {
            this.documentBase = (URL)value;
        } else if (name.equals("userId")) {
            this.userId = String.valueOf(value);
        } else if (name.equals("userAgent")) {
            this.userAgent = String.valueOf(value);
        } else if (name.equals("password")) {
            this.password = String.valueOf(value);
        } else if (name.equals("readSize")) {
            this.readSize = Integer.parseInt((String)value);
        } else {
            res = false;
        }
        return res;
    }

    private final /* synthetic */ void this() {
        this.userAgent = "Cortado";
        this.readSize = 4096;
        this.srcpad = new Pad(1, "src"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private final boolean doSeek(Event event) {
                int format = event.parseSeekFormat();
                long position = event.parseSeekPosition();
                if (format == 5 && HTTPSrc.this.contentLength != (long)-1) {
                    position = position * HTTPSrc.this.contentLength / 1000000L;
                } else if (format != 2) {
                    Debug.log(2, "can only seek in bytes");
                    return false;
                }
                Debug.log(4, this + " flushing");
                this.pushEvent(Event.newFlushStart());
                Object object = this.streamLock;
                synchronized (object) {
                    Debug.log(4, this + " synced");
                    boolean result = false;
                    try {
                        HTTPSrc.this.input = HTTPSrc.this.getInputStream(position);
                        if (HTTPSrc.this.input != null) {
                            result = true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.pushEvent(Event.newFlushStop());
                    if (result) {
                        this.pushEvent(Event.newNewsegment(false, 2, position, HTTPSrc.this.contentLength, position));
                        HTTPSrc.this.postMessage(Message.newStreamStatus(this, true, 0, "restart after seek"));
                        return this.startTask("cortado-HTTPSrc-Stream-" + Debug.genId());
                    }
                    HTTPSrc.this.postMessage(Message.newError(this, "error: Seek failed"));
                    return result;
                }
            }

            protected final boolean eventFunc(Event event) {
                boolean res;
                switch (event.getType()) {
                    case 5: {
                        res = this.doSeek(event);
                        break;
                    }
                    default: {
                        res = super.eventFunc(event);
                        break;
                    }
                }
                return res;
            }

            protected final void taskFunc() {
                Buffer data = Buffer.create();
                data.ensureSize(HTTPSrc.this.readSize);
                data.offset = 0;
                try {
                    data.length = HTTPSrc.this.input.read(data.data, 0, HTTPSrc.this.readSize);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    data.length = 0;
                }
                if (data.length <= 0) {
                    data.free();
                    Debug.log(3, this + " reached EOS");
                    this.pushEvent(Event.newEOS());
                    HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, -3, "reached EOS"));
                    this.pauseTask();
                } else {
                    if (HTTPSrc.this.srcpad.getCaps() == null) {
                        String typeMime = ElementFactory.typeFindMime(data.data, data.offset, data.length);
                        if (typeMime != null) {
                            if (!typeMime.equals(HTTPSrc.this.mime)) {
                                Debug.log(2, "server contentType: " + HTTPSrc.this.mime + " disagrees with our typeFind: " + typeMime);
                            }
                            Debug.log(3, "using typefind contentType: " + typeMime);
                            HTTPSrc.this.mime = typeMime;
                        } else {
                            Debug.log(3, "typefind failed, using server contentType: " + HTTPSrc.this.mime);
                        }
                        HTTPSrc.this.outCaps = new Caps(HTTPSrc.this.mime);
                        HTTPSrc.this.srcpad.setCaps(HTTPSrc.this.outCaps);
                    }
                    data.caps = HTTPSrc.this.outCaps;
                    data.setFlag(1, HTTPSrc.this.discont);
                    HTTPSrc.this.discont = false;
                    int ret = this.push(data);
                    if (ret != 0) {
                        if (1.isFlowFatal(ret) || ret == -1) {
                            HTTPSrc.this.postMessage(Message.newError(this, "error: " + 1.getFlowName(ret)));
                            this.pushEvent(Event.newEOS());
                        }
                        HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, ret, "reason: " + 1.getFlowName(ret)));
                        this.pauseTask();
                    }
                }
            }

            protected final boolean activateFunc(int mode) {
                boolean res = true;
                switch (mode) {
                    case 0: {
                        HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, -2, "stopping"));
                        res = this.stopTask();
                        HTTPSrc.this.input = null;
                        HTTPSrc.this.outCaps = null;
                        HTTPSrc.this.mime = null;
                        break;
                    }
                    case 1: {
                        try {
                            HTTPSrc.this.contentLength = -1;
                            HTTPSrc.this.input = HTTPSrc.this.getInputStream(0L);
                            if (HTTPSrc.this.input == null) {
                                res = false;
                            }
                        }
                        catch (Exception e) {
                            res = false;
                        }
                        if (!res) break;
                        HTTPSrc.this.postMessage(Message.newStreamStatus(this, true, 0, "activating"));
                        res = this.startTask("cortado-HTTPSrc-Stream-" + Debug.genId());
                        break;
                    }
                    default: {
                        res = false;
                        break;
                    }
                }
                return res;
            }
        };
    }

    public HTTPSrc() {
        this.this();
        this.addPad(this.srcpad);
    }
}

