/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.BusHandler;
import com.fluendo.jst.BusSyncHandler;
import com.fluendo.jst.Message;
import java.util.Enumeration;
import java.util.Vector;

public class Bus {
    private Vector queue = new Vector();
    private Vector handlers = new Vector();
    private boolean flushing = false;
    private BusSyncHandler syncHandler;

    public synchronized void addHandler(BusHandler handler) {
        this.handlers.addElement(handler);
    }

    public synchronized void removeHandler(BusHandler handler) {
        this.handlers.removeElement(handler);
    }

    public synchronized void setSyncHandler(BusSyncHandler handler) {
        this.syncHandler = handler;
    }

    private final void notifyHandlers(Vector handlers, Message message) {
        Enumeration e = handlers.elements();
        while (e.hasMoreElements()) {
            BusHandler handler = (BusHandler)e.nextElement();
            handler.handleMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void post(Message message) {
        BusSyncHandler handler;
        boolean post = true;
        Bus bus = this;
        synchronized (bus) {
            if (this.flushing) {
                return;
            }
            handler = this.syncHandler;
        }
        boolean bl = false;
        if (handler == null || handler.handleSyncMessage(message) == 1) {
            bl = true;
        }
        post = bl;
        bus = this;
        synchronized (bus) {
            if (post && !this.flushing) {
                this.queue.addElement(message);
                this.notifyAll();
            }
            return;
        }
    }

    public synchronized Message peek() {
        if (this.queue.isEmpty() || this.flushing) {
            return null;
        }
        return (Message)this.queue.firstElement();
    }

    public synchronized Message pop() {
        if (this.queue.isEmpty() || this.flushing) {
            return null;
        }
        Message ret = (Message)this.queue.elementAt(0);
        this.queue.removeElementAt(0);
        return ret;
    }

    public synchronized Message poll(long timeout) {
        if (this.queue.isEmpty() && !this.flushing) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.pop();
    }

    public synchronized void setFlushing(boolean flush) {
        this.flushing = flush;
        this.queue.setSize(0);
        this.notifyAll();
    }

    public void waitAndDispatch() {
        Message msg = this.poll(0L);
        if (msg != null) {
            this.notifyHandlers(this.handlers, msg);
        }
    }
}

