/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.EnvironmentVariableResolver;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.testdriver.Environment;
import net.sf.saxon.testdriver.ErrorCollector;
import net.sf.saxon.testdriver.QT3TestReport;
import net.sf.saxon.testdriver.Spec;
import net.sf.saxon.testdriver.TestDriver;
import net.sf.saxon.testdriver.TestOutcome;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QT3TestDriverHE
extends TestDriver {
    public static String RNS = "http://www.w3.org/2012/08/qt-fots-results";
    public static String CNS = "http://www.w3.org/2010/09/qt-fots-catalog";
    private Map<String, Dependency> dependencyMap = new HashMap<String, Dependency>();

    public Map<String, Dependency> getDependencyMap() {
        return this.dependencyMap;
    }

    @Override
    public String catalogNamespace() {
        return CNS;
    }

    @Override
    public void go(String[] args) throws Exception {
        super.go(args);
    }

    @Override
    public void processSpec(String specStr) {
        if (specStr.equals("XP20")) {
            this.spec = Spec.XP20;
        } else if (specStr.equals("XP30")) {
            this.spec = Spec.XP30;
        } else if (specStr.equals("XP30")) {
            this.spec = Spec.XP31;
        } else if (specStr.equals("XQ10")) {
            this.spec = Spec.XQ10;
        } else if (specStr.equals("XQ30")) {
            this.spec = Spec.XQ30;
        } else if (specStr.equals("XQ31")) {
            this.spec = Spec.XQ31;
        } else if (specStr.equals("XT30")) {
            this.spec = Spec.XT30;
        } else {
            throw new IllegalArgumentException("The specific language must be one of the following: XP20, XP30, XQ10, XQ30, XT30");
        }
        this.resultsDoc = new QT3TestReport(this, this.spec);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("-?")) {
            QT3TestDriverHE.usage();
        }
        new QT3TestDriverHE().go(args);
    }

    public static void usage() {
        System.err.println("java com.saxonica.testdriver.FOTestSuiteDriver[HE] testsuiteDir catalog [-o:resultsdir] [-s:testSetName] [-t:testNamePattern] [-unfolded] [-bytecode:on|off|debug] [-tree] [-lang:XP20|XP30|XQ10|XQ30]");
    }

    @Override
    protected void createGlobalEnvironments(XdmNode catalog, XPathCompiler xpc) throws SaxonApiException {
        Environment environment = null;
        for (XdmItem env : xpc.evaluate("//environment", (XdmItem)catalog)) {
            try {
                environment = Environment.processEnvironment(this, xpc, env, this.globalEnvironments, (Environment)this.localEnvironments.get("default"));
            }
            catch (NullPointerException ex) {
                System.err.println("Failed to load environment");
            }
        }
        try {
            this.buildDependencyMap(this.driverProc, environment);
        }
        catch (Exception ex) {
            System.err.println("Environment map error" + ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dependencyIsSatisfied(XdmNode dependency, Environment env) {
        String type = dependency.getAttributeValue(new QName("type"));
        String value = dependency.getAttributeValue(new QName("value"));
        boolean inverse = "false".equals(dependency.getAttributeValue(new QName("satisfied")));
        if ("xml-version".equals(type)) {
            if (value.equals("1.0:4-") && !inverse) {
                return false;
            }
            if (value.contains("1.1") && !inverse) {
                if (this.treeModel.getName().equals("JDOM")) return false;
                if (this.treeModel.getName().equals("JDOM2")) return false;
                if (this.treeModel.getName().equals("XOM")) {
                    return false;
                }
                if (env == null) return false;
                env.processor.setXmlVersion("1.1");
                return true;
            } else {
                if (!value.contains("1.0")) return true;
                if (inverse) return true;
                if (env == null) return false;
                env.processor.setXmlVersion("1.0");
            }
            return true;
        }
        if ("xsd-version".equals(type)) {
            final String old = (String)env.processor.getConfigurationProperty("http://saxon.sf.net/feature/xsd-version");
            if ("1.1".equals(value)) {
                if (env == null) return false;
                env.processor.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", (Object)(inverse ? "1.0" : "1.1"));
            } else if ("1.0".equals(value)) {
                if (env == null) return false;
                env.processor.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", (Object)(inverse ? "1.1" : "1.0"));
            }
            env.resetActions.add(new Environment.ResetAction(){

                public void reset(Environment env) {
                    env.processor.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", (Object)old);
                }
            });
            return true;
        }
        if ("limits".equals(type)) {
            if (!"year_lt_0".equals(value)) {
                if (!"big_integer".equals(value)) return false;
            }
            if (inverse) return false;
            return true;
        }
        if ("spec".equals(type)) {
            return true;
        }
        if ("collection-stability".equals(type)) {
            if ("false".equals(value) == inverse) return false;
            return true;
        }
        if ("default-language".equals(type)) {
            if ("en".equals(value) == inverse) return false;
            return true;
        }
        if ("directory-as-collection-uri".equals(type)) {
            if ("true".equals(value) == inverse) return false;
            return true;
        }
        if ("language".equals(type)) {
            if (("en".equals(value) || "de".equals(value) || "fr".equals(value) || "it".equals(value) || "xib".equals(value)) == inverse) return false;
            return true;
        }
        if ("calendar".equals(type)) {
            if (("AD".equals(value) || "ISO".equals(value)) == inverse) return false;
            return true;
        }
        if ("format-integer-sequence".equals(type)) {
            if (inverse) return false;
            return true;
        }
        if ("unicode-normalization-form".equals(type)) {
            if (!value.equalsIgnoreCase("FULLY-NORMALIZED")) {
                if (inverse) return false;
                return true;
            }
            boolean bl = inverse;
            return bl;
        }
        if ("feature".equals(type)) {
            if ("namespace-axis".equals(value)) {
                if (inverse) return false;
                return true;
            }
            if ("higherOrderFunctions".equals(value)) {
                String edition = env.processor.getSaxonEdition();
                return (edition.equals("PE") || edition.equals("EE")) ^ inverse;
            }
            if ("schemaImport".equals(value)) return this.makeSchemaAware(env, inverse);
            if ("schemaValidation".equals(value)) return this.makeSchemaAware(env, inverse);
            if ("schemaAware".equals(value)) {
                return this.makeSchemaAware(env, inverse);
            }
            if ("xpath-1.0-compatibility".equals(value)) {
                if (env == null) return false;
                env.xpathCompiler.setBackwardsCompatible(!inverse);
                return true;
            }
            if ("staticTyping".equals(value)) {
                return inverse;
            }
            if ("moduleImport".equals(value)) {
                if (inverse) return false;
                return true;
            }
            if ("schema-location-hint".equals(value)) {
                String edition = env.processor.getUnderlyingConfiguration().getEditionCode();
                return (edition.equals("PE") || edition.equals("EE")) ^ inverse;
            }
            if ("infoset-dtd".equals(value)) {
                if (this.treeModel != TreeModel.TINY_TREE && this.treeModel != TreeModel.LINKED_TREE) {
                    if (this.treeModel != TreeModel.TINY_TREE_CONDENSED) return inverse;
                }
                if (inverse) return false;
                return true;
            }
            if ("serialization".equals(value)) {
                return true;
            }
            if ("non_unicode_codepoint_collation".equals(value)) {
                if (inverse) return false;
                return true;
            }
            if ("non_empty_sequence_collection".equals(value)) {
                if (inverse) return false;
                return true;
            }
            this.println("**** feature = " + value + "  ????");
            return false;
        }
        this.println("**** dependency not recognized: " + type);
        return false;
    }

    protected boolean makeSchemaAware(Environment env, boolean inverse) {
        return !inverse;
    }

    @Override
    protected void runTestCase(XdmNode testCase, XPathCompiler xpc) throws SaxonApiException {
        boolean run = true;
        Object specOpt = null;
        XPathCompiler xpath = this.driverProc.newXPathCompiler();
        String testCaseName = testCase.getAttributeValue(new QName("name"));
        String testSetName = testCase.getParent().getAttributeValue(new QName("name"));
        boolean needSerializedResult = ((XdmAtomicValue)xpc.evaluateSingle("exists(./result//assert-serialization-error) or exists(./result//serialization-matches)", (XdmItem)testCase)).getBooleanValue();
        boolean needResultValue = true;
        if (needSerializedResult) {
            needResultValue = ((XdmAtomicValue)xpc.evaluateSingle("exists(./result//*[not(self::serialization-matches or self::assert-serialization-error or self::any-of or self::all-of)])", (XdmItem)testCase)).getBooleanValue();
        }
        XdmNode alternativeResult = null;
        XdmNode optimization = null;
        String hostLang = this.spec.shortSpecName;
        String langVersion = this.spec.version;
        Environment env = this.getEnvironment(testCase, xpc);
        if (env == null) {
            ++this.notrun;
            return;
        }
        if (!env.usable) {
            this.writeTestcaseElement(testCaseName, "n/a", "environment dependencies not satisfied");
            ++this.notrun;
            return;
        }
        env.xpathCompiler.setBackwardsCompatible(false);
        env.processor.setXmlVersion("1.0");
        for (XdmItem dependency : xpc.evaluate("/*/dependency, ./dependency", (XdmItem)testCase)) {
            String type = ((XdmNode)dependency).getAttributeValue(new QName("type"));
            if (type == null) {
                throw new IllegalStateException("dependency/@type is missing");
            }
            String value = ((XdmNode)dependency).getAttributeValue(new QName("value"));
            if (value == null) {
                throw new IllegalStateException("dependency/@value is missing");
            }
            if (type.equals("spec")) {
                boolean applicable = false;
                if (!value.contains(this.spec.shortSpecName)) {
                    applicable = false;
                } else if (value.contains(this.spec.specAndVersion)) {
                    applicable = true;
                } else if ((this.spec.specAndVersion.equals("XQ30") || this.spec.specAndVersion.equals("XQ31")) && (value.contains("XQ10+") || value.contains("XQ30+"))) {
                    applicable = true;
                } else if ((this.spec.specAndVersion.equals("XP30") || this.spec.specAndVersion.equals("XP31")) && (value.contains("XP20+") || value.contains("XP30+"))) {
                    applicable = true;
                }
                if (!applicable) {
                    this.writeTestcaseElement(testCaseName, "n/a", "not" + this.spec.specAndVersion);
                    ++this.notrun;
                    return;
                }
            }
            if (langVersion.equals("3.0") || langVersion.equals("3.1")) {
                EnvironmentVariableResolver resolver = new EnvironmentVariableResolver(){

                    public Set<String> getAvailableEnvironmentVariables() {
                        HashSet<String> strings = new HashSet<String>();
                        strings.add("QTTEST");
                        strings.add("QTTEST2");
                        strings.add("QTTESTEMPTY");
                        return strings;
                    }

                    public String getEnvironmentVariable(String name) {
                        if (name.equals("QTTEST")) {
                            return "42";
                        }
                        if (name.equals("QTTEST2")) {
                            return "other";
                        }
                        if (name.equals("QTTESTEMPTY")) {
                            return "";
                        }
                        return null;
                    }
                };
                env.processor.setConfigurationProperty("http://saxon.sf.net/feature/environmentVariableResolver", (Object)resolver);
            }
            if (this.dependencyIsSatisfied((XdmNode)dependency, env)) continue;
            this.println("*** Dependency not satisfied: " + ((XdmNode)dependency).getAttributeValue(new QName("type")));
            this.writeTestcaseElement(testCaseName, "n/a", "Dependency not satisfied");
            ++this.notrun;
            return;
        }
        XdmNode exceptionElement = (XdmNode)this.exceptionsMap.get(testCaseName);
        if (exceptionElement != null) {
            String reportAtt;
            XdmItem config = xpath.evaluateSingle("configuration", (XdmItem)exceptionElement);
            String runAtt = exceptionElement.getAttributeValue(new QName("run"));
            String reasonMsg = exceptionElement.getAttributeValue(new QName("reason"));
            if (reasonMsg == null) {
                reasonMsg = "no reason given";
            }
            if ((reportAtt = exceptionElement.getAttributeValue(new QName("report"))) == null) {
                reportAtt = "";
            }
            if (config != null) {
                XdmItem paramValue = xpath.evaluateSingle("param[@name='not-unfolded' and @value='yes']/@name", config);
                if (this.unfolded && paramValue != null) {
                    this.writeTestcaseElement(testCaseName, "notRun", reasonMsg);
                    ++this.notrun;
                    return;
                }
            }
            if ("false".equals(runAtt)) {
                this.writeTestcaseElement(testCaseName, reportAtt, reasonMsg);
                ++this.notrun;
                return;
            }
            alternativeResult = (XdmNode)xpc.evaluateSingle("result", (XdmItem)exceptionElement);
            optimization = (XdmNode)xpc.evaluateSingle("optimization", (XdmItem)exceptionElement);
        }
        if (run && (specOpt == null || specOpt == this.spec)) {
            TestOutcome outcome = new TestOutcome(this);
            String exp = null;
            try {
                exp = xpc.evaluate("if (test/@file) then unparsed-text(resolve-uri(test/@file, base-uri(.))) else string(test)", (XdmItem)testCase).toString();
            }
            catch (SaxonApiException err) {
                this.println("*** Failed to read query: " + err.getMessage());
                outcome.setException(err);
            }
            if (outcome.getException() == null) {
                if (hostLang.equals("XP") || hostLang.equals("XT")) {
                    XPathCompiler testXpc = env.xpathCompiler;
                    testXpc.setLanguageVersion(langVersion);
                    testXpc.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
                    testXpc.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
                    testXpc.declareNamespace("map", "http://www.w3.org/2005/xpath-functions/map");
                    this.copySchemaNamespaces(env, testXpc);
                    try {
                        XPathSelector selector = testXpc.compile(exp).load();
                        for (QName varName : env.params.keySet()) {
                            selector.setVariable(varName, env.params.get(varName));
                        }
                        if (env.contextItem != null) {
                            selector.setContextItem(env.contextItem);
                        }
                        selector.setURIResolver((URIResolver)new TestURIResolver(env));
                        selector.setURIResolver((URIResolver)new TestURIResolver(env));
                        if (env.unparsedTextResolver != null) {
                            selector.getUnderlyingXPathContext().setUnparsedTextURIResolver(env.unparsedTextResolver);
                        }
                        XdmValue result = selector.evaluate();
                        outcome.setPrincipalResult(result);
                    }
                    catch (SaxonApiException err) {
                        this.println(err.getMessage());
                        outcome.setException(err);
                    }
                    catch (Exception err) {
                        this.println(err.getMessage());
                        err.printStackTrace();
                        this.writeTestcaseElement(testCaseName, "fail", "*** crashed: + err.getMessage()");
                    }
                } else if (hostLang.equals("XQ")) {
                    String vars;
                    XQueryCompiler testXqc = env.xqueryCompiler;
                    testXqc.setLanguageVersion(langVersion);
                    testXqc.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
                    testXqc.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
                    testXqc.declareNamespace("map", "http://www.w3.org/2005/xpath-functions/map");
                    ErrorCollector errorCollector = new ErrorCollector();
                    testXqc.setErrorListener((ErrorListener)((Object)errorCollector));
                    String decVars = env.paramDecimalDeclarations.toString();
                    if (decVars.length() != 0) {
                        int x = exp.indexOf("(:%DECL%:)");
                        exp = x < 0 ? decVars + exp : exp.substring(0, x) + decVars + exp.substring(x + 13);
                    }
                    if ((vars = env.paramDeclarations.toString()).length() != 0) {
                        int x = exp.indexOf("(:%VARDECL%:)");
                        exp = x < 0 ? vars + exp : exp.substring(0, x) + vars + exp.substring(x + 13);
                    }
                    ModuleResolver mr = new ModuleResolver(xpc);
                    mr.setTestCase(testCase);
                    testXqc.setModuleURIResolver((ModuleURIResolver)mr);
                    try {
                        XQueryExecutable q = testXqc.compile(exp);
                        if (optimization != null) {
                            XdmDestination expDest = new XdmDestination();
                            Configuration config = this.driverProc.getUnderlyingConfiguration();
                            ExpressionPresenter presenter = new ExpressionPresenter(config, expDest.getReceiver(config));
                            q.getUnderlyingCompiledQuery().explain(presenter);
                            presenter.close();
                            XdmNode explanation = expDest.getXdmNode();
                            XdmItem optResult = xpc.evaluateSingle(optimization.getAttributeValue(new QName("assert")), (XdmItem)explanation);
                            if (((XdmAtomicValue)optResult).getBooleanValue()) {
                                this.println("Optimization result OK");
                            } else {
                                this.println("Failed optimization test");
                                this.driverProc.writeXdmValue((XdmValue)explanation, (Destination)this.driverProc.newSerializer((OutputStream)System.err));
                                this.writeTestcaseElement(testCaseName, "fail", "Failed optimization assertions");
                                ++this.failures;
                                return;
                            }
                        }
                        XQueryEvaluator selector = q.load();
                        for (QName varName : env.params.keySet()) {
                            selector.setExternalVariable(varName, env.params.get(varName));
                        }
                        if (env.contextItem != null) {
                            selector.setContextItem(env.contextItem);
                        }
                        selector.setURIResolver((URIResolver)new TestURIResolver(env));
                        if (env.unparsedTextResolver != null) {
                            selector.getUnderlyingQueryContext().setUnparsedTextURIResolver(env.unparsedTextResolver);
                        }
                        if (needSerializedResult) {
                            StringWriter sw = new StringWriter();
                            Serializer serializer = env.processor.newSerializer((Writer)sw);
                            selector.setDestination((Destination)serializer);
                            selector.run();
                            outcome.setPrincipalSerializedResult(sw.toString());
                        }
                        if (needResultValue) {
                            XdmValue result = selector.evaluate();
                            outcome.setPrincipalResult(result);
                        }
                    }
                    catch (SaxonApiException err) {
                        this.println("in TestSet " + testSetName);
                        this.println(err.getMessage());
                        outcome.setException(err);
                        outcome.setErrorsReported(errorCollector.getErrorCodes());
                    }
                    catch (LicenseException err) {
                        this.println("in TestSet " + testSetName);
                        this.println(err.getMessage());
                        XPathException xe = new XPathException(err.getMessage(), "XPST0075");
                        outcome.setException(new SaxonApiException((Throwable)xe));
                        try {
                            errorCollector.error((TransformerException)((Object)xe));
                        }
                        catch (Exception e3) {
                            // empty catch block
                        }
                        outcome.setErrorsReported(errorCollector.getErrorCodes());
                    }
                } else {
                    this.writeTestcaseElement(testCaseName, "notRun", "No processor found");
                    ++this.notrun;
                    return;
                }
            }
            for (Environment.ResetAction action : env.resetActions) {
                action.reset(env);
            }
            env.resetActions.clear();
            XdmNode assertion = alternativeResult != null ? (XdmNode)xpc.evaluateSingle("*[1]", alternativeResult) : (XdmNode)xpc.evaluateSingle("result/*[1]", (XdmItem)testCase);
            if (assertion == null) {
                this.println("*** No assertions found for test case " + testCaseName);
                this.writeTestcaseElement(testCaseName, "disputed", "No assertions in test case");
                ++this.failures;
                return;
            }
            XPathCompiler assertXpc = env.processor.newXPathCompiler();
            assertXpc.setLanguageVersion("3.0");
            assertXpc.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
            assertXpc.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            assertXpc.declareNamespace("math", "http://www.w3.org/2005/xpath-functions/math");
            assertXpc.declareNamespace("map", "http://www.w3.org/2005/xpath-functions/map");
            assertXpc.declareVariable(new QName("result"));
            this.copySchemaNamespaces(env, assertXpc);
            boolean b = outcome.testAssertion(assertion, outcome.getPrincipalResultDoc(), assertXpc, xpc, this.debug);
            if (b) {
                this.writeTestcaseElement(testCaseName, "pass", null);
                ++this.successes;
            } else if (outcome.isException()) {
                XdmItem expectedError = xpc.evaluateSingle("result//error/@code", (XdmItem)testCase);
                if (expectedError == null) {
                    this.writeTestcaseElement(testCaseName, "fail", "Expected success, got " + outcome.getException().getErrorCode());
                    this.println("*** fail, result " + outcome.getException().getErrorCode() + " Expected success.");
                    ++this.failures;
                } else {
                    this.writeTestcaseElement(testCaseName, "wrongError", "Expected error:" + expectedError.getStringValue() + ", got " + outcome.getException().getErrorCode());
                    this.println("*** fail, result " + outcome.getException().getErrorCode() + " Expected error:" + expectedError.getStringValue());
                    ++this.wrongErrorResults;
                    ++this.successes;
                }
            } else {
                this.writeTestcaseElement(testCaseName, "fail", "Wrong results, got " + this.truncate(outcome.serialize(assertXpc.getProcessor(), outcome.getPrincipalResultDoc())));
                ++this.failures;
                if (this.debug) {
                    try {
                        this.println("Result:");
                        this.driverSerializer.serializeXdmValue(outcome.getPrincipalResult());
                        this.println("<=======");
                    }
                    catch (Exception err) {}
                } else {
                    this.println("*** fail (use -debug to show actual result)");
                }
            }
        }
    }

    private void copySchemaNamespaces(Environment env, XPathCompiler testXpc) {
        Configuration config = env.xpathCompiler.getProcessor().getUnderlyingConfiguration();
        for (String s : config.getImportedNamespaces()) {
            testXpc.importSchemaNamespace(s);
        }
    }

    private String truncate(String in) {
        if (in.length() > 80) {
            return in.substring(0, 80) + "...";
        }
        return in;
    }

    @Override
    protected void writeResultFilePreamble(Processor processor, XdmNode catalog) throws Exception {
        this.resultsDoc.writeResultFilePreamble(processor, catalog);
    }

    @Override
    protected void writeResultFilePostamble() throws XMLStreamException {
        this.resultsDoc.writeResultFilePostamble();
    }

    @Override
    protected void startTestSetElement(XdmNode testSetNode) {
        this.resultsDoc.startTestSetElement(testSetNode);
    }

    @Override
    protected void writeTestSetEndElement() {
        this.resultsDoc.endElement();
    }

    private void writeTestcaseElement(String name, String result, String comment) {
        this.resultsDoc.writeTestcaseElement(name, result, comment);
    }

    public static Sequence lazyLiteral(Sequence value) {
        return value;
    }

    private void buildDependencyMap(Processor processor, Environment env) throws SaxonApiException {
        XQueryCompiler xqCompiler = processor.newXQueryCompiler();
        xqCompiler.setLanguageVersion("3.0");
        xqCompiler.setBaseURI(new File(System.getProperty("user.dir")).toURI());
        XdmValue result = xqCompiler.compile("        declare namespace fots = \"http://www.w3.org/2010/09/qt-fots-catalog\";\n        let $testsets := doc('" + this.testSuiteDir + "/catalog.xml')//fots:test-set/@file/doc(resolve-uri(., exactly-one(base-uri(.))))\n" + "        for $dependencyTS in $testsets//fots:dependency\n" + "        let $name := $dependencyTS/@type\n" + "        let $value := $dependencyTS/@value\n" + "        group by $name, $value\n" + "        order by $name, $value\n" + "        return <dependency type='{$name}' value='{$value}' />").load().evaluate();
        for (XdmItem item : result) {
            XdmNode node = (XdmNode)item;
            String type = node.getAttributeValue(new QName("type"));
            String value = node.getAttributeValue(new QName("value"));
            this.addDependency(type, value, this.dependencyIsSatisfied(node, env));
        }
    }

    public void addDependency(String depStr, String value, boolean satisfied) {
        if (!this.dependencyMap.containsKey(value)) {
            Dependency dep = new Dependency();
            dep.dType = depStr;
            dep.satisfied = satisfied;
            this.dependencyMap.put(value, dep);
        }
    }

    protected class Dependency {
        public String dType;
        public boolean satisfied;

        protected Dependency() {
        }
    }

    public static class TestURIResolver
    implements URIResolver {
        Environment env;

        public TestURIResolver(Environment env) {
            this.env = env;
        }

        public Source resolve(String href, String base) throws TransformerException {
            XdmNode node = this.env.sourceDocs.get(href);
            if (node == null) {
                return null;
            }
            return node.asSource();
        }
    }

    public static class ModuleResolver
    extends StandardModuleURIResolver {
        XPathCompiler catXPC;
        XdmNode testCase;

        public ModuleResolver(XPathCompiler xpc) {
            this.catXPC = xpc;
        }

        public void setTestCase(XdmNode testCase) {
            this.testCase = testCase;
        }

        public StreamSource[] resolve(String moduleURI, String baseURI, String[] locations) throws XPathException {
            try {
                XdmValue files = this.catXPC.evaluate("./module[@uri='" + moduleURI + "']/@file/string()", (XdmItem)this.testCase);
                if (files.size() == 0) {
                    throw new XPathException("Failed to find module entry for " + moduleURI);
                }
                StreamSource[] ss = new StreamSource[files.size()];
                for (int i = 0; i < files.size(); ++i) {
                    URI uri = this.testCase.getBaseURI().resolve(files.itemAt(i).toString());
                    ss[i] = this.getQuerySource(uri);
                }
                return ss;
            }
            catch (SaxonApiException e) {
                throw new XPathException((Throwable)e);
            }
        }
    }
}

