/*
 * Decompiled with CFR 0.152.
 */
package unsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public abstract class Utils {
    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(FileChannel fileChannel) {
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void delete(File file) {
        if (file == null) {
            return;
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferFile(File file, File file2) throws IOException {
        if (file == null) {
            throw new NullPointerException("Input must not be null.");
        }
        if (file2 == null) {
            throw new NullPointerException("Output must not be null.");
        }
        if (file.isDirectory()) {
            throw new IOException("Input must not be a directory. " + file.getAbsolutePath());
        }
        if (file2.isDirectory()) {
            throw new IOException("Output must not be a directory. " + file2.getAbsolutePath());
        }
        if (file.getCanonicalFile().equals(file2.getCanonicalFile())) {
            throw new IOException("Input must be different from output.");
        }
        if (file2.exists() && !file2.delete()) {
            throw new IOException("Unable to delete output file. " + file2.getAbsolutePath());
        }
        File file3 = file2.getParentFile();
        if (file3 != null) {
            file3.mkdirs();
            if (!file3.isDirectory() || !file3.exists()) {
                throw new IOException("Output parent is not an existing directory. " + file2.getAbsolutePath());
            }
            if (!file3.canWrite()) {
                throw new IOException("Can't write to output parent. " + file2.getAbsolutePath());
            }
        }
        FileChannel fileChannel = null;
        FileInputStream fileInputStream = null;
        FileChannel fileChannel2 = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileChannel = fileInputStream.getChannel();
            fileOutputStream = new FileOutputStream(file2);
            fileChannel2 = fileOutputStream.getChannel();
            long l = file.length();
            for (long i = 0L; i < l; i += fileChannel2.transferFrom(fileChannel, i, l - i)) {
            }
        }
        catch (Throwable throwable) {
            Utils.close(fileChannel);
            Utils.close(fileInputStream);
            Utils.close(fileChannel2);
            Utils.close(fileOutputStream);
            throw throwable;
        }
        Utils.close(fileChannel);
        Utils.close(fileInputStream);
        Utils.close(fileChannel2);
        Utils.close(fileOutputStream);
        if (file2.length() != file.length()) {
            throw new IOException("Input file failed to transfer to output file. output.length() != input.length() input: " + file.getAbsolutePath() + " output: " + file2.getAbsolutePath());
        }
        Utils.delete(file);
    }
}

