# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import map_error
from azure.core.async_paging import AsyncItemPaged, AsyncList
from ... import models
import uuid


class KeyVaultClientOperationsMixin:

    async def create_key(self, vault_base_url, key_name, kty, key_size=None, key_ops=None, key_attributes=None, tags=None, curve=None, *, cls=None, **kwargs):
        """Creates a new key, stores it, then returns key parameters and
        attributes to the client.

        The create key operation can be used to create any key type in Azure
        Key Vault. If the named key already exists, Azure Key Vault creates a
        new version of the key. It requires the keys/create permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name for the new key. The system will generate
         the version name for the new key.
        :type key_name: str
        :param kty: The type of key to create. For valid values, see
         JsonWebKeyType. Possible values include: 'EC', 'EC-HSM', 'RSA',
         'RSA-HSM', 'oct'
        :type kty: str or ~azure.keyvault.v7_0.models.JsonWebKeyType
        :param key_size: The key size in bits. For example: 2048, 3072, or
         4096 for RSA.
        :type key_size: int
        :param key_ops:
        :type key_ops: list[str or
         ~azure.keyvault.v7_0.models.JsonWebKeyOperation]
        :param key_attributes:
        :type key_attributes: ~azure.keyvault.v7_0.models.KeyAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param curve: Elliptic curve name. For valid values, see
         JsonWebKeyCurveName. Possible values include: 'P-256', 'P-384',
         'P-521', 'P-256K'
        :type curve: str or ~azure.keyvault.v7_0.models.JsonWebKeyCurveName
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.KeyCreateParameters(kty=kty, key_size=key_size, key_ops=key_ops, key_attributes=key_attributes, tags=tags, curve=curve)

        # Construct URL
        url = self.create_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str', pattern=r'^[0-9a-zA-Z-]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'KeyCreateParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    create_key.metadata = {'url': '/keys/{key-name}/create'}

    async def import_key(self, vault_base_url, key_name, key, hsm=None, key_attributes=None, tags=None, *, cls=None, **kwargs):
        """Imports an externally created key, stores it, and returns key
        parameters and attributes to the client.

        The import key operation may be used to import any key type into an
        Azure Key Vault. If the named key already exists, Azure Key Vault
        creates a new version of the key. This operation requires the
        keys/import permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: Name for the imported key.
        :type key_name: str
        :param key: The Json web key
        :type key: ~azure.keyvault.v7_0.models.JsonWebKey
        :param hsm: Whether to import as a hardware key (HSM) or software key.
        :type hsm: bool
        :param key_attributes: The key management attributes.
        :type key_attributes: ~azure.keyvault.v7_0.models.KeyAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.KeyImportParameters(hsm=hsm, key=key, key_attributes=key_attributes, tags=tags)

        # Construct URL
        url = self.import_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str', pattern=r'^[0-9a-zA-Z-]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'KeyImportParameters')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    import_key.metadata = {'url': '/keys/{key-name}'}

    async def delete_key(self, vault_base_url, key_name, *, cls=None, **kwargs):
        """Deletes a key of any type from storage in Azure Key Vault.

        The delete key operation cannot be used to remove individual versions
        of a key. This operation removes the cryptographic material associated
        with the key, which means the key is not usable for Sign/Verify,
        Wrap/Unwrap or Encrypt/Decrypt operations. This operation requires the
        keys/delete permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key to delete.
        :type key_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: DeletedKeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedKeyBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.delete_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DeletedKeyBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    delete_key.metadata = {'url': '/keys/{key-name}'}

    async def update_key(self, vault_base_url, key_name, key_version, key_ops=None, key_attributes=None, tags=None, *, cls=None, **kwargs):
        """The update key operation changes specified attributes of a stored key
        and can be applied to any key type and key version stored in Azure Key
        Vault.

        In order to perform this operation, the key must already exist in the
        Key Vault. Note: The cryptographic material of a key itself cannot be
        changed. This operation requires the keys/update permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of key to update.
        :type key_name: str
        :param key_version: The version of the key to update.
        :type key_version: str
        :param key_ops: Json web key operations. For more information on
         possible key operations, see JsonWebKeyOperation.
        :type key_ops: list[str or
         ~azure.keyvault.v7_0.models.JsonWebKeyOperation]
        :param key_attributes:
        :type key_attributes: ~azure.keyvault.v7_0.models.KeyAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.KeyUpdateParameters(key_ops=key_ops, key_attributes=key_attributes, tags=tags)

        # Construct URL
        url = self.update_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'KeyUpdateParameters')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    update_key.metadata = {'url': '/keys/{key-name}/{key-version}'}

    async def get_key(self, vault_base_url, key_name, key_version, *, cls=None, **kwargs):
        """Gets the public part of a stored key.

        The get key operation is applicable to all key types. If the requested
        key is symmetric, then no key material is released in the response.
        This operation requires the keys/get permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key to get.
        :type key_name: str
        :param key_version: Adding the version parameter retrieves a specific
         version of a key.
        :type key_version: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_key.metadata = {'url': '/keys/{key-name}/{key-version}'}

    def get_key_versions(
            self, vault_base_url, key_name, maxresults=None, *, cls=None, **kwargs):
        """Retrieves a list of individual key versions with the same key name.

        The full key identifier, attributes, and tags are provided in the
        response. This operation requires the keys/list permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of KeyItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.KeyItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_key_versions.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                    'key-name': self._serialize.url("key_name", key_name, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('KeyListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_key_versions.metadata = {'url': '/keys/{key-name}/versions'}

    def get_keys(
            self, vault_base_url, maxresults=None, *, cls=None, **kwargs):
        """List keys in the specified vault.

        Retrieves a list of the keys in the Key Vault as JSON Web Key
        structures that contain the public part of a stored key. The LIST
        operation is applicable to all key types, however only the base key
        identifier, attributes, and tags are provided in the response.
        Individual versions of a key are not listed in the response. This
        operation requires the keys/list permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of KeyItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.KeyItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_keys.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('KeyListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_keys.metadata = {'url': '/keys'}

    async def backup_key(self, vault_base_url, key_name, *, cls=None, **kwargs):
        """Requests that a backup of the specified key be downloaded to the
        client.

        The Key Backup operation exports a key from Azure Key Vault in a
        protected form. Note that this operation does NOT return key material
        in a form that can be used outside the Azure Key Vault system, the
        returned key material is either protected to a Azure Key Vault HSM or
        to Azure Key Vault itself. The intent of this operation is to allow a
        client to GENERATE a key in one Azure Key Vault instance, BACKUP the
        key, and then RESTORE it into another Azure Key Vault instance. The
        BACKUP operation may be used to export, in protected form, any key type
        from Azure Key Vault. Individual versions of a key cannot be backed up.
        BACKUP / RESTORE can be performed within geographical boundaries only;
        meaning that a BACKUP from one geographical area cannot be restored to
        another geographical area. For example, a backup from the US
        geographical area cannot be restored in an EU geographical area. This
        operation requires the key/backup permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: BackupKeyResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.BackupKeyResult
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.backup_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('BackupKeyResult', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    backup_key.metadata = {'url': '/keys/{key-name}/backup'}

    async def restore_key(self, vault_base_url, key_bundle_backup, *, cls=None, **kwargs):
        """Restores a backed up key to a vault.

        Imports a previously backed up key into Azure Key Vault, restoring the
        key, its key identifier, attributes and access control policies. The
        RESTORE operation may be used to import a previously backed up key.
        Individual versions of a key cannot be restored. The key is restored in
        its entirety with the same key name as it had when it was backed up. If
        the key name is not available in the target Key Vault, the RESTORE
        operation will be rejected. While the key name is retained during
        restore, the final key identifier will change if the key is restored to
        a different vault. Restore will restore all versions and preserve
        version identifiers. The RESTORE operation is subject to security
        constraints: The target Key Vault must be owned by the same Microsoft
        Azure Subscription as the source Key Vault The user must have RESTORE
        permission in the target Key Vault. This operation requires the
        keys/restore permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_bundle_backup: The backup blob associated with a key
         bundle.
        :type key_bundle_backup: bytes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.KeyRestoreParameters(key_bundle_backup=key_bundle_backup)

        # Construct URL
        url = self.restore_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'KeyRestoreParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    restore_key.metadata = {'url': '/keys/restore'}

    async def encrypt(self, vault_base_url, key_name, key_version, algorithm, value, *, cls=None, **kwargs):
        """Encrypts an arbitrary sequence of bytes using an encryption key that is
        stored in a key vault.

        The ENCRYPT operation encrypts an arbitrary sequence of bytes using an
        encryption key that is stored in Azure Key Vault. Note that the ENCRYPT
        operation only supports a single block of data, the size of which is
        dependent on the target key and the encryption algorithm to be used.
        The ENCRYPT operation is only strictly necessary for symmetric keys
        stored in Azure Key Vault since protection with an asymmetric key can
        be performed using public portion of the key. This operation is
        supported for asymmetric keys as a convenience for callers that have a
        key-reference but do not have access to the public key material. This
        operation requires the keys/encrypt permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param algorithm: algorithm identifier. Possible values include:
         'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
        :type algorithm: str or
         ~azure.keyvault.v7_0.models.JsonWebKeyEncryptionAlgorithm
        :param value:
        :type value: bytes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyOperationResult
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.KeyOperationsParameters(algorithm=algorithm, value=value)

        # Construct URL
        url = self.encrypt.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'KeyOperationsParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyOperationResult', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    encrypt.metadata = {'url': '/keys/{key-name}/{key-version}/encrypt'}

    async def decrypt(self, vault_base_url, key_name, key_version, algorithm, value, *, cls=None, **kwargs):
        """Decrypts a single block of encrypted data.

        The DECRYPT operation decrypts a well-formed block of ciphertext using
        the target encryption key and specified algorithm. This operation is
        the reverse of the ENCRYPT operation; only a single block of data may
        be decrypted, the size of this block is dependent on the target key and
        the algorithm to be used. The DECRYPT operation applies to asymmetric
        and symmetric keys stored in Azure Key Vault since it uses the private
        portion of the key. This operation requires the keys/decrypt
        permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param algorithm: algorithm identifier. Possible values include:
         'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
        :type algorithm: str or
         ~azure.keyvault.v7_0.models.JsonWebKeyEncryptionAlgorithm
        :param value:
        :type value: bytes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyOperationResult
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.KeyOperationsParameters(algorithm=algorithm, value=value)

        # Construct URL
        url = self.decrypt.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'KeyOperationsParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyOperationResult', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    decrypt.metadata = {'url': '/keys/{key-name}/{key-version}/decrypt'}

    async def sign(self, vault_base_url, key_name, key_version, algorithm, value, *, cls=None, **kwargs):
        """Creates a signature from a digest using the specified key.

        The SIGN operation is applicable to asymmetric and symmetric keys
        stored in Azure Key Vault since this operation uses the private portion
        of the key. This operation requires the keys/sign permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param algorithm: The signing/verification algorithm identifier. For
         more information on possible algorithm types, see
         JsonWebKeySignatureAlgorithm. Possible values include: 'PS256',
         'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256',
         'ES384', 'ES512', 'ES256K'
        :type algorithm: str or
         ~azure.keyvault.v7_0.models.JsonWebKeySignatureAlgorithm
        :param value:
        :type value: bytes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyOperationResult
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.KeySignParameters(algorithm=algorithm, value=value)

        # Construct URL
        url = self.sign.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'KeySignParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyOperationResult', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    sign.metadata = {'url': '/keys/{key-name}/{key-version}/sign'}

    async def verify(self, vault_base_url, key_name, key_version, algorithm, digest, signature, *, cls=None, **kwargs):
        """Verifies a signature using a specified key.

        The VERIFY operation is applicable to symmetric keys stored in Azure
        Key Vault. VERIFY is not strictly necessary for asymmetric keys stored
        in Azure Key Vault since signature verification can be performed using
        the public portion of the key but this operation is supported as a
        convenience for callers that only have a key-reference and not the
        public portion of the key. This operation requires the keys/verify
        permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param algorithm: The signing/verification algorithm. For more
         information on possible algorithm types, see
         JsonWebKeySignatureAlgorithm. Possible values include: 'PS256',
         'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256',
         'ES384', 'ES512', 'ES256K'
        :type algorithm: str or
         ~azure.keyvault.v7_0.models.JsonWebKeySignatureAlgorithm
        :param digest: The digest used for signing.
        :type digest: bytes
        :param signature: The signature to be verified.
        :type signature: bytes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyVerifyResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyVerifyResult
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.KeyVerifyParameters(algorithm=algorithm, digest=digest, signature=signature)

        # Construct URL
        url = self.verify.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'KeyVerifyParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyVerifyResult', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    verify.metadata = {'url': '/keys/{key-name}/{key-version}/verify'}

    async def wrap_key(self, vault_base_url, key_name, key_version, algorithm, value, *, cls=None, **kwargs):
        """Wraps a symmetric key using a specified key.

        The WRAP operation supports encryption of a symmetric key using a key
        encryption key that has previously been stored in an Azure Key Vault.
        The WRAP operation is only strictly necessary for symmetric keys stored
        in Azure Key Vault since protection with an asymmetric key can be
        performed using the public portion of the key. This operation is
        supported for asymmetric keys as a convenience for callers that have a
        key-reference but do not have access to the public key material. This
        operation requires the keys/wrapKey permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param algorithm: algorithm identifier. Possible values include:
         'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
        :type algorithm: str or
         ~azure.keyvault.v7_0.models.JsonWebKeyEncryptionAlgorithm
        :param value:
        :type value: bytes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyOperationResult
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.KeyOperationsParameters(algorithm=algorithm, value=value)

        # Construct URL
        url = self.wrap_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'KeyOperationsParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyOperationResult', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    wrap_key.metadata = {'url': '/keys/{key-name}/{key-version}/wrapkey'}

    async def unwrap_key(self, vault_base_url, key_name, key_version, algorithm, value, *, cls=None, **kwargs):
        """Unwraps a symmetric key using the specified key that was initially used
        for wrapping that key.

        The UNWRAP operation supports decryption of a symmetric key using the
        target key encryption key. This operation is the reverse of the WRAP
        operation. The UNWRAP operation applies to asymmetric and symmetric
        keys stored in Azure Key Vault since it uses the private portion of the
        key. This operation requires the keys/unwrapKey permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param algorithm: algorithm identifier. Possible values include:
         'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
        :type algorithm: str or
         ~azure.keyvault.v7_0.models.JsonWebKeyEncryptionAlgorithm
        :param value:
        :type value: bytes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyOperationResult
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.KeyOperationsParameters(algorithm=algorithm, value=value)

        # Construct URL
        url = self.unwrap_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'KeyOperationsParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyOperationResult', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    unwrap_key.metadata = {'url': '/keys/{key-name}/{key-version}/unwrapkey'}

    def get_deleted_keys(
            self, vault_base_url, maxresults=None, *, cls=None, **kwargs):
        """Lists the deleted keys in the specified vault.

        Retrieves a list of the keys in the Key Vault as JSON Web Key
        structures that contain the public part of a deleted key. This
        operation includes deletion-specific information. The Get Deleted Keys
        operation is applicable for vaults enabled for soft-delete. While the
        operation can be invoked on any vault, it will return an error if
        invoked on a non soft-delete enabled vault. This operation requires the
        keys/list permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of DeletedKeyItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.DeletedKeyItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_deleted_keys.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('DeletedKeyListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_deleted_keys.metadata = {'url': '/deletedkeys'}

    async def get_deleted_key(self, vault_base_url, key_name, *, cls=None, **kwargs):
        """Gets the public part of a deleted key.

        The Get Deleted Key operation is applicable for soft-delete enabled
        vaults. While the operation can be invoked on any vault, it will return
        an error if invoked on a non soft-delete enabled vault. This operation
        requires the keys/get permission. .

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: DeletedKeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedKeyBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_deleted_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DeletedKeyBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_deleted_key.metadata = {'url': '/deletedkeys/{key-name}'}

    async def purge_deleted_key(self, vault_base_url, key_name, *, cls=None, **kwargs):
        """Permanently deletes the specified key.

        The Purge Deleted Key operation is applicable for soft-delete enabled
        vaults. While the operation can be invoked on any vault, it will return
        an error if invoked on a non soft-delete enabled vault. This operation
        requires the keys/purge permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key
        :type key_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.purge_deleted_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        if cls:
            response_headers = {}
            return cls(response, None, response_headers)
    purge_deleted_key.metadata = {'url': '/deletedkeys/{key-name}'}

    async def recover_deleted_key(self, vault_base_url, key_name, *, cls=None, **kwargs):
        """Recovers the deleted key to its latest version.

        The Recover Deleted Key operation is applicable for deleted keys in
        soft-delete enabled vaults. It recovers the deleted key back to its
        latest version under /keys. An attempt to recover an non-deleted key
        will return an error. Consider this the inverse of the delete operation
        on soft-delete enabled vaults. This operation requires the keys/recover
        permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the deleted key.
        :type key_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.KeyBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.recover_deleted_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('KeyBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    recover_deleted_key.metadata = {'url': '/deletedkeys/{key-name}/recover'}

    async def set_secret(self, vault_base_url, secret_name, value, tags=None, content_type=None, secret_attributes=None, *, cls=None, **kwargs):
        """Sets a secret in a specified key vault.

        The SET operation adds a secret to the Azure Key Vault. If the named
        secret already exists, Azure Key Vault creates a new version of that
        secret. This operation requires the secrets/set permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param value: The value of the secret.
        :type value: str
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param content_type: Type of the secret value such as a password.
        :type content_type: str
        :param secret_attributes: The secret management attributes.
        :type secret_attributes: ~azure.keyvault.v7_0.models.SecretAttributes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.SecretBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.SecretSetParameters(value=value, tags=tags, content_type=content_type, secret_attributes=secret_attributes)

        # Construct URL
        url = self.set_secret.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'secret-name': self._serialize.url("secret_name", secret_name, 'str', pattern=r'^[0-9a-zA-Z-]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'SecretSetParameters')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SecretBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    set_secret.metadata = {'url': '/secrets/{secret-name}'}

    async def delete_secret(self, vault_base_url, secret_name, *, cls=None, **kwargs):
        """Deletes a secret from a specified key vault.

        The DELETE operation applies to any secret stored in Azure Key Vault.
        DELETE cannot be applied to an individual version of a secret. This
        operation requires the secrets/delete permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: DeletedSecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedSecretBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.delete_secret.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'secret-name': self._serialize.url("secret_name", secret_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DeletedSecretBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    delete_secret.metadata = {'url': '/secrets/{secret-name}'}

    async def update_secret(self, vault_base_url, secret_name, secret_version, content_type=None, secret_attributes=None, tags=None, *, cls=None, **kwargs):
        """Updates the attributes associated with a specified secret in a given
        key vault.

        The UPDATE operation changes specified attributes of an existing stored
        secret. Attributes that are not specified in the request are left
        unchanged. The value of a secret itself cannot be changed. This
        operation requires the secrets/set permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param secret_version: The version of the secret.
        :type secret_version: str
        :param content_type: Type of the secret value such as a password.
        :type content_type: str
        :param secret_attributes: The secret management attributes.
        :type secret_attributes: ~azure.keyvault.v7_0.models.SecretAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.SecretBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.SecretUpdateParameters(content_type=content_type, secret_attributes=secret_attributes, tags=tags)

        # Construct URL
        url = self.update_secret.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'secret-name': self._serialize.url("secret_name", secret_name, 'str'),
            'secret-version': self._serialize.url("secret_version", secret_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'SecretUpdateParameters')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SecretBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    update_secret.metadata = {'url': '/secrets/{secret-name}/{secret-version}'}

    async def get_secret(self, vault_base_url, secret_name, secret_version, *, cls=None, **kwargs):
        """Get a specified secret from a given key vault.

        The GET operation is applicable to any secret stored in Azure Key
        Vault. This operation requires the secrets/get permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param secret_version: The version of the secret.
        :type secret_version: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.SecretBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_secret.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'secret-name': self._serialize.url("secret_name", secret_name, 'str'),
            'secret-version': self._serialize.url("secret_version", secret_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SecretBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_secret.metadata = {'url': '/secrets/{secret-name}/{secret-version}'}

    def get_secrets(
            self, vault_base_url, maxresults=None, *, cls=None, **kwargs):
        """List secrets in a specified key vault.

        The Get Secrets operation is applicable to the entire vault. However,
        only the base secret identifier and its attributes are provided in the
        response. Individual secret versions are not listed in the response.
        This operation requires the secrets/list permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified, the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of SecretItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.SecretItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_secrets.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('SecretListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_secrets.metadata = {'url': '/secrets'}

    def get_secret_versions(
            self, vault_base_url, secret_name, maxresults=None, *, cls=None, **kwargs):
        """List all versions of the specified secret.

        The full secret identifier and attributes are provided in the response.
        No values are returned for the secrets. This operations requires the
        secrets/list permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified, the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of SecretItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.SecretItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_secret_versions.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                    'secret-name': self._serialize.url("secret_name", secret_name, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('SecretListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_secret_versions.metadata = {'url': '/secrets/{secret-name}/versions'}

    def get_deleted_secrets(
            self, vault_base_url, maxresults=None, *, cls=None, **kwargs):
        """Lists deleted secrets for the specified vault.

        The Get Deleted Secrets operation returns the secrets that have been
        deleted for a vault enabled for soft-delete. This operation requires
        the secrets/list permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of DeletedSecretItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.DeletedSecretItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_deleted_secrets.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('DeletedSecretListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_deleted_secrets.metadata = {'url': '/deletedsecrets'}

    async def get_deleted_secret(self, vault_base_url, secret_name, *, cls=None, **kwargs):
        """Gets the specified deleted secret.

        The Get Deleted Secret operation returns the specified deleted secret
        along with its attributes. This operation requires the secrets/get
        permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: DeletedSecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedSecretBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_deleted_secret.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'secret-name': self._serialize.url("secret_name", secret_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DeletedSecretBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_deleted_secret.metadata = {'url': '/deletedsecrets/{secret-name}'}

    async def purge_deleted_secret(self, vault_base_url, secret_name, *, cls=None, **kwargs):
        """Permanently deletes the specified secret.

        The purge deleted secret operation removes the secret permanently,
        without the possibility of recovery. This operation can only be enabled
        on a soft-delete enabled vault. This operation requires the
        secrets/purge permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.purge_deleted_secret.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'secret-name': self._serialize.url("secret_name", secret_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        if cls:
            response_headers = {}
            return cls(response, None, response_headers)
    purge_deleted_secret.metadata = {'url': '/deletedsecrets/{secret-name}'}

    async def recover_deleted_secret(self, vault_base_url, secret_name, *, cls=None, **kwargs):
        """Recovers the deleted secret to the latest version.

        Recovers the deleted secret in the specified vault. This operation can
        only be performed on a soft-delete enabled vault. This operation
        requires the secrets/recover permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the deleted secret.
        :type secret_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.SecretBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.recover_deleted_secret.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'secret-name': self._serialize.url("secret_name", secret_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SecretBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    recover_deleted_secret.metadata = {'url': '/deletedsecrets/{secret-name}/recover'}

    async def backup_secret(self, vault_base_url, secret_name, *, cls=None, **kwargs):
        """Backs up the specified secret.

        Requests that a backup of the specified secret be downloaded to the
        client. All versions of the secret will be downloaded. This operation
        requires the secrets/backup permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_name: The name of the secret.
        :type secret_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: BackupSecretResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.BackupSecretResult
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.backup_secret.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'secret-name': self._serialize.url("secret_name", secret_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('BackupSecretResult', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    backup_secret.metadata = {'url': '/secrets/{secret-name}/backup'}

    async def restore_secret(self, vault_base_url, secret_bundle_backup, *, cls=None, **kwargs):
        """Restores a backed up secret to a vault.

        Restores a backed up secret, and all its versions, to a vault. This
        operation requires the secrets/restore permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param secret_bundle_backup: The backup blob associated with a secret
         bundle.
        :type secret_bundle_backup: bytes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.SecretBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.SecretRestoreParameters(secret_bundle_backup=secret_bundle_backup)

        # Construct URL
        url = self.restore_secret.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'SecretRestoreParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SecretBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    restore_secret.metadata = {'url': '/secrets/restore'}

    def get_certificates(
            self, vault_base_url, maxresults=None, include_pending=None, *, cls=None, **kwargs):
        """List certificates in a specified key vault.

        The GetCertificates operation returns the set of certificates resources
        in the specified key vault. This operation requires the
        certificates/list permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :param include_pending: Specifies whether to include certificates
         which are not completely provisioned.
        :type include_pending: bool
        :return: An iterator like instance of CertificateItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.CertificateItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_certificates.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                if include_pending is not None:
                    query_parameters['includePending'] = self._serialize.query("include_pending", include_pending, 'bool')
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('CertificateListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_certificates.metadata = {'url': '/certificates'}

    async def delete_certificate(self, vault_base_url, certificate_name, *, cls=None, **kwargs):
        """Deletes a certificate from a specified key vault.

        Deletes all versions of a certificate object along with its associated
        policy. Delete certificate cannot be used to remove individual versions
        of a certificate object. This operation requires the
        certificates/delete permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: DeletedCertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedCertificateBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.delete_certificate.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DeletedCertificateBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    delete_certificate.metadata = {'url': '/certificates/{certificate-name}'}

    async def set_certificate_contacts(self, vault_base_url, contact_list=None, *, cls=None, **kwargs):
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This
        operation requires the certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param contact_list: The contact list for the vault certificates.
        :type contact_list: list[~azure.keyvault.v7_0.models.Contact]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.Contacts
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        contacts = models.Contacts(contact_list=contact_list)

        # Construct URL
        url = self.set_certificate_contacts.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(contacts, 'Contacts')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('Contacts', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    set_certificate_contacts.metadata = {'url': '/certificates/contacts'}

    async def get_certificate_contacts(self, vault_base_url, *, cls=None, **kwargs):
        """Lists the certificate contacts for a specified key vault.

        The GetCertificateContacts operation returns the set of certificate
        contact resources in the specified key vault. This operation requires
        the certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.Contacts
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_certificate_contacts.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('Contacts', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_certificate_contacts.metadata = {'url': '/certificates/contacts'}

    async def delete_certificate_contacts(self, vault_base_url, *, cls=None, **kwargs):
        """Deletes the certificate contacts for a specified key vault.

        Deletes the certificate contacts for a specified key vault certificate.
        This operation requires the certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.Contacts
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.delete_certificate_contacts.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('Contacts', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    delete_certificate_contacts.metadata = {'url': '/certificates/contacts'}

    def get_certificate_issuers(
            self, vault_base_url, maxresults=None, *, cls=None, **kwargs):
        """List certificate issuers for a specified key vault.

        The GetCertificateIssuers operation returns the set of certificate
        issuer resources in the specified key vault. This operation requires
        the certificates/manageissuers/getissuers permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of CertificateIssuerItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.CertificateIssuerItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_certificate_issuers.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('CertificateIssuerListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_certificate_issuers.metadata = {'url': '/certificates/issuers'}

    async def set_certificate_issuer(self, vault_base_url, issuer_name, provider, credentials=None, organization_details=None, attributes=None, *, cls=None, **kwargs):
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified
        certificate issuer. This operation requires the certificates/setissuers
        permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :param provider: The issuer provider.
        :type provider: str
        :param credentials: The credentials to be used for the issuer.
        :type credentials: ~azure.keyvault.v7_0.models.IssuerCredentials
        :param organization_details: Details of the organization as provided
         to the issuer.
        :type organization_details:
         ~azure.keyvault.v7_0.models.OrganizationDetails
        :param attributes: Attributes of the issuer object.
        :type attributes: ~azure.keyvault.v7_0.models.IssuerAttributes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.IssuerBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameter = models.CertificateIssuerSetParameters(provider=provider, credentials=credentials, organization_details=organization_details, attributes=attributes)

        # Construct URL
        url = self.set_certificate_issuer.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'issuer-name': self._serialize.url("issuer_name", issuer_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameter, 'CertificateIssuerSetParameters')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('IssuerBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    set_certificate_issuer.metadata = {'url': '/certificates/issuers/{issuer-name}'}

    async def update_certificate_issuer(self, vault_base_url, issuer_name, provider=None, credentials=None, organization_details=None, attributes=None, *, cls=None, **kwargs):
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the
        specified certificate issuer entity. This operation requires the
        certificates/setissuers permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :param provider: The issuer provider.
        :type provider: str
        :param credentials: The credentials to be used for the issuer.
        :type credentials: ~azure.keyvault.v7_0.models.IssuerCredentials
        :param organization_details: Details of the organization as provided
         to the issuer.
        :type organization_details:
         ~azure.keyvault.v7_0.models.OrganizationDetails
        :param attributes: Attributes of the issuer object.
        :type attributes: ~azure.keyvault.v7_0.models.IssuerAttributes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.IssuerBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameter = models.CertificateIssuerUpdateParameters(provider=provider, credentials=credentials, organization_details=organization_details, attributes=attributes)

        # Construct URL
        url = self.update_certificate_issuer.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'issuer-name': self._serialize.url("issuer_name", issuer_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameter, 'CertificateIssuerUpdateParameters')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('IssuerBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    update_certificate_issuer.metadata = {'url': '/certificates/issuers/{issuer-name}'}

    async def get_certificate_issuer(self, vault_base_url, issuer_name, *, cls=None, **kwargs):
        """Lists the specified certificate issuer.

        The GetCertificateIssuer operation returns the specified certificate
        issuer resources in the specified key vault. This operation requires
        the certificates/manageissuers/getissuers permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.IssuerBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_certificate_issuer.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'issuer-name': self._serialize.url("issuer_name", issuer_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('IssuerBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_certificate_issuer.metadata = {'url': '/certificates/issuers/{issuer-name}'}

    async def delete_certificate_issuer(self, vault_base_url, issuer_name, *, cls=None, **kwargs):
        """Deletes the specified certificate issuer.

        The DeleteCertificateIssuer operation permanently removes the specified
        certificate issuer from the vault. This operation requires the
        certificates/manageissuers/deleteissuers permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.IssuerBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.delete_certificate_issuer.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'issuer-name': self._serialize.url("issuer_name", issuer_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('IssuerBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    delete_certificate_issuer.metadata = {'url': '/certificates/issuers/{issuer-name}'}

    async def create_certificate(self, vault_base_url, certificate_name, certificate_policy=None, certificate_attributes=None, tags=None, *, cls=None, **kwargs):
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This
        operation requires the certificates/create permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param certificate_policy: The management policy for the certificate.
        :type certificate_policy:
         ~azure.keyvault.v7_0.models.CertificatePolicy
        :param certificate_attributes: The attributes of the certificate
         (optional).
        :type certificate_attributes:
         ~azure.keyvault.v7_0.models.CertificateAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificateOperation
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.CertificateCreateParameters(certificate_policy=certificate_policy, certificate_attributes=certificate_attributes, tags=tags)

        # Construct URL
        url = self.create_certificate.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str', pattern=r'^[0-9a-zA-Z-]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'CertificateCreateParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 202:
            deserialized = self._deserialize('CertificateOperation', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    create_certificate.metadata = {'url': '/certificates/{certificate-name}/create'}

    async def import_certificate(self, vault_base_url, certificate_name, base64_encoded_certificate, password=None, certificate_policy=None, certificate_attributes=None, tags=None, *, cls=None, **kwargs):
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into
        Azure Key Vault. The certificate to be imported can be in either PFX or
        PEM format. If the certificate is in PEM format the PEM file must
        contain the key as well as x509 certificates. This operation requires
        the certificates/import permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param base64_encoded_certificate: Base64 encoded representation of
         the certificate object to import. This certificate needs to contain
         the private key.
        :type base64_encoded_certificate: str
        :param password: If the private key in base64EncodedCertificate is
         encrypted, the password used for encryption.
        :type password: str
        :param certificate_policy: The management policy for the certificate.
        :type certificate_policy:
         ~azure.keyvault.v7_0.models.CertificatePolicy
        :param certificate_attributes: The attributes of the certificate
         (optional).
        :type certificate_attributes:
         ~azure.keyvault.v7_0.models.CertificateAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificateBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.CertificateImportParameters(base64_encoded_certificate=base64_encoded_certificate, password=password, certificate_policy=certificate_policy, certificate_attributes=certificate_attributes, tags=tags)

        # Construct URL
        url = self.import_certificate.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str', pattern=r'^[0-9a-zA-Z-]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'CertificateImportParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CertificateBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    import_certificate.metadata = {'url': '/certificates/{certificate-name}/import'}

    def get_certificate_versions(
            self, vault_base_url, certificate_name, maxresults=None, *, cls=None, **kwargs):
        """List the versions of a certificate.

        The GetCertificateVersions operation returns the versions of a
        certificate in the specified key vault. This operation requires the
        certificates/list permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of CertificateItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.CertificateItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_certificate_versions.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                    'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('CertificateListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_certificate_versions.metadata = {'url': '/certificates/{certificate-name}/versions'}

    async def get_certificate_policy(self, vault_base_url, certificate_name, *, cls=None, **kwargs):
        """Lists the policy for a certificate.

        The GetCertificatePolicy operation returns the specified certificate
        policy resources in the specified key vault. This operation requires
        the certificates/get permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in a given key
         vault.
        :type certificate_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificatePolicy or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificatePolicy
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_certificate_policy.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CertificatePolicy', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_certificate_policy.metadata = {'url': '/certificates/{certificate-name}/policy'}

    async def update_certificate_policy(self, vault_base_url, certificate_name, certificate_policy, *, cls=None, **kwargs):
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null.
        This operation requires the certificates/update permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given
         vault.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate.
        :type certificate_policy:
         ~azure.keyvault.v7_0.models.CertificatePolicy
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificatePolicy or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificatePolicy
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.update_certificate_policy.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(certificate_policy, 'CertificatePolicy')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CertificatePolicy', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    update_certificate_policy.metadata = {'url': '/certificates/{certificate-name}/policy'}

    async def update_certificate(self, vault_base_url, certificate_name, certificate_version, certificate_policy=None, certificate_attributes=None, tags=None, *, cls=None, **kwargs):
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the
        given certificate; the only elements updated are the certificate's
        attributes. This operation requires the certificates/update permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given key
         vault.
        :type certificate_name: str
        :param certificate_version: The version of the certificate.
        :type certificate_version: str
        :param certificate_policy: The management policy for the certificate.
        :type certificate_policy:
         ~azure.keyvault.v7_0.models.CertificatePolicy
        :param certificate_attributes: The attributes of the certificate
         (optional).
        :type certificate_attributes:
         ~azure.keyvault.v7_0.models.CertificateAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificateBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.CertificateUpdateParameters(certificate_policy=certificate_policy, certificate_attributes=certificate_attributes, tags=tags)

        # Construct URL
        url = self.update_certificate.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
            'certificate-version': self._serialize.url("certificate_version", certificate_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'CertificateUpdateParameters')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CertificateBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    update_certificate.metadata = {'url': '/certificates/{certificate-name}/{certificate-version}'}

    async def get_certificate(self, vault_base_url, certificate_name, certificate_version, *, cls=None, **kwargs):
        """Gets information about a certificate.

        Gets information about a specific certificate. This operation requires
        the certificates/get permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given
         vault.
        :type certificate_name: str
        :param certificate_version: The version of the certificate.
        :type certificate_version: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificateBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_certificate.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
            'certificate-version': self._serialize.url("certificate_version", certificate_version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CertificateBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_certificate.metadata = {'url': '/certificates/{certificate-name}/{certificate-version}'}

    async def update_certificate_operation(self, vault_base_url, certificate_name, cancellation_requested, *, cls=None, **kwargs):
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress.
        This operation requires the certificates/update permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param cancellation_requested: Indicates if cancellation was requested
         on the certificate operation.
        :type cancellation_requested: bool
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificateOperation
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        certificate_operation = models.CertificateOperationUpdateParameter(cancellation_requested=cancellation_requested)

        # Construct URL
        url = self.update_certificate_operation.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(certificate_operation, 'CertificateOperationUpdateParameter')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CertificateOperation', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    update_certificate_operation.metadata = {'url': '/certificates/{certificate-name}/pending'}

    async def get_certificate_operation(self, vault_base_url, certificate_name, *, cls=None, **kwargs):
        """Gets the creation operation of a certificate.

        Gets the creation operation associated with a specified certificate.
        This operation requires the certificates/get permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificateOperation
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_certificate_operation.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CertificateOperation', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_certificate_operation.metadata = {'url': '/certificates/{certificate-name}/pending'}

    async def delete_certificate_operation(self, vault_base_url, certificate_name, *, cls=None, **kwargs):
        """Deletes the creation operation for a specific certificate.

        Deletes the creation operation for a specified certificate that is in
        the process of being created. The certificate is no longer created.
        This operation requires the certificates/update permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificateOperation
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.delete_certificate_operation.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CertificateOperation', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    delete_certificate_operation.metadata = {'url': '/certificates/{certificate-name}/pending'}

    async def merge_certificate(self, vault_base_url, certificate_name, x509_certificates, certificate_attributes=None, tags=None, *, cls=None, **kwargs):
        """Merges a certificate or a certificate chain with a key pair existing on
        the server.

        The MergeCertificate operation performs the merging of a certificate or
        certificate chain with a key pair currently available in the service.
        This operation requires the certificates/create permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param x509_certificates: The certificate or the certificate chain to
         merge.
        :type x509_certificates: list[bytearray]
        :param certificate_attributes: The attributes of the certificate
         (optional).
        :type certificate_attributes:
         ~azure.keyvault.v7_0.models.CertificateAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificateBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.CertificateMergeParameters(x509_certificates=x509_certificates, certificate_attributes=certificate_attributes, tags=tags)

        # Construct URL
        url = self.merge_certificate.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'CertificateMergeParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 201:
            deserialized = self._deserialize('CertificateBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    merge_certificate.metadata = {'url': '/certificates/{certificate-name}/pending/merge'}

    async def backup_certificate(self, vault_base_url, certificate_name, *, cls=None, **kwargs):
        """Backs up the specified certificate.

        Requests that a backup of the specified certificate be downloaded to
        the client. All versions of the certificate will be downloaded. This
        operation requires the certificates/backup permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: BackupCertificateResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.BackupCertificateResult
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.backup_certificate.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('BackupCertificateResult', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    backup_certificate.metadata = {'url': '/certificates/{certificate-name}/backup'}

    async def restore_certificate(self, vault_base_url, certificate_bundle_backup, *, cls=None, **kwargs):
        """Restores a backed up certificate to a vault.

        Restores a backed up certificate, and all its versions, to a vault.
        This operation requires the certificates/restore permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_bundle_backup: The backup blob associated with a
         certificate bundle.
        :type certificate_bundle_backup: bytes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificateBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.CertificateRestoreParameters(certificate_bundle_backup=certificate_bundle_backup)

        # Construct URL
        url = self.restore_certificate.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'CertificateRestoreParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CertificateBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    restore_certificate.metadata = {'url': '/certificates/restore'}

    def get_deleted_certificates(
            self, vault_base_url, maxresults=None, include_pending=None, *, cls=None, **kwargs):
        """Lists the deleted certificates in the specified vault currently
        available for recovery.

        The GetDeletedCertificates operation retrieves the certificates in the
        current vault which are in a deleted state and ready for recovery or
        purging. This operation includes deletion-specific information. This
        operation requires the certificates/get/list permission. This operation
        can only be enabled on soft-delete enabled vaults.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :param include_pending: Specifies whether to include certificates
         which are not completely provisioned.
        :type include_pending: bool
        :return: An iterator like instance of DeletedCertificateItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.DeletedCertificateItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_deleted_certificates.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                if include_pending is not None:
                    query_parameters['includePending'] = self._serialize.query("include_pending", include_pending, 'bool')
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('DeletedCertificateListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_deleted_certificates.metadata = {'url': '/deletedcertificates'}

    async def get_deleted_certificate(self, vault_base_url, certificate_name, *, cls=None, **kwargs):
        """Retrieves information about the specified deleted certificate.

        The GetDeletedCertificate operation retrieves the deleted certificate
        information plus its attributes, such as retention interval, scheduled
        permanent deletion and the current deletion recovery level. This
        operation requires the certificates/get permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate
        :type certificate_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: DeletedCertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedCertificateBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_deleted_certificate.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DeletedCertificateBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_deleted_certificate.metadata = {'url': '/deletedcertificates/{certificate-name}'}

    async def purge_deleted_certificate(self, vault_base_url, certificate_name, *, cls=None, **kwargs):
        """Permanently deletes the specified deleted certificate.

        The PurgeDeletedCertificate operation performs an irreversible deletion
        of the specified certificate, without possibility for recovery. The
        operation is not available if the recovery level does not specify
        'Purgeable'. This operation requires the certificate/purge permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate
        :type certificate_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.purge_deleted_certificate.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        if cls:
            response_headers = {}
            return cls(response, None, response_headers)
    purge_deleted_certificate.metadata = {'url': '/deletedcertificates/{certificate-name}'}

    async def recover_deleted_certificate(self, vault_base_url, certificate_name, *, cls=None, **kwargs):
        """Recovers the deleted certificate back to its current version under
        /certificates.

        The RecoverDeletedCertificate operation performs the reversal of the
        Delete operation. The operation is applicable in vaults enabled for
        soft-delete, and must be issued during the retention interval
        (available in the deleted certificate's attributes). This operation
        requires the certificates/recover permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the deleted certificate
        :type certificate_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.CertificateBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.recover_deleted_certificate.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CertificateBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    recover_deleted_certificate.metadata = {'url': '/deletedcertificates/{certificate-name}/recover'}

    def get_storage_accounts(
            self, vault_base_url, maxresults=None, *, cls=None, **kwargs):
        """List storage accounts managed by the specified key vault. This
        operation requires the storage/list permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of StorageAccountItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.StorageAccountItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_storage_accounts.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('StorageListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_storage_accounts.metadata = {'url': '/storage'}

    def get_deleted_storage_accounts(
            self, vault_base_url, maxresults=None, *, cls=None, **kwargs):
        """Lists deleted storage accounts for the specified vault.

        The Get Deleted Storage Accounts operation returns the storage accounts
        that have been deleted for a vault enabled for soft-delete. This
        operation requires the storage/list permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of DeletedStorageAccountItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.DeletedStorageAccountItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_deleted_storage_accounts.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('DeletedStorageListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_deleted_storage_accounts.metadata = {'url': '/deletedstorage'}

    async def get_deleted_storage_account(self, vault_base_url, storage_account_name, *, cls=None, **kwargs):
        """Gets the specified deleted storage account.

        The Get Deleted Storage Account operation returns the specified deleted
        storage account along with its attributes. This operation requires the
        storage/get permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: DeletedStorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedStorageBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_deleted_storage_account.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DeletedStorageBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_deleted_storage_account.metadata = {'url': '/deletedstorage/{storage-account-name}'}

    async def purge_deleted_storage_account(self, vault_base_url, storage_account_name, *, cls=None, **kwargs):
        """Permanently deletes the specified storage account.

        The purge deleted storage account operation removes the secret
        permanently, without the possibility of recovery. This operation can
        only be performed on a soft-delete enabled vault. This operation
        requires the storage/purge permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.purge_deleted_storage_account.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        if cls:
            response_headers = {}
            return cls(response, None, response_headers)
    purge_deleted_storage_account.metadata = {'url': '/deletedstorage/{storage-account-name}'}

    async def recover_deleted_storage_account(self, vault_base_url, storage_account_name, *, cls=None, **kwargs):
        """Recovers the deleted storage account.

        Recovers the deleted storage account in the specified vault. This
        operation can only be performed on a soft-delete enabled vault. This
        operation requires the storage/recover permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.StorageBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.recover_deleted_storage_account.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('StorageBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    recover_deleted_storage_account.metadata = {'url': '/deletedstorage/{storage-account-name}/recover'}

    async def backup_storage_account(self, vault_base_url, storage_account_name, *, cls=None, **kwargs):
        """Backs up the specified storage account.

        Requests that a backup of the specified storage account be downloaded
        to the client. This operation requires the storage/backup permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: BackupStorageResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.BackupStorageResult
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.backup_storage_account.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('BackupStorageResult', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    backup_storage_account.metadata = {'url': '/storage/{storage-account-name}/backup'}

    async def restore_storage_account(self, vault_base_url, storage_bundle_backup, *, cls=None, **kwargs):
        """Restores a backed up storage account to a vault.

        Restores a backed up storage account to a vault. This operation
        requires the storage/restore permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_bundle_backup: The backup blob associated with a
         storage account.
        :type storage_bundle_backup: bytes
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.StorageBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.StorageRestoreParameters(storage_bundle_backup=storage_bundle_backup)

        # Construct URL
        url = self.restore_storage_account.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'StorageRestoreParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('StorageBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    restore_storage_account.metadata = {'url': '/storage/restore'}

    async def delete_storage_account(self, vault_base_url, storage_account_name, *, cls=None, **kwargs):
        """Deletes a storage account. This operation requires the storage/delete
        permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: DeletedStorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedStorageBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.delete_storage_account.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DeletedStorageBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    delete_storage_account.metadata = {'url': '/storage/{storage-account-name}'}

    async def get_storage_account(self, vault_base_url, storage_account_name, *, cls=None, **kwargs):
        """Gets information about a specified storage account. This operation
        requires the storage/get permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.StorageBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_storage_account.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('StorageBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_storage_account.metadata = {'url': '/storage/{storage-account-name}'}

    async def set_storage_account(self, vault_base_url, storage_account_name, resource_id, active_key_name, auto_regenerate_key, regeneration_period=None, storage_account_attributes=None, tags=None, *, cls=None, **kwargs):
        """Creates or updates a new storage account. This operation requires the
        storage/set permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param resource_id: Storage account resource id.
        :type resource_id: str
        :param active_key_name: Current active storage account key name.
        :type active_key_name: str
        :param auto_regenerate_key: whether keyvault should manage the storage
         account for the user.
        :type auto_regenerate_key: bool
        :param regeneration_period: The key regeneration time duration
         specified in ISO-8601 format.
        :type regeneration_period: str
        :param storage_account_attributes: The attributes of the storage
         account.
        :type storage_account_attributes:
         ~azure.keyvault.v7_0.models.StorageAccountAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.StorageBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.StorageAccountCreateParameters(resource_id=resource_id, active_key_name=active_key_name, auto_regenerate_key=auto_regenerate_key, regeneration_period=regeneration_period, storage_account_attributes=storage_account_attributes, tags=tags)

        # Construct URL
        url = self.set_storage_account.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'StorageAccountCreateParameters')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('StorageBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    set_storage_account.metadata = {'url': '/storage/{storage-account-name}'}

    async def update_storage_account(self, vault_base_url, storage_account_name, active_key_name=None, auto_regenerate_key=None, regeneration_period=None, storage_account_attributes=None, tags=None, *, cls=None, **kwargs):
        """Updates the specified attributes associated with the given storage
        account. This operation requires the storage/set/update permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param active_key_name: The current active storage account key name.
        :type active_key_name: str
        :param auto_regenerate_key: whether keyvault should manage the storage
         account for the user.
        :type auto_regenerate_key: bool
        :param regeneration_period: The key regeneration time duration
         specified in ISO-8601 format.
        :type regeneration_period: str
        :param storage_account_attributes: The attributes of the storage
         account.
        :type storage_account_attributes:
         ~azure.keyvault.v7_0.models.StorageAccountAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.StorageBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.StorageAccountUpdateParameters(active_key_name=active_key_name, auto_regenerate_key=auto_regenerate_key, regeneration_period=regeneration_period, storage_account_attributes=storage_account_attributes, tags=tags)

        # Construct URL
        url = self.update_storage_account.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'StorageAccountUpdateParameters')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('StorageBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    update_storage_account.metadata = {'url': '/storage/{storage-account-name}'}

    async def regenerate_storage_account_key(self, vault_base_url, storage_account_name, key_name, *, cls=None, **kwargs):
        """Regenerates the specified key value for the given storage account. This
        operation requires the storage/regeneratekey permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param key_name: The storage account key name.
        :type key_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.StorageBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.StorageAccountRegenerteKeyParameters(key_name=key_name)

        # Construct URL
        url = self.regenerate_storage_account_key.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'StorageAccountRegenerteKeyParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('StorageBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    regenerate_storage_account_key.metadata = {'url': '/storage/{storage-account-name}/regeneratekey'}

    def get_sas_definitions(
            self, vault_base_url, storage_account_name, maxresults=None, *, cls=None, **kwargs):
        """List storage SAS definitions for the given storage account. This
        operation requires the storage/listsas permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of SasDefinitionItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.SasDefinitionItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_sas_definitions.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                    'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('SasDefinitionListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_sas_definitions.metadata = {'url': '/storage/{storage-account-name}/sas'}

    def get_deleted_sas_definitions(
            self, vault_base_url, storage_account_name, maxresults=None, *, cls=None, **kwargs):
        """Lists deleted SAS definitions for the specified vault and storage
        account.

        The Get Deleted Sas Definitions operation returns the SAS definitions
        that have been deleted for a vault enabled for soft-delete. This
        operation requires the storage/listsas permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param maxresults: Maximum number of results to return in a page. If
         not specified the service will return up to 25 results.
        :type maxresults: int
        :return: An iterator like instance of DeletedSasDefinitionItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v7_0.models.DeletedSasDefinitionItem]
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.get_deleted_sas_definitions.metadata['url']
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                    'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
                }
                url = self._client.format_url(url, **path_format_arguments)
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('DeletedSasDefinitionListResult', response)
            list_of_elem = deserialized.value
            if cls:
               list_of_elem = cls(list_of_elem)
            return deserialized.next_link, AsyncList(list_of_elem)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise models.KeyVaultErrorException(response, self._deserialize)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    get_deleted_sas_definitions.metadata = {'url': '/deletedstorage/{storage-account-name}/sas'}

    async def get_deleted_sas_definition(self, vault_base_url, storage_account_name, sas_definition_name, *, cls=None, **kwargs):
        """Gets the specified deleted sas definition.

        The Get Deleted SAS Definition operation returns the specified deleted
        SAS definition along with its attributes. This operation requires the
        storage/getsas permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: DeletedSasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedSasDefinitionBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_deleted_sas_definition.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$'),
            'sas-definition-name': self._serialize.url("sas_definition_name", sas_definition_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DeletedSasDefinitionBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_deleted_sas_definition.metadata = {'url': '/deletedstorage/{storage-account-name}/sas/{sas-definition-name}'}

    async def recover_deleted_sas_definition(self, vault_base_url, storage_account_name, sas_definition_name, *, cls=None, **kwargs):
        """Recovers the deleted SAS definition.

        Recovers the deleted SAS definition for the specified storage account.
        This operation can only be performed on a soft-delete enabled vault.
        This operation requires the storage/recover permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.SasDefinitionBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.recover_deleted_sas_definition.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$'),
            'sas-definition-name': self._serialize.url("sas_definition_name", sas_definition_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SasDefinitionBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    recover_deleted_sas_definition.metadata = {'url': '/deletedstorage/{storage-account-name}/sas/{sas-definition-name}/recover'}

    async def delete_sas_definition(self, vault_base_url, storage_account_name, sas_definition_name, *, cls=None, **kwargs):
        """Deletes a SAS definition from a specified storage account. This
        operation requires the storage/deletesas permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: DeletedSasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.DeletedSasDefinitionBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.delete_sas_definition.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$'),
            'sas-definition-name': self._serialize.url("sas_definition_name", sas_definition_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('DeletedSasDefinitionBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    delete_sas_definition.metadata = {'url': '/storage/{storage-account-name}/sas/{sas-definition-name}'}

    async def get_sas_definition(self, vault_base_url, storage_account_name, sas_definition_name, *, cls=None, **kwargs):
        """Gets information about a SAS definition for the specified storage
        account. This operation requires the storage/getsas permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.SasDefinitionBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_sas_definition.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$'),
            'sas-definition-name': self._serialize.url("sas_definition_name", sas_definition_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SasDefinitionBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    get_sas_definition.metadata = {'url': '/storage/{storage-account-name}/sas/{sas-definition-name}'}

    async def set_sas_definition(self, vault_base_url, storage_account_name, sas_definition_name, template_uri, sas_type, validity_period, sas_definition_attributes=None, tags=None, *, cls=None, **kwargs):
        """Creates or updates a new SAS definition for the specified storage
        account. This operation requires the storage/setsas permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :param template_uri: The SAS definition token template signed with an
         arbitrary key.  Tokens created according to the SAS definition will
         have the same properties as the template.
        :type template_uri: str
        :param sas_type: The type of SAS token the SAS definition will create.
         Possible values include: 'account', 'service'
        :type sas_type: str or ~azure.keyvault.v7_0.models.SasTokenType
        :param validity_period: The validity period of SAS tokens created
         according to the SAS definition.
        :type validity_period: str
        :param sas_definition_attributes: The attributes of the SAS
         definition.
        :type sas_definition_attributes:
         ~azure.keyvault.v7_0.models.SasDefinitionAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.SasDefinitionBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.SasDefinitionCreateParameters(template_uri=template_uri, sas_type=sas_type, validity_period=validity_period, sas_definition_attributes=sas_definition_attributes, tags=tags)

        # Construct URL
        url = self.set_sas_definition.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$'),
            'sas-definition-name': self._serialize.url("sas_definition_name", sas_definition_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'SasDefinitionCreateParameters')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SasDefinitionBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    set_sas_definition.metadata = {'url': '/storage/{storage-account-name}/sas/{sas-definition-name}'}

    async def update_sas_definition(self, vault_base_url, storage_account_name, sas_definition_name, template_uri=None, sas_type=None, validity_period=None, sas_definition_attributes=None, tags=None, *, cls=None, **kwargs):
        """Updates the specified attributes associated with the given SAS
        definition. This operation requires the storage/setsas permission.

        :param vault_base_url: The vault name, for example
         https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition.
        :type sas_definition_name: str
        :param template_uri: The SAS definition token template signed with an
         arbitrary key.  Tokens created according to the SAS definition will
         have the same properties as the template.
        :type template_uri: str
        :param sas_type: The type of SAS token the SAS definition will create.
         Possible values include: 'account', 'service'
        :type sas_type: str or ~azure.keyvault.v7_0.models.SasTokenType
        :param validity_period: The validity period of SAS tokens created
         according to the SAS definition.
        :type validity_period: str
        :param sas_definition_attributes: The attributes of the SAS
         definition.
        :type sas_definition_attributes:
         ~azure.keyvault.v7_0.models.SasDefinitionAttributes
        :param tags: Application specific metadata in the form of key-value
         pairs.
        :type tags: dict[str, str]
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_0.models.SasDefinitionBundle
        :raises:
         :class:`KeyVaultErrorException<azure.keyvault.v7_0.models.KeyVaultErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        parameters = models.SasDefinitionUpdateParameters(template_uri=template_uri, sas_type=sas_type, validity_period=validity_period, sas_definition_attributes=sas_definition_attributes, tags=tags)

        # Construct URL
        url = self.update_sas_definition.metadata['url']
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'storage-account-name': self._serialize.url("storage_account_name", storage_account_name, 'str', pattern=r'^[0-9a-zA-Z]+$'),
            'sas-definition-name': self._serialize.url("sas_definition_name", sas_definition_name, 'str', pattern=r'^[0-9a-zA-Z]+$')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(parameters, 'SasDefinitionUpdateParameters')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.KeyVaultErrorException(response, self._deserialize)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SasDefinitionBundle', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    update_sas_definition.metadata = {'url': '/storage/{storage-account-name}/sas/{sas-definition-name}'}
