
/* Chrysalide - Outil d'analyse de fichiers binaires
 * cache_oleaut32.c - fourniture des ordinaux du fichier oleaut32.dll
 *
 * Copyright (C) 2021 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "cache_oleaut32.h"


#include <stddef.h>



/**
 * Empreintes du fichier oleaut32.dll :
 *
 *   - MD5 : 9ee967cf9b388c7faaec9f04700eb47b
 *   - SHA1 : ef5be564b84a7de92b12acbcd69d5f580fabcd89
 *   - SHA256 : cf34badd43d9e69ca9f01352c4d89c9fd9f4ab53832b1589215a8544462f346d
 */


/* Liste des ordinaux référencés */
static const char *_oleaut32_ordinals[501] = {
    [2] = "SysAllocString",
    [3] = "SysReAllocString",
    [4] = "SysAllocStringLen",
    [5] = "SysReAllocStringLen",
    [6] = "SysFreeString",
    [7] = "SysStringLen",
    [8] = "VariantInit",
    [9] = "VariantClear",
    [10] = "VariantCopy",
    [11] = "VariantCopyInd",
    [12] = "VariantChangeType",
    [13] = "VariantTimeToDosDateTime",
    [14] = "DosDateTimeToVariantTime",
    [15] = "SafeArrayCreate",
    [16] = "SafeArrayDestroy",
    [17] = "SafeArrayGetDim",
    [18] = "SafeArrayGetElemsize",
    [19] = "SafeArrayGetUBound",
    [20] = "SafeArrayGetLBound",
    [21] = "SafeArrayLock",
    [22] = "SafeArrayUnlock",
    [23] = "SafeArrayAccessData",
    [24] = "SafeArrayUnaccessData",
    [25] = "SafeArrayGetElement",
    [26] = "SafeArrayPutElement",
    [27] = "SafeArrayCopy",
    [28] = "DispGetParam",
    [29] = "DispGetIDsOfNames",
    [30] = "DispInvoke",
    [31] = "CreateDispTypeInfo",
    [32] = "CreateStdDispatch",
    [33] = "RegisterActiveObject",
    [34] = "RevokeActiveObject",
    [35] = "GetActiveObject",
    [36] = "SafeArrayAllocDescriptor",
    [37] = "SafeArrayAllocData",
    [38] = "SafeArrayDestroyDescriptor",
    [39] = "SafeArrayDestroyData",
    [40] = "SafeArrayRedim",
    [41] = "SafeArrayAllocDescriptorEx",
    [42] = "SafeArrayCreateEx",
    [43] = "SafeArrayCreateVectorEx",
    [44] = "SafeArraySetRecordInfo",
    [45] = "SafeArrayGetRecordInfo",
    [47] = "VarNumFromParseNum",
    [48] = "VarI2FromUI1",
    [49] = "VarI2FromI4",
    [50] = "VarI2FromR4",
    [51] = "VarI2FromR8",
    [52] = "VarI2FromCy",
    [53] = "VarI2FromDate",
    [54] = "VarI2FromStr",
    [55] = "VarI2FromDisp",
    [56] = "VarI2FromBool",
    [57] = "SafeArraySetIID",
    [58] = "VarI4FromUI1",
    [59] = "VarI4FromI2",
    [60] = "VarI4FromR4",
    [61] = "VarI4FromR8",
    [62] = "VarI4FromCy",
    [63] = "VarI4FromDate",
    [65] = "VarI4FromDisp",
    [66] = "VarI4FromBool",
    [67] = "SafeArrayGetIID",
    [68] = "VarR4FromUI1",
    [69] = "VarR4FromI2",
    [70] = "VarR4FromI4",
    [71] = "VarR4FromR8",
    [72] = "VarR4FromCy",
    [73] = "VarR4FromDate",
    [75] = "VarR4FromDisp",
    [76] = "VarR4FromBool",
    [77] = "SafeArrayGetVartype",
    [78] = "VarR8FromUI1",
    [79] = "VarR8FromI2",
    [80] = "VarR8FromI4",
    [81] = "VarR8FromR4",
    [82] = "VarR8FromCy",
    [83] = "VarR8FromDate",
    [85] = "VarR8FromDisp",
    [88] = "VarDateFromUI1",
    [89] = "VarDateFromI2",
    [90] = "VarDateFromI4",
    [91] = "VarDateFromR4",
    [92] = "VarDateFromR8",
    [93] = "VarDateFromCy",
    [95] = "VarDateFromDisp",
    [96] = "VarDateFromBool",
    [98] = "VarCyFromUI1",
    [99] = "VarCyFromI2",
    [100] = "VarCyFromI4",
    [102] = "VarCyFromR8",
    [103] = "VarCyFromDate",
    [104] = "VarCyFromStr",
    [105] = "VarCyFromDisp",
    [106] = "VarCyFromBool",
    [107] = "VarFormatNumber",
    [108] = "VarBstrFromUI1",
    [109] = "VarBstrFromI2",
    [110] = "VarBstrFromI4",
    [111] = "VarBstrFromR4",
    [112] = "VarBstrFromR8",
    [113] = "VarBstrFromCy",
    [114] = "VarBstrFromDate",
    [115] = "VarBstrFromDisp",
    [116] = "VarBstrFromBool",
    [119] = "VarBoolFromI2",
    [120] = "VarBoolFromI4",
    [121] = "VarBoolFromR4",
    [122] = "VarBoolFromR8",
    [123] = "VarBoolFromDate",
    [124] = "VarBoolFromCy",
    [125] = "VarBoolFromStr",
    [126] = "VarBoolFromDisp",
    [127] = "VarFormatCurrency",
    [129] = "VarMonthName",
    [130] = "VarUI1FromI2",
    [131] = "VarUI1FromI4",
    [132] = "VarUI1FromR4",
    [133] = "VarUI1FromR8",
    [134] = "VarUI1FromCy",
    [135] = "VarUI1FromDate",
    [137] = "VarUI1FromDisp",
    [138] = "VarUI1FromBool",
    [139] = "VarFormatFromTokens",
    [140] = "VarTokenizeFormatString",
    [141] = "VarAdd",
    [143] = "VarDiv",
    [144] = "BSTR_UserFree64",
    [145] = "BSTR_UserMarshal64",
    [146] = "DispCallFunc",
    [147] = "VariantChangeTypeEx",
    [148] = "SafeArrayPtrOfIndex",
    [149] = "SysStringByteLen",
    [150] = "SysAllocStringByteLen",
    [151] = "BSTR_UserSize64",
    [152] = "VarEqv",
    [153] = "VarIdiv",
    [154] = "VarImp",
    [155] = "VarMod",
    [156] = "VarMul",
    [157] = "VarOr",
    [158] = "VarPow",
    [159] = "VarSub",
    [160] = "CreateTypeLib",
    [161] = "LoadTypeLib",
    [162] = "LoadRegTypeLib",
    [163] = "RegisterTypeLib",
    [164] = "QueryPathOfRegTypeLib",
    [165] = "LHashValOfNameSys",
    [166] = "LHashValOfNameSysA",
    [167] = "VarXor",
    [168] = "VarAbs",
    [169] = "VarFix",
    [170] = "OaBuildVersion",
    [171] = "ClearCustData",
    [172] = "VarInt",
    [173] = "VarNeg",
    [174] = "VarNot",
    [175] = "VarRound",
    [176] = "VarCmp",
    [177] = "VarDecAdd",
    [179] = "VarDecMul",
    [180] = "CreateTypeLib2",
    [181] = "VarDecSub",
    [182] = "VarDecAbs",
    [183] = "LoadTypeLibEx",
    [184] = "SystemTimeToVariantTime",
    [185] = "VariantTimeToSystemTime",
    [186] = "UnRegisterTypeLib",
    [187] = "VarDecFix",
    [188] = "VarDecInt",
    [189] = "VarDecNeg",
    [190] = "VarDecFromUI1",
    [191] = "VarDecFromI2",
    [192] = "VarDecFromI4",
    [193] = "VarDecFromR4",
    [194] = "VarDecFromR8",
    [195] = "VarDecFromDate",
    [196] = "VarDecFromCy",
    [197] = "VarDecFromStr",
    [198] = "VarDecFromDisp",
    [199] = "VarDecFromBool",
    [200] = "GetErrorInfo",
    [201] = "SetErrorInfo",
    [202] = "CreateErrorInfo",
    [203] = "VarDecRound",
    [204] = "VarDecCmp",
    [205] = "VarI2FromI1",
    [206] = "VarI2FromUI2",
    [207] = "VarI2FromUI4",
    [208] = "VarI2FromDec",
    [209] = "VarI4FromI1",
    [210] = "VarI4FromUI2",
    [211] = "VarI4FromUI4",
    [212] = "VarI4FromDec",
    [213] = "VarR4FromI1",
    [214] = "VarR4FromUI2",
    [215] = "VarR4FromUI4",
    [216] = "VarR4FromDec",
    [217] = "VarR8FromI1",
    [218] = "VarR8FromUI2",
    [219] = "VarR8FromUI4",
    [220] = "VarR8FromDec",
    [221] = "VarDateFromI1",
    [222] = "VarDateFromUI2",
    [223] = "VarDateFromUI4",
    [224] = "VarDateFromDec",
    [225] = "VarCyFromI1",
    [226] = "VarCyFromUI2",
    [227] = "VarCyFromUI4",
    [228] = "VarCyFromDec",
    [229] = "VarBstrFromI1",
    [230] = "VarBstrFromUI2",
    [232] = "VarBstrFromDec",
    [233] = "VarBoolFromI1",
    [234] = "VarBoolFromUI2",
    [235] = "VarBoolFromUI4",
    [236] = "VarBoolFromDec",
    [238] = "VarUI1FromUI2",
    [239] = "VarUI1FromUI4",
    [240] = "VarUI1FromDec",
    [241] = "VarDecFromI1",
    [242] = "VarDecFromUI2",
    [243] = "VarDecFromUI4",
    [244] = "VarI1FromUI1",
    [245] = "VarI1FromI2",
    [246] = "VarI1FromI4",
    [247] = "VarI1FromR4",
    [248] = "VarI1FromR8",
    [249] = "VarI1FromDate",
    [250] = "VarI1FromCy",
    [251] = "VarI1FromStr",
    [252] = "VarI1FromDisp",
    [253] = "VarI1FromBool",
    [254] = "VarI1FromUI2",
    [255] = "VarI1FromUI4",
    [256] = "VarI1FromDec",
    [258] = "VarUI2FromI2",
    [259] = "VarUI2FromI4",
    [260] = "VarUI2FromR4",
    [261] = "VarUI2FromR8",
    [262] = "VarUI2FromDate",
    [263] = "VarUI2FromCy",
    [265] = "VarUI2FromDisp",
    [266] = "VarUI2FromBool",
    [267] = "VarUI2FromI1",
    [269] = "VarUI2FromDec",
    [270] = "VarUI4FromUI1",
    [271] = "VarUI4FromI2",
    [272] = "VarUI4FromI4",
    [273] = "VarUI4FromR4",
    [274] = "VarUI4FromR8",
    [275] = "VarUI4FromDate",
    [276] = "VarUI4FromCy",
    [278] = "VarUI4FromDisp",
    [280] = "VarUI4FromI1",
    [281] = "VarUI4FromUI2",
    [282] = "VarUI4FromDec",
    [283] = "BSTR_UserSize",
    [284] = "BSTR_UserMarshal",
    [285] = "BSTR_UserUnmarshal",
    [286] = "BSTR_UserFree",
    [287] = "VARIANT_UserSize",
    [288] = "VARIANT_UserMarshal",
    [289] = "VARIANT_UserUnmarshal",
    [290] = "VARIANT_UserFree",
    [291] = "LPSAFEARRAY_UserSize",
    [292] = "LPSAFEARRAY_UserMarshal",
    [293] = "LPSAFEARRAY_UserUnmarshal",
    [294] = "LPSAFEARRAY_UserFree",
    [295] = "LPSAFEARRAY_Size",
    [296] = "LPSAFEARRAY_Marshal",
    [297] = "LPSAFEARRAY_Unmarshal",
    [298] = "VarDecCmpR8",
    [299] = "VarCyAdd",
    [300] = "BSTR_UserUnmarshal64",
    [301] = "DllCanUnloadNow",
    [302] = "DllGetClassObject",
    [303] = "VarCyMul",
    [304] = "VarCyMulI4",
    [305] = "VarCySub",
    [306] = "VarCyAbs",
    [307] = "VarCyFix",
    [308] = "VarCyInt",
    [309] = "VarCyNeg",
    [310] = "VarCyRound",
    [311] = "VarCyCmp",
    [312] = "VarCyCmpR8",
    [313] = "VarBstrCat",
    [314] = "VarBstrCmp",
    [315] = "VarR8Pow",
    [316] = "VarR4CmpR8",
    [317] = "VarR8Round",
    [318] = "VarCat",
    [319] = "VarDateFromUdateEx",
    [320] = "DllRegisterServer",
    [321] = "DllUnregisterServer",
    [322] = "GetRecordInfoFromGuids",
    [323] = "GetRecordInfoFromTypeInfo",
    [324] = "LPSAFEARRAY_UserFree64",
    [325] = "SetVarConversionLocaleSetting",
    [326] = "GetVarConversionLocaleSetting",
    [327] = "SetOaNoCache",
    [328] = "LPSAFEARRAY_UserMarshal64",
    [329] = "VarCyMulI8",
    [330] = "VarDateFromUdate",
    [332] = "GetAltMonthNames",
    [333] = "VarI8FromUI1",
    [334] = "VarI8FromI2",
    [335] = "VarI8FromR4",
    [336] = "VarI8FromR8",
    [337] = "VarI8FromCy",
    [338] = "VarI8FromDate",
    [340] = "VarI8FromDisp",
    [341] = "VarI8FromBool",
    [342] = "VarI8FromI1",
    [343] = "VarI8FromUI2",
    [344] = "VarI8FromUI4",
    [345] = "VarI8FromDec",
    [346] = "VarI2FromI8",
    [347] = "VarI2FromUI8",
    [348] = "VarI4FromI8",
    [349] = "VarI4FromUI8",
    [350] = "LPSAFEARRAY_UserSize64",
    [351] = "LPSAFEARRAY_UserUnmarshal64",
    [352] = "OACreateTypeLib2",
    [353] = "SafeArrayAddRef",
    [354] = "SafeArrayReleaseData",
    [355] = "SafeArrayReleaseDescriptor",
    [356] = "SysAddRefString",
    [357] = "SysReleaseString",
    [358] = "VARIANT_UserFree64",
    [359] = "VARIANT_UserMarshal64",
    [360] = "VarR4FromI8",
    [361] = "VarR4FromUI8",
    [362] = "VarR8FromI8",
    [363] = "VarR8FromUI8",
    [364] = "VarDateFromI8",
    [365] = "VarDateFromUI8",
    [366] = "VarCyFromI8",
    [367] = "VarCyFromUI8",
    [368] = "VarBstrFromI8",
    [370] = "VarBoolFromI8",
    [372] = "VarUI1FromI8",
    [373] = "VarUI1FromUI8",
    [374] = "VarDecFromI8",
    [375] = "VarDecFromUI8",
    [376] = "VarI1FromI8",
    [378] = "VarUI2FromI8",
    [379] = "VarUI2FromUI8",
    [411] = "SafeArrayCreateVector",
    [412] = "SafeArrayCopyData",
    [413] = "VectorFromBstr",
    [414] = "BstrFromVector",
    [415] = "OleIconToCursor",
    [416] = "OleCreatePropertyFrameIndirect",
    [417] = "OleCreatePropertyFrame",
    [418] = "OleLoadPicture",
    [419] = "OleCreatePictureIndirect",
    [420] = "OleCreateFontIndirect",
    [421] = "OleTranslateColor",
    [422] = "OleLoadPictureFile",
    [424] = "OleLoadPicturePath",
    [425] = "VarUI4FromI8",
    [426] = "VarUI4FromUI8",
    [427] = "VarI8FromUI8",
    [428] = "VarUI8FromI8",
    [429] = "VarUI8FromUI1",
    [430] = "VarUI8FromI2",
    [431] = "VarUI8FromR4",
    [432] = "VarUI8FromR8",
    [433] = "VarUI8FromCy",
    [434] = "VarUI8FromDate",
    [436] = "VarUI8FromDisp",
    [439] = "VarUI8FromUI2",
    [440] = "VarUI8FromUI4",
    [441] = "VarUI8FromDec",
    [442] = "RegisterTypeLibForUser",
    [443] = "UnRegisterTypeLibForUser",
    [444] = "OaEnablePerUserTLibRegistration",
    [445] = "HWND_UserFree",
    [446] = "HWND_UserMarshal",
    [447] = "HWND_UserSize",
    [448] = "HWND_UserUnmarshal",
    [449] = "HWND_UserFree64",
    [450] = "HWND_UserMarshal64",
    [500] = "OACleanup",
};



/******************************************************************************
*                                                                             *
*  Paramètres  : ordinal = valeur ordinale à considérer.                      *
*                                                                             *
*  Description : Fournit le nom du symbole associé à un ordinal donné.        *
*                                                                             *
*  Retour      : Désignation du symbole trouvé ou NULL en cas d'échec.        *
*                                                                             *
*  Remarques   : -                                                            *
*                                                                             *
******************************************************************************/

const char *find_oleaut32_name_for_ordinal(uint16_t ordinal)
{
    const char *result;                     /* Désignation à renvoyer      */

    if (ordinal >= 501)
        result = NULL;

    else
        result = _oleaut32_ordinals[ordinal];

    return result;

}
