/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Lambda {
    public static final BiConsumer<Integer, RunnableThatThrows> repeater = (limit, func) -> {
        for (int i = 0; i < limit; ++i) {
            try {
                func.run();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    private Lambda() {
    }

    public static void withLock(Lock lock, Runnable runnable) {
        lock.lock();
        try {
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T withLock(Lock lock, Callable<T> callable) {
        lock.lock();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    public static <T, E extends Exception> T withLockInterruptible(Lock lock, Callable<T> callable, E interruptedException) throws E {
        try {
            lock.lockInterruptibly();
            T t = callable.call();
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (interruptedException != null) {
                interruptedException.initCause(e);
                throw interruptedException;
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    public static <T, E1 extends Exception> T withLockException1(Lock lock, Callable<T> callable, Class<E1> exception1Class) throws E1 {
        lock.lock();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            if (exception1Class.isInstance(e)) {
                throw e;
            }
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    public static <T, E1 extends Exception, E2 extends Exception> T withLockException2(Lock lock, Callable<T> callable, Class<E1> exception1Class, Class<E2> exception2Class) throws E1, E2 {
        lock.lock();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            if (exception1Class.isInstance(e)) {
                throw e;
            }
            if (exception2Class.isInstance(e)) {
                throw e;
            }
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    public static <T, R> Function<T, R> silent(FunctionThatThrows<T, R> functionThatThrows) {
        return arg -> {
            try {
                return functionThatThrows.apply(arg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> Callable<T> silent(CallableThatThrows<T> functionThatThrows) {
        return () -> {
            try {
                return functionThatThrows.apply();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static Runnable silent(RunnableThatThrows functionThatThrows) {
        return () -> {
            try {
                functionThatThrows.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> void forEachWithIndex(Iterable<T> iterable, IteratorWithIndex<T> iteratorWithIndex) {
        Iterator<T> iterator = iterable.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            T nextT = iterator.next();
            iteratorWithIndex.forEachWithIndex(nextT, index);
            ++index;
        }
    }

    public static <A, B, C> Map<A, C> mapValues(Map<A, B> map, Function<B, C> mapper) {
        return map.entrySet().stream().map(p -> new AbstractMap.SimpleEntry(p.getKey(), mapper.apply(p.getValue()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    public static <A, B, C> Map<B, C> mapKeys(Map<A, C> map, Function<A, B> mapper) {
        return map.entrySet().stream().map(p -> new AbstractMap.SimpleEntry(mapper.apply(p.getKey()), p.getValue())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    @FunctionalInterface
    public static interface FunctionThatThrows<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface CallableThatThrows<T> {
        public T apply() throws Exception;
    }

    @FunctionalInterface
    public static interface RunnableThatThrows3Exceptions<A extends Throwable, B extends Throwable, C extends Throwable> {
        public void run() throws A, B, C;
    }

    @FunctionalInterface
    public static interface RunnableThatThrows {
        public void run() throws Exception;
    }

    public static interface IteratorWithIndex<T> {
        public void forEachWithIndex(T var1, int var2);
    }
}

