/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task.flow;

import it.sauronsoftware.cron4j.InvalidPatternException;
import it.sauronsoftware.cron4j.Predictor;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import javax.script.Bindings;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.flow.FlowAction;
import org.ow2.proactive.scheduler.common.task.flow.FlowActionType;
import org.ow2.proactive.scripting.InvalidScriptException;
import org.ow2.proactive.scripting.Script;
import org.ow2.proactive.scripting.ScriptResult;
import org.ow2.proactive.scripting.SimpleScript;

@PublicAPI
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FlowScript
extends Script<FlowAction> {
    private String actionType = null;
    private String target = null;
    private String targetElse = null;
    private String targetContinuation = null;
    public static final String loopVariable = "loop";
    public static final String replicateRunsVariable = "runs";
    public static final String branchSelectionVariable = "branch";
    public static final String ifBranchSelectedVariable = "if";
    public static final String elseBranchSelectedVariable = "else";
    private static final long serialVersionUID = 141L;

    public FlowScript() {
    }

    protected String getDefaultScriptName() {
        return "FlowScript";
    }

    public FlowScript(FlowScript fl) {
        super((Script)fl);
        if (fl.getActionType() != null) {
            this.actionType = new String(fl.getActionType());
        }
        if (fl.getActionTarget() != null) {
            this.target = new String(fl.getActionTarget());
        }
        if (fl.getActionTargetElse() != null) {
            this.targetElse = new String(fl.getActionTargetElse());
        }
        if (fl.getActionContinuation() != null) {
            this.targetContinuation = new String(fl.getActionContinuation());
        }
    }

    private FlowScript(Script<?> scr) {
        super(scr);
    }

    public static FlowScript createContinueFlowScript() {
        FlowScript fs = new FlowScript((Script<?>)new SimpleScript("", "javascript"));
        fs.setActionType(FlowActionType.CONTINUE);
        return fs;
    }

    public static FlowScript createLoopFlowScript(String script, String target) throws InvalidScriptException {
        return FlowScript.createLoopFlowScript(script, "javascript", target);
    }

    public static FlowScript createLoopFlowScript(String script, String engine, String target) throws InvalidScriptException {
        SimpleScript scr = new SimpleScript(script, engine);
        return FlowScript.createLoopFlowScript(scr, target);
    }

    public static FlowScript createLoopFlowScript(String script, String engine, String target, Serializable[] parameters) throws InvalidScriptException {
        SimpleScript scr = new SimpleScript(script, engine, parameters);
        return FlowScript.createLoopFlowScript(scr, target);
    }

    public static FlowScript createLoopFlowScript(URL url, String engine, String target, Serializable[] parameters) throws InvalidScriptException {
        SimpleScript scr = new SimpleScript(url, engine, parameters);
        return FlowScript.createLoopFlowScript(scr, target);
    }

    public static FlowScript createLoopFlowScript(Script<?> script, String target) throws InvalidScriptException {
        FlowScript flow = new FlowScript(script);
        flow.setActionType(FlowActionType.LOOP);
        flow.setActionTarget(target);
        return flow;
    }

    public static FlowScript createIfFlowScript(String script, String targetIf, String targetElse, String targetCont) throws InvalidScriptException {
        return FlowScript.createIfFlowScript(script, "javascript", targetIf, targetElse, targetCont);
    }

    public static FlowScript createIfFlowScript(String script, String engine, String targetIf, String targetElse, String targetCont) throws InvalidScriptException {
        SimpleScript scr = new SimpleScript(script, engine);
        return FlowScript.createIfFlowScript(scr, targetIf, targetElse, targetCont);
    }

    public static FlowScript createIfFlowScript(String script, String engine, String targetIf, String targetElse, String targetCont, Serializable[] parameters) throws InvalidScriptException {
        SimpleScript scr = new SimpleScript(script, engine, parameters);
        return FlowScript.createIfFlowScript(scr, targetIf, targetElse, targetCont);
    }

    public static FlowScript createIfFlowScript(URL url, String engine, String targetIf, String targetElse, String targetCont, Serializable[] parameters) throws InvalidScriptException {
        SimpleScript scr = new SimpleScript(url, engine, parameters);
        return FlowScript.createIfFlowScript(scr, targetIf, targetElse, targetCont);
    }

    public static FlowScript createIfFlowScript(Script<?> script, String targetIf, String targetElse, String targetCont) throws InvalidScriptException {
        FlowScript flow = new FlowScript(script);
        flow.setActionType(FlowActionType.IF);
        flow.setActionTarget(targetIf);
        flow.setActionTargetElse(targetElse);
        flow.setActionContinuation(targetCont);
        return flow;
    }

    public static FlowScript createReplicateFlowScript(String script) throws InvalidScriptException {
        return FlowScript.createReplicateFlowScript(script, "javascript");
    }

    public static FlowScript createReplicateFlowScript(String script, String engine) throws InvalidScriptException {
        SimpleScript scr = new SimpleScript(script, engine);
        return FlowScript.createReplicateFlowScript(scr);
    }

    public static FlowScript createReplicateFlowScript(String script, String engine, Serializable[] parameters) throws InvalidScriptException {
        SimpleScript scr = new SimpleScript(script, engine, parameters);
        return FlowScript.createReplicateFlowScript(scr);
    }

    public static FlowScript createReplicateFlowScript(URL url, String engine, Serializable[] parameters) throws InvalidScriptException {
        SimpleScript scr = new SimpleScript(url, engine, parameters);
        return FlowScript.createReplicateFlowScript(scr);
    }

    public static FlowScript createReplicateFlowScript(Script<?> script) throws InvalidScriptException {
        FlowScript flow = new FlowScript(script);
        flow.setActionType(FlowActionType.REPLICATE);
        return flow;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public void setActionType(FlowActionType type) {
        this.actionType = type.toString();
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionTarget(String target) {
        this.target = target;
    }

    public void setActionTarget(Task target) {
        this.target = target.getName();
    }

    public String getActionTarget() {
        return this.target;
    }

    public void setActionTargetElse(String target) {
        this.targetElse = target;
    }

    public void setActionTargetElse(Task target) {
        this.targetElse = target.getName();
    }

    public String getActionTargetElse() {
        return this.targetElse;
    }

    public void setActionContinuation(String target) {
        this.targetContinuation = target;
    }

    public void setActionContinuation(Task target) {
        this.targetContinuation = target.getName();
    }

    public String getActionContinuation() {
        return this.targetContinuation;
    }

    public String getId() {
        return this.id;
    }

    protected Reader getReader() {
        return new StringReader(this.script);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ScriptResult<FlowAction> getResult(Object evalResult, Bindings bindings) {
        try {
            FlowAction act = new FlowAction();
            if (this.actionType == null || this.actionType.equals(FlowActionType.CONTINUE.toString())) {
                act.setType(FlowActionType.CONTINUE);
                return new ScriptResult((Object)act);
            }
            if (this.actionType.equals(FlowActionType.LOOP.toString())) {
                Boolean enabled;
                if (this.target == null) {
                    String msg = "LOOP control flow action requires a target";
                    logger.error((Object)msg);
                    return new ScriptResult((Throwable)new Exception(msg));
                }
                if (!bindings.containsKey(loopVariable)) {
                    String msg = "Script environment for LOOP action needs to define variable loop";
                    logger.error((Object)msg);
                    return new ScriptResult((Throwable)new Exception(msg));
                }
                String loopValue = bindings.get(loopVariable).toString();
                if ("true".equalsIgnoreCase(loopValue)) {
                    enabled = Boolean.TRUE;
                } else if ("false".equalsIgnoreCase(loopValue)) {
                    enabled = Boolean.FALSE;
                } else {
                    try {
                        new Predictor(loopValue).nextMatchingDate();
                        enabled = Boolean.TRUE;
                        act.setCronExpr(loopValue);
                    }
                    catch (InvalidPatternException e) {
                        enabled = Boolean.FALSE;
                    }
                }
                if (enabled.booleanValue()) {
                    act.setType(FlowActionType.LOOP);
                    act.setTarget(this.target);
                    return new ScriptResult((Object)act);
                }
                act.setType(FlowActionType.CONTINUE);
                return new ScriptResult((Object)act);
            }
            if (this.actionType.equals(FlowActionType.REPLICATE.toString())) {
                if (!bindings.containsKey(replicateRunsVariable)) {
                    String msg = "Script environment for REPLICATE action needs to define variable runs";
                    logger.error((Object)msg);
                    return new ScriptResult((Throwable)new Exception(msg));
                }
                act.setType(FlowActionType.REPLICATE);
                int args = 1;
                Object o = bindings.get(replicateRunsVariable);
                try {
                    args = Integer.parseInt("" + o);
                }
                catch (NumberFormatException e) {
                    try {
                        args = (int)Math.floor(Double.parseDouble("" + o));
                    }
                    catch (Exception e2) {
                        String msg = "REPLICATE action: could not parse value for variable runs";
                        logger.error((Object)msg);
                        return new ScriptResult((Throwable)new Exception(msg, e2));
                    }
                }
                if (args < 0) {
                    String msg = "REPLICATE action: value of variable runs cannot be negative";
                    logger.error((Object)msg);
                    return new ScriptResult((Throwable)new Exception(msg));
                }
                act.setDupNumber(args);
                return new ScriptResult((Object)act);
            }
            if (!this.actionType.equals(FlowActionType.IF.toString())) {
                String msg = this.actionType + " action type unknown";
                logger.error((Object)msg);
                return new ScriptResult((Throwable)new Exception(msg));
            }
            if (this.target == null) {
                String msg = "IF action requires a target ";
                logger.error((Object)msg);
                return new ScriptResult((Throwable)new Exception(msg));
            }
            if (this.targetElse == null) {
                String msg = "IF action requires an ELSE target ";
                logger.error((Object)msg);
                return new ScriptResult((Throwable)new Exception(msg));
            }
            act.setType(FlowActionType.IF);
            if (!bindings.containsKey(branchSelectionVariable)) {
                String msg = "Environment for IF action needs to define variable branch";
                logger.error((Object)msg);
                return new ScriptResult((Throwable)new Exception(msg));
            }
            String val = new String((String)bindings.get(branchSelectionVariable));
            if (val.toLowerCase().equals(ifBranchSelectedVariable)) {
                act.setTarget(this.target);
                act.setTargetElse(this.targetElse);
            } else {
                if (!val.toLowerCase().equals(elseBranchSelectedVariable)) {
                    String msg = "IF action: value for branch needs to be one of if or else";
                    logger.error((Object)msg);
                    return new ScriptResult((Throwable)new Exception(msg));
                }
                act.setTarget(this.targetElse);
                act.setTargetElse(this.target);
            }
            if (this.targetContinuation == null) return new ScriptResult((Object)act);
            act.setTargetContinuation(this.targetContinuation);
            return new ScriptResult((Object)act);
        }
        catch (Throwable th) {
            return new ScriptResult(th);
        }
    }

    public String display() {
        String nl = System.lineSeparator();
        return "actionType = " + this.actionType + " target = " + this.target + " targetElse = " + this.targetElse + " targetContinuation = " + this.targetContinuation + nl + super.display();
    }

    protected void prepareSpecialBindings(Bindings bindings) {
    }
}

