#ifndef _TQUANT_API_H
#define _TQUANT_API_H

#include <stdint.h>
#include <string>
#include <memory>
#include <vector>

namespace tquant {  namespace api {

    using namespace std;

    template<typename T> 
    class TickDataHolder : public T {
        string _code;
    public:
        TickDataHolder(const T& t, const char* a_code) : T(t), _code(a_code) {
            this->code = _code.c_str();
        }

        TickDataHolder(const TickDataHolder<T>& t) {
            *this = t;
            if (t.code){
                this->_code = t.code;
                this->code = this->_code.c_str();
            }
        }
    };

#pragma pack(1)
    // keep same with tk_schema!
    struct RawMarketQuote{
        const char*     code;
#if defined(WIN32) && !defined(_WIN64)
        int32_t         _padding_1;
#endif
        int32_t         date;
        int32_t         time;
        int64_t         recv_time;
        int32_t         trading_day;
        double          open;
        double          high;
        double          low;
        double          close;
        double          last;
        double          high_limit;
        double          low_limit;
        double          pre_close;
        int64_t         volume;
        double          turnover;
        double          ask1;
        double          ask2;
        double          ask3;
        double          ask4;
        double          ask5;
        double          bid1;
        double          bid2;
        double          bid3;
        double          bid4;
        double          bid5;
        int64_t         ask_vol1;
        int64_t         ask_vol2;
        int64_t         ask_vol3;
        int64_t         ask_vol4;
        int64_t         ask_vol5;
        int64_t         bid_vol1;
        int64_t         bid_vol2;
        int64_t         bid_vol3;
        int64_t         bid_vol4;
        int64_t         bid_vol5;
        double          settle;
        double          pre_settle;
        int64_t         oi;
        int64_t         pre_oi;
    };

    typedef TickDataHolder<RawMarketQuote> MarketQuote;

    struct RawBar {
        const char*     code;
#if defined(WIN32) && !defined(_WIN64)
        int32_t         _padding_1;
#endif
        int32_t         date;
        int32_t         time;
        int32_t         trading_day;
        double          open;
        double          high;
        double          low;
        double          close;
        int64_t         volume;
        double          turnover;
        int64_t         oi;
    };

    typedef TickDataHolder<RawBar> Bar;

    struct RawDailyBar {
        const char*     code;
#if defined(WIN32) && !defined(_WIN64)
        int32_t         _padding_1;
#endif
        int32_t         date;
        double          open;
        double          high;
        double          low;
        double          close;
        int64_t         volume;
        double          turnover;
        int64_t         oi;
        double          settle;
        double          pre_close;
        double          pre_settle;
        double          _padding;
    };

    typedef TickDataHolder<RawDailyBar> DailyBar;

#pragma pack()

    /**
    *  ݲѯӿ
    *
    *  ܣ
    *      ʵʱ飬tick, 
    *      ĺ
    */
    class DataApi_Callback {
    public:
        virtual void on_market_quote (shared_ptr<MarketQuote> quote) = 0;
        virtual void on_bar          (const char* cycle, shared_ptr<Bar> bar) = 0;
    };

    template<typename T_VALUE>
    struct CallResult {
        shared_ptr<T_VALUE> value;
        string    msg;

        CallResult(shared_ptr<T_VALUE> a_value)
            : value(a_value)
        {
        }
        CallResult(const string& a_msg)
            : msg(a_msg)
        {
        }
    };

    class DataApi {
    protected:
        virtual ~DataApi() {}
    public:   
        /**
        * ȡĳյĳ ticks
        *
        * tradingday Ϊ0ʾǰ
        *
        * @param code
        * @param trading_day
        * @return
        */
        virtual CallResult<vector<MarketQuote>> tick(const char* code, int trading_day) = 0;

        /**
        * ȡĳBar
        *
        * Ŀǰַֻ֧ߺߡ
        *   cycle == "1m"ʱtrading_dayķߣtrading_day=0ʾǰա
        *
        * @param code          ֤ȯ
        * @param cycle         "1m""
        * @param trading_day   գԷ
        * @param align         Ƿ
        * @return
        */
        virtual CallResult<vector<Bar>> bar(const char* code, const char* cycle, int trading_day, bool align) = 0;

        /**
        * ȡĳ
        *
        * Ŀǰַֻ֧ߺߡ
        *   cycle == "1m"ʱtrading_dayķߣtrading_day=0ʾǰա
        *   cycle == "1d"ʱеߣtrading_dayֵ塣
        *
        * @param code          ֤ȯ
        * @param price_adj     ۸Ȩȡֵ
        *                        back -- Ȩ
        *                        forward -- ǰȨ
        * @param align         Ƿ
        * @return
        */
        virtual CallResult<vector<DailyBar>> daily_bar(const char* code, const char* price_adj, bool align) = 0;

        /**
        * ȡǰ
        *
        * @param code
        * @return
        */
        virtual CallResult<MarketQuote> quote(const char* code) = 0;

        /**
        * 
        *
        * codesΪĶбѾĵĴ,бcodesΪգԷѶб
        *
        * @param codes
        * @return ѾĵĴ
        */
        virtual CallResult<vector<string>> subscribe(const vector<string>& codes) = 0;

        /**
        * ȡ
        *
        * codesΪҪȡблڶĵĴ롣
        * Ҫȡжģͨ subscribe õбȻʹunscribeȡ

        * @param codes
        * @return
        */
        virtual CallResult<vector<string>> unsubscribe(const vector<string>& codes) = 0;

        /**
        * Ļص
        *
        * ĵĴбµ飬ͨcallback֪ͨû
        *
        * @param callback
        */
        virtual void set_callback(DataApi_Callback* callback) = 0;
    };

    // TradeApi
    struct AccountInfo {
        string account_id;       // ʺű
        string broker;           // ƣ֤ȯ
        string account;          // ʺ
        string status;           // ״̬ȡֵ Disconnected, Connected, Connecting
        string msg;              // ״̬Ϣ¼ʧԭ
        string account_type;     // ʺͣ stock, ctp
    };

    struct Balance {
        string account_id;       // ʺű
        string fund_account;     // ʽʺ
        double init_balance;     // ʼʽ
        double enable_balance;   // ʽ
        double margin;           // ֤
        double float_pnl;        // ӯ
        double close_pnl;        // ʵӯ

        Balance() : init_balance(0.0), enable_balance(0.0), margin(0.0)
            , float_pnl(0.0), close_pnl(0.0)
        {}            
    };

    //struct OrderStatus {
#define OS_New        "New"
#define OS_Accepted   "Accepted"
#define OS_Filled     "Filled"
#define OS_Rejected   "Rejected"
#define OS_Cancelled  "Cancelled"
    //}

    //class EntrustAction {
#define EA_Buy             "Buy"
#define EA_Short           "Sell"
#define EA_Cover           "Cover"
#define EA_Sell            "Sell"
#define EA_CoverToday      "CoverToday"
#define EA_CoverYesterday  "CoverYesterday"
#define EA_SellToday       "SellToday"
#define EA_SellYesterday   "SellYesterday"
    //}

    struct Order {
        string  account_id;       // ʺű
        string  code;             // ֤ȯ
        string  name;             // ֤ȯ
        string  entrust_no;       // ίб
        string  entrust_action;   // ίж
        double  entrust_price;    // ίм۸
        int64_t entrust_size;     // ίλ
        int32_t entrust_date;     // ί
        int32_t entrust_time;     // ίʱ
        double  fill_price;       // ɽ۸
        int64_t fill_size;        // ɽ
        string  status;           // ״̬ȡֵ: OrderStatus
        string  status_msg;       // ״̬Ϣ
        int32_t order_id;         // Զ嶩

        Order() 
            : entrust_price(0.0), entrust_size(0), entrust_date(0), entrust_time(0)
            , fill_price(0.0), fill_size(0), order_id(0)
        {}
    };

    struct Trade {
        string  account_id;       // ʺű
        string  code;             // ֤ȯ
        string  name;             // ֤ȯ
        string  entrust_no;       // ίб
        string  entrust_action;   // ίж
        string  fill_no;          // ɽ
        int64_t fill_size;        // ɽ
        double  fill_price;       // ɽ۸
        int32_t fill_date;        // ɽ
        int32_t fill_time;        // ɽʱ

        Trade() : fill_size(0), fill_price(0.0), fill_date(0), fill_time(0)
        {}
    };

    // Side {
#define SD_Long "Long"
#define D_Short "Short"
    //}

    struct Position {
        string  account_id;       // ʺű
        string  code;             // ֤ȯ
        string  name;             // ֤ȯ
        int64_t current_size;     // ǰֲ
        int64_t enable_size;      // ãɽףֲ
        int64_t init_size;        // ʼֲ
        int64_t today_size;       // ճֲ
        int64_t frozen_size;      // ֲ
        string  side;             // ֲַ򣬹ƱĳֲַΪ Long, ڻ Long, Short
        double  cost;             // ɱ
        double  cost_price;       // ɱ۸
        double  last_price;       // ¼۸
        double  float_pnl;        // ֲӯ
        double  close_pnl;        // ƽӯ
        double  margin;           // ֤
        double  commission;       // 

        Position()
            : current_size(0), enable_size(0), init_size(0), today_size(0), frozen_size(0)
            , cost(0.0), cost_price(0.0), last_price(0.0), float_pnl(0.0), close_pnl(0.0)
            , margin(0.0), commission(0.0)
        {
        }
    };

    struct OrderID {
        string  entrust_no;       // ίк
        int32_t order_id;         // Զ
    };

    class TradeApi_Callback{
    public:
        virtual void on_order_status  (shared_ptr<Order> order) = 0;
        virtual void on_order_trade   (shared_ptr<Trade> trade) = 0;
        virtual void on_account_status(shared_ptr<AccountInfo> account) = 0;
    };

    class TradeApi {
    protected:
        virtual ~TradeApi() {}
    public:
        TradeApi() { }

        /**
        * ѯʺ״̬
        *
        * @return
        */
        virtual CallResult<vector<AccountInfo>> query_account_status() = 0;

        /**
        * ѯĳʺŵʽʹ
        *
        * @param account_id
        * @return
        */
        virtual CallResult<Balance> query_balance(const char* account_id) = 0;

        /**
        * ѯĳʺŵĵĶ
        *
        * @param account_id
        * @return
        */
        virtual CallResult<vector<Order>> query_orders(const char* account_id) = 0;

        /**
        * ѯĳʺŵĵĳɽ
        *
        * @param account_id
        * @return
        */
        virtual CallResult<vector<Trade>> query_trades(const char* account_id) = 0;

        /**
        * ѯĳʺŵĵĳֲ
        *
        * @param account_id
        * @return
        */
        virtual CallResult<vector<Position>> query_positions(const char* account_id) = 0;

        /**
        * µ
        *
        * ƱͨΪͬµģʽµɹ뷵ίк entrust_no
        *
        * CTPͨΪ첽µģʽµԶorder_idܶίкźãͨ Callback.on_order_status֪ͨ
        * ûûͨorder_idƥ䡣ûбգon_order_statusصentrust_noΪգ״̬ΪRejected
        * order_idΪ0ʾûԼԶţʱû뱣֤ŵΨһԡ֧ͨorder_idúش롣
        *
        * @param account_id    ʺű
        * @param code          ֤ȯ
        * @param price         ίм۸
        * @param size          ί
        * @param action        ίж
        * @param order_id      Զ嶩ţΪ0ʾֵ
        * @return OrderID      ID
        */
        virtual CallResult<OrderID> place_order(const char* account_id, const char* code, double price, int64_t size, const char* action, int order_id) = 0;

        /**
        * ݶų
        *
        * security Ϊ
        *
        * @param account_id    ʺű
        * @param code          ֤ȯ
        * @param order_id      
        * @return Ƿɹ
        */
        virtual CallResult<bool> cancel_order(const char* account_id, const char* code, int order_id) = 0;

        /**
        * ίкų
        *
        * security Ϊ
        *
        * @param account_id    ʺű
        * @param code          ֤ȯ
        * @param entrust_no    ίб
        * @return Ƿɹ
        */
        virtual CallResult<bool> cancel_order(const char* account_id, const char* code, const char* entrust_no) = 0;

        /**
        * ͨòѯӿ
        *
        * ڲѯͨеϢѯ CTPĴ command="ctp_codetable".
        * ַ
        *
        * @param account_id
        * @param command
        * @param params
        * @return
        */
        virtual CallResult<string> query(const char* account_id, const char* command, const char* params) = 0;
        /**
        *  TradeApi.Callback
        *
        * @param callback
        */
        virtual void set_callback(TradeApi_Callback* callback) = 0;
    };

    class TQuantApi {
    public:        
        virtual ~TQuantApi() {}

        /**
        * ȡݽӿ
        *
        * @return
        */
        virtual TradeApi* trade_api() = 0;

        /**
        *  ȡ׽ӿ
        *
        * @return
        */
        virtual DataApi*  data_api() = 0;

        static TQuantApi* create(const char* addr);
    };

} }

#endif
