# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Snapshot(Model):
    """Snapshot object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Snapshot id.
    :type id: str
    :param account: Required. Azure Cognitive Service Face account id of the
     subscriber who created the snapshot by Snapshot - Take.
    :type account: str
    :param type: Required. Type of the source object in the snapshot,
     specified by the subscriber who created the snapshot when calling Snapshot
     - Take. Currently FaceList, PersonGroup, LargeFaceList and
     LargePersonGroup are supported. Possible values include: 'FaceList',
     'LargeFaceList', 'LargePersonGroup', 'PersonGroup'
    :type type: str or
     ~azure.cognitiveservices.vision.face.models.SnapshotObjectType
    :param apply_scope: Required. Array of the target Face subscription ids
     for the snapshot, specified by the user who created the snapshot when
     calling Snapshot - Take. For each snapshot, only subscriptions included in
     the applyScope of Snapshot - Take can apply it.
    :type apply_scope: list[str]
    :param user_data: User specified data about the snapshot for any purpose.
     Length should not exceed 16KB.
    :type user_data: str
    :param created_time: Required. A combined UTC date and time string that
     describes the created time of the snapshot. E.g.
     2018-12-25T11:41:02.2331413Z.
    :type created_time: datetime
    :param last_update_time: Required. A combined UTC date and time string
     that describes the last time when the snapshot was created or updated by
     Snapshot - Update. E.g. 2018-12-25T11:51:27.8705696Z.
    :type last_update_time: datetime
    """

    _validation = {
        'id': {'required': True},
        'account': {'required': True},
        'type': {'required': True},
        'apply_scope': {'required': True},
        'user_data': {'max_length': 16384},
        'created_time': {'required': True},
        'last_update_time': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'account': {'key': 'account', 'type': 'str'},
        'type': {'key': 'type', 'type': 'SnapshotObjectType'},
        'apply_scope': {'key': 'applyScope', 'type': '[str]'},
        'user_data': {'key': 'userData', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, id: str, account: str, type, apply_scope, created_time, last_update_time, user_data: str=None, **kwargs) -> None:
        super(Snapshot, self).__init__(**kwargs)
        self.id = id
        self.account = account
        self.type = type
        self.apply_scope = apply_scope
        self.user_data = user_data
        self.created_time = created_time
        self.last_update_time = last_update_time
