# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .name_and_user_data_contract_py3 import NameAndUserDataContract


class MetaDataContract(NameAndUserDataContract):
    """A combination of user defined name and user specified data and recognition
    model name for largePersonGroup/personGroup, and largeFaceList/faceList.

    :param name: User defined name, maximum length is 128.
    :type name: str
    :param user_data: User specified data. Length should not exceed 16KB.
    :type user_data: str
    :param recognition_model: Possible values include: 'recognition_01',
     'recognition_02'. Default value: "recognition_01" .
    :type recognition_model: str or
     ~azure.cognitiveservices.vision.face.models.RecognitionModel
    """

    _validation = {
        'name': {'max_length': 128},
        'user_data': {'max_length': 16384},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'user_data': {'key': 'userData', 'type': 'str'},
        'recognition_model': {'key': 'recognitionModel', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, user_data: str=None, recognition_model="recognition_01", **kwargs) -> None:
        super(MetaDataContract, self).__init__(name=name, user_data=user_data, **kwargs)
        self.recognition_model = recognition_model
