# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplySnapshotRequest(Model):
    """Request body for applying snapshot operation.

    All required parameters must be populated in order to send to Azure.

    :param object_id: Required. User specified target object id to be created
     from the snapshot.
    :type object_id: str
    :param mode: Snapshot applying mode. Currently only CreateNew is
     supported, which means the apply operation will fail if target
     subscription already contains an object of same type and using the same
     objectId. Users can specify the "objectId" in request body to avoid such
     conflicts. Possible values include: 'CreateNew'. Default value:
     "CreateNew" .
    :type mode: str or
     ~azure.cognitiveservices.vision.face.models.SnapshotApplyMode
    """

    _validation = {
        'object_id': {'required': True, 'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
    }

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'SnapshotApplyMode'},
    }

    def __init__(self, **kwargs):
        super(ApplySnapshotRequest, self).__init__(**kwargs)
        self.object_id = kwargs.get('object_id', None)
        self.mode = kwargs.get('mode', "CreateNew")
