/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.util;

import java.util.ArrayList;
import org.brunel.action.Action;
import org.brunel.data.Field;

class LibraryItem {
    private final String name;
    private final String action;
    private final Param[] parameters;

    public LibraryItem(String name, String action, Param ... parameters) {
        this.name = name;
        this.action = action;
        this.parameters = parameters;
    }

    public Action apply(Field ... fields) {
        String text = this.action;
        ArrayList<Field> toBin = new ArrayList<Field>();
        for (int i = 0; i < this.parameters.length; ++i) {
            Param parameter = this.parameters[i];
            if (parameter.isMultiple) {
                if (i != this.parameters.length - 1) {
                    throw new IllegalStateException("Multi field must be last parameter");
                }
                text = this.modifyStringForMulti(text, fields, i);
                for (int j = i; j < fields.length; ++j) {
                    if (parameter != Param.multiCategorical || fields[j].preferCategorical()) continue;
                    toBin.add(fields[j]);
                }
                continue;
            }
            text = text.replaceAll("\\$" + (i + 1), fields[i].name);
            if (parameter != Param.categorical || fields[i].preferCategorical()) continue;
            toBin.add(fields[i]);
        }
        Action a = Action.parse(text);
        for (Field f : toBin) {
            a = a.append(Action.parse("bin(" + f.name + ")"));
        }
        return a.simplify();
    }

    public String name() {
        return this.name;
    }

    private String modifyStringForMulti(String text, Field[] fields, int start) {
        int n = fields.length - start;
        String all = "";
        for (int i = 0; i < n; ++i) {
            text = text.replaceAll("\\$" + (start + 1) + "\\[" + i + "\\]", fields[start + i].name);
            text = text.replaceAll("\\$" + (start + 1) + "\\[-" + i + "\\]", fields[fields.length - 1 - i].name);
            if (i > 0) {
                all = all + ", ";
            }
            all = all + fields[start + i].name;
        }
        return text.replaceAll("\\$" + (start + 1), all);
    }

    static enum Param {
        field(false),
        numeric(false),
        categorical(false),
        multiple(true),
        multiCategorical(true);

        public final boolean isMultiple;

        private Param(boolean isMultiple) {
            this.isMultiple = isMultiple;
        }
    }
}

