/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.util;

import java.util.Arrays;
import java.util.Comparator;
import org.brunel.data.Field;

class FieldCoarseness
implements Comparator<Field> {
    FieldCoarseness() {
    }

    public static void sort(Field[] items) {
        Arrays.sort(items, new FieldCoarseness());
    }

    @Override
    public int compare(Field o1, Field o2) {
        return this.categories(o1) - this.categories(o2);
    }

    private int categories(Field f) {
        if (f.preferCategorical()) {
            return f.categories().length;
        }
        if (f.isNumeric()) {
            Double g = f.numProperty("granularity");
            if (g != null && g > 0.0) {
                return (int)((f.max() - f.min()) / g + 1.0);
            }
            return 1000;
        }
        return 10000;
    }
}

