/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.model.style;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.TreeSet;
import org.brunel.build.Builder;
import org.brunel.model.style.BasicSelector;
import org.brunel.model.style.StyleFactory;
import org.brunel.model.style.StyleSelector;
import org.brunel.model.style.StyleTarget;

public class StyleSheet {
    private static StyleSheet brunelDefault;
    private final List<StyleSheetEntry> entries = new ArrayList<StyleSheetEntry>();
    private boolean sorted = false;

    private static void ensureDefaultBuilt() {
        if (brunelDefault == null) {
            String text = new Scanner(Builder.class.getResourceAsStream("/javascript/Brunel.css"), "UTF-8").useDelimiter("\\A").next();
            brunelDefault = StyleFactory.instance().makeStyleSheet(text);
        }
    }

    public void add(StyleSheet other, String ... parentClasses) {
        if (other == null) {
            return;
        }
        if (parentClasses.length == 0) {
            for (StyleSheetEntry e : other.entries) {
                this.entries.add(new StyleSheetEntry(e.selector, e.options, this.entries.size()));
            }
        } else {
            StyleSelector[] parts = new StyleSelector[parentClasses.length];
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = new BasicSelector("", new String[]{parentClasses[i]});
            }
            for (StyleSheetEntry e : other.entries) {
                this.entries.add(new StyleSheetEntry(e.selector.containedIn(parts), e.options, this.entries.size()));
            }
        }
        this.sorted = false;
    }

    public static String getBrunelDefault(StyleTarget target, String key) {
        StyleSheet.ensureDefaultBuilt();
        return brunelDefault.get(target, key);
    }

    public String get(StyleTarget target, String key) {
        this.ensureSorted();
        for (StyleSheetEntry e : this.entries) {
            String v;
            if (!e.selector.match(target) || (v = (String)e.options.get(key)) == null) continue;
            return v;
        }
        return null;
    }

    public StyleSheet replaceClass(String target, String replace) {
        StyleSheet result = new StyleSheet();
        for (StyleSheetEntry style : this.entries) {
            result.entries.add(style.replaceClass(target, replace));
        }
        return result;
    }

    private void ensureSorted() {
        if (this.sorted) {
            return;
        }
        Collections.sort(this.entries);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void add(String text) {
        this.add(StyleFactory.instance().makeStyleSheet(text), new String[0]);
    }

    public void clear() {
        this.entries.clear();
    }

    public Map<String, String> stylesFor(StyleTarget parent, String type, String ... classes) {
        this.ensureSorted();
        StyleTarget target = StyleTarget.makeTarget(type, parent, classes);
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (StyleSheetEntry e : this.entries) {
            if (!e.selector.match(target)) continue;
            for (Map.Entry o : e.options.entrySet()) {
                if (result.containsKey(o.getKey())) continue;
                result.put((String)o.getKey(), (String)o.getValue());
            }
        }
        return result;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String owner) {
        StringWriter w = new StringWriter();
        try {
            this.write(w, owner);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return w.toString().trim();
    }

    private void write(Writer writer, String owner) throws IOException {
        this.ensureSorted();
        Collections.reverse(this.entries);
        for (StyleSheetEntry e : this.entries) {
            if (e != this.entries.get(0)) {
                writer.write(10);
            }
            if (owner != null) {
                writer.write(owner + " ");
            }
            writer.write(e.selector.toString());
            writer.write(" {");
            writer.append('\n');
            TreeSet keys = new TreeSet(e.options.keySet());
            for (String key : keys) {
                writer.write("\t");
                writer.write(key);
                writer.write(": ");
                writer.write((String)e.options.get(key));
                writer.write(";\n");
            }
            writer.write("}\n");
        }
        Collections.reverse(this.entries);
    }

    void addEntry(StyleSelector selector, Map<String, String> options) {
        this.entries.add(new StyleSheetEntry(selector, options, this.entries.size()));
        this.sorted = false;
    }

    private class StyleSheetEntry
    implements Comparable<StyleSheetEntry> {
        private final StyleSelector selector;
        private final Map<String, String> options;
        private final int index;

        public StyleSheetEntry(StyleSelector selector, Map<String, String> options, int index) {
            this.selector = selector;
            this.options = options;
            this.index = index;
        }

        @Override
        public int compareTo(StyleSheetEntry o) {
            int n = this.selector.compareTo(o.selector);
            return n == 0 ? o.index - this.index : n;
        }

        public StyleSheetEntry replaceClass(String target, String replace) {
            StyleSelector sel = this.selector.replaceClass(target, replace);
            if (sel == this.selector) {
                return this;
            }
            return new StyleSheetEntry(sel, this.options, this.index);
        }
    }
}

