/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.brunel.action.Param;
import org.brunel.color.ColorMapping;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;

public class Palette {
    private static final Palette[] sequential = new Palette[]{new Palette("Blues;blue,purple;#f1eef6,#bdc9e1,#74a9cf,#2b8cbe,#045a8d"), new Palette("Greens;blue,green;#edf8fb,#b2e2e2,#66c2a4,#2ca25f,#006d2c"), new Palette("PurpleBlues;blue,purple;#edf8fb,#b3cde3,#8c96c6,#8856a7,#810f7c"), new Palette("BlueGreens;green,blue;#f0f9e8,#bae4bc,#7bccc4,#43a2ca,#0868ac"), new Palette("Reds;orange,red;#fef0d9,#fdcc8a,#fc8d59,#e34a33,#b30000"), new Palette("Purples;red,purple;#feebe2,#fbb4b9,#f768a1,#c51b8a,#7a0177"), new Palette("GreenYellows;green;#ffffcc,#c2e699,#78c679,#31a354,#006837"), new Palette("BlueYellows;green,blue;#ffffcc,#a1dab4,#41b6c4,#2c7fb8,#253494"), new Palette("Browns;orange,brown;#ffffd4,#fed98e,#fe9929,#d95f0e,#993404")};
    private static final Palette nominal19;
    private static final Map<String, String> COLORS_BY_NAME;
    private static final Palette emptyPalette;
    private final String name;
    public final String singleColor;
    private final Set<String> colorTags;
    private final String[] items;

    public Palette(String definition) {
        String[] parts = definition.split(";");
        this.name = parts[0].trim();
        this.colorTags = new HashSet<String>();
        for (String s : parts[1].split(",")) {
            this.colorTags.add(s.trim());
        }
        String[] cols = parts[2].split(",");
        this.items = new String[cols.length];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = cols[i].trim();
        }
        this.singleColor = null;
    }

    public Palette(String name, List<String> colors, boolean singleColor) {
        this.name = name;
        this.singleColor = singleColor ? colors.get(colors.size() - 1) : null;
        this.colorTags = Collections.emptySet();
        this.items = colors.toArray(new String[colors.size()]);
    }

    public static ColorMapping makeColorMapping(Field f, Param[] modifiers, boolean largeElement) {
        ColorMapping base;
        int mutingLevel;
        int n = mutingLevel = largeElement && f.preferCategorical() && !f.isBinned() ? 1 : 0;
        if (modifiers.length == 0) {
            base = Palette.makeDefaultMapping(f);
        } else {
            List<Param> params = modifiers[0].asList();
            ArrayList<String> names = new ArrayList<String>();
            for (Param p : params) {
                String s = p.asString();
                if (s.equals("=")) {
                    mutingLevel = 0;
                    continue;
                }
                if (s.startsWith("*")) {
                    mutingLevel += s.length();
                    continue;
                }
                names.add(s);
            }
            base = Palette.makeNamedMapping(f, names);
        }
        if (f.isBinned()) {
            base = base.fitColorsToCategories(f);
        }
        return mutingLevel == 0 ? base : base.mute(mutingLevel);
    }

    private static ColorMapping makeNamedMapping(Field f, List<String> paletteParts) {
        if (paletteParts.size() == 0) {
            return Palette.makeDefaultMapping(f);
        }
        if (paletteParts.size() == 1) {
            String name = paletteParts.get(0);
            if (name.equals("diverging")) {
                return Palette.makeNamedMapping(f, Arrays.asList("Blues", "Reds"));
            }
            Palette palette = Palette.makeNamedPalette(name);
            if (f.isNumeric()) {
                return new ColorMapping(Palette.fieldSplits(f, palette.length()), palette.items);
            }
            return Palette.makeNominal(f, palette.items);
        }
        if (paletteParts.size() == 2 && f.isNumeric()) {
            String a = paletteParts.get(0);
            String b = paletteParts.get(1);
            return Palette.makeDivergent(f, Palette.makeNamedPalette(a), Palette.makeNamedPalette(b));
        }
        ArrayList<String> colors = new ArrayList<String>();
        for (String s : paletteParts) {
            Palette p = Palette.makeNamedPalette(s);
            if (p.singleColor != null) {
                colors.add(p.singleColor);
                continue;
            }
            Collections.addAll(colors, p.items);
        }
        Palette combined = new Palette("combined", colors, false);
        if (f.isNumeric()) {
            return new ColorMapping(Palette.fieldSplits(f, combined.length()), combined.items);
        }
        return Palette.makeNominal(f, combined.items);
    }

    private int length() {
        return this.items.length;
    }

    private static ColorMapping makeDefaultMapping(Field f) {
        String summary;
        if (!f.isNumeric()) {
            return Palette.makeNamedMapping(f, Collections.singletonList("nominal"));
        }
        boolean divergent = true;
        if (f.name.startsWith("#")) {
            divergent = false;
        }
        if ("sum".equals(summary = f.strProperty("summary")) || "percent".equals(summary)) {
            divergent = false;
        }
        return Palette.makeNamedMapping(f, divergent ? Arrays.asList("Blues", "Reds") : Collections.singletonList("Blues"));
    }

    private static Palette makeNamedPalette(String name) {
        if (name.equals("none") || name.isEmpty()) {
            return emptyPalette;
        }
        if (name.equalsIgnoreCase("nominal") || name.equalsIgnoreCase("ordinal") || name.equalsIgnoreCase("nominal19") || name.equalsIgnoreCase("kelly")) {
            return nominal19;
        }
        if (name.startsWith("continuous") || name.startsWith("sequential")) {
            int n;
            try {
                n = Integer.parseInt(name.substring(name.length() - 1));
            }
            catch (NumberFormatException e) {
                n = 1;
            }
            n = (n + sequential.length - 1) % sequential.length;
            return sequential[n];
        }
        for (Palette p : sequential) {
            if (!p.name.equalsIgnoreCase(name)) continue;
            return p;
        }
        if (name.startsWith("#") && name.length() == 7) {
            return Palette.makeSingleHue(name);
        }
        String color = COLORS_BY_NAME.get(name.toLowerCase());
        if (color != null) {
            return Palette.makeSingleHue(color);
        }
        throw new IllegalStateException("Unknown color palette: " + name);
    }

    private static Palette makeSingleHue(String c) {
        Color base = Color.decode(c);
        float[] hsv = Color.RGBtoHSB(base.getRed(), base.getGreen(), base.getBlue(), new float[3]);
        int n = 10;
        ArrayList<String> colors = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            float r = (float)i / ((float)n - 1.0f);
            Color a = Color.getHSBColor(hsv[0], r * hsv[1], 1.0f - r + r * hsv[2]);
            colors.add(String.format("#%02X%02X%02X", a.getRed(), a.getGreen(), a.getBlue()));
        }
        return new Palette(c, colors, true);
    }

    public static Object[] fieldSplits(Field f, int n) {
        Auto.setTransform((Field)f);
        String t = f.strProperty("transform");
        Object[] objects = new Object[n];
        double min = f.min();
        double max = f.max();
        for (int i = 0; i < n; ++i) {
            objects[i] = "log".equals(t) ? Double.valueOf(Math.exp(Palette.interpolate(n, Math.log(min), Math.log(max), i))) : ("root".equals(t) ? Double.valueOf(Math.pow(Palette.interpolate(n, Math.sqrt(min), Math.sqrt(max), i), 2.0)) : Double.valueOf(Palette.interpolate(n, min, max, i)));
        }
        return objects;
    }

    private static double interpolate(int n, double min, double max, int i) {
        return min + (max - min) * (double)i / (double)(n - 1);
    }

    private static ColorMapping makeDivergent(Field f, Palette lower, Palette upper) {
        int low = lower.items.length;
        int n = low + upper.items.length - 1;
        String[] colors = new String[n];
        for (int i = 0; i < n; ++i) {
            colors[i] = i < low - 1 ? lower.items[low - 1 - i] : (i == low - 1 ? Palette.mid(lower.items[0], upper.items[0], 0.5) : upper.items[i - low]);
        }
        return new ColorMapping(Palette.fieldSplits(f, n), colors);
    }

    static String mid(String a, String b, double v) {
        return "#" + Palette.mid2(a.substring(1, 3), b.substring(1, 3), v) + Palette.mid2(a.substring(3, 5), b.substring(3, 5), v) + Palette.mid2(a.substring(5, 7), b.substring(5, 7), v);
    }

    static String mid2(String hexA, String hexB, double v) {
        int b;
        int a = Integer.parseInt(hexA, 16);
        int mid = (int)Math.round((double)a * (1.0 - v) + (double)(b = Integer.parseInt(hexB, 16)) * v);
        String s = Integer.toHexString(mid);
        return s.length() < 2 ? "0" + s : s;
    }

    private static ColorMapping makeNominal(Field field, String[] items) {
        if (field.preferCategorical()) {
            return new ColorMapping(field.categories(), items);
        }
        int n = items.length;
        Object[] simple = Palette.fieldSplits(field, n);
        Object[] rampedValues = new Object[2 * n - 2];
        String[] rampedItems = new String[2 * n - 2];
        for (int i = 0; i < n - 1; ++i) {
            rampedValues[2 * i] = simple[i];
            rampedValues[2 * i + 1] = simple[i + 1];
            rampedItems[2 * i] = items[i];
            rampedItems[2 * i + 1] = items[i];
        }
        return new ColorMapping(rampedValues, rampedItems);
    }

    static {
        emptyPalette = new Palette("empty", Collections.EMPTY_LIST, false);
        COLORS_BY_NAME = new HashMap<String, String>();
        Scanner scanner = new Scanner(Palette.class.getResourceAsStream("/org/brunel/color/colors.txt")).useDelimiter("\n");
        ArrayList<String> boyntonColors = new ArrayList<String>();
        ArrayList<String> kellyColors = new ArrayList<String>();
        while (scanner.hasNext()) {
            String def;
            String s = scanner.next();
            String[] parts = s.split("[\t]+");
            if (parts.length != 3) continue;
            String namespace = parts[0].trim();
            String name = parts[1].toLowerCase().trim();
            String prev = COLORS_BY_NAME.put(name, def = parts[2].trim());
            if (prev != null && !prev.equals(def)) {
                throw new IllegalStateException("Color file redefined " + name + ". Was " + prev + ", redefined to " + def);
            }
            if (namespace.equalsIgnoreCase("boynton")) {
                boyntonColors.add(def);
            }
            if (!namespace.equalsIgnoreCase("kelly")) continue;
            kellyColors.add(def);
        }
        if (kellyColors.size() != 19) {
            throw new IllegalStateException("Expected 19 Kelly colors, but was " + kellyColors.size());
        }
        nominal19 = new Palette("nominal19", kellyColors, false);
    }
}

