/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.element;

import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3LabelBuilder;
import org.brunel.build.d3.D3ScaleBuilder;
import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.ScalePurpose;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.diagrams.GeoMap;
import org.brunel.build.d3.element.DefineLocations;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementDimension;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.d3.element.GeomAttribute;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.Accessibility;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;
import org.brunel.model.style.StyleTarget;

public class D3ElementBuilder {
    private static final String BAR_SPACING = "0.9";
    protected final ScriptWriter out;
    protected final VisSingle vis;
    private final D3ScaleBuilder scales;
    private final D3Interaction interaction;
    private final D3LabelBuilder labelBuilder;
    private final D3Diagram diagram;
    protected final ElementStructure structure;

    public D3ElementBuilder(ElementStructure structure, ScriptWriter out, D3ScaleBuilder scales, D3Interaction interaction) {
        this.structure = structure;
        this.vis = structure.vis;
        this.out = out;
        this.scales = scales;
        this.interaction = interaction;
        this.labelBuilder = new D3LabelBuilder(this.vis, out, structure.data);
        this.diagram = D3Diagram.make(structure, interaction, out);
    }

    public void generate(int elementIndex) {
        this.out.add("element = elements[" + elementIndex + "]").endStatement();
        ElementDetails details = this.makeDetails();
        this.setGeometry(details);
        if (this.diagram == null) {
            if (!this.structure.isGraphEdge()) {
                this.writeCoordinateFunctions(details);
                if (details.representation == ElementRepresentation.wedge) {
                    this.defineWedgePath();
                } else if (details.isDrawnAsPath()) {
                    this.definePathsAndSplits(details);
                }
            }
        } else {
            this.out.add("main.attr('class',", this.diagram.getStyleClasses(), ")").endStatement();
        }
        this.defineLabeling(details);
        this.out.add("selection = main.selectAll('.element').data(" + details.dataSource + ",", this.getKeyFunction(), ")").endStatement();
        this.out.add("var added = selection.enter().append('" + details.representation.getMark() + "')").addChained("attr('class', '" + Data.join((Object[])details.classes, (String)" ") + "')");
        if (!this.interaction.hasElementInteraction(this.structure)) {
            this.out.addChained("style('pointer-events', 'none')");
        }
        Accessibility.useElementLabelFunction(this.structure, this.out);
        if (this.diagram == null) {
            this.writeCoordEnter();
            this.out.add("merged = selection.merge(added)").endStatement();
        } else {
            this.out.endStatement();
            this.out.add("merged = selection.merge(added)").endStatement();
            this.diagram.writeDiagramEnter();
            this.diagram.writePreDefinition(details);
        }
        this.out.add("merged.filter(hasData).classed('selected', function(d) { return data.$selection(d) == '\u2713' })").endStatement();
        this.out.add("BrunelD3.transition(merged, transitionMillis)");
        if (this.diagram == null || this.diagram instanceof GeoMap) {
            this.writeCoordinateDefinition(details);
            this.writeCoordinateLabelingAndAesthetics(details, true);
            if (this.diagram != null) {
                this.diagram.writeDefinition(details);
            }
        } else {
            this.diagram.writeDefinition(details);
        }
        D3ElementBuilder.writeRemovalOnExit(this.out, "selection");
    }

    protected void defineLabeling(ElementDetails details) {
        int collisionDetectionGranularity;
        if (details.textCanOverlap()) {
            collisionDetectionGranularity = 0;
        } else {
            int n = this.structure.data.rowCount();
            double pow = Math.log(n / 10) / Math.log(4.0);
            collisionDetectionGranularity = (int)Math.pow(2.0, Math.floor(pow));
            collisionDetectionGranularity = Math.min(16, Math.max(1, collisionDetectionGranularity));
        }
        this.labelBuilder.defineLabeling(this.vis.itemsLabel, details.getTextMethod(), false, details.textFitsShape(), details.getAlignment(), details.getPadding(), collisionDetectionGranularity);
        Accessibility.defineElementLabelFunction(this.structure, this.out, this.labelBuilder);
    }

    public static void writeRemovalOnExit(ScriptWriter out, String selection) {
        out.onNewLine().ln().add("BrunelD3.transition(" + selection + ".exit(), transitionMillis/3)");
        out.addChained("style('opacity', 0.5).each( function() {").indentMore().indentMore().onNewLine().add("this.remove(); if (this.__label__) this.__label__.remove()").indentLess().indentLess().onNewLine().add("})").endStatement();
    }

    protected void writeCoordinateFunctions(ElementDetails details) {
        this.writeDimLocations(details.x, "x", "w");
        this.writeDimLocations(details.y, "y", "h");
        if (details.getRefLocation() != null) {
            this.out.add("function validReference(r) {");
            if (details.representation == ElementRepresentation.segment) {
                this.out.add("return r[0][0] != null && r[0][1] != null && r[1][0] != null && r[1][1] != null");
            } else {
                this.out.add("return r[0][0] != null && r[0][1] != null");
            }
            this.out.add("}").endStatement();
        }
    }

    private void writeDimLocations(ElementDimension dim, String mainName, String sizeName) {
        if (dim.clusterSize != null) {
            this.out.add("var clusterWidth =", dim.clusterSize).endStatement();
        }
        if (dim.size != null) {
            this.out.add("var", sizeName, "=", dim.size).endStatement();
        }
        if (dim.left != null && dim.right != null) {
            this.out.add("var", mainName + "1 =", dim.left).endStatement();
            this.out.add("var", mainName + "2 =", dim.right).endStatement();
        }
        if (dim.center != null) {
            this.out.add("var", mainName, "=", dim.center).endStatement();
        }
    }

    public boolean needsDiagramExtras() {
        return this.diagram != null && this.diagram.needsDiagramExtras();
    }

    public boolean needsDiagramLabels() {
        return this.diagram != null && this.diagram.needsDiagramLabels();
    }

    public void writeBuildCommands() {
        if (this.diagram != null) {
            this.diagram.writeBuildCommands();
        }
    }

    public void writePerChartDefinitions() {
        if (this.diagram != null) {
            this.diagram.writePerChartDefinitions();
        }
    }

    protected ElementDetails makeDetails() {
        if (this.structure.isGraphEdge()) {
            this.out.onNewLine().comment("Defining graph edge element");
            return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.segment, "edge", "graph.links");
        }
        if (this.diagram == null) {
            return ElementDetails.makeForCoordinates(this.vis, this.getSymbol());
        }
        this.out.onNewLine().comment(new Object[]{"Data structures for a", this.vis.tDiagram, "diagram"});
        return this.diagram.initializeDiagram();
    }

    protected void setGeometry(ElementDetails e) {
        Field[] x = this.structure.chart.coordinates.getX(this.vis);
        Field[] y = this.structure.chart.coordinates.getY(this.vis);
        Field[] keys = new Field[this.vis.fKeys.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.structure.data.field(this.vis.fKeys.get(i).asField());
        }
        if (this.structure.dependent) {
            this.defineReferenceFunctions(e, keys);
            DefineLocations.setDependentLocations(this.structure, e);
        }
        if (this.structure.chart.geo != null) {
            e.x.size = this.getSize(new Field[0], "geom.default_point_size", null, e.x);
            e.y.size = this.getSize(new Field[0], "geom.default_point_size", null, e.x);
            if (this.vis.tDiagram != VisTypes.Diagram.map) {
                this.setLocationsByProjection(e, x, y);
            } else if (e.representation != ElementRepresentation.geoFeature) {
                this.setLocationsByGeoPropertiesCenter(e);
            }
        } else {
            if (x.length > 1) {
                e.x.clusterSize = this.getSize(x, "geom.inner_width", ScalePurpose.x, e.x);
                e.x.size = this.getSize(x, "geom.inner_width", ScalePurpose.inner, e.x);
            } else {
                e.x.size = this.getSize(x, "geom.inner_width", ScalePurpose.x, e.x);
            }
            e.y.size = this.getSize(y, "geom.inner_height", ScalePurpose.y, e.y);
            DefineLocations.setLocations(e.representation, this.structure, e.x, "x", x, this.structure.chart.coordinates.xCategorical);
            DefineLocations.setLocations(e.representation, this.structure, e.y, "y", y, this.structure.chart.coordinates.yCategorical);
            if (e.representation == ElementRepresentation.area && e.y.right == null) {
                e.y.right = e.y.center;
                e.y.left = GeomAttribute.makeConstant("scale_y.range()[0]");
                e.y.center = null;
            }
        }
        e.overallSize = D3ElementBuilder.getOverallSize(this.vis, e);
    }

    private void defineReferenceFunctions(ElementDetails e, Field[] keys) {
        String[] references = this.structure.makeReferences(keys);
        if (this.structure.chart.geo != null) {
            for (int i = 0; i < references.length; ++i) {
                references[i] = "projection(" + references[i] + ")";
            }
            e.setReferences(references);
        } else if (!this.structure.isGraphEdge()) {
            e.setReferences(references);
        }
    }

    private void definePathsAndSplits(ElementDetails elementDef) {
        if (this.vis.tElement == VisTypes.Element.area) {
            this.out.add("var path = d3.area().x(x).y1(y2).y0(y1)");
        } else if (this.vis.tElement.producesSingleShape) {
            String yDef;
            String string = yDef = elementDef.y.right == null ? "y" : "y2";
            if (this.vis.fSize.size() == 1) {
                this.out.add("var path = BrunelD3.sizedPath().x(x).y(" + yDef + ")");
                GeomAttribute size = elementDef.y.size != null ? elementDef.y.size : elementDef.overallSize;
                this.out.addChained("r( function(d) { return " + size.definition() + "})");
            } else {
                this.out.add("var path = d3.line().x(x).y(" + yDef + ")");
            }
        }
        if (this.vis.tUsing == VisTypes.Using.interpolate) {
            this.out.add(".curve(d3.curveCatmullRom)");
        }
        this.out.endStatement();
        this.constructSplitPath();
    }

    private void defineWedgePath() {
        this.out.add("var path = d3.arc().innerRadius(0)");
        if (this.vis.fSize.isEmpty()) {
            this.out.addChained("outerRadius(geom.inner_radius)");
        } else {
            this.out.addChained("outerRadius(function(d) {return size(d)*geom.inner_radius})");
        }
        if (this.vis.fRange == null && !this.vis.stacked) {
            this.out.addChained("startAngle(0).endAngle(y)");
        } else {
            this.out.addChained("startAngle(y1).endAngle(y2)");
        }
        this.out.endStatement();
    }

    private String getKeyFunction() {
        String content = this.diagram != null ? this.diagram.getRowKey() : "d.key";
        return "function(d) { return " + content + "}";
    }

    private void writeCoordEnter() {
        StyleTarget target = StyleTarget.makeElementTarget("rect", "element", "point");
        ModelUtil.Size size = ModelUtil.getSize(this.vis, target, "border-radius");
        if (size != null) {
            this.out.addChained("attr('rx'," + size.value(8.0) + ").attr('ry', " + size.value(8.0) + ")").ln();
        }
        this.out.endStatement().onNewLine().ln();
    }

    private void writeCoordinateDefinition(ElementDetails details) {
        if (this.structure.isGraphEdge()) {
            return;
        }
        if (details.getRefLocation() != null) {
            this.out.addChained("each(function(d) { this.r = " + details.getRefLocation().definition() + "})");
            this.out.addChained("style('visibility', function() { return validReference(this.e) ? 'visible' : 'hidden'})");
        }
        if (details.requiresSplitting()) {
            this.out.addChained("attr('d', function(d) { return d.path })");
        } else if (details.isDrawnAsPath()) {
            if (this.vis.tDiagram == VisTypes.Diagram.map) {
                this.out.addChained("attr('d', function(d) { return path(d).replace(/,L/g, 'L').replace(/,Z/g, 'Z') })");
            } else {
                this.out.addChained("attr('d', path)");
            }
        } else if (details.representation == ElementRepresentation.rect) {
            this.defineRect(details);
        } else if (details.representation == ElementRepresentation.segment) {
            this.out.addChained("attr('x1', x1).attr('y1', y1).attr('x2', x2).attr('y2', y2)");
        } else if (details.representation == ElementRepresentation.text) {
            this.defineText(details, this.vis);
        } else if (details.representation == ElementRepresentation.pointLikeCircle || details.representation == ElementRepresentation.spaceFillingCircle || details.representation == ElementRepresentation.largeCircle) {
            this.defineCircle(details);
        }
    }

    protected void writeCoordinateLabelingAndAesthetics(ElementDetails details, boolean filterToDataOnly) {
        D3ElementBuilder.writeAesthetics(details, filterToDataOnly, this.vis, this.out, this.labelBuilder);
    }

    public static void writeAesthetics(ElementDetails details, boolean filterToDataOnly, VisSingle vis, ScriptWriter out, D3LabelBuilder labelBuilder) {
        boolean showsOpacity;
        boolean showsColor = !vis.fColor.isEmpty();
        boolean showsStrokeSize = details.isStroked() && !vis.fSize.isEmpty();
        boolean bl = showsOpacity = !vis.fOpacity.isEmpty();
        if (filterToDataOnly && (showsColor || showsOpacity || showsStrokeSize)) {
            out.addChained("filter(hasData)").at(50).comment("following only performed for data items");
        }
        if (showsColor) {
            String colorType = details.isStroked() ? "stroke" : "fill";
            out.addChained("style('" + colorType + "', color)");
        }
        if (showsStrokeSize) {
            out.addChained("style('stroke-width', size)");
        }
        if (showsOpacity) {
            out.addChained("style('fill-opacity', opacity)").addChained("style('stroke-opacity', opacity)");
        }
        out.endStatement();
        labelBuilder.addElementLabeling();
        labelBuilder.addTooltips(details);
    }

    private void defineText(ElementDetails elementDef, VisSingle vis) {
        if (elementDef.x.center != null) {
            this.out.addChained("attr('x'," + elementDef.x.center + ")");
        }
        if (elementDef.y.center != null) {
            this.out.addChained("attr('y'," + elementDef.y.center + ")");
        }
        this.out.addChained("attr('dy', '0.35em').text(labeling.content)");
        D3LabelBuilder.addFontSizeAttribute(vis, this.out);
    }

    private void defineCircle(ElementDetails elementDef) {
        if (elementDef.x.center != null) {
            this.out.addChained("attr('cx'," + elementDef.x.center + ")");
        }
        if (elementDef.y.center != null) {
            this.out.addChained("attr('cy'," + elementDef.y.center + ")");
        }
        this.out.addChained("attr('r'," + elementDef.overallSize.halved() + ")");
    }

    private String getSymbol() {
        String result = ModelUtil.getElementSymbol(this.vis);
        if (result != null) {
            return result;
        }
        if (this.structure.chart.geo != null) {
            return "point";
        }
        boolean cat = this.allShowExtent(this.structure.chart.coordinates.allXFields) && this.allShowExtent(this.structure.chart.coordinates.allYFields);
        return cat ? "rect" : "point";
    }

    private void setLocationsByProjection(ElementDetails def, Field[] x, Field[] y) {
        int n = x.length;
        if (y.length != n) {
            throw new IllegalStateException("X and Y dimensions do not match in geographic maps");
        }
        if (this.structure.isGraphEdge()) {
            throw new IllegalStateException("Cannot handle edged dependencies in geographic maps");
        }
        if (this.structure.dependent) {
            return;
        }
        if (n == 0) {
            def.x.center = GeomAttribute.makeConstant("null");
            def.y.center = GeomAttribute.makeConstant("null");
        } else if (n == 1) {
            String xFunction = D3Util.writeCall(x[0]);
            String yFunction = D3Util.writeCall(y[0]);
            if (DefineLocations.isRange(x[0])) {
                xFunction = xFunction + ".mid";
            }
            if (DefineLocations.isRange(y[0])) {
                yFunction = yFunction + ".mid";
            }
            def.x.center = GeomAttribute.makeFunction("projection([" + xFunction + "," + yFunction + "])[0]");
            def.y.center = GeomAttribute.makeFunction("projection([" + xFunction + "," + yFunction + "])[1]");
        } else if (n == 2) {
            String xLow = D3Util.writeCall(x[0]);
            String xHigh = D3Util.writeCall(x[1]);
            if (DefineLocations.isRange(x[0])) {
                xLow = xLow + ".low";
            }
            if (DefineLocations.isRange(x[1])) {
                xHigh = xHigh + ".high";
            }
            String yLow = D3Util.writeCall(y[0]);
            String yHigh = D3Util.writeCall(y[1]);
            if (DefineLocations.isRange(y[0])) {
                yLow = yLow + ".low";
            }
            if (DefineLocations.isRange(y[1])) {
                yHigh = yHigh + ".high";
            }
            def.x.left = GeomAttribute.makeFunction("projection([" + xLow + "," + yLow + "])[0]");
            def.x.right = GeomAttribute.makeFunction("projection([" + xHigh + "," + yHigh + "])[0]");
            def.y.left = GeomAttribute.makeFunction("projection([" + xLow + "," + yLow + "])[1]");
            def.y.right = GeomAttribute.makeFunction("projection([" + xHigh + "," + yHigh + "])[1]");
        }
    }

    private void setLocationsByGeoPropertiesCenter(ElementDetails e) {
        e.x.center = GeomAttribute.makeFunction("projection(d.geo_properties ? [d.geo_properties.c, d.geo_properties.d]: [-999,-999])[0]");
        e.y.center = GeomAttribute.makeFunction("projection(d.geo_properties ? [d.geo_properties.c, d.geo_properties.d]: [-999,-999])[1]");
    }

    private GeomAttribute getSize(Field[] fields, String extent, ScalePurpose purpose, ElementDimension dim) {
        String baseAmount;
        boolean needsFunction;
        boolean bl = needsFunction = dim.sizeFunction != null;
        if (dim.sizeStyle != null && !dim.sizeStyle.isPercent()) {
            baseAmount = "" + dim.sizeStyle.value(100.0);
        } else if (fields.length == 0) {
            baseAmount = this.vis.tDiagram != null ? "geom.default_point_size" : extent;
        } else if (dim.left != null) {
            baseAmount = "Math.abs(" + dim.left.definition() + "-" + dim.right.definition() + ")";
            needsFunction = true;
        } else {
            String scaleName = "scale_" + purpose.name();
            Field[] baseFields = fields;
            if (purpose == ScalePurpose.x) {
                baseFields = new Field[]{fields[0]};
            }
            if (purpose == ScalePurpose.inner) {
                baseFields = new Field[]{fields[1]};
            }
            int categories = this.scales.getCategories(baseFields).size();
            Double granularity = this.scales.getGranularitySuitableForSizing(baseFields);
            if ((purpose == ScalePurpose.x || purpose == ScalePurpose.y || purpose == ScalePurpose.inner) && baseFields.length == 1 && baseFields[0].isNumeric()) {
                categories = 0;
            }
            if (this.vis.tDiagram != null) {
                granularity = null;
                categories = 0;
            }
            if (categories > 0) {
                baseAmount = categories > 1 ? "Math.abs(" + scaleName + "(" + scaleName + ".domain()[1])" + " - " + scaleName + "(" + scaleName + ".domain()[0])" + " )" : extent;
                if (purpose == ScalePurpose.x && fields.length > 1) {
                    baseAmount = "0.8 * " + baseAmount;
                } else if (!(purpose == ScalePurpose.inner || this.scales.allNumeric(baseFields) || dim.sizeStyle != null && dim.sizeStyle.isPercent())) {
                    baseAmount = "0.9 * " + baseAmount;
                }
            } else {
                baseAmount = granularity != null ? "Math.abs( " + scaleName + "(" + scaleName + ".domain()[0] + " + granularity + ") - " + scaleName + ".range()[0] )" : "geom.default_point_size";
            }
        }
        if (dim.sizeStyle != null && dim.sizeStyle.isPercent()) {
            baseAmount = dim.sizeStyle.value(1.0) + " * " + baseAmount;
        }
        if (dim.clusterSize != null) {
            baseAmount = dim.clusterSize.isFunc() ? baseAmount + " * clusterWidth(d)" : baseAmount + " * clusterWidth";
        }
        if (dim.sizeFunction != null) {
            baseAmount = dim.sizeFunction + " * " + baseAmount;
        }
        if (needsFunction) {
            return GeomAttribute.makeFunction(baseAmount);
        }
        return GeomAttribute.makeConstant(baseAmount);
    }

    private static GeomAttribute getOverallSize(VisSingle vis, ElementDetails def) {
        boolean needsFunction;
        StyleTarget target = StyleTarget.makeElementTarget(null, def.classes);
        ModelUtil.Size size = ModelUtil.getSize(vis, target, "size");
        boolean bl = needsFunction = vis.fSize.size() == 1;
        if (size != null && !size.isPercent()) {
            if (needsFunction) {
                return GeomAttribute.makeFunction("size(d) * " + size.value(1.0));
            }
            return GeomAttribute.makeConstant(Double.toString(size.value(1.0)));
        }
        GeomAttribute x = def.x.size;
        GeomAttribute y = def.y.size;
        if (x.equals(y)) {
            return x;
        }
        String content = "Math.min(" + x.definition() + ", " + y.definition() + ")";
        if (x.isFunc() || y.isFunc()) {
            return GeomAttribute.makeFunction(content);
        }
        return GeomAttribute.makeConstant(content);
    }

    private void constructSplitPath() {
        String params = "data, path";
        if (this.vis.tElement == VisTypes.Element.line || this.vis.tElement == VisTypes.Element.area) {
            params = params + ", x";
        }
        this.out.add("var splits = BrunelD3.makePathSplits(" + params + ");").ln();
    }

    private void defineRect(ElementDetails details) {
        this.out.addChained("each(function(d) {").indentMore().indentMore().onNewLine();
        if (details.x.defineUsingExtent()) {
            this.out.add("var a =", details.x.left.call("x1"), ", b =", details.x.right.call("x2"), ", left = Math.min(a,b), width = Math.max(1e-6, Math.abs(a-b)), ");
        } else {
            this.out.add("var width =", details.x.size.call("w"), ", left =", details.x.center.call("x"), "- width/2, ");
        }
        this.out.onNewLine();
        if (details.y.defineUsingExtent()) {
            this.out.add("c =", details.y.left.call("y1"), ", d =", details.y.right.call("y2"), ", top = Math.min(c,d), height = Math.max(1e-6, Math.abs(c-d))").endStatement();
        } else {
            this.out.add("height =", details.y.size.call("h"), ", top =", details.y.center.call("y"), "- height/2").endStatement();
        }
        this.out.onNewLine().add("this.r = {x:left, y:top, w:width, h:height}").endStatement().indentLess().onNewLine().add("})").indentLess();
        this.out.addChained("attr('x', function(d) { return this.r.x })").addChained("attr('y', function(d) { return this.r.y })").addChained("attr('width', function(d) { return this.r.w })").addChained("attr('height', function(d) { return this.r.h })");
    }

    private boolean allShowExtent(Field[] fields) {
        for (Field field : fields) {
            if (!field.isNumeric() || field.isBinned()) continue;
            return false;
        }
        return true;
    }

    public void preBuildDefinitions() {
        if (this.diagram != null) {
            this.diagram.preBuildDefinitions();
        }
    }
}

