/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import org.brunel.build.info.ChartStructure;
import org.brunel.build.util.Accessibility;
import org.brunel.build.util.ScriptWriter;

public class SVGGroupUtility {
    public final String className;
    private final ChartStructure structure;
    private final ScriptWriter out;

    public SVGGroupUtility(ChartStructure structure, String className, ScriptWriter out) {
        this.className = className;
        this.structure = structure;
        this.out = out;
    }

    public void addAccessibleChartInfo() {
        if (this.structure.accessible) {
            this.addAccessibleTitle(Accessibility.makeNumberingTitle("chart", this.structure.chartIndex));
        }
    }

    public void addAccessibleTitle(String title) {
        if (this.structure.accessible) {
            Accessibility.writeLabelAttribute(title, this.out);
        }
    }

    public void addClipPathReference(ScriptWriter out) {
        out.addChained("attr('clip-path', 'url(#" + this.clipID() + ")')");
    }

    public String createChart() {
        return "vis.append('g').attr('class', '" + this.className + "')";
    }

    public void defineInnerClipPath() {
        this.out.add("vis.append('clipPath').attr('id', '" + this.clipID() + "').append('rect')").addChained("attr('x', -1).attr('y', -1)").addChained("attr('width', geom.inner_rawWidth+2).attr('height', geom.inner_rawHeight+2)").endStatement();
    }

    public void defineHorizontalAxisClipPath() {
        this.out.add("vis.append('clipPath').attr('id', '" + this.clipID() + "').append('polyline')").addChained("attr('points', '-1,-1 -5,5, -1000,5, -100,1000, 10000,1000 10000,-1')").endStatement();
    }

    private String clipID() {
        return "clip_" + this.structure.visIdentifier + "_" + this.className;
    }
}

