/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.action.parse;

import java.util.Set;
import java.util.TreeSet;
import org.brunel.data.Data;

public class GrammarItem {
    public final String name;
    public final String type;
    private final Set<String> parameters;
    private final Set<String> options;
    private final boolean emptyAllowed;
    private final boolean multiOptionsAllowed;

    GrammarItem(String[] description) {
        this.name = description[0];
        this.type = description[1];
        this.parameters = new TreeSet<String>();
        this.options = new TreeSet<String>();
        boolean canBeEmpty = false;
        boolean canBeMulti = false;
        for (int i = 2; i < description.length; ++i) {
            String s = description[i];
            if (s.equalsIgnoreCase("-")) {
                canBeEmpty = true;
                continue;
            }
            if (s.equalsIgnoreCase("+")) {
                canBeMulti = true;
                continue;
            }
            if (s.toUpperCase().equals(s)) {
                this.parameters.add(s);
                continue;
            }
            this.options.add(s);
        }
        this.emptyAllowed = canBeEmpty || this.hasNoContent();
        this.multiOptionsAllowed = canBeMulti;
    }

    public boolean allowsMultiples() {
        if (this.multiOptionsAllowed) {
            return true;
        }
        for (String s : this.parameters) {
            if (!s.endsWith("+")) continue;
            return true;
        }
        return false;
    }

    public boolean allowsParameter(String s, boolean secondAppearance) {
        return this.parameters.contains(s + "+") || !secondAppearance && this.parameters.contains(s);
    }

    public boolean hasNoContent() {
        return this.parameters.isEmpty() && this.options.isEmpty();
    }

    public boolean isOption(String s) {
        return this.options.contains(s);
    }

    public boolean mayHaveNoContent() {
        return this.emptyAllowed;
    }

    public boolean mayHaveMultipleOptions() {
        return this.multiOptionsAllowed;
    }

    public String options() {
        return Data.join(this.options);
    }
}

