/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.values;

import java.util.HashMap;
import java.util.HashSet;
import org.brunel.data.Data;
import org.brunel.data.util.MapInt;
import org.brunel.data.values.Provider;

public class ColumnProvider
implements Provider {
    private final Object[] column;

    public static Provider copy(Provider base) {
        Object[] data = new Object[base.count()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = base.value(i);
        }
        return new ColumnProvider(data);
    }

    public ColumnProvider(Object[] column) {
        HashMap<Object, Object> common = new HashMap<Object, Object>();
        this.column = new Object[column.length];
        for (int i = 0; i < column.length; ++i) {
            Object value = column[i];
            Object stored = common.get(value);
            if (stored == null) {
                common.put(value, value);
                this.column[i] = value;
                continue;
            }
            this.column[i] = stored;
        }
    }

    @Override
    public int count() {
        return this.column.length;
    }

    @Override
    public int expectedSize() {
        HashSet<Object> seen = new HashSet<Object>();
        int total = 24 + 4 * this.column.length;
        for (Object c : this.column) {
            if (c == null || !seen.add(c)) continue;
            if (c instanceof String) {
                total += 42 + ((String)c).length() * 2;
                continue;
            }
            total += 16;
        }
        return total;
    }

    @Override
    public Provider setValue(Object o, int index) {
        this.column[index] = o;
        return this;
    }

    @Override
    public int compareRows(int a, int b, MapInt categoryOrder) {
        Object p = this.column[a];
        Object q = this.column[b];
        if (p == q) {
            return 0;
        }
        if (p == null) {
            return 1;
        }
        if (q == null) {
            return -1;
        }
        if (categoryOrder.isEmpty()) {
            return Data.compare(p, q);
        }
        return categoryOrder.get(p) - categoryOrder.get(q);
    }

    @Override
    public Object value(int index) {
        return this.column[index];
    }
}

