/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.modify;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.Fields;
import org.brunel.data.modify.DataOperation;
import org.brunel.data.summary.DimensionField;
import org.brunel.data.summary.FieldRowComparison;
import org.brunel.data.summary.MeasureField;
import org.brunel.data.summary.SummaryValues;

public class Summarize
extends DataOperation {
    private final List<MeasureField> measures;
    private final List<DimensionField> dimensions;
    private final List<Field> percentBase;
    private final boolean percentNeeded;
    private final int rowCount;

    public static Dataset transform(Dataset base, String command) {
        if (base.rowCount() == 0) {
            return base;
        }
        List<String[]> operations = Summarize.map(command);
        if (operations.isEmpty()) {
            return base;
        }
        ArrayList<MeasureField> measures = new ArrayList<MeasureField>();
        ArrayList<DimensionField> dimensions = new ArrayList<DimensionField>();
        ArrayList<Field> percentBase = new ArrayList<Field>();
        boolean containsCount = false;
        boolean containsRow = false;
        boolean containsSelection = false;
        for (String[] op : operations) {
            if (op[0].equals("#count")) {
                containsCount = true;
            }
            if (op[0].equals("#row")) {
                containsRow = true;
            }
            if (op[0].equals("#selection")) {
                containsSelection = true;
            }
            String[] values = op[1].split(":");
            Field baseField = base.field(values[0].trim());
            if (values.length == 1) {
                dimensions.add(new DimensionField(baseField, op[0]));
                continue;
            }
            if (values[1].trim().equals("base")) {
                dimensions.add(new DimensionField(baseField, op[0]));
                percentBase.add(baseField);
                continue;
            }
            MeasureField measureField = new MeasureField(baseField, op[0], values[1].trim());
            if (values.length > 2) {
                measureField.option = values[2].trim();
            }
            measures.add(measureField);
        }
        Collections.sort(measures);
        Collections.sort(dimensions);
        if (!containsCount) {
            measures.add(new MeasureField(base.field("#count"), "#count", "sum"));
        }
        if (!containsRow) {
            measures.add(new MeasureField(base.field("#row"), "#row", "list"));
        }
        if (!containsSelection) {
            measures.add(new MeasureField(base.field("#selection"), "#selection", "mode"));
        }
        Summarize s = new Summarize(measures, dimensions, percentBase, base.rowCount());
        Field[] fields = s.make();
        return base.replaceFields(fields);
    }

    public Summarize(List<MeasureField> measures, List<DimensionField> dimensions, List<Field> percentBase, int rowCount) {
        this.measures = measures;
        this.dimensions = dimensions;
        this.percentBase = percentBase;
        this.rowCount = rowCount;
        boolean percentNeeded = false;
        for (MeasureField m : measures) {
            if (!m.isPercent()) continue;
            percentNeeded = true;
        }
        this.percentNeeded = percentNeeded;
    }

    private Field[] make() {
        int i;
        Field[] dimensionFields = this.getFields(this.dimensions);
        Field[] percentBaseFields = this.percentBase.toArray(new Field[this.percentBase.size()]);
        Field[] measureFields = this.getFields(this.measures);
        FieldRowComparison dimComparison = new FieldRowComparison(dimensionFields, null, false);
        FieldRowComparison percentBaseComparison = new FieldRowComparison(percentBaseFields, null, false);
        int[] group = new int[this.rowCount];
        int groupCount = this.buildGroups(group, dimComparison);
        int[] percentGroup = this.percentNeeded ? new int[this.rowCount] : null;
        int percentGroupCount = this.percentNeeded ? this.buildGroups(percentGroup, percentBaseComparison) : 0;
        SummaryValues[] summaries = new SummaryValues[groupCount];
        for (int i2 = 0; i2 < summaries.length; ++i2) {
            summaries[i2] = new SummaryValues(measureFields, percentBaseFields, dimensionFields);
        }
        double[][] percentSums = new double[percentGroupCount][measureFields.length];
        for (int row = 0; row < this.rowCount; ++row) {
            SummaryValues value = summaries[group[row]];
            if (this.percentNeeded) {
                if (value.percentSums == null) {
                    value.percentSums = percentSums[percentGroup[row]];
                }
                for (int i3 = 0; i3 < measureFields.length; ++i3) {
                    Double v;
                    if (!this.measures.get(i3).isPercent() || (v = Data.asNumeric(measureFields[i3].value(row))) == null) continue;
                    int n = i3;
                    value.percentSums[n] = value.percentSums[n] + v;
                }
            }
            value.rows.add(row);
        }
        Object[][] dimData = new Object[this.dimensions.size()][groupCount];
        Object[][] measureData = new Object[this.measures.size()][groupCount];
        for (int g = 0; g < groupCount; ++g) {
            int i4;
            SummaryValues values = summaries[g];
            int originalRow = values.firstRow();
            for (i4 = 0; i4 < this.dimensions.size(); ++i4) {
                dimData[i4][g] = dimensionFields[i4].value(originalRow);
            }
            for (i4 = 0; i4 < this.measures.size(); ++i4) {
                MeasureField m = this.measures.get(i4);
                measureData[i4][g] = values.get(i4, m);
            }
        }
        Field[] fields = new Field[dimData.length + measureData.length];
        for (i = 0; i < dimData.length; ++i) {
            DimensionField f = this.dimensions.get(i);
            fields[i] = Fields.makeColumnField(f.rename, f.label(), dimData[i]);
            Fields.copyBaseProperties(f.field, fields[i]);
        }
        for (i = 0; i < measureData.length; ++i) {
            MeasureField m = this.measures.get(i);
            Field result = Fields.makeColumnField(m.rename, m.label(), measureData[i]);
            this.setProperties(m.method, result, m.field);
            result.set("summary", m.method);
            result.set("calculated", true);
            if (m.field != null) {
                result.set("originalLabel", m.field.label);
            }
            fields[dimData.length + i] = result;
        }
        return fields;
    }

    private void setProperties(String f, Field to, Field src) {
        if (f.equals("list")) {
            to.copyProperties(src, "dateFormat");
            to.set("list", true);
        } else if (f.equals("count") || f.equals("percent") || f.equals("valid") || f.equals("unique")) {
            to.setNumeric();
        } else {
            Fields.copyBaseProperties(src, to);
        }
    }

    private Field[] getFields(List<? extends DimensionField> list) {
        Field[] result = new Field[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get((int)i).field;
        }
        return result;
    }

    private int buildGroups(int[] group, FieldRowComparison dimComparison) {
        if (dimComparison.isEmpty()) {
            return 1;
        }
        int[] order = dimComparison.makeSortedOrder();
        int currentGroup = 0;
        for (int i = 0; i < group.length; ++i) {
            if (i <= 0 || dimComparison.compare(order[i], order[i - 1]) != 0) {
                // empty if block
            }
            group[order[i]] = ++currentGroup;
        }
        return currentGroup + 1;
    }
}

