##############################################################################
#
# Copyright (c) 2007 Zope Foundation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""
$Id: tests.py 72566 2007-02-14 03:44:40Z rogerineichen $
"""

__docformat__ = "reStructuredText"

import doctest
import unittest
from zope.testing.doctestunit import DocFileSuite
from zope.app.testing.placelesssetup import setUp
from zope.app.testing.placelesssetup import tearDown

from z3c.resource.resource import Resource
from z3c.resource.testing import BaseTestIResource


class TestResource(BaseTestIResource):

    def getTestClass(self):
        return Resource


def test_suite():
    return unittest.TestSuite((
        unittest.makeSuite(TestResource),
        doctest.DocTestSuite('z3c.resource.resource'),
        doctest.DocTestSuite('z3c.resource.namespace'),
        DocFileSuite('README.txt', setUp=setUp, tearDown=tearDown,
            optionflags=doctest.NORMALIZE_WHITESPACE|doctest.ELLIPSIS),
        ))

if __name__ == '__main__': unittest.main()
