# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
from msrest import Serializer, Deserializer


class FeatureClientOperationsMixin(object):


    def list_operations(self, custom_headers=None, raw=False, **operation_config):
        """Lists all of the available Microsoft.Features REST API operations.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of Operation
        :rtype:
         ~azure.mgmt.resource.features.v2015_12_01.models.OperationPaged[~azure.mgmt.resource.features.v2015_12_01.models.Operation]
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        
        """
        api_version = self._get_api_version('list_operations')
        if api_version == '2015-12-01':
            from .v2015_12_01.operations import FeatureClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_operations(custom_headers, raw, **operation_config)
