/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.ma;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.snu.ids.ha.constants.Condition;
import org.snu.ids.ha.constants.POSTag;
import org.snu.ids.ha.dic.Dictionary;
import org.snu.ids.ha.ma.CharSetType;
import org.snu.ids.ha.ma.Eojeol;
import org.snu.ids.ha.ma.MCandidate;
import org.snu.ids.ha.ma.MExpression;
import org.snu.ids.ha.ma.MorphemeList;
import org.snu.ids.ha.ma.Sentence;
import org.snu.ids.ha.ma.Token;
import org.snu.ids.ha.ma.Tokenizer;
import org.snu.ids.ha.util.Util;

public class MorphemeAnalyzer {
    protected Dictionary dic = Dictionary.getInstance();
    PrintWriter logger = null;
    boolean doLogging = false;
    public static final boolean DEBUG = "DO_DEBUG".equals(System.getProperty("DO_DEBUG"));

    public List<MExpression> analyze(String string) throws Exception {
        if (!Util.valid(string)) {
            return null;
        }
        string = string.trim();
        ArrayList<MExpression> ret = new ArrayList<MExpression>();
        List<Token> tokenList = Tokenizer.tokenize(string);
        MExpression mePrev = null;
        MExpression meCur = null;
        int i = 0;
        int stop = tokenList.size();
        while (i < stop) {
            Token token = tokenList.get(i);
            if (!token.isCharSetOf(CharSetType.SPACE)) {
                List<MExpression> meList = this.analyze(mePrev, token);
                int j = 0;
                int jStop = meList.size();
                while (j < jStop) {
                    meCur = meList.get(j);
                    if (mePrev != null) {
                        mePrev.pruneWithNext(meCur);
                    }
                    ret.add(meCur);
                    mePrev = meCur;
                    ++j;
                }
            }
            ++i;
        }
        return ret;
    }

    private List<MExpression> analyze(MExpression mePrev, Token token) throws Exception {
        ArrayList<MExpression> ret = new ArrayList<MExpression>();
        if (!token.isCharSetOf(CharSetType.HANGUL)) {
            ret.add(new MExpression(token.string, new MCandidate(token)));
            return ret;
        }
        String string = token.string;
        int strlen = string.length();
        MExpression meHeadTemp = null;
        MExpression meTailTemp = null;
        MExpression meNew = null;
        MExpression[] meArr = new MExpression[strlen];
        String substr = null;
        String tail = null;
        int tailCutPos = 1;
        int firstOffset = token.index;
        while (tailCutPos <= strlen) {
            String strHead;
            substr = string.substring(0, tailCutPos);
            MExpression mExpression = this.getMExpression(substr, firstOffset);
            meArr[tailCutPos - 1] = mExpression;
            MExpression meCur = mExpression;
            meCur.pruneWithPrev(mePrev);
            int headCutPos = 1;
            while (headCutPos < tailCutPos) {
                this.writeLog("==========================================[" + substr + "]");
                tail = substr.substring(headCutPos, tailCutPos);
                meTailTemp = this.getMExpression(tail, firstOffset + headCutPos);
                meHeadTemp = meArr[headCutPos - 1];
                meNew = meHeadTemp.derive(meTailTemp);
                meNew.pruneWithPrev(mePrev);
                this.writeLog("[     HEAD ] " + meHeadTemp);
                this.writeLog("[     TAIL ] " + meTailTemp);
                this.writeLog("[GENERATED ] " + meNew);
                this.writeLog("[   STORED ] " + meCur);
                meCur.merge(meNew);
                this.writeLog("[   MERGED ] " + meCur);
                this.writeLog("==================================================");
                ++headCutPos;
            }
            if (tailCutPos != strlen && (meCur.isComplete() || tailCutPos >= 11) && strlen > 5 && meCur.size() > 3 && tailCutPos > 4 && (strHead = meCur.getCommonHead()) != null) {
                this.writeLog("[COMMON HEAD]==============" + strHead);
                int headLen = strHead.length();
                String tailStr = meCur.getExp().substring(headLen);
                MExpression[] meHeadTail = meCur.divideHeadTailAt(strHead, firstOffset, tailStr, firstOffset + headLen);
                MExpression headME = meHeadTail[0];
                ret.add(headME);
                mePrev = headME;
                this.writeLog(ret);
                MExpression[] newExps = new MExpression[tailCutPos - headLen];
                int k = headLen;
                int l = 0;
                while (k < tailCutPos) {
                    meHeadTail = meArr[k].divideHeadTailAt(strHead, token.index, tailStr.substring(0, l + 1), token.index + k);
                    newExps[l] = meHeadTail[1];
                    ++k;
                    ++l;
                }
                string = string.substring(strHead.length());
                strlen = string.length();
                meArr = new MExpression[strlen];
                tailCutPos = 0;
                int j = 0;
                int stop = newExps.length;
                while (j < stop) {
                    meArr[j] = newExps[j];
                    ++j;
                }
                tailCutPos = tailStr.length();
                firstOffset += strHead.length();
            }
            ++tailCutPos;
        }
        if (tailCutPos > 1) {
            ret.add(meArr[meArr.length - 1]);
        }
        int i = 0;
        int stop = ret.size();
        while (i < stop) {
            MExpression me = (MExpression)ret.get(i);
            if (me.size() == 0 || ((MCandidate)me.get(0)).getDicLenOnlyReal() == 0) {
                me.add(new MCandidate(me.exp, token.index));
            }
            ++i;
        }
        return ret;
    }

    private MExpression getMExpression(String string, int index) throws Exception {
        MExpression ret = this.dic.getMExpression(string);
        if (ret == null) {
            MCandidate mc = new MCandidate(string, index);
            ret = new MExpression(string, mc);
            ret.setLnprOfSpacing(mc.lnprOfSpacing);
        } else {
            ret.setIndex(index);
        }
        return ret;
    }

    public List<MExpression> postProcess(List<MExpression> melAnalResult) throws Exception {
        MExpression me1 = null;
        MExpression me2 = null;
        MExpression me3 = null;
        int i = 1;
        while (i < melAnalResult.size()) {
            me1 = melAnalResult.get(i - 1);
            me2 = melAnalResult.get(i);
            if (!me2.isComplete() || me1.isOneEojeolCheckable() || me2.isOneEojeolCheckable()) {
                MCandidate mc2;
                MCandidate mc1;
                if (me1.isNotHangul() && me2.isNotHangul()) {
                    mc1 = (MCandidate)me1.get(0);
                    mc2 = (MCandidate)me2.get(0);
                    if (mc1.firstMorp.index + mc1.getExp().length() == mc2.firstMorp.index) {
                        me1.exp = String.valueOf(me1.exp) + me2.exp;
                        mc1.addAll(mc2);
                        mc1.setExp(me1.exp);
                        melAnalResult.remove(i);
                        --i;
                    }
                } else if (me1.isNotHangul()) {
                    mc1 = (MCandidate)me1.get(0);
                    mc2 = (MCandidate)me2.get(0);
                    if (mc1.firstMorp.index + mc1.getExp().length() == mc2.firstMorp.index) {
                        me3 = me1.derive(me2);
                        melAnalResult.remove(i - 1);
                        melAnalResult.remove(i - 1);
                        melAnalResult.add(i - 1, me3);
                        --i;
                    }
                } else {
                    me3 = me1.derive(me2);
                    if (me3.isOneEojeol()) {
                        melAnalResult.remove(i - 1);
                        melAnalResult.remove(i - 1);
                        melAnalResult.add(i - 1, me3);
                        --i;
                    }
                }
            }
            ++i;
        }
        me1 = melAnalResult.get(0);
        i = 0;
        int size = 0;
        while (i < (size = me1.size()) && size > 1) {
            MCandidate mc = (MCandidate)me1.get(i);
            if (mc.cclEnc != Condition.ENG && mc.cclEnc != 0L || mc.firstMorp.isTagOf(POSTag.J | POSTag.E | POSTag.XS)) {
                me1.remove(i);
                --i;
            }
            ++i;
        }
        this.setBestPrevMC(melAnalResult);
        return melAnalResult;
    }

    private void setBestPrevMC(List<MExpression> meList) {
        MExpression mePrev = null;
        MExpression meCurr = null;
        int i = 0;
        int size = meList.size();
        while (i < size) {
            meCurr = meList.get(i);
            meCurr.setBestPrevMC(mePrev);
            mePrev = meCurr;
            ++i;
        }
        int idx = meList.size() - 1;
        MExpression me = meList.get(idx);
        me.sortByBestLnpr();
        MCandidate mc = (MCandidate)me.get(0);
        --idx;
        while (mc != null && idx >= 0) {
            mc = mc.prevBestMC;
            me = meList.get(idx);
            me.remove(mc);
            me.add(0, mc);
            --idx;
        }
    }

    public List<MExpression> leaveJustBest(List<MExpression> meList) throws Exception {
        int i = 0;
        while (i < meList.size()) {
            MExpression me = meList.get(i);
            MCandidate mc = (MCandidate)me.get(0);
            me.clear();
            me.add(mc);
            ++i;
        }
        ArrayList<MExpression> tempMEList = new ArrayList<MExpression>();
        for (MExpression me : meList) {
            tempMEList.addAll(me.split());
        }
        meList.clear();
        meList.addAll(tempMEList);
        return meList;
    }

    public List<Sentence> divideToSentences(List<MExpression> melAnalResult) throws Exception {
        ArrayList<Sentence> ret = new ArrayList<Sentence>();
        MExpression me1 = null;
        Eojeol eojeol = null;
        MorphemeList prevEojeol = null;
        ArrayList sentence = null;
        int i = 0;
        while (i < melAnalResult.size()) {
            if (sentence == null) {
                sentence = new Sentence();
            }
            me1 = melAnalResult.get(i);
            if (prevEojeol != null && ((MCandidate)me1.get(0)).isTagOf(POSTag.S) && prevEojeol.getStartIndex() + ((Eojeol)prevEojeol).exp.length() == ((MCandidate)me1.get((int)0)).firstMorp.index) {
                eojeol.addAll((Collection)me1.get(0));
                eojeol.exp = String.valueOf(eojeol.exp) + me1.exp;
            } else {
                eojeol = new Eojeol(me1);
                ((Sentence)sentence).add(eojeol);
                prevEojeol = eojeol;
            }
            if (eojeol.isEnding()) {
                if (i < melAnalResult.size() - 1) {
                    while (i < melAnalResult.size() - 1) {
                        me1 = melAnalResult.get(i + 1);
                        if (!me1.getExp().startsWith(".") && !me1.getExp().startsWith(",") && !me1.getExp().startsWith("!") && !me1.getExp().startsWith("?") && !me1.getExp().startsWith(";") && !me1.getExp().startsWith("~") && !me1.getExp().startsWith(")") && !me1.getExp().startsWith("]") && !me1.getExp().startsWith("}")) break;
                        if (eojeol.firstMorp.index + eojeol.exp.length() == ((MCandidate)me1.get((int)0)).firstMorp.index) {
                            eojeol.addAll((Collection)me1.get(0));
                            eojeol.exp = String.valueOf(eojeol.exp) + me1.exp;
                        } else {
                            ((Sentence)sentence).add(new Eojeol(me1));
                        }
                        ++i;
                    }
                }
                ret.add((Sentence)sentence);
                sentence = null;
                prevEojeol = null;
            }
            ++i;
        }
        if (sentence != null && sentence.size() > 0) {
            ret.add((Sentence)sentence);
        }
        return ret;
    }

    public void createLogger(String fileName) {
        try {
            System.out.println("DO LOGGING!!");
            this.logger = fileName == null ? new PrintWriter(System.out, true) : new PrintWriter((Writer)new FileWriter(fileName), true);
            this.doLogging = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeLogger() {
        if (this.doLogging && this.logger != null) {
            this.logger.close();
        }
        this.doLogging = false;
    }

    private void writeLog(Object obj) {
        if (DEBUG) {
            if (this.logger != null) {
                this.logger.println(obj);
            } else {
                System.out.println(obj);
            }
        }
    }
}

