# -*- coding: utf-8 -*-
'''
Created on 2016-12-13

@author: hustcc
'''
from __future__ import absolute_import
import os
import copy


def is_latin(c):
    '''decide c is latin or not
    '''
    return c.isalpha()


def is_space(c):
    '''decide c is space，中文
    '''
    return c.isspace()


def is_number(c):
    # 是否是数字
    return c in '1234567890'


def is_unit(c):
    # 判断是否为单位
    return 'TODO'


def is_fw_symbol(c):
    # 是否为中文符号
    return c in u'，。；：、？！'


def is_hw_symbol(c):
    # 是否为中文符号
    return c in ',.;:\?!'


def is_ellipsis_symbol(c):
    # 是否是省略号
    return c in u'…'


def is_fw_number(c):
    # 是否是圆角数字
    return c in u'０１２３４５６７８９'


def is_zh(c):
    '''判断是否为中文'''
    return u'\u4e00' <= c <= u'\u9fff' and True or False


def is_zh_unit(c):
    '''判断是否为单位'''
    return c in u'％℃°'


def ignore_errorcode(errors, ignores):
    '''ignore the errors in ignores
    '''
    if not isinstance(ignores, list):
        ignores = ignores.split(',')
    # trim the error code
    ignores = [code.strip() for code in ignores]
    # ignore error codes.
    errors = [error for error in errors if error.code not in ignores]
    return errors


def format_errors(errors, format):
    return [e.format(format) for e in errors]


def typeof(c):
    if is_number(c):
        return 'N'  # number
    if is_zh_unit(c):
        return 'U'  # zh unit
    if is_space(c):
        return 'S'  # space
    if is_ellipsis_symbol(c):  # 省略号
        return 'E'
    if is_fw_symbol(c):
        return 'H'  # zh sym
    if is_hw_symbol(c):
        return 'I'  # en sym
    if is_fw_number(c):
        return 'F'  # 全角 number
    if is_zh(c):
        return 'Z'  # zh
    if is_latin(c):
        return 'L'  # latin
    return 'O'  # other， no limit


detectors_on = None


def load_detectors():
    '''加载所有的检测器'''
    # 缓存一下，避免多次加载
    global detectors_on
    if detectors_on:
        return detectors_on

    from hint.detector import exxx
    detectors_on = [exxx.Detector]

    return detectors_on


# 使用非递归的方式，来遍历目中的所有 markdown 文件
def traversing_path_norecursive(all_files, path,
                                depth=0,
                                max_depth=3,
                                suffixs=['.md']):
    paths = [path]  # 需要被循环遍历的目录数组
    # 遍历深度限制
    paths_tmp = []  # 临时存储每次遍历的目录
    pj = os.path.join
    while depth <= max_depth:
        # 目录，新增一级
        depth += 1
        # 遍历这些目录
        for path in paths:
            ls = os.listdir(path)  # 目录中所有的文件，文件夹
            # 所有文件
            files = [f for f in ls if os.path.isfile(pj(path, f))]
            # 符合后缀名称的文件，添加到最后的 all_files 中
            all_files += [
                pj(path, f) for f in files if f[-3:] in suffixs
            ]

            # 所有文件夹，加入到待遍历数组中
            paths_tmp += [
                pj(path, d) for d in ls if os.path.isdir(pj(path, d))
            ]
        paths = copy.deepcopy(paths_tmp)
        # 每次遍历一层之后初始化
        paths_tmp = []

    return all_files


if __name__ == '__main__':
    print(traversing_path_norecursive([], 'E:/Work/git_code/hint',
                                      max_depth=4))
