# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServiceResourceDescription(Model):
    """This type describes a service resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the Service resource.
    :type name: str
    :param os_type: Required. The operation system required by the code in
     service. Possible values include: 'Linux', 'Windows'
    :type os_type: str or ~azure.servicefabric.models.OperatingSystemType
    :param code_packages: Required. Describes the set of code packages that
     forms the service. A code package describes the container and the
     properties for running it. All the code packages are started together on
     the same host and share the same context (network, process etc.).
    :type code_packages:
     list[~azure.servicefabric.models.ContainerCodePackageProperties]
    :param network_refs: The names of the private networks that this service
     needs to be part of.
    :type network_refs: list[~azure.servicefabric.models.NetworkRef]
    :param diagnostics: Reference to sinks in DiagnosticsDescription.
    :type diagnostics: ~azure.servicefabric.models.DiagnosticsRef
    :param description: User readable description of the service.
    :type description: str
    :param replica_count: The number of replicas of the service to create.
     Defaults to 1 if not specified.
    :type replica_count: int
    :param auto_scaling_policies: Auto scaling policies
    :type auto_scaling_policies:
     list[~azure.servicefabric.models.AutoScalingPolicy]
    :ivar status: Status of the service. Possible values include: 'Unknown',
     'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the service.
    :vartype status_details: str
    :ivar health_state: Describes the health state of an application resource.
     Possible values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :vartype health_state: str or ~azure.servicefabric.models.HealthState
    :ivar unhealthy_evaluation: When the service's health state is not 'Ok',
     this additional details from service fabric Health Manager for the user to
     know why the service is marked unhealthy.
    :vartype unhealthy_evaluation: str
    """

    _validation = {
        'name': {'required': True},
        'os_type': {'required': True},
        'code_packages': {'required': True},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
        'health_state': {'readonly': True},
        'unhealthy_evaluation': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'code_packages': {'key': 'properties.codePackages', 'type': '[ContainerCodePackageProperties]'},
        'network_refs': {'key': 'properties.networkRefs', 'type': '[NetworkRef]'},
        'diagnostics': {'key': 'properties.diagnostics', 'type': 'DiagnosticsRef'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'replica_count': {'key': 'properties.replicaCount', 'type': 'int'},
        'auto_scaling_policies': {'key': 'properties.autoScalingPolicies', 'type': '[AutoScalingPolicy]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'status_details': {'key': 'properties.statusDetails', 'type': 'str'},
        'health_state': {'key': 'properties.healthState', 'type': 'str'},
        'unhealthy_evaluation': {'key': 'properties.unhealthyEvaluation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceResourceDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.os_type = kwargs.get('os_type', None)
        self.code_packages = kwargs.get('code_packages', None)
        self.network_refs = kwargs.get('network_refs', None)
        self.diagnostics = kwargs.get('diagnostics', None)
        self.description = kwargs.get('description', None)
        self.replica_count = kwargs.get('replica_count', None)
        self.auto_scaling_policies = kwargs.get('auto_scaling_policies', None)
        self.status = None
        self.status_details = None
        self.health_state = None
        self.unhealthy_evaluation = None
