# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GatewayDestination(Model):
    """Describes destination endpoint for routing traffic.

    All required parameters must be populated in order to send to Azure.

    :param application_name: Required. Name of the service fabric Mesh
     application.
    :type application_name: str
    :param service_name: Required. service that contains the endpoint.
    :type service_name: str
    :param endpoint_name: Required. name of the endpoint in the service.
    :type endpoint_name: str
    """

    _validation = {
        'application_name': {'required': True},
        'service_name': {'required': True},
        'endpoint_name': {'required': True},
    }

    _attribute_map = {
        'application_name': {'key': 'applicationName', 'type': 'str'},
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'endpoint_name': {'key': 'endpointName', 'type': 'str'},
    }

    def __init__(self, *, application_name: str, service_name: str, endpoint_name: str, **kwargs) -> None:
        super(GatewayDestination, self).__init__(**kwargs)
        self.application_name = application_name
        self.service_name = service_name
        self.endpoint_name = endpoint_name
