# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ContainerCodePackageProperties(Model):
    """Describes a container and its runtime properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the code package.
    :type name: str
    :param image: Required. The Container image to use.
    :type image: str
    :param image_registry_credential: Image registry credential.
    :type image_registry_credential:
     ~azure.servicefabric.models.ImageRegistryCredential
    :param entrypoint: Override for the default entry point in the container.
    :type entrypoint: str
    :param commands: Command array to execute within the container in exec
     form.
    :type commands: list[str]
    :param environment_variables: The environment variables to set in this
     container
    :type environment_variables:
     list[~azure.servicefabric.models.EnvironmentVariable]
    :param settings: The settings to set in this container. The setting file
     path can be fetched from environment variable "Fabric_SettingPath". The
     path for Windows container is "C:\\\\secrets". The path for Linux
     container is "/var/secrets".
    :type settings: list[~azure.servicefabric.models.Setting]
    :param labels: The labels to set in this container.
    :type labels: list[~azure.servicefabric.models.ContainerLabel]
    :param endpoints: The endpoints exposed by this container.
    :type endpoints: list[~azure.servicefabric.models.EndpointProperties]
    :param resources: Required. The resources required by this container.
    :type resources: ~azure.servicefabric.models.ResourceRequirements
    :param volume_refs: Volumes to be attached to the container. The lifetime
     of these volumes is independent of the application's lifetime.
    :type volume_refs: list[~azure.servicefabric.models.VolumeReference]
    :param volumes: Volumes to be attached to the container. The lifetime of
     these volumes is scoped to the application's lifetime.
    :type volumes: list[~azure.servicefabric.models.ApplicationScopedVolume]
    :param diagnostics: Reference to sinks in DiagnosticsDescription.
    :type diagnostics: ~azure.servicefabric.models.DiagnosticsRef
    :param reliable_collections_refs: A list of ReliableCollection resources
     used by this particular code package. Please refer to
     ReliablecollectionsRef for more details.
    :type reliable_collections_refs:
     list[~azure.servicefabric.models.ReliableCollectionsRef]
    :ivar instance_view: Runtime information of a container instance.
    :vartype instance_view: ~azure.servicefabric.models.ContainerInstanceView
    """

    _validation = {
        'name': {'required': True},
        'image': {'required': True},
        'resources': {'required': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'image': {'key': 'image', 'type': 'str'},
        'image_registry_credential': {'key': 'imageRegistryCredential', 'type': 'ImageRegistryCredential'},
        'entrypoint': {'key': 'entrypoint', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[str]'},
        'environment_variables': {'key': 'environmentVariables', 'type': '[EnvironmentVariable]'},
        'settings': {'key': 'settings', 'type': '[Setting]'},
        'labels': {'key': 'labels', 'type': '[ContainerLabel]'},
        'endpoints': {'key': 'endpoints', 'type': '[EndpointProperties]'},
        'resources': {'key': 'resources', 'type': 'ResourceRequirements'},
        'volume_refs': {'key': 'volumeRefs', 'type': '[VolumeReference]'},
        'volumes': {'key': 'volumes', 'type': '[ApplicationScopedVolume]'},
        'diagnostics': {'key': 'diagnostics', 'type': 'DiagnosticsRef'},
        'reliable_collections_refs': {'key': 'reliableCollectionsRefs', 'type': '[ReliableCollectionsRef]'},
        'instance_view': {'key': 'instanceView', 'type': 'ContainerInstanceView'},
    }

    def __init__(self, *, name: str, image: str, resources, image_registry_credential=None, entrypoint: str=None, commands=None, environment_variables=None, settings=None, labels=None, endpoints=None, volume_refs=None, volumes=None, diagnostics=None, reliable_collections_refs=None, **kwargs) -> None:
        super(ContainerCodePackageProperties, self).__init__(**kwargs)
        self.name = name
        self.image = image
        self.image_registry_credential = image_registry_credential
        self.entrypoint = entrypoint
        self.commands = commands
        self.environment_variables = environment_variables
        self.settings = settings
        self.labels = labels
        self.endpoints = endpoints
        self.resources = resources
        self.volume_refs = volume_refs
        self.volumes = volumes
        self.diagnostics = diagnostics
        self.reliable_collections_refs = reliable_collections_refs
        self.instance_view = None
