# Generated by Django 3.2.5 on 2023-04-18 22:56

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Flow',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('flow_name', models.CharField(help_text='必填', max_length=255, verbose_name='流程名称')),
                ('module_name', models.CharField(blank=True, choices=[('USER', '用户(USER)'), ('THREAD', '信息(THREAD)'), ('COMMENT', '评论(COMMENT)'), ('FINANCE', '资金(FINANCE)'), ('ENROLL', '报名(ENROLL)'), ('RESOURCE', '资源(RESOURCE)'), ('DICTIONARY', '字典(DICTIONARY)'), ('PAYMENT', '支付(PAYMENT)'), ('ROLE', '角色(ROLE)')], max_length=32, null=True, verbose_name='模块名称')),
                ('description', models.CharField(blank=True, max_length=255, null=True, verbose_name='流程描述')),
            ],
            options={
                'verbose_name': '1.流程主表',
                'verbose_name_plural': '1.流程主表',
                'db_table': 'flow_flow',
            },
        ),
        migrations.CreateModel(
            name='FlowAction',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('action', models.CharField(db_index=True, help_text='必填', max_length=255, unique=True, verbose_name='动作关键字')),
                ('name', models.CharField(blank=True, max_length=255, null=True, verbose_name='动作名称')),
                ('description', models.CharField(blank=True, max_length=255, null=True, verbose_name='动作描述')),
                ('config', models.JSONField(blank=True, null=True, verbose_name='前端配置')),
            ],
            options={
                'verbose_name': '3.流程动作表',
                'verbose_name_plural': '3.流程动作表',
                'db_table': 'flow_action',
            },
        ),
        migrations.CreateModel(
            name='FlowNode',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('node_name', models.CharField(blank=True, help_text='节点名称建议使用下一流程状态命名。例如：已付款的下一状态是接单，则写待接单', max_length=255, null=True, verbose_name='节点名称')),
                ('node_value', models.CharField(blank=True, default='', max_length=255, null=True, verbose_name='节点值')),
                ('module_name', models.CharField(blank=True, choices=[('USER', '用户(USER)'), ('THREAD', '信息(THREAD)'), ('COMMENT', '评论(COMMENT)'), ('FINANCE', '资金(FINANCE)'), ('ENROLL', '报名(ENROLL)'), ('RESOURCE', '资源(RESOURCE)'), ('DICTIONARY', '字典(DICTIONARY)'), ('PAYMENT', '支付(PAYMENT)'), ('ROLE', '角色(ROLE)')], max_length=32, null=True, verbose_name='模块名称')),
                ('flow_number', models.IntegerField(blank=True, null=True, verbose_name='流程号')),
                ('status_code', models.IntegerField(blank=True, db_index=True, help_text='订单状态表示法：0完成、1 留空或非、2下单、3接单、4付款、5发货、6收货、7退货、8评价、9冗余', null=True, verbose_name='状态码')),
                ('summary', models.CharField(blank=True, max_length=1024, null=True, verbose_name='摘要')),
                ('description', models.CharField(blank=True, max_length=1024, null=True, verbose_name='描述')),
                ('config', models.JSONField(blank=True, default={}, help_text='前端状态配置', null=True, verbose_name='节点配置')),
                ('flow_id', models.ForeignKey(db_column='flow_id', on_delete=django.db.models.deletion.DO_NOTHING, to='xj_flow.flow', verbose_name='流程ID')),
            ],
            options={
                'verbose_name': '2.流程节点表',
                'verbose_name_plural': '2.流程节点表',
                'db_table': 'flow_node',
            },
        ),
        migrations.CreateModel(
            name='FlowToCategory',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('category_id', models.IntegerField(blank=True, null=True, verbose_name='类别ID')),
                ('flow', models.ForeignKey(db_column='flow_id', on_delete=django.db.models.deletion.DO_NOTHING, to='xj_flow.flow', verbose_name='流程ID')),
            ],
            options={
                'verbose_name': '2.流程节点类别表',
                'verbose_name_plural': '2.流程节点类别表',
                'db_table': 'flow_to_category',
            },
        ),
        migrations.CreateModel(
            name='FlowRecord',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('user_id', models.BigIntegerField(db_index=True, verbose_name='用户ID')),
                ('belong_role_id', models.IntegerField(blank=True, help_text='操作该记录的所属角色(即操作人)', null=True, verbose_name='所属角色ID')),
                ('summary', models.CharField(blank=True, db_index=True, help_text='摘要自动生成。例如：“【张三】检查完成【马云】的“XXX”资料，并信息补充”', max_length=255, null=True, verbose_name='摘要(自动)')),
                ('flow_node_id', models.ForeignKey(db_column='flow_node_id', on_delete=django.db.models.deletion.DO_NOTHING, to='xj_flow.flownode', verbose_name='流程节点ID')),
            ],
            options={
                'verbose_name_plural': '7. 流程记录表',
                'db_table': 'flow_record',
            },
        ),
        migrations.CreateModel(
            name='FlowNodeToAction',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(blank=True, default='', max_length=255, null=True, verbose_name='描述')),
                ('ttl', models.IntegerField(blank=True, default=-1, null=True, verbose_name='生命周期')),
                ('role_list', models.JSONField(blank=True, null=True, verbose_name='角色列表')),
                ('user_list', models.JSONField(blank=True, null=True, verbose_name='用户列表')),
                ('is_automatic', models.BooleanField(blank=True, default=0, null=True, verbose_name='是否自动触发')),
                ('flow_action_id', models.ForeignKey(db_column='flow_action_id', on_delete=django.db.models.deletion.DO_NOTHING, to='xj_flow.flowaction', verbose_name='流程动作ID')),
                ('flow_node_id', models.ForeignKey(db_column='flow_node_id', on_delete=django.db.models.deletion.DO_NOTHING, to='xj_flow.flownode', verbose_name='流程节点ID')),
                ('flow_to_fail_node_id', models.ForeignKey(blank=True, db_column='flow_to_fail_node_id', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='xj_flow.flownode', verbose_name='流向失败的节点ID')),
                ('flow_to_node_id', models.ForeignKey(blank=True, db_column='flow_to_node_id', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='xj_flow.flownode', verbose_name='流向节点ID')),
            ],
            options={
                'verbose_name': '4.流程节点多对多动作表',
                'verbose_name_plural': '4.流程节点多对多动作表',
                'db_table': 'flow_node_to_action',
                'unique_together': {('flow_node_id', 'flow_action_id', 'flow_to_node_id')},
            },
        ),
        migrations.CreateModel(
            name='FlowNodeLog',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('user_id', models.BigIntegerField(db_index=True, verbose_name='用户ID')),
                ('belong_role_id', models.IntegerField(blank=True, help_text='操作该日志的所属角色(即操作人)', null=True, verbose_name='所属角色ID')),
                ('summary', models.CharField(blank=True, db_index=True, help_text='摘要自动生成。例如：“【张三】检查完成【马云】的“XXX”资料，并信息补充”', max_length=255, null=True, verbose_name='摘要(自动)')),
                ('create_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='创建时间')),
                ('flow_node_id', models.ForeignKey(db_column='flow_node_id', on_delete=django.db.models.deletion.DO_NOTHING, to='xj_flow.flownode', verbose_name='流程节点ID')),
                ('flow_record_id', models.ForeignKey(db_column='flow_record_id', on_delete=django.db.models.deletion.DO_NOTHING, to='xj_flow.flowrecord', verbose_name='流程节点ID')),
            ],
            options={
                'verbose_name_plural': '8. 流程节点日志表',
                'db_table': 'flow_node_log',
            },
        ),
        migrations.CreateModel(
            name='FlowNodeActionRule',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('rule_name', models.CharField(blank=True, max_length=255, null=True, verbose_name='规则名称')),
                ('rule_sort', models.IntegerField(blank=True, db_index=True, null=True, verbose_name='规则顺序')),
                ('inflow_service', models.CharField(blank=True, choices=[('enroll_detail', '报名详细(enroll_detail)'), ('thread_detail', '信息详细(thread_detail)'), ('payment_detail', '支付详细(payment_detail)')], db_index=True, max_length=32, null=True, verbose_name='流入服务')),
                ('inflow_module', models.CharField(blank=True, choices=[('USER', '用户(USER)'), ('THREAD', '信息(THREAD)'), ('COMMENT', '评论(COMMENT)'), ('FINANCE', '资金(FINANCE)'), ('ENROLL', '报名(ENROLL)'), ('RESOURCE', '资源(RESOURCE)'), ('DICTIONARY', '字典(DICTIONARY)'), ('PAYMENT', '支付(PAYMENT)'), ('ROLE', '角色(ROLE)')], db_index=True, max_length=32, null=True, verbose_name='流入模块')),
                ('inflow_field', models.CharField(blank=True, max_length=32, null=True, verbose_name='流入字段')),
                ('outflow_module', models.CharField(blank=True, choices=[('USER', '用户(USER)'), ('THREAD', '信息(THREAD)'), ('COMMENT', '评论(COMMENT)'), ('FINANCE', '资金(FINANCE)'), ('ENROLL', '报名(ENROLL)'), ('RESOURCE', '资源(RESOURCE)'), ('DICTIONARY', '字典(DICTIONARY)'), ('PAYMENT', '支付(PAYMENT)'), ('ROLE', '角色(ROLE)')], db_index=True, help_text='默认与流入模块相同', max_length=32, null=True, verbose_name='流出模块')),
                ('outflow_field', models.CharField(blank=True, help_text='默认与流入字段相同。如果流出字段不存在则自动创建', max_length=32, null=True, verbose_name='流出字段')),
                ('default_value', models.CharField(blank=True, max_length=255, null=True, verbose_name='默认值')),
                ('expression_string', models.CharField(blank=True, max_length=2048, null=True, verbose_name='逻辑表达式')),
                ('python_script', models.TextField(blank=True, null=True, verbose_name='帕森脚本')),
                ('flow_node_to_action_id', models.ForeignKey(db_column='flow_node_to_action_id', db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, to='xj_flow.flownodetoaction', verbose_name='流程节点动作ID')),
            ],
            options={
                'verbose_name_plural': '6. 流程节点动作规则表',
                'db_table': 'flow_node_action_rule',
            },
        ),
        migrations.AddField(
            model_name='flownode',
            name='many_flow_action_id',
            field=models.ManyToManyField(through='xj_flow.FlowNodeToAction', to='xj_flow.FlowAction', verbose_name='多对多流程动作ID'),
        ),
        migrations.CreateModel(
            name='FlowLastStatus',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('module_code', models.CharField(max_length=255, verbose_name='模型编码')),
                ('table_code', models.CharField(max_length=255, verbose_name='表编码')),
                ('relate_data_id', models.IntegerField(verbose_name='执行的主键ID')),
                ('user_id', models.IntegerField(blank=True, db_index=True, null=True, verbose_name='用户ID')),
                ('flow_node_id', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='xj_flow.flownode', verbose_name='当前用户的节点')),
            ],
            options={
                'verbose_name_plural': '9. 流程节点日志表',
                'db_table': 'flow_last_status',
            },
        ),
        migrations.CreateModel(
            name='FlowActionToOperator',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='ID')),
                ('role_id', models.IntegerField(blank=True, help_text='操作该记录的所属角色(即操作组)', null=True, verbose_name='操作角色ID')),
                ('user_id', models.BigIntegerField(blank=True, help_text='操作该记录的所属用户(即操作人)', null=True, verbose_name='操作人员ID')),
                ('flow_action_id', models.ForeignKey(db_column='flow_action_id', on_delete=django.db.models.deletion.DO_NOTHING, to='xj_flow.flowaction', verbose_name='流程动作ID')),
            ],
            options={
                'verbose_name': '5.流程动作多对多操作人表',
                'verbose_name_plural': '5.流程动作多对多操作人表',
                'db_table': 'flow_action_to_operator',
            },
        ),
    ]
