def get_category_ldap_from_crf_code(value):
    """ get the CRF category this CRF Code matches
        According to the rules previously set
        for LDAP Matching
    """
    return CRF_CODES.get(value, {}).get('ldap', '')


def get_category_value_from_crf_code(value):
    """ get the CRF category value to show it in the observation metadata """

    # return CRF_CODES.get(value, {}).get('sectorname', '')
    return CRF_CODES.get(value, {}).get('title', '')


CRF_CODES = {
    '1A1': {'title': '1A1 Fuel Combustion Activities - Energy Industries',
            'ldap': 'sector1',
            'sectorname': '',
    },
    '1A2': {'title': '1A2 Fuel Combustion Activities - Manufacturing Industries and Construction',
            'ldap': 'sector2',
            'sectorname': '',
    },
    '1A3a': {'title': '1A3a Fuel Combustion Activities - Transport - Civil Aviation',
            'ldap': 'sector3',
            'sectorname': '',
    },
    '1A3b': {'title': '1A3b Fuel Combustion Activities - Transport - Road transportation',
            'ldap': 'sector3',
            'sectorname': '',
    },
    '1A3c': {'title': '1A3c Fuel Combustion Activities - Transport - Railways',
            'ldap': 'sector3',
            'sectorname': '',
    },
    '1A3d': {'title': '1A3d Fuel Combustion Activities - Transport - Water-borne Navigation',
            'ldap': 'sector3',
            'sectorname': '',
    },
    '1A3e': {'title': '1A3e Fuel Combustion Activities - Transport - Other Transportation',
            'ldap': 'sector3',
            'sectorname': '',
    },
    '1A4': {'title': '1A4 Fuel Combustion Activities - Other Sectors',
            'ldap': 'sector2',
            'sectorname': '',
    },
    '1A5': {'title': '1A5 Fuel Combustion Activities - Non- Specified',
            'ldap': 'sector2',
            'sectorname': '',
    },
    '1B1': {'title': '1B1 Fugitive emissions from fuels - Solid Fuels',
            'ldap': 'sector4',
            'sectorname': '',
    },
    '1B2a': {'title': '1B2a Fugitive Emissions from Fuels - Oil and Natural Gas - Oil',
            'ldap': 'sector4',
            'sectorname': '',
    },
    '1B2b': {'title': '1B2b Fugitive Emissions from Fuels - Oil and Natural Gas - Natural gas',
            'ldap': 'sector4',
            'sectorname': '',
    },
    '1C': {'title': '1C Carbon Dioxide Transport and Storage',
            'ldap': 'sector4',
            'sectorname': '',
    },
    '2A1': {'title': '2A1 Mineral industry - Cement Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2A2': {'title': '2A2 Mineral Industry - Lime Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2A3': {'title': '2A3 Mineral Industry - Glass Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2A4': {'title': '2A4 Mineral Industry - Other Process Uses of Carbonates',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2B1': {'title': '2B1 Chemical Industry - Ammonia Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2B2': {'title': '2B2 Chemical industry - Nitric Acid Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2B3': {'title': '2B3 Chemical industry - Adipic Acid Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2B4': {'title': '2B4 Chemical industry - Caprolactam, Glyoxal and Glyoxylic Acid Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2B5': {'title': '2B5 Chemical industry - Carbide Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2B6': {'title': '2B6 Chemical industry - Titanium Dioxide Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2B7': {'title': '2B7 Chemical Industry - Soda Ash Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2B8': {'title': '2B8 Chemical Industry - Petrochemical and Carbon Black Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2B9': {'title': '2B9 Chemical Industry - Fluorochemical Production',
            'ldap': 'sector5',
            'sectorname': '',
    },
    '2C1': {'title': '2C1 Metal Industry - Iron and Steel Production',
            'ldap': 'sector6',
            'sectorname': '',
    },
    '2C2': {'title': '2C2 Metal Industry - Ferroalloys Production',
            'ldap': 'sector6',
            'sectorname': '',
    },
    '2C3': {'title': '2C3 Metal Industry - Aluminium Production',
            'ldap': 'sector6',
            'sectorname': '',
    },
    '2C4': {'title': '2C4 Metal Industry - Magnesium Production',
            'ldap': 'sector6',
            'sectorname': '',
    },
    '2C5': {'title': '2C5 Metal Industry - Lead Production',
            'ldap': 'sector6',
            'sectorname': '',
    },
    '2C6': {'title': '2C6 Metal Industry - Zinc Production',
            'ldap': 'sector6',
            'sectorname': '',
    },
    '2D': {'title': '2D Non-Energy Products from Fuels and Solvent Use',
            'ldap': 'sector6',
            'sectorname': '',
    },
    '2E': {'title': '2E Electronics Industry',
            'ldap': 'sector7',
            'sectorname': '',
    },
    '2F1': {'title': '2F1 Product Uses as Substitutes for Ozone Depleting Substances - Refrigeration and Air Conditioning',
            'ldap': 'sector7',
            'sectorname': '',
    },
    '2F2': {'title': '2F2 Product Uses as Substitutes for Ozone Depleting Substances - Foam Blowing Agents',
            'ldap': 'sector7',
            'sectorname': '',
    },
    '2F3': {'title': '2F3 Product Uses as Substitutes for Ozone Depleting Substances - Fire Protection',
            'ldap': 'sector7',
            'sectorname': '',
    },
    '2F4': {'title': '2F4 Product Uses as Substitutes for Ozone Depleting Substances - Aerosolls',
            'ldap': 'sector7',
            'sectorname': '',
    },
    '2F5': {'title': '2F5 Product Uses as Substitutes for Ozone Depleting Substances - Solvents',
            'ldap': 'sector7',
            'sectorname': '',
    },
    '2F6': {'title': '2F6 Product Uses as Substitutes for Ozone Depleting Substances - Other Applications',
            'ldap': 'sector7',
            'sectorname': '',
    },
    '2G': {'title': '2G Other Product Manufacture and Use',
            'ldap': 'sector7',
            'sectorname': '',
    },
    '3A1': {'title': '3A1 Enteric Fermentation',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3A2': {'title': '3A2 Manure Management',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3B1a': {'title': '3B1a Forest Land Remaining Forest Land',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3B1b': {'title': '3B1b Land Converted to Forest Land',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3B2a': {'title': '3B2a Cropland Remaining Cropland',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3B2b': {'title': '3B2b Land Converted to Cropland',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3B3a': {'title': '3B3a Grassland Remaining Grassland',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3B3b': {'title': '3B3b Land Converted to Grassland',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3B4ai': {'title': '3B4ai Peatlands Remaining Peatlands',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3B4aii': {'title': '3B4aii Flooded land remaining Flooded land',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3B4b': {'title': '3B4b Land Converted to Wetlands',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3B5a': {'title': '3B5a Settlements Remaining Settlements',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3B5b': {'title': '3B5b Land Converted to Settlements',
            'ldap': 'sector8',
            'sectorname': '',
    },
    '3C1': {'title': '3C1 Biomass Burning',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '3C2': {'title': '3C2 Liming',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '3C3': {'title': '3C3 Urea Application',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '3C4': {'title': '3C4 Direct N2O Emissions from Managed soils',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '3C5': {'title': '3C5 Indirect N2O Emissions from Managed soils',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '3C6': {'title': '3C6 Indirect N2O Emissions from Manure Management',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '3C7': {'title': '3C7 Rice Cultivations',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '3D1': {'title': '3D1 Harvested Wood Products',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '4A': {'title': '4A Solid Waste Disposal',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '4B': {'title': '4B Biological Treatment of Solid Waste',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '4C': {'title': '4C Incineration and Open Burning of Waste',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '4D': {'title': '4D Wastewater Treatment and Discharge',
            'ldap': 'sector9',
            'sectorname': '',
    },
    '5A': {'title': '5A Indirect N2O Emissions from the atmospheric deposition of nitrogen in NOx and NH3',
            'ldap': 'sector11',
            'sectorname': '',
    },
    '5B': {'title': '5B Other',
            'ldap': 'sector11',
            'sectorname': '',
    },
}
