# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConnectToSourcePostgreSqlSyncTaskOutput(Model):
    """Output for the task that validates connection to PostgreSQL and source
    server requirements.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Result identifier
    :vartype id: str
    :ivar source_server_version: Version of the source server
    :vartype source_server_version: str
    :ivar databases: List of databases on source server
    :vartype databases: list[str]
    :ivar source_server_brand_version: Source server brand version
    :vartype source_server_brand_version: str
    :ivar validation_errors: Validation errors associated with the task
    :vartype validation_errors:
     list[~azure.mgmt.datamigration.models.ReportableException]
    """

    _validation = {
        'id': {'readonly': True},
        'source_server_version': {'readonly': True},
        'databases': {'readonly': True},
        'source_server_brand_version': {'readonly': True},
        'validation_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'source_server_version': {'key': 'sourceServerVersion', 'type': 'str'},
        'databases': {'key': 'databases', 'type': '[str]'},
        'source_server_brand_version': {'key': 'sourceServerBrandVersion', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[ReportableException]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ConnectToSourcePostgreSqlSyncTaskOutput, self).__init__(**kwargs)
        self.id = None
        self.source_server_version = None
        self.databases = None
        self.source_server_brand_version = None
        self.validation_errors = None
