# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AzureActiveDirectoryApp(Model):
    """Azure Active Directory Application.

    All required parameters must be populated in order to send to Azure.

    :param application_id: Required. Application ID of the Azure Active
     Directory Application
    :type application_id: str
    :param app_key: Required. Key used to authenticate to the Azure Active
     Directory Application
    :type app_key: str
    :param tenant_id: Required. Tenant id of the customer
    :type tenant_id: str
    """

    _validation = {
        'application_id': {'required': True},
        'app_key': {'required': True},
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'app_key': {'key': 'appKey', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, *, application_id: str, app_key: str, tenant_id: str, **kwargs) -> None:
        super(AzureActiveDirectoryApp, self).__init__(**kwargs)
        self.application_id = application_id
        self.app_key = app_key
        self.tenant_id = tenant_id
