# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class QueryRequestOptions(Model):
    """The options for query evaluation.

    :param skip_token: Continuation token for pagination, capturing the next
     page size and offset, as well as the context of the query.
    :type skip_token: str
    :param top: The maximum number of rows that the query should return.
     Overrides the page size when ```$skipToken``` property is present.
    :type top: int
    :param skip: The number of rows to skip from the beginning of the results.
     Overrides the next page offset when ```$skipToken``` property is present.
    :type skip: int
    :param result_format: Defines in which format query result returned.
     Possible values include: 'table', 'objectArray'
    :type result_format: str or ~azure.mgmt.resourcegraph.models.ResultFormat
    """

    _validation = {
        'top': {'maximum': 1000, 'minimum': 1},
        'skip': {'minimum': 0},
    }

    _attribute_map = {
        'skip_token': {'key': '$skipToken', 'type': 'str'},
        'top': {'key': '$top', 'type': 'int'},
        'skip': {'key': '$skip', 'type': 'int'},
        'result_format': {'key': 'resultFormat', 'type': 'ResultFormat'},
    }

    def __init__(self, *, skip_token: str=None, top: int=None, skip: int=None, result_format=None, **kwargs) -> None:
        super(QueryRequestOptions, self).__init__(**kwargs)
        self.skip_token = skip_token
        self.top = top
        self.skip = skip
        self.result_format = result_format
