# -*- coding: utf-8 -*-
# 竺家寧(1992)《聲韻學》p.76-8
官話注音符號對照音值聲母表 = {
    'ㄅ': 'p', 'ㄆ': 'pʰ', 'ㄇ': 'm', 'ㄈ': 'f',
    'ㄉ': 't', 'ㄊ': 'tʰ', 'ㄋ': 'n', 'ㄌ': 'l',
    'ㄍ': 'k', 'ㄎ': 'kʰ', 'ㄏ': 'h',
    'ㄐ': 'tɕ', 'ㄑ': 'tɕʰ', 'ㄒ': 'ɕ',
    'ㄓ': 'tʂ', 'ㄔ': 'tʂʰ', 'ㄕ': 'ʂ', 'ㄖ': 'ʐ',
    'ㄗ': 'ts', 'ㄘ': 'tsʰ', 'ㄙ': 's', '': 'ʔ',
}

官話注音符號對照音值韻母表 = {
    '': 'ï', 'ㄧ': 'i', 'ㄨ': 'u', 'ㄩ': 'y',
        'ㄚ': 'a', 'ㄛ': 'o', 'ㄜ': 'ɤ', 'ㄝ': 'e',
        'ㄞ': 'ai', 'ㄟ': 'ei', 'ㄠ': 'au', 'ㄡ': 'ou',
        'ㄢ': 'an', 'ㄣ': 'ən', 'ㄤ': 'aŋ', 'ㄥ': 'əŋ', 'ㄦ': 'ɚ',
        'ㄧㄚ': 'ia', 'ㄧㄛ': 'io', 'ㄧㄝ': 'ie', 'ㄧㄞ': 'iai',
        'ㄧㄠ': 'iau', 'ㄧㄡ': 'iou',
        'ㄧㄢ': 'ien', 'ㄧㄣ': 'in', 'ㄧㄤ': 'iaŋ', 'ㄧㄥ': 'iŋ',
        'ㄨㄚ': 'ua', 'ㄨㄛ': 'uo', 'ㄨㄞ': 'uai', 'ㄨㄟ': 'uei',
        'ㄨㄢ': 'uan', 'ㄨㄣ': 'uən', 'ㄨㄤ': 'uaŋ', 'ㄨㄥ': 'uŋ',
        'ㄩㄝ': 'ye', 'ㄩㄢ': 'yen', 'ㄩㄣ': 'yn', 'ㄩㄥ': 'yuŋ',
}

官話韻母實際音值表 = {'sï': 'ɿ', 'ʂï': 'ʅ', 'tuŋ': 'oŋ'}
官話韻母實際音值表.update(官話注音符號對照音值韻母表)


class 官話注音符號轉音值模組():
    聲母表 = 官話注音符號對照音值聲母表
    韻母表 = 官話注音符號對照音值韻母表
    唇音 = {'p', 'pʰ', 'm', 'f', }

    def 轉(self, 聲, 韻, 調):
        if 聲 is None or 韻 is None or 調 is None:
            return (None,)
        音值聲 = self.聲母表[聲]
        音值韻 = self.韻母表[韻]
        if 音值韻 == 'ï':
            if 's' in 音值聲:  # 舌尖前音
                音值韻 = 'ɿ'
            elif 'ʂ' in 音值聲 or 'ʐ' in 音值聲:  # 舌尖前音
                音值韻 = 'ʅ'
            else:
                raise RuntimeError(
                    '函式庫有問題！！傳入來的是：{}、{}、{}'.format(聲, 韻, 調))
        elif 音值韻 == 'o':
            if 音值聲 in self.唇音:
                音值韻 = 'uo'
        elif 音值韻 == 'uŋ':
            if 音值聲 != 'ʔ':
                音值韻 = 'oŋ'
        elif 音值韻 == 'əŋ':
            if 音值聲 in self.唇音:
                音值韻 = 'oŋ'
        音值調 = 調
        return (音值聲, 音值韻, 音值調)
