!***************************************************************************************************
! Copyright 2009 S. Bourdarie
!
! This file is part of IRBEM-LIB.
!
!    IRBEM-LIB is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Lesser General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    IRBEM-LIB is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU Lesser General Public License for more details.
!
!    You should have received a copy of the GNU Lesser General Public License
!    along with IRBEM-LIB.  If not, see <http://www.gnu.org/licenses/>.
!
!
! CREATION: S. Bourdarie - ONERA-DESP
!
! FILE CONTENT:
!               SUBROUTINE InitLAndI2Lstar_OlsonPfitzerQuiet: Set block data for LAndI2Lstar_OlsonPfitzerQuiet
!
!***************************************************************************************************
C-----------------------------------------------------------------------------
C IDL Wrappers
C-----------------------------------------------------------------------------

      REAL*4 FUNCTION LAndI2Lstar(argc, argv)   ! Called by IDL
      INCLUDE 'wrappers.inc'
c      INTEGER*4 argc, argv(*)                      ! Argc and Argv are integers

       j = loc(argc)                    ! Obtains the number of arguments (argc)
                                       ! Because argc is passed by VALUE.

c  Call subroutine LAndI2Lstar, converting the IDL parameters to standard FORTRAN
c  passed by reference arguments.
c
c  subroutine LAndI2Lstar: 17 arguments
      call LAndI2Lstar1(%VAL(argv(1)), %VAL(argv(2)), %VAL(argv(3)),
     * %VAL(argv(4)),  %VAL(argv(5)),  %VAL(argv(6)),  %VAL(argv(7)),
     * %VAL(argv(8)),  %VAL(argv(9)),  %VAL(argv(10)), %VAL(argv(11)),
     + %VAL(argv(12)), %VAL(argv(13)), %VAL(argv(14)), %VAL(argv(15)),
     + %VAL(argv(16)), %VAL(argv(17)))

      LAndI2Lstar = 9.9

      RETURN
      END
c
!C-----------------------------------------------------------------------------
C IDL Wrappers
C-----------------------------------------------------------------------------

      REAL*4 FUNCTION EmpiricalLstar(argc, argv)   ! Called by IDL
      INCLUDE 'wrappers.inc'
c      INTEGER*4 argc, argv(*)                      ! Argc and Argv are integers

       j = loc(argc)                    ! Obtains the number of arguments (argc)
                                       ! Because argc is passed by VALUE.

c  Call subroutine EmpiricalLstar, converting the IDL parameters to standard FORTRAN
c  passed by reference arguments.
c
c  subroutine EmpiricalLstar: 9 arguments
      call EmpiricalLstar1(%VAL(argv(1)), %VAL(argv(2)), %VAL(argv(3)),
     * %VAL(argv(4)),  %VAL(argv(5)),  %VAL(argv(6)),  %VAL(argv(7)),
     * %VAL(argv(8)),%VAL(argv(9)))

      EmpiricalLstar = 9.9

      RETURN
      END
c
C-----------------------------------------------------------------------------
C IDL Wrappers
C-----------------------------------------------------------------------------

      REAL*4 FUNCTION LAndI2Lstar_shell_splitting(argc, argv)   ! Called by IDL
      INCLUDE 'wrappers.inc'
c
       j = loc(argc)                    ! Obtains the number of arguments (argc)
                                       ! Because argc is passed by VALUE.
      call LAndI2Lstar_shell_splitting1(%VAL(argv(1)),%VAL(argv(2)),
     &  %VAL(argv(3)),%VAL(argv(4)),%VAL(argv(5)),%VAL(argv(6)),
     &  %VAL(argv(7)),%VAL(argv(8)),%VAL(argv(9)),%VAL(argv(10)),
     &  %VAL(argv(11)),%VAL(argv(12)),%VAL(argv(13)),%VAL(argv(14)),
     &  %VAL(argv(15)),%VAL(argv(16)),%VAL(argv(17)),%VAL(argv(18)),
     &  %VAL(argv(19)))
c
      LAndI2Lstar_shell_splitting = 9.9

      RETURN
      END
c
!--------------------------------------------------------------------------------------------
!+
! NAME:
!	InitLAndI2Lstar_OlsonPfitzerQuiet
!
! PURPOSE:
!	This subroutine Allows to init block data to perform later L* calculation
!	from Lm and I with IGRF+OP Quiet field model.
!
! CATEGORY:
!
!
! CALLING SEQUENCE:
!	CALL InitLAndI2Lstar_OlsonPfitzerQuiet
!
! INPUTS:
!	None
!
! OUTPUTS:
!	None (in common blocks)
!
! COMMON BLOCKS:
!   COMMON/LAndI2LstarCom/Lmax,Imax,Lupper,Iupper,Lm4,A0,A1,A2,A3,A4,Lm5,A50,A51,A52,A53,A54,A55

!
! MODIFICATION HISTORY:
!	Written by: S. Bourdarie (introduced in version 4.4), May 2009
!-
!--------------------------------------------------------------------------------------------
      SUBROUTINE InitLAndI2Lstar_OlsonPfitzerQuiet
c
      IMPLICIT NONE
      INTEGER*4  I
      REAL*8     Lmax(12,2100),Imax(12,2100)
      REAL*8     Lupper(12,1001),Iupper(12,1001)
      REAL*8     Lm4(12,100),A0(12,100),A1(12,100),A2(12,100),A3(12,100)
      REAL*8     A4(12,100)
      REAL*8     Lm5(12,100),A50(12,100),A51(12,100),A52(12,100)
      REAL*8     A53(12,100),A54(12,100),A55(12,100)
c
      COMMON/LAndI2LstarCom/Lmax,Imax,Lupper,Iupper,Lm4,A0,A1,A2,A3,A4,
     &Lm5,A50,A51,A52,A53,A54,A55
c
c Definition of Loss cone as Lmax=f(Imax) for doy=001
      DATA (Lmax ( 1,I), I= 1, 2100) /
     & 1.0853d0, 1.0863d0, 1.0874d0, 1.0884d0, 1.0893d0, 1.0903d0,
     & 1.0913d0, 1.0923d0, 1.0933d0, 1.0943d0, 1.0953d0, 1.0963d0,
     & 1.0973d0, 1.0983d0, 1.0993d0, 1.1003d0, 1.1013d0, 1.1023d0,
     & 1.1033d0, 1.1043d0, 1.1053d0, 1.1064d0, 1.1074d0, 1.1084d0,
     & 1.1094d0, 1.1104d0, 1.1115d0, 1.1125d0, 1.1135d0, 1.1145d0,
     & 1.1155d0, 1.1166d0, 1.1176d0, 1.1186d0, 1.1196d0, 1.1207d0,
     & 1.1217d0, 1.1227d0, 1.1237d0, 1.1248d0, 1.1258d0, 1.1268d0,
     & 1.1278d0, 1.1289d0, 1.1299d0, 1.1309d0, 1.1319d0, 1.1329d0,
     & 1.1340d0, 1.1350d0, 1.1360d0, 1.1371d0, 1.1381d0, 1.1391d0,
     & 1.1401d0, 1.1412d0, 1.1422d0, 1.1432d0, 1.1443d0, 1.1453d0,
     & 1.1463d0, 1.1473d0, 1.1484d0, 1.1494d0, 1.1504d0, 1.1514d0,
     & 1.1525d0, 1.1535d0, 1.1545d0, 1.1555d0, 1.1566d0, 1.1576d0,
     & 1.1586d0, 1.1597d0, 1.1607d0, 1.1617d0, 1.1627d0, 1.1638d0,
     & 1.1648d0, 1.1658d0, 1.1669d0, 1.1679d0, 1.1689d0, 1.1699d0,
     & 1.1710d0, 1.1720d0, 1.1730d0, 1.1740d0, 1.1751d0, 1.1761d0,
     & 1.1771d0, 1.1782d0, 1.1792d0, 1.1802d0, 1.1812d0, 1.1822d0,
     & 1.1833d0, 1.1843d0, 1.1854d0, 1.1864d0, 1.1874d0, 1.1884d0,
     & 1.1894d0, 1.1905d0, 1.1915d0, 1.1925d0, 1.1936d0, 1.1946d0,
     & 1.1956d0, 1.1966d0, 1.1976d0, 1.1987d0, 1.1997d0, 1.2007d0,
     & 1.2018d0, 1.2028d0, 1.2038d0, 1.2048d0, 1.2058d0, 1.2069d0,
     & 1.2079d0, 1.2089d0, 1.2100d0, 1.2110d0, 1.2120d0, 1.2130d0,
     & 1.2141d0, 1.2151d0, 1.2161d0, 1.2171d0, 1.2182d0, 1.2192d0,
     & 1.2202d0, 1.2212d0, 1.2223d0, 1.2233d0, 1.2243d0, 1.2253d0,
     & 1.2264d0, 1.2274d0, 1.2284d0, 1.2294d0, 1.2304d0, 1.2315d0,
     & 1.2325d0, 1.2335d0, 1.2345d0, 1.2356d0, 1.2366d0, 1.2376d0,
     & 1.2386d0, 1.2397d0, 1.2407d0, 1.2417d0, 1.2427d0, 1.2438d0,
     & 1.2448d0, 1.2458d0, 1.2468d0, 1.2478d0, 1.2489d0, 1.2499d0,
     & 1.2509d0, 1.2519d0, 1.2530d0, 1.2540d0, 1.2550d0, 1.2560d0,
     & 1.2570d0, 1.2581d0, 1.2591d0, 1.2601d0, 1.2611d0, 1.2622d0,
     & 1.2632d0, 1.2642d0, 1.2652d0, 1.2662d0, 1.2673d0, 1.2683d0,
     & 1.2693d0, 1.2703d0, 1.2714d0, 1.2724d0, 1.2734d0, 1.2744d0,
     & 1.2754d0, 1.2764d0, 1.2775d0, 1.2785d0, 1.2795d0, 1.2805d0,
     & 1.2816d0, 1.2826d0, 1.2836d0, 1.2846d0, 1.2856d0, 1.2867d0,
     & 1.2877d0, 1.2887d0, 1.2897d0, 1.2908d0, 1.2918d0, 1.2928d0,
     & 1.2938d0, 1.2948d0, 1.2958d0, 1.2969d0, 1.2979d0, 1.2989d0,
     & 1.2999d0, 1.3009d0, 1.3020d0, 1.3030d0, 1.3040d0, 1.3050d0,
     & 1.3060d0, 1.3070d0, 1.3081d0, 1.3091d0, 1.3101d0, 1.3111d0,
     & 1.3121d0, 1.3132d0, 1.3142d0, 1.3152d0, 1.3162d0, 1.3172d0,
     & 1.3183d0, 1.3193d0, 1.3203d0, 1.3213d0, 1.3223d0, 1.3234d0,
     & 1.3244d0, 1.3254d0, 1.3264d0, 1.3274d0, 1.3284d0, 1.3295d0,
     & 1.3305d0, 1.3315d0, 1.3325d0, 1.3335d0, 1.3345d0, 1.3356d0,
     & 1.3366d0, 1.3376d0, 1.3386d0, 1.3396d0, 1.3406d0, 1.3417d0,
     & 1.3427d0, 1.3437d0, 1.3447d0, 1.3457d0, 1.3467d0, 1.3478d0,
     & 1.3488d0, 1.3498d0, 1.3508d0, 1.3518d0, 1.3529d0, 1.3539d0,
     & 1.3549d0, 1.3559d0, 1.3569d0, 1.3579d0, 1.3589d0, 1.3600d0,
     & 1.3610d0, 1.3620d0, 1.3630d0, 1.3640d0, 1.3651d0, 1.3661d0,
     & 1.3671d0, 1.3681d0, 1.3691d0, 1.3701d0, 1.3711d0, 1.3721d0,
     & 1.3732d0, 1.3742d0, 1.3752d0, 1.3762d0, 1.3772d0, 1.3783d0,
     & 1.3793d0, 1.3803d0, 1.3813d0, 1.3823d0, 1.3833d0, 1.3843d0,
     & 1.3853d0, 1.3864d0, 1.3874d0, 1.3884d0, 1.3894d0, 1.3904d0,
     & 1.3914d0, 1.3924d0, 1.3934d0, 1.3945d0, 1.3955d0, 1.3965d0,
     & 1.3975d0, 1.3985d0, 1.3995d0, 1.4006d0, 1.4016d0, 1.4026d0,
     & 1.4036d0, 1.4046d0, 1.4056d0, 1.4066d0, 1.4076d0, 1.4086d0,
     & 1.4097d0, 1.4107d0, 1.4117d0, 1.4127d0, 1.4137d0, 1.4148d0,
     & 1.4158d0, 1.4168d0, 1.4178d0, 1.4188d0, 1.4198d0, 1.4208d0,
     & 1.4218d0, 1.4228d0, 1.4238d0, 1.4249d0, 1.4259d0, 1.4269d0,
     & 1.4279d0, 1.4290d0, 1.4300d0, 1.4310d0, 1.4320d0, 1.4330d0,
     & 1.4340d0, 1.4350d0, 1.4360d0, 1.4370d0, 1.4380d0, 1.4390d0,
     & 1.4401d0, 1.4411d0, 1.4421d0, 1.4431d0, 1.4442d0, 1.4452d0,
     & 1.4462d0, 1.4472d0, 1.4482d0, 1.4491d0, 1.4501d0, 1.4512d0,
     & 1.4522d0, 1.4532d0, 1.4542d0, 1.4552d0, 1.4563d0, 1.4573d0,
     & 1.4583d0, 1.4593d0, 1.4604d0, 1.4614d0, 1.4623d0, 1.4633d0,
     & 1.4643d0, 1.4653d0, 1.4663d0, 1.4673d0, 1.4684d0, 1.4694d0,
     & 1.4704d0, 1.4714d0, 1.4725d0, 1.4735d0, 1.4745d0, 1.4755d0,
     & 1.4765d0, 1.4775d0, 1.4785d0, 1.4795d0, 1.4805d0, 1.4815d0,
     & 1.4825d0, 1.4835d0, 1.4845d0, 1.4855d0, 1.4866d0, 1.4876d0,
     & 1.4886d0, 1.4896d0, 1.4907d0, 1.4917d0, 1.4927d0, 1.4937d0,
     & 1.4947d0, 1.4957d0, 1.4966d0, 1.4976d0, 1.4986d0, 1.4996d0,
     & 1.5007d0, 1.5017d0, 1.5027d0, 1.5037d0, 1.5047d0, 1.5058d0,
     & 1.5068d0, 1.5078d0, 1.5089d0, 1.5098d0, 1.5108d0, 1.5118d0,
     & 1.5128d0, 1.5138d0, 1.5148d0, 1.5158d0, 1.5168d0, 1.5178d0,
     & 1.5188d0, 1.5199d0, 1.5209d0, 1.5219d0, 1.5229d0, 1.5240d0,
     & 1.5250d0, 1.5260d0, 1.5270d0, 1.5280d0, 1.5290d0, 1.5300d0,
     & 1.5310d0, 1.5319d0, 1.5329d0, 1.5339d0, 1.5349d0, 1.5360d0,
     & 1.5370d0, 1.5380d0, 1.5390d0, 1.5401d0, 1.5411d0, 1.5421d0,
     & 1.5431d0, 1.5442d0, 1.5452d0, 1.5461d0, 1.5471d0, 1.5481d0,
     & 1.5491d0, 1.5501d0, 1.5511d0, 1.5521d0, 1.5531d0, 1.5541d0,
     & 1.5551d0, 1.5561d0, 1.5572d0, 1.5582d0, 1.5592d0, 1.5603d0,
     & 1.5613d0, 1.5623d0, 1.5633d0, 1.5643d0, 1.5653d0, 1.5663d0,
     & 1.5672d0, 1.5682d0, 1.5692d0, 1.5702d0, 1.5712d0, 1.5722d0,
     & 1.5732d0, 1.5742d0, 1.5753d0, 1.5763d0, 1.5773d0, 1.5784d0,
     & 1.5794d0, 1.5804d0, 1.5814d0, 1.5824d0, 1.5834d0, 1.5844d0,
     & 1.5854d0, 1.5864d0, 1.5873d0, 1.5883d0, 1.5893d0, 1.5903d0,
     & 1.5913d0, 1.5924d0, 1.5934d0, 1.5944d0, 1.5954d0, 1.5965d0,
     & 1.5975d0, 1.5985d0, 1.5996d0, 1.6006d0, 1.6016d0, 1.6026d0,
     & 1.6035d0, 1.6045d0, 1.6055d0, 1.6065d0, 1.6075d0, 1.6084d0,
     & 1.6094d0, 1.6104d0, 1.6115d0, 1.6125d0, 1.6135d0, 1.6145d0,
     & 1.6156d0, 1.6166d0, 1.6176d0, 1.6186d0, 1.6197d0, 1.6207d0,
     & 1.6217d0, 1.6227d0, 1.6237d0, 1.6247d0, 1.6256d0, 1.6266d0,
     & 1.6276d0, 1.6286d0, 1.6296d0, 1.6306d0, 1.6316d0, 1.6326d0,
     & 1.6336d0, 1.6346d0, 1.6357d0, 1.6367d0, 1.6377d0, 1.6388d0,
     & 1.6398d0, 1.6408d0, 1.6418d0, 1.6428d0, 1.6438d0, 1.6448d0,
     & 1.6458d0, 1.6467d0, 1.6477d0, 1.6487d0, 1.6497d0, 1.6507d0,
     & 1.6517d0, 1.6527d0, 1.6537d0, 1.6547d0, 1.6558d0, 1.6568d0,
     & 1.6578d0, 1.6588d0, 1.6599d0, 1.6609d0, 1.6619d0, 1.6629d0,
     & 1.6639d0, 1.6649d0, 1.6659d0, 1.6669d0, 1.6678d0, 1.6688d0,
     & 1.6698d0, 1.6708d0, 1.6718d0, 1.6728d0, 1.6738d0, 1.6748d0,
     & 1.6758d0, 1.6768d0, 1.6779d0, 1.6789d0, 1.6799d0, 1.6810d0,
     & 1.6820d0, 1.6830d0, 1.6840d0, 1.6850d0, 1.6860d0, 1.6870d0,
     & 1.6880d0, 1.6890d0, 1.6900d0, 1.6909d0, 1.6919d0, 1.6929d0,
     & 1.6939d0, 1.6949d0, 1.6959d0, 1.6969d0, 1.6979d0, 1.6989d0,
     & 1.7000d0, 1.7010d0, 1.7020d0, 1.7031d0, 1.7041d0, 1.7051d0,
     & 1.7061d0, 1.7071d0, 1.7081d0, 1.7091d0, 1.7101d0, 1.7111d0,
     & 1.7121d0, 1.7131d0, 1.7140d0, 1.7150d0, 1.7160d0, 1.7170d0,
     & 1.7179d0, 1.7189d0, 1.7200d0, 1.7210d0, 1.7220d0, 1.7230d0,
     & 1.7241d0, 1.7251d0, 1.7261d0, 1.7272d0, 1.7282d0, 1.7292d0,
     & 1.7302d0, 1.7312d0, 1.7322d0, 1.7332d0, 1.7342d0, 1.7352d0,
     & 1.7362d0, 1.7372d0, 1.7381d0, 1.7391d0, 1.7401d0, 1.7411d0,
     & 1.7420d0, 1.7430d0, 1.7440d0, 1.7451d0, 1.7461d0, 1.7471d0,
     & 1.7481d0, 1.7492d0, 1.7502d0, 1.7512d0, 1.7523d0, 1.7533d0,
     & 1.7543d0, 1.7553d0, 1.7563d0, 1.7573d0, 1.7583d0, 1.7593d0,
     & 1.7603d0, 1.7612d0, 1.7622d0, 1.7632d0, 1.7642d0, 1.7652d0,
     & 1.7661d0, 1.7671d0, 1.7681d0, 1.7691d0, 1.7701d0, 1.7711d0,
     & 1.7722d0, 1.7732d0, 1.7742d0, 1.7753d0, 1.7763d0, 1.7773d0,
     & 1.7784d0, 1.7794d0, 1.7804d0, 1.7814d0, 1.7824d0, 1.7834d0,
     & 1.7844d0, 1.7853d0, 1.7863d0, 1.7873d0, 1.7883d0, 1.7893d0,
     & 1.7902d0, 1.7912d0, 1.7922d0, 1.7932d0, 1.7942d0, 1.7952d0,
     & 1.7962d0, 1.7972d0, 1.7983d0, 1.7993d0, 1.8003d0, 1.8014d0,
     & 1.8024d0, 1.8034d0, 1.8045d0, 1.8055d0, 1.8065d0, 1.8075d0,
     & 1.8085d0, 1.8095d0, 1.8104d0, 1.8114d0, 1.8124d0, 1.8134d0,
     & 1.8144d0, 1.8153d0, 1.8163d0, 1.8173d0, 1.8183d0, 1.8192d0,
     & 1.8202d0, 1.8212d0, 1.8223d0, 1.8233d0, 1.8243d0, 1.8253d0,
     & 1.8264d0, 1.8274d0, 1.8285d0, 1.8295d0, 1.8305d0, 1.8315d0,
     & 1.8326d0, 1.8336d0, 1.8345d0, 1.8355d0, 1.8365d0, 1.8375d0,
     & 1.8385d0, 1.8395d0, 1.8404d0, 1.8414d0, 1.8424d0, 1.8434d0,
     & 1.8443d0, 1.8453d0, 1.8463d0, 1.8473d0, 1.8483d0, 1.8493d0,
     & 1.8503d0, 1.8514d0, 1.8524d0, 1.8534d0, 1.8545d0, 1.8555d0,
     & 1.8566d0, 1.8576d0, 1.8586d0, 1.8596d0, 1.8606d0, 1.8616d0,
     & 1.8626d0, 1.8636d0, 1.8646d0, 1.8656d0, 1.8665d0, 1.8675d0,
     & 1.8685d0, 1.8695d0, 1.8705d0, 1.8714d0, 1.8724d0, 1.8734d0,
     & 1.8744d0, 1.8753d0, 1.8763d0, 1.8774d0, 1.8784d0, 1.8794d0,
     & 1.8804d0, 1.8815d0, 1.8825d0, 1.8835d0, 1.8846d0, 1.8856d0,
     & 1.8867d0, 1.8877d0, 1.8887d0, 1.8897d0, 1.8907d0, 1.8917d0,
     & 1.8927d0, 1.8936d0, 1.8946d0, 1.8956d0, 1.8966d0, 1.8976d0,
     & 1.8985d0, 1.8995d0, 1.9005d0, 1.9015d0, 1.9024d0, 1.9034d0,
     & 1.9044d0, 1.9054d0, 1.9064d0, 1.9075d0, 1.9085d0, 1.9095d0,
     & 1.9106d0, 1.9116d0, 1.9126d0, 1.9137d0, 1.9147d0, 1.9157d0,
     & 1.9167d0, 1.9177d0, 1.9187d0, 1.9197d0, 1.9207d0, 1.9217d0,
     & 1.9227d0, 1.9237d0, 1.9247d0, 1.9257d0, 1.9266d0, 1.9276d0,
     & 1.9286d0, 1.9296d0, 1.9305d0, 1.9315d0, 1.9325d0, 1.9334d0,
     & 1.9344d0, 1.9354d0, 1.9364d0, 1.9374d0, 1.9385d0, 1.9395d0,
     & 1.9405d0, 1.9416d0, 1.9426d0, 1.9437d0, 1.9447d0, 1.9457d0,
     & 1.9468d0, 1.9478d0, 1.9488d0, 1.9498d0, 1.9508d0, 1.9518d0,
     & 1.9528d0, 1.9537d0, 1.9547d0, 1.9557d0, 1.9567d0, 1.9577d0,
     & 1.9587d0, 1.9596d0, 1.9606d0, 1.9616d0, 1.9626d0, 1.9635d0,
     & 1.9645d0, 1.9655d0, 1.9665d0, 1.9675d0, 1.9685d0, 1.9695d0,
     & 1.9706d0, 1.9716d0, 1.9726d0, 1.9737d0, 1.9747d0, 1.9758d0,
     & 1.9768d0, 1.9778d0, 1.9788d0, 1.9798d0, 1.9808d0, 1.9818d0,
     & 1.9828d0, 1.9838d0, 1.9848d0, 1.9858d0, 1.9868d0, 1.9878d0,
     & 1.9887d0, 1.9897d0, 1.9907d0, 1.9917d0, 1.9926d0, 1.9936d0,
     & 1.9946d0, 1.9956d0, 1.9965d0, 1.9976d0, 1.9986d0, 1.9996d0,
     & 2.0006d0, 2.0017d0, 2.0027d0, 2.0037d0, 2.0048d0, 2.0058d0,
     & 2.0068d0, 2.0079d0, 2.0089d0, 2.0099d0, 2.0109d0, 2.0119d0,
     & 2.0129d0, 2.0139d0, 2.0149d0, 2.0158d0, 2.0168d0, 2.0178d0,
     & 2.0188d0, 2.0198d0, 2.0208d0, 2.0218d0, 2.0227d0, 2.0237d0,
     & 2.0247d0, 2.0257d0, 2.0266d0, 2.0276d0, 2.0286d0, 2.0296d0,
     & 2.0306d0, 2.0316d0, 2.0326d0, 2.0336d0, 2.0347d0, 2.0357d0,
     & 2.0367d0, 2.0378d0, 2.0388d0, 2.0399d0, 2.0409d0, 2.0419d0,
     & 2.0429d0, 2.0439d0, 2.0449d0, 2.0459d0, 2.0469d0, 2.0479d0,
     & 2.0489d0, 2.0499d0, 2.0509d0, 2.0518d0, 2.0528d0, 2.0538d0,
     & 2.0548d0, 2.0558d0, 2.0568d0, 2.0577d0, 2.0587d0, 2.0597d0,
     & 2.0607d0, 2.0616d0, 2.0626d0, 2.0636d0, 2.0646d0, 2.0656d0,
     & 2.0666d0, 2.0676d0, 2.0686d0, 2.0697d0, 2.0707d0, 2.0717d0,
     & 2.0728d0, 2.0738d0, 2.0748d0, 2.0759d0, 2.0769d0, 2.0779d0,
     & 2.0789d0, 2.0799d0, 2.0809d0, 2.0819d0, 2.0829d0, 2.0839d0,
     & 2.0849d0, 2.0858d0, 2.0868d0, 2.0878d0, 2.0888d0, 2.0898d0,
     & 2.0907d0, 2.0917d0, 2.0927d0, 2.0937d0, 2.0946d0, 2.0956d0,
     & 2.0966d0, 2.0976d0, 2.0985d0, 2.0995d0, 2.1005d0, 2.1015d0,
     & 2.1025d0, 2.1035d0, 2.1045d0, 2.1056d0, 2.1066d0, 2.1076d0,
     & 2.1087d0, 2.1097d0, 2.1108d0, 2.1118d0, 2.1129d0, 2.1139d0,
     & 2.1149d0, 2.1159d0, 2.1169d0, 2.1179d0, 2.1189d0, 2.1199d0,
     & 2.1208d0, 2.1218d0, 2.1228d0, 2.1238d0, 2.1248d0, 2.1257d0,
     & 2.1267d0, 2.1277d0, 2.1286d0, 2.1296d0, 2.1306d0, 2.1316d0,
     & 2.1325d0, 2.1335d0, 2.1345d0, 2.1355d0, 2.1364d0, 2.1375d0,
     & 2.1385d0, 2.1395d0, 2.1406d0, 2.1416d0, 2.1426d0, 2.1437d0,
     & 2.1447d0, 2.1458d0, 2.1468d0, 2.1478d0, 2.1488d0, 2.1498d0,
     & 2.1508d0, 2.1518d0, 2.1528d0, 2.1538d0, 2.1548d0, 2.1558d0,
     & 2.1568d0, 2.1578d0, 2.1587d0, 2.1597d0, 2.1607d0, 2.1616d0,
     & 2.1626d0, 2.1636d0, 2.1646d0, 2.1655d0, 2.1665d0, 2.1675d0,
     & 2.1685d0, 2.1695d0, 2.1705d0, 2.1716d0, 2.1726d0, 2.1736d0,
     & 2.1746d0, 2.1756d0, 2.1766d0, 2.1776d0, 2.1787d0, 2.1797d0,
     & 2.1808d0, 2.1818d0, 2.1828d0, 2.1838d0, 2.1849d0, 2.1860d0,
     & 2.1870d0, 2.1881d0, 2.1891d0, 2.1902d0, 2.1913d0, 2.1923d0,
     & 2.1932d0, 2.1942d0, 2.1952d0, 2.1961d0, 2.1971d0, 2.1981d0,
     & 2.1990d0, 2.2000d0, 2.2009d0, 2.2018d0, 2.2028d0, 2.2038d0,
     & 2.2048d0, 2.2058d0, 2.2068d0, 2.2078d0, 2.2088d0, 2.2097d0,
     & 2.2107d0, 2.2116d0, 2.2126d0, 2.2136d0, 2.2147d0, 2.2157d0,
     & 2.2168d0, 2.2178d0, 2.2189d0, 2.2199d0, 2.2211d0, 2.2222d0,
     & 2.2234d0, 2.2244d0, 2.2254d0, 2.2264d0, 2.2274d0, 2.2283d0,
     & 2.2293d0, 2.2302d0, 2.2312d0, 2.2321d0, 2.2330d0, 2.2339d0,
     & 2.2348d0, 2.2358d0, 2.2367d0, 2.2377d0, 2.2386d0, 2.2396d0,
     & 2.2405d0, 2.2415d0, 2.2424d0, 2.2434d0, 2.2443d0, 2.2453d0,
     & 2.2463d0, 2.2472d0, 2.2482d0, 2.2492d0, 2.2503d0, 2.2513d0,
     & 2.2524d0, 2.2534d0, 2.2545d0, 2.2556d0, 2.2567d0, 2.2577d0,
     & 2.2588d0, 2.2598d0, 2.2608d0, 2.2618d0, 2.2628d0, 2.2637d0,
     & 2.2647d0, 2.2657d0, 2.2667d0, 2.2676d0, 2.2686d0, 2.2696d0,
     & 2.2706d0, 2.2724d0, 2.2749d0, 2.2784d0, 2.2826d0, 2.2876d0,
     & 2.2935d0, 2.3002d0, 2.3077d0, 2.3161d0, 2.3252d0, 2.3352d0,
     & 2.3452d0, 2.3552d0, 2.3651d0, 2.3750d0, 2.3850d0, 2.3950d0,
     & 2.4049d0, 2.4148d0, 2.4247d0, 2.4346d0, 2.4445d0, 2.4544d0,
     & 2.4644d0, 2.4743d0, 2.4842d0, 2.4941d0, 2.5040d0, 2.5140d0,
     & 2.5239d0, 2.5338d0, 2.5437d0, 2.5536d0, 2.5636d0, 2.5735d0,
     & 2.5834d0, 2.5933d0, 2.6032d0, 2.6131d0, 2.6230d0, 2.6329d0,
     & 2.6429d0, 2.6528d0, 2.6627d0, 2.6726d0, 2.6826d0, 2.6924d0,
     & 2.7024d0, 2.7123d0, 2.7222d0, 2.7321d0, 2.7419d0, 2.7519d0,
     & 2.7618d0, 2.7717d0, 2.7816d0, 2.7914d0, 2.8013d0, 2.8112d0,
     & 2.8211d0, 2.8310d0, 2.8410d0, 2.8509d0, 2.8608d0, 2.8707d0,
     & 2.8806d0, 2.8905d0, 2.9004d0, 2.9103d0, 2.9202d0, 2.9301d0,
     & 2.9400d0, 2.9499d0, 2.9597d0, 2.9697d0, 2.9795d0, 2.9894d0,
     & 2.9993d0, 3.0092d0, 3.0191d0, 3.0291d0, 3.0389d0, 3.0488d0,
     & 3.0587d0, 3.0686d0, 3.0785d0, 3.0884d0, 3.0983d0, 3.1082d0,
     & 3.1181d0, 3.1280d0, 3.1379d0, 3.1478d0, 3.1577d0, 3.1676d0,
     & 3.1775d0, 3.1874d0, 3.1973d0, 3.2072d0, 3.2171d0, 3.2270d0,
     & 3.2368d0, 3.2467d0, 3.2566d0, 3.2665d0, 3.2764d0, 3.2863d0,
     & 3.2961d0, 3.3059d0, 3.3158d0, 3.3257d0, 3.3356d0, 3.3455d0,
     & 3.3553d0, 3.3651d0, 3.3749d0, 3.3848d0, 3.3948d0, 3.4048d0,
     & 3.4148d0, 3.4246d0, 3.4344d0, 3.4442d0, 3.4541d0, 3.4639d0,
     & 3.4739d0, 3.4838d0, 3.4937d0, 3.5036d0, 3.5134d0, 3.5233d0,
     & 3.5332d0, 3.5432d0, 3.5531d0, 3.5630d0, 3.5730d0, 3.5829d0,
     & 3.5927d0, 3.6025d0, 3.6124d0, 3.6223d0, 3.6322d0, 3.6420d0,
     & 3.6519d0, 3.6618d0, 3.6716d0, 3.6815d0, 3.6915d0, 3.7014d0,
     & 3.7114d0, 3.7213d0, 3.7312d0, 3.7411d0, 3.7510d0, 3.7609d0,
     & 3.7708d0, 3.7807d0, 3.7906d0, 3.8005d0, 3.8104d0, 3.8203d0,
     & 3.8301d0, 3.8399d0, 3.8497d0, 3.8596d0, 3.8694d0, 3.8793d0,
     & 3.8892d0, 3.8991d0, 3.9090d0, 3.9188d0, 3.9288d0, 3.9386d0,
     & 3.9486d0, 3.9585d0, 3.9685d0, 3.9785d0, 3.9883d0, 3.9981d0,
     & 4.0080d0, 4.0178d0, 4.0276d0, 4.0374d0, 4.0474d0, 4.0574d0,
     & 4.0673d0, 4.0771d0, 4.0870d0, 4.0970d0, 4.1070d0, 4.1169d0,
     & 4.1269d0, 4.1368d0, 4.1467d0, 4.1565d0, 4.1663d0, 4.1763d0,
     & 4.1862d0, 4.1961d0, 4.2061d0, 4.2159d0, 4.2258d0, 4.2357d0,
     & 4.2456d0, 4.2557d0, 4.2657d0, 4.2757d0, 4.2856d0, 4.2956d0,
     & 4.3055d0, 4.3154d0, 4.3254d0, 4.3353d0, 4.3452d0, 4.3552d0,
     & 4.3651d0, 4.3750d0, 4.3850d0, 4.3949d0, 4.4048d0, 4.4147d0,
     & 4.4246d0, 4.4346d0, 4.4446d0, 4.4545d0, 4.4643d0, 4.4743d0,
     & 4.4842d0, 4.4942d0, 4.5041d0, 4.5141d0, 4.5240d0, 4.5339d0,
     & 4.5439d0, 4.5539d0, 4.5638d0, 4.5738d0, 4.5838d0, 4.5938d0,
     & 4.6038d0, 4.6138d0, 4.6238d0, 4.6338d0, 4.6438d0, 4.6537d0,
     & 4.6637d0, 4.6737d0, 4.6838d0, 4.6938d0, 4.7038d0, 4.7138d0,
     & 4.7238d0, 4.7338d0, 4.7439d0, 4.7540d0, 4.7640d0, 4.7741d0,
     & 4.7841d0, 4.7941d0, 4.8041d0, 4.8140d0, 4.8239d0, 4.8339d0,
     & 4.8439d0, 4.8539d0, 4.8640d0, 4.8741d0, 4.8842d0, 4.8943d0,
     & 4.9044d0, 4.9143d0, 4.9243d0, 4.9344d0, 4.9443d0, 4.9544d0,
     & 4.9645d0, 4.9745d0, 4.9847d0, 4.9947d0, 5.0048d0, 5.0149d0,
     & 5.0251d0, 5.0353d0, 5.0453d0, 5.0556d0, 5.0657d0, 5.0756d0,
     & 5.0856d0, 5.0957d0, 5.1058d0, 5.1159d0, 5.1259d0, 5.1360d0,
     & 5.1461d0, 5.1563d0, 5.1664d0, 5.1763d0, 5.1866d0, 5.1969d0,
     & 5.2070d0, 5.2172d0, 5.2274d0, 5.2377d0, 5.2479d0, 5.2581d0,
     & 5.2682d0, 5.2784d0, 5.2887d0, 5.2989d0, 5.3091d0, 5.3191d0,
     & 5.3291d0, 5.3393d0, 5.3493d0, 5.3594d0, 5.3697d0, 5.3800d0,
     & 5.3903d0, 5.4005d0, 5.4106d0, 5.4207d0, 5.4310d0, 5.4414d0,
     & 5.4515d0, 5.4618d0, 5.4720d0, 5.4822d0, 5.4924d0, 5.5026d0,
     & 5.5129d0, 5.5232d0, 5.5336d0, 5.5439d0, 5.5542d0, 5.5645d0,
     & 5.5748d0, 5.5850d0, 5.5952d0, 5.6054d0, 5.6156d0, 5.6259d0,
     & 5.6362d0, 5.6465d0, 5.6568d0, 5.6671d0, 5.6775d0, 5.6879d0,
     & 5.6983d0, 5.7087d0, 5.7190d0, 5.7293d0, 5.7395d0, 5.7497d0,
     & 5.7599d0, 5.7702d0, 5.7804d0, 5.7908d0, 5.8012d0, 5.8116d0,
     & 5.8221d0, 5.8325d0, 5.8430d0, 5.8534d0, 5.8640d0, 5.8744d0,
     & 5.8848d0, 5.8954d0, 5.9056d0, 5.9161d0, 5.9264d0, 5.9369d0,
     & 5.9474d0, 5.9578d0, 5.9684d0, 5.9788d0, 5.9894d0, 5.9999d0,
     & 6.0103d0, 6.0209d0, 6.0313d0, 6.0417d0, 6.0521d0, 6.0625d0,
     & 6.0729d0, 6.0833d0, 6.0936d0, 6.1041d0, 6.1145d0, 6.1250d0,
     & 6.1355d0, 6.1460d0, 6.1566d0, 6.1672d0, 6.1778d0, 6.1885d0,
     & 6.1992d0, 6.2098d0, 6.2203d0, 6.2309d0, 6.2413d0, 6.2518d0,
     & 6.2624d0, 6.2729d0, 6.2833d0, 6.2939d0, 6.3045d0, 6.3151d0,
     & 6.3258d0, 6.3366d0, 6.3473d0, 6.3581d0, 6.3688d0, 6.3796d0,
     & 6.3904d0, 6.4012d0, 6.4118d0, 6.4223d0, 6.4328d0, 6.4433d0,
     & 6.4537d0, 6.4643d0, 6.4748d0, 6.4855d0, 6.4961d0, 6.5067d0,
     & 6.5172d0, 6.5279d0, 6.5388d0, 6.5498d0, 6.5607d0, 6.5717d0,
     & 6.5825d0, 6.5934d0, 6.6041d0, 6.6149d0, 6.6257d0, 6.6366d0,
     & 6.6474d0, 6.6580d0, 6.6688d0, 6.6794d0, 6.6900d0, 6.7009d0,
     & 6.7117d0, 6.7227d0, 6.7337d0, 6.7447d0, 6.7557d0, 6.7668d0,
     & 6.7778d0, 6.7887d0, 6.7998d0, 6.8107d0, 6.8216d0, 6.8325d0,
     & 6.8434d0, 6.8542d0, 6.8650d0, 6.8757d0, 6.8864d0, 6.8971d0,
     & 6.9081d0, 6.9189d0, 6.9298d0, 6.9408d0, 6.9519d0, 6.9630d0,
     & 6.9741d0, 6.9853d0, 6.9965d0, 7.0078d0, 7.0190d0, 7.0301d0,
     & 7.0413d0, 7.0525d0, 7.0636d0, 7.0745d0, 7.0855d0, 7.0964d0,
     & 7.1074d0, 7.1183d0, 7.1292d0, 7.1402d0, 7.1511d0, 7.1623d0,
     & 7.1735d0, 7.1848d0, 7.1959d0, 7.2072d0, 7.2185d0, 7.2298d0,
     & 7.2410d0, 7.2523d0, 7.2635d0, 7.2749d0, 7.2859d0, 7.2971d0,
     & 7.3084d0, 7.3198d0, 7.3310d0, 7.3422d0, 7.3535d0, 7.3646d0,
     & 7.3760d0, 7.3874d0, 7.3987d0, 7.4100d0, 7.4212d0, 7.4323d0,
     & 7.4436d0, 7.4547d0, 7.4659d0, 7.4771d0, 7.4884d0, 7.4999d0,
     & 7.5114d0, 7.5229d0, 7.5346d0, 7.5462d0, 7.5579d0, 7.5695d0,
     & 7.5812d0, 7.5929d0, 7.6046d0, 7.6162d0, 7.6275d0, 7.6389d0,
     & 7.6501d0, 7.6615d0, 7.6729d0, 7.6844d0, 7.6958d0, 7.7071d0,
     & 7.7186d0, 7.7300d0, 7.7416d0, 7.7532d0, 7.7647d0, 7.7765d0,
     & 7.7883d0, 7.7998d0, 7.8115d0, 7.8233d0, 7.8352d0, 7.8469d0,
     & 7.8587d0, 7.8706d0, 7.8824d0, 7.8943d0, 7.9061d0, 7.9178d0,
     & 7.9298d0, 7.9415d0, 7.9533d0, 7.9652d0, 7.9771d0, 7.9889d0,
     & 8.0007d0, 8.0127d0, 8.0245d0, 8.0365d0, 8.0484d0, 8.0601d0,
     & 8.0719d0, 8.0838d0, 8.0958d0, 8.1078d0, 8.1199d0, 8.1317d0,
     & 8.1437d0, 8.1558d0, 8.1679d0, 8.1799d0, 8.1922d0, 8.2041d0,
     & 8.2162d0, 8.2282d0, 8.2401d0, 8.2521d0, 8.2642d0, 8.2762d0,
     & 8.2881d0, 8.3000d0, 8.3120d0, 8.3238d0, 8.3361d0, 8.3481d0,
     & 8.3601d0, 8.3722d0, 8.3844d0, 8.3966d0, 8.4088d0, 8.4214d0,
     & 8.4339d0, 8.4464d0, 8.4587d0, 8.4711d0, 8.4837d0, 8.4963d0,
     & 8.5088d0, 8.5213d0, 8.5339d0, 8.5464d0, 8.5587d0, 8.5710d0,
     & 8.5834d0, 8.5960d0, 8.6086d0, 8.6210d0, 8.6334d0, 8.6460d0,
     & 8.6584d0, 8.6708d0, 8.6833d0, 8.6958d0, 8.7083d0, 8.7208d0,
     & 8.7334d0, 8.7462d0, 8.7588d0, 8.7717d0, 8.7843d0, 8.7974d0,
     & 8.8101d0, 8.8229d0, 8.8361d0, 8.8488d0, 8.8620d0, 8.8750d0,
     & 8.8880d0, 8.9011d0, 8.9138d0, 8.9268d0, 8.9398d0, 8.9530d0,
     & 8.9660d0, 8.9790d0, 8.9923d0, 9.0051d0, 9.0183d0, 9.0314d0,
     & 9.0444d0, 9.0574d0, 9.0708d0, 9.0839d0, 9.0972d0, 9.1107d0,
     & 9.1240d0, 9.1371d0, 9.1507d0, 9.1637d0, 9.1769d0, 9.1903d0,
     & 9.2040d0, 9.2172d0, 9.2306d0, 9.2440d0, 9.2571d0, 9.2703d0,
     & 9.2839d0, 9.2971d0, 9.3106d0, 9.3239d0, 9.3376d0, 9.3509d0,
     & 9.3647d0, 9.3783d0, 9.3918d0, 9.4056d0, 9.4192d0, 9.4326d0,
     & 9.4467d0, 9.4608d0, 9.4750d0, 9.4885d0, 9.5023d0, 9.5158d0,
     & 9.5294d0, 9.5435d0, 9.5576d0, 9.5720d0, 9.5863d0, 9.6003d0,
     & 9.6140d0, 9.6277d0, 9.6419d0, 9.6559d0, 9.6700d0, 9.6841d0,
     & 9.6979d0, 9.7122d0, 9.7265d0, 9.7403d0, 9.7545d0, 9.7687d0,
     & 9.7833d0, 9.7978d0, 9.8124d0, 9.8270d0, 9.8418d0, 9.8567d0,
     & 9.8709d0, 9.8852d0, 9.9002d0, 9.9151d0, 9.9297d0, 9.9427d0,
     & 9.9544d0, 9.9649d0, 9.9740d0, 9.9815d0, 9.9878d0, 9.9930d0,
     & 9.9969d0, 9.9991d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0, 9.9999d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0
     &/
      DATA (Imax ( 1,I), I= 1, 1000) /
     & 0.00002327d0, 0.00002327d0, 0.00002327d0, 0.00006557d0,
     & 0.00014223d0, 0.00028208d0, 0.00050784d0, 0.00076776d0,
     & 0.00115046d0, 0.00165151d0, 0.00225875d0, 0.00295101d0,
     & 0.00376458d0, 0.00469411d0, 0.00570463d0, 0.00683643d0,
     & 0.00802264d0, 0.00923564d0, 0.01056469d0, 0.01195784d0,
     & 0.01336897d0, 0.01478559d0, 0.01628143d0, 0.01784350d0,
     & 0.01940690d0, 0.02101022d0, 0.02266621d0, 0.02436113d0,
     & 0.02609020d0, 0.02783491d0, 0.02959597d0, 0.03139255d0,
     & 0.03323871d0, 0.03504154d0, 0.03689478d0, 0.03882283d0,
     & 0.04075288d0, 0.04266000d0, 0.04459121d0, 0.04656277d0,
     & 0.04855755d0, 0.05053336d0, 0.05250539d0, 0.05451778d0,
     & 0.05658142d0, 0.05863183d0, 0.06067961d0, 0.06272978d0,
     & 0.06481099d0, 0.06690541d0, 0.06901456d0, 0.07112362d0,
     & 0.07323809d0, 0.07539780d0, 0.07754946d0, 0.07970621d0,
     & 0.08186072d0, 0.08402508d0, 0.08625638d0, 0.08846463d0,
     & 0.09066400d0, 0.09287134d0, 0.09508556d0, 0.09730631d0,
     & 0.09954812d0, 0.10180857d0, 0.10406072d0, 0.10631832d0,
     & 0.10858112d0, 0.11083503d0, 0.11312070d0, 0.11542573d0,
     & 0.11770619d0, 0.12001929d0, 0.12233456d0, 0.12462470d0,
     & 0.12694706d0, 0.12928982d0, 0.13163589d0, 0.13398369d0,
     & 0.13631143d0, 0.13860986d0, 0.14097770d0, 0.14336680d0,
     & 0.14572793d0, 0.14808911d0, 0.15045451d0, 0.15280457d0,
     & 0.15516664d0, 0.15756659d0, 0.15997002d0, 0.16237360d0,
     & 0.16478550d0, 0.16714337d0, 0.16951406d0, 0.17192541d0,
     & 0.17438377d0, 0.17684406d0, 0.17928717d0, 0.18169855d0,
     & 0.18407364d0, 0.18646453d0, 0.18891516d0, 0.19139570d0,
     & 0.19387820d0, 0.19635908d0, 0.19879687d0, 0.20120367d0,
     & 0.20360874d0, 0.20601541d0, 0.20850180d0, 0.21102780d0,
     & 0.21355240d0, 0.21600956d0, 0.21845305d0, 0.22087623d0,
     & 0.22330104d0, 0.22578986d0, 0.22830948d0, 0.23084848d0,
     & 0.23340219d0, 0.23589037d0, 0.23833552d0, 0.24076219d0,
     & 0.24321519d0, 0.24574304d0, 0.24829470d0, 0.25086311d0,
     & 0.25340191d0, 0.25590661d0, 0.25838858d0, 0.26085201d0,
     & 0.26333714d0, 0.26588476d0, 0.26847959d0, 0.27107170d0,
     & 0.27360696d0, 0.27613327d0, 0.27863851d0, 0.28112581d0,
     & 0.28361574d0, 0.28612977d0, 0.28873301d0, 0.29133528d0,
     & 0.29389209d0, 0.29643741d0, 0.29898041d0, 0.30150327d0,
     & 0.30402696d0, 0.30653211d0, 0.30908406d0, 0.31170923d0,
     & 0.31432962d0, 0.31687698d0, 0.31942028d0, 0.32198304d0,
     & 0.32450461d0, 0.32702738d0, 0.32954487d0, 0.33211625d0,
     & 0.33475858d0, 0.33737355d0, 0.33995238d0, 0.34250742d0,
     & 0.34508398d0, 0.34766200d0, 0.35020089d0, 0.35278511d0,
     & 0.35542363d0, 0.35809740d0, 0.36071491d0, 0.36329836d0,
     & 0.36587891d0, 0.36845988d0, 0.37106356d0, 0.37362620d0,
     & 0.37619117d0, 0.37882751d0, 0.38146144d0, 0.38406503d0,
     & 0.38665858d0, 0.38927242d0, 0.39188620d0, 0.39447871d0,
     & 0.39705110d0, 0.39962485d0, 0.40221825d0, 0.40485153d0,
     & 0.40747422d0, 0.41007683d0, 0.41267651d0, 0.41527677d0,
     & 0.41787851d0, 0.42048186d0, 0.42308712d0, 0.42569485d0,
     & 0.42830589d0, 0.43098846d0, 0.43366802d0, 0.43630829d0,
     & 0.43892246d0, 0.44153613d0, 0.44417334d0, 0.44681174d0,
     & 0.44942921d0, 0.45207131d0, 0.45469293d0, 0.45731696d0,
     & 0.45999286d0, 0.46263304d0, 0.46524754d0, 0.46788582d0,
     & 0.47052547d0, 0.47314379d0, 0.47578755d0, 0.47843307d0,
     & 0.48108080d0, 0.48372984d0, 0.48638290d0, 0.48902592d0,
     & 0.49169451d0, 0.49434030d0, 0.49701250d0, 0.49966368d0,
     & 0.50231797d0, 0.50492823d0, 0.50756431d0, 0.51020294d0,
     & 0.51284438d0, 0.51552176d0, 0.51819038d0, 0.52083600d0,
     & 0.52350760d0, 0.52618146d0, 0.52888077d0, 0.53155744d0,
     & 0.53423572d0, 0.53694010d0, 0.53962278d0, 0.54228359d0,
     & 0.54491156d0, 0.54751825d0, 0.55013144d0, 0.55287284d0,
     & 0.55554157d0, 0.55818832d0, 0.56086183d0, 0.56353742d0,
     & 0.56619149d0, 0.56884760d0, 0.57152939d0, 0.57421327d0,
     & 0.57687747d0, 0.57955378d0, 0.58213526d0, 0.58484113d0,
     & 0.58755076d0, 0.59023941d0, 0.59295607d0, 0.59560233d0,
     & 0.59830093d0, 0.60102630d0, 0.60372990d0, 0.60636657d0,
     & 0.60905004d0, 0.61174846d0, 0.61438394d0, 0.61702430d0,
     & 0.61971909d0, 0.62241709d0, 0.62516642d0, 0.62784326d0,
     & 0.63054746d0, 0.63325369d0, 0.63596171d0, 0.63862205d0,
     & 0.64128524d0, 0.64397621d0, 0.64667624d0, 0.64940912d0,
     & 0.65214556d0, 0.65488452d0, 0.65762556d0, 0.66034448d0,
     & 0.66306567d0, 0.66578889d0, 0.66846430d0, 0.67113692d0,
     & 0.67376912d0, 0.67649090d0, 0.67914850d0, 0.68178844d0,
     & 0.68443429d0, 0.68710989d0, 0.68976384d0, 0.69254893d0,
     & 0.69528520d0, 0.69804871d0, 0.70080435d0, 0.70356286d0,
     & 0.70621681d0, 0.70882255d0, 0.71155280d0, 0.71429861d0,
     & 0.71705317d0, 0.71981412d0, 0.72245204d0, 0.72514606d0,
     & 0.72784424d0, 0.73066002d0, 0.73340029d0, 0.73616832d0,
     & 0.73896360d0, 0.74162322d0, 0.74426049d0, 0.74691701d0,
     & 0.74963474d0, 0.75236326d0, 0.75509846d0, 0.75783861d0,
     & 0.76061177d0, 0.76341254d0, 0.76619029d0, 0.76897037d0,
     & 0.77177876d0, 0.77458894d0, 0.77736819d0, 0.78002661d0,
     & 0.78266871d0, 0.78538007d0, 0.78808272d0, 0.79072148d0,
     & 0.79341942d0, 0.79612225d0, 0.79882914d0, 0.80151355d0,
     & 0.80420101d0, 0.80702251d0, 0.80989772d0, 0.81269634d0,
     & 0.81544244d0, 0.81819028d0, 0.82083881d0, 0.82353169d0,
     & 0.82624686d0, 0.82898974d0, 0.83174121d0, 0.83449906d0,
     & 0.83713102d0, 0.83976805d0, 0.84248793d0, 0.84529203d0,
     & 0.84812617d0, 0.85096347d0, 0.85374969d0, 0.85650903d0,
     & 0.85923737d0, 0.86190230d0, 0.86463058d0, 0.86737460d0,
     & 0.87012810d0, 0.87288827d0, 0.87554705d0, 0.87821114d0,
     & 0.88090605d0, 0.88360411d0, 0.88630491d0, 0.88908792d0,
     & 0.89192593d0, 0.89464086d0, 0.89733577d0, 0.90001762d0,
     & 0.90268993d0, 0.90539491d0, 0.90809143d0, 0.91077185d0,
     & 0.91343200d0, 0.91609848d0, 0.91871774d0, 0.92131352d0,
     & 0.92396665d0, 0.92662221d0, 0.92925352d0, 0.93188787d0,
     & 0.93456537d0, 0.93719327d0, 0.93978053d0, 0.94238591d0,
     & 0.94498318d0, 0.94757742d0, 0.95022333d0, 0.95288223d0,
     & 0.95554996d0, 0.95822328d0, 0.96090221d0, 0.96350509d0,
     & 0.96613878d0, 0.96880299d0, 0.97147042d0, 0.97411323d0,
     & 0.97672760d0, 0.97931468d0, 0.98196739d0, 0.98460960d0,
     & 0.98727155d0, 0.98988205d0, 0.99258280d0, 0.99526989d0,
     & 0.99793899d0, 1.00061667d0, 1.00330985d0, 1.00601006d0,
     & 1.00871599d0, 1.01134574d0, 1.01395249d0, 1.01656353d0,
     & 1.01922238d0, 1.02178895d0, 1.02434051d0, 1.02690911d0,
     & 1.02946889d0, 1.03204060d0, 1.03472018d0, 1.03740919d0,
     & 1.04011679d0, 1.04280472d0, 1.04550183d0, 1.04820597d0,
     & 1.05091584d0, 1.05365777d0, 1.05640364d0, 1.05912519d0,
     & 1.06184983d0, 1.06446207d0, 1.06706309d0, 1.06961608d0,
     & 1.07221437d0, 1.07480192d0, 1.07735372d0, 1.08000851d0,
     & 1.08268344d0, 1.08538759d0, 1.08807445d0, 1.09077275d0,
     & 1.09347939d0, 1.09619272d0, 1.09893906d0, 1.10169041d0,
     & 1.10441768d0, 1.10717583d0, 1.10982752d0, 1.11245620d0,
     & 1.11502576d0, 1.11763859d0, 1.12023854d0, 1.12282956d0,
     & 1.12549520d0, 1.12815452d0, 1.13086748d0, 1.13360417d0,
     & 1.13632667d0, 1.13903117d0, 1.14174438d0, 1.14449251d0,
     & 1.14724624d0, 1.14997613d0, 1.15271020d0, 1.15536451d0,
     & 1.15802264d0, 1.16059673d0, 1.16317368d0, 1.16576362d0,
     & 1.16837049d0, 1.17096794d0, 1.17353010d0, 1.17608607d0,
     & 1.17866528d0, 1.18124151d0, 1.18399239d0, 1.18675625d0,
     & 1.18955779d0, 1.19230819d0, 1.19506514d0, 1.19782746d0,
     & 1.20056570d0, 1.20333600d0, 1.20611000d0, 1.20888758d0,
     & 1.21165657d0, 1.21422327d0, 1.21677732d0, 1.21932197d0,
     & 1.22189009d0, 1.22445226d0, 1.22700953d0, 1.22959173d0,
     & 1.23231983d0, 1.23507476d0, 1.23784637d0, 1.24060977d0,
     & 1.24340987d0, 1.24621606d0, 1.24902809d0, 1.25187325d0,
     & 1.25466478d0, 1.25743139d0, 1.26020145d0, 1.26282549d0,
     & 1.26542270d0, 1.26800334d0, 1.27060282d0, 1.27316499d0,
     & 1.27571893d0, 1.27826798d0, 1.28081203d0, 1.28338146d0,
     & 1.28602946d0, 1.28871059d0, 1.29137778d0, 1.29420841d0,
     & 1.29701567d0, 1.29983020d0, 1.30267847d0, 1.30547404d0,
     & 1.30827284d0, 1.31107533d0, 1.31388056d0, 1.31663513d0,
     & 1.31935608d0, 1.32209051d0, 1.32466137d0, 1.32725525d0,
     & 1.32981336d0, 1.33236587d0, 1.33497083d0, 1.33757234d0,
     & 1.34018540d0, 1.34286678d0, 1.34569156d0, 1.34852636d0,
     & 1.35136902d0, 1.35421705d0, 1.35704124d0, 1.35984099d0,
     & 1.36264443d0, 1.36545420d0, 1.36826670d0, 1.37106729d0,
     & 1.37382770d0, 1.37644434d0, 1.37902176d0, 1.38159096d0,
     & 1.38409722d0, 1.38662744d0, 1.38923883d0, 1.39184678d0,
     & 1.39444852d0, 1.39707768d0, 1.39973927d0, 1.40241861d0,
     & 1.40507948d0, 1.40777922d0, 1.41048706d0, 1.41337776d0,
     & 1.41624379d0, 1.41908431d0, 1.42192984d0, 1.42477977d0,
     & 1.42760432d0, 1.43036819d0, 1.43311572d0, 1.43588281d0,
     & 1.43864131d0, 1.44130671d0, 1.44384789d0, 1.44641542d0,
     & 1.44898129d0, 1.45154369d0, 1.45414507d0, 1.45678914d0,
     & 1.45948267d0, 1.46218979d0, 1.46487665d0, 1.46757317d0,
     & 1.47039342d0, 1.47321928d0, 1.47605014d0, 1.47888517d0,
     & 1.48169470d0, 1.48446703d0, 1.48716664d0, 1.48984635d0,
     & 1.49248385d0, 1.49514210d0, 1.49770391d0, 1.50022936d0,
     & 1.50274932d0, 1.50526333d0, 1.50774443d0, 1.51025271d0,
     & 1.51275766d0, 1.51534617d0, 1.51803565d0, 1.52077031d0,
     & 1.52351677d0, 1.52632892d0, 1.52914870d0, 1.53191471d0,
     & 1.53468835d0, 1.53749478d0, 1.54030609d0, 1.54309189d0,
     & 1.54582453d0, 1.54842734d0, 1.55101466d0, 1.55359089d0,
     & 1.55615973d0, 1.55872118d0, 1.56130779d0, 1.56388891d0,
     & 1.56643748d0, 1.56898057d0, 1.57146239d0, 1.57394111d0,
     & 1.57644653d0, 1.57901585d0, 1.58161628d0, 1.58423197d0,
     & 1.58704877d0, 1.58990300d0, 1.59273350d0, 1.59550846d0,
     & 1.59828901d0, 1.60116172d0, 1.60400879d0, 1.60685980d0,
     & 1.60970736d0, 1.61237669d0, 1.61506116d0, 1.61754560d0,
     & 1.62002110d0, 1.62252271d0, 1.62508059d0, 1.62763357d0,
     & 1.63018239d0, 1.63272822d0, 1.63524151d0, 1.63769257d0,
     & 1.64028895d0, 1.64294922d0, 1.64557230d0, 1.64821863d0,
     & 1.65087819d0, 1.65357828d0, 1.65625656d0, 1.65894246d0,
     & 1.66166270d0, 1.66438746d0, 1.66723955d0, 1.67003596d0,
     & 1.67279983d0, 1.67557216d0, 1.67832398d0, 1.68103230d0,
     & 1.68373048d0, 1.68647945d0, 1.68916380d0, 1.69181430d0,
     & 1.69446063d0, 1.69700968d0, 1.69958568d0, 1.70212853d0,
     & 1.70463967d0, 1.70714808d0, 1.70974374d0, 1.71234047d0,
     & 1.71493101d0, 1.71759427d0, 1.72029853d0, 1.72301042d0,
     & 1.72569430d0, 1.72841763d0, 1.73111773d0, 1.73400462d0,
     & 1.73686683d0, 1.73967409d0, 1.74248290d0, 1.74533391d0,
     & 1.74808085d0, 1.75078881d0, 1.75364161d0, 1.75637639d0,
     & 1.75907350d0, 1.76179600d0, 1.76436317d0, 1.76692736d0,
     & 1.76942933d0, 1.77192879d0, 1.77436423d0, 1.77688897d0,
     & 1.77952194d0, 1.78202748d0, 1.78467083d0, 1.78735745d0,
     & 1.79005468d0, 1.79279017d0, 1.79553163d0, 1.79846156d0,
     & 1.80136585d0, 1.80427480d0, 1.80718780d0, 1.80999386d0,
     & 1.81280828d0, 1.81557512d0, 1.81844974d0, 1.82131469d0,
     & 1.82414198d0, 1.82699394d0, 1.82971728d0, 1.83234799d0,
     & 1.83488381d0, 1.83741832d0, 1.83998013d0, 1.84253907d0,
     & 1.84509599d0, 1.84750104d0, 1.84997118d0, 1.85250545d0,
     & 1.85499299d0, 1.85749686d0, 1.86013222d0, 1.86286867d0,
     & 1.86558008d0, 1.86829889d0, 1.87102413d0, 1.87378263d0,
     & 1.87654531d0, 1.87924767d0, 1.88191819d0, 1.88460732d0,
     & 1.88743329d0, 1.89021814d0, 1.89299440d0, 1.89579272d0,
     & 1.89855468d0, 1.90131319d0, 1.90406907d0, 1.90682161d0,
     & 1.90956819d0, 1.91228163d0, 1.91502237d0, 1.91760921d0,
     & 1.92019427d0, 1.92277765d0, 1.92536616d0, 1.92800856d0,
     & 1.93066525d0, 1.93333447d0, 1.93601203d0, 1.93869853d0,
     & 1.94142246d0, 1.94415307d0, 1.94685638d0, 1.94959676d0,
     & 1.95231104d0, 1.95499384d0, 1.95765543d0, 1.96045458d0,
     & 1.96321249d0, 1.96599352d0, 1.96876490d0, 1.97149980d0,
     & 1.97414100d0, 1.97678065d0, 1.97941422d0, 1.98204494d0,
     & 1.98479307d0, 1.98750818d0, 1.99006879d0, 1.99265766d0,
     & 1.99512494d0, 1.99760497d0, 2.00022650d0, 2.00289202d0,
     & 2.00560594d0, 2.00830150d0, 2.01103854d0, 2.01363134d0,
     & 2.01626277d0, 2.01883912d0, 2.02139068d0, 2.02416158d0,
     & 2.02689433d0, 2.02951646d0, 2.03215528d0, 2.03486323d0,
     & 2.03744531d0, 2.03998756d0, 2.04258847d0, 2.04520965d0,
     & 2.04785872d0, 2.05068660d0, 2.05338717d0, 2.05611610d0,
     & 2.05884528d0, 2.06157279d0, 2.06421328d0, 2.06700110d0,
     & 2.06978798d0, 2.07266164d0, 2.07558870d0, 2.07854033d0,
     & 2.08149481d0, 2.08445907d0, 2.08710742d0, 2.08973622d0,
     & 2.09240651d0, 2.09505415d0, 2.09770775d0, 2.10036731d0,
     & 2.10303712d0, 2.10563064d0, 2.10820174d0, 2.11043596d0,
     & 2.11266255d0, 2.11520815d0, 2.11774492d0, 2.12027311d0,
     & 2.12279558d0, 2.12543392d0, 2.12825036d0, 2.13096786d0,
     & 2.13401198d0, 2.13684344d0, 2.13982677d0, 2.14271379d0,
     & 2.14556742d0, 2.14845109d0, 2.15121126d0, 2.15396976d0,
     & 2.15660381d0, 2.15912414d0, 2.16165972d0, 2.16389561d0,
     & 2.16649008d0, 2.16912746d0, 2.17186642d0, 2.17477202d0,
     & 2.17765045d0, 2.18043518d0, 2.18325663d0, 2.18608379d0,
     & 2.18887568d0, 2.19165587d0, 2.19422174d0, 2.19676495d0,
     & 2.19926763d0, 2.20179462d0, 2.20415688d0, 2.20666862d0,
     & 2.20927405d0, 2.21184397d0, 2.21441007d0, 2.21694183d0,
     & 2.21947026d0, 2.22218251d0, 2.22476816d0, 2.22738194d0,
     & 2.22996330d0, 2.23257327d0, 2.23521042d0, 2.23796821d0,
     & 2.24083066d0, 2.24369144d0, 2.24660563d0, 2.24953628d0,
     & 2.25247931d0, 2.25546336d0, 2.25845623d0, 2.26148438d0,
     & 2.26429892d0, 2.26703262d0, 2.26974058d0, 2.27237868d0,
     & 2.27502179d0, 2.27761388d0, 2.28018975d0, 2.28260303d0,
     & 2.28513265d0, 2.28765559d0, 2.29014516d0, 2.29284978d0,
     & 2.29545498d0, 2.29820991d0, 2.30096078d0, 2.30367756d0,
     & 2.30641913d0, 2.30925512d0, 2.31224084d0, 2.31525159d0,
     & 2.31822920d0, 2.32146215d0, 2.32431412d0, 2.32777786d0,
     & 2.33109951d0, 2.33459926d0, 2.33767629d0, 2.34042263d0,
     & 2.34315252d0, 2.34589601d0, 2.34849668d0, 2.35100722d0,
     & 2.35329604d0, 2.35610080d0, 2.35832834d0, 2.36070371d0,
     & 2.36289930d0, 2.36567640d0, 2.36838746d0, 2.37102342d0,
     & 2.37342715d0, 2.37582755d0, 2.37832046d0, 2.38081050d0,
     & 2.38316584d0, 2.38551760d0, 2.38784170d0, 2.39016891d0,
     & 2.39236927d0, 2.39493990d0, 2.39753985d0, 2.40035939d0,
     & 2.40317464d0, 2.40623689d0, 2.40945077d0, 2.41271615d0,
     & 2.41601539d0, 2.41940594d0, 2.42221928d0, 2.42505932d0,
     & 2.42791438d0, 2.43075371d0, 2.43370366d0, 2.43659806d0,
     & 2.43928361d0, 2.44153047d0, 2.44373655d0, 2.44607568d0,
     & 2.44822788d0, 2.45096087d0, 2.45385909d0, 2.45674443d0,
     & 2.45977283d0, 2.46216202d0, 2.46460986d0, 2.46705174d0,
     & 2.46975112d0, 2.47244120d0, 2.47505879d0, 2.47767258d0,
     & 2.48028302d0, 2.48257804d0, 2.48487139d0, 2.48700690d0,
     & 2.48967147d0, 2.49230266d0, 2.49493146d0, 2.49755883d0,
     & 2.50070596d0, 2.50378633d0, 2.50656080d0, 2.50945187d0,
     & 2.51249886d0, 2.51722980d0, 2.52196503d0, 2.52670383d0,
     & 2.52973962d0, 2.53278208d0, 2.53586745d0, 2.53824425d0,
     & 2.54060054d0, 2.54323649d0, 2.54576087d0, 2.54825735d0,
     & 2.54907274d0, 2.54988432d0, 2.55069900d0, 2.55321908d0,
     & 2.55573535d0, 2.55858564d0, 2.56162477d0, 2.56487465d0,
     & 2.56805801d0, 2.57108116d0, 2.57409978d0, 2.57711530d0,
     & 2.58028507d0, 2.58298087d0, 2.58561587d0, 2.58821774d0
     &/
      DATA (Imax ( 1,I), I= 1001, 2100) /
     & 2.59080935d0, 2.59336877d0, 2.59528089d0, 2.59725451d0,
     & 2.59935093d0, 2.60144663d0, 2.60357213d0, 2.60572672d0,
     & 2.60844064d0, 2.61116362d0, 2.61422157d0, 2.61695576d0,
     & 2.61973119d0, 2.62425017d0, 2.62881017d0, 2.63216376d0,
     & 2.63552308d0, 2.63882375d0, 2.64194489d0, 2.64497757d0,
     & 2.64809370d0, 2.65090823d0, 2.65371323d0, 2.65647888d0,
     & 2.65764880d0, 2.65868521d0, 2.66093016d0, 2.66317201d0,
     & 2.66594291d0, 2.66849232d0, 2.67122531d0, 2.67407942d0,
     & 2.67739177d0, 2.68082643d0, 2.68361092d0, 2.68614960d0,
     & 2.68874955d0, 2.69199395d0, 2.69524050d0, 2.69801807d0,
     & 2.70106411d0, 2.70385599d0, 2.70622587d0, 2.70863938d0,
     & 2.71091008d0, 2.71389151d0, 2.71676421d0, 2.71968389d0,
     & 2.72200441d0, 2.72433376d0, 2.72663951d0, 2.72928166d0,
     & 2.73199749d0, 2.73501754d0, 2.73753834d0, 2.74037194d0,
     & 2.74317765d0, 2.74661899d0, 2.74998832d0, 2.75305748d0,
     & 2.75612068d0, 2.75908017d0, 2.76140285d0, 2.76400876d0,
     & 2.76810122d0, 2.77215815d0, 2.77546000d0, 2.77832437d0,
     & 2.78078580d0, 2.78286481d0, 2.78560328d0, 2.78786898d0,
     & 2.79023194d0, 2.79284477d0, 2.79516935d0, 2.79628515d0,
     & 2.79932499d0, 2.80283237d0, 2.80661440d0, 2.81081057d0,
     & 2.81354094d0, 2.81597185d0, 2.81887293d0, 2.82183242d0,
     & 2.82481122d0, 2.82776690d0, 2.83637619d0, 2.84263611d0,
     & 2.84890461d0, 2.85534310d0, 2.86178064d0, 2.88277316d0,
     & 2.89108872d0, 2.91202354d0, 2.91558099d0, 2.93610573d0,
     & 2.95666361d0, 2.95362949d0, 2.95102310d0, 2.94865608d0,
     & 2.95142651d0, 2.95419288d0, 2.94434524d0, 2.94707274d0,
     & 2.93718123d0, 2.93901157d0, 2.92914128d0, 2.91926455d0,
     & 2.92181754d0, 2.92440009d0, 2.92881513d0, 2.92810178d0,
     & 2.92739391d0, 2.92638946d0, 2.92542648d0, 2.92271447d0,
     & 2.92563057d0, 2.92325544d0, 2.92095470d0, 2.92392230d0,
     & 2.93804884d0, 2.95010638d0, 2.96216083d0, 2.97422504d0,
     & 2.98659539d0, 2.99856305d0, 3.01955771d0, 3.04021335d0,
     & 3.06088543d0, 3.06412482d0, 3.07131457d0, 3.06732512d0,
     & 3.06402373d0, 3.06071401d0, 3.05739141d0, 3.05370808d0,
     & 3.05032325d0, 3.03942132d0, 3.02565074d0, 3.01187444d0,
     & 3.01513696d0, 3.01339006d0, 3.01166391d0, 3.00920177d0,
     & 3.00673270d0, 3.00425291d0, 3.00212526d0, 3.00008726d0,
     & 2.99878550d0, 3.00068688d0, 3.00298500d0, 3.00550604d0,
     & 3.00885272d0, 3.01195240d0, 3.01512074d0, 3.02876139d0,
     & 3.04241157d0, 3.05606270d0, 3.06981134d0, 3.08259702d0,
     & 3.09542084d0, 3.10788369d0, 3.12048221d0, 3.13280058d0,
     & 3.13658547d0, 3.13998389d0, 3.13211656d0, 3.12424970d0,
     & 3.11638236d0, 3.10857010d0, 3.10122561d0, 3.09385252d0,
     & 3.08644152d0, 3.07899165d0, 3.07198453d0, 3.07376027d0,
     & 3.07588720d0, 3.08257174d0, 3.08956504d0, 3.09963536d0,
     & 3.11194468d0, 3.21449590d0, 3.17768240d0, 3.18624496d0,
     & 3.20433164d0, 3.26201916d0, 3.28821349d0, 3.29548383d0,
     & 3.32800937d0, 3.35650039d0, 3.39418387d0, 3.41708779d0,
     & 3.45288777d0, 3.48214364d0, 3.50980973d0, 3.53335500d0,
     & 3.56162167d0, 3.58963990d0, 3.60839748d0, 3.62397957d0,
     & 3.65266943d0, 3.67134929d0, 3.70013356d0, 3.72294879d0,
     & 3.75357866d0, 3.78140545d0, 3.81198740d0, 3.83997512d0,
     & 3.86114717d0, 3.89782834d0, 3.92660332d0, 3.95564318d0,
     & 3.98203754d0, 4.01046467d0, 4.03820992d0, 4.06654024d0,
     & 4.10120153d0, 4.12788677d0, 4.15665913d0, 4.18579912d0,
     & 4.21536922d0, 4.24337864d0, 4.27134895d0, 4.29744768d0,
     & 4.32519293d0, 4.35422182d0, 4.39076853d0, 4.42144585d0,
     & 4.45008326d0, 4.48062944d0, 4.50972462d0, 4.55611849d0,
     & 4.58485556d0, 4.61206627d0, 4.63806581d0, 4.66674232d0,
     & 4.69467735d0, 4.72387075d0, 4.73650217d0, 4.76835823d0,
     & 4.79590940d0, 4.82314682d0, 4.85002899d0, 4.88147831d0,
     & 4.90781641d0, 4.94528532d0, 4.97731686d0, 5.00698757d0,
     & 5.03840160d0, 5.06793690d0, 5.10092640d0, 5.12966490d0,
     & 5.16044188d0, 5.19834948d0, 5.22577524d0, 5.25404024d0,
     & 5.27885103d0, 5.29874039d0, 5.33050060d0, 5.35859537d0,
     & 5.38462782d0, 5.41040325d0, 5.43765640d0, 5.46251011d0,
     & 5.48288584d0, 5.51260376d0, 5.53984165d0, 5.56862307d0,
     & 5.59649658d0, 5.62920856d0, 5.65809536d0, 5.68804169d0,
     & 5.71941233d0, 5.75544548d0, 5.78921652d0, 5.81957483d0,
     & 5.85001898d0, 5.87844086d0, 5.90478039d0, 5.93582821d0,
     & 5.97202349d0, 5.99662352d0, 6.02121401d0, 6.04195690d0,
     & 6.07393932d0, 6.09968138d0, 6.13057041d0, 6.15755653d0,
     & 6.18450499d0, 6.21138239d0, 6.24009180d0, 6.27292585d0,
     & 6.30169535d0, 6.32774448d0, 6.34758186d0, 6.37726593d0,
     & 6.40883398d0, 6.43886805d0, 6.46082735d0, 6.49110126d0,
     & 6.51594496d0, 6.54691219d0, 6.57419491d0, 6.60521364d0,
     & 6.63323212d0, 6.66021919d0, 6.69110775d0, 6.71839905d0,
     & 6.75146151d0, 6.77838564d0, 6.80474043d0, 6.82908821d0,
     & 6.85788584d0, 6.88378668d0, 6.90939236d0, 6.93792582d0,
     & 6.96754646d0, 6.99803352d0, 7.02516031d0, 7.05212069d0,
     & 7.08146572d0, 7.10901928d0, 7.13700771d0, 7.16446638d0,
     & 7.19924355d0, 7.22781420d0, 7.25345802d0, 7.28160906d0,
     & 7.31048107d0, 7.33599758d0, 7.36299706d0, 7.39111614d0,
     & 7.41881800d0, 7.45130873d0, 7.48202896d0, 7.51085472d0,
     & 7.53677750d0, 7.56402779d0, 7.59579420d0, 7.62446785d0,
     & 7.65427542d0, 7.67975664d0, 7.71134758d0, 7.74065781d0,
     & 7.77010202d0, 7.79578876d0, 7.82243204d0, 7.85040140d0,
     & 7.87884951d0, 7.90697622d0, 7.93488264d0, 7.96521282d0,
     & 7.99410915d0, 8.02247906d0, 8.05380154d0, 8.08152962d0,
     & 8.11194992d0, 8.14172459d0, 8.16572189d0, 8.18959618d0,
     & 8.21820354d0, 8.24530315d0, 8.27218342d0, 8.29995823d0,
     & 8.32978344d0, 8.35976887d0, 8.39164543d0, 8.42383862d0,
     & 8.45398235d0, 8.48605633d0, 8.51340008d0, 8.54207516d0,
     & 8.56874180d0, 8.59429073d0, 8.62009239d0, 8.64871407d0,
     & 8.67574215d0, 8.70320511d0, 8.72988415d0, 8.75974369d0,
     & 8.78997612d0, 8.81522083d0, 8.83848381d0, 8.86310768d0,
     & 8.88745689d0, 8.91359901d0, 8.94027615d0, 8.96790886d0,
     & 8.99482441d0, 9.02227783d0, 9.04820251d0, 9.07544899d0,
     & 9.10425472d0, 9.13405704d0, 9.16301441d0, 9.19191170d0,
     & 9.22128296d0, 9.24840736d0, 9.27763081d0, 9.30394650d0,
     & 9.33281517d0, 9.35916901d0, 9.38496208d0, 9.41331768d0,
     & 9.44367123d0, 9.47314930d0, 9.50233936d0, 9.53137112d0,
     & 9.55959892d0, 9.58915234d0, 9.61832333d0, 9.64729595d0,
     & 9.67708778d0, 9.70365334d0, 9.72827721d0, 9.75532341d0,
     & 9.78222084d0, 9.81299591d0, 9.84409428d0, 9.87414742d0,
     & 9.90243244d0, 9.93060589d0, 9.96107006d0, 9.98764610d0,
     &10.01393604d0,10.04130459d0,10.06920433d0,10.10009289d0,
     &10.12668037d0,10.15140724d0,10.17907429d0,10.20612335d0,
     &10.23596287d0,10.26767635d0,10.29328156d0,10.31940460d0,
     &10.34693527d0,10.37558174d0,10.40660191d0,10.43328381d0,
     &10.45760918d0,10.48489380d0,10.51085281d0,10.53547859d0,
     &10.56059551d0,10.58624363d0,10.61321735d0,10.64019108d0,
     &10.66549587d0,10.69195366d0,10.72104645d0,10.74921608d0,
     &10.77554989d0,10.80281353d0,10.82965755d0,10.86407280d0,
     &10.89304924d0,10.92426682d0,10.95244312d0,10.97719479d0,
     &11.00719547d0,11.03402805d0,11.06443024d0,11.09220695d0,
     &11.11741734d0,11.14365768d0,11.17143059d0,11.19965267d0,
     &11.22938538d0,11.25637150d0,11.28348637d0,11.31098366d0,
     &11.34210682d0,11.37051201d0,11.40177727d0,11.43115616d0,
     &11.45864677d0,11.49085903d0,11.51533222d0,11.54215145d0,
     &11.57090569d0,11.60013962d0,11.62816906d0,11.65756321d0,
     &11.68684292d0,11.71517086d0,11.74386120d0,11.77427769d0,
     &11.80493450d0,11.83229256d0,11.85840988d0,11.89011669d0,
     &11.91802216d0,11.94630146d0,11.97477245d0,12.00539780d0,
     &12.03437901d0,12.06064415d0,12.08980751d0,12.11715794d0,
     &12.14520073d0,12.17185879d0,12.19904709d0,12.22386265d0,
     &12.25113773d0,12.28017426d0,12.30947781d0,12.33651924d0,
     &12.36528969d0,12.39136219d0,12.41888142d0,12.44607353d0,
     &12.47308159d0,12.50511551d0,12.53277302d0,12.56075859d0,
     &12.58972263d0,12.61764431d0,12.64570332d0,12.67486858d0,
     &12.70145893d0,12.73123741d0,12.75912189d0,12.78837585d0,
     &12.81775570d0,12.84594345d0,12.87416553d0,12.90263081d0,
     &12.92808151d0,12.95555973d0,12.98569679d0,13.01498699d0,
     &13.04584122d0,13.07119751d0,13.10116291d0,13.12771130d0,
     &13.15704060d0,13.18743420d0,13.21821022d0,13.24781895d0,
     &13.27575207d0,13.30277348d0,13.33243942d0,13.36296844d0,
     &13.39283562d0,13.42125893d0,13.44861031d0,13.47605324d0,
     &13.50432301d0,13.53241348d0,13.55957985d0,13.58889103d0,
     &13.61997414d0,13.64813519d0,13.67538357d0,13.70493031d0,
     &13.73484230d0,13.76367760d0,13.79238033d0,13.81890774d0,
     &13.84755230d0,13.87617207d0,13.90413570d0,13.93246937d0,
     &13.96337509d0,13.99193764d0,14.01995373d0,14.04782295d0,
     &14.07650471d0,14.11057949d0,14.14131260d0,14.17045879d0,
     &14.19924927d0,14.22645092d0,14.25398922d0,14.28009224d0,
     &14.30775070d0,14.33797455d0,14.36541176d0,14.39419270d0,
     &14.42229939d0,14.45090103d0,14.48130035d0,14.51100731d0,
     &14.54157829d0,14.57085609d0,14.60072517d0,14.63191700d0,
     &14.66166782d0,14.69299698d0,14.71744919d0,14.74357033d0,
     &14.77121830d0,14.80021095d0,14.82938290d0,14.85925579d0,
     &14.89000320d0,14.91963959d0,14.94784355d0,14.97631359d0,
     &15.00425053d0,15.03289032d0,15.06334782d0,15.09427929d0,
     &15.12623310d0,15.15902424d0,15.19099617d0,15.21988487d0,
     &15.25068951d0,15.28133106d0,15.31087494d0,15.33825779d0,
     &15.36530781d0,15.39384079d0,15.42161179d0,15.44875813d0,
     &15.47797489d0,15.50913429d0,15.53932095d0,15.57062054d0,
     &15.60186386d0,15.62980080d0,15.65874195d0,15.68621635d0,
     &15.71161652d0,15.74047089d0,15.77108097d0,15.80156422d0,
     &15.83213615d0,15.86203098d0,15.89097977d0,15.92275810d0,
     &15.95444107d0,15.98731136d0,16.01615334d0,16.04665375d0,
     &16.07617569d0,16.10453415d0,16.13378716d0,16.16424751d0,
     &16.19055367d0,16.22122765d0,16.25029755d0,16.28042793d0,
     &16.30829430d0,16.33701134d0,16.36681747d0,16.39599800d0,
     &16.42573166d0,16.45585251d0,16.48737717d0,16.51734352d0,
     &16.54741287d0,16.57848358d0,16.60846329d0,16.63898087d0,
     &16.66826057d0,16.69856453d0,16.72845078d0,16.76040840d0,
     &16.79082298d0,16.82110596d0,16.85401154d0,16.88664818d0,
     &16.91380692d0,16.94513130d0,16.97720909d0,17.01262856d0,
     &17.04690361d0,17.08151245d0,17.11758423d0,17.15139008d0,
     &17.18162346d0,17.21415901d0,17.24273872d0,17.27254295d0,
     &17.30366325d0,17.33500481d0,17.36149979d0,17.39019012d0,
     &17.42009354d0,17.44689369d0,17.47504044d0,17.50488663d0,
     &17.53186035d0,17.56047249d0,17.58817291d0,17.62160110d0,
     &17.64996529d0,17.67728233d0,17.71044540d0,17.73827171d0,
     &17.77037621d0,17.80345154d0,17.83471107d0,17.86579132d0,
     &17.89547539d0,17.92991066d0,17.96172905d0,17.99267578d0,
     &18.02789497d0,18.06367493d0,18.08954430d0,18.12602425d0,
     &18.15738869d0,18.18649483d0,18.21769333d0,18.24851608d0,
     &18.28037071d0,18.31294632d0,18.34460449d0,18.37319183d0,
     &18.40453720d0,18.43718910d0,18.46345711d0,18.49243164d0,
     &18.52400780d0,18.55846214d0,18.58942604d0,18.62323952d0,
     &18.65482521d0,18.69082642d0,18.72499657d0,18.76056480d0,
     &18.79244614d0,18.82634544d0,19.87360764d0,19.87372780d0,
     &19.87385178d0,19.87397003d0,19.87409019d0,19.87421227d0,
     &19.87433434d0,19.87445450d0,19.87457466d0,19.87469864d0,
     &19.87481880d0,19.87494087d0,19.87506294d0,19.87518311d0,
     &19.87530327d0,19.87542534d0,19.87554741d0,19.87567139d0,
     &19.87579346d0,19.87591362d0,19.87603760d0,19.87616158d0,
     &19.87628365d0,19.87640762d0,19.87653351d0,19.87665367d0,
     &19.87677765d0,19.87689972d0,19.87702179d0,19.87714577d0,
     &19.87726784d0,19.87738991d0,19.87751198d0,19.89201736d0,
     &19.92281723d0,19.95038795d0,19.98413086d0,20.01818275d0,
     &20.05171013d0,20.08813667d0,20.11806297d0,20.14944077d0,
     &20.17839622d0,20.21529198d0,20.24682426d0,20.28179932d0,
     &20.31798553d0,20.35468102d0,20.38927269d0,20.42734146d0,
     &20.46282959d0,20.49962807d0,20.53913116d0,20.57641983d0,
     &20.60716820d0,20.63953590d0,20.67110252d0,20.70601463d0,
     &20.74251938d0,20.77742195d0,20.81223869d0,20.84393120d0,
     &20.87873650d0,20.91342163d0,20.94803429d0,20.98280334d0,
     &21.01691246d0,21.05175781d0,21.08533096d0,21.12191391d0,
     &21.15643501d0,21.19301796d0,21.22824478d0,21.26476097d0,
     &21.29877663d0,21.33348083d0,21.37008476d0,21.40419579d0,
     &21.44143677d0,21.47681046d0,21.51347160d0,21.54963303d0,
     &21.59322548d0,21.63050842d0,21.66816139d0,21.70179176d0,
     &21.73912621d0,21.76931381d0,21.80367851d0,21.82628632d0,
     &21.85865784d0,21.88499832d0,21.91826820d0,21.95709801d0,
     &21.99192619d0,22.02568817d0,22.05839539d0,22.08712387d0,
     &22.12230110d0,22.15727425d0,22.19641876d0,22.23731613d0,
     &22.26544380d0,22.29996872d0,22.34237862d0,22.38323402d0,
     &22.42248344d0,22.45858002d0,22.49095726d0,22.52615166d0,
     &22.57007217d0,22.61011696d0,22.64834404d0,22.68781662d0,
     &22.72581291d0,22.76034737d0,22.79796410d0,22.83395958d0,
     &22.87293816d0,22.91201019d0,22.94758987d0,22.98750877d0,
     &23.03318405d0,23.07584000d0,23.11551666d0,23.14793015d0,
     &23.18388367d0,23.21833801d0,23.25083542d0,23.29401398d0,
     &23.33815956d0,23.37623978d0,23.41344833d0,23.45684242d0,
     &23.48842430d0,23.52235985d0,23.56021500d0,23.60184479d0,
     &23.64578247d0,23.69320679d0,23.73704147d0,23.77962685d0,
     &23.81334877d0,23.84543610d0,23.88208771d0,23.92045212d0,
     &23.95655441d0,23.99455833d0,24.03169441d0,24.07993698d0,
     &24.12185669d0,24.16288948d0,24.19760895d0,24.23811913d0,
     &24.25778389d0,24.29660606d0,24.23363304d0,23.88859558d0,
     &23.37633705d0,22.76574707d0,22.05404663d0,21.29183197d0,
     &20.50795174d0,19.62766075d0,18.69625473d0,17.75949097d0,
     &16.78371048d0,15.86056423d0,15.21871471d0,14.69879532d0,
     &14.24984169d0,13.87089443d0,13.53172016d0,13.22388935d0,
     &12.94589615d0,16.73075867d0,16.73368645d0,16.73466301d0,
     &16.73466301d0,16.73368645d0,16.73466301d0,16.76358795d0,
     &16.76358795d0,16.78282547d0,16.78282547d0,16.78282547d0,
     &10.65557194d0,10.51825047d0,10.38422012d0,10.25455189d0,
     &10.12979603d0,16.72978401d0, 9.89108372d0, 9.77754498d0,
     & 9.66638660d0, 9.55926609d0, 9.45502758d0, 9.35396004d0,
     & 9.25376034d0, 9.15824223d0, 9.06285667d0, 8.97106075d0,
     & 8.88099003d0, 8.79297924d0, 8.70737457d0, 8.62319374d0,
     & 8.54104996d0, 8.45941544d0, 9.93997478d0,16.69550133d0,
     &16.69550133d0,16.72880745d0,16.72978401d0,16.73270988d0,
     &16.73563766d0,16.73758888d0,16.73661423d0,16.73661423d0,
     &16.74958038d0,16.76012421d0,16.74841499d0,16.73661423d0,
     &16.73856544d0,16.75074768d0,16.73661423d0,16.73563766d0,
     &16.73661423d0,16.73661423d0,16.73563766d0,16.73563766d0,
     &16.72880745d0,16.73466301d0,16.79747391d0,16.80138206d0,
     &16.79356766d0,16.79942703d0,16.81212425d0,16.81114769d0,
     &16.81798363d0,16.81700706d0,16.82481956d0,16.82579613d0,
     &16.83067894d0,16.79845047d0,16.80235863d0,16.80431175d0,
     &16.80626488d0,16.80138206d0,16.80528831d0,16.80431175d0,
     &16.80626488d0,16.79356766d0,16.80333519d0,16.79649734d0,
     &16.82091331d0,16.82091331d0,16.82677269d0,16.82677269d0,
     &16.83067894d0,16.81993675d0,16.82286644d0,16.82188988d0,
     &16.82970238d0,16.82677269d0,16.83263206d0,16.82286644d0,
     &16.82384300d0,16.82774925d0,16.82677269d0,16.81993675d0,
     &16.83556366d0,16.83067894d0,16.83263206d0,16.83165550d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0,
     &16.83067894d0,16.83067894d0,16.83067894d0,16.83067894d0
     &/
c Definition of open field lines as Lupper=f(Iupper) for doy=001
      DATA (Lupper ( 1,I), I= 1, 1001) /
     &12.89d0,12.88d0,12.88d0,12.87d0,12.87d0,12.86d0,12.86d0,12.86d0,
     &12.85d0,12.85d0,12.84d0,12.84d0,12.83d0,12.83d0,12.82d0,12.82d0,
     &12.81d0,12.81d0,12.81d0,12.80d0,12.80d0,12.79d0,12.79d0,12.78d0,
     &12.78d0,12.77d0,12.77d0,12.76d0,12.76d0,12.76d0,12.75d0,12.75d0,
     &12.74d0,12.74d0,12.73d0,12.73d0,12.72d0,12.72d0,12.71d0,12.71d0,
     &12.71d0,12.70d0,12.70d0,12.69d0,12.69d0,12.68d0,12.68d0,12.67d0,
     &12.67d0,12.67d0,12.66d0,12.66d0,12.65d0,12.65d0,12.64d0,12.64d0,
     &12.63d0,12.63d0,12.62d0,12.62d0,12.62d0,12.61d0,12.61d0,12.60d0,
     &12.60d0,12.59d0,12.59d0,12.58d0,12.58d0,12.57d0,12.57d0,12.57d0,
     &12.56d0,12.56d0,12.55d0,12.55d0,12.54d0,12.54d0,12.53d0,12.53d0,
     &12.53d0,12.52d0,12.52d0,12.51d0,12.51d0,12.50d0,12.50d0,12.49d0,
     &12.49d0,12.48d0,12.48d0,12.48d0,12.47d0,12.47d0,12.46d0,12.46d0,
     &12.45d0,12.45d0,12.44d0,12.44d0,12.43d0,12.43d0,12.43d0,12.42d0,
     &12.42d0,12.41d0,12.41d0,12.40d0,12.40d0,12.39d0,12.39d0,12.38d0,
     &12.38d0,12.38d0,12.37d0,12.37d0,12.36d0,12.36d0,12.35d0,12.35d0,
     &12.34d0,12.34d0,12.34d0,12.33d0,12.33d0,12.32d0,12.32d0,12.31d0,
     &12.31d0,12.30d0,12.30d0,12.29d0,12.29d0,12.29d0,12.28d0,12.28d0,
     &12.27d0,12.27d0,12.26d0,12.26d0,12.25d0,12.25d0,12.24d0,12.24d0,
     &12.24d0,12.23d0,12.23d0,12.22d0,12.22d0,12.21d0,12.21d0,12.20d0,
     &12.20d0,12.19d0,12.19d0,12.19d0,12.18d0,12.18d0,12.17d0,12.17d0,
     &12.16d0,12.16d0,12.15d0,12.15d0,12.15d0,12.14d0,12.14d0,12.13d0,
     &12.13d0,12.12d0,12.12d0,12.11d0,12.11d0,12.10d0,12.10d0,12.10d0,
     &12.09d0,12.09d0,12.08d0,12.08d0,12.07d0,12.07d0,12.06d0,12.06d0,
     &12.05d0,12.05d0,12.05d0,12.04d0,12.04d0,12.03d0,12.03d0,12.02d0,
     &12.02d0,12.01d0,12.01d0,12.00d0,12.00d0,12.00d0,11.99d0,11.99d0,
     &11.98d0,11.98d0,11.97d0,11.97d0,11.96d0,11.96d0,11.96d0,11.95d0,
     &11.95d0,11.94d0,11.94d0,11.93d0,11.93d0,11.92d0,11.92d0,11.91d0,
     &11.91d0,11.91d0,11.90d0,11.90d0,11.89d0,11.89d0,11.88d0,11.88d0,
     &11.87d0,11.87d0,11.86d0,11.86d0,11.86d0,11.85d0,11.85d0,11.84d0,
     &11.84d0,11.83d0,11.83d0,11.82d0,11.82d0,11.81d0,11.81d0,11.81d0,
     &11.80d0,11.80d0,11.79d0,11.79d0,11.78d0,11.78d0,11.77d0,11.77d0,
     &11.77d0,11.76d0,11.76d0,11.75d0,11.75d0,11.74d0,11.74d0,11.73d0,
     &11.73d0,11.72d0,11.72d0,11.72d0,11.71d0,11.71d0,11.70d0,11.70d0,
     &11.69d0,11.69d0,11.68d0,11.68d0,11.67d0,11.67d0,11.67d0,11.66d0,
     &11.66d0,11.65d0,11.65d0,11.64d0,11.64d0,11.63d0,11.63d0,11.63d0,
     &11.62d0,11.62d0,11.61d0,11.61d0,11.60d0,11.60d0,11.59d0,11.59d0,
     &11.58d0,11.58d0,11.58d0,11.57d0,11.57d0,11.56d0,11.56d0,11.55d0,
     &11.55d0,11.54d0,11.54d0,11.53d0,11.53d0,11.53d0,11.52d0,11.52d0,
     &11.51d0,11.51d0,11.50d0,11.50d0,11.49d0,11.49d0,11.48d0,11.48d0,
     &11.48d0,11.47d0,11.47d0,11.46d0,11.46d0,11.45d0,11.45d0,11.44d0,
     &11.44d0,11.44d0,11.43d0,11.43d0,11.42d0,11.42d0,11.41d0,11.41d0,
     &11.40d0,11.40d0,11.39d0,11.39d0,11.39d0,11.38d0,11.38d0,11.37d0,
     &11.37d0,11.36d0,11.36d0,11.35d0,11.35d0,11.34d0,11.34d0,11.34d0,
     &11.33d0,11.33d0,11.32d0,11.32d0,11.31d0,11.31d0,11.30d0,11.30d0,
     &11.29d0,11.29d0,11.29d0,11.28d0,11.28d0,11.27d0,11.27d0,11.26d0,
     &11.26d0,11.25d0,11.25d0,11.25d0,11.24d0,11.24d0,11.23d0,11.23d0,
     &11.22d0,11.22d0,11.21d0,11.21d0,11.20d0,11.20d0,11.20d0,11.19d0,
     &11.19d0,11.18d0,11.18d0,11.17d0,11.17d0,11.16d0,11.16d0,11.15d0,
     &11.15d0,11.15d0,11.14d0,11.14d0,11.13d0,11.13d0,11.12d0,11.12d0,
     &11.11d0,11.11d0,11.10d0,11.10d0,11.10d0,11.09d0,11.09d0,11.08d0,
     &11.08d0,11.07d0,11.07d0,11.06d0,11.06d0,11.06d0,11.05d0,11.05d0,
     &11.04d0,11.04d0,11.03d0,11.03d0,11.02d0,11.02d0,11.01d0,11.01d0,
     &11.01d0,11.00d0,11.00d0,10.99d0,10.99d0,10.98d0,10.98d0,10.97d0,
     &10.97d0,10.96d0,10.96d0,10.96d0,10.95d0,10.95d0,10.94d0,10.94d0,
     &10.93d0,10.93d0,10.92d0,10.92d0,10.92d0,10.91d0,10.91d0,10.90d0,
     &10.90d0,10.89d0,10.89d0,10.88d0,10.88d0,10.87d0,10.87d0,10.87d0,
     &10.86d0,10.86d0,10.85d0,10.85d0,10.84d0,10.84d0,10.83d0,10.83d0,
     &10.82d0,10.82d0,10.82d0,10.81d0,10.81d0,10.80d0,10.80d0,10.79d0,
     &10.79d0,10.78d0,10.78d0,10.77d0,10.77d0,10.77d0,10.76d0,10.76d0,
     &10.75d0,10.75d0,10.74d0,10.74d0,10.73d0,10.73d0,10.73d0,10.72d0,
     &10.72d0,10.71d0,10.71d0,10.70d0,10.70d0,10.69d0,10.69d0,10.68d0,
     &10.68d0,10.68d0,10.67d0,10.67d0,10.66d0,10.66d0,10.65d0,10.65d0,
     &10.64d0,10.64d0,10.63d0,10.63d0,10.63d0,10.62d0,10.62d0,10.61d0,
     &10.61d0,10.60d0,10.60d0,10.59d0,10.59d0,10.58d0,10.58d0,10.58d0,
     &10.57d0,10.57d0,10.56d0,10.56d0,10.55d0,10.55d0,10.54d0,10.54d0,
     &10.54d0,10.53d0,10.53d0,10.52d0,10.52d0,10.51d0,10.51d0,10.50d0,
     &10.50d0,10.49d0,10.49d0,10.49d0,10.48d0,10.48d0,10.47d0,10.47d0,
     &10.46d0,10.46d0,10.45d0,10.45d0,10.44d0,10.44d0,10.44d0,10.43d0,
     &10.43d0,10.42d0,10.42d0,10.41d0,10.41d0,10.40d0,10.40d0,10.39d0,
     &10.39d0,10.39d0,10.38d0,10.38d0,10.37d0,10.37d0,10.36d0,10.36d0,
     &10.35d0,10.35d0,10.35d0,10.34d0,10.34d0,10.33d0,10.33d0,10.32d0,
     &10.32d0,10.32d0,10.31d0,10.31d0,10.31d0,10.30d0,10.30d0,10.29d0,
     &10.29d0,10.29d0,10.28d0,10.28d0,10.28d0,10.27d0,10.27d0,10.27d0,
     &10.26d0,10.26d0,10.25d0,10.25d0,10.25d0,10.24d0,10.24d0,10.24d0,
     &10.23d0,10.23d0,10.22d0,10.22d0,10.22d0,10.21d0,10.21d0,10.21d0,
     &10.20d0,10.20d0,10.20d0,10.19d0,10.19d0,10.18d0,10.18d0,10.18d0,
     &10.17d0,10.17d0,10.17d0,10.16d0,10.16d0,10.16d0,10.15d0,10.15d0,
     &10.14d0,10.14d0,10.14d0,10.13d0,10.13d0,10.13d0,10.12d0,10.12d0,
     &10.11d0,10.11d0,10.11d0,10.10d0,10.10d0,10.10d0,10.09d0,10.09d0,
     &10.09d0,10.08d0,10.08d0,10.07d0,10.07d0,10.07d0,10.06d0,10.06d0,
     &10.06d0,10.05d0,10.05d0,10.04d0,10.04d0,10.04d0,10.03d0,10.03d0,
     &10.03d0,10.02d0,10.02d0,10.02d0,10.01d0,10.01d0,10.00d0,10.00d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.98d0, 9.98d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.98d0, 9.98d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,
     & 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.98d0, 9.98d0, 9.98d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.98d0, 9.99d0, 9.99d0,10.00d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,
     &10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0,
     &10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0,
     &10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,
     & 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,
     &10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0
     &/
      DATA (Iupper ( 1,I), I= 1, 1001) /
     & 0.00010000d0, 0.00010127d0, 0.00010255d0, 0.00010386d0,
     & 0.00010517d0, 0.00010651d0, 0.00010786d0, 0.00010923d0,
     & 0.00011062d0, 0.00011202d0, 0.00011344d0, 0.00011488d0,
     & 0.00011634d0, 0.00011782d0, 0.00011931d0, 0.00012083d0,
     & 0.00012236d0, 0.00012391d0, 0.00012548d0, 0.00012708d0,
     & 0.00012869d0, 0.00013032d0, 0.00013198d0, 0.00013365d0,
     & 0.00013535d0, 0.00013707d0, 0.00013881d0, 0.00014057d0,
     & 0.00014235d0, 0.00014416d0, 0.00014599d0, 0.00014784d0,
     & 0.00014972d0, 0.00015162d0, 0.00015354d0, 0.00015549d0,
     & 0.00015746d0, 0.00015946d0, 0.00016148d0, 0.00016353d0,
     & 0.00016561d0, 0.00016771d0, 0.00016984d0, 0.00017200d0,
     & 0.00017418d0, 0.00017639d0, 0.00017863d0, 0.00018089d0,
     & 0.00018319d0, 0.00018551d0, 0.00018787d0, 0.00019025d0,
     & 0.00019267d0, 0.00019511d0, 0.00019759d0, 0.00020010d0,
     & 0.00020264d0, 0.00020521d0, 0.00020781d0, 0.00021045d0,
     & 0.00021312d0, 0.00021583d0, 0.00021857d0, 0.00022134d0,
     & 0.00022415d0, 0.00022699d0, 0.00022987d0, 0.00023279d0,
     & 0.00023575d0, 0.00023874d0, 0.00024177d0, 0.00024484d0,
     & 0.00024794d0, 0.00025109d0, 0.00025428d0, 0.00025750d0,
     & 0.00026077d0, 0.00026408d0, 0.00026743d0, 0.00027083d0,
     & 0.00027426d0, 0.00027775d0, 0.00028127d0, 0.00028484d0,
     & 0.00028846d0, 0.00029212d0, 0.00029582d0, 0.00029958d0,
     & 0.00030338d0, 0.00030723d0, 0.00031113d0, 0.00031508d0,
     & 0.00031908d0, 0.00032313d0, 0.00032723d0, 0.00033138d0,
     & 0.00033559d0, 0.00033984d0, 0.00034416d0, 0.00034853d0,
     & 0.00035295d0, 0.00035743d0, 0.00036196d0, 0.00036656d0,
     & 0.00037121d0, 0.00037592d0, 0.00038069d0, 0.00038552d0,
     & 0.00039042d0, 0.00039537d0, 0.00040039d0, 0.00040547d0,
     & 0.00041062d0, 0.00041583d0, 0.00042111d0, 0.00042645d0,
     & 0.00043186d0, 0.00043734d0, 0.00044289d0, 0.00044852d0,
     & 0.00045421d0, 0.00045997d0, 0.00046581d0, 0.00047172d0,
     & 0.00047771d0, 0.00048377d0, 0.00048991d0, 0.00049613d0,
     & 0.00050243d0, 0.00050880d0, 0.00051526d0, 0.00052180d0,
     & 0.00052842d0, 0.00053513d0, 0.00054192d0, 0.00054880d0,
     & 0.00055576d0, 0.00056281d0, 0.00056996d0, 0.00057719d0,
     & 0.00058452d0, 0.00059194d0, 0.00059945d0, 0.00060706d0,
     & 0.00061476d0, 0.00062256d0, 0.00063046d0, 0.00063846d0,
     & 0.00064657d0, 0.00065477d0, 0.00066308d0, 0.00067150d0,
     & 0.00068002d0, 0.00068865d0, 0.00069739d0, 0.00070624d0,
     & 0.00071521d0, 0.00072428d0, 0.00073347d0, 0.00074278d0,
     & 0.00075221d0, 0.00076176d0, 0.00077142d0, 0.00078122d0,
     & 0.00079113d0, 0.00080117d0, 0.00081134d0, 0.00082164d0,
     & 0.00083206d0, 0.00084262d0, 0.00085332d0, 0.00086415d0,
     & 0.00087511d0, 0.00088622d0, 0.00089747d0, 0.00090886d0,
     & 0.00092039d0, 0.00093207d0, 0.00094390d0, 0.00095588d0,
     & 0.00096801d0, 0.00098030d0, 0.00099274d0, 0.00100534d0,
     & 0.00101810d0, 0.00103102d0, 0.00104411d0, 0.00105736d0,
     & 0.00107078d0, 0.00108437d0, 0.00109813d0, 0.00111206d0,
     & 0.00112618d0, 0.00114047d0, 0.00115495d0, 0.00116960d0,
     & 0.00118445d0, 0.00119948d0, 0.00121470d0, 0.00123012d0,
     & 0.00124573d0, 0.00126154d0, 0.00127755d0, 0.00129377d0,
     & 0.00131019d0, 0.00132681d0, 0.00134365d0, 0.00136071d0,
     & 0.00137797d0, 0.00139546d0, 0.00141317d0, 0.00143111d0,
     & 0.00144927d0, 0.00146766d0, 0.00148629d0, 0.00150515d0,
     & 0.00152426d0, 0.00154360d0, 0.00156319d0, 0.00158303d0,
     & 0.00160312d0, 0.00162347d0, 0.00164407d0, 0.00166494d0,
     & 0.00168607d0, 0.00170747d0, 0.00172914d0, 0.00175108d0,
     & 0.00177331d0, 0.00179581d0, 0.00181860d0, 0.00184168d0,
     & 0.00186506d0, 0.00188873d0, 0.00191270d0, 0.00193697d0,
     & 0.00196156d0, 0.00198645d0, 0.00201166d0, 0.00203719d0,
     & 0.00206305d0, 0.00208923d0, 0.00211575d0, 0.00214260d0,
     & 0.00216979d0, 0.00219733d0, 0.00222521d0, 0.00225346d0,
     & 0.00228206d0, 0.00231102d0, 0.00234035d0, 0.00237005d0,
     & 0.00240013d0, 0.00243059d0, 0.00246144d0, 0.00249268d0,
     & 0.00252431d0, 0.00255635d0, 0.00258879d0, 0.00262165d0,
     & 0.00265492d0, 0.00268862d0, 0.00272274d0, 0.00275729d0,
     & 0.00279229d0, 0.00282773d0, 0.00286361d0, 0.00289996d0,
     & 0.00293676d0, 0.00297403d0, 0.00301178d0, 0.00305000d0,
     & 0.00308871d0, 0.00312791d0, 0.00316761d0, 0.00320781d0,
     & 0.00324852d0, 0.00328975d0, 0.00333150d0, 0.00337378d0,
     & 0.00341660d0, 0.00345996d0, 0.00350387d0, 0.00354834d0,
     & 0.00359337d0, 0.00363898d0, 0.00368516d0, 0.00373193d0,
     & 0.00377930d0, 0.00382726d0, 0.00387583d0, 0.00392502d0,
     & 0.00397484d0, 0.00402528d0, 0.00407637d0, 0.00412811d0,
     & 0.00418050d0, 0.00423355d0, 0.00428728d0, 0.00434169d0,
     & 0.00439680d0, 0.00445260d0, 0.00450911d0, 0.00456633d0,
     & 0.00462429d0, 0.00468298d0, 0.00474241d0, 0.00480260d0,
     & 0.00486355d0, 0.00492528d0, 0.00498778d0, 0.00505109d0,
     & 0.00511519d0, 0.00518011d0, 0.00524585d0, 0.00531243d0,
     & 0.00537985d0, 0.00544813d0, 0.00551727d0, 0.00558730d0,
     & 0.00565821d0, 0.00573002d0, 0.00580274d0, 0.00587639d0,
     & 0.00595096d0, 0.00602649d0, 0.00610298d0, 0.00618043d0,
     & 0.00625887d0, 0.00633830d0, 0.00641874d0, 0.00650021d0,
     & 0.00658270d0, 0.00666625d0, 0.00675085d0, 0.00683653d0,
     & 0.00692329d0, 0.00701116d0, 0.00710014d0, 0.00719025d0,
     & 0.00728151d0, 0.00737392d0, 0.00746751d0, 0.00756228d0,
     & 0.00765826d0, 0.00775545d0, 0.00785387d0, 0.00795355d0,
     & 0.00805449d0, 0.00815672d0, 0.00826024d0, 0.00836507d0,
     & 0.00847124d0, 0.00857875d0, 0.00868762d0, 0.00879788d0,
     & 0.00890954d0, 0.00902261d0, 0.00913712d0, 0.00925308d0,
     & 0.00937052d0, 0.00948945d0, 0.00960988d0, 0.00973184d0,
     & 0.00985535d0, 0.00998043d0, 0.01010710d0, 0.01023537d0,
     & 0.01036527d0, 0.01049682d0, 0.01063004d0, 0.01076495d0,
     & 0.01090157d0, 0.01103993d0, 0.01118004d0, 0.01132193d0,
     & 0.01146563d0, 0.01161114d0, 0.01175850d0, 0.01190773d0,
     & 0.01205886d0, 0.01221190d0, 0.01236688d0, 0.01252384d0,
     & 0.01268278d0, 0.01284374d0, 0.01300676d0, 0.01317183d0,
     & 0.01333899d0, 0.01350829d0, 0.01367973d0, 0.01385334d0,
     & 0.01402915d0, 0.01420721d0, 0.01438751d0, 0.01457011d0,
     & 0.01475503d0, 0.01494229d0, 0.01513193d0, 0.01532398d0,
     & 0.01551846d0, 0.01571541d0, 0.01591486d0, 0.01611684d0,
     & 0.01632139d0, 0.01652853d0, 0.01673830d0, 0.01695073d0,
     & 0.01716586d0, 0.01738372d0, 0.01760434d0, 0.01782776d0,
     & 0.01805403d0, 0.01828315d0, 0.01851519d0, 0.01875018d0,
     & 0.01898814d0, 0.01922913d0, 0.01947318d0, 0.01972032d0,
     & 0.01997059d0, 0.02022405d0, 0.02048072d0, 0.02074065d0,
     & 0.02100387d0, 0.02127045d0, 0.02154040d0, 0.02181377d0,
     & 0.02209063d0, 0.02237098d0, 0.02265490d0, 0.02294243d0,
     & 0.02323360d0, 0.02352846d0, 0.02382708d0, 0.02412947d0,
     & 0.02443570d0, 0.02474584d0, 0.02505989d0, 0.02537793d0,
     & 0.02570002d0, 0.02602619d0, 0.02635649d0, 0.02669099d0,
     & 0.02702975d0, 0.02737279d0, 0.02772018d0, 0.02807200d0,
     & 0.02842827d0, 0.02878906d0, 0.02915444d0, 0.02952445d0,
     & 0.02989915d0, 0.03027862d0, 0.03066289d0, 0.03105204d0,
     & 0.03144613d0, 0.03184524d0, 0.03224939d0, 0.03265868d0,
     & 0.03307318d0, 0.03349292d0, 0.03391798d0, 0.03434846d0,
     & 0.03478439d0, 0.03522584d0, 0.03567292d0, 0.03612565d0,
     & 0.03658413d0, 0.03704845d0, 0.03751864d0, 0.03799480d0,
     & 0.03847702d0, 0.03896534d0, 0.03945986d0, 0.03996065d0,
     & 0.04046782d0, 0.04098141d0, 0.04150151d0, 0.04202824d0,
     & 0.04256163d0, 0.04310180d0, 0.04364883d0, 0.04420279d0,
     & 0.04476377d0, 0.04533191d0, 0.04590723d0, 0.04648984d0,
     & 0.04707986d0, 0.04767738d0, 0.04828247d0, 0.04889523d0,
     & 0.04951580d0, 0.05014421d0, 0.05078061d0, 0.05142510d0,
     & 0.05207775d0, 0.05273868d0, 0.05340803d0, 0.05408584d0,
     & 0.05477226d0, 0.05546741d0, 0.05617137d0, 0.05688425d0,
     & 0.05760621d0, 0.05833730d0, 0.05907768d0, 0.05982745d0,
     & 0.06058676d0, 0.06135568d0, 0.06213436d0, 0.06292295d0,
     & 0.06372152d0, 0.06453023d0, 0.06534923d0, 0.06617859d0,
     & 0.06701849d0, 0.06786907d0, 0.06873041d0, 0.06960268d0,
     & 0.07048602d0, 0.07138062d0, 0.07228653d0, 0.07320394d0,
     & 0.07413302d0, 0.07507385d0, 0.07602664d0, 0.07699155d0,
     & 0.07796867d0, 0.07895819d0, 0.07996030d0, 0.08097509d0,
     & 0.08200277d0, 0.08304353d0, 0.08409746d0, 0.08516476d0,
     & 0.08624565d0, 0.08734021d0, 0.08844867d0, 0.08957119d0,
     & 0.09070800d0, 0.09185920d0, 0.09302501d0, 0.09420566d0,
     & 0.09540125d0, 0.09661201d0, 0.09783818d0, 0.09907987d0,
     & 0.10033731d0, 0.10161077d0, 0.10290034d0, 0.10420627d0,
     & 0.10552878d0, 0.10686813d0, 0.10822441d0, 0.10959791d0,
     & 0.11098890d0, 0.11239749d0, 0.11382396d0, 0.11526857d0,
     & 0.11673148d0, 0.11821295d0, 0.11971328d0, 0.12123259d0,
     & 0.12277117d0, 0.12432936d0, 0.12590724d0, 0.12750517d0,
     & 0.12912343d0, 0.13076216d0, 0.13242172d0, 0.13410230d0,
     & 0.13580430d0, 0.13752782d0, 0.13927321d0, 0.14104085d0,
     & 0.14283082d0, 0.14464353d0, 0.14647931d0, 0.14833830d0,
     & 0.15022090d0, 0.15212746d0, 0.15405814d0, 0.15601335d0,
     & 0.15799335d0, 0.15999855d0, 0.16202913d0, 0.16408549d0,
     & 0.16616802d0, 0.16827691d0, 0.17041254d0, 0.17257537d0,
     & 0.17476557d0, 0.17698357d0, 0.17922980d0, 0.18150444d0,
     & 0.18380795d0, 0.18614081d0, 0.18850316d0, 0.19089550d0,
     & 0.19331829d0, 0.19577175d0, 0.19825633d0, 0.20077245d0,
     & 0.20332061d0, 0.20590100d0, 0.20851412d0, 0.21116054d0,
     & 0.21384043d0, 0.21655434d0, 0.21930277d0, 0.22208601d0,
     & 0.22490457d0, 0.22775897d0, 0.23064953d0, 0.23357674d0,
     & 0.23654114d0, 0.23954326d0, 0.24258336d0, 0.24566205d0,
     & 0.24877992d0, 0.25193724d0, 0.25513467d0, 0.25837275d0,
     & 0.26165181d0, 0.26497251d0, 0.26833546d0, 0.27174097d0,
     & 0.27518973d0, 0.27868235d0, 0.28221917d0, 0.28580090d0,
     & 0.28942820d0, 0.29310140d0, 0.29682124d0, 0.30058825d0,
     & 0.30440310d0, 0.30826664d0, 0.31217894d0, 0.31614089d0,
     & 0.32015309d0, 0.32421625d0, 0.32833093d0, 0.33249786d0,
     & 0.33671802d0, 0.34099138d0, 0.34531897d0, 0.34970152d0,
     & 0.35413966d0, 0.35863414d0, 0.36318600d0, 0.36779529d0,
     & 0.37246308d0, 0.37719008d0, 0.38197711d0, 0.38682488d0,
     & 0.39173418d0, 0.39670613d0, 0.40174085d0, 0.40683943d0,
     & 0.41200271d0, 0.41723153d0, 0.42252675d0, 0.42788953d0,
     & 0.43332002d0, 0.43881938d0, 0.44438851d0, 0.45002836d0,
     & 0.45573980d0, 0.46152416d0, 0.46738148d0, 0.47331312d0,
     & 0.47932005d0, 0.48540321d0, 0.49156362d0, 0.49780214d0,
     & 0.50412035d0, 0.51051831d0, 0.51699740d0, 0.52355874d0,
     & 0.53020334d0, 0.53693229d0, 0.54374713d0, 0.55064797d0,
     & 0.55763638d0, 0.56471354d0, 0.57188040d0, 0.57913828d0,
     & 0.58648884d0, 0.59393209d0, 0.60146987d0, 0.60910326d0,
     & 0.61683351d0, 0.62466192d0, 0.63258964d0, 0.64061862d0,
     & 0.64874887d0, 0.65698230d0, 0.66532022d0, 0.67376393d0,
     & 0.68231487d0, 0.69097501d0, 0.69974434d0, 0.70862496d0,
     & 0.71761823d0, 0.72672570d0, 0.73594880d0, 0.74528891d0,
     & 0.75474828d0, 0.76432699d0, 0.77402723d0, 0.78385061d0,
     & 0.79379863d0, 0.80387294d0, 0.81407589d0, 0.82440752d0,
     & 0.83487028d0, 0.84546578d0, 0.85619581d0, 0.86706197d0,
     & 0.87806606d0, 0.88921070d0, 0.90049589d0, 0.91192430d0,
     & 0.92349786d0, 0.93521816d0, 0.94708717d0, 0.95910788d0,
     & 0.97128016d0, 0.98360693d0, 0.99609011d0, 1.00873172d0,
     & 1.02153373d0, 1.03449929d0, 1.04762840d0, 1.06092405d0,
     & 1.07438850d0, 1.08802390d0, 1.10183227d0, 1.11581588d0,
     & 1.12997806d0, 1.14431894d0, 1.15884173d0, 1.17354894d0,
     & 1.18844259d0, 1.20352542d0, 1.21880090d0, 1.23426902d0,
     & 1.24993336d0, 1.26579666d0, 1.28186119d0, 1.29812956d0,
     & 1.31460571d0, 1.33128977d0, 1.34818542d0, 1.36529553d0,
     & 1.38262296d0, 1.40017009d0, 1.41794002d0, 1.43593681d0,
     & 1.45416057d0, 1.47261584d0, 1.49130499d0, 1.51023161d0,
     & 1.52939832d0, 1.54880977d0, 1.56846607d0, 1.58837199d0,
     & 1.60853028d0, 1.62894464d0, 1.64961791d0, 1.67055368d0,
     & 1.69175661d0, 1.71322715d0, 1.73497009d0, 1.75698900d0,
     & 1.77928746d0, 1.80186892d0, 1.82473862d0, 1.84789681d0,
     & 1.87134874d0, 1.89509857d0, 1.91914976d0, 1.94350624d0,
     & 1.96817160d0, 1.99315214d0, 2.01844788d0, 2.04406428d0,
     & 2.07000613d0, 2.09627700d0, 2.12288141d0, 2.14982557d0,
     & 2.17710948d0, 2.20473981d0, 2.23272061d0, 2.26105666d0,
     & 2.28975224d0, 2.31881428d0, 2.34824300d0, 2.37804508d0,
     & 2.40822554d0, 2.43878889d0, 2.46974015d0, 2.50108409d0,
     & 2.53282857d0, 2.56497312d0, 2.59752584d0, 2.63049173d0,
     & 2.66387582d0, 2.69768381d0, 2.73192358d0, 2.76659513d0,
     & 2.80170655d0, 2.83726382d0, 2.87327218d0, 2.90973759d0,
     & 2.94666839d0, 2.98406553d0, 3.02193713d0, 3.06028914d0,
     & 3.09912801d0, 3.13845992d0, 3.17829084d0, 3.21863031d0,
     & 3.25947881d0, 3.30084562d0, 3.34273744d0, 3.38516092d0,
     & 3.42812300d0, 3.47163343d0, 3.51569295d0, 3.56031132d0,
     & 3.60549593d0, 3.65125418d0, 3.69759321d0, 3.74452019d0,
     & 3.79204679d0, 3.84017253d0, 3.88890886d0, 3.93826389d0,
     & 3.98824549d0, 4.03886127d0, 4.09012318d0, 4.14203215d0,
     & 4.19460011d0, 4.24783468d0, 4.30174494d0, 4.35633945d0,
     & 4.41162682d0, 4.46762037d0, 4.52431965d0, 4.58173895d0,
     & 4.63988686d0, 4.69877291d0, 4.75840616d0, 4.81880093d0,
     & 4.87995768d0, 4.94189024d0, 5.00460863d0, 5.06812382d0,
     & 5.13244438d0, 5.19758654d0, 5.26355076d0, 5.33035135d0,
     & 5.39800024d0, 5.46650791d0, 5.53588486d0, 5.60614157d0,
     & 5.67729616d0, 5.74934816d0, 5.82231474d0, 5.89620686d0,
     & 5.97103739d0, 6.04681683d0, 6.12356472d0, 6.20128012d0,
     & 6.27998209d0, 6.35968304d0, 6.44039536d0, 6.52213240d0,
     & 6.60491228d0, 6.68873739d0, 6.77362537d0, 6.85959101d0,
     & 6.94664812d0, 7.03480911d0, 7.12408972d0, 7.21451092d0,
     & 7.30607176d0, 7.39879513d0, 7.49269533d0, 7.58778667d0,
     & 7.68408489d0, 7.78161287d0, 7.88037157d0, 7.98038340d0,
     & 8.08166409d0, 8.18422985d0, 8.28809834d0, 8.39328480d0,
     & 8.49981499d0, 8.60768700d0, 8.71692944d0, 8.82755852d0,
     & 8.93959141d0, 9.05304623d0, 9.16794872d0, 9.28430176d0,
     & 9.40213108d0, 9.52145576d0, 9.64229488d0, 9.76466751d0,
     & 9.88859367d0,10.01410198d0,10.14119339d0,10.26989746d0,
     &10.40023613d0,10.53222752d0,10.66589451d0,10.80126858d0,
     &10.93834972d0,11.07717133d0,11.21775436d0,11.36012173d0,
     &11.50429535d0,11.65031052d0,11.79816723d0,11.94790173d0,
     &12.09953499d0,12.25309372d0,12.40860081d0,12.56608105d0,
     &12.72557259d0,12.88707542d0,13.05062866d0,13.21625710d0,
     &13.38398838d0,13.55384827d0,13.72587585d0,13.90007496d0,
     &14.07648373d0,14.25513268d0,14.43604851d0,14.61925888d0,
     &14.80481052d0,14.99270153d0,15.18297768d0,15.37566853d0,
     &15.57080460d0,15.76841831d0,15.96853828d0,16.17121506d0,
     &16.37644768d0,16.58428574d0,16.79475975d0,17.00790787d0,
     &17.22375870d0,17.44236755d0,17.66373062d0,17.88790512d0,
     &18.11492538d0,18.34482765d0,18.57764626d0,18.81341934d0,
     &19.05220222d0,19.29399872d0,19.53886604d0,19.78683662d0,
     &20.03795815d0,20.29226303d0,20.54981613d0,20.81061935d0,
     &21.07473183d0,21.34219742d0,21.61305809d0,21.88735199d0,
     &22.16513062d0,22.44645500d0,22.73132896d0,23.01981735d0,
     &23.31196785d0,23.60782623d0,23.90743828d0,24.21087837d0,
     &24.51814270d0,24.82930946d0,25.14442444d0,25.46353912d0,
     &25.78670311d0,26.11399269d0,26.44541168d0,26.78103638d0,
     &27.12092209d0,27.46512032d0,27.81368637d0,28.16667747d0,
     &28.52417374d0,28.88618279d0,29.25278282d0,29.62404060d0,
     &30.00000572d0
     &/
c Definition of fits (4 deg polynomial) for doy=001
c A0=f(Lm) same for A1,A2,A3 and A4; to be used every where except Lm>7.5 and I> 1.
      DATA (Lm4 ( 1,I), I= 1,100) /
     & 1.10d0, 1.20d0, 1.30d0, 1.40d0, 1.50d0, 1.60d0, 1.70d0, 1.80d0,
     & 1.90d0, 2.00d0, 2.10d0, 2.20d0, 2.30d0, 2.40d0, 2.50d0, 2.60d0,
     & 2.70d0, 2.80d0, 2.90d0, 3.00d0, 3.10d0, 3.20d0, 3.30d0, 3.40d0,
     & 3.50d0, 3.60d0, 3.70d0, 3.80d0, 3.90d0, 4.00d0, 4.10d0, 4.20d0,
     & 4.30d0, 4.40d0, 4.50d0, 4.60d0, 4.70d0, 4.80d0, 4.90d0, 5.00d0,
     & 5.10d0, 5.20d0, 5.30d0, 5.40d0, 5.50d0, 5.60d0, 5.70d0, 5.80d0,
     & 5.90d0, 6.00d0, 6.10d0, 6.20d0, 6.30d0, 6.40d0, 6.50d0, 6.60d0,
     & 6.70d0, 6.80d0, 6.90d0, 7.00d0, 7.10d0, 7.20d0, 7.30d0, 7.40d0,
     & 7.50d0, 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0,
     & 8.30d0, 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0,
     & 9.10d0, 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0,
     & 9.90d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A0 ( 1,I), I= 1,100) /
     & 1.1011524850D+00, 1.2015148527D+00, 1.3020358384D+00,
     & 1.4015865057D+00, 1.5011925495D+00, 1.6003224287D+00,
     & 1.7005402678D+00, 1.8005317750D+00, 1.8990717388D+00,
     & 2.0005849257D+00, 2.0983966161D+00, 2.1999274234D+00,
     & 2.2971872681D+00, 2.3955219781D+00, 2.4882677992D+00,
     & 2.5878019495D+00, 2.6810948702D+00, 2.7754704208D+00,
     & 2.8707954387D+00, 2.9625465486D+00, 3.0564599929D+00,
     & 3.1459991077D+00, 3.2375478906D+00, 3.3267023877D+00,
     & 3.4173184499D+00, 3.5049181949D+00, 3.5954881941D+00,
     & 3.6817905534D+00, 3.7699931228D+00, 3.8556081003D+00,
     & 3.9413416359D+00, 4.0249131653D+00, 4.1103553151D+00,
     & 4.1928844814D+00, 4.2781017744D+00, 4.3577134600D+00,
     & 4.4377379523D+00, 4.5235707694D+00, 4.6035953158D+00,
     & 4.6871956286D+00, 4.7665055486D+00, 4.8459891897D+00,
     & 4.9264189689D+00, 5.0061958875D+00, 5.0908312033D+00,
     & 5.1675966882D+00, 5.2464413336D+00, 5.3275398567D+00,
     & 5.4071479724D+00, 5.4877552628D+00, 5.5682981493D+00,
     & 5.6484459058D+00, 5.7296493034D+00, 5.8107603906D+00,
     & 5.8916575115D+00, 5.9734346171D+00, 6.0564055005D+00,
     & 6.1353388275D+00, 6.2196831159D+00, 6.3010471134D+00,
     & 6.3818859736D+00, 6.4642384971D+00, 6.5484644425D+00,
     & 6.6320492360D+00, 6.7160278006D+00, 6.7931485401D+00,
     & 6.8779407220D+00, 6.9740043650D+00, 7.0594863121D+00,
     & 7.1447823649D+00, 7.2325627573D+00, 7.3235811455D+00,
     & 7.4204625975D+00, 7.5124588895D+00, 7.6133919018D+00,
     & 7.7192173185D+00, 7.8168206302D+00, 7.9286175748D+00,
     & 8.0319034915D+00, 8.1805266054D+00, 8.2992896284D+00,
     & 8.4144830412D+00, 8.5435488624D+00, 8.6785036708D+00,
     & 8.8120803882D+00, 8.9618620911D+00, 9.0866170476D+00,
     & 9.2218736885D+00, 9.3455572570D+00,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A1 ( 1,I), I= 1,100) /
     &-5.9922282754D-05, 1.6321632991D-04, 3.8798025512D-04,
     & 3.8358336225D-04, 4.6416661537D-04, 2.6428715781D-04,
     & 1.0161608517D-04, 2.6051432238D-04, 1.6563744366D-04,
     &-4.2347947284D-05, 6.2382838469D-04, 5.7702658130D-03,
     & 2.1418086640D-03, 4.5147126954D-03, 5.5635549755D-03,
     & 7.0462706606D-03, 6.9099248156D-03, 9.6490900010D-03,
     & 9.9370364265D-03, 1.0389702143D-02, 1.3472395367D-02,
     & 1.3431500234D-02, 1.4082820597D-02, 1.8708234550D-02,
     & 1.7599122962D-02, 1.9356409073D-02, 2.1711294899D-02,
     & 2.3020334601D-02, 2.3206766254D-02, 2.4053183443D-02,
     & 2.5631224110D-02, 2.6437232173D-02, 2.7829412552D-02,
     & 2.9378203488D-02, 3.0264272547D-02, 3.2003052442D-02,
     & 3.3776683076D-02, 3.1945867771D-02, 3.4842945613D-02,
     & 3.2607808884D-02, 3.4426220520D-02, 3.5436648231D-02,
     & 3.5093578320D-02, 3.6940100458D-02, 3.5596746833D-02,
     & 3.5658779842D-02, 3.5482492972D-02, 3.6095477516D-02,
     & 3.6122384789D-02, 3.6713135180D-02, 3.5186498436D-02,
     & 3.3916983181D-02, 3.3919675919D-02, 3.4801801848D-02,
     & 3.3105551093D-02, 3.0470663559D-02, 3.0271610777D-02,
     & 2.9496053542D-02, 2.9280416933D-02, 3.0121982454D-02,
     & 2.9155546950D-02, 2.7223500192D-02, 2.5815988368D-02,
     & 2.4654002909D-02, 2.4342063322D-02, 1.9708142339D-02,
     & 2.1629142228D-02, 4.2236831377D-02, 4.2349977102D-02,
     & 2.4459971956D-02, 2.8445595846D-02, 2.5201489535D-02,
     & 2.7697083917D-02, 2.7764302964D-02, 3.4523673575D-02,
     & 3.2632422726D-02, 1.7961628029D-02, 4.2905950601D-02,
     & 1.2408352052D-02, 5.6937613807D-02, 5.5221829138D-02,
     & 3.6814630115D-02, 3.5924968549D-02, 4.3388214851D-02,
     & 4.9866751916D-02, 8.3543323205D-02, 7.2573868616D-02,
     & 9.3127894500D-02, 1.0150366105D-01,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A2 ( 1,I), I= 1,100) /
     & 5.6370691656D-07,-8.9440932483D-06, 1.0152739025D-05,
     & 1.8159074290D-05, 1.9488679956D-05, 8.3026511500D-06,
     &-2.6486201901D-05, 6.4053653495D-06,-6.0002614454D-06,
     &-2.5141401658D-04, 4.4357591817D-06, 2.2832543912D-03,
     &-6.6724965521D-05, 4.4182227068D-04, 7.9821692168D-04,
     & 9.5239400908D-04, 1.2350719192D-03, 2.2221354653D-03,
     & 1.7003475449D-03, 2.3203045331D-03, 2.4915723570D-03,
     & 3.2340242489D-03, 2.8899617413D-03, 4.7705612635D-03,
     & 3.9911335916D-03, 4.4108954330D-03, 5.2312830574D-03,
     & 5.1940567826D-03, 4.7673977630D-03, 6.0938891607D-03,
     & 6.5121702296D-03, 6.5834905194D-03, 6.3937468182D-03,
     & 7.1088611570D-03, 7.1503697123D-03, 7.1502194549D-03,
     & 8.6619968189D-03, 8.5348560051D-03, 7.8484116895D-03,
     & 7.9883417890D-03, 8.2088288998D-03, 9.1550328873D-03,
     & 9.0264159190D-03, 8.9111855833D-03, 8.5012133413D-03,
     & 8.2553889848D-03, 8.0515193863D-03, 7.5139870398D-03,
     & 7.8766956959D-03, 7.7930170097D-03, 7.2751065197D-03,
     & 7.7151724253D-03, 7.6206213881D-03, 7.0173019803D-03,
     & 6.5729245241D-03, 6.5838787430D-03, 5.0190705782D-03,
     & 6.2383697319D-03, 4.5351481099D-03, 4.1989676875D-03,
     & 3.8064996943D-03, 3.8560878932D-03, 2.7371712232D-03,
     & 2.4514241419D-03, 1.6725758070D-03, 2.7905474628D-03,
     & 2.7362603766D-03, 1.2475824964D-02, 1.3771707719D-02,
     & 3.4315990970D-03, 8.8426296006D-03, 4.9735360652D-03,
     & 7.1258638917D-03, 6.9303808057D-03, 9.4973720995D-03,
     & 6.8196748339D-03, 2.1200361494D-03, 1.3442378341D-02,
     & 3.7806049625D-05, 1.9712492828D-02, 1.7352465649D-02,
     & 9.3024654601D-03, 9.0117303732D-03, 8.0097681069D-03,
     & 1.0884066390D-02, 2.4361430279D-02, 1.6492630930D-02,
     & 2.4207022290D-02, 2.7836099658D-02,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A3 ( 1,I), I= 1,100) /
     & 3.1009814556D-07,-5.6001459093D-07,-2.7339483458D-06,
     &-3.8859414054D-06,-4.8813169342D-06,-2.6466474993D-06,
     &-7.5342468725D-07,-2.3707872101D-06,-1.0983460573D-06,
     &-4.9593047002D-05,-7.6730905681D-06, 3.5459674286D-04,
     &-6.6835709925D-05,-2.2255695768D-05, 1.6943404294D-05,
     & 4.2588771728D-06, 8.1433327845D-05, 2.1192823974D-04,
     & 1.0040657293D-04, 2.2503404924D-04, 1.4329479827D-04,
     & 3.3681032685D-04, 2.3036562670D-04, 4.9848232914D-04,
     & 3.7063714862D-04, 4.1677363241D-04, 5.2575579902D-04,
     & 4.8436637143D-04, 3.8347163973D-04, 6.5298187907D-04,
     & 7.0571056197D-04, 6.6586662586D-04, 6.0719860730D-04,
     & 7.3083686871D-04, 7.1051400682D-04, 6.4807421876D-04,
     & 9.1272535480D-04, 9.8836207471D-04, 7.0873845193D-04,
     & 8.5245810668D-04, 8.2124154903D-04, 1.0093152031D-03,
     & 9.8609338205D-04, 8.9054990264D-04, 8.2227012172D-04,
     & 7.6696737483D-04, 7.4650712099D-04, 6.1558596707D-04,
     & 6.6021194418D-04, 6.3297973516D-04, 5.9189748925D-04,
     & 7.1431702697D-04, 6.6245628879D-04, 4.9119310535D-04,
     & 4.5755847988D-04, 5.5678374423D-04, 2.5120247436D-04,
     & 4.7282641206D-04, 1.2154491425D-04, 5.1288818692D-05,
     &-7.4627208043D-05, 1.5085264690D-05,-1.1297521487D-04,
     &-2.9380419062D-04,-5.0250271037D-04, 1.1545739774D-04,
     & 4.4575422384D-06, 1.4989528375D-03, 1.8474205340D-03,
     & 1.1861438560D-04, 1.1971906814D-03, 4.2399207642D-04,
     & 7.2947033231D-04, 8.2106063607D-04, 1.1956834146D-03,
     & 5.4136309557D-04, 1.7133039579D-04, 1.6745278410D-03,
     &-2.2420853924D-04, 2.8558073005D-03, 2.3346834092D-03,
     & 1.1498303713D-03, 1.1928863590D-03, 7.0303116449D-04,
     & 1.0085828639D-03, 3.0990351636D-03, 1.7017796623D-03,
     & 2.7494978332D-03, 3.2849952668D-03,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A4 ( 1,I), I= 1,100) /
     &-3.7036159298D-08, 1.2448589807D-07,-1.4107727786D-07,
     &-3.4873108362D-07,-3.8309169342D-07,-2.2666360528D-07,
     & 2.8464065912D-07,-1.8896790870D-07, 5.0292959840D-09,
     &-2.7698676662D-06,-4.1456917510D-07, 1.8485728571D-05,
     &-4.7249546374D-06,-3.4775635112D-06,-2.2624078935D-06,
     &-3.9164836498D-06, 1.2774708739D-06, 7.1831745862D-06,
     & 9.2062040402D-07, 7.7008719812D-06,-7.4315511826D-08,
     & 1.2973097363D-05, 5.7344199815D-06, 1.7973049448D-05,
     & 1.1801951778D-05, 1.3560352826D-05, 1.8471659060D-05,
     & 1.5708222937D-05, 9.6009119758D-06, 2.4843406957D-05,
     & 2.7652433184D-05, 2.3581392038D-05, 1.9783694882D-05,
     & 2.6923301274D-05, 2.5345872252D-05, 1.9898633311D-05,
     & 3.3736573153D-05, 4.1489572361D-05, 2.1170433081D-05,
     & 3.3304592847D-05, 2.9079383382D-05, 4.0120206602D-05,
     & 3.8855137849D-05, 3.1264137673D-05, 2.7086432730D-05,
     & 2.3678538436D-05, 2.3467812351D-05, 1.5798106707D-05,
     & 1.6996643550D-05, 1.5383820188D-05, 1.5220294557D-05,
     & 2.1542034488D-05, 1.7851053366D-05, 6.6250390909D-06,
     & 6.3656192015D-06, 1.4904462723D-05,-1.6179269909D-06,
     & 9.0357874154D-06,-1.0637056419D-05,-1.4344355224D-05,
     &-2.4329370727D-05,-1.6908787625D-05,-1.9786075052D-05,
     &-3.7562781399D-05,-5.1179222791D-05,-1.3265397324D-06,
     &-1.1381363471D-05, 6.2617065013D-05, 8.6711828670D-05,
     &-3.9485138649D-06, 5.7423037802D-05, 1.2960186249D-05,
     & 2.5824789359D-05, 3.7560418105D-05, 5.4066982373D-05,
     & 1.2343079614D-05, 9.4716800207D-06, 7.2555044731D-05,
     &-1.4333131293D-05, 1.4229950807D-04, 1.1244769560D-04,
     & 5.4333332819D-05, 5.8975520860D-05, 2.7188728903D-05,
     & 3.3192688669D-05, 1.4028478307D-04, 6.7997922553D-05,
     & 1.1298974447D-04, 1.3967385235D-04,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of fits (5 deg polynomial) for doy=001
c A50=f(Lm5) same for A51,A52,A53, A54 and A55
c To be used only where Lm>7.5 and I> 1.
      DATA (Lm5 ( 1,I), I= 1,100) /
     & 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0, 8.30d0,
     & 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0, 9.10d0,
     & 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0, 9.90d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A50 ( 1,I), I= 1,100) /
     & 6.7972398689D+00, 6.8842835994D+00, 6.9725234686D+00,
     & 7.0568985133D+00, 7.1447066002D+00, 7.2345097221D+00,
     & 7.3295262369D+00, 7.4205062325D+00, 7.5137554468D+00,
     & 7.6113505609D+00, 7.7104121096D+00, 7.8214480899D+00,
     & 7.9303098403D+00, 8.0378954421D+00, 8.1728305484D+00,
     & 8.2891811428D+00, 8.4128458463D+00, 8.5393686072D+00,
     & 8.6737600728D+00, 8.8063581344D+00, 8.9463871699D+00,
     & 9.0820796147D+00, 9.2156341162D+00, 9.3375538139D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A51 ( 1,I), I= 1,100) /
     & 1.7815392967D-02, 3.3601366418D-02, 3.9031677561D-03,
     & 2.5293847523D-02, 2.4049418814D-02, 6.0162096049D-02,
     & 3.6135298864D-03, 1.8579789672D-03, 3.1346515039D-02,
     & 3.7748034523D-03, 2.1283528505D-02, 1.0403851861D-02,
     & 2.2177342812D-02, 6.9757652060D-02, 2.2363709142D-03,
     & 5.9418039956D-02, 3.1191794740D-02, 8.5603420632D-02,
     & 9.3339532732D-02, 1.3998217919D-01, 7.9020031154D-02,
     & 8.4616491889D-02, 1.1008467134D-02,-5.7979465534D-04,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A52 ( 1,I), I= 1,100) /
     & 9.7740205979D-02, 4.0441911390D-02, 9.5631804828D-02,
     & 4.3475737991D-02, 4.2819564774D-02,-6.4037188898D-02,
     & 6.5648695207D-02, 7.6198562701D-02, 6.1167210007D-03,
     & 6.4286410980D-02,-2.4306522001D-02,-1.9781432808D-02,
     &-8.0448986338D-02,-1.7060222258D-01,-8.5333766842D-02,
     &-1.9219671880D-01,-8.3692985418D-02,-1.8936494452D-01,
     &-1.4700647866D-01,-1.4776525475D-01, 6.2839108752D-02,
     & 1.5434851142D-01, 4.2932606086D-01, 6.2048822927D-01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A53 ( 1,I), I= 1,100) /
     &-1.0738371517D-01,-5.0471175360D-02,-9.1192835971D-02,
     &-4.6994175412D-02,-4.1474150830D-02, 6.2645893344D-02,
     &-6.1699123384D-02,-7.6082052853D-02,-2.3665322131D-02,
     &-7.7278891333D-02, 2.4453779990D-02, 3.2550612019D-03,
     & 6.3400753260D-02, 1.0741025994D-01, 4.1865822784D-02,
     & 9.7864475586D-02,-3.8464085622D-02, 2.9400424905D-02,
     &-6.1854980034D-02,-1.3449592377D-01,-3.4116802692D-01,
     &-4.7214214099D-01,-7.4247214368D-01,-9.5610481013D-01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A54 ( 1,I), I= 1,100) /
     & 3.9459769546D-02, 1.6908830649D-02, 2.9771969156D-02,
     & 1.3188293169D-02, 7.6250198066D-03,-3.6015988362D-02,
     & 1.4893737736D-02, 1.9752736065D-02, 2.4334877591D-03,
     & 2.2183157154D-02,-2.4145020829D-02,-9.5948304639D-03,
     &-3.5797635699D-02,-4.2433601785D-02,-2.1393161178D-02,
     &-3.3441466903D-02, 2.4920790069D-02, 1.3471652365D-03,
     & 4.5348560358D-02, 8.5055686043D-02, 1.5638867803D-01,
     & 2.0943018773D-01, 3.0637608017D-01, 3.8387541153D-01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A55 ( 1,I), I= 1,100) /
     &-4.8180085407D-03,-1.7738535117D-03,-3.3205651589D-03,
     &-1.0547685307D-03, 2.2450420405D-04, 6.7488883079D-03,
     &-7.4370983466D-04,-1.1758518132D-03, 8.8458135032D-04,
     &-1.6722974860D-03, 5.5159867134D-03, 2.7477574915D-03,
     & 6.8062307015D-03, 6.6723238706D-03, 4.4064824989D-03,
     & 5.2151942833D-03,-2.9929896577D-03, 3.7238291224D-04,
     &-6.1160483088D-03,-1.2078900678D-02,-2.0181818743D-02,
     &-2.7069691655D-02,-3.8891448638D-02,-4.8123660342D-02,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of Loss cone as Lmax=f(Imax) for doy=031
      DATA (Lmax ( 2,I), I= 1, 2100) /
     & 1.0843d0, 1.0853d0, 1.0863d0, 1.0873d0, 1.0883d0, 1.0893d0,
     & 1.0903d0, 1.0913d0, 1.0923d0, 1.0932d0, 1.0942d0, 1.0952d0,
     & 1.0962d0, 1.0972d0, 1.0982d0, 1.0992d0, 1.1002d0, 1.1012d0,
     & 1.1023d0, 1.1033d0, 1.1043d0, 1.1053d0, 1.1063d0, 1.1073d0,
     & 1.1083d0, 1.1094d0, 1.1104d0, 1.1114d0, 1.1124d0, 1.1135d0,
     & 1.1145d0, 1.1155d0, 1.1165d0, 1.1175d0, 1.1186d0, 1.1196d0,
     & 1.1206d0, 1.1216d0, 1.1227d0, 1.1237d0, 1.1247d0, 1.1257d0,
     & 1.1267d0, 1.1278d0, 1.1288d0, 1.1298d0, 1.1308d0, 1.1319d0,
     & 1.1329d0, 1.1339d0, 1.1349d0, 1.1360d0, 1.1370d0, 1.1380d0,
     & 1.1391d0, 1.1401d0, 1.1411d0, 1.1421d0, 1.1432d0, 1.1442d0,
     & 1.1452d0, 1.1462d0, 1.1473d0, 1.1483d0, 1.1493d0, 1.1503d0,
     & 1.1514d0, 1.1524d0, 1.1534d0, 1.1544d0, 1.1555d0, 1.1565d0,
     & 1.1575d0, 1.1586d0, 1.1596d0, 1.1606d0, 1.1616d0, 1.1627d0,
     & 1.1637d0, 1.1647d0, 1.1657d0, 1.1667d0, 1.1678d0, 1.1688d0,
     & 1.1698d0, 1.1709d0, 1.1719d0, 1.1729d0, 1.1739d0, 1.1750d0,
     & 1.1760d0, 1.1770d0, 1.1780d0, 1.1790d0, 1.1801d0, 1.1811d0,
     & 1.1821d0, 1.1832d0, 1.1842d0, 1.1852d0, 1.1862d0, 1.1872d0,
     & 1.1883d0, 1.1893d0, 1.1903d0, 1.1914d0, 1.1924d0, 1.1934d0,
     & 1.1944d0, 1.1954d0, 1.1965d0, 1.1975d0, 1.1985d0, 1.1996d0,
     & 1.2006d0, 1.2016d0, 1.2026d0, 1.2036d0, 1.2047d0, 1.2057d0,
     & 1.2067d0, 1.2077d0, 1.2088d0, 1.2098d0, 1.2108d0, 1.2118d0,
     & 1.2129d0, 1.2139d0, 1.2149d0, 1.2159d0, 1.2169d0, 1.2179d0,
     & 1.2190d0, 1.2200d0, 1.2211d0, 1.2221d0, 1.2231d0, 1.2241d0,
     & 1.2251d0, 1.2261d0, 1.2272d0, 1.2282d0, 1.2292d0, 1.2303d0,
     & 1.2313d0, 1.2323d0, 1.2333d0, 1.2343d0, 1.2353d0, 1.2364d0,
     & 1.2374d0, 1.2384d0, 1.2395d0, 1.2405d0, 1.2415d0, 1.2425d0,
     & 1.2435d0, 1.2445d0, 1.2456d0, 1.2466d0, 1.2476d0, 1.2486d0,
     & 1.2497d0, 1.2507d0, 1.2517d0, 1.2527d0, 1.2537d0, 1.2547d0,
     & 1.2558d0, 1.2568d0, 1.2578d0, 1.2588d0, 1.2599d0, 1.2609d0,
     & 1.2619d0, 1.2629d0, 1.2639d0, 1.2650d0, 1.2660d0, 1.2670d0,
     & 1.2680d0, 1.2690d0, 1.2701d0, 1.2711d0, 1.2721d0, 1.2731d0,
     & 1.2741d0, 1.2752d0, 1.2762d0, 1.2772d0, 1.2782d0, 1.2792d0,
     & 1.2802d0, 1.2813d0, 1.2823d0, 1.2833d0, 1.2843d0, 1.2853d0,
     & 1.2864d0, 1.2874d0, 1.2884d0, 1.2894d0, 1.2904d0, 1.2914d0,
     & 1.2925d0, 1.2935d0, 1.2945d0, 1.2955d0, 1.2965d0, 1.2976d0,
     & 1.2986d0, 1.2996d0, 1.3006d0, 1.3016d0, 1.3026d0, 1.3037d0,
     & 1.3047d0, 1.3057d0, 1.3067d0, 1.3077d0, 1.3088d0, 1.3098d0,
     & 1.3108d0, 1.3118d0, 1.3128d0, 1.3138d0, 1.3149d0, 1.3159d0,
     & 1.3169d0, 1.3179d0, 1.3189d0, 1.3199d0, 1.3210d0, 1.3220d0,
     & 1.3230d0, 1.3240d0, 1.3250d0, 1.3260d0, 1.3271d0, 1.3281d0,
     & 1.3291d0, 1.3301d0, 1.3311d0, 1.3321d0, 1.3331d0, 1.3342d0,
     & 1.3352d0, 1.3362d0, 1.3372d0, 1.3382d0, 1.3392d0, 1.3403d0,
     & 1.3413d0, 1.3423d0, 1.3433d0, 1.3443d0, 1.3453d0, 1.3463d0,
     & 1.3474d0, 1.3484d0, 1.3494d0, 1.3504d0, 1.3514d0, 1.3524d0,
     & 1.3534d0, 1.3545d0, 1.3555d0, 1.3565d0, 1.3575d0, 1.3585d0,
     & 1.3595d0, 1.3606d0, 1.3616d0, 1.3626d0, 1.3636d0, 1.3646d0,
     & 1.3656d0, 1.3666d0, 1.3676d0, 1.3687d0, 1.3697d0, 1.3707d0,
     & 1.3717d0, 1.3727d0, 1.3737d0, 1.3748d0, 1.3758d0, 1.3768d0,
     & 1.3778d0, 1.3788d0, 1.3798d0, 1.3808d0, 1.3818d0, 1.3828d0,
     & 1.3839d0, 1.3849d0, 1.3859d0, 1.3869d0, 1.3879d0, 1.3890d0,
     & 1.3900d0, 1.3910d0, 1.3920d0, 1.3930d0, 1.3940d0, 1.3950d0,
     & 1.3960d0, 1.3970d0, 1.3980d0, 1.3990d0, 1.4001d0, 1.4011d0,
     & 1.4021d0, 1.4031d0, 1.4042d0, 1.4051d0, 1.4061d0, 1.4071d0,
     & 1.4081d0, 1.4092d0, 1.4102d0, 1.4112d0, 1.4122d0, 1.4132d0,
     & 1.4143d0, 1.4153d0, 1.4163d0, 1.4173d0, 1.4183d0, 1.4193d0,
     & 1.4203d0, 1.4213d0, 1.4223d0, 1.4233d0, 1.4243d0, 1.4253d0,
     & 1.4264d0, 1.4274d0, 1.4284d0, 1.4294d0, 1.4304d0, 1.4315d0,
     & 1.4325d0, 1.4335d0, 1.4345d0, 1.4354d0, 1.4364d0, 1.4375d0,
     & 1.4385d0, 1.4395d0, 1.4405d0, 1.4415d0, 1.4425d0, 1.4436d0,
     & 1.4446d0, 1.4456d0, 1.4466d0, 1.4476d0, 1.4486d0, 1.4496d0,
     & 1.4506d0, 1.4516d0, 1.4526d0, 1.4536d0, 1.4546d0, 1.4557d0,
     & 1.4567d0, 1.4577d0, 1.4587d0, 1.4598d0, 1.4608d0, 1.4618d0,
     & 1.4628d0, 1.4638d0, 1.4648d0, 1.4657d0, 1.4667d0, 1.4678d0,
     & 1.4688d0, 1.4698d0, 1.4708d0, 1.4718d0, 1.4728d0, 1.4739d0,
     & 1.4749d0, 1.4759d0, 1.4769d0, 1.4779d0, 1.4789d0, 1.4799d0,
     & 1.4809d0, 1.4819d0, 1.4829d0, 1.4839d0, 1.4849d0, 1.4859d0,
     & 1.4869d0, 1.4880d0, 1.4890d0, 1.4900d0, 1.4910d0, 1.4921d0,
     & 1.4931d0, 1.4941d0, 1.4951d0, 1.4961d0, 1.4970d0, 1.4980d0,
     & 1.4990d0, 1.5000d0, 1.5011d0, 1.5021d0, 1.5031d0, 1.5041d0,
     & 1.5051d0, 1.5062d0, 1.5072d0, 1.5082d0, 1.5092d0, 1.5102d0,
     & 1.5112d0, 1.5122d0, 1.5132d0, 1.5142d0, 1.5152d0, 1.5162d0,
     & 1.5172d0, 1.5182d0, 1.5192d0, 1.5202d0, 1.5213d0, 1.5223d0,
     & 1.5233d0, 1.5243d0, 1.5254d0, 1.5264d0, 1.5274d0, 1.5284d0,
     & 1.5293d0, 1.5303d0, 1.5313d0, 1.5323d0, 1.5333d0, 1.5343d0,
     & 1.5353d0, 1.5364d0, 1.5374d0, 1.5384d0, 1.5394d0, 1.5405d0,
     & 1.5415d0, 1.5425d0, 1.5435d0, 1.5445d0, 1.5455d0, 1.5465d0,
     & 1.5475d0, 1.5484d0, 1.5494d0, 1.5504d0, 1.5514d0, 1.5524d0,
     & 1.5535d0, 1.5545d0, 1.5555d0, 1.5565d0, 1.5575d0, 1.5586d0,
     & 1.5596d0, 1.5606d0, 1.5616d0, 1.5626d0, 1.5636d0, 1.5646d0,
     & 1.5656d0, 1.5666d0, 1.5675d0, 1.5685d0, 1.5695d0, 1.5705d0,
     & 1.5716d0, 1.5726d0, 1.5736d0, 1.5746d0, 1.5756d0, 1.5767d0,
     & 1.5777d0, 1.5787d0, 1.5797d0, 1.5807d0, 1.5817d0, 1.5827d0,
     & 1.5837d0, 1.5847d0, 1.5857d0, 1.5867d0, 1.5876d0, 1.5886d0,
     & 1.5896d0, 1.5906d0, 1.5916d0, 1.5927d0, 1.5937d0, 1.5947d0,
     & 1.5957d0, 1.5968d0, 1.5978d0, 1.5988d0, 1.5999d0, 1.6009d0,
     & 1.6018d0, 1.6028d0, 1.6038d0, 1.6048d0, 1.6058d0, 1.6068d0,
     & 1.6077d0, 1.6087d0, 1.6097d0, 1.6107d0, 1.6117d0, 1.6128d0,
     & 1.6138d0, 1.6148d0, 1.6158d0, 1.6169d0, 1.6179d0, 1.6189d0,
     & 1.6199d0, 1.6210d0, 1.6219d0, 1.6229d0, 1.6239d0, 1.6249d0,
     & 1.6259d0, 1.6269d0, 1.6278d0, 1.6288d0, 1.6298d0, 1.6308d0,
     & 1.6318d0, 1.6329d0, 1.6339d0, 1.6349d0, 1.6359d0, 1.6370d0,
     & 1.6380d0, 1.6390d0, 1.6400d0, 1.6411d0, 1.6421d0, 1.6430d0,
     & 1.6440d0, 1.6450d0, 1.6460d0, 1.6470d0, 1.6480d0, 1.6489d0,
     & 1.6499d0, 1.6509d0, 1.6519d0, 1.6529d0, 1.6539d0, 1.6549d0,
     & 1.6559d0, 1.6570d0, 1.6580d0, 1.6590d0, 1.6601d0, 1.6611d0,
     & 1.6621d0, 1.6631d0, 1.6641d0, 1.6651d0, 1.6661d0, 1.6671d0,
     & 1.6681d0, 1.6690d0, 1.6700d0, 1.6710d0, 1.6720d0, 1.6729d0,
     & 1.6739d0, 1.6750d0, 1.6760d0, 1.6770d0, 1.6780d0, 1.6791d0,
     & 1.6801d0, 1.6811d0, 1.6822d0, 1.6832d0, 1.6842d0, 1.6852d0,
     & 1.6862d0, 1.6872d0, 1.6882d0, 1.6892d0, 1.6902d0, 1.6911d0,
     & 1.6921d0, 1.6931d0, 1.6941d0, 1.6950d0, 1.6960d0, 1.6970d0,
     & 1.6981d0, 1.6991d0, 1.7001d0, 1.7011d0, 1.7022d0, 1.7032d0,
     & 1.7042d0, 1.7053d0, 1.7063d0, 1.7073d0, 1.7083d0, 1.7093d0,
     & 1.7103d0, 1.7113d0, 1.7122d0, 1.7132d0, 1.7142d0, 1.7152d0,
     & 1.7162d0, 1.7171d0, 1.7181d0, 1.7191d0, 1.7201d0, 1.7211d0,
     & 1.7221d0, 1.7232d0, 1.7242d0, 1.7252d0, 1.7263d0, 1.7273d0,
     & 1.7283d0, 1.7294d0, 1.7304d0, 1.7314d0, 1.7324d0, 1.7334d0,
     & 1.7343d0, 1.7353d0, 1.7363d0, 1.7373d0, 1.7383d0, 1.7392d0,
     & 1.7402d0, 1.7412d0, 1.7421d0, 1.7432d0, 1.7442d0, 1.7452d0,
     & 1.7462d0, 1.7472d0, 1.7483d0, 1.7493d0, 1.7503d0, 1.7514d0,
     & 1.7524d0, 1.7534d0, 1.7544d0, 1.7554d0, 1.7564d0, 1.7574d0,
     & 1.7584d0, 1.7594d0, 1.7604d0, 1.7613d0, 1.7623d0, 1.7633d0,
     & 1.7643d0, 1.7652d0, 1.7662d0, 1.7672d0, 1.7682d0, 1.7692d0,
     & 1.7702d0, 1.7712d0, 1.7722d0, 1.7733d0, 1.7743d0, 1.7753d0,
     & 1.7764d0, 1.7774d0, 1.7785d0, 1.7795d0, 1.7805d0, 1.7815d0,
     & 1.7825d0, 1.7835d0, 1.7844d0, 1.7854d0, 1.7864d0, 1.7874d0,
     & 1.7884d0, 1.7893d0, 1.7903d0, 1.7913d0, 1.7923d0, 1.7932d0,
     & 1.7942d0, 1.7952d0, 1.7963d0, 1.7973d0, 1.7983d0, 1.7993d0,
     & 1.8004d0, 1.8014d0, 1.8024d0, 1.8035d0, 1.8045d0, 1.8055d0,
     & 1.8065d0, 1.8075d0, 1.8085d0, 1.8095d0, 1.8105d0, 1.8115d0,
     & 1.8125d0, 1.8134d0, 1.8144d0, 1.8154d0, 1.8164d0, 1.8173d0,
     & 1.8183d0, 1.8193d0, 1.8203d0, 1.8213d0, 1.8223d0, 1.8233d0,
     & 1.8243d0, 1.8253d0, 1.8264d0, 1.8274d0, 1.8284d0, 1.8295d0,
     & 1.8305d0, 1.8315d0, 1.8326d0, 1.8336d0, 1.8346d0, 1.8356d0,
     & 1.8366d0, 1.8375d0, 1.8385d0, 1.8395d0, 1.8405d0, 1.8415d0,
     & 1.8424d0, 1.8434d0, 1.8444d0, 1.8454d0, 1.8463d0, 1.8473d0,
     & 1.8483d0, 1.8493d0, 1.8503d0, 1.8513d0, 1.8523d0, 1.8534d0,
     & 1.8544d0, 1.8554d0, 1.8565d0, 1.8575d0, 1.8585d0, 1.8596d0,
     & 1.8606d0, 1.8616d0, 1.8626d0, 1.8636d0, 1.8646d0, 1.8656d0,
     & 1.8666d0, 1.8675d0, 1.8685d0, 1.8695d0, 1.8705d0, 1.8714d0,
     & 1.8724d0, 1.8734d0, 1.8744d0, 1.8753d0, 1.8763d0, 1.8773d0,
     & 1.8783d0, 1.8793d0, 1.8804d0, 1.8814d0, 1.8824d0, 1.8835d0,
     & 1.8845d0, 1.8855d0, 1.8866d0, 1.8876d0, 1.8886d0, 1.8896d0,
     & 1.8906d0, 1.8916d0, 1.8926d0, 1.8936d0, 1.8946d0, 1.8956d0,
     & 1.8965d0, 1.8975d0, 1.8985d0, 1.8995d0, 1.9005d0, 1.9014d0,
     & 1.9024d0, 1.9034d0, 1.9044d0, 1.9053d0, 1.9063d0, 1.9073d0,
     & 1.9083d0, 1.9094d0, 1.9104d0, 1.9114d0, 1.9125d0, 1.9135d0,
     & 1.9145d0, 1.9156d0, 1.9166d0, 1.9177d0, 1.9187d0, 1.9197d0,
     & 1.9207d0, 1.9217d0, 1.9226d0, 1.9236d0, 1.9246d0, 1.9256d0,
     & 1.9266d0, 1.9276d0, 1.9285d0, 1.9295d0, 1.9305d0, 1.9315d0,
     & 1.9324d0, 1.9334d0, 1.9344d0, 1.9353d0, 1.9363d0, 1.9373d0,
     & 1.9383d0, 1.9394d0, 1.9404d0, 1.9414d0, 1.9425d0, 1.9435d0,
     & 1.9446d0, 1.9456d0, 1.9466d0, 1.9477d0, 1.9487d0, 1.9497d0,
     & 1.9507d0, 1.9517d0, 1.9527d0, 1.9537d0, 1.9546d0, 1.9556d0,
     & 1.9566d0, 1.9576d0, 1.9586d0, 1.9595d0, 1.9605d0, 1.9615d0,
     & 1.9625d0, 1.9634d0, 1.9644d0, 1.9654d0, 1.9664d0, 1.9673d0,
     & 1.9683d0, 1.9694d0, 1.9704d0, 1.9714d0, 1.9724d0, 1.9735d0,
     & 1.9745d0, 1.9755d0, 1.9766d0, 1.9776d0, 1.9787d0, 1.9797d0,
     & 1.9807d0, 1.9817d0, 1.9827d0, 1.9837d0, 1.9847d0, 1.9857d0,
     & 1.9866d0, 1.9876d0, 1.9886d0, 1.9896d0, 1.9906d0, 1.9916d0,
     & 1.9925d0, 1.9935d0, 1.9945d0, 1.9955d0, 1.9964d0, 1.9974d0,
     & 1.9984d0, 1.9994d0, 2.0003d0, 2.0013d0, 2.0023d0, 2.0034d0,
     & 2.0044d0, 2.0054d0, 2.0065d0, 2.0075d0, 2.0085d0, 2.0096d0,
     & 2.0106d0, 2.0117d0, 2.0127d0, 2.0137d0, 2.0147d0, 2.0157d0,
     & 2.0167d0, 2.0177d0, 2.0186d0, 2.0196d0, 2.0206d0, 2.0216d0,
     & 2.0226d0, 2.0236d0, 2.0245d0, 2.0255d0, 2.0265d0, 2.0275d0,
     & 2.0284d0, 2.0294d0, 2.0304d0, 2.0313d0, 2.0323d0, 2.0333d0,
     & 2.0343d0, 2.0353d0, 2.0364d0, 2.0374d0, 2.0384d0, 2.0395d0,
     & 2.0405d0, 2.0415d0, 2.0426d0, 2.0436d0, 2.0447d0, 2.0457d0,
     & 2.0467d0, 2.0477d0, 2.0487d0, 2.0497d0, 2.0507d0, 2.0516d0,
     & 2.0526d0, 2.0536d0, 2.0546d0, 2.0556d0, 2.0566d0, 2.0575d0,
     & 2.0585d0, 2.0595d0, 2.0605d0, 2.0614d0, 2.0624d0, 2.0634d0,
     & 2.0644d0, 2.0653d0, 2.0663d0, 2.0673d0, 2.0683d0, 2.0693d0,
     & 2.0703d0, 2.0713d0, 2.0723d0, 2.0734d0, 2.0744d0, 2.0754d0,
     & 2.0765d0, 2.0775d0, 2.0786d0, 2.0796d0, 2.0806d0, 2.0816d0,
     & 2.0826d0, 2.0836d0, 2.0846d0, 2.0856d0, 2.0866d0, 2.0876d0,
     & 2.0886d0, 2.0895d0, 2.0905d0, 2.0915d0, 2.0925d0, 2.0935d0,
     & 2.0944d0, 2.0954d0, 2.0963d0, 2.0973d0, 2.0983d0, 2.0993d0,
     & 2.1002d0, 2.1012d0, 2.1022d0, 2.1032d0, 2.1043d0, 2.1052d0,
     & 2.1063d0, 2.1073d0, 2.1083d0, 2.1094d0, 2.1104d0, 2.1115d0,
     & 2.1125d0, 2.1135d0, 2.1145d0, 2.1155d0, 2.1165d0, 2.1176d0,
     & 2.1186d0, 2.1195d0, 2.1205d0, 2.1215d0, 2.1225d0, 2.1235d0,
     & 2.1245d0, 2.1254d0, 2.1264d0, 2.1274d0, 2.1284d0, 2.1294d0,
     & 2.1303d0, 2.1313d0, 2.1323d0, 2.1333d0, 2.1343d0, 2.1352d0,
     & 2.1363d0, 2.1372d0, 2.1382d0, 2.1392d0, 2.1402d0, 2.1411d0,
     & 2.1422d0, 2.1432d0, 2.1442d0, 2.1452d0, 2.1462d0, 2.1472d0,
     & 2.1483d0, 2.1493d0, 2.1504d0, 2.1515d0, 2.1525d0, 2.1535d0,
     & 2.1546d0, 2.1556d0, 2.1566d0, 2.1576d0, 2.1586d0, 2.1596d0,
     & 2.1607d0, 2.1616d0, 2.1626d0, 2.1636d0, 2.1646d0, 2.1654d0,
     & 2.1664d0, 2.1674d0, 2.1683d0, 2.1693d0, 2.1703d0, 2.1712d0,
     & 2.1721d0, 2.1731d0, 2.1741d0, 2.1750d0, 2.1760d0, 2.1770d0,
     & 2.1781d0, 2.1791d0, 2.1801d0, 2.1811d0, 2.1822d0, 2.1832d0,
     & 2.1843d0, 2.1854d0, 2.1864d0, 2.1875d0, 2.1885d0, 2.1895d0,
     & 2.1905d0, 2.1915d0, 2.1925d0, 2.1934d0, 2.1944d0, 2.1954d0,
     & 2.1964d0, 2.1974d0, 2.1985d0, 2.1995d0, 2.2005d0, 2.2016d0,
     & 2.2026d0, 2.2037d0, 2.2047d0, 2.2057d0, 2.2067d0, 2.2076d0,
     & 2.2085d0, 2.2095d0, 2.2104d0, 2.2113d0, 2.2123d0, 2.2133d0,
     & 2.2143d0, 2.2153d0, 2.2163d0, 2.2174d0, 2.2185d0, 2.2195d0,
     & 2.2205d0, 2.2216d0, 2.2225d0, 2.2235d0, 2.2245d0, 2.2254d0,
     & 2.2264d0, 2.2273d0, 2.2283d0, 2.2294d0, 2.2304d0, 2.2315d0,
     & 2.2326d0, 2.2336d0, 2.2346d0, 2.2356d0, 2.2365d0, 2.2375d0,
     & 2.2385d0, 2.2395d0, 2.2404d0, 2.2413d0, 2.2422d0, 2.2430d0,
     & 2.2440d0, 2.2450d0, 2.2460d0, 2.2469d0, 2.2479d0, 2.2489d0,
     & 2.2499d0, 2.2508d0, 2.2518d0, 2.2527d0, 2.2537d0, 2.2547d0,
     & 2.2557d0, 2.2567d0, 2.2577d0, 2.2587d0, 2.2598d0, 2.2608d0,
     & 2.2618d0, 2.2629d0, 2.2639d0, 2.2649d0, 2.2659d0, 2.2669d0,
     & 2.2679d0, 2.2689d0, 2.2707d0, 2.2734d0, 2.2768d0, 2.2811d0,
     & 2.2862d0, 2.2922d0, 2.2989d0, 2.3065d0, 2.3148d0, 2.3239d0,
     & 2.3338d0, 2.3438d0, 2.3537d0, 2.3636d0, 2.3736d0, 2.3835d0,
     & 2.3934d0, 2.4033d0, 2.4132d0, 2.4232d0, 2.4332d0, 2.4431d0,
     & 2.4530d0, 2.4628d0, 2.4728d0, 2.4826d0, 2.4925d0, 2.5023d0,
     & 2.5122d0, 2.5221d0, 2.5320d0, 2.5418d0, 2.5517d0, 2.5616d0,
     & 2.5716d0, 2.5814d0, 2.5913d0, 2.6012d0, 2.6112d0, 2.6211d0,
     & 2.6310d0, 2.6409d0, 2.6508d0, 2.6607d0, 2.6706d0, 2.6805d0,
     & 2.6904d0, 2.7003d0, 2.7101d0, 2.7200d0, 2.7299d0, 2.7398d0,
     & 2.7497d0, 2.7596d0, 2.7694d0, 2.7793d0, 2.7892d0, 2.7991d0,
     & 2.8089d0, 2.8188d0, 2.8287d0, 2.8386d0, 2.8485d0, 2.8583d0,
     & 2.8682d0, 2.8780d0, 2.8878d0, 2.8977d0, 2.9076d0, 2.9175d0,
     & 2.9274d0, 2.9372d0, 2.9471d0, 2.9570d0, 2.9670d0, 2.9768d0,
     & 2.9868d0, 2.9967d0, 3.0067d0, 3.0166d0, 3.0265d0, 3.0364d0,
     & 3.0462d0, 3.0561d0, 3.0659d0, 3.0758d0, 3.0857d0, 3.0956d0,
     & 3.1054d0, 3.1152d0, 3.1251d0, 3.1350d0, 3.1449d0, 3.1548d0,
     & 3.1646d0, 3.1745d0, 3.1843d0, 3.1942d0, 3.2041d0, 3.2140d0,
     & 3.2239d0, 3.2338d0, 3.2436d0, 3.2534d0, 3.2634d0, 3.2733d0,
     & 3.2832d0, 3.2931d0, 3.3030d0, 3.3128d0, 3.3226d0, 3.3325d0,
     & 3.3424d0, 3.3523d0, 3.3622d0, 3.3721d0, 3.3818d0, 3.3916d0,
     & 3.4015d0, 3.4114d0, 3.4213d0, 3.4312d0, 3.4411d0, 3.4510d0,
     & 3.4608d0, 3.4706d0, 3.4805d0, 3.4905d0, 3.5004d0, 3.5103d0,
     & 3.5201d0, 3.5300d0, 3.5398d0, 3.5496d0, 3.5595d0, 3.5694d0,
     & 3.5793d0, 3.5891d0, 3.5990d0, 3.6088d0, 3.6186d0, 3.6285d0,
     & 3.6384d0, 3.6483d0, 3.6581d0, 3.6680d0, 3.6779d0, 3.6877d0,
     & 3.6976d0, 3.7074d0, 3.7172d0, 3.7271d0, 3.7368d0, 3.7467d0,
     & 3.7566d0, 3.7666d0, 3.7765d0, 3.7863d0, 3.7962d0, 3.8060d0,
     & 3.8159d0, 3.8259d0, 3.8358d0, 3.8458d0, 3.8556d0, 3.8655d0,
     & 3.8754d0, 3.8852d0, 3.8950d0, 3.9048d0, 3.9146d0, 3.9246d0,
     & 3.9345d0, 3.9443d0, 3.9541d0, 3.9639d0, 3.9737d0, 3.9836d0,
     & 3.9935d0, 4.0035d0, 4.0135d0, 4.0235d0, 4.0333d0, 4.0432d0,
     & 4.0531d0, 4.0630d0, 4.0729d0, 4.0827d0, 4.0927d0, 4.1026d0,
     & 4.1124d0, 4.1223d0, 4.1322d0, 4.1421d0, 4.1520d0, 4.1619d0,
     & 4.1718d0, 4.1816d0, 4.1915d0, 4.2013d0, 4.2112d0, 4.2211d0,
     & 4.2310d0, 4.2409d0, 4.2508d0, 4.2606d0, 4.2705d0, 4.2804d0,
     & 4.2903d0, 4.3003d0, 4.3102d0, 4.3201d0, 4.3300d0, 4.3398d0,
     & 4.3497d0, 4.3595d0, 4.3694d0, 4.3794d0, 4.3894d0, 4.3994d0,
     & 4.4093d0, 4.4194d0, 4.4293d0, 4.4392d0, 4.4493d0, 4.4593d0,
     & 4.4692d0, 4.4792d0, 4.4892d0, 4.4990d0, 4.5088d0, 4.5186d0,
     & 4.5285d0, 4.5385d0, 4.5485d0, 4.5584d0, 4.5684d0, 4.5784d0,
     & 4.5884d0, 4.5983d0, 4.6083d0, 4.6183d0, 4.6283d0, 4.6381d0,
     & 4.6481d0, 4.6581d0, 4.6680d0, 4.6780d0, 4.6880d0, 4.6980d0,
     & 4.7079d0, 4.7179d0, 4.7280d0, 4.7381d0, 4.7482d0, 4.7582d0,
     & 4.7682d0, 4.7781d0, 4.7881d0, 4.7982d0, 4.8082d0, 4.8182d0,
     & 4.8281d0, 4.8381d0, 4.8480d0, 4.8579d0, 4.8678d0, 4.8776d0,
     & 4.8876d0, 4.8976d0, 4.9077d0, 4.9177d0, 4.9277d0, 4.9378d0,
     & 4.9478d0, 4.9579d0, 4.9680d0, 4.9781d0, 4.9882d0, 4.9982d0,
     & 5.0081d0, 5.0180d0, 5.0281d0, 5.0381d0, 5.0482d0, 5.0582d0,
     & 5.0683d0, 5.0784d0, 5.0884d0, 5.0985d0, 5.1085d0, 5.1186d0,
     & 5.1288d0, 5.1389d0, 5.1490d0, 5.1591d0, 5.1693d0, 5.1795d0,
     & 5.1896d0, 5.1998d0, 5.2100d0, 5.2201d0, 5.2303d0, 5.2404d0,
     & 5.2504d0, 5.2603d0, 5.2703d0, 5.2804d0, 5.2903d0, 5.3005d0,
     & 5.3106d0, 5.3208d0, 5.3311d0, 5.3413d0, 5.3515d0, 5.3617d0,
     & 5.3720d0, 5.3823d0, 5.3925d0, 5.4028d0, 5.4129d0, 5.4229d0,
     & 5.4329d0, 5.4431d0, 5.4531d0, 5.4633d0, 5.4735d0, 5.4838d0,
     & 5.4939d0, 5.5042d0, 5.5144d0, 5.5247d0, 5.5349d0, 5.5452d0,
     & 5.5553d0, 5.5656d0, 5.5758d0, 5.5861d0, 5.5963d0, 5.6066d0,
     & 5.6169d0, 5.6273d0, 5.6376d0, 5.6479d0, 5.6583d0, 5.6685d0,
     & 5.6788d0, 5.6891d0, 5.6992d0, 5.7094d0, 5.7195d0, 5.7296d0,
     & 5.7397d0, 5.7498d0, 5.7601d0, 5.7705d0, 5.7810d0, 5.7913d0,
     & 5.8017d0, 5.8122d0, 5.8227d0, 5.8332d0, 5.8436d0, 5.8540d0,
     & 5.8644d0, 5.8746d0, 5.8848d0, 5.8949d0, 5.9052d0, 5.9156d0,
     & 5.9261d0, 5.9365d0, 5.9469d0, 5.9574d0, 5.9678d0, 5.9783d0,
     & 5.9888d0, 5.9994d0, 6.0099d0, 6.0203d0, 6.0306d0, 6.0409d0,
     & 6.0511d0, 6.0614d0, 6.0718d0, 6.0821d0, 6.0925d0, 6.1029d0,
     & 6.1132d0, 6.1237d0, 6.1343d0, 6.1448d0, 6.1555d0, 6.1661d0,
     & 6.1767d0, 6.1874d0, 6.1980d0, 6.2087d0, 6.2193d0, 6.2301d0,
     & 6.2405d0, 6.2510d0, 6.2617d0, 6.2723d0, 6.2828d0, 6.2934d0,
     & 6.3041d0, 6.3147d0, 6.3253d0, 6.3360d0, 6.3467d0, 6.3575d0,
     & 6.3682d0, 6.3787d0, 6.3892d0, 6.3998d0, 6.4103d0, 6.4209d0,
     & 6.4313d0, 6.4418d0, 6.4523d0, 6.4627d0, 6.4732d0, 6.4836d0,
     & 6.4944d0, 6.5053d0, 6.5160d0, 6.5267d0, 6.5375d0, 6.5484d0,
     & 6.5592d0, 6.5700d0, 6.5809d0, 6.5918d0, 6.6027d0, 6.6135d0,
     & 6.6242d0, 6.6348d0, 6.6456d0, 6.6563d0, 6.6669d0, 6.6776d0,
     & 6.6883d0, 6.6990d0, 6.7096d0, 6.7202d0, 6.7311d0, 6.7420d0,
     & 6.7529d0, 6.7639d0, 6.7748d0, 6.7858d0, 6.7968d0, 6.8078d0,
     & 6.8189d0, 6.8299d0, 6.8410d0, 6.8519d0, 6.8627d0, 6.8734d0,
     & 6.8841d0, 6.8948d0, 6.9055d0, 6.9163d0, 6.9271d0, 6.9379d0,
     & 6.9487d0, 6.9596d0, 6.9704d0, 6.9815d0, 6.9927d0, 7.0039d0,
     & 7.0151d0, 7.0264d0, 7.0376d0, 7.0487d0, 7.0599d0, 7.0711d0,
     & 7.0823d0, 7.0936d0, 7.1046d0, 7.1156d0, 7.1266d0, 7.1377d0,
     & 7.1485d0, 7.1595d0, 7.1705d0, 7.1814d0, 7.1923d0, 7.2033d0,
     & 7.2143d0, 7.2252d0, 7.2362d0, 7.2473d0, 7.2582d0, 7.2694d0,
     & 7.2806d0, 7.2920d0, 7.3034d0, 7.3147d0, 7.3260d0, 7.3374d0,
     & 7.3490d0, 7.3605d0, 7.3719d0, 7.3834d0, 7.3949d0, 7.4065d0,
     & 7.4176d0, 7.4288d0, 7.4402d0, 7.4513d0, 7.4624d0, 7.4736d0,
     & 7.4847d0, 7.4959d0, 7.5071d0, 7.5183d0, 7.5294d0, 7.5407d0,
     & 7.5521d0, 7.5634d0, 7.5749d0, 7.5865d0, 7.5981d0, 7.6098d0,
     & 7.6213d0, 7.6330d0, 7.6448d0, 7.6565d0, 7.6682d0, 7.6799d0,
     & 7.6917d0, 7.7033d0, 7.7150d0, 7.7266d0, 7.7382d0, 7.7499d0,
     & 7.7614d0, 7.7730d0, 7.7846d0, 7.7962d0, 7.8077d0, 7.8195d0,
     & 7.8312d0, 7.8428d0, 7.8545d0, 7.8661d0, 7.8778d0, 7.8896d0,
     & 7.9014d0, 7.9129d0, 7.9245d0, 7.9362d0, 7.9479d0, 7.9595d0,
     & 7.9713d0, 7.9831d0, 7.9950d0, 8.0067d0, 8.0186d0, 8.0305d0,
     & 8.0427d0, 8.0549d0, 8.0670d0, 8.0789d0, 8.0911d0, 8.1031d0,
     & 8.1152d0, 8.1271d0, 8.1394d0, 8.1513d0, 8.1633d0, 8.1752d0,
     & 8.1871d0, 8.1990d0, 8.2110d0, 8.2231d0, 8.2350d0, 8.2469d0,
     & 8.2589d0, 8.2711d0, 8.2832d0, 8.2954d0, 8.3074d0, 8.3197d0,
     & 8.3318d0, 8.3438d0, 8.3561d0, 8.3682d0, 8.3803d0, 8.3925d0,
     & 8.4045d0, 8.4169d0, 8.4291d0, 8.4415d0, 8.4538d0, 8.4663d0,
     & 8.4787d0, 8.4910d0, 8.5035d0, 8.5162d0, 8.5288d0, 8.5414d0,
     & 8.5540d0, 8.5665d0, 8.5791d0, 8.5916d0, 8.6043d0, 8.6169d0,
     & 8.6297d0, 8.6424d0, 8.6550d0, 8.6677d0, 8.6805d0, 8.6931d0,
     & 8.7059d0, 8.7184d0, 8.7312d0, 8.7438d0, 8.7565d0, 8.7691d0,
     & 8.7818d0, 8.7944d0, 8.8071d0, 8.8196d0, 8.8323d0, 8.8449d0,
     & 8.8579d0, 8.8708d0, 8.8838d0, 8.8967d0, 8.9099d0, 8.9227d0,
     & 8.9356d0, 8.9488d0, 8.9622d0, 8.9753d0, 8.9887d0, 9.0018d0,
     & 9.0147d0, 9.0276d0, 9.0406d0, 9.0535d0, 9.0667d0, 9.0800d0,
     & 9.0931d0, 9.1061d0, 9.1194d0, 9.1325d0, 9.1458d0, 9.1592d0,
     & 9.1726d0, 9.1862d0, 9.1998d0, 9.2134d0, 9.2268d0, 9.2402d0,
     & 9.2537d0, 9.2671d0, 9.2804d0, 9.2940d0, 9.3075d0, 9.3211d0,
     & 9.3344d0, 9.3480d0, 9.3614d0, 9.3751d0, 9.3890d0, 9.4026d0,
     & 9.4162d0, 9.4303d0, 9.4444d0, 9.4585d0, 9.4726d0, 9.4868d0,
     & 9.5007d0, 9.5146d0, 9.5286d0, 9.5425d0, 9.5566d0, 9.5707d0,
     & 9.5848d0, 9.5989d0, 9.6128d0, 9.6269d0, 9.6411d0, 9.6555d0,
     & 9.6699d0, 9.6844d0, 9.6989d0, 9.7135d0, 9.7277d0, 9.7422d0,
     & 9.7566d0, 9.7712d0, 9.7857d0, 9.8002d0, 9.8147d0, 9.8295d0,
     & 9.8440d0, 9.8586d0, 9.8732d0, 9.8880d0, 9.9022d0, 9.9165d0,
     & 9.9308d0, 9.9436d0, 9.9551d0, 9.9653d0, 9.9741d0, 9.9817d0,
     & 9.9878d0, 9.9926d0, 9.9963d0, 9.9988d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0,10.0000d0,10.0000d0,10.0000d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     &10.0000d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0
     &/
      DATA (Imax ( 2,I), I= 1, 1000) /
     & 0.00000639d0, 0.00000639d0, 0.00002642d0, 0.00008872d0,
     & 0.00015029d0, 0.00035111d0, 0.00062718d0, 0.00095004d0,
     & 0.00137292d0, 0.00189008d0, 0.00251077d0, 0.00325908d0,
     & 0.00413710d0, 0.00510136d0, 0.00617416d0, 0.00740600d0,
     & 0.00860051d0, 0.00984844d0, 0.01122361d0, 0.01263107d0,
     & 0.01406813d0, 0.01558326d0, 0.01714809d0, 0.01873663d0,
     & 0.02034482d0, 0.02199208d0, 0.02366701d0, 0.02541172d0,
     & 0.02717611d0, 0.02893666d0, 0.03076849d0, 0.03264745d0,
     & 0.03450714d0, 0.03634398d0, 0.03824711d0, 0.04020982d0,
     & 0.04214862d0, 0.04407473d0, 0.04603570d0, 0.04803883d0,
     & 0.05004998d0, 0.05204711d0, 0.05407346d0, 0.05611101d0,
     & 0.05819797d0, 0.06026189d0, 0.06230874d0, 0.06442975d0,
     & 0.06654746d0, 0.06866122d0, 0.07077400d0, 0.07289863d0,
     & 0.07507329d0, 0.07722806d0, 0.07939806d0, 0.08155800d0,
     & 0.08372799d0, 0.08595791d0, 0.08814186d0, 0.09035522d0,
     & 0.09256284d0, 0.09479076d0, 0.09703165d0, 0.09926941d0,
     & 0.10152438d0, 0.10378378d0, 0.10604880d0, 0.10831898d0,
     & 0.11059348d0, 0.11289570d0, 0.11520292d0, 0.11751381d0,
     & 0.11981411d0, 0.12212412d0, 0.12441935d0, 0.12675166d0,
     & 0.12910385d0, 0.13144350d0, 0.13378499d0, 0.13608512d0,
     & 0.13838539d0, 0.14073949d0, 0.14311641d0, 0.14549489d0,
     & 0.14785932d0, 0.15021592d0, 0.15253504d0, 0.15489599d0,
     & 0.15730631d0, 0.15971959d0, 0.16214809d0, 0.16455959d0,
     & 0.16691689d0, 0.16927050d0, 0.17166851d0, 0.17411259d0,
     & 0.17655827d0, 0.17901903d0, 0.18143541d0, 0.18381801d0,
     & 0.18618175d0, 0.18862653d0, 0.19109815d0, 0.19359121d0,
     & 0.19606526d0, 0.19851027d0, 0.20090790d0, 0.20328698d0,
     & 0.20573170d0, 0.20821615d0, 0.21070269d0, 0.21322241d0,
     & 0.21567655d0, 0.21810113d0, 0.22050205d0, 0.22292215d0,
     & 0.22541365d0, 0.22792988d0, 0.23048100d0, 0.23296337d0,
     & 0.23542204d0, 0.23787639d0, 0.24031202d0, 0.24273282d0,
     & 0.24524823d0, 0.24780715d0, 0.25036320d0, 0.25284564d0,
     & 0.25531852d0, 0.25777113d0, 0.26022565d0, 0.26268280d0,
     & 0.26518899d0, 0.26774389d0, 0.27031407d0, 0.27282625d0,
     & 0.27530992d0, 0.27779213d0, 0.28027448d0, 0.28275806d0,
     & 0.28526258d0, 0.28783545d0, 0.29040837d0, 0.29297030d0,
     & 0.29549870d0, 0.29802370d0, 0.30052879d0, 0.30301523d0,
     & 0.30550429d0, 0.30806398d0, 0.31065321d0, 0.31324142d0,
     & 0.31577700d0, 0.31830803d0, 0.32081759d0, 0.32332852d0,
     & 0.32584238d0, 0.32837951d0, 0.33094177d0, 0.33353418d0,
     & 0.33607697d0, 0.33860725d0, 0.34115559d0, 0.34368256d0,
     & 0.34623209d0, 0.34876236d0, 0.35129467d0, 0.35388982d0,
     & 0.35645023d0, 0.35902822d0, 0.36159286d0, 0.36415458d0,
     & 0.36673784d0, 0.36927888d0, 0.37184757d0, 0.37437558d0,
     & 0.37692750d0, 0.37951127d0, 0.38206333d0, 0.38462687d0,
     & 0.38723248d0, 0.38981548d0, 0.39239940d0, 0.39494109d0,
     & 0.39750698d0, 0.40007091d0, 0.40263724d0, 0.40528980d0,
     & 0.40791318d0, 0.41048002d0, 0.41306770d0, 0.41563272d0,
     & 0.41819885d0, 0.42076677d0, 0.42335904d0, 0.42593122d0,
     & 0.42850584d0, 0.43113270d0, 0.43370432d0, 0.43629584d0,
     & 0.43893352d0, 0.44154859d0, 0.44414237d0, 0.44673768d0,
     & 0.44933534d0, 0.45191166d0, 0.45448923d0, 0.45708567d0,
     & 0.45968151d0, 0.46231538d0, 0.46492618d0, 0.46749201d0,
     & 0.47006065d0, 0.47265524d0, 0.47525197d0, 0.47782794d0,
     & 0.48043007d0, 0.48305830d0, 0.48568735d0, 0.48830453d0,
     & 0.49090597d0, 0.49350888d0, 0.49616060d0, 0.49881315d0,
     & 0.50142068d0, 0.50403017d0, 0.50664163d0, 0.50927901d0,
     & 0.51189524d0, 0.51450264d0, 0.51711947d0, 0.51968962d0,
     & 0.52231228d0, 0.52491331d0, 0.52754092d0, 0.53014660d0,
     & 0.53277844d0, 0.53541225d0, 0.53804857d0, 0.54066229d0,
     & 0.54327410d0, 0.54590297d0, 0.54859120d0, 0.55123270d0,
     & 0.55387717d0, 0.55652463d0, 0.55919844d0, 0.56182569d0,
     & 0.56445444d0, 0.56703711d0, 0.56970537d0, 0.57235271d0,
     & 0.57494628d0, 0.57753044d0, 0.58012575d0, 0.58277863d0,
     & 0.58541101d0, 0.58804679d0, 0.59073508d0, 0.59342659d0,
     & 0.59609663d0, 0.59871012d0, 0.60135019d0, 0.60399216d0,
     & 0.60657257d0, 0.60918862d0, 0.61179346d0, 0.61448240d0,
     & 0.61714947d0, 0.61979496d0, 0.62244332d0, 0.62509388d0,
     & 0.62777168d0, 0.63042718d0, 0.63308477d0, 0.63574374d0,
     & 0.63837349d0, 0.64098275d0, 0.64354330d0, 0.64616692d0,
     & 0.64887470d0, 0.65153450d0, 0.65417153d0, 0.65683770d0,
     & 0.65950620d0, 0.66220164d0, 0.66484886d0, 0.66749865d0,
     & 0.67012024d0, 0.67270172d0, 0.67533427d0, 0.67791063d0,
     & 0.68054879d0, 0.68324441d0, 0.68589312d0, 0.68863267d0,
     & 0.69135088d0, 0.69407177d0, 0.69677097d0, 0.69947344d0,
     & 0.70217913d0, 0.70481831d0, 0.70740253d0, 0.71001112d0,
     & 0.71266645d0, 0.71533525d0, 0.71792537d0, 0.72052127d0,
     & 0.72325158d0, 0.72598505d0, 0.72872132d0, 0.73145998d0,
     & 0.73417532d0, 0.73686695d0, 0.73952115d0, 0.74214619d0,
     & 0.74475253d0, 0.74742311d0, 0.75011510d0, 0.75271112d0,
     & 0.75531483d0, 0.75792426d0, 0.76053822d0, 0.76315594d0,
     & 0.76593298d0, 0.76871228d0, 0.77144200d0, 0.77417386d0,
     & 0.77680540d0, 0.77940857d0, 0.78202409d0, 0.78466505d0,
     & 0.78733742d0, 0.79002255d0, 0.79271573d0, 0.79530954d0,
     & 0.79804194d0, 0.80072409d0, 0.80338293d0, 0.80617601d0,
     & 0.80897135d0, 0.81174254d0, 0.81447905d0, 0.81717765d0,
     & 0.81980658d0, 0.82242388d0, 0.82509524d0, 0.82765150d0,
     & 0.83035409d0, 0.83308965d0, 0.83571672d0, 0.83832240d0,
     & 0.84098637d0, 0.84376132d0, 0.84653980d0, 0.84929430d0,
     & 0.85207856d0, 0.85480297d0, 0.85747874d0, 0.86008573d0,
     & 0.86268973d0, 0.86539352d0, 0.86813855d0, 0.87086535d0,
     & 0.87349188d0, 0.87612385d0, 0.87881267d0, 0.88150579d0,
     & 0.88430989d0, 0.88714284d0, 0.88992453d0, 0.89272994d0,
     & 0.89543933d0, 0.89807713d0, 0.90070271d0, 0.90331936d0,
     & 0.90599519d0, 0.90868777d0, 0.91136461d0, 0.91394264d0,
     & 0.91655499d0, 0.91922587d0, 0.92187417d0, 0.92452610d0,
     & 0.92723435d0, 0.93008053d0, 0.93292874d0, 0.93571264d0,
     & 0.93842238d0, 0.94111758d0, 0.94385540d0, 0.94647717d0,
     & 0.94916582d0, 0.95193028d0, 0.95464671d0, 0.95739889d0,
     & 0.96002156d0, 0.96264917d0, 0.96525335d0, 0.96796930d0,
     & 0.97068828d0, 0.97335637d0, 0.97610748d0, 0.97889638d0,
     & 0.98160589d0, 0.98436081d0, 0.98702365d0, 0.98969859d0,
     & 0.99242896d0, 0.99523485d0, 0.99793661d0, 1.00067711d0,
     & 1.00342512d0, 1.00617921d0, 1.00880253d0, 1.01143122d0,
     & 1.01409221d0, 1.01681137d0, 1.01951468d0, 1.02216017d0,
     & 1.02475643d0, 1.02740061d0, 1.03014171d0, 1.03287482d0,
     & 1.03566957d0, 1.03851211d0, 1.04130805d0, 1.04408550d0,
     & 1.04687071d0, 1.04966164d0, 1.05245721d0, 1.05520022d0,
     & 1.05797434d0, 1.06067097d0, 1.06337047d0, 1.06600440d0,
     & 1.06861532d0, 1.07126987d0, 1.07405150d0, 1.07665920d0,
     & 1.07923293d0, 1.08196938d0, 1.08478785d0, 1.08761990d0,
     & 1.09040570d0, 1.09319818d0, 1.09599698d0, 1.09880066d0,
     & 1.10160911d0, 1.10428309d0, 1.10712504d0, 1.10999739d0,
     & 1.11270380d0, 1.11535454d0, 1.11798918d0, 1.12061262d0,
     & 1.12320018d0, 1.12577975d0, 1.12843704d0, 1.13116443d0,
     & 1.13391149d0, 1.13667083d0, 1.13940966d0, 1.14215565d0,
     & 1.14487779d0, 1.14763427d0, 1.15039468d0, 1.15315819d0,
     & 1.15589762d0, 1.15855718d0, 1.16111648d0, 1.16365445d0,
     & 1.16617894d0, 1.16872275d0, 1.17125845d0, 1.17381728d0,
     & 1.17634165d0, 1.17898226d0, 1.18166530d0, 1.18439770d0,
     & 1.18711305d0, 1.18983781d0, 1.19257140d0, 1.19528341d0,
     & 1.19800198d0, 1.20072639d0, 1.20348394d0, 1.20621765d0,
     & 1.20880699d0, 1.21138239d0, 1.21393728d0, 1.21648073d0,
     & 1.21904373d0, 1.22159958d0, 1.22414982d0, 1.22669435d0,
     & 1.22923386d0, 1.23174119d0, 1.23435104d0, 1.23710275d0,
     & 1.23983538d0, 1.24257684d0, 1.24529445d0, 1.24801838d0,
     & 1.25074589d0, 1.25350690d0, 1.25624335d0, 1.25898361d0,
     & 1.26172674d0, 1.26439512d0, 1.26694918d0, 1.26949334d0,
     & 1.27202833d0, 1.27461469d0, 1.27716637d0, 1.27971339d0,
     & 1.28225482d0, 1.28479290d0, 1.28740144d0, 1.29002976d0,
     & 1.29267275d0, 1.29541802d0, 1.29819942d0, 1.30098712d0,
     & 1.30372155d0, 1.30648887d0, 1.30923128d0, 1.31197751d0,
     & 1.31475520d0, 1.31746161d0, 1.32014763d0, 1.32281804d0,
     & 1.32538688d0, 1.32791960d0, 1.33044612d0, 1.33302617d0,
     & 1.33557332d0, 1.33814549d0, 1.34087324d0, 1.34362435d0,
     & 1.34638894d0, 1.34916246d0, 1.35194635d0, 1.35467565d0,
     & 1.35744071d0, 1.36021113d0, 1.36298609d0, 1.36576426d0,
     & 1.36854613d0, 1.37117231d0, 1.37377501d0, 1.37633526d0,
     & 1.37888670d0, 1.38139999d0, 1.38396704d0, 1.38652670d0,
     & 1.38908112d0, 1.39160240d0, 1.39414775d0, 1.39669073d0,
     & 1.39930904d0, 1.40191793d0, 1.40457118d0, 1.40735602d0,
     & 1.41017735d0, 1.41300523d0, 1.41580927d0, 1.41861713d0,
     & 1.42145932d0, 1.42430639d0, 1.42712653d0, 1.42984390d0,
     & 1.43257308d0, 1.43528795d0, 1.43787241d0, 1.44045031d0,
     & 1.44296539d0, 1.44550610d0, 1.44804442d0, 1.45057869d0,
     & 1.45308208d0, 1.45563424d0, 1.45827353d0, 1.46106267d0,
     & 1.46386325d0, 1.46664083d0, 1.46942627d0, 1.47227597d0,
     & 1.47510123d0, 1.47793150d0, 1.48076606d0, 1.48363304d0,
     & 1.48645282d0, 1.48918509d0, 1.49176705d0, 1.49430859d0,
     & 1.49690282d0, 1.49946058d0, 1.50201106d0, 1.50458765d0,
     & 1.50715983d0, 1.50972807d0, 1.51226389d0, 1.51482594d0,
     & 1.51748586d0, 1.52013993d0, 1.52284110d0, 1.52555478d0,
     & 1.52827656d0, 1.53100789d0, 1.53386545d0, 1.53672814d0,
     & 1.53956544d0, 1.54243612d0, 1.54531062d0, 1.54805791d0,
     & 1.55081189d0, 1.55351925d0, 1.55621457d0, 1.55893123d0,
     & 1.56164002d0, 1.56422150d0, 1.56676769d0, 1.56931031d0,
     & 1.57185054d0, 1.57438743d0, 1.57698035d0, 1.57960451d0,
     & 1.58229017d0, 1.58499432d0, 1.58768022d0, 1.59037685d0,
     & 1.59308231d0, 1.59579527d0, 1.59854376d0, 1.60129654d0,
     & 1.60417390d0, 1.60705495d0, 1.60990536d0, 1.61269450d0,
     & 1.61546576d0, 1.61819696d0, 1.62091804d0, 1.62363124d0,
     & 1.62636805d0, 1.62906981d0, 1.63176501d0, 1.63433790d0,
     & 1.63690758d0, 1.63944519d0, 1.64200997d0, 1.64465535d0,
     & 1.64738429d0, 1.65009689d0, 1.65282202d0, 1.65555680d0,
     & 1.65845168d0, 1.66129315d0, 1.66413856d0, 1.66695857d0,
     & 1.66981220d0, 1.67266965d0, 1.67535806d0, 1.67799354d0,
     & 1.68064642d0, 1.68331778d0, 1.68598032d0, 1.68845391d0,
     & 1.69098818d0, 1.69348967d0, 1.69602013d0, 1.69854844d0,
     & 1.70107448d0, 1.70365906d0, 1.70621312d0, 1.70873630d0,
     & 1.71129060d0, 1.71384633d0, 1.71648419d0, 1.71910095d0,
     & 1.72175920d0, 1.72439408d0, 1.72700632d0, 1.72962594d0,
     & 1.73225093d0, 1.73503160d0, 1.73784816d0, 1.74057686d0,
     & 1.74330723d0, 1.74592590d0, 1.74871469d0, 1.75146270d0,
     & 1.75423336d0, 1.75699782d0, 1.75972617d0, 1.76244998d0,
     & 1.76501834d0, 1.76755166d0, 1.77011180d0, 1.77263916d0,
     & 1.77525556d0, 1.77768850d0, 1.78014779d0, 1.78277051d0,
     & 1.78544188d0, 1.78815687d0, 1.79088068d0, 1.79357886d0,
     & 1.79631543d0, 1.79905903d0, 1.80183852d0, 1.80459273d0,
     & 1.80738127d0, 1.81017590d0, 1.81302071d0, 1.81584799d0,
     & 1.81863272d0, 1.82143927d0, 1.82418215d0, 1.82688761d0,
     & 1.82949722d0, 1.83219159d0, 1.83491194d0, 1.83762836d0,
     & 1.84031153d0, 1.84266114d0, 1.84500861d0, 1.84744358d0,
     & 1.84989297d0, 1.85240197d0, 1.85498655d0, 1.85765004d0,
     & 1.86024070d0, 1.86293972d0, 1.86564791d0, 1.86836231d0,
     & 1.87107599d0, 1.87379825d0, 1.87643611d0, 1.87915492d0,
     & 1.88196671d0, 1.88473499d0, 1.88748562d0, 1.89022136d0,
     & 1.89275956d0, 1.89544129d0, 1.89811778d0, 1.90091515d0,
     & 1.90361512d0, 1.90631092d0, 1.90894043d0, 1.91156638d0,
     & 1.91418910d0, 1.91680944d0, 1.91942728d0, 1.92207360d0,
     & 1.92453706d0, 1.92710578d0, 1.92966974d0, 1.93234444d0,
     & 1.93503118d0, 1.93770039d0, 1.94047439d0, 1.94313049d0,
     & 1.94582200d0, 1.94848883d0, 1.95122337d0, 1.95396233d0,
     & 1.95662916d0, 1.95927238d0, 1.96189749d0, 1.96463394d0,
     & 1.96735978d0, 1.96998215d0, 1.97269392d0, 1.97539949d0,
     & 1.97804248d0, 1.98085952d0, 1.98367310d0, 1.98636246d0,
     & 1.98919928d0, 1.99203312d0, 1.99465299d0, 1.99727058d0,
     & 1.99988639d0, 2.00260925d0, 2.00536466d0, 2.00822783d0,
     & 2.01088905d0, 2.01356030d0, 2.01632977d0, 2.01900196d0,
     & 2.02168489d0, 2.02446437d0, 2.02725101d0, 2.03004384d0,
     & 2.03276396d0, 2.03542686d0, 2.03807402d0, 2.04074550d0,
     & 2.04341006d0, 2.04609966d0, 2.04898453d0, 2.05186105d0,
     & 2.05464244d0, 2.05741906d0, 2.06019163d0, 2.06296086d0,
     & 2.06563663d0, 2.06824946d0, 2.07085967d0, 2.07358861d0,
     & 2.07619476d0, 2.07858396d0, 2.08098197d0, 2.08355427d0,
     & 2.08611703d0, 2.08883095d0, 2.09155631d0, 2.09441209d0,
     & 2.09730434d0, 2.10020375d0, 2.10298753d0, 2.10580373d0,
     & 2.10862565d0, 2.11144209d0, 2.11414671d0, 2.11686349d0,
     & 2.11943197d0, 2.12196064d0, 2.12469649d0, 2.12718225d0,
     & 2.12966275d0, 2.13213968d0, 2.13467598d0, 2.13720798d0,
     & 2.14009857d0, 2.14304972d0, 2.14575505d0, 2.14842725d0,
     & 2.15112758d0, 2.15370178d0, 2.15651894d0, 2.15924358d0,
     & 2.16205645d0, 2.16490436d0, 2.16777778d0, 2.17030382d0,
     & 2.17284369d0, 2.17563748d0, 2.17847061d0, 2.18111992d0,
     & 2.18368673d0, 2.18638611d0, 2.18915057d0, 2.19167256d0,
     & 2.19419360d0, 2.19666195d0, 2.19911575d0, 2.20152569d0,
     & 2.20396090d0, 2.20638943d0, 2.20900416d0, 2.21158171d0,
     & 2.21418190d0, 2.21668649d0, 2.21952868d0, 2.22236633d0,
     & 2.22520089d0, 2.22803473d0, 2.23089671d0, 2.23369169d0,
     & 2.23660326d0, 2.23948216d0, 2.24253464d0, 2.24524021d0,
     & 2.24810863d0, 2.25081968d0, 2.25354958d0, 2.25629282d0,
     & 2.25934243d0, 2.26211214d0, 2.26488948d0, 2.26742721d0,
     & 2.27000070d0, 2.27253437d0, 2.27529597d0, 2.27780056d0,
     & 2.28031063d0, 2.28293347d0, 2.28557658d0, 2.28791595d0,
     & 2.29050636d0, 2.29312229d0, 2.29586077d0, 2.29868841d0,
     & 2.30147409d0, 2.30394840d0, 2.30663943d0, 2.30932951d0,
     & 2.31185746d0, 2.31437993d0, 2.31686950d0, 2.31939077d0,
     & 2.32190967d0, 2.32442689d0, 2.32681918d0, 2.32911801d0,
     & 2.33187509d0, 2.33475947d0, 2.33767009d0, 2.34062910d0,
     & 2.34372306d0, 2.34698844d0, 2.35035539d0, 2.35332298d0,
     & 2.35638595d0, 2.35938859d0, 2.36239743d0, 2.36558127d0,
     & 2.36825895d0, 2.37079382d0, 2.37331390d0, 2.37570477d0,
     & 2.37792659d0, 2.38004732d0, 2.38257408d0, 2.38494372d0,
     & 2.38741088d0, 2.38990593d0, 2.39204526d0, 2.39456511d0,
     & 2.39720321d0, 2.40005755d0, 2.40290999d0, 2.40579224d0,
     & 2.40861034d0, 2.41142321d0, 2.41417646d0, 2.41707754d0,
     & 2.41997647d0, 2.42292857d0, 2.42589068d0, 2.42888045d0,
     & 2.43166780d0, 2.43447328d0, 2.43725729d0, 2.44040561d0,
     & 2.44381571d0, 2.44731832d0, 2.44997478d0, 2.45263505d0,
     & 2.45524621d0, 2.45785475d0, 2.46043944d0, 2.46298027d0,
     & 2.46550655d0, 2.46824145d0, 2.47024107d0, 2.47204137d0,
     & 2.47400236d0, 2.47665906d0, 2.47943783d0, 2.48221254d0,
     & 2.48528934d0, 2.48839283d0, 2.49093723d0, 2.49347878d0,
     & 2.49580216d0, 2.49855900d0, 2.50125337d0, 2.50381446d0,
     & 2.50637698d0, 2.50878263d0, 2.51121807d0, 2.51334286d0,
     & 2.51543593d0, 2.51836467d0, 2.52132463d0, 2.52430010d0,
     & 2.52729106d0, 2.53062367d0, 2.53386950d0, 2.53747201d0,
     & 2.54110980d0, 2.54471993d0, 2.54769778d0, 2.55068135d0,
     & 2.55342078d0, 2.55613232d0, 2.55883098d0, 2.56151700d0,
     & 2.56408429d0, 2.56674314d0, 2.56904435d0, 2.57168508d0,
     & 2.57373166d0, 2.57641292d0, 2.57905865d0, 2.58170080d0
     &/
      DATA (Imax ( 2,I), I= 1001, 2100) /
     & 2.58449149d0, 2.58762383d0, 2.59099650d0, 2.59414983d0,
     & 2.59726977d0, 2.59967780d0, 2.60173869d0, 2.60442448d0,
     & 2.60710883d0, 2.60982251d0, 2.61281729d0, 2.61629558d0,
     & 2.61947060d0, 2.62119341d0, 2.62296319d0, 2.62515306d0,
     & 2.62842965d0, 2.63108897d0, 2.63517356d0, 2.63927197d0,
     & 2.64346886d0, 2.64687991d0, 2.64965868d0, 2.65243101d0,
     & 2.65625811d0, 2.65930033d0, 2.66195703d0, 2.66424060d0,
     & 2.66714787d0, 2.66859698d0, 2.67077303d0, 2.67285681d0,
     & 2.67544627d0, 2.67800260d0, 2.68052578d0, 2.68233538d0,
     & 2.68493938d0, 2.68754435d0, 2.69011545d0, 2.69268417d0,
     & 2.69528222d0, 2.69707799d0, 2.69886804d0, 2.70065594d0,
     & 2.70580173d0, 2.70764780d0, 2.71036077d0, 2.71298242d0,
     & 2.71559930d0, 2.71830750d0, 2.72110128d0, 2.72377348d0,
     & 2.72634888d0, 2.72891283d0, 2.73149610d0, 2.73073149d0,
     & 2.73347569d0, 2.73619628d0, 2.75421238d0, 2.75696969d0,
     & 2.76000261d0, 2.76292348d0, 2.78089905d0, 2.78414130d0,
     & 2.78739905d0, 2.79064155d0, 2.79422164d0, 2.80062270d0,
     & 2.80705786d0, 2.79824972d0, 2.80467796d0, 2.80830169d0,
     & 2.81186008d0, 2.80061078d0, 2.80391240d0, 2.80674434d0,
     & 2.80920005d0, 2.81130767d0, 2.81022954d0, 2.80911112d0,
     & 2.80797362d0, 2.80698490d0, 2.80862021d0, 2.81034851d0,
     & 2.81195211d0, 2.81418920d0, 2.81673288d0, 2.81960654d0,
     & 2.82235193d0, 2.84031868d0, 2.85829306d0, 2.86370134d0,
     & 2.88118577d0, 2.89867949d0, 2.90507531d0, 2.91604567d0,
     & 2.93289113d0, 2.93600512d0, 2.93922591d0, 2.94261336d0,
     & 2.93096828d0, 2.91931725d0, 2.92105317d0, 2.91058493d0,
     & 2.90728188d0, 2.91481161d0, 2.91779518d0, 2.91448832d0,
     & 2.92509246d0, 2.93564987d0, 2.94621968d0, 2.95642710d0,
     & 2.96667933d0, 2.96825147d0, 2.96967077d0, 2.96509075d0,
     & 2.96044374d0, 2.95586061d0, 2.95106840d0, 2.94892907d0,
     & 2.95115662d0, 2.95347047d0, 2.95628071d0, 2.95931077d0,
     & 2.97027111d0, 2.98100781d0, 2.99042559d0, 2.99241495d0,
     & 2.99422336d0, 2.99634314d0, 2.99580240d0, 2.99088764d0,
     & 2.98587537d0, 2.98195434d0, 2.97780347d0, 2.98083472d0,
     & 2.98391008d0, 3.00209284d0, 3.01292682d0, 3.03898835d0,
     & 3.06505346d0, 3.06873322d0, 3.07929873d0, 3.08248091d0,
     & 3.08443689d0, 3.08638787d0, 3.08108282d0, 3.07611871d0,
     & 3.05862045d0, 3.05375338d0, 3.03279328d0, 3.01185226d0,
     & 3.01410270d0, 3.00911331d0, 3.01149964d0, 3.01388454d0,
     & 3.01623702d0, 3.01859283d0, 3.02094340d0, 3.02055264d0,
     & 3.02263999d0, 3.02568126d0, 3.02868986d0, 3.03088021d0,
     & 3.03350067d0, 3.04004049d0, 3.04658341d0, 3.05316067d0,
     & 3.05974102d0, 3.06600571d0, 3.07682228d0, 3.08324981d0,
     & 3.08968520d0, 3.09580517d0, 3.10192847d0, 3.10786557d0,
     & 3.10701466d0, 3.10613489d0, 3.10744953d0, 3.11482716d0,
     & 3.12311745d0, 3.12721944d0, 3.34333062d0, 3.32045269d0,
     & 3.29207540d0, 3.30839372d0, 3.27630758d0, 3.43767428d0,
     & 3.31386352d0, 3.33062315d0, 3.35704947d0, 3.39685416d0,
     & 3.42084599d0, 3.44524026d0, 3.47135377d0, 3.49148250d0,
     & 3.52000928d0, 3.53978038d0, 3.57732177d0, 3.60189056d0,
     & 3.62388921d0, 3.65263104d0, 3.68185878d0, 3.69719124d0,
     & 3.72429323d0, 3.75130773d0, 3.78046727d0, 3.80826116d0,
     & 3.83664131d0, 3.86538410d0, 3.89455914d0, 3.92342544d0,
     & 3.94814324d0, 3.97686744d0, 4.00688124d0, 4.03585863d0,
     & 4.06919098d0, 4.09869480d0, 4.12557983d0, 4.15189600d0,
     & 4.18259907d0, 4.21246433d0, 4.24040031d0, 4.26757765d0,
     & 4.29492807d0, 4.32279444d0, 4.35435581d0, 4.38289213d0,
     & 4.41079140d0, 4.44009304d0, 4.46712494d0, 4.50025702d0,
     & 4.53014374d0, 4.55989981d0, 4.59046984d0, 4.62326384d0,
     & 4.65190649d0, 4.68600702d0, 4.71524429d0, 4.74533367d0,
     & 4.77326965d0, 4.80262947d0, 4.82538509d0, 4.83771229d0,
     & 4.86388779d0, 4.89241791d0, 4.92268515d0, 4.94669008d0,
     & 4.97351599d0, 5.01391506d0, 5.04380989d0, 5.07653856d0,
     & 5.10914326d0, 5.14118910d0, 5.17666006d0, 5.20930815d0,
     & 5.24510813d0, 5.27176476d0, 5.30046463d0, 5.32924795d0,
     & 5.35927629d0, 5.38863897d0, 5.41829300d0, 5.44016266d0,
     & 5.46494293d0, 5.49416018d0, 5.51430655d0, 5.54441071d0,
     & 5.57031059d0, 5.59765053d0, 5.62852049d0, 5.65946865d0,
     & 5.68415880d0, 5.70874119d0, 5.73271894d0, 5.77174330d0,
     & 5.80151749d0, 5.83045530d0, 5.86161709d0, 5.88583040d0,
     & 5.91469383d0, 5.94091177d0, 5.97163630d0, 6.00205374d0,
     & 6.03052950d0, 6.05910826d0, 6.08861685d0, 6.11451578d0,
     & 6.13759375d0, 6.16619968d0, 6.19546413d0, 6.22198248d0,
     & 6.25012350d0, 6.27920771d0, 6.30669785d0, 6.33142805d0,
     & 6.36038351d0, 6.38688278d0, 6.41635084d0, 6.44961834d0,
     & 6.47116041d0, 6.50143242d0, 6.52816868d0, 6.55992842d0,
     & 6.58735132d0, 6.62295008d0, 6.65726709d0, 6.68990374d0,
     & 6.71998119d0, 6.73740387d0, 6.76667643d0, 6.79904461d0,
     & 6.82586575d0, 6.85607767d0, 6.87852669d0, 6.91051912d0,
     & 6.93896008d0, 6.97070074d0, 7.00155640d0, 7.02802706d0,
     & 7.05410814d0, 7.07744694d0, 7.10185385d0, 7.13060951d0,
     & 7.15832710d0, 7.18767786d0, 7.21361446d0, 7.24053049d0,
     & 7.26924276d0, 7.30252409d0, 7.32176590d0, 7.35405111d0,
     & 7.38255024d0, 7.41298580d0, 7.44833422d0, 7.47767925d0,
     & 7.50540733d0, 7.53271294d0, 7.56191587d0, 7.58754635d0,
     & 7.61500549d0, 7.64759302d0, 7.67348623d0, 7.70437479d0,
     & 7.72842169d0, 7.75097084d0, 7.77926111d0, 7.80517244d0,
     & 7.83489275d0, 7.86576033d0, 7.89078522d0, 7.91704702d0,
     & 7.94945526d0, 7.97404718d0, 8.00666046d0, 8.03962708d0,
     & 8.06803322d0, 8.09879017d0, 8.13017750d0, 8.15610218d0,
     & 8.18308735d0, 8.21256447d0, 8.24132061d0, 8.26939201d0,
     & 8.29904175d0, 8.32602978d0, 8.35389900d0, 8.38316441d0,
     & 8.41180134d0, 8.44053841d0, 8.46746159d0, 8.49372959d0,
     & 8.52047348d0, 8.54690456d0, 8.57382298d0, 8.60225010d0,
     & 8.62870502d0, 8.65484047d0, 8.68315601d0, 8.70971775d0,
     & 8.73787498d0, 8.76599979d0, 8.79443932d0, 8.82345009d0,
     & 8.85154438d0, 8.88123703d0, 8.91098118d0, 8.93913555d0,
     & 8.96787548d0, 8.99382687d0, 9.01943016d0, 9.04682255d0,
     & 9.07497215d0, 9.10226822d0, 9.13055038d0, 9.16145992d0,
     & 9.19326210d0, 9.22351265d0, 9.25304127d0, 9.28589630d0,
     & 9.31202507d0, 9.34116173d0, 9.36350346d0, 9.38690376d0,
     & 9.41310406d0, 9.44016361d0, 9.46928024d0, 9.49295998d0,
     & 9.52065754d0, 9.54896927d0, 9.57752323d0, 9.60424995d0,
     & 9.63243294d0, 9.66168976d0, 9.68707180d0, 9.71115398d0,
     & 9.74347019d0, 9.77298546d0, 9.79771900d0, 9.82377148d0,
     & 9.85154819d0, 9.88106728d0, 9.91080475d0, 9.94055843d0,
     & 9.96873951d0, 9.99744129d0,10.02650547d0,10.05086231d0,
     &10.07485294d0,10.10305882d0,10.13256454d0,10.16172695d0,
     &10.18700027d0,10.21483421d0,10.24182224d0,10.26741600d0,
     &10.29395676d0,10.32451630d0,10.35226727d0,10.37888718d0,
     &10.40475655d0,10.43297672d0,10.45874596d0,10.48690891d0,
     &10.51567936d0,10.54091549d0,10.56706715d0,10.59307194d0,
     &10.61579990d0,10.64428806d0,10.67005253d0,10.69794846d0,
     &10.72618103d0,10.75482941d0,10.78252316d0,10.81412888d0,
     &10.84435844d0,10.87125111d0,10.89688969d0,10.92192173d0,
     &10.94900036d0,10.98128891d0,11.00850391d0,11.03928852d0,
     &11.06871319d0,11.09909058d0,11.12367630d0,11.15183640d0,
     &11.18272591d0,11.21140671d0,11.24419785d0,11.27419662d0,
     &11.29990673d0,11.33107567d0,11.35318470d0,11.38193226d0,
     &11.41057587d0,11.44071865d0,11.46814919d0,11.49743652d0,
     &11.52403736d0,11.54761791d0,11.57458973d0,11.60335159d0,
     &11.63152790d0,11.66121387d0,11.68688869d0,11.71362686d0,
     &11.73855019d0,11.76448441d0,11.79083157d0,11.81944275d0,
     &11.84799099d0,11.87495327d0,11.90506840d0,11.93410492d0,
     &11.96196651d0,11.99135113d0,12.01760578d0,12.04513454d0,
     &12.07365990d0,12.10309505d0,12.13234711d0,12.15933895d0,
     &12.19248009d0,12.22041988d0,12.25203609d0,12.28157425d0,
     &12.31001186d0,12.33943653d0,12.36823845d0,12.39366150d0,
     &12.41959000d0,12.44583035d0,12.47486210d0,12.50858116d0,
     &12.53792763d0,12.56644249d0,12.59078789d0,12.61572933d0,
     &12.64631748d0,12.67189121d0,12.70119858d0,12.73329163d0,
     &12.76395035d0,12.78780079d0,12.81881332d0,12.84896088d0,
     &12.87741756d0,12.90557289d0,12.93291187d0,12.95891190d0,
     &12.98547649d0,13.01573277d0,13.04404449d0,13.07310772d0,
     &13.09870911d0,13.12391663d0,13.14949417d0,13.18042564d0,
     &13.21044540d0,13.24129391d0,13.27306080d0,13.30142307d0,
     &13.32986546d0,13.35714245d0,13.38694382d0,13.41645336d0,
     &13.44638157d0,13.47509766d0,13.50402260d0,13.53260899d0,
     &13.56151962d0,13.59189415d0,13.62143612d0,13.64921761d0,
     &13.67660713d0,13.70497990d0,13.73523903d0,13.76659870d0,
     &13.79357910d0,13.81845665d0,13.84187603d0,13.86773682d0,
     &13.89556694d0,13.92272377d0,13.95059109d0,13.98005962d0,
     &14.00921154d0,14.03975964d0,14.07099438d0,14.10236263d0,
     &14.13423729d0,14.16220188d0,14.19261742d0,14.22149849d0,
     &14.25003910d0,14.27976608d0,14.30908489d0,14.33695316d0,
     &14.36598587d0,14.39441013d0,14.42474079d0,14.45389938d0,
     &14.48240948d0,14.51126003d0,14.53861332d0,14.56710625d0,
     &14.59270763d0,14.62228966d0,14.65405750d0,14.68224525d0,
     &14.71086693d0,14.73831177d0,14.76645374d0,14.79601765d0,
     &14.82248783d0,14.85235977d0,14.88144779d0,14.90844631d0,
     &14.93872833d0,14.96498013d0,14.99293423d0,15.02077866d0,
     &15.05359459d0,15.08541775d0,15.11465263d0,15.14547729d0,
     &15.17193127d0,15.20298767d0,15.23307228d0,15.26355934d0,
     &15.29166412d0,15.32213116d0,15.35208035d0,15.38367748d0,
     &15.41499805d0,15.44360161d0,15.47018433d0,15.49492550d0,
     &15.52412128d0,15.55563641d0,15.58707714d0,15.62090969d0,
     &15.64746761d0,15.67599869d0,15.70235729d0,15.73193741d0,
     &15.76074886d0,15.79347134d0,15.82716942d0,15.85443592d0,
     &15.88097095d0,15.91100407d0,15.94060898d0,15.96968555d0,
     &16.00137520d0,16.03235435d0,16.06518173d0,16.09408569d0,
     &16.12103081d0,16.14765549d0,16.17980194d0,16.20771217d0,
     &16.23845863d0,16.26965523d0,16.29940414d0,16.32752037d0,
     &16.35904694d0,16.38665962d0,16.41852951d0,16.44794464d0,
     &16.47908211d0,16.51220894d0,16.54482841d0,16.57644653d0,
     &16.61142159d0,16.64114380d0,16.67270088d0,16.70248604d0,
     &16.73221588d0,16.75886917d0,16.78527832d0,16.81382179d0,
     &16.84233093d0,16.87135315d0,16.89653397d0,16.92456245d0,
     &16.95552254d0,16.98854637d0,17.02135086d0,17.04938889d0,
     &17.08140945d0,17.11572075d0,17.14805412d0,17.18214417d0,
     &17.21288300d0,17.24540138d0,17.28130913d0,17.30783081d0,
     &17.33318329d0,17.35799980d0,17.38537598d0,17.41703033d0,
     &17.45228386d0,17.48118210d0,17.51200104d0,17.54258156d0,
     &17.57116127d0,17.60175705d0,17.63333511d0,17.66311073d0,
     &17.69772148d0,17.72831345d0,17.75660324d0,17.78724098d0,
     &17.81853294d0,17.84496117d0,17.87665367d0,17.90870857d0,
     &17.94374275d0,17.97431946d0,18.00077820d0,18.03610420d0,
     &18.07027626d0,18.10141563d0,18.13016891d0,18.16264534d0,
     &18.19218254d0,18.22014999d0,18.25606728d0,18.29068756d0,
     &18.32263756d0,18.35108948d0,18.38184929d0,18.41115761d0,
     &18.44448090d0,18.48501205d0,18.51907158d0,18.55007362d0,
     &18.57863045d0,18.61403275d0,18.64582825d0,18.67658615d0,
     &18.70646286d0,18.73844147d0,18.77251244d0,18.80350113d0,
     &18.83494377d0,18.86296082d0,18.89660263d0,18.93121147d0,
     &18.96002007d0,18.99135017d0,19.02397156d0,19.05599976d0,
     &19.08829498d0,19.11740112d0,19.15036774d0,19.18239021d0,
     &19.21617889d0,19.25150299d0,19.28205872d0,19.31439972d0,
     &19.34653664d0,19.37580299d0,19.40553093d0,19.43789291d0,
     &19.47380829d0,19.50483322d0,19.53446198d0,19.57736588d0,
     &19.60981560d0,19.63993073d0,19.67217064d0,19.70624733d0,
     &19.73914719d0,19.77375412d0,19.80756378d0,19.83898735d0,
     &19.87729263d0,19.91503525d0,19.94623184d0,19.97217369d0,
     &20.00840759d0,20.04031372d0,20.07196617d0,20.10496521d0,
     &20.13718987d0,20.16716766d0,20.19821930d0,20.23431015d0,
     &20.27825928d0,20.30900574d0,20.33962631d0,20.37530327d0,
     &20.41157913d0,20.44690132d0,20.49105263d0,20.52248383d0,
     &20.55284882d0,20.58290672d0,20.60973549d0,20.63567162d0,
     &20.66822815d0,20.69581223d0,20.73585129d0,20.76054382d0,
     &20.78788185d0,20.81469345d0,20.84778595d0,20.88350296d0,
     &20.90896606d0,20.94286728d0,20.97998047d0,21.01340866d0,
     &21.04971695d0,21.08161926d0,21.12005234d0,21.15948105d0,
     &21.19556808d0,21.23095512d0,21.26341820d0,21.29994965d0,
     &21.34124565d0,21.37531471d0,21.41328430d0,21.45085335d0,
     &21.48633575d0,21.52320862d0,21.55925179d0,21.59304047d0,
     &21.62772179d0,21.66315651d0,21.69919014d0,21.74214935d0,
     &21.77724075d0,21.80456352d0,21.83200836d0,21.86531258d0,
     &21.90055084d0,21.93835258d0,21.97875214d0,22.01784325d0,
     &22.05277443d0,22.08050346d0,22.11479759d0,22.14956474d0,
     &22.18278885d0,22.21889687d0,22.25833893d0,22.29465294d0,
     &22.33169556d0,22.37069702d0,22.40811539d0,22.44741440d0,
     &22.48514557d0,22.52690887d0,22.56724739d0,22.60079575d0,
     &22.64122581d0,22.67671585d0,22.71204567d0,22.74954796d0,
     &22.78703499d0,22.82489204d0,22.86626053d0,22.90045166d0,
     &22.93235016d0,22.97342110d0,23.01413345d0,23.04784203d0,
     &23.09167671d0,23.13252258d0,23.16349602d0,23.20793724d0,
     &23.24618530d0,23.28437424d0,23.32477570d0,23.36226654d0,
     &23.39913368d0,23.43817520d0,23.47544670d0,23.52091408d0,
     &23.55558014d0,23.60174942d0,23.63930893d0,23.67556953d0,
     &23.70951462d0,23.74626923d0,23.78445053d0,23.82406044d0,
     &23.86084938d0,23.89890480d0,23.93772888d0,23.98340225d0,
     &24.02772522d0,24.06154060d0,24.10665512d0,24.14540100d0,
     &24.17500877d0,24.21660233d0,24.25748062d0,24.29638863d0,
     &24.13765526d0,23.73697472d0,23.20064926d0,22.56548500d0,
     &21.85026932d0,21.08106232d0,20.25551987d0,19.37358093d0,
     &18.44959641d0,17.49588776d0,16.50573158d0,15.67899990d0,
     &15.06760120d0,14.56595802d0,14.13744354d0,13.76373577d0,
     &13.42797756d0,13.11493969d0,12.83655453d0,12.57855320d0,
     &12.33861923d0,12.11482811d0,11.90620232d0,11.70654488d0,
     &11.51546860d0,11.33563805d0,11.16311359d0,11.00216675d0,
     &10.84772587d0,10.70162487d0,10.55823994d0,10.42030144d0,
     &10.28923035d0,10.16096878d0,10.03876400d0, 9.91979980d0,
     & 9.80382633d0, 9.69300175d0, 9.58298874d0, 9.47944355d0,
     & 9.37602997d0, 9.27688885d0, 9.18106937d0, 9.08716202d0,
     & 8.99586201d0, 8.90703678d0, 8.82075596d0, 8.73520470d0,
     & 8.65247536d0, 8.57246780d0, 8.49250984d0, 8.41509819d0,
     & 8.34064102d0, 8.26619625d0, 8.19374084d0, 8.12315559d0,
     & 8.05350018d0, 7.98551941d0, 7.91906452d0, 7.85351419d0,
     & 7.78965950d0, 7.72711945d0, 7.66567898d0, 7.60439634d0,
     & 7.54539061d0, 7.48746014d0, 7.43033075d0, 7.37338400d0,
     & 7.31803322d0, 7.26418161d0, 7.21104527d0, 7.15789938d0,
     & 7.10597420d0, 7.05554104d0, 7.00597000d0, 6.95629978d0,
     & 6.90763474d0, 6.85990572d0, 6.81355858d0, 6.76759672d0,
     & 6.72187328d0, 6.67691612d0, 6.63284445d0, 6.58974648d0,
     & 6.54691410d0, 6.50455761d0, 6.46287727d0, 6.42188644d0,
     & 6.38162422d0, 6.34177732d0, 6.30244446d0, 6.26370573d0,
     & 6.22557545d0, 6.18803740d0, 6.15100002d0, 6.11446905d0,
     & 6.07844448d0, 6.04297876d0, 6.00796556d0, 5.97334766d0,
     & 5.93927908d0, 5.90572691d0, 5.87264347d0, 5.83997917d0,
     & 5.80772257d0, 5.77560902d0, 5.74429083d0, 5.71343851d0,
     & 5.68300056d0, 5.65290880d0, 5.62323332d0, 5.59350681d0,
     & 5.56444597d0, 5.53604317d0, 5.50801420d0, 5.48030138d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0,
     & 5.45297766d0, 5.45297766d0, 5.45297766d0, 5.45297766d0
     &/
c Definition of open field lines as Lupper=f(Iupper) for doy=031
      DATA (Lupper ( 2,I), I= 1, 1001) /
     & 9.78d0, 9.78d0, 9.78d0, 9.78d0, 9.79d0, 9.79d0, 9.79d0, 9.79d0,
     & 9.79d0, 9.80d0, 9.80d0, 9.80d0, 9.80d0, 9.80d0, 9.80d0, 9.80d0,
     & 9.80d0, 9.80d0, 9.80d0, 9.81d0, 9.81d0, 9.81d0, 9.81d0, 9.82d0,
     & 9.82d0, 9.82d0, 9.82d0, 9.83d0, 9.83d0, 9.83d0, 9.83d0, 9.83d0,
     & 9.84d0, 9.84d0, 9.84d0, 9.84d0, 9.85d0, 9.85d0, 9.85d0, 9.85d0,
     & 9.86d0, 9.86d0, 9.86d0, 9.86d0, 9.87d0, 9.87d0, 9.87d0, 9.87d0,
     & 9.87d0, 9.88d0, 9.88d0, 9.88d0, 9.88d0, 9.89d0, 9.89d0, 9.89d0,
     & 9.89d0, 9.90d0, 9.90d0, 9.90d0, 9.90d0, 9.91d0, 9.91d0, 9.91d0,
     & 9.91d0, 9.92d0, 9.92d0, 9.92d0, 9.92d0, 9.93d0, 9.93d0, 9.94d0,
     & 9.94d0, 9.94d0, 9.95d0, 9.95d0, 9.96d0, 9.96d0, 9.97d0, 9.97d0,
     & 9.98d0, 9.98d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.97d0,
     & 9.97d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.98d0,
     & 9.98d0, 9.98d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.98d0, 9.98d0,
     & 9.98d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.98d0, 9.98d0, 9.98d0, 9.98d0,
     & 9.97d0, 9.97d0, 9.97d0, 9.97d0, 9.97d0, 9.97d0, 9.97d0, 9.97d0,
     & 9.97d0, 9.97d0, 9.96d0, 9.96d0, 9.96d0, 9.96d0, 9.96d0, 9.95d0,
     & 9.95d0, 9.95d0, 9.95d0, 9.95d0, 9.95d0, 9.95d0, 9.95d0, 9.94d0,
     & 9.94d0, 9.94d0, 9.94d0, 9.94d0, 9.94d0, 9.93d0, 9.93d0, 9.93d0,
     & 9.93d0, 9.93d0, 9.92d0, 9.92d0, 9.92d0, 9.92d0, 9.92d0, 9.91d0,
     & 9.91d0, 9.91d0, 9.91d0, 9.90d0, 9.91d0, 9.91d0, 9.91d0, 9.91d0,
     & 9.90d0, 9.90d0, 9.90d0, 9.90d0, 9.89d0, 9.89d0, 9.89d0, 9.88d0,
     & 9.88d0, 9.88d0, 9.88d0, 9.88d0, 9.88d0, 9.88d0, 9.88d0, 9.87d0,
     & 9.87d0, 9.87d0, 9.86d0, 9.86d0, 9.86d0, 9.85d0, 9.85d0, 9.85d0,
     & 9.85d0, 9.85d0, 9.85d0, 9.85d0, 9.84d0, 9.83d0, 9.83d0, 9.83d0,
     & 9.83d0, 9.83d0, 9.83d0, 9.83d0, 9.83d0, 9.82d0, 9.82d0, 9.81d0,
     & 9.81d0, 9.81d0, 9.81d0, 9.81d0, 9.81d0, 9.81d0, 9.80d0, 9.80d0,
     & 9.79d0, 9.79d0, 9.79d0, 9.79d0, 9.79d0, 9.79d0, 9.78d0, 9.78d0,
     & 9.77d0, 9.77d0, 9.77d0, 9.77d0, 9.77d0, 9.76d0, 9.76d0, 9.75d0,
     & 9.75d0, 9.75d0, 9.76d0, 9.75d0, 9.75d0, 9.75d0, 9.74d0, 9.74d0,
     & 9.73d0, 9.74d0, 9.74d0, 9.73d0, 9.73d0, 9.73d0, 9.73d0, 9.72d0,
     & 9.72d0, 9.72d0, 9.72d0, 9.72d0, 9.72d0, 9.72d0, 9.71d0, 9.71d0,
     & 9.71d0, 9.71d0, 9.71d0, 9.71d0, 9.70d0, 9.70d0, 9.70d0, 9.70d0,
     & 9.70d0, 9.70d0, 9.70d0, 9.69d0, 9.70d0, 9.70d0, 9.70d0, 9.70d0,
     & 9.70d0, 9.69d0, 9.69d0, 9.69d0, 9.69d0, 9.69d0, 9.70d0, 9.69d0,
     & 9.69d0, 9.70d0, 9.70d0, 9.70d0, 9.70d0, 9.70d0, 9.69d0, 9.70d0,
     & 9.71d0, 9.71d0, 9.71d0, 9.71d0, 9.70d0, 9.72d0, 9.72d0, 9.72d0,
     & 9.72d0, 9.73d0, 9.72d0, 9.74d0, 9.74d0, 9.74d0, 9.75d0, 9.75d0,
     & 9.76d0, 9.77d0, 9.77d0, 9.78d0, 9.79d0, 9.79d0, 9.80d0, 9.81d0,
     & 9.82d0, 9.83d0, 9.84d0, 9.85d0, 9.87d0, 9.89d0, 9.91d0, 9.93d0,
     & 9.95d0, 9.97d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0,
     &10.00d0,10.00d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     &10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0,
     & 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     & 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.98d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0
     &/
      DATA (Iupper ( 2,I), I= 1, 1001) /
     & 0.00010000d0, 0.00010127d0, 0.00010255d0, 0.00010386d0,
     & 0.00010517d0, 0.00010651d0, 0.00010786d0, 0.00010923d0,
     & 0.00011062d0, 0.00011202d0, 0.00011344d0, 0.00011488d0,
     & 0.00011634d0, 0.00011782d0, 0.00011931d0, 0.00012083d0,
     & 0.00012236d0, 0.00012391d0, 0.00012548d0, 0.00012708d0,
     & 0.00012869d0, 0.00013032d0, 0.00013198d0, 0.00013365d0,
     & 0.00013535d0, 0.00013707d0, 0.00013881d0, 0.00014057d0,
     & 0.00014235d0, 0.00014416d0, 0.00014599d0, 0.00014784d0,
     & 0.00014972d0, 0.00015162d0, 0.00015354d0, 0.00015549d0,
     & 0.00015746d0, 0.00015946d0, 0.00016148d0, 0.00016353d0,
     & 0.00016561d0, 0.00016771d0, 0.00016984d0, 0.00017200d0,
     & 0.00017418d0, 0.00017639d0, 0.00017863d0, 0.00018089d0,
     & 0.00018319d0, 0.00018551d0, 0.00018787d0, 0.00019025d0,
     & 0.00019267d0, 0.00019511d0, 0.00019759d0, 0.00020010d0,
     & 0.00020264d0, 0.00020521d0, 0.00020781d0, 0.00021045d0,
     & 0.00021312d0, 0.00021583d0, 0.00021857d0, 0.00022134d0,
     & 0.00022415d0, 0.00022699d0, 0.00022987d0, 0.00023279d0,
     & 0.00023575d0, 0.00023874d0, 0.00024177d0, 0.00024484d0,
     & 0.00024794d0, 0.00025109d0, 0.00025428d0, 0.00025750d0,
     & 0.00026077d0, 0.00026408d0, 0.00026743d0, 0.00027083d0,
     & 0.00027426d0, 0.00027775d0, 0.00028127d0, 0.00028484d0,
     & 0.00028846d0, 0.00029212d0, 0.00029582d0, 0.00029958d0,
     & 0.00030338d0, 0.00030723d0, 0.00031113d0, 0.00031508d0,
     & 0.00031908d0, 0.00032313d0, 0.00032723d0, 0.00033138d0,
     & 0.00033559d0, 0.00033984d0, 0.00034416d0, 0.00034853d0,
     & 0.00035295d0, 0.00035743d0, 0.00036196d0, 0.00036656d0,
     & 0.00037121d0, 0.00037592d0, 0.00038069d0, 0.00038552d0,
     & 0.00039042d0, 0.00039537d0, 0.00040039d0, 0.00040547d0,
     & 0.00041062d0, 0.00041583d0, 0.00042111d0, 0.00042645d0,
     & 0.00043186d0, 0.00043734d0, 0.00044289d0, 0.00044852d0,
     & 0.00045421d0, 0.00045997d0, 0.00046581d0, 0.00047172d0,
     & 0.00047771d0, 0.00048377d0, 0.00048991d0, 0.00049613d0,
     & 0.00050243d0, 0.00050880d0, 0.00051526d0, 0.00052180d0,
     & 0.00052842d0, 0.00053513d0, 0.00054192d0, 0.00054880d0,
     & 0.00055576d0, 0.00056281d0, 0.00056996d0, 0.00057719d0,
     & 0.00058452d0, 0.00059194d0, 0.00059945d0, 0.00060706d0,
     & 0.00061476d0, 0.00062256d0, 0.00063046d0, 0.00063846d0,
     & 0.00064657d0, 0.00065477d0, 0.00066308d0, 0.00067150d0,
     & 0.00068002d0, 0.00068865d0, 0.00069739d0, 0.00070624d0,
     & 0.00071521d0, 0.00072428d0, 0.00073347d0, 0.00074278d0,
     & 0.00075221d0, 0.00076176d0, 0.00077142d0, 0.00078122d0,
     & 0.00079113d0, 0.00080117d0, 0.00081134d0, 0.00082164d0,
     & 0.00083206d0, 0.00084262d0, 0.00085332d0, 0.00086415d0,
     & 0.00087511d0, 0.00088622d0, 0.00089747d0, 0.00090886d0,
     & 0.00092039d0, 0.00093207d0, 0.00094390d0, 0.00095588d0,
     & 0.00096801d0, 0.00098030d0, 0.00099274d0, 0.00100534d0,
     & 0.00101810d0, 0.00103102d0, 0.00104411d0, 0.00105736d0,
     & 0.00107078d0, 0.00108437d0, 0.00109813d0, 0.00111206d0,
     & 0.00112618d0, 0.00114047d0, 0.00115495d0, 0.00116960d0,
     & 0.00118445d0, 0.00119948d0, 0.00121470d0, 0.00123012d0,
     & 0.00124573d0, 0.00126154d0, 0.00127755d0, 0.00129377d0,
     & 0.00131019d0, 0.00132681d0, 0.00134365d0, 0.00136071d0,
     & 0.00137797d0, 0.00139546d0, 0.00141317d0, 0.00143111d0,
     & 0.00144927d0, 0.00146766d0, 0.00148629d0, 0.00150515d0,
     & 0.00152426d0, 0.00154360d0, 0.00156319d0, 0.00158303d0,
     & 0.00160312d0, 0.00162347d0, 0.00164407d0, 0.00166494d0,
     & 0.00168607d0, 0.00170747d0, 0.00172914d0, 0.00175108d0,
     & 0.00177331d0, 0.00179581d0, 0.00181860d0, 0.00184168d0,
     & 0.00186506d0, 0.00188873d0, 0.00191270d0, 0.00193697d0,
     & 0.00196156d0, 0.00198645d0, 0.00201166d0, 0.00203719d0,
     & 0.00206305d0, 0.00208923d0, 0.00211575d0, 0.00214260d0,
     & 0.00216979d0, 0.00219733d0, 0.00222521d0, 0.00225346d0,
     & 0.00228206d0, 0.00231102d0, 0.00234035d0, 0.00237005d0,
     & 0.00240013d0, 0.00243059d0, 0.00246144d0, 0.00249268d0,
     & 0.00252431d0, 0.00255635d0, 0.00258879d0, 0.00262165d0,
     & 0.00265492d0, 0.00268862d0, 0.00272274d0, 0.00275729d0,
     & 0.00279229d0, 0.00282773d0, 0.00286361d0, 0.00289996d0,
     & 0.00293676d0, 0.00297403d0, 0.00301178d0, 0.00305000d0,
     & 0.00308871d0, 0.00312791d0, 0.00316761d0, 0.00320781d0,
     & 0.00324852d0, 0.00328975d0, 0.00333150d0, 0.00337378d0,
     & 0.00341660d0, 0.00345996d0, 0.00350387d0, 0.00354834d0,
     & 0.00359337d0, 0.00363898d0, 0.00368516d0, 0.00373193d0,
     & 0.00377930d0, 0.00382726d0, 0.00387583d0, 0.00392502d0,
     & 0.00397484d0, 0.00402528d0, 0.00407637d0, 0.00412811d0,
     & 0.00418050d0, 0.00423355d0, 0.00428728d0, 0.00434169d0,
     & 0.00439680d0, 0.00445260d0, 0.00450911d0, 0.00456633d0,
     & 0.00462429d0, 0.00468298d0, 0.00474241d0, 0.00480260d0,
     & 0.00486355d0, 0.00492528d0, 0.00498778d0, 0.00505109d0,
     & 0.00511519d0, 0.00518011d0, 0.00524585d0, 0.00531243d0,
     & 0.00537985d0, 0.00544813d0, 0.00551727d0, 0.00558730d0,
     & 0.00565821d0, 0.00573002d0, 0.00580274d0, 0.00587639d0,
     & 0.00595096d0, 0.00602649d0, 0.00610298d0, 0.00618043d0,
     & 0.00625887d0, 0.00633830d0, 0.00641874d0, 0.00650021d0,
     & 0.00658270d0, 0.00666625d0, 0.00675085d0, 0.00683653d0,
     & 0.00692329d0, 0.00701116d0, 0.00710014d0, 0.00719025d0,
     & 0.00728151d0, 0.00737392d0, 0.00746751d0, 0.00756228d0,
     & 0.00765826d0, 0.00775545d0, 0.00785387d0, 0.00795355d0,
     & 0.00805449d0, 0.00815672d0, 0.00826024d0, 0.00836507d0,
     & 0.00847124d0, 0.00857875d0, 0.00868762d0, 0.00879788d0,
     & 0.00890954d0, 0.00902261d0, 0.00913712d0, 0.00925308d0,
     & 0.00937052d0, 0.00948945d0, 0.00960988d0, 0.00973184d0,
     & 0.00985535d0, 0.00998043d0, 0.01010710d0, 0.01023537d0,
     & 0.01036527d0, 0.01049682d0, 0.01063004d0, 0.01076495d0,
     & 0.01090157d0, 0.01103993d0, 0.01118004d0, 0.01132193d0,
     & 0.01146563d0, 0.01161114d0, 0.01175850d0, 0.01190773d0,
     & 0.01205886d0, 0.01221190d0, 0.01236688d0, 0.01252384d0,
     & 0.01268278d0, 0.01284374d0, 0.01300676d0, 0.01317183d0,
     & 0.01333899d0, 0.01350829d0, 0.01367973d0, 0.01385334d0,
     & 0.01402915d0, 0.01420721d0, 0.01438751d0, 0.01457011d0,
     & 0.01475503d0, 0.01494229d0, 0.01513193d0, 0.01532398d0,
     & 0.01551846d0, 0.01571541d0, 0.01591486d0, 0.01611684d0,
     & 0.01632139d0, 0.01652853d0, 0.01673830d0, 0.01695073d0,
     & 0.01716586d0, 0.01738372d0, 0.01760434d0, 0.01782776d0,
     & 0.01805403d0, 0.01828315d0, 0.01851519d0, 0.01875018d0,
     & 0.01898814d0, 0.01922913d0, 0.01947318d0, 0.01972032d0,
     & 0.01997059d0, 0.02022405d0, 0.02048072d0, 0.02074065d0,
     & 0.02100387d0, 0.02127045d0, 0.02154040d0, 0.02181377d0,
     & 0.02209063d0, 0.02237098d0, 0.02265490d0, 0.02294243d0,
     & 0.02323360d0, 0.02352846d0, 0.02382708d0, 0.02412947d0,
     & 0.02443570d0, 0.02474584d0, 0.02505989d0, 0.02537793d0,
     & 0.02570002d0, 0.02602619d0, 0.02635649d0, 0.02669099d0,
     & 0.02702975d0, 0.02737279d0, 0.02772018d0, 0.02807200d0,
     & 0.02842827d0, 0.02878906d0, 0.02915444d0, 0.02952445d0,
     & 0.02989915d0, 0.03027862d0, 0.03066289d0, 0.03105204d0,
     & 0.03144613d0, 0.03184524d0, 0.03224939d0, 0.03265868d0,
     & 0.03307318d0, 0.03349292d0, 0.03391798d0, 0.03434846d0,
     & 0.03478439d0, 0.03522584d0, 0.03567292d0, 0.03612565d0,
     & 0.03658413d0, 0.03704845d0, 0.03751864d0, 0.03799480d0,
     & 0.03847702d0, 0.03896534d0, 0.03945986d0, 0.03996065d0,
     & 0.04046782d0, 0.04098141d0, 0.04150151d0, 0.04202824d0,
     & 0.04256163d0, 0.04310180d0, 0.04364883d0, 0.04420279d0,
     & 0.04476377d0, 0.04533191d0, 0.04590723d0, 0.04648984d0,
     & 0.04707986d0, 0.04767738d0, 0.04828247d0, 0.04889523d0,
     & 0.04951580d0, 0.05014421d0, 0.05078061d0, 0.05142510d0,
     & 0.05207775d0, 0.05273868d0, 0.05340803d0, 0.05408584d0,
     & 0.05477226d0, 0.05546741d0, 0.05617137d0, 0.05688425d0,
     & 0.05760621d0, 0.05833730d0, 0.05907768d0, 0.05982745d0,
     & 0.06058676d0, 0.06135568d0, 0.06213436d0, 0.06292295d0,
     & 0.06372152d0, 0.06453023d0, 0.06534923d0, 0.06617859d0,
     & 0.06701849d0, 0.06786907d0, 0.06873041d0, 0.06960268d0,
     & 0.07048602d0, 0.07138062d0, 0.07228653d0, 0.07320394d0,
     & 0.07413302d0, 0.07507385d0, 0.07602664d0, 0.07699155d0,
     & 0.07796867d0, 0.07895819d0, 0.07996030d0, 0.08097509d0,
     & 0.08200277d0, 0.08304353d0, 0.08409746d0, 0.08516476d0,
     & 0.08624565d0, 0.08734021d0, 0.08844867d0, 0.08957119d0,
     & 0.09070800d0, 0.09185920d0, 0.09302501d0, 0.09420566d0,
     & 0.09540125d0, 0.09661201d0, 0.09783818d0, 0.09907987d0,
     & 0.10033731d0, 0.10161077d0, 0.10290034d0, 0.10420627d0,
     & 0.10552878d0, 0.10686813d0, 0.10822441d0, 0.10959791d0,
     & 0.11098890d0, 0.11239749d0, 0.11382396d0, 0.11526857d0,
     & 0.11673148d0, 0.11821295d0, 0.11971328d0, 0.12123259d0,
     & 0.12277117d0, 0.12432936d0, 0.12590724d0, 0.12750517d0,
     & 0.12912343d0, 0.13076216d0, 0.13242172d0, 0.13410230d0,
     & 0.13580430d0, 0.13752782d0, 0.13927321d0, 0.14104085d0,
     & 0.14283082d0, 0.14464353d0, 0.14647931d0, 0.14833830d0,
     & 0.15022090d0, 0.15212746d0, 0.15405814d0, 0.15601335d0,
     & 0.15799335d0, 0.15999855d0, 0.16202913d0, 0.16408549d0,
     & 0.16616802d0, 0.16827691d0, 0.17041254d0, 0.17257537d0,
     & 0.17476557d0, 0.17698357d0, 0.17922980d0, 0.18150444d0,
     & 0.18380795d0, 0.18614081d0, 0.18850316d0, 0.19089550d0,
     & 0.19331829d0, 0.19577175d0, 0.19825633d0, 0.20077245d0,
     & 0.20332061d0, 0.20590100d0, 0.20851412d0, 0.21116054d0,
     & 0.21384043d0, 0.21655434d0, 0.21930277d0, 0.22208601d0,
     & 0.22490457d0, 0.22775897d0, 0.23064953d0, 0.23357674d0,
     & 0.23654114d0, 0.23954326d0, 0.24258336d0, 0.24566205d0,
     & 0.24877992d0, 0.25193724d0, 0.25513467d0, 0.25837275d0,
     & 0.26165181d0, 0.26497251d0, 0.26833546d0, 0.27174097d0,
     & 0.27518973d0, 0.27868235d0, 0.28221917d0, 0.28580090d0,
     & 0.28942820d0, 0.29310140d0, 0.29682124d0, 0.30058825d0,
     & 0.30440310d0, 0.30826664d0, 0.31217894d0, 0.31614089d0,
     & 0.32015309d0, 0.32421625d0, 0.32833093d0, 0.33249786d0,
     & 0.33671802d0, 0.34099138d0, 0.34531897d0, 0.34970152d0,
     & 0.35413966d0, 0.35863414d0, 0.36318600d0, 0.36779529d0,
     & 0.37246308d0, 0.37719008d0, 0.38197711d0, 0.38682488d0,
     & 0.39173418d0, 0.39670613d0, 0.40174085d0, 0.40683943d0,
     & 0.41200271d0, 0.41723153d0, 0.42252675d0, 0.42788953d0,
     & 0.43332002d0, 0.43881938d0, 0.44438851d0, 0.45002836d0,
     & 0.45573980d0, 0.46152416d0, 0.46738148d0, 0.47331312d0,
     & 0.47932005d0, 0.48540321d0, 0.49156362d0, 0.49780214d0,
     & 0.50412035d0, 0.51051831d0, 0.51699740d0, 0.52355874d0,
     & 0.53020334d0, 0.53693229d0, 0.54374713d0, 0.55064797d0,
     & 0.55763638d0, 0.56471354d0, 0.57188040d0, 0.57913828d0,
     & 0.58648884d0, 0.59393209d0, 0.60146987d0, 0.60910326d0,
     & 0.61683351d0, 0.62466192d0, 0.63258964d0, 0.64061862d0,
     & 0.64874887d0, 0.65698230d0, 0.66532022d0, 0.67376393d0,
     & 0.68231487d0, 0.69097501d0, 0.69974434d0, 0.70862496d0,
     & 0.71761823d0, 0.72672570d0, 0.73594880d0, 0.74528891d0,
     & 0.75474828d0, 0.76432699d0, 0.77402723d0, 0.78385061d0,
     & 0.79379863d0, 0.80387294d0, 0.81407589d0, 0.82440752d0,
     & 0.83487028d0, 0.84546578d0, 0.85619581d0, 0.86706197d0,
     & 0.87806606d0, 0.88921070d0, 0.90049589d0, 0.91192430d0,
     & 0.92349786d0, 0.93521816d0, 0.94708717d0, 0.95910788d0,
     & 0.97128016d0, 0.98360693d0, 0.99609011d0, 1.00873172d0,
     & 1.02153373d0, 1.03449929d0, 1.04762840d0, 1.06092405d0,
     & 1.07438850d0, 1.08802390d0, 1.10183227d0, 1.11581588d0,
     & 1.12997806d0, 1.14431894d0, 1.15884173d0, 1.17354894d0,
     & 1.18844259d0, 1.20352542d0, 1.21880090d0, 1.23426902d0,
     & 1.24993336d0, 1.26579666d0, 1.28186119d0, 1.29812956d0,
     & 1.31460571d0, 1.33128977d0, 1.34818542d0, 1.36529553d0,
     & 1.38262296d0, 1.40017009d0, 1.41794002d0, 1.43593681d0,
     & 1.45416057d0, 1.47261584d0, 1.49130499d0, 1.51023161d0,
     & 1.52939832d0, 1.54880977d0, 1.56846607d0, 1.58837199d0,
     & 1.60853028d0, 1.62894464d0, 1.64961791d0, 1.67055368d0,
     & 1.69175661d0, 1.71322715d0, 1.73497009d0, 1.75698900d0,
     & 1.77928746d0, 1.80186892d0, 1.82473862d0, 1.84789681d0,
     & 1.87134874d0, 1.89509857d0, 1.91914976d0, 1.94350624d0,
     & 1.96817160d0, 1.99315214d0, 2.01844788d0, 2.04406428d0,
     & 2.07000613d0, 2.09627700d0, 2.12288141d0, 2.14982557d0,
     & 2.17710948d0, 2.20473981d0, 2.23272061d0, 2.26105666d0,
     & 2.28975224d0, 2.31881428d0, 2.34824300d0, 2.37804508d0,
     & 2.40822554d0, 2.43878889d0, 2.46974015d0, 2.50108409d0,
     & 2.53282857d0, 2.56497312d0, 2.59752584d0, 2.63049173d0,
     & 2.66387582d0, 2.69768381d0, 2.73192358d0, 2.76659513d0,
     & 2.80170655d0, 2.83726382d0, 2.87327218d0, 2.90973759d0,
     & 2.94666839d0, 2.98406553d0, 3.02193713d0, 3.06028914d0,
     & 3.09912801d0, 3.13845992d0, 3.17829084d0, 3.21863031d0,
     & 3.25947881d0, 3.30084562d0, 3.34273744d0, 3.38516092d0,
     & 3.42812300d0, 3.47163343d0, 3.51569295d0, 3.56031132d0,
     & 3.60549593d0, 3.65125418d0, 3.69759321d0, 3.74452019d0,
     & 3.79204679d0, 3.84017253d0, 3.88890886d0, 3.93826389d0,
     & 3.98824549d0, 4.03886127d0, 4.09012318d0, 4.14203215d0,
     & 4.19460011d0, 4.24783468d0, 4.30174494d0, 4.35633945d0,
     & 4.41162682d0, 4.46762037d0, 4.52431965d0, 4.58173895d0,
     & 4.63988686d0, 4.69877291d0, 4.75840616d0, 4.81880093d0,
     & 4.87995768d0, 4.94189024d0, 5.00460863d0, 5.06812382d0,
     & 5.13244438d0, 5.19758654d0, 5.26355076d0, 5.33035135d0,
     & 5.39800024d0, 5.46650791d0, 5.53588486d0, 5.60614157d0,
     & 5.67729616d0, 5.74934816d0, 5.82231474d0, 5.89620686d0,
     & 5.97103739d0, 6.04681683d0, 6.12356472d0, 6.20128012d0,
     & 6.27998209d0, 6.35968304d0, 6.44039536d0, 6.52213240d0,
     & 6.60491228d0, 6.68873739d0, 6.77362537d0, 6.85959101d0,
     & 6.94664812d0, 7.03480911d0, 7.12408972d0, 7.21451092d0,
     & 7.30607176d0, 7.39879513d0, 7.49269533d0, 7.58778667d0,
     & 7.68408489d0, 7.78161287d0, 7.88037157d0, 7.98038340d0,
     & 8.08166409d0, 8.18422985d0, 8.28809834d0, 8.39328480d0,
     & 8.49981499d0, 8.60768700d0, 8.71692944d0, 8.82755852d0,
     & 8.93959141d0, 9.05304623d0, 9.16794872d0, 9.28430176d0,
     & 9.40213108d0, 9.52145576d0, 9.64229488d0, 9.76466751d0,
     & 9.88859367d0,10.01410198d0,10.14119339d0,10.26989746d0,
     &10.40023613d0,10.53222752d0,10.66589451d0,10.80126858d0,
     &10.93834972d0,11.07717133d0,11.21775436d0,11.36012173d0,
     &11.50429535d0,11.65031052d0,11.79816723d0,11.94790173d0,
     &12.09953499d0,12.25309372d0,12.40860081d0,12.56608105d0,
     &12.72557259d0,12.88707542d0,13.05062866d0,13.21625710d0,
     &13.38398838d0,13.55384827d0,13.72587585d0,13.90007496d0,
     &14.07648373d0,14.25513268d0,14.43604851d0,14.61925888d0,
     &14.80481052d0,14.99270153d0,15.18297768d0,15.37566853d0,
     &15.57080460d0,15.76841831d0,15.96853828d0,16.17121506d0,
     &16.37644768d0,16.58428574d0,16.79475975d0,17.00790787d0,
     &17.22375870d0,17.44236755d0,17.66373062d0,17.88790512d0,
     &18.11492538d0,18.34482765d0,18.57764626d0,18.81341934d0,
     &19.05220222d0,19.29399872d0,19.53886604d0,19.78683662d0,
     &20.03795815d0,20.29226303d0,20.54981613d0,20.81061935d0,
     &21.07473183d0,21.34219742d0,21.61305809d0,21.88735199d0,
     &22.16513062d0,22.44645500d0,22.73132896d0,23.01981735d0,
     &23.31196785d0,23.60782623d0,23.90743828d0,24.21087837d0,
     &24.51814270d0,24.82930946d0,25.14442444d0,25.46353912d0,
     &25.78670311d0,26.11399269d0,26.44541168d0,26.78103638d0,
     &27.12092209d0,27.46512032d0,27.81368637d0,28.16667747d0,
     &28.52417374d0,28.88618279d0,29.25278282d0,29.62404060d0,
     &30.00000572d0
     &/
c Definition of fits (4 deg polynomial) for doy=031
c A0=f(Lm) same for A1,A2,A3 and A4; to be used every where except Lm>7.5 and I> 1.
      DATA (Lm4 ( 2,I), I= 1,100) /
     & 1.10d0, 1.20d0, 1.30d0, 1.40d0, 1.50d0, 1.60d0, 1.70d0, 1.80d0,
     & 1.90d0, 2.00d0, 2.10d0, 2.20d0, 2.30d0, 2.40d0, 2.50d0, 2.60d0,
     & 2.70d0, 2.80d0, 2.90d0, 3.00d0, 3.10d0, 3.20d0, 3.30d0, 3.40d0,
     & 3.50d0, 3.60d0, 3.70d0, 3.80d0, 3.90d0, 4.00d0, 4.10d0, 4.20d0,
     & 4.30d0, 4.40d0, 4.50d0, 4.60d0, 4.70d0, 4.80d0, 4.90d0, 5.00d0,
     & 5.10d0, 5.20d0, 5.30d0, 5.40d0, 5.50d0, 5.60d0, 5.70d0, 5.80d0,
     & 5.90d0, 6.00d0, 6.10d0, 6.20d0, 6.30d0, 6.40d0, 6.50d0, 6.60d0,
     & 6.70d0, 6.80d0, 6.90d0, 7.00d0, 7.10d0, 7.20d0, 7.30d0, 7.40d0,
     & 7.50d0, 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0,
     & 8.30d0, 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0,
     & 9.10d0, 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0,
     & 9.90d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A0 ( 2,I), I= 1,100) /
     & 1.1018364938D+00, 1.2019510766D+00, 1.3013635028D+00,
     & 1.4016979384D+00, 1.5009694437D+00, 1.6012812336D+00,
     & 1.6995958046D+00, 1.8010245836D+00, 1.8998524428D+00,
     & 1.9988258932D+00, 2.0987190585D+00, 2.1982388510D+00,
     & 2.2973411107D+00, 2.3953698951D+00, 2.4880056134D+00,
     & 2.5866983999D+00, 2.6796379240D+00, 2.7739415793D+00,
     & 2.8687893789D+00, 2.9616491028D+00, 3.0538698270D+00,
     & 3.1447552930D+00, 3.2356392020D+00, 3.3293841855D+00,
     & 3.4134373315D+00, 3.5090068417D+00, 3.5912631634D+00,
     & 3.6805525090D+00, 3.7646799926D+00, 3.8540061957D+00,
     & 3.9388144204D+00, 4.0224432609D+00, 4.1075107383D+00,
     & 4.1898765878D+00, 4.2730428442D+00, 4.3570620939D+00,
     & 4.4382744217D+00, 4.5191859119D+00, 4.5955713242D+00,
     & 4.6789336912D+00, 4.7587861181D+00, 4.8442701427D+00,
     & 4.9189992080D+00, 5.0008055619D+00, 5.0815524111D+00,
     & 5.1592646044D+00, 5.2407116308D+00, 5.3205221238D+00,
     & 5.4030905414D+00, 5.4819573764D+00, 5.5618994271D+00,
     & 5.6437535211D+00, 5.7228974970D+00, 5.8047735917D+00,
     & 5.8856578313D+00, 5.9671136936D+00, 6.0489364373D+00,
     & 6.1309343915D+00, 6.2147735414D+00, 6.2987842176D+00,
     & 6.3804939256D+00, 6.4638134457D+00, 6.5482773299D+00,
     & 6.6334755403D+00, 6.7183049377D+00, 6.8064475917D+00,
     & 6.8982085004D+00, 6.9913231134D+00, 7.0811647414D+00,
     & 7.1648628531D+00, 7.2620822366D+00, 7.3661323423D+00,
     & 7.4659470333D+00, 7.5717945861D+00, 7.6810410472D+00,
     & 7.7978155067D+00, 7.9238804928D+00, 8.0494680941D+00,
     & 8.1763548126D+00, 8.3222458890D+00, 8.4494385434D+00,
     & 8.5986206327D+00, 8.7523523019D+00, 8.8811306623D+00,
     & 9.0410467905D+00, 9.1821457801D+00, 9.3185794697D+00,
     & 9.4447337201D+00, 9.5529332772D+00,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A1 ( 2,I), I= 1,100) /
     &-5.3508675831D-06, 2.2831565044D-04, 3.1699994762D-04,
     & 3.2488161571D-04, 2.0461596583D-04, 4.5364368526D-04,
     & 2.6072777911D-04,-2.8484881237D-04, 1.4918545555D-04,
     &-4.8147022247D-05, 5.3405216268D-04, 1.2811548677D-03,
     & 3.5113729357D-03, 4.4349597025D-03, 6.5775182716D-03,
     & 6.9154210255D-03, 7.3637208337D-03, 9.6428034138D-03,
     & 1.0415688792D-02, 1.3306329817D-02, 1.3380614514D-02,
     & 1.5173833195D-02, 1.6925275683D-02, 1.6134333381D-02,
     & 1.7989994146D-02, 1.9491299191D-02, 2.1545089730D-02,
     & 2.1191005654D-02, 2.5104191174D-02, 2.4727174193D-02,
     & 2.6779444335D-02, 2.6052164454D-02, 2.9184541133D-02,
     & 3.1013615341D-02, 3.1272377027D-02, 3.0714972970D-02,
     & 3.3113990533D-02, 3.3736263902D-02, 3.4949478520D-02,
     & 3.5467199795D-02, 3.5199708209D-02, 3.6158922541D-02,
     & 3.6602835163D-02, 3.6385879821D-02, 3.5990589484D-02,
     & 3.6226615215D-02, 3.6801149341D-02, 3.7368973391D-02,
     & 3.7974990446D-02, 3.7265214047D-02, 3.6100920030D-02,
     & 3.5570845639D-02, 3.4081527324D-02, 3.2915698966D-02,
     & 3.0942092209D-02, 3.2789564288D-02, 3.1441745319D-02,
     & 2.9692663864D-02, 2.9707428496D-02, 2.7434714404D-02,
     & 2.4877513661D-02, 2.6276304748D-02, 2.3276509625D-02,
     & 2.1237905386D-02, 2.0013918533D-02, 2.8317063250D-02,
     & 2.9231893057D-02, 3.0934581021D-02, 3.0541488727D-02,
     & 1.3530897890D-02, 1.5584720878D-02, 7.5394141782D-03,
     & 1.0233929777D-02, 1.0337879023D-03, 1.7345993439D-03,
     & 6.2815901330D-03, 1.2142931135D-02, 2.0903879087D-03,
     & 4.5999717908D-03, 1.6610421128D-02, 1.2189258459D-02,
     & 1.2751562158D-02, 3.3619266327D-02,-5.3784997543D-04,
     & 4.7829459602D-02, 4.8973830626D-02, 6.6047498912D-02,
     & 6.9795234546D-02, 5.8443429448D-02,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A2 ( 2,I), I= 1,100) /
     &-1.0979600401D-05,-2.6525960690D-06, 1.0413733950D-05,
     & 2.1827017998D-06, 3.6812140958D-07, 2.1757735091D-05,
     & 7.6865222021D-06,-2.7738907793D-04,-7.3892120733D-06,
     &-5.3709148983D-05, 5.9611892838D-07, 9.4645632870D-05,
     & 7.4482563762D-04, 3.5270965098D-04, 1.2690920371D-03,
     & 9.5642864863D-04, 1.5685662984D-03, 2.0553388743D-03,
     & 2.0644431222D-03, 3.6835037101D-03, 2.4370053484D-03,
     & 3.7072015543D-03, 4.0643602824D-03, 3.6153321987D-03,
     & 4.0686741477D-03, 4.2930059172D-03, 4.8953169191D-03,
     & 5.4367085340D-03, 6.1557779411D-03, 5.6171441754D-03,
     & 6.1622925310D-03, 6.2344004728D-03, 6.1302546323D-03,
     & 6.5396651303D-03, 6.8568461341D-03, 7.0613482913D-03,
     & 8.1065092759D-03, 8.3411234323D-03, 8.5341945262D-03,
     & 8.7575481201D-03, 8.5088615819D-03, 8.4713847698D-03,
     & 9.2928379541D-03, 8.4595029345D-03, 8.8651373586D-03,
     & 8.9564857483D-03, 8.4275799746D-03, 8.7631613229D-03,
     & 7.7347496886D-03, 7.3463104674D-03, 7.1822563166D-03,
     & 7.0940405095D-03, 7.5392976118D-03, 6.9462605954D-03,
     & 6.6564367162D-03, 5.9909471488D-03, 6.3270807307D-03,
     & 5.3567109152D-03, 4.7310630894D-03, 4.2052779478D-03,
     & 4.1289931919D-03, 3.7562661336D-03, 3.1120337257D-03,
     & 2.4806880415D-03, 2.1936502304D-03, 8.0645912443D-03,
     & 8.3023076377D-03, 1.0251841863D-02, 8.7674068984D-03,
     & 2.8083084774D-03, 5.7226632827D-03, 2.2577884646D-04,
     & 3.0668366088D-03,-1.1132117443D-03, 1.1720555606D-03,
     & 2.4607526371D-03, 2.4230730313D-03,-2.7372107489D-03,
     &-1.4281820591D-03, 4.7588930011D-03, 7.1815649735D-03,
     & 3.4603442980D-03, 1.0240340820D-02,-4.4131796907D-03,
     & 1.4126207165D-02, 1.1182220979D-02, 1.7894760393D-02,
     & 1.7840025144D-02, 1.1697148016D-02,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A3 ( 2,I), I= 1,100) /
     & 7.8721682807D-07,-1.4972470017D-06,-2.5240208528D-06,
     &-2.4337296297D-06,-7.4380824228D-07,-4.4945304441D-06,
     &-1.7440526308D-06,-5.9002165156D-05,-2.2321413752D-06,
     &-2.0117647618D-06,-5.4120803101D-06,-8.0179889670D-06,
     & 7.1930376178D-05,-4.5328936950D-05, 1.0076421572D-04,
     & 1.3733385699D-05, 1.4680487973D-04, 1.7563246716D-04,
     & 1.7008998653D-04, 4.3289470746D-04, 1.4086052371D-04,
     & 3.8417910707D-04, 4.0298870820D-04, 3.4157731768D-04,
     & 3.7920653455D-04, 3.8468234532D-04, 4.5656061034D-04,
     & 6.0203543942D-04, 6.2166719487D-04, 5.3858194726D-04,
     & 5.8192661310D-04, 6.3147958334D-04, 4.9631677558D-04,
     & 5.2003590683D-04, 6.0678981346D-04, 6.5721081812D-04,
     & 8.5869112046D-04, 8.7671971438D-04, 8.3664335807D-04,
     & 9.2486530488D-04, 8.7754845609D-04, 8.2363838763D-04,
     & 9.9661415627D-04, 7.7805247100D-04, 8.9611808750D-04,
     & 8.6848140137D-04, 7.7467610558D-04, 8.3939371412D-04,
     & 5.8082313174D-04, 5.1833326202D-04, 5.4293219054D-04,
     & 4.8007188647D-04, 7.0301406245D-04, 5.7186978896D-04,
     & 5.4095070077D-04, 2.9217491706D-04, 4.3648225463D-04,
     & 2.3322989225D-04, 9.0063489575D-05, 1.4173891608D-04,
     & 1.6589234210D-04, 4.4735756949D-05, 1.9600248142D-05,
     &-1.1615527676D-04,-2.2200033542D-04, 9.3608462568D-04,
     & 9.3935213860D-04, 1.3147757858D-03, 1.0075390398D-03,
     & 2.2699257627D-04, 7.9673229105D-04,-1.5244243127D-04,
     & 4.0778827737D-04,-2.2667269383D-04, 2.0717332526D-04,
     & 3.7347435284D-04, 1.2702278949D-04,-6.7683518708D-04,
     &-5.5455673766D-04, 6.3008119331D-04, 1.3488740437D-03,
     & 6.2571278748D-04, 1.2908295631D-03,-5.7423769048D-04,
     & 1.8811481396D-03, 1.0905419138D-03, 2.0954635491D-03,
     & 1.9395833300D-03, 9.1339545289D-04,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A4 ( 2,I), I= 1,100) /
     & 1.5528891886D-07, 9.9622579024D-09,-1.9100420033D-07,
     &-9.6827317911D-09,-7.7024524593D-09,-3.7310306381D-07,
     &-1.1122434181D-07,-3.8145154329D-06,-1.1320953641D-07,
     & 1.6828368978D-07,-2.5157063359D-07,-8.6969470172D-07,
     & 2.5432424757D-06,-5.1273833327D-06, 2.7428573965D-06,
     &-2.9843660195D-06, 5.1146390072D-06, 5.1557029056D-06,
     & 4.8411906223D-06, 1.8056274305D-05, 2.0338452653D-07,
     & 1.4375601134D-05, 1.3995454436D-05, 1.1382211695D-05,
     & 1.2189648155D-05, 1.1587893808D-05, 1.4581081510D-05,
     & 2.3938939568D-05, 2.2171742827D-05, 1.8358580142D-05,
     & 1.8694460926D-05, 2.2823924596D-05, 1.1929969681D-05,
     & 1.1645876209D-05, 1.7715075172D-05, 2.0418437012D-05,
     & 3.3147793290D-05, 3.2633960895D-05, 2.8025133061D-05,
     & 3.5611950076D-05, 3.2973574164D-05, 2.8401106141D-05,
     & 3.8036705818D-05, 2.3251272553D-05, 3.1552005735D-05,
     & 2.7756314785D-05, 2.3837462561D-05, 2.7657945680D-05,
     & 1.1576985119D-05, 7.9201776934D-06, 1.1757904659D-05,
     & 4.8441909563D-06, 2.3515618133D-05, 1.4359679564D-05,
     & 1.2317963943D-05,-5.4945125722D-06, 5.7291864073D-06,
     &-7.8585004261D-06,-1.5999737645D-05,-7.5176539307D-06,
     &-5.9735245866D-06,-1.3385913185D-05,-1.1791346851D-05,
     &-2.1091913207D-05,-2.9687698557D-05, 3.7867486772D-05,
     & 3.7337174962D-05, 5.7941399011D-05, 4.0347341400D-05,
     & 4.9682776743D-06, 3.7498259359D-05,-1.2847250472D-05,
     & 1.8866542505D-05,-1.2330720730D-05, 1.0624203256D-05,
     & 1.8538934130D-05,-1.6012795228D-06,-4.1950556243D-05,
     &-4.0578000343D-05, 2.9504520917D-05, 7.6422836005D-05,
     & 3.9960964872D-05, 5.5168603882D-05,-1.6773584201D-05,
     & 9.0381049839D-05, 3.7309914886D-05, 8.8975792291D-05,
     & 7.5715051242D-05, 2.0152087611D-05,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of fits (5 deg polynomial) for doy=031
c A50=f(Lm5) same for A51,A52,A53, A54 and A55
c To be used only where Lm>7.5 and I> 1.
      DATA (Lm5 ( 2,I), I= 1,100) /
     & 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0, 8.30d0,
     & 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0, 9.10d0,
     & 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0, 9.90d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A50 ( 2,I), I= 1,100) /
     & 6.8061892954D+00, 6.8946269651D+00, 6.9875409332D+00,
     & 7.0807222616D+00, 7.1668218583D+00, 7.2621173058D+00,
     & 7.3631964619D+00, 7.4621599837D+00, 7.5690737568D+00,
     & 7.6791369156D+00, 7.7918498815D+00, 7.9135487092D+00,
     & 8.0449072834D+00, 8.1692812987D+00, 8.3092304820D+00,
     & 8.4364269589D+00, 8.5924231960D+00, 8.7469149353D+00,
     & 8.8781693424D+00, 9.0264959008D+00, 9.1757793596D+00,
     & 9.3101136786D+00, 9.4375421883D+00, 9.6402991362D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A51 ( 2,I), I= 1,100) /
     & 1.4989558000D-02, 1.4669341764D-02, 1.4993085166D-03,
     & 1.6926723493D-04, 2.8206113057D-02,-8.7729714251D-03,
     &-3.8667615580D-02, 5.5000385745D-03,-1.1041419510D-02,
     &-1.8106000558D-02,-1.9519363703D-02,-6.0182006956D-02,
     &-7.5278868836D-02,-9.2598146901D-03, 4.2885011551D-04,
     & 6.7183338436D-02, 7.2718694598D-02, 9.2908916790D-02,
     & 1.4281758520D-01, 9.0246794052D-02, 3.5852714485D-02,
     & 3.2597016432D-02, 1.1813401431D-01, 2.2595889553D-01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A52 ( 2,I), I= 1,100) /
     & 2.4890910789D-02, 4.4391898093D-02, 7.0484819481D-02,
     & 6.0257261662D-02, 3.2940742425D-03, 6.8180733037D-02,
     & 9.4945733795D-02,-2.5856836830D-02,-3.7523910948D-03,
     &-3.5117247729D-02,-5.0115245612D-02, 2.2295855223D-02,
     &-1.4557035830D-02,-1.8658113760D-01,-2.4750393437D-01,
     &-3.3840239772D-01,-3.7716905544D-01,-3.6617995698D-01,
     &-3.4297675198D-01,-1.1619027660D-01, 1.2448830431D-01,
     & 2.4520889375D-01, 2.5271019204D-02,-2.3791936768D-01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A53 ( 2,I), I= 1,100) /
     &-1.2517990320D-02,-5.0550899186D-02,-8.0387593273D-02,
     &-6.9910852673D-02,-1.9101198750D-02,-6.5452422678D-02,
     &-7.1836220057D-02, 2.0775525616D-02,-1.0199641939D-02,
     & 2.6650031458D-02, 2.6601192343D-02,-5.3091576967D-02,
     &-1.3710523181D-02, 1.1325064616D-01, 1.5112110028D-01,
     & 1.6353777005D-01, 1.7035684379D-01, 8.5638901505D-02,
     &-1.1001388082D-02,-2.7094479626D-01,-5.2734099433D-01,
     &-6.7637135367D-01,-4.8566413119D-01,-3.1694929272D-01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A54 ( 2,I), I= 1,100) /
     &-2.5750116248D-03, 1.7817360209D-02, 3.0740719405D-02,
     & 2.5919004403D-02, 3.7478296276D-03, 1.7020849380D-02,
     & 1.3990552515D-02,-1.4870517749D-02, 3.9534037636D-04,
     &-1.6307856431D-02,-1.3199972639D-02, 2.1140824617D-02,
     & 4.3621630225D-03,-3.7190054133D-02,-4.8050135763D-02,
     &-3.6897370558D-02,-3.5125971460D-02, 1.2890163554D-02,
     & 5.9159794871D-02, 1.6219806005D-01, 2.5600681527D-01,
     & 3.1225055069D-01, 2.4091644748D-01, 1.9075465269D-01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A55 ( 2,I), I= 1,100) /
     & 1.4329332649D-03,-1.9850533901D-03,-3.9122271518D-03,
     &-3.1812449058D-03, 3.4916568566D-04,-9.6948920549D-04,
     & 6.8226883548D-05, 3.1827251001D-03, 7.2834956424D-04,
     & 3.3442459330D-03, 2.7473680164D-03,-2.2930606243D-03,
     & 2.7181435020D-04, 5.3684277183D-03, 6.6189146708D-03,
     & 3.7806303302D-03, 3.4897905417D-03,-4.1472657941D-03,
     &-1.0517308994D-02,-2.4036647717D-02,-3.5352847858D-02,
     &-4.2256077210D-02,-3.2834755956D-02,-2.6955351306D-02,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of Loss cone as Lmax=f(Imax) for doy=061
      DATA (Lmax ( 3,I), I= 1, 2100) /
     & 1.0843d0, 1.0853d0, 1.0863d0, 1.0873d0, 1.0883d0, 1.0893d0,
     & 1.0903d0, 1.0913d0, 1.0922d0, 1.0932d0, 1.0942d0, 1.0952d0,
     & 1.0962d0, 1.0972d0, 1.0982d0, 1.0992d0, 1.1002d0, 1.1012d0,
     & 1.1023d0, 1.1033d0, 1.1043d0, 1.1053d0, 1.1063d0, 1.1073d0,
     & 1.1083d0, 1.1094d0, 1.1104d0, 1.1114d0, 1.1124d0, 1.1134d0,
     & 1.1145d0, 1.1155d0, 1.1165d0, 1.1175d0, 1.1186d0, 1.1196d0,
     & 1.1206d0, 1.1216d0, 1.1226d0, 1.1237d0, 1.1247d0, 1.1257d0,
     & 1.1267d0, 1.1278d0, 1.1288d0, 1.1298d0, 1.1308d0, 1.1319d0,
     & 1.1329d0, 1.1339d0, 1.1350d0, 1.1360d0, 1.1370d0, 1.1380d0,
     & 1.1391d0, 1.1401d0, 1.1411d0, 1.1421d0, 1.1432d0, 1.1442d0,
     & 1.1452d0, 1.1462d0, 1.1473d0, 1.1483d0, 1.1493d0, 1.1503d0,
     & 1.1514d0, 1.1524d0, 1.1534d0, 1.1544d0, 1.1555d0, 1.1565d0,
     & 1.1575d0, 1.1585d0, 1.1596d0, 1.1606d0, 1.1616d0, 1.1626d0,
     & 1.1637d0, 1.1647d0, 1.1657d0, 1.1667d0, 1.1678d0, 1.1688d0,
     & 1.1698d0, 1.1709d0, 1.1719d0, 1.1729d0, 1.1739d0, 1.1749d0,
     & 1.1760d0, 1.1770d0, 1.1780d0, 1.1790d0, 1.1801d0, 1.1811d0,
     & 1.1821d0, 1.1832d0, 1.1842d0, 1.1852d0, 1.1862d0, 1.1872d0,
     & 1.1883d0, 1.1893d0, 1.1903d0, 1.1914d0, 1.1924d0, 1.1934d0,
     & 1.1944d0, 1.1954d0, 1.1965d0, 1.1975d0, 1.1985d0, 1.1996d0,
     & 1.2006d0, 1.2016d0, 1.2026d0, 1.2036d0, 1.2047d0, 1.2057d0,
     & 1.2067d0, 1.2078d0, 1.2088d0, 1.2098d0, 1.2108d0, 1.2118d0,
     & 1.2129d0, 1.2139d0, 1.2149d0, 1.2159d0, 1.2170d0, 1.2180d0,
     & 1.2190d0, 1.2200d0, 1.2211d0, 1.2221d0, 1.2231d0, 1.2241d0,
     & 1.2251d0, 1.2262d0, 1.2272d0, 1.2282d0, 1.2292d0, 1.2303d0,
     & 1.2313d0, 1.2323d0, 1.2333d0, 1.2343d0, 1.2353d0, 1.2364d0,
     & 1.2374d0, 1.2384d0, 1.2395d0, 1.2405d0, 1.2415d0, 1.2425d0,
     & 1.2435d0, 1.2445d0, 1.2456d0, 1.2466d0, 1.2476d0, 1.2487d0,
     & 1.2497d0, 1.2507d0, 1.2517d0, 1.2527d0, 1.2537d0, 1.2547d0,
     & 1.2558d0, 1.2568d0, 1.2578d0, 1.2589d0, 1.2599d0, 1.2609d0,
     & 1.2619d0, 1.2629d0, 1.2639d0, 1.2650d0, 1.2660d0, 1.2670d0,
     & 1.2680d0, 1.2691d0, 1.2701d0, 1.2711d0, 1.2721d0, 1.2731d0,
     & 1.2741d0, 1.2752d0, 1.2762d0, 1.2772d0, 1.2782d0, 1.2793d0,
     & 1.2803d0, 1.2813d0, 1.2823d0, 1.2833d0, 1.2843d0, 1.2854d0,
     & 1.2864d0, 1.2874d0, 1.2884d0, 1.2894d0, 1.2905d0, 1.2915d0,
     & 1.2925d0, 1.2935d0, 1.2945d0, 1.2955d0, 1.2966d0, 1.2976d0,
     & 1.2986d0, 1.2996d0, 1.3006d0, 1.3017d0, 1.3027d0, 1.3037d0,
     & 1.3047d0, 1.3057d0, 1.3067d0, 1.3078d0, 1.3088d0, 1.3098d0,
     & 1.3108d0, 1.3118d0, 1.3129d0, 1.3139d0, 1.3149d0, 1.3159d0,
     & 1.3169d0, 1.3179d0, 1.3189d0, 1.3200d0, 1.3210d0, 1.3220d0,
     & 1.3230d0, 1.3240d0, 1.3250d0, 1.3261d0, 1.3271d0, 1.3281d0,
     & 1.3291d0, 1.3301d0, 1.3311d0, 1.3322d0, 1.3332d0, 1.3342d0,
     & 1.3352d0, 1.3362d0, 1.3372d0, 1.3383d0, 1.3393d0, 1.3403d0,
     & 1.3413d0, 1.3423d0, 1.3433d0, 1.3443d0, 1.3454d0, 1.3464d0,
     & 1.3474d0, 1.3484d0, 1.3494d0, 1.3504d0, 1.3515d0, 1.3525d0,
     & 1.3535d0, 1.3545d0, 1.3555d0, 1.3565d0, 1.3575d0, 1.3586d0,
     & 1.3596d0, 1.3606d0, 1.3616d0, 1.3626d0, 1.3636d0, 1.3647d0,
     & 1.3657d0, 1.3667d0, 1.3677d0, 1.3687d0, 1.3697d0, 1.3707d0,
     & 1.3717d0, 1.3727d0, 1.3738d0, 1.3748d0, 1.3758d0, 1.3768d0,
     & 1.3779d0, 1.3788d0, 1.3798d0, 1.3808d0, 1.3819d0, 1.3829d0,
     & 1.3839d0, 1.3849d0, 1.3859d0, 1.3869d0, 1.3880d0, 1.3890d0,
     & 1.3900d0, 1.3910d0, 1.3920d0, 1.3930d0, 1.3940d0, 1.3950d0,
     & 1.3960d0, 1.3971d0, 1.3981d0, 1.3991d0, 1.4001d0, 1.4011d0,
     & 1.4022d0, 1.4032d0, 1.4042d0, 1.4052d0, 1.4062d0, 1.4072d0,
     & 1.4082d0, 1.4092d0, 1.4102d0, 1.4112d0, 1.4123d0, 1.4133d0,
     & 1.4143d0, 1.4153d0, 1.4163d0, 1.4174d0, 1.4184d0, 1.4194d0,
     & 1.4203d0, 1.4213d0, 1.4223d0, 1.4234d0, 1.4244d0, 1.4254d0,
     & 1.4264d0, 1.4274d0, 1.4285d0, 1.4295d0, 1.4305d0, 1.4315d0,
     & 1.4325d0, 1.4335d0, 1.4345d0, 1.4355d0, 1.4365d0, 1.4375d0,
     & 1.4385d0, 1.4395d0, 1.4406d0, 1.4416d0, 1.4426d0, 1.4436d0,
     & 1.4446d0, 1.4457d0, 1.4467d0, 1.4477d0, 1.4487d0, 1.4497d0,
     & 1.4507d0, 1.4517d0, 1.4527d0, 1.4537d0, 1.4547d0, 1.4557d0,
     & 1.4567d0, 1.4578d0, 1.4588d0, 1.4598d0, 1.4608d0, 1.4619d0,
     & 1.4629d0, 1.4638d0, 1.4648d0, 1.4658d0, 1.4668d0, 1.4678d0,
     & 1.4688d0, 1.4698d0, 1.4709d0, 1.4719d0, 1.4729d0, 1.4739d0,
     & 1.4750d0, 1.4760d0, 1.4770d0, 1.4780d0, 1.4790d0, 1.4800d0,
     & 1.4810d0, 1.4820d0, 1.4830d0, 1.4840d0, 1.4850d0, 1.4860d0,
     & 1.4870d0, 1.4880d0, 1.4891d0, 1.4901d0, 1.4911d0, 1.4921d0,
     & 1.4932d0, 1.4942d0, 1.4951d0, 1.4961d0, 1.4971d0, 1.4981d0,
     & 1.4991d0, 1.5001d0, 1.5011d0, 1.5021d0, 1.5032d0, 1.5042d0,
     & 1.5052d0, 1.5062d0, 1.5073d0, 1.5083d0, 1.5093d0, 1.5103d0,
     & 1.5113d0, 1.5123d0, 1.5132d0, 1.5142d0, 1.5152d0, 1.5162d0,
     & 1.5173d0, 1.5183d0, 1.5193d0, 1.5203d0, 1.5213d0, 1.5224d0,
     & 1.5234d0, 1.5244d0, 1.5254d0, 1.5264d0, 1.5274d0, 1.5284d0,
     & 1.5294d0, 1.5304d0, 1.5314d0, 1.5324d0, 1.5334d0, 1.5344d0,
     & 1.5354d0, 1.5364d0, 1.5374d0, 1.5385d0, 1.5395d0, 1.5405d0,
     & 1.5415d0, 1.5426d0, 1.5436d0, 1.5446d0, 1.5456d0, 1.5465d0,
     & 1.5475d0, 1.5485d0, 1.5495d0, 1.5505d0, 1.5515d0, 1.5525d0,
     & 1.5535d0, 1.5545d0, 1.5556d0, 1.5566d0, 1.5576d0, 1.5586d0,
     & 1.5597d0, 1.5607d0, 1.5617d0, 1.5627d0, 1.5637d0, 1.5647d0,
     & 1.5657d0, 1.5666d0, 1.5676d0, 1.5686d0, 1.5696d0, 1.5706d0,
     & 1.5716d0, 1.5726d0, 1.5736d0, 1.5747d0, 1.5757d0, 1.5767d0,
     & 1.5777d0, 1.5788d0, 1.5798d0, 1.5808d0, 1.5818d0, 1.5828d0,
     & 1.5838d0, 1.5848d0, 1.5857d0, 1.5867d0, 1.5877d0, 1.5887d0,
     & 1.5897d0, 1.5907d0, 1.5917d0, 1.5927d0, 1.5938d0, 1.5948d0,
     & 1.5958d0, 1.5968d0, 1.5979d0, 1.5989d0, 1.5999d0, 1.6009d0,
     & 1.6019d0, 1.6029d0, 1.6039d0, 1.6049d0, 1.6059d0, 1.6068d0,
     & 1.6078d0, 1.6088d0, 1.6098d0, 1.6108d0, 1.6118d0, 1.6128d0,
     & 1.6138d0, 1.6149d0, 1.6159d0, 1.6169d0, 1.6180d0, 1.6190d0,
     & 1.6200d0, 1.6210d0, 1.6220d0, 1.6230d0, 1.6240d0, 1.6250d0,
     & 1.6260d0, 1.6269d0, 1.6279d0, 1.6289d0, 1.6299d0, 1.6309d0,
     & 1.6319d0, 1.6329d0, 1.6339d0, 1.6350d0, 1.6360d0, 1.6370d0,
     & 1.6381d0, 1.6391d0, 1.6401d0, 1.6411d0, 1.6421d0, 1.6431d0,
     & 1.6441d0, 1.6451d0, 1.6461d0, 1.6471d0, 1.6480d0, 1.6490d0,
     & 1.6500d0, 1.6510d0, 1.6520d0, 1.6530d0, 1.6540d0, 1.6550d0,
     & 1.6560d0, 1.6571d0, 1.6581d0, 1.6591d0, 1.6602d0, 1.6612d0,
     & 1.6622d0, 1.6632d0, 1.6642d0, 1.6652d0, 1.6662d0, 1.6672d0,
     & 1.6681d0, 1.6691d0, 1.6701d0, 1.6711d0, 1.6720d0, 1.6730d0,
     & 1.6740d0, 1.6751d0, 1.6761d0, 1.6771d0, 1.6781d0, 1.6792d0,
     & 1.6802d0, 1.6812d0, 1.6823d0, 1.6833d0, 1.6843d0, 1.6853d0,
     & 1.6863d0, 1.6873d0, 1.6883d0, 1.6893d0, 1.6902d0, 1.6912d0,
     & 1.6922d0, 1.6932d0, 1.6941d0, 1.6951d0, 1.6961d0, 1.6971d0,
     & 1.6981d0, 1.6992d0, 1.7002d0, 1.7012d0, 1.7022d0, 1.7033d0,
     & 1.7043d0, 1.7053d0, 1.7064d0, 1.7074d0, 1.7084d0, 1.7094d0,
     & 1.7104d0, 1.7113d0, 1.7123d0, 1.7133d0, 1.7143d0, 1.7153d0,
     & 1.7162d0, 1.7172d0, 1.7182d0, 1.7192d0, 1.7202d0, 1.7212d0,
     & 1.7222d0, 1.7233d0, 1.7243d0, 1.7253d0, 1.7264d0, 1.7274d0,
     & 1.7284d0, 1.7295d0, 1.7305d0, 1.7315d0, 1.7325d0, 1.7334d0,
     & 1.7344d0, 1.7354d0, 1.7364d0, 1.7374d0, 1.7383d0, 1.7393d0,
     & 1.7403d0, 1.7413d0, 1.7422d0, 1.7433d0, 1.7443d0, 1.7453d0,
     & 1.7463d0, 1.7473d0, 1.7484d0, 1.7494d0, 1.7504d0, 1.7515d0,
     & 1.7525d0, 1.7535d0, 1.7545d0, 1.7555d0, 1.7565d0, 1.7575d0,
     & 1.7585d0, 1.7595d0, 1.7605d0, 1.7614d0, 1.7624d0, 1.7634d0,
     & 1.7644d0, 1.7653d0, 1.7663d0, 1.7673d0, 1.7683d0, 1.7693d0,
     & 1.7703d0, 1.7713d0, 1.7723d0, 1.7734d0, 1.7744d0, 1.7754d0,
     & 1.7765d0, 1.7775d0, 1.7786d0, 1.7796d0, 1.7806d0, 1.7816d0,
     & 1.7826d0, 1.7836d0, 1.7845d0, 1.7855d0, 1.7865d0, 1.7875d0,
     & 1.7885d0, 1.7894d0, 1.7904d0, 1.7914d0, 1.7924d0, 1.7933d0,
     & 1.7943d0, 1.7953d0, 1.7963d0, 1.7974d0, 1.7984d0, 1.7994d0,
     & 1.8005d0, 1.8015d0, 1.8025d0, 1.8036d0, 1.8046d0, 1.8056d0,
     & 1.8066d0, 1.8076d0, 1.8086d0, 1.8096d0, 1.8106d0, 1.8116d0,
     & 1.8126d0, 1.8135d0, 1.8145d0, 1.8155d0, 1.8165d0, 1.8174d0,
     & 1.8184d0, 1.8194d0, 1.8204d0, 1.8214d0, 1.8224d0, 1.8234d0,
     & 1.8244d0, 1.8254d0, 1.8265d0, 1.8275d0, 1.8285d0, 1.8296d0,
     & 1.8306d0, 1.8316d0, 1.8327d0, 1.8337d0, 1.8347d0, 1.8357d0,
     & 1.8367d0, 1.8376d0, 1.8386d0, 1.8396d0, 1.8406d0, 1.8416d0,
     & 1.8425d0, 1.8435d0, 1.8445d0, 1.8455d0, 1.8464d0, 1.8474d0,
     & 1.8484d0, 1.8494d0, 1.8504d0, 1.8514d0, 1.8525d0, 1.8535d0,
     & 1.8545d0, 1.8556d0, 1.8566d0, 1.8576d0, 1.8587d0, 1.8597d0,
     & 1.8607d0, 1.8617d0, 1.8627d0, 1.8637d0, 1.8647d0, 1.8657d0,
     & 1.8667d0, 1.8676d0, 1.8686d0, 1.8696d0, 1.8706d0, 1.8716d0,
     & 1.8725d0, 1.8735d0, 1.8745d0, 1.8754d0, 1.8764d0, 1.8774d0,
     & 1.8784d0, 1.8795d0, 1.8805d0, 1.8815d0, 1.8826d0, 1.8836d0,
     & 1.8846d0, 1.8857d0, 1.8867d0, 1.8877d0, 1.8887d0, 1.8897d0,
     & 1.8907d0, 1.8917d0, 1.8927d0, 1.8937d0, 1.8947d0, 1.8957d0,
     & 1.8966d0, 1.8976d0, 1.8986d0, 1.8996d0, 1.9006d0, 1.9015d0,
     & 1.9025d0, 1.9035d0, 1.9044d0, 1.9054d0, 1.9064d0, 1.9074d0,
     & 1.9085d0, 1.9095d0, 1.9105d0, 1.9115d0, 1.9126d0, 1.9136d0,
     & 1.9147d0, 1.9157d0, 1.9168d0, 1.9178d0, 1.9188d0, 1.9198d0,
     & 1.9208d0, 1.9218d0, 1.9228d0, 1.9237d0, 1.9247d0, 1.9257d0,
     & 1.9267d0, 1.9277d0, 1.9286d0, 1.9296d0, 1.9306d0, 1.9316d0,
     & 1.9325d0, 1.9335d0, 1.9345d0, 1.9355d0, 1.9365d0, 1.9375d0,
     & 1.9385d0, 1.9395d0, 1.9405d0, 1.9416d0, 1.9426d0, 1.9436d0,
     & 1.9447d0, 1.9457d0, 1.9468d0, 1.9478d0, 1.9488d0, 1.9498d0,
     & 1.9508d0, 1.9518d0, 1.9528d0, 1.9538d0, 1.9548d0, 1.9557d0,
     & 1.9567d0, 1.9577d0, 1.9587d0, 1.9597d0, 1.9606d0, 1.9616d0,
     & 1.9626d0, 1.9636d0, 1.9645d0, 1.9655d0, 1.9665d0, 1.9674d0,
     & 1.9685d0, 1.9695d0, 1.9705d0, 1.9715d0, 1.9725d0, 1.9736d0,
     & 1.9746d0, 1.9757d0, 1.9767d0, 1.9778d0, 1.9788d0, 1.9798d0,
     & 1.9808d0, 1.9818d0, 1.9828d0, 1.9838d0, 1.9848d0, 1.9858d0,
     & 1.9868d0, 1.9877d0, 1.9887d0, 1.9897d0, 1.9907d0, 1.9917d0,
     & 1.9926d0, 1.9936d0, 1.9946d0, 1.9956d0, 1.9965d0, 1.9975d0,
     & 1.9985d0, 1.9995d0, 2.0005d0, 2.0015d0, 2.0025d0, 2.0035d0,
     & 2.0045d0, 2.0056d0, 2.0066d0, 2.0077d0, 2.0087d0, 2.0097d0,
     & 2.0108d0, 2.0118d0, 2.0128d0, 2.0138d0, 2.0148d0, 2.0158d0,
     & 2.0168d0, 2.0178d0, 2.0188d0, 2.0197d0, 2.0207d0, 2.0217d0,
     & 2.0227d0, 2.0237d0, 2.0246d0, 2.0256d0, 2.0266d0, 2.0276d0,
     & 2.0285d0, 2.0295d0, 2.0305d0, 2.0314d0, 2.0324d0, 2.0334d0,
     & 2.0345d0, 2.0355d0, 2.0365d0, 2.0375d0, 2.0386d0, 2.0396d0,
     & 2.0407d0, 2.0417d0, 2.0427d0, 2.0438d0, 2.0448d0, 2.0458d0,
     & 2.0468d0, 2.0478d0, 2.0488d0, 2.0498d0, 2.0508d0, 2.0518d0,
     & 2.0527d0, 2.0537d0, 2.0547d0, 2.0557d0, 2.0567d0, 2.0577d0,
     & 2.0586d0, 2.0596d0, 2.0606d0, 2.0616d0, 2.0626d0, 2.0635d0,
     & 2.0645d0, 2.0655d0, 2.0664d0, 2.0675d0, 2.0685d0, 2.0695d0,
     & 2.0705d0, 2.0716d0, 2.0726d0, 2.0736d0, 2.0747d0, 2.0757d0,
     & 2.0768d0, 2.0778d0, 2.0788d0, 2.0798d0, 2.0808d0, 2.0818d0,
     & 2.0828d0, 2.0838d0, 2.0848d0, 2.0857d0, 2.0867d0, 2.0877d0,
     & 2.0887d0, 2.0897d0, 2.0906d0, 2.0916d0, 2.0926d0, 2.0936d0,
     & 2.0945d0, 2.0955d0, 2.0965d0, 2.0975d0, 2.0985d0, 2.0994d0,
     & 2.1004d0, 2.1014d0, 2.1023d0, 2.1033d0, 2.1043d0, 2.1054d0,
     & 2.1064d0, 2.1074d0, 2.1084d0, 2.1095d0, 2.1105d0, 2.1116d0,
     & 2.1126d0, 2.1136d0, 2.1147d0, 2.1157d0, 2.1167d0, 2.1177d0,
     & 2.1187d0, 2.1197d0, 2.1207d0, 2.1216d0, 2.1226d0, 2.1236d0,
     & 2.1247d0, 2.1257d0, 2.1267d0, 2.1276d0, 2.1286d0, 2.1296d0,
     & 2.1306d0, 2.1315d0, 2.1325d0, 2.1335d0, 2.1344d0, 2.1354d0,
     & 2.1363d0, 2.1373d0, 2.1383d0, 2.1393d0, 2.1403d0, 2.1413d0,
     & 2.1423d0, 2.1433d0, 2.1444d0, 2.1454d0, 2.1464d0, 2.1475d0,
     & 2.1485d0, 2.1495d0, 2.1505d0, 2.1516d0, 2.1526d0, 2.1536d0,
     & 2.1545d0, 2.1555d0, 2.1565d0, 2.1575d0, 2.1586d0, 2.1597d0,
     & 2.1608d0, 2.1619d0, 2.1630d0, 2.1639d0, 2.1650d0, 2.1660d0,
     & 2.1671d0, 2.1681d0, 2.1691d0, 2.1699d0, 2.1708d0, 2.1717d0,
     & 2.1726d0, 2.1734d0, 2.1744d0, 2.1753d0, 2.1764d0, 2.1773d0,
     & 2.1784d0, 2.1794d0, 2.1805d0, 2.1815d0, 2.1826d0, 2.1836d0,
     & 2.1847d0, 2.1857d0, 2.1867d0, 2.1877d0, 2.1887d0, 2.1896d0,
     & 2.1906d0, 2.1916d0, 2.1927d0, 2.1936d0, 2.1946d0, 2.1957d0,
     & 2.1968d0, 2.1977d0, 2.1987d0, 2.1997d0, 2.2006d0, 2.2016d0,
     & 2.2026d0, 2.2035d0, 2.2044d0, 2.2054d0, 2.2064d0, 2.2075d0,
     & 2.2086d0, 2.2098d0, 2.2108d0, 2.2119d0, 2.2130d0, 2.2140d0,
     & 2.2151d0, 2.2160d0, 2.2170d0, 2.2179d0, 2.2187d0, 2.2196d0,
     & 2.2204d0, 2.2214d0, 2.2224d0, 2.2233d0, 2.2243d0, 2.2253d0,
     & 2.2263d0, 2.2274d0, 2.2284d0, 2.2294d0, 2.2304d0, 2.2314d0,
     & 2.2324d0, 2.2334d0, 2.2343d0, 2.2354d0, 2.2363d0, 2.2373d0,
     & 2.2382d0, 2.2392d0, 2.2402d0, 2.2413d0, 2.2423d0, 2.2433d0,
     & 2.2443d0, 2.2454d0, 2.2465d0, 2.2476d0, 2.2487d0, 2.2498d0,
     & 2.2507d0, 2.2517d0, 2.2526d0, 2.2536d0, 2.2545d0, 2.2555d0,
     & 2.2564d0, 2.2573d0, 2.2583d0, 2.2592d0, 2.2601d0, 2.2612d0,
     & 2.2622d0, 2.2632d0, 2.2643d0, 2.2653d0, 2.2663d0, 2.2673d0,
     & 2.2683d0, 2.2693d0, 2.2711d0, 2.2737d0, 2.2771d0, 2.2813d0,
     & 2.2863d0, 2.2922d0, 2.2989d0, 2.3064d0, 2.3147d0, 2.3238d0,
     & 2.3337d0, 2.3437d0, 2.3536d0, 2.3635d0, 2.3735d0, 2.3835d0,
     & 2.3934d0, 2.4033d0, 2.4132d0, 2.4231d0, 2.4331d0, 2.4430d0,
     & 2.4528d0, 2.4627d0, 2.4727d0, 2.4826d0, 2.4924d0, 2.5024d0,
     & 2.5123d0, 2.5222d0, 2.5321d0, 2.5420d0, 2.5519d0, 2.5618d0,
     & 2.5717d0, 2.5816d0, 2.5915d0, 2.6014d0, 2.6113d0, 2.6212d0,
     & 2.6310d0, 2.6409d0, 2.6508d0, 2.6607d0, 2.6706d0, 2.6805d0,
     & 2.6904d0, 2.7002d0, 2.7101d0, 2.7200d0, 2.7299d0, 2.7398d0,
     & 2.7496d0, 2.7595d0, 2.7694d0, 2.7793d0, 2.7891d0, 2.7990d0,
     & 2.8089d0, 2.8189d0, 2.8287d0, 2.8386d0, 2.8485d0, 2.8584d0,
     & 2.8683d0, 2.8781d0, 2.8880d0, 2.8979d0, 2.9077d0, 2.9176d0,
     & 2.9275d0, 2.9374d0, 2.9472d0, 2.9571d0, 2.9670d0, 2.9770d0,
     & 2.9868d0, 2.9967d0, 3.0066d0, 3.0165d0, 3.0264d0, 3.0362d0,
     & 3.0462d0, 3.0561d0, 3.0660d0, 3.0759d0, 3.0857d0, 3.0956d0,
     & 3.1055d0, 3.1154d0, 3.1251d0, 3.1350d0, 3.1449d0, 3.1548d0,
     & 3.1646d0, 3.1745d0, 3.1844d0, 3.1943d0, 3.2041d0, 3.2140d0,
     & 3.2239d0, 3.2338d0, 3.2436d0, 3.2535d0, 3.2634d0, 3.2733d0,
     & 3.2832d0, 3.2930d0, 3.3029d0, 3.3126d0, 3.3225d0, 3.3324d0,
     & 3.3423d0, 3.3522d0, 3.3620d0, 3.3719d0, 3.3817d0, 3.3916d0,
     & 3.4015d0, 3.4113d0, 3.4212d0, 3.4311d0, 3.4410d0, 3.4508d0,
     & 3.4606d0, 3.4704d0, 3.4803d0, 3.4902d0, 3.5001d0, 3.5099d0,
     & 3.5198d0, 3.5296d0, 3.5394d0, 3.5492d0, 3.5591d0, 3.5690d0,
     & 3.5789d0, 3.5888d0, 3.5986d0, 3.6084d0, 3.6182d0, 3.6280d0,
     & 3.6379d0, 3.6478d0, 3.6578d0, 3.6677d0, 3.6775d0, 3.6873d0,
     & 3.6971d0, 3.7070d0, 3.7169d0, 3.7269d0, 3.7367d0, 3.7466d0,
     & 3.7565d0, 3.7663d0, 3.7762d0, 3.7860d0, 3.7959d0, 3.8059d0,
     & 3.8157d0, 3.8256d0, 3.8354d0, 3.8453d0, 3.8552d0, 3.8650d0,
     & 3.8747d0, 3.8846d0, 3.8945d0, 3.9043d0, 3.9141d0, 3.9239d0,
     & 3.9338d0, 3.9437d0, 3.9535d0, 3.9633d0, 3.9731d0, 3.9830d0,
     & 3.9928d0, 4.0027d0, 4.0127d0, 4.0225d0, 4.0324d0, 4.0422d0,
     & 4.0519d0, 4.0619d0, 4.0718d0, 4.0818d0, 4.0918d0, 4.1018d0,
     & 4.1116d0, 4.1215d0, 4.1313d0, 4.1411d0, 4.1510d0, 4.1609d0,
     & 4.1706d0, 4.1805d0, 4.1902d0, 4.2001d0, 4.2100d0, 4.2199d0,
     & 4.2298d0, 4.2397d0, 4.2496d0, 4.2595d0, 4.2694d0, 4.2793d0,
     & 4.2890d0, 4.2990d0, 4.3089d0, 4.3188d0, 4.3287d0, 4.3386d0,
     & 4.3485d0, 4.3584d0, 4.3683d0, 4.3782d0, 4.3881d0, 4.3981d0,
     & 4.4079d0, 4.4179d0, 4.4278d0, 4.4377d0, 4.4476d0, 4.4576d0,
     & 4.4676d0, 4.4775d0, 4.4874d0, 4.4974d0, 4.5073d0, 4.5171d0,
     & 4.5269d0, 4.5368d0, 4.5467d0, 4.5566d0, 4.5665d0, 4.5765d0,
     & 4.5864d0, 4.5964d0, 4.6063d0, 4.6163d0, 4.6263d0, 4.6364d0,
     & 4.6462d0, 4.6560d0, 4.6658d0, 4.6757d0, 4.6856d0, 4.6957d0,
     & 4.7056d0, 4.7155d0, 4.7254d0, 4.7353d0, 4.7451d0, 4.7550d0,
     & 4.7651d0, 4.7750d0, 4.7851d0, 4.7949d0, 4.8049d0, 4.8149d0,
     & 4.8250d0, 4.8350d0, 4.8450d0, 4.8550d0, 4.8652d0, 4.8750d0,
     & 4.8852d0, 4.8952d0, 4.9052d0, 4.9152d0, 4.9252d0, 4.9353d0,
     & 4.9454d0, 4.9555d0, 4.9655d0, 4.9755d0, 4.9856d0, 4.9955d0,
     & 5.0054d0, 5.0154d0, 5.0253d0, 5.0354d0, 5.0454d0, 5.0555d0,
     & 5.0655d0, 5.0756d0, 5.0856d0, 5.0957d0, 5.1058d0, 5.1160d0,
     & 5.1261d0, 5.1362d0, 5.1462d0, 5.1563d0, 5.1663d0, 5.1764d0,
     & 5.1865d0, 5.1966d0, 5.2067d0, 5.2168d0, 5.2269d0, 5.2371d0,
     & 5.2471d0, 5.2572d0, 5.2672d0, 5.2771d0, 5.2870d0, 5.2970d0,
     & 5.3071d0, 5.3172d0, 5.3273d0, 5.3375d0, 5.3476d0, 5.3579d0,
     & 5.3680d0, 5.3783d0, 5.3885d0, 5.3987d0, 5.4090d0, 5.4191d0,
     & 5.4291d0, 5.4391d0, 5.4492d0, 5.4592d0, 5.4694d0, 5.4796d0,
     & 5.4898d0, 5.5000d0, 5.5102d0, 5.5205d0, 5.5307d0, 5.5410d0,
     & 5.5513d0, 5.5614d0, 5.5716d0, 5.5816d0, 5.5917d0, 5.6018d0,
     & 5.6120d0, 5.6222d0, 5.6324d0, 5.6426d0, 5.6530d0, 5.6633d0,
     & 5.6737d0, 5.6840d0, 5.6944d0, 5.7047d0, 5.7149d0, 5.7250d0,
     & 5.7352d0, 5.7453d0, 5.7555d0, 5.7656d0, 5.7757d0, 5.7858d0,
     & 5.7960d0, 5.8063d0, 5.8167d0, 5.8272d0, 5.8375d0, 5.8479d0,
     & 5.8583d0, 5.8688d0, 5.8792d0, 5.8897d0, 5.9001d0, 5.9105d0,
     & 5.9209d0, 5.9313d0, 5.9416d0, 5.9518d0, 5.9622d0, 5.9724d0,
     & 5.9828d0, 5.9932d0, 6.0036d0, 6.0141d0, 6.0245d0, 6.0348d0,
     & 6.0451d0, 6.0556d0, 6.0660d0, 6.0763d0, 6.0867d0, 6.0969d0,
     & 6.1072d0, 6.1174d0, 6.1279d0, 6.1382d0, 6.1486d0, 6.1590d0,
     & 6.1694d0, 6.1800d0, 6.1906d0, 6.2013d0, 6.2119d0, 6.2226d0,
     & 6.2332d0, 6.2436d0, 6.2541d0, 6.2646d0, 6.2751d0, 6.2856d0,
     & 6.2959d0, 6.3064d0, 6.3168d0, 6.3274d0, 6.3380d0, 6.3484d0,
     & 6.3589d0, 6.3694d0, 6.3800d0, 6.3905d0, 6.4010d0, 6.4117d0,
     & 6.4224d0, 6.4330d0, 6.4435d0, 6.4541d0, 6.4649d0, 6.4757d0,
     & 6.4864d0, 6.4970d0, 6.5077d0, 6.5183d0, 6.5288d0, 6.5392d0,
     & 6.5497d0, 6.5603d0, 6.5707d0, 6.5812d0, 6.5916d0, 6.6022d0,
     & 6.6131d0, 6.6240d0, 6.6348d0, 6.6458d0, 6.6567d0, 6.6675d0,
     & 6.6784d0, 6.6893d0, 6.7002d0, 6.7112d0, 6.7221d0, 6.7328d0,
     & 6.7434d0, 6.7541d0, 6.7647d0, 6.7754d0, 6.7862d0, 6.7968d0,
     & 6.8075d0, 6.8183d0, 6.8291d0, 6.8398d0, 6.8505d0, 6.8614d0,
     & 6.8723d0, 6.8834d0, 6.8944d0, 6.9056d0, 6.9164d0, 6.9275d0,
     & 6.9385d0, 6.9496d0, 6.9606d0, 6.9719d0, 6.9829d0, 6.9937d0,
     & 7.0045d0, 7.0153d0, 7.0261d0, 7.0373d0, 7.0481d0, 7.0590d0,
     & 7.0699d0, 7.0808d0, 7.0917d0, 7.1027d0, 7.1136d0, 7.1247d0,
     & 7.1359d0, 7.1471d0, 7.1580d0, 7.1689d0, 7.1799d0, 7.1908d0,
     & 7.2020d0, 7.2133d0, 7.2246d0, 7.2359d0, 7.2471d0, 7.2583d0,
     & 7.2694d0, 7.2808d0, 7.2922d0, 7.3035d0, 7.3150d0, 7.3262d0,
     & 7.3373d0, 7.3485d0, 7.3597d0, 7.3707d0, 7.3817d0, 7.3927d0,
     & 7.4038d0, 7.4149d0, 7.4261d0, 7.4373d0, 7.4485d0, 7.4596d0,
     & 7.4706d0, 7.4817d0, 7.4930d0, 7.5043d0, 7.5158d0, 7.5274d0,
     & 7.5388d0, 7.5500d0, 7.5613d0, 7.5728d0, 7.5843d0, 7.5960d0,
     & 7.6076d0, 7.6191d0, 7.6306d0, 7.6422d0, 7.6534d0, 7.6647d0,
     & 7.6765d0, 7.6880d0, 7.6993d0, 7.7110d0, 7.7224d0, 7.7339d0,
     & 7.7456d0, 7.7574d0, 7.7688d0, 7.7806d0, 7.7923d0, 7.8040d0,
     & 7.8157d0, 7.8274d0, 7.8391d0, 7.8508d0, 7.8623d0, 7.8739d0,
     & 7.8854d0, 7.8971d0, 7.9087d0, 7.9204d0, 7.9318d0, 7.9434d0,
     & 7.9552d0, 7.9667d0, 7.9783d0, 7.9901d0, 8.0022d0, 8.0143d0,
     & 8.0259d0, 8.0377d0, 8.0497d0, 8.0615d0, 8.0736d0, 8.0857d0,
     & 8.0979d0, 8.1099d0, 8.1221d0, 8.1339d0, 8.1456d0, 8.1579d0,
     & 8.1702d0, 8.1820d0, 8.1941d0, 8.2061d0, 8.2180d0, 8.2300d0,
     & 8.2421d0, 8.2542d0, 8.2664d0, 8.2788d0, 8.2906d0, 8.3026d0,
     & 8.3148d0, 8.3272d0, 8.3393d0, 8.3516d0, 8.3639d0, 8.3764d0,
     & 8.3884d0, 8.4006d0, 8.4129d0, 8.4255d0, 8.4379d0, 8.4503d0,
     & 8.4626d0, 8.4749d0, 8.4872d0, 8.4995d0, 8.5118d0, 8.5244d0,
     & 8.5369d0, 8.5491d0, 8.5616d0, 8.5742d0, 8.5866d0, 8.5990d0,
     & 8.6115d0, 8.6243d0, 8.6367d0, 8.6492d0, 8.6619d0, 8.6745d0,
     & 8.6872d0, 8.6998d0, 8.7123d0, 8.7251d0, 8.7378d0, 8.7504d0,
     & 8.7630d0, 8.7758d0, 8.7884d0, 8.8012d0, 8.8139d0, 8.8268d0,
     & 8.8398d0, 8.8527d0, 8.8657d0, 8.8790d0, 8.8920d0, 8.9050d0,
     & 8.9179d0, 8.9310d0, 8.9438d0, 8.9570d0, 8.9699d0, 8.9826d0,
     & 8.9957d0, 9.0085d0, 9.0215d0, 9.0348d0, 9.0480d0, 9.0612d0,
     & 9.0747d0, 9.0882d0, 9.1017d0, 9.1150d0, 9.1284d0, 9.1420d0,
     & 9.1556d0, 9.1690d0, 9.1824d0, 9.1958d0, 9.2095d0, 9.2229d0,
     & 9.2363d0, 9.2498d0, 9.2637d0, 9.2774d0, 9.2909d0, 9.3045d0,
     & 9.3184d0, 9.3318d0, 9.3457d0, 9.3593d0, 9.3730d0, 9.3868d0,
     & 9.4006d0, 9.4144d0, 9.4281d0, 9.4419d0, 9.4553d0, 9.4692d0,
     & 9.4832d0, 9.4968d0, 9.5108d0, 9.5249d0, 9.5386d0, 9.5525d0,
     & 9.5665d0, 9.5810d0, 9.5953d0, 9.6095d0, 9.6237d0, 9.6383d0,
     & 9.6529d0, 9.6672d0, 9.6812d0, 9.6958d0, 9.7103d0, 9.7247d0,
     & 9.7388d0, 9.7529d0, 9.7676d0, 9.7818d0, 9.7963d0, 9.8105d0,
     & 9.8250d0, 9.8395d0, 9.8539d0, 9.8687d0, 9.8831d0, 9.8981d0,
     & 9.9132d0, 9.9277d0, 9.9410d0, 9.9527d0, 9.9635d0, 9.9727d0,
     & 9.9809d0, 9.9875d0, 9.9925d0, 9.9965d0, 9.9989d0, 9.9999d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0, 9.9999d0,
     &10.0000d0,10.0000d0,10.0000d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9998d0, 9.9999d0,
     & 9.9998d0, 9.9998d0, 9.9998d0, 9.9998d0, 9.9998d0, 9.9998d0,
     & 9.9998d0, 9.9998d0, 9.9998d0, 9.9998d0, 9.9999d0, 9.9998d0,
     & 9.9998d0, 9.9998d0, 9.9998d0, 9.9998d0, 9.9998d0, 9.9998d0,
     & 9.9998d0, 9.9998d0, 9.9998d0, 9.9998d0, 9.9998d0, 9.9998d0,
     & 9.9998d0, 9.9998d0, 9.9998d0, 9.9998d0, 9.9997d0, 9.9997d0,
     & 9.9997d0, 9.9997d0, 9.9997d0, 9.9997d0, 9.9997d0, 9.9997d0,
     & 9.9996d0, 9.9996d0, 9.9996d0,10.0000d0, 9.9997d0, 9.9993d0,
     & 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0,
     & 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0,
     & 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0,
     & 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0,
     & 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0,
     & 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0,
     & 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0,
     & 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0, 9.9992d0
     &/
      DATA (Imax ( 3,I), I= 1, 1000) /
     & 0.00000799d0, 0.00000799d0, 0.00003794d0, 0.00008942d0,
     & 0.00014140d0, 0.00032130d0, 0.00054955d0, 0.00087751d0,
     & 0.00131201d0, 0.00183262d0, 0.00245255d0, 0.00318625d0,
     & 0.00403355d0, 0.00496166d0, 0.00599972d0, 0.00720583d0,
     & 0.00841472d0, 0.00968620d0, 0.01103393d0, 0.01239618d0,
     & 0.01379618d0, 0.01526704d0, 0.01681359d0, 0.01840935d0,
     & 0.02002746d0, 0.02168198d0, 0.02334960d0, 0.02505819d0,
     & 0.02680372d0, 0.02854465d0, 0.03035335d0, 0.03221018d0,
     & 0.03407656d0, 0.03591973d0, 0.03778502d0, 0.03970367d0,
     & 0.04162960d0, 0.04353425d0, 0.04547001d0, 0.04746131d0,
     & 0.04947032d0, 0.05146892d0, 0.05348472d0, 0.05552356d0,
     & 0.05757998d0, 0.05964670d0, 0.06170625d0, 0.06382389d0,
     & 0.06595404d0, 0.06807292d0, 0.07019022d0, 0.07230846d0,
     & 0.07447916d0, 0.07664528d0, 0.07879855d0, 0.08096054d0,
     & 0.08313569d0, 0.08534548d0, 0.08753909d0, 0.08974689d0,
     & 0.09196075d0, 0.09418280d0, 0.09641141d0, 0.09864394d0,
     & 0.10090762d0, 0.10316104d0, 0.10542031d0, 0.10768487d0,
     & 0.10994080d0, 0.11222174d0, 0.11453785d0, 0.11684288d0,
     & 0.11913757d0, 0.12144959d0, 0.12372492d0, 0.12605071d0,
     & 0.12839648d0, 0.13074583d0, 0.13308181d0, 0.13543503d0,
     & 0.13775183d0, 0.14009741d0, 0.14248386d0, 0.14487253d0,
     & 0.14724661d0, 0.14962049d0, 0.15194085d0, 0.15427427d0,
     & 0.15667793d0, 0.15910161d0, 0.16151032d0, 0.16391851d0,
     & 0.16627926d0, 0.16861591d0, 0.17099729d0, 0.17343493d0,
     & 0.17589194d0, 0.17834920d0, 0.18080387d0, 0.18317033d0,
     & 0.18553337d0, 0.18793724d0, 0.19038332d0, 0.19286844d0,
     & 0.19535491d0, 0.19781126d0, 0.20020977d0, 0.20260611d0,
     & 0.20500430d0, 0.20748167d0, 0.20998012d0, 0.21249533d0,
     & 0.21498466d0, 0.21742935d0, 0.21983354d0, 0.22225338d0,
     & 0.22470725d0, 0.22721614d0, 0.22974402d0, 0.23228632d0,
     & 0.23474734d0, 0.23720221d0, 0.23963778d0, 0.24205638d0,
     & 0.24455887d0, 0.24711110d0, 0.24966183d0, 0.25217703d0,
     & 0.25467193d0, 0.25714466d0, 0.25959849d0, 0.26205426d0,
     & 0.26454097d0, 0.26710957d0, 0.26969650d0, 0.27221641d0,
     & 0.27470168d0, 0.27718344d0, 0.27966461d0, 0.28212726d0,
     & 0.28459173d0, 0.28713670d0, 0.28972551d0, 0.29230118d0,
     & 0.29480979d0, 0.29733452d0, 0.29983771d0, 0.30234155d0,
     & 0.30487075d0, 0.30740947d0, 0.30999115d0, 0.31259260d0,
     & 0.31513122d0, 0.31764132d0, 0.32017136d0, 0.32270303d0,
     & 0.32519612d0, 0.32771283d0, 0.33026001d0, 0.33282590d0,
     & 0.33540493d0, 0.33795860d0, 0.34050766d0, 0.34307733d0,
     & 0.34562662d0, 0.34815609d0, 0.35068706d0, 0.35321942d0,
     & 0.35583785d0, 0.35845035d0, 0.36101702d0, 0.36357945d0,
     & 0.36614099d0, 0.36870262d0, 0.37124360d0, 0.37380722d0,
     & 0.37638021d0, 0.37900564d0, 0.38163492d0, 0.38420016d0,
     & 0.38673836d0, 0.38929850d0, 0.39188159d0, 0.39446649d0,
     & 0.39703211d0, 0.39960107d0, 0.40215150d0, 0.40477407d0,
     & 0.40732598d0, 0.40991640d0, 0.41250354d0, 0.41511327d0,
     & 0.41770139d0, 0.42029166d0, 0.42286152d0, 0.42543319d0,
     & 0.42800650d0, 0.43061870d0, 0.43321636d0, 0.43585631d0,
     & 0.43844762d0, 0.44101647d0, 0.44361001d0, 0.44620496d0,
     & 0.44877866d0, 0.45137647d0, 0.45397568d0, 0.45655453d0,
     & 0.45923352d0, 0.46185035d0, 0.46441880d0, 0.46703145d0,
     & 0.46964577d0, 0.47223917d0, 0.47483483d0, 0.47743374d0,
     & 0.48003596d0, 0.48264110d0, 0.48529598d0, 0.48788795d0,
     & 0.49050665d0, 0.49315107d0, 0.49580184d0, 0.49840650d0,
     & 0.50101358d0, 0.50364619d0, 0.50628114d0, 0.50889486d0,
     & 0.51151043d0, 0.51410395d0, 0.51669317d0, 0.51931304d0,
     & 0.52193540d0, 0.52456063d0, 0.52723581d0, 0.52984083d0,
     & 0.53249639d0, 0.53510612d0, 0.53774101d0, 0.54037732d0,
     & 0.54301596d0, 0.54564226d0, 0.54822713d0, 0.55089343d0,
     & 0.55351317d0, 0.55613565d0, 0.55880833d0, 0.56143486d0,
     & 0.56408727d0, 0.56671780d0, 0.56935036d0, 0.57197350d0,
     & 0.57457381d0, 0.57720751d0, 0.57977641d0, 0.58237714d0,
     & 0.58503288d0, 0.58769250d0, 0.59033144d0, 0.59299845d0,
     & 0.59566879d0, 0.59834218d0, 0.60100609d0, 0.60364789d0,
     & 0.60625774d0, 0.60889822d0, 0.61155230d0, 0.61421466d0,
     & 0.61690676d0, 0.61960185d0, 0.62227499d0, 0.62495065d0,
     & 0.62762856d0, 0.63030845d0, 0.63298976d0, 0.63564837d0,
     & 0.63825548d0, 0.64083785d0, 0.64344966d0, 0.64604640d0,
     & 0.64864975d0, 0.65130955d0, 0.65397274d0, 0.65666384d0,
     & 0.65935707d0, 0.66202730d0, 0.66469979d0, 0.66737431d0,
     & 0.67005068d0, 0.67263353d0, 0.67520916d0, 0.67788929d0,
     & 0.68052715d0, 0.68317080d0, 0.68579370d0, 0.68850791d0,
     & 0.69121474d0, 0.69391048d0, 0.69660985d0, 0.69933790d0,
     & 0.70206904d0, 0.70474213d0, 0.70732749d0, 0.70992273d0,
     & 0.71257710d0, 0.71524566d0, 0.71783549d0, 0.72046798d0,
     & 0.72311968d0, 0.72577494d0, 0.72848570d0, 0.73119897d0,
     & 0.73391360d0, 0.73665595d0, 0.73937511d0, 0.74197584d0,
     & 0.74455750d0, 0.74722618d0, 0.74991757d0, 0.75261945d0,
     & 0.75532818d0, 0.75796413d0, 0.76060444d0, 0.76329947d0,
     & 0.76599878d0, 0.76872665d0, 0.77150810d0, 0.77429140d0,
     & 0.77695143d0, 0.77958161d0, 0.78219604d0, 0.78484279d0,
     & 0.78751695d0, 0.79020298d0, 0.79289669d0, 0.79554355d0,
     & 0.79819578d0, 0.80082518d0, 0.80359024d0, 0.80638373d0,
     & 0.80912685d0, 0.81189835d0, 0.81462866d0, 0.81727302d0,
     & 0.81990063d0, 0.82251704d0, 0.82519108d0, 0.82785541d0,
     & 0.83055633d0, 0.83318675d0, 0.83579522d0, 0.83845407d0,
     & 0.84109181d0, 0.84386724d0, 0.84664536d0, 0.84942681d0,
     & 0.85221148d0, 0.85493314d0, 0.85763389d0, 0.86032248d0,
     & 0.86298800d0, 0.86565238d0, 0.86839861d0, 0.87115294d0,
     & 0.87378019d0, 0.87646592d0, 0.87915599d0, 0.88182265d0,
     & 0.88465393d0, 0.88735360d0, 0.89016247d0, 0.89293277d0,
     & 0.89564741d0, 0.89828390d0, 0.90090859d0, 0.90356928d0,
     & 0.90621620d0, 0.90894181d0, 0.91167587d0, 0.91425592d0,
     & 0.91700381d0, 0.91962177d0, 0.92224389d0, 0.92494953d0,
     & 0.92779362d0, 0.93064004d0, 0.93344378d0, 0.93620253d0,
     & 0.93887883d0, 0.94157112d0, 0.94425344d0, 0.94695079d0,
     & 0.94967264d0, 0.95240915d0, 0.95512640d0, 0.95774347d0,
     & 0.96036679d0, 0.96299487d0, 0.96570849d0, 0.96842539d0,
     & 0.97114533d0, 0.97386819d0, 0.97651583d0, 0.97929835d0,
     & 0.98206276d0, 0.98484474d0, 0.98753428d0, 0.99026662d0,
     & 0.99306142d0, 0.99575394d0, 0.99845898d0, 1.00117314d0,
     & 1.00389469d0, 1.00664997d0, 1.00927496d0, 1.01190495d0,
     & 1.01456583d0, 1.01728594d0, 1.01995909d0, 1.02256787d0,
     & 1.02524972d0, 1.02789056d0, 1.03065789d0, 1.03343868d0,
     & 1.03626812d0, 1.03905499d0, 1.04185379d0, 1.04463410d0,
     & 1.04742110d0, 1.05021346d0, 1.05300975d0, 1.05580997d0,
     & 1.05861294d0, 1.06128263d0, 1.06396174d0, 1.06658840d0,
     & 1.06925428d0, 1.07204437d0, 1.07476854d0, 1.07748461d0,
     & 1.08016646d0, 1.08291245d0, 1.08567929d0, 1.08848643d0,
     & 1.09130168d0, 1.09409654d0, 1.09689689d0, 1.09970236d0,
     & 1.10231733d0, 1.10499108d0, 1.10769641d0, 1.11043251d0,
     & 1.11307359d0, 1.11569154d0, 1.11829507d0, 1.12088895d0,
     & 1.12344635d0, 1.12605250d0, 1.12865329d0, 1.13137913d0,
     & 1.13412535d0, 1.13682616d0, 1.13953650d0, 1.14228249d0,
     & 1.14497709d0, 1.14767718d0, 1.15038180d0, 1.15311825d0,
     & 1.15574610d0, 1.15837729d0, 1.16093731d0, 1.16347599d0,
     & 1.16603088d0, 1.16854715d0, 1.17105520d0, 1.17361438d0,
     & 1.17616773d0, 1.17877460d0, 1.18145645d0, 1.18421602d0,
     & 1.18695915d0, 1.18968427d0, 1.19238830d0, 1.19509995d0,
     & 1.19784641d0, 1.20059860d0, 1.20332742d0, 1.20606101d0,
     & 1.20874083d0, 1.21131742d0, 1.21387339d0, 1.21641791d0,
     & 1.21898198d0, 1.22156692d0, 1.22411656d0, 1.22666121d0,
     & 1.22917295d0, 1.23170888d0, 1.23431730d0, 1.23703992d0,
     & 1.23977208d0, 1.24251294d0, 1.24523032d0, 1.24795389d0,
     & 1.25068307d0, 1.25344431d0, 1.25618017d0, 1.25894868d0,
     & 1.26172018d0, 1.26441836d0, 1.26697290d0, 1.26951754d0,
     & 1.27205276d0, 1.27463937d0, 1.27719116d0, 1.27973747d0,
     & 1.28227985d0, 1.28481877d0, 1.28742611d0, 1.29005742d0,
     & 1.29267275d0, 1.29541814d0, 1.29819930d0, 1.30098665d0,
     & 1.30377924d0, 1.30654621d0, 1.30931735d0, 1.31206334d0,
     & 1.31484079d0, 1.31754851d0, 1.32023203d0, 1.32290280d0,
     & 1.32547104d0, 1.32803297d0, 1.33056021d0, 1.33308244d0,
     & 1.33565855d0, 1.33820212d0, 1.34081638d0, 1.34356666d0,
     & 1.34633172d0, 1.34910631d0, 1.35191894d0, 1.35467863d0,
     & 1.35744441d0, 1.36021447d0, 1.36298907d0, 1.36576796d0,
     & 1.36857903d0, 1.37131882d0, 1.37392271d0, 1.37651181d0,
     & 1.37903345d0, 1.38154578d0, 1.38411176d0, 1.38664198d0,
     & 1.38919640d0, 1.39174640d0, 1.39429116d0, 1.39686251d0,
     & 1.39947963d0, 1.40221536d0, 1.40496325d0, 1.40777838d0,
     & 1.41060126d0, 1.41340065d0, 1.41623461d0, 1.41907215d0,
     & 1.42191494d0, 1.42473328d0, 1.42752564d0, 1.43024206d0,
     & 1.43287337d0, 1.43546474d0, 1.43804801d0, 1.44062507d0,
     & 1.44316924d0, 1.44570935d0, 1.44821846d0, 1.45072401d0,
     & 1.45325685d0, 1.45582771d0, 1.45866859d0, 1.46145999d0,
     & 1.46429110d0, 1.46713078d0, 1.46991718d0, 1.47276771d0,
     & 1.47559369d0, 1.47845340d0, 1.48131716d0, 1.48418474d0,
     & 1.48698568d0, 1.48957729d0, 1.49218667d0, 1.49475646d0,
     & 1.49731684d0, 1.49987411d0, 1.50242436d0, 1.50500059d0,
     & 1.50757229d0, 1.51013994d0, 1.51267517d0, 1.51523674d0,
     & 1.51787293d0, 1.52050114d0, 1.52317524d0, 1.52586269d0,
     & 1.52858591d0, 1.53131831d0, 1.53402591d0, 1.53688955d0,
     & 1.53975785d0, 1.54262960d0, 1.54550505d0, 1.54830635d0,
     & 1.55105746d0, 1.55379212d0, 1.55648565d0, 1.55920088d0,
     & 1.56190848d0, 1.56463838d0, 1.56721437d0, 1.56975698d0,
     & 1.57232571d0, 1.57489109d0, 1.57747793d0, 1.58014584d0,
     & 1.58283937d0, 1.58557844d0, 1.58829808d0, 1.59118164d0,
     & 1.59404290d0, 1.59690881d0, 1.59980893d0, 1.60253334d0,
     & 1.60526109d0, 1.60808921d0, 1.61089575d0, 1.61367762d0,
     & 1.61644399d0, 1.61920071d0, 1.62173557d0, 1.62429476d0,
     & 1.62684846d0, 1.62936866d0, 1.63206351d0, 1.63475728d0,
     & 1.63732696d0, 1.63989377d0, 1.64246702d0, 1.64508855d0,
     & 1.64776170d0, 1.65050876d0, 1.65323555d0, 1.65597188d0,
     & 1.65874517d0, 1.66149604d0, 1.66431189d0, 1.66710246d0,
     & 1.66989744d0, 1.67268753d0, 1.67540073d0, 1.67803347d0,
     & 1.68062282d0, 1.68323350d0, 1.68583584d0, 1.68843150d0,
     & 1.69108820d0, 1.69365084d0, 1.69617999d0, 1.69870830d0,
     & 1.70120502d0, 1.70372987d0, 1.70631278d0, 1.70883608d0,
     & 1.71142006d0, 1.71404004d0, 1.71664822d0, 1.71923637d0,
     & 1.72183394d0, 1.72450197d0, 1.72714555d0, 1.72982574d0,
     & 1.73272705d0, 1.73554206d0, 1.73844957d0, 1.74126911d0,
     & 1.74402511d0, 1.74682534d0, 1.74955189d0, 1.75226998d0,
     & 1.75497949d0, 1.75771272d0, 1.76043987d0, 1.76291728d0,
     & 1.76548183d0, 1.76795387d0, 1.77042353d0, 1.77292049d0,
     & 1.77535558d0, 1.77784836d0, 1.78038907d0, 1.78297281d0,
     & 1.78554535d0, 1.78813255d0, 1.79085886d0, 1.79356241d0,
     & 1.79636264d0, 1.79916799d0, 1.80197906d0, 1.80473328d0,
     & 1.80749226d0, 1.81023550d0, 1.81292892d0, 1.81555378d0,
     & 1.81831646d0, 1.82097125d0, 1.82367992d0, 1.82635212d0,
     & 1.82893026d0, 1.83150375d0, 1.83413506d0, 1.83676243d0,
     & 1.83947563d0, 1.84216499d0, 1.84493303d0, 1.84742880d0,
     & 1.84992254d0, 1.85241616d0, 1.85497665d0, 1.85764408d0,
     & 1.86032712d0, 1.86301994d0, 1.86572278d0, 1.86831343d0,
     & 1.87093937d0, 1.87366652d0, 1.87651789d0, 1.87934327d0,
     & 1.88214123d0, 1.88481319d0, 1.88749993d0, 1.89017284d0,
     & 1.89289784d0, 1.89558387d0, 1.89829421d0, 1.90109038d0,
     & 1.90378642d0, 1.90644801d0, 1.90904665d0, 1.91161191d0,
     & 1.91438484d0, 1.91712487d0, 1.91977274d0, 1.92238784d0,
     & 1.92508769d0, 1.92782784d0, 1.93039763d0, 1.93298650d0,
     & 1.93558693d0, 1.93828893d0, 1.94112504d0, 1.94384909d0,
     & 1.94648278d0, 1.94918132d0, 1.95188773d0, 1.95451152d0,
     & 1.95709765d0, 1.95976651d0, 1.96238828d0, 1.96503055d0,
     & 1.96763277d0, 1.97013235d0, 1.97259605d0, 1.97530007d0,
     & 1.97803235d0, 1.98072779d0, 1.98345029d0, 1.98616910d0,
     & 1.98897505d0, 1.99180853d0, 1.99460936d0, 1.99743819d0,
     & 2.00033450d0, 2.00325871d0, 2.00595021d0, 2.00862646d0,
     & 2.01134825d0, 2.01408219d0, 2.01679420d0, 2.01946831d0,
     & 2.02221560d0, 2.02490687d0, 2.02757382d0, 2.03017783d0,
     & 2.03278804d0, 2.03551555d0, 2.03826022d0, 2.04096198d0,
     & 2.04356313d0, 2.04618979d0, 2.04888892d0, 2.05148721d0,
     & 2.05417442d0, 2.05685806d0, 2.05969119d0, 2.06233978d0,
     & 2.06513596d0, 2.06789899d0, 2.07069016d0, 2.07357001d0,
     & 2.07641745d0, 2.07902074d0, 2.08173537d0, 2.08447933d0,
     & 2.08723903d0, 2.08986020d0, 2.09267211d0, 2.09534526d0,
     & 2.09802508d0, 2.10071278d0, 2.10337543d0, 2.10607433d0,
     & 2.10877204d0, 2.11142564d0, 2.11402178d0, 2.11675858d0,
     & 2.11935973d0, 2.12195373d0, 2.12444592d0, 2.12693262d0,
     & 2.12941408d0, 2.13192201d0, 2.13442564d0, 2.13702226d0,
     & 2.13958120d0, 2.14216805d0, 2.14468884d0, 2.14733028d0,
     & 2.14993906d0, 2.15263724d0, 2.15533376d0, 2.15802836d0,
     & 2.16092706d0, 2.16385245d0, 2.16683006d0, 2.16962123d0,
     & 2.17242742d0, 2.17515278d0, 2.17788839d0, 2.18063140d0,
     & 2.18350935d0, 2.18639207d0, 2.18928051d0, 2.19196773d0,
     & 2.19463134d0, 2.19712019d0, 2.19976759d0, 2.20240211d0,
     & 2.20512128d0, 2.20783186d0, 2.21056747d0, 2.21323133d0,
     & 2.21592188d0, 2.21842456d0, 2.22092414d0, 2.22342038d0,
     & 2.22603893d0, 2.22868299d0, 2.23126602d0, 2.23390675d0,
     & 2.23654556d0, 2.23918247d0, 2.24175620d0, 2.24429846d0,
     & 2.24722195d0, 2.25016785d0, 2.25302553d0, 2.25593090d0,
     & 2.25894856d0, 2.26200080d0, 2.26481056d0, 2.26762819d0,
     & 2.27042079d0, 2.27321959d0, 2.27605414d0, 2.27844262d0,
     & 2.28081298d0, 2.28330636d0, 2.28578544d0, 2.28812695d0,
     & 2.29049468d0, 2.29298520d0, 2.29547024d0, 2.29795170d0,
     & 2.30042863d0, 2.30290222d0, 2.30562377d0, 2.30843377d0,
     & 2.31120872d0, 2.31394982d0, 2.31671929d0, 2.31960821d0,
     & 2.32225013d0, 2.32485962d0, 2.32749772d0, 2.33013391d0,
     & 2.33374667d0, 2.33639693d0, 2.33918667d0, 2.34195995d0,
     & 2.34484458d0, 2.34785819d0, 2.35082316d0, 2.35366416d0,
     & 2.35654402d0, 2.35943103d0, 2.36229277d0, 2.36430502d0,
     & 2.36728406d0, 2.37016106d0, 2.37318277d0, 2.37625408d0,
     & 2.37923050d0, 2.38169980d0, 2.38454056d0, 2.38719034d0,
     & 2.38983607d0, 2.39276004d0, 2.39527750d0, 2.39831781d0,
     & 2.40113425d0, 2.40370369d0, 2.40595961d0, 2.40812159d0,
     & 2.41068792d0, 2.41337466d0, 2.41624570d0, 2.41923714d0,
     & 2.42160988d0, 2.42512918d0, 2.42755198d0, 2.43008924d0,
     & 2.43272877d0, 2.43556952d0, 2.43848300d0, 2.44150138d0,
     & 2.44437289d0, 2.44725132d0, 2.44978666d0, 2.45266390d0,
     & 2.45468283d0, 2.45724487d0, 2.45991755d0, 2.46257973d0,
     & 2.46497631d0, 2.46798706d0, 2.47030425d0, 2.47264862d0,
     & 2.47498846d0, 2.47755146d0, 2.48014188d0, 2.48263192d0,
     & 2.48514986d0, 2.48747683d0, 2.48983240d0, 2.49243736d0,
     & 2.49441743d0, 2.49701715d0, 2.49973774d0, 2.50242543d0,
     & 2.50526500d0, 2.50822544d0, 2.51124644d0, 2.51512313d0,
     & 2.51903725d0, 2.52295899d0, 2.52688742d0, 2.53013659d0,
     & 2.53323030d0, 2.53621149d0, 2.53923225d0, 2.54210734d0,
     & 2.54486656d0, 2.54766273d0, 2.54960728d0, 2.55129266d0,
     & 2.55297494d0, 2.55462241d0, 2.55711079d0, 2.55975723d0,
     & 2.56270933d0, 2.56593442d0, 2.56915283d0, 2.57236552d0,
     & 2.57488894d0, 2.57740855d0, 2.58021212d0, 2.58298039d0
     &/
      DATA (Imax ( 3,I), I= 1001, 2100) /
     & 2.58577681d0, 2.58856678d0, 2.59169412d0, 2.59370089d0,
     & 2.59542608d0, 2.59724355d0, 2.59905982d0, 2.60155964d0,
     & 2.60417771d0, 2.60679770d0, 2.60944724d0, 2.61226034d0,
     & 2.61480069d0, 2.61700058d0, 2.62003040d0, 2.62307787d0,
     & 2.62601256d0, 2.62895966d0, 2.63221121d0, 2.63534975d0,
     & 2.63925123d0, 2.64316893d0, 2.64692616d0, 2.65080404d0,
     & 2.65462208d0, 2.65838671d0, 2.66172481d0, 2.66475749d0,
     & 2.66778016d0, 2.67096210d0, 2.67345762d0, 2.67876601d0,
     & 2.68406749d0, 2.68934155d0, 2.69176555d0, 2.69418836d0,
     & 2.69580269d0, 2.69782233d0, 2.70017123d0, 2.70251822d0,
     & 2.70440173d0, 2.70696497d0, 2.70668864d0, 2.70629811d0,
     & 2.70576644d0, 2.70796490d0, 2.71056318d0, 2.71315002d0,
     & 2.71601939d0, 2.71892476d0, 2.72185397d0, 2.72514248d0,
     & 2.72844124d0, 2.73100996d0, 2.73675108d0, 2.74268198d0,
     & 2.74870133d0, 2.75131392d0, 2.75474834d0, 2.75790858d0,
     & 2.76102924d0, 2.76501632d0, 2.76864624d0, 2.77211189d0,
     & 2.77557015d0, 2.77570987d0, 2.79040742d0, 2.80520463d0,
     & 2.82263446d0, 2.84026742d0, 2.85790682d0, 2.86024666d0,
     & 2.87663150d0, 2.87795782d0, 2.89448547d0, 2.89584255d0,
     & 2.89732480d0, 2.88422942d0, 2.87106442d0, 2.85855007d0,
     & 2.84582901d0, 2.83310103d0, 2.83567262d0, 2.82435107d0,
     & 2.83573675d0, 2.83208275d0, 2.84363556d0, 2.85532212d0,
     & 2.86700988d0, 2.87842011d0, 2.88962173d0, 2.90085983d0,
     & 2.91209912d0, 2.91622305d0, 2.91785693d0, 2.91259456d0,
     & 2.90793395d0, 2.90263534d0, 2.89733386d0, 2.89199781d0,
     & 2.90187716d0, 2.89640522d0, 2.89093065d0, 2.90044332d0,
     & 2.91652107d0, 2.92070794d0, 2.92398882d0, 2.92666221d0,
     & 2.92968249d0, 2.93270421d0, 2.93553662d0, 2.92318106d0,
     & 2.92588615d0, 2.92859292d0, 2.93988132d0, 2.95175147d0,
     & 2.97698951d0, 3.00237012d0, 3.00752330d0, 3.01795816d0,
     & 3.02801228d0, 3.03829265d0, 3.04132438d0, 3.04389644d0,
     & 3.04621434d0, 3.02554703d0, 3.00486612d0, 2.98417139d0,
     & 2.96346331d0, 2.96299267d0, 2.95750260d0, 2.95554471d0,
     & 2.95358062d0, 2.96002078d0, 2.96730542d0, 2.97485876d0,
     & 2.98502874d0, 2.98910952d0, 2.99292707d0, 2.99676943d0,
     & 3.00341082d0, 3.00695133d0, 3.00733852d0, 3.00746250d0,
     & 3.00668120d0, 3.00539231d0, 3.00408506d0, 2.99957323d0,
     & 3.00516415d0, 3.01097894d0, 3.01663256d0, 3.01938653d0,
     & 3.02514291d0, 3.05047536d0, 3.07547450d0, 3.10048556d0,
     & 3.12610722d0, 3.15178347d0, 3.15419650d0, 3.15335846d0,
     & 3.15142202d0, 3.14964414d0, 3.14795589d0, 3.14802217d0,
     & 3.12849712d0, 3.10931206d0, 3.09012222d0, 3.07070494d0,
     & 3.05097747d0, 3.05451965d0, 3.05702305d0, 3.06011224d0,
     & 3.06317663d0, 3.06624889d0, 3.06766319d0, 3.06909609d0,
     & 3.07075644d0, 3.07241344d0, 3.07992649d0, 3.08645940d0,
     & 3.09539557d0, 3.11006951d0, 3.33880162d0, 3.21223855d0,
     & 3.26876855d0, 3.37463856d0, 3.36464071d0, 3.23889947d0,
     & 3.30314469d0, 3.33411050d0, 3.35863543d0, 3.38691139d0,
     & 3.41750050d0, 3.44858265d0, 3.48007798d0, 3.50706363d0,
     & 3.52903914d0, 3.55773234d0, 3.57319307d0, 3.60041857d0,
     & 3.62064791d0, 3.64839816d0, 3.67788100d0, 3.70694757d0,
     & 3.72296572d0, 3.74968624d0, 3.77843189d0, 3.80468178d0,
     & 3.83380795d0, 3.86229038d0, 3.90561604d0, 3.93099999d0,
     & 3.95867777d0, 3.98705745d0, 4.01468182d0, 4.03921366d0,
     & 4.08374405d0, 4.11219883d0, 4.13881159d0, 4.16807938d0,
     & 4.19637012d0, 4.20598793d0, 4.23593378d0, 4.26599979d0,
     & 4.29565620d0, 4.32527637d0, 4.35446215d0, 4.37048674d0,
     & 4.41736603d0, 4.44717312d0, 4.47407198d0, 4.50183249d0,
     & 4.53086615d0, 4.55985832d0, 4.58829784d0, 4.61584044d0,
     & 4.64440346d0, 4.67502260d0, 4.70352077d0, 4.73218727d0,
     & 4.76237297d0, 4.79150200d0, 4.80441475d0, 4.83662081d0,
     & 4.86400509d0, 4.89278936d0, 4.92609835d0, 4.95101976d0,
     & 4.98032761d0, 5.00863266d0, 5.03825665d0, 5.07905579d0,
     & 5.11527061d0, 5.15275192d0, 5.18902922d0, 5.22239304d0,
     & 5.24860954d0, 5.27576113d0, 5.31072521d0, 5.34597731d0,
     & 5.37461853d0, 5.40338421d0, 5.41755819d0, 5.44870663d0,
     & 5.46684361d0, 5.48942137d0, 5.51243305d0, 5.53717422d0,
     & 5.55881786d0, 5.59032393d0, 5.61893845d0, 5.64285278d0,
     & 5.67770910d0, 5.70497751d0, 5.73619127d0, 5.76814651d0,
     & 5.79534197d0, 5.82217550d0, 5.84975386d0, 5.89067936d0,
     & 5.92000484d0, 5.94784355d0, 5.97573423d0, 6.00504827d0,
     & 6.02747869d0, 6.05318451d0, 6.08409357d0, 6.11441660d0,
     & 6.14426184d0, 6.17286444d0, 6.19462347d0, 6.22199678d0,
     & 6.25167656d0, 6.28310108d0, 6.31538582d0, 6.34027052d0,
     & 6.37101889d0, 6.40104055d0, 6.42704391d0, 6.45562696d0,
     & 6.48323059d0, 6.50986290d0, 6.54199600d0, 6.57058334d0,
     & 6.59409571d0, 6.61995077d0, 6.64716578d0, 6.67198610d0,
     & 6.69957399d0, 6.73082876d0, 6.76085997d0, 6.79282522d0,
     & 6.81797171d0, 6.84631443d0, 6.87171030d0, 6.89882326d0,
     & 6.92629480d0, 6.95539522d0, 6.98382139d0, 7.01166773d0,
     & 7.04632044d0, 7.07841206d0, 7.10728931d0, 7.13109541d0,
     & 7.15594292d0, 7.18796349d0, 7.21943665d0, 7.25001621d0,
     & 7.28013515d0, 7.30641890d0, 7.33187532d0, 7.35509491d0,
     & 7.38549137d0, 7.41443253d0, 7.44235468d0, 7.47671795d0,
     & 7.50583696d0, 7.53353119d0, 7.56307793d0, 7.59018803d0,
     & 7.61827326d0, 7.64333296d0, 7.66852999d0, 7.69657612d0,
     & 7.72599506d0, 7.75241995d0, 7.78237295d0, 7.81217289d0,
     & 7.84192705d0, 7.87102842d0, 7.89803696d0, 7.92560720d0,
     & 7.95067358d0, 7.97881269d0, 8.00744534d0, 8.03108788d0,
     & 8.05618000d0, 8.08646870d0, 8.11633110d0, 8.14281178d0,
     & 8.17284870d0, 8.20442104d0, 8.23355389d0, 8.26302433d0,
     & 8.29396629d0, 8.32382870d0, 8.35508060d0, 8.38628578d0,
     & 8.41279793d0, 8.44140816d0, 8.47000790d0, 8.49899769d0,
     & 8.52756119d0, 8.55501080d0, 8.57895565d0, 8.60402393d0,
     & 8.62982559d0, 8.66069889d0, 8.68911362d0, 8.71718025d0,
     & 8.74698830d0, 8.77682114d0, 8.80641079d0, 8.83392620d0,
     & 8.86105824d0, 8.88796329d0, 8.91741276d0, 8.94691753d0,
     & 8.97269917d0, 8.99818039d0, 9.02419758d0, 9.05395794d0,
     & 9.08334637d0, 9.11015987d0, 9.13728237d0, 9.16084957d0,
     & 9.18608284d0, 9.21200562d0, 9.23939133d0, 9.26495743d0,
     & 9.28924179d0, 9.32297134d0, 9.35205746d0, 9.37905502d0,
     & 9.40549755d0, 9.43124485d0, 9.45647907d0, 9.48090267d0,
     & 9.50838089d0, 9.53543472d0, 9.56409073d0, 9.59300327d0,
     & 9.62223053d0, 9.64978123d0, 9.67632198d0, 9.70489025d0,
     & 9.73097706d0, 9.75829697d0, 9.78769779d0, 9.81550980d0,
     & 9.84432983d0, 9.87214565d0, 9.89897251d0, 9.92390728d0,
     & 9.95118713d0, 9.97490120d0,10.00336647d0,10.03069019d0,
     &10.05665684d0,10.08489799d0,10.11350727d0,10.14192390d0,
     &10.16753197d0,10.19423389d0,10.22060871d0,10.24653244d0,
     &10.27354527d0,10.30187130d0,10.32647610d0,10.35468197d0,
     &10.38319016d0,10.41020584d0,10.44107914d0,10.47184086d0,
     &10.49714470d0,10.52400208d0,10.55124569d0,10.58113480d0,
     &10.61027431d0,10.63925648d0,10.66793060d0,10.69519520d0,
     &10.71957302d0,10.74468803d0,10.77239704d0,10.79925442d0,
     &10.82892227d0,10.85755157d0,10.88455486d0,10.91080570d0,
     &10.94122696d0,10.96854496d0,10.99856472d0,11.02741718d0,
     &11.05371666d0,11.08630085d0,11.11251450d0,11.14488697d0,
     &11.17701721d0,11.20761967d0,11.24016380d0,11.26852703d0,
     &11.29844475d0,11.32470512d0,11.34681511d0,11.37437248d0,
     &11.40316772d0,11.43068218d0,11.45693398d0,11.48397636d0,
     &11.51224518d0,11.54159164d0,11.56768703d0,11.59582233d0,
     &11.62149429d0,11.64767933d0,11.67385483d0,11.70141888d0,
     &11.73246574d0,11.76282692d0,11.79116249d0,11.82275867d0,
     &11.84882545d0,11.87442207d0,11.90294552d0,11.93119812d0,
     &11.95907879d0,11.98964787d0,12.01760769d0,12.04441738d0,
     &12.06929207d0,12.09624481d0,12.12178421d0,12.14888382d0,
     &12.17964172d0,12.20985794d0,12.23911953d0,12.26800442d0,
     &12.29426384d0,12.32094765d0,12.34690666d0,12.37852192d0,
     &12.40384388d0,12.43200207d0,12.45786762d0,12.48205376d0,
     &12.51185226d0,12.53721809d0,12.56629944d0,12.59488487d0,
     &12.62373734d0,12.65131474d0,12.67831326d0,12.70481586d0,
     &12.73504353d0,12.76682472d0,12.79965305d0,12.82460594d0,
     &12.84903336d0,12.87416553d0,12.90406322d0,12.93653870d0,
     &12.96191502d0,12.98665714d0,13.01550674d0,13.04225349d0,
     &13.06901360d0,13.09611607d0,13.12754631d0,13.15694332d0,
     &13.18519497d0,13.21312332d0,13.24206352d0,13.27433872d0,
     &13.30297852d0,13.33234882d0,13.35918140d0,13.38892841d0,
     &13.41896152d0,13.44718170d0,13.47356415d0,13.50358868d0,
     &13.53053856d0,13.56064320d0,13.58691978d0,13.61653996d0,
     &13.64951324d0,13.68336964d0,13.71317959d0,13.73784924d0,
     &13.76311874d0,13.79116726d0,13.82286644d0,13.85352039d0,
     &13.88346291d0,13.90790653d0,13.93616772d0,13.96294785d0,
     &13.98780060d0,14.01397800d0,14.04172897d0,14.07215309d0,
     &14.10314465d0,14.13271332d0,14.16051579d0,14.18987656d0,
     &14.21966267d0,14.25003815d0,14.27976799d0,14.30732727d0,
     &14.33712673d0,14.36367702d0,14.39201355d0,14.42104053d0,
     &14.44801712d0,14.47509766d0,14.50516987d0,14.53374863d0,
     &14.56269741d0,14.59020233d0,14.62022591d0,14.65058994d0,
     &14.67530632d0,14.70349503d0,14.73424625d0,14.76533318d0,
     &14.79180241d0,14.81836796d0,14.84772491d0,14.87668991d0,
     &14.90464878d0,14.93377018d0,14.96566963d0,14.99720478d0,
     &15.02502918d0,15.06104946d0,15.08844280d0,15.11609650d0,
     &15.14680195d0,15.17539024d0,15.20293617d0,15.22601604d0,
     &15.25239086d0,15.28212833d0,15.31201363d0,15.33844566d0,
     &15.36695385d0,15.39651299d0,15.42646980d0,15.45853615d0,
     &15.48964691d0,15.52345562d0,15.55286121d0,15.58116817d0,
     &15.61050415d0,15.64279079d0,15.67677498d0,15.70510960d0,
     &15.73398399d0,15.76392841d0,15.79433250d0,15.82212353d0,
     &15.85070896d0,15.88146782d0,15.91141224d0,15.93952084d0,
     &15.96611595d0,15.99355507d0,16.02112579d0,16.05295753d0,
     &16.08305550d0,16.11204147d0,16.14122009d0,16.17297935d0,
     &16.20315170d0,16.23199272d0,16.26391983d0,16.29661751d0,
     &16.32837105d0,16.35688019d0,16.38937378d0,16.41330338d0,
     &16.44338608d0,16.47380447d0,16.50704575d0,16.53132248d0,
     &16.55671120d0,16.58711433d0,16.61490440d0,16.64687538d0,
     &16.67631912d0,16.70700455d0,16.73883057d0,16.76816940d0,
     &16.79911232d0,16.82913589d0,16.85416794d0,16.88659477d0,
     &16.91929436d0,16.94737053d0,16.97571754d0,17.00729561d0,
     &17.03906631d0,17.06956291d0,17.10238647d0,17.13115883d0,
     &17.16331673d0,17.19478226d0,17.22201347d0,17.24986076d0,
     &17.28362656d0,17.31632996d0,17.34620094d0,17.37658882d0,
     &17.41026878d0,17.43999481d0,17.46837044d0,17.49666214d0,
     &17.52378845d0,17.55511284d0,17.58924866d0,17.61768341d0,
     &17.65046501d0,17.68160820d0,17.70786285d0,17.73728752d0,
     &17.76953697d0,17.80136108d0,17.83406448d0,17.86298370d0,
     &17.89628601d0,17.93208122d0,17.96319962d0,17.99619484d0,
     &18.02729607d0,18.06332779d0,18.09336472d0,18.12162781d0,
     &18.14968872d0,18.17771912d0,18.21315002d0,18.24405098d0,
     &18.27265549d0,18.30902100d0,18.33440018d0,18.36426544d0,
     &18.40081787d0,18.43796158d0,18.46951103d0,18.50575638d0,
     &18.53402328d0,18.56802559d0,18.60307693d0,18.63694000d0,
     &18.66857529d0,18.69941139d0,18.73254776d0,18.76797485d0,
     &18.79615784d0,18.82920074d0,18.85509300d0,18.88287163d0,
     &18.90736961d0,18.94089890d0,18.97133446d0,19.00288963d0,
     &19.03520966d0,19.06955719d0,19.10482216d0,19.13695145d0,
     &19.16959572d0,19.20187378d0,19.23652077d0,19.26949883d0,
     &19.30647850d0,19.33921242d0,19.37378502d0,19.40494537d0,
     &19.43859100d0,19.46958733d0,19.49682426d0,19.53073692d0,
     &19.56163597d0,19.59349060d0,19.62766647d0,19.65320969d0,
     &19.68320084d0,19.71547890d0,19.74530983d0,19.77569580d0,
     &19.80681419d0,19.83968353d0,19.86832428d0,19.89592743d0,
     &19.93255043d0,19.96537399d0,19.99123764d0,20.01775742d0,
     &20.04562187d0,20.07459831d0,20.10135269d0,20.13818741d0,
     &20.17954254d0,20.20485306d0,20.23637009d0,20.27408028d0,
     &20.30179787d0,20.34172821d0,20.38272858d0,20.42059135d0,
     &20.45279694d0,20.48484612d0,20.51475716d0,20.54478455d0,
     &20.57028389d0,20.61194229d0,20.64734459d0,20.67199898d0,
     &20.70670509d0,20.74847603d0,20.78107262d0,20.81587982d0,
     &20.85071182d0,20.88146210d0,20.91950798d0,20.95975304d0,
     &20.99458313d0,21.02578354d0,21.05555916d0,21.09116936d0,
     &21.13317299d0,21.17051888d0,21.20002937d0,21.23790169d0,
     &21.26959038d0,21.30195618d0,21.33938408d0,21.37786484d0,
     &21.41379929d0,21.45606232d0,21.48630714d0,21.52297401d0,
     &21.55965614d0,21.60540962d0,21.64157295d0,21.67827988d0,
     &21.71423149d0,21.74356461d0,21.77628899d0,21.81111717d0,
     &21.84896278d0,21.89020729d0,21.93137741d0,21.96651649d0,
     &22.00364876d0,22.04884720d0,22.08332443d0,22.12873459d0,
     &22.16508865d0,22.20446587d0,22.24088478d0,22.27363396d0,
     &22.30990219d0,22.34245682d0,22.37992477d0,22.41741753d0,
     &22.45708656d0,22.49459648d0,22.53619957d0,22.56960487d0,
     &22.60112190d0,22.64141655d0,22.67463493d0,22.70403671d0,
     &22.73941422d0,22.77874947d0,22.81402397d0,22.85107040d0,
     &22.88187408d0,22.92233467d0,22.95553017d0,22.99831200d0,
     &23.03829384d0,23.08390427d0,23.12110519d0,23.15917587d0,
     &23.19623566d0,23.22947311d0,23.26297760d0,23.30130196d0,
     &23.33683777d0,23.37730598d0,23.41392708d0,23.45372963d0,
     &23.48090935d0,23.52489662d0,23.55790901d0,23.59992409d0,
     &23.63580704d0,23.67860794d0,23.71964645d0,23.74999428d0,
     &23.79465294d0,23.82710838d0,23.85927963d0,23.88860130d0,
     &23.92509079d0,23.96685219d0,24.00477028d0,24.04448128d0,
     &24.08524704d0,24.12812996d0,24.17840004d0,24.22883415d0,
     &24.26763725d0,24.29362679d0,23.97136307d0,23.47602844d0,
     &22.83939934d0,22.14184761d0,21.32863617d0,20.45112801d0,
     &19.62720108d0,18.66349983d0,17.70845032d0,16.65244102d0,
     &15.74831581d0,15.07745934d0,14.53627872d0,14.08860207d0,
     &13.69857311d0,13.35006523d0,13.03984833d0,12.75939751d0,
     &12.49705315d0,12.25095558d0,12.02677155d0,11.81440353d0,
     &11.61512470d0,11.42432022d0,11.24537945d0,11.07458687d0,
     &10.91377068d0,10.75752068d0,10.60784912d0,10.46541023d0,
     &10.32786083d0,10.19417381d0,10.06724167d0, 9.94333172d0,
     & 9.82588577d0, 9.70997524d0, 9.59963131d0, 9.49155331d0,
     & 9.38768864d0, 9.28460979d0, 9.18742657d0, 9.09263802d0,
     & 8.99884701d0, 8.90891743d0, 8.82171440d0, 8.73583984d0,
     & 8.65262222d0, 8.57124138d0, 8.49218750d0, 8.41527653d0,
     & 8.34003067d0, 8.26513958d0, 8.19310379d0, 8.12357330d0,
     & 8.05504417d0, 7.98698854d0, 7.92081118d0, 7.85658646d0,
     & 7.79427862d0, 7.73206663d0, 7.67138052d0,15.74037361d0,
     & 7.55409288d0, 7.49708033d0,15.90479374d0,15.90479374d0,
     &16.31584167d0,15.90479374d0,15.82258320d0,15.90479374d0,
     &15.74037361d0,15.74037361d0, 7.03157806d0, 6.98471832d0,
     & 6.93832254d0, 6.89225149d0,15.82258320d0, 6.80314875d0,
     &15.82258320d0,16.06921387d0,15.90479374d0,16.68251610d0,
     &16.68655396d0,16.69462967d0,16.70169449d0,16.69160080d0,
     &16.69462967d0,16.69563866d0,16.70775032d0,16.70270348d0,
     &16.70472336d0,16.70775032d0,16.70472336d0,16.70674133d0,
     &16.70573235d0,16.70674133d0,16.70977020d0,16.70977020d0,
     &16.71582603d0,16.71784401d0,16.72389984d0,16.72793770d0,
     &16.72188187d0,16.71582603d0,16.71380615d0,16.72188187d0,
     &16.71380615d0,16.72087288d0,16.72087288d0,16.71481705d0,
     &16.71784401d0,16.72591972d0,16.72692871d0,16.73096657d0,
     &16.73197556d0,16.72995758d0,16.73500443d0,16.75620079d0,
     &16.75014496d0,16.76730347d0,16.75922775d0,16.75922775d0,
     &16.77033043d0,16.76831245d0,16.77033043d0,16.77840614d0,
     &16.77840614d0,16.77235031d0,16.77335930d0,16.77537727d0,
     &16.77134132d0,16.77739716d0,16.78446198d0,16.77335930d0,
     &16.76528358d0,16.79051781d0,16.81070518d0,16.82584572d0,
     &16.83190155d0,16.82685471d0,16.84199524d0,16.85007095d0,
     &16.84603310d0,16.83291245d0,16.85511780d0,16.87227631d0,
     &16.84098625d0,16.83997726d0,16.82079887d0,16.82483673d0,
     &16.85713577d0,16.85814667d0,16.87934303d0,16.90053940d0,
     &16.89145470d0,16.90760422d0,16.92173576d0,16.95605469d0,
     &16.93082047d0,16.94999695d0,16.99037170d0,17.01358795d0,
     &17.02771950d0, 4.76450062d0,16.88035202d0,17.36181831d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0,
     &17.42540741d0,17.42540741d0,17.42540741d0,17.42540741d0
     &/
c Definition of open field lines as Lupper=f(Iupper) for doy=061
      DATA (Lupper ( 3,I), I= 1, 1001) /
     & 9.20d0, 9.20d0, 9.20d0, 9.20d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0,
     & 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0,
     & 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0,
     & 9.23d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.25d0,
     & 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.26d0, 9.26d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0,
     & 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0,
     & 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0,
     & 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0,
     & 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0,
     & 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0,
     & 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0,
     & 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0,
     & 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0,
     & 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0,
     & 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0,
     & 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0,
     & 9.23d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0,
     & 9.23d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0,
     & 9.23d0, 9.23d0, 9.23d0, 9.22d0, 9.22d0, 9.23d0, 9.23d0, 9.23d0,
     & 9.23d0, 9.23d0, 9.23d0, 9.23d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0,
     & 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0,
     & 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0,
     & 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.21d0, 9.21d0, 9.22d0, 9.22d0, 9.21d0, 9.21d0, 9.21d0,
     & 9.21d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0, 9.22d0,
     & 9.22d0, 9.22d0, 9.22d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0, 9.23d0,
     & 9.23d0, 9.23d0, 9.23d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0, 9.24d0,
     & 9.24d0, 9.24d0, 9.25d0, 9.25d0, 9.25d0, 9.25d0, 9.26d0, 9.26d0,
     & 9.26d0, 9.26d0, 9.27d0, 9.27d0, 9.27d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.30d0, 9.30d0, 9.30d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.32d0, 9.33d0, 9.33d0, 9.34d0, 9.34d0, 9.35d0, 9.36d0,
     & 9.36d0, 9.37d0, 9.38d0, 9.38d0, 9.39d0, 9.40d0, 9.41d0, 9.41d0,
     & 9.42d0, 9.44d0, 9.45d0, 9.47d0, 9.49d0, 9.50d0, 9.52d0, 9.54d0,
     & 9.56d0, 9.58d0, 9.60d0, 9.61d0, 9.63d0, 9.65d0, 9.67d0, 9.69d0,
     & 9.71d0, 9.73d0, 9.75d0, 9.77d0, 9.80d0, 9.82d0, 9.84d0, 9.86d0,
     & 9.88d0, 9.90d0, 9.92d0, 9.94d0, 9.96d0, 9.98d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0,
     & 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0
     &/
      DATA (Iupper ( 3,I), I= 1, 1001) /
     & 0.00010000d0, 0.00010127d0, 0.00010255d0, 0.00010386d0,
     & 0.00010517d0, 0.00010651d0, 0.00010786d0, 0.00010923d0,
     & 0.00011062d0, 0.00011202d0, 0.00011344d0, 0.00011488d0,
     & 0.00011634d0, 0.00011782d0, 0.00011931d0, 0.00012083d0,
     & 0.00012236d0, 0.00012391d0, 0.00012548d0, 0.00012708d0,
     & 0.00012869d0, 0.00013032d0, 0.00013198d0, 0.00013365d0,
     & 0.00013535d0, 0.00013707d0, 0.00013881d0, 0.00014057d0,
     & 0.00014235d0, 0.00014416d0, 0.00014599d0, 0.00014784d0,
     & 0.00014972d0, 0.00015162d0, 0.00015354d0, 0.00015549d0,
     & 0.00015746d0, 0.00015946d0, 0.00016148d0, 0.00016353d0,
     & 0.00016561d0, 0.00016771d0, 0.00016984d0, 0.00017200d0,
     & 0.00017418d0, 0.00017639d0, 0.00017863d0, 0.00018089d0,
     & 0.00018319d0, 0.00018551d0, 0.00018787d0, 0.00019025d0,
     & 0.00019267d0, 0.00019511d0, 0.00019759d0, 0.00020010d0,
     & 0.00020264d0, 0.00020521d0, 0.00020781d0, 0.00021045d0,
     & 0.00021312d0, 0.00021583d0, 0.00021857d0, 0.00022134d0,
     & 0.00022415d0, 0.00022699d0, 0.00022987d0, 0.00023279d0,
     & 0.00023575d0, 0.00023874d0, 0.00024177d0, 0.00024484d0,
     & 0.00024794d0, 0.00025109d0, 0.00025428d0, 0.00025750d0,
     & 0.00026077d0, 0.00026408d0, 0.00026743d0, 0.00027083d0,
     & 0.00027426d0, 0.00027775d0, 0.00028127d0, 0.00028484d0,
     & 0.00028846d0, 0.00029212d0, 0.00029582d0, 0.00029958d0,
     & 0.00030338d0, 0.00030723d0, 0.00031113d0, 0.00031508d0,
     & 0.00031908d0, 0.00032313d0, 0.00032723d0, 0.00033138d0,
     & 0.00033559d0, 0.00033984d0, 0.00034416d0, 0.00034853d0,
     & 0.00035295d0, 0.00035743d0, 0.00036196d0, 0.00036656d0,
     & 0.00037121d0, 0.00037592d0, 0.00038069d0, 0.00038552d0,
     & 0.00039042d0, 0.00039537d0, 0.00040039d0, 0.00040547d0,
     & 0.00041062d0, 0.00041583d0, 0.00042111d0, 0.00042645d0,
     & 0.00043186d0, 0.00043734d0, 0.00044289d0, 0.00044852d0,
     & 0.00045421d0, 0.00045997d0, 0.00046581d0, 0.00047172d0,
     & 0.00047771d0, 0.00048377d0, 0.00048991d0, 0.00049613d0,
     & 0.00050243d0, 0.00050880d0, 0.00051526d0, 0.00052180d0,
     & 0.00052842d0, 0.00053513d0, 0.00054192d0, 0.00054880d0,
     & 0.00055576d0, 0.00056281d0, 0.00056996d0, 0.00057719d0,
     & 0.00058452d0, 0.00059194d0, 0.00059945d0, 0.00060706d0,
     & 0.00061476d0, 0.00062256d0, 0.00063046d0, 0.00063846d0,
     & 0.00064657d0, 0.00065477d0, 0.00066308d0, 0.00067150d0,
     & 0.00068002d0, 0.00068865d0, 0.00069739d0, 0.00070624d0,
     & 0.00071521d0, 0.00072428d0, 0.00073347d0, 0.00074278d0,
     & 0.00075221d0, 0.00076176d0, 0.00077142d0, 0.00078122d0,
     & 0.00079113d0, 0.00080117d0, 0.00081134d0, 0.00082164d0,
     & 0.00083206d0, 0.00084262d0, 0.00085332d0, 0.00086415d0,
     & 0.00087511d0, 0.00088622d0, 0.00089747d0, 0.00090886d0,
     & 0.00092039d0, 0.00093207d0, 0.00094390d0, 0.00095588d0,
     & 0.00096801d0, 0.00098030d0, 0.00099274d0, 0.00100534d0,
     & 0.00101810d0, 0.00103102d0, 0.00104411d0, 0.00105736d0,
     & 0.00107078d0, 0.00108437d0, 0.00109813d0, 0.00111206d0,
     & 0.00112618d0, 0.00114047d0, 0.00115495d0, 0.00116960d0,
     & 0.00118445d0, 0.00119948d0, 0.00121470d0, 0.00123012d0,
     & 0.00124573d0, 0.00126154d0, 0.00127755d0, 0.00129377d0,
     & 0.00131019d0, 0.00132681d0, 0.00134365d0, 0.00136071d0,
     & 0.00137797d0, 0.00139546d0, 0.00141317d0, 0.00143111d0,
     & 0.00144927d0, 0.00146766d0, 0.00148629d0, 0.00150515d0,
     & 0.00152426d0, 0.00154360d0, 0.00156319d0, 0.00158303d0,
     & 0.00160312d0, 0.00162347d0, 0.00164407d0, 0.00166494d0,
     & 0.00168607d0, 0.00170747d0, 0.00172914d0, 0.00175108d0,
     & 0.00177331d0, 0.00179581d0, 0.00181860d0, 0.00184168d0,
     & 0.00186506d0, 0.00188873d0, 0.00191270d0, 0.00193697d0,
     & 0.00196156d0, 0.00198645d0, 0.00201166d0, 0.00203719d0,
     & 0.00206305d0, 0.00208923d0, 0.00211575d0, 0.00214260d0,
     & 0.00216979d0, 0.00219733d0, 0.00222521d0, 0.00225346d0,
     & 0.00228206d0, 0.00231102d0, 0.00234035d0, 0.00237005d0,
     & 0.00240013d0, 0.00243059d0, 0.00246144d0, 0.00249268d0,
     & 0.00252431d0, 0.00255635d0, 0.00258879d0, 0.00262165d0,
     & 0.00265492d0, 0.00268862d0, 0.00272274d0, 0.00275729d0,
     & 0.00279229d0, 0.00282773d0, 0.00286361d0, 0.00289996d0,
     & 0.00293676d0, 0.00297403d0, 0.00301178d0, 0.00305000d0,
     & 0.00308871d0, 0.00312791d0, 0.00316761d0, 0.00320781d0,
     & 0.00324852d0, 0.00328975d0, 0.00333150d0, 0.00337378d0,
     & 0.00341660d0, 0.00345996d0, 0.00350387d0, 0.00354834d0,
     & 0.00359337d0, 0.00363898d0, 0.00368516d0, 0.00373193d0,
     & 0.00377930d0, 0.00382726d0, 0.00387583d0, 0.00392502d0,
     & 0.00397484d0, 0.00402528d0, 0.00407637d0, 0.00412811d0,
     & 0.00418050d0, 0.00423355d0, 0.00428728d0, 0.00434169d0,
     & 0.00439680d0, 0.00445260d0, 0.00450911d0, 0.00456633d0,
     & 0.00462429d0, 0.00468298d0, 0.00474241d0, 0.00480260d0,
     & 0.00486355d0, 0.00492528d0, 0.00498778d0, 0.00505109d0,
     & 0.00511519d0, 0.00518011d0, 0.00524585d0, 0.00531243d0,
     & 0.00537985d0, 0.00544813d0, 0.00551727d0, 0.00558730d0,
     & 0.00565821d0, 0.00573002d0, 0.00580274d0, 0.00587639d0,
     & 0.00595096d0, 0.00602649d0, 0.00610298d0, 0.00618043d0,
     & 0.00625887d0, 0.00633830d0, 0.00641874d0, 0.00650021d0,
     & 0.00658270d0, 0.00666625d0, 0.00675085d0, 0.00683653d0,
     & 0.00692329d0, 0.00701116d0, 0.00710014d0, 0.00719025d0,
     & 0.00728151d0, 0.00737392d0, 0.00746751d0, 0.00756228d0,
     & 0.00765826d0, 0.00775545d0, 0.00785387d0, 0.00795355d0,
     & 0.00805449d0, 0.00815672d0, 0.00826024d0, 0.00836507d0,
     & 0.00847124d0, 0.00857875d0, 0.00868762d0, 0.00879788d0,
     & 0.00890954d0, 0.00902261d0, 0.00913712d0, 0.00925308d0,
     & 0.00937052d0, 0.00948945d0, 0.00960988d0, 0.00973184d0,
     & 0.00985535d0, 0.00998043d0, 0.01010710d0, 0.01023537d0,
     & 0.01036527d0, 0.01049682d0, 0.01063004d0, 0.01076495d0,
     & 0.01090157d0, 0.01103993d0, 0.01118004d0, 0.01132193d0,
     & 0.01146563d0, 0.01161114d0, 0.01175850d0, 0.01190773d0,
     & 0.01205886d0, 0.01221190d0, 0.01236688d0, 0.01252384d0,
     & 0.01268278d0, 0.01284374d0, 0.01300676d0, 0.01317183d0,
     & 0.01333899d0, 0.01350829d0, 0.01367973d0, 0.01385334d0,
     & 0.01402915d0, 0.01420721d0, 0.01438751d0, 0.01457011d0,
     & 0.01475503d0, 0.01494229d0, 0.01513193d0, 0.01532398d0,
     & 0.01551846d0, 0.01571541d0, 0.01591486d0, 0.01611684d0,
     & 0.01632139d0, 0.01652853d0, 0.01673830d0, 0.01695073d0,
     & 0.01716586d0, 0.01738372d0, 0.01760434d0, 0.01782776d0,
     & 0.01805403d0, 0.01828315d0, 0.01851519d0, 0.01875018d0,
     & 0.01898814d0, 0.01922913d0, 0.01947318d0, 0.01972032d0,
     & 0.01997059d0, 0.02022405d0, 0.02048072d0, 0.02074065d0,
     & 0.02100387d0, 0.02127045d0, 0.02154040d0, 0.02181377d0,
     & 0.02209063d0, 0.02237098d0, 0.02265490d0, 0.02294243d0,
     & 0.02323360d0, 0.02352846d0, 0.02382708d0, 0.02412947d0,
     & 0.02443570d0, 0.02474584d0, 0.02505989d0, 0.02537793d0,
     & 0.02570002d0, 0.02602619d0, 0.02635649d0, 0.02669099d0,
     & 0.02702975d0, 0.02737279d0, 0.02772018d0, 0.02807200d0,
     & 0.02842827d0, 0.02878906d0, 0.02915444d0, 0.02952445d0,
     & 0.02989915d0, 0.03027862d0, 0.03066289d0, 0.03105204d0,
     & 0.03144613d0, 0.03184524d0, 0.03224939d0, 0.03265868d0,
     & 0.03307318d0, 0.03349292d0, 0.03391798d0, 0.03434846d0,
     & 0.03478439d0, 0.03522584d0, 0.03567292d0, 0.03612565d0,
     & 0.03658413d0, 0.03704845d0, 0.03751864d0, 0.03799480d0,
     & 0.03847702d0, 0.03896534d0, 0.03945986d0, 0.03996065d0,
     & 0.04046782d0, 0.04098141d0, 0.04150151d0, 0.04202824d0,
     & 0.04256163d0, 0.04310180d0, 0.04364883d0, 0.04420279d0,
     & 0.04476377d0, 0.04533191d0, 0.04590723d0, 0.04648984d0,
     & 0.04707986d0, 0.04767738d0, 0.04828247d0, 0.04889523d0,
     & 0.04951580d0, 0.05014421d0, 0.05078061d0, 0.05142510d0,
     & 0.05207775d0, 0.05273868d0, 0.05340803d0, 0.05408584d0,
     & 0.05477226d0, 0.05546741d0, 0.05617137d0, 0.05688425d0,
     & 0.05760621d0, 0.05833730d0, 0.05907768d0, 0.05982745d0,
     & 0.06058676d0, 0.06135568d0, 0.06213436d0, 0.06292295d0,
     & 0.06372152d0, 0.06453023d0, 0.06534923d0, 0.06617859d0,
     & 0.06701849d0, 0.06786907d0, 0.06873041d0, 0.06960268d0,
     & 0.07048602d0, 0.07138062d0, 0.07228653d0, 0.07320394d0,
     & 0.07413302d0, 0.07507385d0, 0.07602664d0, 0.07699155d0,
     & 0.07796867d0, 0.07895819d0, 0.07996030d0, 0.08097509d0,
     & 0.08200277d0, 0.08304353d0, 0.08409746d0, 0.08516476d0,
     & 0.08624565d0, 0.08734021d0, 0.08844867d0, 0.08957119d0,
     & 0.09070800d0, 0.09185920d0, 0.09302501d0, 0.09420566d0,
     & 0.09540125d0, 0.09661201d0, 0.09783818d0, 0.09907987d0,
     & 0.10033731d0, 0.10161077d0, 0.10290034d0, 0.10420627d0,
     & 0.10552878d0, 0.10686813d0, 0.10822441d0, 0.10959791d0,
     & 0.11098890d0, 0.11239749d0, 0.11382396d0, 0.11526857d0,
     & 0.11673148d0, 0.11821295d0, 0.11971328d0, 0.12123259d0,
     & 0.12277117d0, 0.12432936d0, 0.12590724d0, 0.12750517d0,
     & 0.12912343d0, 0.13076216d0, 0.13242172d0, 0.13410230d0,
     & 0.13580430d0, 0.13752782d0, 0.13927321d0, 0.14104085d0,
     & 0.14283082d0, 0.14464353d0, 0.14647931d0, 0.14833830d0,
     & 0.15022090d0, 0.15212746d0, 0.15405814d0, 0.15601335d0,
     & 0.15799335d0, 0.15999855d0, 0.16202913d0, 0.16408549d0,
     & 0.16616802d0, 0.16827691d0, 0.17041254d0, 0.17257537d0,
     & 0.17476557d0, 0.17698357d0, 0.17922980d0, 0.18150444d0,
     & 0.18380795d0, 0.18614081d0, 0.18850316d0, 0.19089550d0,
     & 0.19331829d0, 0.19577175d0, 0.19825633d0, 0.20077245d0,
     & 0.20332061d0, 0.20590100d0, 0.20851412d0, 0.21116054d0,
     & 0.21384043d0, 0.21655434d0, 0.21930277d0, 0.22208601d0,
     & 0.22490457d0, 0.22775897d0, 0.23064953d0, 0.23357674d0,
     & 0.23654114d0, 0.23954326d0, 0.24258336d0, 0.24566205d0,
     & 0.24877992d0, 0.25193724d0, 0.25513467d0, 0.25837275d0,
     & 0.26165181d0, 0.26497251d0, 0.26833546d0, 0.27174097d0,
     & 0.27518973d0, 0.27868235d0, 0.28221917d0, 0.28580090d0,
     & 0.28942820d0, 0.29310140d0, 0.29682124d0, 0.30058825d0,
     & 0.30440310d0, 0.30826664d0, 0.31217894d0, 0.31614089d0,
     & 0.32015309d0, 0.32421625d0, 0.32833093d0, 0.33249786d0,
     & 0.33671802d0, 0.34099138d0, 0.34531897d0, 0.34970152d0,
     & 0.35413966d0, 0.35863414d0, 0.36318600d0, 0.36779529d0,
     & 0.37246308d0, 0.37719008d0, 0.38197711d0, 0.38682488d0,
     & 0.39173418d0, 0.39670613d0, 0.40174085d0, 0.40683943d0,
     & 0.41200271d0, 0.41723153d0, 0.42252675d0, 0.42788953d0,
     & 0.43332002d0, 0.43881938d0, 0.44438851d0, 0.45002836d0,
     & 0.45573980d0, 0.46152416d0, 0.46738148d0, 0.47331312d0,
     & 0.47932005d0, 0.48540321d0, 0.49156362d0, 0.49780214d0,
     & 0.50412035d0, 0.51051831d0, 0.51699740d0, 0.52355874d0,
     & 0.53020334d0, 0.53693229d0, 0.54374713d0, 0.55064797d0,
     & 0.55763638d0, 0.56471354d0, 0.57188040d0, 0.57913828d0,
     & 0.58648884d0, 0.59393209d0, 0.60146987d0, 0.60910326d0,
     & 0.61683351d0, 0.62466192d0, 0.63258964d0, 0.64061862d0,
     & 0.64874887d0, 0.65698230d0, 0.66532022d0, 0.67376393d0,
     & 0.68231487d0, 0.69097501d0, 0.69974434d0, 0.70862496d0,
     & 0.71761823d0, 0.72672570d0, 0.73594880d0, 0.74528891d0,
     & 0.75474828d0, 0.76432699d0, 0.77402723d0, 0.78385061d0,
     & 0.79379863d0, 0.80387294d0, 0.81407589d0, 0.82440752d0,
     & 0.83487028d0, 0.84546578d0, 0.85619581d0, 0.86706197d0,
     & 0.87806606d0, 0.88921070d0, 0.90049589d0, 0.91192430d0,
     & 0.92349786d0, 0.93521816d0, 0.94708717d0, 0.95910788d0,
     & 0.97128016d0, 0.98360693d0, 0.99609011d0, 1.00873172d0,
     & 1.02153373d0, 1.03449929d0, 1.04762840d0, 1.06092405d0,
     & 1.07438850d0, 1.08802390d0, 1.10183227d0, 1.11581588d0,
     & 1.12997806d0, 1.14431894d0, 1.15884173d0, 1.17354894d0,
     & 1.18844259d0, 1.20352542d0, 1.21880090d0, 1.23426902d0,
     & 1.24993336d0, 1.26579666d0, 1.28186119d0, 1.29812956d0,
     & 1.31460571d0, 1.33128977d0, 1.34818542d0, 1.36529553d0,
     & 1.38262296d0, 1.40017009d0, 1.41794002d0, 1.43593681d0,
     & 1.45416057d0, 1.47261584d0, 1.49130499d0, 1.51023161d0,
     & 1.52939832d0, 1.54880977d0, 1.56846607d0, 1.58837199d0,
     & 1.60853028d0, 1.62894464d0, 1.64961791d0, 1.67055368d0,
     & 1.69175661d0, 1.71322715d0, 1.73497009d0, 1.75698900d0,
     & 1.77928746d0, 1.80186892d0, 1.82473862d0, 1.84789681d0,
     & 1.87134874d0, 1.89509857d0, 1.91914976d0, 1.94350624d0,
     & 1.96817160d0, 1.99315214d0, 2.01844788d0, 2.04406428d0,
     & 2.07000613d0, 2.09627700d0, 2.12288141d0, 2.14982557d0,
     & 2.17710948d0, 2.20473981d0, 2.23272061d0, 2.26105666d0,
     & 2.28975224d0, 2.31881428d0, 2.34824300d0, 2.37804508d0,
     & 2.40822554d0, 2.43878889d0, 2.46974015d0, 2.50108409d0,
     & 2.53282857d0, 2.56497312d0, 2.59752584d0, 2.63049173d0,
     & 2.66387582d0, 2.69768381d0, 2.73192358d0, 2.76659513d0,
     & 2.80170655d0, 2.83726382d0, 2.87327218d0, 2.90973759d0,
     & 2.94666839d0, 2.98406553d0, 3.02193713d0, 3.06028914d0,
     & 3.09912801d0, 3.13845992d0, 3.17829084d0, 3.21863031d0,
     & 3.25947881d0, 3.30084562d0, 3.34273744d0, 3.38516092d0,
     & 3.42812300d0, 3.47163343d0, 3.51569295d0, 3.56031132d0,
     & 3.60549593d0, 3.65125418d0, 3.69759321d0, 3.74452019d0,
     & 3.79204679d0, 3.84017253d0, 3.88890886d0, 3.93826389d0,
     & 3.98824549d0, 4.03886127d0, 4.09012318d0, 4.14203215d0,
     & 4.19460011d0, 4.24783468d0, 4.30174494d0, 4.35633945d0,
     & 4.41162682d0, 4.46762037d0, 4.52431965d0, 4.58173895d0,
     & 4.63988686d0, 4.69877291d0, 4.75840616d0, 4.81880093d0,
     & 4.87995768d0, 4.94189024d0, 5.00460863d0, 5.06812382d0,
     & 5.13244438d0, 5.19758654d0, 5.26355076d0, 5.33035135d0,
     & 5.39800024d0, 5.46650791d0, 5.53588486d0, 5.60614157d0,
     & 5.67729616d0, 5.74934816d0, 5.82231474d0, 5.89620686d0,
     & 5.97103739d0, 6.04681683d0, 6.12356472d0, 6.20128012d0,
     & 6.27998209d0, 6.35968304d0, 6.44039536d0, 6.52213240d0,
     & 6.60491228d0, 6.68873739d0, 6.77362537d0, 6.85959101d0,
     & 6.94664812d0, 7.03480911d0, 7.12408972d0, 7.21451092d0,
     & 7.30607176d0, 7.39879513d0, 7.49269533d0, 7.58778667d0,
     & 7.68408489d0, 7.78161287d0, 7.88037157d0, 7.98038340d0,
     & 8.08166409d0, 8.18422985d0, 8.28809834d0, 8.39328480d0,
     & 8.49981499d0, 8.60768700d0, 8.71692944d0, 8.82755852d0,
     & 8.93959141d0, 9.05304623d0, 9.16794872d0, 9.28430176d0,
     & 9.40213108d0, 9.52145576d0, 9.64229488d0, 9.76466751d0,
     & 9.88859367d0,10.01410198d0,10.14119339d0,10.26989746d0,
     &10.40023613d0,10.53222752d0,10.66589451d0,10.80126858d0,
     &10.93834972d0,11.07717133d0,11.21775436d0,11.36012173d0,
     &11.50429535d0,11.65031052d0,11.79816723d0,11.94790173d0,
     &12.09953499d0,12.25309372d0,12.40860081d0,12.56608105d0,
     &12.72557259d0,12.88707542d0,13.05062866d0,13.21625710d0,
     &13.38398838d0,13.55384827d0,13.72587585d0,13.90007496d0,
     &14.07648373d0,14.25513268d0,14.43604851d0,14.61925888d0,
     &14.80481052d0,14.99270153d0,15.18297768d0,15.37566853d0,
     &15.57080460d0,15.76841831d0,15.96853828d0,16.17121506d0,
     &16.37644768d0,16.58428574d0,16.79475975d0,17.00790787d0,
     &17.22375870d0,17.44236755d0,17.66373062d0,17.88790512d0,
     &18.11492538d0,18.34482765d0,18.57764626d0,18.81341934d0,
     &19.05220222d0,19.29399872d0,19.53886604d0,19.78683662d0,
     &20.03795815d0,20.29226303d0,20.54981613d0,20.81061935d0,
     &21.07473183d0,21.34219742d0,21.61305809d0,21.88735199d0,
     &22.16513062d0,22.44645500d0,22.73132896d0,23.01981735d0,
     &23.31196785d0,23.60782623d0,23.90743828d0,24.21087837d0,
     &24.51814270d0,24.82930946d0,25.14442444d0,25.46353912d0,
     &25.78670311d0,26.11399269d0,26.44541168d0,26.78103638d0,
     &27.12092209d0,27.46512032d0,27.81368637d0,28.16667747d0,
     &28.52417374d0,28.88618279d0,29.25278282d0,29.62404060d0,
     &30.00000572d0
     &/
c Definition of fits (4 deg polynomial) for doy=061
c A0=f(Lm) same for A1,A2,A3 and A4; to be used every where except Lm>7.5 and I> 1.
      DATA (Lm4 ( 3,I), I= 1,100) /
     & 1.10d0, 1.20d0, 1.30d0, 1.40d0, 1.50d0, 1.60d0, 1.70d0, 1.80d0,
     & 1.90d0, 2.00d0, 2.10d0, 2.20d0, 2.30d0, 2.40d0, 2.50d0, 2.60d0,
     & 2.70d0, 2.80d0, 2.90d0, 3.00d0, 3.10d0, 3.20d0, 3.30d0, 3.40d0,
     & 3.50d0, 3.60d0, 3.70d0, 3.80d0, 3.90d0, 4.00d0, 4.10d0, 4.20d0,
     & 4.30d0, 4.40d0, 4.50d0, 4.60d0, 4.70d0, 4.80d0, 4.90d0, 5.00d0,
     & 5.10d0, 5.20d0, 5.30d0, 5.40d0, 5.50d0, 5.60d0, 5.70d0, 5.80d0,
     & 5.90d0, 6.00d0, 6.10d0, 6.20d0, 6.30d0, 6.40d0, 6.50d0, 6.60d0,
     & 6.70d0, 6.80d0, 6.90d0, 7.00d0, 7.10d0, 7.20d0, 7.30d0, 7.40d0,
     & 7.50d0, 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0,
     & 8.30d0, 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0,
     & 9.10d0, 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0,
     & 9.90d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A0 ( 3,I), I= 1,100) /
     & 1.1013242294D+00, 1.2017997872D+00, 1.3019416413D+00,
     & 1.4011565582D+00, 1.5004465260D+00, 1.6006598557D+00,
     & 1.7006348685D+00, 1.8005570355D+00, 1.8989326090D+00,
     & 2.0002940906D+00, 2.0978681625D+00, 2.1987640365D+00,
     & 2.2963283351D+00, 2.3944282747D+00, 2.4909468734D+00,
     & 2.5852230309D+00, 2.6807833676D+00, 2.7725862816D+00,
     & 2.8667548538D+00, 2.9595366173D+00, 3.0534882404D+00,
     & 3.1439883780D+00, 3.2346600266D+00, 3.3258642060D+00,
     & 3.4179515313D+00, 3.5047950489D+00, 3.5905476210D+00,
     & 3.6795495811D+00, 3.7650331459D+00, 3.8497846349D+00,
     & 3.9341288207D+00, 4.0194116703D+00, 4.1022317357D+00,
     & 4.1839171406D+00, 4.2678754346D+00, 4.3526150557D+00,
     & 4.4305323403D+00, 4.5128359059D+00, 4.5939530860D+00,
     & 4.6786885250D+00, 4.7583508179D+00, 4.8377614664D+00,
     & 4.9180318589D+00, 4.9955748019D+00, 5.0776387752D+00,
     & 5.1524405632D+00, 5.2362619958D+00, 5.3177979265D+00,
     & 5.3970885767D+00, 5.4773467331D+00, 5.5574773263D+00,
     & 5.6403284648D+00, 5.7201128059D+00, 5.8037938843D+00,
     & 5.8852302315D+00, 5.9676941220D+00, 6.0523278201D+00,
     & 6.1335489019D+00, 6.2191502084D+00, 6.3036563975D+00,
     & 6.3893389033D+00, 6.4777541266D+00, 6.5642900567D+00,
     & 6.6523476110D+00, 6.7447733257D+00, 6.8331955589D+00,
     & 6.9277968261D+00, 7.0265073754D+00, 7.1224756781D+00,
     & 7.2294964224D+00, 7.3320883469D+00, 7.4500850481D+00,
     & 7.5701970013D+00, 7.7067149062D+00, 7.8505798117D+00,
     & 7.9990614658D+00, 8.1559678494D+00, 8.3009114594D+00,
     & 8.4682479594D+00, 8.6268571013D+00, 8.8035233888D+00,
     & 8.9650887017D+00,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A1 ( 3,I), I= 1,100) /
     &-2.5955017323D-05, 2.0034651125D-04, 3.8683350698D-04,
     & 3.6153166740D-04, 2.6218009337D-04, 4.3629067310D-04,
     & 4.5475714790D-04, 2.0402191372D-04, 1.5330017906D-04,
     & 3.8248802119D-04, 7.7968196561D-04, 2.9274626575D-03,
     & 5.0290420639D-03, 6.3415021243D-03, 5.7076727938D-03,
     & 7.7254629143D-03, 8.7896704572D-03, 1.0635931714D-02,
     & 1.0466433333D-02, 1.2475273657D-02, 1.2991425635D-02,
     & 1.5242901568D-02, 1.7304474090D-02, 1.6307515573D-02,
     & 1.8448180125D-02, 2.0032724371D-02, 1.9640066231D-02,
     & 2.1524260063D-02, 2.3156958930D-02, 2.5583595446D-02,
     & 2.8026162956D-02, 2.7837644267D-02, 2.9928963421D-02,
     & 3.1139540852D-02, 3.1060154740D-02, 3.2296985952D-02,
     & 3.4171043875D-02, 3.5622885792D-02, 3.5188803424D-02,
     & 3.4118196151D-02, 3.5054552652D-02, 3.5853759330D-02,
     & 3.6919095967D-02, 3.6843829587D-02, 3.8022266591D-02,
     & 3.6940445070D-02, 3.8040150075D-02, 3.7863627965D-02,
     & 3.6331541657D-02, 3.6361504645D-02, 3.4708488152D-02,
     & 3.4275040067D-02, 3.4432145622D-02, 3.2281163689D-02,
     & 3.1570512435D-02, 3.0417886803D-02, 2.9108860921D-02,
     & 2.8225574937D-02, 2.6543129092D-02, 2.2422574671D-02,
     & 2.3138966790D-02, 1.9501449125D-02, 1.7004051238D-02,
     & 1.3848806908D-02, 1.1260827863D-02, 6.0317232332D-03,
     &-1.9082853012D-03,-3.7104263637D-03,-2.0843964950D-02,
     &-1.9883175694D-02,-4.5453969716D-02,-5.2569301336D-02,
     &-7.0036133243D-02,-6.8922268946D-02,-6.9950946379D-02,
     &-6.1504708381D-02,-6.8254919995D-02,-7.9514128368D-02,
     &-7.0023591257D-02,-7.7261323637D-02,-5.4253422992D-02,
     &-2.7730756416D-02,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A2 ( 3,I), I= 1,100) /
     &-5.5407060349D-06,-4.1124135105D-06, 1.4205137018D-05,
     & 1.0381755128D-05, 9.1692680371D-06, 2.2607582927D-05,
     & 2.2293645131D-05,-6.0598803326D-07,-1.2958830199D-05,
     & 2.6219038137D-06, 3.3668471927D-05, 7.5492023656D-04,
     & 1.6196891250D-03, 1.8589300513D-03, 7.6133918409D-04,
     & 1.3944073340D-03, 1.5610998250D-03, 2.3466632223D-03,
     & 1.9115671010D-03, 2.9137419139D-03, 3.0912092166D-03,
     & 3.1493920944D-03, 3.6859104653D-03, 3.7012179473D-03,
     & 3.8465810995D-03, 4.6041851784D-03, 4.9035736815D-03,
     & 4.4436492740D-03, 5.5209999310D-03, 5.6066426937D-03,
     & 6.3174118505D-03, 6.3368217458D-03, 7.4797709980D-03,
     & 8.2116872798D-03, 7.6550880165D-03, 7.2630980132D-03,
     & 8.6460731472D-03, 8.5285920940D-03, 8.7645669533D-03,
     & 7.9739640757D-03, 8.6563741149D-03, 9.1025860369D-03,
     & 8.5103744105D-03, 9.1859580012D-03, 8.9753258403D-03,
     & 9.1812523890D-03, 9.0226243899D-03, 8.6106128320D-03,
     & 8.9529213478D-03, 8.6997355868D-03, 8.5229080318D-03,
     & 7.5705428578D-03, 7.8866831876D-03, 7.3032576340D-03,
     & 7.2904955301D-03, 6.5369265871D-03, 5.7299091580D-03,
     & 6.6234668051D-03, 5.0568250316D-03, 5.3543490360D-03,
     & 4.4717836782D-03, 3.0193760023D-03, 3.4925498924D-03,
     & 2.9090308492D-03, 1.3894536527D-03, 1.7740781422D-03,
     &-2.3031624641D-03,-1.5712203416D-03,-8.7415849161D-03,
     &-3.6574700338D-03,-1.3902726578D-02,-1.6867072176D-02,
     &-2.2298764120D-02,-2.1964447096D-02,-2.2574867567D-02,
     &-1.6897576593D-02,-2.3140181097D-02,-2.2234054669D-02,
     &-1.9885106595D-02,-2.6030655911D-02,-1.7113750049D-02,
     &-6.0451244382D-03,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A3 ( 3,I), I= 1,100) /
     & 5.5174029799D-07,-1.3632289064D-06,-2.8434993687D-06,
     &-3.3431958848D-06,-1.6261623078D-06,-4.1140514410D-06,
     &-2.5190951171D-06,-5.2758398974D-07,-1.0899920419D-06,
     &-3.3737814468D-06,-7.5960712108D-06, 9.1623038640D-05,
     & 2.2651969063D-04, 2.4016858298D-04, 6.1617587385D-06,
     & 9.0405984347D-05, 9.1394503789D-05, 2.0364852677D-04,
     & 1.2839164000D-04, 2.8023711195D-04, 3.2227596831D-04,
     & 2.5150688337D-04, 2.9446557087D-04, 3.5021360470D-04,
     & 3.2917058004D-04, 4.4686126285D-04, 5.3235001961D-04,
     & 3.5441812319D-04, 5.5915944545D-04, 4.9525497950D-04,
     & 5.8332934209D-04, 5.9930091484D-04, 7.2846245317D-04,
     & 8.9221552078D-04, 7.7905326992D-04, 6.5065823674D-04,
     & 9.1058435549D-04, 8.5666316138D-04, 9.1869903432D-04,
     & 7.5344197679D-04, 9.1461907494D-04, 9.5437874919D-04,
     & 8.2531997893D-04, 9.4772270797D-04, 8.8423326690D-04,
     & 9.3675672123D-04, 8.0832061689D-04, 8.0556527688D-04,
     & 8.3289226267D-04, 7.7241989028D-04, 8.5015290257D-04,
     & 6.3016087225D-04, 7.1628086430D-04, 6.7611389769D-04,
     & 7.2380053483D-04, 5.6251542412D-04, 4.5605735996D-04,
     & 5.8502172547D-04, 1.8856754167D-04, 5.3358623100D-04,
     & 2.1459130156D-04, 1.4146476464D-04, 2.2420372092D-04,
     & 1.2502811293D-04, 1.7069689243D-05, 2.0757691391D-04,
     &-5.2398297456D-04,-2.9776799663D-04,-1.5059869606D-03,
     &-2.2261773957D-04,-1.6874561634D-03,-2.2823543399D-03,
     &-2.8385082790D-03,-2.9023159862D-03,-2.9640575556D-03,
     &-1.8973615512D-03,-3.0958473869D-03,-2.5114386150D-03,
     &-2.4508756865D-03,-3.4100315116D-03,-2.2174309416D-03,
     &-4.5033132156D-04,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A4 ( 3,I), I= 1,100) /
     & 7.4557591451D-08,-2.4926499163D-09,-2.0909037146D-07,
     &-1.4981289389D-07,-1.3475711937D-07,-4.2173966330D-07,
     &-1.8139000272D-07,-4.5390374110D-09, 1.0522624290D-07,
     &-1.3596402390D-07,-6.0163123375D-07, 4.1438614721D-06,
     & 1.1235153228D-05, 1.1099295377D-05,-2.8935377676D-06,
     & 1.2769302672D-06, 4.1248740693D-07, 5.7052512876D-06,
     & 2.1461640518D-06, 9.1643391917D-06, 1.2158809881D-05,
     & 6.1504640134D-06, 6.6370413499D-06, 1.1619038056D-05,
     & 9.1393589132D-06, 1.5492803791D-05, 2.1435261638D-05,
     & 8.3910437630D-06, 2.0413799713D-05, 1.4382116599D-05,
     & 1.8337853956D-05, 1.9785079272D-05, 2.3036750987D-05,
     & 3.3961408351D-05, 2.8352674677D-05, 1.8845726096D-05,
     & 3.4159611581D-05, 3.0680660155D-05, 3.4137720480D-05,
     & 2.3965399132D-05, 3.4951434865D-05, 3.5031295404D-05,
     & 2.8405340326D-05, 3.3877941589D-05, 3.1055405762D-05,
     & 3.2953768040D-05, 2.1725292914D-05, 2.6048383098D-05,
     & 2.3998547852D-05, 2.0346118051D-05, 2.9047697280D-05,
     & 1.4917771367D-05, 2.1527875962D-05, 2.1764402983D-05,
     & 2.5566441738D-05, 1.5537411392D-05, 1.2011933997D-05,
     & 1.6172835333D-05,-1.1418623489D-05, 1.9196601680D-05,
     &-5.4322747395D-06,-1.3958414093D-06, 4.4753500586D-07,
     &-5.5096697311D-06,-3.9256047732D-06, 8.3014470113D-06,
     &-3.1643570369D-05,-1.8110717900D-05,-8.4787129499D-05,
     &-2.2200738013D-06,-7.1440040958D-05,-1.0906721350D-04,
     &-1.2636078763D-04,-1.3455614631D-04,-1.3595046373D-04,
     &-7.4861115613D-05,-1.4199923123D-04,-9.9372902473D-05,
     &-1.1168041627D-04,-1.5305704989D-04,-1.0166264368D-04,
     &-8.6996981744D-06,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of fits (5 deg polynomial) for doy=061
c A50=f(Lm5) same for A51,A52,A53, A54 and A55
c To be used only where Lm>7.5 and I> 1.
      DATA (Lm5 ( 3,I), I= 1,100) /
     & 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0, 8.30d0,
     & 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0, 9.10d0,
     & 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0, 9.90d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A50 ( 3,I), I= 1,100) /
     & 6.8363197438D+00, 6.9289451165D+00, 7.0236821629D+00,
     & 7.1233380116D+00, 7.2285982105D+00, 7.3342477183D+00,
     & 7.4470597953D+00, 7.5668509259D+00, 7.6927135986D+00,
     & 7.8316646454D+00, 7.9813286869D+00, 8.1358850099D+00,
     & 8.2913878773D+00, 8.4550384478D+00, 8.6164514401D+00,
     & 8.7881872542D+00, 8.9464822440D+00, 1.1767814882D+01,
     & 1.3921944758D+01, 1.8270106298D+01, 1.8213554651D+01,
     & 1.9903446004D+01, 2.2557587052D+01, 2.3668989995D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A51 ( 3,I), I= 1,100) /
     & 7.9504262553D-03, 8.8955860622D-03, 3.0294947483D-03,
     &-3.5168835157D-03,-4.7205955017D-02,-3.2676794949D-02,
     &-6.1551493353D-02,-8.7002819703D-02,-1.2726485564D-01,
     &-1.8793350617D-01,-1.8283629906D-01,-1.3941745962D-01,
     &-6.5398327392D-02,-3.2500805596D-02, 1.7934319972D-02,
     & 7.1392141536D-02, 9.3961507753D-02,-6.3021617877D+00,
     &-1.0586541466D+01,-2.0367455744D+01,-1.8891373813D+01,
     &-2.1523303443D+01,-2.5862081575D+01,-2.6304626583D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A52 ( 3,I), I= 1,100) /
     &-3.5006126953D-03,-2.3063521093D-02, 6.9120881707D-04,
     &-2.0039835576D-02, 6.8277061459D-02,-1.2579784540D-02,
     & 5.3284395883D-03, 1.0386289912D-02, 3.6824109383D-02,
     & 8.2684749967D-02,-4.8468863714D-02,-2.7166717905D-01,
     &-5.0060730803D-01,-6.1824507401D-01,-7.0587493859D-01,
     &-8.1772387618D-01,-7.4984862027D-01, 5.0545207378D+00,
     & 8.5970371282D+00, 1.7622503856D+01, 1.5503349181D+01,
     & 1.7230759985D+01, 2.0148658735D+01, 1.9255741147D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A53 ( 3,I), I= 1,100) /
     & 1.2543797411D-02, 3.5906302235D-02,-5.1559477064D-03,
     & 2.2290639114D-02,-6.6424453863D-02, 1.5026522889D-02,
     & 5.7986614879D-03, 4.3948557994D-04,-1.3827005749D-02,
     &-4.9646108431D-02, 6.8654936160D-02, 2.6734120272D-01,
     & 4.2911645131D-01, 4.8722110248D-01, 4.8382872302D-01,
     & 5.1168353610D-01, 3.5572555433D-01,-2.1716622365D+00,
     &-3.6048691400D+00,-7.7502228509D+00,-6.5316207827D+00,
     &-7.0903351870D+00,-8.0580185780D+00,-7.2035976766D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A54 ( 3,I), I= 1,100) /
     &-9.3897997909D-03,-2.0709066346D-02, 8.2963795899D-04,
     &-1.1954170060D-02, 2.4434185940D-02,-9.3521428955D-03,
     &-7.3614377847D-03,-4.0833356729D-03,-1.3548938460D-03,
     & 1.4453882831D-02,-2.7185445998D-02,-9.8872619705D-02,
     &-1.4669670881D-01,-1.5573086961D-01,-1.3385061844D-01,
     &-1.2837000441D-01,-5.2928198601D-02, 4.7227056463D-01,
     & 7.5131127248D-01, 1.6936871629D+00, 1.3771239232D+00,
     & 1.4639508705D+00, 1.6203565348D+00, 1.3485523327D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A55 ( 3,I), I= 1,100) /
     & 1.9121025084D-03, 3.7332050436D-03, 1.7213974398D-04,
     & 2.1420079873D-03,-2.9954179796D-03, 1.9340692060D-03,
     & 1.8488584212D-03, 1.2907394016D-03, 1.3112032919D-03,
     &-1.2858823412D-03, 3.9770635077D-03, 1.3188898585D-02,
     & 1.8398337462D-02, 1.8552463821D-02, 1.3815852121D-02,
     & 1.2001111383D-02, 1.0275031403D-03,-4.0528561382D-02,
     &-6.1163365192D-02,-1.4581338983D-01,-1.1489924162D-01,
     &-1.1990049597D-01,-1.2966491665D-01,-9.9736657578D-02,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of Loss cone as Lmax=f(Imax) for doy=091
      DATA (Lmax ( 4,I), I= 1, 2100) /
     & 1.0853d0, 1.0863d0, 1.0874d0, 1.0883d0, 1.0893d0, 1.0903d0,
     & 1.0913d0, 1.0923d0, 1.0933d0, 1.0943d0, 1.0953d0, 1.0963d0,
     & 1.0973d0, 1.0983d0, 1.0993d0, 1.1003d0, 1.1013d0, 1.1023d0,
     & 1.1033d0, 1.1043d0, 1.1053d0, 1.1063d0, 1.1074d0, 1.1084d0,
     & 1.1094d0, 1.1104d0, 1.1114d0, 1.1125d0, 1.1135d0, 1.1145d0,
     & 1.1155d0, 1.1165d0, 1.1176d0, 1.1186d0, 1.1196d0, 1.1206d0,
     & 1.1217d0, 1.1227d0, 1.1237d0, 1.1247d0, 1.1258d0, 1.1268d0,
     & 1.1278d0, 1.1288d0, 1.1299d0, 1.1309d0, 1.1319d0, 1.1329d0,
     & 1.1340d0, 1.1350d0, 1.1360d0, 1.1370d0, 1.1381d0, 1.1391d0,
     & 1.1401d0, 1.1412d0, 1.1422d0, 1.1432d0, 1.1442d0, 1.1453d0,
     & 1.1463d0, 1.1473d0, 1.1483d0, 1.1494d0, 1.1504d0, 1.1514d0,
     & 1.1525d0, 1.1535d0, 1.1545d0, 1.1555d0, 1.1566d0, 1.1576d0,
     & 1.1586d0, 1.1597d0, 1.1607d0, 1.1617d0, 1.1627d0, 1.1638d0,
     & 1.1648d0, 1.1658d0, 1.1668d0, 1.1679d0, 1.1689d0, 1.1699d0,
     & 1.1709d0, 1.1720d0, 1.1730d0, 1.1740d0, 1.1750d0, 1.1761d0,
     & 1.1771d0, 1.1781d0, 1.1792d0, 1.1802d0, 1.1812d0, 1.1822d0,
     & 1.1833d0, 1.1843d0, 1.1853d0, 1.1864d0, 1.1874d0, 1.1884d0,
     & 1.1894d0, 1.1904d0, 1.1915d0, 1.1925d0, 1.1935d0, 1.1946d0,
     & 1.1956d0, 1.1966d0, 1.1976d0, 1.1987d0, 1.1997d0, 1.2007d0,
     & 1.2017d0, 1.2028d0, 1.2038d0, 1.2048d0, 1.2058d0, 1.2069d0,
     & 1.2079d0, 1.2089d0, 1.2099d0, 1.2110d0, 1.2120d0, 1.2130d0,
     & 1.2140d0, 1.2151d0, 1.2161d0, 1.2171d0, 1.2181d0, 1.2191d0,
     & 1.2202d0, 1.2212d0, 1.2222d0, 1.2233d0, 1.2243d0, 1.2253d0,
     & 1.2263d0, 1.2273d0, 1.2284d0, 1.2294d0, 1.2304d0, 1.2315d0,
     & 1.2325d0, 1.2335d0, 1.2345d0, 1.2355d0, 1.2366d0, 1.2376d0,
     & 1.2386d0, 1.2396d0, 1.2407d0, 1.2417d0, 1.2427d0, 1.2437d0,
     & 1.2447d0, 1.2458d0, 1.2468d0, 1.2478d0, 1.2488d0, 1.2499d0,
     & 1.2509d0, 1.2519d0, 1.2529d0, 1.2539d0, 1.2550d0, 1.2560d0,
     & 1.2570d0, 1.2581d0, 1.2591d0, 1.2601d0, 1.2611d0, 1.2621d0,
     & 1.2631d0, 1.2642d0, 1.2652d0, 1.2662d0, 1.2672d0, 1.2683d0,
     & 1.2693d0, 1.2703d0, 1.2713d0, 1.2723d0, 1.2734d0, 1.2744d0,
     & 1.2754d0, 1.2764d0, 1.2774d0, 1.2785d0, 1.2795d0, 1.2805d0,
     & 1.2815d0, 1.2825d0, 1.2836d0, 1.2846d0, 1.2856d0, 1.2866d0,
     & 1.2877d0, 1.2887d0, 1.2897d0, 1.2907d0, 1.2917d0, 1.2928d0,
     & 1.2938d0, 1.2948d0, 1.2958d0, 1.2968d0, 1.2978d0, 1.2989d0,
     & 1.2999d0, 1.3009d0, 1.3019d0, 1.3029d0, 1.3040d0, 1.3050d0,
     & 1.3060d0, 1.3070d0, 1.3080d0, 1.3091d0, 1.3101d0, 1.3111d0,
     & 1.3121d0, 1.3131d0, 1.3141d0, 1.3152d0, 1.3162d0, 1.3172d0,
     & 1.3182d0, 1.3192d0, 1.3203d0, 1.3213d0, 1.3223d0, 1.3233d0,
     & 1.3243d0, 1.3253d0, 1.3264d0, 1.3274d0, 1.3284d0, 1.3294d0,
     & 1.3304d0, 1.3314d0, 1.3325d0, 1.3335d0, 1.3345d0, 1.3355d0,
     & 1.3365d0, 1.3376d0, 1.3386d0, 1.3396d0, 1.3406d0, 1.3416d0,
     & 1.3426d0, 1.3437d0, 1.3447d0, 1.3457d0, 1.3467d0, 1.3477d0,
     & 1.3487d0, 1.3498d0, 1.3508d0, 1.3518d0, 1.3528d0, 1.3538d0,
     & 1.3548d0, 1.3558d0, 1.3569d0, 1.3579d0, 1.3589d0, 1.3599d0,
     & 1.3609d0, 1.3620d0, 1.3630d0, 1.3640d0, 1.3650d0, 1.3660d0,
     & 1.3670d0, 1.3680d0, 1.3690d0, 1.3701d0, 1.3711d0, 1.3721d0,
     & 1.3731d0, 1.3741d0, 1.3752d0, 1.3762d0, 1.3772d0, 1.3782d0,
     & 1.3792d0, 1.3802d0, 1.3812d0, 1.3822d0, 1.3833d0, 1.3843d0,
     & 1.3853d0, 1.3863d0, 1.3873d0, 1.3884d0, 1.3894d0, 1.3904d0,
     & 1.3914d0, 1.3924d0, 1.3934d0, 1.3944d0, 1.3954d0, 1.3964d0,
     & 1.3975d0, 1.3985d0, 1.3995d0, 1.4005d0, 1.4015d0, 1.4026d0,
     & 1.4036d0, 1.4046d0, 1.4056d0, 1.4066d0, 1.4076d0, 1.4086d0,
     & 1.4096d0, 1.4106d0, 1.4116d0, 1.4127d0, 1.4137d0, 1.4147d0,
     & 1.4157d0, 1.4168d0, 1.4178d0, 1.4188d0, 1.4198d0, 1.4208d0,
     & 1.4218d0, 1.4228d0, 1.4238d0, 1.4248d0, 1.4258d0, 1.4269d0,
     & 1.4279d0, 1.4289d0, 1.4299d0, 1.4310d0, 1.4320d0, 1.4330d0,
     & 1.4339d0, 1.4349d0, 1.4359d0, 1.4370d0, 1.4380d0, 1.4390d0,
     & 1.4400d0, 1.4410d0, 1.4421d0, 1.4431d0, 1.4441d0, 1.4451d0,
     & 1.4461d0, 1.4471d0, 1.4481d0, 1.4491d0, 1.4501d0, 1.4511d0,
     & 1.4521d0, 1.4532d0, 1.4542d0, 1.4552d0, 1.4562d0, 1.4572d0,
     & 1.4583d0, 1.4593d0, 1.4603d0, 1.4613d0, 1.4623d0, 1.4633d0,
     & 1.4643d0, 1.4653d0, 1.4663d0, 1.4673d0, 1.4683d0, 1.4693d0,
     & 1.4704d0, 1.4714d0, 1.4724d0, 1.4734d0, 1.4745d0, 1.4755d0,
     & 1.4765d0, 1.4775d0, 1.4785d0, 1.4794d0, 1.4804d0, 1.4814d0,
     & 1.4824d0, 1.4835d0, 1.4845d0, 1.4855d0, 1.4865d0, 1.4875d0,
     & 1.4886d0, 1.4896d0, 1.4906d0, 1.4916d0, 1.4926d0, 1.4936d0,
     & 1.4946d0, 1.4956d0, 1.4966d0, 1.4976d0, 1.4986d0, 1.4996d0,
     & 1.5006d0, 1.5016d0, 1.5026d0, 1.5037d0, 1.5047d0, 1.5057d0,
     & 1.5068d0, 1.5078d0, 1.5088d0, 1.5098d0, 1.5108d0, 1.5118d0,
     & 1.5128d0, 1.5137d0, 1.5147d0, 1.5157d0, 1.5167d0, 1.5177d0,
     & 1.5188d0, 1.5198d0, 1.5208d0, 1.5218d0, 1.5229d0, 1.5239d0,
     & 1.5249d0, 1.5260d0, 1.5270d0, 1.5279d0, 1.5289d0, 1.5299d0,
     & 1.5309d0, 1.5319d0, 1.5329d0, 1.5339d0, 1.5349d0, 1.5359d0,
     & 1.5369d0, 1.5379d0, 1.5390d0, 1.5400d0, 1.5410d0, 1.5421d0,
     & 1.5431d0, 1.5441d0, 1.5451d0, 1.5461d0, 1.5471d0, 1.5481d0,
     & 1.5490d0, 1.5500d0, 1.5510d0, 1.5520d0, 1.5530d0, 1.5540d0,
     & 1.5551d0, 1.5561d0, 1.5571d0, 1.5581d0, 1.5592d0, 1.5602d0,
     & 1.5612d0, 1.5622d0, 1.5632d0, 1.5642d0, 1.5652d0, 1.5662d0,
     & 1.5672d0, 1.5682d0, 1.5691d0, 1.5701d0, 1.5711d0, 1.5722d0,
     & 1.5732d0, 1.5742d0, 1.5752d0, 1.5763d0, 1.5773d0, 1.5783d0,
     & 1.5793d0, 1.5804d0, 1.5814d0, 1.5824d0, 1.5834d0, 1.5843d0,
     & 1.5853d0, 1.5863d0, 1.5873d0, 1.5883d0, 1.5893d0, 1.5903d0,
     & 1.5913d0, 1.5923d0, 1.5933d0, 1.5944d0, 1.5954d0, 1.5964d0,
     & 1.5974d0, 1.5985d0, 1.5995d0, 1.6005d0, 1.6015d0, 1.6025d0,
     & 1.6035d0, 1.6045d0, 1.6055d0, 1.6064d0, 1.6074d0, 1.6084d0,
     & 1.6094d0, 1.6104d0, 1.6114d0, 1.6124d0, 1.6135d0, 1.6145d0,
     & 1.6155d0, 1.6165d0, 1.6176d0, 1.6186d0, 1.6196d0, 1.6206d0,
     & 1.6216d0, 1.6226d0, 1.6236d0, 1.6246d0, 1.6256d0, 1.6266d0,
     & 1.6275d0, 1.6285d0, 1.6295d0, 1.6305d0, 1.6315d0, 1.6325d0,
     & 1.6336d0, 1.6346d0, 1.6356d0, 1.6366d0, 1.6377d0, 1.6387d0,
     & 1.6397d0, 1.6408d0, 1.6418d0, 1.6427d0, 1.6437d0, 1.6447d0,
     & 1.6457d0, 1.6467d0, 1.6477d0, 1.6486d0, 1.6496d0, 1.6506d0,
     & 1.6516d0, 1.6526d0, 1.6536d0, 1.6547d0, 1.6557d0, 1.6567d0,
     & 1.6578d0, 1.6588d0, 1.6598d0, 1.6608d0, 1.6619d0, 1.6629d0,
     & 1.6639d0, 1.6648d0, 1.6658d0, 1.6668d0, 1.6678d0, 1.6688d0,
     & 1.6697d0, 1.6707d0, 1.6717d0, 1.6727d0, 1.6737d0, 1.6747d0,
     & 1.6757d0, 1.6768d0, 1.6778d0, 1.6788d0, 1.6799d0, 1.6809d0,
     & 1.6819d0, 1.6830d0, 1.6840d0, 1.6850d0, 1.6860d0, 1.6870d0,
     & 1.6879d0, 1.6889d0, 1.6899d0, 1.6909d0, 1.6919d0, 1.6928d0,
     & 1.6938d0, 1.6948d0, 1.6958d0, 1.6968d0, 1.6978d0, 1.6989d0,
     & 1.6999d0, 1.7009d0, 1.7020d0, 1.7030d0, 1.7040d0, 1.7051d0,
     & 1.7061d0, 1.7071d0, 1.7081d0, 1.7091d0, 1.7101d0, 1.7110d0,
     & 1.7120d0, 1.7130d0, 1.7140d0, 1.7150d0, 1.7159d0, 1.7169d0,
     & 1.7179d0, 1.7189d0, 1.7199d0, 1.7209d0, 1.7219d0, 1.7229d0,
     & 1.7240d0, 1.7250d0, 1.7260d0, 1.7271d0, 1.7281d0, 1.7292d0,
     & 1.7302d0, 1.7312d0, 1.7322d0, 1.7332d0, 1.7341d0, 1.7351d0,
     & 1.7361d0, 1.7371d0, 1.7381d0, 1.7390d0, 1.7400d0, 1.7410d0,
     & 1.7420d0, 1.7429d0, 1.7440d0, 1.7450d0, 1.7460d0, 1.7470d0,
     & 1.7480d0, 1.7491d0, 1.7501d0, 1.7511d0, 1.7522d0, 1.7532d0,
     & 1.7542d0, 1.7552d0, 1.7562d0, 1.7572d0, 1.7582d0, 1.7592d0,
     & 1.7602d0, 1.7612d0, 1.7622d0, 1.7631d0, 1.7641d0, 1.7651d0,
     & 1.7661d0, 1.7670d0, 1.7680d0, 1.7690d0, 1.7700d0, 1.7711d0,
     & 1.7721d0, 1.7731d0, 1.7741d0, 1.7752d0, 1.7762d0, 1.7772d0,
     & 1.7783d0, 1.7793d0, 1.7803d0, 1.7813d0, 1.7823d0, 1.7833d0,
     & 1.7843d0, 1.7853d0, 1.7863d0, 1.7872d0, 1.7882d0, 1.7892d0,
     & 1.7902d0, 1.7911d0, 1.7921d0, 1.7931d0, 1.7941d0, 1.7951d0,
     & 1.7961d0, 1.7971d0, 1.7982d0, 1.7992d0, 1.8002d0, 1.8013d0,
     & 1.8023d0, 1.8033d0, 1.8044d0, 1.8054d0, 1.8064d0, 1.8074d0,
     & 1.8084d0, 1.8094d0, 1.8104d0, 1.8113d0, 1.8123d0, 1.8133d0,
     & 1.8143d0, 1.8153d0, 1.8162d0, 1.8172d0, 1.8182d0, 1.8192d0,
     & 1.8202d0, 1.8212d0, 1.8222d0, 1.8232d0, 1.8242d0, 1.8253d0,
     & 1.8263d0, 1.8273d0, 1.8284d0, 1.8294d0, 1.8304d0, 1.8315d0,
     & 1.8325d0, 1.8335d0, 1.8345d0, 1.8355d0, 1.8364d0, 1.8374d0,
     & 1.8384d0, 1.8394d0, 1.8404d0, 1.8414d0, 1.8423d0, 1.8433d0,
     & 1.8443d0, 1.8453d0, 1.8462d0, 1.8472d0, 1.8482d0, 1.8492d0,
     & 1.8503d0, 1.8513d0, 1.8523d0, 1.8534d0, 1.8544d0, 1.8554d0,
     & 1.8565d0, 1.8575d0, 1.8585d0, 1.8595d0, 1.8605d0, 1.8615d0,
     & 1.8625d0, 1.8635d0, 1.8645d0, 1.8655d0, 1.8665d0, 1.8675d0,
     & 1.8684d0, 1.8694d0, 1.8704d0, 1.8714d0, 1.8723d0, 1.8733d0,
     & 1.8743d0, 1.8752d0, 1.8762d0, 1.8773d0, 1.8783d0, 1.8793d0,
     & 1.8803d0, 1.8814d0, 1.8824d0, 1.8834d0, 1.8845d0, 1.8855d0,
     & 1.8866d0, 1.8876d0, 1.8886d0, 1.8896d0, 1.8906d0, 1.8916d0,
     & 1.8926d0, 1.8936d0, 1.8945d0, 1.8955d0, 1.8965d0, 1.8975d0,
     & 1.8985d0, 1.8994d0, 1.9004d0, 1.9014d0, 1.9023d0, 1.9033d0,
     & 1.9043d0, 1.9053d0, 1.9063d0, 1.9073d0, 1.9083d0, 1.9094d0,
     & 1.9104d0, 1.9114d0, 1.9125d0, 1.9135d0, 1.9145d0, 1.9156d0,
     & 1.9166d0, 1.9176d0, 1.9186d0, 1.9196d0, 1.9206d0, 1.9216d0,
     & 1.9226d0, 1.9236d0, 1.9246d0, 1.9256d0, 1.9266d0, 1.9275d0,
     & 1.9285d0, 1.9295d0, 1.9305d0, 1.9314d0, 1.9324d0, 1.9334d0,
     & 1.9344d0, 1.9353d0, 1.9363d0, 1.9373d0, 1.9384d0, 1.9394d0,
     & 1.9404d0, 1.9415d0, 1.9425d0, 1.9435d0, 1.9446d0, 1.9456d0,
     & 1.9467d0, 1.9477d0, 1.9487d0, 1.9497d0, 1.9507d0, 1.9517d0,
     & 1.9527d0, 1.9537d0, 1.9546d0, 1.9556d0, 1.9566d0, 1.9576d0,
     & 1.9586d0, 1.9595d0, 1.9605d0, 1.9615d0, 1.9625d0, 1.9635d0,
     & 1.9644d0, 1.9654d0, 1.9664d0, 1.9674d0, 1.9684d0, 1.9694d0,
     & 1.9704d0, 1.9715d0, 1.9725d0, 1.9735d0, 1.9746d0, 1.9756d0,
     & 1.9767d0, 1.9777d0, 1.9787d0, 1.9797d0, 1.9807d0, 1.9817d0,
     & 1.9827d0, 1.9837d0, 1.9847d0, 1.9857d0, 1.9867d0, 1.9877d0,
     & 1.9886d0, 1.9896d0, 1.9906d0, 1.9916d0, 1.9926d0, 1.9935d0,
     & 1.9945d0, 1.9955d0, 1.9964d0, 1.9974d0, 1.9984d0, 1.9994d0,
     & 2.0004d0, 2.0015d0, 2.0025d0, 2.0035d0, 2.0046d0, 2.0056d0,
     & 2.0066d0, 2.0077d0, 2.0087d0, 2.0097d0, 2.0108d0, 2.0118d0,
     & 2.0128d0, 2.0138d0, 2.0147d0, 2.0157d0, 2.0167d0, 2.0177d0,
     & 2.0187d0, 2.0197d0, 2.0207d0, 2.0216d0, 2.0226d0, 2.0236d0,
     & 2.0246d0, 2.0255d0, 2.0265d0, 2.0275d0, 2.0285d0, 2.0294d0,
     & 2.0304d0, 2.0314d0, 2.0325d0, 2.0335d0, 2.0345d0, 2.0355d0,
     & 2.0366d0, 2.0376d0, 2.0387d0, 2.0397d0, 2.0408d0, 2.0418d0,
     & 2.0428d0, 2.0438d0, 2.0448d0, 2.0458d0, 2.0468d0, 2.0478d0,
     & 2.0488d0, 2.0498d0, 2.0507d0, 2.0517d0, 2.0527d0, 2.0537d0,
     & 2.0547d0, 2.0557d0, 2.0566d0, 2.0576d0, 2.0586d0, 2.0596d0,
     & 2.0605d0, 2.0615d0, 2.0625d0, 2.0635d0, 2.0644d0, 2.0654d0,
     & 2.0664d0, 2.0674d0, 2.0685d0, 2.0695d0, 2.0705d0, 2.0716d0,
     & 2.0726d0, 2.0736d0, 2.0747d0, 2.0757d0, 2.0768d0, 2.0778d0,
     & 2.0788d0, 2.0798d0, 2.0808d0, 2.0818d0, 2.0828d0, 2.0838d0,
     & 2.0847d0, 2.0857d0, 2.0867d0, 2.0877d0, 2.0887d0, 2.0896d0,
     & 2.0906d0, 2.0916d0, 2.0926d0, 2.0936d0, 2.0946d0, 2.0955d0,
     & 2.0965d0, 2.0975d0, 2.0984d0, 2.0994d0, 2.1004d0, 2.1014d0,
     & 2.1024d0, 2.1034d0, 2.1044d0, 2.1054d0, 2.1064d0, 2.1075d0,
     & 2.1085d0, 2.1096d0, 2.1106d0, 2.1116d0, 2.1127d0, 2.1137d0,
     & 2.1147d0, 2.1157d0, 2.1167d0, 2.1178d0, 2.1188d0, 2.1198d0,
     & 2.1208d0, 2.1218d0, 2.1228d0, 2.1238d0, 2.1248d0, 2.1258d0,
     & 2.1267d0, 2.1277d0, 2.1286d0, 2.1296d0, 2.1306d0, 2.1315d0,
     & 2.1325d0, 2.1335d0, 2.1345d0, 2.1354d0, 2.1364d0, 2.1374d0,
     & 2.1384d0, 2.1394d0, 2.1405d0, 2.1415d0, 2.1425d0, 2.1435d0,
     & 2.1446d0, 2.1456d0, 2.1466d0, 2.1477d0, 2.1487d0, 2.1497d0,
     & 2.1507d0, 2.1517d0, 2.1527d0, 2.1537d0, 2.1547d0, 2.1557d0,
     & 2.1567d0, 2.1578d0, 2.1588d0, 2.1599d0, 2.1609d0, 2.1619d0,
     & 2.1629d0, 2.1639d0, 2.1648d0, 2.1658d0, 2.1667d0, 2.1677d0,
     & 2.1686d0, 2.1695d0, 2.1703d0, 2.1714d0, 2.1724d0, 2.1734d0,
     & 2.1745d0, 2.1755d0, 2.1765d0, 2.1775d0, 2.1786d0, 2.1796d0,
     & 2.1807d0, 2.1817d0, 2.1827d0, 2.1837d0, 2.1847d0, 2.1857d0,
     & 2.1867d0, 2.1877d0, 2.1887d0, 2.1898d0, 2.1909d0, 2.1919d0,
     & 2.1930d0, 2.1941d0, 2.1951d0, 2.1960d0, 2.1970d0, 2.1980d0,
     & 2.1989d0, 2.1998d0, 2.2008d0, 2.2017d0, 2.2026d0, 2.2036d0,
     & 2.2045d0, 2.2056d0, 2.2066d0, 2.2077d0, 2.2088d0, 2.2097d0,
     & 2.2107d0, 2.2116d0, 2.2126d0, 2.2135d0, 2.2145d0, 2.2155d0,
     & 2.2164d0, 2.2174d0, 2.2183d0, 2.2193d0, 2.2204d0, 2.2214d0,
     & 2.2225d0, 2.2235d0, 2.2246d0, 2.2256d0, 2.2265d0, 2.2275d0,
     & 2.2285d0, 2.2295d0, 2.2306d0, 2.2316d0, 2.2326d0, 2.2336d0,
     & 2.2347d0, 2.2356d0, 2.2366d0, 2.2377d0, 2.2387d0, 2.2397d0,
     & 2.2407d0, 2.2417d0, 2.2428d0, 2.2438d0, 2.2449d0, 2.2459d0,
     & 2.2469d0, 2.2479d0, 2.2489d0, 2.2498d0, 2.2507d0, 2.2517d0,
     & 2.2526d0, 2.2534d0, 2.2544d0, 2.2553d0, 2.2562d0, 2.2572d0,
     & 2.2582d0, 2.2592d0, 2.2603d0, 2.2613d0, 2.2624d0, 2.2635d0,
     & 2.2645d0, 2.2655d0, 2.2666d0, 2.2675d0, 2.2685d0, 2.2695d0,
     & 2.2705d0, 2.2722d0, 2.2749d0, 2.2783d0, 2.2825d0, 2.2875d0,
     & 2.2934d0, 2.3001d0, 2.3076d0, 2.3159d0, 2.3250d0, 2.3350d0,
     & 2.3449d0, 2.3549d0, 2.3649d0, 2.3748d0, 2.3848d0, 2.3947d0,
     & 2.4046d0, 2.4146d0, 2.4245d0, 2.4345d0, 2.4444d0, 2.4543d0,
     & 2.4641d0, 2.4740d0, 2.4839d0, 2.4938d0, 2.5036d0, 2.5136d0,
     & 2.5234d0, 2.5333d0, 2.5431d0, 2.5531d0, 2.5631d0, 2.5729d0,
     & 2.5828d0, 2.5927d0, 2.6026d0, 2.6126d0, 2.6224d0, 2.6323d0,
     & 2.6422d0, 2.6522d0, 2.6621d0, 2.6720d0, 2.6819d0, 2.6917d0,
     & 2.7017d0, 2.7116d0, 2.7215d0, 2.7314d0, 2.7413d0, 2.7512d0,
     & 2.7610d0, 2.7709d0, 2.7808d0, 2.7907d0, 2.8006d0, 2.8104d0,
     & 2.8203d0, 2.8302d0, 2.8401d0, 2.8500d0, 2.8598d0, 2.8697d0,
     & 2.8796d0, 2.8895d0, 2.8994d0, 2.9094d0, 2.9192d0, 2.9290d0,
     & 2.9390d0, 2.9489d0, 2.9588d0, 2.9688d0, 2.9786d0, 2.9884d0,
     & 2.9983d0, 3.0082d0, 3.0181d0, 3.0280d0, 3.0379d0, 3.0478d0,
     & 3.0577d0, 3.0676d0, 3.0774d0, 3.0873d0, 3.0972d0, 3.1070d0,
     & 3.1168d0, 3.1267d0, 3.1366d0, 3.1464d0, 3.1563d0, 3.1661d0,
     & 3.1760d0, 3.1859d0, 3.1958d0, 3.2057d0, 3.2157d0, 3.2255d0,
     & 3.2354d0, 3.2453d0, 3.2551d0, 3.2650d0, 3.2750d0, 3.2848d0,
     & 3.2946d0, 3.3045d0, 3.3143d0, 3.3242d0, 3.3341d0, 3.3439d0,
     & 3.3538d0, 3.3637d0, 3.3735d0, 3.3832d0, 3.3931d0, 3.4030d0,
     & 3.4129d0, 3.4228d0, 3.4326d0, 3.4424d0, 3.4523d0, 3.4622d0,
     & 3.4721d0, 3.4820d0, 3.4920d0, 3.5018d0, 3.5117d0, 3.5215d0,
     & 3.5314d0, 3.5413d0, 3.5512d0, 3.5610d0, 3.5708d0, 3.5807d0,
     & 3.5905d0, 3.6003d0, 3.6101d0, 3.6199d0, 3.6297d0, 3.6395d0,
     & 3.6494d0, 3.6592d0, 3.6691d0, 3.6789d0, 3.6887d0, 3.6986d0,
     & 3.7084d0, 3.7183d0, 3.7282d0, 3.7382d0, 3.7481d0, 3.7580d0,
     & 3.7678d0, 3.7776d0, 3.7875d0, 3.7974d0, 3.8072d0, 3.8172d0,
     & 3.8270d0, 3.8368d0, 3.8466d0, 3.8564d0, 3.8662d0, 3.8760d0,
     & 3.8860d0, 3.8959d0, 3.9058d0, 3.9156d0, 3.9255d0, 3.9354d0,
     & 3.9453d0, 3.9551d0, 3.9649d0, 3.9749d0, 3.9848d0, 3.9946d0,
     & 4.0045d0, 4.0143d0, 4.0241d0, 4.0340d0, 4.0438d0, 4.0536d0,
     & 4.0635d0, 4.0734d0, 4.0833d0, 4.0931d0, 4.1030d0, 4.1129d0,
     & 4.1227d0, 4.1326d0, 4.1424d0, 4.1522d0, 4.1621d0, 4.1721d0,
     & 4.1819d0, 4.1918d0, 4.2017d0, 4.2116d0, 4.2214d0, 4.2312d0,
     & 4.2411d0, 4.2509d0, 4.2608d0, 4.2707d0, 4.2804d0, 4.2903d0,
     & 4.3001d0, 4.3100d0, 4.3200d0, 4.3298d0, 4.3396d0, 4.3494d0,
     & 4.3594d0, 4.3694d0, 4.3794d0, 4.3894d0, 4.3994d0, 4.4093d0,
     & 4.4191d0, 4.4290d0, 4.4390d0, 4.4490d0, 4.4589d0, 4.4688d0,
     & 4.4786d0, 4.4885d0, 4.4984d0, 4.5082d0, 4.5182d0, 4.5281d0,
     & 4.5380d0, 4.5479d0, 4.5579d0, 4.5677d0, 4.5777d0, 4.5877d0,
     & 4.5975d0, 4.6074d0, 4.6173d0, 4.6273d0, 4.6372d0, 4.6471d0,
     & 4.6570d0, 4.6669d0, 4.6768d0, 4.6868d0, 4.6967d0, 4.7067d0,
     & 4.7167d0, 4.7265d0, 4.7365d0, 4.7464d0, 4.7562d0, 4.7662d0,
     & 4.7762d0, 4.7862d0, 4.7962d0, 4.8061d0, 4.8160d0, 4.8259d0,
     & 4.8358d0, 4.8456d0, 4.8554d0, 4.8653d0, 4.8753d0, 4.8853d0,
     & 4.8953d0, 4.9053d0, 4.9153d0, 4.9254d0, 4.9355d0, 4.9456d0,
     & 4.9556d0, 4.9656d0, 4.9756d0, 4.9855d0, 4.9954d0, 5.0053d0,
     & 5.0153d0, 5.0253d0, 5.0353d0, 5.0452d0, 5.0552d0, 5.0653d0,
     & 5.0754d0, 5.0854d0, 5.0954d0, 5.1055d0, 5.1156d0, 5.1255d0,
     & 5.1355d0, 5.1456d0, 5.1556d0, 5.1657d0, 5.1757d0, 5.1858d0,
     & 5.1959d0, 5.2061d0, 5.2161d0, 5.2262d0, 5.2363d0, 5.2462d0,
     & 5.2562d0, 5.2663d0, 5.2762d0, 5.2863d0, 5.2964d0, 5.3064d0,
     & 5.3165d0, 5.3266d0, 5.3367d0, 5.3469d0, 5.3570d0, 5.3670d0,
     & 5.3771d0, 5.3871d0, 5.3972d0, 5.4071d0, 5.4172d0, 5.4273d0,
     & 5.4374d0, 5.4474d0, 5.4577d0, 5.4679d0, 5.4781d0, 5.4883d0,
     & 5.4985d0, 5.5088d0, 5.5190d0, 5.5290d0, 5.5391d0, 5.5492d0,
     & 5.5593d0, 5.5693d0, 5.5793d0, 5.5894d0, 5.5994d0, 5.6095d0,
     & 5.6197d0, 5.6299d0, 5.6402d0, 5.6505d0, 5.6608d0, 5.6711d0,
     & 5.6814d0, 5.6917d0, 5.7019d0, 5.7121d0, 5.7223d0, 5.7324d0,
     & 5.7426d0, 5.7528d0, 5.7630d0, 5.7733d0, 5.7835d0, 5.7939d0,
     & 5.8042d0, 5.8145d0, 5.8249d0, 5.8351d0, 5.8454d0, 5.8556d0,
     & 5.8659d0, 5.8760d0, 5.8863d0, 5.8965d0, 5.9067d0, 5.9168d0,
     & 5.9271d0, 5.9374d0, 5.9479d0, 5.9583d0, 5.9688d0, 5.9791d0,
     & 5.9896d0, 5.9999d0, 6.0103d0, 6.0206d0, 6.0310d0, 6.0412d0,
     & 6.0516d0, 6.0618d0, 6.0721d0, 6.0823d0, 6.0925d0, 6.1028d0,
     & 6.1129d0, 6.1231d0, 6.1335d0, 6.1438d0, 6.1542d0, 6.1646d0,
     & 6.1749d0, 6.1854d0, 6.1960d0, 6.2066d0, 6.2170d0, 6.2276d0,
     & 6.2383d0, 6.2487d0, 6.2591d0, 6.2696d0, 6.2800d0, 6.2906d0,
     & 6.3010d0, 6.3114d0, 6.3218d0, 6.3322d0, 6.3427d0, 6.3532d0,
     & 6.3639d0, 6.3746d0, 6.3853d0, 6.3958d0, 6.4064d0, 6.4169d0,
     & 6.4273d0, 6.4379d0, 6.4487d0, 6.4592d0, 6.4697d0, 6.4801d0,
     & 6.4905d0, 6.5008d0, 6.5112d0, 6.5217d0, 6.5323d0, 6.5429d0,
     & 6.5534d0, 6.5637d0, 6.5741d0, 6.5846d0, 6.5952d0, 6.6058d0,
     & 6.6164d0, 6.6270d0, 6.6376d0, 6.6481d0, 6.6589d0, 6.6697d0,
     & 6.6805d0, 6.6914d0, 6.7023d0, 6.7131d0, 6.7240d0, 6.7349d0,
     & 6.7458d0, 6.7566d0, 6.7675d0, 6.7782d0, 6.7888d0, 6.7996d0,
     & 6.8102d0, 6.8209d0, 6.8314d0, 6.8420d0, 6.8528d0, 6.8634d0,
     & 6.8740d0, 6.8846d0, 6.8952d0, 6.9059d0, 6.9165d0, 6.9273d0,
     & 6.9380d0, 6.9489d0, 6.9599d0, 6.9707d0, 6.9817d0, 6.9928d0,
     & 7.0040d0, 7.0151d0, 7.0262d0, 7.0373d0, 7.0484d0, 7.0595d0,
     & 7.0704d0, 7.0814d0, 7.0922d0, 7.1030d0, 7.1138d0, 7.1246d0,
     & 7.1355d0, 7.1464d0, 7.1573d0, 7.1683d0, 7.1792d0, 7.1903d0,
     & 7.2014d0, 7.2126d0, 7.2236d0, 7.2347d0, 7.2458d0, 7.2567d0,
     & 7.2676d0, 7.2785d0, 7.2895d0, 7.3005d0, 7.3116d0, 7.3225d0,
     & 7.3334d0, 7.3447d0, 7.3559d0, 7.3671d0, 7.3785d0, 7.3900d0,
     & 7.4013d0, 7.4123d0, 7.4235d0, 7.4346d0, 7.4460d0, 7.4575d0,
     & 7.4686d0, 7.4798d0, 7.4909d0, 7.5022d0, 7.5132d0, 7.5245d0,
     & 7.5358d0, 7.5473d0, 7.5585d0, 7.5699d0, 7.5812d0, 7.5927d0,
     & 7.6040d0, 7.6154d0, 7.6266d0, 7.6381d0, 7.6491d0, 7.6605d0,
     & 7.6721d0, 7.6835d0, 7.6947d0, 7.7059d0, 7.7173d0, 7.7285d0,
     & 7.7398d0, 7.7513d0, 7.7629d0, 7.7746d0, 7.7863d0, 7.7977d0,
     & 7.8092d0, 7.8209d0, 7.8327d0, 7.8443d0, 7.8560d0, 7.8678d0,
     & 7.8795d0, 7.8912d0, 7.9026d0, 7.9142d0, 7.9257d0, 7.9371d0,
     & 7.9488d0, 7.9601d0, 7.9716d0, 7.9830d0, 7.9945d0, 8.0060d0,
     & 8.0177d0, 8.0295d0, 8.0412d0, 8.0531d0, 8.0651d0, 8.0770d0,
     & 8.0891d0, 8.1010d0, 8.1131d0, 8.1252d0, 8.1369d0, 8.1487d0,
     & 8.1606d0, 8.1724d0, 8.1842d0, 8.1959d0, 8.2077d0, 8.2193d0,
     & 8.2315d0, 8.2434d0, 8.2553d0, 8.2676d0, 8.2798d0, 8.2921d0,
     & 8.3044d0, 8.3166d0, 8.3289d0, 8.3409d0, 8.3530d0, 8.3649d0,
     & 8.3768d0, 8.3889d0, 8.4008d0, 8.4130d0, 8.4250d0, 8.4372d0,
     & 8.4495d0, 8.4616d0, 8.4740d0, 8.4863d0, 8.4989d0, 8.5112d0,
     & 8.5237d0, 8.5362d0, 8.5486d0, 8.5612d0, 8.5735d0, 8.5856d0,
     & 8.5982d0, 8.6107d0, 8.6235d0, 8.6358d0, 8.6484d0, 8.6610d0,
     & 8.6733d0, 8.6859d0, 8.6983d0, 8.7111d0, 8.7237d0, 8.7361d0,
     & 8.7485d0, 8.7610d0, 8.7738d0, 8.7868d0, 8.7994d0, 8.8124d0,
     & 8.8252d0, 8.8382d0, 8.8510d0, 8.8641d0, 8.8768d0, 8.8898d0,
     & 8.9029d0, 8.9159d0, 8.9288d0, 8.9417d0, 8.9548d0, 8.9678d0,
     & 8.9807d0, 8.9933d0, 9.0060d0, 9.0191d0, 9.0321d0, 9.0452d0,
     & 9.0580d0, 9.0711d0, 9.0841d0, 9.0972d0, 9.1104d0, 9.1233d0,
     & 9.1366d0, 9.1502d0, 9.1638d0, 9.1771d0, 9.1905d0, 9.2039d0,
     & 9.2173d0, 9.2307d0, 9.2440d0, 9.2574d0, 9.2711d0, 9.2848d0,
     & 9.2981d0, 9.3116d0, 9.3251d0, 9.3386d0, 9.3525d0, 9.3662d0,
     & 9.3796d0, 9.3935d0, 9.4072d0, 9.4211d0, 9.4346d0, 9.4485d0,
     & 9.4622d0, 9.4759d0, 9.4894d0, 9.5031d0, 9.5170d0, 9.5311d0,
     & 9.5452d0, 9.5589d0, 9.5730d0, 9.5872d0, 9.6012d0, 9.6151d0,
     & 9.6295d0, 9.6437d0, 9.6578d0, 9.6718d0, 9.6862d0, 9.7002d0,
     & 9.7145d0, 9.7285d0, 9.7429d0, 9.7574d0, 9.7721d0, 9.7863d0,
     & 9.8007d0, 9.8155d0, 9.8303d0, 9.8445d0, 9.8591d0, 9.8739d0,
     & 9.8890d0, 9.9037d0, 9.9184d0, 9.9325d0, 9.9455d0, 9.9571d0,
     & 9.9671d0, 9.9757d0, 9.9833d0, 9.9895d0, 9.9942d0, 9.9974d0,
     & 9.9994d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     & 9.9999d0, 9.9999d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,10.0000d0,
     &10.0000d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0,10.0000d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0
     &/
      DATA (Imax ( 4,I), I= 1, 1000) /
     & 0.00001006d0, 0.00001006d0, 0.00001210d0, 0.00003641d0,
     & 0.00008120d0, 0.00024949d0, 0.00045747d0, 0.00076237d0,
     & 0.00117479d0, 0.00164624d0, 0.00223139d0, 0.00291370d0,
     & 0.00376559d0, 0.00467936d0, 0.00572772d0, 0.00688554d0,
     & 0.00804942d0, 0.00929188d0, 0.01059850d0, 0.01196272d0,
     & 0.01341060d0, 0.01485652d0, 0.01638398d0, 0.01790835d0,
     & 0.01950098d0, 0.02110025d0, 0.02277119d0, 0.02447694d0,
     & 0.02621237d0, 0.02793551d0, 0.02970599d0, 0.03151419d0,
     & 0.03338086d0, 0.03520342d0, 0.03706099d0, 0.03898431d0,
     & 0.04091902d0, 0.04281786d0, 0.04473326d0, 0.04669884d0,
     & 0.04870437d0, 0.05069214d0, 0.05266755d0, 0.05467735d0,
     & 0.05672564d0, 0.05878371d0, 0.06083321d0, 0.06287538d0,
     & 0.06495684d0, 0.06706385d0, 0.06917431d0, 0.07128498d0,
     & 0.07337844d0, 0.07554437d0, 0.07768531d0, 0.07984359d0,
     & 0.08199971d0, 0.08417015d0, 0.08639040d0, 0.08859874d0,
     & 0.09079967d0, 0.09300870d0, 0.09522451d0, 0.09745895d0,
     & 0.09970382d0, 0.10195157d0, 0.10420524d0, 0.10646442d0,
     & 0.10872148d0, 0.11099594d0, 0.11329739d0, 0.11558910d0,
     & 0.11787120d0, 0.12017104d0, 0.12248780d0, 0.12477535d0,
     & 0.12711392d0, 0.12945861d0, 0.13179080d0, 0.13412751d0,
     & 0.13645540d0, 0.13876924d0, 0.14113696d0, 0.14352793d0,
     & 0.14590561d0, 0.14826837d0, 0.15062265d0, 0.15295635d0,
     & 0.15532462d0, 0.15774257d0, 0.16016339d0, 0.16256359d0,
     & 0.16496150d0, 0.16733585d0, 0.16970633d0, 0.17214148d0,
     & 0.17460220d0, 0.17706436d0, 0.17950781d0, 0.18191420d0,
     & 0.18428823d0, 0.18667960d0, 0.18913525d0, 0.19161843d0,
     & 0.19410302d0, 0.19656746d0, 0.19898288d0, 0.20138952d0,
     & 0.20377737d0, 0.20624889d0, 0.20873845d0, 0.21124791d0,
     & 0.21376757d0, 0.21622141d0, 0.21864629d0, 0.22106966d0,
     & 0.22351287d0, 0.22600684d0, 0.22854815d0, 0.23110618d0,
     & 0.23359571d0, 0.23608312d0, 0.23854719d0, 0.24098025d0,
     & 0.24343358d0, 0.24596167d0, 0.24851523d0, 0.25108588d0,
     & 0.25360247d0, 0.25608730d0, 0.25856951d0, 0.26103255d0,
     & 0.26349834d0, 0.26605019d0, 0.26864770d0, 0.27124208d0,
     & 0.27377719d0, 0.27628323d0, 0.27876815d0, 0.28125495d0,
     & 0.28374517d0, 0.28624323d0, 0.28884733d0, 0.29145026d0,
     & 0.29400486d0, 0.29652894d0, 0.29905114d0, 0.30157396d0,
     & 0.30409819d0, 0.30662403d0, 0.30920205d0, 0.31178597d0,
     & 0.31442460d0, 0.31699246d0, 0.31955656d0, 0.32209903d0,
     & 0.32462090d0, 0.32717726d0, 0.32969478d0, 0.33229110d0,
     & 0.33491325d0, 0.33752432d0, 0.34012529d0, 0.34268066d0,
     & 0.34523648d0, 0.34779361d0, 0.35033211d0, 0.35289484d0,
     & 0.35550097d0, 0.35817546d0, 0.36076850d0, 0.36335227d0,
     & 0.36591133d0, 0.36849198d0, 0.37105235d0, 0.37361473d0,
     & 0.37620112d0, 0.37884116d0, 0.38147327d0, 0.38405365d0,
     & 0.38662446d0, 0.38923797d0, 0.39185140d0, 0.39446586d0,
     & 0.39706028d0, 0.39965171d0, 0.40224552d0, 0.40482992d0,
     & 0.40744987d0, 0.41009948d0, 0.41274485d0, 0.41536734d0,
     & 0.41796905d0, 0.42057294d0, 0.42317894d0, 0.42576489d0,
     & 0.42838025d0, 0.43109217d0, 0.43375045d0, 0.43636647d0,
     & 0.43898076d0, 0.44157195d0, 0.44418678d0, 0.44680250d0,
     & 0.44944265d0, 0.45206216d0, 0.45468363d0, 0.45730746d0,
     & 0.45987749d0, 0.46254313d0, 0.46518201d0, 0.46782076d0,
     & 0.47046027d0, 0.47310150d0, 0.47574478d0, 0.47836736d0,
     & 0.48099187d0, 0.48361838d0, 0.48628306d0, 0.48892671d0,
     & 0.49157026d0, 0.49424005d0, 0.49688837d0, 0.49953938d0,
     & 0.50216979d0, 0.50480342d0, 0.50746346d0, 0.51012570d0,
     & 0.51279008d0, 0.51542580d0, 0.51809347d0, 0.52078819d0,
     & 0.52343547d0, 0.52610928d0, 0.52876079d0, 0.53141373d0,
     & 0.53409231d0, 0.53672540d0, 0.53936046d0, 0.54202121d0,
     & 0.54467958d0, 0.54733711d0, 0.55002713d0, 0.55269414d0,
     & 0.55536354d0, 0.55805868d0, 0.56078023d0, 0.56345582d0,
     & 0.56615758d0, 0.56886125d0, 0.57154298d0, 0.57420278d0,
     & 0.57686502d0, 0.57943875d0, 0.58214688d0, 0.58485276d0,
     & 0.58756226d0, 0.59025085d0, 0.59291798d0, 0.59556419d0,
     & 0.59821361d0, 0.60091501d0, 0.60361880d0, 0.60625958d0,
     & 0.60890788d0, 0.61152792d0, 0.61426747d0, 0.61695915d0,
     & 0.61965400d0, 0.62240154d0, 0.62515128d0, 0.62787783d0,
     & 0.63055694d0, 0.63323802d0, 0.63592100d0, 0.63861758d0,
     & 0.64127123d0, 0.64383084d0, 0.64647985d0, 0.64913481d0,
     & 0.65176898d0, 0.65440619d0, 0.65714735d0, 0.65989077d0,
     & 0.66266155d0, 0.66538411d0, 0.66808426d0, 0.67076766d0,
     & 0.67342681d0, 0.67608815d0, 0.67876959d0, 0.68148601d0,
     & 0.68420792d0, 0.68698746d0, 0.68971837d0, 0.69242674d0,
     & 0.69518781d0, 0.69795126d0, 0.70070648d0, 0.70339817d0,
     & 0.70603645d0, 0.70869654d0, 0.71136111d0, 0.71404958d0,
     & 0.71661925d0, 0.71930218d0, 0.72199070d0, 0.72478843d0,
     & 0.72751278d0, 0.73027688d0, 0.73308462d0, 0.73590308d0,
     & 0.73867285d0, 0.74134779d0, 0.74399161d0, 0.74661940d0,
     & 0.74933571d0, 0.75206333d0, 0.75469363d0, 0.75738144d0,
     & 0.76004767d0, 0.76271731d0, 0.76538992d0, 0.76819575d0,
     & 0.77105480d0, 0.77383810d0, 0.77664930d0, 0.77930969d0,
     & 0.78195292d0, 0.78462654d0, 0.78735703d0, 0.79009801d0,
     & 0.79284596d0, 0.79559934d0, 0.79822636d0, 0.80101633d0,
     & 0.80383396d0, 0.80662811d0, 0.80942446d0, 0.81222290d0,
     & 0.81500733d0, 0.81772810d0, 0.82035494d0, 0.82302505d0,
     & 0.82573354d0, 0.82845557d0, 0.83110029d0, 0.83380473d0,
     & 0.83651489d0, 0.83923000d0, 0.84194946d0, 0.84462023d0,
     & 0.84742761d0, 0.85034263d0, 0.85312736d0, 0.85586858d0,
     & 0.85859245d0, 0.86125827d0, 0.86398423d0, 0.86669809d0,
     & 0.86945075d0, 0.87221032d0, 0.87500149d0, 0.87766433d0,
     & 0.88030481d0, 0.88302779d0, 0.88575363d0, 0.88848203d0,
     & 0.89118648d0, 0.89395773d0, 0.89673632d0, 0.89947230d0,
     & 0.90214539d0, 0.90491050d0, 0.90769124d0, 0.91045332d0,
     & 0.91322267d0, 0.91599768d0, 0.91877723d0, 0.92153329d0,
     & 0.92418689d0, 0.92681652d0, 0.92944896d0, 0.93211001d0,
     & 0.93475467d0, 0.93737918d0, 0.94001919d0, 0.94262284d0,
     & 0.94521880d0, 0.94784790d0, 0.95052421d0, 0.95318538d0,
     & 0.95582479d0, 0.95849961d0, 0.96120673d0, 0.96383750d0,
     & 0.96647215d0, 0.96908283d0, 0.97172344d0, 0.97444808d0,
     & 0.97713608d0, 0.97980112d0, 0.98239732d0, 0.98504055d0,
     & 0.98764664d0, 0.99024212d0, 0.99288529d0, 0.99554574d0,
     & 0.99822295d0, 1.00090992d0, 1.00352347d0, 1.00614333d0,
     & 1.00874102d0, 1.01139796d0, 1.01405942d0, 1.01672506d0,
     & 1.01937103d0, 1.02196741d0, 1.02454543d0, 1.02721548d0,
     & 1.02987516d0, 1.03249979d0, 1.03506386d0, 1.03772211d0,
     & 1.04040051d0, 1.04309094d0, 1.04578984d0, 1.04852295d0,
     & 1.05126143d0, 1.05394828d0, 1.05655682d0, 1.05919635d0,
     & 1.06183851d0, 1.06453848d0, 1.06716979d0, 1.06975162d0,
     & 1.07242990d0, 1.07509804d0, 1.07773089d0, 1.08030236d0,
     & 1.08297169d0, 1.08567369d0, 1.08836353d0, 1.09109247d0,
     & 1.09382856d0, 1.09657097d0, 1.09928906d0, 1.10187364d0,
     & 1.10446286d0, 1.10708356d0, 1.10976231d0, 1.11239696d0,
     & 1.11499667d0, 1.11757946d0, 1.12012184d0, 1.12265515d0,
     & 1.12526429d0, 1.12789667d0, 1.13059497d0, 1.13332915d0,
     & 1.13608003d0, 1.13884234d0, 1.14161313d0, 1.14439058d0,
     & 1.14711595d0, 1.14987385d0, 1.15260756d0, 1.15526152d0,
     & 1.15794694d0, 1.16059256d0, 1.16320014d0, 1.16578937d0,
     & 1.16833818d0, 1.17087781d0, 1.17352092d0, 1.17621636d0,
     & 1.17891371d0, 1.18167150d0, 1.18438900d0, 1.18712127d0,
     & 1.18986404d0, 1.19261491d0, 1.19537222d0, 1.19816291d0,
     & 1.20095813d0, 1.20361817d0, 1.20622408d0, 1.20885479d0,
     & 1.21144187d0, 1.21407092d0, 1.21668482d0, 1.21928823d0,
     & 1.22185588d0, 1.22441769d0, 1.22697473d0, 1.22950006d0,
     & 1.23222983d0, 1.23504353d0, 1.23784411d0, 1.24063635d0,
     & 1.24337673d0, 1.24612415d0, 1.24890709d0, 1.25172317d0,
     & 1.25454390d0, 1.25731075d0, 1.26008046d0, 1.26267421d0,
     & 1.26524127d0, 1.26779306d0, 1.27036381d0, 1.27298498d0,
     & 1.27556920d0, 1.27811897d0, 1.28066349d0, 1.28320360d0,
     & 1.28599286d0, 1.28883028d0, 1.29168034d0, 1.29435873d0,
     & 1.29716527d0, 1.29997909d0, 1.30279851d0, 1.30565178d0,
     & 1.30845010d0, 1.31125224d0, 1.31402898d0, 1.31661344d0,
     & 1.31917787d0, 1.32172918d0, 1.32445192d0, 1.32701778d0,
     & 1.32957625d0, 1.33212936d0, 1.33467662d0, 1.33724940d0,
     & 1.33985019d0, 1.34269083d0, 1.34548306d0, 1.34828639d0,
     & 1.35112822d0, 1.35394692d0, 1.35679889d0, 1.35962641d0,
     & 1.36245942d0, 1.36529744d0, 1.36816752d0, 1.37098002d0,
     & 1.37352359d0, 1.37611520d0, 1.37869549d0, 1.38123703d0,
     & 1.38380146d0, 1.38636112d0, 1.38894498d0, 1.39149463d0,
     & 1.39404058d0, 1.39663315d0, 1.39929175d0, 1.40218246d0,
     & 1.40505242d0, 1.40793037d0, 1.41066563d0, 1.41352654d0,
     & 1.41639149d0, 1.41926217d0, 1.42216516d0, 1.42504191d0,
     & 1.42781377d0, 1.43055046d0, 1.43311501d0, 1.43570149d0,
     & 1.43825221d0, 1.44094729d0, 1.44351804d0, 1.44608617d0,
     & 1.44865024d0, 1.45118344d0, 1.45376647d0, 1.45646656d0,
     & 1.45915556d0, 1.46185863d0, 1.46457303d0, 1.46732628d0,
     & 1.47020674d0, 1.47309256d0, 1.47595322d0, 1.47881806d0,
     & 1.48168600d0, 1.48447633d0, 1.48720920d0, 1.48992348d0,
     & 1.49262261d0, 1.49530983d0, 1.49795818d0, 1.50048125d0,
     & 1.50297046d0, 1.50548506d0, 1.50796688d0, 1.51041687d0,
     & 1.51295125d0, 1.51554143d0, 1.51816082d0, 1.52080035d0,
     & 1.52345502d0, 1.52627194d0, 1.52906442d0, 1.53189206d0,
     & 1.53472507d0, 1.53747129d0, 1.54031134d0, 1.54318571d0,
     & 1.54591656d0, 1.54864812d0, 1.55136037d0, 1.55397129d0,
     & 1.55644953d0, 1.55895138d0, 1.56141841d0, 1.56388044d0,
     & 1.56645894d0, 1.56900203d0, 1.57142425d0, 1.57390296d0,
     & 1.57637882d0, 1.57891941d0, 1.58157706d0, 1.58425438d0,
     & 1.58691323d0, 1.58979654d0, 1.59265625d0, 1.59540117d0,
     & 1.59818196d0, 1.60111570d0, 1.60405254d0, 1.60687399d0,
     & 1.60963178d0, 1.61233199d0, 1.61501217d0, 1.61768210d0,
     & 1.62015927d0, 1.62274885d0, 1.62545395d0, 1.62797725d0,
     & 1.63040662d0, 1.63283324d0, 1.63537598d0, 1.63791573d0,
     & 1.64045334d0, 1.64300442d0, 1.64562964d0, 1.64824188d0,
     & 1.65081370d0, 1.65336537d0, 1.65607309d0, 1.65875793d0,
     & 1.66147709d0, 1.66429460d0, 1.66711676d0, 1.66994226d0,
     & 1.67275727d0, 1.67546928d0, 1.67822373d0, 1.68090189d0,
     & 1.68360150d0, 1.68629265d0, 1.68897808d0, 1.69165742d0,
     & 1.69424081d0, 1.69679070d0, 1.69936681d0, 1.70191038d0,
     & 1.70451057d0, 1.70699012d0, 1.70952368d0, 1.71211505d0,
     & 1.71473014d0, 1.71739078d0, 1.72003329d0, 1.72268426d0,
     & 1.72561407d0, 1.72855067d0, 1.73140156d0, 1.73422849d0,
     & 1.73702836d0, 1.73977709d0, 1.74271262d0, 1.74553502d0,
     & 1.74825430d0, 1.75099564d0, 1.75372910d0, 1.75621748d0,
     & 1.75867140d0, 1.76124263d0, 1.76381052d0, 1.76649559d0,
     & 1.76917744d0, 1.77158499d0, 1.77408171d0, 1.77663636d0,
     & 1.77929866d0, 1.78195429d0, 1.78462696d0, 1.78731096d0,
     & 1.79000640d0, 1.79274046d0, 1.79545105d0, 1.79819608d0,
     & 1.80094576d0, 1.80370259d0, 1.80646324d0, 1.80932999d0,
     & 1.81211448d0, 1.81485164d0, 1.81760848d0, 1.82032526d0,
     & 1.82303417d0, 1.82573783d0, 1.82840788d0, 1.83113348d0,
     & 1.83382320d0, 1.83653951d0, 1.83904076d0, 1.84160030d0,
     & 1.84418750d0, 1.84674251d0, 1.84939170d0, 1.85204017d0,
     & 1.85474014d0, 1.85738707d0, 1.86001790d0, 1.86265731d0,
     & 1.86530602d0, 1.86796260d0, 1.87068641d0, 1.87341392d0,
     & 1.87614560d0, 1.87881780d0, 1.88161457d0, 1.88439131d0,
     & 1.88725245d0, 1.89007127d0, 1.89291239d0, 1.89568555d0,
     & 1.89830196d0, 1.90061140d0, 1.90333843d0, 1.90609193d0,
     & 1.90880954d0, 1.91140223d0, 1.91399229d0, 1.91649044d0,
     & 1.91907609d0, 1.92168784d0, 1.92439938d0, 1.92728269d0,
     & 1.93031979d0, 1.93295133d0, 1.93559444d0, 1.93827713d0,
     & 1.94096792d0, 1.94366562d0, 1.94642794d0, 1.94913423d0,
     & 1.95181942d0, 1.95446730d0, 1.95706534d0, 1.95978177d0,
     & 1.96248543d0, 1.96514893d0, 1.96780467d0, 1.97057223d0,
     & 1.97333634d0, 1.97612631d0, 1.97888386d0, 1.98163521d0,
     & 1.98438323d0, 1.98712873d0, 1.98993134d0, 1.99278915d0,
     & 1.99543786d0, 1.99805474d0, 2.00063038d0, 2.00319910d0,
     & 2.00575519d0, 2.00845528d0, 2.01116610d0, 2.01385427d0,
     & 2.01665640d0, 2.01923537d0, 2.02176332d0, 2.02440977d0,
     & 2.02706075d0, 2.02972794d0, 2.03240490d0, 2.03506684d0,
     & 2.03760719d0, 2.04010963d0, 2.04264045d0, 2.04506040d0,
     & 2.04764628d0, 2.05019855d0, 2.05287218d0, 2.05554366d0,
     & 2.05821252d0, 2.06090760d0, 2.06363177d0, 2.06627393d0,
     & 2.06903648d0, 2.07167196d0, 2.07433534d0, 2.07700300d0,
     & 2.07975936d0, 2.08246899d0, 2.08523107d0, 2.08794999d0,
     & 2.09061766d0, 2.09329486d0, 2.09603882d0, 2.09869766d0,
     & 2.10145450d0, 2.10418606d0, 2.10701013d0, 2.10977578d0,
     & 2.11259341d0, 2.11536026d0, 2.11798954d0, 2.12061167d0,
     & 2.12322354d0, 2.12592459d0, 2.12846732d0, 2.13100600d0,
     & 2.13356924d0, 2.13603783d0, 2.13850546d0, 2.14117765d0,
     & 2.14397073d0, 2.14685321d0, 2.14973354d0, 2.15279126d0,
     & 2.15536451d0, 2.15808606d0, 2.16088414d0, 2.16371989d0,
     & 2.16657352d0, 2.16940904d0, 2.17204762d0, 2.17469978d0,
     & 2.17716837d0, 2.17964411d0, 2.18195009d0, 2.18468142d0,
     & 2.18742108d0, 2.19008708d0, 2.19275188d0, 2.19539928d0,
     & 2.19803619d0, 2.20066285d0, 2.20315433d0, 2.20582867d0,
     & 2.20853114d0, 2.21119738d0, 2.21395016d0, 2.21651268d0,
     & 2.21910548d0, 2.22166395d0, 2.22418928d0, 2.22674274d0,
     & 2.22929406d0, 2.23187399d0, 2.23469734d0, 2.23742509d0,
     & 2.24031353d0, 2.24299598d0, 2.24582458d0, 2.24867511d0,
     & 2.25154257d0, 2.25445366d0, 2.25740790d0, 2.26030660d0,
     & 2.26333785d0, 2.26613569d0, 2.26880908d0, 2.27132511d0,
     & 2.27395940d0, 2.27663684d0, 2.27935243d0, 2.28202271d0,
     & 2.28468490d0, 2.28727531d0, 2.28992343d0, 2.29244089d0,
     & 2.29491997d0, 2.29761624d0, 2.30030918d0, 2.30299807d0,
     & 2.30580282d0, 2.30851412d0, 2.31125665d0, 2.31411576d0,
     & 2.31700325d0, 2.31955338d0, 2.32207060d0, 2.32461715d0,
     & 2.32754946d0, 2.33050799d0, 2.33334756d0, 2.33608842d0,
     & 2.33884192d0, 2.34153891d0, 2.34415841d0, 2.34678745d0,
     & 2.34975696d0, 2.35273218d0, 2.35571671d0, 2.35828781d0,
     & 2.36102414d0, 2.36384487d0, 2.36677623d0, 2.36972904d0,
     & 2.37289667d0, 2.37561512d0, 2.37829566d0, 2.38094354d0,
     & 2.38362241d0, 2.38626409d0, 2.38899612d0, 2.39175582d0,
     & 2.39455104d0, 2.39718485d0, 2.39962912d0, 2.40191364d0,
     & 2.40460396d0, 2.40729356d0, 2.41001201d0, 2.41288114d0,
     & 2.41578794d0, 2.41887379d0, 2.42179012d0, 2.42488647d0,
     & 2.42752457d0, 2.43036461d0, 2.43321633d0, 2.43607831d0,
     & 2.43897963d0, 2.44188499d0, 2.44454885d0, 2.44721055d0,
     & 2.44960403d0, 2.45198035d0, 2.45418382d0, 2.45681334d0,
     & 2.45939994d0, 2.46210575d0, 2.46455383d0, 2.46705866d0,
     & 2.46956110d0, 2.47212076d0, 2.47488952d0, 2.47753429d0,
     & 2.48014784d0, 2.48275447d0, 2.48527026d0, 2.48781466d0,
     & 2.49022865d0, 2.49289012d0, 2.49545622d0, 2.49802065d0,
     & 2.50061393d0, 2.50299215d0, 2.50548983d0, 2.50822210d0,
     & 2.51098847d0, 2.51411891d0, 2.51753116d0, 2.52095246d0,
     & 2.52388859d0, 2.52830672d0, 2.53296089d0, 2.53758740d0,
     & 2.54212379d0, 2.54493904d0, 2.54784393d0, 2.55071831d0,
     & 2.55310106d0, 2.55542684d0, 2.55774665d0, 2.56055403d0,
     & 2.56175590d0, 2.56259847d0, 2.56344008d0, 2.56437445d0,
     & 2.56740499d0, 2.57014251d0, 2.57327533d0, 2.57669353d0,
     & 2.57951188d0, 2.58177376d0, 2.58412647d0, 2.58837652d0
     &/
      DATA (Imax ( 4,I), I= 1001, 2100) /
     & 2.59097648d0, 2.59400654d0, 2.59706521d0, 2.59977937d0,
     & 2.60246110d0, 2.60455465d0, 2.60643196d0, 2.60868263d0,
     & 2.61149216d0, 2.61427093d0, 2.61533570d0, 2.61819315d0,
     & 2.62106395d0, 2.62391210d0, 2.62705660d0, 2.63128304d0,
     & 2.63554478d0, 2.64002204d0, 2.64447141d0, 2.64758754d0,
     & 2.65064454d0, 2.65367603d0, 2.65665889d0, 2.66916108d0,
     & 2.67147493d0, 2.68365955d0, 2.68460011d0, 2.68569231d0,
     & 2.68678689d0, 2.68791151d0, 2.69033384d0, 2.69275355d0,
     & 2.69529533d0, 2.69786620d0, 2.69050002d0, 2.69328332d0,
     & 2.69601393d0, 2.69851780d0, 2.70102334d0, 2.70349240d0,
     & 2.70602179d0, 2.70858097d0, 2.71113849d0, 2.71357036d0,
     & 2.71650553d0, 2.72101736d0, 2.72553301d0, 2.71993899d0,
     & 2.72470617d0, 2.72947741d0, 2.73403096d0, 2.73731065d0,
     & 2.74059796d0, 2.74389243d0, 2.74719334d0, 2.74999619d0,
     & 2.75123096d0, 2.75278163d0, 2.75468111d0, 2.75701737d0,
     & 2.75796723d0, 2.77728367d0, 2.77967048d0, 2.80015564d0,
     & 2.82074380d0, 2.84133506d0, 2.84402466d0, 2.84671116d0,
     & 2.84911036d0, 2.85115433d0, 2.85276365d0, 2.85557032d0,
     & 2.84013605d0, 2.84284496d0, 2.82741833d0, 2.81188345d0,
     & 2.79634070d0, 2.79963493d0, 2.80394959d0, 2.80826950d0,
     & 2.81246471d0, 2.81672740d0, 2.81935787d0, 2.82345819d0,
     & 2.82674694d0, 2.83010912d0, 2.83347917d0, 2.83701849d0,
     & 2.83916473d0, 2.84058833d0, 2.84197903d0, 2.84350562d0,
     & 2.84461021d0, 2.84753394d0, 2.86701822d0, 2.88754964d0,
     & 2.90766549d0, 2.92778349d0, 2.94774246d0, 2.96816421d0,
     & 2.97045064d0, 2.97276616d0, 2.97687507d0, 2.98112917d0,
     & 2.98538256d0, 2.97545242d0, 2.96529531d0, 2.95551491d0,
     & 2.94572806d0, 2.94171190d0, 2.93162632d0, 2.95190978d0,
     & 2.95448661d0, 2.97280669d0, 2.98495674d0, 2.98599982d0,
     & 2.98344421d0, 2.98087525d0, 2.97799540d0, 2.97511148d0,
     & 2.96874928d0, 2.96847653d0, 2.95567584d0, 2.96048832d0,
     & 2.94776011d0, 2.94147301d0, 2.94600701d0, 2.95042038d0,
     & 2.95458841d0, 2.95903540d0, 2.96243644d0, 2.96353936d0,
     & 2.96461630d0, 2.96559644d0, 2.96667075d0, 2.97297001d0,
     & 2.97891951d0, 2.98516154d0, 2.99140644d0, 2.99758744d0,
     & 3.00380278d0, 3.00671077d0, 3.00936365d0, 3.02294183d0,
     & 3.03624010d0, 3.04951119d0, 3.05759788d0, 3.06600595d0,
     & 3.08168221d0, 3.09687757d0, 3.11246467d0, 3.12751436d0,
     & 3.14022160d0, 3.14413166d0, 3.13677716d0, 3.12925982d0,
     & 3.12107992d0, 3.11285543d0, 3.10465503d0, 3.08925152d0,
     & 3.07436848d0, 3.05942941d0, 3.04515052d0, 3.03761506d0,
     & 3.03923893d0, 3.04614902d0, 3.05336356d0, 3.06114912d0,
     & 3.06895232d0, 3.07639122d0, 3.08377719d0, 3.08643079d0,
     & 3.08906770d0, 3.09158015d0, 3.09404945d0, 3.09637880d0,
     & 3.09550524d0, 3.09529638d0, 3.10391021d0, 3.10970521d0,
     & 3.12101293d0, 3.21987462d0, 3.22232723d0, 3.23210716d0,
     & 3.26030684d0, 3.30848122d0, 3.28679323d0, 3.30632448d0,
     & 3.32467008d0, 3.35222864d0, 3.38131881d0, 3.40679193d0,
     & 3.44044876d0, 3.46821761d0, 3.49555111d0, 3.51799893d0,
     & 3.54744053d0, 3.57545137d0, 3.60357881d0, 3.62852001d0,
     & 3.66014147d0, 3.68648362d0, 3.70416832d0, 3.72828817d0,
     & 3.75721145d0, 3.78557038d0, 3.81447935d0, 3.84421039d0,
     & 3.87233949d0, 3.89015961d0, 3.91792679d0, 3.94604111d0,
     & 3.97255111d0, 4.00300741d0, 4.03124714d0, 4.06130219d0,
     & 4.08853531d0, 4.11701679d0, 4.14947557d0, 4.17920542d0,
     & 4.21429443d0, 4.24268770d0, 4.27043676d0, 4.29925156d0,
     & 4.33034849d0, 4.35701609d0, 4.38482571d0, 4.41233540d0,
     & 4.43975544d0, 4.46866846d0, 4.51442337d0, 4.53641796d0,
     & 4.56539297d0, 4.59471083d0, 4.62286425d0, 4.65148306d0,
     & 4.68907309d0, 4.71714115d0, 4.74501324d0, 4.77410889d0,
     & 4.80245304d0, 4.83252764d0, 4.87205124d0, 4.88359499d0,
     & 4.91270542d0, 4.94328499d0, 4.97057343d0, 4.99940300d0,
     & 5.02956676d0, 5.05948210d0, 5.09458447d0, 5.12506628d0,
     & 5.15597248d0, 5.18143177d0, 5.21262455d0, 5.23395967d0,
     & 5.26314402d0, 5.29398203d0, 5.32769775d0, 5.35743427d0,
     & 5.38068867d0, 5.41033411d0, 5.43948603d0, 5.46798658d0,
     & 5.50213718d0, 5.53516197d0, 5.56388569d0, 5.59021807d0,
     & 5.61892557d0, 5.63465309d0, 5.66752434d0, 5.69763327d0,
     & 5.72458410d0, 5.74434471d0, 5.78650522d0, 5.81079483d0,
     & 5.83878422d0, 5.87104177d0, 5.89842510d0, 5.92635345d0,
     & 5.95355940d0, 5.98064852d0, 6.00618362d0, 6.03665686d0,
     & 6.06326151d0, 6.08932066d0, 6.11441278d0, 6.14157915d0,
     & 6.17213821d0, 6.20075655d0, 6.22936487d0, 6.25504351d0,
     & 6.28463364d0, 6.31638765d0, 6.34793901d0, 6.37412930d0,
     & 6.40031290d0, 6.43068027d0, 6.45877028d0, 6.48662806d0,
     & 6.51651096d0, 6.54560852d0, 6.57486153d0, 6.60482454d0,
     & 6.62995243d0, 6.65873098d0, 6.68876553d0, 6.71588945d0,
     & 6.74120283d0, 6.76929474d0, 6.79216957d0, 6.82090235d0,
     & 6.85477018d0, 6.88759518d0, 6.91980410d0, 6.94885588d0,
     & 6.97702503d0, 7.00494242d0, 7.03204966d0, 7.05953884d0,
     & 7.08917570d0, 7.11754322d0, 7.14160919d0, 7.16268158d0,
     & 7.19113350d0, 7.22611475d0, 7.25422525d0, 7.27545261d0,
     & 7.30000639d0, 7.32645607d0, 7.34990358d0, 7.38192797d0,
     & 7.41267633d0, 7.44213772d0, 7.47175455d0, 7.49049425d0,
     & 7.52160454d0, 7.55188704d0, 7.58165455d0, 7.61681271d0,
     & 7.64144659d0, 7.67046928d0, 7.69859934d0, 7.72819233d0,
     & 7.75530005d0, 7.78372049d0, 7.81233835d0, 7.84009218d0,
     & 7.87203550d0, 7.90415955d0, 7.93447065d0, 7.96568298d0,
     & 7.99371672d0, 8.01707363d0, 8.04338551d0, 8.07129860d0,
     & 8.09945774d0, 8.12897778d0, 8.15848160d0, 8.18775082d0,
     & 8.21796513d0, 8.24438381d0, 8.27267170d0, 8.29584885d0,
     & 8.32604885d0, 8.35153675d0, 8.37680531d0, 8.40221882d0,
     & 8.42905617d0, 8.45391083d0, 8.47939777d0, 8.50621223d0,
     & 8.53223228d0, 8.56174946d0, 8.59137535d0, 8.61712742d0,
     & 8.64482307d0, 8.67205429d0, 8.69844913d0, 8.72593021d0,
     & 8.75350285d0, 8.78306198d0, 8.81330204d0, 8.84054279d0,
     & 8.86711788d0, 8.89530468d0, 8.92271709d0, 8.95151997d0,
     & 8.97902775d0, 9.00775051d0, 9.03355408d0, 9.05986691d0,
     & 9.08944225d0, 9.12135410d0, 9.15332222d0, 9.18452549d0,
     & 9.20867062d0, 9.23830223d0, 9.26512432d0, 9.28873730d0,
     & 9.31358814d0, 9.34173203d0, 9.36999035d0, 9.39923668d0,
     & 9.42961407d0, 9.45781040d0, 9.48349953d0, 9.51261425d0,
     & 9.54147243d0, 9.56973934d0, 9.59676743d0, 9.62338352d0,
     & 9.65050888d0, 9.67463970d0, 9.70377159d0, 9.73303890d0,
     & 9.76117897d0, 9.78799534d0, 9.81528950d0, 9.84236717d0,
     & 9.86912346d0, 9.89886665d0, 9.92441082d0, 9.95266914d0,
     & 9.97767258d0,10.00824451d0,10.03749561d0,10.06408310d0,
     &10.09131336d0,10.11854172d0,10.14768505d0,10.17602444d0,
     &10.20141220d0,10.22707939d0,10.25302792d0,10.28104973d0,
     &10.30666161d0,10.33167362d0,10.35665226d0,10.38251114d0,
     &10.41183758d0,10.44064903d0,10.46881580d0,10.49628830d0,
     &10.52160740d0,10.54641056d0,10.57538986d0,10.60473442d0,
     &10.63342571d0,10.66704845d0,10.69075775d0,10.71916962d0,
     &10.74880505d0,10.77636433d0,10.80417442d0,10.83273506d0,
     &10.85966969d0,10.88694096d0,10.91546440d0,10.94283104d0,
     &10.96855164d0,10.99861050d0,11.02530193d0,11.05338097d0,
     &11.08197880d0,11.11267376d0,11.14554405d0,11.17477036d0,
     &11.20150471d0,11.22642326d0,11.25249386d0,11.27980137d0,
     &11.30836391d0,11.33642006d0,11.36660767d0,11.39425850d0,
     &11.42187309d0,11.44889450d0,11.47868919d0,11.50642681d0,
     &11.53587532d0,11.56372929d0,11.59142113d0,11.61661053d0,
     &11.64562035d0,11.67628002d0,11.70213509d0,11.73249722d0,
     &11.76021290d0,11.78750038d0,11.81418324d0,11.84273434d0,
     &11.87074471d0,11.89773750d0,11.92803001d0,11.95500755d0,
     &11.97981262d0,12.00602436d0,12.03743362d0,12.06686878d0,
     &12.09242249d0,12.11813164d0,12.14577103d0,12.17060852d0,
     &12.19718933d0,12.22669125d0,12.25396156d0,12.28326511d0,
     &12.31075573d0,12.33968735d0,12.36753750d0,12.39669132d0,
     &12.42417812d0,12.44882202d0,12.47328758d0,12.50125313d0,
     &12.53082848d0,12.55667686d0,12.58217430d0,12.61095619d0,
     &12.63971233d0,12.66930485d0,12.70203686d0,12.73716068d0,
     &12.76257420d0,12.79009151d0,12.81963348d0,12.84927559d0,
     &12.87526894d0,12.90048885d0,12.92632484d0,12.95500851d0,
     &12.98297977d0,13.00956154d0,13.03675652d0,13.06659508d0,
     &13.09427643d0,13.11947918d0,13.14909077d0,13.17888260d0,
     &13.20994091d0,13.23793983d0,13.26959801d0,13.29727554d0,
     &13.32214928d0,13.35046768d0,13.37742519d0,13.40598679d0,
     &13.43315315d0,13.46066761d0,13.49285412d0,13.52611256d0,
     &13.55348492d0,13.58502197d0,13.61176682d0,13.63610458d0,
     &13.66112804d0,13.68922234d0,13.71817207d0,13.74788380d0,
     &13.77769279d0,13.80558014d0,13.83295536d0,13.85996056d0,
     &13.89108467d0,13.92271328d0,13.95634747d0,13.98361874d0,
     &14.00431633d0,14.03045273d0,14.05409241d0,14.08360291d0,
     &14.11603642d0,14.14071274d0,14.16905212d0,14.19905853d0,
     &14.22768784d0,14.25654125d0,14.28849697d0,14.31855679d0,
     &14.34398937d0,14.36913490d0,14.39584255d0,14.42848110d0,
     &14.45892811d0,14.48636150d0,14.51480961d0,14.54845524d0,
     &14.57895756d0,14.60789967d0,14.63616657d0,14.66200638d0,
     &14.69109058d0,14.72079277d0,14.74859142d0,14.77797318d0,
     &14.80847549d0,14.83778572d0,14.86665916d0,14.89321899d0,
     &14.91928768d0,14.94993591d0,14.98177624d0,15.01233673d0,
     &15.04234695d0,15.07164192d0,15.10037327d0,15.12616348d0,
     &15.15321827d0,15.17790794d0,15.21087360d0,15.23945141d0,
     &15.26421642d0,15.29226112d0,15.31731796d0,15.34330273d0,
     &15.37109280d0,15.39736652d0,15.42842388d0,15.45534039d0,
     &15.48490047d0,15.51452732d0,15.54383278d0,15.57242012d0,
     &15.60421658d0,15.63635254d0,15.66576576d0,15.69470024d0,
     &15.72981358d0,15.75921631d0,15.78908443d0,15.82028198d0,
     &15.84996128d0,15.88125229d0,15.91089535d0,15.93955898d0,
     &15.96615219d0,15.99202728d0,16.01848793d0,16.04664040d0,
     &16.07791901d0,16.10778427d0,16.13578987d0,16.16574860d0,
     &16.19520569d0,16.22541809d0,16.25607681d0,16.28718948d0,
     &16.31843567d0,16.35062981d0,16.38402367d0,16.41695595d0,
     &16.44707108d0,16.47446442d0,16.50388336d0,16.53712273d0,
     &16.56372452d0,16.59243202d0,16.62363243d0,16.65615463d0,
     &16.68871880d0,16.71992493d0,16.74830627d0,16.77484894d0,
     &16.79840851d0,16.82655334d0,16.85816574d0,16.88509750d0,
     &16.91604614d0,16.94594383d0,16.97484970d0,17.00551224d0,
     &17.03238869d0,17.06161690d0,17.09341431d0,17.12366676d0,
     &17.15359688d0,17.18535614d0,17.21706009d0,17.24867439d0,
     &17.27922630d0,17.31226730d0,17.34530067d0,17.37716866d0,
     &17.41042900d0,17.44166374d0,17.47243690d0,17.49713326d0,
     &17.52578354d0,17.55631065d0,17.58716774d0,17.61693764d0,
     &17.64772415d0,17.68173218d0,17.70817566d0,17.73914337d0,
     &17.76996422d0,17.80551720d0,17.83569336d0,17.85772324d0,
     &17.88232422d0,17.90849113d0,17.93509102d0,17.96895981d0,
     &18.00724411d0,18.04294777d0,18.07393837d0,18.10736084d0,
     &18.13334465d0,18.16362762d0,18.19107246d0,18.22653389d0,
     &18.25762177d0,18.28617668d0,18.31907845d0,18.34966087d0,
     &18.37807465d0,18.40668106d0,18.44156837d0,18.47197342d0,
     &18.50383377d0,18.53449059d0,18.57354736d0,18.60486031d0,
     &18.63191605d0,18.66095161d0,18.69221687d0,18.72567177d0,
     &18.75790787d0,18.78625298d0,18.81706810d0,18.84399605d0,
     &18.87807655d0,18.90687180d0,18.93808746d0,18.96682739d0,
     &18.99669647d0,19.02563477d0,19.05620575d0,19.08394051d0,
     &19.11589241d0,19.14629364d0,19.17726517d0,19.20672798d0,
     &19.23794556d0,19.26642227d0,19.29916763d0,19.33388710d0,
     &19.36950493d0,19.40918541d0,19.44026184d0,19.47911644d0,
     &19.51283264d0,19.54421997d0,19.56831551d0,19.60076141d0,
     &19.63001633d0,19.65996361d0,19.69113922d0,19.72152328d0,
     &19.75580597d0,19.79080582d0,19.82374573d0,19.85544395d0,
     &19.89150620d0,19.91956520d0,19.94567490d0,19.97706223d0,
     &20.00385475d0,20.03510094d0,20.07267380d0,20.10876465d0,
     &20.13778496d0,20.16789436d0,20.20291710d0,20.23988724d0,
     &20.27258873d0,20.31222725d0,20.34301758d0,20.38037109d0,
     &20.41474152d0,20.45443916d0,20.48822021d0,20.51602936d0,
     &20.54655647d0,20.58605957d0,20.62236786d0,20.65839767d0,
     &20.68915367d0,20.72143936d0,20.75392723d0,20.78845596d0,
     &20.82732964d0,20.86281776d0,20.89857674d0,20.93645287d0,
     &20.97394943d0,21.00667000d0,21.04911041d0,21.08721352d0,
     &21.12108612d0,21.15989685d0,21.19666100d0,21.23170853d0,
     &21.26639366d0,21.29785919d0,21.33276367d0,21.36252594d0,
     &21.39328957d0,21.42765236d0,21.46512413d0,21.50652313d0,
     &21.53483009d0,21.56792450d0,21.60631943d0,21.64343643d0,
     &21.67667389d0,21.71165848d0,21.74705505d0,21.78416824d0,
     &21.82104301d0,21.83743477d0,21.86629677d0,21.90496445d0,
     &21.93879318d0,21.96649933d0,21.99698067d0,22.02694130d0,
     &22.05645180d0,22.09985733d0,22.12864494d0,22.16262627d0,
     &22.19773865d0,22.23648071d0,22.26719284d0,22.30471802d0,
     &22.34601402d0,22.38518333d0,22.42802238d0,22.46864700d0,
     &22.50640869d0,22.55332184d0,22.59746552d0,22.63927650d0,
     &22.68194199d0,22.72433472d0,22.75136948d0,22.78937149d0,
     &22.82475090d0,22.86337852d0,22.90345764d0,22.93358231d0,
     &22.96828842d0,23.00801277d0,23.04167938d0,23.07510376d0,
     &23.11260605d0,23.15876389d0,23.18964767d0,23.22929955d0,
     &23.25989914d0,23.28643036d0,23.32840919d0,23.37002373d0,
     &23.40486336d0,23.43993568d0,23.48116112d0,23.51247215d0,
     &23.54611206d0,23.58650398d0,23.62821579d0,23.66742706d0,
     &23.71269608d0,23.75093079d0,23.78448677d0,23.81665230d0,
     &23.85870934d0,23.88667679d0,23.92185974d0,23.96430588d0,
     &24.00726509d0,24.03734016d0,24.08260536d0,24.12708473d0,
     &24.16839218d0,24.21451378d0,24.26154900d0,24.05013466d0,
     &23.63356400d0,23.09206009d0,22.45724487d0,21.73422241d0,
     &20.94975281d0,20.10668564d0,19.21544075d0,18.28005219d0,
     &17.31022072d0,16.30143929d0,15.51558399d0,14.91301441d0,
     &14.40811157d0,13.96457195d0,13.58548355d0,13.25007248d0,
     &12.93951511d0,12.65818596d0,12.40282726d0,12.15828133d0,
     &11.93737602d0,11.72842598d0,11.53432083d0,11.34799576d0,
     &11.17098522d0,11.00067806d0,10.83781624d0,10.68614101d0,
     &10.53779030d0,10.39565182d0,10.26107788d0,10.12765121d0,
     &10.00175953d0, 9.87901974d0, 9.76201057d0, 9.64774036d0,
     & 9.53779030d0, 9.43270111d0, 9.32824802d0, 9.22803116d0,
     & 9.13122272d0, 9.03670692d0, 8.94535446d0, 8.85627842d0,
     & 8.76793957d0, 8.68352985d0, 8.60218048d0, 8.52183342d0,
     & 8.44260883d0, 8.36584091d0, 8.29134750d0, 8.21932793d0,
     & 8.14780807d0, 8.07822704d0, 8.01034260d0, 7.94390154d0,
     & 7.87824297d0, 7.81373930d0, 7.75190735d0, 7.69144392d0,
     & 7.63220501d0, 7.57389307d0, 7.51547813d0, 7.45851183d0,
     & 7.40286446d0, 7.34856510d0, 7.29569387d0, 7.24450111d0,
     & 7.19394064d0, 7.14331341d0, 7.09376955d0, 7.04522800d0,
     & 6.99765968d0, 6.95100641d0, 6.90520287d0, 6.86024857d0,
     & 6.81607676d0, 6.77250767d0, 6.72918367d0, 6.68726158d0,
     & 6.64607954d0, 6.60561943d0, 6.56588650d0, 6.52684116d0,
     & 6.48841953d0, 6.45061445d0, 6.41339779d0, 6.37669659d0,
     & 6.34050465d0, 6.30471039d0, 6.26898241d0, 6.23388720d0,
     & 6.19938660d0, 6.16543579d0, 6.13207436d0, 6.09934998d0,
     & 6.06720686d0, 6.03562069d0, 6.00468063d0, 5.97453690d0,
     & 5.94484043d0, 5.91554260d0, 5.88664818d0, 5.85819864d0,
     & 5.83013248d0, 5.80246353d0, 5.77509689d0, 5.74809837d0,
     & 5.72142982d0, 5.69505262d0, 5.66871595d0, 5.64276695d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0,
     & 5.61720562d0, 5.61720562d0, 5.61720562d0, 5.61720562d0
     &/
c Definition of open field lines as Lupper=f(Iupper) for doy=091
      DATA (Lupper ( 4,I), I= 1, 1001) /
     & 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0,
     & 8.57d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.56d0, 8.56d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0,
     & 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0,
     & 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0,
     & 8.58d0, 8.58d0, 8.58d0, 8.58d0, 8.58d0, 8.58d0, 8.58d0, 8.58d0,
     & 8.58d0, 8.58d0, 8.58d0, 8.58d0, 8.58d0, 8.58d0, 8.58d0, 8.58d0,
     & 8.58d0, 8.58d0, 8.59d0, 8.59d0, 8.59d0, 8.59d0, 8.59d0, 8.59d0,
     & 8.59d0, 8.59d0, 8.59d0, 8.59d0, 8.59d0, 8.59d0, 8.59d0, 8.59d0,
     & 8.60d0, 8.60d0, 8.60d0, 8.60d0, 8.60d0, 8.60d0, 8.60d0, 8.60d0,
     & 8.60d0, 8.60d0, 8.60d0, 8.61d0, 8.61d0, 8.61d0, 8.61d0, 8.61d0,
     & 8.61d0, 8.61d0, 8.61d0, 8.61d0, 8.61d0, 8.61d0, 8.62d0, 8.62d0,
     & 8.62d0, 8.62d0, 8.62d0, 8.62d0, 8.62d0, 8.63d0, 8.63d0, 8.63d0,
     & 8.63d0, 8.63d0, 8.63d0, 8.63d0, 8.63d0, 8.64d0, 8.64d0, 8.64d0,
     & 8.64d0, 8.64d0, 8.64d0, 8.64d0, 8.64d0, 8.65d0, 8.65d0, 8.65d0,
     & 8.65d0, 8.65d0, 8.66d0, 8.66d0, 8.66d0, 8.66d0, 8.66d0, 8.67d0,
     & 8.67d0, 8.67d0, 8.67d0, 8.67d0, 8.68d0, 8.68d0, 8.68d0, 8.68d0,
     & 8.68d0, 8.69d0, 8.69d0, 8.69d0, 8.69d0, 8.70d0, 8.70d0, 8.70d0,
     & 8.70d0, 8.70d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.72d0, 8.72d0,
     & 8.72d0, 8.73d0, 8.73d0, 8.73d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0,
     & 8.74d0, 8.75d0, 8.75d0, 8.76d0, 8.76d0, 8.76d0, 8.77d0, 8.77d0,
     & 8.78d0, 8.78d0, 8.78d0, 8.79d0, 8.79d0, 8.79d0, 8.80d0, 8.80d0,
     & 8.81d0, 8.81d0, 8.82d0, 8.82d0, 8.82d0, 8.83d0, 8.83d0, 8.84d0,
     & 8.84d0, 8.85d0, 8.85d0, 8.86d0, 8.87d0, 8.88d0, 8.89d0, 8.90d0,
     & 8.91d0, 8.92d0, 8.93d0, 8.94d0, 8.95d0, 8.96d0, 8.97d0, 8.99d0,
     & 9.00d0, 9.01d0, 9.02d0, 9.03d0, 9.05d0, 9.06d0, 9.07d0, 9.09d0,
     & 9.10d0, 9.11d0, 9.13d0, 9.14d0, 9.15d0, 9.17d0, 9.18d0, 9.19d0,
     & 9.21d0, 9.22d0, 9.24d0, 9.25d0, 9.27d0, 9.28d0, 9.30d0, 9.31d0,
     & 9.33d0, 9.34d0, 9.36d0, 9.37d0, 9.39d0, 9.41d0, 9.42d0, 9.44d0,
     & 9.46d0, 9.47d0, 9.49d0, 9.51d0, 9.52d0, 9.54d0, 9.56d0, 9.58d0,
     & 9.59d0, 9.61d0, 9.63d0, 9.64d0, 9.66d0, 9.68d0, 9.69d0, 9.71d0,
     & 9.73d0, 9.75d0, 9.76d0, 9.78d0, 9.80d0, 9.81d0, 9.83d0, 9.85d0,
     & 9.86d0, 9.88d0, 9.90d0, 9.92d0, 9.93d0, 9.95d0, 9.97d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     & 9.99d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,
     & 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     &10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     &10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0,
     & 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0
     &/
      DATA (Iupper ( 4,I), I= 1, 1001) /
     & 0.00010000d0, 0.00010127d0, 0.00010255d0, 0.00010386d0,
     & 0.00010517d0, 0.00010651d0, 0.00010786d0, 0.00010923d0,
     & 0.00011062d0, 0.00011202d0, 0.00011344d0, 0.00011488d0,
     & 0.00011634d0, 0.00011782d0, 0.00011931d0, 0.00012083d0,
     & 0.00012236d0, 0.00012391d0, 0.00012548d0, 0.00012708d0,
     & 0.00012869d0, 0.00013032d0, 0.00013198d0, 0.00013365d0,
     & 0.00013535d0, 0.00013707d0, 0.00013881d0, 0.00014057d0,
     & 0.00014235d0, 0.00014416d0, 0.00014599d0, 0.00014784d0,
     & 0.00014972d0, 0.00015162d0, 0.00015354d0, 0.00015549d0,
     & 0.00015746d0, 0.00015946d0, 0.00016148d0, 0.00016353d0,
     & 0.00016561d0, 0.00016771d0, 0.00016984d0, 0.00017200d0,
     & 0.00017418d0, 0.00017639d0, 0.00017863d0, 0.00018089d0,
     & 0.00018319d0, 0.00018551d0, 0.00018787d0, 0.00019025d0,
     & 0.00019267d0, 0.00019511d0, 0.00019759d0, 0.00020010d0,
     & 0.00020264d0, 0.00020521d0, 0.00020781d0, 0.00021045d0,
     & 0.00021312d0, 0.00021583d0, 0.00021857d0, 0.00022134d0,
     & 0.00022415d0, 0.00022699d0, 0.00022987d0, 0.00023279d0,
     & 0.00023575d0, 0.00023874d0, 0.00024177d0, 0.00024484d0,
     & 0.00024794d0, 0.00025109d0, 0.00025428d0, 0.00025750d0,
     & 0.00026077d0, 0.00026408d0, 0.00026743d0, 0.00027083d0,
     & 0.00027426d0, 0.00027775d0, 0.00028127d0, 0.00028484d0,
     & 0.00028846d0, 0.00029212d0, 0.00029582d0, 0.00029958d0,
     & 0.00030338d0, 0.00030723d0, 0.00031113d0, 0.00031508d0,
     & 0.00031908d0, 0.00032313d0, 0.00032723d0, 0.00033138d0,
     & 0.00033559d0, 0.00033984d0, 0.00034416d0, 0.00034853d0,
     & 0.00035295d0, 0.00035743d0, 0.00036196d0, 0.00036656d0,
     & 0.00037121d0, 0.00037592d0, 0.00038069d0, 0.00038552d0,
     & 0.00039042d0, 0.00039537d0, 0.00040039d0, 0.00040547d0,
     & 0.00041062d0, 0.00041583d0, 0.00042111d0, 0.00042645d0,
     & 0.00043186d0, 0.00043734d0, 0.00044289d0, 0.00044852d0,
     & 0.00045421d0, 0.00045997d0, 0.00046581d0, 0.00047172d0,
     & 0.00047771d0, 0.00048377d0, 0.00048991d0, 0.00049613d0,
     & 0.00050243d0, 0.00050880d0, 0.00051526d0, 0.00052180d0,
     & 0.00052842d0, 0.00053513d0, 0.00054192d0, 0.00054880d0,
     & 0.00055576d0, 0.00056281d0, 0.00056996d0, 0.00057719d0,
     & 0.00058452d0, 0.00059194d0, 0.00059945d0, 0.00060706d0,
     & 0.00061476d0, 0.00062256d0, 0.00063046d0, 0.00063846d0,
     & 0.00064657d0, 0.00065477d0, 0.00066308d0, 0.00067150d0,
     & 0.00068002d0, 0.00068865d0, 0.00069739d0, 0.00070624d0,
     & 0.00071521d0, 0.00072428d0, 0.00073347d0, 0.00074278d0,
     & 0.00075221d0, 0.00076176d0, 0.00077142d0, 0.00078122d0,
     & 0.00079113d0, 0.00080117d0, 0.00081134d0, 0.00082164d0,
     & 0.00083206d0, 0.00084262d0, 0.00085332d0, 0.00086415d0,
     & 0.00087511d0, 0.00088622d0, 0.00089747d0, 0.00090886d0,
     & 0.00092039d0, 0.00093207d0, 0.00094390d0, 0.00095588d0,
     & 0.00096801d0, 0.00098030d0, 0.00099274d0, 0.00100534d0,
     & 0.00101810d0, 0.00103102d0, 0.00104411d0, 0.00105736d0,
     & 0.00107078d0, 0.00108437d0, 0.00109813d0, 0.00111206d0,
     & 0.00112618d0, 0.00114047d0, 0.00115495d0, 0.00116960d0,
     & 0.00118445d0, 0.00119948d0, 0.00121470d0, 0.00123012d0,
     & 0.00124573d0, 0.00126154d0, 0.00127755d0, 0.00129377d0,
     & 0.00131019d0, 0.00132681d0, 0.00134365d0, 0.00136071d0,
     & 0.00137797d0, 0.00139546d0, 0.00141317d0, 0.00143111d0,
     & 0.00144927d0, 0.00146766d0, 0.00148629d0, 0.00150515d0,
     & 0.00152426d0, 0.00154360d0, 0.00156319d0, 0.00158303d0,
     & 0.00160312d0, 0.00162347d0, 0.00164407d0, 0.00166494d0,
     & 0.00168607d0, 0.00170747d0, 0.00172914d0, 0.00175108d0,
     & 0.00177331d0, 0.00179581d0, 0.00181860d0, 0.00184168d0,
     & 0.00186506d0, 0.00188873d0, 0.00191270d0, 0.00193697d0,
     & 0.00196156d0, 0.00198645d0, 0.00201166d0, 0.00203719d0,
     & 0.00206305d0, 0.00208923d0, 0.00211575d0, 0.00214260d0,
     & 0.00216979d0, 0.00219733d0, 0.00222521d0, 0.00225346d0,
     & 0.00228206d0, 0.00231102d0, 0.00234035d0, 0.00237005d0,
     & 0.00240013d0, 0.00243059d0, 0.00246144d0, 0.00249268d0,
     & 0.00252431d0, 0.00255635d0, 0.00258879d0, 0.00262165d0,
     & 0.00265492d0, 0.00268862d0, 0.00272274d0, 0.00275729d0,
     & 0.00279229d0, 0.00282773d0, 0.00286361d0, 0.00289996d0,
     & 0.00293676d0, 0.00297403d0, 0.00301178d0, 0.00305000d0,
     & 0.00308871d0, 0.00312791d0, 0.00316761d0, 0.00320781d0,
     & 0.00324852d0, 0.00328975d0, 0.00333150d0, 0.00337378d0,
     & 0.00341660d0, 0.00345996d0, 0.00350387d0, 0.00354834d0,
     & 0.00359337d0, 0.00363898d0, 0.00368516d0, 0.00373193d0,
     & 0.00377930d0, 0.00382726d0, 0.00387583d0, 0.00392502d0,
     & 0.00397484d0, 0.00402528d0, 0.00407637d0, 0.00412811d0,
     & 0.00418050d0, 0.00423355d0, 0.00428728d0, 0.00434169d0,
     & 0.00439680d0, 0.00445260d0, 0.00450911d0, 0.00456633d0,
     & 0.00462429d0, 0.00468298d0, 0.00474241d0, 0.00480260d0,
     & 0.00486355d0, 0.00492528d0, 0.00498778d0, 0.00505109d0,
     & 0.00511519d0, 0.00518011d0, 0.00524585d0, 0.00531243d0,
     & 0.00537985d0, 0.00544813d0, 0.00551727d0, 0.00558730d0,
     & 0.00565821d0, 0.00573002d0, 0.00580274d0, 0.00587639d0,
     & 0.00595096d0, 0.00602649d0, 0.00610298d0, 0.00618043d0,
     & 0.00625887d0, 0.00633830d0, 0.00641874d0, 0.00650021d0,
     & 0.00658270d0, 0.00666625d0, 0.00675085d0, 0.00683653d0,
     & 0.00692329d0, 0.00701116d0, 0.00710014d0, 0.00719025d0,
     & 0.00728151d0, 0.00737392d0, 0.00746751d0, 0.00756228d0,
     & 0.00765826d0, 0.00775545d0, 0.00785387d0, 0.00795355d0,
     & 0.00805449d0, 0.00815672d0, 0.00826024d0, 0.00836507d0,
     & 0.00847124d0, 0.00857875d0, 0.00868762d0, 0.00879788d0,
     & 0.00890954d0, 0.00902261d0, 0.00913712d0, 0.00925308d0,
     & 0.00937052d0, 0.00948945d0, 0.00960988d0, 0.00973184d0,
     & 0.00985535d0, 0.00998043d0, 0.01010710d0, 0.01023537d0,
     & 0.01036527d0, 0.01049682d0, 0.01063004d0, 0.01076495d0,
     & 0.01090157d0, 0.01103993d0, 0.01118004d0, 0.01132193d0,
     & 0.01146563d0, 0.01161114d0, 0.01175850d0, 0.01190773d0,
     & 0.01205886d0, 0.01221190d0, 0.01236688d0, 0.01252384d0,
     & 0.01268278d0, 0.01284374d0, 0.01300676d0, 0.01317183d0,
     & 0.01333899d0, 0.01350829d0, 0.01367973d0, 0.01385334d0,
     & 0.01402915d0, 0.01420721d0, 0.01438751d0, 0.01457011d0,
     & 0.01475503d0, 0.01494229d0, 0.01513193d0, 0.01532398d0,
     & 0.01551846d0, 0.01571541d0, 0.01591486d0, 0.01611684d0,
     & 0.01632139d0, 0.01652853d0, 0.01673830d0, 0.01695073d0,
     & 0.01716586d0, 0.01738372d0, 0.01760434d0, 0.01782776d0,
     & 0.01805403d0, 0.01828315d0, 0.01851519d0, 0.01875018d0,
     & 0.01898814d0, 0.01922913d0, 0.01947318d0, 0.01972032d0,
     & 0.01997059d0, 0.02022405d0, 0.02048072d0, 0.02074065d0,
     & 0.02100387d0, 0.02127045d0, 0.02154040d0, 0.02181377d0,
     & 0.02209063d0, 0.02237098d0, 0.02265490d0, 0.02294243d0,
     & 0.02323360d0, 0.02352846d0, 0.02382708d0, 0.02412947d0,
     & 0.02443570d0, 0.02474584d0, 0.02505989d0, 0.02537793d0,
     & 0.02570002d0, 0.02602619d0, 0.02635649d0, 0.02669099d0,
     & 0.02702975d0, 0.02737279d0, 0.02772018d0, 0.02807200d0,
     & 0.02842827d0, 0.02878906d0, 0.02915444d0, 0.02952445d0,
     & 0.02989915d0, 0.03027862d0, 0.03066289d0, 0.03105204d0,
     & 0.03144613d0, 0.03184524d0, 0.03224939d0, 0.03265868d0,
     & 0.03307318d0, 0.03349292d0, 0.03391798d0, 0.03434846d0,
     & 0.03478439d0, 0.03522584d0, 0.03567292d0, 0.03612565d0,
     & 0.03658413d0, 0.03704845d0, 0.03751864d0, 0.03799480d0,
     & 0.03847702d0, 0.03896534d0, 0.03945986d0, 0.03996065d0,
     & 0.04046782d0, 0.04098141d0, 0.04150151d0, 0.04202824d0,
     & 0.04256163d0, 0.04310180d0, 0.04364883d0, 0.04420279d0,
     & 0.04476377d0, 0.04533191d0, 0.04590723d0, 0.04648984d0,
     & 0.04707986d0, 0.04767738d0, 0.04828247d0, 0.04889523d0,
     & 0.04951580d0, 0.05014421d0, 0.05078061d0, 0.05142510d0,
     & 0.05207775d0, 0.05273868d0, 0.05340803d0, 0.05408584d0,
     & 0.05477226d0, 0.05546741d0, 0.05617137d0, 0.05688425d0,
     & 0.05760621d0, 0.05833730d0, 0.05907768d0, 0.05982745d0,
     & 0.06058676d0, 0.06135568d0, 0.06213436d0, 0.06292295d0,
     & 0.06372152d0, 0.06453023d0, 0.06534923d0, 0.06617859d0,
     & 0.06701849d0, 0.06786907d0, 0.06873041d0, 0.06960268d0,
     & 0.07048602d0, 0.07138062d0, 0.07228653d0, 0.07320394d0,
     & 0.07413302d0, 0.07507385d0, 0.07602664d0, 0.07699155d0,
     & 0.07796867d0, 0.07895819d0, 0.07996030d0, 0.08097509d0,
     & 0.08200277d0, 0.08304353d0, 0.08409746d0, 0.08516476d0,
     & 0.08624565d0, 0.08734021d0, 0.08844867d0, 0.08957119d0,
     & 0.09070800d0, 0.09185920d0, 0.09302501d0, 0.09420566d0,
     & 0.09540125d0, 0.09661201d0, 0.09783818d0, 0.09907987d0,
     & 0.10033731d0, 0.10161077d0, 0.10290034d0, 0.10420627d0,
     & 0.10552878d0, 0.10686813d0, 0.10822441d0, 0.10959791d0,
     & 0.11098890d0, 0.11239749d0, 0.11382396d0, 0.11526857d0,
     & 0.11673148d0, 0.11821295d0, 0.11971328d0, 0.12123259d0,
     & 0.12277117d0, 0.12432936d0, 0.12590724d0, 0.12750517d0,
     & 0.12912343d0, 0.13076216d0, 0.13242172d0, 0.13410230d0,
     & 0.13580430d0, 0.13752782d0, 0.13927321d0, 0.14104085d0,
     & 0.14283082d0, 0.14464353d0, 0.14647931d0, 0.14833830d0,
     & 0.15022090d0, 0.15212746d0, 0.15405814d0, 0.15601335d0,
     & 0.15799335d0, 0.15999855d0, 0.16202913d0, 0.16408549d0,
     & 0.16616802d0, 0.16827691d0, 0.17041254d0, 0.17257537d0,
     & 0.17476557d0, 0.17698357d0, 0.17922980d0, 0.18150444d0,
     & 0.18380795d0, 0.18614081d0, 0.18850316d0, 0.19089550d0,
     & 0.19331829d0, 0.19577175d0, 0.19825633d0, 0.20077245d0,
     & 0.20332061d0, 0.20590100d0, 0.20851412d0, 0.21116054d0,
     & 0.21384043d0, 0.21655434d0, 0.21930277d0, 0.22208601d0,
     & 0.22490457d0, 0.22775897d0, 0.23064953d0, 0.23357674d0,
     & 0.23654114d0, 0.23954326d0, 0.24258336d0, 0.24566205d0,
     & 0.24877992d0, 0.25193724d0, 0.25513467d0, 0.25837275d0,
     & 0.26165181d0, 0.26497251d0, 0.26833546d0, 0.27174097d0,
     & 0.27518973d0, 0.27868235d0, 0.28221917d0, 0.28580090d0,
     & 0.28942820d0, 0.29310140d0, 0.29682124d0, 0.30058825d0,
     & 0.30440310d0, 0.30826664d0, 0.31217894d0, 0.31614089d0,
     & 0.32015309d0, 0.32421625d0, 0.32833093d0, 0.33249786d0,
     & 0.33671802d0, 0.34099138d0, 0.34531897d0, 0.34970152d0,
     & 0.35413966d0, 0.35863414d0, 0.36318600d0, 0.36779529d0,
     & 0.37246308d0, 0.37719008d0, 0.38197711d0, 0.38682488d0,
     & 0.39173418d0, 0.39670613d0, 0.40174085d0, 0.40683943d0,
     & 0.41200271d0, 0.41723153d0, 0.42252675d0, 0.42788953d0,
     & 0.43332002d0, 0.43881938d0, 0.44438851d0, 0.45002836d0,
     & 0.45573980d0, 0.46152416d0, 0.46738148d0, 0.47331312d0,
     & 0.47932005d0, 0.48540321d0, 0.49156362d0, 0.49780214d0,
     & 0.50412035d0, 0.51051831d0, 0.51699740d0, 0.52355874d0,
     & 0.53020334d0, 0.53693229d0, 0.54374713d0, 0.55064797d0,
     & 0.55763638d0, 0.56471354d0, 0.57188040d0, 0.57913828d0,
     & 0.58648884d0, 0.59393209d0, 0.60146987d0, 0.60910326d0,
     & 0.61683351d0, 0.62466192d0, 0.63258964d0, 0.64061862d0,
     & 0.64874887d0, 0.65698230d0, 0.66532022d0, 0.67376393d0,
     & 0.68231487d0, 0.69097501d0, 0.69974434d0, 0.70862496d0,
     & 0.71761823d0, 0.72672570d0, 0.73594880d0, 0.74528891d0,
     & 0.75474828d0, 0.76432699d0, 0.77402723d0, 0.78385061d0,
     & 0.79379863d0, 0.80387294d0, 0.81407589d0, 0.82440752d0,
     & 0.83487028d0, 0.84546578d0, 0.85619581d0, 0.86706197d0,
     & 0.87806606d0, 0.88921070d0, 0.90049589d0, 0.91192430d0,
     & 0.92349786d0, 0.93521816d0, 0.94708717d0, 0.95910788d0,
     & 0.97128016d0, 0.98360693d0, 0.99609011d0, 1.00873172d0,
     & 1.02153373d0, 1.03449929d0, 1.04762840d0, 1.06092405d0,
     & 1.07438850d0, 1.08802390d0, 1.10183227d0, 1.11581588d0,
     & 1.12997806d0, 1.14431894d0, 1.15884173d0, 1.17354894d0,
     & 1.18844259d0, 1.20352542d0, 1.21880090d0, 1.23426902d0,
     & 1.24993336d0, 1.26579666d0, 1.28186119d0, 1.29812956d0,
     & 1.31460571d0, 1.33128977d0, 1.34818542d0, 1.36529553d0,
     & 1.38262296d0, 1.40017009d0, 1.41794002d0, 1.43593681d0,
     & 1.45416057d0, 1.47261584d0, 1.49130499d0, 1.51023161d0,
     & 1.52939832d0, 1.54880977d0, 1.56846607d0, 1.58837199d0,
     & 1.60853028d0, 1.62894464d0, 1.64961791d0, 1.67055368d0,
     & 1.69175661d0, 1.71322715d0, 1.73497009d0, 1.75698900d0,
     & 1.77928746d0, 1.80186892d0, 1.82473862d0, 1.84789681d0,
     & 1.87134874d0, 1.89509857d0, 1.91914976d0, 1.94350624d0,
     & 1.96817160d0, 1.99315214d0, 2.01844788d0, 2.04406428d0,
     & 2.07000613d0, 2.09627700d0, 2.12288141d0, 2.14982557d0,
     & 2.17710948d0, 2.20473981d0, 2.23272061d0, 2.26105666d0,
     & 2.28975224d0, 2.31881428d0, 2.34824300d0, 2.37804508d0,
     & 2.40822554d0, 2.43878889d0, 2.46974015d0, 2.50108409d0,
     & 2.53282857d0, 2.56497312d0, 2.59752584d0, 2.63049173d0,
     & 2.66387582d0, 2.69768381d0, 2.73192358d0, 2.76659513d0,
     & 2.80170655d0, 2.83726382d0, 2.87327218d0, 2.90973759d0,
     & 2.94666839d0, 2.98406553d0, 3.02193713d0, 3.06028914d0,
     & 3.09912801d0, 3.13845992d0, 3.17829084d0, 3.21863031d0,
     & 3.25947881d0, 3.30084562d0, 3.34273744d0, 3.38516092d0,
     & 3.42812300d0, 3.47163343d0, 3.51569295d0, 3.56031132d0,
     & 3.60549593d0, 3.65125418d0, 3.69759321d0, 3.74452019d0,
     & 3.79204679d0, 3.84017253d0, 3.88890886d0, 3.93826389d0,
     & 3.98824549d0, 4.03886127d0, 4.09012318d0, 4.14203215d0,
     & 4.19460011d0, 4.24783468d0, 4.30174494d0, 4.35633945d0,
     & 4.41162682d0, 4.46762037d0, 4.52431965d0, 4.58173895d0,
     & 4.63988686d0, 4.69877291d0, 4.75840616d0, 4.81880093d0,
     & 4.87995768d0, 4.94189024d0, 5.00460863d0, 5.06812382d0,
     & 5.13244438d0, 5.19758654d0, 5.26355076d0, 5.33035135d0,
     & 5.39800024d0, 5.46650791d0, 5.53588486d0, 5.60614157d0,
     & 5.67729616d0, 5.74934816d0, 5.82231474d0, 5.89620686d0,
     & 5.97103739d0, 6.04681683d0, 6.12356472d0, 6.20128012d0,
     & 6.27998209d0, 6.35968304d0, 6.44039536d0, 6.52213240d0,
     & 6.60491228d0, 6.68873739d0, 6.77362537d0, 6.85959101d0,
     & 6.94664812d0, 7.03480911d0, 7.12408972d0, 7.21451092d0,
     & 7.30607176d0, 7.39879513d0, 7.49269533d0, 7.58778667d0,
     & 7.68408489d0, 7.78161287d0, 7.88037157d0, 7.98038340d0,
     & 8.08166409d0, 8.18422985d0, 8.28809834d0, 8.39328480d0,
     & 8.49981499d0, 8.60768700d0, 8.71692944d0, 8.82755852d0,
     & 8.93959141d0, 9.05304623d0, 9.16794872d0, 9.28430176d0,
     & 9.40213108d0, 9.52145576d0, 9.64229488d0, 9.76466751d0,
     & 9.88859367d0,10.01410198d0,10.14119339d0,10.26989746d0,
     &10.40023613d0,10.53222752d0,10.66589451d0,10.80126858d0,
     &10.93834972d0,11.07717133d0,11.21775436d0,11.36012173d0,
     &11.50429535d0,11.65031052d0,11.79816723d0,11.94790173d0,
     &12.09953499d0,12.25309372d0,12.40860081d0,12.56608105d0,
     &12.72557259d0,12.88707542d0,13.05062866d0,13.21625710d0,
     &13.38398838d0,13.55384827d0,13.72587585d0,13.90007496d0,
     &14.07648373d0,14.25513268d0,14.43604851d0,14.61925888d0,
     &14.80481052d0,14.99270153d0,15.18297768d0,15.37566853d0,
     &15.57080460d0,15.76841831d0,15.96853828d0,16.17121506d0,
     &16.37644768d0,16.58428574d0,16.79475975d0,17.00790787d0,
     &17.22375870d0,17.44236755d0,17.66373062d0,17.88790512d0,
     &18.11492538d0,18.34482765d0,18.57764626d0,18.81341934d0,
     &19.05220222d0,19.29399872d0,19.53886604d0,19.78683662d0,
     &20.03795815d0,20.29226303d0,20.54981613d0,20.81061935d0,
     &21.07473183d0,21.34219742d0,21.61305809d0,21.88735199d0,
     &22.16513062d0,22.44645500d0,22.73132896d0,23.01981735d0,
     &23.31196785d0,23.60782623d0,23.90743828d0,24.21087837d0,
     &24.51814270d0,24.82930946d0,25.14442444d0,25.46353912d0,
     &25.78670311d0,26.11399269d0,26.44541168d0,26.78103638d0,
     &27.12092209d0,27.46512032d0,27.81368637d0,28.16667747d0,
     &28.52417374d0,28.88618279d0,29.25278282d0,29.62404060d0,
     &30.00000572d0
     &/
c Definition of fits (4 deg polynomial) for doy=091
c A0=f(Lm) same for A1,A2,A3 and A4; to be used every where except Lm>7.5 and I> 1.
      DATA (Lm4 ( 4,I), I= 1,100) /
     & 1.10d0, 1.20d0, 1.30d0, 1.40d0, 1.50d0, 1.60d0, 1.70d0, 1.80d0,
     & 1.90d0, 2.00d0, 2.10d0, 2.20d0, 2.30d0, 2.40d0, 2.50d0, 2.60d0,
     & 2.70d0, 2.80d0, 2.90d0, 3.00d0, 3.10d0, 3.20d0, 3.30d0, 3.40d0,
     & 3.50d0, 3.60d0, 3.70d0, 3.80d0, 3.90d0, 4.00d0, 4.10d0, 4.20d0,
     & 4.30d0, 4.40d0, 4.50d0, 4.60d0, 4.70d0, 4.80d0, 4.90d0, 5.00d0,
     & 5.10d0, 5.20d0, 5.30d0, 5.40d0, 5.50d0, 5.60d0, 5.70d0, 5.80d0,
     & 5.90d0, 6.00d0, 6.10d0, 6.20d0, 6.30d0, 6.40d0, 6.50d0, 6.60d0,
     & 6.70d0, 6.80d0, 6.90d0, 7.00d0, 7.10d0, 7.20d0, 7.30d0, 7.40d0,
     & 7.50d0, 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0,
     & 8.30d0, 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0,
     & 9.10d0, 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0,
     & 9.90d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A0 ( 4,I), I= 1,100) /
     & 1.1011166488D+00, 1.2016141874D+00, 1.3021021506D+00,
     & 1.4016519690D+00, 1.5012063638D+00, 1.6003116602D+00,
     & 1.7000000477D+00, 1.8004836818D+00, 1.8990200901D+00,
     & 2.0005172661D+00, 2.0982493834D+00, 2.2002097772D+00,
     & 2.2970372522D+00, 2.3951476577D+00, 2.4878209477D+00,
     & 2.5835902827D+00, 2.6774407686D+00, 2.7740702058D+00,
     & 2.8655003463D+00, 2.9601785144D+00, 3.0510946747D+00,
     & 3.1433238665D+00, 3.2340687769D+00, 3.3231150404D+00,
     & 3.4129785770D+00, 3.5001373986D+00, 3.5901933244D+00,
     & 3.6759876442D+00, 3.7637885944D+00, 3.8489638823D+00,
     & 3.9367109582D+00, 4.0176292845D+00, 4.1040485860D+00,
     & 4.1855294439D+00, 4.2704717595D+00, 4.3484212696D+00,
     & 4.4312807090D+00, 4.5156760898D+00, 4.5993929113D+00,
     & 4.6747693559D+00, 4.7535094703D+00, 4.8383069428D+00,
     & 4.9133378788D+00, 5.0012101102D+00, 5.0793712553D+00,
     & 5.1575073602D+00, 5.2401601945D+00, 5.3190357754D+00,
     & 5.4026876100D+00, 5.4840666348D+00, 5.5630013650D+00,
     & 5.6458710968D+00, 5.7297659926D+00, 5.8126094682D+00,
     & 5.8949868424D+00, 5.9801691600D+00, 6.0641102864D+00,
     & 6.1495307565D+00, 6.2366997348D+00, 6.3242668723D+00,
     & 6.4136716268D+00, 6.5018871499D+00, 6.5935097627D+00,
     & 6.6852621733D+00, 6.7770143927D+00, 6.8724444688D+00,
     & 6.9753373422D+00, 7.0745804632D+00, 7.1768268352D+00,
     & 7.2825857623D+00, 7.4000872277D+00, 7.5309480757D+00,
     & 7.6844423129D+00, 7.8582261802D+00, 8.0403392960D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A1 ( 4,I), I= 1,100) /
     &-5.4277780473D-05, 1.7408693708D-04, 3.9973208029D-04,
     & 3.5317917474D-04, 4.5739467440D-04, 2.2359333835D-04,
     & 0.0000000000D+00, 3.3733054577D-04, 1.2214299185D-04,
     & 2.0299208940D-04, 6.7372859075D-04, 7.6826203246D-03,
     & 2.7181872044D-03, 4.7316311946D-03, 5.7057164587D-03,
     & 5.9312637735D-03, 8.9621260022D-03, 1.0413575358D-02,
     & 1.1240335766D-02, 1.1214218178D-02, 1.3843658204D-02,
     & 1.4135113935D-02, 1.4908608015D-02, 1.8818147205D-02,
     & 1.8246399869D-02, 2.0386913476D-02, 2.2420008548D-02,
     & 2.3997179270D-02, 2.5539438496D-02, 2.5193217595D-02,
     & 2.6287829161D-02, 2.8058776277D-02, 2.9412723087D-02,
     & 3.0890326999D-02, 3.2248020166D-02, 3.3005213820D-02,
     & 3.3800376296D-02, 3.4606421094D-02, 3.3588416185D-02,
     & 3.6615668772D-02, 3.7792259620D-02, 3.7292205328D-02,
     & 3.7287830743D-02, 3.6707045252D-02, 3.8477345199D-02,
     & 3.6551052934D-02, 3.7726311606D-02, 3.7771961610D-02,
     & 3.6378717457D-02, 3.6068838621D-02, 3.5135887399D-02,
     & 3.4028237710D-02, 3.2599586416D-02, 3.2043390514D-02,
     & 3.0862929107D-02, 2.8318842488D-02, 2.8247541176D-02,
     & 2.8113318269D-02, 2.3632866145D-02, 2.3149768107D-02,
     & 1.9746787123D-02, 1.6476930125D-02, 1.3579635086D-02,
     & 8.6955471141D-03, 4.4480803884D-03,-6.8888817632D-03,
     &-8.0946049526D-03,-2.5899684525D-02,-4.9007837770D-02,
     &-8.2136585049D-02,-1.1917725572D-01,-1.6479731854D-01,
     &-1.9545324820D-01,-1.9560474636D-01,-2.0244067218D-01,
     &-5.1664506097D-01,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A2 ( 4,I), I= 1,100) /
     &-4.5149158122D-07,-6.9763267237D-06, 1.2773743375D-05,
     & 1.2051461863D-05, 2.1955551062D-05, 9.4429665108D-06,
     & 0.0000000000D+00, 1.0204806434D-05,-9.6357430525D-06,
     &-1.3249320147D-04, 1.2466962596D-05, 3.2509272949D-03,
     & 1.5149828397D-04, 4.7266898626D-04, 7.3810111091D-04,
     & 9.7869938931D-04, 1.7700248310D-03, 1.8473256848D-03,
     & 2.5242343149D-03, 2.7353696522D-03, 3.3056065975D-03,
     & 3.4386049722D-03, 3.3539699056D-03, 4.6436153412D-03,
     & 4.2497912767D-03, 4.7980217528D-03, 5.5174522554D-03,
     & 5.4469312118D-03, 6.0046706656D-03, 6.5249086414D-03,
     & 5.7104932351D-03, 6.9789706097D-03, 6.5567696806D-03,
     & 6.9042090792D-03, 7.2236384078D-03, 7.9778254516D-03,
     & 8.9981033473D-03, 8.5018668801D-03, 7.8520266055D-03,
     & 9.1647604849D-03, 9.4091329101D-03, 8.6342206589D-03,
     & 1.0070744812D-02, 9.2972377591D-03, 8.6515433767D-03,
     & 9.4601694059D-03, 8.7275535397D-03, 9.4048621463D-03,
     & 8.8996687974D-03, 8.0729142516D-03, 8.7489222475D-03,
     & 8.7923843125D-03, 7.7510990368D-03, 6.8832523418D-03,
     & 8.1778867402D-03, 6.8908867686D-03, 6.5633235636D-03,
     & 6.5125521134D-03, 5.3480105899D-03, 4.5516423338D-03,
     & 3.8990406634D-03, 4.0793734881D-03, 2.6707069485D-03,
     & 2.2737701827D-03, 2.4644422070D-03,-1.7955163754D-03,
     &-1.0283059006D-04,-5.9752679929D-03,-1.0904640410D-02,
     &-1.9556689467D-02,-2.8903565348D-02,-4.5577505335D-02,
     &-6.1168929344D-02,-6.1877771387D-02,-6.7603952087D-02,
     &-1.1055831307D+00,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A3 ( 4,I), I= 1,100) /
     & 4.1006638116D-07,-9.0120390939D-07,-2.8493774448D-06,
     &-3.2454811080D-06,-4.2612589003D-06,-1.3202574945D-06,
     & 0.0000000000D+00,-3.2962913774D-06, 3.8177024819D-07,
     &-3.2664407413D-05,-7.7304051247D-06, 5.1680273369D-04,
     &-3.2829190412D-05,-2.9047580804D-05, 5.1293950037D-06,
     & 4.9317926076D-05, 1.3383556780D-04, 1.1200428685D-04,
     & 2.1924472724D-04, 2.9847599840D-04, 3.2828088410D-04,
     & 3.5803536466D-04, 3.1233168376D-04, 4.8910453885D-04,
     & 4.1234628872D-04, 4.8251305082D-04, 5.9110383746D-04,
     & 4.9284241093D-04, 6.0267562899D-04, 7.1392599585D-04,
     & 4.9697973622D-04, 7.0196770592D-04, 6.0355132310D-04,
     & 6.3101102806D-04, 6.5218753888D-04, 7.7467001691D-04,
     & 1.0270039996D-03, 8.7664627856D-04, 7.6434042745D-04,
     & 9.6488683378D-04, 9.6556818732D-04, 8.3252552670D-04,
     & 1.1498440200D-03, 9.8737513583D-04, 7.6210638482D-04,
     & 1.0029888878D-03, 8.2049314943D-04, 9.2383253950D-04,
     & 9.0596616220D-04, 7.1261965801D-04, 8.7320924577D-04,
     & 9.2255968716D-04, 7.8190842762D-04, 6.0157831914D-04,
     & 8.4623849698D-04, 6.9570064826D-04, 6.8134408726D-04,
     & 6.2243887564D-04, 5.0007883806D-04, 2.9672093085D-04,
     & 2.6114217160D-04, 5.0596311912D-04, 2.6144529896D-04,
     & 2.4835790009D-04, 4.7635727261D-04,-2.2768122907D-04,
     & 1.6072793098D-04,-7.3843895136D-04,-8.8589926907D-04,
     &-2.0031672878D-03,-2.9753150250D-03,-5.2238792584D-03,
     &-7.8286301603D-03,-8.0292005360D-03,-9.1124248629D-03,
     &-1.3573754137D+00,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A4 ( 4,I), I= 1,100) /
     &-3.0271770725D-08, 8.2042603152D-08,-1.6343862841D-07,
     &-2.3999221268D-07,-3.6907645289D-07,-1.3179933456D-07,
     & 0.0000000000D+00,-2.3611219920D-07, 2.0166486198D-07,
     &-2.0400422907D-06,-4.8856810109D-07, 2.7170724212D-05,
     &-2.8301800271D-06,-4.4178942985D-06,-2.5787881902D-06,
     &-3.2946745094D-07, 3.1432200297D-06, 9.2677228239D-07,
     & 5.9034426427D-06, 1.1962216210D-05, 1.1290427003D-05,
     & 1.3574658844D-05, 9.8611239780D-06, 1.8807521823D-05,
     & 1.4063473058D-05, 1.7659880006D-05, 2.3259538259D-05,
     & 1.4616757834D-05, 2.2009694698D-05, 2.8027317145D-05,
     & 1.4560291983D-05, 2.4657148540D-05, 1.9433462773D-05,
     & 1.9422111124D-05, 1.9646558669D-05, 2.5685606596D-05,
     & 4.2090004670D-05, 3.2283638098D-05, 2.5804056413D-05,
     & 3.6284551278D-05, 3.5280773017D-05, 2.8635981969D-05,
     & 4.6715524222D-05, 3.6752225550D-05, 2.1279819785D-05,
     & 3.7078661221D-05, 2.6439562393D-05, 3.0483059901D-05,
     & 3.2739975896D-05, 2.0456072679D-05, 2.9821064643D-05,
     & 3.3101231711D-05, 2.8646671539D-05, 1.8146323962D-05,
     & 2.9407844687D-05, 2.4718575085D-05, 2.6546295215D-05,
     & 2.0792235776D-05, 1.6399379057D-05, 2.7358570608D-06,
     & 3.3768303075D-06, 2.3962698889D-05, 1.0672494494D-05,
     & 9.3718627445D-06, 2.7634596960D-05,-1.0863797811D-05,
     & 1.1597813885D-05,-3.5937283157D-05,-1.7944684366D-05,
     &-7.4653710271D-05,-1.1002212468D-04,-2.1114113891D-04,
     &-3.4980733718D-04,-3.6586790428D-04,-4.2319356447D-04,
     &-6.1937611817D-01,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of fits (5 deg polynomial) for doy=091
c A50=f(Lm5) same for A51,A52,A53, A54 and A55
c To be used only where Lm>7.5 and I> 1.
      DATA (Lm5 ( 4,I), I= 1,100) /
     & 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0, 8.30d0,
     & 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0, 9.10d0,
     & 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0, 9.90d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A50 ( 4,I), I= 1,100) /
     & 6.8730408368D+00, 6.9736971299D+00, 7.0747507810D+00,
     & 7.1801736972D+00, 7.2933143033D+00, 7.4108092325D+00,
     & 7.5337670560D+00, 7.6691017657D+00, 7.8150118682D+00,
     & 8.0032727797D+00, 8.1975565019D+00, 8.4329447752D+00,
     & 9.0348306324D+00, 8.8441625073D+00, 9.2402878579D+00,
     & 9.7527022500D+00, 9.8508897187D+00, 1.0375184588D+01,
     & 9.9281953932D+00, 1.1062189753D+01, 1.2725932340D+01,
     & 1.2004420809D+01, 1.7199117312D+01, 2.4992621393D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A51 ( 4,I), I= 1,100) /
     & 3.2767802020D-03,-7.8137615895D-03,-3.4745652544D-03,
     &-3.2897255416D-02,-4.6839467938D-02,-1.0029499606D-01,
     &-1.1923069234D-01,-1.5935158214D-01,-2.0645503770D-01,
     &-4.4281004453D-01,-4.8618440572D-01,-6.6792510430D-01,
     &-2.1697271308D+00,-8.9710061292D-01,-1.4004017317D+00,
     &-2.3047601972D+00,-1.9540257717D+00,-2.5172147055D+00,
     &-5.7816890226D-01,-2.7039226914D+00,-5.7914938328D+00,
     &-3.1818362328D+00,-1.3326327300D+01,-3.0173356609D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A52 ( 4,I), I= 1,100) /
     &-1.2460106397D-02,-1.5092729487D-02,-3.6055922976D-02,
     & 2.0244345707D-02,-2.3129249902D-02, 7.9643976451D-02,
     & 5.0141513271D-02, 4.9425275129D-02, 4.3420116999D-02,
     & 3.6185245277D-01, 1.7658019691D-01, 2.4014275805D-01,
     & 2.0954607039D+00, 3.8467255983D-01, 7.1731572971D-01,
     & 1.6360838345D+00, 1.1255906105D+00, 1.3383691972D+00,
     &-8.8596307488D-01, 9.8190951853D-01, 3.5167015268D+00,
     & 7.7065957360D-01, 8.7986236028D+00, 2.3707288639D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A53 ( 4,I), I= 1,100) /
     & 2.0489904332D-02, 2.6322707725D-02, 3.4176982077D-02,
     &-3.0066069078D-02, 3.6525253587D-02,-7.1069018841D-02,
     &-3.1823800474D-02,-1.9682126720D-02,-1.7264973288D-03,
     &-2.2681866361D-01,-1.0574880791D-02, 6.3454736433D-04,
     &-1.1206538445D+00,-1.0431008866D-01,-2.0086154489D-01,
     &-7.0461874150D-01,-4.3064270133D-01,-4.0738364945D-01,
     & 7.5332254612D-01,-9.8403009786D-02,-1.1703339704D+00,
     & 1.5045781487D-01,-2.9854897649D+00,-9.6018399513D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A54 ( 4,I), I= 1,100) /
     &-1.1581634061D-02,-1.4843438742D-02,-1.4552410286D-02,
     & 1.4945770652D-02,-1.8592506300D-02, 2.7588691845D-02,
     & 9.3324911749D-03, 4.2004182783D-03,-3.1292939197D-03,
     & 7.0377334519D-02,-1.5478573409D-02,-2.7784331489D-02,
     & 2.9559438967D-01, 1.4257682497D-02, 2.1187816689D-02,
     & 1.5980829060D-01, 9.4771862599D-02, 6.2968159708D-02,
     &-2.2528303560D-01,-3.0051827726D-02, 2.0023091801D-01,
     &-1.0202275623D-01, 4.9844159660D-01, 1.9624687009D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A55 ( 4,I), I= 1,100) /
     & 2.1690480434D-03, 2.7177466026D-03, 2.3349197284D-03,
     &-2.2554834127D-03, 3.2050048237D-03,-3.6119953236D-03,
     &-6.5621544688D-04,-9.4286200604D-05, 8.8733212410D-04,
     &-7.9145848062D-03, 3.5685184561D-03, 5.6778851414D-03,
     &-2.9889410224D-02,-2.5967814077D-04, 7.3944607719D-04,
     &-1.4172409157D-02,-8.4691569818D-03,-3.2210309225D-03,
     & 2.4496776763D-02, 6.7859624935D-03,-1.3199116143D-02,
     & 1.3556169327D-02,-3.1313036088D-02,-1.6012687782D-01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of Loss cone as Lmax=f(Imax) for doy=121
      DATA (Lmax ( 5,I), I= 1, 2100) /
     & 1.0854d0, 1.0865d0, 1.0875d0, 1.0885d0, 1.0895d0, 1.0905d0,
     & 1.0914d0, 1.0924d0, 1.0934d0, 1.0944d0, 1.0954d0, 1.0964d0,
     & 1.0974d0, 1.0984d0, 1.0994d0, 1.1004d0, 1.1014d0, 1.1024d0,
     & 1.1034d0, 1.1044d0, 1.1055d0, 1.1065d0, 1.1075d0, 1.1085d0,
     & 1.1095d0, 1.1105d0, 1.1116d0, 1.1126d0, 1.1136d0, 1.1146d0,
     & 1.1157d0, 1.1167d0, 1.1177d0, 1.1187d0, 1.1197d0, 1.1208d0,
     & 1.1218d0, 1.1228d0, 1.1238d0, 1.1249d0, 1.1259d0, 1.1269d0,
     & 1.1279d0, 1.1290d0, 1.1300d0, 1.1310d0, 1.1321d0, 1.1331d0,
     & 1.1341d0, 1.1351d0, 1.1362d0, 1.1372d0, 1.1382d0, 1.1393d0,
     & 1.1403d0, 1.1413d0, 1.1423d0, 1.1434d0, 1.1444d0, 1.1454d0,
     & 1.1465d0, 1.1475d0, 1.1485d0, 1.1495d0, 1.1506d0, 1.1516d0,
     & 1.1526d0, 1.1537d0, 1.1547d0, 1.1557d0, 1.1567d0, 1.1578d0,
     & 1.1588d0, 1.1598d0, 1.1608d0, 1.1619d0, 1.1629d0, 1.1639d0,
     & 1.1649d0, 1.1660d0, 1.1670d0, 1.1680d0, 1.1691d0, 1.1701d0,
     & 1.1711d0, 1.1722d0, 1.1732d0, 1.1742d0, 1.1752d0, 1.1763d0,
     & 1.1773d0, 1.1783d0, 1.1794d0, 1.1804d0, 1.1814d0, 1.1824d0,
     & 1.1834d0, 1.1845d0, 1.1855d0, 1.1866d0, 1.1876d0, 1.1886d0,
     & 1.1896d0, 1.1906d0, 1.1917d0, 1.1927d0, 1.1937d0, 1.1948d0,
     & 1.1958d0, 1.1968d0, 1.1978d0, 1.1989d0, 1.1999d0, 1.2009d0,
     & 1.2019d0, 1.2030d0, 1.2040d0, 1.2050d0, 1.2060d0, 1.2071d0,
     & 1.2081d0, 1.2091d0, 1.2102d0, 1.2112d0, 1.2122d0, 1.2132d0,
     & 1.2143d0, 1.2153d0, 1.2163d0, 1.2173d0, 1.2184d0, 1.2194d0,
     & 1.2204d0, 1.2214d0, 1.2225d0, 1.2235d0, 1.2245d0, 1.2255d0,
     & 1.2266d0, 1.2276d0, 1.2286d0, 1.2296d0, 1.2306d0, 1.2317d0,
     & 1.2327d0, 1.2337d0, 1.2347d0, 1.2358d0, 1.2368d0, 1.2378d0,
     & 1.2388d0, 1.2399d0, 1.2409d0, 1.2419d0, 1.2430d0, 1.2440d0,
     & 1.2450d0, 1.2460d0, 1.2470d0, 1.2481d0, 1.2491d0, 1.2501d0,
     & 1.2511d0, 1.2522d0, 1.2532d0, 1.2542d0, 1.2552d0, 1.2562d0,
     & 1.2573d0, 1.2583d0, 1.2593d0, 1.2604d0, 1.2614d0, 1.2624d0,
     & 1.2634d0, 1.2644d0, 1.2654d0, 1.2665d0, 1.2675d0, 1.2685d0,
     & 1.2696d0, 1.2706d0, 1.2716d0, 1.2726d0, 1.2736d0, 1.2746d0,
     & 1.2757d0, 1.2767d0, 1.2777d0, 1.2788d0, 1.2798d0, 1.2808d0,
     & 1.2818d0, 1.2828d0, 1.2838d0, 1.2849d0, 1.2859d0, 1.2869d0,
     & 1.2879d0, 1.2890d0, 1.2900d0, 1.2910d0, 1.2920d0, 1.2930d0,
     & 1.2941d0, 1.2951d0, 1.2961d0, 1.2971d0, 1.2982d0, 1.2992d0,
     & 1.3002d0, 1.3012d0, 1.3022d0, 1.3032d0, 1.3043d0, 1.3053d0,
     & 1.3063d0, 1.3073d0, 1.3083d0, 1.3094d0, 1.3104d0, 1.3114d0,
     & 1.3124d0, 1.3134d0, 1.3145d0, 1.3155d0, 1.3165d0, 1.3175d0,
     & 1.3185d0, 1.3196d0, 1.3206d0, 1.3216d0, 1.3226d0, 1.3236d0,
     & 1.3247d0, 1.3257d0, 1.3267d0, 1.3277d0, 1.3287d0, 1.3297d0,
     & 1.3308d0, 1.3318d0, 1.3328d0, 1.3338d0, 1.3348d0, 1.3359d0,
     & 1.3369d0, 1.3379d0, 1.3389d0, 1.3399d0, 1.3410d0, 1.3420d0,
     & 1.3430d0, 1.3440d0, 1.3450d0, 1.3460d0, 1.3471d0, 1.3481d0,
     & 1.3491d0, 1.3501d0, 1.3511d0, 1.3522d0, 1.3532d0, 1.3542d0,
     & 1.3552d0, 1.3562d0, 1.3572d0, 1.3582d0, 1.3593d0, 1.3603d0,
     & 1.3613d0, 1.3623d0, 1.3633d0, 1.3644d0, 1.3654d0, 1.3664d0,
     & 1.3674d0, 1.3684d0, 1.3694d0, 1.3704d0, 1.3715d0, 1.3725d0,
     & 1.3735d0, 1.3745d0, 1.3756d0, 1.3766d0, 1.3776d0, 1.3786d0,
     & 1.3796d0, 1.3806d0, 1.3816d0, 1.3826d0, 1.3837d0, 1.3847d0,
     & 1.3857d0, 1.3867d0, 1.3877d0, 1.3888d0, 1.3898d0, 1.3908d0,
     & 1.3918d0, 1.3928d0, 1.3938d0, 1.3948d0, 1.3958d0, 1.3969d0,
     & 1.3979d0, 1.3989d0, 1.3999d0, 1.4009d0, 1.4020d0, 1.4030d0,
     & 1.4040d0, 1.4050d0, 1.4060d0, 1.4070d0, 1.4080d0, 1.4090d0,
     & 1.4100d0, 1.4111d0, 1.4121d0, 1.4131d0, 1.4141d0, 1.4151d0,
     & 1.4162d0, 1.4172d0, 1.4182d0, 1.4192d0, 1.4201d0, 1.4212d0,
     & 1.4222d0, 1.4232d0, 1.4242d0, 1.4252d0, 1.4263d0, 1.4273d0,
     & 1.4283d0, 1.4293d0, 1.4304d0, 1.4314d0, 1.4324d0, 1.4333d0,
     & 1.4343d0, 1.4353d0, 1.4363d0, 1.4374d0, 1.4384d0, 1.4394d0,
     & 1.4404d0, 1.4414d0, 1.4425d0, 1.4435d0, 1.4445d0, 1.4455d0,
     & 1.4465d0, 1.4475d0, 1.4485d0, 1.4495d0, 1.4505d0, 1.4515d0,
     & 1.4525d0, 1.4535d0, 1.4546d0, 1.4556d0, 1.4566d0, 1.4576d0,
     & 1.4587d0, 1.4597d0, 1.4607d0, 1.4617d0, 1.4627d0, 1.4637d0,
     & 1.4647d0, 1.4657d0, 1.4667d0, 1.4677d0, 1.4687d0, 1.4697d0,
     & 1.4708d0, 1.4718d0, 1.4728d0, 1.4738d0, 1.4749d0, 1.4759d0,
     & 1.4769d0, 1.4779d0, 1.4789d0, 1.4799d0, 1.4809d0, 1.4818d0,
     & 1.4829d0, 1.4839d0, 1.4849d0, 1.4859d0, 1.4869d0, 1.4880d0,
     & 1.4890d0, 1.4900d0, 1.4910d0, 1.4921d0, 1.4931d0, 1.4941d0,
     & 1.4951d0, 1.4961d0, 1.4970d0, 1.4980d0, 1.4990d0, 1.5000d0,
     & 1.5010d0, 1.5021d0, 1.5031d0, 1.5041d0, 1.5051d0, 1.5061d0,
     & 1.5072d0, 1.5082d0, 1.5092d0, 1.5102d0, 1.5112d0, 1.5122d0,
     & 1.5132d0, 1.5142d0, 1.5152d0, 1.5162d0, 1.5172d0, 1.5182d0,
     & 1.5192d0, 1.5202d0, 1.5213d0, 1.5223d0, 1.5233d0, 1.5243d0,
     & 1.5254d0, 1.5264d0, 1.5274d0, 1.5284d0, 1.5294d0, 1.5304d0,
     & 1.5314d0, 1.5323d0, 1.5333d0, 1.5343d0, 1.5354d0, 1.5364d0,
     & 1.5374d0, 1.5384d0, 1.5394d0, 1.5405d0, 1.5415d0, 1.5425d0,
     & 1.5436d0, 1.5446d0, 1.5456d0, 1.5466d0, 1.5475d0, 1.5485d0,
     & 1.5495d0, 1.5505d0, 1.5515d0, 1.5525d0, 1.5535d0, 1.5545d0,
     & 1.5556d0, 1.5566d0, 1.5576d0, 1.5586d0, 1.5597d0, 1.5607d0,
     & 1.5617d0, 1.5627d0, 1.5637d0, 1.5647d0, 1.5657d0, 1.5667d0,
     & 1.5677d0, 1.5686d0, 1.5696d0, 1.5706d0, 1.5716d0, 1.5727d0,
     & 1.5737d0, 1.5747d0, 1.5757d0, 1.5768d0, 1.5778d0, 1.5788d0,
     & 1.5798d0, 1.5809d0, 1.5819d0, 1.5829d0, 1.5839d0, 1.5848d0,
     & 1.5858d0, 1.5868d0, 1.5878d0, 1.5888d0, 1.5898d0, 1.5908d0,
     & 1.5918d0, 1.5928d0, 1.5938d0, 1.5949d0, 1.5959d0, 1.5969d0,
     & 1.5980d0, 1.5990d0, 1.6000d0, 1.6010d0, 1.6020d0, 1.6030d0,
     & 1.6040d0, 1.6050d0, 1.6060d0, 1.6069d0, 1.6079d0, 1.6089d0,
     & 1.6099d0, 1.6109d0, 1.6120d0, 1.6130d0, 1.6140d0, 1.6150d0,
     & 1.6161d0, 1.6171d0, 1.6181d0, 1.6192d0, 1.6202d0, 1.6212d0,
     & 1.6222d0, 1.6231d0, 1.6241d0, 1.6251d0, 1.6261d0, 1.6271d0,
     & 1.6280d0, 1.6290d0, 1.6300d0, 1.6311d0, 1.6321d0, 1.6331d0,
     & 1.6341d0, 1.6352d0, 1.6362d0, 1.6372d0, 1.6383d0, 1.6393d0,
     & 1.6403d0, 1.6413d0, 1.6423d0, 1.6433d0, 1.6443d0, 1.6453d0,
     & 1.6462d0, 1.6472d0, 1.6482d0, 1.6492d0, 1.6502d0, 1.6512d0,
     & 1.6522d0, 1.6532d0, 1.6542d0, 1.6553d0, 1.6563d0, 1.6573d0,
     & 1.6584d0, 1.6594d0, 1.6604d0, 1.6614d0, 1.6624d0, 1.6634d0,
     & 1.6644d0, 1.6654d0, 1.6664d0, 1.6674d0, 1.6683d0, 1.6693d0,
     & 1.6703d0, 1.6713d0, 1.6723d0, 1.6733d0, 1.6743d0, 1.6753d0,
     & 1.6763d0, 1.6774d0, 1.6784d0, 1.6794d0, 1.6804d0, 1.6815d0,
     & 1.6825d0, 1.6835d0, 1.6845d0, 1.6855d0, 1.6865d0, 1.6875d0,
     & 1.6885d0, 1.6895d0, 1.6905d0, 1.6914d0, 1.6924d0, 1.6934d0,
     & 1.6944d0, 1.6954d0, 1.6964d0, 1.6974d0, 1.6984d0, 1.6995d0,
     & 1.7005d0, 1.7015d0, 1.7026d0, 1.7036d0, 1.7046d0, 1.7057d0,
     & 1.7067d0, 1.7077d0, 1.7087d0, 1.7097d0, 1.7106d0, 1.7116d0,
     & 1.7126d0, 1.7136d0, 1.7146d0, 1.7155d0, 1.7165d0, 1.7175d0,
     & 1.7185d0, 1.7195d0, 1.7205d0, 1.7215d0, 1.7226d0, 1.7236d0,
     & 1.7246d0, 1.7256d0, 1.7267d0, 1.7277d0, 1.7288d0, 1.7298d0,
     & 1.7308d0, 1.7318d0, 1.7328d0, 1.7338d0, 1.7347d0, 1.7357d0,
     & 1.7367d0, 1.7377d0, 1.7387d0, 1.7396d0, 1.7406d0, 1.7416d0,
     & 1.7426d0, 1.7436d0, 1.7446d0, 1.7456d0, 1.7467d0, 1.7477d0,
     & 1.7487d0, 1.7497d0, 1.7508d0, 1.7518d0, 1.7529d0, 1.7539d0,
     & 1.7549d0, 1.7559d0, 1.7569d0, 1.7579d0, 1.7588d0, 1.7598d0,
     & 1.7608d0, 1.7618d0, 1.7628d0, 1.7637d0, 1.7647d0, 1.7657d0,
     & 1.7667d0, 1.7677d0, 1.7687d0, 1.7697d0, 1.7707d0, 1.7718d0,
     & 1.7728d0, 1.7738d0, 1.7749d0, 1.7759d0, 1.7769d0, 1.7780d0,
     & 1.7790d0, 1.7800d0, 1.7810d0, 1.7820d0, 1.7830d0, 1.7839d0,
     & 1.7849d0, 1.7859d0, 1.7869d0, 1.7879d0, 1.7888d0, 1.7898d0,
     & 1.7908d0, 1.7918d0, 1.7928d0, 1.7938d0, 1.7948d0, 1.7958d0,
     & 1.7968d0, 1.7979d0, 1.7989d0, 1.8000d0, 1.8010d0, 1.8020d0,
     & 1.8031d0, 1.8041d0, 1.8051d0, 1.8061d0, 1.8071d0, 1.8081d0,
     & 1.8091d0, 1.8100d0, 1.8110d0, 1.8120d0, 1.8130d0, 1.8140d0,
     & 1.8149d0, 1.8159d0, 1.8169d0, 1.8179d0, 1.8189d0, 1.8199d0,
     & 1.8209d0, 1.8219d0, 1.8229d0, 1.8240d0, 1.8250d0, 1.8260d0,
     & 1.8271d0, 1.8281d0, 1.8292d0, 1.8302d0, 1.8312d0, 1.8322d0,
     & 1.8332d0, 1.8342d0, 1.8352d0, 1.8361d0, 1.8371d0, 1.8381d0,
     & 1.8391d0, 1.8401d0, 1.8410d0, 1.8420d0, 1.8430d0, 1.8440d0,
     & 1.8449d0, 1.8459d0, 1.8469d0, 1.8479d0, 1.8490d0, 1.8500d0,
     & 1.8510d0, 1.8520d0, 1.8531d0, 1.8541d0, 1.8552d0, 1.8562d0,
     & 1.8572d0, 1.8583d0, 1.8593d0, 1.8603d0, 1.8613d0, 1.8622d0,
     & 1.8632d0, 1.8642d0, 1.8652d0, 1.8662d0, 1.8672d0, 1.8681d0,
     & 1.8691d0, 1.8701d0, 1.8711d0, 1.8720d0, 1.8730d0, 1.8740d0,
     & 1.8750d0, 1.8760d0, 1.8770d0, 1.8780d0, 1.8791d0, 1.8801d0,
     & 1.8811d0, 1.8822d0, 1.8832d0, 1.8843d0, 1.8853d0, 1.8863d0,
     & 1.8873d0, 1.8883d0, 1.8893d0, 1.8903d0, 1.8913d0, 1.8923d0,
     & 1.8933d0, 1.8943d0, 1.8953d0, 1.8962d0, 1.8972d0, 1.8982d0,
     & 1.8992d0, 1.9001d0, 1.9011d0, 1.9021d0, 1.9031d0, 1.9041d0,
     & 1.9051d0, 1.9061d0, 1.9071d0, 1.9081d0, 1.9092d0, 1.9102d0,
     & 1.9112d0, 1.9123d0, 1.9133d0, 1.9144d0, 1.9154d0, 1.9164d0,
     & 1.9174d0, 1.9184d0, 1.9194d0, 1.9204d0, 1.9214d0, 1.9224d0,
     & 1.9234d0, 1.9243d0, 1.9253d0, 1.9263d0, 1.9273d0, 1.9282d0,
     & 1.9292d0, 1.9302d0, 1.9312d0, 1.9321d0, 1.9331d0, 1.9341d0,
     & 1.9351d0, 1.9362d0, 1.9372d0, 1.9382d0, 1.9392d0, 1.9403d0,
     & 1.9413d0, 1.9424d0, 1.9434d0, 1.9445d0, 1.9455d0, 1.9465d0,
     & 1.9475d0, 1.9485d0, 1.9495d0, 1.9505d0, 1.9515d0, 1.9525d0,
     & 1.9534d0, 1.9544d0, 1.9554d0, 1.9564d0, 1.9574d0, 1.9583d0,
     & 1.9593d0, 1.9603d0, 1.9612d0, 1.9622d0, 1.9632d0, 1.9642d0,
     & 1.9652d0, 1.9662d0, 1.9672d0, 1.9682d0, 1.9693d0, 1.9703d0,
     & 1.9714d0, 1.9724d0, 1.9735d0, 1.9745d0, 1.9755d0, 1.9765d0,
     & 1.9776d0, 1.9786d0, 1.9796d0, 1.9806d0, 1.9815d0, 1.9825d0,
     & 1.9835d0, 1.9845d0, 1.9855d0, 1.9865d0, 1.9875d0, 1.9884d0,
     & 1.9894d0, 1.9904d0, 1.9914d0, 1.9923d0, 1.9933d0, 1.9943d0,
     & 1.9953d0, 1.9962d0, 1.9972d0, 1.9982d0, 1.9992d0, 2.0003d0,
     & 2.0013d0, 2.0023d0, 2.0034d0, 2.0044d0, 2.0055d0, 2.0065d0,
     & 2.0076d0, 2.0086d0, 2.0096d0, 2.0106d0, 2.0116d0, 2.0126d0,
     & 2.0136d0, 2.0146d0, 2.0156d0, 2.0165d0, 2.0175d0, 2.0185d0,
     & 2.0195d0, 2.0205d0, 2.0215d0, 2.0224d0, 2.0234d0, 2.0244d0,
     & 2.0254d0, 2.0263d0, 2.0273d0, 2.0283d0, 2.0292d0, 2.0302d0,
     & 2.0313d0, 2.0323d0, 2.0333d0, 2.0344d0, 2.0354d0, 2.0364d0,
     & 2.0375d0, 2.0385d0, 2.0396d0, 2.0406d0, 2.0416d0, 2.0426d0,
     & 2.0436d0, 2.0446d0, 2.0456d0, 2.0466d0, 2.0476d0, 2.0486d0,
     & 2.0496d0, 2.0506d0, 2.0516d0, 2.0526d0, 2.0535d0, 2.0547d0,
     & 2.0558d0, 2.0567d0, 2.0577d0, 2.0587d0, 2.0597d0, 2.0606d0,
     & 2.0616d0, 2.0628d0, 2.0638d0, 2.0647d0, 2.0656d0, 2.0665d0,
     & 2.0675d0, 2.0685d0, 2.0696d0, 2.0706d0, 2.0717d0, 2.0727d0,
     & 2.0735d0, 2.0746d0, 2.0756d0, 2.0767d0, 2.0777d0, 2.0787d0,
     & 2.0797d0, 2.0808d0, 2.0818d0, 2.0828d0, 2.0838d0, 2.0847d0,
     & 2.0857d0, 2.0867d0, 2.0877d0, 2.0887d0, 2.0897d0, 2.0906d0,
     & 2.0915d0, 2.0925d0, 2.0934d0, 2.0945d0, 2.0955d0, 2.0965d0,
     & 2.0975d0, 2.0985d0, 2.0994d0, 2.1005d0, 2.1015d0, 2.1025d0,
     & 2.1036d0, 2.1046d0, 2.1056d0, 2.1066d0, 2.1076d0, 2.1086d0,
     & 2.1096d0, 2.1107d0, 2.1117d0, 2.1127d0, 2.1137d0, 2.1147d0,
     & 2.1157d0, 2.1166d0, 2.1176d0, 2.1186d0, 2.1196d0, 2.1206d0,
     & 2.1216d0, 2.1225d0, 2.1235d0, 2.1245d0, 2.1255d0, 2.1265d0,
     & 2.1274d0, 2.1284d0, 2.1294d0, 2.1304d0, 2.1314d0, 2.1323d0,
     & 2.1333d0, 2.1343d0, 2.1354d0, 2.1364d0, 2.1375d0, 2.1386d0,
     & 2.1396d0, 2.1407d0, 2.1417d0, 2.1428d0, 2.1438d0, 2.1449d0,
     & 2.1459d0, 2.1469d0, 2.1478d0, 2.1488d0, 2.1497d0, 2.1507d0,
     & 2.1517d0, 2.1528d0, 2.1538d0, 2.1548d0, 2.1558d0, 2.1568d0,
     & 2.1578d0, 2.1588d0, 2.1598d0, 2.1607d0, 2.1617d0, 2.1626d0,
     & 2.1636d0, 2.1645d0, 2.1654d0, 2.1664d0, 2.1674d0, 2.1684d0,
     & 2.1694d0, 2.1704d0, 2.1714d0, 2.1724d0, 2.1734d0, 2.1744d0,
     & 2.1754d0, 2.1765d0, 2.1775d0, 2.1784d0, 2.1795d0, 2.1805d0,
     & 2.1815d0, 2.1826d0, 2.1837d0, 2.1848d0, 2.1858d0, 2.1869d0,
     & 2.1879d0, 2.1889d0, 2.1899d0, 2.1909d0, 2.1919d0, 2.1928d0,
     & 2.1938d0, 2.1947d0, 2.1956d0, 2.1965d0, 2.1975d0, 2.1985d0,
     & 2.1995d0, 2.2005d0, 2.2015d0, 2.2025d0, 2.2036d0, 2.2046d0,
     & 2.2056d0, 2.2067d0, 2.2077d0, 2.2086d0, 2.2097d0, 2.2106d0,
     & 2.2116d0, 2.2126d0, 2.2135d0, 2.2145d0, 2.2155d0, 2.2165d0,
     & 2.2176d0, 2.2185d0, 2.2196d0, 2.2206d0, 2.2216d0, 2.2226d0,
     & 2.2236d0, 2.2246d0, 2.2256d0, 2.2266d0, 2.2275d0, 2.2285d0,
     & 2.2295d0, 2.2304d0, 2.2314d0, 2.2324d0, 2.2334d0, 2.2343d0,
     & 2.2353d0, 2.2363d0, 2.2373d0, 2.2383d0, 2.2393d0, 2.2404d0,
     & 2.2415d0, 2.2426d0, 2.2437d0, 2.2449d0, 2.2460d0, 2.2470d0,
     & 2.2479d0, 2.2489d0, 2.2499d0, 2.2509d0, 2.2518d0, 2.2526d0,
     & 2.2535d0, 2.2544d0, 2.2553d0, 2.2562d0, 2.2573d0, 2.2583d0,
     & 2.2594d0, 2.2604d0, 2.2614d0, 2.2625d0, 2.2634d0, 2.2645d0,
     & 2.2655d0, 2.2665d0, 2.2675d0, 2.2685d0, 2.2695d0, 2.2705d0,
     & 2.2715d0, 2.2732d0, 2.2759d0, 2.2793d0, 2.2835d0, 2.2886d0,
     & 2.2944d0, 2.3011d0, 2.3087d0, 2.3170d0, 2.3262d0, 2.3361d0,
     & 2.3461d0, 2.3560d0, 2.3660d0, 2.3760d0, 2.3859d0, 2.3958d0,
     & 2.4057d0, 2.4156d0, 2.4256d0, 2.4355d0, 2.4453d0, 2.4552d0,
     & 2.4652d0, 2.4751d0, 2.4850d0, 2.4949d0, 2.5048d0, 2.5148d0,
     & 2.5246d0, 2.5345d0, 2.5444d0, 2.5543d0, 2.5643d0, 2.5742d0,
     & 2.5841d0, 2.5939d0, 2.6039d0, 2.6138d0, 2.6237d0, 2.6336d0,
     & 2.6436d0, 2.6536d0, 2.6634d0, 2.6733d0, 2.6832d0, 2.6931d0,
     & 2.7030d0, 2.7129d0, 2.7228d0, 2.7327d0, 2.7426d0, 2.7525d0,
     & 2.7624d0, 2.7723d0, 2.7822d0, 2.7921d0, 2.8021d0, 2.8120d0,
     & 2.8219d0, 2.8318d0, 2.8417d0, 2.8515d0, 2.8614d0, 2.8713d0,
     & 2.8812d0, 2.8911d0, 2.9010d0, 2.9108d0, 2.9207d0, 2.9306d0,
     & 2.9404d0, 2.9503d0, 2.9602d0, 2.9700d0, 2.9799d0, 2.9898d0,
     & 2.9997d0, 3.0096d0, 3.0195d0, 3.0295d0, 3.0394d0, 3.0493d0,
     & 3.0592d0, 3.0691d0, 3.0790d0, 3.0889d0, 3.0988d0, 3.1086d0,
     & 3.1184d0, 3.1283d0, 3.1382d0, 3.1480d0, 3.1579d0, 3.1678d0,
     & 3.1777d0, 3.1875d0, 3.1974d0, 3.2072d0, 3.2171d0, 3.2270d0,
     & 3.2369d0, 3.2468d0, 3.2567d0, 3.2666d0, 3.2765d0, 3.2863d0,
     & 3.2961d0, 3.3060d0, 3.3160d0, 3.3259d0, 3.3358d0, 3.3457d0,
     & 3.3555d0, 3.3653d0, 3.3752d0, 3.3851d0, 3.3950d0, 3.4049d0,
     & 3.4148d0, 3.4246d0, 3.4344d0, 3.4442d0, 3.4541d0, 3.4640d0,
     & 3.4740d0, 3.4838d0, 3.4936d0, 3.5034d0, 3.5133d0, 3.5231d0,
     & 3.5329d0, 3.5429d0, 3.5527d0, 3.5625d0, 3.5724d0, 3.5822d0,
     & 3.5921d0, 3.6020d0, 3.6119d0, 3.6218d0, 3.6318d0, 3.6417d0,
     & 3.6514d0, 3.6612d0, 3.6711d0, 3.6810d0, 3.6908d0, 3.7007d0,
     & 3.7105d0, 3.7203d0, 3.7302d0, 3.7400d0, 3.7497d0, 3.7597d0,
     & 3.7696d0, 3.7795d0, 3.7893d0, 3.7992d0, 3.8090d0, 3.8188d0,
     & 3.8287d0, 3.8386d0, 3.8485d0, 3.8585d0, 3.8684d0, 3.8782d0,
     & 3.8881d0, 3.8980d0, 3.9078d0, 3.9177d0, 3.9276d0, 3.9374d0,
     & 3.9472d0, 3.9571d0, 3.9670d0, 3.9768d0, 3.9866d0, 3.9963d0,
     & 4.0062d0, 4.0160d0, 4.0258d0, 4.0356d0, 4.0456d0, 4.0554d0,
     & 4.0653d0, 4.0752d0, 4.0850d0, 4.0949d0, 4.1048d0, 4.1146d0,
     & 4.1245d0, 4.1343d0, 4.1442d0, 4.1540d0, 4.1639d0, 4.1738d0,
     & 4.1835d0, 4.1933d0, 4.2031d0, 4.2129d0, 4.2229d0, 4.2328d0,
     & 4.2426d0, 4.2525d0, 4.2624d0, 4.2722d0, 4.2821d0, 4.2920d0,
     & 4.3019d0, 4.3118d0, 4.3216d0, 4.3315d0, 4.3412d0, 4.3512d0,
     & 4.3611d0, 4.3710d0, 4.3809d0, 4.3908d0, 4.4007d0, 4.4106d0,
     & 4.4204d0, 4.4303d0, 4.4402d0, 4.4502d0, 4.4601d0, 4.4700d0,
     & 4.4799d0, 4.4898d0, 4.4997d0, 4.5097d0, 4.5196d0, 4.5296d0,
     & 4.5395d0, 4.5493d0, 4.5591d0, 4.5689d0, 4.5787d0, 4.5885d0,
     & 4.5984d0, 4.6083d0, 4.6182d0, 4.6282d0, 4.6381d0, 4.6481d0,
     & 4.6580d0, 4.6680d0, 4.6780d0, 4.6878d0, 4.6979d0, 4.7076d0,
     & 4.7176d0, 4.7275d0, 4.7374d0, 4.7473d0, 4.7572d0, 4.7672d0,
     & 4.7771d0, 4.7869d0, 4.7969d0, 4.8067d0, 4.8166d0, 4.8264d0,
     & 4.8362d0, 4.8461d0, 4.8561d0, 4.8661d0, 4.8761d0, 4.8861d0,
     & 4.8962d0, 4.9062d0, 4.9162d0, 4.9263d0, 4.9363d0, 4.9462d0,
     & 4.9560d0, 4.9659d0, 4.9759d0, 4.9858d0, 4.9958d0, 5.0058d0,
     & 5.0159d0, 5.0259d0, 5.0360d0, 5.0461d0, 5.0562d0, 5.0663d0,
     & 5.0761d0, 5.0860d0, 5.0958d0, 5.1058d0, 5.1158d0, 5.1258d0,
     & 5.1358d0, 5.1458d0, 5.1558d0, 5.1658d0, 5.1759d0, 5.1860d0,
     & 5.1960d0, 5.2061d0, 5.2161d0, 5.2259d0, 5.2358d0, 5.2457d0,
     & 5.2558d0, 5.2658d0, 5.2759d0, 5.2859d0, 5.2960d0, 5.3061d0,
     & 5.3162d0, 5.3262d0, 5.3363d0, 5.3465d0, 5.3565d0, 5.3665d0,
     & 5.3764d0, 5.3863d0, 5.3963d0, 5.4063d0, 5.4165d0, 5.4267d0,
     & 5.4369d0, 5.4470d0, 5.4571d0, 5.4673d0, 5.4774d0, 5.4876d0,
     & 5.4978d0, 5.5079d0, 5.5178d0, 5.5279d0, 5.5379d0, 5.5480d0,
     & 5.5582d0, 5.5681d0, 5.5783d0, 5.5885d0, 5.5987d0, 5.6090d0,
     & 5.6192d0, 5.6295d0, 5.6396d0, 5.6499d0, 5.6599d0, 5.6700d0,
     & 5.6803d0, 5.6903d0, 5.7005d0, 5.7104d0, 5.7206d0, 5.7306d0,
     & 5.7408d0, 5.7510d0, 5.7610d0, 5.7713d0, 5.7815d0, 5.7918d0,
     & 5.8020d0, 5.8122d0, 5.8226d0, 5.8329d0, 5.8433d0, 5.8535d0,
     & 5.8636d0, 5.8740d0, 5.8840d0, 5.8941d0, 5.9042d0, 5.9144d0,
     & 5.9245d0, 5.9346d0, 5.9449d0, 5.9551d0, 5.9654d0, 5.9758d0,
     & 5.9861d0, 5.9966d0, 6.0070d0, 6.0174d0, 6.0278d0, 6.0381d0,
     & 6.0484d0, 6.0586d0, 6.0687d0, 6.0788d0, 6.0890d0, 6.0992d0,
     & 6.1095d0, 6.1198d0, 6.1302d0, 6.1404d0, 6.1508d0, 6.1611d0,
     & 6.1714d0, 6.1819d0, 6.1924d0, 6.2029d0, 6.2134d0, 6.2237d0,
     & 6.2340d0, 6.2443d0, 6.2548d0, 6.2653d0, 6.2758d0, 6.2864d0,
     & 6.2967d0, 6.3070d0, 6.3172d0, 6.3275d0, 6.3380d0, 6.3484d0,
     & 6.3589d0, 6.3694d0, 6.3798d0, 6.3902d0, 6.4007d0, 6.4111d0,
     & 6.4217d0, 6.4323d0, 6.4429d0, 6.4534d0, 6.4639d0, 6.4744d0,
     & 6.4849d0, 6.4954d0, 6.5060d0, 6.5165d0, 6.5272d0, 6.5376d0,
     & 6.5480d0, 6.5584d0, 6.5688d0, 6.5792d0, 6.5898d0, 6.6002d0,
     & 6.6105d0, 6.6209d0, 6.6313d0, 6.6418d0, 6.6522d0, 6.6629d0,
     & 6.6735d0, 6.6842d0, 6.6949d0, 6.7055d0, 6.7160d0, 6.7268d0,
     & 6.7375d0, 6.7483d0, 6.7591d0, 6.7697d0, 6.7804d0, 6.7912d0,
     & 6.8018d0, 6.8123d0, 6.8228d0, 6.8336d0, 6.8443d0, 6.8550d0,
     & 6.8656d0, 6.8763d0, 6.8872d0, 6.8979d0, 6.9085d0, 6.9193d0,
     & 6.9300d0, 6.9407d0, 6.9514d0, 6.9621d0, 6.9728d0, 6.9835d0,
     & 6.9943d0, 7.0051d0, 7.0159d0, 7.0269d0, 7.0378d0, 7.0487d0,
     & 7.0598d0, 7.0708d0, 7.0818d0, 7.0926d0, 7.1033d0, 7.1142d0,
     & 7.1251d0, 7.1358d0, 7.1467d0, 7.1576d0, 7.1685d0, 7.1794d0,
     & 7.1901d0, 7.2010d0, 7.2121d0, 7.2233d0, 7.2342d0, 7.2450d0,
     & 7.2561d0, 7.2669d0, 7.2778d0, 7.2887d0, 7.2997d0, 7.3107d0,
     & 7.3216d0, 7.3325d0, 7.3436d0, 7.3546d0, 7.3656d0, 7.3767d0,
     & 7.3878d0, 7.3989d0, 7.4098d0, 7.4207d0, 7.4318d0, 7.4428d0,
     & 7.4539d0, 7.4650d0, 7.4759d0, 7.4869d0, 7.4979d0, 7.5089d0,
     & 7.5199d0, 7.5312d0, 7.5425d0, 7.5536d0, 7.5650d0, 7.5761d0,
     & 7.5873d0, 7.5986d0, 7.6100d0, 7.6211d0, 7.6324d0, 7.6439d0,
     & 7.6551d0, 7.6663d0, 7.6775d0, 7.6886d0, 7.6998d0, 7.7111d0,
     & 7.7224d0, 7.7337d0, 7.7453d0, 7.7568d0, 7.7680d0, 7.7793d0,
     & 7.7905d0, 7.8019d0, 7.8133d0, 7.8247d0, 7.8360d0, 7.8474d0,
     & 7.8588d0, 7.8702d0, 7.8815d0, 7.8932d0, 7.9049d0, 7.9167d0,
     & 7.9285d0, 7.9402d0, 7.9520d0, 7.9635d0, 7.9750d0, 7.9864d0,
     & 7.9978d0, 8.0094d0, 8.0209d0, 8.0324d0, 8.0438d0, 8.0552d0,
     & 8.0668d0, 8.0785d0, 8.0902d0, 8.1019d0, 8.1137d0, 8.1255d0,
     & 8.1372d0, 8.1488d0, 8.1604d0, 8.1722d0, 8.1842d0, 8.1958d0,
     & 8.2075d0, 8.2195d0, 8.2315d0, 8.2435d0, 8.2556d0, 8.2676d0,
     & 8.2798d0, 8.2916d0, 8.3036d0, 8.3153d0, 8.3274d0, 8.3391d0,
     & 8.3512d0, 8.3631d0, 8.3751d0, 8.3871d0, 8.3988d0, 8.4106d0,
     & 8.4227d0, 8.4347d0, 8.4468d0, 8.4588d0, 8.4709d0, 8.4831d0,
     & 8.4951d0, 8.5070d0, 8.5192d0, 8.5316d0, 8.5441d0, 8.5563d0,
     & 8.5684d0, 8.5808d0, 8.5930d0, 8.6054d0, 8.6174d0, 8.6298d0,
     & 8.6420d0, 8.6544d0, 8.6667d0, 8.6790d0, 8.6916d0, 8.7043d0,
     & 8.7165d0, 8.7289d0, 8.7415d0, 8.7540d0, 8.7663d0, 8.7789d0,
     & 8.7912d0, 8.8034d0, 8.8160d0, 8.8287d0, 8.8414d0, 8.8543d0,
     & 8.8671d0, 8.8799d0, 8.8926d0, 8.9055d0, 8.9183d0, 8.9313d0,
     & 8.9441d0, 8.9568d0, 8.9693d0, 8.9817d0, 8.9943d0, 9.0073d0,
     & 9.0201d0, 9.0330d0, 9.0459d0, 9.0588d0, 9.0717d0, 9.0850d0,
     & 9.0979d0, 9.1113d0, 9.1247d0, 9.1377d0, 9.1508d0, 9.1639d0,
     & 9.1769d0, 9.1904d0, 9.2037d0, 9.2170d0, 9.2304d0, 9.2438d0,
     & 9.2569d0, 9.2703d0, 9.2838d0, 9.2968d0, 9.3103d0, 9.3241d0,
     & 9.3374d0, 9.3510d0, 9.3643d0, 9.3777d0, 9.3911d0, 9.4047d0,
     & 9.4183d0, 9.4321d0, 9.4460d0, 9.4596d0, 9.4732d0, 9.4869d0,
     & 9.5006d0, 9.5144d0, 9.5283d0, 9.5423d0, 9.5561d0, 9.5699d0,
     & 9.5834d0, 9.5972d0, 9.6108d0, 9.6245d0, 9.6384d0, 9.6521d0,
     & 9.6661d0, 9.6802d0, 9.6944d0, 9.7082d0, 9.7223d0, 9.7368d0,
     & 9.7509d0, 9.7650d0, 9.7792d0, 9.7936d0, 9.8082d0, 9.8225d0,
     & 9.8368d0, 9.8513d0, 9.8661d0, 9.8801d0, 9.8943d0, 9.9088d0,
     & 9.9235d0, 9.9372d0, 9.9493d0, 9.9601d0, 9.9695d0, 9.9777d0,
     & 9.9845d0, 9.9899d0, 9.9945d0, 9.9977d0, 9.9995d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0
     &/
      DATA (Imax ( 5,I), I= 1, 1000) /
     & 0.00000345d0, 0.00002569d0, 0.00002569d0, 0.00004786d0,
     & 0.00011944d0, 0.00026063d0, 0.00051663d0, 0.00080842d0,
     & 0.00118735d0, 0.00171504d0, 0.00228352d0, 0.00297083d0,
     & 0.00377211d0, 0.00471880d0, 0.00574318d0, 0.00686747d0,
     & 0.00805619d0, 0.00926519d0, 0.01056036d0, 0.01194386d0,
     & 0.01332630d0, 0.01477293d0, 0.01628276d0, 0.01781849d0,
     & 0.01939896d0, 0.02100604d0, 0.02266312d0, 0.02435119d0,
     & 0.02604290d0, 0.02778682d0, 0.02954874d0, 0.03133509d0,
     & 0.03317761d0, 0.03500595d0, 0.03686118d0, 0.03873733d0,
     & 0.04065651d0, 0.04256143d0, 0.04447811d0, 0.04644573d0,
     & 0.04842850d0, 0.05039498d0, 0.05237508d0, 0.05439485d0,
     & 0.05642768d0, 0.05847663d0, 0.06051470d0, 0.06256198d0,
     & 0.06465098d0, 0.06674539d0, 0.06885180d0, 0.07095865d0,
     & 0.07307768d0, 0.07522132d0, 0.07735918d0, 0.07951353d0,
     & 0.08166539d0, 0.08382568d0, 0.08604420d0, 0.08823162d0,
     & 0.09042901d0, 0.09263474d0, 0.09484637d0, 0.09706465d0,
     & 0.09931894d0, 0.10156241d0, 0.10381190d0, 0.10606701d0,
     & 0.10834006d0, 0.11058075d0, 0.11287063d0, 0.11515781d0,
     & 0.11743572d0, 0.11973160d0, 0.12204454d0, 0.12430967d0,
     & 0.12664218d0, 0.12898210d0, 0.13131000d0, 0.13364002d0,
     & 0.13597102d0, 0.13827807d0, 0.14064778d0, 0.14303362d0,
     & 0.14542325d0, 0.14779823d0, 0.15017201d0, 0.15252310d0,
     & 0.15489103d0, 0.15730226d0, 0.15973511d0, 0.16216831d0,
     & 0.16458462d0, 0.16695194d0, 0.16932185d0, 0.17172696d0,
     & 0.17416432d0, 0.17662007d0, 0.17906073d0, 0.18148057d0,
     & 0.18387386d0, 0.18626502d0, 0.18868625d0, 0.19114569d0,
     & 0.19364335d0, 0.19613941d0, 0.19858104d0, 0.20100687d0,
     & 0.20341295d0, 0.20585403d0, 0.20835643d0, 0.21087985d0,
     & 0.21340182d0, 0.21589120d0, 0.21835823d0, 0.22080278d0,
     & 0.22322762d0, 0.22573268d0, 0.22826922d0, 0.23082367d0,
     & 0.23335823d0, 0.23584732d0, 0.23831195d0, 0.24075779d0,
     & 0.24322422d0, 0.24576414d0, 0.24831127d0, 0.25087732d0,
     & 0.25341737d0, 0.25592214d0, 0.25842327d0, 0.26092440d0,
     & 0.26340872d0, 0.26596263d0, 0.26854286d0, 0.27116132d0,
     & 0.27369824d0, 0.27624533d0, 0.27879038d0, 0.28127766d0,
     & 0.28376788d0, 0.28626105d0, 0.28884378d0, 0.29146650d0,
     & 0.29403669d0, 0.29659542d0, 0.29913163d0, 0.30165410d0,
     & 0.30417794d0, 0.30672365d0, 0.30932045d0, 0.31194338d0,
     & 0.31460452d0, 0.31719398d0, 0.31975779d0, 0.32232052d0,
     & 0.32488352d0, 0.32742718d0, 0.33001357d0, 0.33261642d0,
     & 0.33521864d0, 0.33785251d0, 0.34047565d0, 0.34307432d0,
     & 0.34565195d0, 0.34820968d0, 0.35079104d0, 0.35339689d0,
     & 0.35601458d0, 0.35864010d0, 0.36129349d0, 0.36394298d0,
     & 0.36652371d0, 0.36912590d0, 0.37172943d0, 0.37431335d0,
     & 0.37692091d0, 0.37951341d0, 0.38217676d0, 0.38482675d0,
     & 0.38746518d0, 0.39007851d0, 0.39269212d0, 0.39530674d0,
     & 0.39790148d0, 0.40049809d0, 0.40311790d0, 0.40576571d0,
     & 0.40843803d0, 0.41103911d0, 0.41366172d0, 0.41633049d0,
     & 0.41893345d0, 0.42153871d0, 0.42419061d0, 0.42682236d0,
     & 0.42945692d0, 0.43212384d0, 0.43479443d0, 0.43745708d0,
     & 0.44011787d0, 0.44277856d0, 0.44537130d0, 0.44803327d0,
     & 0.45067397d0, 0.45329440d0, 0.45596224d0, 0.45865431d0,
     & 0.46137577d0, 0.46408835d0, 0.46679869d0, 0.46946156d0,
     & 0.47214875d0, 0.47481406d0, 0.47745845d0, 0.48015094d0,
     & 0.48284557d0, 0.48547369d0, 0.48817492d0, 0.49079391d0,
     & 0.49348781d0, 0.49611172d0, 0.49880958d0, 0.50146323d0,
     & 0.50419003d0, 0.50689626d0, 0.50955886d0, 0.51222396d0,
     & 0.51491427d0, 0.51758194d0, 0.52035147d0, 0.52304792d0,
     & 0.52574533d0, 0.52842098d0, 0.53109854d0, 0.53377819d0,
     & 0.53645909d0, 0.53914142d0, 0.54182589d0, 0.54451221d0,
     & 0.54719627d0, 0.54983485d0, 0.55245245d0, 0.55517149d0,
     & 0.55786777d0, 0.56056547d0, 0.56321704d0, 0.56589496d0,
     & 0.56862295d0, 0.57135320d0, 0.57408518d0, 0.57677776d0,
     & 0.57948244d0, 0.58219105d0, 0.58494759d0, 0.58773208d0,
     & 0.59046996d0, 0.59321100d0, 0.59595531d0, 0.59867883d0,
     & 0.60140562d0, 0.60413522d0, 0.60682154d0, 0.60950881d0,
     & 0.61223531d0, 0.61495036d0, 0.61766946d0, 0.62044090d0,
     & 0.62323964d0, 0.62601572d0, 0.62871957d0, 0.63140088d0,
     & 0.63410836d0, 0.63684195d0, 0.63954639d0, 0.64225489d0,
     & 0.64489961d0, 0.64752650d0, 0.65033942d0, 0.65307879d0,
     & 0.65582085d0, 0.65861458d0, 0.66143513d0, 0.66420764d0,
     & 0.66695744d0, 0.66970932d0, 0.67240822d0, 0.67510390d0,
     & 0.67786312d0, 0.68045038d0, 0.68314838d0, 0.68585008d0,
     & 0.68866789d0, 0.69141275d0, 0.69418621d0, 0.69698834d0,
     & 0.69976842d0, 0.70255160d0, 0.70526540d0, 0.70790434d0,
     & 0.71062243d0, 0.71331084d0, 0.71603751d0, 0.71865827d0,
     & 0.72133523d0, 0.72401607d0, 0.72667480d0, 0.72941387d0,
     & 0.73215532d0, 0.73492378d0, 0.73766851d0, 0.74031997d0,
     & 0.74293953d0, 0.74551588d0, 0.74814087d0, 0.75078422d0,
     & 0.75343722d0, 0.75609678d0, 0.75868392d0, 0.76124871d0,
     & 0.76384318d0, 0.76646632d0, 0.76917017d0, 0.77187628d0,
     & 0.77453268d0, 0.77715808d0, 0.77970755d0, 0.78224301d0,
     & 0.78483623d0, 0.78745812d0, 0.79011917d0, 0.79278779d0,
     & 0.79543507d0, 0.79803586d0, 0.80064064d0, 0.80337965d0,
     & 0.80609572d0, 0.80881304d0, 0.81153286d0, 0.81418705d0,
     & 0.81680691d0, 0.81940997d0, 0.82200176d0, 0.82464111d0,
     & 0.82727593d0, 0.82992232d0, 0.83249754d0, 0.83507854d0,
     & 0.83771694d0, 0.84035933d0, 0.84300518d0, 0.84565401d0,
     & 0.84838319d0, 0.85108924d0, 0.85376930d0, 0.85642332d0,
     & 0.85903686d0, 0.86164093d0, 0.86422467d0, 0.86687267d0,
     & 0.86953437d0, 0.87217790d0, 0.87482917d0, 0.87743676d0,
     & 0.88007516d0, 0.88271743d0, 0.88533592d0, 0.88809067d0,
     & 0.89084733d0, 0.89356655d0, 0.89621812d0, 0.89885366d0,
     & 0.90150583d0, 0.90416741d0, 0.90685028d0, 0.90949076d0,
     & 0.91217142d0, 0.91488653d0, 0.91750032d0, 0.92011946d0,
     & 0.92276835d0, 0.92544794d0, 0.92810315d0, 0.93086952d0,
     & 0.93361986d0, 0.93626249d0, 0.93894398d0, 0.94158262d0,
     & 0.94421184d0, 0.94686252d0, 0.94955426d0, 0.95225990d0,
     & 0.95494992d0, 0.95767468d0, 0.96026915d0, 0.96286893d0,
     & 0.96552676d0, 0.96818841d0, 0.97085327d0, 0.97352111d0,
     & 0.97627121d0, 0.97897619d0, 0.98163730d0, 0.98428458d0,
     & 0.98692220d0, 0.98958009d0, 0.99222940d0, 0.99490690d0,
     & 0.99759847d0, 1.00029957d0, 1.00300789d0, 1.00561333d0,
     & 1.00822341d0, 1.01089239d0, 1.01356494d0, 1.01624072d0,
     & 1.01889169d0, 1.02154732d0, 1.02417183d0, 1.02677321d0,
     & 1.02947378d0, 1.03216660d0, 1.03482640d0, 1.03748703d0,
     & 1.04017401d0, 1.04287601d0, 1.04558849d0, 1.04833686d0,
     & 1.05109203d0, 1.05385363d0, 1.05662692d0, 1.05929422d0,
     & 1.06193697d0, 1.06458223d0, 1.06722510d0, 1.06986773d0,
     & 1.07246721d0, 1.07516575d0, 1.07785594d0, 1.08053899d0,
     & 1.08328009d0, 1.08598244d0, 1.08870041d0, 1.09145653d0,
     & 1.09424806d0, 1.09701705d0, 1.09976375d0, 1.10254240d0,
     & 1.10521507d0, 1.10789073d0, 1.11057055d0, 1.11316121d0,
     & 1.11578822d0, 1.11839759d0, 1.12099516d0, 1.12355590d0,
     & 1.12627530d0, 1.12898934d0, 1.13173997d0, 1.13444948d0,
     & 1.13717568d0, 1.13991153d0, 1.14268339d0, 1.14546168d0,
     & 1.14824545d0, 1.15103364d0, 1.15385330d0, 1.15651083d0,
     & 1.15911436d0, 1.16167891d0, 1.16433787d0, 1.16698015d0,
     & 1.16958284d0, 1.17217660d0, 1.17490220d0, 1.17745519d0,
     & 1.18000352d0, 1.18277788d0, 1.18553519d0, 1.18835950d0,
     & 1.19119298d0, 1.19397783d0, 1.19676745d0, 1.19958973d0,
     & 1.20241606d0, 1.20507848d0, 1.20788252d0, 1.21068943d0,
     & 1.21326911d0, 1.21589303d0, 1.21849906d0, 1.22109699d0,
     & 1.22368884d0, 1.22624767d0, 1.22880256d0, 1.23135400d0,
     & 1.23400819d0, 1.23683631d0, 1.23967659d0, 1.24252594d0,
     & 1.24538291d0, 1.24816549d0, 1.25095224d0, 1.25374353d0,
     & 1.25656688d0, 1.25936520d0, 1.26216686d0, 1.26489437d0,
     & 1.26747656d0, 1.27004671d0, 1.27260816d0, 1.27513444d0,
     & 1.27774119d0, 1.28034365d0, 1.28294134d0, 1.28579926d0,
     & 1.28863883d0, 1.29149032d0, 1.29435086d0, 1.29718816d0,
     & 1.30003285d0, 1.30288267d0, 1.30576515d0, 1.30865252d0,
     & 1.31154215d0, 1.31434858d0, 1.31689382d0, 1.31948507d0,
     & 1.32206368d0, 1.32463288d0, 1.32722509d0, 1.32980978d0,
     & 1.33241761d0, 1.33502114d0, 1.33759248d0, 1.34020030d0,
     & 1.34292090d0, 1.34565687d0, 1.34846449d0, 1.35125005d0,
     & 1.35404217d0, 1.35686934d0, 1.35967088d0, 1.36236179d0,
     & 1.36505675d0, 1.36778259d0, 1.37047303d0, 1.37313688d0,
     & 1.37575638d0, 1.37833309d0, 1.38093197d0, 1.38349557d0,
     & 1.38599539d0, 1.38849235d0, 1.39107156d0, 1.39364684d0,
     & 1.39627719d0, 1.39893878d0, 1.40168071d0, 1.40446222d0,
     & 1.40722358d0, 1.40996206d0, 1.41273534d0, 1.41551316d0,
     & 1.41832447d0, 1.42105210d0, 1.42378402d0, 1.42646194d0,
     & 1.42910743d0, 1.43167293d0, 1.43419838d0, 1.43671560d0,
     & 1.43925452d0, 1.44178879d0, 1.44428873d0, 1.44678545d0,
     & 1.44936621d0, 1.45192754d0, 1.45449364d0, 1.45724249d0,
     & 1.46000803d0, 1.46278429d0, 1.46557117d0, 1.46827734d0,
     & 1.47099054d0, 1.47376955d0, 1.47655356d0, 1.47934306d0,
     & 1.48212397d0, 1.48490179d0, 1.48749983d0, 1.49008298d0,
     & 1.49259734d0, 1.49510419d0, 1.49772382d0, 1.50033700d0,
     & 1.50291598d0, 1.50549030d0, 1.50806081d0, 1.51062858d0,
     & 1.51319289d0, 1.51579082d0, 1.51841843d0, 1.52137148d0,
     & 1.52433181d0, 1.52708781d0, 1.52985120d0, 1.53264987d0,
     & 1.53545403d0, 1.53826284d0, 1.54101574d0, 1.54377282d0,
     & 1.54652548d0, 1.54921973d0, 1.55167806d0, 1.55409908d0,
     & 1.55669606d0, 1.55928588d0, 1.56183922d0, 1.56438899d0,
     & 1.56693435d0, 1.56953585d0, 1.57207561d0, 1.57458270d0,
     & 1.57720017d0, 1.57985437d0, 1.58255732d0, 1.58524239d0,
     & 1.58802998d0, 1.59085763d0, 1.59366024d0, 1.59646881d0,
     & 1.59931183d0, 1.60215771d0, 1.60500777d0, 1.60777760d0,
     & 1.61051154d0, 1.61316741d0, 1.61584198d0, 1.61844432d0,
     & 1.62103796d0, 1.62362647d0, 1.62620962d0, 1.62878823d0,
     & 1.63136411d0, 1.63393486d0, 1.63647342d0, 1.63901091d0,
     & 1.64166439d0, 1.64435315d0, 1.64699948d0, 1.64966059d0,
     & 1.65236223d0, 1.65504169d0, 1.65772891d0, 1.66048110d0,
     & 1.66321027d0, 1.66597366d0, 1.66885984d0, 1.67163038d0,
     & 1.67436695d0, 1.67711747d0, 1.67985427d0, 1.68258095d0,
     & 1.68530095d0, 1.68801415d0, 1.69072163d0, 1.69342506d0,
     & 1.69612408d0, 1.69864082d0, 1.70121408d0, 1.70378268d0,
     & 1.70635033d0, 1.70896220d0, 1.71160197d0, 1.71428895d0,
     & 1.71698856d0, 1.71966696d0, 1.72238350d0, 1.72510719d0,
     & 1.72786534d0, 1.73062503d0, 1.73339462d0, 1.73625863d0,
     & 1.73908114d0, 1.74184835d0, 1.74460053d0, 1.74734247d0,
     & 1.75001848d0, 1.75268805d0, 1.75532281d0, 1.75804317d0,
     & 1.76073444d0, 1.76342130d0, 1.76598465d0, 1.76854479d0,
     & 1.77110255d0, 1.77365792d0, 1.77628279d0, 1.77902782d0,
     & 1.78175867d0, 1.78453350d0, 1.78726029d0, 1.79002595d0,
     & 1.79276657d0, 1.79554355d0, 1.79832458d0, 1.80111003d0,
     & 1.80390191d0, 1.80674672d0, 1.80956233d0, 1.81236303d0,
     & 1.81515062d0, 1.81792808d0, 1.82063770d0, 1.82328200d0,
     & 1.82592058d0, 1.82858586d0, 1.83130705d0, 1.83399272d0,
     & 1.83652461d0, 1.83899271d0, 1.84152007d0, 1.84404540d0,
     & 1.84664118d0, 1.84929371d0, 1.85205650d0, 1.85476899d0,
     & 1.85740006d0, 1.86001229d0, 1.86266327d0, 1.86532032d0,
     & 1.86804533d0, 1.87071395d0, 1.87341845d0, 1.87605524d0,
     & 1.87869525d0, 1.88131881d0, 1.88399434d0, 1.88675332d0,
     & 1.88950300d0, 1.89221489d0, 1.89492166d0, 1.89756298d0,
     & 1.90020049d0, 1.90277326d0, 1.90552163d0, 1.90826869d0,
     & 1.91086161d0, 1.91345179d0, 1.91600740d0, 1.91853094d0,
     & 1.92116642d0, 1.92386007d0, 1.92669737d0, 1.92944741d0,
     & 1.93217480d0, 1.93470156d0, 1.93723750d0, 1.93993032d0,
     & 1.94269192d0, 1.94543028d0, 1.94820368d0, 1.95089805d0,
     & 1.95353603d0, 1.95627475d0, 1.95910180d0, 1.96198273d0,
     & 1.96485627d0, 1.96772182d0, 1.97046041d0, 1.97313142d0,
     & 1.97582889d0, 1.97849214d0, 1.98115182d0, 1.98380876d0,
     & 1.98628056d0, 1.98875034d0, 1.99112833d0, 1.99359465d0,
     & 1.99612641d0, 1.99881589d0, 2.00149250d0, 2.00418496d0,
     & 2.00678992d0, 2.00940442d0, 2.01206136d0, 2.01469493d0,
     & 2.01736593d0, 2.02010202d0, 2.02278399d0, 2.02537298d0,
     & 2.02792788d0, 2.03049874d0, 2.03302550d0, 2.03567195d0,
     & 2.03828073d0, 2.04087901d0, 2.04347205d0, 2.04605913d0,
     & 2.04864240d0, 2.05122137d0, 2.05398035d0, 2.05670667d0,
     & 2.05943131d0, 2.06218481d0, 2.06493711d0, 2.06771851d0,
     & 2.07049918d0, 2.07334471d0, 2.07619333d0, 2.07923412d0,
     & 2.08215499d0, 2.08490467d0, 2.08769751d0, 2.09049940d0,
     & 2.09327745d0, 2.09606218d0, 2.09882188d0, 2.10158706d0,
     & 2.10429096d0, 2.10699558d0, 2.10951138d0, 2.11215043d0,
     & 2.11481142d0, 2.11755300d0, 2.12034822d0, 2.12316871d0,
     & 2.12598348d0, 2.12870359d0, 2.13141942d0, 2.13413215d0,
     & 2.13678098d0, 2.13945746d0, 2.14216137d0, 2.14486265d0,
     & 2.14743948d0, 2.14995360d0, 2.15246582d0, 2.15502095d0,
     & 2.15772915d0, 2.16042376d0, 2.16316795d0, 2.16595221d0,
     & 2.16887617d0, 2.17177773d0, 2.17446423d0, 2.17718863d0,
     & 2.17988825d0, 2.18259406d0, 2.18526053d0, 2.18789911d0,
     & 2.19055367d0, 2.19316125d0, 2.19579148d0, 2.19828463d0,
     & 2.20074105d0, 2.20341444d0, 2.20607948d0, 2.20889544d0,
     & 2.21155453d0, 2.21420956d0, 2.21686125d0, 2.21975231d0,
     & 2.22267151d0, 2.22555733d0, 2.22859192d0, 2.23134947d0,
     & 2.23407483d0, 2.23693013d0, 2.23954439d0, 2.24234915d0,
     & 2.24514103d0, 2.24794936d0, 2.25052786d0, 2.25308490d0,
     & 2.25574589d0, 2.25823140d0, 2.26115608d0, 2.26411629d0,
     & 2.26670170d0, 2.26940703d0, 2.27204633d0, 2.27470183d0,
     & 2.27734327d0, 2.27994347d0, 2.28259587d0, 2.28517938d0,
     & 2.28778934d0, 2.29020619d0, 2.29258871d0, 2.29521871d0,
     & 2.29784513d0, 2.30046868d0, 2.30330300d0, 2.30607033d0,
     & 2.30868602d0, 2.31148458d0, 2.31443024d0, 2.31737065d0,
     & 2.32033896d0, 2.32294559d0, 2.32552052d0, 2.32836413d0,
     & 2.33122396d0, 2.33388591d0, 2.33662462d0, 2.33955336d0,
     & 2.34224582d0, 2.34476185d0, 2.34722447d0, 2.34972572d0,
     & 2.35259175d0, 2.35549355d0, 2.35840583d0, 2.36133599d0,
     & 2.36422300d0, 2.36678863d0, 2.36944246d0, 2.37218189d0,
     & 2.37495160d0, 2.37778091d0, 2.38041687d0, 2.38308001d0,
     & 2.38573933d0, 2.38811946d0, 2.39047217d0, 2.39285707d0,
     & 2.39552140d0, 2.39845824d0, 2.40111732d0, 2.40374088d0,
     & 2.40639305d0, 2.40917253d0, 2.41182947d0, 2.41471863d0,
     & 2.41777086d0, 2.42065930d0, 2.42338657d0, 2.42612624d0,
     & 2.42857480d0, 2.43121815d0, 2.43390393d0, 2.43663120d0,
     & 2.43926334d0, 2.44230938d0, 2.44497323d0, 2.44747877d0,
     & 2.45014453d0, 2.45268559d0, 2.45556140d0, 2.45832920d0,
     & 2.46084499d0, 2.46332026d0, 2.46572638d0, 2.46829081d0,
     & 2.47056556d0, 2.47296095d0, 2.47547340d0, 2.49753332d0,
     & 2.51985693d0, 2.52230620d0, 2.52475405d0, 2.52747655d0,
     & 2.53022814d0, 2.53297710d0, 2.53569365d0, 2.56671977d0,
     & 2.56958270d0, 2.57214355d0, 2.55525017d0, 2.53841901d0,
     & 2.54113507d0, 2.54420328d0, 2.54724860d0, 2.55030274d0,
     & 2.55336475d0, 2.55646086d0, 2.53147745d0, 2.53469086d0,
     & 2.53808570d0, 2.54126430d0, 2.54417920d0, 2.54707623d0,
     & 2.54950094d0, 2.57158685d0, 2.57446814d0, 2.57734346d0,
     & 2.58006167d0, 2.58220720d0, 2.58425689d0, 2.58630776d0,
     & 2.58847928d0, 2.59151840d0, 2.59393716d0, 2.59651089d0,
     & 2.57944655d0, 2.58154750d0, 2.58364725d0, 2.58836603d0
     &/
      DATA (Imax ( 5,I), I= 1001, 2100) /
     & 2.59343123d0, 2.59856081d0, 2.60121465d0, 2.60405159d0,
     & 2.60617971d0, 2.60951328d0, 2.61272144d0, 2.61594248d0,
     & 2.61917210d0, 2.62241125d0, 2.62309551d0, 2.62365222d0,
     & 2.62417865d0, 2.62782598d0, 2.63129187d0, 2.63434768d0,
     & 2.63681912d0, 2.64030194d0, 2.64377379d0, 2.64707088d0,
     & 2.64964414d0, 2.65230918d0, 2.65506721d0, 2.65816569d0,
     & 2.66083646d0, 2.66288233d0, 2.66561985d0, 2.66918755d0,
     & 2.67069101d0, 2.67219281d0, 2.67389226d0, 2.67627549d0,
     & 2.67865705d0, 2.68106794d0, 2.68319273d0, 2.68510246d0,
     & 2.68766499d0, 2.68997717d0, 2.69148636d0, 2.69526887d0,
     & 2.70039558d0, 2.70984149d0, 2.71932745d0, 2.72882175d0,
     & 2.73826051d0, 2.74771094d0, 2.75100994d0, 2.75424862d0,
     & 2.75752974d0, 2.76081824d0, 2.76301360d0, 2.76386952d0,
     & 2.76041079d0, 2.75694728d0, 2.75344729d0, 2.76209307d0,
     & 2.77073836d0, 2.78557014d0, 2.80050635d0, 2.81518459d0,
     & 2.82986355d0, 2.83293247d0, 2.83599782d0, 2.83905983d0,
     & 2.84190106d0, 2.84476733d0, 2.83517218d0, 2.83157277d0,
     & 2.82793856d0, 2.82423401d0, 2.81458306d0, 2.80551863d0,
     & 2.81388664d0, 2.81642199d0, 2.81894684d0, 2.82172847d0,
     & 2.82427716d0, 2.82678819d0, 2.82354283d0, 2.82303572d0,
     & 2.82255816d0, 2.82827687d0, 2.83337402d0, 2.83252096d0,
     & 2.83750224d0, 2.84221029d0, 2.85691953d0, 2.87187290d0,
     & 2.88724399d0, 2.90199900d0, 2.91398907d0, 2.91383767d0,
     & 2.91368771d0, 2.92537403d0, 2.92535043d0, 2.92532730d0,
     & 2.92609382d0, 2.91660118d0, 2.90694499d0, 2.89728284d0,
     & 2.88799191d0, 2.87872601d0, 2.88156962d0, 2.88440990d0,
     & 2.87824631d0, 2.88385868d0, 2.88947582d0, 2.89459300d0,
     & 2.89964461d0, 2.90482640d0, 2.90975046d0, 2.91468453d0,
     & 2.91932893d0, 2.92217922d0, 2.92512655d0, 2.92526603d0,
     & 2.92548132d0, 2.92571139d0, 2.92594910d0, 2.92644882d0,
     & 2.92698455d0, 2.93390703d0, 2.94082093d0, 2.94246292d0,
     & 2.94593382d0, 2.94931006d0, 2.95243883d0, 2.95555186d0,
     & 2.95842242d0, 2.96128178d0, 2.96397495d0, 2.96910906d0,
     & 2.96783876d0, 2.96439624d0, 2.96654725d0, 2.96888518d0,
     & 2.97144055d0, 2.97412324d0, 2.97680330d0, 2.97951579d0,
     & 2.98222589d0, 2.98512483d0, 2.98557234d0, 2.98626256d0,
     & 2.98912311d0, 3.01235414d0, 3.03501821d0, 3.05747437d0,
     & 3.08003664d0, 3.10261083d0, 3.12538481d0, 3.12764215d0,
     & 3.12989879d0, 3.13212347d0, 3.13437438d0, 3.13670921d0,
     & 3.11864305d0, 3.10143566d0, 3.08401847d0, 3.06653476d0,
     & 3.04901576d0, 3.03149390d0, 3.03446341d0, 3.03743625d0,
     & 3.04045177d0, 3.04347801d0, 3.04722333d0, 3.05096364d0,
     & 3.05422449d0, 3.06390333d0, 3.07367277d0, 3.08346963d0,
     & 3.09326196d0, 3.10273266d0, 3.11221051d0, 3.12168193d0,
     & 3.13115239d0, 3.13585448d0, 3.14300299d0, 3.15466094d0,
     & 3.16025019d0, 3.31290245d0, 3.24858809d0, 3.27062869d0,
     & 3.36593294d0, 3.33538771d0, 3.36190677d0, 3.34259224d0,
     & 3.36134815d0, 3.38665819d0, 3.41412878d0, 3.43916583d0,
     & 3.46673560d0, 3.47706485d0, 3.50251460d0, 3.52517104d0,
     & 3.55396652d0, 3.57486439d0, 3.60304523d0, 3.63320827d0,
     & 3.66208863d0, 3.68898487d0, 3.70861816d0, 3.74098063d0,
     & 3.76386356d0, 3.79215074d0, 3.82153940d0, 3.85000110d0,
     & 3.87869716d0, 3.90467048d0, 3.93324137d0, 3.96236444d0,
     & 3.99048996d0, 4.01926136d0, 4.04602003d0, 4.07385492d0,
     & 4.08783150d0, 4.11601400d0, 4.14692640d0, 4.17528725d0,
     & 4.20424175d0, 4.23105574d0, 4.25888157d0, 4.28873062d0,
     & 4.31806755d0, 4.34755373d0, 4.37621355d0, 4.41520023d0,
     & 4.44296741d0, 4.48757601d0, 4.51529217d0, 4.54408932d0,
     & 4.57400513d0, 4.60366440d0, 4.63114691d0, 4.66012478d0,
     & 4.68778896d0, 4.71951342d0, 4.74513292d0, 4.77561188d0,
     & 4.80599737d0, 4.83496428d0, 4.86172533d0, 4.89303923d0,
     & 4.92181778d0, 4.95150566d0, 4.98174095d0, 5.00128460d0,
     & 5.02944326d0, 5.05492592d0, 5.08306789d0, 5.11197710d0,
     & 5.14167356d0, 5.17049742d0, 5.19535637d0, 5.22600460d0,
     & 5.25355625d0, 5.28259087d0, 5.31770325d0, 5.34479475d0,
     & 5.37426567d0, 5.40281200d0, 5.44097137d0, 5.46984673d0,
     & 5.50103188d0, 5.51579666d0, 5.55128479d0, 5.59140635d0,
     & 5.62203217d0, 5.65012312d0, 5.67728806d0, 5.70350361d0,
     & 5.73290920d0, 5.76763964d0, 5.79831886d0, 5.82461643d0,
     & 5.85487509d0, 5.88326025d0, 5.90281963d0, 5.93010426d0,
     & 5.96536303d0, 5.99615145d0, 6.01991177d0, 6.04023933d0,
     & 6.05984926d0, 6.08890772d0, 6.12247992d0, 6.15000010d0,
     & 6.17948914d0, 6.20932436d0, 6.23782158d0, 6.26606083d0,
     & 6.29431820d0, 6.33265209d0, 6.36276627d0, 6.38792038d0,
     & 6.41183138d0, 6.43827629d0, 6.46763229d0, 6.49221373d0,
     & 6.52470732d0, 6.55293846d0, 6.58256483d0, 6.60510302d0,
     & 6.63158369d0, 6.65992594d0, 6.69356537d0, 6.72625446d0,
     & 6.75384045d0, 6.78314304d0, 6.80281448d0, 6.82657146d0,
     & 6.85675526d0, 6.88094902d0, 6.90738630d0, 6.93446589d0,
     & 6.96223450d0, 6.99437571d0, 7.02311945d0, 7.05002451d0,
     & 7.07991076d0, 7.11076403d0, 7.13994265d0, 7.16815710d0,
     & 7.19366360d0, 7.22159767d0, 7.25040293d0, 7.28006744d0,
     & 7.30897665d0, 7.34335232d0, 7.36531019d0, 7.39256573d0,
     & 7.42090464d0, 7.44818640d0, 7.47170353d0, 7.50157166d0,
     & 7.53304291d0, 7.56183100d0, 7.59009457d0, 7.61860514d0,
     & 7.64838409d0, 7.67646360d0, 7.70676279d0, 7.73768997d0,
     & 7.76611996d0, 7.79873085d0, 7.82814360d0, 7.85868502d0,
     & 7.88342571d0, 7.90833378d0, 7.93672180d0, 7.96577024d0,
     & 7.99251652d0, 8.02403069d0, 8.05365849d0, 8.08391571d0,
     & 8.10912991d0, 8.13343143d0, 8.15973473d0, 8.18731880d0,
     & 8.21797180d0, 8.24643326d0, 8.27540207d0, 8.30287170d0,
     & 8.33221340d0, 8.35853195d0, 8.38511086d0, 8.41288185d0,
     & 8.44308281d0, 8.46900082d0, 8.49833965d0, 8.52438068d0,
     & 8.55066109d0, 8.57642460d0, 8.60312843d0, 8.63090801d0,
     & 8.65921783d0, 8.68634701d0, 8.71500111d0, 8.74220943d0,
     & 8.77147102d0, 8.79848576d0, 8.82701969d0, 8.85575867d0,
     & 8.88459301d0, 8.91277027d0, 8.94263744d0, 8.97088909d0,
     & 8.99854469d0, 9.02668762d0, 9.05801868d0, 9.08703995d0,
     & 9.11499023d0, 9.14194584d0, 9.16930294d0, 9.19617844d0,
     & 9.22336197d0, 9.25124073d0, 9.27964973d0, 9.30883598d0,
     & 9.33573818d0, 9.36022663d0, 9.38674355d0, 9.41343403d0,
     & 9.44083691d0, 9.47225094d0, 9.50118923d0, 9.52643967d0,
     & 9.54794502d0, 9.57293987d0, 9.59980488d0, 9.62556076d0,
     & 9.64958382d0, 9.67509937d0, 9.70220470d0, 9.73116779d0,
     & 9.76112461d0, 9.79008007d0, 9.82086849d0, 9.85110664d0,
     & 9.87738419d0, 9.90227985d0, 9.92999077d0, 9.95651627d0,
     & 9.98438931d0,10.01219559d0,10.03922081d0,10.06868935d0,
     &10.09832287d0,10.12553596d0,10.15028477d0,10.17641354d0,
     &10.20087242d0,10.22931957d0,10.25893402d0,10.28538036d0,
     &10.31110191d0,10.33723831d0,10.36261177d0,10.38852024d0,
     &10.41367912d0,10.44048977d0,10.47483253d0,10.50426292d0,
     &10.53243828d0,10.55891991d0,10.58553982d0,10.61318684d0,
     &10.64227486d0,10.67261410d0,10.70192814d0,10.72944260d0,
     &10.75382328d0,10.78001022d0,10.80722332d0,10.83624458d0,
     &10.86383724d0,10.88922691d0,10.91525364d0,10.94594479d0,
     &10.97805023d0,11.00710106d0,11.03815937d0,11.06658745d0,
     &11.09471512d0,11.12427998d0,11.15106583d0,11.17415905d0,
     &11.20194340d0,11.22916412d0,11.25328064d0,11.28349209d0,
     &11.31574249d0,11.34303761d0,11.36635494d0,11.39116192d0,
     &11.41864777d0,11.44462109d0,11.47270584d0,11.49569511d0,
     &11.52516556d0,11.55523109d0,11.58764744d0,11.61567307d0,
     &11.64411259d0,11.67072868d0,11.70025444d0,11.72685719d0,
     &11.75382137d0,11.78225231d0,11.81118202d0,11.83885574d0,
     &11.86464691d0,11.89052296d0,11.91905785d0,11.94654369d0,
     &11.97341251d0,12.00069714d0,12.03180408d0,12.06003475d0,
     &12.08957672d0,12.11958218d0,12.14258480d0,12.16907215d0,
     &12.20004559d0,12.23083019d0,12.26189995d0,12.28899288d0,
     &12.31632328d0,12.34039593d0,12.36802483d0,12.39586258d0,
     &12.42665958d0,12.45648575d0,12.48656654d0,12.51547813d0,
     &12.54357910d0,12.57028961d0,12.59457970d0,12.62210274d0,
     &12.65127754d0,12.68173599d0,12.70838451d0,12.73183441d0,
     &12.75923157d0,12.78762817d0,12.81924152d0,12.84615231d0,
     &12.87303257d0,12.89760017d0,12.92466831d0,12.95600319d0,
     &12.98289299d0,13.01191711d0,13.03916931d0,13.06947327d0,
     &13.09540653d0,13.12265491d0,13.15237331d0,13.18467140d0,
     &13.21140099d0,13.23903179d0,13.26221085d0,13.29130459d0,
     &13.31908703d0,13.34683323d0,13.37545681d0,13.40606689d0,
     &13.42975044d0,13.45561504d0,13.48514557d0,13.51314640d0,
     &13.54195690d0,13.56946278d0,13.59437847d0,13.62410069d0,
     &13.65301418d0,13.68156147d0,13.71246529d0,13.74166679d0,
     &13.76807880d0,13.79573059d0,13.82259941d0,13.84977436d0,
     &13.87853909d0,13.90734005d0,13.93275261d0,13.96415329d0,
     &13.99599934d0,14.02134895d0,14.04695797d0,14.07345963d0,
     &14.09708309d0,14.12457085d0,14.15333652d0,14.18152618d0,
     &14.21491146d0,14.24733734d0,14.27580833d0,14.30561924d0,
     &14.33631325d0,14.36089420d0,14.38780308d0,14.41239834d0,
     &14.44098949d0,14.47053242d0,14.49841309d0,14.52773380d0,
     &14.55925083d0,14.59057999d0,14.62137127d0,14.64978409d0,
     &14.67612076d0,14.70493889d0,14.73828697d0,14.76130772d0,
     &14.78705597d0,14.81396484d0,14.84579468d0,14.87297535d0,
     &14.90401936d0,14.93005657d0,14.95624065d0,14.98750782d0,
     &15.01629925d0,15.04269028d0,15.06912613d0,15.09876347d0,
     &15.12706375d0,15.15894985d0,15.18356800d0,15.21731186d0,
     &15.24951935d0,15.28197193d0,15.30758762d0,15.33516788d0,
     &15.36368465d0,15.39347553d0,15.42342758d0,15.45331669d0,
     &15.48314476d0,15.51275730d0,15.54147243d0,15.57180595d0,
     &15.60390854d0,15.63029957d0,15.65703011d0,15.68758392d0,
     &15.71525288d0,15.74326897d0,15.76948547d0,15.79598522d0,
     &15.82584286d0,15.85530758d0,15.88561821d0,15.91981030d0,
     &15.95098209d0,15.98430252d0,16.01462936d0,16.03949738d0,
     &16.06712341d0,16.09596252d0,16.12347794d0,16.15419579d0,
     &16.18337822d0,16.21270752d0,16.24284935d0,16.26795578d0,
     &16.29597473d0,16.32614326d0,16.35647202d0,16.38637543d0,
     &16.41555214d0,16.44661331d0,16.47483444d0,16.50685883d0,
     &16.53823280d0,16.56974411d0,16.60108376d0,16.62777901d0,
     &16.65366364d0,16.68264580d0,16.70700073d0,16.73860741d0,
     &16.76977158d0,16.80016708d0,16.82949829d0,16.85498810d0,
     &16.88904381d0,16.91936684d0,16.94330788d0,16.97350502d0,
     &17.00131226d0,17.03348732d0,17.06525993d0,17.09470749d0,
     &17.12285995d0,17.15051079d0,17.17961311d0,17.20972824d0,
     &17.24034882d0,17.27424049d0,17.30206680d0,17.33067131d0,
     &17.35842705d0,17.38913345d0,17.42054749d0,17.45453072d0,
     &17.48277092d0,17.51161003d0,17.54342270d0,17.57547951d0,
     &17.60354233d0,17.63405991d0,17.66461945d0,17.69193649d0,
     &17.72235870d0,17.75148964d0,17.77690315d0,17.80796623d0,
     &17.83938408d0,17.86570358d0,17.89106941d0,17.92419434d0,
     &17.94941711d0,17.97851944d0,18.01193428d0,18.04110146d0,
     &18.07132721d0,18.10713005d0,18.14142799d0,18.16737747d0,
     &18.19152641d0,18.21753311d0,18.24613571d0,18.27975464d0,
     &18.30871773d0,18.33789253d0,18.37048340d0,18.40519524d0,
     &18.43688583d0,18.46969414d0,18.49500084d0,18.52833748d0,
     &18.56597137d0,18.59362793d0,18.62578392d0,18.65699196d0,
     &18.68702888d0,18.71887207d0,18.75352669d0,18.78871727d0,
     &18.81750107d0,18.85316658d0,18.88530159d0,18.91942596d0,
     &18.94500351d0,18.97603607d0,19.01534081d0,19.04827309d0,
     &19.08018684d0,19.11443138d0,19.14746475d0,19.17834473d0,
     &19.21110153d0,19.24159813d0,19.26542091d0,19.29695892d0,
     &19.32829857d0,19.36272430d0,19.40005875d0,19.42937851d0,
     &19.45609856d0,19.48213005d0,19.50444984d0,19.53520775d0,
     &19.56698036d0,19.59809685d0,19.63181877d0,19.66441917d0,
     &19.69728088d0,19.73142624d0,19.76218987d0,19.79658508d0,
     &19.83180428d0,19.86387634d0,19.89640617d0,19.92781639d0,
     &19.96190643d0,19.99082184d0,20.02362823d0,20.04480934d0,
     &20.08356857d0,20.11455154d0,20.14905548d0,20.18472481d0,
     &20.22399139d0,20.26078224d0,20.28595352d0,20.31417465d0,
     &20.34733772d0,20.38382149d0,20.42479324d0,20.44730949d0,
     &20.48014259d0,20.52210236d0,20.55307198d0,20.58694839d0,
     &20.62134552d0,20.65559196d0,20.68707657d0,20.71648026d0,
     &20.74623489d0,20.78830528d0,20.81870270d0,20.86174965d0,
     &20.88971901d0,20.91980171d0,20.95284462d0,20.98785400d0,
     &21.02176857d0,21.06050110d0,21.09288025d0,21.12460899d0,
     &21.16121864d0,21.19589806d0,21.22532654d0,21.25282288d0,
     &21.28851509d0,21.33169937d0,21.36966896d0,21.38932610d0,
     &21.42821121d0,21.46033287d0,21.49609375d0,21.53843117d0,
     &21.57083321d0,21.59884262d0,21.63283730d0,21.67177200d0,
     &21.71157837d0,22.21039772d0,22.21056938d0,22.21074486d0,
     &22.21091843d0,22.21109200d0,22.21126556d0,22.21144104d0,
     &22.21161461d0,22.21179390d0,22.21196938d0,22.21215057d0,
     &22.21232986d0,22.21250725d0,22.22316170d0,22.25975990d0,
     &22.30103111d0,22.34461403d0,22.38079262d0,22.41756630d0,
     &22.44958115d0,22.48982239d0,22.52303123d0,22.55891228d0,
     &22.58932495d0,22.61925697d0,22.65221405d0,22.68905067d0,
     &22.72242737d0,22.75148201d0,22.78817749d0,22.82545471d0,
     &22.86072731d0,22.89086342d0,22.92552757d0,22.96310234d0,
     &23.00612640d0,23.04360199d0,23.08310890d0,23.11741066d0,
     &23.14746857d0,23.18332672d0,23.22122192d0,23.25910759d0,
     &23.30057716d0,23.33484840d0,23.37103462d0,23.40558624d0,
     &23.44316673d0,23.47913933d0,23.51209450d0,23.54300308d0,
     &23.58613586d0,23.61795616d0,23.65416145d0,23.69703293d0,
     &23.73309326d0,23.76802254d0,23.80638695d0,23.83707047d0,
     &23.88265228d0,23.92674446d0,23.96731377d0,24.00558853d0,
     &24.04590416d0,24.08157158d0,24.12510490d0,24.16613579d0,
     &24.19778442d0,24.24348068d0,24.28010559d0,24.04568291d0,
     &23.61774063d0,23.05080986d0,22.40662003d0,21.71330452d0,
     &20.94903183d0,20.15244865d0,19.25341034d0,18.35725212d0,
     &17.43640518d0,16.17017937d0,15.40598106d0,14.83188152d0,
     &16.33876991d0,16.32981491d0,16.20494461d0,16.29398918d0,
     &16.20494461d0,16.30294609d0,16.36563873d0,16.30294609d0,
     &16.32085800d0,16.33876991d0,16.34772682d0,11.38405514d0,
     &11.20902729d0,11.04555798d0,10.88554382d0,10.73322964d0,
     &10.58962727d0,10.44843006d0,10.31405354d0,10.18337822d0,
     &10.05970097d0, 9.93939686d0, 9.82199860d0, 9.71044064d0,
     & 9.60046291d0, 9.49492264d0, 9.39280224d0,10.51108932d0,
     &16.30294609d0,16.29398918d0,16.30294609d0,16.31190109d0,
     &16.34772682d0,16.36563873d0,16.34772682d0,16.36563873d0,
     &16.37459373d0,16.35668182d0,16.32085800d0,16.20494461d0,
     &16.31190109d0,16.20494461d0,16.19789505d0,11.38386631d0,
     &16.19789505d0,16.29398918d0,16.20141983d0,10.54246807d0,
     &10.52677917d0,16.20141983d0,10.52677917d0,11.38386631d0,
     &16.20141983d0,16.30294609d0,16.31190109d0,16.20141983d0,
     &11.38386631d0,10.54246807d0,16.20494461d0,16.20494461d0,
     &16.19789505d0,16.30294609d0,16.20141983d0,16.20494461d0,
     &16.30294609d0,16.20141983d0,16.32085800d0,16.30294609d0,
     &16.31190109d0,16.20141983d0,16.20141983d0,16.19789505d0,
     &10.51108932d0,10.51108932d0, 8.38522911d0, 6.43474245d0,
     & 6.39866686d0, 6.36310720d0, 6.32803583d0, 6.29341555d0,
     & 6.25922489d0, 6.22541714d0, 6.19175816d0,10.51108932d0,
     & 8.62923813d0,11.38386631d0,10.52677917d0,10.52677917d0,
     & 8.62923813d0,11.38386631d0,10.51108932d0,11.38386631d0,
     &11.38386631d0, 8.62923813d0, 8.36041737d0,10.51108932d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0,
     & 5.77184010d0, 5.77184010d0, 5.77184010d0, 5.77184010d0
     &/
c Definition of open field lines as Lupper=f(Iupper) for doy=121
      DATA (Lupper ( 5,I), I= 1, 1001) /
     & 8.79d0, 8.79d0, 8.78d0, 8.78d0, 8.77d0, 8.77d0, 8.76d0, 8.76d0,
     & 8.75d0, 8.75d0, 8.74d0, 8.73d0, 8.73d0, 8.72d0, 8.72d0, 8.71d0,
     & 8.71d0, 8.70d0, 8.70d0, 8.69d0, 8.69d0, 8.69d0, 8.69d0, 8.69d0,
     & 8.69d0, 8.69d0, 8.69d0, 8.69d0, 8.69d0, 8.69d0, 8.69d0, 8.70d0,
     & 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0,
     & 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0,
     & 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0,
     & 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0, 8.70d0,
     & 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0,
     & 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0,
     & 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0,
     & 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0, 8.71d0,
     & 8.71d0, 8.71d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0,
     & 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0,
     & 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0,
     & 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0, 8.72d0,
     & 8.72d0, 8.72d0, 8.72d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0,
     & 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0,
     & 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0,
     & 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.73d0,
     & 8.73d0, 8.73d0, 8.73d0, 8.73d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0,
     & 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0,
     & 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0,
     & 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0,
     & 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.74d0, 8.75d0, 8.75d0,
     & 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0,
     & 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0,
     & 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0,
     & 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.75d0, 8.76d0,
     & 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0,
     & 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0,
     & 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0,
     & 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0, 8.76d0,
     & 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0,
     & 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0,
     & 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0,
     & 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0, 8.77d0,
     & 8.77d0, 8.77d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0,
     & 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0,
     & 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0,
     & 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0, 8.78d0,
     & 8.78d0, 8.78d0, 8.78d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0,
     & 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0,
     & 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0,
     & 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0,
     & 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.79d0, 8.80d0, 8.80d0, 8.80d0,
     & 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0,
     & 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0,
     & 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0,
     & 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.80d0, 8.81d0, 8.81d0,
     & 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0,
     & 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0,
     & 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0,
     & 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.81d0, 8.82d0,
     & 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0,
     & 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0,
     & 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0,
     & 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0, 8.82d0,
     & 8.82d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0,
     & 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0,
     & 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0,
     & 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0, 8.83d0,
     & 8.83d0, 8.83d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0,
     & 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0,
     & 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0,
     & 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.84d0,
     & 8.84d0, 8.84d0, 8.84d0, 8.84d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0,
     & 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0,
     & 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0,
     & 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0,
     & 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.85d0, 8.86d0, 8.86d0, 8.86d0,
     & 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0,
     & 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0,
     & 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0,
     & 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.86d0, 8.87d0, 8.87d0,
     & 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0,
     & 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0,
     & 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0,
     & 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0, 8.87d0,
     & 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0,
     & 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0,
     & 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0,
     & 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0, 8.88d0,
     & 8.88d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0,
     & 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0,
     & 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0,
     & 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0, 8.89d0,
     & 8.89d0, 8.89d0, 8.89d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0,
     & 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0,
     & 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0,
     & 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.90d0,
     & 8.90d0, 8.90d0, 8.90d0, 8.90d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0,
     & 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0,
     & 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0,
     & 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0,
     & 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.91d0, 8.92d0, 8.92d0, 8.92d0,
     & 8.92d0, 8.92d0, 8.92d0, 8.92d0, 8.92d0, 8.92d0, 8.93d0, 8.94d0,
     & 8.94d0, 8.95d0, 8.95d0, 8.96d0, 8.97d0, 8.97d0, 8.98d0, 8.99d0,
     & 9.00d0, 9.00d0, 9.01d0, 9.02d0, 9.03d0, 9.03d0, 9.04d0, 9.05d0,
     & 9.06d0, 9.07d0, 9.08d0, 9.09d0, 9.10d0, 9.10d0, 9.11d0, 9.12d0,
     & 9.13d0, 9.14d0, 9.15d0, 9.16d0, 9.17d0, 9.18d0, 9.19d0, 9.21d0,
     & 9.22d0, 9.23d0, 9.24d0, 9.25d0, 9.26d0, 9.27d0, 9.28d0, 9.29d0,
     & 9.30d0, 9.31d0, 9.32d0, 9.33d0, 9.35d0, 9.36d0, 9.38d0, 9.40d0,
     & 9.41d0, 9.43d0, 9.45d0, 9.47d0, 9.48d0, 9.50d0, 9.52d0, 9.54d0,
     & 9.56d0, 9.58d0, 9.60d0, 9.62d0, 9.63d0, 9.65d0, 9.67d0, 9.69d0,
     & 9.71d0, 9.73d0, 9.75d0, 9.77d0, 9.79d0, 9.81d0, 9.83d0, 9.85d0,
     & 9.87d0, 9.89d0, 9.91d0, 9.93d0, 9.95d0, 9.97d0, 9.98d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     & 9.99d0,10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0,
     & 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     &10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,
     &10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0
     &/
      DATA (Iupper ( 5,I), I= 1, 1001) /
     & 0.00010000d0, 0.00010127d0, 0.00010255d0, 0.00010386d0,
     & 0.00010517d0, 0.00010651d0, 0.00010786d0, 0.00010923d0,
     & 0.00011062d0, 0.00011202d0, 0.00011344d0, 0.00011488d0,
     & 0.00011634d0, 0.00011782d0, 0.00011931d0, 0.00012083d0,
     & 0.00012236d0, 0.00012391d0, 0.00012548d0, 0.00012708d0,
     & 0.00012869d0, 0.00013032d0, 0.00013198d0, 0.00013365d0,
     & 0.00013535d0, 0.00013707d0, 0.00013881d0, 0.00014057d0,
     & 0.00014235d0, 0.00014416d0, 0.00014599d0, 0.00014784d0,
     & 0.00014972d0, 0.00015162d0, 0.00015354d0, 0.00015549d0,
     & 0.00015746d0, 0.00015946d0, 0.00016148d0, 0.00016353d0,
     & 0.00016561d0, 0.00016771d0, 0.00016984d0, 0.00017200d0,
     & 0.00017418d0, 0.00017639d0, 0.00017863d0, 0.00018089d0,
     & 0.00018319d0, 0.00018551d0, 0.00018787d0, 0.00019025d0,
     & 0.00019267d0, 0.00019511d0, 0.00019759d0, 0.00020010d0,
     & 0.00020264d0, 0.00020521d0, 0.00020781d0, 0.00021045d0,
     & 0.00021312d0, 0.00021583d0, 0.00021857d0, 0.00022134d0,
     & 0.00022415d0, 0.00022699d0, 0.00022987d0, 0.00023279d0,
     & 0.00023575d0, 0.00023874d0, 0.00024177d0, 0.00024484d0,
     & 0.00024794d0, 0.00025109d0, 0.00025428d0, 0.00025750d0,
     & 0.00026077d0, 0.00026408d0, 0.00026743d0, 0.00027083d0,
     & 0.00027426d0, 0.00027775d0, 0.00028127d0, 0.00028484d0,
     & 0.00028846d0, 0.00029212d0, 0.00029582d0, 0.00029958d0,
     & 0.00030338d0, 0.00030723d0, 0.00031113d0, 0.00031508d0,
     & 0.00031908d0, 0.00032313d0, 0.00032723d0, 0.00033138d0,
     & 0.00033559d0, 0.00033984d0, 0.00034416d0, 0.00034853d0,
     & 0.00035295d0, 0.00035743d0, 0.00036196d0, 0.00036656d0,
     & 0.00037121d0, 0.00037592d0, 0.00038069d0, 0.00038552d0,
     & 0.00039042d0, 0.00039537d0, 0.00040039d0, 0.00040547d0,
     & 0.00041062d0, 0.00041583d0, 0.00042111d0, 0.00042645d0,
     & 0.00043186d0, 0.00043734d0, 0.00044289d0, 0.00044852d0,
     & 0.00045421d0, 0.00045997d0, 0.00046581d0, 0.00047172d0,
     & 0.00047771d0, 0.00048377d0, 0.00048991d0, 0.00049613d0,
     & 0.00050243d0, 0.00050880d0, 0.00051526d0, 0.00052180d0,
     & 0.00052842d0, 0.00053513d0, 0.00054192d0, 0.00054880d0,
     & 0.00055576d0, 0.00056281d0, 0.00056996d0, 0.00057719d0,
     & 0.00058452d0, 0.00059194d0, 0.00059945d0, 0.00060706d0,
     & 0.00061476d0, 0.00062256d0, 0.00063046d0, 0.00063846d0,
     & 0.00064657d0, 0.00065477d0, 0.00066308d0, 0.00067150d0,
     & 0.00068002d0, 0.00068865d0, 0.00069739d0, 0.00070624d0,
     & 0.00071521d0, 0.00072428d0, 0.00073347d0, 0.00074278d0,
     & 0.00075221d0, 0.00076176d0, 0.00077142d0, 0.00078122d0,
     & 0.00079113d0, 0.00080117d0, 0.00081134d0, 0.00082164d0,
     & 0.00083206d0, 0.00084262d0, 0.00085332d0, 0.00086415d0,
     & 0.00087511d0, 0.00088622d0, 0.00089747d0, 0.00090886d0,
     & 0.00092039d0, 0.00093207d0, 0.00094390d0, 0.00095588d0,
     & 0.00096801d0, 0.00098030d0, 0.00099274d0, 0.00100534d0,
     & 0.00101810d0, 0.00103102d0, 0.00104411d0, 0.00105736d0,
     & 0.00107078d0, 0.00108437d0, 0.00109813d0, 0.00111206d0,
     & 0.00112618d0, 0.00114047d0, 0.00115495d0, 0.00116960d0,
     & 0.00118445d0, 0.00119948d0, 0.00121470d0, 0.00123012d0,
     & 0.00124573d0, 0.00126154d0, 0.00127755d0, 0.00129377d0,
     & 0.00131019d0, 0.00132681d0, 0.00134365d0, 0.00136071d0,
     & 0.00137797d0, 0.00139546d0, 0.00141317d0, 0.00143111d0,
     & 0.00144927d0, 0.00146766d0, 0.00148629d0, 0.00150515d0,
     & 0.00152426d0, 0.00154360d0, 0.00156319d0, 0.00158303d0,
     & 0.00160312d0, 0.00162347d0, 0.00164407d0, 0.00166494d0,
     & 0.00168607d0, 0.00170747d0, 0.00172914d0, 0.00175108d0,
     & 0.00177331d0, 0.00179581d0, 0.00181860d0, 0.00184168d0,
     & 0.00186506d0, 0.00188873d0, 0.00191270d0, 0.00193697d0,
     & 0.00196156d0, 0.00198645d0, 0.00201166d0, 0.00203719d0,
     & 0.00206305d0, 0.00208923d0, 0.00211575d0, 0.00214260d0,
     & 0.00216979d0, 0.00219733d0, 0.00222521d0, 0.00225346d0,
     & 0.00228206d0, 0.00231102d0, 0.00234035d0, 0.00237005d0,
     & 0.00240013d0, 0.00243059d0, 0.00246144d0, 0.00249268d0,
     & 0.00252431d0, 0.00255635d0, 0.00258879d0, 0.00262165d0,
     & 0.00265492d0, 0.00268862d0, 0.00272274d0, 0.00275729d0,
     & 0.00279229d0, 0.00282773d0, 0.00286361d0, 0.00289996d0,
     & 0.00293676d0, 0.00297403d0, 0.00301178d0, 0.00305000d0,
     & 0.00308871d0, 0.00312791d0, 0.00316761d0, 0.00320781d0,
     & 0.00324852d0, 0.00328975d0, 0.00333150d0, 0.00337378d0,
     & 0.00341660d0, 0.00345996d0, 0.00350387d0, 0.00354834d0,
     & 0.00359337d0, 0.00363898d0, 0.00368516d0, 0.00373193d0,
     & 0.00377930d0, 0.00382726d0, 0.00387583d0, 0.00392502d0,
     & 0.00397484d0, 0.00402528d0, 0.00407637d0, 0.00412811d0,
     & 0.00418050d0, 0.00423355d0, 0.00428728d0, 0.00434169d0,
     & 0.00439680d0, 0.00445260d0, 0.00450911d0, 0.00456633d0,
     & 0.00462429d0, 0.00468298d0, 0.00474241d0, 0.00480260d0,
     & 0.00486355d0, 0.00492528d0, 0.00498778d0, 0.00505109d0,
     & 0.00511519d0, 0.00518011d0, 0.00524585d0, 0.00531243d0,
     & 0.00537985d0, 0.00544813d0, 0.00551727d0, 0.00558730d0,
     & 0.00565821d0, 0.00573002d0, 0.00580274d0, 0.00587639d0,
     & 0.00595096d0, 0.00602649d0, 0.00610298d0, 0.00618043d0,
     & 0.00625887d0, 0.00633830d0, 0.00641874d0, 0.00650021d0,
     & 0.00658270d0, 0.00666625d0, 0.00675085d0, 0.00683653d0,
     & 0.00692329d0, 0.00701116d0, 0.00710014d0, 0.00719025d0,
     & 0.00728151d0, 0.00737392d0, 0.00746751d0, 0.00756228d0,
     & 0.00765826d0, 0.00775545d0, 0.00785387d0, 0.00795355d0,
     & 0.00805449d0, 0.00815672d0, 0.00826024d0, 0.00836507d0,
     & 0.00847124d0, 0.00857875d0, 0.00868762d0, 0.00879788d0,
     & 0.00890954d0, 0.00902261d0, 0.00913712d0, 0.00925308d0,
     & 0.00937052d0, 0.00948945d0, 0.00960988d0, 0.00973184d0,
     & 0.00985535d0, 0.00998043d0, 0.01010710d0, 0.01023537d0,
     & 0.01036527d0, 0.01049682d0, 0.01063004d0, 0.01076495d0,
     & 0.01090157d0, 0.01103993d0, 0.01118004d0, 0.01132193d0,
     & 0.01146563d0, 0.01161114d0, 0.01175850d0, 0.01190773d0,
     & 0.01205886d0, 0.01221190d0, 0.01236688d0, 0.01252384d0,
     & 0.01268278d0, 0.01284374d0, 0.01300676d0, 0.01317183d0,
     & 0.01333899d0, 0.01350829d0, 0.01367973d0, 0.01385334d0,
     & 0.01402915d0, 0.01420721d0, 0.01438751d0, 0.01457011d0,
     & 0.01475503d0, 0.01494229d0, 0.01513193d0, 0.01532398d0,
     & 0.01551846d0, 0.01571541d0, 0.01591486d0, 0.01611684d0,
     & 0.01632139d0, 0.01652853d0, 0.01673830d0, 0.01695073d0,
     & 0.01716586d0, 0.01738372d0, 0.01760434d0, 0.01782776d0,
     & 0.01805403d0, 0.01828315d0, 0.01851519d0, 0.01875018d0,
     & 0.01898814d0, 0.01922913d0, 0.01947318d0, 0.01972032d0,
     & 0.01997059d0, 0.02022405d0, 0.02048072d0, 0.02074065d0,
     & 0.02100387d0, 0.02127045d0, 0.02154040d0, 0.02181377d0,
     & 0.02209063d0, 0.02237098d0, 0.02265490d0, 0.02294243d0,
     & 0.02323360d0, 0.02352846d0, 0.02382708d0, 0.02412947d0,
     & 0.02443570d0, 0.02474584d0, 0.02505989d0, 0.02537793d0,
     & 0.02570002d0, 0.02602619d0, 0.02635649d0, 0.02669099d0,
     & 0.02702975d0, 0.02737279d0, 0.02772018d0, 0.02807200d0,
     & 0.02842827d0, 0.02878906d0, 0.02915444d0, 0.02952445d0,
     & 0.02989915d0, 0.03027862d0, 0.03066289d0, 0.03105204d0,
     & 0.03144613d0, 0.03184524d0, 0.03224939d0, 0.03265868d0,
     & 0.03307318d0, 0.03349292d0, 0.03391798d0, 0.03434846d0,
     & 0.03478439d0, 0.03522584d0, 0.03567292d0, 0.03612565d0,
     & 0.03658413d0, 0.03704845d0, 0.03751864d0, 0.03799480d0,
     & 0.03847702d0, 0.03896534d0, 0.03945986d0, 0.03996065d0,
     & 0.04046782d0, 0.04098141d0, 0.04150151d0, 0.04202824d0,
     & 0.04256163d0, 0.04310180d0, 0.04364883d0, 0.04420279d0,
     & 0.04476377d0, 0.04533191d0, 0.04590723d0, 0.04648984d0,
     & 0.04707986d0, 0.04767738d0, 0.04828247d0, 0.04889523d0,
     & 0.04951580d0, 0.05014421d0, 0.05078061d0, 0.05142510d0,
     & 0.05207775d0, 0.05273868d0, 0.05340803d0, 0.05408584d0,
     & 0.05477226d0, 0.05546741d0, 0.05617137d0, 0.05688425d0,
     & 0.05760621d0, 0.05833730d0, 0.05907768d0, 0.05982745d0,
     & 0.06058676d0, 0.06135568d0, 0.06213436d0, 0.06292295d0,
     & 0.06372152d0, 0.06453023d0, 0.06534923d0, 0.06617859d0,
     & 0.06701849d0, 0.06786907d0, 0.06873041d0, 0.06960268d0,
     & 0.07048602d0, 0.07138062d0, 0.07228653d0, 0.07320394d0,
     & 0.07413302d0, 0.07507385d0, 0.07602664d0, 0.07699155d0,
     & 0.07796867d0, 0.07895819d0, 0.07996030d0, 0.08097509d0,
     & 0.08200277d0, 0.08304353d0, 0.08409746d0, 0.08516476d0,
     & 0.08624565d0, 0.08734021d0, 0.08844867d0, 0.08957119d0,
     & 0.09070800d0, 0.09185920d0, 0.09302501d0, 0.09420566d0,
     & 0.09540125d0, 0.09661201d0, 0.09783818d0, 0.09907987d0,
     & 0.10033731d0, 0.10161077d0, 0.10290034d0, 0.10420627d0,
     & 0.10552878d0, 0.10686813d0, 0.10822441d0, 0.10959791d0,
     & 0.11098890d0, 0.11239749d0, 0.11382396d0, 0.11526857d0,
     & 0.11673148d0, 0.11821295d0, 0.11971328d0, 0.12123259d0,
     & 0.12277117d0, 0.12432936d0, 0.12590724d0, 0.12750517d0,
     & 0.12912343d0, 0.13076216d0, 0.13242172d0, 0.13410230d0,
     & 0.13580430d0, 0.13752782d0, 0.13927321d0, 0.14104085d0,
     & 0.14283082d0, 0.14464353d0, 0.14647931d0, 0.14833830d0,
     & 0.15022090d0, 0.15212746d0, 0.15405814d0, 0.15601335d0,
     & 0.15799335d0, 0.15999855d0, 0.16202913d0, 0.16408549d0,
     & 0.16616802d0, 0.16827691d0, 0.17041254d0, 0.17257537d0,
     & 0.17476557d0, 0.17698357d0, 0.17922980d0, 0.18150444d0,
     & 0.18380795d0, 0.18614081d0, 0.18850316d0, 0.19089550d0,
     & 0.19331829d0, 0.19577175d0, 0.19825633d0, 0.20077245d0,
     & 0.20332061d0, 0.20590100d0, 0.20851412d0, 0.21116054d0,
     & 0.21384043d0, 0.21655434d0, 0.21930277d0, 0.22208601d0,
     & 0.22490457d0, 0.22775897d0, 0.23064953d0, 0.23357674d0,
     & 0.23654114d0, 0.23954326d0, 0.24258336d0, 0.24566205d0,
     & 0.24877992d0, 0.25193724d0, 0.25513467d0, 0.25837275d0,
     & 0.26165181d0, 0.26497251d0, 0.26833546d0, 0.27174097d0,
     & 0.27518973d0, 0.27868235d0, 0.28221917d0, 0.28580090d0,
     & 0.28942820d0, 0.29310140d0, 0.29682124d0, 0.30058825d0,
     & 0.30440310d0, 0.30826664d0, 0.31217894d0, 0.31614089d0,
     & 0.32015309d0, 0.32421625d0, 0.32833093d0, 0.33249786d0,
     & 0.33671802d0, 0.34099138d0, 0.34531897d0, 0.34970152d0,
     & 0.35413966d0, 0.35863414d0, 0.36318600d0, 0.36779529d0,
     & 0.37246308d0, 0.37719008d0, 0.38197711d0, 0.38682488d0,
     & 0.39173418d0, 0.39670613d0, 0.40174085d0, 0.40683943d0,
     & 0.41200271d0, 0.41723153d0, 0.42252675d0, 0.42788953d0,
     & 0.43332002d0, 0.43881938d0, 0.44438851d0, 0.45002836d0,
     & 0.45573980d0, 0.46152416d0, 0.46738148d0, 0.47331312d0,
     & 0.47932005d0, 0.48540321d0, 0.49156362d0, 0.49780214d0,
     & 0.50412035d0, 0.51051831d0, 0.51699740d0, 0.52355874d0,
     & 0.53020334d0, 0.53693229d0, 0.54374713d0, 0.55064797d0,
     & 0.55763638d0, 0.56471354d0, 0.57188040d0, 0.57913828d0,
     & 0.58648884d0, 0.59393209d0, 0.60146987d0, 0.60910326d0,
     & 0.61683351d0, 0.62466192d0, 0.63258964d0, 0.64061862d0,
     & 0.64874887d0, 0.65698230d0, 0.66532022d0, 0.67376393d0,
     & 0.68231487d0, 0.69097501d0, 0.69974434d0, 0.70862496d0,
     & 0.71761823d0, 0.72672570d0, 0.73594880d0, 0.74528891d0,
     & 0.75474828d0, 0.76432699d0, 0.77402723d0, 0.78385061d0,
     & 0.79379863d0, 0.80387294d0, 0.81407589d0, 0.82440752d0,
     & 0.83487028d0, 0.84546578d0, 0.85619581d0, 0.86706197d0,
     & 0.87806606d0, 0.88921070d0, 0.90049589d0, 0.91192430d0,
     & 0.92349786d0, 0.93521816d0, 0.94708717d0, 0.95910788d0,
     & 0.97128016d0, 0.98360693d0, 0.99609011d0, 1.00873172d0,
     & 1.02153373d0, 1.03449929d0, 1.04762840d0, 1.06092405d0,
     & 1.07438850d0, 1.08802390d0, 1.10183227d0, 1.11581588d0,
     & 1.12997806d0, 1.14431894d0, 1.15884173d0, 1.17354894d0,
     & 1.18844259d0, 1.20352542d0, 1.21880090d0, 1.23426902d0,
     & 1.24993336d0, 1.26579666d0, 1.28186119d0, 1.29812956d0,
     & 1.31460571d0, 1.33128977d0, 1.34818542d0, 1.36529553d0,
     & 1.38262296d0, 1.40017009d0, 1.41794002d0, 1.43593681d0,
     & 1.45416057d0, 1.47261584d0, 1.49130499d0, 1.51023161d0,
     & 1.52939832d0, 1.54880977d0, 1.56846607d0, 1.58837199d0,
     & 1.60853028d0, 1.62894464d0, 1.64961791d0, 1.67055368d0,
     & 1.69175661d0, 1.71322715d0, 1.73497009d0, 1.75698900d0,
     & 1.77928746d0, 1.80186892d0, 1.82473862d0, 1.84789681d0,
     & 1.87134874d0, 1.89509857d0, 1.91914976d0, 1.94350624d0,
     & 1.96817160d0, 1.99315214d0, 2.01844788d0, 2.04406428d0,
     & 2.07000613d0, 2.09627700d0, 2.12288141d0, 2.14982557d0,
     & 2.17710948d0, 2.20473981d0, 2.23272061d0, 2.26105666d0,
     & 2.28975224d0, 2.31881428d0, 2.34824300d0, 2.37804508d0,
     & 2.40822554d0, 2.43878889d0, 2.46974015d0, 2.50108409d0,
     & 2.53282857d0, 2.56497312d0, 2.59752584d0, 2.63049173d0,
     & 2.66387582d0, 2.69768381d0, 2.73192358d0, 2.76659513d0,
     & 2.80170655d0, 2.83726382d0, 2.87327218d0, 2.90973759d0,
     & 2.94666839d0, 2.98406553d0, 3.02193713d0, 3.06028914d0,
     & 3.09912801d0, 3.13845992d0, 3.17829084d0, 3.21863031d0,
     & 3.25947881d0, 3.30084562d0, 3.34273744d0, 3.38516092d0,
     & 3.42812300d0, 3.47163343d0, 3.51569295d0, 3.56031132d0,
     & 3.60549593d0, 3.65125418d0, 3.69759321d0, 3.74452019d0,
     & 3.79204679d0, 3.84017253d0, 3.88890886d0, 3.93826389d0,
     & 3.98824549d0, 4.03886127d0, 4.09012318d0, 4.14203215d0,
     & 4.19460011d0, 4.24783468d0, 4.30174494d0, 4.35633945d0,
     & 4.41162682d0, 4.46762037d0, 4.52431965d0, 4.58173895d0,
     & 4.63988686d0, 4.69877291d0, 4.75840616d0, 4.81880093d0,
     & 4.87995768d0, 4.94189024d0, 5.00460863d0, 5.06812382d0,
     & 5.13244438d0, 5.19758654d0, 5.26355076d0, 5.33035135d0,
     & 5.39800024d0, 5.46650791d0, 5.53588486d0, 5.60614157d0,
     & 5.67729616d0, 5.74934816d0, 5.82231474d0, 5.89620686d0,
     & 5.97103739d0, 6.04681683d0, 6.12356472d0, 6.20128012d0,
     & 6.27998209d0, 6.35968304d0, 6.44039536d0, 6.52213240d0,
     & 6.60491228d0, 6.68873739d0, 6.77362537d0, 6.85959101d0,
     & 6.94664812d0, 7.03480911d0, 7.12408972d0, 7.21451092d0,
     & 7.30607176d0, 7.39879513d0, 7.49269533d0, 7.58778667d0,
     & 7.68408489d0, 7.78161287d0, 7.88037157d0, 7.98038340d0,
     & 8.08166409d0, 8.18422985d0, 8.28809834d0, 8.39328480d0,
     & 8.49981499d0, 8.60768700d0, 8.71692944d0, 8.82755852d0,
     & 8.93959141d0, 9.05304623d0, 9.16794872d0, 9.28430176d0,
     & 9.40213108d0, 9.52145576d0, 9.64229488d0, 9.76466751d0,
     & 9.88859367d0,10.01410198d0,10.14119339d0,10.26989746d0,
     &10.40023613d0,10.53222752d0,10.66589451d0,10.80126858d0,
     &10.93834972d0,11.07717133d0,11.21775436d0,11.36012173d0,
     &11.50429535d0,11.65031052d0,11.79816723d0,11.94790173d0,
     &12.09953499d0,12.25309372d0,12.40860081d0,12.56608105d0,
     &12.72557259d0,12.88707542d0,13.05062866d0,13.21625710d0,
     &13.38398838d0,13.55384827d0,13.72587585d0,13.90007496d0,
     &14.07648373d0,14.25513268d0,14.43604851d0,14.61925888d0,
     &14.80481052d0,14.99270153d0,15.18297768d0,15.37566853d0,
     &15.57080460d0,15.76841831d0,15.96853828d0,16.17121506d0,
     &16.37644768d0,16.58428574d0,16.79475975d0,17.00790787d0,
     &17.22375870d0,17.44236755d0,17.66373062d0,17.88790512d0,
     &18.11492538d0,18.34482765d0,18.57764626d0,18.81341934d0,
     &19.05220222d0,19.29399872d0,19.53886604d0,19.78683662d0,
     &20.03795815d0,20.29226303d0,20.54981613d0,20.81061935d0,
     &21.07473183d0,21.34219742d0,21.61305809d0,21.88735199d0,
     &22.16513062d0,22.44645500d0,22.73132896d0,23.01981735d0,
     &23.31196785d0,23.60782623d0,23.90743828d0,24.21087837d0,
     &24.51814270d0,24.82930946d0,25.14442444d0,25.46353912d0,
     &25.78670311d0,26.11399269d0,26.44541168d0,26.78103638d0,
     &27.12092209d0,27.46512032d0,27.81368637d0,28.16667747d0,
     &28.52417374d0,28.88618279d0,29.25278282d0,29.62404060d0,
     &30.00000572d0
     &/
c Definition of fits (4 deg polynomial) for doy=121
c A0=f(Lm) same for A1,A2,A3 and A4; to be used every where except Lm>7.5 and I> 1.
      DATA (Lm4 ( 5,I), I= 1,100) /
     & 1.10d0, 1.20d0, 1.30d0, 1.40d0, 1.50d0, 1.60d0, 1.70d0, 1.80d0,
     & 1.90d0, 2.00d0, 2.10d0, 2.20d0, 2.30d0, 2.40d0, 2.50d0, 2.60d0,
     & 2.70d0, 2.80d0, 2.90d0, 3.00d0, 3.10d0, 3.20d0, 3.30d0, 3.40d0,
     & 3.50d0, 3.60d0, 3.70d0, 3.80d0, 3.90d0, 4.00d0, 4.10d0, 4.20d0,
     & 4.30d0, 4.40d0, 4.50d0, 4.60d0, 4.70d0, 4.80d0, 4.90d0, 5.00d0,
     & 5.10d0, 5.20d0, 5.30d0, 5.40d0, 5.50d0, 5.60d0, 5.70d0, 5.80d0,
     & 5.90d0, 6.00d0, 6.10d0, 6.20d0, 6.30d0, 6.40d0, 6.50d0, 6.60d0,
     & 6.70d0, 6.80d0, 6.90d0, 7.00d0, 7.10d0, 7.20d0, 7.30d0, 7.40d0,
     & 7.50d0, 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0,
     & 8.30d0, 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0,
     & 9.10d0, 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0,
     & 9.90d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A0 ( 5,I), I= 1,100) /
     & 1.1012363899D+00, 1.2019458599D+00, 1.3018416418D+00,
     & 1.4015850309D+00, 1.5014778259D+00, 1.6007588890D+00,
     & 1.6997521894D+00, 1.7996289136D+00, 1.9005733589D+00,
     & 2.0002475696D+00, 2.0977680526D+00, 2.1991619710D+00,
     & 2.2972791212D+00, 2.3951773497D+00, 2.4879717190D+00,
     & 2.5841456242D+00, 2.6778330885D+00, 2.7745482917D+00,
     & 2.8662624455D+00, 2.9601182678D+00, 3.0518681137D+00,
     & 3.1442308545D+00, 3.2351459626D+00, 3.3231276778D+00,
     & 3.4145137362D+00, 3.5018742037D+00, 3.5920758404D+00,
     & 3.6773166626D+00, 3.7651325025D+00, 3.8507011801D+00,
     & 3.9382961189D+00, 4.0183673616D+00, 4.1060980397D+00,
     & 4.1884935770D+00, 4.2730766124D+00, 4.3563835129D+00,
     & 4.4386820241D+00, 4.5197101391D+00, 4.6022245767D+00,
     & 4.6804008617D+00, 4.7669161569D+00, 4.8483609852D+00,
     & 4.9254532864D+00, 5.0056584448D+00, 5.0855930926D+00,
     & 5.1691516823D+00, 5.2487113610D+00, 5.3313271852D+00,
     & 5.4130887244D+00, 5.4950186281D+00, 5.5775102061D+00,
     & 5.6606743802D+00, 5.7447331842D+00, 5.8273791509D+00,
     & 5.9129275183D+00, 5.9985709394D+00, 6.0849465678D+00,
     & 6.1706898650D+00, 6.2598084658D+00, 6.3490449031D+00,
     & 6.4373531456D+00, 6.5291347632D+00, 6.6211788296D+00,
     & 6.7132037122D+00, 6.8074246447D+00, 6.8971875855D+00,
     & 7.0095806784D+00, 7.1094196291D+00, 7.2161635653D+00,
     & 7.3289849860D+00, 7.4381804640D+00, 7.5631407356D+00,
     & 7.7001855227D+00, 7.8260661542D+00, 7.9374626051D+00,
     & 8.0727818497D+00, 8.2043831385D+00,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A1 ( 5,I), I= 1,100) /
     &-5.4601849694D-05, 1.9546547135D-04, 3.0527474424D-04,
     & 3.6165417690D-04, 3.5301582496D-04, 3.6376270264D-04,
     & 3.0724916617D-04, 3.3222791458D-04, 4.0102037714D-04,
     & 4.7431400610D-04, 5.2568046773D-04, 2.5996241301D-03,
     & 3.3645549302D-03, 4.6254115779D-03, 5.7007861768D-03,
     & 5.8305907147D-03, 8.9559276745D-03, 1.0707688102D-02,
     & 1.1080404515D-02, 1.2251413069D-02, 1.3609506922D-02,
     & 1.2908453373D-02, 1.4398077178D-02, 1.7276714824D-02,
     & 1.8057938929D-02, 2.0023808819D-02, 2.1807997078D-02,
     & 2.4108882835D-02, 2.4476486996D-02, 2.4831893555D-02,
     & 2.6141877302D-02, 2.7251653501D-02, 2.9393253097D-02,
     & 3.0612669680D-02, 3.1698485751D-02, 3.0246513412D-02,
     & 3.3004440372D-02, 3.4466152919D-02, 3.3848687740D-02,
     & 3.6444664763D-02, 3.5495433780D-02, 3.6443963997D-02,
     & 3.7836692661D-02, 3.6768291510D-02, 3.6510267026D-02,
     & 3.6883900068D-02, 3.6152180308D-02, 3.7437953773D-02,
     & 3.5340577851D-02, 3.6119925623D-02, 3.5668595063D-02,
     & 3.4528018420D-02, 3.2823039964D-02, 3.3313230317D-02,
     & 3.1954827270D-02, 3.0147294970D-02, 2.8818617556D-02,
     & 2.6651115108D-02, 2.4447719819D-02, 2.3393308327D-02,
     & 2.1993909855D-02, 1.8200950261D-02, 1.3842142590D-02,
     & 1.0524778599D-02, 6.4169857066D-03,-1.2167303301D-02,
     & 5.2289280633D-03,-6.8149374683D-03,-1.4349976008D-02,
     &-1.4657801122D-02,-3.5410796054D-02,-3.0466780608D-02,
     &-1.2078975982D-03,-6.3849187412D-03,-2.8050280984D-02,
     &-1.2680409114D-02, 1.5464232329D-02,-1.1980842535D-02,
     & 7.3457765075D-02,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A2 ( 5,I), I= 1,100) /
     &-4.2537997541D-07,-5.7142396357D-06, 7.0863124715D-06,
     & 1.8225826869D-05, 6.9886060933D-06, 1.3200861204D-05,
     & 1.2360815262D-05, 1.0407922991D-05, 1.1879082520D-05,
     & 2.3182749360D-05, 4.3246201752D-06, 6.3302775259D-04,
     & 5.2723989026D-04, 3.0648837580D-04, 8.3253897223D-04,
     & 1.0247511344D-03, 1.9263332326D-03, 2.0940966551D-03,
     & 2.4869160079D-03, 2.0846905740D-03, 3.4009643985D-03,
     & 2.6437889118D-03, 3.2766293641D-03, 4.2844250976D-03,
     & 4.1009581790D-03, 4.5353600836D-03, 5.0745228399D-03,
     & 5.7633737123D-03, 5.4043791682D-03, 6.4966443828D-03,
     & 6.0106702662D-03, 6.9964299843D-03, 6.6159319778D-03,
     & 6.9731894098D-03, 7.0840736150D-03, 7.2968489650D-03,
     & 7.6959088366D-03, 8.3928584370D-03, 8.5296524076D-03,
     & 8.9719797845D-03, 8.4495137517D-03, 8.7475128119D-03,
     & 8.6829516107D-03, 8.6336780017D-03, 9.4183088287D-03,
     & 8.9804903522D-03, 9.2393813847D-03, 8.8125355881D-03,
     & 9.3797905228D-03, 8.8220828452D-03, 7.8217615753D-03,
     & 8.2935098867D-03, 7.6169765072D-03, 7.8981490151D-03,
     & 6.8220776674D-03, 6.6205302498D-03, 6.2866739490D-03,
     & 6.4223091601D-03, 5.2552518348D-03, 4.4628808742D-03,
     & 4.3317006428D-03, 3.1627918523D-03, 2.6404643535D-03,
     & 2.5826185221D-03, 1.3318594626D-03,-5.1064991867D-03,
     & 1.4966792556D-04,-2.4677529313D-03,-4.1921720762D-03,
     &-6.5042601534D-03,-1.4973783604D-02,-1.1259040316D-02,
     & 4.4692177259D-04,-2.3459689525D-03,-9.9248738895D-03,
     &-4.0204644723D-03, 1.6010436893D-02, 1.6866186434D-02,
     & 1.6826715611D-01,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A3 ( 5,I), I= 1,100) /
     & 3.2385030276D-07,-1.2544361163D-06,-2.2950860637D-06,
     &-3.1696931087D-06,-2.7457594830D-06,-3.2274115913D-06,
     &-2.5788324569D-06,-2.9050523790D-06,-3.4071097937D-06,
     &-3.8273150341D-06,-5.4671647389D-06, 7.5559665011D-05,
     & 3.2037711045D-05,-5.9245783635D-05, 2.7058640154D-05,
     & 6.8875129332D-05, 1.6079855186D-04, 1.5366801257D-04,
     & 2.1373196167D-04, 1.0077049481D-04, 3.6258548889D-04,
     & 2.0445161339D-04, 3.1540495727D-04, 4.5374269179D-04,
     & 3.9455719536D-04, 4.2468708412D-04, 4.8825439587D-04,
     & 5.8244253341D-04, 4.8215933580D-04, 7.3050346505D-04,
     & 5.9127221298D-04, 7.4841529663D-04, 6.0580487426D-04,
     & 6.5705995578D-04, 6.3228916230D-04, 7.6589146311D-04,
     & 7.6836479980D-04, 8.6619431947D-04, 9.3159057468D-04,
     & 9.2380350208D-04, 8.5708147430D-04, 8.2051118085D-04,
     & 7.6693369947D-04, 8.5220626439D-04, 1.0274685552D-03,
     & 8.5366034249D-04, 9.9081628773D-04, 8.3769837893D-04,
     & 1.0414930976D-03, 8.8982942327D-04, 6.5727252082D-04,
     & 7.8832234576D-04, 6.9836823233D-04, 7.6299483665D-04,
     & 5.4601345126D-04, 4.9967571614D-04, 5.1065840782D-04,
     & 5.5764369161D-04, 3.7339694953D-04, 3.0151858016D-04,
     & 2.5164826783D-04, 1.7121012099D-04, 2.2514837330D-04,
     & 2.5005806753D-04, 1.6563902589D-04,-6.4552639849D-04,
     &-2.3163505060D-04,-4.6259303813D-04,-4.1191524760D-04,
     &-1.2352177297D-03,-2.5361733663D-03,-1.7491583577D-03,
     &-1.3339936988D-04,-6.8896348216D-04,-1.6622407104D-03,
     &-9.8946864197D-04, 3.1358922839D-03, 1.0348026413D-02,
     & 9.1756254045D-01,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A4 ( 5,I), I= 1,100) /
     &-1.8196398113D-08, 4.9214406612D-08,-1.2873385934D-07,
     &-3.1300939034D-07,-8.5241530870D-08,-2.6146759689D-07,
     &-1.8917042226D-07,-1.8992421880D-07,-2.4909539535D-07,
     &-3.5256366003D-07,-2.6472748398D-07, 3.4839722290D-06,
     & 5.9201409437D-07,-5.9048582306D-06,-1.2524210538D-06,
     & 1.3560724974D-06, 4.0527185679D-06, 2.8782134366D-06,
     & 5.4308777298D-06,-8.2420499603D-07, 1.3937604165D-05,
     & 4.8183675377D-06, 1.0605298229D-05, 1.7192441303D-05,
     & 1.3770367795D-05, 1.4120771675D-05, 1.6275773596D-05,
     & 2.1075410035D-05, 1.4453028420D-05, 2.9686497362D-05,
     & 2.0898250413D-05, 2.8165080188D-05, 1.8852036402D-05,
     & 2.1605818145D-05, 1.8693443605D-05, 2.9271847867D-05,
     & 2.7642077574D-05, 3.2016758502D-05, 3.6951443451D-05,
     & 3.3729159452D-05, 3.1132523272D-05, 2.5584538026D-05,
     & 2.1521294208D-05, 2.9787600418D-05, 4.0052960334D-05,
     & 2.6682024979D-05, 3.7817237328D-05, 2.7075023222D-05,
     & 4.1110235840D-05, 3.1264553133D-05, 1.6752311710D-05,
     & 2.5034772039D-05, 2.1063631289D-05, 2.5363810825D-05,
     & 1.2614198640D-05, 8.4625027887D-06, 1.1803982646D-05,
     & 1.4143852783D-05, 4.3126813819D-06, 3.5741837381D-06,
     & 3.8191649948D-07, 6.1341752551D-08, 7.2104009154D-06,
     & 7.0812689083D-06, 9.2022723786D-06,-2.4480883812D-05,
     &-1.9609691224D-05,-3.0014372204D-05,-1.0126976677D-05,
     &-7.4394001872D-05,-1.4024183158D-04,-8.9893376116D-05,
     &-1.6159352885D-05,-4.8879692541D-05,-8.7955677983D-05,
     &-6.2481554055D-05, 1.9876610820D-04, 1.5921338904D-03,
     & 1.7119974573D+00,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of fits (5 deg polynomial) for doy=121
c A50=f(Lm5) same for A51,A52,A53, A54 and A55
c To be used only where Lm>7.5 and I> 1.
      DATA (Lm5 ( 5,I), I= 1,100) /
     & 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0, 8.30d0,
     & 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0, 9.10d0,
     & 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0, 9.90d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A50 ( 5,I), I= 1,100) /
     & 6.9033246387D+00, 7.0065845919D+00, 7.1088776652D+00,
     & 7.2144410140D+00, 7.3244241247D+00, 7.4371551069D+00,
     & 7.5582665857D+00, 7.6872628089D+00, 7.8197687393D+00,
     & 7.9386999349D+00, 8.0775717131D+00, 8.1967552793D+00,
     & 8.3184542125D+00, 8.4493040685D+00, 8.7896714638D+00,
     & 9.6295659120D+00, 1.0778439683D+01, 1.1373580970D+01,
     & 1.1555636365D+01, 1.5439128527D+01, 1.5532916611D+01,
     & 1.1225381739D+01, 1.6387089251D+01, 2.0222643904D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A51 ( 5,I), I= 1,100) /
     & 1.3153172419D-02,-1.0114079849D-02,-8.1947391575D-03,
     &-2.6217894593D-02,-3.9226122669D-02,-5.6347287937D-02,
     &-8.3466847206D-02,-1.0073773332D-01,-8.4513469482D-02,
     & 1.2312107206D-02, 2.0753924525D-02, 7.0782386345D-02,
     & 7.3494148570D-02, 1.1792722829D-01,-8.3244991793D-02,
     &-1.9911588019D+00,-4.4430826067D+00,-5.0645335034D+00,
     &-4.5063742990D+00,-1.3328028480D+01,-1.2515294955D+01,
     &-6.9932688615D-01,-1.1878190096D+01,-1.9727695388D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A52 ( 5,I), I= 1,100) /
     & 6.3464619002D-03, 1.6755620004D-02,-9.0132221287D-03,
     & 2.1923583656D-02, 3.3975417414D-02, 4.3258123564D-02,
     & 5.8143523467D-02, 1.5174690216D-02,-1.0074544574D-01,
     &-3.1467281929D-01,-3.6518932253D-01,-4.0206310649D-01,
     &-3.0946308614D-01,-3.4372040556D-01,-5.2856650640D-01,
     & 1.5495964992D+00, 3.9149375597D+00, 4.0912876822D+00,
     & 3.0208355179D+00, 1.1271801782D+01, 1.0025333327D+01,
     &-1.9399049026D+00, 8.1102437552D+00, 1.4851780430D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A53 ( 5,I), I= 1,100) /
     &-1.7115869450D-02,-6.3545050728D-03, 1.3348552635D-02,
     &-2.4456348303D-02,-4.1521106945D-02,-4.9483416190D-02,
     &-6.1041017290D-02,-4.4242359550D-03, 1.0405481448D-01,
     & 2.5258362572D-01, 2.7338390868D-01, 2.4232530485D-01,
     & 9.8566359678D-02, 7.4003536995D-02, 3.5418412047D-01,
     &-7.8138184301D-01,-1.9261177535D+00,-1.8431419017D+00,
     &-1.1364368181D+00,-4.9654536388D+00,-4.2430899399D+00,
     & 1.5892104946D+00,-2.9631810637D+00,-5.8773090837D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A54 ( 5,I), I= 1,100) /
     & 8.5640957121D-03,-3.3140877300D-03,-9.0133067454D-03,
     & 8.4680392067D-03, 1.5750505156D-02, 1.7926652573D-02,
     & 2.2917118276D-02,-3.5058022558D-03,-4.4575800731D-02,
     &-8.9033019929D-02,-9.0317405556D-02,-6.4521722259D-02,
     & 1.8473885655D-04, 1.8896332725D-02,-9.5366499671D-02,
     & 2.0708448815D-01, 4.7963540569D-01, 4.2416433549D-01,
     & 2.1915167045D-01, 1.0948037290D+00, 9.0786896687D-01,
     &-4.7479398773D-01, 5.5618364291D-01, 1.1828245184D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A55 ( 5,I), I= 1,100) /
     &-1.3194093315D-03, 1.3796985158D-03, 1.8739599459D-03,
     &-8.4242968614D-04,-1.7388133408D-03,-1.8121709561D-03,
     &-2.6606939596D-03, 1.5251342143D-03, 7.0517922897D-03,
     & 1.1914618425D-02, 1.1541846417D-02, 6.9334804538D-03,
     &-2.3199326888D-03,-5.3217242499D-03, 9.8880526458D-03,
     &-2.1317714964D-02,-4.6725951837D-02,-3.8435631422D-02,
     &-1.6291235170D-02,-9.5038784053D-02,-7.6944486255D-02,
     & 5.1259692574D-02,-4.1735665946D-02,-9.5043058546D-02,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of Loss cone as Lmax=f(Imax) for doy=151
      DATA (Lmax ( 6,I), I= 1, 2100) /
     & 1.0854d0, 1.0865d0, 1.0875d0, 1.0885d0, 1.0894d0, 1.0904d0,
     & 1.0914d0, 1.0924d0, 1.0934d0, 1.0944d0, 1.0954d0, 1.0964d0,
     & 1.0974d0, 1.0984d0, 1.0994d0, 1.1004d0, 1.1014d0, 1.1024d0,
     & 1.1034d0, 1.1044d0, 1.1054d0, 1.1065d0, 1.1075d0, 1.1085d0,
     & 1.1095d0, 1.1105d0, 1.1116d0, 1.1126d0, 1.1136d0, 1.1146d0,
     & 1.1156d0, 1.1167d0, 1.1177d0, 1.1187d0, 1.1197d0, 1.1208d0,
     & 1.1218d0, 1.1228d0, 1.1238d0, 1.1249d0, 1.1259d0, 1.1269d0,
     & 1.1279d0, 1.1290d0, 1.1300d0, 1.1310d0, 1.1321d0, 1.1331d0,
     & 1.1341d0, 1.1351d0, 1.1362d0, 1.1372d0, 1.1382d0, 1.1392d0,
     & 1.1403d0, 1.1413d0, 1.1423d0, 1.1433d0, 1.1444d0, 1.1454d0,
     & 1.1464d0, 1.1475d0, 1.1485d0, 1.1495d0, 1.1506d0, 1.1516d0,
     & 1.1526d0, 1.1536d0, 1.1547d0, 1.1557d0, 1.1567d0, 1.1577d0,
     & 1.1588d0, 1.1598d0, 1.1608d0, 1.1618d0, 1.1629d0, 1.1639d0,
     & 1.1649d0, 1.1660d0, 1.1670d0, 1.1680d0, 1.1690d0, 1.1701d0,
     & 1.1711d0, 1.1721d0, 1.1732d0, 1.1742d0, 1.1752d0, 1.1762d0,
     & 1.1773d0, 1.1783d0, 1.1793d0, 1.1804d0, 1.1814d0, 1.1824d0,
     & 1.1834d0, 1.1845d0, 1.1855d0, 1.1865d0, 1.1876d0, 1.1886d0,
     & 1.1896d0, 1.1906d0, 1.1917d0, 1.1927d0, 1.1937d0, 1.1948d0,
     & 1.1958d0, 1.1968d0, 1.1978d0, 1.1988d0, 1.1999d0, 1.2009d0,
     & 1.2019d0, 1.2029d0, 1.2040d0, 1.2050d0, 1.2060d0, 1.2071d0,
     & 1.2081d0, 1.2091d0, 1.2101d0, 1.2112d0, 1.2122d0, 1.2132d0,
     & 1.2142d0, 1.2153d0, 1.2163d0, 1.2173d0, 1.2183d0, 1.2194d0,
     & 1.2204d0, 1.2214d0, 1.2224d0, 1.2235d0, 1.2245d0, 1.2255d0,
     & 1.2265d0, 1.2276d0, 1.2286d0, 1.2296d0, 1.2306d0, 1.2317d0,
     & 1.2327d0, 1.2337d0, 1.2347d0, 1.2358d0, 1.2368d0, 1.2378d0,
     & 1.2388d0, 1.2399d0, 1.2409d0, 1.2419d0, 1.2429d0, 1.2440d0,
     & 1.2450d0, 1.2460d0, 1.2470d0, 1.2480d0, 1.2491d0, 1.2501d0,
     & 1.2511d0, 1.2522d0, 1.2532d0, 1.2542d0, 1.2552d0, 1.2562d0,
     & 1.2572d0, 1.2583d0, 1.2593d0, 1.2603d0, 1.2614d0, 1.2624d0,
     & 1.2634d0, 1.2644d0, 1.2654d0, 1.2665d0, 1.2675d0, 1.2685d0,
     & 1.2695d0, 1.2706d0, 1.2716d0, 1.2726d0, 1.2736d0, 1.2746d0,
     & 1.2756d0, 1.2767d0, 1.2777d0, 1.2787d0, 1.2798d0, 1.2808d0,
     & 1.2818d0, 1.2828d0, 1.2838d0, 1.2848d0, 1.2859d0, 1.2869d0,
     & 1.2879d0, 1.2890d0, 1.2900d0, 1.2910d0, 1.2920d0, 1.2930d0,
     & 1.2940d0, 1.2951d0, 1.2961d0, 1.2971d0, 1.2981d0, 1.2992d0,
     & 1.3002d0, 1.3012d0, 1.3022d0, 1.3032d0, 1.3043d0, 1.3053d0,
     & 1.3063d0, 1.3073d0, 1.3083d0, 1.3093d0, 1.3104d0, 1.3114d0,
     & 1.3124d0, 1.3134d0, 1.3144d0, 1.3155d0, 1.3165d0, 1.3175d0,
     & 1.3185d0, 1.3195d0, 1.3206d0, 1.3216d0, 1.3226d0, 1.3236d0,
     & 1.3246d0, 1.3257d0, 1.3267d0, 1.3277d0, 1.3287d0, 1.3297d0,
     & 1.3307d0, 1.3318d0, 1.3328d0, 1.3338d0, 1.3348d0, 1.3358d0,
     & 1.3369d0, 1.3379d0, 1.3389d0, 1.3399d0, 1.3409d0, 1.3420d0,
     & 1.3430d0, 1.3440d0, 1.3450d0, 1.3460d0, 1.3470d0, 1.3481d0,
     & 1.3491d0, 1.3501d0, 1.3511d0, 1.3521d0, 1.3531d0, 1.3542d0,
     & 1.3552d0, 1.3562d0, 1.3572d0, 1.3582d0, 1.3592d0, 1.3603d0,
     & 1.3613d0, 1.3623d0, 1.3633d0, 1.3644d0, 1.3653d0, 1.3664d0,
     & 1.3674d0, 1.3684d0, 1.3694d0, 1.3704d0, 1.3714d0, 1.3725d0,
     & 1.3735d0, 1.3745d0, 1.3755d0, 1.3766d0, 1.3776d0, 1.3785d0,
     & 1.3796d0, 1.3806d0, 1.3816d0, 1.3826d0, 1.3836d0, 1.3847d0,
     & 1.3857d0, 1.3867d0, 1.3877d0, 1.3887d0, 1.3898d0, 1.3907d0,
     & 1.3917d0, 1.3928d0, 1.3938d0, 1.3948d0, 1.3958d0, 1.3968d0,
     & 1.3979d0, 1.3989d0, 1.3999d0, 1.4009d0, 1.4020d0, 1.4030d0,
     & 1.4040d0, 1.4049d0, 1.4059d0, 1.4070d0, 1.4080d0, 1.4090d0,
     & 1.4100d0, 1.4110d0, 1.4121d0, 1.4131d0, 1.4141d0, 1.4151d0,
     & 1.4162d0, 1.4172d0, 1.4181d0, 1.4191d0, 1.4201d0, 1.4211d0,
     & 1.4221d0, 1.4232d0, 1.4242d0, 1.4252d0, 1.4262d0, 1.4273d0,
     & 1.4283d0, 1.4293d0, 1.4303d0, 1.4313d0, 1.4323d0, 1.4333d0,
     & 1.4343d0, 1.4353d0, 1.4363d0, 1.4373d0, 1.4384d0, 1.4394d0,
     & 1.4404d0, 1.4414d0, 1.4424d0, 1.4435d0, 1.4445d0, 1.4455d0,
     & 1.4465d0, 1.4475d0, 1.4485d0, 1.4495d0, 1.4505d0, 1.4515d0,
     & 1.4525d0, 1.4535d0, 1.4545d0, 1.4556d0, 1.4566d0, 1.4576d0,
     & 1.4586d0, 1.4597d0, 1.4607d0, 1.4617d0, 1.4627d0, 1.4637d0,
     & 1.4647d0, 1.4656d0, 1.4667d0, 1.4677d0, 1.4687d0, 1.4697d0,
     & 1.4707d0, 1.4717d0, 1.4728d0, 1.4738d0, 1.4748d0, 1.4759d0,
     & 1.4769d0, 1.4779d0, 1.4789d0, 1.4799d0, 1.4808d0, 1.4818d0,
     & 1.4828d0, 1.4838d0, 1.4849d0, 1.4859d0, 1.4869d0, 1.4879d0,
     & 1.4890d0, 1.4900d0, 1.4910d0, 1.4920d0, 1.4931d0, 1.4941d0,
     & 1.4950d0, 1.4960d0, 1.4970d0, 1.4980d0, 1.4990d0, 1.5000d0,
     & 1.5010d0, 1.5020d0, 1.5031d0, 1.5041d0, 1.5051d0, 1.5061d0,
     & 1.5072d0, 1.5082d0, 1.5092d0, 1.5102d0, 1.5112d0, 1.5122d0,
     & 1.5132d0, 1.5142d0, 1.5151d0, 1.5161d0, 1.5172d0, 1.5182d0,
     & 1.5192d0, 1.5202d0, 1.5212d0, 1.5223d0, 1.5233d0, 1.5243d0,
     & 1.5253d0, 1.5264d0, 1.5274d0, 1.5284d0, 1.5294d0, 1.5304d0,
     & 1.5313d0, 1.5323d0, 1.5333d0, 1.5343d0, 1.5353d0, 1.5363d0,
     & 1.5374d0, 1.5384d0, 1.5394d0, 1.5404d0, 1.5415d0, 1.5425d0,
     & 1.5435d0, 1.5445d0, 1.5455d0, 1.5465d0, 1.5475d0, 1.5485d0,
     & 1.5495d0, 1.5505d0, 1.5515d0, 1.5525d0, 1.5535d0, 1.5545d0,
     & 1.5555d0, 1.5565d0, 1.5576d0, 1.5586d0, 1.5596d0, 1.5607d0,
     & 1.5617d0, 1.5627d0, 1.5637d0, 1.5647d0, 1.5657d0, 1.5667d0,
     & 1.5676d0, 1.5686d0, 1.5696d0, 1.5706d0, 1.5716d0, 1.5727d0,
     & 1.5737d0, 1.5747d0, 1.5757d0, 1.5768d0, 1.5778d0, 1.5788d0,
     & 1.5798d0, 1.5809d0, 1.5819d0, 1.5828d0, 1.5838d0, 1.5848d0,
     & 1.5858d0, 1.5868d0, 1.5878d0, 1.5888d0, 1.5898d0, 1.5908d0,
     & 1.5918d0, 1.5928d0, 1.5938d0, 1.5949d0, 1.5959d0, 1.5969d0,
     & 1.5980d0, 1.5990d0, 1.6000d0, 1.6010d0, 1.6020d0, 1.6030d0,
     & 1.6040d0, 1.6049d0, 1.6059d0, 1.6069d0, 1.6079d0, 1.6089d0,
     & 1.6099d0, 1.6109d0, 1.6119d0, 1.6129d0, 1.6140d0, 1.6150d0,
     & 1.6160d0, 1.6171d0, 1.6181d0, 1.6191d0, 1.6201d0, 1.6211d0,
     & 1.6221d0, 1.6231d0, 1.6241d0, 1.6251d0, 1.6261d0, 1.6270d0,
     & 1.6280d0, 1.6290d0, 1.6300d0, 1.6310d0, 1.6321d0, 1.6331d0,
     & 1.6341d0, 1.6351d0, 1.6362d0, 1.6372d0, 1.6382d0, 1.6393d0,
     & 1.6403d0, 1.6413d0, 1.6423d0, 1.6433d0, 1.6442d0, 1.6452d0,
     & 1.6462d0, 1.6472d0, 1.6482d0, 1.6491d0, 1.6501d0, 1.6511d0,
     & 1.6522d0, 1.6532d0, 1.6542d0, 1.6552d0, 1.6563d0, 1.6573d0,
     & 1.6583d0, 1.6594d0, 1.6604d0, 1.6614d0, 1.6624d0, 1.6634d0,
     & 1.6644d0, 1.6654d0, 1.6664d0, 1.6673d0, 1.6683d0, 1.6693d0,
     & 1.6703d0, 1.6712d0, 1.6722d0, 1.6732d0, 1.6743d0, 1.6753d0,
     & 1.6763d0, 1.6773d0, 1.6784d0, 1.6794d0, 1.6804d0, 1.6815d0,
     & 1.6825d0, 1.6835d0, 1.6845d0, 1.6855d0, 1.6865d0, 1.6875d0,
     & 1.6885d0, 1.6895d0, 1.6904d0, 1.6914d0, 1.6924d0, 1.6934d0,
     & 1.6943d0, 1.6953d0, 1.6964d0, 1.6974d0, 1.6984d0, 1.6994d0,
     & 1.7005d0, 1.7015d0, 1.7025d0, 1.7036d0, 1.7046d0, 1.7056d0,
     & 1.7066d0, 1.7076d0, 1.7086d0, 1.7096d0, 1.7106d0, 1.7116d0,
     & 1.7126d0, 1.7136d0, 1.7145d0, 1.7155d0, 1.7165d0, 1.7175d0,
     & 1.7184d0, 1.7194d0, 1.7205d0, 1.7215d0, 1.7225d0, 1.7235d0,
     & 1.7246d0, 1.7256d0, 1.7266d0, 1.7277d0, 1.7287d0, 1.7297d0,
     & 1.7307d0, 1.7317d0, 1.7327d0, 1.7337d0, 1.7347d0, 1.7357d0,
     & 1.7367d0, 1.7377d0, 1.7386d0, 1.7396d0, 1.7406d0, 1.7416d0,
     & 1.7426d0, 1.7436d0, 1.7446d0, 1.7456d0, 1.7466d0, 1.7477d0,
     & 1.7487d0, 1.7497d0, 1.7508d0, 1.7518d0, 1.7528d0, 1.7538d0,
     & 1.7549d0, 1.7558d0, 1.7568d0, 1.7578d0, 1.7588d0, 1.7598d0,
     & 1.7608d0, 1.7618d0, 1.7627d0, 1.7637d0, 1.7647d0, 1.7657d0,
     & 1.7666d0, 1.7676d0, 1.7687d0, 1.7697d0, 1.7707d0, 1.7717d0,
     & 1.7728d0, 1.7738d0, 1.7748d0, 1.7759d0, 1.7769d0, 1.7779d0,
     & 1.7789d0, 1.7799d0, 1.7809d0, 1.7819d0, 1.7829d0, 1.7839d0,
     & 1.7849d0, 1.7859d0, 1.7868d0, 1.7878d0, 1.7888d0, 1.7898d0,
     & 1.7908d0, 1.7917d0, 1.7927d0, 1.7937d0, 1.7948d0, 1.7958d0,
     & 1.7968d0, 1.7978d0, 1.7989d0, 1.7999d0, 1.8010d0, 1.8020d0,
     & 1.8030d0, 1.8040d0, 1.8051d0, 1.8061d0, 1.8070d0, 1.8080d0,
     & 1.8090d0, 1.8100d0, 1.8110d0, 1.8120d0, 1.8129d0, 1.8139d0,
     & 1.8149d0, 1.8159d0, 1.8168d0, 1.8178d0, 1.8188d0, 1.8198d0,
     & 1.8208d0, 1.8218d0, 1.8229d0, 1.8239d0, 1.8249d0, 1.8260d0,
     & 1.8270d0, 1.8281d0, 1.8291d0, 1.8301d0, 1.8311d0, 1.8321d0,
     & 1.8331d0, 1.8341d0, 1.8351d0, 1.8361d0, 1.8371d0, 1.8381d0,
     & 1.8390d0, 1.8400d0, 1.8410d0, 1.8420d0, 1.8430d0, 1.8439d0,
     & 1.8449d0, 1.8459d0, 1.8469d0, 1.8479d0, 1.8489d0, 1.8499d0,
     & 1.8510d0, 1.8520d0, 1.8530d0, 1.8541d0, 1.8551d0, 1.8562d0,
     & 1.8572d0, 1.8582d0, 1.8592d0, 1.8602d0, 1.8612d0, 1.8622d0,
     & 1.8632d0, 1.8642d0, 1.8652d0, 1.8661d0, 1.8671d0, 1.8681d0,
     & 1.8691d0, 1.8701d0, 1.8710d0, 1.8720d0, 1.8730d0, 1.8740d0,
     & 1.8750d0, 1.8760d0, 1.8770d0, 1.8780d0, 1.8790d0, 1.8801d0,
     & 1.8811d0, 1.8821d0, 1.8832d0, 1.8842d0, 1.8853d0, 1.8863d0,
     & 1.8873d0, 1.8883d0, 1.8893d0, 1.8903d0, 1.8913d0, 1.8923d0,
     & 1.8933d0, 1.8942d0, 1.8952d0, 1.8962d0, 1.8972d0, 1.8981d0,
     & 1.8991d0, 1.9001d0, 1.9011d0, 1.9020d0, 1.9030d0, 1.9040d0,
     & 1.9050d0, 1.9060d0, 1.9071d0, 1.9081d0, 1.9091d0, 1.9102d0,
     & 1.9112d0, 1.9122d0, 1.9133d0, 1.9143d0, 1.9153d0, 1.9164d0,
     & 1.9174d0, 1.9184d0, 1.9194d0, 1.9204d0, 1.9213d0, 1.9223d0,
     & 1.9233d0, 1.9243d0, 1.9253d0, 1.9263d0, 1.9272d0, 1.9282d0,
     & 1.9292d0, 1.9302d0, 1.9311d0, 1.9321d0, 1.9331d0, 1.9341d0,
     & 1.9351d0, 1.9361d0, 1.9371d0, 1.9381d0, 1.9392d0, 1.9402d0,
     & 1.9412d0, 1.9423d0, 1.9433d0, 1.9444d0, 1.9454d0, 1.9464d0,
     & 1.9474d0, 1.9484d0, 1.9494d0, 1.9504d0, 1.9514d0, 1.9524d0,
     & 1.9534d0, 1.9544d0, 1.9553d0, 1.9563d0, 1.9573d0, 1.9583d0,
     & 1.9593d0, 1.9602d0, 1.9612d0, 1.9622d0, 1.9632d0, 1.9642d0,
     & 1.9652d0, 1.9662d0, 1.9672d0, 1.9682d0, 1.9693d0, 1.9703d0,
     & 1.9713d0, 1.9724d0, 1.9734d0, 1.9745d0, 1.9755d0, 1.9765d0,
     & 1.9775d0, 1.9785d0, 1.9795d0, 1.9805d0, 1.9815d0, 1.9825d0,
     & 1.9835d0, 1.9845d0, 1.9854d0, 1.9864d0, 1.9874d0, 1.9884d0,
     & 1.9894d0, 1.9903d0, 1.9913d0, 1.9923d0, 1.9933d0, 1.9942d0,
     & 1.9952d0, 1.9962d0, 1.9972d0, 1.9982d0, 1.9992d0, 2.0003d0,
     & 2.0013d0, 2.0023d0, 2.0034d0, 2.0044d0, 2.0055d0, 2.0065d0,
     & 2.0076d0, 2.0086d0, 2.0096d0, 2.0106d0, 2.0116d0, 2.0126d0,
     & 2.0136d0, 2.0145d0, 2.0155d0, 2.0165d0, 2.0175d0, 2.0185d0,
     & 2.0195d0, 2.0204d0, 2.0214d0, 2.0224d0, 2.0234d0, 2.0244d0,
     & 2.0253d0, 2.0263d0, 2.0273d0, 2.0283d0, 2.0292d0, 2.0302d0,
     & 2.0312d0, 2.0322d0, 2.0332d0, 2.0342d0, 2.0353d0, 2.0363d0,
     & 2.0374d0, 2.0384d0, 2.0394d0, 2.0405d0, 2.0415d0, 2.0426d0,
     & 2.0436d0, 2.0446d0, 2.0456d0, 2.0466d0, 2.0476d0, 2.0486d0,
     & 2.0496d0, 2.0505d0, 2.0515d0, 2.0525d0, 2.0535d0, 2.0545d0,
     & 2.0555d0, 2.0564d0, 2.0574d0, 2.0584d0, 2.0593d0, 2.0603d0,
     & 2.0613d0, 2.0623d0, 2.0632d0, 2.0642d0, 2.0652d0, 2.0663d0,
     & 2.0673d0, 2.0683d0, 2.0694d0, 2.0704d0, 2.0715d0, 2.0725d0,
     & 2.0736d0, 2.0746d0, 2.0756d0, 2.0766d0, 2.0776d0, 2.0786d0,
     & 2.0796d0, 2.0806d0, 2.0817d0, 2.0829d0, 2.0839d0, 2.0848d0,
     & 2.0858d0, 2.0868d0, 2.0878d0, 2.0888d0, 2.0897d0, 2.0907d0,
     & 2.0917d0, 2.0925d0, 2.0934d0, 2.0944d0, 2.0953d0, 2.0963d0,
     & 2.0973d0, 2.0982d0, 2.0992d0, 2.1003d0, 2.1013d0, 2.1023d0,
     & 2.1033d0, 2.1044d0, 2.1054d0, 2.1065d0, 2.1075d0, 2.1086d0,
     & 2.1096d0, 2.1106d0, 2.1116d0, 2.1126d0, 2.1136d0, 2.1146d0,
     & 2.1156d0, 2.1166d0, 2.1176d0, 2.1186d0, 2.1196d0, 2.1205d0,
     & 2.1215d0, 2.1225d0, 2.1235d0, 2.1245d0, 2.1254d0, 2.1264d0,
     & 2.1274d0, 2.1284d0, 2.1293d0, 2.1303d0, 2.1313d0, 2.1323d0,
     & 2.1333d0, 2.1343d0, 2.1353d0, 2.1364d0, 2.1374d0, 2.1384d0,
     & 2.1395d0, 2.1405d0, 2.1415d0, 2.1426d0, 2.1436d0, 2.1446d0,
     & 2.1456d0, 2.1466d0, 2.1476d0, 2.1486d0, 2.1496d0, 2.1506d0,
     & 2.1516d0, 2.1526d0, 2.1536d0, 2.1546d0, 2.1556d0, 2.1566d0,
     & 2.1577d0, 2.1586d0, 2.1596d0, 2.1606d0, 2.1616d0, 2.1625d0,
     & 2.1635d0, 2.1645d0, 2.1654d0, 2.1663d0, 2.1674d0, 2.1685d0,
     & 2.1696d0, 2.1707d0, 2.1718d0, 2.1729d0, 2.1740d0, 2.1751d0,
     & 2.1761d0, 2.1772d0, 2.1782d0, 2.1792d0, 2.1801d0, 2.1810d0,
     & 2.1820d0, 2.1829d0, 2.1838d0, 2.1847d0, 2.1857d0, 2.1866d0,
     & 2.1876d0, 2.1885d0, 2.1894d0, 2.1904d0, 2.1914d0, 2.1923d0,
     & 2.1933d0, 2.1943d0, 2.1953d0, 2.1962d0, 2.1972d0, 2.1983d0,
     & 2.1993d0, 2.2003d0, 2.2014d0, 2.2025d0, 2.2035d0, 2.2044d0,
     & 2.2054d0, 2.2064d0, 2.2074d0, 2.2085d0, 2.2094d0, 2.2104d0,
     & 2.2114d0, 2.2124d0, 2.2133d0, 2.2143d0, 2.2154d0, 2.2164d0,
     & 2.2175d0, 2.2185d0, 2.2195d0, 2.2205d0, 2.2215d0, 2.2225d0,
     & 2.2236d0, 2.2246d0, 2.2256d0, 2.2266d0, 2.2276d0, 2.2286d0,
     & 2.2295d0, 2.2305d0, 2.2315d0, 2.2325d0, 2.2335d0, 2.2343d0,
     & 2.2353d0, 2.2363d0, 2.2372d0, 2.2382d0, 2.2392d0, 2.2403d0,
     & 2.2413d0, 2.2423d0, 2.2434d0, 2.2444d0, 2.2454d0, 2.2464d0,
     & 2.2474d0, 2.2484d0, 2.2495d0, 2.2504d0, 2.2514d0, 2.2524d0,
     & 2.2534d0, 2.2544d0, 2.2553d0, 2.2563d0, 2.2574d0, 2.2584d0,
     & 2.2594d0, 2.2604d0, 2.2614d0, 2.2624d0, 2.2634d0, 2.2644d0,
     & 2.2655d0, 2.2666d0, 2.2675d0, 2.2685d0, 2.2694d0, 2.2704d0,
     & 2.2714d0, 2.2732d0, 2.2759d0, 2.2793d0, 2.2835d0, 2.2885d0,
     & 2.2944d0, 2.3011d0, 2.3087d0, 2.3170d0, 2.3262d0, 2.3362d0,
     & 2.3461d0, 2.3560d0, 2.3659d0, 2.3759d0, 2.3859d0, 2.3957d0,
     & 2.4057d0, 2.4156d0, 2.4255d0, 2.4354d0, 2.4453d0, 2.4553d0,
     & 2.4652d0, 2.4751d0, 2.4849d0, 2.4948d0, 2.5048d0, 2.5146d0,
     & 2.5245d0, 2.5344d0, 2.5443d0, 2.5543d0, 2.5642d0, 2.5741d0,
     & 2.5841d0, 2.5940d0, 2.6039d0, 2.6138d0, 2.6237d0, 2.6336d0,
     & 2.6436d0, 2.6535d0, 2.6634d0, 2.6733d0, 2.6831d0, 2.6930d0,
     & 2.7030d0, 2.7129d0, 2.7227d0, 2.7326d0, 2.7425d0, 2.7524d0,
     & 2.7623d0, 2.7721d0, 2.7821d0, 2.7920d0, 2.8019d0, 2.8118d0,
     & 2.8217d0, 2.8316d0, 2.8415d0, 2.8514d0, 2.8613d0, 2.8712d0,
     & 2.8811d0, 2.8910d0, 2.9009d0, 2.9107d0, 2.9206d0, 2.9305d0,
     & 2.9404d0, 2.9503d0, 2.9603d0, 2.9701d0, 2.9799d0, 2.9899d0,
     & 2.9997d0, 3.0096d0, 3.0195d0, 3.0294d0, 3.0393d0, 3.0492d0,
     & 3.0590d0, 3.0689d0, 3.0788d0, 3.0886d0, 3.0985d0, 3.1084d0,
     & 3.1183d0, 3.1282d0, 3.1380d0, 3.1479d0, 3.1578d0, 3.1678d0,
     & 3.1777d0, 3.1876d0, 3.1976d0, 3.2074d0, 3.2174d0, 3.2272d0,
     & 3.2371d0, 3.2470d0, 3.2569d0, 3.2667d0, 3.2765d0, 3.2862d0,
     & 3.2961d0, 3.3060d0, 3.3160d0, 3.3258d0, 3.3356d0, 3.3455d0,
     & 3.3553d0, 3.3652d0, 3.3751d0, 3.3850d0, 3.3949d0, 3.4047d0,
     & 3.4145d0, 3.4243d0, 3.4341d0, 3.4439d0, 3.4537d0, 3.4636d0,
     & 3.4735d0, 3.4833d0, 3.4931d0, 3.5030d0, 3.5128d0, 3.5227d0,
     & 3.5326d0, 3.5425d0, 3.5525d0, 3.5623d0, 3.5722d0, 3.5820d0,
     & 3.5918d0, 3.6016d0, 3.6116d0, 3.6214d0, 3.6314d0, 3.6412d0,
     & 3.6511d0, 3.6610d0, 3.6709d0, 3.6807d0, 3.6905d0, 3.7004d0,
     & 3.7103d0, 3.7202d0, 3.7300d0, 3.7398d0, 3.7496d0, 3.7594d0,
     & 3.7692d0, 3.7790d0, 3.7889d0, 3.7988d0, 3.8086d0, 3.8184d0,
     & 3.8282d0, 3.8380d0, 3.8478d0, 3.8578d0, 3.8677d0, 3.8775d0,
     & 3.8873d0, 3.8972d0, 3.9071d0, 3.9169d0, 3.9268d0, 3.9367d0,
     & 3.9466d0, 3.9566d0, 3.9664d0, 3.9763d0, 3.9861d0, 3.9960d0,
     & 4.0057d0, 4.0155d0, 4.0253d0, 4.0351d0, 4.0451d0, 4.0549d0,
     & 4.0648d0, 4.0746d0, 4.0845d0, 4.0943d0, 4.1042d0, 4.1141d0,
     & 4.1240d0, 4.1339d0, 4.1438d0, 4.1535d0, 4.1633d0, 4.1731d0,
     & 4.1830d0, 4.1928d0, 4.2027d0, 4.2126d0, 4.2225d0, 4.2323d0,
     & 4.2421d0, 4.2519d0, 4.2619d0, 4.2718d0, 4.2817d0, 4.2916d0,
     & 4.3015d0, 4.3114d0, 4.3212d0, 4.3310d0, 4.3409d0, 4.3508d0,
     & 4.3606d0, 4.3705d0, 4.3803d0, 4.3902d0, 4.4001d0, 4.4100d0,
     & 4.4199d0, 4.4298d0, 4.4397d0, 4.4495d0, 4.4594d0, 4.4694d0,
     & 4.4793d0, 4.4892d0, 4.4990d0, 4.5089d0, 4.5188d0, 4.5288d0,
     & 4.5387d0, 4.5487d0, 4.5586d0, 4.5685d0, 4.5783d0, 4.5881d0,
     & 4.5979d0, 4.6078d0, 4.6177d0, 4.6276d0, 4.6375d0, 4.6474d0,
     & 4.6573d0, 4.6672d0, 4.6770d0, 4.6870d0, 4.6970d0, 4.7070d0,
     & 4.7168d0, 4.7267d0, 4.7366d0, 4.7465d0, 4.7565d0, 4.7664d0,
     & 4.7764d0, 4.7864d0, 4.7963d0, 4.8062d0, 4.8161d0, 4.8260d0,
     & 4.8358d0, 4.8456d0, 4.8555d0, 4.8653d0, 4.8752d0, 4.8851d0,
     & 4.8951d0, 4.9051d0, 4.9151d0, 4.9251d0, 4.9351d0, 4.9452d0,
     & 4.9551d0, 4.9650d0, 4.9751d0, 4.9850d0, 4.9949d0, 5.0049d0,
     & 5.0149d0, 5.0248d0, 5.0347d0, 5.0448d0, 5.0548d0, 5.0649d0,
     & 5.0749d0, 5.0850d0, 5.0950d0, 5.1048d0, 5.1147d0, 5.1245d0,
     & 5.1344d0, 5.1444d0, 5.1543d0, 5.1644d0, 5.1743d0, 5.1844d0,
     & 5.1944d0, 5.2044d0, 5.2145d0, 5.2246d0, 5.2346d0, 5.2446d0,
     & 5.2546d0, 5.2646d0, 5.2746d0, 5.2847d0, 5.2946d0, 5.3046d0,
     & 5.3147d0, 5.3247d0, 5.3348d0, 5.3449d0, 5.3551d0, 5.3652d0,
     & 5.3752d0, 5.3851d0, 5.3950d0, 5.4051d0, 5.4150d0, 5.4250d0,
     & 5.4351d0, 5.4452d0, 5.4553d0, 5.4654d0, 5.4756d0, 5.4857d0,
     & 5.4959d0, 5.5061d0, 5.5163d0, 5.5265d0, 5.5366d0, 5.5466d0,
     & 5.5567d0, 5.5667d0, 5.5768d0, 5.5867d0, 5.5966d0, 5.6066d0,
     & 5.6167d0, 5.6267d0, 5.6368d0, 5.6470d0, 5.6572d0, 5.6673d0,
     & 5.6776d0, 5.6877d0, 5.6979d0, 5.7082d0, 5.7184d0, 5.7287d0,
     & 5.7389d0, 5.7491d0, 5.7592d0, 5.7693d0, 5.7795d0, 5.7895d0,
     & 5.7995d0, 5.8096d0, 5.8197d0, 5.8298d0, 5.8398d0, 5.8501d0,
     & 5.8603d0, 5.8705d0, 5.8808d0, 5.8911d0, 5.9015d0, 5.9119d0,
     & 5.9222d0, 5.9325d0, 5.9428d0, 5.9531d0, 5.9633d0, 5.9734d0,
     & 5.9837d0, 5.9938d0, 6.0040d0, 6.0142d0, 6.0244d0, 6.0347d0,
     & 6.0451d0, 6.0555d0, 6.0657d0, 6.0760d0, 6.0864d0, 6.0967d0,
     & 6.1071d0, 6.1174d0, 6.1276d0, 6.1379d0, 6.1481d0, 6.1584d0,
     & 6.1685d0, 6.1789d0, 6.1890d0, 6.1992d0, 6.2094d0, 6.2196d0,
     & 6.2298d0, 6.2402d0, 6.2505d0, 6.2608d0, 6.2713d0, 6.2818d0,
     & 6.2922d0, 6.3028d0, 6.3133d0, 6.3239d0, 6.3344d0, 6.3449d0,
     & 6.3554d0, 6.3658d0, 6.3762d0, 6.3866d0, 6.3971d0, 6.4074d0,
     & 6.4178d0, 6.4282d0, 6.4386d0, 6.4489d0, 6.4592d0, 6.4695d0,
     & 6.4798d0, 6.4904d0, 6.5007d0, 6.5110d0, 6.5215d0, 6.5318d0,
     & 6.5424d0, 6.5529d0, 6.5634d0, 6.5739d0, 6.5846d0, 6.5952d0,
     & 6.6055d0, 6.6163d0, 6.6270d0, 6.6375d0, 6.6482d0, 6.6587d0,
     & 6.6692d0, 6.6798d0, 6.6905d0, 6.7011d0, 6.7117d0, 6.7222d0,
     & 6.7328d0, 6.7433d0, 6.7539d0, 6.7644d0, 6.7749d0, 6.7854d0,
     & 6.7959d0, 6.8065d0, 6.8170d0, 6.8274d0, 6.8380d0, 6.8485d0,
     & 6.8592d0, 6.8697d0, 6.8805d0, 6.8913d0, 6.9019d0, 6.9125d0,
     & 6.9231d0, 6.9336d0, 6.9444d0, 6.9552d0, 6.9660d0, 6.9767d0,
     & 6.9874d0, 6.9980d0, 7.0087d0, 7.0197d0, 7.0306d0, 7.0416d0,
     & 7.0526d0, 7.0636d0, 7.0745d0, 7.0853d0, 7.0958d0, 7.1067d0,
     & 7.1175d0, 7.1282d0, 7.1389d0, 7.1497d0, 7.1604d0, 7.1711d0,
     & 7.1819d0, 7.1926d0, 7.2033d0, 7.2144d0, 7.2252d0, 7.2359d0,
     & 7.2467d0, 7.2575d0, 7.2684d0, 7.2792d0, 7.2902d0, 7.3011d0,
     & 7.3119d0, 7.3229d0, 7.3337d0, 7.3446d0, 7.3557d0, 7.3669d0,
     & 7.3778d0, 7.3887d0, 7.3996d0, 7.4105d0, 7.4215d0, 7.4324d0,
     & 7.4433d0, 7.4543d0, 7.4655d0, 7.4763d0, 7.4871d0, 7.4982d0,
     & 7.5093d0, 7.5204d0, 7.5314d0, 7.5424d0, 7.5537d0, 7.5649d0,
     & 7.5761d0, 7.5871d0, 7.5982d0, 7.6095d0, 7.6207d0, 7.6318d0,
     & 7.6432d0, 7.6546d0, 7.6660d0, 7.6772d0, 7.6883d0, 7.6994d0,
     & 7.7107d0, 7.7221d0, 7.7334d0, 7.7447d0, 7.7561d0, 7.7673d0,
     & 7.7785d0, 7.7896d0, 7.8008d0, 7.8124d0, 7.8238d0, 7.8354d0,
     & 7.8469d0, 7.8583d0, 7.8695d0, 7.8806d0, 7.8921d0, 7.9034d0,
     & 7.9149d0, 7.9264d0, 7.9379d0, 7.9494d0, 7.9607d0, 7.9722d0,
     & 7.9837d0, 7.9954d0, 8.0072d0, 8.0188d0, 8.0303d0, 8.0419d0,
     & 8.0536d0, 8.0648d0, 8.0761d0, 8.0875d0, 8.0989d0, 8.1104d0,
     & 8.1220d0, 8.1336d0, 8.1451d0, 8.1569d0, 8.1685d0, 8.1800d0,
     & 8.1917d0, 8.2036d0, 8.2156d0, 8.2272d0, 8.2389d0, 8.2507d0,
     & 8.2623d0, 8.2741d0, 8.2859d0, 8.2978d0, 8.3096d0, 8.3217d0,
     & 8.3335d0, 8.3450d0, 8.3570d0, 8.3688d0, 8.3804d0, 8.3922d0,
     & 8.4041d0, 8.4161d0, 8.4280d0, 8.4403d0, 8.4520d0, 8.4639d0,
     & 8.4762d0, 8.4883d0, 8.5002d0, 8.5122d0, 8.5244d0, 8.5362d0,
     & 8.5480d0, 8.5601d0, 8.5720d0, 8.5840d0, 8.5961d0, 8.6082d0,
     & 8.6203d0, 8.6328d0, 8.6453d0, 8.6576d0, 8.6701d0, 8.6827d0,
     & 8.6950d0, 8.7073d0, 8.7199d0, 8.7325d0, 8.7449d0, 8.7575d0,
     & 8.7696d0, 8.7817d0, 8.7941d0, 8.8063d0, 8.8187d0, 8.8308d0,
     & 8.8433d0, 8.8559d0, 8.8681d0, 8.8805d0, 8.8927d0, 8.9054d0,
     & 8.9182d0, 8.9307d0, 8.9434d0, 8.9556d0, 8.9684d0, 8.9809d0,
     & 8.9933d0, 9.0060d0, 9.0188d0, 9.0317d0, 9.0447d0, 9.0575d0,
     & 9.0703d0, 9.0834d0, 9.0966d0, 9.1098d0, 9.1229d0, 9.1360d0,
     & 9.1489d0, 9.1619d0, 9.1749d0, 9.1880d0, 9.2009d0, 9.2139d0,
     & 9.2270d0, 9.2400d0, 9.2529d0, 9.2659d0, 9.2789d0, 9.2925d0,
     & 9.3055d0, 9.3186d0, 9.3317d0, 9.3452d0, 9.3587d0, 9.3718d0,
     & 9.3852d0, 9.3983d0, 9.4117d0, 9.4252d0, 9.4387d0, 9.4524d0,
     & 9.4659d0, 9.4791d0, 9.4926d0, 9.5060d0, 9.5197d0, 9.5330d0,
     & 9.5468d0, 9.5605d0, 9.5744d0, 9.5879d0, 9.6012d0, 9.6149d0,
     & 9.6291d0, 9.6425d0, 9.6564d0, 9.6703d0, 9.6845d0, 9.6987d0,
     & 9.7123d0, 9.7262d0, 9.7403d0, 9.7548d0, 9.7690d0, 9.7832d0,
     & 9.7973d0, 9.8113d0, 9.8251d0, 9.8391d0, 9.8530d0, 9.8675d0,
     & 9.8818d0, 9.8961d0, 9.9105d0, 9.9248d0, 9.9380d0, 9.9502d0,
     & 9.9610d0, 9.9707d0, 9.9789d0, 9.9859d0, 9.9915d0, 9.9956d0,
     & 9.9984d0, 9.9998d0,10.0000d0,10.0000d0, 9.9999d0, 9.9999d0,
     & 9.9999d0,10.0000d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0
     &/
      DATA (Imax ( 6,I), I= 1, 1000) /
     & 0.00000649d0, 0.00004472d0, 0.00005737d0, 0.00013053d0,
     & 0.00025469d0, 0.00041744d0, 0.00062310d0, 0.00088419d0,
     & 0.00126744d0, 0.00176404d0, 0.00236834d0, 0.00307022d0,
     & 0.00386375d0, 0.00477677d0, 0.00574785d0, 0.00682306d0,
     & 0.00799302d0, 0.00922708d0, 0.01056171d0, 0.01193774d0,
     & 0.01333522d0, 0.01476247d0, 0.01625867d0, 0.01778251d0,
     & 0.01935143d0, 0.02096458d0, 0.02261397d0, 0.02429516d0,
     & 0.02603264d0, 0.02774565d0, 0.02949684d0, 0.03128584d0,
     & 0.03312537d0, 0.03493619d0, 0.03679007d0, 0.03869829d0,
     & 0.04061864d0, 0.04251303d0, 0.04441438d0, 0.04635633d0,
     & 0.04835613d0, 0.05033132d0, 0.05231954d0, 0.05431974d0,
     & 0.05636062d0, 0.05840912d0, 0.06044215d0, 0.06249027d0,
     & 0.06458765d0, 0.06669567d0, 0.06880231d0, 0.07090843d0,
     & 0.07301459d0, 0.07517054d0, 0.07730824d0, 0.07946196d0,
     & 0.08161314d0, 0.08378552d0, 0.08599066d0, 0.08817755d0,
     & 0.09037429d0, 0.09257849d0, 0.09478947d0, 0.09701921d0,
     & 0.09925903d0, 0.10150177d0, 0.10375062d0, 0.10600511d0,
     & 0.10826476d0, 0.11050616d0, 0.11279523d0, 0.11509687d0,
     & 0.11737415d0, 0.11966944d0, 0.12198181d0, 0.12424717d0,
     & 0.12657858d0, 0.12891781d0, 0.13126069d0, 0.13360561d0,
     & 0.13595165d0, 0.13825889d0, 0.14061189d0, 0.14299701d0,
     & 0.14538603d0, 0.14776045d0, 0.15013373d0, 0.15248513d0,
     & 0.15484613d0, 0.15725867d0, 0.15967540d0, 0.16209248d0,
     & 0.16450830d0, 0.16689295d0, 0.16926259d0, 0.17166543d0,
     & 0.17412020d0, 0.17659312d0, 0.17903325d0, 0.18145916d0,
     & 0.18383463d0, 0.18622579d0, 0.18866783d0, 0.19114532d0,
     & 0.19362572d0, 0.19612128d0, 0.19856431d0, 0.20097199d0,
     & 0.20337795d0, 0.20580123d0, 0.20830265d0, 0.21082544d0,
     & 0.21334660d0, 0.21581429d0, 0.21826278d0, 0.22068909d0,
     & 0.22313219d0, 0.22563532d0, 0.22817092d0, 0.23072602d0,
     & 0.23327768d0, 0.23576728d0, 0.23823203d0, 0.24067789d0,
     & 0.24316309d0, 0.24570127d0, 0.24828598d0, 0.25085309d0,
     & 0.25337502d0, 0.25588015d0, 0.25836217d0, 0.26084390d0,
     & 0.26330855d0, 0.26586053d0, 0.26846117d0, 0.27103996d0,
     & 0.27357781d0, 0.27608484d0, 0.27858993d0, 0.28111634d0,
     & 0.28362599d0, 0.28615791d0, 0.28873709d0, 0.29137859d0,
     & 0.29394990d0, 0.29648748d0, 0.29902348d0, 0.30156600d0,
     & 0.30408958d0, 0.30663493d0, 0.30923444d0, 0.31185886d0,
     & 0.31448045d0, 0.31709206d0, 0.31965572d0, 0.32221857d0,
     & 0.32478166d0, 0.32734579d0, 0.32989118d0, 0.33253670d0,
     & 0.33518040d0, 0.33776915d0, 0.34037042d0, 0.34296927d0,
     & 0.34554699d0, 0.34812596d0, 0.35070699d0, 0.35329139d0,
     & 0.35593230d0, 0.35860056d0, 0.36120850d0, 0.36381409d0,
     & 0.36643863d0, 0.36904082d0, 0.37162259d0, 0.37420627d0,
     & 0.37679234d0, 0.37944168d0, 0.38210157d0, 0.38472754d0,
     & 0.38734329d0, 0.38995644d0, 0.39259186d0, 0.39520651d0,
     & 0.39780104d0, 0.40041918d0, 0.40303904d0, 0.40573552d0,
     & 0.40839788d0, 0.41104603d0, 0.41369140d0, 0.41631460d0,
     & 0.41893965d0, 0.42154494d0, 0.42415243d0, 0.42678422d0,
     & 0.42941859d0, 0.43213665d0, 0.43478188d0, 0.43742037d0,
     & 0.44005778d0, 0.44269571d0, 0.44535691d0, 0.44801900d0,
     & 0.45068228d0, 0.45332488d0, 0.45596981d0, 0.45871553d0,
     & 0.46140930d0, 0.46409777d0, 0.46673718d0, 0.46937665d0,
     & 0.47201696d0, 0.47468239d0, 0.47732657d0, 0.47997296d0,
     & 0.48262125d0, 0.48529491d0, 0.48790836d0, 0.49055263d0,
     & 0.49319792d0, 0.49586913d0, 0.49854267d0, 0.50124282d0,
     & 0.50392258d0, 0.50660509d0, 0.50931418d0, 0.51202554d0,
     & 0.51469284d0, 0.51739329d0, 0.52003729d0, 0.52273297d0,
     & 0.52543020d0, 0.52815336d0, 0.53080666d0, 0.53346217d0,
     & 0.53616673d0, 0.53882545d0, 0.54148602d0, 0.54417223d0,
     & 0.54685587d0, 0.54956961d0, 0.55228639d0, 0.55502999d0,
     & 0.55775094d0, 0.56047279d0, 0.56319636d0, 0.56587410d0,
     & 0.56857783d0, 0.57128346d0, 0.57396716d0, 0.57665849d0,
     & 0.57936281d0, 0.58202130d0, 0.58465827d0, 0.58734316d0,
     & 0.59008080d0, 0.59279734d0, 0.59554148d0, 0.59826440d0,
     & 0.60096580d0, 0.60369444d0, 0.60638332d0, 0.60906982d0,
     & 0.61179590d0, 0.61452812d0, 0.61721987d0, 0.61989003d0,
     & 0.62261331d0, 0.62533939d0, 0.62806755d0, 0.63084698d0,
     & 0.63360345d0, 0.63628763d0, 0.63899362d0, 0.64170092d0,
     & 0.64442271d0, 0.64715129d0, 0.64988434d0, 0.65259629d0,
     & 0.65538812d0, 0.65818202d0, 0.66090220d0, 0.66364950d0,
     & 0.66644847d0, 0.66912520d0, 0.67182589d0, 0.67451328d0,
     & 0.67724335d0, 0.68001097d0, 0.68275839d0, 0.68540800d0,
     & 0.68806106d0, 0.69088125d0, 0.69370508d0, 0.69650704d0,
     & 0.69931126d0, 0.70204365d0, 0.70476627d0, 0.70748514d0,
     & 0.71020091d0, 0.71294165d0, 0.71569282d0, 0.71847785d0,
     & 0.72115457d0, 0.72380972d0, 0.72657198d0, 0.72933561d0,
     & 0.73210180d0, 0.73489583d0, 0.73761559d0, 0.74029559d0,
     & 0.74291605d0, 0.74552017d0, 0.74814373d0, 0.75081462d0,
     & 0.75349456d0, 0.75607675d0, 0.75871623d0, 0.76133317d0,
     & 0.76392806d0, 0.76662999d0, 0.76933414d0, 0.77201420d0,
     & 0.77469635d0, 0.77734929d0, 0.77992296d0, 0.78248292d0,
     & 0.78504634d0, 0.78766990d0, 0.79033172d0, 0.79300112d0,
     & 0.79559779d0, 0.79817230d0, 0.80080283d0, 0.80343682d0,
     & 0.80610037d0, 0.80881864d0, 0.81153947d0, 0.81424928d0,
     & 0.81686711d0, 0.81944293d0, 0.82203382d0, 0.82464975d0,
     & 0.82731283d0, 0.82998687d0, 0.83266819d0, 0.83530241d0,
     & 0.83791512d0, 0.84053183d0, 0.84314752d0, 0.84584689d0,
     & 0.84857589d0, 0.85128218d0, 0.85395825d0, 0.85661042d0,
     & 0.85922277d0, 0.86179972d0, 0.86442405d0, 0.86707342d0,
     & 0.86973619d0, 0.87241310d0, 0.87504274d0, 0.87765008d0,
     & 0.88028902d0, 0.88290471d0, 0.88552356d0, 0.88822514d0,
     & 0.89095545d0, 0.89363354d0, 0.89628357d0, 0.89891785d0,
     & 0.90154094d0, 0.90410268d0, 0.90675324d0, 0.90939522d0,
     & 0.91210365d0, 0.91481948d0, 0.91748744d0, 0.92013264d0,
     & 0.92278236d0, 0.92543483d0, 0.92806333d0, 0.93069518d0,
     & 0.93346322d0, 0.93616533d0, 0.93884510d0, 0.94148272d0,
     & 0.94411099d0, 0.94677049d0, 0.94943029d0, 0.95213777d0,
     & 0.95485598d0, 0.95758045d0, 0.96031046d0, 0.96296459d0,
     & 0.96562296d0, 0.96828508d0, 0.97092301d0, 0.97356385d0,
     & 0.97616905d0, 0.97877067d0, 0.98132151d0, 0.98396778d0,
     & 0.98660582d0, 0.98923612d0, 0.99189019d0, 0.99456960d0,
     & 0.99726254d0, 0.99999189d0, 1.00267148d0, 1.00535703d0,
     & 1.00807488d0, 1.01085258d0, 1.01349795d0, 1.01617348d0,
     & 1.01885188d0, 1.02150261d0, 1.02422714d0, 1.02693677d0,
     & 1.02960908d0, 1.03227639d0, 1.03493738d0, 1.03765714d0,
     & 1.04034567d0, 1.04307652d0, 1.04581738d0, 1.04856646d0,
     & 1.05126560d0, 1.05386877d0, 1.05647707d0, 1.05911636d0,
     & 1.06181335d0, 1.06451321d0, 1.06715202d0, 1.06987464d0,
     & 1.07258272d0, 1.07528019d0, 1.07796955d0, 1.08065403d0,
     & 1.08338690d0, 1.08614743d0, 1.08889246d0, 1.09164822d0,
     & 1.09441173d0, 1.09718144d0, 1.09978986d0, 1.10240269d0,
     & 1.10501957d0, 1.10764015d0, 1.11031830d0, 1.11294603d0,
     & 1.11551523d0, 1.11809778d0, 1.12069583d0, 1.12339520d0,
     & 1.12608647d0, 1.12877417d0, 1.13151610d0, 1.13428473d0,
     & 1.13706768d0, 1.13986123d0, 1.14266145d0, 1.14549589d0,
     & 1.14830709d0, 1.15103805d0, 1.15369093d0, 1.15632010d0,
     & 1.15900671d0, 1.16163647d0, 1.16423738d0, 1.16682172d0,
     & 1.16939545d0, 1.17196071d0, 1.17449105d0, 1.17707217d0,
     & 1.17983758d0, 1.18260801d0, 1.18542254d0, 1.18824875d0,
     & 1.19108319d0, 1.19392395d0, 1.19671321d0, 1.19950652d0,
     & 1.20230401d0, 1.20513308d0, 1.20793760d0, 1.21061254d0,
     & 1.21325266d0, 1.21586800d0, 1.21844375d0, 1.22101271d0,
     & 1.22357583d0, 1.22619188d0, 1.22877562d0, 1.23156500d0,
     & 1.23437917d0, 1.23720932d0, 1.24005067d0, 1.24281132d0,
     & 1.24558878d0, 1.24840021d0, 1.25121558d0, 1.25403523d0,
     & 1.25685883d0, 1.25971401d0, 1.26233482d0, 1.26490247d0,
     & 1.26745415d0, 1.26999497d0, 1.27261710d0, 1.27522969d0,
     & 1.27783692d0, 1.28041077d0, 1.28297997d0, 1.28560638d0,
     & 1.28826165d0, 1.29093063d0, 1.29378951d0, 1.29665673d0,
     & 1.29953027d0, 1.30240893d0, 1.30529296d0, 1.30809307d0,
     & 1.31092489d0, 1.31375992d0, 1.31653678d0, 1.31928396d0,
     & 1.32204509d0, 1.32464445d0, 1.32723498d0, 1.32976234d0,
     & 1.33228457d0, 1.33480132d0, 1.33740234d0, 1.34016836d0,
     & 1.34289110d0, 1.34565926d0, 1.34846795d0, 1.35128415d0,
     & 1.35401773d0, 1.35675728d0, 1.35955882d0, 1.36236346d0,
     & 1.36517406d0, 1.36795819d0, 1.37057674d0, 1.37323856d0,
     & 1.37585449d0, 1.37837291d0, 1.38091230d0, 1.38353443d0,
     & 1.38612223d0, 1.38870490d0, 1.39125562d0, 1.39380157d0,
     & 1.39639795d0, 1.39902902d0, 1.40186501d0, 1.40458834d0,
     & 1.40734768d0, 1.41008568d0, 1.41277051d0, 1.41548967d0,
     & 1.41821384d0, 1.42094195d0, 1.42367411d0, 1.42638505d0,
     & 1.42906129d0, 1.43153286d0, 1.43411577d0, 1.43666375d0,
     & 1.43920326d0, 1.44179738d0, 1.44435728d0, 1.44692302d0,
     & 1.44948661d0, 1.45204902d0, 1.45466614d0, 1.45728517d0,
     & 1.45992565d0, 1.46255124d0, 1.46524560d0, 1.46792090d0,
     & 1.47066355d0, 1.47344184d0, 1.47621572d0, 1.47902274d0,
     & 1.48177338d0, 1.48447073d0, 1.48716938d0, 1.48984838d0,
     & 1.49251616d0, 1.49517345d0, 1.49785280d0, 1.50043643d0,
     & 1.50301468d0, 1.50558865d0, 1.50807202d0, 1.51061094d0,
     & 1.51314676d0, 1.51574099d0, 1.51849759d0, 1.52129698d0,
     & 1.52407575d0, 1.52686310d0, 1.52962601d0, 1.53239524d0,
     & 1.53517008d0, 1.53800666d0, 1.54087710d0, 1.54369223d0,
     & 1.54644835d0, 1.54901350d0, 1.55156577d0, 1.55413938d0,
     & 1.55667579d0, 1.55926621d0, 1.56182003d0, 1.56437027d0,
     & 1.56694579d0, 1.56945860d0, 1.57202721d0, 1.57459247d0,
     & 1.57715786d0, 1.57977545d0, 1.58241534d0, 1.58509934d0,
     & 1.58779466d0, 1.59049904d0, 1.59320974d0, 1.59592712d0,
     & 1.59864938d0, 1.60146654d0, 1.60428810d0, 1.60713983d0,
     & 1.60991037d0, 1.61265910d0, 1.61539376d0, 1.61808813d0,
     & 1.62071681d0, 1.62333846d0, 1.62595415d0, 1.62859476d0,
     & 1.63114119d0, 1.63365471d0, 1.63616359d0, 1.63867044d0,
     & 1.64129925d0, 1.64392674d0, 1.64660394d0, 1.64935207d0,
     & 1.65211141d0, 1.65487969d0, 1.65774548d0, 1.66061866d0,
     & 1.66352618d0, 1.66640949d0, 1.66932619d0, 1.67203224d0,
     & 1.67474115d0, 1.67749023d0, 1.68022823d0, 1.68295562d0,
     & 1.68558609d0, 1.68812013d0, 1.69061804d0, 1.69311178d0,
     & 1.69563198d0, 1.69814873d0, 1.70075226d0, 1.70335090d0,
     & 1.70588911d0, 1.70849717d0, 1.71113503d0, 1.71387959d0,
     & 1.71663725d0, 1.71943450d0, 1.72220922d0, 1.72510874d0,
     & 1.72801507d0, 1.73092747d0, 1.73381734d0, 1.73671079d0,
     & 1.73950696d0, 1.74227583d0, 1.74502921d0, 1.74777186d0,
     & 1.75050652d0, 1.75320649d0, 1.75578356d0, 1.75832605d0,
     & 1.76086426d0, 1.76343071d0, 1.76599383d0, 1.76858437d0,
     & 1.77117193d0, 1.77375698d0, 1.77641559d0, 1.77906883d0,
     & 1.78180110d0, 1.78454733d0, 1.78720737d0, 1.78994071d0,
     & 1.79283500d0, 1.79573512d0, 1.79863966d0, 1.80154896d0,
     & 1.80446255d0, 1.80727375d0, 1.81000113d0, 1.81271064d0,
     & 1.81540728d0, 1.81819117d0, 1.82090306d0, 1.82345331d0,
     & 1.82596874d0, 1.82853830d0, 1.83107412d0, 1.83357692d0,
     & 1.83610904d0, 1.83872879d0, 1.84128678d0, 1.84381294d0,
     & 1.84640586d0, 1.84901357d0, 1.85164750d0, 1.85429585d0,
     & 1.85689783d0, 1.85963559d0, 1.86237991d0, 1.86512947d0,
     & 1.86785448d0, 1.87064445d0, 1.87343824d0, 1.87619579d0,
     & 1.87894261d0, 1.88163507d0, 1.88446546d0, 1.88731587d0,
     & 1.89003158d0, 1.89277160d0, 1.89550555d0, 1.89817536d0,
     & 1.90078080d0, 1.90335321d0, 1.90589440d0, 1.90851986d0,
     & 1.91117275d0, 1.91367018d0, 1.91616750d0, 1.91860366d0,
     & 1.92110276d0, 1.92367399d0, 1.92635405d0, 1.92907524d0,
     & 1.93186784d0, 1.93460441d0, 1.93722880d0, 1.93986094d0,
     & 1.94259405d0, 1.94533074d0, 1.94813108d0, 1.95087135d0,
     & 1.95351148d0, 1.95610452d0, 1.95871830d0, 1.96147382d0,
     & 1.96431649d0, 1.96718299d0, 1.97001266d0, 1.97268438d0,
     & 1.97535145d0, 1.97798526d0, 1.98055530d0, 1.98312283d0,
     & 1.98577785d0, 1.98845983d0, 1.99095809d0, 1.99345207d0,
     & 1.99597692d0, 1.99850035d0, 2.00114036d0, 2.00376248d0,
     & 2.00659013d0, 2.00939202d0, 2.01223254d0, 2.01498961d0,
     & 2.01772356d0, 2.02046251d0, 2.02320910d0, 2.02592826d0,
     & 2.02865076d0, 2.03134966d0, 2.03403831d0, 2.03658319d0,
     & 2.03918576d0, 2.04198885d0, 2.04478788d0, 2.04758263d0,
     & 2.05040479d0, 2.05310321d0, 2.05576921d0, 2.05843353d0,
     & 2.06109643d0, 2.06387854d0, 2.06653953d0, 2.06922984d0,
     & 2.07171154d0, 2.07424855d0, 2.07682872d0, 2.07939768d0,
     & 2.08210492d0, 2.08482265d0, 2.08758426d0, 2.09032297d0,
     & 2.09288216d0, 2.09553766d0, 2.09820008d0, 2.10083747d0,
     & 2.10345602d0, 2.10600448d0, 2.10856700d0, 2.11111522d0,
     & 2.11365461d0, 2.11618304d0, 2.11879730d0, 2.12147236d0,
     & 2.12417316d0, 2.12686872d0, 2.12956047d0, 2.13224292d0,
     & 2.13495517d0, 2.13775492d0, 2.14043069d0, 2.14313436d0,
     & 2.14601374d0, 2.14883208d0, 2.15173340d0, 2.15433717d0,
     & 2.15701556d0, 2.15972161d0, 2.16245270d0, 2.16516376d0,
     & 2.16779709d0, 2.17056227d0, 2.17330456d0, 2.17587662d0,
     & 2.17854762d0, 2.18116975d0, 2.18406177d0, 2.18688226d0,
     & 2.18983150d0, 2.19260645d0, 2.19540095d0, 2.19815373d0,
     & 2.20089793d0, 2.20366406d0, 2.20639324d0, 2.20942140d0,
     & 2.21244478d0, 2.21494722d0, 2.21741605d0, 2.21987963d0,
     & 2.22246480d0, 2.22504735d0, 2.22765803d0, 2.23038530d0,
     & 2.23311591d0, 2.23600483d0, 2.23845863d0, 2.24104309d0,
     & 2.24388361d0, 2.24674034d0, 2.24948812d0, 2.25228143d0,
     & 2.25505304d0, 2.25783348d0, 2.26047158d0, 2.26311421d0,
     & 2.26560187d0, 2.26813006d0, 2.27050018d0, 2.27331877d0,
     & 2.27612305d0, 2.27891970d0, 2.28170300d0, 2.28463364d0,
     & 2.28724909d0, 2.28989029d0, 2.29258776d0, 2.29528141d0,
     & 2.29797101d0, 2.30065751d0, 2.30327940d0, 2.30635643d0,
     & 2.30912328d0, 2.31185746d0, 2.31446624d0, 2.31732035d0,
     & 2.32014203d0, 2.32293391d0, 2.32581758d0, 2.32869267d0,
     & 2.33161831d0, 2.33450031d0, 2.33690166d0, 2.33984375d0,
     & 2.34279156d0, 2.34536171d0, 2.34800100d0, 2.35067749d0,
     & 2.35329509d0, 2.35598159d0, 2.35858583d0, 2.36104798d0,
     & 2.36355591d0, 2.36608982d0, 2.36839294d0, 2.37087631d0,
     & 2.37374330d0, 2.37657452d0, 2.37905765d0, 2.38156796d0,
     & 2.38394547d0, 2.38641739d0, 2.38898087d0, 2.39145088d0,
     & 2.39394951d0, 2.39644265d0, 2.39875054d0, 2.40105224d0,
     & 2.40349126d0, 2.40624237d0, 2.40902352d0, 2.41165137d0,
     & 2.41424537d0, 2.41732216d0, 2.42020702d0, 2.42341256d0,
     & 2.42662835d0, 2.42962146d0, 2.43275690d0, 2.43559527d0,
     & 2.43834329d0, 2.44106793d0, 2.44395471d0, 2.44684601d0,
     & 2.44929075d0, 2.45193481d0, 2.45438814d0, 2.45692539d0,
     & 2.45972252d0, 2.46210074d0, 2.46467018d0, 2.46736288d0,
     & 2.47001958d0, 2.47267151d0, 2.47544050d0, 2.47830129d0,
     & 2.48133969d0, 2.48424959d0, 2.48721957d0, 2.49018383d0,
     & 2.49333405d0, 2.49605227d0, 2.49876857d0, 2.50151396d0,
     & 2.50422716d0, 2.50712657d0, 2.50996041d0, 2.51262951d0,
     & 2.51531434d0, 2.51785827d0, 2.52038002d0, 2.52300310d0,
     & 2.52606368d0, 2.52938676d0, 2.53271484d0, 2.53575754d0,
     & 2.53830910d0, 2.54080343d0, 2.54350281d0, 2.54619026d0,
     & 2.54886770d0, 2.55200672d0, 2.57381272d0, 2.59581757d0,
     & 2.59790373d0, 2.59998679d0, 2.60235691d0, 2.60494280d0,
     & 2.60755324d0, 2.60994244d0, 2.61266923d0, 2.61539340d0,
     & 2.61767888d0, 2.60125756d0, 2.58425951d0, 2.58691812d0
     &/
      DATA (Imax ( 6,I), I= 1001, 2100) /
     & 2.58957481d0, 2.59223008d0, 2.59506822d0, 2.59778190d0,
     & 2.60068107d0, 2.60364008d0, 2.60661292d0, 2.60897303d0,
     & 2.61139131d0, 2.61584640d0, 2.61899614d0, 2.62215352d0,
     & 2.62534881d0, 2.62836552d0, 2.63151431d0, 2.63447762d0,
     & 2.63701224d0, 2.63953686d0, 2.64239240d0, 2.64522433d0,
     & 2.64639258d0, 2.64883733d0, 2.65127707d0, 2.65414953d0,
     & 2.65701365d0, 2.65984273d0, 2.66248512d0, 2.66487622d0,
     & 2.66726446d0, 2.67088628d0, 2.67497134d0, 2.67754316d0,
     & 2.68011332d0, 2.68268156d0, 2.68480635d0, 2.68693733d0,
     & 2.68909860d0, 2.69141078d0, 2.69473529d0, 2.69850135d0,
     & 2.70286775d0, 2.70486808d0, 2.70839119d0, 2.71188974d0,
     & 2.71539783d0, 2.71872234d0, 2.72174239d0, 2.72460651d0,
     & 2.72747803d0, 2.73023486d0, 2.73248005d0, 2.73301959d0,
     & 2.73531389d0, 2.73749995d0, 2.73971319d0, 2.74192405d0,
     & 2.74432516d0, 2.74699807d0, 2.75586772d0, 2.76477051d0,
     & 2.77915430d0, 2.78748679d0, 2.80210853d0, 2.80513430d0,
     & 2.80825710d0, 2.81122327d0, 2.81383729d0, 2.81645012d0,
     & 2.81909347d0, 2.81569767d0, 2.81226254d0, 2.80272937d0,
     & 2.81200790d0, 2.81493711d0, 2.82962012d0, 2.84431458d0,
     & 2.85920644d0, 2.87406301d0, 2.88893032d0, 2.90380859d0,
     & 2.90729690d0, 2.91075850d0, 2.92021179d0, 2.91694951d0,
     & 2.90779424d0, 2.89863229d0, 2.88946342d0, 2.88079739d0,
     & 2.87251520d0, 2.86419225d0, 2.85573411d0, 2.86053872d0,
     & 2.86542058d0, 2.86421919d0, 2.86298203d0, 2.86785460d0,
     & 2.87281227d0, 2.87739253d0, 2.88154840d0, 2.88533449d0,
     & 2.88923836d0, 2.89293456d0, 2.89370561d0, 2.90614533d0,
     & 2.90617800d0, 2.90627193d0, 2.91839385d0, 2.93039513d0,
     & 2.93073869d0, 2.93099236d0, 2.93161297d0, 2.93214440d0,
     & 2.93378949d0, 2.93647361d0, 2.92731071d0, 2.93048811d0,
     & 2.93350601d0, 2.92444420d0, 2.91797543d0, 2.92353988d0,
     & 2.92879248d0, 2.93404818d0, 2.93902349d0, 2.94322014d0,
     & 2.94718099d0, 2.95123577d0, 2.95422220d0, 2.95714736d0,
     & 2.98032904d0, 2.98055649d0, 2.98078418d0, 2.98132253d0,
     & 2.98202324d0, 2.98319602d0, 2.98449326d0, 2.98613477d0,
     & 2.98759031d0, 2.99027371d0, 2.99298978d0, 2.97550058d0,
     & 2.97840261d0, 2.98130178d0, 2.98417163d0, 2.98687601d0,
     & 2.99186325d0, 2.99642706d0, 3.00090408d0, 3.00531125d0,
     & 3.00972629d0, 3.01404142d0, 3.01772523d0, 3.02038765d0,
     & 3.02307892d0, 3.02585292d0, 3.03571153d0, 3.03605986d0,
     & 3.03672004d0, 3.03700233d0, 3.03762245d0, 3.03824830d0,
     & 3.03917360d0, 3.04070616d0, 3.04326868d0, 3.04580474d0,
     & 3.04830050d0, 3.04450631d0, 3.04775262d0, 3.05095506d0,
     & 3.07384729d0, 3.07728124d0, 3.09974670d0, 3.12223625d0,
     & 3.12731409d0, 3.13207173d0, 3.13682747d0, 3.14100957d0,
     & 3.14389658d0, 3.15138507d0, 3.16434789d0, 3.15401912d0,
     & 3.16646671d0, 3.31446648d0, 3.19677067d0, 3.25797582d0,
     & 3.35789013d0, 3.41300416d0, 3.36118150d0, 3.33282447d0,
     & 3.34359121d0, 3.37231898d0, 3.38287139d0, 3.41872072d0,
     & 3.44564199d0, 3.47323895d0, 3.50219989d0, 3.51416039d0,
     & 3.54256463d0, 3.56299591d0, 3.60449409d0, 3.63256097d0,
     & 3.66062069d0, 3.68798018d0, 3.70757914d0, 3.73608208d0,
     & 3.76529241d0, 3.80951023d0, 3.83956599d0, 3.86457396d0,
     & 3.89270401d0, 3.90327835d0, 3.93277574d0, 3.96119213d0,
     & 3.99368906d0, 4.02269506d0, 4.04944372d0, 4.07787991d0,
     & 4.10740614d0, 4.13694191d0, 4.16601992d0, 4.19388771d0,
     & 4.22304916d0, 4.25088406d0, 4.27940655d0, 4.30660582d0,
     & 4.33699369d0, 4.36609221d0, 4.39363098d0, 4.42359018d0,
     & 4.45260954d0, 4.48753738d0, 4.51542282d0, 4.54353237d0,
     & 4.57179594d0, 4.62567711d0, 4.65568018d0, 4.68526173d0,
     & 4.71468210d0, 4.74479628d0, 4.77148342d0, 4.79858541d0,
     & 4.80196476d0, 4.83009863d0, 4.86129427d0, 4.89089108d0,
     & 4.91816092d0, 4.94074059d0, 4.96669102d0, 4.99770498d0,
     & 5.02171230d0, 5.05093765d0, 5.08019114d0, 5.11131239d0,
     & 5.13668537d0, 5.16468954d0, 5.20566988d0, 5.23555756d0,
     & 5.26360750d0, 5.29135942d0, 5.31867838d0, 5.34676504d0,
     & 5.37568140d0, 5.40580273d0, 5.43419218d0, 5.46444416d0,
     & 5.49326801d0, 5.52592707d0, 5.55967283d0, 5.59058619d0,
     & 5.62102747d0, 5.64934206d0, 5.67538452d0, 5.70378065d0,
     & 5.72950077d0, 5.76073647d0, 5.79141808d0, 5.82008457d0,
     & 5.84805107d0, 5.87892008d0, 5.90819788d0, 5.93670225d0,
     & 5.96720505d0, 5.98692513d0, 6.02019358d0, 6.04393244d0,
     & 6.07215118d0, 6.10161257d0, 6.13006115d0, 6.15771818d0,
     & 6.18720388d0, 6.21798372d0, 6.24598598d0, 6.27551317d0,
     & 6.31289768d0, 6.34094429d0, 6.37294102d0, 6.40124655d0,
     & 6.43102980d0, 6.45085859d0, 6.47679090d0, 6.50220013d0,
     & 6.52642202d0, 6.55312824d0, 6.58158875d0, 6.60526037d0,
     & 6.63622618d0, 6.66561174d0, 6.68798065d0, 6.72033215d0,
     & 6.74843502d0, 6.77692842d0, 6.80938244d0, 6.84167147d0,
     & 6.87409592d0, 6.89633799d0, 6.92278957d0, 6.94925690d0,
     & 6.97535992d0, 7.00073338d0, 7.02570963d0, 7.05447197d0,
     & 7.08468342d0, 7.11244631d0, 7.14686346d0, 7.16844845d0,
     & 7.19601059d0, 7.22171354d0, 7.25020027d0, 7.27881479d0,
     & 7.31229830d0, 7.33973265d0, 7.36697006d0, 7.39538050d0,
     & 7.42250156d0, 7.45169306d0, 7.47976780d0, 7.50714922d0,
     & 7.53403997d0, 7.56454420d0, 7.59121227d0, 7.62016821d0,
     & 7.65084076d0, 7.68248129d0, 7.71090364d0, 7.73881674d0,
     & 7.76560259d0, 7.79626846d0, 7.82622385d0, 7.85538244d0,
     & 7.87954235d0, 7.91041756d0, 7.93542480d0, 7.96239281d0,
     & 7.99201155d0, 8.02236748d0, 8.05080223d0, 8.08432865d0,
     & 8.10918999d0, 8.13475513d0, 8.16359711d0, 8.19259071d0,
     & 8.22384453d0, 8.25323772d0, 8.27769375d0, 8.30491161d0,
     & 8.33000183d0, 8.35564709d0, 8.38214779d0, 8.41063499d0,
     & 8.43919945d0, 8.46875191d0, 8.49877930d0, 8.52793503d0,
     & 8.55547619d0, 8.58354664d0, 8.61057186d0, 8.63776970d0,
     & 8.66390038d0, 8.68905544d0, 8.71719551d0, 8.74588108d0,
     & 8.77633095d0, 8.80467510d0, 8.83264065d0, 8.86283588d0,
     & 8.89135551d0, 8.92090893d0, 8.94618797d0, 8.97260857d0,
     & 8.99879169d0, 9.02467442d0, 9.05017376d0, 9.07789421d0,
     & 9.10545158d0, 9.13296795d0, 9.16076565d0, 9.18885708d0,
     & 9.21809769d0, 9.24597454d0, 9.27338600d0, 9.30147266d0,
     & 9.32884502d0, 9.35483932d0, 9.38387108d0, 9.40914154d0,
     & 9.43592739d0, 9.46158600d0, 9.48856640d0, 9.51843548d0,
     & 9.54662323d0, 9.57329082d0, 9.60061169d0, 9.62812996d0,
     & 9.65923309d0, 9.68636036d0, 9.71162701d0, 9.73783875d0,
     & 9.76285839d0, 9.79133606d0, 9.81452560d0, 9.84226894d0,
     & 9.87159920d0, 9.89928722d0, 9.92866421d0, 9.95858955d0,
     & 9.98476696d0,10.01112461d0,10.03677273d0,10.06671524d0,
     &10.09545040d0,10.12080193d0,10.14891052d0,10.17633820d0,
     &10.20364475d0,10.23217392d0,10.26097202d0,10.28746223d0,
     &10.31393623d0,10.33885479d0,10.36436081d0,10.39055824d0,
     &10.41993141d0,10.44670868d0,10.47394276d0,10.50207615d0,
     &10.52855015d0,10.55452442d0,10.58210945d0,10.60957623d0,
     &10.63655949d0,10.66378689d0,10.69409657d0,10.72283840d0,
     &10.74806976d0,10.77287769d0,10.80230427d0,10.82862949d0,
     &10.85684299d0,10.88500786d0,10.91266727d0,10.93901062d0,
     &10.96297073d0,10.98938560d0,11.01765919d0,11.04505539d0,
     &11.07184505d0,11.10096931d0,11.13265991d0,11.15939426d0,
     &11.18694973d0,11.21522808d0,11.24075794d0,11.26783466d0,
     &11.29840851d0,11.33004951d0,11.35833359d0,11.38513088d0,
     &11.41316891d0,11.44071770d0,11.46931267d0,11.49656963d0,
     &11.52346516d0,11.55094814d0,11.57789993d0,11.60846806d0,
     &11.63557243d0,11.66147900d0,11.68934059d0,11.71852016d0,
     &11.74843788d0,11.77821541d0,11.80571842d0,11.83235264d0,
     &11.86125565d0,11.88761425d0,11.91579819d0,11.94350052d0,
     &11.97126102d0,11.99547005d0,12.02409554d0,12.05239201d0,
     &12.08163452d0,12.11229420d0,12.14154339d0,12.17033958d0,
     &12.19915581d0,12.22844315d0,12.25440693d0,12.28232479d0,
     &12.31015587d0,12.33867931d0,12.36351204d0,12.39049053d0,
     &12.41876888d0,12.44750595d0,12.47842121d0,12.50734234d0,
     &12.53129959d0,12.55632210d0,12.58129120d0,12.60815716d0,
     &12.63252449d0,12.66208458d0,12.69356346d0,12.71882153d0,
     &12.74579144d0,12.77337742d0,12.80452347d0,12.83221054d0,
     &12.86162186d0,12.89293766d0,12.92347336d0,12.94972229d0,
     &12.98115253d0,13.00558853d0,13.03090096d0,13.06052113d0,
     &13.08971310d0,13.11254406d0,13.13939857d0,13.17103100d0,
     &13.19805050d0,13.22501469d0,13.24833202d0,13.27756023d0,
     &13.30940819d0,13.34184456d0,13.37465954d0,13.40290165d0,
     &13.42940235d0,13.45148563d0,13.48048210d0,13.51271343d0,
     &13.54399586d0,13.57263947d0,13.60254955d0,13.62747669d0,
     &13.65417194d0,13.68019772d0,13.70913887d0,13.73844147d0,
     &13.76797009d0,13.79168224d0,13.82110500d0,13.84699726d0,
     &13.87698174d0,13.90850735d0,13.93624783d0,13.96395016d0,
     &13.99208069d0,14.01591015d0,14.03953934d0,14.07048512d0,
     &14.09899044d0,14.12673283d0,14.15746784d0,14.18158436d0,
     &14.20374012d0,14.23253250d0,14.26179504d0,14.29175377d0,
     &14.31880474d0,14.34438419d0,14.37393761d0,14.40008640d0,
     &14.42935181d0,14.45466900d0,14.48192692d0,14.51047897d0,
     &14.54051304d0,14.57054806d0,14.59926510d0,14.62980556d0,
     &14.66045380d0,14.69449425d0,14.72054291d0,14.75130939d0,
     &14.78184128d0,14.80885887d0,14.83792782d0,14.86443424d0,
     &14.89052200d0,14.91860390d0,14.94234657d0,14.97297764d0,
     &14.99981785d0,15.02771950d0,15.05568981d0,15.08411312d0,
     &15.11452293d0,15.14488888d0,15.17014790d0,15.19858646d0,
     &15.23130226d0,15.26373768d0,15.28930569d0,15.31669617d0,
     &15.34936428d0,15.38089943d0,15.40870953d0,15.43599892d0,
     &15.46558952d0,15.49410820d0,15.52156258d0,15.54837608d0,
     &15.57582569d0,15.60757351d0,15.63322639d0,15.66328049d0,
     &15.69256210d0,15.72244930d0,15.75303173d0,15.78159809d0,
     &15.81022358d0,15.83882809d0,15.86954689d0,15.89597321d0,
     &15.92487240d0,15.95452023d0,15.98287487d0,16.01367950d0,
     &16.03976631d0,16.07440186d0,16.10531044d0,16.13626289d0,
     &16.16785622d0,16.19577408d0,16.22450638d0,16.25359344d0,
     &16.27930641d0,16.30577278d0,16.33399773d0,16.36042213d0,
     &16.38486099d0,16.41309547d0,16.44187927d0,16.47316551d0,
     &16.50291443d0,16.53409767d0,16.56489754d0,16.59424973d0,
     &16.62250710d0,16.65225983d0,16.68164062d0,16.71194267d0,
     &16.74021149d0,16.77126884d0,16.79786682d0,16.82783699d0,
     &16.86031723d0,16.89446259d0,16.92719650d0,16.95727921d0,
     &16.99001312d0,17.01886368d0,17.04765511d0,17.07674599d0,
     &17.10879898d0,17.13559914d0,17.16447639d0,17.19119453d0,
     &17.21656609d0,17.24493980d0,17.27296257d0,17.30251312d0,
     &17.33083725d0,17.36318779d0,17.39688301d0,17.42639732d0,
     &17.45989609d0,17.48939514d0,17.52056885d0,17.55259895d0,
     &17.58179474d0,17.60867310d0,17.63897324d0,17.67183495d0,
     &17.70335960d0,17.72739983d0,17.75298882d0,17.77560425d0,
     &17.80614853d0,17.83546448d0,17.86548996d0,17.89664078d0,
     &17.92986679d0,17.95962334d0,17.98769188d0,18.02221107d0,
     &18.05396461d0,18.08657074d0,18.11181641d0,18.14174080d0,
     &18.17066574d0,18.20074844d0,18.22818947d0,18.26090240d0,
     &18.28853416d0,18.31992531d0,18.35028458d0,18.37433434d0,
     &18.40599823d0,18.43976212d0,18.47642899d0,18.51181793d0,
     &18.54673576d0,18.57787132d0,18.60892487d0,18.63904190d0,
     &18.66654587d0,18.69393730d0,18.72790718d0,18.75236511d0,
     &18.78814316d0,18.81965256d0,18.85671043d0,18.88624191d0,
     &18.91973114d0,18.95252609d0,18.98416710d0,19.01800919d0,
     &19.05167389d0,19.08375359d0,19.11621666d0,19.14586067d0,
     &19.17770004d0,19.20514679d0,19.24201775d0,19.26371574d0,
     &19.28542709d0,19.31161690d0,19.34394455d0,19.37127304d0,
     &19.40174866d0,19.43339157d0,19.46576881d0,19.50004196d0,
     &19.53539848d0,19.56420326d0,19.59881401d0,19.63164520d0,
     &19.66300201d0,19.69257736d0,19.72000504d0,19.75097084d0,
     &19.77850723d0,19.81081581d0,19.83984947d0,19.87356567d0,
     &19.90283775d0,19.93210030d0,19.96777725d0,20.00444412d0,
     &20.03632927d0,20.06364822d0,20.09687805d0,20.12837410d0,
     &20.16110611d0,20.19395447d0,20.22571754d0,20.25435638d0,
     &20.29303169d0,20.33155823d0,20.36764908d0,20.39719772d0,
     &20.43079948d0,20.46180153d0,20.49203682d0,20.52338791d0,
     &20.55327225d0,20.58965492d0,20.62649727d0,20.65132523d0,
     &20.68976212d0,20.72197533d0,20.74959946d0,20.78000450d0,
     &20.81572151d0,20.85204887d0,20.89115906d0,20.93186569d0,
     &20.96645737d0,21.01268005d0,21.04564095d0,21.08646393d0,
     &21.11984062d0,21.15026474d0,21.18062973d0,21.21006203d0,
     &21.23655128d0,21.26746750d0,21.30449104d0,21.33744621d0,
     &21.36339378d0,21.39559555d0,21.42643929d0,21.45394325d0,
     &21.48803902d0,21.52720070d0,21.56662560d0,21.60482407d0,
     &21.64252090d0,21.67633438d0,21.71666718d0,21.75576210d0,
     &21.79094887d0,21.82509232d0,21.85699272d0,21.88955498d0,
     &21.92346191d0,21.95778656d0,21.99374771d0,22.03220749d0,
     &22.06848145d0,22.10564041d0,22.13628578d0,22.16967392d0,
     &22.21173477d0,22.25386238d0,22.28947449d0,22.31935310d0,
     &22.35968018d0,22.40340805d0,22.42817688d0,22.46358681d0,
     &22.49879074d0,22.52249336d0,22.55506325d0,22.59508514d0,
     &22.62503052d0,22.65528297d0,22.69406319d0,22.72958183d0,
     &22.75888062d0,22.78900337d0,22.82757378d0,22.87203026d0,
     &22.91844749d0,22.94739914d0,22.98574066d0,23.01685333d0,
     &23.05040932d0,23.66191292d0,23.66201973d0,23.66212845d0,
     &23.66223717d0,23.66234207d0,23.66245270d0,23.66256142d0,
     &23.66267204d0,23.66278076d0,23.66288567d0,23.66299629d0,
     &23.66310883d0,23.66321564d0,23.66332626d0,23.66343689d0,
     &23.66355133d0,23.67893791d0,23.71727753d0,23.76037216d0,
     &23.79243279d0,23.82555199d0,23.85718155d0,23.89327621d0,
     &23.93713951d0,23.96761513d0,24.00484276d0,24.04546547d0,
     &24.09129333d0,24.13627625d0,24.18156433d0,24.22654343d0,
     &24.25376129d0,24.27509880d0,24.03699303d0,23.59048080d0,
     &23.02768517d0,22.35520363d0,21.63326454d0,20.84049606d0,
     &20.00231743d0,19.10162163d0,18.16018867d0,17.23831749d0,
     &16.46508026d0,15.46879768d0,16.74488831d0,16.74488831d0,
     &16.74488831d0,16.59890175d0,16.63539886d0,16.63539886d0,
     &16.64756393d0,16.63539886d0,16.53807449d0,16.53807449d0,
     &16.52590752d0,11.67024612d0,11.48671627d0,11.31595039d0,
     &11.14943218d0,10.99014759d0,10.84112930d0,10.69346809d0,
     &10.55432892d0,11.73322487d0,11.80884647d0,11.81865025d0,
     &11.81865025d0,11.80884647d0,11.82845497d0,11.80884647d0,
     &11.81865025d0,11.81865025d0,11.79904270d0,11.79904270d0,
     &11.74354839d0, 9.11330223d0,11.73322487d0,11.80884647d0,
     &11.82845497d0,11.84806252d0,13.69619560d0,12.78113270d0,
     &13.69619560d0,13.71305275d0,13.71305275d0,13.72990990d0,
     &13.72990990d0,13.72990990d0,13.69619560d0,13.69619560d0,
     &11.82845497d0,11.79904270d0,11.81865025d0,11.81865025d0,
     &11.83825874d0,11.84806252d0,11.84806252d0,11.84806252d0,
     &12.78113270d0,13.69619560d0,11.84806252d0,13.69619560d0,
     &13.74676609d0,13.72990990d0,12.78113270d0,11.84806252d0,
     &11.82845497d0,11.82845497d0,11.81865025d0,11.74354839d0,
     &11.73322487d0,11.79904270d0,11.73322487d0,11.73322487d0,
     &11.73322487d0,11.80884647d0,11.74354839d0,11.80884647d0,
     &11.79904270d0,11.81865025d0,11.81865025d0,11.81865025d0,
     &11.74354839d0,11.80884647d0,11.74354839d0,11.79904270d0,
     &11.79904270d0,11.79904270d0,11.73322487d0,11.74354839d0,
     &11.80884647d0,11.83825874d0,11.82845497d0,11.84806252d0,
     &11.85786724d0,12.78113270d0,13.69619560d0,11.85786724d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0,
     &13.69619560d0,13.69619560d0,13.69619560d0,13.69619560d0
     &/
c Definition of open field lines as Lupper=f(Iupper) for doy=151
      DATA (Lupper ( 6,I), I= 1, 1001) /
     & 9.28d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0,
     & 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.27d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0, 9.28d0,
     & 9.28d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.29d0,
     & 9.29d0, 9.29d0, 9.29d0, 9.29d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0,
     & 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.30d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0, 9.31d0,
     & 9.31d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0, 9.32d0,
     & 9.32d0, 9.32d0, 9.32d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0,
     & 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.33d0, 9.34d0, 9.34d0,
     & 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0,
     & 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0,
     & 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0,
     & 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0,
     & 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0,
     & 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0,
     & 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0, 9.34d0,
     & 9.35d0, 9.35d0, 9.36d0, 9.37d0, 9.37d0, 9.38d0, 9.39d0, 9.40d0,
     & 9.40d0, 9.41d0, 9.42d0, 9.42d0, 9.43d0, 9.44d0, 9.44d0, 9.45d0,
     & 9.46d0, 9.47d0, 9.47d0, 9.48d0, 9.49d0, 9.49d0, 9.50d0, 9.51d0,
     & 9.51d0, 9.52d0, 9.53d0, 9.54d0, 9.54d0, 9.55d0, 9.56d0, 9.58d0,
     & 9.60d0, 9.62d0, 9.64d0, 9.66d0, 9.68d0, 9.70d0, 9.72d0, 9.73d0,
     & 9.75d0, 9.77d0, 9.78d0, 9.80d0, 9.82d0, 9.84d0, 9.85d0, 9.87d0,
     & 9.89d0, 9.91d0, 9.93d0, 9.94d0, 9.96d0, 9.98d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0,
     &10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0,
     &10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0,
     & 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,
     &10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     &10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     & 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     &10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     & 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0
     &/
      DATA (Iupper ( 6,I), I= 1, 1001) /
     & 0.00010000d0, 0.00010127d0, 0.00010255d0, 0.00010386d0,
     & 0.00010517d0, 0.00010651d0, 0.00010786d0, 0.00010923d0,
     & 0.00011062d0, 0.00011202d0, 0.00011344d0, 0.00011488d0,
     & 0.00011634d0, 0.00011782d0, 0.00011931d0, 0.00012083d0,
     & 0.00012236d0, 0.00012391d0, 0.00012548d0, 0.00012708d0,
     & 0.00012869d0, 0.00013032d0, 0.00013198d0, 0.00013365d0,
     & 0.00013535d0, 0.00013707d0, 0.00013881d0, 0.00014057d0,
     & 0.00014235d0, 0.00014416d0, 0.00014599d0, 0.00014784d0,
     & 0.00014972d0, 0.00015162d0, 0.00015354d0, 0.00015549d0,
     & 0.00015746d0, 0.00015946d0, 0.00016148d0, 0.00016353d0,
     & 0.00016561d0, 0.00016771d0, 0.00016984d0, 0.00017200d0,
     & 0.00017418d0, 0.00017639d0, 0.00017863d0, 0.00018089d0,
     & 0.00018319d0, 0.00018551d0, 0.00018787d0, 0.00019025d0,
     & 0.00019267d0, 0.00019511d0, 0.00019759d0, 0.00020010d0,
     & 0.00020264d0, 0.00020521d0, 0.00020781d0, 0.00021045d0,
     & 0.00021312d0, 0.00021583d0, 0.00021857d0, 0.00022134d0,
     & 0.00022415d0, 0.00022699d0, 0.00022987d0, 0.00023279d0,
     & 0.00023575d0, 0.00023874d0, 0.00024177d0, 0.00024484d0,
     & 0.00024794d0, 0.00025109d0, 0.00025428d0, 0.00025750d0,
     & 0.00026077d0, 0.00026408d0, 0.00026743d0, 0.00027083d0,
     & 0.00027426d0, 0.00027775d0, 0.00028127d0, 0.00028484d0,
     & 0.00028846d0, 0.00029212d0, 0.00029582d0, 0.00029958d0,
     & 0.00030338d0, 0.00030723d0, 0.00031113d0, 0.00031508d0,
     & 0.00031908d0, 0.00032313d0, 0.00032723d0, 0.00033138d0,
     & 0.00033559d0, 0.00033984d0, 0.00034416d0, 0.00034853d0,
     & 0.00035295d0, 0.00035743d0, 0.00036196d0, 0.00036656d0,
     & 0.00037121d0, 0.00037592d0, 0.00038069d0, 0.00038552d0,
     & 0.00039042d0, 0.00039537d0, 0.00040039d0, 0.00040547d0,
     & 0.00041062d0, 0.00041583d0, 0.00042111d0, 0.00042645d0,
     & 0.00043186d0, 0.00043734d0, 0.00044289d0, 0.00044852d0,
     & 0.00045421d0, 0.00045997d0, 0.00046581d0, 0.00047172d0,
     & 0.00047771d0, 0.00048377d0, 0.00048991d0, 0.00049613d0,
     & 0.00050243d0, 0.00050880d0, 0.00051526d0, 0.00052180d0,
     & 0.00052842d0, 0.00053513d0, 0.00054192d0, 0.00054880d0,
     & 0.00055576d0, 0.00056281d0, 0.00056996d0, 0.00057719d0,
     & 0.00058452d0, 0.00059194d0, 0.00059945d0, 0.00060706d0,
     & 0.00061476d0, 0.00062256d0, 0.00063046d0, 0.00063846d0,
     & 0.00064657d0, 0.00065477d0, 0.00066308d0, 0.00067150d0,
     & 0.00068002d0, 0.00068865d0, 0.00069739d0, 0.00070624d0,
     & 0.00071521d0, 0.00072428d0, 0.00073347d0, 0.00074278d0,
     & 0.00075221d0, 0.00076176d0, 0.00077142d0, 0.00078122d0,
     & 0.00079113d0, 0.00080117d0, 0.00081134d0, 0.00082164d0,
     & 0.00083206d0, 0.00084262d0, 0.00085332d0, 0.00086415d0,
     & 0.00087511d0, 0.00088622d0, 0.00089747d0, 0.00090886d0,
     & 0.00092039d0, 0.00093207d0, 0.00094390d0, 0.00095588d0,
     & 0.00096801d0, 0.00098030d0, 0.00099274d0, 0.00100534d0,
     & 0.00101810d0, 0.00103102d0, 0.00104411d0, 0.00105736d0,
     & 0.00107078d0, 0.00108437d0, 0.00109813d0, 0.00111206d0,
     & 0.00112618d0, 0.00114047d0, 0.00115495d0, 0.00116960d0,
     & 0.00118445d0, 0.00119948d0, 0.00121470d0, 0.00123012d0,
     & 0.00124573d0, 0.00126154d0, 0.00127755d0, 0.00129377d0,
     & 0.00131019d0, 0.00132681d0, 0.00134365d0, 0.00136071d0,
     & 0.00137797d0, 0.00139546d0, 0.00141317d0, 0.00143111d0,
     & 0.00144927d0, 0.00146766d0, 0.00148629d0, 0.00150515d0,
     & 0.00152426d0, 0.00154360d0, 0.00156319d0, 0.00158303d0,
     & 0.00160312d0, 0.00162347d0, 0.00164407d0, 0.00166494d0,
     & 0.00168607d0, 0.00170747d0, 0.00172914d0, 0.00175108d0,
     & 0.00177331d0, 0.00179581d0, 0.00181860d0, 0.00184168d0,
     & 0.00186506d0, 0.00188873d0, 0.00191270d0, 0.00193697d0,
     & 0.00196156d0, 0.00198645d0, 0.00201166d0, 0.00203719d0,
     & 0.00206305d0, 0.00208923d0, 0.00211575d0, 0.00214260d0,
     & 0.00216979d0, 0.00219733d0, 0.00222521d0, 0.00225346d0,
     & 0.00228206d0, 0.00231102d0, 0.00234035d0, 0.00237005d0,
     & 0.00240013d0, 0.00243059d0, 0.00246144d0, 0.00249268d0,
     & 0.00252431d0, 0.00255635d0, 0.00258879d0, 0.00262165d0,
     & 0.00265492d0, 0.00268862d0, 0.00272274d0, 0.00275729d0,
     & 0.00279229d0, 0.00282773d0, 0.00286361d0, 0.00289996d0,
     & 0.00293676d0, 0.00297403d0, 0.00301178d0, 0.00305000d0,
     & 0.00308871d0, 0.00312791d0, 0.00316761d0, 0.00320781d0,
     & 0.00324852d0, 0.00328975d0, 0.00333150d0, 0.00337378d0,
     & 0.00341660d0, 0.00345996d0, 0.00350387d0, 0.00354834d0,
     & 0.00359337d0, 0.00363898d0, 0.00368516d0, 0.00373193d0,
     & 0.00377930d0, 0.00382726d0, 0.00387583d0, 0.00392502d0,
     & 0.00397484d0, 0.00402528d0, 0.00407637d0, 0.00412811d0,
     & 0.00418050d0, 0.00423355d0, 0.00428728d0, 0.00434169d0,
     & 0.00439680d0, 0.00445260d0, 0.00450911d0, 0.00456633d0,
     & 0.00462429d0, 0.00468298d0, 0.00474241d0, 0.00480260d0,
     & 0.00486355d0, 0.00492528d0, 0.00498778d0, 0.00505109d0,
     & 0.00511519d0, 0.00518011d0, 0.00524585d0, 0.00531243d0,
     & 0.00537985d0, 0.00544813d0, 0.00551727d0, 0.00558730d0,
     & 0.00565821d0, 0.00573002d0, 0.00580274d0, 0.00587639d0,
     & 0.00595096d0, 0.00602649d0, 0.00610298d0, 0.00618043d0,
     & 0.00625887d0, 0.00633830d0, 0.00641874d0, 0.00650021d0,
     & 0.00658270d0, 0.00666625d0, 0.00675085d0, 0.00683653d0,
     & 0.00692329d0, 0.00701116d0, 0.00710014d0, 0.00719025d0,
     & 0.00728151d0, 0.00737392d0, 0.00746751d0, 0.00756228d0,
     & 0.00765826d0, 0.00775545d0, 0.00785387d0, 0.00795355d0,
     & 0.00805449d0, 0.00815672d0, 0.00826024d0, 0.00836507d0,
     & 0.00847124d0, 0.00857875d0, 0.00868762d0, 0.00879788d0,
     & 0.00890954d0, 0.00902261d0, 0.00913712d0, 0.00925308d0,
     & 0.00937052d0, 0.00948945d0, 0.00960988d0, 0.00973184d0,
     & 0.00985535d0, 0.00998043d0, 0.01010710d0, 0.01023537d0,
     & 0.01036527d0, 0.01049682d0, 0.01063004d0, 0.01076495d0,
     & 0.01090157d0, 0.01103993d0, 0.01118004d0, 0.01132193d0,
     & 0.01146563d0, 0.01161114d0, 0.01175850d0, 0.01190773d0,
     & 0.01205886d0, 0.01221190d0, 0.01236688d0, 0.01252384d0,
     & 0.01268278d0, 0.01284374d0, 0.01300676d0, 0.01317183d0,
     & 0.01333899d0, 0.01350829d0, 0.01367973d0, 0.01385334d0,
     & 0.01402915d0, 0.01420721d0, 0.01438751d0, 0.01457011d0,
     & 0.01475503d0, 0.01494229d0, 0.01513193d0, 0.01532398d0,
     & 0.01551846d0, 0.01571541d0, 0.01591486d0, 0.01611684d0,
     & 0.01632139d0, 0.01652853d0, 0.01673830d0, 0.01695073d0,
     & 0.01716586d0, 0.01738372d0, 0.01760434d0, 0.01782776d0,
     & 0.01805403d0, 0.01828315d0, 0.01851519d0, 0.01875018d0,
     & 0.01898814d0, 0.01922913d0, 0.01947318d0, 0.01972032d0,
     & 0.01997059d0, 0.02022405d0, 0.02048072d0, 0.02074065d0,
     & 0.02100387d0, 0.02127045d0, 0.02154040d0, 0.02181377d0,
     & 0.02209063d0, 0.02237098d0, 0.02265490d0, 0.02294243d0,
     & 0.02323360d0, 0.02352846d0, 0.02382708d0, 0.02412947d0,
     & 0.02443570d0, 0.02474584d0, 0.02505989d0, 0.02537793d0,
     & 0.02570002d0, 0.02602619d0, 0.02635649d0, 0.02669099d0,
     & 0.02702975d0, 0.02737279d0, 0.02772018d0, 0.02807200d0,
     & 0.02842827d0, 0.02878906d0, 0.02915444d0, 0.02952445d0,
     & 0.02989915d0, 0.03027862d0, 0.03066289d0, 0.03105204d0,
     & 0.03144613d0, 0.03184524d0, 0.03224939d0, 0.03265868d0,
     & 0.03307318d0, 0.03349292d0, 0.03391798d0, 0.03434846d0,
     & 0.03478439d0, 0.03522584d0, 0.03567292d0, 0.03612565d0,
     & 0.03658413d0, 0.03704845d0, 0.03751864d0, 0.03799480d0,
     & 0.03847702d0, 0.03896534d0, 0.03945986d0, 0.03996065d0,
     & 0.04046782d0, 0.04098141d0, 0.04150151d0, 0.04202824d0,
     & 0.04256163d0, 0.04310180d0, 0.04364883d0, 0.04420279d0,
     & 0.04476377d0, 0.04533191d0, 0.04590723d0, 0.04648984d0,
     & 0.04707986d0, 0.04767738d0, 0.04828247d0, 0.04889523d0,
     & 0.04951580d0, 0.05014421d0, 0.05078061d0, 0.05142510d0,
     & 0.05207775d0, 0.05273868d0, 0.05340803d0, 0.05408584d0,
     & 0.05477226d0, 0.05546741d0, 0.05617137d0, 0.05688425d0,
     & 0.05760621d0, 0.05833730d0, 0.05907768d0, 0.05982745d0,
     & 0.06058676d0, 0.06135568d0, 0.06213436d0, 0.06292295d0,
     & 0.06372152d0, 0.06453023d0, 0.06534923d0, 0.06617859d0,
     & 0.06701849d0, 0.06786907d0, 0.06873041d0, 0.06960268d0,
     & 0.07048602d0, 0.07138062d0, 0.07228653d0, 0.07320394d0,
     & 0.07413302d0, 0.07507385d0, 0.07602664d0, 0.07699155d0,
     & 0.07796867d0, 0.07895819d0, 0.07996030d0, 0.08097509d0,
     & 0.08200277d0, 0.08304353d0, 0.08409746d0, 0.08516476d0,
     & 0.08624565d0, 0.08734021d0, 0.08844867d0, 0.08957119d0,
     & 0.09070800d0, 0.09185920d0, 0.09302501d0, 0.09420566d0,
     & 0.09540125d0, 0.09661201d0, 0.09783818d0, 0.09907987d0,
     & 0.10033731d0, 0.10161077d0, 0.10290034d0, 0.10420627d0,
     & 0.10552878d0, 0.10686813d0, 0.10822441d0, 0.10959791d0,
     & 0.11098890d0, 0.11239749d0, 0.11382396d0, 0.11526857d0,
     & 0.11673148d0, 0.11821295d0, 0.11971328d0, 0.12123259d0,
     & 0.12277117d0, 0.12432936d0, 0.12590724d0, 0.12750517d0,
     & 0.12912343d0, 0.13076216d0, 0.13242172d0, 0.13410230d0,
     & 0.13580430d0, 0.13752782d0, 0.13927321d0, 0.14104085d0,
     & 0.14283082d0, 0.14464353d0, 0.14647931d0, 0.14833830d0,
     & 0.15022090d0, 0.15212746d0, 0.15405814d0, 0.15601335d0,
     & 0.15799335d0, 0.15999855d0, 0.16202913d0, 0.16408549d0,
     & 0.16616802d0, 0.16827691d0, 0.17041254d0, 0.17257537d0,
     & 0.17476557d0, 0.17698357d0, 0.17922980d0, 0.18150444d0,
     & 0.18380795d0, 0.18614081d0, 0.18850316d0, 0.19089550d0,
     & 0.19331829d0, 0.19577175d0, 0.19825633d0, 0.20077245d0,
     & 0.20332061d0, 0.20590100d0, 0.20851412d0, 0.21116054d0,
     & 0.21384043d0, 0.21655434d0, 0.21930277d0, 0.22208601d0,
     & 0.22490457d0, 0.22775897d0, 0.23064953d0, 0.23357674d0,
     & 0.23654114d0, 0.23954326d0, 0.24258336d0, 0.24566205d0,
     & 0.24877992d0, 0.25193724d0, 0.25513467d0, 0.25837275d0,
     & 0.26165181d0, 0.26497251d0, 0.26833546d0, 0.27174097d0,
     & 0.27518973d0, 0.27868235d0, 0.28221917d0, 0.28580090d0,
     & 0.28942820d0, 0.29310140d0, 0.29682124d0, 0.30058825d0,
     & 0.30440310d0, 0.30826664d0, 0.31217894d0, 0.31614089d0,
     & 0.32015309d0, 0.32421625d0, 0.32833093d0, 0.33249786d0,
     & 0.33671802d0, 0.34099138d0, 0.34531897d0, 0.34970152d0,
     & 0.35413966d0, 0.35863414d0, 0.36318600d0, 0.36779529d0,
     & 0.37246308d0, 0.37719008d0, 0.38197711d0, 0.38682488d0,
     & 0.39173418d0, 0.39670613d0, 0.40174085d0, 0.40683943d0,
     & 0.41200271d0, 0.41723153d0, 0.42252675d0, 0.42788953d0,
     & 0.43332002d0, 0.43881938d0, 0.44438851d0, 0.45002836d0,
     & 0.45573980d0, 0.46152416d0, 0.46738148d0, 0.47331312d0,
     & 0.47932005d0, 0.48540321d0, 0.49156362d0, 0.49780214d0,
     & 0.50412035d0, 0.51051831d0, 0.51699740d0, 0.52355874d0,
     & 0.53020334d0, 0.53693229d0, 0.54374713d0, 0.55064797d0,
     & 0.55763638d0, 0.56471354d0, 0.57188040d0, 0.57913828d0,
     & 0.58648884d0, 0.59393209d0, 0.60146987d0, 0.60910326d0,
     & 0.61683351d0, 0.62466192d0, 0.63258964d0, 0.64061862d0,
     & 0.64874887d0, 0.65698230d0, 0.66532022d0, 0.67376393d0,
     & 0.68231487d0, 0.69097501d0, 0.69974434d0, 0.70862496d0,
     & 0.71761823d0, 0.72672570d0, 0.73594880d0, 0.74528891d0,
     & 0.75474828d0, 0.76432699d0, 0.77402723d0, 0.78385061d0,
     & 0.79379863d0, 0.80387294d0, 0.81407589d0, 0.82440752d0,
     & 0.83487028d0, 0.84546578d0, 0.85619581d0, 0.86706197d0,
     & 0.87806606d0, 0.88921070d0, 0.90049589d0, 0.91192430d0,
     & 0.92349786d0, 0.93521816d0, 0.94708717d0, 0.95910788d0,
     & 0.97128016d0, 0.98360693d0, 0.99609011d0, 1.00873172d0,
     & 1.02153373d0, 1.03449929d0, 1.04762840d0, 1.06092405d0,
     & 1.07438850d0, 1.08802390d0, 1.10183227d0, 1.11581588d0,
     & 1.12997806d0, 1.14431894d0, 1.15884173d0, 1.17354894d0,
     & 1.18844259d0, 1.20352542d0, 1.21880090d0, 1.23426902d0,
     & 1.24993336d0, 1.26579666d0, 1.28186119d0, 1.29812956d0,
     & 1.31460571d0, 1.33128977d0, 1.34818542d0, 1.36529553d0,
     & 1.38262296d0, 1.40017009d0, 1.41794002d0, 1.43593681d0,
     & 1.45416057d0, 1.47261584d0, 1.49130499d0, 1.51023161d0,
     & 1.52939832d0, 1.54880977d0, 1.56846607d0, 1.58837199d0,
     & 1.60853028d0, 1.62894464d0, 1.64961791d0, 1.67055368d0,
     & 1.69175661d0, 1.71322715d0, 1.73497009d0, 1.75698900d0,
     & 1.77928746d0, 1.80186892d0, 1.82473862d0, 1.84789681d0,
     & 1.87134874d0, 1.89509857d0, 1.91914976d0, 1.94350624d0,
     & 1.96817160d0, 1.99315214d0, 2.01844788d0, 2.04406428d0,
     & 2.07000613d0, 2.09627700d0, 2.12288141d0, 2.14982557d0,
     & 2.17710948d0, 2.20473981d0, 2.23272061d0, 2.26105666d0,
     & 2.28975224d0, 2.31881428d0, 2.34824300d0, 2.37804508d0,
     & 2.40822554d0, 2.43878889d0, 2.46974015d0, 2.50108409d0,
     & 2.53282857d0, 2.56497312d0, 2.59752584d0, 2.63049173d0,
     & 2.66387582d0, 2.69768381d0, 2.73192358d0, 2.76659513d0,
     & 2.80170655d0, 2.83726382d0, 2.87327218d0, 2.90973759d0,
     & 2.94666839d0, 2.98406553d0, 3.02193713d0, 3.06028914d0,
     & 3.09912801d0, 3.13845992d0, 3.17829084d0, 3.21863031d0,
     & 3.25947881d0, 3.30084562d0, 3.34273744d0, 3.38516092d0,
     & 3.42812300d0, 3.47163343d0, 3.51569295d0, 3.56031132d0,
     & 3.60549593d0, 3.65125418d0, 3.69759321d0, 3.74452019d0,
     & 3.79204679d0, 3.84017253d0, 3.88890886d0, 3.93826389d0,
     & 3.98824549d0, 4.03886127d0, 4.09012318d0, 4.14203215d0,
     & 4.19460011d0, 4.24783468d0, 4.30174494d0, 4.35633945d0,
     & 4.41162682d0, 4.46762037d0, 4.52431965d0, 4.58173895d0,
     & 4.63988686d0, 4.69877291d0, 4.75840616d0, 4.81880093d0,
     & 4.87995768d0, 4.94189024d0, 5.00460863d0, 5.06812382d0,
     & 5.13244438d0, 5.19758654d0, 5.26355076d0, 5.33035135d0,
     & 5.39800024d0, 5.46650791d0, 5.53588486d0, 5.60614157d0,
     & 5.67729616d0, 5.74934816d0, 5.82231474d0, 5.89620686d0,
     & 5.97103739d0, 6.04681683d0, 6.12356472d0, 6.20128012d0,
     & 6.27998209d0, 6.35968304d0, 6.44039536d0, 6.52213240d0,
     & 6.60491228d0, 6.68873739d0, 6.77362537d0, 6.85959101d0,
     & 6.94664812d0, 7.03480911d0, 7.12408972d0, 7.21451092d0,
     & 7.30607176d0, 7.39879513d0, 7.49269533d0, 7.58778667d0,
     & 7.68408489d0, 7.78161287d0, 7.88037157d0, 7.98038340d0,
     & 8.08166409d0, 8.18422985d0, 8.28809834d0, 8.39328480d0,
     & 8.49981499d0, 8.60768700d0, 8.71692944d0, 8.82755852d0,
     & 8.93959141d0, 9.05304623d0, 9.16794872d0, 9.28430176d0,
     & 9.40213108d0, 9.52145576d0, 9.64229488d0, 9.76466751d0,
     & 9.88859367d0,10.01410198d0,10.14119339d0,10.26989746d0,
     &10.40023613d0,10.53222752d0,10.66589451d0,10.80126858d0,
     &10.93834972d0,11.07717133d0,11.21775436d0,11.36012173d0,
     &11.50429535d0,11.65031052d0,11.79816723d0,11.94790173d0,
     &12.09953499d0,12.25309372d0,12.40860081d0,12.56608105d0,
     &12.72557259d0,12.88707542d0,13.05062866d0,13.21625710d0,
     &13.38398838d0,13.55384827d0,13.72587585d0,13.90007496d0,
     &14.07648373d0,14.25513268d0,14.43604851d0,14.61925888d0,
     &14.80481052d0,14.99270153d0,15.18297768d0,15.37566853d0,
     &15.57080460d0,15.76841831d0,15.96853828d0,16.17121506d0,
     &16.37644768d0,16.58428574d0,16.79475975d0,17.00790787d0,
     &17.22375870d0,17.44236755d0,17.66373062d0,17.88790512d0,
     &18.11492538d0,18.34482765d0,18.57764626d0,18.81341934d0,
     &19.05220222d0,19.29399872d0,19.53886604d0,19.78683662d0,
     &20.03795815d0,20.29226303d0,20.54981613d0,20.81061935d0,
     &21.07473183d0,21.34219742d0,21.61305809d0,21.88735199d0,
     &22.16513062d0,22.44645500d0,22.73132896d0,23.01981735d0,
     &23.31196785d0,23.60782623d0,23.90743828d0,24.21087837d0,
     &24.51814270d0,24.82930946d0,25.14442444d0,25.46353912d0,
     &25.78670311d0,26.11399269d0,26.44541168d0,26.78103638d0,
     &27.12092209d0,27.46512032d0,27.81368637d0,28.16667747d0,
     &28.52417374d0,28.88618279d0,29.25278282d0,29.62404060d0,
     &30.00000572d0
     &/
c Definition of fits (4 deg polynomial) for doy=151
c A0=f(Lm) same for A1,A2,A3 and A4; to be used every where except Lm>7.5 and I> 1.
      DATA (Lm4 ( 6,I), I= 1,100) /
     & 1.10d0, 1.20d0, 1.30d0, 1.40d0, 1.50d0, 1.60d0, 1.70d0, 1.80d0,
     & 1.90d0, 2.00d0, 2.10d0, 2.20d0, 2.30d0, 2.40d0, 2.50d0, 2.60d0,
     & 2.70d0, 2.80d0, 2.90d0, 3.00d0, 3.10d0, 3.20d0, 3.30d0, 3.40d0,
     & 3.50d0, 3.60d0, 3.70d0, 3.80d0, 3.90d0, 4.00d0, 4.10d0, 4.20d0,
     & 4.30d0, 4.40d0, 4.50d0, 4.60d0, 4.70d0, 4.80d0, 4.90d0, 5.00d0,
     & 5.10d0, 5.20d0, 5.30d0, 5.40d0, 5.50d0, 5.60d0, 5.70d0, 5.80d0,
     & 5.90d0, 6.00d0, 6.10d0, 6.20d0, 6.30d0, 6.40d0, 6.50d0, 6.60d0,
     & 6.70d0, 6.80d0, 6.90d0, 7.00d0, 7.10d0, 7.20d0, 7.30d0, 7.40d0,
     & 7.50d0, 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0,
     & 8.30d0, 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0,
     & 9.10d0, 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0,
     & 9.90d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A0 ( 6,I), I= 1,100) /
     & 1.1011901964D+00, 1.2014991279D+00, 1.3012240419D+00,
     & 1.4009881673D+00, 1.5007914888D+00, 1.5999571195D+00,
     & 1.7004505584D+00, 1.8006848739D+00, 1.8995148726D+00,
     & 1.9987866610D+00, 2.1017509781D+00, 2.1972288737D+00,
     & 2.2950149094D+00, 2.3928765970D+00, 2.4899873854D+00,
     & 2.5840515780D+00, 2.6800281523D+00, 2.7747403693D+00,
     & 2.8660678247D+00, 2.9590039782D+00, 3.0532084808D+00,
     & 3.1439046751D+00, 3.2375492889D+00, 3.3253962452D+00,
     & 3.4178908640D+00, 3.5050643738D+00, 3.5948207020D+00,
     & 3.6812338165D+00, 3.7685310249D+00, 3.8506201636D+00,
     & 3.9392062211D+00, 4.0223633600D+00, 4.1100219172D+00,
     & 4.1918300508D+00, 4.2773862054D+00, 4.3591073926D+00,
     & 4.4422658941D+00, 4.5242619487D+00, 4.6044472137D+00,
     & 4.6868012448D+00, 4.7689652162D+00, 4.8534620085D+00,
     & 4.9293034200D+00, 5.0164502374D+00, 5.0979551833D+00,
     & 5.1744636740D+00, 5.2607091837D+00, 5.3426018870D+00,
     & 5.4261179434D+00, 5.5064794140D+00, 5.5908188703D+00,
     & 5.6758407170D+00, 5.7597782093D+00, 5.8444022948D+00,
     & 5.9309763532D+00, 6.0160691581D+00, 6.1025749530D+00,
     & 6.1905408641D+00, 6.2785735861D+00, 6.3671443797D+00,
     & 6.4578879423D+00, 6.5490848160D+00, 6.6400752339D+00,
     & 6.7352228703D+00, 6.8292462911D+00, 6.9265391073D+00,
     & 7.0250385678D+00, 7.1250399549D+00, 7.2327210836D+00,
     & 7.3371467753D+00, 7.4372751699D+00, 7.5610093823D+00,
     & 7.6710675027D+00, 7.7913057650D+00, 7.9208073357D+00,
     & 8.0311471991D+00, 8.1533646484D+00, 8.2865204928D+00,
     & 8.4150168489D+00, 8.5282993061D+00, 8.6643224646D+00,
     & 8.7815190486D+00,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A1 ( 6,I), I= 1,100) /
     &-5.1992683449D-05, 1.8140149915D-04, 2.9868047157D-04,
     & 4.1010851951D-04, 2.9481322621D-04, 2.1306366083D-04,
     & 1.2681612007D-04, 3.0528753588D-04, 2.1987755846D-04,
     & 1.1685190893D-04, 6.8959290137D-03, 3.2344143350D-03,
     & 3.0915475898D-03, 3.8553456648D-03, 5.5409659605D-03,
     & 7.4984643858D-03, 8.9118184319D-03, 8.9784247851D-03,
     & 1.0247536959D-02, 1.2450469016D-02, 1.2371947761D-02,
     & 1.5363401137D-02, 1.5919254085D-02, 1.7884320020D-02,
     & 1.7741880478D-02, 1.9653200905D-02, 1.9154594503D-02,
     & 2.2996335670D-02, 2.3086965635D-02, 2.6769851890D-02,
     & 2.4446199563D-02, 2.7990528648D-02, 2.7907109358D-02,
     & 2.9716898498D-02, 3.1078388225D-02, 2.9972391468D-02,
     & 3.2504492138D-02, 3.3201758364D-02, 3.4368259627D-02,
     & 3.5564593868D-02, 3.6022491815D-02, 3.6815187616D-02,
     & 3.6364825321D-02, 3.6567432545D-02, 3.7310262701D-02,
     & 3.5725337680D-02, 3.5577153414D-02, 3.5493043902D-02,
     & 3.6210230418D-02, 3.4557972758D-02, 3.4670701328D-02,
     & 3.5669917040D-02, 3.3548736300D-02, 3.1863057486D-02,
     & 3.1468987636D-02, 3.0704829225D-02, 3.0907284055D-02,
     & 2.7056099683D-02, 2.7171617657D-02, 2.2252830661D-02,
     & 2.1700860732D-02, 2.0572705029D-02, 1.6287016754D-02,
     & 1.2579721441D-02, 1.3774235361D-02, 2.9511233216D-02,
     & 2.3703520492D-02, 2.3656436037D-02, 2.4531590057D-02,
     & 8.7225965374D-03,-4.1065010407D-03,-5.9912313246D-03,
     &-1.0203167646D-02,-3.1539824080D-03, 1.6968513820D-02,
     &-3.5909970167D-03,-2.0872891539D-02,-1.5305061516D-02,
     &-1.0279477765D-02,-1.7323895440D-02,-1.4316237119D-02,
     &-4.3077005235D-02,-3.3481635664D-02,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A2 ( 6,I), I= 1,100) /
     &-1.0101462786D-06,-5.8957266109D-06, 5.2428941795D-06,
     & 2.5615903865D-05, 1.0614848394D-05, 1.5679175852D-05,
     &-1.8845571809D-05, 7.6717963511D-06, 9.2713799067D-06,
     &-3.0499931974D-05, 2.9918868747D-03, 8.7038207233D-04,
     & 5.1369082853D-04, 5.6551629367D-04, 7.7520683766D-04,
     & 1.2881533905D-03, 1.5443249220D-03, 1.6722941154D-03,
     & 1.8094998001D-03, 3.2408927331D-03, 2.6835840470D-03,
     & 3.2318502558D-03, 2.8965953084D-03, 4.9258148934D-03,
     & 3.9663292493D-03, 4.4468212348D-03, 3.8539169635D-03,
     & 5.1768647824D-03, 4.7514156487D-03, 6.9123615700D-03,
     & 5.8112265684D-03, 6.8597699548D-03, 6.0919952732D-03,
     & 6.9762077616D-03, 7.2245946369D-03, 7.6046599675D-03,
     & 8.3259999994D-03, 8.4402107448D-03, 8.7675067029D-03,
     & 8.6310101949D-03, 8.5568196868D-03, 8.3281435683D-03,
     & 8.8927660547D-03, 9.2661691447D-03, 9.1287026060D-03,
     & 9.0233447887D-03, 9.0066970265D-03, 8.5664516872D-03,
     & 7.5065549006D-03, 8.5423278550D-03, 8.3055894182D-03,
     & 7.6141298757D-03, 7.3278068697D-03, 7.5688543178D-03,
     & 6.8735555591D-03, 6.5497066348D-03, 5.9292384076D-03,
     & 5.6121503348D-03, 4.5962339618D-03, 5.0694917337D-03,
     & 4.1692180168D-03, 2.9974448142D-03, 3.5814176216D-03,
     & 1.9247015180D-03, 8.6861575563D-04, 1.2627432428D-02,
     & 1.0517771529D-02, 1.1766664152D-02, 1.2387704916D-02,
     & 4.1189755229D-03, 3.4994917832D-04,-3.4840795504D-03,
     &-4.8283254488D-03,-4.6591233257D-04, 9.9980831186D-03,
     & 2.2190152875D-03,-7.3868473894D-03,-5.9455965645D-03,
     &-2.9872785951D-03,-9.3648437056D-04, 4.3594487238D-04,
     &-1.3547075990D-02,-2.6763527362D-04,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A3 ( 6,I), I= 1,100) /
     & 4.5693909608D-07,-1.0680577658D-06,-2.0339626423D-06,
     &-3.5419508846D-06,-2.4406072190D-06,-1.3045917240D-06,
     &-2.6492179215D-06,-3.4431909728D-06,-6.5342416210D-07,
     &-1.7440355491D-06, 4.7450977526D-04, 1.0966830813D-04,
     & 2.8779243641D-05, 2.5493865585D-05, 1.7386538430D-05,
     & 6.5331961220D-05, 7.9094764344D-05, 1.0941844914D-04,
     & 1.1572539599D-04, 3.6652568342D-04, 2.5476986476D-04,
     & 2.6723023863D-04, 1.8974489064D-04, 5.9190730096D-04,
     & 3.6783958530D-04, 4.1429008838D-04, 2.9429641548D-04,
     & 4.7655989828D-04, 3.7123637738D-04, 7.4189085768D-04,
     & 5.8143754548D-04, 6.7853018233D-04, 5.3884469468D-04,
     & 6.9686021053D-04, 6.9774123259D-04, 8.0017672758D-04,
     & 9.2712996532D-04, 9.4418955149D-04, 9.3686090467D-04,
     & 8.5630397159D-04, 8.5526508741D-04, 7.7736854231D-04,
     & 8.9103134396D-04, 9.9497680968D-04, 8.8671871258D-04,
     & 9.2712006470D-04, 8.9950613445D-04, 8.6399454838D-04,
     & 6.1458539774D-04, 8.4714694979D-04, 7.7572875623D-04,
     & 6.1490685893D-04, 5.7701241826D-04, 7.2074393301D-04,
     & 5.8651833685D-04, 5.1959352018D-04, 3.5156788033D-04,
     & 3.4766981805D-04, 1.1965792603D-04, 4.2375247892D-04,
     & 2.7996104020D-04, 7.0566105501D-05, 2.5830827217D-04,
     & 1.3800417612D-04,-3.7701591776D-04, 1.9607924152D-03,
     & 1.6450134777D-03, 1.9222412228D-03, 2.0995595424D-03,
     & 7.3263393431D-04, 2.6484602613D-04,-5.8873991500D-04,
     &-8.3987731127D-04,-4.1678183445D-05, 1.6764984936D-03,
     & 5.2378754613D-04,-1.1544779184D-03,-1.0648671549D-03,
     &-6.8497451151D-04, 7.7753487332D-05, 2.0925469419D-04,
     &-2.1599989446D-03, 2.5327195083D-03,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A4 ( 6,I), I= 1,100) /
     &-3.6141843418D-08, 5.3206035878D-08,-7.3199325064D-08,
     &-3.6690896846D-07,-1.8346592856D-07,-2.4390751568D-07,
     &-1.8867934696D-08,-2.8857184591D-07,-7.7130221709D-08,
     & 1.3747758228D-07, 2.4673317207D-05, 5.1687319273D-06,
     & 1.9067672500D-08,-9.6524461812D-08,-1.7578000551D-06,
     &-6.7500559451D-07,-8.3928881145D-07, 9.5957659009D-07,
     & 1.6176542135D-06, 1.5057063850D-05, 8.7633182510D-06,
     & 7.3607178416D-06, 2.5205989668D-06, 2.5872224775D-05,
     & 1.1955900270D-05, 1.3674007528D-05, 6.2751283419D-06,
     & 1.5043263768D-05, 8.5508596542D-06, 2.8282543409D-05,
     & 2.0727429478D-05, 2.3166573070D-05, 1.6022435002D-05,
     & 2.4900944557D-05, 2.3603366359D-05, 2.9652490465D-05,
     & 3.7479613789D-05, 3.8559590955D-05, 3.5664587156D-05,
     & 2.9528683799D-05, 3.0449058966D-05, 2.5234843509D-05,
     & 3.1095600290D-05, 3.8353341328D-05, 2.8820844152D-05,
     & 3.2896759583D-05, 3.0268176719D-05, 3.0852790892D-05,
     & 1.6075429470D-05, 2.8753134384D-05, 2.3091314457D-05,
     & 1.4571751431D-05, 1.2299953543D-05, 2.3150795669D-05,
     & 1.5672135589D-05, 1.1389776672D-05, 1.0845049673D-06,
     & 4.6098009204D-07,-1.3022577668D-05, 9.1585519421D-06,
     & 2.1477465952D-06,-7.5857531123D-06, 1.4601483096D-06,
     & 2.5651107193D-06,-3.9262591584D-05, 9.8951621181D-05,
     & 8.2079397154D-05, 9.9631754576D-05, 1.1421767712D-04,
     & 4.3244410600D-05, 2.1108051334D-05,-2.9091543265D-05,
     &-4.5674752948D-05, 7.9829313604D-07, 8.8868526257D-05,
     & 3.3758860518D-05,-5.6732147939D-05,-5.3738508889D-05,
     &-4.2103392434D-05, 1.3699218377D-05, 1.6103851340D-05,
     &-1.0955165437D-04, 3.9079437200D-04,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of fits (5 deg polynomial) for doy=151
c A50=f(Lm5) same for A51,A52,A53, A54 and A55
c To be used only where Lm>7.5 and I> 1.
      DATA (Lm5 ( 6,I), I= 1,100) /
     & 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0, 8.30d0,
     & 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0, 9.10d0,
     & 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0, 9.90d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A50 ( 6,I), I= 1,100) /
     & 6.9272434807D+00, 7.0205541824D+00, 7.1233230164D+00,
     & 7.2269373692D+00, 7.3331476636D+00, 7.4410194243D+00,
     & 7.5565565220D+00, 7.6742248448D+00, 7.7940747285D+00,
     & 7.9117233536D+00, 8.0349527100D+00, 8.1642407199D+00,
     & 8.2916709723D+00, 8.4285566319D+00, 8.5356328614D+00,
     & 8.6537324322D+00, 8.7880141580D+00, 8.8994408480D+00,
     & 8.2757663339D+00, 1.1656880332D+01, 1.1553541990D+01,
     & 1.2486929131D+01, 1.3689126039D+01, 1.5494808916D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A51 ( 6,I), I= 1,100) /
     & 5.7691841004D-03, 3.2174546609D-02,-2.4689994594D-03,
     &-9.8534043251D-03, 4.5544239479D-03,-5.2690595131D-03,
     &-4.2198806441D-02,-5.6541389589D-02,-5.0970382810D-02,
     &-7.0450523184D-03,-2.1002963339D-03, 9.2682531886D-02,
     & 3.2972623677D-02, 3.2974695680D-02, 5.9665975573D-02,
     & 3.8721842282D-02,-2.7419999960D-02,-6.4267636624D-02,
     & 3.3257523719D+00,-4.3821109024D+00,-3.4316181508D+00,
     &-5.1272255466D+00,-7.3638838780D+00,-1.0649276646D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A52 ( 6,I), I= 1,100) /
     & 2.1357327225D-02,-4.0678241832D-02, 5.2673981426D-02,
     & 4.6871230699D-02,-3.2210699227D-02,-1.2329098375D-02,
     & 5.0442757426D-02, 5.3961507861D-02, 2.5366000842D-02,
     &-9.0420539684D-02,-9.8975675338D-02,-3.4146982736D-01,
     &-1.7014619325D-01,-1.5050630900D-01,-7.8489453903D-02,
     & 8.7388922682D-02, 2.9231572187D-01, 5.0043842002D-01,
     &-4.2669176502D+00, 2.9607782711D+00, 1.8631667905D+00,
     & 3.4394289965D+00, 5.4549021202D+00, 8.1243128257D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A53 ( 6,I), I= 1,100) /
     &-1.2301252967D-02, 3.9276619077D-02,-6.6628194927D-02,
     &-5.3434583009D-02, 3.6273457415D-02, 2.2938452414D-03,
     &-5.8627414883D-02,-6.2584121392D-02,-5.3652880438D-02,
     & 3.7139606057D-02, 2.4455043572D-02, 2.1828364884D-01,
     & 4.1838961653D-02,-8.1177196052D-03,-1.2954636580D-01,
     &-3.2258168404D-01,-5.2238814534D-01,-7.3407986188D-01,
     & 2.2119177357D+00,-1.1294023336D+00,-5.8354390832D-01,
     &-1.3669239771D+00,-2.3257184347D+00,-3.4402432105D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A54 ( 6,I), I= 1,100) /
     &-1.6239471420D-03,-2.0703521645D-02, 2.6526429762D-02,
     & 1.7169986665D-02,-2.4121715403D-02,-5.6735824576D-03,
     & 1.9165537124D-02, 1.9719114069D-02, 2.1594109968D-02,
     &-1.0445691986D-02,-2.4028509352D-03,-7.0329652507D-02,
     &-1.5418624770D-03, 2.2810396116D-02, 7.6037372319D-02,
     & 1.5193105227D-01, 2.2438050526D-01, 3.0057856787D-01,
     &-5.3911995509D-01, 2.1728897605D-01, 8.9813343288D-02,
     & 2.8690251081D-01, 5.1787629527D-01, 7.5105609058D-01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A55 ( 6,I), I= 1,100) /
     & 1.2233054416D-03, 3.7448598696D-03,-3.4737656533D-03,
     &-1.5015817158D-03, 5.0341478400D-03, 1.8325307835D-03,
     &-1.7406920488D-03,-1.5332870472D-03,-2.4275690521D-03,
     & 1.7788149412D-03, 6.1932908019D-04, 9.3637414531D-03,
     & 2.1778536551D-04,-3.3099738424D-03,-1.0682660540D-02,
     &-2.0585837406D-02,-2.9538870223D-02,-3.8807504526D-02,
     & 5.1363827648D-02,-1.5619265130D-02,-4.0964820893D-03,
     &-2.3731954133D-02,-4.5857684708D-02,-6.5136426617D-02,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of Loss cone as Lmax=f(Imax) for doy=181
      DATA (Lmax ( 7,I), I= 1, 2100) /
     & 1.0874d0, 1.0883d0, 1.0893d0, 1.0903d0, 1.0913d0, 1.0923d0,
     & 1.0933d0, 1.0943d0, 1.0953d0, 1.0963d0, 1.0973d0, 1.0983d0,
     & 1.0993d0, 1.1003d0, 1.1013d0, 1.1023d0, 1.1033d0, 1.1043d0,
     & 1.1053d0, 1.1064d0, 1.1074d0, 1.1084d0, 1.1094d0, 1.1104d0,
     & 1.1115d0, 1.1125d0, 1.1135d0, 1.1145d0, 1.1155d0, 1.1166d0,
     & 1.1176d0, 1.1186d0, 1.1196d0, 1.1206d0, 1.1217d0, 1.1227d0,
     & 1.1237d0, 1.1247d0, 1.1258d0, 1.1268d0, 1.1278d0, 1.1288d0,
     & 1.1299d0, 1.1309d0, 1.1319d0, 1.1329d0, 1.1340d0, 1.1350d0,
     & 1.1360d0, 1.1371d0, 1.1381d0, 1.1391d0, 1.1401d0, 1.1412d0,
     & 1.1422d0, 1.1432d0, 1.1443d0, 1.1453d0, 1.1463d0, 1.1473d0,
     & 1.1484d0, 1.1494d0, 1.1504d0, 1.1514d0, 1.1525d0, 1.1535d0,
     & 1.1545d0, 1.1555d0, 1.1566d0, 1.1576d0, 1.1586d0, 1.1597d0,
     & 1.1607d0, 1.1617d0, 1.1627d0, 1.1638d0, 1.1648d0, 1.1658d0,
     & 1.1669d0, 1.1679d0, 1.1689d0, 1.1699d0, 1.1710d0, 1.1720d0,
     & 1.1730d0, 1.1740d0, 1.1751d0, 1.1761d0, 1.1771d0, 1.1782d0,
     & 1.1792d0, 1.1802d0, 1.1812d0, 1.1822d0, 1.1833d0, 1.1843d0,
     & 1.1854d0, 1.1864d0, 1.1874d0, 1.1884d0, 1.1894d0, 1.1905d0,
     & 1.1915d0, 1.1925d0, 1.1936d0, 1.1946d0, 1.1956d0, 1.1966d0,
     & 1.1976d0, 1.1987d0, 1.1997d0, 1.2007d0, 1.2018d0, 1.2028d0,
     & 1.2038d0, 1.2048d0, 1.2058d0, 1.2069d0, 1.2079d0, 1.2089d0,
     & 1.2100d0, 1.2110d0, 1.2120d0, 1.2130d0, 1.2141d0, 1.2151d0,
     & 1.2161d0, 1.2171d0, 1.2182d0, 1.2192d0, 1.2202d0, 1.2212d0,
     & 1.2222d0, 1.2233d0, 1.2243d0, 1.2253d0, 1.2263d0, 1.2274d0,
     & 1.2284d0, 1.2294d0, 1.2304d0, 1.2315d0, 1.2325d0, 1.2335d0,
     & 1.2345d0, 1.2356d0, 1.2366d0, 1.2376d0, 1.2386d0, 1.2397d0,
     & 1.2407d0, 1.2417d0, 1.2427d0, 1.2438d0, 1.2448d0, 1.2458d0,
     & 1.2468d0, 1.2478d0, 1.2489d0, 1.2499d0, 1.2509d0, 1.2519d0,
     & 1.2530d0, 1.2540d0, 1.2550d0, 1.2560d0, 1.2570d0, 1.2581d0,
     & 1.2591d0, 1.2601d0, 1.2611d0, 1.2622d0, 1.2632d0, 1.2642d0,
     & 1.2652d0, 1.2662d0, 1.2673d0, 1.2683d0, 1.2693d0, 1.2703d0,
     & 1.2713d0, 1.2724d0, 1.2734d0, 1.2744d0, 1.2754d0, 1.2764d0,
     & 1.2775d0, 1.2785d0, 1.2795d0, 1.2805d0, 1.2816d0, 1.2826d0,
     & 1.2836d0, 1.2846d0, 1.2856d0, 1.2866d0, 1.2877d0, 1.2887d0,
     & 1.2897d0, 1.2907d0, 1.2918d0, 1.2928d0, 1.2938d0, 1.2948d0,
     & 1.2958d0, 1.2968d0, 1.2979d0, 1.2989d0, 1.2999d0, 1.3009d0,
     & 1.3019d0, 1.3030d0, 1.3040d0, 1.3050d0, 1.3060d0, 1.3070d0,
     & 1.3081d0, 1.3091d0, 1.3101d0, 1.3111d0, 1.3121d0, 1.3132d0,
     & 1.3142d0, 1.3152d0, 1.3162d0, 1.3172d0, 1.3182d0, 1.3193d0,
     & 1.3203d0, 1.3213d0, 1.3223d0, 1.3233d0, 1.3244d0, 1.3254d0,
     & 1.3264d0, 1.3274d0, 1.3284d0, 1.3295d0, 1.3305d0, 1.3315d0,
     & 1.3325d0, 1.3335d0, 1.3345d0, 1.3355d0, 1.3366d0, 1.3376d0,
     & 1.3386d0, 1.3396d0, 1.3406d0, 1.3417d0, 1.3427d0, 1.3437d0,
     & 1.3447d0, 1.3457d0, 1.3467d0, 1.3478d0, 1.3488d0, 1.3498d0,
     & 1.3508d0, 1.3518d0, 1.3529d0, 1.3539d0, 1.3549d0, 1.3559d0,
     & 1.3569d0, 1.3579d0, 1.3589d0, 1.3599d0, 1.3610d0, 1.3620d0,
     & 1.3630d0, 1.3640d0, 1.3651d0, 1.3661d0, 1.3670d0, 1.3681d0,
     & 1.3691d0, 1.3701d0, 1.3711d0, 1.3721d0, 1.3731d0, 1.3742d0,
     & 1.3752d0, 1.3762d0, 1.3772d0, 1.3782d0, 1.3792d0, 1.3802d0,
     & 1.3813d0, 1.3823d0, 1.3833d0, 1.3843d0, 1.3853d0, 1.3864d0,
     & 1.3874d0, 1.3884d0, 1.3894d0, 1.3904d0, 1.3914d0, 1.3924d0,
     & 1.3934d0, 1.3944d0, 1.3955d0, 1.3965d0, 1.3975d0, 1.3985d0,
     & 1.3995d0, 1.4006d0, 1.4016d0, 1.4026d0, 1.4036d0, 1.4046d0,
     & 1.4056d0, 1.4066d0, 1.4076d0, 1.4086d0, 1.4097d0, 1.4107d0,
     & 1.4117d0, 1.4127d0, 1.4137d0, 1.4148d0, 1.4158d0, 1.4168d0,
     & 1.4178d0, 1.4188d0, 1.4198d0, 1.4208d0, 1.4218d0, 1.4228d0,
     & 1.4238d0, 1.4249d0, 1.4259d0, 1.4269d0, 1.4279d0, 1.4289d0,
     & 1.4300d0, 1.4310d0, 1.4320d0, 1.4330d0, 1.4340d0, 1.4350d0,
     & 1.4360d0, 1.4370d0, 1.4380d0, 1.4390d0, 1.4400d0, 1.4411d0,
     & 1.4421d0, 1.4431d0, 1.4441d0, 1.4452d0, 1.4462d0, 1.4472d0,
     & 1.4482d0, 1.4491d0, 1.4502d0, 1.4512d0, 1.4522d0, 1.4532d0,
     & 1.4542d0, 1.4552d0, 1.4563d0, 1.4573d0, 1.4583d0, 1.4593d0,
     & 1.4604d0, 1.4614d0, 1.4623d0, 1.4633d0, 1.4643d0, 1.4653d0,
     & 1.4663d0, 1.4673d0, 1.4684d0, 1.4694d0, 1.4704d0, 1.4714d0,
     & 1.4724d0, 1.4735d0, 1.4745d0, 1.4755d0, 1.4765d0, 1.4775d0,
     & 1.4785d0, 1.4795d0, 1.4805d0, 1.4815d0, 1.4825d0, 1.4835d0,
     & 1.4845d0, 1.4855d0, 1.4866d0, 1.4876d0, 1.4886d0, 1.4896d0,
     & 1.4907d0, 1.4917d0, 1.4927d0, 1.4937d0, 1.4947d0, 1.4957d0,
     & 1.4966d0, 1.4976d0, 1.4986d0, 1.4996d0, 1.5006d0, 1.5017d0,
     & 1.5027d0, 1.5037d0, 1.5047d0, 1.5058d0, 1.5068d0, 1.5078d0,
     & 1.5088d0, 1.5098d0, 1.5108d0, 1.5118d0, 1.5128d0, 1.5138d0,
     & 1.5148d0, 1.5158d0, 1.5168d0, 1.5178d0, 1.5188d0, 1.5198d0,
     & 1.5209d0, 1.5219d0, 1.5229d0, 1.5239d0, 1.5250d0, 1.5260d0,
     & 1.5270d0, 1.5280d0, 1.5290d0, 1.5300d0, 1.5309d0, 1.5319d0,
     & 1.5329d0, 1.5339d0, 1.5349d0, 1.5360d0, 1.5370d0, 1.5380d0,
     & 1.5390d0, 1.5400d0, 1.5411d0, 1.5421d0, 1.5431d0, 1.5441d0,
     & 1.5451d0, 1.5461d0, 1.5471d0, 1.5481d0, 1.5491d0, 1.5501d0,
     & 1.5510d0, 1.5520d0, 1.5531d0, 1.5541d0, 1.5551d0, 1.5561d0,
     & 1.5571d0, 1.5582d0, 1.5592d0, 1.5602d0, 1.5613d0, 1.5623d0,
     & 1.5633d0, 1.5643d0, 1.5653d0, 1.5662d0, 1.5672d0, 1.5682d0,
     & 1.5692d0, 1.5702d0, 1.5712d0, 1.5722d0, 1.5732d0, 1.5742d0,
     & 1.5753d0, 1.5763d0, 1.5773d0, 1.5784d0, 1.5794d0, 1.5804d0,
     & 1.5814d0, 1.5824d0, 1.5834d0, 1.5844d0, 1.5854d0, 1.5864d0,
     & 1.5873d0, 1.5883d0, 1.5893d0, 1.5903d0, 1.5913d0, 1.5924d0,
     & 1.5934d0, 1.5944d0, 1.5954d0, 1.5965d0, 1.5975d0, 1.5985d0,
     & 1.5996d0, 1.6006d0, 1.6016d0, 1.6025d0, 1.6035d0, 1.6045d0,
     & 1.6055d0, 1.6065d0, 1.6075d0, 1.6084d0, 1.6094d0, 1.6105d0,
     & 1.6115d0, 1.6125d0, 1.6135d0, 1.6145d0, 1.6156d0, 1.6166d0,
     & 1.6176d0, 1.6187d0, 1.6197d0, 1.6207d0, 1.6217d0, 1.6227d0,
     & 1.6237d0, 1.6246d0, 1.6256d0, 1.6266d0, 1.6276d0, 1.6286d0,
     & 1.6295d0, 1.6305d0, 1.6316d0, 1.6326d0, 1.6336d0, 1.6346d0,
     & 1.6357d0, 1.6367d0, 1.6377d0, 1.6387d0, 1.6398d0, 1.6408d0,
     & 1.6418d0, 1.6428d0, 1.6438d0, 1.6448d0, 1.6457d0, 1.6467d0,
     & 1.6477d0, 1.6487d0, 1.6497d0, 1.6507d0, 1.6517d0, 1.6527d0,
     & 1.6537d0, 1.6547d0, 1.6558d0, 1.6568d0, 1.6578d0, 1.6589d0,
     & 1.6599d0, 1.6609d0, 1.6619d0, 1.6629d0, 1.6639d0, 1.6649d0,
     & 1.6659d0, 1.6669d0, 1.6678d0, 1.6688d0, 1.6698d0, 1.6708d0,
     & 1.6717d0, 1.6728d0, 1.6738d0, 1.6748d0, 1.6758d0, 1.6768d0,
     & 1.6779d0, 1.6789d0, 1.6799d0, 1.6810d0, 1.6820d0, 1.6830d0,
     & 1.6840d0, 1.6850d0, 1.6860d0, 1.6870d0, 1.6880d0, 1.6890d0,
     & 1.6899d0, 1.6909d0, 1.6919d0, 1.6929d0, 1.6939d0, 1.6948d0,
     & 1.6958d0, 1.6969d0, 1.6979d0, 1.6989d0, 1.6999d0, 1.7010d0,
     & 1.7020d0, 1.7030d0, 1.7041d0, 1.7051d0, 1.7061d0, 1.7071d0,
     & 1.7081d0, 1.7091d0, 1.7101d0, 1.7111d0, 1.7121d0, 1.7131d0,
     & 1.7140d0, 1.7150d0, 1.7160d0, 1.7170d0, 1.7179d0, 1.7189d0,
     & 1.7199d0, 1.7210d0, 1.7220d0, 1.7230d0, 1.7240d0, 1.7251d0,
     & 1.7261d0, 1.7271d0, 1.7282d0, 1.7292d0, 1.7302d0, 1.7312d0,
     & 1.7322d0, 1.7332d0, 1.7342d0, 1.7352d0, 1.7362d0, 1.7371d0,
     & 1.7381d0, 1.7391d0, 1.7401d0, 1.7410d0, 1.7420d0, 1.7430d0,
     & 1.7440d0, 1.7450d0, 1.7461d0, 1.7471d0, 1.7481d0, 1.7491d0,
     & 1.7502d0, 1.7512d0, 1.7522d0, 1.7533d0, 1.7543d0, 1.7553d0,
     & 1.7563d0, 1.7573d0, 1.7583d0, 1.7593d0, 1.7603d0, 1.7612d0,
     & 1.7622d0, 1.7632d0, 1.7642d0, 1.7651d0, 1.7661d0, 1.7671d0,
     & 1.7681d0, 1.7691d0, 1.7701d0, 1.7711d0, 1.7721d0, 1.7732d0,
     & 1.7742d0, 1.7752d0, 1.7763d0, 1.7773d0, 1.7783d0, 1.7794d0,
     & 1.7804d0, 1.7814d0, 1.7824d0, 1.7834d0, 1.7843d0, 1.7853d0,
     & 1.7863d0, 1.7873d0, 1.7883d0, 1.7892d0, 1.7902d0, 1.7912d0,
     & 1.7922d0, 1.7931d0, 1.7942d0, 1.7952d0, 1.7962d0, 1.7972d0,
     & 1.7982d0, 1.7993d0, 1.8003d0, 1.8013d0, 1.8024d0, 1.8034d0,
     & 1.8045d0, 1.8055d0, 1.8065d0, 1.8075d0, 1.8085d0, 1.8094d0,
     & 1.8104d0, 1.8114d0, 1.8124d0, 1.8134d0, 1.8143d0, 1.8153d0,
     & 1.8163d0, 1.8173d0, 1.8182d0, 1.8192d0, 1.8202d0, 1.8212d0,
     & 1.8222d0, 1.8233d0, 1.8243d0, 1.8253d0, 1.8264d0, 1.8274d0,
     & 1.8284d0, 1.8295d0, 1.8305d0, 1.8315d0, 1.8325d0, 1.8335d0,
     & 1.8345d0, 1.8355d0, 1.8365d0, 1.8375d0, 1.8385d0, 1.8395d0,
     & 1.8404d0, 1.8414d0, 1.8424d0, 1.8434d0, 1.8443d0, 1.8453d0,
     & 1.8463d0, 1.8473d0, 1.8483d0, 1.8493d0, 1.8503d0, 1.8514d0,
     & 1.8524d0, 1.8534d0, 1.8545d0, 1.8555d0, 1.8565d0, 1.8576d0,
     & 1.8586d0, 1.8596d0, 1.8606d0, 1.8616d0, 1.8626d0, 1.8636d0,
     & 1.8646d0, 1.8656d0, 1.8665d0, 1.8675d0, 1.8685d0, 1.8695d0,
     & 1.8704d0, 1.8714d0, 1.8724d0, 1.8734d0, 1.8743d0, 1.8753d0,
     & 1.8763d0, 1.8773d0, 1.8784d0, 1.8794d0, 1.8804d0, 1.8815d0,
     & 1.8825d0, 1.8835d0, 1.8846d0, 1.8856d0, 1.8866d0, 1.8877d0,
     & 1.8887d0, 1.8897d0, 1.8907d0, 1.8916d0, 1.8926d0, 1.8936d0,
     & 1.8946d0, 1.8956d0, 1.8966d0, 1.8975d0, 1.8985d0, 1.8995d0,
     & 1.9005d0, 1.9014d0, 1.9024d0, 1.9034d0, 1.9044d0, 1.9054d0,
     & 1.9064d0, 1.9074d0, 1.9084d0, 1.9094d0, 1.9105d0, 1.9115d0,
     & 1.9125d0, 1.9136d0, 1.9146d0, 1.9157d0, 1.9167d0, 1.9177d0,
     & 1.9187d0, 1.9197d0, 1.9207d0, 1.9217d0, 1.9227d0, 1.9237d0,
     & 1.9246d0, 1.9256d0, 1.9266d0, 1.9276d0, 1.9286d0, 1.9295d0,
     & 1.9305d0, 1.9315d0, 1.9325d0, 1.9334d0, 1.9344d0, 1.9354d0,
     & 1.9364d0, 1.9374d0, 1.9384d0, 1.9395d0, 1.9405d0, 1.9415d0,
     & 1.9426d0, 1.9436d0, 1.9447d0, 1.9457d0, 1.9467d0, 1.9478d0,
     & 1.9488d0, 1.9498d0, 1.9508d0, 1.9518d0, 1.9527d0, 1.9537d0,
     & 1.9547d0, 1.9557d0, 1.9567d0, 1.9577d0, 1.9586d0, 1.9596d0,
     & 1.9606d0, 1.9616d0, 1.9625d0, 1.9635d0, 1.9645d0, 1.9655d0,
     & 1.9664d0, 1.9675d0, 1.9685d0, 1.9695d0, 1.9705d0, 1.9716d0,
     & 1.9726d0, 1.9736d0, 1.9747d0, 1.9757d0, 1.9768d0, 1.9778d0,
     & 1.9788d0, 1.9798d0, 1.9808d0, 1.9818d0, 1.9828d0, 1.9838d0,
     & 1.9848d0, 1.9858d0, 1.9867d0, 1.9877d0, 1.9887d0, 1.9897d0,
     & 1.9907d0, 1.9916d0, 1.9926d0, 1.9936d0, 1.9946d0, 1.9955d0,
     & 1.9965d0, 1.9975d0, 1.9985d0, 1.9995d0, 2.0005d0, 2.0016d0,
     & 2.0026d0, 2.0036d0, 2.0047d0, 2.0057d0, 2.0067d0, 2.0078d0,
     & 2.0088d0, 2.0098d0, 2.0108d0, 2.0118d0, 2.0128d0, 2.0138d0,
     & 2.0148d0, 2.0158d0, 2.0168d0, 2.0178d0, 2.0188d0, 2.0197d0,
     & 2.0207d0, 2.0217d0, 2.0227d0, 2.0237d0, 2.0246d0, 2.0256d0,
     & 2.0266d0, 2.0276d0, 2.0285d0, 2.0295d0, 2.0305d0, 2.0315d0,
     & 2.0325d0, 2.0335d0, 2.0346d0, 2.0356d0, 2.0366d0, 2.0377d0,
     & 2.0387d0, 2.0398d0, 2.0408d0, 2.0419d0, 2.0429d0, 2.0439d0,
     & 2.0449d0, 2.0459d0, 2.0469d0, 2.0479d0, 2.0488d0, 2.0498d0,
     & 2.0508d0, 2.0518d0, 2.0528d0, 2.0538d0, 2.0547d0, 2.0557d0,
     & 2.0567d0, 2.0577d0, 2.0587d0, 2.0596d0, 2.0606d0, 2.0616d0,
     & 2.0626d0, 2.0635d0, 2.0645d0, 2.0655d0, 2.0664d0, 2.0675d0,
     & 2.0685d0, 2.0695d0, 2.0706d0, 2.0716d0, 2.0726d0, 2.0737d0,
     & 2.0747d0, 2.0757d0, 2.0768d0, 2.0778d0, 2.0788d0, 2.0798d0,
     & 2.0808d0, 2.0818d0, 2.0828d0, 2.0838d0, 2.0848d0, 2.0858d0,
     & 2.0868d0, 2.0878d0, 2.0887d0, 2.0897d0, 2.0907d0, 2.0917d0,
     & 2.0927d0, 2.0936d0, 2.0946d0, 2.0956d0, 2.0966d0, 2.0975d0,
     & 2.0985d0, 2.0995d0, 2.1005d0, 2.1014d0, 2.1025d0, 2.1035d0,
     & 2.1045d0, 2.1056d0, 2.1067d0, 2.1077d0, 2.1088d0, 2.1098d0,
     & 2.1109d0, 2.1119d0, 2.1129d0, 2.1139d0, 2.1149d0, 2.1159d0,
     & 2.1169d0, 2.1178d0, 2.1188d0, 2.1197d0, 2.1207d0, 2.1217d0,
     & 2.1227d0, 2.1237d0, 2.1247d0, 2.1257d0, 2.1267d0, 2.1277d0,
     & 2.1286d0, 2.1296d0, 2.1306d0, 2.1315d0, 2.1325d0, 2.1335d0,
     & 2.1345d0, 2.1354d0, 2.1364d0, 2.1374d0, 2.1385d0, 2.1396d0,
     & 2.1406d0, 2.1417d0, 2.1427d0, 2.1437d0, 2.1448d0, 2.1458d0,
     & 2.1469d0, 2.1479d0, 2.1489d0, 2.1499d0, 2.1508d0, 2.1518d0,
     & 2.1528d0, 2.1538d0, 2.1547d0, 2.1557d0, 2.1567d0, 2.1577d0,
     & 2.1587d0, 2.1597d0, 2.1606d0, 2.1616d0, 2.1626d0, 2.1636d0,
     & 2.1646d0, 2.1655d0, 2.1665d0, 2.1675d0, 2.1685d0, 2.1694d0,
     & 2.1704d0, 2.1714d0, 2.1723d0, 2.1733d0, 2.1743d0, 2.1753d0,
     & 2.1763d0, 2.1774d0, 2.1784d0, 2.1794d0, 2.1805d0, 2.1815d0,
     & 2.1826d0, 2.1836d0, 2.1847d0, 2.1857d0, 2.1868d0, 2.1878d0,
     & 2.1888d0, 2.1898d0, 2.1909d0, 2.1920d0, 2.1929d0, 2.1939d0,
     & 2.1949d0, 2.1960d0, 2.1970d0, 2.1979d0, 2.1989d0, 2.1998d0,
     & 2.2009d0, 2.2018d0, 2.2027d0, 2.2038d0, 2.2048d0, 2.2058d0,
     & 2.2067d0, 2.2078d0, 2.2088d0, 2.2098d0, 2.2108d0, 2.2116d0,
     & 2.2125d0, 2.2134d0, 2.2144d0, 2.2154d0, 2.2163d0, 2.2173d0,
     & 2.2183d0, 2.2193d0, 2.2204d0, 2.2215d0, 2.2226d0, 2.2238d0,
     & 2.2249d0, 2.2260d0, 2.2271d0, 2.2281d0, 2.2291d0, 2.2302d0,
     & 2.2312d0, 2.2322d0, 2.2331d0, 2.2341d0, 2.2350d0, 2.2359d0,
     & 2.2368d0, 2.2377d0, 2.2387d0, 2.2396d0, 2.2405d0, 2.2415d0,
     & 2.2425d0, 2.2435d0, 2.2445d0, 2.2454d0, 2.2464d0, 2.2474d0,
     & 2.2484d0, 2.2494d0, 2.2504d0, 2.2514d0, 2.2525d0, 2.2534d0,
     & 2.2543d0, 2.2554d0, 2.2564d0, 2.2574d0, 2.2584d0, 2.2595d0,
     & 2.2606d0, 2.2617d0, 2.2627d0, 2.2638d0, 2.2648d0, 2.2659d0,
     & 2.2669d0, 2.2678d0, 2.2688d0, 2.2698d0, 2.2708d0, 2.2725d0,
     & 2.2751d0, 2.2785d0, 2.2827d0, 2.2876d0, 2.2935d0, 2.3002d0,
     & 2.3077d0, 2.3159d0, 2.3251d0, 2.3350d0, 2.3450d0, 2.3549d0,
     & 2.3648d0, 2.3747d0, 2.3847d0, 2.3946d0, 2.4046d0, 2.4145d0,
     & 2.4244d0, 2.4343d0, 2.4442d0, 2.4541d0, 2.4640d0, 2.4739d0,
     & 2.4839d0, 2.4937d0, 2.5036d0, 2.5135d0, 2.5234d0, 2.5333d0,
     & 2.5432d0, 2.5531d0, 2.5631d0, 2.5730d0, 2.5829d0, 2.5927d0,
     & 2.6026d0, 2.6126d0, 2.6225d0, 2.6324d0, 2.6422d0, 2.6522d0,
     & 2.6621d0, 2.6720d0, 2.6818d0, 2.6917d0, 2.7017d0, 2.7117d0,
     & 2.7216d0, 2.7314d0, 2.7413d0, 2.7513d0, 2.7612d0, 2.7710d0,
     & 2.7809d0, 2.7908d0, 2.8007d0, 2.8106d0, 2.8205d0, 2.8303d0,
     & 2.8402d0, 2.8501d0, 2.8600d0, 2.8699d0, 2.8798d0, 2.8897d0,
     & 2.8996d0, 2.9095d0, 2.9194d0, 2.9292d0, 2.9391d0, 2.9491d0,
     & 2.9590d0, 2.9688d0, 2.9787d0, 2.9886d0, 2.9985d0, 3.0084d0,
     & 3.0181d0, 3.0280d0, 3.0380d0, 3.0478d0, 3.0577d0, 3.0676d0,
     & 3.0775d0, 3.0873d0, 3.0971d0, 3.1070d0, 3.1169d0, 3.1268d0,
     & 3.1367d0, 3.1465d0, 3.1564d0, 3.1662d0, 3.1761d0, 3.1860d0,
     & 3.1959d0, 3.2058d0, 3.2157d0, 3.2255d0, 3.2354d0, 3.2453d0,
     & 3.2552d0, 3.2650d0, 3.2750d0, 3.2848d0, 3.2946d0, 3.3045d0,
     & 3.3143d0, 3.3242d0, 3.3340d0, 3.3438d0, 3.3536d0, 3.3634d0,
     & 3.3732d0, 3.3830d0, 3.3928d0, 3.4028d0, 3.4126d0, 3.4226d0,
     & 3.4324d0, 3.4422d0, 3.4520d0, 3.4618d0, 3.4717d0, 3.4816d0,
     & 3.4916d0, 3.5015d0, 3.5113d0, 3.5211d0, 3.5309d0, 3.5407d0,
     & 3.5506d0, 3.5605d0, 3.5705d0, 3.5803d0, 3.5901d0, 3.5999d0,
     & 3.6096d0, 3.6195d0, 3.6294d0, 3.6393d0, 3.6492d0, 3.6591d0,
     & 3.6689d0, 3.6787d0, 3.6886d0, 3.6985d0, 3.7084d0, 3.7183d0,
     & 3.7282d0, 3.7380d0, 3.7479d0, 3.7577d0, 3.7675d0, 3.7774d0,
     & 3.7873d0, 3.7970d0, 3.8069d0, 3.8167d0, 3.8266d0, 3.8364d0,
     & 3.8462d0, 3.8559d0, 3.8657d0, 3.8755d0, 3.8853d0, 3.8951d0,
     & 3.9051d0, 3.9150d0, 3.9249d0, 3.9346d0, 3.9445d0, 3.9543d0,
     & 3.9642d0, 3.9741d0, 3.9840d0, 3.9939d0, 4.0038d0, 4.0136d0,
     & 4.0235d0, 4.0333d0, 4.0431d0, 4.0530d0, 4.0629d0, 4.0726d0,
     & 4.0825d0, 4.0924d0, 4.1023d0, 4.1121d0, 4.1220d0, 4.1318d0,
     & 4.1416d0, 4.1514d0, 4.1613d0, 4.1711d0, 4.1809d0, 4.1908d0,
     & 4.2007d0, 4.2105d0, 4.2204d0, 4.2303d0, 4.2401d0, 4.2500d0,
     & 4.2600d0, 4.2698d0, 4.2797d0, 4.2896d0, 4.2995d0, 4.3094d0,
     & 4.3192d0, 4.3290d0, 4.3389d0, 4.3487d0, 4.3586d0, 4.3684d0,
     & 4.3783d0, 4.3881d0, 4.3979d0, 4.4077d0, 4.4176d0, 4.4274d0,
     & 4.4373d0, 4.4472d0, 4.4571d0, 4.4669d0, 4.4768d0, 4.4866d0,
     & 4.4965d0, 4.5064d0, 4.5162d0, 4.5261d0, 4.5360d0, 4.5459d0,
     & 4.5558d0, 4.5658d0, 4.5757d0, 4.5857d0, 4.5956d0, 4.6056d0,
     & 4.6154d0, 4.6253d0, 4.6352d0, 4.6452d0, 4.6551d0, 4.6649d0,
     & 4.6748d0, 4.6847d0, 4.6946d0, 4.7046d0, 4.7144d0, 4.7244d0,
     & 4.7343d0, 4.7440d0, 4.7539d0, 4.7638d0, 4.7738d0, 4.7837d0,
     & 4.7936d0, 4.8035d0, 4.8134d0, 4.8234d0, 4.8334d0, 4.8435d0,
     & 4.8535d0, 4.8634d0, 4.8732d0, 4.8830d0, 4.8929d0, 4.9026d0,
     & 4.9125d0, 4.9225d0, 4.9324d0, 4.9424d0, 4.9524d0, 4.9623d0,
     & 4.9723d0, 4.9823d0, 4.9924d0, 5.0023d0, 5.0122d0, 5.0222d0,
     & 5.0320d0, 5.0418d0, 5.0518d0, 5.0618d0, 5.0718d0, 5.0818d0,
     & 5.0918d0, 5.1019d0, 5.1120d0, 5.1221d0, 5.1322d0, 5.1423d0,
     & 5.1523d0, 5.1622d0, 5.1721d0, 5.1821d0, 5.1921d0, 5.2020d0,
     & 5.2118d0, 5.2217d0, 5.2317d0, 5.2417d0, 5.2517d0, 5.2619d0,
     & 5.2720d0, 5.2820d0, 5.2920d0, 5.3019d0, 5.3120d0, 5.3221d0,
     & 5.3321d0, 5.3421d0, 5.3521d0, 5.3621d0, 5.3722d0, 5.3822d0,
     & 5.3923d0, 5.4025d0, 5.4126d0, 5.4227d0, 5.4329d0, 5.4430d0,
     & 5.4532d0, 5.4632d0, 5.4731d0, 5.4832d0, 5.4931d0, 5.5030d0,
     & 5.5129d0, 5.5229d0, 5.5328d0, 5.5429d0, 5.5530d0, 5.5632d0,
     & 5.5733d0, 5.5834d0, 5.5937d0, 5.6039d0, 5.6141d0, 5.6243d0,
     & 5.6345d0, 5.6447d0, 5.6549d0, 5.6649d0, 5.6749d0, 5.6849d0,
     & 5.6950d0, 5.7052d0, 5.7152d0, 5.7254d0, 5.7355d0, 5.7457d0,
     & 5.7559d0, 5.7662d0, 5.7763d0, 5.7866d0, 5.7970d0, 5.8073d0,
     & 5.8175d0, 5.8279d0, 5.8379d0, 5.8481d0, 5.8583d0, 5.8684d0,
     & 5.8784d0, 5.8887d0, 5.8987d0, 5.9089d0, 5.9189d0, 5.9290d0,
     & 5.9392d0, 5.9496d0, 5.9599d0, 5.9702d0, 5.9805d0, 5.9909d0,
     & 6.0013d0, 6.0117d0, 6.0219d0, 6.0323d0, 6.0426d0, 6.0529d0,
     & 6.0630d0, 6.0731d0, 6.0833d0, 6.0934d0, 6.1035d0, 6.1137d0,
     & 6.1239d0, 6.1340d0, 6.1444d0, 6.1548d0, 6.1652d0, 6.1754d0,
     & 6.1858d0, 6.1963d0, 6.2069d0, 6.2174d0, 6.2279d0, 6.2383d0,
     & 6.2487d0, 6.2590d0, 6.2693d0, 6.2797d0, 6.2902d0, 6.3006d0,
     & 6.3108d0, 6.3211d0, 6.3315d0, 6.3416d0, 6.3520d0, 6.3623d0,
     & 6.3728d0, 6.3831d0, 6.3934d0, 6.4038d0, 6.4141d0, 6.4247d0,
     & 6.4352d0, 6.4455d0, 6.4560d0, 6.4666d0, 6.4772d0, 6.4876d0,
     & 6.4980d0, 6.5086d0, 6.5191d0, 6.5298d0, 6.5403d0, 6.5507d0,
     & 6.5613d0, 6.5720d0, 6.5824d0, 6.5929d0, 6.6034d0, 6.6141d0,
     & 6.6244d0, 6.6347d0, 6.6451d0, 6.6555d0, 6.6660d0, 6.6765d0,
     & 6.6868d0, 6.6975d0, 6.7081d0, 6.7186d0, 6.7293d0, 6.7401d0,
     & 6.7507d0, 6.7613d0, 6.7720d0, 6.7825d0, 6.7929d0, 6.8035d0,
     & 6.8139d0, 6.8243d0, 6.8349d0, 6.8455d0, 6.8561d0, 6.8670d0,
     & 6.8777d0, 6.8882d0, 6.8991d0, 6.9100d0, 6.9209d0, 6.9319d0,
     & 6.9428d0, 6.9535d0, 6.9641d0, 6.9748d0, 6.9855d0, 6.9962d0,
     & 7.0070d0, 7.0176d0, 7.0282d0, 7.0387d0, 7.0493d0, 7.0598d0,
     & 7.0704d0, 7.0811d0, 7.0918d0, 7.1025d0, 7.1132d0, 7.1238d0,
     & 7.1345d0, 7.1452d0, 7.1561d0, 7.1670d0, 7.1779d0, 7.1889d0,
     & 7.1997d0, 7.2106d0, 7.2216d0, 7.2328d0, 7.2439d0, 7.2551d0,
     & 7.2662d0, 7.2770d0, 7.2879d0, 7.2987d0, 7.3096d0, 7.3208d0,
     & 7.3316d0, 7.3425d0, 7.3535d0, 7.3645d0, 7.3755d0, 7.3865d0,
     & 7.3977d0, 7.4088d0, 7.4200d0, 7.4309d0, 7.4417d0, 7.4525d0,
     & 7.4633d0, 7.4742d0, 7.4852d0, 7.4961d0, 7.5070d0, 7.5180d0,
     & 7.5291d0, 7.5402d0, 7.5516d0, 7.5629d0, 7.5743d0, 7.5857d0,
     & 7.5967d0, 7.6077d0, 7.6188d0, 7.6298d0, 7.6409d0, 7.6522d0,
     & 7.6634d0, 7.6745d0, 7.6857d0, 7.6969d0, 7.7079d0, 7.7193d0,
     & 7.7304d0, 7.7419d0, 7.7533d0, 7.7646d0, 7.7756d0, 7.7867d0,
     & 7.7978d0, 7.8091d0, 7.8202d0, 7.8316d0, 7.8427d0, 7.8543d0,
     & 7.8657d0, 7.8769d0, 7.8884d0, 7.9000d0, 7.9117d0, 7.9229d0,
     & 7.9342d0, 7.9458d0, 7.9574d0, 7.9689d0, 7.9803d0, 7.9918d0,
     & 8.0035d0, 8.0149d0, 8.0261d0, 8.0376d0, 8.0495d0, 8.0611d0,
     & 8.0727d0, 8.0842d0, 8.0960d0, 8.1073d0, 8.1190d0, 8.1303d0,
     & 8.1419d0, 8.1536d0, 8.1651d0, 8.1768d0, 8.1884d0, 8.1998d0,
     & 8.2113d0, 8.2230d0, 8.2348d0, 8.2463d0, 8.2582d0, 8.2701d0,
     & 8.2819d0, 8.2937d0, 8.3054d0, 8.3172d0, 8.3293d0, 8.3413d0,
     & 8.3532d0, 8.3652d0, 8.3772d0, 8.3892d0, 8.4011d0, 8.4131d0,
     & 8.4252d0, 8.4372d0, 8.4492d0, 8.4608d0, 8.4725d0, 8.4844d0,
     & 8.4962d0, 8.5082d0, 8.5202d0, 8.5321d0, 8.5439d0, 8.5560d0,
     & 8.5678d0, 8.5800d0, 8.5922d0, 8.6044d0, 8.6166d0, 8.6288d0,
     & 8.6410d0, 8.6529d0, 8.6651d0, 8.6774d0, 8.6893d0, 8.7018d0,
     & 8.7139d0, 8.7264d0, 8.7389d0, 8.7513d0, 8.7637d0, 8.7760d0,
     & 8.7886d0, 8.8014d0, 8.8140d0, 8.8268d0, 8.8394d0, 8.8519d0,
     & 8.8644d0, 8.8768d0, 8.8892d0, 8.9019d0, 8.9146d0, 8.9273d0,
     & 8.9399d0, 8.9522d0, 8.9646d0, 8.9772d0, 8.9900d0, 9.0027d0,
     & 9.0155d0, 9.0281d0, 9.0405d0, 9.0531d0, 9.0658d0, 9.0784d0,
     & 9.0915d0, 9.1045d0, 9.1173d0, 9.1303d0, 9.1432d0, 9.1562d0,
     & 9.1692d0, 9.1821d0, 9.1953d0, 9.2081d0, 9.2211d0, 9.2341d0,
     & 9.2469d0, 9.2597d0, 9.2727d0, 9.2857d0, 9.2988d0, 9.3122d0,
     & 9.3258d0, 9.3390d0, 9.3524d0, 9.3655d0, 9.3787d0, 9.3920d0,
     & 9.4053d0, 9.4189d0, 9.4323d0, 9.4454d0, 9.4589d0, 9.4722d0,
     & 9.4857d0, 9.4992d0, 9.5130d0, 9.5267d0, 9.5408d0, 9.5547d0,
     & 9.5685d0, 9.5822d0, 9.5963d0, 9.6100d0, 9.6237d0, 9.6370d0,
     & 9.6506d0, 9.6644d0, 9.6782d0, 9.6919d0, 9.7058d0, 9.7197d0,
     & 9.7332d0, 9.7470d0, 9.7610d0, 9.7753d0, 9.7897d0, 9.8042d0,
     & 9.8182d0, 9.8319d0, 9.8461d0, 9.8602d0, 9.8742d0, 9.8888d0,
     & 9.9028d0, 9.9169d0, 9.9308d0, 9.9435d0, 9.9547d0, 9.9650d0,
     & 9.9742d0, 9.9817d0, 9.9879d0, 9.9928d0, 9.9964d0, 9.9989d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0
     &/
      DATA (Imax ( 7,I), I= 1, 1000) /
     & 0.00000418d0, 0.00006224d0, 0.00016247d0, 0.00031877d0,
     & 0.00056602d0, 0.00084851d0, 0.00124519d0, 0.00176900d0,
     & 0.00233781d0, 0.00303288d0, 0.00386781d0, 0.00481546d0,
     & 0.00581886d0, 0.00694463d0, 0.00810766d0, 0.00930922d0,
     & 0.01063446d0, 0.01199277d0, 0.01335406d0, 0.01481435d0,
     & 0.01632900d0, 0.01788282d0, 0.01945906d0, 0.02105221d0,
     & 0.02268893d0, 0.02440515d0, 0.02613982d0, 0.02784746d0,
     & 0.02961824d0, 0.03144902d0, 0.03329706d0, 0.03511788d0,
     & 0.03695596d0, 0.03885668d0, 0.04080579d0, 0.04270273d0,
     & 0.04460459d0, 0.04656910d0, 0.04859062d0, 0.05057540d0,
     & 0.05254874d0, 0.05456370d0, 0.05662016d0, 0.05867035d0,
     & 0.06070800d0, 0.06274971d0, 0.06485289d0, 0.06695966d0,
     & 0.06905780d0, 0.07115599d0, 0.07328226d0, 0.07544436d0,
     & 0.07758378d0, 0.07974163d0, 0.08190861d0, 0.08407268d0,
     & 0.08629183d0, 0.08848715d0, 0.09069982d0, 0.09290688d0,
     & 0.09513430d0, 0.09735617d0, 0.09959913d0, 0.10185931d0,
     & 0.10409839d0, 0.10635711d0, 0.10863110d0, 0.11088379d0,
     & 0.11316910d0, 0.11546027d0, 0.11775535d0, 0.12005473d0,
     & 0.12235623d0, 0.12465626d0, 0.12699451d0, 0.12935273d0,
     & 0.13166897d0, 0.13400505d0, 0.13633396d0, 0.13864788d0,
     & 0.14101529d0, 0.14338921d0, 0.14576635d0, 0.14814341d0,
     & 0.15049985d0, 0.15283358d0, 0.15520051d0, 0.15761554d0,
     & 0.16003573d0, 0.16245589d0, 0.16486870d0, 0.16722658d0,
     & 0.16959725d0, 0.17201135d0, 0.17445324d0, 0.17689708d0,
     & 0.17933996d0, 0.18174760d0, 0.18412261d0, 0.18651368d0,
     & 0.18894672d0, 0.19142906d0, 0.19391131d0, 0.19639182d0,
     & 0.19881020d0, 0.20121710d0, 0.20362218d0, 0.20606127d0,
     & 0.20854974d0, 0.21107548d0, 0.21358250d0, 0.21605864d0,
     & 0.21848352d0, 0.22092505d0, 0.22334984d0, 0.22586000d0,
     & 0.22839896d0, 0.23095687d0, 0.23347794d0, 0.23594654d0,
     & 0.23841062d0, 0.24087498d0, 0.24332803d0, 0.24585517d0,
     & 0.24838810d0, 0.25097626d0, 0.25349349d0, 0.25597849d0,
     & 0.25844121d0, 0.26092383d0, 0.26340878d0, 0.26593688d0,
     & 0.26849371d0, 0.27106690d0, 0.27360252d0, 0.27612886d0,
     & 0.27861401d0, 0.28110117d0, 0.28359109d0, 0.28613332d0,
     & 0.28871685d0, 0.29131889d0, 0.29387596d0, 0.29642129d0,
     & 0.29896417d0, 0.30148706d0, 0.30401078d0, 0.30653620d0,
     & 0.30913597d0, 0.31176069d0, 0.31435251d0, 0.31692097d0,
     & 0.31948531d0, 0.32204813d0, 0.32456973d0, 0.32709256d0,
     & 0.32963055d0, 0.33222559d0, 0.33484718d0, 0.33741397d0,
     & 0.33997145d0, 0.34254798d0, 0.34510347d0, 0.34766039d0,
     & 0.35019910d0, 0.35276216d0, 0.35537422d0, 0.35800394d0,
     & 0.36061984d0, 0.36322546d0, 0.36582789d0, 0.36840844d0,
     & 0.37099060d0, 0.37355313d0, 0.37611797d0, 0.37870610d0,
     & 0.38136068d0, 0.38399032d0, 0.38660693d0, 0.38919833d0,
     & 0.39176762d0, 0.39436036d0, 0.39697659d0, 0.39955038d0,
     & 0.40214381d0, 0.40480453d0, 0.40749916d0, 0.41010177d0,
     & 0.41270140d0, 0.41532424d0, 0.41794860d0, 0.42057434d0,
     & 0.42317992d0, 0.42578787d0, 0.42839876d0, 0.43101704d0,
     & 0.43364397d0, 0.43626001d0, 0.43892121d0, 0.44155815d0,
     & 0.44417274d0, 0.44676551d0, 0.44938290d0, 0.45197967d0,
     & 0.45460153d0, 0.45722544d0, 0.45993951d0, 0.46260455d0,
     & 0.46524310d0, 0.46788174d0, 0.47052157d0, 0.47316313d0,
     & 0.47580647d0, 0.47845191d0, 0.48109922d0, 0.48372555d0,
     & 0.48641753d0, 0.48908609d0, 0.49173000d0, 0.49440017d0,
     & 0.49700093d0, 0.49962854d0, 0.50228304d0, 0.50494009d0,
     & 0.50757617d0, 0.51023793d0, 0.51290274d0, 0.51553971d0,
     & 0.51813024d0, 0.52077532d0, 0.52344757d0, 0.52612096d0,
     & 0.52879620d0, 0.53142524d0, 0.53407985d0, 0.53676027d0,
     & 0.53941905d0, 0.54208016d0, 0.54470944d0, 0.54739386d0,
     & 0.55008322d0, 0.55275059d0, 0.55546844d0, 0.55818832d0,
     & 0.56086135d0, 0.56351256d0, 0.56616616d0, 0.56887013d0,
     & 0.57155216d0, 0.57426006d0, 0.57692391d0, 0.57954890d0,
     & 0.58215517d0, 0.58486146d0, 0.58754689d0, 0.59025979d0,
     & 0.59297591d0, 0.59567100d0, 0.59834528d0, 0.60102218d0,
     & 0.60367727d0, 0.60631478d0, 0.60899770d0, 0.61169589d0,
     & 0.61430597d0, 0.61702359d0, 0.61976886d0, 0.62251663d0,
     & 0.62521636d0, 0.62794310d0, 0.63064688d0, 0.63335264d0,
     & 0.63606060d0, 0.63869703d0, 0.64130622d0, 0.64402485d0,
     & 0.64664900d0, 0.64927918d0, 0.65191329d0, 0.65465170d0,
     & 0.65739346d0, 0.66016251d0, 0.66288310d0, 0.66558117d0,
     & 0.66833133d0, 0.67108321d0, 0.67371279d0, 0.67637670d0,
     & 0.67908621d0, 0.68180317d0, 0.68447441d0, 0.68717724d0,
     & 0.68990880d0, 0.69269347d0, 0.69548035d0, 0.69816822d0,
     & 0.70088369d0, 0.70359176d0, 0.70625198d0, 0.70890850d0,
     & 0.71160769d0, 0.71432531d0, 0.71697474d0, 0.71960580d0,
     & 0.72224289d0, 0.72498947d0, 0.72779083d0, 0.73059601d0,
     & 0.73341310d0, 0.73623204d0, 0.73895109d0, 0.74161661d0,
     & 0.74425638d0, 0.74693823d0, 0.74965328d0, 0.75243545d0,
     & 0.75511932d0, 0.75780827d0, 0.76047522d0, 0.76314551d0,
     & 0.76592362d0, 0.76870328d0, 0.77148503d0, 0.77429497d0,
     & 0.77705026d0, 0.77976388d0, 0.78240418d0, 0.78505456d0,
     & 0.78778791d0, 0.79053074d0, 0.79328036d0, 0.79593009d0,
     & 0.79863626d0, 0.80134594d0, 0.80403280d0, 0.80682755d0,
     & 0.80965072d0, 0.81247604d0, 0.81528240d0, 0.81794703d0,
     & 0.82059735d0, 0.82328308d0, 0.82599527d0, 0.82871991d0,
     & 0.83146983d0, 0.83425403d0, 0.83696532d0, 0.83965522d0,
     & 0.84248292d0, 0.84531420d0, 0.84820080d0, 0.85101122d0,
     & 0.85380548d0, 0.85656846d0, 0.85931545d0, 0.86206084d0,
     & 0.86481911d0, 0.86756474d0, 0.87031925d0, 0.87294644d0,
     & 0.87557942d0, 0.87821698d0, 0.88093764d0, 0.88363504d0,
     & 0.88633531d0, 0.88903809d0, 0.89171702d0, 0.89445561d0,
     & 0.89714861d0, 0.89980263d0, 0.90244782d0, 0.90515596d0,
     & 0.90782261d0, 0.91050136d0, 0.91321629d0, 0.91593713d0,
     & 0.91863531d0, 0.92136496d0, 0.92396438d0, 0.92659330d0,
     & 0.92933309d0, 0.93196732d0, 0.93453342d0, 0.93721789d0,
     & 0.93988758d0, 0.94246507d0, 0.94503480d0, 0.94772106d0,
     & 0.95033926d0, 0.95299792d0, 0.95566541d0, 0.95825869d0,
     & 0.96096534d0, 0.96367639d0, 0.96631068d0, 0.96892112d0,
     & 0.97158843d0, 0.97425842d0, 0.97686261d0, 0.97953093d0,
     & 0.98218393d0, 0.98482639d0, 0.98743296d0, 0.99000585d0,
     & 0.99264711d0, 0.99530637d0, 0.99801177d0, 1.00072682d0,
     & 1.00339270d0, 1.00603843d0, 1.00863552d0, 1.01129282d0,
     & 1.01392710d0, 1.01659250d0, 1.01926124d0, 1.02196920d0,
     & 1.02463031d0, 1.02727222d0, 1.02984893d0, 1.03247571d0,
     & 1.03509569d0, 1.03781199d0, 1.04049158d0, 1.04321027d0,
     & 1.04590857d0, 1.04861259d0, 1.05118454d0, 1.05378902d0,
     & 1.05639720d0, 1.05906415d0, 1.06173372d0, 1.06440568d0,
     & 1.06697905d0, 1.06953228d0, 1.07207215d0, 1.07468605d0,
     & 1.07732034d0, 1.07997620d0, 1.08267820d0, 1.08540976d0,
     & 1.08815575d0, 1.09091258d0, 1.09364867d0, 1.09639001d0,
     & 1.09910774d0, 1.10183048d0, 1.10450280d0, 1.10717857d0,
     & 1.10985756d0, 1.11248755d0, 1.11505759d0, 1.11761141d0,
     & 1.12015295d0, 1.12271452d0, 1.12526965d0, 1.12784648d0,
     & 1.13041866d0, 1.13315463d0, 1.13590705d0, 1.13867044d0,
     & 1.14138353d0, 1.14413154d0, 1.14688504d0, 1.14961481d0,
     & 1.15234888d0, 1.15511358d0, 1.15785396d0, 1.16059721d0,
     & 1.16317475d0, 1.16573477d0, 1.16825473d0, 1.17082441d0,
     & 1.17338657d0, 1.17608178d0, 1.17874372d0, 1.18147051d0,
     & 1.18422103d0, 1.18698323d0, 1.18975496d0, 1.19253445d0,
     & 1.19532025d0, 1.19813931d0, 1.20090544d0, 1.20367563d0,
     & 1.20631027d0, 1.20897663d0, 1.21157682d0, 1.21417308d0,
     & 1.21678579d0, 1.21936035d0, 1.22192740d0, 1.22448862d0,
     & 1.22701728d0, 1.22971153d0, 1.23247325d0, 1.23526001d0,
     & 1.23809028d0, 1.24087167d0, 1.24364233d0, 1.24639082d0,
     & 1.24917352d0, 1.25196147d0, 1.25475371d0, 1.25757766d0,
     & 1.26029289d0, 1.26285481d0, 1.26539171d0, 1.26791382d0,
     & 1.27048516d0, 1.27304757d0, 1.27563107d0, 1.27818024d0,
     & 1.28072500d0, 1.28344858d0, 1.28621185d0, 1.28893101d0,
     & 1.29174984d0, 1.29457867d0, 1.29741418d0, 1.30025697d0,
     & 1.30307579d0, 1.30590034d0, 1.30875719d0, 1.31161666d0,
     & 1.31423891d0, 1.31682086d0, 1.31941783d0, 1.32200050d0,
     & 1.32457304d0, 1.32713854d0, 1.32969666d0, 1.33227861d0,
     & 1.33482718d0, 1.33737051d0, 1.33995235d0, 1.34263301d0,
     & 1.34530139d0, 1.34801221d0, 1.35085332d0, 1.35370111d0,
     & 1.35652518d0, 1.35935318d0, 1.36221588d0, 1.36508179d0,
     & 1.36789453d0, 1.37066853d0, 1.37340081d0, 1.37614512d0,
     & 1.37887526d0, 1.38147461d0, 1.38403833d0, 1.38662565d0,
     & 1.38920891d0, 1.39175761d0, 1.39433157d0, 1.39719713d0,
     & 1.40004790d0, 1.40291095d0, 1.40578365d0, 1.40860391d0,
     & 1.41143119d0, 1.41432154d0, 1.41718709d0, 1.42005801d0,
     & 1.42287302d0, 1.42569268d0, 1.42827952d0, 1.43088329d0,
     & 1.43344676d0, 1.43600190d0, 1.43861091d0, 1.44121432d0,
     & 1.44378483d0, 1.44635284d0, 1.44891691d0, 1.45153844d0,
     & 1.45420861d0, 1.45688212d0, 1.45954299d0, 1.46224749d0,
     & 1.46499479d0, 1.46781075d0, 1.47066295d0, 1.47352040d0,
     & 1.47641110d0, 1.47921741d0, 1.48199809d0, 1.48470116d0,
     & 1.48740160d0, 1.49011397d0, 1.49281204d0, 1.49543869d0,
     & 1.49799573d0, 1.50048816d0, 1.50297701d0, 1.50537467d0,
     & 1.50785589d0, 1.51036429d0, 1.51286983d0, 1.51541436d0,
     & 1.51803660d0, 1.52083480d0, 1.52364135d0, 1.52645910d0,
     & 1.52931285d0, 1.53214121d0, 1.53494215d0, 1.53771996d0,
     & 1.54053092d0, 1.54337513d0, 1.54618120d0, 1.54885125d0,
     & 1.55134594d0, 1.55383265d0, 1.55631006d0, 1.55875158d0,
     & 1.56121790d0, 1.56379926d0, 1.56640553d0, 1.56894875d0,
     & 1.57148838d0, 1.57399571d0, 1.57653022d0, 1.57913518d0,
     & 1.58179581d0, 1.58444154d0, 1.58722508d0, 1.59001768d0,
     & 1.59278715d0, 1.59559333d0, 1.59849250d0, 1.60136616d0,
     & 1.60421467d0, 1.60700679d0, 1.60972965d0, 1.61242723d0,
     & 1.61511111d0, 1.61768579d0, 1.62034225d0, 1.62287390d0,
     & 1.62537134d0, 1.62780571d0, 1.63023698d0, 1.63272309d0,
     & 1.63529539d0, 1.63783562d0, 1.64034367d0, 1.64293265d0,
     & 1.64552665d0, 1.64818108d0, 1.65096450d0, 1.65366423d0,
     & 1.65637314d0, 1.65927148d0, 1.66217530d0, 1.66499329d0,
     & 1.66784525d0, 1.67070055d0, 1.67350614d0, 1.67636883d0,
     & 1.67899311d0, 1.68172717d0, 1.68442559d0, 1.68711603d0,
     & 1.68961728d0, 1.69211197d0, 1.69466364d0, 1.69721282d0,
     & 1.69978845d0, 1.70233154d0, 1.70472229d0, 1.70720136d0,
     & 1.70963275d0, 1.71222830d0, 1.71484601d0, 1.71747637d0,
     & 1.72012079d0, 1.72280455d0, 1.72548795d0, 1.72814906d0,
     & 1.73084891d0, 1.73388731d0, 1.73680890d0, 1.73966181d0,
     & 1.74256337d0, 1.74529374d0, 1.74804342d0, 1.75078321d0,
     & 1.75351572d0, 1.75625074d0, 1.75898063d0, 1.76170337d0,
     & 1.76414979d0, 1.76671350d0, 1.76927459d0, 1.77174151d0,
     & 1.77432787d0, 1.77692306d0, 1.77955425d0, 1.78221345d0,
     & 1.78488874d0, 1.78757477d0, 1.79027164d0, 1.79300678d0,
     & 1.79571843d0, 1.79846442d0, 1.80118537d0, 1.80394280d0,
     & 1.80681515d0, 1.80962288d0, 1.81240416d0, 1.81513894d0,
     & 1.81789410d0, 1.82060981d0, 1.82331789d0, 1.82602084d0,
     & 1.82883930d0, 1.83156443d0, 1.83425379d0, 1.83681810d0,
     & 1.83940971d0, 1.84196889d0, 1.84455550d0, 1.84711015d0,
     & 1.84976685d0, 1.85245407d0, 1.85515666d0, 1.85765696d0,
     & 1.86028957d0, 1.86296237d0, 1.86561227d0, 1.86826992d0,
     & 1.87096393d0, 1.87366378d0, 1.87639654d0, 1.87902927d0,
     & 1.88163590d0, 1.88425899d0, 1.88711810d0, 1.89008594d0,
     & 1.89286411d0, 1.89563608d0, 1.89842939d0, 1.90121913d0,
     & 1.90397406d0, 1.90672684d0, 1.90950608d0, 1.91225016d0,
     & 1.91490161d0, 1.91739929d0, 1.91977441d0, 1.92238450d0,
     & 1.92506528d0, 1.92770660d0, 1.93039525d0, 1.93302917d0,
     & 1.93567431d0, 1.93832874d0, 1.94102108d0, 1.94380963d0,
     & 1.94657314d0, 1.94931126d0, 1.95199573d0, 1.95464420d0,
     & 1.95730662d0, 1.95989144d0, 1.96256280d0, 1.96522474d0,
     & 1.96806049d0, 1.97082686d0, 1.97358990d0, 1.97634888d0,
     & 1.97913432d0, 1.98188806d0, 1.98454416d0, 1.98719943d0,
     & 1.98985255d0, 1.99265289d0, 1.99549067d0, 1.99792612d0,
     & 2.00047112d0, 2.00304461d0, 2.00563431d0, 2.00823879d0,
     & 2.01098156d0, 2.01379323d0, 2.01660824d0, 2.01950765d0,
     & 2.02212429d0, 2.02458239d0, 2.02723408d0, 2.02984262d0,
     & 2.03248239d0, 2.03514123d0, 2.03775692d0, 2.04025841d0,
     & 2.04278851d0, 2.04528594d0, 2.04773188d0, 2.05028343d0,
     & 2.05292630d0, 2.05559731d0, 2.05823565d0, 2.06090307d0,
     & 2.06362677d0, 2.06628919d0, 2.06892872d0, 2.07165623d0,
     & 2.07431912d0, 2.07700539d0, 2.07969117d0, 2.08243537d0,
     & 2.08520055d0, 2.08800983d0, 2.09073973d0, 2.09341884d0,
     & 2.09616470d0, 2.09891629d0, 2.10158181d0, 2.10431480d0,
     & 2.10702801d0, 2.10986495d0, 2.11264515d0, 2.11540937d0,
     & 2.11816168d0, 2.12096596d0, 2.12357664d0, 2.12621546d0,
     & 2.12915373d0, 2.13196540d0, 2.13452744d0, 2.13708830d0,
     & 2.13952518d0, 2.14199018d0, 2.14444995d0, 2.14705849d0,
     & 2.14954329d0, 2.15221190d0, 2.15484619d0, 2.15723753d0,
     & 2.15977359d0, 2.16257668d0, 2.16543388d0, 2.16830277d0,
     & 2.17118382d0, 2.17404222d0, 2.17685390d0, 2.17954278d0,
     & 2.18223906d0, 2.18497181d0, 2.18764591d0, 2.19030094d0,
     & 2.19296813d0, 2.19558120d0, 2.19818473d0, 2.20077872d0,
     & 2.20339704d0, 2.20591307d0, 2.20858097d0, 2.21124578d0,
     & 2.21411991d0, 2.21701789d0, 2.21991491d0, 2.22247362d0,
     & 2.22502947d0, 2.22761345d0, 2.23019528d0, 2.23274446d0,
     & 2.23568606d0, 2.23853755d0, 2.24135327d0, 2.24399829d0,
     & 2.24652863d0, 2.24907851d0, 2.25197959d0, 2.25486016d0,
     & 2.25775146d0, 2.26065159d0, 2.26359010d0, 2.26614118d0,
     & 2.26891398d0, 2.27172351d0, 2.27427387d0, 2.27694535d0,
     & 2.27965713d0, 2.28232455d0, 2.28501773d0, 2.28770208d0,
     & 2.29034877d0, 2.29298949d0, 2.29559422d0, 2.29810023d0,
     & 2.30060291d0, 2.30329084d0, 2.30597520d0, 2.30868578d0,
     & 2.31142783d0, 2.31416392d0, 2.31686735d0, 2.31972122d0,
     & 2.32223797d0, 2.32478356d0, 2.32790804d0, 2.33105040d0,
     & 2.33403158d0, 2.33689594d0, 2.33961892d0, 2.34231877d0,
     & 2.34509516d0, 2.34787869d0, 2.35054541d0, 2.35355687d0,
     & 2.35654306d0, 2.35895419d0, 2.36131954d0, 2.36399865d0,
     & 2.36680198d0, 2.36966133d0, 2.37266827d0, 2.37560225d0,
     & 2.37868929d0, 2.38133574d0, 2.38397837d0, 2.38664961d0,
     & 2.38928723d0, 2.39195395d0, 2.39474821d0, 2.39750552d0,
     & 2.40026045d0, 2.40270185d0, 2.40514159d0, 2.40742230d0,
     & 2.41014004d0, 2.41285586d0, 2.41553974d0, 2.41851306d0,
     & 2.42151046d0, 2.42444444d0, 2.42742014d0, 2.43053126d0,
     & 2.43332005d0, 2.43608642d0, 2.43889260d0, 2.44179988d0,
     & 2.44471383d0, 2.44763231d0, 2.45029593d0, 2.45281243d0,
     & 2.45521045d0, 2.45750308d0, 2.45963192d0, 2.46227598d0,
     & 2.46494508d0, 2.46779370d0, 2.47051191d0, 2.47288108d0,
     & 2.47527504d0, 2.47766876d0, 2.48015475d0, 2.48257470d0,
     & 2.48524380d0, 2.48794174d0, 2.49060297d0, 2.49325871d0,
     & 2.49557543d0, 2.49792171d0, 2.50057721d0, 2.50323415d0,
     & 2.50588608d0, 2.50856423d0, 2.51121044d0, 2.51401615d0,
     & 2.51680708d0, 2.51977849d0, 2.52273059d0, 2.52619863d0,
     & 2.52982807d0, 2.53454781d0, 2.53927040d0, 2.54396486d0,
     & 2.54720259d0, 2.55006623d0, 2.55261970d0, 2.55528736d0,
     & 2.55780816d0, 2.56032300d0, 2.56262827d0, 2.56474304d0,
     & 2.56580377d0, 2.56683183d0, 2.56770325d0, 2.56994319d0,
     & 2.57255864d0, 2.57517052d0, 2.57790112d0, 2.58062887d0,
     & 2.58304501d0, 2.58527470d0, 2.58753443d0, 2.59003592d0
     &/
      DATA (Imax ( 7,I), I= 1001, 2100) /
     & 2.59253621d0, 2.59509826d0, 2.59787536d0, 2.60065079d0,
     & 2.60342455d0, 2.60603762d0, 2.61026287d0, 2.61483359d0,
     & 2.61944008d0, 2.62405062d0, 2.63705039d0, 2.64017606d0,
     & 2.64356089d0, 2.64689207d0, 2.65006781d0, 2.65382266d0,
     & 2.65818477d0, 2.66090584d0, 2.66362357d0, 2.66623187d0,
     & 2.66773987d0, 2.66061735d0, 2.66340184d0, 2.66548777d0,
     & 2.66747546d0, 2.66965222d0, 2.67137718d0, 2.67240810d0,
     & 2.67346883d0, 2.67452812d0, 2.67569232d0, 2.67792177d0,
     & 2.68029690d0, 2.68245721d0, 2.68514943d0, 2.68802190d0,
     & 2.69064808d0, 2.69324017d0, 2.69586182d0, 2.69845080d0,
     & 2.70145011d0, 2.70449281d0, 2.70759034d0, 2.72874022d0,
     & 2.73191047d0, 2.73555660d0, 2.73944521d0, 2.74371076d0,
     & 2.74807429d0, 2.75266600d0, 2.75713539d0, 2.76024890d0,
     & 2.76303267d0, 2.76579738d0, 2.75036311d0, 2.75312638d0,
     & 2.75545263d0, 2.75738907d0, 2.75916433d0, 2.76103473d0,
     & 2.76258183d0, 2.76428914d0, 2.76675558d0, 2.76903653d0,
     & 2.77131462d0, 2.77355909d0, 2.77580094d0, 2.77813077d0,
     & 2.78045869d0, 2.78319335d0, 2.78564382d0, 2.78819084d0,
     & 2.79063940d0, 2.79308844d0, 2.79588556d0, 2.79868102d0,
     & 2.80147529d0, 2.80426836d0, 2.80696607d0, 2.80968690d0,
     & 2.81417942d0, 2.81842089d0, 2.82266569d0, 2.82675266d0,
     & 2.82957172d0, 2.83252525d0, 2.83548737d0, 2.83845544d0,
     & 2.84200978d0, 2.84540868d0, 2.85374165d0, 2.85491085d0,
     & 2.87429404d0, 2.87549448d0, 2.89470530d0, 2.91518569d0,
     & 2.91986084d0, 2.92452884d0, 2.94488859d0, 2.96467209d0,
     & 2.96890759d0, 2.96806264d0, 2.97226572d0, 2.95663929d0,
     & 2.98615170d0, 2.97633457d0, 2.96670532d0, 2.97287488d0,
     & 2.98473692d0, 2.98093891d0, 2.97713733d0, 2.98901439d0,
     & 2.99468899d0, 2.99539351d0, 2.99796414d0, 2.97357535d0,
     & 2.97075629d0, 2.96777797d0, 2.96484447d0, 2.95623517d0,
     & 2.94765234d0, 2.93908525d0, 2.93056011d0, 2.92834020d0,
     & 2.94255424d0, 2.95678020d0, 2.97101760d0, 2.99130201d0,
     & 3.01181841d0, 3.03255868d0, 3.04650307d0, 3.04997587d0,
     & 3.05342913d0, 3.07373691d0, 3.08188629d0, 3.07854414d0,
     & 3.07519603d0, 3.07155061d0, 3.06183267d0, 3.05204892d0,
     & 3.03868294d0, 3.03181481d0, 3.03538704d0, 3.03870368d0,
     & 3.02406335d0, 3.02160668d0, 3.03629208d0, 3.05172372d0,
     & 3.05038023d0, 3.04921389d0, 3.04791665d0, 3.04980969d0,
     & 3.05186319d0, 3.05379343d0, 3.05585456d0, 3.05887938d0,
     & 3.06189179d0, 3.04777813d0, 3.03356600d0, 3.04560995d0,
     & 3.04962492d0, 3.05228233d0, 3.05625892d0, 3.06906843d0,
     & 3.08201957d0, 3.09511018d0, 3.10792613d0, 3.12076831d0,
     & 3.13360524d0, 3.14002776d0, 3.13274646d0, 3.13334703d0,
     & 3.13542891d0, 3.13631439d0, 3.12845659d0, 3.12658286d0,
     & 3.12389636d0, 3.12314439d0, 3.12498093d0, 3.21288919d0,
     & 3.22852039d0, 3.21765161d0, 3.21317983d0, 3.30989718d0,
     & 3.32928276d0, 3.29534173d0, 3.32697749d0, 3.35904765d0,
     & 3.38662982d0, 3.41508150d0, 3.43861914d0, 3.47323513d0,
     & 3.50289512d0, 3.53055859d0, 3.55423951d0, 3.57368326d0,
     & 3.60242438d0, 3.63080311d0, 3.66045022d0, 3.67593074d0,
     & 3.70528865d0, 3.72998047d0, 3.75706744d0, 3.77797031d0,
     & 3.80740976d0, 3.83606625d0, 3.86029577d0, 3.88826823d0,
     & 3.91852546d0, 3.94506359d0, 3.97270823d0, 4.00202084d0,
     & 4.03042364d0, 4.05937099d0, 4.08877611d0, 4.12140512d0,
     & 4.15386724d0, 4.18314981d0, 4.21144009d0, 4.23827553d0,
     & 4.26677132d0, 4.29587746d0, 4.32325745d0, 4.35282421d0,
     & 4.38107967d0, 4.40893650d0, 4.43989897d0, 4.47244453d0,
     & 4.50515366d0, 4.53271580d0, 4.56039047d0, 4.58977365d0,
     & 4.61796379d0, 4.64938354d0, 4.67847395d0, 4.70823193d0,
     & 4.73768091d0, 4.76610231d0, 4.79914904d0, 4.83297873d0,
     & 4.86161804d0, 4.88802147d0, 4.91601706d0, 4.94456005d0,
     & 4.97245836d0, 4.99960852d0, 5.02991104d0, 5.06057644d0,
     & 5.09555817d0, 5.12417889d0, 5.15422058d0, 5.18292618d0,
     & 5.20756769d0, 5.23262215d0, 5.25946760d0, 5.29154158d0,
     & 5.31771183d0, 5.34409952d0, 5.37346029d0, 5.39905977d0,
     & 5.42754793d0, 5.45626688d0, 5.48387909d0, 5.51009560d0,
     & 5.54650974d0, 5.57612801d0, 5.60012102d0, 5.62728977d0,
     & 5.66271305d0, 5.68983555d0, 5.72574472d0, 5.75658369d0,
     & 5.78885651d0, 5.81238317d0, 5.83684492d0, 5.86352873d0,
     & 5.89212132d0, 5.92082119d0, 5.94979620d0, 5.97970819d0,
     & 6.00430107d0, 6.02971840d0, 6.05932999d0, 6.08695507d0,
     & 6.11080170d0, 6.13922071d0, 6.16821957d0, 6.19821167d0,
     & 6.22674084d0, 6.25517559d0, 6.28072166d0, 6.30966377d0,
     & 6.33947706d0, 6.37029457d0, 6.40081596d0, 6.43602180d0,
     & 6.46574593d0, 6.49431849d0, 6.52195215d0, 6.55176783d0,
     & 6.58205128d0, 6.61053324d0, 6.64025640d0, 6.66660166d0,
     & 6.69700050d0, 6.72550583d0, 6.75152826d0, 6.77025652d0,
     & 6.80163860d0, 6.83186722d0, 6.85997581d0, 6.89004517d0,
     & 6.91531754d0, 6.94127798d0, 6.97287941d0, 7.00169659d0,
     & 7.03128433d0, 7.06126690d0, 7.08927155d0, 7.11850977d0,
     & 7.14362144d0, 7.17477703d0, 7.20695400d0, 7.23853970d0,
     & 7.26056433d0, 7.28677464d0, 7.31156111d0, 7.33757401d0,
     & 7.35956240d0, 7.38919210d0, 7.41896963d0, 7.44848490d0,
     & 7.47593164d0, 7.49513149d0, 7.51991129d0, 7.54759741d0,
     & 7.58153391d0, 7.61006832d0, 7.64053631d0, 7.66463232d0,
     & 7.69562912d0, 7.72729874d0, 7.75613785d0, 7.78355169d0,
     & 7.80777931d0, 7.83880901d0, 7.87087154d0, 7.89903069d0,
     & 7.92919397d0, 7.95933342d0, 7.98986006d0, 8.01071262d0,
     & 8.03785610d0, 8.06705475d0, 8.09726429d0, 8.12368393d0,
     & 8.15090084d0, 8.17792702d0, 8.20707607d0, 8.23684883d0,
     & 8.26719761d0, 8.29519844d0, 8.32447052d0, 8.35369492d0,
     & 8.37934971d0, 8.40635681d0, 8.43220520d0, 8.45676804d0,
     & 8.48291588d0, 8.51132965d0, 8.54139614d0, 8.57063007d0,
     & 8.59632874d0, 8.62679958d0, 8.65133095d0, 8.67827702d0,
     & 8.70427227d0, 8.73065662d0, 8.75689888d0, 8.78442574d0,
     & 8.81157207d0, 8.83938885d0, 8.86689663d0, 8.89325905d0,
     & 8.91898823d0, 8.94641209d0, 8.97401142d0, 9.00022221d0,
     & 9.02775097d0, 9.05605793d0, 9.08461380d0, 9.11371994d0,
     & 9.14092636d0, 9.16948700d0, 9.19861317d0, 9.22632694d0,
     & 9.25414181d0, 9.28233051d0, 9.31052017d0, 9.33833408d0,
     & 9.36849594d0, 9.39598942d0, 9.42562580d0, 9.45482731d0,
     & 9.48432159d0, 9.51170063d0, 9.53786755d0, 9.56572819d0,
     & 9.59232044d0, 9.61963749d0, 9.64574528d0, 9.67270660d0,
     & 9.70335388d0, 9.73283195d0, 9.76330280d0, 9.79052448d0,
     & 9.81639481d0, 9.84205723d0, 9.86984348d0, 9.89618111d0,
     & 9.92132568d0, 9.94932270d0, 9.97890091d0,10.00601578d0,
     &10.03194237d0,10.06024933d0,10.08940792d0,10.11710453d0,
     &10.14258003d0,10.16765690d0,10.19460678d0,10.22270775d0,
     &10.24881363d0,10.27730179d0,10.30423450d0,10.33018303d0,
     &10.36076450d0,10.38658905d0,10.41315842d0,10.43796349d0,
     &10.46359062d0,10.48867130d0,10.51608086d0,10.54384613d0,
     &10.57563400d0,10.60369682d0,10.63099957d0,10.66002560d0,
     &10.69184685d0,10.72093105d0,10.74618053d0,10.77071762d0,
     &10.79378223d0,10.82085800d0,10.84978676d0,10.87693882d0,
     &10.90608597d0,10.93412209d0,10.96109581d0,10.98910713d0,
     &11.01914406d0,11.04764271d0,11.07363605d0,11.10361099d0,
     &11.13309193d0,11.16084003d0,11.18831635d0,11.21661854d0,
     &11.24497700d0,11.27192974d0,11.29961967d0,11.32875061d0,
     &11.35623074d0,11.38481331d0,11.40905285d0,11.43684101d0,
     &11.46367168d0,11.49303150d0,11.52087879d0,11.55047798d0,
     &11.57805538d0,11.60670090d0,11.63512516d0,11.66561985d0,
     &11.69266987d0,11.71872711d0,11.74643803d0,11.77450180d0,
     &11.79993153d0,11.82505989d0,11.85118294d0,11.87926102d0,
     &11.90178490d0,11.93103600d0,11.95991707d0,11.99126339d0,
     &12.01456451d0,12.03900909d0,12.06810379d0,12.09543991d0,
     &12.12322712d0,12.15127468d0,12.17868423d0,12.20747185d0,
     &12.23685932d0,12.26301575d0,12.29040241d0,12.31868935d0,
     &12.34953785d0,12.38077641d0,12.40910912d0,12.43499756d0,
     &12.45855522d0,12.48307037d0,12.51307678d0,12.54241180d0,
     &12.57007980d0,12.59569836d0,12.62318897d0,12.65770435d0,
     &12.68220711d0,12.70936108d0,12.73453808d0,12.75907516d0,
     &12.79137421d0,12.81635094d0,12.84035873d0,12.86868000d0,
     &12.89821053d0,12.92770195d0,12.95685101d0,12.98543262d0,
     &13.01446056d0,13.03923512d0,13.06556034d0,13.09442997d0,
     &13.12495422d0,13.15278721d0,13.18258095d0,13.21073818d0,
     &13.23954964d0,13.27148628d0,13.29966259d0,13.32885456d0,
     &13.35954189d0,13.38776684d0,13.41511917d0,13.44256687d0,
     &13.47212887d0,13.50031853d0,13.53178215d0,13.56197739d0,
     &13.59211254d0,13.62224579d0,13.65101337d0,13.67908192d0,
     &13.70958805d0,13.73976898d0,13.76976681d0,13.79689789d0,
     &13.81816673d0,13.84379768d0,13.87029839d0,13.89433479d0,
     &13.92200756d0,13.94820690d0,13.97617054d0,14.00391293d0,
     &14.03489113d0,14.06590462d0,14.09409428d0,14.11828899d0,
     &14.14224911d0,14.16944408d0,14.19815540d0,14.22700405d0,
     &14.25941372d0,14.28943062d0,14.31705093d0,14.34471703d0,
     &14.37182617d0,14.40148067d0,14.42781830d0,14.45557213d0,
     &14.48540974d0,14.51519489d0,14.54466343d0,14.56949520d0,
     &14.59535789d0,14.62352848d0,14.65550900d0,14.68902969d0,
     &14.71364021d0,14.74001980d0,14.76586246d0,14.79178715d0,
     &14.82128429d0,14.84868145d0,14.87430191d0,14.90339661d0,
     &14.93210316d0,14.96679497d0,14.99361515d0,15.02280521d0,
     &15.05176544d0,15.07910061d0,15.10781479d0,15.14049721d0,
     &15.17272282d0,15.20230865d0,15.23342609d0,15.26013947d0,
     &15.28757858d0,15.31525421d0,15.34097767d0,15.36605740d0,
     &15.39434814d0,15.42621803d0,15.45896721d0,15.49017620d0,
     &15.51584625d0,15.54166794d0,15.57441616d0,15.60531425d0,
     &15.62996864d0,15.66089153d0,15.68895054d0,15.71290398d0,
     &15.74092388d0,15.76561832d0,15.79687309d0,15.82847500d0,
     &15.85239792d0,15.88364601d0,15.90954685d0,15.94100666d0,
     &15.96861839d0,15.99938965d0,16.03248024d0,16.06685829d0,
     &16.09921455d0,16.12621880d0,16.15516663d0,16.18358803d0,
     &16.21351624d0,16.24598885d0,16.26813698d0,16.29855537d0,
     &16.32610703d0,16.35827446d0,16.38788223d0,16.41395950d0,
     &16.44092560d0,16.46982956d0,16.49814415d0,16.52951431d0,
     &16.55653763d0,16.58424187d0,16.61054611d0,16.64330101d0,
     &16.67376137d0,16.70475769d0,16.73339653d0,16.76248169d0,
     &16.78941536d0,16.81625748d0,16.84368134d0,16.87510109d0,
     &16.90380287d0,16.93548584d0,16.96267128d0,16.99310684d0,
     &17.02488899d0,17.05817795d0,17.08800507d0,17.12197685d0,
     &17.15262222d0,17.17812157d0,17.21182632d0,17.24308014d0,
     &17.27646446d0,17.30748940d0,17.33635902d0,17.36171913d0,
     &17.38915825d0,17.41638184d0,17.44354630d0,17.47753334d0,
     &17.51171684d0,17.53934669d0,17.56875038d0,17.59935760d0,
     &17.62942505d0,17.66175270d0,17.69028473d0,17.71876335d0,
     &17.74902153d0,17.77547455d0,17.80424309d0,17.83484840d0,
     &17.86914062d0,17.90310287d0,17.93793106d0,17.96965790d0,
     &17.99368668d0,18.02379608d0,18.05119705d0,18.08056068d0,
     &18.11143684d0,18.14259911d0,18.17745399d0,18.20924187d0,
     &18.23817253d0,18.26908684d0,18.29657936d0,18.32745171d0,
     &18.35885429d0,18.38963127d0,18.42270279d0,18.45187569d0,
     &18.48650360d0,18.52083015d0,18.55352974d0,18.58514214d0,
     &18.61272049d0,18.64223480d0,18.66977501d0,18.69889450d0,
     &18.72893524d0,18.76232147d0,18.79309845d0,18.82106209d0,
     &18.84595490d0,18.87938309d0,18.90998840d0,18.93869972d0,
     &18.97467804d0,19.00995255d0,19.03896523d0,19.06606674d0,
     &19.09750366d0,19.13052368d0,19.16326904d0,19.19584084d0,
     &19.22980309d0,19.26018333d0,19.28974724d0,19.31847000d0,
     &19.35000610d0,19.38281441d0,19.41484833d0,19.44837570d0,
     &19.47666931d0,19.50576019d0,19.53562737d0,19.56543922d0,
     &19.59554100d0,19.61980247d0,19.64670372d0,19.67276955d0,
     &19.70402527d0,19.73549080d0,19.76057434d0,19.79233742d0,
     &19.82296181d0,19.85484314d0,19.88771629d0,19.91701317d0,
     &19.94888687d0,19.98328400d0,20.01042175d0,20.04235077d0,
     &20.07158470d0,20.10407066d0,20.13263130d0,20.17181396d0,
     &20.19857216d0,20.22743988d0,20.63019753d0,20.63027382d0,
     &20.63035202d0,20.63043022d0,20.63050842d0,20.63058853d0,
     &20.63066673d0,20.63074684d0,20.63082314d0,20.63090515d0,
     &20.63098145d0,20.63998795d0,20.67313957d0,20.69877434d0,
     &20.72443199d0,20.75881195d0,20.80196381d0,20.83169746d0,
     &20.85808945d0,20.89344597d0,20.92740822d0,20.96161461d0,
     &20.99518394d0,21.02816200d0,21.05877876d0,21.08693886d0,
     &21.11104012d0,21.14381027d0,21.17689705d0,21.20552254d0,
     &21.24918556d0,21.28663254d0,21.31390190d0,21.34826851d0,
     &21.38748360d0,21.41678238d0,21.44559860d0,21.48094749d0,
     &21.51226425d0,21.55255890d0,21.59175682d0,21.63039780d0,
     &21.66687965d0,21.69773674d0,21.73020744d0,21.76902390d0,
     &21.80657196d0,21.83974457d0,21.87370110d0,21.91050529d0,
     &21.95366669d0,21.98613739d0,22.02066803d0,22.05762672d0,
     &22.09774780d0,22.13825798d0,22.17570305d0,22.21390343d0,
     &22.25083160d0,22.29112434d0,22.32632065d0,22.35863686d0,
     &22.38756943d0,22.41294670d0,22.45077324d0,22.49223518d0,
     &22.52774620d0,22.56605721d0,22.60587502d0,22.64631081d0,
     &22.67400169d0,22.70545578d0,22.73722267d0,22.77290726d0,
     &22.80381584d0,22.84150124d0,22.87917519d0,22.91179276d0,
     &22.93999672d0,22.97654533d0,23.01243019d0,23.05135727d0,
     &23.09057999d0,23.12685966d0,23.16647148d0,23.20567703d0,
     &23.25149155d0,23.29008102d0,23.33113480d0,23.37068748d0,
     &23.40444946d0,23.43715096d0,23.46858025d0,23.50529861d0,
     &23.54077339d0,23.58349800d0,23.61735344d0,23.65014648d0,
     &23.69397736d0,23.73649025d0,23.76166344d0,23.79513741d0,
     &23.83298302d0,23.86667633d0,23.91292381d0,23.94668961d0,
     &23.98327065d0,24.01628494d0,24.05532455d0,24.09589767d0,
     &24.13275909d0,24.17424202d0,24.20707512d0,24.24233818d0,
     &24.18152618d0,23.85192871d0,23.37077332d0,22.75809097d0,
     &22.06312752d0,21.32960320d0,20.52724838d0,19.70762253d0,
     &18.84060287d0,17.83120537d0,16.73661423d0,16.73661423d0,
     &16.73308563d0,14.66212463d0,14.22885990d0,13.84140968d0,
     &13.50202370d0,13.19648361d0,12.91722393d0,12.65300751d0,
     &12.41345310d0,12.19269085d0,11.98318863d0,11.78794384d0,
     &11.60083199d0,11.41985512d0,11.25197315d0,11.09115887d0,
     &10.93360710d0,10.78829575d0,14.66306782d0,15.18389988d0,
     &15.18389988d0,15.18389988d0,10.12666321d0,14.66306782d0,
     &15.34496498d0,15.18389988d0,15.34496498d0,14.22962475d0,
     & 9.46738148d0, 9.36796665d0, 9.27242851d0, 9.18048859d0,
     & 9.08881092d0, 9.00000477d0, 8.91375160d0, 8.82961464d0,
     & 8.74631500d0, 8.66523266d0, 8.58746529d0,15.18389988d0,
     &15.50602913d0,16.73396683d0,16.73484993d0,16.73308563d0,
     &15.50602913d0,15.50602913d0,16.73308563d0,16.73749542d0,
     &16.73484993d0,16.73396683d0,16.73308563d0,16.73220253d0,
     &15.18389988d0,15.34496498d0,15.18389988d0,15.50602913d0,
     &15.50602913d0,15.50602913d0, 7.31446838d0,14.22962475d0,
     &15.34496498d0,15.50602913d0,15.34496498d0,15.34496498d0,
     &14.66306782d0,15.34496498d0,15.34496498d0,16.73220253d0,
     &16.73220253d0,16.73308563d0,15.18389988d0,14.66306782d0,
     & 6.65895748d0,14.66306782d0,15.18389988d0,15.34496498d0,
     &15.34496498d0,14.66306782d0,14.66306782d0, 6.53467512d0,
     & 6.33767462d0,14.22962475d0, 6.26312971d0, 6.22665453d0,
     & 6.19071007d0, 6.15526772d0, 6.12031651d0, 6.08586454d0,
     & 6.05188322d0, 6.01835966d0,14.22962475d0,15.18389988d0,
     &15.34496498d0,16.73220253d0,15.50602913d0,16.73220253d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0,
     &16.73396683d0,16.73396683d0,16.73396683d0,16.73396683d0
     &/
c Definition of open field lines as Lupper=f(Iupper) for doy=181
      DATA (Lupper ( 7,I), I= 1, 1001) /
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0, 9.40d0,
     & 9.40d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0,
     & 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.41d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0,
     & 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.42d0, 9.43d0, 9.44d0, 9.44d0,
     & 9.45d0, 9.46d0, 9.46d0, 9.47d0, 9.48d0, 9.48d0, 9.49d0, 9.50d0,
     & 9.50d0, 9.51d0, 9.52d0, 9.52d0, 9.53d0, 9.54d0, 9.54d0, 9.55d0,
     & 9.56d0, 9.56d0, 9.57d0, 9.57d0, 9.58d0, 9.59d0, 9.59d0, 9.61d0,
     & 9.62d0, 9.64d0, 9.66d0, 9.68d0, 9.70d0, 9.72d0, 9.73d0, 9.75d0,
     & 9.77d0, 9.79d0, 9.80d0, 9.82d0, 9.84d0, 9.85d0, 9.87d0, 9.89d0,
     & 9.91d0, 9.92d0, 9.94d0, 9.96d0, 9.98d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0, 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0,
     & 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0,
     &10.00d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0
     &/
      DATA (Iupper ( 7,I), I= 1, 1001) /
     & 0.00010000d0, 0.00010127d0, 0.00010255d0, 0.00010386d0,
     & 0.00010517d0, 0.00010651d0, 0.00010786d0, 0.00010923d0,
     & 0.00011062d0, 0.00011202d0, 0.00011344d0, 0.00011488d0,
     & 0.00011634d0, 0.00011782d0, 0.00011931d0, 0.00012083d0,
     & 0.00012236d0, 0.00012391d0, 0.00012548d0, 0.00012708d0,
     & 0.00012869d0, 0.00013032d0, 0.00013198d0, 0.00013365d0,
     & 0.00013535d0, 0.00013707d0, 0.00013881d0, 0.00014057d0,
     & 0.00014235d0, 0.00014416d0, 0.00014599d0, 0.00014784d0,
     & 0.00014972d0, 0.00015162d0, 0.00015354d0, 0.00015549d0,
     & 0.00015746d0, 0.00015946d0, 0.00016148d0, 0.00016353d0,
     & 0.00016561d0, 0.00016771d0, 0.00016984d0, 0.00017200d0,
     & 0.00017418d0, 0.00017639d0, 0.00017863d0, 0.00018089d0,
     & 0.00018319d0, 0.00018551d0, 0.00018787d0, 0.00019025d0,
     & 0.00019267d0, 0.00019511d0, 0.00019759d0, 0.00020010d0,
     & 0.00020264d0, 0.00020521d0, 0.00020781d0, 0.00021045d0,
     & 0.00021312d0, 0.00021583d0, 0.00021857d0, 0.00022134d0,
     & 0.00022415d0, 0.00022699d0, 0.00022987d0, 0.00023279d0,
     & 0.00023575d0, 0.00023874d0, 0.00024177d0, 0.00024484d0,
     & 0.00024794d0, 0.00025109d0, 0.00025428d0, 0.00025750d0,
     & 0.00026077d0, 0.00026408d0, 0.00026743d0, 0.00027083d0,
     & 0.00027426d0, 0.00027775d0, 0.00028127d0, 0.00028484d0,
     & 0.00028846d0, 0.00029212d0, 0.00029582d0, 0.00029958d0,
     & 0.00030338d0, 0.00030723d0, 0.00031113d0, 0.00031508d0,
     & 0.00031908d0, 0.00032313d0, 0.00032723d0, 0.00033138d0,
     & 0.00033559d0, 0.00033984d0, 0.00034416d0, 0.00034853d0,
     & 0.00035295d0, 0.00035743d0, 0.00036196d0, 0.00036656d0,
     & 0.00037121d0, 0.00037592d0, 0.00038069d0, 0.00038552d0,
     & 0.00039042d0, 0.00039537d0, 0.00040039d0, 0.00040547d0,
     & 0.00041062d0, 0.00041583d0, 0.00042111d0, 0.00042645d0,
     & 0.00043186d0, 0.00043734d0, 0.00044289d0, 0.00044852d0,
     & 0.00045421d0, 0.00045997d0, 0.00046581d0, 0.00047172d0,
     & 0.00047771d0, 0.00048377d0, 0.00048991d0, 0.00049613d0,
     & 0.00050243d0, 0.00050880d0, 0.00051526d0, 0.00052180d0,
     & 0.00052842d0, 0.00053513d0, 0.00054192d0, 0.00054880d0,
     & 0.00055576d0, 0.00056281d0, 0.00056996d0, 0.00057719d0,
     & 0.00058452d0, 0.00059194d0, 0.00059945d0, 0.00060706d0,
     & 0.00061476d0, 0.00062256d0, 0.00063046d0, 0.00063846d0,
     & 0.00064657d0, 0.00065477d0, 0.00066308d0, 0.00067150d0,
     & 0.00068002d0, 0.00068865d0, 0.00069739d0, 0.00070624d0,
     & 0.00071521d0, 0.00072428d0, 0.00073347d0, 0.00074278d0,
     & 0.00075221d0, 0.00076176d0, 0.00077142d0, 0.00078122d0,
     & 0.00079113d0, 0.00080117d0, 0.00081134d0, 0.00082164d0,
     & 0.00083206d0, 0.00084262d0, 0.00085332d0, 0.00086415d0,
     & 0.00087511d0, 0.00088622d0, 0.00089747d0, 0.00090886d0,
     & 0.00092039d0, 0.00093207d0, 0.00094390d0, 0.00095588d0,
     & 0.00096801d0, 0.00098030d0, 0.00099274d0, 0.00100534d0,
     & 0.00101810d0, 0.00103102d0, 0.00104411d0, 0.00105736d0,
     & 0.00107078d0, 0.00108437d0, 0.00109813d0, 0.00111206d0,
     & 0.00112618d0, 0.00114047d0, 0.00115495d0, 0.00116960d0,
     & 0.00118445d0, 0.00119948d0, 0.00121470d0, 0.00123012d0,
     & 0.00124573d0, 0.00126154d0, 0.00127755d0, 0.00129377d0,
     & 0.00131019d0, 0.00132681d0, 0.00134365d0, 0.00136071d0,
     & 0.00137797d0, 0.00139546d0, 0.00141317d0, 0.00143111d0,
     & 0.00144927d0, 0.00146766d0, 0.00148629d0, 0.00150515d0,
     & 0.00152426d0, 0.00154360d0, 0.00156319d0, 0.00158303d0,
     & 0.00160312d0, 0.00162347d0, 0.00164407d0, 0.00166494d0,
     & 0.00168607d0, 0.00170747d0, 0.00172914d0, 0.00175108d0,
     & 0.00177331d0, 0.00179581d0, 0.00181860d0, 0.00184168d0,
     & 0.00186506d0, 0.00188873d0, 0.00191270d0, 0.00193697d0,
     & 0.00196156d0, 0.00198645d0, 0.00201166d0, 0.00203719d0,
     & 0.00206305d0, 0.00208923d0, 0.00211575d0, 0.00214260d0,
     & 0.00216979d0, 0.00219733d0, 0.00222521d0, 0.00225346d0,
     & 0.00228206d0, 0.00231102d0, 0.00234035d0, 0.00237005d0,
     & 0.00240013d0, 0.00243059d0, 0.00246144d0, 0.00249268d0,
     & 0.00252431d0, 0.00255635d0, 0.00258879d0, 0.00262165d0,
     & 0.00265492d0, 0.00268862d0, 0.00272274d0, 0.00275729d0,
     & 0.00279229d0, 0.00282773d0, 0.00286361d0, 0.00289996d0,
     & 0.00293676d0, 0.00297403d0, 0.00301178d0, 0.00305000d0,
     & 0.00308871d0, 0.00312791d0, 0.00316761d0, 0.00320781d0,
     & 0.00324852d0, 0.00328975d0, 0.00333150d0, 0.00337378d0,
     & 0.00341660d0, 0.00345996d0, 0.00350387d0, 0.00354834d0,
     & 0.00359337d0, 0.00363898d0, 0.00368516d0, 0.00373193d0,
     & 0.00377930d0, 0.00382726d0, 0.00387583d0, 0.00392502d0,
     & 0.00397484d0, 0.00402528d0, 0.00407637d0, 0.00412811d0,
     & 0.00418050d0, 0.00423355d0, 0.00428728d0, 0.00434169d0,
     & 0.00439680d0, 0.00445260d0, 0.00450911d0, 0.00456633d0,
     & 0.00462429d0, 0.00468298d0, 0.00474241d0, 0.00480260d0,
     & 0.00486355d0, 0.00492528d0, 0.00498778d0, 0.00505109d0,
     & 0.00511519d0, 0.00518011d0, 0.00524585d0, 0.00531243d0,
     & 0.00537985d0, 0.00544813d0, 0.00551727d0, 0.00558730d0,
     & 0.00565821d0, 0.00573002d0, 0.00580274d0, 0.00587639d0,
     & 0.00595096d0, 0.00602649d0, 0.00610298d0, 0.00618043d0,
     & 0.00625887d0, 0.00633830d0, 0.00641874d0, 0.00650021d0,
     & 0.00658270d0, 0.00666625d0, 0.00675085d0, 0.00683653d0,
     & 0.00692329d0, 0.00701116d0, 0.00710014d0, 0.00719025d0,
     & 0.00728151d0, 0.00737392d0, 0.00746751d0, 0.00756228d0,
     & 0.00765826d0, 0.00775545d0, 0.00785387d0, 0.00795355d0,
     & 0.00805449d0, 0.00815672d0, 0.00826024d0, 0.00836507d0,
     & 0.00847124d0, 0.00857875d0, 0.00868762d0, 0.00879788d0,
     & 0.00890954d0, 0.00902261d0, 0.00913712d0, 0.00925308d0,
     & 0.00937052d0, 0.00948945d0, 0.00960988d0, 0.00973184d0,
     & 0.00985535d0, 0.00998043d0, 0.01010710d0, 0.01023537d0,
     & 0.01036527d0, 0.01049682d0, 0.01063004d0, 0.01076495d0,
     & 0.01090157d0, 0.01103993d0, 0.01118004d0, 0.01132193d0,
     & 0.01146563d0, 0.01161114d0, 0.01175850d0, 0.01190773d0,
     & 0.01205886d0, 0.01221190d0, 0.01236688d0, 0.01252384d0,
     & 0.01268278d0, 0.01284374d0, 0.01300676d0, 0.01317183d0,
     & 0.01333899d0, 0.01350829d0, 0.01367973d0, 0.01385334d0,
     & 0.01402915d0, 0.01420721d0, 0.01438751d0, 0.01457011d0,
     & 0.01475503d0, 0.01494229d0, 0.01513193d0, 0.01532398d0,
     & 0.01551846d0, 0.01571541d0, 0.01591486d0, 0.01611684d0,
     & 0.01632139d0, 0.01652853d0, 0.01673830d0, 0.01695073d0,
     & 0.01716586d0, 0.01738372d0, 0.01760434d0, 0.01782776d0,
     & 0.01805403d0, 0.01828315d0, 0.01851519d0, 0.01875018d0,
     & 0.01898814d0, 0.01922913d0, 0.01947318d0, 0.01972032d0,
     & 0.01997059d0, 0.02022405d0, 0.02048072d0, 0.02074065d0,
     & 0.02100387d0, 0.02127045d0, 0.02154040d0, 0.02181377d0,
     & 0.02209063d0, 0.02237098d0, 0.02265490d0, 0.02294243d0,
     & 0.02323360d0, 0.02352846d0, 0.02382708d0, 0.02412947d0,
     & 0.02443570d0, 0.02474584d0, 0.02505989d0, 0.02537793d0,
     & 0.02570002d0, 0.02602619d0, 0.02635649d0, 0.02669099d0,
     & 0.02702975d0, 0.02737279d0, 0.02772018d0, 0.02807200d0,
     & 0.02842827d0, 0.02878906d0, 0.02915444d0, 0.02952445d0,
     & 0.02989915d0, 0.03027862d0, 0.03066289d0, 0.03105204d0,
     & 0.03144613d0, 0.03184524d0, 0.03224939d0, 0.03265868d0,
     & 0.03307318d0, 0.03349292d0, 0.03391798d0, 0.03434846d0,
     & 0.03478439d0, 0.03522584d0, 0.03567292d0, 0.03612565d0,
     & 0.03658413d0, 0.03704845d0, 0.03751864d0, 0.03799480d0,
     & 0.03847702d0, 0.03896534d0, 0.03945986d0, 0.03996065d0,
     & 0.04046782d0, 0.04098141d0, 0.04150151d0, 0.04202824d0,
     & 0.04256163d0, 0.04310180d0, 0.04364883d0, 0.04420279d0,
     & 0.04476377d0, 0.04533191d0, 0.04590723d0, 0.04648984d0,
     & 0.04707986d0, 0.04767738d0, 0.04828247d0, 0.04889523d0,
     & 0.04951580d0, 0.05014421d0, 0.05078061d0, 0.05142510d0,
     & 0.05207775d0, 0.05273868d0, 0.05340803d0, 0.05408584d0,
     & 0.05477226d0, 0.05546741d0, 0.05617137d0, 0.05688425d0,
     & 0.05760621d0, 0.05833730d0, 0.05907768d0, 0.05982745d0,
     & 0.06058676d0, 0.06135568d0, 0.06213436d0, 0.06292295d0,
     & 0.06372152d0, 0.06453023d0, 0.06534923d0, 0.06617859d0,
     & 0.06701849d0, 0.06786907d0, 0.06873041d0, 0.06960268d0,
     & 0.07048602d0, 0.07138062d0, 0.07228653d0, 0.07320394d0,
     & 0.07413302d0, 0.07507385d0, 0.07602664d0, 0.07699155d0,
     & 0.07796867d0, 0.07895819d0, 0.07996030d0, 0.08097509d0,
     & 0.08200277d0, 0.08304353d0, 0.08409746d0, 0.08516476d0,
     & 0.08624565d0, 0.08734021d0, 0.08844867d0, 0.08957119d0,
     & 0.09070800d0, 0.09185920d0, 0.09302501d0, 0.09420566d0,
     & 0.09540125d0, 0.09661201d0, 0.09783818d0, 0.09907987d0,
     & 0.10033731d0, 0.10161077d0, 0.10290034d0, 0.10420627d0,
     & 0.10552878d0, 0.10686813d0, 0.10822441d0, 0.10959791d0,
     & 0.11098890d0, 0.11239749d0, 0.11382396d0, 0.11526857d0,
     & 0.11673148d0, 0.11821295d0, 0.11971328d0, 0.12123259d0,
     & 0.12277117d0, 0.12432936d0, 0.12590724d0, 0.12750517d0,
     & 0.12912343d0, 0.13076216d0, 0.13242172d0, 0.13410230d0,
     & 0.13580430d0, 0.13752782d0, 0.13927321d0, 0.14104085d0,
     & 0.14283082d0, 0.14464353d0, 0.14647931d0, 0.14833830d0,
     & 0.15022090d0, 0.15212746d0, 0.15405814d0, 0.15601335d0,
     & 0.15799335d0, 0.15999855d0, 0.16202913d0, 0.16408549d0,
     & 0.16616802d0, 0.16827691d0, 0.17041254d0, 0.17257537d0,
     & 0.17476557d0, 0.17698357d0, 0.17922980d0, 0.18150444d0,
     & 0.18380795d0, 0.18614081d0, 0.18850316d0, 0.19089550d0,
     & 0.19331829d0, 0.19577175d0, 0.19825633d0, 0.20077245d0,
     & 0.20332061d0, 0.20590100d0, 0.20851412d0, 0.21116054d0,
     & 0.21384043d0, 0.21655434d0, 0.21930277d0, 0.22208601d0,
     & 0.22490457d0, 0.22775897d0, 0.23064953d0, 0.23357674d0,
     & 0.23654114d0, 0.23954326d0, 0.24258336d0, 0.24566205d0,
     & 0.24877992d0, 0.25193724d0, 0.25513467d0, 0.25837275d0,
     & 0.26165181d0, 0.26497251d0, 0.26833546d0, 0.27174097d0,
     & 0.27518973d0, 0.27868235d0, 0.28221917d0, 0.28580090d0,
     & 0.28942820d0, 0.29310140d0, 0.29682124d0, 0.30058825d0,
     & 0.30440310d0, 0.30826664d0, 0.31217894d0, 0.31614089d0,
     & 0.32015309d0, 0.32421625d0, 0.32833093d0, 0.33249786d0,
     & 0.33671802d0, 0.34099138d0, 0.34531897d0, 0.34970152d0,
     & 0.35413966d0, 0.35863414d0, 0.36318600d0, 0.36779529d0,
     & 0.37246308d0, 0.37719008d0, 0.38197711d0, 0.38682488d0,
     & 0.39173418d0, 0.39670613d0, 0.40174085d0, 0.40683943d0,
     & 0.41200271d0, 0.41723153d0, 0.42252675d0, 0.42788953d0,
     & 0.43332002d0, 0.43881938d0, 0.44438851d0, 0.45002836d0,
     & 0.45573980d0, 0.46152416d0, 0.46738148d0, 0.47331312d0,
     & 0.47932005d0, 0.48540321d0, 0.49156362d0, 0.49780214d0,
     & 0.50412035d0, 0.51051831d0, 0.51699740d0, 0.52355874d0,
     & 0.53020334d0, 0.53693229d0, 0.54374713d0, 0.55064797d0,
     & 0.55763638d0, 0.56471354d0, 0.57188040d0, 0.57913828d0,
     & 0.58648884d0, 0.59393209d0, 0.60146987d0, 0.60910326d0,
     & 0.61683351d0, 0.62466192d0, 0.63258964d0, 0.64061862d0,
     & 0.64874887d0, 0.65698230d0, 0.66532022d0, 0.67376393d0,
     & 0.68231487d0, 0.69097501d0, 0.69974434d0, 0.70862496d0,
     & 0.71761823d0, 0.72672570d0, 0.73594880d0, 0.74528891d0,
     & 0.75474828d0, 0.76432699d0, 0.77402723d0, 0.78385061d0,
     & 0.79379863d0, 0.80387294d0, 0.81407589d0, 0.82440752d0,
     & 0.83487028d0, 0.84546578d0, 0.85619581d0, 0.86706197d0,
     & 0.87806606d0, 0.88921070d0, 0.90049589d0, 0.91192430d0,
     & 0.92349786d0, 0.93521816d0, 0.94708717d0, 0.95910788d0,
     & 0.97128016d0, 0.98360693d0, 0.99609011d0, 1.00873172d0,
     & 1.02153373d0, 1.03449929d0, 1.04762840d0, 1.06092405d0,
     & 1.07438850d0, 1.08802390d0, 1.10183227d0, 1.11581588d0,
     & 1.12997806d0, 1.14431894d0, 1.15884173d0, 1.17354894d0,
     & 1.18844259d0, 1.20352542d0, 1.21880090d0, 1.23426902d0,
     & 1.24993336d0, 1.26579666d0, 1.28186119d0, 1.29812956d0,
     & 1.31460571d0, 1.33128977d0, 1.34818542d0, 1.36529553d0,
     & 1.38262296d0, 1.40017009d0, 1.41794002d0, 1.43593681d0,
     & 1.45416057d0, 1.47261584d0, 1.49130499d0, 1.51023161d0,
     & 1.52939832d0, 1.54880977d0, 1.56846607d0, 1.58837199d0,
     & 1.60853028d0, 1.62894464d0, 1.64961791d0, 1.67055368d0,
     & 1.69175661d0, 1.71322715d0, 1.73497009d0, 1.75698900d0,
     & 1.77928746d0, 1.80186892d0, 1.82473862d0, 1.84789681d0,
     & 1.87134874d0, 1.89509857d0, 1.91914976d0, 1.94350624d0,
     & 1.96817160d0, 1.99315214d0, 2.01844788d0, 2.04406428d0,
     & 2.07000613d0, 2.09627700d0, 2.12288141d0, 2.14982557d0,
     & 2.17710948d0, 2.20473981d0, 2.23272061d0, 2.26105666d0,
     & 2.28975224d0, 2.31881428d0, 2.34824300d0, 2.37804508d0,
     & 2.40822554d0, 2.43878889d0, 2.46974015d0, 2.50108409d0,
     & 2.53282857d0, 2.56497312d0, 2.59752584d0, 2.63049173d0,
     & 2.66387582d0, 2.69768381d0, 2.73192358d0, 2.76659513d0,
     & 2.80170655d0, 2.83726382d0, 2.87327218d0, 2.90973759d0,
     & 2.94666839d0, 2.98406553d0, 3.02193713d0, 3.06028914d0,
     & 3.09912801d0, 3.13845992d0, 3.17829084d0, 3.21863031d0,
     & 3.25947881d0, 3.30084562d0, 3.34273744d0, 3.38516092d0,
     & 3.42812300d0, 3.47163343d0, 3.51569295d0, 3.56031132d0,
     & 3.60549593d0, 3.65125418d0, 3.69759321d0, 3.74452019d0,
     & 3.79204679d0, 3.84017253d0, 3.88890886d0, 3.93826389d0,
     & 3.98824549d0, 4.03886127d0, 4.09012318d0, 4.14203215d0,
     & 4.19460011d0, 4.24783468d0, 4.30174494d0, 4.35633945d0,
     & 4.41162682d0, 4.46762037d0, 4.52431965d0, 4.58173895d0,
     & 4.63988686d0, 4.69877291d0, 4.75840616d0, 4.81880093d0,
     & 4.87995768d0, 4.94189024d0, 5.00460863d0, 5.06812382d0,
     & 5.13244438d0, 5.19758654d0, 5.26355076d0, 5.33035135d0,
     & 5.39800024d0, 5.46650791d0, 5.53588486d0, 5.60614157d0,
     & 5.67729616d0, 5.74934816d0, 5.82231474d0, 5.89620686d0,
     & 5.97103739d0, 6.04681683d0, 6.12356472d0, 6.20128012d0,
     & 6.27998209d0, 6.35968304d0, 6.44039536d0, 6.52213240d0,
     & 6.60491228d0, 6.68873739d0, 6.77362537d0, 6.85959101d0,
     & 6.94664812d0, 7.03480911d0, 7.12408972d0, 7.21451092d0,
     & 7.30607176d0, 7.39879513d0, 7.49269533d0, 7.58778667d0,
     & 7.68408489d0, 7.78161287d0, 7.88037157d0, 7.98038340d0,
     & 8.08166409d0, 8.18422985d0, 8.28809834d0, 8.39328480d0,
     & 8.49981499d0, 8.60768700d0, 8.71692944d0, 8.82755852d0,
     & 8.93959141d0, 9.05304623d0, 9.16794872d0, 9.28430176d0,
     & 9.40213108d0, 9.52145576d0, 9.64229488d0, 9.76466751d0,
     & 9.88859367d0,10.01410198d0,10.14119339d0,10.26989746d0,
     &10.40023613d0,10.53222752d0,10.66589451d0,10.80126858d0,
     &10.93834972d0,11.07717133d0,11.21775436d0,11.36012173d0,
     &11.50429535d0,11.65031052d0,11.79816723d0,11.94790173d0,
     &12.09953499d0,12.25309372d0,12.40860081d0,12.56608105d0,
     &12.72557259d0,12.88707542d0,13.05062866d0,13.21625710d0,
     &13.38398838d0,13.55384827d0,13.72587585d0,13.90007496d0,
     &14.07648373d0,14.25513268d0,14.43604851d0,14.61925888d0,
     &14.80481052d0,14.99270153d0,15.18297768d0,15.37566853d0,
     &15.57080460d0,15.76841831d0,15.96853828d0,16.17121506d0,
     &16.37644768d0,16.58428574d0,16.79475975d0,17.00790787d0,
     &17.22375870d0,17.44236755d0,17.66373062d0,17.88790512d0,
     &18.11492538d0,18.34482765d0,18.57764626d0,18.81341934d0,
     &19.05220222d0,19.29399872d0,19.53886604d0,19.78683662d0,
     &20.03795815d0,20.29226303d0,20.54981613d0,20.81061935d0,
     &21.07473183d0,21.34219742d0,21.61305809d0,21.88735199d0,
     &22.16513062d0,22.44645500d0,22.73132896d0,23.01981735d0,
     &23.31196785d0,23.60782623d0,23.90743828d0,24.21087837d0,
     &24.51814270d0,24.82930946d0,25.14442444d0,25.46353912d0,
     &25.78670311d0,26.11399269d0,26.44541168d0,26.78103638d0,
     &27.12092209d0,27.46512032d0,27.81368637d0,28.16667747d0,
     &28.52417374d0,28.88618279d0,29.25278282d0,29.62404060d0,
     &30.00000572d0
     &/
c Definition of fits (4 deg polynomial) for doy=181
c A0=f(Lm) same for A1,A2,A3 and A4; to be used every where except Lm>7.5 and I> 1.
      DATA (Lm4 ( 7,I), I= 1,100) /
     & 1.10d0, 1.20d0, 1.30d0, 1.40d0, 1.50d0, 1.60d0, 1.70d0, 1.80d0,
     & 1.90d0, 2.00d0, 2.10d0, 2.20d0, 2.30d0, 2.40d0, 2.50d0, 2.60d0,
     & 2.70d0, 2.80d0, 2.90d0, 3.00d0, 3.10d0, 3.20d0, 3.30d0, 3.40d0,
     & 3.50d0, 3.60d0, 3.70d0, 3.80d0, 3.90d0, 4.00d0, 4.10d0, 4.20d0,
     & 4.30d0, 4.40d0, 4.50d0, 4.60d0, 4.70d0, 4.80d0, 4.90d0, 5.00d0,
     & 5.10d0, 5.20d0, 5.30d0, 5.40d0, 5.50d0, 5.60d0, 5.70d0, 5.80d0,
     & 5.90d0, 6.00d0, 6.10d0, 6.20d0, 6.30d0, 6.40d0, 6.50d0, 6.60d0,
     & 6.70d0, 6.80d0, 6.90d0, 7.00d0, 7.10d0, 7.20d0, 7.30d0, 7.40d0,
     & 7.50d0, 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0,
     & 8.30d0, 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0,
     & 9.10d0, 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0,
     & 9.90d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A0 ( 7,I), I= 1,100) /
     & 1.1008640829D+00, 1.2017718119D+00, 1.3012182303D+00,
     & 1.4018367311D+00, 1.5015262345D+00, 1.6006288408D+00,
     & 1.7008411204D+00, 1.8011085686D+00, 1.8997233201D+00,
     & 1.9988630318D+00, 2.0991852825D+00, 2.2013343111D+00,
     & 2.2979260089D+00, 2.3922495914D+00, 2.4890197814D+00,
     & 2.5833997104D+00, 2.6791084237D+00, 2.7732804375D+00,
     & 2.8671649332D+00, 2.9603926195D+00, 3.0526812233D+00,
     & 3.1444963117D+00, 3.2357608741D+00, 3.3235246492D+00,
     & 3.4152905680D+00, 3.5025027122D+00, 3.5927745751D+00,
     & 3.6778525800D+00, 3.7662503539D+00, 3.8547443158D+00,
     & 3.9401685409D+00, 4.0263485277D+00, 4.1076076116D+00,
     & 4.1913257611D+00, 4.2759204130D+00, 4.3607037911D+00,
     & 4.4420225396D+00, 4.5231704439D+00, 4.6071861885D+00,
     & 4.6906928013D+00, 4.7716106461D+00, 4.8525778826D+00,
     & 4.9364296837D+00, 5.0154132182D+00, 5.0989257360D+00,
     & 5.1831357858D+00, 5.2612594898D+00, 5.3431838806D+00,
     & 5.4276204282D+00, 5.5110404087D+00, 5.5951591546D+00,
     & 5.6789783956D+00, 5.7637068550D+00, 5.8481953453D+00,
     & 5.9357535157D+00, 6.0211485829D+00, 6.1080049075D+00,
     & 6.1947812087D+00, 6.2839357642D+00, 6.3730636860D+00,
     & 6.4633799262D+00, 6.5546547860D+00, 6.6471598272D+00,
     & 6.7397548867D+00, 6.8330910117D+00, 6.9219904338D+00,
     & 7.0283354059D+00, 7.1229149885D+00, 7.2302424501D+00,
     & 7.3266829520D+00, 7.4465144579D+00, 7.5502104064D+00,
     & 7.6752741915D+00, 7.7942757683D+00, 7.8987802755D+00,
     & 8.0423408478D+00, 8.1627181085D+00, 8.2794473552D+00,
     & 8.3902496160D+00, 8.5316607046D+00, 8.6463569216D+00,
     & 8.7807703275D+00, 8.9132162055D+00, 9.0208450289D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A1 ( 7,I), I= 1,100) /
     &-4.1524876225D-05, 2.0746447888D-04, 3.0653469647D-04,
     & 4.7287665910D-04, 3.9697683234D-04, 5.2136391154D-04,
     & 4.5320684448D-04, 2.7081139542D-04, 1.9966652160D-04,
     &-1.4742696515D-05, 5.4078411664D-04, 7.7950572382D-03,
     & 2.0542304779D-03, 3.8255707660D-03, 5.6639889995D-03,
     & 7.4260325713D-03, 8.8599619397D-03, 8.3401156515D-03,
     & 1.1137045185D-02, 1.1834126323D-02, 1.3739820217D-02,
     & 1.2936471833D-02, 1.4365115641D-02, 1.8044638955D-02,
     & 1.7831390396D-02, 1.9469871099D-02, 2.1978646319D-02,
     & 2.3356334988D-02, 2.4514346334D-02, 2.5276524653D-02,
     & 2.6642090602D-02, 2.6588901793D-02, 2.9194861106D-02,
     & 3.1614145666D-02, 3.1888338258D-02, 3.1709178133D-02,
     & 3.3943728945D-02, 3.4238139951D-02, 3.4472308205D-02,
     & 3.4431011622D-02, 3.5079306774D-02, 3.5118002715D-02,
     & 3.5760239684D-02, 3.7322622410D-02, 3.6890732951D-02,
     & 3.6138000518D-02, 3.6879088951D-02, 3.6785283954D-02,
     & 3.6782051760D-02, 3.7196111851D-02, 3.4506786890D-02,
     & 3.4143706076D-02, 3.4554916836D-02, 3.2056163915D-02,
     & 3.0615682922D-02, 2.9886785459D-02, 2.9998225129D-02,
     & 2.9268652313D-02, 2.7440185562D-02, 2.4613233902D-02,
     & 2.1426110536D-02, 1.8324533163D-02, 1.8140991489D-02,
     & 1.7491993914D-02, 1.1201878895D-02, 5.0269223304D-03,
     & 1.5340812873D-02, 3.3731986599D-03, 6.0000279510D-03,
     &-1.3741672698D-02, 1.7828098715D-02,-2.2064107444D-03,
     & 8.8484268527D-03, 6.6023605073D-03,-2.0151746241D-02,
     & 1.1943705905D-02, 9.7734218720D-04,-6.6866938109D-04,
     &-8.9291027913D-03,-7.4485549157D-03,-1.5738370379D-02,
     &-6.8660815543D-03, 9.0268577943D-03,-8.0316850701D-03,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A2 ( 7,I), I= 1,100) /
     &-2.9799966946D-07,-2.1106380163D-06, 8.7995710401D-06,
     & 2.1633485588D-05, 1.1179684389D-05, 4.0209889396D-05,
     & 1.3982457633D-05, 3.0377827209D-06,-1.0162479485D-05,
     &-5.5431394097D-05,-2.9938654217D-06, 3.3427835202D-03,
     &-7.6988766280D-05, 3.8787993030D-04, 8.3254000622D-04,
     & 1.1274926102D-03, 1.6333761003D-03, 1.4853482388D-03,
     & 2.4445257598D-03, 2.3597277146D-03, 3.3328806710D-03,
     & 2.9452748086D-03, 3.2521353189D-03, 4.8960845167D-03,
     & 3.9117962941D-03, 4.3005263357D-03, 5.1376349649D-03,
     & 5.4255688995D-03, 5.4384825648D-03, 6.1229800545D-03,
     & 6.1707051901D-03, 5.8919003371D-03, 7.2416799657D-03,
     & 7.6010880332D-03, 6.9909023448D-03, 7.7035766488D-03,
     & 8.0109116163D-03, 8.2242263418D-03, 8.4885519090D-03,
     & 8.1259200151D-03, 8.5021914725D-03, 8.7993164774D-03,
     & 9.1858996031D-03, 9.0757796512D-03, 8.5312276946D-03,
     & 8.7827256405D-03, 8.6714817850D-03, 9.7886101666D-03,
     & 8.9866025132D-03, 8.2433612249D-03, 8.7100507457D-03,
     & 7.8737851180D-03, 7.2677816067D-03, 7.3493050498D-03,
     & 6.6183165655D-03, 6.7762590603D-03, 6.2071554007D-03,
     & 5.6180625724D-03, 4.4958473158D-03, 4.6688966905D-03,
     & 4.5371620860D-03, 3.3990645424D-03, 2.7374484010D-03,
     & 1.5760087180D-03, 1.7791587838D-03, 6.5499578798D-04,
     & 6.4186132766D-03,-1.5571258469D-03, 1.1711647947D-03,
     &-8.0989188186D-03, 9.6433814212D-03,-2.5528754281D-03,
     & 4.0572038452D-03, 2.2895436751D-03,-8.4831337265D-03,
     & 5.8450209723D-03, 2.0565006940D-04, 5.6062635030D-04,
     & 2.8100558242D-03,-2.4096762642D-03,-2.7139212341D-03,
     & 2.1170863970D-03, 9.6638899255D-03, 1.3764342875D-03,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A3 ( 7,I), I= 1,100) /
     & 3.0886485236D-07,-1.5585136240D-06,-2.1070117657D-06,
     &-3.6453896660D-06,-3.1916176636D-06,-3.8047450972D-06,
     &-3.4684157609D-06,-1.9235445250D-06,-1.3495584027D-06,
     &-3.0245517058D-06,-3.9741991302D-06, 5.3192410293D-04,
     &-6.8287747526D-05,-2.0950312701D-05, 2.6444276993D-05,
     & 3.3636842101D-05, 1.1171338727D-04, 9.8364226984D-05,
     & 2.0728261880D-04, 2.0347857331D-04, 3.3757063639D-04,
     & 2.8455225832D-04, 3.1555492288D-04, 5.7175635450D-04,
     & 3.4758009433D-04, 3.8639053868D-04, 4.9453686330D-04,
     & 5.2879568175D-04, 4.9241495241D-04, 6.3348892038D-04,
     & 5.9380891398D-04, 5.3430584729D-04, 7.4859741688D-04,
     & 7.5809487588D-04, 5.8990066759D-04, 7.9989928174D-04,
     & 7.8009243812D-04, 8.3773289220D-04, 8.7971922253D-04,
     & 7.6742238944D-04, 8.6651439803D-04, 9.3270924027D-04,
     & 9.9114178959D-04, 8.8551849721D-04, 8.2800487984D-04,
     & 9.0899622083D-04, 8.3061862848D-04, 1.0628971454D-03,
     & 9.0837675513D-04, 7.0415970450D-04, 8.7998209388D-04,
     & 7.1463856696D-04, 5.8174351546D-04, 6.2170572247D-04,
     & 5.2974259111D-04, 5.6211889082D-04, 4.7691516693D-04,
     & 3.6896420880D-04, 1.5731227378D-04, 2.1319656028D-04,
     & 3.3693942854D-04, 1.9321220537D-04, 1.4349963731D-04,
     &-2.5245193616D-04, 3.1790736798D-05, 6.3064716949D-05,
     & 1.0542005404D-03,-5.7972828776D-04, 4.8619451174D-05,
     &-1.5094854780D-03, 1.6948688367D-03,-6.7742376143D-04,
     & 6.4668376765D-04, 2.3960631184D-04,-1.3762235442D-03,
     & 9.6581854357D-04,-3.6640629642D-05,-1.3634004113D-04,
     & 8.4101241963D-04,-6.6027800021D-04,-5.5935643216D-04,
     & 1.2936483652D-04, 1.4495390342D-03,-1.1947859271D-04,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A4 ( 7,I), I= 1,100) /
     &-2.7080104730D-08,-3.3221840274D-08,-8.9979359801D-08,
     &-2.6006197461D-07,-1.5820106941D-07,-4.8816688099D-07,
     &-1.3399974370D-07,-3.8851085324D-08, 8.0069220583D-08,
     & 2.1533687165D-07, 6.9834842910D-09, 2.7809933216D-05,
     &-4.9019636728D-06,-3.2848992755D-06,-1.4691775096D-06,
     &-2.3163313871D-06, 1.9063635090D-06, 1.6215778179D-06,
     & 5.2711604703D-06, 6.3204535805D-06, 1.1880733547D-05,
     & 9.9114908950D-06, 1.1039825629D-05, 2.4044724404D-05,
     & 1.0534222694D-05, 1.1993893340D-05, 1.6857670948D-05,
     & 1.8062898721D-05, 1.5163110784D-05, 2.3716913033D-05,
     & 2.0203925399D-05, 1.6578263433D-05, 2.7117798383D-05,
     & 2.6549656025D-05, 1.5538459074D-05, 2.9964621817D-05,
     & 2.6589624499D-05, 3.0446137686D-05, 3.2453134117D-05,
     & 2.4506482285D-05, 3.1367442052D-05, 3.5564263202D-05,
     & 3.8169842107D-05, 2.9525170335D-05, 2.8573029666D-05,
     & 3.3849028398D-05, 2.7452100101D-05, 4.0233053458D-05,
     & 3.2191177937D-05, 1.8856299408D-05, 2.9972396093D-05,
     & 2.1088852346D-05, 1.3304084441D-05, 1.4909152664D-05,
     & 1.1974650434D-05, 1.2932493068D-05, 9.2600887765D-06,
     & 3.4005692535D-06,-7.8050917520D-06,-6.3027729641D-06,
     & 4.4381053661D-06,-1.8914504186D-06, 2.3501329522D-06,
     &-2.8033616929D-05,-8.3914797327D-06, 2.1895705259D-06,
     & 5.6238750552D-05,-4.2840006617D-05,-1.9794573642D-06,
     &-8.6711906039D-05, 9.4175015362D-05,-4.6419443688D-05,
     & 3.3388435300D-05, 7.5296290006D-06,-7.1126782136D-05,
     & 5.3922205012D-05,-6.0439448896D-07,-1.8813859936D-05,
     & 5.9878282619D-05,-4.2409925500D-05,-3.6277001305D-05,
     &-5.6170569958D-06, 7.3162929977D-05,-1.8682663433D-05,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of fits (5 deg polynomial) for doy=181
c A50=f(Lm5) same for A51,A52,A53, A54 and A55
c To be used only where Lm>7.5 and I> 1.
      DATA (Lm5 ( 7,I), I= 1,100) /
     & 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0, 8.30d0,
     & 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0, 9.10d0,
     & 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0, 9.90d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A50 ( 7,I), I= 1,100) /
     & 6.9304443951D+00, 7.0261143826D+00, 7.1275322763D+00,
     & 7.2302438453D+00, 7.3363963517D+00, 7.4421077918D+00,
     & 7.5546232196D+00, 7.6672683631D+00, 7.7927957219D+00,
     & 7.9096506988D+00, 8.0486609702D+00, 8.1603282591D+00,
     & 8.2711021295D+00, 8.3984667482D+00, 8.5278784558D+00,
     & 8.6493070747D+00, 8.7814418176D+00, 8.9071549140D+00,
     & 9.0145090562D+00, 1.0247440430D+01, 1.1458204967D+01,
     & 1.4286699621D+01, 1.1010031290D+01, 1.7890361572D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A51 ( 7,I), I= 1,100) /
     & 9.3638390487D-03, 2.3593980190D-02,-5.7273034103D-03,
     &-1.0807461193D-03,-4.5013597481D-03,-2.4070399930D-03,
     &-3.8601227121D-02,-3.3934340638D-02,-6.2081225126D-02,
     &-9.6927617828D-03,-3.3037714555D-02, 5.2698991230D-03,
     & 4.8488914651D-02, 1.0848239456D-01, 1.0675163869D-02,
     & 9.1669886239D-02, 6.4215564660D-03,-7.6802198326D-02,
     &-1.4585588307D-01,-1.3608437181D+00,-3.3469476174D+00,
     &-9.9012024816D+00,-7.5147651341D-01,-1.5769766093D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A52 ( 7,I), I= 1,100) /
     & 3.1228646343D-02,-9.1660364879D-03, 7.6029944522D-02,
     & 3.1219449939D-02, 8.9165876849D-03, 2.9491610101D-03,
     & 8.2058153678D-02, 5.2033408865D-02, 4.5863819728D-02,
     &-7.1439380081D-02,-8.3850240687D-02,-1.2057217241D-01,
     &-1.3583315912D-01,-2.3446600524D-01, 3.9210541151D-02,
     &-5.1361536619D-02, 2.0732950223D-01, 4.3574411268D-01,
     & 6.7917744526D-01, 4.5866449802D-01, 1.8612582911D+00,
     & 8.2906787481D+00,-1.0704282763D+00, 1.2313616392D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A53 ( 7,I), I= 1,100) /
     &-2.5544844358D-02, 5.0367181860D-03,-8.9994873617D-02,
     &-3.4298505894D-02,-5.6185088627D-03,-1.4766362282D-02,
     &-9.7948538330D-02,-7.3247569855D-02,-4.4564200789D-02,
     & 2.6624337161D-02, 3.9209181507D-02, 4.2378574875D-02,
     & 7.6070933375D-03, 5.1778145577D-02,-2.0812319489D-01,
     &-1.8538372546D-01,-4.3308857158D-01,-6.3186565760D-01,
     &-8.4701192882D-01,-1.2394575150D-01,-5.8889296657D-01,
     &-3.7329008816D+00, 8.8774410635D-01,-5.0704364572D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A54 ( 7,I), I= 1,100) /
     & 3.3785897572D-03,-5.9847170776D-03, 3.4874788097D-02,
     & 7.5632472260D-03,-6.6744157004D-03, 9.7986149736D-04,
     & 3.5835664903D-02, 2.5539064309D-02, 7.4265211363D-03,
     &-8.6740624206D-03,-1.3465304157D-02,-1.1703693524D-02,
     & 9.5072120354D-03, 1.4721989531D-03, 9.7212331044D-02,
     & 9.8014279939D-02, 1.8803457145D-01, 2.5488205983D-01,
     & 3.2616242732D-01, 2.2436426979D-02, 8.8146460976D-02,
     & 8.4471365506D-01,-2.6720056100D-01, 1.0520283559D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A55 ( 7,I), I= 1,100) /
     & 6.4909598630D-04, 1.5410610555D-03,-4.4550849746D-03,
     & 7.9616781075D-05, 2.4205820065D-03, 9.1415300431D-04,
     &-4.1207746379D-03,-2.4612943918D-03, 8.3705581551D-04,
     & 1.7402174533D-03, 2.4691506490D-03, 2.3009842586D-03,
     &-1.0138743740D-03,-5.1642563062D-04,-1.2703656858D-02,
     &-1.3318107976D-02,-2.4549787841D-02,-3.2383968119D-02,
     &-4.0507525650D-02,-1.2028874632D-03,-3.5240774674D-03,
     &-7.4872646066D-02, 2.9931938994D-02,-8.6094663112D-02,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of Loss cone as Lmax=f(Imax) for doy=211
      DATA (Lmax ( 8,I), I= 1, 2100) /
     & 1.0853d0, 1.0863d0, 1.0873d0, 1.0883d0, 1.0893d0, 1.0903d0,
     & 1.0913d0, 1.0923d0, 1.0933d0, 1.0943d0, 1.0952d0, 1.0962d0,
     & 1.0972d0, 1.0982d0, 1.0992d0, 1.1002d0, 1.1013d0, 1.1023d0,
     & 1.1033d0, 1.1043d0, 1.1053d0, 1.1063d0, 1.1073d0, 1.1084d0,
     & 1.1094d0, 1.1104d0, 1.1114d0, 1.1124d0, 1.1135d0, 1.1145d0,
     & 1.1155d0, 1.1165d0, 1.1176d0, 1.1186d0, 1.1196d0, 1.1206d0,
     & 1.1216d0, 1.1227d0, 1.1237d0, 1.1247d0, 1.1257d0, 1.1268d0,
     & 1.1278d0, 1.1288d0, 1.1298d0, 1.1309d0, 1.1319d0, 1.1329d0,
     & 1.1340d0, 1.1350d0, 1.1360d0, 1.1370d0, 1.1381d0, 1.1391d0,
     & 1.1401d0, 1.1411d0, 1.1422d0, 1.1432d0, 1.1442d0, 1.1452d0,
     & 1.1463d0, 1.1473d0, 1.1483d0, 1.1493d0, 1.1504d0, 1.1514d0,
     & 1.1524d0, 1.1535d0, 1.1545d0, 1.1555d0, 1.1565d0, 1.1576d0,
     & 1.1586d0, 1.1596d0, 1.1606d0, 1.1617d0, 1.1627d0, 1.1637d0,
     & 1.1648d0, 1.1658d0, 1.1668d0, 1.1678d0, 1.1689d0, 1.1699d0,
     & 1.1709d0, 1.1720d0, 1.1730d0, 1.1740d0, 1.1750d0, 1.1760d0,
     & 1.1771d0, 1.1781d0, 1.1791d0, 1.1801d0, 1.1812d0, 1.1822d0,
     & 1.1832d0, 1.1843d0, 1.1853d0, 1.1863d0, 1.1873d0, 1.1883d0,
     & 1.1894d0, 1.1904d0, 1.1914d0, 1.1925d0, 1.1935d0, 1.1945d0,
     & 1.1955d0, 1.1965d0, 1.1976d0, 1.1986d0, 1.1997d0, 1.2007d0,
     & 1.2017d0, 1.2027d0, 1.2037d0, 1.2047d0, 1.2058d0, 1.2068d0,
     & 1.2078d0, 1.2089d0, 1.2099d0, 1.2109d0, 1.2119d0, 1.2129d0,
     & 1.2140d0, 1.2150d0, 1.2160d0, 1.2171d0, 1.2181d0, 1.2191d0,
     & 1.2201d0, 1.2211d0, 1.2222d0, 1.2232d0, 1.2242d0, 1.2253d0,
     & 1.2263d0, 1.2273d0, 1.2283d0, 1.2293d0, 1.2304d0, 1.2314d0,
     & 1.2324d0, 1.2334d0, 1.2345d0, 1.2355d0, 1.2365d0, 1.2375d0,
     & 1.2385d0, 1.2396d0, 1.2406d0, 1.2416d0, 1.2426d0, 1.2437d0,
     & 1.2447d0, 1.2457d0, 1.2467d0, 1.2477d0, 1.2488d0, 1.2498d0,
     & 1.2508d0, 1.2518d0, 1.2529d0, 1.2539d0, 1.2549d0, 1.2559d0,
     & 1.2569d0, 1.2580d0, 1.2590d0, 1.2600d0, 1.2610d0, 1.2621d0,
     & 1.2631d0, 1.2641d0, 1.2651d0, 1.2661d0, 1.2672d0, 1.2682d0,
     & 1.2692d0, 1.2702d0, 1.2712d0, 1.2723d0, 1.2733d0, 1.2743d0,
     & 1.2753d0, 1.2763d0, 1.2774d0, 1.2784d0, 1.2794d0, 1.2804d0,
     & 1.2815d0, 1.2825d0, 1.2835d0, 1.2845d0, 1.2855d0, 1.2865d0,
     & 1.2876d0, 1.2886d0, 1.2896d0, 1.2906d0, 1.2916d0, 1.2927d0,
     & 1.2937d0, 1.2947d0, 1.2957d0, 1.2967d0, 1.2978d0, 1.2988d0,
     & 1.2998d0, 1.3008d0, 1.3018d0, 1.3029d0, 1.3039d0, 1.3049d0,
     & 1.3059d0, 1.3069d0, 1.3079d0, 1.3090d0, 1.3100d0, 1.3110d0,
     & 1.3120d0, 1.3130d0, 1.3141d0, 1.3151d0, 1.3161d0, 1.3171d0,
     & 1.3181d0, 1.3191d0, 1.3202d0, 1.3212d0, 1.3222d0, 1.3232d0,
     & 1.3242d0, 1.3253d0, 1.3263d0, 1.3273d0, 1.3283d0, 1.3293d0,
     & 1.3303d0, 1.3314d0, 1.3324d0, 1.3334d0, 1.3344d0, 1.3354d0,
     & 1.3364d0, 1.3375d0, 1.3385d0, 1.3395d0, 1.3405d0, 1.3415d0,
     & 1.3425d0, 1.3436d0, 1.3446d0, 1.3456d0, 1.3466d0, 1.3476d0,
     & 1.3486d0, 1.3497d0, 1.3507d0, 1.3517d0, 1.3527d0, 1.3537d0,
     & 1.3547d0, 1.3557d0, 1.3568d0, 1.3578d0, 1.3588d0, 1.3598d0,
     & 1.3608d0, 1.3619d0, 1.3629d0, 1.3639d0, 1.3649d0, 1.3659d0,
     & 1.3669d0, 1.3679d0, 1.3689d0, 1.3699d0, 1.3710d0, 1.3720d0,
     & 1.3730d0, 1.3740d0, 1.3750d0, 1.3761d0, 1.3771d0, 1.3781d0,
     & 1.3791d0, 1.3801d0, 1.3811d0, 1.3821d0, 1.3831d0, 1.3842d0,
     & 1.3852d0, 1.3862d0, 1.3872d0, 1.3882d0, 1.3893d0, 1.3903d0,
     & 1.3913d0, 1.3923d0, 1.3933d0, 1.3943d0, 1.3953d0, 1.3963d0,
     & 1.3973d0, 1.3984d0, 1.3994d0, 1.4004d0, 1.4014d0, 1.4024d0,
     & 1.4035d0, 1.4045d0, 1.4055d0, 1.4065d0, 1.4075d0, 1.4085d0,
     & 1.4095d0, 1.4105d0, 1.4115d0, 1.4125d0, 1.4136d0, 1.4146d0,
     & 1.4156d0, 1.4166d0, 1.4177d0, 1.4187d0, 1.4196d0, 1.4206d0,
     & 1.4216d0, 1.4226d0, 1.4237d0, 1.4247d0, 1.4257d0, 1.4267d0,
     & 1.4277d0, 1.4288d0, 1.4298d0, 1.4308d0, 1.4318d0, 1.4328d0,
     & 1.4338d0, 1.4348d0, 1.4358d0, 1.4368d0, 1.4378d0, 1.4388d0,
     & 1.4399d0, 1.4409d0, 1.4419d0, 1.4429d0, 1.4440d0, 1.4450d0,
     & 1.4460d0, 1.4470d0, 1.4480d0, 1.4490d0, 1.4500d0, 1.4510d0,
     & 1.4520d0, 1.4530d0, 1.4540d0, 1.4550d0, 1.4561d0, 1.4571d0,
     & 1.4581d0, 1.4591d0, 1.4602d0, 1.4612d0, 1.4622d0, 1.4632d0,
     & 1.4641d0, 1.4651d0, 1.4661d0, 1.4671d0, 1.4682d0, 1.4692d0,
     & 1.4702d0, 1.4712d0, 1.4722d0, 1.4733d0, 1.4743d0, 1.4753d0,
     & 1.4763d0, 1.4773d0, 1.4783d0, 1.4793d0, 1.4803d0, 1.4813d0,
     & 1.4823d0, 1.4833d0, 1.4843d0, 1.4854d0, 1.4864d0, 1.4874d0,
     & 1.4884d0, 1.4895d0, 1.4905d0, 1.4915d0, 1.4925d0, 1.4935d0,
     & 1.4945d0, 1.4955d0, 1.4964d0, 1.4974d0, 1.4984d0, 1.4995d0,
     & 1.5005d0, 1.5015d0, 1.5025d0, 1.5035d0, 1.5046d0, 1.5056d0,
     & 1.5066d0, 1.5077d0, 1.5087d0, 1.5097d0, 1.5106d0, 1.5116d0,
     & 1.5126d0, 1.5136d0, 1.5146d0, 1.5156d0, 1.5166d0, 1.5176d0,
     & 1.5186d0, 1.5197d0, 1.5207d0, 1.5217d0, 1.5227d0, 1.5238d0,
     & 1.5248d0, 1.5258d0, 1.5268d0, 1.5278d0, 1.5288d0, 1.5298d0,
     & 1.5308d0, 1.5317d0, 1.5327d0, 1.5337d0, 1.5348d0, 1.5358d0,
     & 1.5368d0, 1.5378d0, 1.5388d0, 1.5399d0, 1.5409d0, 1.5419d0,
     & 1.5429d0, 1.5440d0, 1.5449d0, 1.5459d0, 1.5469d0, 1.5479d0,
     & 1.5489d0, 1.5499d0, 1.5509d0, 1.5519d0, 1.5529d0, 1.5539d0,
     & 1.5549d0, 1.5559d0, 1.5570d0, 1.5580d0, 1.5590d0, 1.5600d0,
     & 1.5611d0, 1.5621d0, 1.5631d0, 1.5641d0, 1.5651d0, 1.5660d0,
     & 1.5670d0, 1.5680d0, 1.5690d0, 1.5700d0, 1.5710d0, 1.5720d0,
     & 1.5730d0, 1.5740d0, 1.5751d0, 1.5761d0, 1.5771d0, 1.5781d0,
     & 1.5792d0, 1.5802d0, 1.5812d0, 1.5822d0, 1.5832d0, 1.5842d0,
     & 1.5852d0, 1.5861d0, 1.5871d0, 1.5881d0, 1.5891d0, 1.5901d0,
     & 1.5911d0, 1.5921d0, 1.5932d0, 1.5942d0, 1.5952d0, 1.5962d0,
     & 1.5973d0, 1.5983d0, 1.5993d0, 1.6003d0, 1.6013d0, 1.6023d0,
     & 1.6033d0, 1.6043d0, 1.6053d0, 1.6063d0, 1.6072d0, 1.6082d0,
     & 1.6092d0, 1.6102d0, 1.6112d0, 1.6123d0, 1.6133d0, 1.6143d0,
     & 1.6153d0, 1.6164d0, 1.6174d0, 1.6184d0, 1.6195d0, 1.6205d0,
     & 1.6215d0, 1.6225d0, 1.6234d0, 1.6244d0, 1.6254d0, 1.6264d0,
     & 1.6274d0, 1.6283d0, 1.6293d0, 1.6303d0, 1.6313d0, 1.6323d0,
     & 1.6334d0, 1.6344d0, 1.6354d0, 1.6364d0, 1.6375d0, 1.6385d0,
     & 1.6395d0, 1.6406d0, 1.6416d0, 1.6426d0, 1.6436d0, 1.6445d0,
     & 1.6455d0, 1.6465d0, 1.6475d0, 1.6485d0, 1.6494d0, 1.6504d0,
     & 1.6514d0, 1.6524d0, 1.6535d0, 1.6545d0, 1.6555d0, 1.6565d0,
     & 1.6576d0, 1.6586d0, 1.6596d0, 1.6607d0, 1.6617d0, 1.6627d0,
     & 1.6637d0, 1.6647d0, 1.6656d0, 1.6666d0, 1.6676d0, 1.6686d0,
     & 1.6696d0, 1.6705d0, 1.6715d0, 1.6725d0, 1.6735d0, 1.6745d0,
     & 1.6755d0, 1.6766d0, 1.6776d0, 1.6786d0, 1.6796d0, 1.6807d0,
     & 1.6817d0, 1.6828d0, 1.6838d0, 1.6848d0, 1.6858d0, 1.6868d0,
     & 1.6877d0, 1.6887d0, 1.6897d0, 1.6907d0, 1.6917d0, 1.6926d0,
     & 1.6936d0, 1.6946d0, 1.6956d0, 1.6966d0, 1.6976d0, 1.6987d0,
     & 1.6997d0, 1.7007d0, 1.7018d0, 1.7028d0, 1.7038d0, 1.7049d0,
     & 1.7059d0, 1.7069d0, 1.7079d0, 1.7089d0, 1.7099d0, 1.7108d0,
     & 1.7118d0, 1.7128d0, 1.7138d0, 1.7148d0, 1.7157d0, 1.7167d0,
     & 1.7177d0, 1.7187d0, 1.7197d0, 1.7207d0, 1.7217d0, 1.7228d0,
     & 1.7238d0, 1.7248d0, 1.7259d0, 1.7269d0, 1.7279d0, 1.7290d0,
     & 1.7300d0, 1.7310d0, 1.7320d0, 1.7329d0, 1.7339d0, 1.7349d0,
     & 1.7359d0, 1.7369d0, 1.7379d0, 1.7388d0, 1.7398d0, 1.7408d0,
     & 1.7418d0, 1.7428d0, 1.7438d0, 1.7448d0, 1.7458d0, 1.7468d0,
     & 1.7478d0, 1.7489d0, 1.7499d0, 1.7509d0, 1.7520d0, 1.7530d0,
     & 1.7540d0, 1.7550d0, 1.7560d0, 1.7570d0, 1.7580d0, 1.7590d0,
     & 1.7600d0, 1.7610d0, 1.7619d0, 1.7629d0, 1.7639d0, 1.7649d0,
     & 1.7659d0, 1.7668d0, 1.7678d0, 1.7688d0, 1.7698d0, 1.7709d0,
     & 1.7719d0, 1.7729d0, 1.7739d0, 1.7750d0, 1.7760d0, 1.7770d0,
     & 1.7781d0, 1.7791d0, 1.7801d0, 1.7811d0, 1.7821d0, 1.7831d0,
     & 1.7841d0, 1.7851d0, 1.7860d0, 1.7870d0, 1.7880d0, 1.7890d0,
     & 1.7900d0, 1.7909d0, 1.7919d0, 1.7929d0, 1.7939d0, 1.7949d0,
     & 1.7959d0, 1.7969d0, 1.7979d0, 1.7990d0, 1.8000d0, 1.8010d0,
     & 1.8021d0, 1.8031d0, 1.8042d0, 1.8052d0, 1.8062d0, 1.8072d0,
     & 1.8082d0, 1.8092d0, 1.8101d0, 1.8111d0, 1.8121d0, 1.8131d0,
     & 1.8141d0, 1.8150d0, 1.8160d0, 1.8170d0, 1.8180d0, 1.8189d0,
     & 1.8199d0, 1.8209d0, 1.8219d0, 1.8229d0, 1.8240d0, 1.8250d0,
     & 1.8260d0, 1.8271d0, 1.8281d0, 1.8291d0, 1.8302d0, 1.8312d0,
     & 1.8322d0, 1.8332d0, 1.8342d0, 1.8352d0, 1.8362d0, 1.8372d0,
     & 1.8382d0, 1.8392d0, 1.8402d0, 1.8411d0, 1.8421d0, 1.8431d0,
     & 1.8441d0, 1.8450d0, 1.8460d0, 1.8470d0, 1.8480d0, 1.8490d0,
     & 1.8500d0, 1.8510d0, 1.8520d0, 1.8531d0, 1.8541d0, 1.8552d0,
     & 1.8562d0, 1.8572d0, 1.8583d0, 1.8593d0, 1.8603d0, 1.8613d0,
     & 1.8623d0, 1.8633d0, 1.8643d0, 1.8653d0, 1.8662d0, 1.8672d0,
     & 1.8682d0, 1.8692d0, 1.8702d0, 1.8711d0, 1.8721d0, 1.8731d0,
     & 1.8741d0, 1.8750d0, 1.8760d0, 1.8770d0, 1.8781d0, 1.8791d0,
     & 1.8801d0, 1.8811d0, 1.8822d0, 1.8832d0, 1.8843d0, 1.8853d0,
     & 1.8863d0, 1.8873d0, 1.8884d0, 1.8894d0, 1.8903d0, 1.8913d0,
     & 1.8923d0, 1.8933d0, 1.8943d0, 1.8953d0, 1.8963d0, 1.8972d0,
     & 1.8982d0, 1.8992d0, 1.9002d0, 1.9011d0, 1.9021d0, 1.9031d0,
     & 1.9041d0, 1.9050d0, 1.9060d0, 1.9070d0, 1.9081d0, 1.9091d0,
     & 1.9101d0, 1.9112d0, 1.9122d0, 1.9132d0, 1.9143d0, 1.9153d0,
     & 1.9164d0, 1.9174d0, 1.9184d0, 1.9194d0, 1.9204d0, 1.9214d0,
     & 1.9224d0, 1.9234d0, 1.9243d0, 1.9253d0, 1.9263d0, 1.9273d0,
     & 1.9283d0, 1.9292d0, 1.9302d0, 1.9312d0, 1.9322d0, 1.9331d0,
     & 1.9341d0, 1.9351d0, 1.9361d0, 1.9371d0, 1.9381d0, 1.9391d0,
     & 1.9402d0, 1.9412d0, 1.9422d0, 1.9433d0, 1.9443d0, 1.9454d0,
     & 1.9464d0, 1.9474d0, 1.9484d0, 1.9494d0, 1.9504d0, 1.9514d0,
     & 1.9524d0, 1.9534d0, 1.9544d0, 1.9554d0, 1.9564d0, 1.9573d0,
     & 1.9583d0, 1.9593d0, 1.9603d0, 1.9612d0, 1.9622d0, 1.9632d0,
     & 1.9642d0, 1.9651d0, 1.9661d0, 1.9671d0, 1.9681d0, 1.9691d0,
     & 1.9702d0, 1.9712d0, 1.9722d0, 1.9733d0, 1.9743d0, 1.9753d0,
     & 1.9764d0, 1.9774d0, 1.9785d0, 1.9795d0, 1.9805d0, 1.9815d0,
     & 1.9825d0, 1.9835d0, 1.9844d0, 1.9854d0, 1.9864d0, 1.9874d0,
     & 1.9884d0, 1.9894d0, 1.9903d0, 1.9913d0, 1.9923d0, 1.9933d0,
     & 1.9942d0, 1.9952d0, 1.9962d0, 1.9972d0, 1.9981d0, 1.9991d0,
     & 2.0001d0, 2.0012d0, 2.0022d0, 2.0032d0, 2.0043d0, 2.0053d0,
     & 2.0063d0, 2.0074d0, 2.0084d0, 2.0095d0, 2.0105d0, 2.0115d0,
     & 2.0125d0, 2.0135d0, 2.0145d0, 2.0155d0, 2.0165d0, 2.0175d0,
     & 2.0184d0, 2.0194d0, 2.0204d0, 2.0214d0, 2.0224d0, 2.0233d0,
     & 2.0243d0, 2.0253d0, 2.0263d0, 2.0272d0, 2.0282d0, 2.0292d0,
     & 2.0301d0, 2.0311d0, 2.0321d0, 2.0331d0, 2.0342d0, 2.0352d0,
     & 2.0362d0, 2.0373d0, 2.0383d0, 2.0393d0, 2.0404d0, 2.0414d0,
     & 2.0425d0, 2.0435d0, 2.0445d0, 2.0455d0, 2.0465d0, 2.0475d0,
     & 2.0485d0, 2.0495d0, 2.0505d0, 2.0515d0, 2.0524d0, 2.0534d0,
     & 2.0544d0, 2.0554d0, 2.0564d0, 2.0573d0, 2.0583d0, 2.0593d0,
     & 2.0603d0, 2.0612d0, 2.0622d0, 2.0632d0, 2.0642d0, 2.0652d0,
     & 2.0662d0, 2.0672d0, 2.0682d0, 2.0692d0, 2.0703d0, 2.0713d0,
     & 2.0723d0, 2.0734d0, 2.0744d0, 2.0755d0, 2.0765d0, 2.0775d0,
     & 2.0785d0, 2.0795d0, 2.0805d0, 2.0817d0, 2.0827d0, 2.0836d0,
     & 2.0846d0, 2.0856d0, 2.0866d0, 2.0876d0, 2.0886d0, 2.0896d0,
     & 2.0905d0, 2.0915d0, 2.0923d0, 2.0933d0, 2.0943d0, 2.0952d0,
     & 2.0963d0, 2.0973d0, 2.0983d0, 2.0993d0, 2.1002d0, 2.1012d0,
     & 2.1022d0, 2.1033d0, 2.1043d0, 2.1053d0, 2.1064d0, 2.1074d0,
     & 2.1083d0, 2.1093d0, 2.1104d0, 2.1114d0, 2.1125d0, 2.1135d0,
     & 2.1145d0, 2.1155d0, 2.1164d0, 2.1174d0, 2.1184d0, 2.1194d0,
     & 2.1204d0, 2.1214d0, 2.1224d0, 2.1233d0, 2.1244d0, 2.1254d0,
     & 2.1264d0, 2.1274d0, 2.1284d0, 2.1293d0, 2.1303d0, 2.1313d0,
     & 2.1323d0, 2.1334d0, 2.1344d0, 2.1354d0, 2.1364d0, 2.1373d0,
     & 2.1383d0, 2.1394d0, 2.1404d0, 2.1414d0, 2.1424d0, 2.1434d0,
     & 2.1444d0, 2.1454d0, 2.1463d0, 2.1473d0, 2.1483d0, 2.1494d0,
     & 2.1503d0, 2.1514d0, 2.1524d0, 2.1534d0, 2.1544d0, 2.1553d0,
     & 2.1563d0, 2.1573d0, 2.1583d0, 2.1593d0, 2.1603d0, 2.1613d0,
     & 2.1622d0, 2.1632d0, 2.1642d0, 2.1652d0, 2.1662d0, 2.1672d0,
     & 2.1682d0, 2.1692d0, 2.1702d0, 2.1711d0, 2.1721d0, 2.1731d0,
     & 2.1741d0, 2.1750d0, 2.1760d0, 2.1770d0, 2.1780d0, 2.1790d0,
     & 2.1800d0, 2.1810d0, 2.1821d0, 2.1831d0, 2.1842d0, 2.1852d0,
     & 2.1863d0, 2.1873d0, 2.1883d0, 2.1893d0, 2.1903d0, 2.1913d0,
     & 2.1923d0, 2.1932d0, 2.1942d0, 2.1952d0, 2.1962d0, 2.1972d0,
     & 2.1982d0, 2.1992d0, 2.2002d0, 2.2012d0, 2.2022d0, 2.2032d0,
     & 2.2041d0, 2.2051d0, 2.2062d0, 2.2072d0, 2.2082d0, 2.2092d0,
     & 2.2102d0, 2.2112d0, 2.2123d0, 2.2133d0, 2.2143d0, 2.2154d0,
     & 2.2164d0, 2.2173d0, 2.2183d0, 2.2193d0, 2.2202d0, 2.2212d0,
     & 2.2222d0, 2.2232d0, 2.2243d0, 2.2254d0, 2.2265d0, 2.2275d0,
     & 2.2286d0, 2.2297d0, 2.2308d0, 2.2319d0, 2.2329d0, 2.2339d0,
     & 2.2349d0, 2.2358d0, 2.2366d0, 2.2375d0, 2.2384d0, 2.2392d0,
     & 2.2401d0, 2.2410d0, 2.2419d0, 2.2429d0, 2.2440d0, 2.2450d0,
     & 2.2460d0, 2.2471d0, 2.2481d0, 2.2491d0, 2.2502d0, 2.2513d0,
     & 2.2523d0, 2.2534d0, 2.2543d0, 2.2552d0, 2.2562d0, 2.2572d0,
     & 2.2581d0, 2.2590d0, 2.2600d0, 2.2609d0, 2.2619d0, 2.2629d0,
     & 2.2639d0, 2.2649d0, 2.2659d0, 2.2669d0, 2.2679d0, 2.2690d0,
     & 2.2700d0, 2.2718d0, 2.2745d0, 2.2779d0, 2.2821d0, 2.2871d0,
     & 2.2930d0, 2.2997d0, 2.3072d0, 2.3155d0, 2.3246d0, 2.3346d0,
     & 2.3446d0, 2.3546d0, 2.3645d0, 2.3745d0, 2.3844d0, 2.3944d0,
     & 2.4042d0, 2.4142d0, 2.4241d0, 2.4340d0, 2.4439d0, 2.4538d0,
     & 2.4636d0, 2.4735d0, 2.4834d0, 2.4933d0, 2.5032d0, 2.5131d0,
     & 2.5230d0, 2.5329d0, 2.5427d0, 2.5526d0, 2.5625d0, 2.5724d0,
     & 2.5823d0, 2.5922d0, 2.6021d0, 2.6120d0, 2.6220d0, 2.6319d0,
     & 2.6418d0, 2.6517d0, 2.6617d0, 2.6716d0, 2.6814d0, 2.6913d0,
     & 2.7012d0, 2.7111d0, 2.7210d0, 2.7308d0, 2.7407d0, 2.7505d0,
     & 2.7604d0, 2.7703d0, 2.7802d0, 2.7901d0, 2.8000d0, 2.8098d0,
     & 2.8197d0, 2.8296d0, 2.8395d0, 2.8494d0, 2.8592d0, 2.8691d0,
     & 2.8789d0, 2.8888d0, 2.8987d0, 2.9085d0, 2.9184d0, 2.9283d0,
     & 2.9382d0, 2.9482d0, 2.9580d0, 2.9680d0, 2.9778d0, 2.9878d0,
     & 2.9977d0, 3.0076d0, 3.0175d0, 3.0274d0, 3.0372d0, 3.0470d0,
     & 3.0569d0, 3.0668d0, 3.0766d0, 3.0865d0, 3.0963d0, 3.1061d0,
     & 3.1160d0, 3.1259d0, 3.1357d0, 3.1456d0, 3.1555d0, 3.1653d0,
     & 3.1752d0, 3.1851d0, 3.1951d0, 3.2050d0, 3.2149d0, 3.2247d0,
     & 3.2346d0, 3.2445d0, 3.2543d0, 3.2642d0, 3.2741d0, 3.2840d0,
     & 3.2938d0, 3.3035d0, 3.3133d0, 3.3231d0, 3.3330d0, 3.3428d0,
     & 3.3527d0, 3.3625d0, 3.3723d0, 3.3821d0, 3.3920d0, 3.4019d0,
     & 3.4118d0, 3.4217d0, 3.4316d0, 3.4415d0, 3.4513d0, 3.4611d0,
     & 3.4709d0, 3.4808d0, 3.4907d0, 3.5005d0, 3.5104d0, 3.5201d0,
     & 3.5300d0, 3.5397d0, 3.5496d0, 3.5594d0, 3.5693d0, 3.5792d0,
     & 3.5891d0, 3.5989d0, 3.6089d0, 3.6187d0, 3.6285d0, 3.6384d0,
     & 3.6484d0, 3.6582d0, 3.6680d0, 3.6779d0, 3.6877d0, 3.6976d0,
     & 3.7074d0, 3.7173d0, 3.7272d0, 3.7371d0, 3.7470d0, 3.7568d0,
     & 3.7666d0, 3.7764d0, 3.7862d0, 3.7960d0, 3.8058d0, 3.8157d0,
     & 3.8256d0, 3.8354d0, 3.8452d0, 3.8551d0, 3.8649d0, 3.8747d0,
     & 3.8845d0, 3.8944d0, 3.9043d0, 3.9142d0, 3.9240d0, 3.9339d0,
     & 3.9437d0, 3.9535d0, 3.9633d0, 3.9732d0, 3.9831d0, 3.9929d0,
     & 4.0027d0, 4.0126d0, 4.0225d0, 4.0323d0, 4.0421d0, 4.0520d0,
     & 4.0618d0, 4.0716d0, 4.0815d0, 4.0914d0, 4.1014d0, 4.1113d0,
     & 4.1211d0, 4.1310d0, 4.1408d0, 4.1507d0, 4.1605d0, 4.1703d0,
     & 4.1802d0, 4.1899d0, 4.1998d0, 4.2096d0, 4.2195d0, 4.2294d0,
     & 4.2392d0, 4.2491d0, 4.2589d0, 4.2688d0, 4.2787d0, 4.2885d0,
     & 4.2983d0, 4.3081d0, 4.3180d0, 4.3278d0, 4.3377d0, 4.3475d0,
     & 4.3573d0, 4.3671d0, 4.3769d0, 4.3867d0, 4.3967d0, 4.4067d0,
     & 4.4166d0, 4.4264d0, 4.4363d0, 4.4462d0, 4.4560d0, 4.4660d0,
     & 4.4759d0, 4.4858d0, 4.4957d0, 4.5056d0, 4.5154d0, 4.5253d0,
     & 4.5352d0, 4.5451d0, 4.5550d0, 4.5650d0, 4.5749d0, 4.5848d0,
     & 4.5948d0, 4.6048d0, 4.6146d0, 4.6245d0, 4.6342d0, 4.6441d0,
     & 4.6540d0, 4.6638d0, 4.6737d0, 4.6836d0, 4.6935d0, 4.7035d0,
     & 4.7134d0, 4.7234d0, 4.7334d0, 4.7434d0, 4.7531d0, 4.7630d0,
     & 4.7729d0, 4.7827d0, 4.7925d0, 4.8025d0, 4.8124d0, 4.8224d0,
     & 4.8323d0, 4.8421d0, 4.8521d0, 4.8621d0, 4.8720d0, 4.8820d0,
     & 4.8920d0, 4.9019d0, 4.9117d0, 4.9215d0, 4.9315d0, 4.9413d0,
     & 4.9513d0, 4.9613d0, 4.9713d0, 4.9813d0, 4.9913d0, 5.0013d0,
     & 5.0114d0, 5.0214d0, 5.0314d0, 5.0414d0, 5.0515d0, 5.0615d0,
     & 5.0715d0, 5.0815d0, 5.0915d0, 5.1015d0, 5.1115d0, 5.1215d0,
     & 5.1315d0, 5.1415d0, 5.1514d0, 5.1614d0, 5.1713d0, 5.1812d0,
     & 5.1911d0, 5.2011d0, 5.2111d0, 5.2211d0, 5.2312d0, 5.2412d0,
     & 5.2513d0, 5.2613d0, 5.2714d0, 5.2815d0, 5.2915d0, 5.3016d0,
     & 5.3115d0, 5.3214d0, 5.3313d0, 5.3413d0, 5.3512d0, 5.3613d0,
     & 5.3714d0, 5.3815d0, 5.3915d0, 5.4016d0, 5.4117d0, 5.4219d0,
     & 5.4320d0, 5.4423d0, 5.4523d0, 5.4625d0, 5.4725d0, 5.4825d0,
     & 5.4925d0, 5.5026d0, 5.5127d0, 5.5227d0, 5.5327d0, 5.5428d0,
     & 5.5529d0, 5.5631d0, 5.5732d0, 5.5835d0, 5.5937d0, 5.6039d0,
     & 5.6140d0, 5.6242d0, 5.6344d0, 5.6447d0, 5.6547d0, 5.6647d0,
     & 5.6746d0, 5.6847d0, 5.6947d0, 5.7047d0, 5.7148d0, 5.7251d0,
     & 5.7353d0, 5.7455d0, 5.7557d0, 5.7660d0, 5.7764d0, 5.7868d0,
     & 5.7971d0, 5.8074d0, 5.8177d0, 5.8278d0, 5.8380d0, 5.8481d0,
     & 5.8582d0, 5.8683d0, 5.8784d0, 5.8886d0, 5.8988d0, 5.9088d0,
     & 5.9189d0, 5.9289d0, 5.9392d0, 5.9495d0, 5.9598d0, 5.9702d0,
     & 5.9805d0, 5.9909d0, 6.0011d0, 6.0114d0, 6.0217d0, 6.0321d0,
     & 6.0425d0, 6.0527d0, 6.0628d0, 6.0729d0, 6.0833d0, 6.0936d0,
     & 6.1040d0, 6.1143d0, 6.1247d0, 6.1351d0, 6.1455d0, 6.1559d0,
     & 6.1664d0, 6.1767d0, 6.1872d0, 6.1975d0, 6.2078d0, 6.2181d0,
     & 6.2285d0, 6.2388d0, 6.2492d0, 6.2596d0, 6.2699d0, 6.2802d0,
     & 6.2906d0, 6.3008d0, 6.3111d0, 6.3214d0, 6.3317d0, 6.3420d0,
     & 6.3522d0, 6.3625d0, 6.3730d0, 6.3833d0, 6.3938d0, 6.4042d0,
     & 6.4147d0, 6.4253d0, 6.4359d0, 6.4464d0, 6.4570d0, 6.4676d0,
     & 6.4783d0, 6.4886d0, 6.4994d0, 6.5099d0, 6.5205d0, 6.5310d0,
     & 6.5414d0, 6.5517d0, 6.5621d0, 6.5726d0, 6.5831d0, 6.5935d0,
     & 6.6039d0, 6.6144d0, 6.6249d0, 6.6355d0, 6.6460d0, 6.6565d0,
     & 6.6673d0, 6.6778d0, 6.6882d0, 6.6986d0, 6.7090d0, 6.7197d0,
     & 6.7304d0, 6.7411d0, 6.7517d0, 6.7625d0, 6.7733d0, 6.7838d0,
     & 6.7946d0, 6.8054d0, 6.8162d0, 6.8270d0, 6.8377d0, 6.8483d0,
     & 6.8589d0, 6.8694d0, 6.8801d0, 6.8907d0, 6.9014d0, 6.9121d0,
     & 6.9227d0, 6.9334d0, 6.9440d0, 6.9549d0, 6.9657d0, 6.9763d0,
     & 6.9870d0, 6.9977d0, 7.0084d0, 7.0192d0, 7.0298d0, 7.0406d0,
     & 7.0513d0, 7.0623d0, 7.0731d0, 7.0839d0, 7.0949d0, 7.1058d0,
     & 7.1168d0, 7.1276d0, 7.1384d0, 7.1496d0, 7.1604d0, 7.1713d0,
     & 7.1821d0, 7.1929d0, 7.2036d0, 7.2145d0, 7.2254d0, 7.2363d0,
     & 7.2474d0, 7.2585d0, 7.2694d0, 7.2805d0, 7.2914d0, 7.3025d0,
     & 7.3135d0, 7.3247d0, 7.3357d0, 7.3467d0, 7.3577d0, 7.3687d0,
     & 7.3797d0, 7.3906d0, 7.4015d0, 7.4127d0, 7.4236d0, 7.4346d0,
     & 7.4456d0, 7.4567d0, 7.4678d0, 7.4789d0, 7.4899d0, 7.5010d0,
     & 7.5121d0, 7.5233d0, 7.5345d0, 7.5455d0, 7.5568d0, 7.5678d0,
     & 7.5789d0, 7.5900d0, 7.6012d0, 7.6126d0, 7.6238d0, 7.6350d0,
     & 7.6461d0, 7.6572d0, 7.6685d0, 7.6796d0, 7.6911d0, 7.7025d0,
     & 7.7138d0, 7.7249d0, 7.7362d0, 7.7474d0, 7.7587d0, 7.7700d0,
     & 7.7813d0, 7.7927d0, 7.8040d0, 7.8152d0, 7.8264d0, 7.8376d0,
     & 7.8491d0, 7.8604d0, 7.8717d0, 7.8831d0, 7.8945d0, 7.9061d0,
     & 7.9178d0, 7.9295d0, 7.9411d0, 7.9529d0, 7.9644d0, 7.9760d0,
     & 7.9875d0, 7.9990d0, 8.0106d0, 8.0222d0, 8.0336d0, 8.0451d0,
     & 8.0566d0, 8.0682d0, 8.0798d0, 8.0915d0, 8.1032d0, 8.1149d0,
     & 8.1265d0, 8.1382d0, 8.1499d0, 8.1617d0, 8.1735d0, 8.1852d0,
     & 8.1969d0, 8.2088d0, 8.2207d0, 8.2324d0, 8.2444d0, 8.2563d0,
     & 8.2684d0, 8.2803d0, 8.2919d0, 8.3035d0, 8.3156d0, 8.3275d0,
     & 8.3392d0, 8.3511d0, 8.3631d0, 8.3750d0, 8.3871d0, 8.3990d0,
     & 8.4109d0, 8.4230d0, 8.4350d0, 8.4469d0, 8.4589d0, 8.4712d0,
     & 8.4833d0, 8.4952d0, 8.5073d0, 8.5193d0, 8.5315d0, 8.5439d0,
     & 8.5564d0, 8.5689d0, 8.5813d0, 8.5935d0, 8.6057d0, 8.6178d0,
     & 8.6303d0, 8.6427d0, 8.6550d0, 8.6670d0, 8.6792d0, 8.6912d0,
     & 8.7036d0, 8.7160d0, 8.7284d0, 8.7410d0, 8.7535d0, 8.7660d0,
     & 8.7785d0, 8.7909d0, 8.8038d0, 8.8165d0, 8.8290d0, 8.8412d0,
     & 8.8535d0, 8.8660d0, 8.8784d0, 8.8911d0, 8.9033d0, 8.9156d0,
     & 8.9286d0, 8.9410d0, 8.9536d0, 8.9667d0, 8.9798d0, 8.9929d0,
     & 9.0060d0, 9.0187d0, 9.0311d0, 9.0440d0, 9.0572d0, 9.0699d0,
     & 9.0831d0, 9.0960d0, 9.1089d0, 9.1219d0, 9.1346d0, 9.1476d0,
     & 9.1610d0, 9.1744d0, 9.1879d0, 9.2008d0, 9.2142d0, 9.2274d0,
     & 9.2405d0, 9.2535d0, 9.2666d0, 9.2802d0, 9.2933d0, 9.3066d0,
     & 9.3199d0, 9.3332d0, 9.3467d0, 9.3600d0, 9.3735d0, 9.3870d0,
     & 9.4008d0, 9.4144d0, 9.4276d0, 9.4408d0, 9.4541d0, 9.4675d0,
     & 9.4811d0, 9.4947d0, 9.5086d0, 9.5223d0, 9.5360d0, 9.5493d0,
     & 9.5631d0, 9.5771d0, 9.5909d0, 9.6048d0, 9.6186d0, 9.6324d0,
     & 9.6463d0, 9.6602d0, 9.6742d0, 9.6879d0, 9.7023d0, 9.7164d0,
     & 9.7302d0, 9.7445d0, 9.7587d0, 9.7728d0, 9.7867d0, 9.8007d0,
     & 9.8150d0, 9.8292d0, 9.8435d0, 9.8578d0, 9.8722d0, 9.8870d0,
     & 9.9013d0, 9.9157d0, 9.9301d0, 9.9432d0, 9.9549d0, 9.9650d0,
     & 9.9738d0, 9.9817d0, 9.9878d0, 9.9926d0, 9.9961d0, 9.9987d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0
     &/
      DATA (Imax ( 8,I), I= 1, 1000) /
     & 0.00002607d0, 0.00002607d0, 0.00005473d0, 0.00010585d0,
     & 0.00021607d0, 0.00041150d0, 0.00064850d0, 0.00098364d0,
     & 0.00138944d0, 0.00191665d0, 0.00253764d0, 0.00325553d0,
     & 0.00410014d0, 0.00502707d0, 0.00606562d0, 0.00720456d0,
     & 0.00838351d0, 0.00963964d0, 0.01097587d0, 0.01238881d0,
     & 0.01381066d0, 0.01527106d0, 0.01680313d0, 0.01838222d0,
     & 0.01998305d0, 0.02161847d0, 0.02327264d0, 0.02498985d0,
     & 0.02672778d0, 0.02845326d0, 0.03022377d0, 0.03203434d0,
     & 0.03389170d0, 0.03572370d0, 0.03759001d0, 0.03951042d0,
     & 0.04144657d0, 0.04336052d0, 0.04527490d0, 0.04725449d0,
     & 0.04925279d0, 0.05123628d0, 0.05322377d0, 0.05524603d0,
     & 0.05729172d0, 0.05934554d0, 0.06140216d0, 0.06347269d0,
     & 0.06559064d0, 0.06769975d0, 0.06980616d0, 0.07191747d0,
     & 0.07405589d0, 0.07623842d0, 0.07838433d0, 0.08053789d0,
     & 0.08270468d0, 0.08486880d0, 0.08707262d0, 0.08926192d0,
     & 0.09146958d0, 0.09368526d0, 0.09590757d0, 0.09815716d0,
     & 0.10039408d0, 0.10264845d0, 0.10490858d0, 0.10716695d0,
     & 0.10944314d0, 0.11173073d0, 0.11402439d0, 0.11632273d0,
     & 0.11861105d0, 0.12091713d0, 0.12320393d0, 0.12552588d0,
     & 0.12787285d0, 0.13020845d0, 0.13253464d0, 0.13486631d0,
     & 0.13716972d0, 0.13951167d0, 0.14188918d0, 0.14427058d0,
     & 0.14663833d0, 0.14900731d0, 0.15134801d0, 0.15368153d0,
     & 0.15608235d0, 0.15850645d0, 0.16092834d0, 0.16333403d0,
     & 0.16570923d0, 0.16806297d0, 0.17043254d0, 0.17287730d0,
     & 0.17532796d0, 0.17777966d0, 0.18021205d0, 0.18260927d0,
     & 0.18499978d0, 0.18739095d0, 0.18983835d0, 0.19232889d0,
     & 0.19482142d0, 0.19729267d0, 0.19970368d0, 0.20209138d0,
     & 0.20449725d0, 0.20698841d0, 0.20948084d0, 0.21199140d0,
     & 0.21449788d0, 0.21696471d0, 0.21938740d0, 0.22181118d0,
     & 0.22425620d0, 0.22676310d0, 0.22931011d0, 0.23183627d0,
     & 0.23431154d0, 0.23676595d0, 0.23919980d0, 0.24163434d0,
     & 0.24410193d0, 0.24664156d0, 0.24918142d0, 0.25173661d0,
     & 0.25424701d0, 0.25673199d0, 0.25921547d0, 0.26167041d0,
     & 0.26416650d0, 0.26670432d0, 0.26930606d0, 0.27187350d0,
     & 0.27438453d0, 0.27689067d0, 0.27937633d0, 0.28184396d0,
     & 0.28431389d0, 0.28685540d0, 0.28945670d0, 0.29203579d0,
     & 0.29458851d0, 0.29711229d0, 0.29963437d0, 0.30215672d0,
     & 0.30468109d0, 0.30718791d0, 0.30980027d0, 0.31243280d0,
     & 0.31501186d0, 0.31755665d0, 0.32010797d0, 0.32266036d0,
     & 0.32517377d0, 0.32769036d0, 0.33023483d0, 0.33281803d0,
     & 0.33546567d0, 0.33802572d0, 0.34058103d0, 0.34313598d0,
     & 0.34569272d0, 0.34824163d0, 0.35081318d0, 0.35338607d0,
     & 0.35599527d0, 0.35860440d0, 0.36119413d0, 0.36377764d0,
     & 0.36635998d0, 0.36894208d0, 0.37150320d0, 0.37406549d0,
     & 0.37662995d0, 0.37918457d0, 0.38180158d0, 0.38440406d0,
     & 0.38699850d0, 0.38959035d0, 0.39218190d0, 0.39476734d0,
     & 0.39733362d0, 0.39992473d0, 0.40249723d0, 0.40511912d0,
     & 0.40776402d0, 0.41038868d0, 0.41303295d0, 0.41565445d0,
     & 0.41827789d0, 0.42085913d0, 0.42345026d0, 0.42606559d0,
     & 0.42866030d0, 0.43129474d0, 0.43394387d0, 0.43658248d0,
     & 0.43919623d0, 0.44178757d0, 0.44438019d0, 0.44697478d0,
     & 0.44959337d0, 0.45221329d0, 0.45481220d0, 0.45741302d0,
     & 0.46011567d0, 0.46278012d0, 0.46537167d0, 0.46798801d0,
     & 0.47062907d0, 0.47327092d0, 0.47591406d0, 0.47855914d0,
     & 0.48118570d0, 0.48381510d0, 0.48648086d0, 0.48904791d0,
     & 0.49164364d0, 0.49428940d0, 0.49693716d0, 0.49956414d0,
     & 0.50219405d0, 0.50480354d0, 0.50741649d0, 0.51003003d0,
     & 0.51269245d0, 0.51536268d0, 0.51803041d0, 0.52069962d0,
     & 0.52337068d0, 0.52604395d0, 0.52867126d0, 0.53132463d0,
     & 0.53400403d0, 0.53666174d0, 0.53934449d0, 0.54198158d0,
     & 0.54458064d0, 0.54731840d0, 0.54998195d0, 0.55267364d0,
     & 0.55534333d0, 0.55803943d0, 0.56068909d0, 0.56331629d0,
     & 0.56596923d0, 0.56864870d0, 0.57133007d0, 0.57401323d0,
     & 0.57656264d0, 0.57916093d0, 0.58176780d0, 0.58442372d0,
     & 0.58710825d0, 0.58982015d0, 0.59253532d0, 0.59518009d0,
     & 0.59780437d0, 0.60048068d0, 0.60315996d0, 0.60580832d0,
     & 0.60848582d0, 0.61115611d0, 0.61378980d0, 0.61640364d0,
     & 0.61912310d0, 0.62184519d0, 0.62456888d0, 0.62727016d0,
     & 0.62992471d0, 0.63263094d0, 0.63533872d0, 0.63798344d0,
     & 0.64059550d0, 0.64328325d0, 0.64598137d0, 0.64858383d0,
     & 0.65126878d0, 0.65398157d0, 0.65672255d0, 0.65946579d0,
     & 0.66216117d0, 0.66483331d0, 0.66753256d0, 0.67025876d0,
     & 0.67289513d0, 0.67554265d0, 0.67822057d0, 0.68083137d0,
     & 0.68350118d0, 0.68615019d0, 0.68887997d0, 0.69163817d0,
     & 0.69442385d0, 0.69713563d0, 0.69984978d0, 0.70258206d0,
     & 0.70528704d0, 0.70795238d0, 0.71062791d0, 0.71331251d0,
     & 0.71600932d0, 0.71863669d0, 0.72124505d0, 0.72385889d0,
     & 0.72663271d0, 0.72938490d0, 0.73215020d0, 0.73484051d0,
     & 0.73755866d0, 0.74025220d0, 0.74290109d0, 0.74553192d0,
     & 0.74820560d0, 0.75092739d0, 0.75368536d0, 0.75634480d0,
     & 0.75900900d0, 0.76178312d0, 0.76463705d0, 0.76744157d0,
     & 0.77022201d0, 0.77300453d0, 0.77578914d0, 0.77852106d0,
     & 0.78114635d0, 0.78373033d0, 0.78645384d0, 0.78919101d0,
     & 0.79180467d0, 0.79442471d0, 0.79707593d0, 0.79975700d0,
     & 0.80244148d0, 0.80512893d0, 0.80789787d0, 0.81072062d0,
     & 0.81351912d0, 0.81617051d0, 0.81885487d0, 0.82144862d0,
     & 0.82411569d0, 0.82686150d0, 0.82958865d0, 0.83235049d0,
     & 0.83510917d0, 0.83779460d0, 0.84048480d0, 0.84336531d0,
     & 0.84616965d0, 0.84892511d0, 0.85178840d0, 0.85457253d0,
     & 0.85727358d0, 0.85999036d0, 0.86262071d0, 0.86535257d0,
     & 0.86809820d0, 0.87085259d0, 0.87348115d0, 0.87619454d0,
     & 0.87891173d0, 0.88160640d0, 0.88430387d0, 0.88700420d0,
     & 0.88984054d0, 0.89272809d0, 0.89549106d0, 0.89823598d0,
     & 0.90096855d0, 0.90358454d0, 0.90629649d0, 0.90902400d0,
     & 0.91176069d0, 0.91450417d0, 0.91725314d0, 0.91987318d0,
     & 0.92249757d0, 0.92520636d0, 0.92791760d0, 0.93073916d0,
     & 0.93364275d0, 0.93631089d0, 0.93909377d0, 0.94186437d0,
     & 0.94454545d0, 0.94734502d0, 0.95016146d0, 0.95298809d0,
     & 0.95568264d0, 0.95841187d0, 0.96103841d0, 0.96372467d0,
     & 0.96654874d0, 0.96924168d0, 0.97190970d0, 0.97466099d0,
     & 0.97726142d0, 0.97989547d0, 0.98254371d0, 0.98521405d0,
     & 0.98784941d0, 0.99053270d0, 0.99318898d0, 0.99586052d0,
     & 0.99854320d0, 1.00123298d0, 1.00390124d0, 1.00660288d0,
     & 1.00922775d0, 1.01183057d0, 1.01449144d0, 1.01715505d0,
     & 1.01976788d0, 1.02243316d0, 1.02508199d0, 1.02766490d0,
     & 1.03026760d0, 1.03289127d0, 1.03555942d0, 1.03825390d0,
     & 1.04096448d0, 1.04368556d0, 1.04635704d0, 1.04903555d0,
     & 1.05163646d0, 1.05424261d0, 1.05687952d0, 1.05951989d0,
     & 1.06216347d0, 1.06475925d0, 1.06735408d0, 1.06990290d0,
     & 1.07243967d0, 1.07499719d0, 1.07754695d0, 1.08009124d0,
     & 1.08277678d0, 1.08551371d0, 1.08823407d0, 1.09093511d0,
     & 1.09361506d0, 1.09630156d0, 1.09902096d0, 1.10171664d0,
     & 1.10444379d0, 1.10717440d0, 1.10990810d0, 1.11246991d0,
     & 1.11500669d0, 1.11755800d0, 1.12012815d0, 1.12271810d0,
     & 1.12527299d0, 1.12793219d0, 1.13064158d0, 1.13337994d0,
     & 1.13607287d0, 1.13877761d0, 1.14151895d0, 1.14426625d0,
     & 1.14702058d0, 1.14977920d0, 1.15251386d0, 1.15527987d0,
     & 1.15793872d0, 1.16057348d0, 1.16314912d0, 1.16576874d0,
     & 1.16834736d0, 1.17091632d0, 1.17347836d0, 1.17600548d0,
     & 1.17852759d0, 1.18110931d0, 1.18370020d0, 1.18643463d0,
     & 1.18917930d0, 1.19193065d0, 1.19465923d0, 1.19742143d0,
     & 1.20018828d0, 1.20294499d0, 1.20569038d0, 1.20842731d0,
     & 1.21113336d0, 1.21383047d0, 1.21638465d0, 1.21890080d0,
     & 1.22143936d0, 1.22400165d0, 1.22655928d0, 1.22911298d0,
     & 1.23182273d0, 1.23460472d0, 1.23741484d0, 1.24020493d0,
     & 1.24294400d0, 1.24569058d0, 1.24847150d0, 1.25125754d0,
     & 1.25404787d0, 1.25684202d0, 1.25961125d0, 1.26223898d0,
     & 1.26483774d0, 1.26736343d0, 1.26990771d0, 1.27250123d0,
     & 1.27511609d0, 1.27769613d0, 1.28027081d0, 1.28295338d0,
     & 1.28570914d0, 1.28848314d0, 1.29127049d0, 1.29400885d0,
     & 1.29681194d0, 1.29962313d0, 1.30244148d0, 1.30517745d0,
     & 1.30794632d0, 1.31071913d0, 1.31341159d0, 1.31597245d0,
     & 1.31854296d0, 1.32107091d0, 1.32367611d0, 1.32627308d0,
     & 1.32886171d0, 1.33141589d0, 1.33402216d0, 1.33662498d0,
     & 1.33919573d0, 1.34180498d0, 1.34462368d0, 1.34745407d0,
     & 1.35032201d0, 1.35313857d0, 1.35590208d0, 1.35867119d0,
     & 1.36147249d0, 1.36427999d0, 1.36709023d0, 1.36993206d0,
     & 1.37267745d0, 1.37527072d0, 1.37785220d0, 1.38042462d0,
     & 1.38296258d0, 1.38555372d0, 1.38811076d0, 1.39066398d0,
     & 1.39321196d0, 1.39575636d0, 1.39853823d0, 1.40136480d0,
     & 1.40420246d0, 1.40704882d0, 1.40984225d0, 1.41266966d0,
     & 1.41550255d0, 1.41836894d0, 1.42123854d0, 1.42411327d0,
     & 1.42699170d0, 1.42960513d0, 1.43220508d0, 1.43473577d0,
     & 1.43726039d0, 1.43983901d0, 1.44241345d0, 1.44498372d0,
     & 1.44755042d0, 1.45011544d0, 1.45267689d0, 1.45525551d0,
     & 1.45790184d0, 1.46056664d0, 1.46327305d0, 1.46598911d0,
     & 1.46871376d0, 1.47147572d0, 1.47421372d0, 1.47710514d0,
     & 1.48000062d0, 1.48287010d0, 1.48572350d0, 1.48850882d0,
     & 1.49127328d0, 1.49405694d0, 1.49680102d0, 1.49953687d0,
     & 1.50226450d0, 1.50495851d0, 1.50747061d0, 1.50997925d0,
     & 1.51251411d0, 1.51508832d0, 1.51773572d0, 1.52040505d0,
     & 1.52305567d0, 1.52593076d0, 1.52881277d0, 1.53158009d0,
     & 1.53447115d0, 1.53739572d0, 1.54023528d0, 1.54304922d0,
     & 1.54582465d0, 1.54852748d0, 1.55121040d0, 1.55388212d0,
     & 1.55635929d0, 1.55880094d0, 1.56135786d0, 1.56382060d0,
     & 1.56627893d0, 1.56879354d0, 1.57133281d0, 1.57392824d0,
     & 1.57643270d0, 1.57914293d0, 1.58187032d0, 1.58454883d0,
     & 1.58723760d0, 1.58990562d0, 1.59276247d0, 1.59562719d0,
     & 1.59852636d0, 1.60140181d0, 1.60410261d0, 1.60692382d0,
     & 1.60951066d0, 1.61217153d0, 1.61488175d0, 1.61758220d0,
     & 1.62024510d0, 1.62271941d0, 1.62518692d0, 1.62762034d0,
     & 1.63005054d0, 1.63259649d0, 1.63514042d0, 1.63771081d0,
     & 1.64018857d0, 1.64271426d0, 1.64527524d0, 1.64791834d0,
     & 1.65057421d0, 1.65324080d0, 1.65591538d0, 1.65862906d0,
     & 1.66144097d0, 1.66422808d0, 1.66711044d0, 1.67002416d0,
     & 1.67283320d0, 1.67563605d0, 1.67832947d0, 1.68107021d0,
     & 1.68380129d0, 1.68655467d0, 1.68929911d0, 1.69191658d0,
     & 1.69447124d0, 1.69693160d0, 1.69936085d0, 1.70184553d0,
     & 1.70429981d0, 1.70683908d0, 1.70938182d0, 1.71197557d0,
     & 1.71455896d0, 1.71714723d0, 1.71978056d0, 1.72248244d0,
     & 1.72519386d0, 1.72791255d0, 1.73060811d0, 1.73333991d0,
     & 1.73607826d0, 1.73884737d0, 1.74156821d0, 1.74427247d0,
     & 1.74709582d0, 1.74984634d0, 1.75261939d0, 1.75526416d0,
     & 1.75796473d0, 1.76066077d0, 1.76335180d0, 1.76600885d0,
     & 1.76857209d0, 1.77113235d0, 1.77371967d0, 1.77618301d0,
     & 1.77872670d0, 1.78131151d0, 1.78400540d0, 1.78668392d0,
     & 1.78937268d0, 1.79207158d0, 1.79477751d0, 1.79751873d0,
     & 1.80023563d0, 1.80296028d0, 1.80578136d0, 1.80870295d0,
     & 1.81158650d0, 1.81445289d0, 1.81718421d0, 1.81990647d0,
     & 1.82261968d0, 1.82544649d0, 1.82826841d0, 1.83099639d0,
     & 1.83368778d0, 1.83628368d0, 1.83872747d0, 1.84116697d0,
     & 1.84363437d0, 1.84618998d0, 1.84877360d0, 1.85140288d0,
     & 1.85386705d0, 1.85635507d0, 1.85897863d0, 1.86164427d0,
     & 1.86431956d0, 1.86702907d0, 1.86946642d0, 1.87216198d0,
     & 1.87495422d0, 1.87732100d0, 1.88025475d0, 1.88299441d0,
     & 1.88571262d0, 1.88838625d0, 1.89117002d0, 1.89394522d0,
     & 1.89677751d0, 1.89976299d0, 1.90248919d0, 1.90511966d0,
     & 1.90820861d0, 1.91065395d0, 1.91336775d0, 1.91607845d0,
     & 1.91878700d0, 1.92137241d0, 1.92395341d0, 1.92651451d0,
     & 1.92921758d0, 1.93190515d0, 1.93463528d0, 1.93734348d0,
     & 1.94005847d0, 1.94274974d0, 1.94547677d0, 1.94824183d0,
     & 1.95098114d0, 1.95372760d0, 1.95643651d0, 1.95909512d0,
     & 1.96177328d0, 1.96444082d0, 1.96703935d0, 1.96966243d0,
     & 1.97231066d0, 1.97489440d0, 1.97747147d0, 1.98022556d0,
     & 1.98294604d0, 1.98575282d0, 1.98843729d0, 1.99129641d0,
     & 1.99400544d0, 1.99683666d0, 1.99972391d0, 2.00249624d0,
     & 2.00532126d0, 2.00816250d0, 2.01086593d0, 2.01357746d0,
     & 2.01614475d0, 2.01886988d0, 2.02136230d0, 2.02397728d0,
     & 2.02653456d0, 2.02903652d0, 2.03165865d0, 2.03422976d0,
     & 2.03677702d0, 2.03931761d0, 2.04218984d0, 2.04511952d0,
     & 2.04801321d0, 2.05081105d0, 2.05363607d0, 2.05646014d0,
     & 2.05922103d0, 2.06197953d0, 2.06473708d0, 2.06750298d0,
     & 2.07023406d0, 2.07253313d0, 2.07483101d0, 2.07715988d0,
     & 2.07967353d0, 2.08233237d0, 2.08497334d0, 2.08769155d0,
     & 2.09041858d0, 2.09324646d0, 2.09592581d0, 2.09861135d0,
     & 2.10142636d0, 2.10434079d0, 2.10713363d0, 2.10989928d0,
     & 2.11251998d0, 2.11516142d0, 2.11788321d0, 2.12059569d0,
     & 2.12320876d0, 2.12597203d0, 2.12863898d0, 2.13139200d0,
     & 2.13392520d0, 2.13657904d0, 2.13919926d0, 2.14209127d0,
     & 2.14497757d0, 2.14749670d0, 2.15001106d0, 2.15255642d0,
     & 2.15503955d0, 2.15761018d0, 2.16022134d0, 2.16299033d0,
     & 2.16574621d0, 2.16844821d0, 2.17085910d0, 2.17328286d0,
     & 2.17598939d0, 2.17867541d0, 2.18136668d0, 2.18409371d0,
     & 2.18695402d0, 2.18968272d0, 2.19238162d0, 2.19518876d0,
     & 2.19805169d0, 2.20074749d0, 2.20343566d0, 2.20611572d0,
     & 2.20879030d0, 2.21145868d0, 2.21415377d0, 2.21674967d0,
     & 2.21946383d0, 2.22217464d0, 2.22475910d0, 2.22737169d0,
     & 2.23013926d0, 2.23278022d0, 2.23550987d0, 2.23844743d0,
     & 2.24123430d0, 2.24418402d0, 2.24715424d0, 2.24978447d0,
     & 2.25243163d0, 2.25509071d0, 2.25776243d0, 2.26047492d0,
     & 2.26331758d0, 2.26607680d0, 2.26856852d0, 2.27118397d0,
     & 2.27364063d0, 2.27608037d0, 2.27868152d0, 2.28126645d0,
     & 2.28384185d0, 2.28643823d0, 2.28899598d0, 2.29154730d0,
     & 2.29409289d0, 2.29682112d0, 2.29957628d0, 2.30226588d0,
     & 2.30492091d0, 2.30781889d0, 2.31068301d0, 2.31357527d0,
     & 2.31628084d0, 2.31898499d0, 2.32168651d0, 2.32438636d0,
     & 2.32711387d0, 2.32995605d0, 2.33282018d0, 2.33587480d0,
     & 2.33875895d0, 2.34141946d0, 2.34409285d0, 2.34692645d0,
     & 2.34980226d0, 2.35265374d0, 2.35551190d0, 2.35825467d0,
     & 2.36088657d0, 2.36356115d0, 2.36607957d0, 2.36846232d0,
     & 2.37122703d0, 2.37395167d0, 2.37667251d0, 2.37916350d0,
     & 2.38168120d0, 2.38466692d0, 2.38733792d0, 2.39000630d0,
     & 2.39264178d0, 2.39527535d0, 2.39803267d0, 2.40063286d0,
     & 2.40326166d0, 2.40588808d0, 2.40870309d0, 2.41151690d0,
     & 2.41382670d0, 2.41644931d0, 2.41923571d0, 2.42209029d0,
     & 2.42493248d0, 2.42779207d0, 2.43089437d0, 2.43397307d0,
     & 2.43721747d0, 2.44066048d0, 2.44451404d0, 2.44862270d0,
     & 2.45156980d0, 2.45410299d0, 2.45660305d0, 2.45908785d0,
     & 2.46155906d0, 2.46379018d0, 2.46604824d0, 2.46814346d0,
     & 2.47013569d0, 2.47172022d0, 2.47320628d0, 2.47585249d0,
     & 2.47890377d0, 2.48148632d0, 2.48409700d0, 2.48667336d0,
     & 2.48927832d0, 2.49194193d0, 2.49457192d0, 2.49713731d0,
     & 2.49970055d0, 2.50232196d0, 2.50488067d0, 2.50760174d0,
     & 2.51082587d0, 2.51407266d0, 2.51733279d0, 2.52060676d0,
     & 2.52383018d0, 2.52706122d0, 2.53030086d0, 2.53364468d0,
     & 2.53681016d0, 2.53946352d0, 2.54189968d0, 2.54430604d0,
     & 2.54669380d0, 2.54910302d0, 2.55150175d0, 2.57929897d0,
     & 2.58155823d0, 2.58381176d0, 2.58596420d0, 2.58808184d0,
     & 2.59077525d0, 2.59333801d0, 2.59589314d0, 2.59844422d0,
     & 2.60096097d0, 2.60359859d0, 2.58082700d0, 2.58358574d0
     &/
      DATA (Imax ( 8,I), I= 1001, 2100) /
     & 2.58649611d0, 2.58928061d0, 2.59371424d0, 2.59814811d0,
     & 2.60238743d0, 2.60516453d0, 2.60793972d0, 2.61074471d0,
     & 2.61390233d0, 2.61728001d0, 2.62140751d0, 2.62542152d0,
     & 2.62956476d0, 2.63206100d0, 2.63346744d0, 2.63477802d0,
     & 2.63755822d0, 2.64057279d0, 2.64378452d0, 2.64741468d0,
     & 2.65082693d0, 2.65352297d0, 2.65500474d0, 2.65645266d0,
     & 2.65793014d0, 2.66049743d0, 2.66338658d0, 2.66626859d0,
     & 2.66932440d0, 2.67216849d0, 2.68313050d0, 2.69410253d0,
     & 2.69667721d0, 2.69906354d0, 2.70147920d0, 2.70401692d0,
     & 2.70688987d0, 2.70976424d0, 2.72226453d0, 2.73436403d0,
     & 2.74601197d0, 2.74862170d0, 2.75122499d0, 2.75285053d0,
     & 2.75593066d0, 2.76812053d0, 2.77079511d0, 2.77316594d0,
     & 2.77555490d0, 2.76895308d0, 2.76359677d0, 2.75870967d0,
     & 2.75359869d0, 2.74848461d0, 2.75250053d0, 2.75619984d0,
     & 2.75012779d0, 2.75379848d0, 2.75655198d0, 2.75966930d0,
     & 2.76215410d0, 2.76335883d0, 2.76456356d0, 2.76566982d0,
     & 2.76674438d0, 2.76806474d0, 2.76961112d0, 2.77178955d0,
     & 2.77361798d0, 2.77633238d0, 2.77863169d0, 2.78255796d0,
     & 2.78655934d0, 2.79058337d0, 2.79497433d0, 2.79913187d0,
     & 2.80211639d0, 2.80503678d0, 2.80761433d0, 2.81037664d0,
     & 2.81295133d0, 2.81543207d0, 2.81621671d0, 2.81988406d0,
     & 2.82362461d0, 2.82832503d0, 2.82980061d0, 2.83245969d0,
     & 2.83515811d0, 2.84353161d0, 2.84643388d0, 2.84949708d0,
     & 2.85269117d0, 2.85637450d0, 2.85842705d0, 2.86013150d0,
     & 2.86085892d0, 2.86482382d0, 2.86874628d0, 2.87193847d0,
     & 2.86938834d0, 2.87212539d0, 2.88016367d0, 2.88820052d0,
     & 2.89556623d0, 2.89660788d0, 2.89790034d0, 2.89916086d0,
     & 2.90067196d0, 2.90190077d0, 2.90388322d0, 2.90630627d0,
     & 2.92644143d0, 2.92558599d0, 2.92473841d0, 2.92414975d0,
     & 2.92859721d0, 2.93305206d0, 2.93730330d0, 2.94157124d0,
     & 2.94588614d0, 2.95020723d0, 2.95427299d0, 2.93936706d0,
     & 2.94020200d0, 2.94131875d0, 2.94246888d0, 2.94371724d0,
     & 2.94496417d0, 2.94645166d0, 2.96504879d0, 2.98392344d0,
     & 3.00280356d0, 3.02195573d0, 3.04227567d0, 3.06225562d0,
     & 3.08195877d0, 3.10162902d0, 3.10866547d0, 3.11279511d0,
     & 3.11950493d0, 3.10653591d0, 3.09330583d0, 3.08006477d0,
     & 3.06652236d0, 3.05307102d0, 3.03968430d0, 3.02529049d0,
     & 3.01088142d0, 3.02644849d0, 3.04491854d0, 3.06021285d0,
     & 3.06116962d0, 3.07950997d0, 3.09785843d0, 3.09934664d0,
     & 3.11761308d0, 3.13610601d0, 3.15559816d0, 3.15884185d0,
     & 3.14465618d0, 3.13019991d0, 3.12097001d0, 3.12863302d0,
     & 3.11881924d0, 3.10899901d0, 3.11632562d0, 3.10653114d0,
     & 3.09675670d0, 3.09294033d0, 3.10540318d0, 3.10830140d0,
     & 3.11147141d0, 3.11000824d0, 3.10855103d0, 3.10743904d0,
     & 3.10632777d0, 3.10701489d0, 3.11133862d0, 3.11820388d0,
     & 3.12005019d0, 3.28340507d0, 3.30351686d0, 3.25803089d0,
     & 3.20095658d0, 3.28746581d0, 3.32239246d0, 3.30733061d0,
     & 3.32667279d0, 3.34439921d0, 3.37336564d0, 3.41600871d0,
     & 3.44315815d0, 3.47178674d0, 3.50092912d0, 3.52471256d0,
     & 3.55223584d0, 3.58372760d0, 3.61123562d0, 3.63609529d0,
     & 3.66381240d0, 3.69138336d0, 3.70460606d0, 3.73316455d0,
     & 3.75957227d0, 3.78856826d0, 3.81692457d0, 3.84287715d0,
     & 3.87221432d0, 3.89224315d0, 3.91745043d0, 3.94559884d0,
     & 3.97369456d0, 4.00233936d0, 4.02915907d0, 4.05698299d0,
     & 4.08610439d0, 4.11347103d0, 4.15176725d0, 4.18061399d0,
     & 4.20918512d0, 4.23769188d0, 4.26683617d0, 4.29493761d0,
     & 4.32364464d0, 4.35278559d0, 4.38112926d0, 4.40955162d0,
     & 4.43826962d0, 4.46611786d0, 4.49435091d0, 4.52432394d0,
     & 4.55319929d0, 4.58598804d0, 4.61615944d0, 4.64589691d0,
     & 4.67546654d0, 4.70637608d0, 4.73609734d0, 4.76520538d0,
     & 4.79502201d0, 4.82112265d0, 4.85970259d0, 4.89050436d0,
     & 4.91970539d0, 4.95482302d0, 4.99345207d0, 5.02047443d0,
     & 5.05275726d0, 5.06849575d0, 5.09631395d0, 5.13293457d0,
     & 5.16164017d0, 5.18147850d0, 5.20624733d0, 5.23133707d0,
     & 5.27038050d0, 5.30241346d0, 5.32038307d0, 5.34715891d0,
     & 5.37830019d0, 5.40810251d0, 5.43579292d0, 5.46418667d0,
     & 5.49312496d0, 5.52458954d0, 5.55506229d0, 5.57991791d0,
     & 5.61281824d0, 5.64326954d0, 5.67173576d0, 5.69668818d0,
     & 5.72363663d0, 5.75022888d0, 5.77755690d0, 5.81174135d0,
     & 5.83936357d0, 5.86662960d0, 5.89343500d0, 5.90947294d0,
     & 5.93644619d0, 5.96588993d0, 5.99246931d0, 6.02283001d0,
     & 6.05206251d0, 6.07903004d0, 6.10674620d0, 6.13717890d0,
     & 6.16758108d0, 6.19823742d0, 6.22468567d0, 6.24949265d0,
     & 6.27696133d0, 6.30754852d0, 6.33704710d0, 6.36324883d0,
     & 6.39104271d0, 6.42165136d0, 6.45326328d0, 6.48195839d0,
     & 6.49976873d0, 6.53735018d0, 6.56435442d0, 6.59529781d0,
     & 6.62249756d0, 6.65242720d0, 6.68044472d0, 6.71406651d0,
     & 6.74437380d0, 6.77144527d0, 6.79840565d0, 6.82595634d0,
     & 6.85268450d0, 6.88222790d0, 6.90901852d0, 6.93780184d0,
     & 6.96468878d0, 6.99533510d0, 7.02145863d0, 7.05682230d0,
     & 7.08577871d0, 7.11804342d0, 7.14508152d0, 7.17345142d0,
     & 7.20360661d0, 7.23002148d0, 7.25830126d0, 7.28253412d0,
     & 7.30729771d0, 7.33155775d0, 7.35783243d0, 7.38507891d0,
     & 7.41130114d0, 7.44072676d0, 7.47144032d0, 7.49925470d0,
     & 7.52542639d0, 7.55201292d0, 7.58066607d0, 7.60992098d0,
     & 7.63904905d0, 7.67004871d0, 7.69965458d0, 7.72763491d0,
     & 7.75643015d0, 7.78692007d0, 7.81410503d0, 7.84363461d0,
     & 7.87074327d0, 7.89980888d0, 7.92853403d0, 7.95489693d0,
     & 7.98183775d0, 8.01238537d0, 8.03966236d0, 8.06631088d0,
     & 8.09746838d0, 8.12412262d0, 8.15621948d0, 8.18495941d0,
     & 8.21105671d0, 8.23693943d0, 8.26399612d0, 8.29317570d0,
     & 8.31950951d0, 8.34725380d0, 8.37731361d0, 8.40145779d0,
     & 8.42602062d0, 8.45257950d0, 8.47932148d0, 8.50601768d0,
     & 8.53416538d0, 8.56126976d0, 8.58625317d0, 8.61229420d0,
     & 8.63841057d0, 8.66426182d0, 8.69231129d0, 8.72077465d0,
     & 8.74874306d0, 8.77468872d0, 8.80449772d0, 8.83110237d0,
     & 8.86013412d0, 8.88676071d0, 8.91487694d0, 8.94666100d0,
     & 8.97302246d0, 8.99868488d0, 9.02593994d0, 9.05338383d0,
     & 9.08123398d0, 9.11267090d0, 9.14309978d0, 9.17169952d0,
     & 9.20191002d0, 9.23213005d0, 9.26158047d0, 9.28880215d0,
     & 9.31814384d0, 9.34757614d0, 9.37773514d0, 9.40694332d0,
     & 9.43536949d0, 9.46360207d0, 9.49179077d0, 9.51929665d0,
     & 9.54490566d0, 9.57080746d0, 9.59715652d0, 9.62205124d0,
     & 9.64735985d0, 9.67220688d0, 9.69719791d0, 9.72354984d0,
     & 9.75062561d0, 9.77809238d0, 9.80449963d0, 9.82834339d0,
     & 9.85773754d0, 9.88659000d0, 9.91656303d0, 9.94386864d0,
     & 9.97158146d0,10.00121117d0,10.02534485d0,10.05653191d0,
     &10.08362293d0,10.11191177d0,10.13703823d0,10.16623306d0,
     &10.19730759d0,10.22589397d0,10.25345993d0,10.28215313d0,
     &10.30867863d0,10.33220577d0,10.35923100d0,10.38333702d0,
     &10.41095638d0,10.44011497d0,10.46786976d0,10.49201393d0,
     &10.51753902d0,10.54571247d0,10.57414150d0,10.60373402d0,
     &10.62972736d0,10.65636253d0,10.68251991d0,10.71261215d0,
     &10.73987103d0,10.76616478d0,10.79453278d0,10.82047558d0,
     &10.84779549d0,10.87398243d0,10.90141296d0,10.92844963d0,
     &10.95695496d0,10.98393536d0,11.01194668d0,11.03805923d0,
     &11.06498432d0,11.09350491d0,11.12161446d0,11.14829159d0,
     &11.17498684d0,11.20201302d0,11.23093414d0,11.26182747d0,
     &11.28978634d0,11.31949902d0,11.34767818d0,11.37661076d0,
     &11.40348816d0,11.43102264d0,11.45980072d0,11.48678970d0,
     &11.51537514d0,11.54472733d0,11.57648849d0,11.60365677d0,
     &11.63445091d0,11.65927982d0,11.68849468d0,11.71332455d0,
     &11.74032402d0,11.76595974d0,11.79269028d0,11.82039833d0,
     &11.84526920d0,11.87727165d0,11.90538406d0,11.93394375d0,
     &11.96102142d0,11.99047184d0,12.02111912d0,12.04959679d0,
     &12.07759190d0,12.10373974d0,12.12659454d0,12.15318203d0,
     &12.17603397d0,12.20437431d0,12.23088360d0,12.25776958d0,
     &12.28219986d0,12.30691433d0,12.33442020d0,12.36348915d0,
     &12.39439869d0,12.42022038d0,12.44879627d0,12.47946167d0,
     &12.51155949d0,12.54010391d0,12.56677914d0,12.59478283d0,
     &12.62077713d0,12.65200424d0,12.68270493d0,12.71060848d0,
     &12.73795795d0,12.76726437d0,12.79552841d0,12.82467079d0,
     &12.85195732d0,12.88103485d0,12.90696430d0,12.93163681d0,
     &12.96252251d0,12.99381733d0,13.02441406d0,13.05371284d0,
     &13.07925987d0,13.10581684d0,13.12926483d0,13.16054630d0,
     &13.19154167d0,13.22192478d0,13.24628448d0,13.27085781d0,
     &13.29506397d0,13.32054234d0,13.35205555d0,13.38606548d0,
     &13.41199207d0,13.43531895d0,13.46278954d0,13.49239445d0,
     &13.51900768d0,13.54380989d0,13.57491207d0,13.60443306d0,
     &13.63426208d0,13.66653061d0,13.69392204d0,13.72183132d0,
     &13.75165653d0,13.77982998d0,13.81079483d0,13.83996391d0,
     &13.86680317d0,13.89383698d0,13.92464733d0,13.95243740d0,
     &13.98310566d0,14.01121807d0,14.04048347d0,14.07061958d0,
     &14.09994507d0,14.12697601d0,14.15575600d0,14.18167591d0,
     &14.20795155d0,14.23659325d0,14.26135445d0,14.28980446d0,
     &14.31761360d0,14.34641075d0,14.37462425d0,14.39999104d0,
     &14.42888546d0,14.45350742d0,14.48087215d0,14.50764561d0,
     &14.53621197d0,14.56564617d0,14.59619808d0,14.62737656d0,
     &14.65795803d0,14.68664551d0,14.71469021d0,14.74598885d0,
     &14.77492237d0,14.80295753d0,14.82935810d0,14.85347843d0,
     &14.88351250d0,14.91250992d0,14.94238281d0,14.97259808d0,
     &15.00668430d0,15.03575134d0,15.06214428d0,15.08577061d0,
     &15.11795902d0,15.14511299d0,15.17221928d0,15.20248032d0,
     &15.23659992d0,15.26033211d0,15.28764534d0,15.31327152d0,
     &15.33756256d0,15.36376572d0,15.39150715d0,15.42218590d0,
     &15.44882965d0,15.47744370d0,15.50485992d0,15.53758049d0,
     &15.57149887d0,15.59991264d0,15.62833214d0,15.65513134d0,
     &15.68295479d0,15.71126270d0,15.74488068d0,15.77718258d0,
     &15.80635834d0,15.83517456d0,15.86495781d0,15.89831448d0,
     &15.93435287d0,15.96344090d0,15.99223614d0,16.02298927d0,
     &16.04878235d0,16.07682037d0,16.10393524d0,16.13031387d0,
     &16.15804482d0,16.18337631d0,16.21238327d0,16.24399757d0,
     &16.27485847d0,16.30442810d0,16.33555031d0,16.36484909d0,
     &16.39057350d0,16.41927147d0,16.44749451d0,16.47366905d0,
     &16.49930954d0,16.53074837d0,16.56281853d0,16.59240341d0,
     &16.62133217d0,16.65300751d0,16.68464279d0,16.71524429d0,
     &16.74168396d0,16.77002716d0,16.79796600d0,16.83402634d0,
     &16.86239052d0,16.88932228d0,16.91665459d0,16.94894600d0,
     &16.97964287d0,17.00904655d0,17.04091263d0,17.07039642d0,
     &17.09996796d0,17.13081741d0,17.15894318d0,17.18905067d0,
     &17.22332382d0,17.25417137d0,17.28440857d0,17.31323051d0,
     &17.34584618d0,17.37549210d0,17.40354919d0,17.43444252d0,
     &17.46170616d0,17.49026489d0,17.51954269d0,17.54959106d0,
     &17.57727242d0,17.60790634d0,17.63581085d0,17.66492462d0,
     &17.69477081d0,17.72691536d0,17.75757980d0,17.78709602d0,
     &17.81778717d0,17.84786415d0,17.87672043d0,17.90548897d0,
     &17.94045448d0,17.96475410d0,17.99524307d0,18.02987671d0,
     &18.06265068d0,18.09713936d0,18.12587547d0,18.15439224d0,
     &18.18819618d0,18.22151947d0,18.25421906d0,18.29150963d0,
     &18.32375336d0,18.35341072d0,18.38365173d0,18.41280174d0,
     &18.44255447d0,18.47311020d0,18.50023842d0,18.52770615d0,
     &18.55702972d0,18.58375549d0,18.61508942d0,18.64957428d0,
     &18.68474197d0,18.71297646d0,18.74196434d0,18.77092361d0,
     &18.80181885d0,18.83455086d0,18.86502266d0,18.90069008d0,
     &18.93428230d0,18.96357727d0,18.99461555d0,19.02516747d0,
     &19.05925179d0,19.08897972d0,19.12032700d0,19.15447235d0,
     &19.18354607d0,19.21149063d0,19.24421883d0,19.27451706d0,
     &19.30072403d0,19.33167648d0,19.36084557d0,19.39211655d0,
     &19.42392921d0,19.45919991d0,19.49233818d0,19.52915764d0,
     &19.55592918d0,19.58664894d0,19.62367630d0,19.64710617d0,
     &19.67852974d0,19.71267891d0,19.74602509d0,19.77972984d0,
     &19.80564499d0,19.83333588d0,19.86229897d0,19.89051056d0,
     &19.92963028d0,19.97196388d0,19.99578857d0,20.02711678d0,
     &20.04983521d0,20.07843590d0,20.10476303d0,20.13525200d0,
     &20.16650200d0,20.20244598d0,20.23899841d0,20.26773071d0,
     &20.29848671d0,20.33367157d0,20.36926460d0,20.40013885d0,
     &20.43267250d0,20.46618652d0,20.49407387d0,20.53801727d0,
     &20.58140564d0,20.61592865d0,20.64901352d0,20.68056297d0,
     &20.70819473d0,20.74085617d0,20.77358055d0,20.80476952d0,
     &20.84216499d0,20.88212776d0,20.90638161d0,20.94768524d0,
     &20.97987938d0,21.01396942d0,21.05603981d0,21.09086037d0,
     &21.12206078d0,21.15447235d0,21.18617058d0,21.21777344d0,
     &21.25606537d0,21.28475380d0,21.31718063d0,21.34537315d0,
     &21.38105202d0,21.40752220d0,21.43780136d0,21.47078705d0,
     &21.49940491d0,21.53136253d0,21.57523346d0,21.61225128d0,
     &21.64424896d0,21.68079185d0,21.71384239d0,21.74572563d0,
     &21.77952576d0,21.81382179d0,21.84786034d0,21.88396263d0,
     &21.92167282d0,21.95765305d0,21.99159622d0,22.02913666d0,
     &22.06765175d0,22.10497856d0,22.13875008d0,22.18231964d0,
     &22.21715736d0,22.25738716d0,22.29369354d0,22.32745361d0,
     &22.35873985d0,22.39637375d0,22.43532372d0,22.46724510d0,
     &22.49674988d0,22.53569794d0,22.57121468d0,22.60834122d0,
     &22.64982796d0,22.68693352d0,22.72081184d0,22.75684547d0,
     &22.79677773d0,22.83132362d0,22.88305473d0,22.91228676d0,
     &22.94226074d0,22.97503471d0,23.00414848d0,23.03957176d0,
     &23.07307053d0,23.10594177d0,23.14613152d0,23.18113899d0,
     &23.22040749d0,23.25809479d0,23.30614090d0,23.35094643d0,
     &23.38381004d0,23.41456413d0,23.45574951d0,23.49885750d0,
     &23.53471756d0,23.56781578d0,23.60188675d0,23.63611031d0,
     &23.67844772d0,23.72603035d0,23.75577354d0,23.79738998d0,
     &23.83519745d0,23.87243843d0,23.90759850d0,23.94725609d0,
     &23.98085022d0,24.01830673d0,24.05090141d0,24.08300018d0,
     &24.11916924d0,24.16281700d0,24.19471359d0,24.23019028d0,
     &24.14532661d0,23.79391479d0,23.27490807d0,22.67381477d0,
     &22.01663399d0,21.23983002d0,20.44258881d0,19.62426949d0,
     &18.80102921d0,17.80700493d0,16.64949608d0,15.74592113d0,
     &15.10667706d0,14.58739662d0,14.15201473d0,13.76772308d0,
     &13.42796707d0,13.11861801d0,12.84183502d0,12.57677555d0,
     &12.33994961d0,12.11524391d0,16.66441154d0,16.66327477d0,
     &16.66327477d0,16.66327477d0,16.66554642d0,16.66895294d0,
     &16.66781807d0,16.66668320d0,16.66668320d0,16.67008972d0,
     &16.66781807d0,10.16553020d0,10.04345989d0, 9.92661572d0,
     & 9.81145573d0, 9.70094681d0, 9.59314251d0, 9.48975086d0,
     & 9.38983250d0, 9.29214573d0, 9.19544315d0, 9.10232639d0,
     &16.05520630d0, 9.29215431d0,16.09929276d0,16.63634300d0,
     &16.63749123d0,16.63519478d0,16.63864136d0,16.64438248d0,
     &16.65066719d0,16.65183830d0,16.64832687d0,16.64438248d0,
     &16.64438248d0,16.64949608d0,16.64438248d0,16.64832687d0,
     &16.64832687d0,16.64438248d0,16.63864136d0,16.63634300d0,
     &16.63519478d0,16.63519478d0,16.09929276d0, 9.29215431d0,
     & 9.19544792d0, 9.10232639d0, 8.83942604d0, 9.10232639d0,
     & 8.92551327d0, 9.19544792d0, 9.29215431d0,16.05520630d0,
     &16.63634300d0,16.63864136d0,16.64208603d0,16.63864136d0,
     &16.63864136d0,16.63634300d0,16.63634300d0,16.64093781d0,
     &16.64208603d0,16.63978958d0,16.63749123d0,16.63634300d0,
     &16.05520630d0, 9.10232639d0,16.09929276d0,16.63519478d0,
     &16.63749123d0,16.63519478d0, 9.19544792d0, 9.10232639d0,
     &16.09929276d0,16.63519478d0,16.09929276d0,16.09929276d0,
     &16.63749123d0,16.63749123d0,16.63749123d0,16.63864136d0,
     &16.63978958d0,16.64208603d0,16.64323425d0,16.63749123d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0,
     &16.09929276d0,16.09929276d0,16.09929276d0,16.09929276d0
     &/
c Definition of open field lines as Lupper=f(Iupper) for doy=211
      DATA (Lupper ( 8,I), I= 1, 1001) /
     & 9.07d0, 9.06d0, 9.06d0, 9.05d0, 9.05d0, 9.04d0, 9.04d0, 9.04d0,
     & 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0,
     & 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0,
     & 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0,
     & 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0,
     & 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0, 9.04d0,
     & 9.04d0, 9.04d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0,
     & 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0,
     & 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0,
     & 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0,
     & 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0,
     & 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0,
     & 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.05d0, 9.06d0, 9.06d0,
     & 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0,
     & 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0,
     & 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0,
     & 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0,
     & 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0,
     & 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0, 9.06d0,
     & 9.06d0, 9.06d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0,
     & 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0,
     & 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0,
     & 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0,
     & 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0,
     & 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0,
     & 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.07d0, 9.08d0, 9.08d0,
     & 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0,
     & 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0,
     & 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0,
     & 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0,
     & 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0,
     & 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0, 9.08d0,
     & 9.08d0, 9.08d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0,
     & 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0,
     & 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0,
     & 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0,
     & 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0,
     & 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0,
     & 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.09d0, 9.10d0, 9.10d0,
     & 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0,
     & 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0,
     & 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0,
     & 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0,
     & 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0,
     & 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0, 9.10d0,
     & 9.10d0, 9.10d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0,
     & 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0,
     & 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0,
     & 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0,
     & 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0,
     & 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0,
     & 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.11d0, 9.12d0,
     & 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0,
     & 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0,
     & 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0,
     & 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0,
     & 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0,
     & 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0, 9.12d0,
     & 9.12d0, 9.12d0, 9.12d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0,
     & 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0,
     & 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0,
     & 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0,
     & 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0,
     & 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0,
     & 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.13d0, 9.14d0,
     & 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0,
     & 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0,
     & 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0,
     & 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0,
     & 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0,
     & 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0, 9.14d0,
     & 9.14d0, 9.14d0, 9.14d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0,
     & 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0,
     & 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0,
     & 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0,
     & 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0,
     & 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0,
     & 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.15d0, 9.16d0,
     & 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0,
     & 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0,
     & 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0,
     & 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0,
     & 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0,
     & 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0, 9.16d0,
     & 9.16d0, 9.16d0, 9.16d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0,
     & 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0,
     & 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0,
     & 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0,
     & 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0,
     & 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0,
     & 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.17d0, 9.18d0,
     & 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0,
     & 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0,
     & 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0,
     & 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0,
     & 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0,
     & 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0, 9.18d0,
     & 9.18d0, 9.18d0, 9.18d0, 9.19d0, 9.19d0, 9.19d0, 9.19d0, 9.19d0,
     & 9.19d0, 9.19d0, 9.19d0, 9.19d0, 9.19d0, 9.19d0, 9.19d0, 9.19d0,
     & 9.20d0, 9.20d0, 9.21d0, 9.22d0, 9.23d0, 9.23d0, 9.24d0, 9.25d0,
     & 9.26d0, 9.27d0, 9.28d0, 9.28d0, 9.29d0, 9.30d0, 9.31d0, 9.32d0,
     & 9.33d0, 9.33d0, 9.34d0, 9.35d0, 9.36d0, 9.37d0, 9.37d0, 9.38d0,
     & 9.39d0, 9.40d0, 9.41d0, 9.42d0, 9.42d0, 9.43d0, 9.44d0, 9.45d0,
     & 9.46d0, 9.47d0, 9.47d0, 9.49d0, 9.51d0, 9.52d0, 9.54d0, 9.56d0,
     & 9.58d0, 9.60d0, 9.62d0, 9.63d0, 9.65d0, 9.67d0, 9.69d0, 9.71d0,
     & 9.73d0, 9.75d0, 9.77d0, 9.78d0, 9.80d0, 9.82d0, 9.84d0, 9.86d0,
     & 9.87d0, 9.89d0, 9.91d0, 9.93d0, 9.95d0, 9.97d0, 9.99d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,
     & 9.99d0,10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,10.00d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,10.00d0,
     &10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0,
     & 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     & 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0,
     &10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0
     &/
      DATA (Iupper ( 8,I), I= 1, 1001) /
     & 0.00010000d0, 0.00010127d0, 0.00010255d0, 0.00010386d0,
     & 0.00010517d0, 0.00010651d0, 0.00010786d0, 0.00010923d0,
     & 0.00011062d0, 0.00011202d0, 0.00011344d0, 0.00011488d0,
     & 0.00011634d0, 0.00011782d0, 0.00011931d0, 0.00012083d0,
     & 0.00012236d0, 0.00012391d0, 0.00012548d0, 0.00012708d0,
     & 0.00012869d0, 0.00013032d0, 0.00013198d0, 0.00013365d0,
     & 0.00013535d0, 0.00013707d0, 0.00013881d0, 0.00014057d0,
     & 0.00014235d0, 0.00014416d0, 0.00014599d0, 0.00014784d0,
     & 0.00014972d0, 0.00015162d0, 0.00015354d0, 0.00015549d0,
     & 0.00015746d0, 0.00015946d0, 0.00016148d0, 0.00016353d0,
     & 0.00016561d0, 0.00016771d0, 0.00016984d0, 0.00017200d0,
     & 0.00017418d0, 0.00017639d0, 0.00017863d0, 0.00018089d0,
     & 0.00018319d0, 0.00018551d0, 0.00018787d0, 0.00019025d0,
     & 0.00019267d0, 0.00019511d0, 0.00019759d0, 0.00020010d0,
     & 0.00020264d0, 0.00020521d0, 0.00020781d0, 0.00021045d0,
     & 0.00021312d0, 0.00021583d0, 0.00021857d0, 0.00022134d0,
     & 0.00022415d0, 0.00022699d0, 0.00022987d0, 0.00023279d0,
     & 0.00023575d0, 0.00023874d0, 0.00024177d0, 0.00024484d0,
     & 0.00024794d0, 0.00025109d0, 0.00025428d0, 0.00025750d0,
     & 0.00026077d0, 0.00026408d0, 0.00026743d0, 0.00027083d0,
     & 0.00027426d0, 0.00027775d0, 0.00028127d0, 0.00028484d0,
     & 0.00028846d0, 0.00029212d0, 0.00029582d0, 0.00029958d0,
     & 0.00030338d0, 0.00030723d0, 0.00031113d0, 0.00031508d0,
     & 0.00031908d0, 0.00032313d0, 0.00032723d0, 0.00033138d0,
     & 0.00033559d0, 0.00033984d0, 0.00034416d0, 0.00034853d0,
     & 0.00035295d0, 0.00035743d0, 0.00036196d0, 0.00036656d0,
     & 0.00037121d0, 0.00037592d0, 0.00038069d0, 0.00038552d0,
     & 0.00039042d0, 0.00039537d0, 0.00040039d0, 0.00040547d0,
     & 0.00041062d0, 0.00041583d0, 0.00042111d0, 0.00042645d0,
     & 0.00043186d0, 0.00043734d0, 0.00044289d0, 0.00044852d0,
     & 0.00045421d0, 0.00045997d0, 0.00046581d0, 0.00047172d0,
     & 0.00047771d0, 0.00048377d0, 0.00048991d0, 0.00049613d0,
     & 0.00050243d0, 0.00050880d0, 0.00051526d0, 0.00052180d0,
     & 0.00052842d0, 0.00053513d0, 0.00054192d0, 0.00054880d0,
     & 0.00055576d0, 0.00056281d0, 0.00056996d0, 0.00057719d0,
     & 0.00058452d0, 0.00059194d0, 0.00059945d0, 0.00060706d0,
     & 0.00061476d0, 0.00062256d0, 0.00063046d0, 0.00063846d0,
     & 0.00064657d0, 0.00065477d0, 0.00066308d0, 0.00067150d0,
     & 0.00068002d0, 0.00068865d0, 0.00069739d0, 0.00070624d0,
     & 0.00071521d0, 0.00072428d0, 0.00073347d0, 0.00074278d0,
     & 0.00075221d0, 0.00076176d0, 0.00077142d0, 0.00078122d0,
     & 0.00079113d0, 0.00080117d0, 0.00081134d0, 0.00082164d0,
     & 0.00083206d0, 0.00084262d0, 0.00085332d0, 0.00086415d0,
     & 0.00087511d0, 0.00088622d0, 0.00089747d0, 0.00090886d0,
     & 0.00092039d0, 0.00093207d0, 0.00094390d0, 0.00095588d0,
     & 0.00096801d0, 0.00098030d0, 0.00099274d0, 0.00100534d0,
     & 0.00101810d0, 0.00103102d0, 0.00104411d0, 0.00105736d0,
     & 0.00107078d0, 0.00108437d0, 0.00109813d0, 0.00111206d0,
     & 0.00112618d0, 0.00114047d0, 0.00115495d0, 0.00116960d0,
     & 0.00118445d0, 0.00119948d0, 0.00121470d0, 0.00123012d0,
     & 0.00124573d0, 0.00126154d0, 0.00127755d0, 0.00129377d0,
     & 0.00131019d0, 0.00132681d0, 0.00134365d0, 0.00136071d0,
     & 0.00137797d0, 0.00139546d0, 0.00141317d0, 0.00143111d0,
     & 0.00144927d0, 0.00146766d0, 0.00148629d0, 0.00150515d0,
     & 0.00152426d0, 0.00154360d0, 0.00156319d0, 0.00158303d0,
     & 0.00160312d0, 0.00162347d0, 0.00164407d0, 0.00166494d0,
     & 0.00168607d0, 0.00170747d0, 0.00172914d0, 0.00175108d0,
     & 0.00177331d0, 0.00179581d0, 0.00181860d0, 0.00184168d0,
     & 0.00186506d0, 0.00188873d0, 0.00191270d0, 0.00193697d0,
     & 0.00196156d0, 0.00198645d0, 0.00201166d0, 0.00203719d0,
     & 0.00206305d0, 0.00208923d0, 0.00211575d0, 0.00214260d0,
     & 0.00216979d0, 0.00219733d0, 0.00222521d0, 0.00225346d0,
     & 0.00228206d0, 0.00231102d0, 0.00234035d0, 0.00237005d0,
     & 0.00240013d0, 0.00243059d0, 0.00246144d0, 0.00249268d0,
     & 0.00252431d0, 0.00255635d0, 0.00258879d0, 0.00262165d0,
     & 0.00265492d0, 0.00268862d0, 0.00272274d0, 0.00275729d0,
     & 0.00279229d0, 0.00282773d0, 0.00286361d0, 0.00289996d0,
     & 0.00293676d0, 0.00297403d0, 0.00301178d0, 0.00305000d0,
     & 0.00308871d0, 0.00312791d0, 0.00316761d0, 0.00320781d0,
     & 0.00324852d0, 0.00328975d0, 0.00333150d0, 0.00337378d0,
     & 0.00341660d0, 0.00345996d0, 0.00350387d0, 0.00354834d0,
     & 0.00359337d0, 0.00363898d0, 0.00368516d0, 0.00373193d0,
     & 0.00377930d0, 0.00382726d0, 0.00387583d0, 0.00392502d0,
     & 0.00397484d0, 0.00402528d0, 0.00407637d0, 0.00412811d0,
     & 0.00418050d0, 0.00423355d0, 0.00428728d0, 0.00434169d0,
     & 0.00439680d0, 0.00445260d0, 0.00450911d0, 0.00456633d0,
     & 0.00462429d0, 0.00468298d0, 0.00474241d0, 0.00480260d0,
     & 0.00486355d0, 0.00492528d0, 0.00498778d0, 0.00505109d0,
     & 0.00511519d0, 0.00518011d0, 0.00524585d0, 0.00531243d0,
     & 0.00537985d0, 0.00544813d0, 0.00551727d0, 0.00558730d0,
     & 0.00565821d0, 0.00573002d0, 0.00580274d0, 0.00587639d0,
     & 0.00595096d0, 0.00602649d0, 0.00610298d0, 0.00618043d0,
     & 0.00625887d0, 0.00633830d0, 0.00641874d0, 0.00650021d0,
     & 0.00658270d0, 0.00666625d0, 0.00675085d0, 0.00683653d0,
     & 0.00692329d0, 0.00701116d0, 0.00710014d0, 0.00719025d0,
     & 0.00728151d0, 0.00737392d0, 0.00746751d0, 0.00756228d0,
     & 0.00765826d0, 0.00775545d0, 0.00785387d0, 0.00795355d0,
     & 0.00805449d0, 0.00815672d0, 0.00826024d0, 0.00836507d0,
     & 0.00847124d0, 0.00857875d0, 0.00868762d0, 0.00879788d0,
     & 0.00890954d0, 0.00902261d0, 0.00913712d0, 0.00925308d0,
     & 0.00937052d0, 0.00948945d0, 0.00960988d0, 0.00973184d0,
     & 0.00985535d0, 0.00998043d0, 0.01010710d0, 0.01023537d0,
     & 0.01036527d0, 0.01049682d0, 0.01063004d0, 0.01076495d0,
     & 0.01090157d0, 0.01103993d0, 0.01118004d0, 0.01132193d0,
     & 0.01146563d0, 0.01161114d0, 0.01175850d0, 0.01190773d0,
     & 0.01205886d0, 0.01221190d0, 0.01236688d0, 0.01252384d0,
     & 0.01268278d0, 0.01284374d0, 0.01300676d0, 0.01317183d0,
     & 0.01333899d0, 0.01350829d0, 0.01367973d0, 0.01385334d0,
     & 0.01402915d0, 0.01420721d0, 0.01438751d0, 0.01457011d0,
     & 0.01475503d0, 0.01494229d0, 0.01513193d0, 0.01532398d0,
     & 0.01551846d0, 0.01571541d0, 0.01591486d0, 0.01611684d0,
     & 0.01632139d0, 0.01652853d0, 0.01673830d0, 0.01695073d0,
     & 0.01716586d0, 0.01738372d0, 0.01760434d0, 0.01782776d0,
     & 0.01805403d0, 0.01828315d0, 0.01851519d0, 0.01875018d0,
     & 0.01898814d0, 0.01922913d0, 0.01947318d0, 0.01972032d0,
     & 0.01997059d0, 0.02022405d0, 0.02048072d0, 0.02074065d0,
     & 0.02100387d0, 0.02127045d0, 0.02154040d0, 0.02181377d0,
     & 0.02209063d0, 0.02237098d0, 0.02265490d0, 0.02294243d0,
     & 0.02323360d0, 0.02352846d0, 0.02382708d0, 0.02412947d0,
     & 0.02443570d0, 0.02474584d0, 0.02505989d0, 0.02537793d0,
     & 0.02570002d0, 0.02602619d0, 0.02635649d0, 0.02669099d0,
     & 0.02702975d0, 0.02737279d0, 0.02772018d0, 0.02807200d0,
     & 0.02842827d0, 0.02878906d0, 0.02915444d0, 0.02952445d0,
     & 0.02989915d0, 0.03027862d0, 0.03066289d0, 0.03105204d0,
     & 0.03144613d0, 0.03184524d0, 0.03224939d0, 0.03265868d0,
     & 0.03307318d0, 0.03349292d0, 0.03391798d0, 0.03434846d0,
     & 0.03478439d0, 0.03522584d0, 0.03567292d0, 0.03612565d0,
     & 0.03658413d0, 0.03704845d0, 0.03751864d0, 0.03799480d0,
     & 0.03847702d0, 0.03896534d0, 0.03945986d0, 0.03996065d0,
     & 0.04046782d0, 0.04098141d0, 0.04150151d0, 0.04202824d0,
     & 0.04256163d0, 0.04310180d0, 0.04364883d0, 0.04420279d0,
     & 0.04476377d0, 0.04533191d0, 0.04590723d0, 0.04648984d0,
     & 0.04707986d0, 0.04767738d0, 0.04828247d0, 0.04889523d0,
     & 0.04951580d0, 0.05014421d0, 0.05078061d0, 0.05142510d0,
     & 0.05207775d0, 0.05273868d0, 0.05340803d0, 0.05408584d0,
     & 0.05477226d0, 0.05546741d0, 0.05617137d0, 0.05688425d0,
     & 0.05760621d0, 0.05833730d0, 0.05907768d0, 0.05982745d0,
     & 0.06058676d0, 0.06135568d0, 0.06213436d0, 0.06292295d0,
     & 0.06372152d0, 0.06453023d0, 0.06534923d0, 0.06617859d0,
     & 0.06701849d0, 0.06786907d0, 0.06873041d0, 0.06960268d0,
     & 0.07048602d0, 0.07138062d0, 0.07228653d0, 0.07320394d0,
     & 0.07413302d0, 0.07507385d0, 0.07602664d0, 0.07699155d0,
     & 0.07796867d0, 0.07895819d0, 0.07996030d0, 0.08097509d0,
     & 0.08200277d0, 0.08304353d0, 0.08409746d0, 0.08516476d0,
     & 0.08624565d0, 0.08734021d0, 0.08844867d0, 0.08957119d0,
     & 0.09070800d0, 0.09185920d0, 0.09302501d0, 0.09420566d0,
     & 0.09540125d0, 0.09661201d0, 0.09783818d0, 0.09907987d0,
     & 0.10033731d0, 0.10161077d0, 0.10290034d0, 0.10420627d0,
     & 0.10552878d0, 0.10686813d0, 0.10822441d0, 0.10959791d0,
     & 0.11098890d0, 0.11239749d0, 0.11382396d0, 0.11526857d0,
     & 0.11673148d0, 0.11821295d0, 0.11971328d0, 0.12123259d0,
     & 0.12277117d0, 0.12432936d0, 0.12590724d0, 0.12750517d0,
     & 0.12912343d0, 0.13076216d0, 0.13242172d0, 0.13410230d0,
     & 0.13580430d0, 0.13752782d0, 0.13927321d0, 0.14104085d0,
     & 0.14283082d0, 0.14464353d0, 0.14647931d0, 0.14833830d0,
     & 0.15022090d0, 0.15212746d0, 0.15405814d0, 0.15601335d0,
     & 0.15799335d0, 0.15999855d0, 0.16202913d0, 0.16408549d0,
     & 0.16616802d0, 0.16827691d0, 0.17041254d0, 0.17257537d0,
     & 0.17476557d0, 0.17698357d0, 0.17922980d0, 0.18150444d0,
     & 0.18380795d0, 0.18614081d0, 0.18850316d0, 0.19089550d0,
     & 0.19331829d0, 0.19577175d0, 0.19825633d0, 0.20077245d0,
     & 0.20332061d0, 0.20590100d0, 0.20851412d0, 0.21116054d0,
     & 0.21384043d0, 0.21655434d0, 0.21930277d0, 0.22208601d0,
     & 0.22490457d0, 0.22775897d0, 0.23064953d0, 0.23357674d0,
     & 0.23654114d0, 0.23954326d0, 0.24258336d0, 0.24566205d0,
     & 0.24877992d0, 0.25193724d0, 0.25513467d0, 0.25837275d0,
     & 0.26165181d0, 0.26497251d0, 0.26833546d0, 0.27174097d0,
     & 0.27518973d0, 0.27868235d0, 0.28221917d0, 0.28580090d0,
     & 0.28942820d0, 0.29310140d0, 0.29682124d0, 0.30058825d0,
     & 0.30440310d0, 0.30826664d0, 0.31217894d0, 0.31614089d0,
     & 0.32015309d0, 0.32421625d0, 0.32833093d0, 0.33249786d0,
     & 0.33671802d0, 0.34099138d0, 0.34531897d0, 0.34970152d0,
     & 0.35413966d0, 0.35863414d0, 0.36318600d0, 0.36779529d0,
     & 0.37246308d0, 0.37719008d0, 0.38197711d0, 0.38682488d0,
     & 0.39173418d0, 0.39670613d0, 0.40174085d0, 0.40683943d0,
     & 0.41200271d0, 0.41723153d0, 0.42252675d0, 0.42788953d0,
     & 0.43332002d0, 0.43881938d0, 0.44438851d0, 0.45002836d0,
     & 0.45573980d0, 0.46152416d0, 0.46738148d0, 0.47331312d0,
     & 0.47932005d0, 0.48540321d0, 0.49156362d0, 0.49780214d0,
     & 0.50412035d0, 0.51051831d0, 0.51699740d0, 0.52355874d0,
     & 0.53020334d0, 0.53693229d0, 0.54374713d0, 0.55064797d0,
     & 0.55763638d0, 0.56471354d0, 0.57188040d0, 0.57913828d0,
     & 0.58648884d0, 0.59393209d0, 0.60146987d0, 0.60910326d0,
     & 0.61683351d0, 0.62466192d0, 0.63258964d0, 0.64061862d0,
     & 0.64874887d0, 0.65698230d0, 0.66532022d0, 0.67376393d0,
     & 0.68231487d0, 0.69097501d0, 0.69974434d0, 0.70862496d0,
     & 0.71761823d0, 0.72672570d0, 0.73594880d0, 0.74528891d0,
     & 0.75474828d0, 0.76432699d0, 0.77402723d0, 0.78385061d0,
     & 0.79379863d0, 0.80387294d0, 0.81407589d0, 0.82440752d0,
     & 0.83487028d0, 0.84546578d0, 0.85619581d0, 0.86706197d0,
     & 0.87806606d0, 0.88921070d0, 0.90049589d0, 0.91192430d0,
     & 0.92349786d0, 0.93521816d0, 0.94708717d0, 0.95910788d0,
     & 0.97128016d0, 0.98360693d0, 0.99609011d0, 1.00873172d0,
     & 1.02153373d0, 1.03449929d0, 1.04762840d0, 1.06092405d0,
     & 1.07438850d0, 1.08802390d0, 1.10183227d0, 1.11581588d0,
     & 1.12997806d0, 1.14431894d0, 1.15884173d0, 1.17354894d0,
     & 1.18844259d0, 1.20352542d0, 1.21880090d0, 1.23426902d0,
     & 1.24993336d0, 1.26579666d0, 1.28186119d0, 1.29812956d0,
     & 1.31460571d0, 1.33128977d0, 1.34818542d0, 1.36529553d0,
     & 1.38262296d0, 1.40017009d0, 1.41794002d0, 1.43593681d0,
     & 1.45416057d0, 1.47261584d0, 1.49130499d0, 1.51023161d0,
     & 1.52939832d0, 1.54880977d0, 1.56846607d0, 1.58837199d0,
     & 1.60853028d0, 1.62894464d0, 1.64961791d0, 1.67055368d0,
     & 1.69175661d0, 1.71322715d0, 1.73497009d0, 1.75698900d0,
     & 1.77928746d0, 1.80186892d0, 1.82473862d0, 1.84789681d0,
     & 1.87134874d0, 1.89509857d0, 1.91914976d0, 1.94350624d0,
     & 1.96817160d0, 1.99315214d0, 2.01844788d0, 2.04406428d0,
     & 2.07000613d0, 2.09627700d0, 2.12288141d0, 2.14982557d0,
     & 2.17710948d0, 2.20473981d0, 2.23272061d0, 2.26105666d0,
     & 2.28975224d0, 2.31881428d0, 2.34824300d0, 2.37804508d0,
     & 2.40822554d0, 2.43878889d0, 2.46974015d0, 2.50108409d0,
     & 2.53282857d0, 2.56497312d0, 2.59752584d0, 2.63049173d0,
     & 2.66387582d0, 2.69768381d0, 2.73192358d0, 2.76659513d0,
     & 2.80170655d0, 2.83726382d0, 2.87327218d0, 2.90973759d0,
     & 2.94666839d0, 2.98406553d0, 3.02193713d0, 3.06028914d0,
     & 3.09912801d0, 3.13845992d0, 3.17829084d0, 3.21863031d0,
     & 3.25947881d0, 3.30084562d0, 3.34273744d0, 3.38516092d0,
     & 3.42812300d0, 3.47163343d0, 3.51569295d0, 3.56031132d0,
     & 3.60549593d0, 3.65125418d0, 3.69759321d0, 3.74452019d0,
     & 3.79204679d0, 3.84017253d0, 3.88890886d0, 3.93826389d0,
     & 3.98824549d0, 4.03886127d0, 4.09012318d0, 4.14203215d0,
     & 4.19460011d0, 4.24783468d0, 4.30174494d0, 4.35633945d0,
     & 4.41162682d0, 4.46762037d0, 4.52431965d0, 4.58173895d0,
     & 4.63988686d0, 4.69877291d0, 4.75840616d0, 4.81880093d0,
     & 4.87995768d0, 4.94189024d0, 5.00460863d0, 5.06812382d0,
     & 5.13244438d0, 5.19758654d0, 5.26355076d0, 5.33035135d0,
     & 5.39800024d0, 5.46650791d0, 5.53588486d0, 5.60614157d0,
     & 5.67729616d0, 5.74934816d0, 5.82231474d0, 5.89620686d0,
     & 5.97103739d0, 6.04681683d0, 6.12356472d0, 6.20128012d0,
     & 6.27998209d0, 6.35968304d0, 6.44039536d0, 6.52213240d0,
     & 6.60491228d0, 6.68873739d0, 6.77362537d0, 6.85959101d0,
     & 6.94664812d0, 7.03480911d0, 7.12408972d0, 7.21451092d0,
     & 7.30607176d0, 7.39879513d0, 7.49269533d0, 7.58778667d0,
     & 7.68408489d0, 7.78161287d0, 7.88037157d0, 7.98038340d0,
     & 8.08166409d0, 8.18422985d0, 8.28809834d0, 8.39328480d0,
     & 8.49981499d0, 8.60768700d0, 8.71692944d0, 8.82755852d0,
     & 8.93959141d0, 9.05304623d0, 9.16794872d0, 9.28430176d0,
     & 9.40213108d0, 9.52145576d0, 9.64229488d0, 9.76466751d0,
     & 9.88859367d0,10.01410198d0,10.14119339d0,10.26989746d0,
     &10.40023613d0,10.53222752d0,10.66589451d0,10.80126858d0,
     &10.93834972d0,11.07717133d0,11.21775436d0,11.36012173d0,
     &11.50429535d0,11.65031052d0,11.79816723d0,11.94790173d0,
     &12.09953499d0,12.25309372d0,12.40860081d0,12.56608105d0,
     &12.72557259d0,12.88707542d0,13.05062866d0,13.21625710d0,
     &13.38398838d0,13.55384827d0,13.72587585d0,13.90007496d0,
     &14.07648373d0,14.25513268d0,14.43604851d0,14.61925888d0,
     &14.80481052d0,14.99270153d0,15.18297768d0,15.37566853d0,
     &15.57080460d0,15.76841831d0,15.96853828d0,16.17121506d0,
     &16.37644768d0,16.58428574d0,16.79475975d0,17.00790787d0,
     &17.22375870d0,17.44236755d0,17.66373062d0,17.88790512d0,
     &18.11492538d0,18.34482765d0,18.57764626d0,18.81341934d0,
     &19.05220222d0,19.29399872d0,19.53886604d0,19.78683662d0,
     &20.03795815d0,20.29226303d0,20.54981613d0,20.81061935d0,
     &21.07473183d0,21.34219742d0,21.61305809d0,21.88735199d0,
     &22.16513062d0,22.44645500d0,22.73132896d0,23.01981735d0,
     &23.31196785d0,23.60782623d0,23.90743828d0,24.21087837d0,
     &24.51814270d0,24.82930946d0,25.14442444d0,25.46353912d0,
     &25.78670311d0,26.11399269d0,26.44541168d0,26.78103638d0,
     &27.12092209d0,27.46512032d0,27.81368637d0,28.16667747d0,
     &28.52417374d0,28.88618279d0,29.25278282d0,29.62404060d0,
     &30.00000572d0
     &/
c Definition of fits (4 deg polynomial) for doy=211
c A0=f(Lm) same for A1,A2,A3 and A4; to be used every where except Lm>7.5 and I> 1.
      DATA (Lm4 ( 8,I), I= 1,100) /
     & 1.10d0, 1.20d0, 1.30d0, 1.40d0, 1.50d0, 1.60d0, 1.70d0, 1.80d0,
     & 1.90d0, 2.00d0, 2.10d0, 2.20d0, 2.30d0, 2.40d0, 2.50d0, 2.60d0,
     & 2.70d0, 2.80d0, 2.90d0, 3.00d0, 3.10d0, 3.20d0, 3.30d0, 3.40d0,
     & 3.50d0, 3.60d0, 3.70d0, 3.80d0, 3.90d0, 4.00d0, 4.10d0, 4.20d0,
     & 4.30d0, 4.40d0, 4.50d0, 4.60d0, 4.70d0, 4.80d0, 4.90d0, 5.00d0,
     & 5.10d0, 5.20d0, 5.30d0, 5.40d0, 5.50d0, 5.60d0, 5.70d0, 5.80d0,
     & 5.90d0, 6.00d0, 6.10d0, 6.20d0, 6.30d0, 6.40d0, 6.50d0, 6.60d0,
     & 6.70d0, 6.80d0, 6.90d0, 7.00d0, 7.10d0, 7.20d0, 7.30d0, 7.40d0,
     & 7.50d0, 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0,
     & 8.30d0, 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0,
     & 9.10d0, 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0,
     & 9.90d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A0 ( 8,I), I= 1,100) /
     & 1.1012966803D+00, 1.2018400957D+00, 1.3022271934D+00,
     & 1.4016900321D+00, 1.5011424843D+00, 1.6001031254D+00,
     & 1.7001903978D+00, 1.8000588247D+00, 1.9005297948D+00,
     & 1.9999203602D+00, 2.1002699702D+00, 2.1980558845D+00,
     & 2.2960681983D+00, 2.3943809629D+00, 2.4913601355D+00,
     & 2.5854536122D+00, 2.6783277841D+00, 2.7725503031D+00,
     & 2.8670758408D+00, 2.9597749173D+00, 3.0513505626D+00,
     & 3.1447395258D+00, 3.2351159573D+00, 3.3267425358D+00,
     & 3.4164213004D+00, 3.5053390574D+00, 3.5912390671D+00,
     & 3.6810965562D+00, 3.7671964228D+00, 3.8512442862D+00,
     & 3.9355049937D+00, 4.0211190398D+00, 4.1063559824D+00,
     & 4.1920140917D+00, 4.2723589846D+00, 4.3560062961D+00,
     & 4.4354559900D+00, 4.5212752093D+00, 4.6025612922D+00,
     & 4.6862022709D+00, 4.7668860337D+00, 4.8515599075D+00,
     & 4.9273311671D+00, 5.0064515718D+00, 5.0892777483D+00,
     & 5.1727959906D+00, 5.2561193545D+00, 5.3370438246D+00,
     & 5.4195531145D+00, 5.5022887050D+00, 5.5858160762D+00,
     & 5.6690738272D+00, 5.7538727973D+00, 5.8379031092D+00,
     & 5.9244149565D+00, 6.0095028663D+00, 6.0961328038D+00,
     & 6.1823615488D+00, 6.2707299248D+00, 6.3589618023D+00,
     & 6.4476713202D+00, 6.5398659287D+00, 6.6333684828D+00,
     & 6.7265991666D+00, 6.8200005495D+00, 6.9220140357D+00,
     & 7.0178281172D+00, 7.1143063664D+00, 7.2204905966D+00,
     & 7.3341069903D+00, 7.4506571467D+00, 7.5615652506D+00,
     & 7.6763986384D+00, 7.8056313017D+00, 7.9354821332D+00,
     & 8.0569429673D+00, 8.1641664066D+00, 8.3073815185D+00,
     & 8.4326408852D+00, 8.5506299668D+00,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A1 ( 8,I), I= 1,100) /
     &-1.0833545697D-05, 1.8343677544D-04, 4.0352773178D-04,
     & 3.6714176012D-04, 4.0289955566D-04, 1.8749767087D-04,
     & 8.4034531322D-05, 3.1660854289D-04, 3.5447214678D-04,
     & 3.3287902429D-04, 8.2831703004D-04, 1.1308866299D-03,
     & 2.8281998639D-03, 4.4159833947D-03, 5.6793659560D-03,
     & 7.4614612449D-03, 7.0526641333D-03, 1.0366736671D-02,
     & 1.0463671025D-02, 1.2725331414D-02, 1.4388990295D-02,
     & 1.5127494370D-02, 1.6948550089D-02, 1.6169775962D-02,
     & 2.0255016953D-02, 2.0294041388D-02, 1.8998690282D-02,
     & 2.1574628488D-02, 2.2910300700D-02, 2.5448366128D-02,
     & 2.7114786286D-02, 2.8470297993D-02, 2.8143133104D-02,
     & 2.9963850635D-02, 3.0361477964D-02, 3.2886869337D-02,
     & 3.3937554033D-02, 3.2767546429D-02, 3.4148490281D-02,
     & 3.5670587132D-02, 3.6202420206D-02, 3.7347112153D-02,
     & 3.6393551042D-02, 3.7558246714D-02, 3.6533901483D-02,
     & 3.5861746309D-02, 3.9037079565D-02, 3.7678649010D-02,
     & 3.6969783392D-02, 3.4358995763D-02, 3.4897427812D-02,
     & 3.4864426847D-02, 3.5482941019D-02, 3.1507450094D-02,
     & 3.1093864890D-02, 3.1229130209D-02, 3.1177382460D-02,
     & 2.7714036748D-02, 2.4288058228D-02, 2.4675324979D-02,
     & 2.0417617643D-02, 1.8321299143D-02, 1.7215948482D-02,
     & 1.3077475012D-02, 1.0982349029D-02, 2.7119215130D-02,
     & 1.4372294575D-02, 1.3049924434D-04,-3.3108722838D-03,
     &-2.7971193297D-03, 9.6081745933D-03,-2.4492097711D-03,
     &-1.4831751323D-02,-7.0254682593D-04, 5.7710360775D-03,
     & 1.0258074085D-02,-1.9507772526D-02, 2.4961031659D-03,
     & 7.7029941945D-03,-2.2318253642D-02,-6.0211732212D-02,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A2 ( 8,I), I= 1,100) /
     &-7.0477820639D-06,-6.4863309816D-06, 1.3492468909D-05,
     & 1.3995185713D-05, 9.5530880281D-06, 5.3966621256D-06,
     &-2.2035183960D-05, 3.0664601920D-06, 4.0736542743D-06,
     & 4.6182931966D-06, 4.5503823072D-05,-1.8539402715D-04,
     & 4.0656074341D-04, 6.7930299648D-04, 6.9160564426D-04,
     & 1.0581964834D-03, 1.2469400948D-03, 2.3458558626D-03,
     & 1.8865939564D-03, 3.1311377410D-03, 3.1788026314D-03,
     & 3.0697257561D-03, 3.6574100716D-03, 3.4422680570D-03,
     & 3.9067409918D-03, 4.9234060299D-03, 4.6116122747D-03,
     & 4.3926208387D-03, 5.1493539498D-03, 5.4824731550D-03,
     & 6.3746163173D-03, 6.7304459102D-03, 6.9155655181D-03,
     & 7.0982411996D-03, 7.8622131903D-03, 7.3153356499D-03,
     & 9.3758685742D-03, 8.8055221974D-03, 8.4045521609D-03,
     & 8.5649723790D-03, 8.7084107707D-03, 8.5713384518D-03,
     & 9.4157523390D-03, 9.1481305662D-03, 8.9186891947D-03,
     & 9.0789134276D-03, 8.7903173365D-03, 9.2416450171D-03,
     & 8.3610550582D-03, 8.9816359952D-03, 8.6227302269D-03,
     & 8.3108327380D-03, 7.0561662801D-03, 7.6045221114D-03,
     & 6.7057623352D-03, 6.5301257189D-03, 5.8623101655D-03,
     & 5.8185167340D-03, 5.2507671774D-03, 4.7071520901D-03,
     & 4.9634678380D-03, 3.7150988265D-03, 1.9733625368D-03,
     & 1.9080872820D-03, 1.3588993644D-03, 1.0920088671D-02,
     & 7.2292498531D-03, 6.9026063522D-04,-1.6657312149D-03,
     &-1.2836291678D-03, 4.7194645032D-03,-1.2792406065D-04,
     &-5.5988357689D-03, 2.6968106213D-04, 4.6314174087D-03,
     & 8.5066518838D-03,-5.5227294085D-03, 6.0009417617D-03,
     & 9.3124885609D-03,-5.7000853314D-03,-3.4919535800D-02,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A3 ( 8,I), I= 1,100) /
     & 5.8747620306D-07,-1.0468530437D-06,-3.0255245430D-06,
     &-3.0226180074D-06,-2.8340740958D-06,-1.1545185428D-06,
     & 5.7280662537D-08,-2.3752665182D-06,-3.1947916736D-06,
     &-2.0303878972D-06,-6.8116075012D-06,-7.1915029361D-05,
     & 1.2070988525D-05, 2.7781281542D-05,-7.6196231293D-06,
     & 8.1485718815D-06, 7.5290338001D-05, 2.1611100841D-04,
     & 1.1682617841D-04, 3.2724565836D-04, 2.8891422177D-04,
     & 2.4730781239D-04, 3.1573968172D-04, 2.9055695184D-04,
     & 2.6921703260D-04, 5.1919075638D-04, 4.7020037132D-04,
     & 3.3740408267D-04, 4.8554365064D-04, 4.7099042099D-04,
     & 5.9839139538D-04, 6.7918670698D-04, 7.1096989079D-04,
     & 7.0997324501D-04, 8.7084068423D-04, 6.5603145160D-04,
     & 1.1379385794D-03, 1.0265955220D-03, 8.4762341557D-04,
     & 8.3133905564D-04, 8.7924599581D-04, 8.3864785689D-04,
     & 9.9677998568D-04, 9.1848469225D-04, 8.8887760013D-04,
     & 9.8930639535D-04, 7.6088563851D-04, 9.1139921474D-04,
     & 7.5039079200D-04, 9.6279115578D-04, 8.4929470578D-04,
     & 7.8180704386D-04, 5.0675190591D-04, 6.7790376276D-04,
     & 5.6590934576D-04, 5.2009677204D-04, 3.7613621679D-04,
     & 4.0207689533D-04, 4.1629000448D-04, 3.4048385198D-04,
     & 3.9059069986D-04, 2.6664012767D-04,-1.9457367540D-04,
     & 3.6491992815D-05,-2.0395915282D-04, 1.5208638093D-03,
     & 1.3098247293D-03, 1.3545697689D-04,-3.8171718759D-04,
     &-1.7709994130D-04, 6.6127777711D-04,-3.1621636601D-05,
     &-9.3869540671D-04,-9.9421517423D-05, 7.6377764773D-04,
     & 1.5373684113D-03,-1.0553909139D-03, 1.0643092565D-03,
     & 1.4930554617D-03,-1.2506827203D-03,-9.1475414331D-03,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A4 ( 8,I), I= 1,100) /
     & 9.2012533912D-08, 6.0443808865D-08,-1.8943419191D-07,
     &-1.8207750996D-07,-1.0891544998D-07,-7.4699665461D-08,
     & 2.9935254138D-07,-6.8967692729D-08,-1.3175916472D-07,
     &-4.7627162585D-08,-5.5598648524D-07,-4.9794685452D-06,
     &-7.5408262149D-07,-6.4272134369D-07,-3.6885705957D-06,
     &-4.4639349295D-06, 4.5672612255D-07, 6.7977642139D-06,
     & 8.5167900854D-07, 1.2416127800D-05, 8.8715576785D-06,
     & 6.6230515371D-06, 8.9280076359D-06, 8.3105367331D-06,
     & 4.0486715093D-06, 2.0035271148D-05, 1.7226403376D-05,
     & 7.2811769445D-06, 1.6306294222D-05, 1.2993602300D-05,
     & 1.8934033598D-05, 2.4554346954D-05, 2.5794917702D-05,
     & 2.5444958411D-05, 3.4826607772D-05, 1.9731964382D-05,
     & 4.9646764932D-05, 4.3072298730D-05, 2.9927577792D-05,
     & 2.7601428640D-05, 3.1479799794D-05, 2.9616903689D-05,
     & 3.6866970403D-05, 3.2236316695D-05, 3.0715139124D-05,
     & 3.9056996887D-05, 2.0539988388D-05, 3.0730002100D-05,
     & 2.2190327175D-05, 3.6133561204D-05, 2.8012977765D-05,
     & 2.4342117571D-05, 8.9218320473D-06, 1.7901759779D-05,
     & 1.4791785435D-05, 1.1950929064D-05, 4.1854235878D-06,
     & 4.5465454735D-06, 8.0505578237D-06, 7.1694815870D-06,
     & 5.5181852298D-06, 2.2364558109D-06,-2.5907299032D-05,
     &-5.0667666396D-06,-2.8480934904D-05, 6.7128478040D-05,
     & 7.5259762483D-05, 7.0392863465D-06,-2.6829523098D-05,
     &-5.4187140837D-06, 2.9038282349D-05,-1.7571210919D-06,
     &-5.1077287443D-05,-1.0161643890D-05, 4.2574263692D-05,
     & 8.9746096840D-05,-6.1482772456D-05, 6.3201944633D-05,
     & 8.2353807413D-05,-7.6900149207D-05,-7.5137148169D-04,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of fits (5 deg polynomial) for doy=211
c A50=f(Lm5) same for A51,A52,A53, A54 and A55
c To be used only where Lm>7.5 and I> 1.
      DATA (Lm5 ( 8,I), I= 1,100) /
     & 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0, 8.30d0,
     & 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0, 9.10d0,
     & 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0, 9.90d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A50 ( 8,I), I= 1,100) /
     & 6.9165105155D+00, 7.0163022202D+00, 7.1170788772D+00,
     & 7.2214498144D+00, 7.3277914191D+00, 7.4388124292D+00,
     & 7.5551012184D+00, 7.6788716004D+00, 7.8090963122D+00,
     & 7.9313177901D+00, 8.0492830740D+00, 8.1836348760D+00,
     & 8.3182446682D+00, 8.4405117389D+00, 8.5485778381D+00,
     & 8.6700261324D+00, 8.2642393259D+00, 8.7222272193D+00,
     & 1.1007668830D+01, 1.4070002364D+01, 1.3490539178D+01,
     & 1.5187163996D+01, 1.5541745475D+01, 1.7945150000D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A51 ( 8,I), I= 1,100) /
     & 3.2384510195D-03, 1.7114767424D-02,-9.6110917715D-03,
     &-2.7635314827D-02,-1.7816887695D-02,-2.9611856203D-02,
     &-3.6894417558D-02,-5.4563730213D-02,-7.4929937519D-02,
     &-3.7492344450D-02, 1.6372174530D-02, 6.8276440895D-02,
     & 8.2276052290D-02, 7.2730305969D-02, 7.8377803621D-02,
     &-5.1790748033D-03, 2.4043867668D+00, 1.8658574671D+00,
     &-3.3341786835D+00,-1.0444784561D+01,-7.9399803957D+00,
     &-1.0991673688D+01,-1.0167485618D+01,-1.4631118801D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A52 ( 8,I), I= 1,100) /
     & 4.8975757599D-02,-2.7345646128D-02, 4.3717917213D-02,
     & 8.0435144128D-02, 2.2043326203D-02, 2.7875219342D-02,
     &-2.3832558015D-04,-2.1586615268D-02,-2.2149451092D-02,
     &-1.1746521083D-01,-2.0757782028D-01,-3.3830084238D-01,
     &-3.4102205004D-01,-2.4671283353D-01,-9.2885202069D-02,
     & 1.8433140446D-01,-3.3222130939D+00,-2.9574671273D+00,
     & 2.0283837856D+00, 8.9463057501D+00, 6.0435810508D+00,
     & 8.4694271560D+00, 6.7628342044D+00, 1.0384643903D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A53 ( 8,I), I= 1,100) /
     &-5.3278648779D-02, 2.8510333941D-02,-4.9918467524D-02,
     &-9.0018905082D-02,-2.8899337019D-02,-3.9707347789D-02,
     &-1.0031816063D-02, 2.2134987287D-02, 1.5055035228D-02,
     & 7.6260054606D-02, 1.1514585553D-01, 1.9923316493D-01,
     & 1.5825235411D-01, 3.5978271658D-02,-1.6666108701D-01,
     &-4.3178312580D-01, 1.8176755844D+00, 1.6725068150D+00,
     &-6.9113863546D-01,-4.0483022315D+00,-2.5329693354D+00,
     &-3.5157218866D+00,-2.4184363103D+00,-3.9311461636D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A54 ( 8,I), I= 1,100) /
     & 1.8239017678D-02,-1.5928332070D-02, 1.8283213739D-02,
     & 3.4282739644D-02, 7.5766595653D-03, 1.3605961499D-02,
     & 1.1373588127D-03,-1.4533472702D-02,-8.5340908223D-03,
     &-2.5694748185D-02,-3.1168932436D-02,-5.4535181834D-02,
     &-3.0307595598D-02, 1.9889089141D-02, 1.0290805697D-01,
     & 1.9861305728D-01,-4.6672683374D-01,-4.3425248903D-01,
     & 1.1371040656D-01, 9.1849368793D-01, 5.4578088421D-01,
     & 7.4426509373D-01, 4.4254823719D-01, 7.6173319787D-01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A55 ( 8,I), I= 1,100) /
     &-1.8310570505D-03, 3.0276526131D-03,-2.1570634337D-03,
     &-4.2196467040D-03,-1.2676699457D-04,-1.1900557351D-03,
     & 6.8023833419D-04, 3.1369852409D-03, 1.9555301490D-03,
     & 3.7541603637D-03, 3.7759858936D-03, 6.1906222338D-03,
     & 2.3577985982D-03,-4.3422626657D-03,-1.5383404945D-02,
     &-2.7247732125D-02, 4.6736394754D-02, 4.3614883281D-02,
     &-5.9304540738D-03,-8.1886410642D-02,-4.6762018628D-02,
     &-6.2529928405D-02,-3.1986608629D-02,-5.8877074422D-02,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of Loss cone as Lmax=f(Imax) for doy=241
      DATA (Lmax ( 9,I), I= 1, 2100) /
     & 1.0864d0, 1.0874d0, 1.0884d0, 1.0894d0, 1.0904d0, 1.0913d0,
     & 1.0923d0, 1.0933d0, 1.0943d0, 1.0953d0, 1.0963d0, 1.0973d0,
     & 1.0983d0, 1.0993d0, 1.1003d0, 1.1013d0, 1.1023d0, 1.1033d0,
     & 1.1044d0, 1.1054d0, 1.1064d0, 1.1074d0, 1.1084d0, 1.1094d0,
     & 1.1105d0, 1.1115d0, 1.1125d0, 1.1135d0, 1.1145d0, 1.1156d0,
     & 1.1166d0, 1.1176d0, 1.1186d0, 1.1197d0, 1.1207d0, 1.1217d0,
     & 1.1227d0, 1.1238d0, 1.1248d0, 1.1258d0, 1.1268d0, 1.1279d0,
     & 1.1289d0, 1.1299d0, 1.1310d0, 1.1320d0, 1.1330d0, 1.1340d0,
     & 1.1351d0, 1.1361d0, 1.1371d0, 1.1381d0, 1.1392d0, 1.1402d0,
     & 1.1412d0, 1.1422d0, 1.1433d0, 1.1443d0, 1.1453d0, 1.1464d0,
     & 1.1474d0, 1.1484d0, 1.1494d0, 1.1505d0, 1.1515d0, 1.1525d0,
     & 1.1535d0, 1.1546d0, 1.1556d0, 1.1566d0, 1.1576d0, 1.1587d0,
     & 1.1597d0, 1.1607d0, 1.1618d0, 1.1628d0, 1.1638d0, 1.1648d0,
     & 1.1659d0, 1.1669d0, 1.1679d0, 1.1689d0, 1.1700d0, 1.1710d0,
     & 1.1720d0, 1.1731d0, 1.1741d0, 1.1751d0, 1.1761d0, 1.1772d0,
     & 1.1782d0, 1.1792d0, 1.1803d0, 1.1813d0, 1.1823d0, 1.1833d0,
     & 1.1844d0, 1.1854d0, 1.1864d0, 1.1875d0, 1.1885d0, 1.1895d0,
     & 1.1905d0, 1.1916d0, 1.1926d0, 1.1936d0, 1.1946d0, 1.1957d0,
     & 1.1967d0, 1.1977d0, 1.1987d0, 1.1998d0, 1.2008d0, 1.2018d0,
     & 1.2028d0, 1.2038d0, 1.2049d0, 1.2059d0, 1.2069d0, 1.2080d0,
     & 1.2090d0, 1.2100d0, 1.2110d0, 1.2121d0, 1.2131d0, 1.2141d0,
     & 1.2152d0, 1.2162d0, 1.2172d0, 1.2182d0, 1.2192d0, 1.2203d0,
     & 1.2213d0, 1.2223d0, 1.2234d0, 1.2244d0, 1.2254d0, 1.2264d0,
     & 1.2274d0, 1.2284d0, 1.2295d0, 1.2305d0, 1.2315d0, 1.2326d0,
     & 1.2336d0, 1.2346d0, 1.2356d0, 1.2366d0, 1.2377d0, 1.2387d0,
     & 1.2397d0, 1.2408d0, 1.2418d0, 1.2428d0, 1.2438d0, 1.2448d0,
     & 1.2459d0, 1.2469d0, 1.2479d0, 1.2489d0, 1.2500d0, 1.2510d0,
     & 1.2520d0, 1.2530d0, 1.2540d0, 1.2551d0, 1.2561d0, 1.2571d0,
     & 1.2581d0, 1.2592d0, 1.2602d0, 1.2612d0, 1.2622d0, 1.2633d0,
     & 1.2643d0, 1.2653d0, 1.2663d0, 1.2673d0, 1.2684d0, 1.2694d0,
     & 1.2704d0, 1.2714d0, 1.2725d0, 1.2735d0, 1.2745d0, 1.2755d0,
     & 1.2765d0, 1.2776d0, 1.2786d0, 1.2796d0, 1.2806d0, 1.2816d0,
     & 1.2827d0, 1.2837d0, 1.2847d0, 1.2857d0, 1.2867d0, 1.2878d0,
     & 1.2888d0, 1.2898d0, 1.2908d0, 1.2918d0, 1.2929d0, 1.2939d0,
     & 1.2949d0, 1.2959d0, 1.2969d0, 1.2980d0, 1.2990d0, 1.3000d0,
     & 1.3010d0, 1.3020d0, 1.3031d0, 1.3041d0, 1.3051d0, 1.3061d0,
     & 1.3071d0, 1.3082d0, 1.3092d0, 1.3102d0, 1.3112d0, 1.3122d0,
     & 1.3133d0, 1.3143d0, 1.3153d0, 1.3163d0, 1.3173d0, 1.3183d0,
     & 1.3194d0, 1.3204d0, 1.3214d0, 1.3224d0, 1.3234d0, 1.3245d0,
     & 1.3255d0, 1.3265d0, 1.3275d0, 1.3285d0, 1.3296d0, 1.3306d0,
     & 1.3316d0, 1.3326d0, 1.3336d0, 1.3346d0, 1.3357d0, 1.3367d0,
     & 1.3377d0, 1.3387d0, 1.3397d0, 1.3408d0, 1.3418d0, 1.3428d0,
     & 1.3438d0, 1.3448d0, 1.3458d0, 1.3468d0, 1.3479d0, 1.3489d0,
     & 1.3499d0, 1.3509d0, 1.3519d0, 1.3530d0, 1.3540d0, 1.3550d0,
     & 1.3560d0, 1.3570d0, 1.3580d0, 1.3590d0, 1.3601d0, 1.3611d0,
     & 1.3621d0, 1.3631d0, 1.3641d0, 1.3652d0, 1.3662d0, 1.3672d0,
     & 1.3682d0, 1.3692d0, 1.3702d0, 1.3712d0, 1.3723d0, 1.3733d0,
     & 1.3743d0, 1.3753d0, 1.3763d0, 1.3774d0, 1.3784d0, 1.3794d0,
     & 1.3804d0, 1.3814d0, 1.3824d0, 1.3834d0, 1.3844d0, 1.3855d0,
     & 1.3865d0, 1.3875d0, 1.3885d0, 1.3895d0, 1.3906d0, 1.3916d0,
     & 1.3925d0, 1.3936d0, 1.3946d0, 1.3956d0, 1.3966d0, 1.3976d0,
     & 1.3987d0, 1.3997d0, 1.4007d0, 1.4017d0, 1.4027d0, 1.4038d0,
     & 1.4047d0, 1.4057d0, 1.4067d0, 1.4078d0, 1.4088d0, 1.4098d0,
     & 1.4108d0, 1.4118d0, 1.4129d0, 1.4139d0, 1.4149d0, 1.4159d0,
     & 1.4169d0, 1.4179d0, 1.4189d0, 1.4199d0, 1.4209d0, 1.4219d0,
     & 1.4230d0, 1.4240d0, 1.4250d0, 1.4260d0, 1.4270d0, 1.4281d0,
     & 1.4291d0, 1.4301d0, 1.4311d0, 1.4321d0, 1.4331d0, 1.4341d0,
     & 1.4351d0, 1.4361d0, 1.4371d0, 1.4382d0, 1.4392d0, 1.4402d0,
     & 1.4412d0, 1.4423d0, 1.4433d0, 1.4443d0, 1.4453d0, 1.4463d0,
     & 1.4473d0, 1.4483d0, 1.4493d0, 1.4503d0, 1.4513d0, 1.4523d0,
     & 1.4533d0, 1.4544d0, 1.4554d0, 1.4564d0, 1.4574d0, 1.4585d0,
     & 1.4595d0, 1.4605d0, 1.4615d0, 1.4625d0, 1.4635d0, 1.4644d0,
     & 1.4654d0, 1.4665d0, 1.4675d0, 1.4685d0, 1.4695d0, 1.4705d0,
     & 1.4716d0, 1.4726d0, 1.4736d0, 1.4746d0, 1.4757d0, 1.4767d0,
     & 1.4777d0, 1.4786d0, 1.4796d0, 1.4806d0, 1.4816d0, 1.4826d0,
     & 1.4836d0, 1.4846d0, 1.4857d0, 1.4867d0, 1.4877d0, 1.4887d0,
     & 1.4898d0, 1.4908d0, 1.4918d0, 1.4928d0, 1.4938d0, 1.4948d0,
     & 1.4958d0, 1.4968d0, 1.4978d0, 1.4988d0, 1.4998d0, 1.5008d0,
     & 1.5018d0, 1.5028d0, 1.5038d0, 1.5049d0, 1.5059d0, 1.5069d0,
     & 1.5080d0, 1.5090d0, 1.5100d0, 1.5110d0, 1.5120d0, 1.5130d0,
     & 1.5139d0, 1.5149d0, 1.5159d0, 1.5169d0, 1.5179d0, 1.5190d0,
     & 1.5200d0, 1.5210d0, 1.5220d0, 1.5230d0, 1.5241d0, 1.5251d0,
     & 1.5261d0, 1.5271d0, 1.5281d0, 1.5291d0, 1.5301d0, 1.5311d0,
     & 1.5321d0, 1.5331d0, 1.5341d0, 1.5351d0, 1.5361d0, 1.5371d0,
     & 1.5381d0, 1.5392d0, 1.5402d0, 1.5412d0, 1.5423d0, 1.5433d0,
     & 1.5443d0, 1.5453d0, 1.5463d0, 1.5473d0, 1.5483d0, 1.5492d0,
     & 1.5502d0, 1.5512d0, 1.5522d0, 1.5532d0, 1.5542d0, 1.5553d0,
     & 1.5563d0, 1.5573d0, 1.5583d0, 1.5594d0, 1.5604d0, 1.5614d0,
     & 1.5624d0, 1.5634d0, 1.5644d0, 1.5654d0, 1.5664d0, 1.5674d0,
     & 1.5684d0, 1.5694d0, 1.5704d0, 1.5714d0, 1.5724d0, 1.5734d0,
     & 1.5744d0, 1.5755d0, 1.5765d0, 1.5775d0, 1.5785d0, 1.5796d0,
     & 1.5806d0, 1.5816d0, 1.5826d0, 1.5836d0, 1.5846d0, 1.5855d0,
     & 1.5865d0, 1.5875d0, 1.5885d0, 1.5895d0, 1.5905d0, 1.5915d0,
     & 1.5925d0, 1.5935d0, 1.5946d0, 1.5956d0, 1.5966d0, 1.5977d0,
     & 1.5987d0, 1.5997d0, 1.6007d0, 1.6017d0, 1.6027d0, 1.6037d0,
     & 1.6047d0, 1.6057d0, 1.6066d0, 1.6076d0, 1.6086d0, 1.6096d0,
     & 1.6106d0, 1.6116d0, 1.6126d0, 1.6137d0, 1.6147d0, 1.6157d0,
     & 1.6168d0, 1.6178d0, 1.6188d0, 1.6199d0, 1.6209d0, 1.6219d0,
     & 1.6228d0, 1.6238d0, 1.6248d0, 1.6258d0, 1.6268d0, 1.6277d0,
     & 1.6287d0, 1.6297d0, 1.6307d0, 1.6318d0, 1.6328d0, 1.6338d0,
     & 1.6348d0, 1.6359d0, 1.6369d0, 1.6379d0, 1.6390d0, 1.6400d0,
     & 1.6410d0, 1.6420d0, 1.6430d0, 1.6440d0, 1.6449d0, 1.6459d0,
     & 1.6469d0, 1.6479d0, 1.6489d0, 1.6498d0, 1.6509d0, 1.6519d0,
     & 1.6529d0, 1.6539d0, 1.6549d0, 1.6560d0, 1.6570d0, 1.6580d0,
     & 1.6591d0, 1.6601d0, 1.6611d0, 1.6621d0, 1.6631d0, 1.6641d0,
     & 1.6651d0, 1.6661d0, 1.6670d0, 1.6680d0, 1.6690d0, 1.6700d0,
     & 1.6709d0, 1.6719d0, 1.6729d0, 1.6740d0, 1.6750d0, 1.6760d0,
     & 1.6770d0, 1.6781d0, 1.6791d0, 1.6801d0, 1.6812d0, 1.6822d0,
     & 1.6832d0, 1.6842d0, 1.6852d0, 1.6862d0, 1.6872d0, 1.6882d0,
     & 1.6892d0, 1.6901d0, 1.6911d0, 1.6921d0, 1.6931d0, 1.6940d0,
     & 1.6950d0, 1.6960d0, 1.6971d0, 1.6981d0, 1.6991d0, 1.7001d0,
     & 1.7012d0, 1.7022d0, 1.7032d0, 1.7043d0, 1.7053d0, 1.7063d0,
     & 1.7073d0, 1.7083d0, 1.7093d0, 1.7103d0, 1.7113d0, 1.7123d0,
     & 1.7132d0, 1.7142d0, 1.7152d0, 1.7162d0, 1.7172d0, 1.7181d0,
     & 1.7191d0, 1.7201d0, 1.7212d0, 1.7222d0, 1.7232d0, 1.7242d0,
     & 1.7253d0, 1.7263d0, 1.7273d0, 1.7284d0, 1.7294d0, 1.7304d0,
     & 1.7314d0, 1.7324d0, 1.7334d0, 1.7344d0, 1.7354d0, 1.7364d0,
     & 1.7373d0, 1.7383d0, 1.7393d0, 1.7403d0, 1.7412d0, 1.7422d0,
     & 1.7432d0, 1.7442d0, 1.7452d0, 1.7463d0, 1.7473d0, 1.7483d0,
     & 1.7493d0, 1.7504d0, 1.7514d0, 1.7525d0, 1.7535d0, 1.7545d0,
     & 1.7555d0, 1.7565d0, 1.7575d0, 1.7585d0, 1.7595d0, 1.7605d0,
     & 1.7614d0, 1.7624d0, 1.7634d0, 1.7644d0, 1.7653d0, 1.7663d0,
     & 1.7673d0, 1.7683d0, 1.7693d0, 1.7703d0, 1.7714d0, 1.7724d0,
     & 1.7734d0, 1.7744d0, 1.7755d0, 1.7765d0, 1.7775d0, 1.7786d0,
     & 1.7796d0, 1.7806d0, 1.7816d0, 1.7826d0, 1.7836d0, 1.7846d0,
     & 1.7855d0, 1.7865d0, 1.7875d0, 1.7885d0, 1.7895d0, 1.7904d0,
     & 1.7914d0, 1.7924d0, 1.7934d0, 1.7944d0, 1.7954d0, 1.7964d0,
     & 1.7975d0, 1.7985d0, 1.7995d0, 1.8006d0, 1.8016d0, 1.8026d0,
     & 1.8037d0, 1.8047d0, 1.8057d0, 1.8067d0, 1.8077d0, 1.8087d0,
     & 1.8097d0, 1.8106d0, 1.8116d0, 1.8126d0, 1.8136d0, 1.8146d0,
     & 1.8155d0, 1.8165d0, 1.8175d0, 1.8185d0, 1.8195d0, 1.8205d0,
     & 1.8215d0, 1.8225d0, 1.8235d0, 1.8246d0, 1.8256d0, 1.8266d0,
     & 1.8277d0, 1.8287d0, 1.8298d0, 1.8308d0, 1.8318d0, 1.8328d0,
     & 1.8338d0, 1.8348d0, 1.8358d0, 1.8367d0, 1.8377d0, 1.8387d0,
     & 1.8397d0, 1.8407d0, 1.8416d0, 1.8426d0, 1.8436d0, 1.8446d0,
     & 1.8455d0, 1.8465d0, 1.8475d0, 1.8485d0, 1.8496d0, 1.8506d0,
     & 1.8516d0, 1.8526d0, 1.8537d0, 1.8547d0, 1.8558d0, 1.8568d0,
     & 1.8578d0, 1.8588d0, 1.8598d0, 1.8608d0, 1.8618d0, 1.8628d0,
     & 1.8638d0, 1.8648d0, 1.8658d0, 1.8668d0, 1.8677d0, 1.8687d0,
     & 1.8697d0, 1.8707d0, 1.8716d0, 1.8726d0, 1.8736d0, 1.8746d0,
     & 1.8756d0, 1.8766d0, 1.8776d0, 1.8786d0, 1.8796d0, 1.8807d0,
     & 1.8817d0, 1.8828d0, 1.8838d0, 1.8848d0, 1.8859d0, 1.8869d0,
     & 1.8879d0, 1.8889d0, 1.8899d0, 1.8909d0, 1.8919d0, 1.8929d0,
     & 1.8938d0, 1.8948d0, 1.8958d0, 1.8968d0, 1.8978d0, 1.8987d0,
     & 1.8997d0, 1.9007d0, 1.9017d0, 1.9026d0, 1.9036d0, 1.9046d0,
     & 1.9056d0, 1.9067d0, 1.9077d0, 1.9087d0, 1.9097d0, 1.9108d0,
     & 1.9118d0, 1.9129d0, 1.9139d0, 1.9150d0, 1.9160d0, 1.9170d0,
     & 1.9180d0, 1.9190d0, 1.9200d0, 1.9210d0, 1.9220d0, 1.9229d0,
     & 1.9239d0, 1.9249d0, 1.9259d0, 1.9269d0, 1.9278d0, 1.9288d0,
     & 1.9298d0, 1.9308d0, 1.9317d0, 1.9327d0, 1.9337d0, 1.9347d0,
     & 1.9357d0, 1.9367d0, 1.9377d0, 1.9387d0, 1.9398d0, 1.9408d0,
     & 1.9418d0, 1.9429d0, 1.9439d0, 1.9450d0, 1.9460d0, 1.9470d0,
     & 1.9480d0, 1.9490d0, 1.9500d0, 1.9510d0, 1.9520d0, 1.9530d0,
     & 1.9540d0, 1.9550d0, 1.9560d0, 1.9569d0, 1.9579d0, 1.9589d0,
     & 1.9599d0, 1.9608d0, 1.9618d0, 1.9628d0, 1.9638d0, 1.9647d0,
     & 1.9657d0, 1.9667d0, 1.9677d0, 1.9687d0, 1.9698d0, 1.9708d0,
     & 1.9718d0, 1.9729d0, 1.9739d0, 1.9750d0, 1.9760d0, 1.9771d0,
     & 1.9781d0, 1.9791d0, 1.9801d0, 1.9811d0, 1.9821d0, 1.9831d0,
     & 1.9841d0, 1.9850d0, 1.9860d0, 1.9870d0, 1.9880d0, 1.9890d0,
     & 1.9899d0, 1.9909d0, 1.9919d0, 1.9929d0, 1.9939d0, 1.9948d0,
     & 1.9958d0, 1.9968d0, 1.9978d0, 1.9988d0, 1.9998d0, 2.0008d0,
     & 2.0019d0, 2.0029d0, 2.0039d0, 2.0050d0, 2.0060d0, 2.0071d0,
     & 2.0081d0, 2.0091d0, 2.0101d0, 2.0111d0, 2.0121d0, 2.0131d0,
     & 2.0141d0, 2.0151d0, 2.0161d0, 2.0171d0, 2.0181d0, 2.0191d0,
     & 2.0200d0, 2.0210d0, 2.0220d0, 2.0230d0, 2.0239d0, 2.0249d0,
     & 2.0259d0, 2.0269d0, 2.0278d0, 2.0288d0, 2.0298d0, 2.0308d0,
     & 2.0318d0, 2.0328d0, 2.0338d0, 2.0349d0, 2.0359d0, 2.0369d0,
     & 2.0380d0, 2.0390d0, 2.0401d0, 2.0411d0, 2.0422d0, 2.0432d0,
     & 2.0442d0, 2.0452d0, 2.0462d0, 2.0472d0, 2.0481d0, 2.0491d0,
     & 2.0501d0, 2.0511d0, 2.0521d0, 2.0531d0, 2.0540d0, 2.0550d0,
     & 2.0560d0, 2.0570d0, 2.0580d0, 2.0589d0, 2.0599d0, 2.0609d0,
     & 2.0619d0, 2.0628d0, 2.0638d0, 2.0648d0, 2.0658d0, 2.0668d0,
     & 2.0678d0, 2.0688d0, 2.0699d0, 2.0709d0, 2.0720d0, 2.0730d0,
     & 2.0740d0, 2.0751d0, 2.0761d0, 2.0771d0, 2.0782d0, 2.0792d0,
     & 2.0802d0, 2.0812d0, 2.0822d0, 2.0831d0, 2.0841d0, 2.0851d0,
     & 2.0861d0, 2.0871d0, 2.0881d0, 2.0890d0, 2.0900d0, 2.0910d0,
     & 2.0920d0, 2.0929d0, 2.0939d0, 2.0949d0, 2.0959d0, 2.0969d0,
     & 2.0979d0, 2.0990d0, 2.0999d0, 2.1009d0, 2.1020d0, 2.1030d0,
     & 2.1040d0, 2.1051d0, 2.1061d0, 2.1071d0, 2.1081d0, 2.1091d0,
     & 2.1101d0, 2.1112d0, 2.1122d0, 2.1132d0, 2.1143d0, 2.1155d0,
     & 2.1165d0, 2.1174d0, 2.1184d0, 2.1194d0, 2.1204d0, 2.1214d0,
     & 2.1224d0, 2.1233d0, 2.1243d0, 2.1251d0, 2.1259d0, 2.1269d0,
     & 2.1279d0, 2.1289d0, 2.1299d0, 2.1308d0, 2.1318d0, 2.1328d0,
     & 2.1338d0, 2.1348d0, 2.1358d0, 2.1369d0, 2.1380d0, 2.1390d0,
     & 2.1401d0, 2.1412d0, 2.1423d0, 2.1433d0, 2.1445d0, 2.1457d0,
     & 2.1469d0, 2.1479d0, 2.1489d0, 2.1498d0, 2.1508d0, 2.1517d0,
     & 2.1526d0, 2.1536d0, 2.1546d0, 2.1555d0, 2.1563d0, 2.1571d0,
     & 2.1581d0, 2.1591d0, 2.1602d0, 2.1613d0, 2.1623d0, 2.1633d0,
     & 2.1644d0, 2.1655d0, 2.1664d0, 2.1674d0, 2.1684d0, 2.1694d0,
     & 2.1705d0, 2.1715d0, 2.1723d0, 2.1733d0, 2.1743d0, 2.1752d0,
     & 2.1763d0, 2.1775d0, 2.1787d0, 2.1798d0, 2.1808d0, 2.1817d0,
     & 2.1826d0, 2.1836d0, 2.1847d0, 2.1856d0, 2.1866d0, 2.1874d0,
     & 2.1882d0, 2.1890d0, 2.1900d0, 2.1910d0, 2.1920d0, 2.1930d0,
     & 2.1940d0, 2.1950d0, 2.1960d0, 2.1969d0, 2.1979d0, 2.1989d0,
     & 2.1999d0, 2.2009d0, 2.2019d0, 2.2030d0, 2.2041d0, 2.2051d0,
     & 2.2061d0, 2.2072d0, 2.2082d0, 2.2093d0, 2.2102d0, 2.2112d0,
     & 2.2121d0, 2.2131d0, 2.2140d0, 2.2149d0, 2.2159d0, 2.2169d0,
     & 2.2178d0, 2.2188d0, 2.2198d0, 2.2209d0, 2.2219d0, 2.2229d0,
     & 2.2239d0, 2.2250d0, 2.2260d0, 2.2269d0, 2.2279d0, 2.2289d0,
     & 2.2299d0, 2.2309d0, 2.2319d0, 2.2329d0, 2.2339d0, 2.2349d0,
     & 2.2360d0, 2.2370d0, 2.2381d0, 2.2391d0, 2.2402d0, 2.2413d0,
     & 2.2422d0, 2.2431d0, 2.2441d0, 2.2451d0, 2.2460d0, 2.2469d0,
     & 2.2478d0, 2.2487d0, 2.2496d0, 2.2506d0, 2.2515d0, 2.2525d0,
     & 2.2535d0, 2.2545d0, 2.2556d0, 2.2566d0, 2.2577d0, 2.2587d0,
     & 2.2598d0, 2.2608d0, 2.2619d0, 2.2629d0, 2.2639d0, 2.2649d0,
     & 2.2658d0, 2.2668d0, 2.2678d0, 2.2688d0, 2.2698d0, 2.2708d0,
     & 2.2725d0, 2.2752d0, 2.2786d0, 2.2828d0, 2.2879d0, 2.2938d0,
     & 2.3005d0, 2.3080d0, 2.3163d0, 2.3254d0, 2.3353d0, 2.3453d0,
     & 2.3553d0, 2.3652d0, 2.3752d0, 2.3851d0, 2.3951d0, 2.4050d0,
     & 2.4149d0, 2.4249d0, 2.4349d0, 2.4447d0, 2.4546d0, 2.4645d0,
     & 2.4745d0, 2.4844d0, 2.4942d0, 2.5041d0, 2.5141d0, 2.5239d0,
     & 2.5338d0, 2.5437d0, 2.5537d0, 2.5636d0, 2.5735d0, 2.5834d0,
     & 2.5932d0, 2.6032d0, 2.6132d0, 2.6230d0, 2.6329d0, 2.6428d0,
     & 2.6527d0, 2.6626d0, 2.6725d0, 2.6824d0, 2.6923d0, 2.7022d0,
     & 2.7121d0, 2.7220d0, 2.7319d0, 2.7419d0, 2.7519d0, 2.7618d0,
     & 2.7716d0, 2.7815d0, 2.7914d0, 2.8013d0, 2.8112d0, 2.8211d0,
     & 2.8310d0, 2.8408d0, 2.8506d0, 2.8605d0, 2.8704d0, 2.8802d0,
     & 2.8902d0, 2.9001d0, 2.9099d0, 2.9198d0, 2.9297d0, 2.9396d0,
     & 2.9495d0, 2.9594d0, 2.9693d0, 2.9792d0, 2.9891d0, 2.9990d0,
     & 3.0089d0, 3.0188d0, 3.0286d0, 3.0385d0, 3.0483d0, 3.0582d0,
     & 3.0682d0, 3.0780d0, 3.0879d0, 3.0977d0, 3.1076d0, 3.1175d0,
     & 3.1274d0, 3.1373d0, 3.1472d0, 3.1571d0, 3.1669d0, 3.1768d0,
     & 3.1867d0, 3.1967d0, 3.2065d0, 3.2164d0, 3.2263d0, 3.2362d0,
     & 3.2460d0, 3.2559d0, 3.2657d0, 3.2755d0, 3.2854d0, 3.2952d0,
     & 3.3051d0, 3.3150d0, 3.3248d0, 3.3347d0, 3.3446d0, 3.3546d0,
     & 3.3644d0, 3.3742d0, 3.3842d0, 3.3941d0, 3.4039d0, 3.4137d0,
     & 3.4235d0, 3.4333d0, 3.4432d0, 3.4530d0, 3.4629d0, 3.4728d0,
     & 3.4826d0, 3.4925d0, 3.5023d0, 3.5122d0, 3.5220d0, 3.5318d0,
     & 3.5418d0, 3.5517d0, 3.5616d0, 3.5714d0, 3.5812d0, 3.5911d0,
     & 3.6009d0, 3.6108d0, 3.6207d0, 3.6306d0, 3.6406d0, 3.6504d0,
     & 3.6602d0, 3.6701d0, 3.6799d0, 3.6899d0, 3.6997d0, 3.7096d0,
     & 3.7195d0, 3.7293d0, 3.7392d0, 3.7489d0, 3.7587d0, 3.7685d0,
     & 3.7783d0, 3.7880d0, 3.7979d0, 3.8077d0, 3.8175d0, 3.8273d0,
     & 3.8371d0, 3.8469d0, 3.8569d0, 3.8669d0, 3.8768d0, 3.8868d0,
     & 3.8967d0, 3.9065d0, 3.9164d0, 3.9263d0, 3.9361d0, 3.9460d0,
     & 3.9560d0, 3.9659d0, 3.9757d0, 3.9856d0, 3.9954d0, 4.0052d0,
     & 4.0151d0, 4.0249d0, 4.0348d0, 4.0446d0, 4.0545d0, 4.0643d0,
     & 4.0742d0, 4.0840d0, 4.0938d0, 4.1036d0, 4.1134d0, 4.1232d0,
     & 4.1331d0, 4.1428d0, 4.1527d0, 4.1625d0, 4.1723d0, 4.1822d0,
     & 4.1921d0, 4.2020d0, 4.2120d0, 4.2218d0, 4.2317d0, 4.2417d0,
     & 4.2516d0, 4.2616d0, 4.2716d0, 4.2814d0, 4.2912d0, 4.3011d0,
     & 4.3109d0, 4.3207d0, 4.3306d0, 4.3405d0, 4.3503d0, 4.3601d0,
     & 4.3700d0, 4.3798d0, 4.3897d0, 4.3996d0, 4.4095d0, 4.4194d0,
     & 4.4293d0, 4.4392d0, 4.4491d0, 4.4589d0, 4.4689d0, 4.4788d0,
     & 4.4887d0, 4.4985d0, 4.5084d0, 4.5183d0, 4.5283d0, 4.5383d0,
     & 4.5482d0, 4.5582d0, 4.5681d0, 4.5779d0, 4.5877d0, 4.5977d0,
     & 4.6076d0, 4.6175d0, 4.6274d0, 4.6374d0, 4.6473d0, 4.6572d0,
     & 4.6672d0, 4.6771d0, 4.6871d0, 4.6970d0, 4.7069d0, 4.7167d0,
     & 4.7264d0, 4.7364d0, 4.7463d0, 4.7563d0, 4.7662d0, 4.7762d0,
     & 4.7862d0, 4.7961d0, 4.8061d0, 4.8160d0, 4.8260d0, 4.8360d0,
     & 4.8458d0, 4.8558d0, 4.8656d0, 4.8754d0, 4.8853d0, 4.8953d0,
     & 4.9054d0, 4.9153d0, 4.9253d0, 4.9353d0, 4.9453d0, 4.9553d0,
     & 4.9652d0, 4.9753d0, 4.9853d0, 4.9953d0, 5.0053d0, 5.0153d0,
     & 5.0253d0, 5.0353d0, 5.0454d0, 5.0554d0, 5.0654d0, 5.0754d0,
     & 5.0855d0, 5.0956d0, 5.1055d0, 5.1156d0, 5.1256d0, 5.1356d0,
     & 5.1457d0, 5.1557d0, 5.1657d0, 5.1757d0, 5.1857d0, 5.1957d0,
     & 5.2057d0, 5.2156d0, 5.2255d0, 5.2354d0, 5.2453d0, 5.2552d0,
     & 5.2653d0, 5.2754d0, 5.2855d0, 5.2956d0, 5.3058d0, 5.3159d0,
     & 5.3261d0, 5.3363d0, 5.3464d0, 5.3565d0, 5.3666d0, 5.3765d0,
     & 5.3864d0, 5.3965d0, 5.4065d0, 5.4166d0, 5.4267d0, 5.4368d0,
     & 5.4470d0, 5.4572d0, 5.4674d0, 5.4776d0, 5.4879d0, 5.4981d0,
     & 5.5082d0, 5.5182d0, 5.5283d0, 5.5383d0, 5.5482d0, 5.5582d0,
     & 5.5682d0, 5.5781d0, 5.5881d0, 5.5982d0, 5.6084d0, 5.6186d0,
     & 5.6288d0, 5.6390d0, 5.6493d0, 5.6596d0, 5.6699d0, 5.6802d0,
     & 5.6904d0, 5.7007d0, 5.7109d0, 5.7209d0, 5.7311d0, 5.7414d0,
     & 5.7516d0, 5.7618d0, 5.7720d0, 5.7822d0, 5.7924d0, 5.8028d0,
     & 5.8131d0, 5.8234d0, 5.8339d0, 5.8440d0, 5.8543d0, 5.8645d0,
     & 5.8747d0, 5.8848d0, 5.8951d0, 5.9053d0, 5.9155d0, 5.9256d0,
     & 5.9360d0, 5.9462d0, 5.9564d0, 5.9667d0, 5.9770d0, 5.9872d0,
     & 5.9975d0, 6.0079d0, 6.0183d0, 6.0286d0, 6.0390d0, 6.0492d0,
     & 6.0594d0, 6.0699d0, 6.0801d0, 6.0903d0, 6.1007d0, 6.1110d0,
     & 6.1214d0, 6.1315d0, 6.1418d0, 6.1523d0, 6.1626d0, 6.1731d0,
     & 6.1833d0, 6.1937d0, 6.2043d0, 6.2148d0, 6.2251d0, 6.2356d0,
     & 6.2461d0, 6.2567d0, 6.2671d0, 6.2776d0, 6.2879d0, 6.2983d0,
     & 6.3088d0, 6.3191d0, 6.3295d0, 6.3398d0, 6.3501d0, 6.3606d0,
     & 6.3711d0, 6.3817d0, 6.3923d0, 6.4029d0, 6.4136d0, 6.4241d0,
     & 6.4348d0, 6.4454d0, 6.4560d0, 6.4666d0, 6.4770d0, 6.4875d0,
     & 6.4980d0, 6.5084d0, 6.5189d0, 6.5293d0, 6.5398d0, 6.5501d0,
     & 6.5605d0, 6.5710d0, 6.5814d0, 6.5919d0, 6.6024d0, 6.6130d0,
     & 6.6235d0, 6.6340d0, 6.6446d0, 6.6552d0, 6.6660d0, 6.6768d0,
     & 6.6874d0, 6.6982d0, 6.7090d0, 6.7198d0, 6.7305d0, 6.7413d0,
     & 6.7522d0, 6.7630d0, 6.7739d0, 6.7846d0, 6.7953d0, 6.8062d0,
     & 6.8170d0, 6.8277d0, 6.8384d0, 6.8491d0, 6.8597d0, 6.8702d0,
     & 6.8808d0, 6.8915d0, 6.9022d0, 6.9128d0, 6.9235d0, 6.9341d0,
     & 6.9448d0, 6.9555d0, 6.9661d0, 6.9770d0, 6.9880d0, 6.9989d0,
     & 7.0096d0, 7.0205d0, 7.0314d0, 7.0424d0, 7.0534d0, 7.0642d0,
     & 7.0749d0, 7.0859d0, 7.0970d0, 7.1079d0, 7.1189d0, 7.1300d0,
     & 7.1408d0, 7.1518d0, 7.1627d0, 7.1736d0, 7.1848d0, 7.1959d0,
     & 7.2067d0, 7.2176d0, 7.2284d0, 7.2392d0, 7.2501d0, 7.2610d0,
     & 7.2718d0, 7.2826d0, 7.2936d0, 7.3045d0, 7.3154d0, 7.3264d0,
     & 7.3373d0, 7.3485d0, 7.3598d0, 7.3708d0, 7.3819d0, 7.3929d0,
     & 7.4041d0, 7.4152d0, 7.4263d0, 7.4377d0, 7.4491d0, 7.4604d0,
     & 7.4716d0, 7.4826d0, 7.4941d0, 7.5055d0, 7.5170d0, 7.5283d0,
     & 7.5395d0, 7.5507d0, 7.5617d0, 7.5728d0, 7.5841d0, 7.5954d0,
     & 7.6069d0, 7.6182d0, 7.6295d0, 7.6409d0, 7.6522d0, 7.6639d0,
     & 7.6754d0, 7.6870d0, 7.6985d0, 7.7096d0, 7.7209d0, 7.7320d0,
     & 7.7432d0, 7.7545d0, 7.7658d0, 7.7772d0, 7.7885d0, 7.7999d0,
     & 7.8115d0, 7.8229d0, 7.8347d0, 7.8460d0, 7.8577d0, 7.8693d0,
     & 7.8810d0, 7.8925d0, 7.9039d0, 7.9156d0, 7.9271d0, 7.9386d0,
     & 7.9502d0, 7.9618d0, 7.9735d0, 7.9851d0, 7.9969d0, 8.0085d0,
     & 8.0203d0, 8.0320d0, 8.0439d0, 8.0555d0, 8.0670d0, 8.0788d0,
     & 8.0904d0, 8.1023d0, 8.1139d0, 8.1258d0, 8.1374d0, 8.1490d0,
     & 8.1606d0, 8.1722d0, 8.1840d0, 8.1960d0, 8.2076d0, 8.2194d0,
     & 8.2313d0, 8.2435d0, 8.2551d0, 8.2672d0, 8.2792d0, 8.2912d0,
     & 8.3032d0, 8.3152d0, 8.3272d0, 8.3393d0, 8.3514d0, 8.3633d0,
     & 8.3754d0, 8.3875d0, 8.3996d0, 8.4119d0, 8.4243d0, 8.4367d0,
     & 8.4491d0, 8.4615d0, 8.4738d0, 8.4862d0, 8.4987d0, 8.5108d0,
     & 8.5232d0, 8.5353d0, 8.5476d0, 8.5598d0, 8.5721d0, 8.5844d0,
     & 8.5967d0, 8.6090d0, 8.6213d0, 8.6335d0, 8.6461d0, 8.6585d0,
     & 8.6711d0, 8.6836d0, 8.6963d0, 8.7089d0, 8.7211d0, 8.7337d0,
     & 8.7462d0, 8.7587d0, 8.7715d0, 8.7842d0, 8.7970d0, 8.8098d0,
     & 8.8225d0, 8.8349d0, 8.8475d0, 8.8603d0, 8.8727d0, 8.8856d0,
     & 8.8985d0, 8.9113d0, 8.9242d0, 8.9370d0, 8.9498d0, 8.9627d0,
     & 8.9756d0, 8.9887d0, 9.0019d0, 9.0149d0, 9.0278d0, 9.0410d0,
     & 9.0536d0, 9.0665d0, 9.0797d0, 9.0928d0, 9.1060d0, 9.1193d0,
     & 9.1325d0, 9.1457d0, 9.1589d0, 9.1724d0, 9.1856d0, 9.1992d0,
     & 9.2127d0, 9.2256d0, 9.2387d0, 9.2522d0, 9.2655d0, 9.2787d0,
     & 9.2918d0, 9.3053d0, 9.3184d0, 9.3317d0, 9.3452d0, 9.3587d0,
     & 9.3726d0, 9.3861d0, 9.3994d0, 9.4132d0, 9.4269d0, 9.4405d0,
     & 9.4545d0, 9.4686d0, 9.4826d0, 9.4962d0, 9.5098d0, 9.5233d0,
     & 9.5372d0, 9.5513d0, 9.5651d0, 9.5793d0, 9.5937d0, 9.6077d0,
     & 9.6217d0, 9.6358d0, 9.6499d0, 9.6643d0, 9.6786d0, 9.6930d0,
     & 9.7074d0, 9.7216d0, 9.7355d0, 9.7498d0, 9.7639d0, 9.7783d0,
     & 9.7927d0, 9.8074d0, 9.8219d0, 9.8362d0, 9.8504d0, 9.8645d0,
     & 9.8790d0, 9.8938d0, 9.9081d0, 9.9229d0, 9.9363d0, 9.9484d0,
     & 9.9593d0, 9.9688d0, 9.9774d0, 9.9845d0, 9.9905d0, 9.9948d0,
     & 9.9979d0, 9.9997d0, 9.9999d0, 9.9999d0, 9.9999d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0, 9.9999d0, 9.9999d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0, 9.9999d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0, 9.9999d0,10.0000d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0
     &/
      DATA (Imax ( 9,I), I= 1, 1000) /
     & 0.00004678d0, 0.00004678d0, 0.00010453d0, 0.00019213d0,
     & 0.00034230d0, 0.00058392d0, 0.00086248d0, 0.00125255d0,
     & 0.00176613d0, 0.00232631d0, 0.00300891d0, 0.00378504d0,
     & 0.00472627d0, 0.00571423d0, 0.00683221d0, 0.00800584d0,
     & 0.00920051d0, 0.01050199d0, 0.01185376d0, 0.01320452d0,
     & 0.01465244d0, 0.01616956d0, 0.01771929d0, 0.01928953d0,
     & 0.02087427d0, 0.02251281d0, 0.02419798d0, 0.02592532d0,
     & 0.02765841d0, 0.02943081d0, 0.03125361d0, 0.03311123d0,
     & 0.03493006d0, 0.03676043d0, 0.03863615d0, 0.04058785d0,
     & 0.04249100d0, 0.04440238d0, 0.04635130d0, 0.04835124d0,
     & 0.05032766d0, 0.05231633d0, 0.05432661d0, 0.05636876d0,
     & 0.05841715d0, 0.06047111d0, 0.06249724d0, 0.06459598d0,
     & 0.06669154d0, 0.06879767d0, 0.07090467d0, 0.07302369d0,
     & 0.07516755d0, 0.07729269d0, 0.07944742d0, 0.08161106d0,
     & 0.08377176d0, 0.08598673d0, 0.08816650d0, 0.09036259d0,
     & 0.09256632d0, 0.09477837d0, 0.09699693d0, 0.09923641d0,
     & 0.10149322d0, 0.10372874d0, 0.10597008d0, 0.10824341d0,
     & 0.11048557d0, 0.11278239d0, 0.11509854d0, 0.11739013d0,
     & 0.11968621d0, 0.12198499d0, 0.12426543d0, 0.12659873d0,
     & 0.12895314d0, 0.13129528d0, 0.13362557d0, 0.13597137d0,
     & 0.13826486d0, 0.14061025d0, 0.14299634d0, 0.14536984d0,
     & 0.14774333d0, 0.15011798d0, 0.15245335d0, 0.15479533d0,
     & 0.15720704d0, 0.15962303d0, 0.16203962d0, 0.16445574d0,
     & 0.16683376d0, 0.16920392d0, 0.17160590d0, 0.17406029d0,
     & 0.17651784d0, 0.17895827d0, 0.18138787d0, 0.18378069d0,
     & 0.18617083d0, 0.18858778d0, 0.19106458d0, 0.19354507d0,
     & 0.19602461d0, 0.19846840d0, 0.20087545d0, 0.20327963d0,
     & 0.20572020d0, 0.20820215d0, 0.21070902d0, 0.21323130d0,
     & 0.21572340d0, 0.21816732d0, 0.22058986d0, 0.22301434d0,
     & 0.22551881d0, 0.22805534d0, 0.23059128d0, 0.23312435d0,
     & 0.23561378d0, 0.23807770d0, 0.24052362d0, 0.24297205d0,
     & 0.24549323d0, 0.24806075d0, 0.25062561d0, 0.25314614d0,
     & 0.25563189d0, 0.25811484d0, 0.26057866d0, 0.26306301d0,
     & 0.26559219d0, 0.26818472d0, 0.27079406d0, 0.27333331d0,
     & 0.27584144d0, 0.27836752d0, 0.28089395d0, 0.28340229d0,
     & 0.28595543d0, 0.28855360d0, 0.29117435d0, 0.29374859d0,
     & 0.29627424d0, 0.29879650d0, 0.30131805d0, 0.30384025d0,
     & 0.30636480d0, 0.30889246d0, 0.31151673d0, 0.31411558d0,
     & 0.31670639d0, 0.31924880d0, 0.32178959d0, 0.32433102d0,
     & 0.32687438d0, 0.32942024d0, 0.33203349d0, 0.33465365d0,
     & 0.33727098d0, 0.33984944d0, 0.34242561d0, 0.34498140d0,
     & 0.34753919d0, 0.35012093d0, 0.35272640d0, 0.35533336d0,
     & 0.35797346d0, 0.36056748d0, 0.36319536d0, 0.36579856d0,
     & 0.36838022d0, 0.37096277d0, 0.37352490d0, 0.37615281d0,
     & 0.37878743d0, 0.38139656d0, 0.38402936d0, 0.38664734d0,
     & 0.38926208d0, 0.39185399d0, 0.39446828d0, 0.39706114d0,
     & 0.39965567d0, 0.40225220d0, 0.40492013d0, 0.40752003d0,
     & 0.41014802d0, 0.41277117d0, 0.41539362d0, 0.41803935d0,
     & 0.42064238d0, 0.42324820d0, 0.42587927d0, 0.42849123d0,
     & 0.43113023d0, 0.43375435d0, 0.43644196d0, 0.43907830d0,
     & 0.44173771d0, 0.44437501d0, 0.44696853d0, 0.44960949d0,
     & 0.45225254d0, 0.45487455d0, 0.45749786d0, 0.46018353d0,
     & 0.46282303d0, 0.46543783d0, 0.46807691d0, 0.47069421d0,
     & 0.47333652d0, 0.47600335d0, 0.47862554d0, 0.48127237d0,
     & 0.48392096d0, 0.48663712d0, 0.48930049d0, 0.49196985d0,
     & 0.49464089d0, 0.49733800d0, 0.50001329d0, 0.50269085d0,
     & 0.50534749d0, 0.50803047d0, 0.51067013d0, 0.51333606d0,
     & 0.51601106d0, 0.51873779d0, 0.52140838d0, 0.52410460d0,
     & 0.52675360d0, 0.52942878d0, 0.53208220d0, 0.53476149d0,
     & 0.53744310d0, 0.54012650d0, 0.54278839d0, 0.54543203d0,
     & 0.54803890d0, 0.55075347d0, 0.55342072d0, 0.55611473d0,
     & 0.55881131d0, 0.56150991d0, 0.56421077d0, 0.56688976d0,
     & 0.56959426d0, 0.57229996d0, 0.57495517d0, 0.57762158d0,
     & 0.58030254d0, 0.58301252d0, 0.58574504d0, 0.58845651d0,
     & 0.59117126d0, 0.59383982d0, 0.59653556d0, 0.59923452d0,
     & 0.60193646d0, 0.60466564d0, 0.60734707d0, 0.60995775d0,
     & 0.61260867d0, 0.61524683d0, 0.61788899d0, 0.62063503d0,
     & 0.62335771d0, 0.62605822d0, 0.62876123d0, 0.63144159d0,
     & 0.63409948d0, 0.63683343d0, 0.63950974d0, 0.64219034d0,
     & 0.64488548d0, 0.64758742d0, 0.65021914d0, 0.65290511d0,
     & 0.65569586d0, 0.65846401d0, 0.66120869d0, 0.66398060d0,
     & 0.66668034d0, 0.66938186d0, 0.67208159d0, 0.67476547d0,
     & 0.67749447d0, 0.68020791d0, 0.68292779d0, 0.68555063d0,
     & 0.68833256d0, 0.69111621d0, 0.69391483d0, 0.69671661d0,
     & 0.69946998d0, 0.70220196d0, 0.70487636d0, 0.70757008d0,
     & 0.71027470d0, 0.71301281d0, 0.71576273d0, 0.71836525d0,
     & 0.72102571d0, 0.72365361d0, 0.72641456d0, 0.72922903d0,
     & 0.73202020d0, 0.73486382d0, 0.73758245d0, 0.74027431d0,
     & 0.74289805d0, 0.74558061d0, 0.74831772d0, 0.75106889d0,
     & 0.75385463d0, 0.75651568d0, 0.75918114d0, 0.76185060d0,
     & 0.76465434d0, 0.76745939d0, 0.77026689d0, 0.77312773d0,
     & 0.77591354d0, 0.77860910d0, 0.78128350d0, 0.78394109d0,
     & 0.78666878d0, 0.78940862d0, 0.79218316d0, 0.79485905d0,
     & 0.79759109d0, 0.80032688d0, 0.80317169d0, 0.80601907d0,
     & 0.80884188d0, 0.81166637d0, 0.81446928d0, 0.81716871d0,
     & 0.81990290d0, 0.82260966d0, 0.82533640d0, 0.82810503d0,
     & 0.83085424d0, 0.83347845d0, 0.83610868d0, 0.83879662d0,
     & 0.84146237d0, 0.84413230d0, 0.84688520d0, 0.84958977d0,
     & 0.85231239d0, 0.85492998d0, 0.85750252d0, 0.86009181d0,
     & 0.86271149d0, 0.86536390d0, 0.86800164d0, 0.87067574d0,
     & 0.87335670d0, 0.87598991d0, 0.87862700d0, 0.88121450d0,
     & 0.88385856d0, 0.88650554d0, 0.88920861d0, 0.89187503d0,
     & 0.89450395d0, 0.89714390d0, 0.89974505d0, 0.90233707d0,
     & 0.90498090d0, 0.90761739d0, 0.91029453d0, 0.91295177d0,
     & 0.91561592d0, 0.91823202d0, 0.92085278d0, 0.92347741d0,
     & 0.92610544d0, 0.92873615d0, 0.93147743d0, 0.93416190d0,
     & 0.93682337d0, 0.93944144d0, 0.94207650d0, 0.94470280d0,
     & 0.94734323d0, 0.95001292d0, 0.95269668d0, 0.95533276d0,
     & 0.95803171d0, 0.96062893d0, 0.96323103d0, 0.96586370d0,
     & 0.96849930d0, 0.97113860d0, 0.97378069d0, 0.97651267d0,
     & 0.97918469d0, 0.98181266d0, 0.98448604d0, 0.98709476d0,
     & 0.98969632d0, 0.99236035d0, 0.99501485d0, 0.99771011d0,
     & 1.00041366d0, 1.00312388d0, 1.00573087d0, 1.00836980d0,
     & 1.01102531d0, 1.01368618d0, 1.01635063d0, 1.01901913d0,
     & 1.02162313d0, 1.02420878d0, 1.02678037d0, 1.02945137d0,
     & 1.03211522d0, 1.03474629d0, 1.03738081d0, 1.04005492d0,
     & 1.04274237d0, 1.04546654d0, 1.04819775d0, 1.05093467d0,
     & 1.05370355d0, 1.05644858d0, 1.05908871d0, 1.06173217d0,
     & 1.06440568d0, 1.06704628d0, 1.06966054d0, 1.07225835d0,
     & 1.07492840d0, 1.07758987d0, 1.08024454d0, 1.08288014d0,
     & 1.08558011d0, 1.08829653d0, 1.09102404d0, 1.09376001d0,
     & 1.09650135d0, 1.09924722d0, 1.10194242d0, 1.10455823d0,
     & 1.10717833d0, 1.10980177d0, 1.11244154d0, 1.11507046d0,
     & 1.11765337d0, 1.12033403d0, 1.12292290d0, 1.12547827d0,
     & 1.12816632d0, 1.13089919d0, 1.13366473d0, 1.13644540d0,
     & 1.13920712d0, 1.14197707d0, 1.14472580d0, 1.14750791d0,
     & 1.15012729d0, 1.15283346d0, 1.15559852d0, 1.15825713d0,
     & 1.16089582d0, 1.16350162d0, 1.16609001d0, 1.16869605d0,
     & 1.17126465d0, 1.17382586d0, 1.17638075d0, 1.17912650d0,
     & 1.18191981d0, 1.18470061d0, 1.18746579d0, 1.19020998d0,
     & 1.19296134d0, 1.19571900d0, 1.19848228d0, 1.20127845d0,
     & 1.20407856d0, 1.20688212d0, 1.20952141d0, 1.21208298d0,
     & 1.21467543d0, 1.21725595d0, 1.21988666d0, 1.22248173d0,
     & 1.22507107d0, 1.22765565d0, 1.23020864d0, 1.23298085d0,
     & 1.23577416d0, 1.23851740d0, 1.24133170d0, 1.24413490d0,
     & 1.24694347d0, 1.24975729d0, 1.25254595d0, 1.25533867d0,
     & 1.25810635d0, 1.26090527d0, 1.26348495d0, 1.26604402d0,
     & 1.26868200d0, 1.27127814d0, 1.27383792d0, 1.27639031d0,
     & 1.27893841d0, 1.28153956d0, 1.28410804d0, 1.28677142d0,
     & 1.28945935d0, 1.29228389d0, 1.29511595d0, 1.29795599d0,
     & 1.30080163d0, 1.30359197d0, 1.30638897d0, 1.30918884d0,
     & 1.31199265d0, 1.31482816d0, 1.31759667d0, 1.32034004d0,
     & 1.32291758d0, 1.32548690d0, 1.32804787d0, 1.33060288d0,
     & 1.33324015d0, 1.33584321d0, 1.33844316d0, 1.34111142d0,
     & 1.34393036d0, 1.34676075d0, 1.34959996d0, 1.35247397d0,
     & 1.35535514d0, 1.35815346d0, 1.36095572d0, 1.36376429d0,
     & 1.36660492d0, 1.36944771d0, 1.37222147d0, 1.37484384d0,
     & 1.37745440d0, 1.38002694d0, 1.38253593d0, 1.38503790d0,
     & 1.38762295d0, 1.39020419d0, 1.39278042d0, 1.39542437d0,
     & 1.39827240d0, 1.40113401d0, 1.40397513d0, 1.40682447d0,
     & 1.40952921d0, 1.41241741d0, 1.41528118d0, 1.41814828d0,
     & 1.42102063d0, 1.42392588d0, 1.42670465d0, 1.42925179d0,
     & 1.43178797d0, 1.43431687d0, 1.43681037d0, 1.43947852d0,
     & 1.44202209d0, 1.44456279d0, 1.44707286d0, 1.44957900d0,
     & 1.45205355d0, 1.45460045d0, 1.45721769d0, 1.45994842d0,
     & 1.46275163d0, 1.46549976d0, 1.46825683d0, 1.47099054d0,
     & 1.47375870d0, 1.47656083d0, 1.47945583d0, 1.48223710d0,
     & 1.48500633d0, 1.48770559d0, 1.49026132d0, 1.49277401d0,
     & 1.49531269d0, 1.49784267d0, 1.50036752d0, 1.50291598d0,
     & 1.50545967d0, 1.50788188d0, 1.51041722d0, 1.51292026d0,
     & 1.51547050d0, 1.51812410d0, 1.52076411d0, 1.52347624d0,
     & 1.52626026d0, 1.52908123d0, 1.53184974d0, 1.53462410d0,
     & 1.53740239d0, 1.54018652d0, 1.54297388d0, 1.54574275d0,
     & 1.54843950d0, 1.55112112d0, 1.55372965d0, 1.55626833d0,
     & 1.55882907d0, 1.56141388d0, 1.56396437d0, 1.56654036d0,
     & 1.56908357d0, 1.57165289d0, 1.57419157d0, 1.57663918d0,
     & 1.57924938d0, 1.58194530d0, 1.58465588d0, 1.58731782d0,
     & 1.59017360d0, 1.59306502d0, 1.59584129d0, 1.59862185d0,
     & 1.60140741d0, 1.60419643d0, 1.60707629d0, 1.60982418d0,
     & 1.61254740d0, 1.61522591d0, 1.61792457d0, 1.62040079d0,
     & 1.62286985d0, 1.62545645d0, 1.62803876d0, 1.63061678d0,
     & 1.63319159d0, 1.63576269d0, 1.63833082d0, 1.64080870d0,
     & 1.64337587d0, 1.64594245d0, 1.64855933d0, 1.65119207d0,
     & 1.65386546d0, 1.65654600d0, 1.65923429d0, 1.66204929d0,
     & 1.66483951d0, 1.66766441d0, 1.67055106d0, 1.67337918d0,
     & 1.67620885d0, 1.67898881d0, 1.68175530d0, 1.68445063d0,
     & 1.68716908d0, 1.68982172d0, 1.69237757d0, 1.69495928d0,
     & 1.69750690d0, 1.70005000d0, 1.70259166d0, 1.70510137d0,
     & 1.70763850d0, 1.71021998d0, 1.71289301d0, 1.71555007d0,
     & 1.71827948d0, 1.72101903d0, 1.72373593d0, 1.72645366d0,
     & 1.72917962d0, 1.73191237d0, 1.73480165d0, 1.73763585d0,
     & 1.74042881d0, 1.74313247d0, 1.74588454d0, 1.74862587d0,
     & 1.75132942d0, 1.75405800d0, 1.75666916d0, 1.75930548d0,
     & 1.76193547d0, 1.76444042d0, 1.76706338d0, 1.76965392d0,
     & 1.77224219d0, 1.77479804d0, 1.77742028d0, 1.78007019d0,
     & 1.78274059d0, 1.78554428d0, 1.78832734d0, 1.79111993d0,
     & 1.79392028d0, 1.79675865d0, 1.79960144d0, 1.80247855d0,
     & 1.80536020d0, 1.80814683d0, 1.81090724d0, 1.81364870d0,
     & 1.81637692d0, 1.81912696d0, 1.82186866d0, 1.82457364d0,
     & 1.82717860d0, 1.82975197d0, 1.83235097d0, 1.83494627d0,
     & 1.83753884d0, 1.84012890d0, 1.84271634d0, 1.84530127d0,
     & 1.84794927d0, 1.85059702d0, 1.85329652d0, 1.85601318d0,
     & 1.85876751d0, 1.86140716d0, 1.86405635d0, 1.86674309d0,
     & 1.86943555d0, 1.87213409d0, 1.87483823d0, 1.87747967d0,
     & 1.88012588d0, 1.88275206d0, 1.88533449d0, 1.88793874d0,
     & 1.89062941d0, 1.89331222d0, 1.89604843d0, 1.89886963d0,
     & 1.90168571d0, 1.90449727d0, 1.90727699d0, 1.90999150d0,
     & 1.91270316d0, 1.91532123d0, 1.91790712d0, 1.92057109d0,
     & 1.92330301d0, 1.92600036d0, 1.92862225d0, 1.93119299d0,
     & 1.93377566d0, 1.93639791d0, 1.93905663d0, 1.94172251d0,
     & 1.94451594d0, 1.94731367d0, 1.95003629d0, 1.95269132d0,
     & 1.95529258d0, 1.95791399d0, 1.96058857d0, 1.96322286d0,
     & 1.96600044d0, 1.96880257d0, 1.97150850d0, 1.97420931d0,
     & 1.97693670d0, 1.97965789d0, 1.98234773d0, 1.98506737d0,
     & 1.98778200d0, 1.99049389d0, 1.99314392d0, 1.99557853d0,
     & 1.99810755d0, 2.00076437d0, 2.00340867d0, 2.00606918d0,
     & 2.00871229d0, 2.01139593d0, 2.01405430d0, 2.01672053d0,
     & 2.01936245d0, 2.02210045d0, 2.02487516d0, 2.02755857d0,
     & 2.03028679d0, 2.03303337d0, 2.03582811d0, 2.03864574d0,
     & 2.04142547d0, 2.04420042d0, 2.04697037d0, 2.04985785d0,
     & 2.05262065d0, 2.05550408d0, 2.05850530d0, 2.06109118d0,
     & 2.06364179d0, 2.06612873d0, 2.06858349d0, 2.07106638d0,
     & 2.07354784d0, 2.07623553d0, 2.07882619d0, 2.08155799d0,
     & 2.08417869d0, 2.08678842d0, 2.08941650d0, 2.09205389d0,
     & 2.09470057d0, 2.09745145d0, 2.10020876d0, 2.10300231d0,
     & 2.10556197d0, 2.10813141d0, 2.11065269d0, 2.11319470d0,
     & 2.11559939d0, 2.11832166d0, 2.12103629d0, 2.12374353d0,
     & 2.12637591d0, 2.12897277d0, 2.13165903d0, 2.13419008d0,
     & 2.13671517d0, 2.13951302d0, 2.14230537d0, 2.14500737d0,
     & 2.14761639d0, 2.15025401d0, 2.15288973d0, 2.15552592d0,
     & 2.15830684d0, 2.16102505d0, 2.16391063d0, 2.16681337d0,
     & 2.16945052d0, 2.17210031d0, 2.17484522d0, 2.17768860d0,
     & 2.18063283d0, 2.18358231d0, 2.18653679d0, 2.18934631d0,
     & 2.19225335d0, 2.19496155d0, 2.19747186d0, 2.20000553d0,
     & 2.20250082d0, 2.20511365d0, 2.20769024d0, 2.21013713d0,
     & 2.21257734d0, 2.21498394d0, 2.21742392d0, 2.21973491d0,
     & 2.22253346d0, 2.22548413d0, 2.22843218d0, 2.23140836d0,
     & 2.23413539d0, 2.23689389d0, 2.23967242d0, 2.24252295d0,
     & 2.24543142d0, 2.24832153d0, 2.25122643d0, 2.25399947d0,
     & 2.25655293d0, 2.25911641d0, 2.26168823d0, 2.26442170d0,
     & 2.26712751d0, 2.26984811d0, 2.27250290d0, 2.27513337d0,
     & 2.27778220d0, 2.28029490d0, 2.28279233d0, 2.28554201d0,
     & 2.28825331d0, 2.29095817d0, 2.29378033d0, 2.29659843d0,
     & 2.29925895d0, 2.30191541d0, 2.30453777d0, 2.30703497d0,
     & 2.30965352d0, 2.31214547d0, 2.31460452d0, 2.31709242d0,
     & 2.31954813d0, 2.32218337d0, 2.32496953d0, 2.32790208d0,
     & 2.33085537d0, 2.33385134d0, 2.33698487d0, 2.33993196d0,
     & 2.34285688d0, 2.34582186d0, 2.34901857d0, 2.35225129d0,
     & 2.35486865d0, 2.35737062d0, 2.35988355d0, 2.36234808d0,
     & 2.36486602d0, 2.36734056d0, 2.37000394d0, 2.37269139d0,
     & 2.37537169d0, 2.37782216d0, 2.38008308d0, 2.38281488d0,
     & 2.38551283d0, 2.38821101d0, 2.39086628d0, 2.39368248d0,
     & 2.39652824d0, 2.39909720d0, 2.40163445d0, 2.40417099d0,
     & 2.40670705d0, 2.40939760d0, 2.41192985d0, 2.41458297d0,
     & 2.41746926d0, 2.42048502d0, 2.42322326d0, 2.42613769d0,
     & 2.42934036d0, 2.43277407d0, 2.43618155d0, 2.43978381d0,
     & 2.44291162d0, 2.44569421d0, 2.44835997d0, 2.45127130d0,
     & 2.45409632d0, 2.45716286d0, 2.45943069d0, 2.46168900d0,
     & 2.46390581d0, 2.46624422d0, 2.46835852d0, 2.47097945d0,
     & 2.47394729d0, 2.47672558d0, 2.47902226d0, 2.48134804d0,
     & 2.48348451d0, 2.48621345d0, 2.48893976d0, 2.49150729d0,
     & 2.49397945d0, 2.49645042d0, 2.49904251d0, 2.50153780d0,
     & 2.50412869d0, 2.50674844d0, 2.50994468d0, 2.51253772d0,
     & 2.51548767d0, 2.51841807d0, 2.52112556d0, 2.52384663d0,
     & 2.52680635d0, 2.52964783d0, 2.53287935d0, 2.53646016d0,
     & 2.53928447d0, 2.54153752d0, 2.54439735d0, 2.54690361d0,
     & 2.54959011d0, 2.55250239d0, 2.55540347d0, 2.55828595d0,
     & 2.56110358d0, 2.56356621d0, 2.56580091d0, 2.56848311d0,
     & 2.57116127d0, 2.57371140d0, 2.57650352d0, 2.57913804d0,
     & 2.58207870d0, 2.58436847d0, 2.58646894d0, 2.58912039d0
     &/
      DATA (Imax ( 9,I), I= 1001, 2100) /
     & 2.59152746d0, 2.59582973d0, 2.60040998d0, 2.60499620d0,
     & 2.60780120d0, 2.61080027d0, 2.61381483d0, 2.61653519d0,
     & 2.61991644d0, 2.62300372d0, 2.62561703d0, 2.62851191d0,
     & 2.62951970d0, 2.63053536d0, 2.63151813d0, 2.63441157d0,
     & 2.63690162d0, 2.63934517d0, 2.66950440d0, 2.69963670d0,
     & 2.70312142d0, 2.70642519d0, 2.70893836d0, 2.71200919d0,
     & 2.71507359d0, 2.71813369d0, 2.72118855d0, 2.72395897d0,
     & 2.72675753d0, 2.70207429d0, 2.67777014d0, 2.67976427d0,
     & 2.68161011d0, 2.68427324d0, 2.68637037d0, 2.68843532d0,
     & 2.69053030d0, 2.69287181d0, 2.69546127d0, 2.69868326d0,
     & 2.70181823d0, 2.70463634d0, 2.72601032d0, 2.72922325d0,
     & 2.75103021d0, 2.77284884d0, 2.77606845d0, 2.77888680d0,
     & 2.80925512d0, 2.83964133d0, 2.86941290d0, 2.87189341d0,
     & 2.87433171d0, 2.85840797d0, 2.86084723d0, 2.84465718d0,
     & 2.82846284d0, 2.83090138d0, 2.83371234d0, 2.82704759d0,
     & 2.80271220d0, 2.77854776d0, 2.78135848d0, 2.78550029d0,
     & 2.81573820d0, 2.84607196d0, 2.84875607d0, 2.85143471d0,
     & 2.88151646d0, 2.91164899d0, 2.89603734d0, 2.89811087d0,
     & 2.90000033d0, 2.90201378d0, 2.92188454d0, 2.91573405d0,
     & 2.89078283d0, 2.89351368d0, 2.90227008d0, 2.88363719d0,
     & 2.88681340d0, 2.91709733d0, 2.94737124d0, 2.95602036d0,
     & 2.95932841d0, 2.94535232d0, 2.93157053d0, 2.93660307d0,
     & 2.94135928d0, 2.93983912d0, 2.93805361d0, 2.91314149d0,
     & 2.88854957d0, 2.86396694d0, 2.86101222d0, 2.86343265d0,
     & 2.86394715d0, 2.86464524d0, 2.86531663d0, 2.86626649d0,
     & 2.86800003d0, 2.86995316d0, 2.87320352d0, 2.87629032d0,
     & 2.88170552d0, 2.89595175d0, 2.91020107d0, 2.92442322d0,
     & 2.94571900d0, 2.95960069d0, 2.97348690d0, 2.98684478d0,
     & 3.00032306d0, 3.00416660d0, 3.00655293d0, 3.00654840d0,
     & 2.99774432d0, 2.98897982d0, 2.98026228d0, 2.96427751d0,
     & 2.95565033d0, 2.94703674d0, 2.93843246d0, 2.93034673d0,
     & 2.93190145d0, 2.93458962d0, 2.93734765d0, 2.94007373d0,
     & 2.94324207d0, 2.94638753d0, 2.94973135d0, 2.95502472d0,
     & 2.96001935d0, 2.96500015d0, 2.96908808d0, 2.97722507d0,
     & 2.98551297d0, 2.99379873d0, 3.00205112d0, 3.01571012d0,
     & 3.02934575d0, 3.04298067d0, 3.05475879d0, 3.06644535d0,
     & 3.07813716d0, 3.09011960d0, 3.08706713d0, 3.08434701d0,
     & 3.09223914d0, 3.08969259d0, 3.08125544d0, 3.07284260d0,
     & 3.06442213d0, 3.05599475d0, 3.04799604d0, 3.03965163d0,
     & 3.03130913d0, 3.03395343d0, 3.03881311d0, 3.03307056d0,
     & 3.03747892d0, 3.04188704d0, 3.04604459d0, 3.04991961d0,
     & 3.05940151d0, 3.06211305d0, 3.06513691d0, 3.07187986d0,
     & 3.07845283d0, 3.08264470d0, 3.08344054d0, 3.08452177d0,
     & 3.08560228d0, 3.08693600d0, 3.08855534d0, 3.08469415d0,
     & 3.08972669d0, 3.09926391d0, 3.10488677d0, 3.11546731d0,
     & 3.17717409d0, 3.29082990d0, 3.28994751d0, 3.35676599d0,
     & 3.26485991d0, 3.28420305d0, 3.29742169d0, 3.32824421d0,
     & 3.36484361d0, 3.38020253d0, 3.40822172d0, 3.44516945d0,
     & 3.48223281d0, 3.50975180d0, 3.53902102d0, 3.56314373d0,
     & 3.58282042d0, 3.60193491d0, 3.63032079d0, 3.64583158d0,
     & 3.67706347d0, 3.70493317d0, 3.72955108d0, 3.75879598d0,
     & 3.78474641d0, 3.80864549d0, 3.83729768d0, 3.86010671d0,
     & 3.89945078d0, 3.93133926d0, 3.95973945d0, 3.98789144d0,
     & 4.01335907d0, 4.04255724d0, 4.07234287d0, 4.10139275d0,
     & 4.13011408d0, 4.15779734d0, 4.18582392d0, 4.21475029d0,
     & 4.24821997d0, 4.27774477d0, 4.30734348d0, 4.33812761d0,
     & 4.36631012d0, 4.39554024d0, 4.42552471d0, 4.45387936d0,
     & 4.48397207d0, 4.51204920d0, 4.54126596d0, 4.56683493d0,
     & 4.59511089d0, 4.62310743d0, 4.65100718d0, 4.67884207d0,
     & 4.70945930d0, 4.73793554d0, 4.76250792d0, 4.79860544d0,
     & 4.82584381d0, 4.85644388d0, 4.88596296d0, 4.92383909d0,
     & 4.95215559d0, 4.98156929d0, 5.00985575d0, 5.03654957d0,
     & 5.06742954d0, 5.08705330d0, 5.11676502d0, 5.14766693d0,
     & 5.17725754d0, 5.19618750d0, 5.22650957d0, 5.25679064d0,
     & 5.28552675d0, 5.30954552d0, 5.33242226d0, 5.36525011d0,
     & 5.39301109d0, 5.42126894d0, 5.45004559d0, 5.48216581d0,
     & 5.51188469d0, 5.54241467d0, 5.56955051d0, 5.59795427d0,
     & 5.62704706d0, 5.65576887d0, 5.69093800d0, 5.71782112d0,
     & 5.75079775d0, 5.78076839d0, 5.80581141d0, 5.84486389d0,
     & 5.87415171d0, 5.90339375d0, 5.93005371d0, 5.96219587d0,
     & 5.99694967d0, 6.02796555d0, 6.04782009d0, 6.07643223d0,
     & 6.10269117d0, 6.12742567d0, 6.15533257d0, 6.17529440d0,
     & 6.20121384d0, 6.23283815d0, 6.26831245d0, 6.28868055d0,
     & 6.31354666d0, 6.34370899d0, 6.37274694d0, 6.39887524d0,
     & 6.43401098d0, 6.46260881d0, 6.49134970d0, 6.52063894d0,
     & 6.54866409d0, 6.57118273d0, 6.60312939d0, 6.63512421d0,
     & 6.66020679d0, 6.68833780d0, 6.71137524d0, 6.74283457d0,
     & 6.77192116d0, 6.80151081d0, 6.83086777d0, 6.85953569d0,
     & 6.88521957d0, 6.91229153d0, 6.93648481d0, 6.96240282d0,
     & 6.98883343d0, 7.01738167d0, 7.04585409d0, 7.07539034d0,
     & 7.10493803d0, 7.13583517d0, 7.16390610d0, 7.19303751d0,
     & 7.22170830d0, 7.24955034d0, 7.27929354d0, 7.30738449d0,
     & 7.33326197d0, 7.36248493d0, 7.39116240d0, 7.41928625d0,
     & 7.44822598d0, 7.47482300d0, 7.49777937d0, 7.52584124d0,
     & 7.55413246d0, 7.58550644d0, 7.61789131d0, 7.64860487d0,
     & 7.67507219d0, 7.70129919d0, 7.73033810d0, 7.75686884d0,
     & 7.78435612d0, 7.81431723d0, 7.84396982d0, 7.87592268d0,
     & 7.90656090d0, 7.92899847d0, 7.95434999d0, 7.98132944d0,
     & 8.00849819d0, 8.03606892d0, 8.06084728d0, 8.09011173d0,
     & 8.11992836d0, 8.14994240d0, 8.17851734d0, 8.20796299d0,
     & 8.23224926d0, 8.25948620d0, 8.28802299d0, 8.31677628d0,
     & 8.34677315d0, 8.37434578d0, 8.40478611d0, 8.43570328d0,
     & 8.46263695d0, 8.48623943d0, 8.51411057d0, 8.54096031d0,
     & 8.56749916d0, 8.59321690d0, 8.61992550d0, 8.64791965d0,
     & 8.67706966d0, 8.70518970d0, 8.73333168d0, 8.76327896d0,
     & 8.79307556d0, 8.82211876d0, 8.85247135d0, 8.88313293d0,
     & 8.91152859d0, 8.93794250d0, 8.96652985d0, 8.99043465d0,
     & 9.01813889d0, 9.04342175d0, 9.07007599d0, 9.09327412d0,
     & 9.12040424d0, 9.14720917d0, 9.17605972d0, 9.20312881d0,
     & 9.23067093d0, 9.25843334d0, 9.28552437d0, 9.31524658d0,
     & 9.34325314d0, 9.37433147d0, 9.40453148d0, 9.43495941d0,
     & 9.46598816d0, 9.49078369d0, 9.51834297d0, 9.54566574d0,
     & 9.56917858d0, 9.59605408d0, 9.62360954d0, 9.65104103d0,
     & 9.68079376d0, 9.70789242d0, 9.73492813d0, 9.76066589d0,
     & 9.78713512d0, 9.81112766d0, 9.83722496d0, 9.86700344d0,
     & 9.89563751d0, 9.92384624d0, 9.95191479d0, 9.98187447d0,
     &10.00581551d0,10.03147507d0,10.06200886d0,10.08743191d0,
     &10.11618328d0,10.14453697d0,10.17130852d0,10.19953442d0,
     &10.22583389d0,10.25097275d0,10.27846527d0,10.30838776d0,
     &10.33539581d0,10.36183643d0,10.39097786d0,10.41907406d0,
     &10.44553471d0,10.47236919d0,10.50004959d0,10.52842999d0,
     &10.55497551d0,10.57912445d0,10.60565853d0,10.63311100d0,
     &10.65979290d0,10.68798923d0,10.71436787d0,10.74110889d0,
     &10.76776791d0,10.79962540d0,10.82544518d0,10.85157394d0,
     &10.87642479d0,10.90170574d0,10.93230057d0,10.96239948d0,
     &10.99190807d0,11.02083778d0,11.04797459d0,11.07418823d0,
     &11.10223866d0,11.13282108d0,11.16149616d0,11.19116116d0,
     &11.21906090d0,11.24841785d0,11.27630138d0,11.30395412d0,
     &11.33429241d0,11.36385536d0,11.39601517d0,11.42245197d0,
     &11.44768047d0,11.47570038d0,11.50381660d0,11.53032589d0,
     &11.55581665d0,11.58264160d0,11.61094284d0,11.63972187d0,
     &11.66684055d0,11.69481277d0,11.72414017d0,11.74805737d0,
     &11.77385902d0,11.80277061d0,11.83202839d0,11.85943890d0,
     &11.88763905d0,11.91624928d0,11.94637966d0,11.97666359d0,
     &12.00535393d0,12.03185558d0,12.06092453d0,12.09199333d0,
     &12.11925507d0,12.14655018d0,12.17472744d0,12.20402527d0,
     &12.23146534d0,12.25709438d0,12.28456593d0,12.31089783d0,
     &12.33920860d0,12.36658859d0,12.39354515d0,12.42311954d0,
     &12.44911003d0,12.47608948d0,12.50210285d0,12.52891922d0,
     &12.55618572d0,12.58501244d0,12.61201763d0,12.63909245d0,
     &12.66693592d0,12.69844246d0,12.72614670d0,12.75406361d0,
     &12.78381729d0,12.81389332d0,12.84394169d0,12.86957169d0,
     &12.89451599d0,12.92573261d0,12.95318413d0,12.98435879d0,
     &13.01129913d0,13.04102993d0,13.07105160d0,13.10068798d0,
     &13.13012314d0,13.15622044d0,13.18236351d0,13.21016693d0,
     &13.23836613d0,13.26457405d0,13.29422760d0,13.32011318d0,
     &13.34640503d0,13.36552620d0,13.39388084d0,13.42270660d0,
     &13.45213223d0,13.47879124d0,13.50700951d0,13.53695202d0,
     &13.56620979d0,13.59376144d0,13.62238216d0,13.65128708d0,
     &13.68254185d0,13.71001911d0,13.73923683d0,13.76553726d0,
     &13.79261303d0,13.82045937d0,13.84721088d0,13.87401676d0,
     &13.90519905d0,13.93500900d0,13.96799278d0,13.99535561d0,
     &14.02001190d0,14.04841614d0,14.07829094d0,14.11001015d0,
     &14.13851357d0,14.16963005d0,14.19632339d0,14.22251606d0,
     &14.25035667d0,14.28001308d0,14.31270409d0,14.34068012d0,
     &14.36850739d0,14.39417744d0,14.42420959d0,14.45498180d0,
     &14.48555660d0,14.51593304d0,14.54164028d0,14.56749344d0,
     &14.59421539d0,14.62153053d0,14.65320015d0,14.68424511d0,
     &14.71230507d0,14.73921204d0,14.77075672d0,14.80288124d0,
     &14.83489704d0,14.86003780d0,14.88704205d0,14.91537476d0,
     &14.94417858d0,14.97460079d0,14.99524784d0,15.02448463d0,
     &15.05051422d0,15.08019257d0,15.10842514d0,15.13996696d0,
     &15.16838551d0,15.19620323d0,15.22398472d0,15.25254536d0,
     &15.28242397d0,15.31231880d0,15.34148884d0,15.36829376d0,
     &15.39773273d0,15.42909241d0,15.46052933d0,15.49515343d0,
     &15.52326488d0,15.55433846d0,15.58309746d0,15.61144638d0,
     &15.63905048d0,15.66436768d0,15.69217491d0,15.72188282d0,
     &15.75235271d0,15.78750134d0,15.81750584d0,15.84720039d0,
     &15.87581635d0,15.90274906d0,15.92882347d0,15.95609283d0,
     &15.98711300d0,16.01434517d0,16.04065323d0,16.06579208d0,
     &16.09102249d0,16.11858368d0,16.14814758d0,16.17865562d0,
     &16.20516968d0,16.23515320d0,16.26290321d0,16.29237366d0,
     &16.32497025d0,16.35434151d0,16.38588142d0,16.41741943d0,
     &16.44528580d0,16.47744560d0,16.51006317d0,16.54168510d0,
     &16.57294464d0,16.59946060d0,16.62710762d0,16.65588188d0,
     &16.68839264d0,16.71814728d0,16.74942780d0,16.78079796d0,
     &16.81306267d0,16.84425735d0,16.87545013d0,16.90594673d0,
     &16.94148445d0,16.96915817d0,16.99699783d0,17.02606583d0,
     &17.05486107d0,17.08056068d0,17.11020660d0,17.13964462d0,
     &17.16768265d0,17.19646263d0,17.22747612d0,17.25734520d0,
     &17.28746033d0,17.31590652d0,17.34505653d0,17.37476349d0,
     &17.40546036d0,17.43472290d0,17.46010399d0,17.49136734d0,
     &17.52415276d0,17.56103706d0,17.59683800d0,17.63513756d0,
     &17.66545105d0,17.69633865d0,17.72794533d0,17.75862885d0,
     &17.78550148d0,17.80928040d0,17.83829308d0,17.86711121d0,
     &17.88834763d0,17.91752815d0,17.94716644d0,17.97955322d0,
     &18.01400566d0,18.04446030d0,18.07595825d0,18.10995293d0,
     &18.14391518d0,18.17663002d0,18.20753288d0,18.24102783d0,
     &18.27476120d0,18.29737663d0,18.32814026d0,18.36182213d0,
     &18.39151001d0,18.41938400d0,18.45169258d0,18.48195267d0,
     &18.51235390d0,18.54369545d0,18.58102417d0,18.61268234d0,
     &18.64571381d0,18.68070793d0,18.70751572d0,18.74375153d0,
     &18.77091599d0,18.80084038d0,18.82251549d0,18.85061264d0,
     &18.88191032d0,18.91426277d0,18.94770813d0,18.97695732d0,
     &19.01216125d0,19.04439545d0,19.07607269d0,19.10885811d0,
     &19.13794518d0,19.16703224d0,19.19587517d0,19.22780037d0,
     &19.25848389d0,19.29291153d0,19.32747459d0,19.35994911d0,
     &19.38758850d0,19.41276741d0,19.44123268d0,19.47071648d0,
     &19.49960327d0,19.53318977d0,19.56111526d0,19.59412384d0,
     &19.62266541d0,19.64834023d0,19.67453384d0,19.70455742d0,
     &19.73248100d0,19.76296616d0,19.79692841d0,19.82856178d0,
     &19.86233711d0,19.89309692d0,19.93131447d0,19.96686554d0,
     &20.00195503d0,20.02765083d0,20.05672264d0,20.09063530d0,
     &20.12120628d0,20.15517044d0,20.19248009d0,20.22371864d0,
     &20.25809669d0,20.28960609d0,20.32456779d0,20.36067963d0,
     &20.39455414d0,20.42161942d0,20.45207787d0,20.48841667d0,
     &20.52045822d0,20.55655479d0,20.59243965d0,20.62627792d0,
     &20.66198921d0,20.69489861d0,20.73259926d0,20.76527214d0,
     &20.79660416d0,20.82998466d0,20.86395836d0,20.90299225d0,
     &20.93257523d0,20.96953773d0,21.00369072d0,21.04236221d0,
     &21.07807732d0,21.09335709d0,21.12766266d0,21.16225433d0,
     &21.19569016d0,21.22798347d0,21.27219772d0,21.31597137d0,
     &21.36152077d0,21.39791870d0,21.44043922d0,21.47326279d0,
     &21.50928116d0,21.54695892d0,21.58548355d0,21.62506294d0,
     &21.66302109d0,21.68973541d0,21.71718025d0,21.74611473d0,
     &21.78081894d0,21.81875420d0,21.85143280d0,21.88833809d0,
     &21.92225838d0,21.95788193d0,21.99582100d0,22.03716660d0,
     &22.08131409d0,22.11686897d0,22.15557861d0,22.19244194d0,
     &22.22491455d0,22.25724030d0,22.28425217d0,22.31871796d0,
     &22.35106468d0,22.38723183d0,22.41959190d0,22.44628525d0,
     &22.48160744d0,22.51821709d0,22.54371834d0,22.58045578d0,
     &22.62767792d0,22.67359734d0,22.71596909d0,22.75936699d0,
     &22.79568481d0,22.82904434d0,22.86656189d0,22.91190338d0,
     &22.94380569d0,22.98698616d0,23.02495766d0,23.05045128d0,
     &23.07844734d0,23.11325073d0,23.14912415d0,23.18643570d0,
     &23.22846794d0,23.26970863d0,23.30477905d0,23.34536171d0,
     &23.38381958d0,23.41654205d0,23.46121597d0,23.50592422d0,
     &23.54936409d0,23.59079933d0,23.62283134d0,23.66189957d0,
     &23.70363998d0,23.73871422d0,23.77736282d0,23.82069206d0,
     &23.86129761d0,23.89617920d0,23.93166733d0,23.96426582d0,
     &23.99893379d0,24.03614616d0,24.06747246d0,24.09913254d0,
     &24.14596367d0,24.19028091d0,24.22240257d0,24.26268578d0,
     &23.99807739d0,23.55377388d0,22.98180580d0,22.32099724d0,
     &21.57979393d0,20.78728676d0,19.94281197d0,19.04022789d0,
     &18.09170151d0,17.11751366d0,16.11030388d0,15.37863922d0,
     &14.79773808d0,14.31560707d0,13.89238644d0,13.53029823d0,
     &13.19911957d0,12.89628315d0,12.62044430d0,12.37247181d0,
     &12.13674927d0,11.91417027d0,11.70425224d0,11.50828648d0,
     &11.32043743d0,11.14677048d0,10.98171806d0,10.82171917d0,
     &10.66994286d0,10.52519894d0,10.38315487d0,10.25119305d0,
     &10.12080956d0, 9.99648571d0, 9.87481117d0, 9.75991821d0,
     & 9.64649582d0, 9.53705025d0, 9.43233681d0, 9.32943439d0,
     & 9.23041916d0, 9.13433552d0, 9.03886127d0, 8.94829941d0,
     & 8.86079884d0, 8.77456284d0, 8.68954563d0, 8.60736275d0,
     & 8.52775669d0, 8.45066643d0, 8.37437630d0, 8.30016518d0,
     & 8.22788906d0, 8.15715408d0, 8.08689976d0, 8.01835823d0,
     & 7.95276546d0, 7.88870001d0, 7.82591391d0, 7.76408815d0,
     & 7.70227623d0, 7.64196873d0, 7.58313274d0, 7.52569294d0,
     & 7.46970606d0, 7.41517925d0, 7.36198902d0, 7.30863094d0,
     & 7.25643158d0, 7.20529795d0, 7.15522766d0, 7.10614967d0,
     & 7.05799484d0, 7.01071119d0, 6.96424389d0, 6.91845751d0,
     & 6.87316418d0, 6.82826471d0, 6.78436279d0, 6.74145269d0,
     & 6.69986486d0, 6.65899467d0, 6.61884832d0, 6.57935810d0,
     & 6.54053497d0, 6.50231981d0, 6.46471405d0, 6.42766714d0,
     & 6.39111614d0, 6.35505152d0, 6.31938219d0, 6.28377771d0,
     & 6.24875832d0, 6.21427441d0, 6.18038988d0, 6.14705086d0,
     & 6.11424112d0, 6.08193254d0, 6.05012035d0, 6.01882982d0,
     & 5.98801136d0, 5.95770931d0, 5.92784166d0, 5.89843845d0,
     & 5.86949539d0, 5.84097385d0, 5.81287050d0, 5.78521442d0,
     & 5.75793934d0, 5.73111200d0, 5.70464993d0, 5.67858362d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0,
     & 5.65285826d0, 5.65285826d0, 5.65285826d0, 5.65285826d0
     &/
c Definition of open field lines as Lupper=f(Iupper) for doy=241
      DATA (Lupper ( 9,I), I= 1, 1001) /
     & 8.66d0, 8.66d0, 8.66d0, 8.65d0, 8.65d0, 8.65d0, 8.65d0, 8.65d0,
     & 8.64d0, 8.64d0, 8.64d0, 8.64d0, 8.63d0, 8.63d0, 8.63d0, 8.63d0,
     & 8.63d0, 8.62d0, 8.62d0, 8.62d0, 8.62d0, 8.62d0, 8.61d0, 8.61d0,
     & 8.61d0, 8.61d0, 8.60d0, 8.60d0, 8.60d0, 8.60d0, 8.60d0, 8.59d0,
     & 8.59d0, 8.59d0, 8.59d0, 8.59d0, 8.58d0, 8.58d0, 8.58d0, 8.58d0,
     & 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.57d0, 8.56d0, 8.56d0, 8.56d0,
     & 8.56d0, 8.56d0, 8.55d0, 8.55d0, 8.55d0, 8.55d0, 8.54d0, 8.54d0,
     & 8.54d0, 8.54d0, 8.54d0, 8.53d0, 8.53d0, 8.53d0, 8.53d0, 8.53d0,
     & 8.52d0, 8.52d0, 8.52d0, 8.52d0, 8.51d0, 8.51d0, 8.51d0, 8.51d0,
     & 8.51d0, 8.50d0, 8.50d0, 8.50d0, 8.50d0, 8.50d0, 8.49d0, 8.49d0,
     & 8.49d0, 8.49d0, 8.49d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.47d0,
     & 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0,
     & 8.46d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.44d0, 8.44d0, 8.44d0,
     & 8.44d0, 8.44d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.42d0,
     & 8.42d0, 8.42d0, 8.42d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0,
     & 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.39d0, 8.39d0, 8.39d0,
     & 8.39d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.37d0, 8.37d0,
     & 8.37d0, 8.37d0, 8.37d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0,
     & 8.36d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.34d0,
     & 8.34d0, 8.34d0, 8.34d0, 8.34d0, 8.34d0, 8.34d0, 8.34d0, 8.34d0,
     & 8.34d0, 8.34d0, 8.34d0, 8.34d0, 8.34d0, 8.34d0, 8.34d0, 8.34d0,
     & 8.34d0, 8.34d0, 8.34d0, 8.34d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0,
     & 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0,
     & 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0,
     & 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0,
     & 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0, 8.35d0,
     & 8.35d0, 8.35d0, 8.35d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0,
     & 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0,
     & 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0,
     & 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0,
     & 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0, 8.36d0,
     & 8.36d0, 8.36d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0,
     & 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0,
     & 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0,
     & 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0,
     & 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0, 8.37d0,
     & 8.37d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0,
     & 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0,
     & 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0,
     & 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0,
     & 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0, 8.38d0,
     & 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0,
     & 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0,
     & 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0,
     & 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0,
     & 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.39d0, 8.40d0,
     & 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0,
     & 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0,
     & 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0,
     & 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0,
     & 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.40d0, 8.41d0,
     & 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0,
     & 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0,
     & 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0,
     & 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0,
     & 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.41d0, 8.42d0, 8.42d0,
     & 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0,
     & 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0,
     & 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0,
     & 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0,
     & 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.42d0, 8.43d0, 8.43d0, 8.43d0,
     & 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0,
     & 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0,
     & 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0,
     & 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.43d0,
     & 8.43d0, 8.43d0, 8.43d0, 8.43d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0,
     & 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0,
     & 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0,
     & 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0,
     & 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0, 8.44d0,
     & 8.44d0, 8.44d0, 8.44d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0,
     & 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0,
     & 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0,
     & 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0,
     & 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0, 8.45d0,
     & 8.45d0, 8.45d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0,
     & 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0,
     & 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0,
     & 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0,
     & 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0, 8.46d0,
     & 8.46d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0,
     & 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0,
     & 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0,
     & 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0,
     & 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0, 8.47d0,
     & 8.47d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0,
     & 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0,
     & 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0,
     & 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.48d0,
     & 8.48d0, 8.48d0, 8.48d0, 8.48d0, 8.49d0, 8.49d0, 8.49d0, 8.49d0,
     & 8.50d0, 8.50d0, 8.50d0, 8.51d0, 8.51d0, 8.51d0, 8.52d0, 8.52d0,
     & 8.52d0, 8.52d0, 8.53d0, 8.53d0, 8.53d0, 8.54d0, 8.54d0, 8.55d0,
     & 8.55d0, 8.55d0, 8.56d0, 8.56d0, 8.56d0, 8.57d0, 8.57d0, 8.58d0,
     & 8.58d0, 8.59d0, 8.60d0, 8.60d0, 8.61d0, 8.61d0, 8.62d0, 8.62d0,
     & 8.63d0, 8.64d0, 8.64d0, 8.65d0, 8.65d0, 8.66d0, 8.67d0, 8.67d0,
     & 8.68d0, 8.69d0, 8.69d0, 8.70d0, 8.71d0, 8.71d0, 8.72d0, 8.73d0,
     & 8.74d0, 8.74d0, 8.75d0, 8.76d0, 8.77d0, 8.78d0, 8.78d0, 8.79d0,
     & 8.80d0, 8.81d0, 8.82d0, 8.83d0, 8.83d0, 8.84d0, 8.85d0, 8.86d0,
     & 8.87d0, 8.88d0, 8.89d0, 8.90d0, 8.91d0, 8.92d0, 8.93d0, 8.94d0,
     & 8.95d0, 8.96d0, 8.98d0, 8.99d0, 9.00d0, 9.01d0, 9.03d0, 9.04d0,
     & 9.05d0, 9.07d0, 9.08d0, 9.09d0, 9.11d0, 9.12d0, 9.14d0, 9.15d0,
     & 9.16d0, 9.18d0, 9.19d0, 9.21d0, 9.22d0, 9.24d0, 9.26d0, 9.27d0,
     & 9.29d0, 9.30d0, 9.32d0, 9.34d0, 9.35d0, 9.37d0, 9.39d0, 9.40d0,
     & 9.42d0, 9.44d0, 9.46d0, 9.47d0, 9.49d0, 9.51d0, 9.53d0, 9.54d0,
     & 9.56d0, 9.58d0, 9.60d0, 9.62d0, 9.63d0, 9.65d0, 9.67d0, 9.69d0,
     & 9.70d0, 9.72d0, 9.74d0, 9.76d0, 9.78d0, 9.79d0, 9.81d0, 9.83d0,
     & 9.85d0, 9.87d0, 9.89d0, 9.91d0, 9.93d0, 9.95d0, 9.97d0, 9.99d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,
     &10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0,
     &10.00d0,10.00d0,10.00d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0,
     & 9.99d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     &10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,10.00d0, 9.99d0,
     &10.00d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     &10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0, 9.99d0,
     & 9.99d0,10.00d0,10.00d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0,10.00d0,10.00d0,10.00d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0,10.00d0, 9.99d0, 9.99d0,10.00d0,10.00d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0, 9.99d0,
     & 9.99d0
     &/
      DATA (Iupper ( 9,I), I= 1, 1001) /
     & 0.00010000d0, 0.00010127d0, 0.00010255d0, 0.00010386d0,
     & 0.00010517d0, 0.00010651d0, 0.00010786d0, 0.00010923d0,
     & 0.00011062d0, 0.00011202d0, 0.00011344d0, 0.00011488d0,
     & 0.00011634d0, 0.00011782d0, 0.00011931d0, 0.00012083d0,
     & 0.00012236d0, 0.00012391d0, 0.00012548d0, 0.00012708d0,
     & 0.00012869d0, 0.00013032d0, 0.00013198d0, 0.00013365d0,
     & 0.00013535d0, 0.00013707d0, 0.00013881d0, 0.00014057d0,
     & 0.00014235d0, 0.00014416d0, 0.00014599d0, 0.00014784d0,
     & 0.00014972d0, 0.00015162d0, 0.00015354d0, 0.00015549d0,
     & 0.00015746d0, 0.00015946d0, 0.00016148d0, 0.00016353d0,
     & 0.00016561d0, 0.00016771d0, 0.00016984d0, 0.00017200d0,
     & 0.00017418d0, 0.00017639d0, 0.00017863d0, 0.00018089d0,
     & 0.00018319d0, 0.00018551d0, 0.00018787d0, 0.00019025d0,
     & 0.00019267d0, 0.00019511d0, 0.00019759d0, 0.00020010d0,
     & 0.00020264d0, 0.00020521d0, 0.00020781d0, 0.00021045d0,
     & 0.00021312d0, 0.00021583d0, 0.00021857d0, 0.00022134d0,
     & 0.00022415d0, 0.00022699d0, 0.00022987d0, 0.00023279d0,
     & 0.00023575d0, 0.00023874d0, 0.00024177d0, 0.00024484d0,
     & 0.00024794d0, 0.00025109d0, 0.00025428d0, 0.00025750d0,
     & 0.00026077d0, 0.00026408d0, 0.00026743d0, 0.00027083d0,
     & 0.00027426d0, 0.00027775d0, 0.00028127d0, 0.00028484d0,
     & 0.00028846d0, 0.00029212d0, 0.00029582d0, 0.00029958d0,
     & 0.00030338d0, 0.00030723d0, 0.00031113d0, 0.00031508d0,
     & 0.00031908d0, 0.00032313d0, 0.00032723d0, 0.00033138d0,
     & 0.00033559d0, 0.00033984d0, 0.00034416d0, 0.00034853d0,
     & 0.00035295d0, 0.00035743d0, 0.00036196d0, 0.00036656d0,
     & 0.00037121d0, 0.00037592d0, 0.00038069d0, 0.00038552d0,
     & 0.00039042d0, 0.00039537d0, 0.00040039d0, 0.00040547d0,
     & 0.00041062d0, 0.00041583d0, 0.00042111d0, 0.00042645d0,
     & 0.00043186d0, 0.00043734d0, 0.00044289d0, 0.00044852d0,
     & 0.00045421d0, 0.00045997d0, 0.00046581d0, 0.00047172d0,
     & 0.00047771d0, 0.00048377d0, 0.00048991d0, 0.00049613d0,
     & 0.00050243d0, 0.00050880d0, 0.00051526d0, 0.00052180d0,
     & 0.00052842d0, 0.00053513d0, 0.00054192d0, 0.00054880d0,
     & 0.00055576d0, 0.00056281d0, 0.00056996d0, 0.00057719d0,
     & 0.00058452d0, 0.00059194d0, 0.00059945d0, 0.00060706d0,
     & 0.00061476d0, 0.00062256d0, 0.00063046d0, 0.00063846d0,
     & 0.00064657d0, 0.00065477d0, 0.00066308d0, 0.00067150d0,
     & 0.00068002d0, 0.00068865d0, 0.00069739d0, 0.00070624d0,
     & 0.00071521d0, 0.00072428d0, 0.00073347d0, 0.00074278d0,
     & 0.00075221d0, 0.00076176d0, 0.00077142d0, 0.00078122d0,
     & 0.00079113d0, 0.00080117d0, 0.00081134d0, 0.00082164d0,
     & 0.00083206d0, 0.00084262d0, 0.00085332d0, 0.00086415d0,
     & 0.00087511d0, 0.00088622d0, 0.00089747d0, 0.00090886d0,
     & 0.00092039d0, 0.00093207d0, 0.00094390d0, 0.00095588d0,
     & 0.00096801d0, 0.00098030d0, 0.00099274d0, 0.00100534d0,
     & 0.00101810d0, 0.00103102d0, 0.00104411d0, 0.00105736d0,
     & 0.00107078d0, 0.00108437d0, 0.00109813d0, 0.00111206d0,
     & 0.00112618d0, 0.00114047d0, 0.00115495d0, 0.00116960d0,
     & 0.00118445d0, 0.00119948d0, 0.00121470d0, 0.00123012d0,
     & 0.00124573d0, 0.00126154d0, 0.00127755d0, 0.00129377d0,
     & 0.00131019d0, 0.00132681d0, 0.00134365d0, 0.00136071d0,
     & 0.00137797d0, 0.00139546d0, 0.00141317d0, 0.00143111d0,
     & 0.00144927d0, 0.00146766d0, 0.00148629d0, 0.00150515d0,
     & 0.00152426d0, 0.00154360d0, 0.00156319d0, 0.00158303d0,
     & 0.00160312d0, 0.00162347d0, 0.00164407d0, 0.00166494d0,
     & 0.00168607d0, 0.00170747d0, 0.00172914d0, 0.00175108d0,
     & 0.00177331d0, 0.00179581d0, 0.00181860d0, 0.00184168d0,
     & 0.00186506d0, 0.00188873d0, 0.00191270d0, 0.00193697d0,
     & 0.00196156d0, 0.00198645d0, 0.00201166d0, 0.00203719d0,
     & 0.00206305d0, 0.00208923d0, 0.00211575d0, 0.00214260d0,
     & 0.00216979d0, 0.00219733d0, 0.00222521d0, 0.00225346d0,
     & 0.00228206d0, 0.00231102d0, 0.00234035d0, 0.00237005d0,
     & 0.00240013d0, 0.00243059d0, 0.00246144d0, 0.00249268d0,
     & 0.00252431d0, 0.00255635d0, 0.00258879d0, 0.00262165d0,
     & 0.00265492d0, 0.00268862d0, 0.00272274d0, 0.00275729d0,
     & 0.00279229d0, 0.00282773d0, 0.00286361d0, 0.00289996d0,
     & 0.00293676d0, 0.00297403d0, 0.00301178d0, 0.00305000d0,
     & 0.00308871d0, 0.00312791d0, 0.00316761d0, 0.00320781d0,
     & 0.00324852d0, 0.00328975d0, 0.00333150d0, 0.00337378d0,
     & 0.00341660d0, 0.00345996d0, 0.00350387d0, 0.00354834d0,
     & 0.00359337d0, 0.00363898d0, 0.00368516d0, 0.00373193d0,
     & 0.00377930d0, 0.00382726d0, 0.00387583d0, 0.00392502d0,
     & 0.00397484d0, 0.00402528d0, 0.00407637d0, 0.00412811d0,
     & 0.00418050d0, 0.00423355d0, 0.00428728d0, 0.00434169d0,
     & 0.00439680d0, 0.00445260d0, 0.00450911d0, 0.00456633d0,
     & 0.00462429d0, 0.00468298d0, 0.00474241d0, 0.00480260d0,
     & 0.00486355d0, 0.00492528d0, 0.00498778d0, 0.00505109d0,
     & 0.00511519d0, 0.00518011d0, 0.00524585d0, 0.00531243d0,
     & 0.00537985d0, 0.00544813d0, 0.00551727d0, 0.00558730d0,
     & 0.00565821d0, 0.00573002d0, 0.00580274d0, 0.00587639d0,
     & 0.00595096d0, 0.00602649d0, 0.00610298d0, 0.00618043d0,
     & 0.00625887d0, 0.00633830d0, 0.00641874d0, 0.00650021d0,
     & 0.00658270d0, 0.00666625d0, 0.00675085d0, 0.00683653d0,
     & 0.00692329d0, 0.00701116d0, 0.00710014d0, 0.00719025d0,
     & 0.00728151d0, 0.00737392d0, 0.00746751d0, 0.00756228d0,
     & 0.00765826d0, 0.00775545d0, 0.00785387d0, 0.00795355d0,
     & 0.00805449d0, 0.00815672d0, 0.00826024d0, 0.00836507d0,
     & 0.00847124d0, 0.00857875d0, 0.00868762d0, 0.00879788d0,
     & 0.00890954d0, 0.00902261d0, 0.00913712d0, 0.00925308d0,
     & 0.00937052d0, 0.00948945d0, 0.00960988d0, 0.00973184d0,
     & 0.00985535d0, 0.00998043d0, 0.01010710d0, 0.01023537d0,
     & 0.01036527d0, 0.01049682d0, 0.01063004d0, 0.01076495d0,
     & 0.01090157d0, 0.01103993d0, 0.01118004d0, 0.01132193d0,
     & 0.01146563d0, 0.01161114d0, 0.01175850d0, 0.01190773d0,
     & 0.01205886d0, 0.01221190d0, 0.01236688d0, 0.01252384d0,
     & 0.01268278d0, 0.01284374d0, 0.01300676d0, 0.01317183d0,
     & 0.01333899d0, 0.01350829d0, 0.01367973d0, 0.01385334d0,
     & 0.01402915d0, 0.01420721d0, 0.01438751d0, 0.01457011d0,
     & 0.01475503d0, 0.01494229d0, 0.01513193d0, 0.01532398d0,
     & 0.01551846d0, 0.01571541d0, 0.01591486d0, 0.01611684d0,
     & 0.01632139d0, 0.01652853d0, 0.01673830d0, 0.01695073d0,
     & 0.01716586d0, 0.01738372d0, 0.01760434d0, 0.01782776d0,
     & 0.01805403d0, 0.01828315d0, 0.01851519d0, 0.01875018d0,
     & 0.01898814d0, 0.01922913d0, 0.01947318d0, 0.01972032d0,
     & 0.01997059d0, 0.02022405d0, 0.02048072d0, 0.02074065d0,
     & 0.02100387d0, 0.02127045d0, 0.02154040d0, 0.02181377d0,
     & 0.02209063d0, 0.02237098d0, 0.02265490d0, 0.02294243d0,
     & 0.02323360d0, 0.02352846d0, 0.02382708d0, 0.02412947d0,
     & 0.02443570d0, 0.02474584d0, 0.02505989d0, 0.02537793d0,
     & 0.02570002d0, 0.02602619d0, 0.02635649d0, 0.02669099d0,
     & 0.02702975d0, 0.02737279d0, 0.02772018d0, 0.02807200d0,
     & 0.02842827d0, 0.02878906d0, 0.02915444d0, 0.02952445d0,
     & 0.02989915d0, 0.03027862d0, 0.03066289d0, 0.03105204d0,
     & 0.03144613d0, 0.03184524d0, 0.03224939d0, 0.03265868d0,
     & 0.03307318d0, 0.03349292d0, 0.03391798d0, 0.03434846d0,
     & 0.03478439d0, 0.03522584d0, 0.03567292d0, 0.03612565d0,
     & 0.03658413d0, 0.03704845d0, 0.03751864d0, 0.03799480d0,
     & 0.03847702d0, 0.03896534d0, 0.03945986d0, 0.03996065d0,
     & 0.04046782d0, 0.04098141d0, 0.04150151d0, 0.04202824d0,
     & 0.04256163d0, 0.04310180d0, 0.04364883d0, 0.04420279d0,
     & 0.04476377d0, 0.04533191d0, 0.04590723d0, 0.04648984d0,
     & 0.04707986d0, 0.04767738d0, 0.04828247d0, 0.04889523d0,
     & 0.04951580d0, 0.05014421d0, 0.05078061d0, 0.05142510d0,
     & 0.05207775d0, 0.05273868d0, 0.05340803d0, 0.05408584d0,
     & 0.05477226d0, 0.05546741d0, 0.05617137d0, 0.05688425d0,
     & 0.05760621d0, 0.05833730d0, 0.05907768d0, 0.05982745d0,
     & 0.06058676d0, 0.06135568d0, 0.06213436d0, 0.06292295d0,
     & 0.06372152d0, 0.06453023d0, 0.06534923d0, 0.06617859d0,
     & 0.06701849d0, 0.06786907d0, 0.06873041d0, 0.06960268d0,
     & 0.07048602d0, 0.07138062d0, 0.07228653d0, 0.07320394d0,
     & 0.07413302d0, 0.07507385d0, 0.07602664d0, 0.07699155d0,
     & 0.07796867d0, 0.07895819d0, 0.07996030d0, 0.08097509d0,
     & 0.08200277d0, 0.08304353d0, 0.08409746d0, 0.08516476d0,
     & 0.08624565d0, 0.08734021d0, 0.08844867d0, 0.08957119d0,
     & 0.09070800d0, 0.09185920d0, 0.09302501d0, 0.09420566d0,
     & 0.09540125d0, 0.09661201d0, 0.09783818d0, 0.09907987d0,
     & 0.10033731d0, 0.10161077d0, 0.10290034d0, 0.10420627d0,
     & 0.10552878d0, 0.10686813d0, 0.10822441d0, 0.10959791d0,
     & 0.11098890d0, 0.11239749d0, 0.11382396d0, 0.11526857d0,
     & 0.11673148d0, 0.11821295d0, 0.11971328d0, 0.12123259d0,
     & 0.12277117d0, 0.12432936d0, 0.12590724d0, 0.12750517d0,
     & 0.12912343d0, 0.13076216d0, 0.13242172d0, 0.13410230d0,
     & 0.13580430d0, 0.13752782d0, 0.13927321d0, 0.14104085d0,
     & 0.14283082d0, 0.14464353d0, 0.14647931d0, 0.14833830d0,
     & 0.15022090d0, 0.15212746d0, 0.15405814d0, 0.15601335d0,
     & 0.15799335d0, 0.15999855d0, 0.16202913d0, 0.16408549d0,
     & 0.16616802d0, 0.16827691d0, 0.17041254d0, 0.17257537d0,
     & 0.17476557d0, 0.17698357d0, 0.17922980d0, 0.18150444d0,
     & 0.18380795d0, 0.18614081d0, 0.18850316d0, 0.19089550d0,
     & 0.19331829d0, 0.19577175d0, 0.19825633d0, 0.20077245d0,
     & 0.20332061d0, 0.20590100d0, 0.20851412d0, 0.21116054d0,
     & 0.21384043d0, 0.21655434d0, 0.21930277d0, 0.22208601d0,
     & 0.22490457d0, 0.22775897d0, 0.23064953d0, 0.23357674d0,
     & 0.23654114d0, 0.23954326d0, 0.24258336d0, 0.24566205d0,
     & 0.24877992d0, 0.25193724d0, 0.25513467d0, 0.25837275d0,
     & 0.26165181d0, 0.26497251d0, 0.26833546d0, 0.27174097d0,
     & 0.27518973d0, 0.27868235d0, 0.28221917d0, 0.28580090d0,
     & 0.28942820d0, 0.29310140d0, 0.29682124d0, 0.30058825d0,
     & 0.30440310d0, 0.30826664d0, 0.31217894d0, 0.31614089d0,
     & 0.32015309d0, 0.32421625d0, 0.32833093d0, 0.33249786d0,
     & 0.33671802d0, 0.34099138d0, 0.34531897d0, 0.34970152d0,
     & 0.35413966d0, 0.35863414d0, 0.36318600d0, 0.36779529d0,
     & 0.37246308d0, 0.37719008d0, 0.38197711d0, 0.38682488d0,
     & 0.39173418d0, 0.39670613d0, 0.40174085d0, 0.40683943d0,
     & 0.41200271d0, 0.41723153d0, 0.42252675d0, 0.42788953d0,
     & 0.43332002d0, 0.43881938d0, 0.44438851d0, 0.45002836d0,
     & 0.45573980d0, 0.46152416d0, 0.46738148d0, 0.47331312d0,
     & 0.47932005d0, 0.48540321d0, 0.49156362d0, 0.49780214d0,
     & 0.50412035d0, 0.51051831d0, 0.51699740d0, 0.52355874d0,
     & 0.53020334d0, 0.53693229d0, 0.54374713d0, 0.55064797d0,
     & 0.55763638d0, 0.56471354d0, 0.57188040d0, 0.57913828d0,
     & 0.58648884d0, 0.59393209d0, 0.60146987d0, 0.60910326d0,
     & 0.61683351d0, 0.62466192d0, 0.63258964d0, 0.64061862d0,
     & 0.64874887d0, 0.65698230d0, 0.66532022d0, 0.67376393d0,
     & 0.68231487d0, 0.69097501d0, 0.69974434d0, 0.70862496d0,
     & 0.71761823d0, 0.72672570d0, 0.73594880d0, 0.74528891d0,
     & 0.75474828d0, 0.76432699d0, 0.77402723d0, 0.78385061d0,
     & 0.79379863d0, 0.80387294d0, 0.81407589d0, 0.82440752d0,
     & 0.83487028d0, 0.84546578d0, 0.85619581d0, 0.86706197d0,
     & 0.87806606d0, 0.88921070d0, 0.90049589d0, 0.91192430d0,
     & 0.92349786d0, 0.93521816d0, 0.94708717d0, 0.95910788d0,
     & 0.97128016d0, 0.98360693d0, 0.99609011d0, 1.00873172d0,
     & 1.02153373d0, 1.03449929d0, 1.04762840d0, 1.06092405d0,
     & 1.07438850d0, 1.08802390d0, 1.10183227d0, 1.11581588d0,
     & 1.12997806d0, 1.14431894d0, 1.15884173d0, 1.17354894d0,
     & 1.18844259d0, 1.20352542d0, 1.21880090d0, 1.23426902d0,
     & 1.24993336d0, 1.26579666d0, 1.28186119d0, 1.29812956d0,
     & 1.31460571d0, 1.33128977d0, 1.34818542d0, 1.36529553d0,
     & 1.38262296d0, 1.40017009d0, 1.41794002d0, 1.43593681d0,
     & 1.45416057d0, 1.47261584d0, 1.49130499d0, 1.51023161d0,
     & 1.52939832d0, 1.54880977d0, 1.56846607d0, 1.58837199d0,
     & 1.60853028d0, 1.62894464d0, 1.64961791d0, 1.67055368d0,
     & 1.69175661d0, 1.71322715d0, 1.73497009d0, 1.75698900d0,
     & 1.77928746d0, 1.80186892d0, 1.82473862d0, 1.84789681d0,
     & 1.87134874d0, 1.89509857d0, 1.91914976d0, 1.94350624d0,
     & 1.96817160d0, 1.99315214d0, 2.01844788d0, 2.04406428d0,
     & 2.07000613d0, 2.09627700d0, 2.12288141d0, 2.14982557d0,
     & 2.17710948d0, 2.20473981d0, 2.23272061d0, 2.26105666d0,
     & 2.28975224d0, 2.31881428d0, 2.34824300d0, 2.37804508d0,
     & 2.40822554d0, 2.43878889d0, 2.46974015d0, 2.50108409d0,
     & 2.53282857d0, 2.56497312d0, 2.59752584d0, 2.63049173d0,
     & 2.66387582d0, 2.69768381d0, 2.73192358d0, 2.76659513d0,
     & 2.80170655d0, 2.83726382d0, 2.87327218d0, 2.90973759d0,
     & 2.94666839d0, 2.98406553d0, 3.02193713d0, 3.06028914d0,
     & 3.09912801d0, 3.13845992d0, 3.17829084d0, 3.21863031d0,
     & 3.25947881d0, 3.30084562d0, 3.34273744d0, 3.38516092d0,
     & 3.42812300d0, 3.47163343d0, 3.51569295d0, 3.56031132d0,
     & 3.60549593d0, 3.65125418d0, 3.69759321d0, 3.74452019d0,
     & 3.79204679d0, 3.84017253d0, 3.88890886d0, 3.93826389d0,
     & 3.98824549d0, 4.03886127d0, 4.09012318d0, 4.14203215d0,
     & 4.19460011d0, 4.24783468d0, 4.30174494d0, 4.35633945d0,
     & 4.41162682d0, 4.46762037d0, 4.52431965d0, 4.58173895d0,
     & 4.63988686d0, 4.69877291d0, 4.75840616d0, 4.81880093d0,
     & 4.87995768d0, 4.94189024d0, 5.00460863d0, 5.06812382d0,
     & 5.13244438d0, 5.19758654d0, 5.26355076d0, 5.33035135d0,
     & 5.39800024d0, 5.46650791d0, 5.53588486d0, 5.60614157d0,
     & 5.67729616d0, 5.74934816d0, 5.82231474d0, 5.89620686d0,
     & 5.97103739d0, 6.04681683d0, 6.12356472d0, 6.20128012d0,
     & 6.27998209d0, 6.35968304d0, 6.44039536d0, 6.52213240d0,
     & 6.60491228d0, 6.68873739d0, 6.77362537d0, 6.85959101d0,
     & 6.94664812d0, 7.03480911d0, 7.12408972d0, 7.21451092d0,
     & 7.30607176d0, 7.39879513d0, 7.49269533d0, 7.58778667d0,
     & 7.68408489d0, 7.78161287d0, 7.88037157d0, 7.98038340d0,
     & 8.08166409d0, 8.18422985d0, 8.28809834d0, 8.39328480d0,
     & 8.49981499d0, 8.60768700d0, 8.71692944d0, 8.82755852d0,
     & 8.93959141d0, 9.05304623d0, 9.16794872d0, 9.28430176d0,
     & 9.40213108d0, 9.52145576d0, 9.64229488d0, 9.76466751d0,
     & 9.88859367d0,10.01410198d0,10.14119339d0,10.26989746d0,
     &10.40023613d0,10.53222752d0,10.66589451d0,10.80126858d0,
     &10.93834972d0,11.07717133d0,11.21775436d0,11.36012173d0,
     &11.50429535d0,11.65031052d0,11.79816723d0,11.94790173d0,
     &12.09953499d0,12.25309372d0,12.40860081d0,12.56608105d0,
     &12.72557259d0,12.88707542d0,13.05062866d0,13.21625710d0,
     &13.38398838d0,13.55384827d0,13.72587585d0,13.90007496d0,
     &14.07648373d0,14.25513268d0,14.43604851d0,14.61925888d0,
     &14.80481052d0,14.99270153d0,15.18297768d0,15.37566853d0,
     &15.57080460d0,15.76841831d0,15.96853828d0,16.17121506d0,
     &16.37644768d0,16.58428574d0,16.79475975d0,17.00790787d0,
     &17.22375870d0,17.44236755d0,17.66373062d0,17.88790512d0,
     &18.11492538d0,18.34482765d0,18.57764626d0,18.81341934d0,
     &19.05220222d0,19.29399872d0,19.53886604d0,19.78683662d0,
     &20.03795815d0,20.29226303d0,20.54981613d0,20.81061935d0,
     &21.07473183d0,21.34219742d0,21.61305809d0,21.88735199d0,
     &22.16513062d0,22.44645500d0,22.73132896d0,23.01981735d0,
     &23.31196785d0,23.60782623d0,23.90743828d0,24.21087837d0,
     &24.51814270d0,24.82930946d0,25.14442444d0,25.46353912d0,
     &25.78670311d0,26.11399269d0,26.44541168d0,26.78103638d0,
     &27.12092209d0,27.46512032d0,27.81368637d0,28.16667747d0,
     &28.52417374d0,28.88618279d0,29.25278282d0,29.62404060d0,
     &30.00000572d0
     &/
c Definition of fits (4 deg polynomial) for doy=241
c A0=f(Lm) same for A1,A2,A3 and A4; to be used every where except Lm>7.5 and I> 1.
      DATA (Lm4 ( 9,I), I= 1,100) /
     & 1.10d0, 1.20d0, 1.30d0, 1.40d0, 1.50d0, 1.60d0, 1.70d0, 1.80d0,
     & 1.90d0, 2.00d0, 2.10d0, 2.20d0, 2.30d0, 2.40d0, 2.50d0, 2.60d0,
     & 2.70d0, 2.80d0, 2.90d0, 3.00d0, 3.10d0, 3.20d0, 3.30d0, 3.40d0,
     & 3.50d0, 3.60d0, 3.70d0, 3.80d0, 3.90d0, 4.00d0, 4.10d0, 4.20d0,
     & 4.30d0, 4.40d0, 4.50d0, 4.60d0, 4.70d0, 4.80d0, 4.90d0, 5.00d0,
     & 5.10d0, 5.20d0, 5.30d0, 5.40d0, 5.50d0, 5.60d0, 5.70d0, 5.80d0,
     & 5.90d0, 6.00d0, 6.10d0, 6.20d0, 6.30d0, 6.40d0, 6.50d0, 6.60d0,
     & 6.70d0, 6.80d0, 6.90d0, 7.00d0, 7.10d0, 7.20d0, 7.30d0, 7.40d0,
     & 7.50d0, 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0,
     & 8.30d0, 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0,
     & 9.10d0, 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0,
     & 9.90d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A0 ( 9,I), I= 1,100) /
     & 1.1010715677D+00, 1.2014849502D+00, 1.3021642324D+00,
     & 1.4017748994D+00, 1.5015131251D+00, 1.6006473515D+00,
     & 1.7010669271D+00, 1.7993321659D+00, 1.8999696975D+00,
     & 1.9989680013D+00, 2.0999022376D+00, 2.1991422537D+00,
     & 2.2954380709D+00, 2.3933496483D+00, 2.4904739709D+00,
     & 2.5845787116D+00, 2.6804966482D+00, 2.7719293730D+00,
     & 2.8664411007D+00, 2.9592106557D+00, 3.0531667018D+00,
     & 3.1440017966D+00, 3.2344659423D+00, 3.3265763714D+00,
     & 3.4125479014D+00, 3.5052801517D+00, 3.5873009689D+00,
     & 3.6788608824D+00, 3.7654252005D+00, 3.8501197447D+00,
     & 3.9347738226D+00, 4.0201665025D+00, 4.1028765167D+00,
     & 4.1846334186D+00, 4.2683789591D+00, 4.3537575761D+00,
     & 4.4325899281D+00, 4.5137488542D+00, 4.5973193577D+00,
     & 4.6771764873D+00, 4.7596216413D+00, 4.8391514012D+00,
     & 4.9224478097D+00, 5.0013137441D+00, 5.0843792722D+00,
     & 5.1611478389D+00, 5.2437764525D+00, 5.3270819800D+00,
     & 5.4057692648D+00, 5.4897189041D+00, 5.5720849972D+00,
     & 5.6529101405D+00, 5.7351517518D+00, 5.8211636036D+00,
     & 5.9033292088D+00, 5.9878871410D+00, 6.0732576041D+00,
     & 6.1602871222D+00, 6.2476416386D+00, 6.3338341414D+00,
     & 6.4250074967D+00, 6.5145774976D+00, 6.6063258778D+00,
     & 6.6981795412D+00, 6.7943345543D+00, 6.8866346666D+00,
     & 6.9882410518D+00, 7.0964674552D+00, 7.1948127168D+00,
     & 7.3097845195D+00, 7.4405411796D+00, 7.5718353062D+00,
     & 7.7128901251D+00, 7.8373135243D+00,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A1 ( 9,I), I= 1,100) /
     &-6.0025741657D-05, 1.7232583388D-04, 4.0274690294D-04,
     & 4.6811052970D-04, 4.1070703911D-04, 3.7136689388D-04,
     & 3.9582364967D-04,-1.3931158278D-05, 2.6648942903D-05,
     & 3.0167706044D-04, 4.3316524285D-04, 8.3273761348D-03,
     & 2.6201209884D-03, 3.8462078598D-03, 5.7253989172D-03,
     & 7.6069967181D-03, 8.8122691478D-03, 1.3228179445D-02,
     & 1.0485152057D-02, 1.2461974097D-02, 1.1985579997D-02,
     & 1.5226057842D-02, 1.7220711882D-02, 1.6269912842D-02,
     & 2.1524699726D-02, 1.9946166678D-02, 2.1997321067D-02,
     & 2.1651080141D-02, 2.3022897221D-02, 2.6314755201D-02,
     & 2.7721740179D-02, 2.7789269741D-02, 2.9345579588D-02,
     & 3.0964161185D-02, 3.1315786764D-02, 3.3069135754D-02,
     & 3.4399788295D-02, 3.5444388083D-02, 3.5882287039D-02,
     & 3.5794962532D-02, 3.6536407109D-02, 3.5478015796D-02,
     & 3.6072434227D-02, 3.7743775455D-02, 3.7337002829D-02,
     & 3.7264573825D-02, 3.7725947440D-02, 3.7871499565D-02,
     & 3.5943040703D-02, 3.5768648934D-02, 3.7145740588D-02,
     & 3.4884341300D-02, 3.3729622362D-02, 3.2624644146D-02,
     & 3.1894677328D-02, 2.9997558711D-02, 2.8587766340D-02,
     & 2.6953061713D-02, 2.3439760164D-02, 2.1029136705D-02,
     & 2.0206871574D-02, 1.7422701484D-02, 1.2950986942D-02,
     & 9.7262990911D-03, 5.2409585604D-03,-1.0369936240D-02,
     &-1.2533899676D-02,-1.6960371486D-02,-4.9693762520D-02,
     &-5.7166248021D-02,-4.6668347429D-02,-4.0448575292D-02,
     &-1.7185043016D-02,-2.8403506047D-02,-9.0477001301D-01,
     & 5.7386519786D-03,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A2 ( 9,I), I= 1,100) /
     & 1.2369248992D-06,-2.4380919529D-06, 1.1037999478D-05,
     & 2.1020508764D-05, 1.6739791416D-05, 1.0169174873D-05,
     & 1.0361669431D-05,-3.0080411066D-05,-2.2662898962D-05,
     &-1.7313781225D-05,-2.1797115512D-05, 3.6223558491D-03,
     & 1.9775614885D-04, 4.5632316777D-04, 7.1324474498D-04,
     & 1.3741796477D-03, 1.4782235148D-03, 4.1569273070D-03,
     & 1.6931035903D-03, 3.0800507803D-03, 2.3673808911D-03,
     & 3.1959768610D-03, 3.8686543590D-03, 3.5098965333D-03,
     & 5.4732810318D-03, 4.5107186371D-03, 4.9615308683D-03,
     & 4.8281904935D-03, 5.5575652180D-03, 5.9870769937D-03,
     & 6.0313596635D-03, 6.0183547251D-03, 7.6231909671D-03,
     & 8.2013597233D-03, 7.7915725995D-03, 7.3614458868D-03,
     & 8.4738705090D-03, 8.4517515382D-03, 8.6985501040D-03,
     & 9.1092677251D-03, 8.9576969664D-03, 8.9798731805D-03,
     & 9.4907511602D-03, 9.3743496581D-03, 9.2295596688D-03,
     & 8.6665417661D-03, 8.9972335159D-03, 8.4169796155D-03,
     & 9.0171110979D-03, 8.4203399359D-03, 8.1881276332D-03,
     & 7.9119670103D-03, 8.7484581164D-03, 7.1608117974D-03,
     & 6.9512837302D-03, 6.7226280860D-03, 6.3689694643D-03,
     & 5.7246768958D-03, 5.0752910768D-03, 5.5981910748D-03,
     & 4.0056086776D-03, 3.4910322761D-03, 2.7133430382D-03,
     & 2.7120267651D-03, 1.3826801753D-03,-5.0717749393D-03,
     &-7.0242625185D-04,-4.9392301994D-03,-1.7452273888D-02,
     &-1.9522378301D-02,-1.5283110404D-02,-1.2950826889D-02,
     &-3.4219242943D-03,-1.4234242965D-02,-2.3417526047D-01,
     &-6.1097027830D-04,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A3 ( 9,I), I= 1,100) /
     & 2.4709694932D-07,-1.0700899701D-06,-3.0202876818D-06,
     &-3.4260909470D-06,-3.6363836170D-06,-3.3314657583D-06,
     &-2.2682064091D-06,-8.9360633761D-07,-1.7715290899D-06,
     &-1.9625071340D-06,-3.8950333354D-06, 5.8916500426D-04,
     &-2.9519712164D-05,-3.8658591200D-06,-2.1014763830D-06,
     & 1.0057159792D-04, 7.2283286162D-05, 5.4698563291D-04,
     & 7.2702171795D-05, 3.3326565430D-04, 1.9147892513D-04,
     & 2.6459009316D-04, 3.3845569972D-04, 3.0811729188D-04,
     & 5.8903568853D-04, 4.1904114604D-04, 4.3874031258D-04,
     & 4.3515347201D-04, 5.7957223358D-04, 5.6456624426D-04,
     & 5.2581117833D-04, 5.2056063793D-04, 8.1376916546D-04,
     & 8.9870683485D-04, 7.8122159128D-04, 6.5727599289D-04,
     & 8.7182030369D-04, 8.4346527255D-04, 8.6935266507D-04,
     & 9.6703748354D-04, 9.1032757023D-04, 9.4509572801D-04,
     & 1.0649265164D-03, 9.6225307089D-04, 9.9145402417D-04,
     & 7.9898062046D-04, 8.7232672902D-04, 8.1429109879D-04,
     & 8.9569739643D-04, 8.3975780557D-04, 7.3251686369D-04,
     & 6.8969650233D-04, 9.7615594476D-04, 6.9332692621D-04,
     & 5.7542617017D-04, 5.5124223878D-04, 5.6289952492D-04,
     & 4.1995176899D-04, 4.6142749343D-04, 5.7196328581D-04,
     & 3.7047364685D-04, 2.7734402799D-04, 2.2962451923D-04,
     & 2.3560672496D-04, 2.2865279242D-04,-7.3566665207D-04,
     & 4.1354216763D-04,-6.2107650433D-04,-2.3967516527D-03,
     &-2.6645046419D-03,-2.0948452841D-03,-1.8193581610D-03,
     &-4.3517402953D-04,-3.3578396446D-03,-1.9545840340D-02,
     & 6.4988451171D-05,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A4 ( 9,I), I= 1,100) /
     &-4.5035380743D-08,-4.7683609276D-09,-1.7658602252D-07,
     &-2.3183503423D-07,-2.3835133866D-07,-2.2048798526D-07,
     &-2.4632576444D-08, 1.1694652710D-07,-2.0796061607D-08,
     & 2.0114958996D-07, 1.2587964400D-07, 3.1580417118D-05,
     &-3.2445130995D-06,-2.1930461478D-06,-3.1016294676D-06,
     & 2.6261363455D-06,-8.5694406526D-07, 2.5278887209D-05,
     &-1.6800439824D-06, 1.3096010502D-05, 5.0780947998D-06,
     & 7.0869182796D-06, 9.0243283793D-06, 9.3429369445D-06,
     & 2.2686031759D-05, 1.3464766966D-05, 1.2395947249D-05,
     & 1.2929061642D-05, 2.1891906553D-05, 1.8427705397D-05,
     & 1.5262725296D-05, 1.4794742611D-05, 3.0588617942D-05,
     & 3.4797651811D-05, 2.6761242666D-05, 1.9385720412D-05,
     & 3.1789215133D-05, 2.9577395500D-05, 3.0520929724D-05,
     & 3.6351807658D-05, 3.3505648170D-05, 3.4945126984D-05,
     & 4.2779147186D-05, 3.4898483629D-05, 3.8909844506D-05,
     & 2.4495490428D-05, 2.8954512279D-05, 2.8637350648D-05,
     & 3.0189678138D-05, 2.9911161479D-05, 2.2189866276D-05,
     & 1.8923232604D-05, 3.9395428535D-05, 2.4798033544D-05,
     & 1.4297476763D-05, 1.2464820050D-05, 1.6482681435D-05,
     & 6.7330489974D-06, 1.4553748552D-05, 1.9091944731D-05,
     & 1.3787035401D-05, 7.3413018911D-06, 5.9545649553D-06,
     & 4.9358411351D-06, 1.2987281547D-05,-3.2344608074D-05,
     & 4.1129144376D-05,-2.7902602049D-05,-1.1014661464D-04,
     &-1.2136045366D-04,-9.6829504427D-05,-8.6035521090D-05,
     &-1.6790172117D-05,-2.0570163286D-04,-4.8574789646D-04,
     &-6.9134786831D-06,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of fits (5 deg polynomial) for doy=241
c A50=f(Lm5) same for A51,A52,A53, A54 and A55
c To be used only where Lm>7.5 and I> 1.
      DATA (Lm5 ( 9,I), I= 1,100) /
     & 7.60d0, 7.70d0, 7.80d0, 7.90d0, 8.00d0, 8.10d0, 8.20d0, 8.30d0,
     & 8.40d0, 8.50d0, 8.60d0, 8.70d0, 8.80d0, 8.90d0, 9.00d0, 9.10d0,
     & 9.20d0, 9.30d0, 9.40d0, 9.50d0, 9.60d0, 9.70d0, 9.80d0, 9.90d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0, 0.00d0,
     & 0.00d0, 0.00d0, 0.00d0, 0.00d0
     &/
      DATA (A50 ( 9,I), I= 1,100) /
     & 6.8890921338D+00, 6.9901058195D+00, 7.0920189133D+00,
     & 7.2010135422D+00, 7.3117085700D+00, 7.4274210212D+00,
     & 7.5534598471D+00, 7.6877440851D+00, 7.8356315620D+00,
     & 7.9888536261D+00, 8.1539294554D+00, 8.4195154242D+00,
     & 8.6419879654D+00, 9.0388904332D+00, 9.4409743092D+00,
     & 1.0106664928D+01, 1.0626246839D+01, 1.1429833799D+01,
     & 1.0906536575D+01, 1.1452500725D+01, 1.3322922246D+01,
     & 1.3194074261D+01, 1.4150437223D+01, 1.5099490523D+01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A51 ( 9,I), I= 1,100) /
     & 1.7553574541D-02,-3.4486637774D-02,-3.1184423238D-02,
     &-4.2996904177D-02,-4.4183012293D-02,-6.0453964621D-02,
     &-1.0156088025D-01,-1.3252040515D-01,-2.0360206266D-01,
     &-2.4514701549D-01,-2.8053561178D-01,-5.9207853220D-01,
     &-7.2303257546D-01,-1.3196784768D+00,-1.8118012331D+00,
     &-3.0186250424D+00,-3.8253736653D+00,-5.0984737444D+00,
     &-2.9151294620D+00,-3.2790515066D+00,-6.9373793040D+00,
     &-5.8475149763D+00,-7.1328413351D+00,-7.9987482855D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A52 ( 9,I), I= 1,100) /
     &-3.8977416054D-02, 9.7550678514D-02, 5.0752927000D-02,
     & 2.4988442518D-02,-1.5521753737D-02,-1.2661941023D-02,
     & 1.8463728105D-02, 1.3255816508D-03, 5.3926055873D-02,
     & 4.3319665715D-02, 2.1157882998D-02, 2.3288435143D-01,
     & 2.6722900331D-01, 8.0588678864D-01, 1.1385773176D+00,
     & 2.2308146578D+00, 2.9841134958D+00, 3.9405548532D+00,
     & 1.4116569803D+00, 1.3133819633D+00, 4.4450474468D+00,
     & 3.2552031820D+00, 4.0713850910D+00, 4.1870374248D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A53 ( 9,I), I= 1,100) /
     & 3.7094908947D-02,-1.0730894213D-01,-5.2366255237D-02,
     &-1.4642776619D-02, 2.6911460633D-02, 1.8983158549D-02,
     &-3.7550665562D-03, 2.2749238941D-02,-1.0481211499D-02,
     & 2.5502625737D-03, 8.2179931099D-03,-3.6664823559D-02,
     &-3.3496497584D-02,-2.9862593993D-01,-4.1782120414D-01,
     &-9.2546707601D-01,-1.3281695029D+00,-1.6975440810D+00,
     &-3.5305771704D-01,-1.6606443021D-01,-1.5274948874D+00,
     &-9.9950975501D-01,-1.2778194757D+00,-1.1136354307D+00,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A54 ( 9,I), I= 1,100) /
     &-1.5639159362D-02, 4.5823866330D-02, 2.0781892148D-02,
     & 1.7168118466D-03,-1.5769475606D-02,-1.0273544869D-02,
     &-1.8385507313D-03,-1.3283210766D-02,-1.7331207309D-03,
     &-5.3341049642D-03,-3.1084527535D-04,-8.9934871419D-03,
     &-1.1792108341D-02, 5.4678169084D-02, 7.6180689493D-02,
     & 1.9290299631D-01, 3.0484117180D-01, 3.7628315498D-01,
     & 3.5052329819D-02,-3.2008726047D-02, 2.6334104623D-01,
     & 1.6145956901D-01, 2.1082660409D-01, 1.3708778209D-01,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
      DATA (A55 ( 9,I), I= 1,100) /
     & 2.4157503607D-03,-6.6118429597D-03,-2.7788444194D-03,
     & 4.4848542188D-04, 3.0807925455D-03, 2.0188536046D-03,
     & 8.9537186542D-04, 2.5203802991D-03, 9.9312487359D-04,
     & 1.3526455927D-03,-6.7580982279D-05, 3.0518145031D-03,
     & 3.3870022084D-03,-3.2036887746D-03,-4.7071796854D-03,
     &-1.5178584125D-02,-2.7534683735D-02,-3.3016342811D-02,
     & 5.1331004723D-04, 8.3041336261D-03,-1.7082704664D-02,
     &-1.0345407658D-02,-1.3832142512D-02,-4.6906208196D-03,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30,-9.9999998482D+30,-9.9999998482D+30,
     &-9.9999998482D+30
     &/
c Definition of Loss cone as Lmax=f(Imax) for doy=271
      DATA (Lmax (10,I), I= 1, 2100) /
     & 1.0856d0, 1.0866d0, 1.0876d0, 1.0886d0, 1.0896d0, 1.0906d0,
     & 1.0916d0, 1.0926d0, 1.0936d0, 1.0945d0, 1.0955d0, 1.0965d0,
     & 1.0975d0, 1.0985d0, 1.0995d0, 1.1006d0, 1.1016d0, 1.1026d0,
     & 1.1036d0, 1.1046d0, 1.1056d0, 1.1066d0, 1.1077d0, 1.1087d0,
     & 1.1097d0, 1.1107d0, 1.1118d0, 1.1128d0, 1.1138d0, 1.1148d0,
     & 1.1159d0, 1.1169d0, 1.1179d0, 1.1189d0, 1.1199d0, 1.1210d0,
     & 1.1220d0, 1.1230d0, 1.1241d0, 1.1251d0, 1.1261d0, 1.1271d0,
     & 1.1282d0, 1.1292d0, 1.1302d0, 1.1312d0, 1.1323d0, 1.1333d0,
     & 1.1343d0, 1.1354d0, 1.1364d0, 1.1374d0, 1.1384d0, 1.1395d0,
     & 1.1405d0, 1.1415d0, 1.1425d0, 1.1436d0, 1.1446d0, 1.1456d0,
     & 1.1467d0, 1.1477d0, 1.1487d0, 1.1498d0, 1.1508d0, 1.1518d0,
     & 1.1528d0, 1.1539d0, 1.1549d0, 1.1559d0, 1.1570d0, 1.1580d0,
     & 1.1590d0, 1.1600d0, 1.1611d0, 1.1621d0, 1.1631d0, 1.1642d0,
     & 1.1652d0, 1.1662d0, 1.1672d0, 1.1683d0, 1.1693d0, 1.1703d0,
     & 1.1714d0, 1.1724d0, 1.1734d0, 1.1744d0, 1.1755d0, 1.1765d0,
     & 1.1775d0, 1.1786d0, 1.1796d0, 1.1806d0, 1.1816d0, 1.1827d0,
     & 1.1837d0, 1.1847d0, 1.1858d0, 1.1868d0, 1.1878d0, 1.1888d0,
     & 1.1899d0, 1.1909d0, 1.1919d0, 1.1930d0, 1.1940d0, 1.1950d0,
     & 1.1960d0, 1.1970d0, 1.1981d0, 1.1991d0, 1.2002d0, 1.2012d0,
     & 1.2022d0, 1.2032d0, 1.2042d0, 1.2053d0, 1.2063d0, 1.2074d0,
     & 1.2084d0, 1.2094d0, 1.2104d0, 1.2114d0, 1.2125d0, 1.2135d0,
     & 1.2145d0, 1.2156d0, 1.2166d0, 1.2176d0, 1.2186d0, 1.2196d0,
     & 1.2207d0, 1.2217d0, 1.2227d0, 1.2238d0, 1.2248d0, 1.2258d0,
     & 1.2268d0, 1.2278d0, 1.2289d0, 1.2299d0, 1.2310d0, 1.2320d0,
     & 1.2330d0, 1.2340d0, 1.2350d0, 1.2360d0, 1.2371d0, 1.2381d0,
     & 1.2391d0, 1.2402d0, 1.2412d0, 1.2422d0, 1.2432d0, 1.2442d0,
     & 1.2453d0, 1.2463d0, 1.2473d0, 1.2484d0, 1.2494d0, 1.2504d0,
     & 1.2514d0, 1.2525d0, 1.2535d0, 1.2545d0, 1.2555d0, 1.2566d0,
     & 1.2576d0, 1.2586d0, 1.2596d0, 1.2607d0, 1.2617d0, 1.2627d0,
     & 1.2637d0, 1.2647d0, 1.2658d0, 1.2668d0, 1.2678d0, 1.2688d0,
     & 1.2699d0, 1.2709d0, 1.2719d0, 1.2729d0, 1.2739d0, 1.2750d0,
     & 1.2760d0, 1.2770d0, 1.2781d0, 1.2791d0, 1.2801d0, 1.2811d0,
     & 1.2821d0, 1.2831d0, 1.2842d0, 1.2852d0, 1.2862d0, 1.2873d0,
     & 1.2883d0, 1.2893d0, 1.2903d0, 1.2913d0, 1.2923d0, 1.2934d0,
     & 1.2944d0, 1.2954d0, 1.2964d0, 1.2975d0, 1.2985d0, 1.2995d0,
     & 1.3005d0, 1.3015d0, 1.3026d0, 1.3036d0, 1.3046d0, 1.3056d0,
     & 1.3066d0, 1.3077d0, 1.3087d0, 1.3097d0, 1.3107d0, 1.3117d0,
     & 1.3128d0, 1.3138d0, 1.3148d0, 1.3158d0, 1.3168d0, 1.3179d0,
     & 1.3189d0, 1.3199d0, 1.3209d0, 1.3219d0, 1.3230d0, 1.3240d0,
     & 1.3250d0, 1.3260d0, 1.3270d0, 1.3281d0, 1.3291d0, 1.3301d0,
     & 1.3311d0, 1.3321d0, 1.3332d0, 1.3342d0, 1.3352d0, 1.3362d0,
     & 1.3372d0, 1.3383d0, 1.3393d0, 1.3403d0, 1.3413d0, 1.3423d0,
     & 1.3433d0, 1.3443d0, 1.3454d0, 1.3464d0, 1.3474d0, 1.3484d0,
     & 1.3494d0, 1.3505d0, 1.3515d0, 1.3525d0, 1.3535d0, 1.3545d0,
     & 1.3555d0, 1.3565d0, 1.3576d0, 1.3586d0, 1.3596d0, 1.3606d0,
     & 1.3616d0, 1.3627d0, 1.3637d0, 1.3647d0, 1.3657d0, 1.3667d0,
     & 1.3677d0, 1.3687d0, 1.3698d0, 1.3708d0, 1.3718d0, 1.3728d0,
     & 1.3738d0, 1.3749d0, 1.3759d0, 1.3769d0, 1.3779d0, 1.3789d0,
     & 1.3799d0, 1.3809d0, 1.3819d0, 1.3830d0, 1.3840d0, 1.3850d0,
     & 1.3860d0, 1.3870d0, 1.3881d0, 1.3891d0, 1.3901d0, 1.3911d0,
     & 1.3921d0, 1.3931d0, 1.3941d0, 1.3951d0, 1.3961d0, 1.3972d0,
     & 1.3982d0, 1.3992d0, 1.4002d0, 1.4013d0, 1.4023d0, 1.4033d0,
     & 1.4043d0, 1.4053d0, 1.4063d0, 1.4073d0, 1.4083d0, 1.4093d0,
     & 1.4103d0, 1.4114d0, 1.4124d0, 1.4134d0, 1.4144d0, 1.4155d0,
     & 1.4165d0, 1.4175d0, 1.4185d0, 1.4195d0, 1.4205d0, 1.4215d0,
     & 1.4225d0, 1.4235d0, 1.4245d0, 1.4256d0, 1.4266d0, 1.4276d0,
     & 1.4286d0, 1.4297d0, 1.4307d0, 1.4317d0, 1.4327d0, 1.4337d0,
     & 1.4347d0, 1.4357d0, 1.4367d0, 1.4377d0, 1.4387d0, 1.4397d0,
     & 1.4408d0, 1.4418d0, 1.4428d0, 1.4438d0, 1.4449d0, 1.4459d0,
     & 1.4469d0, 1.4479d0, 1.4489d0, 1.4499d0, 1.4509d0, 1.4519d0,
     & 1.4529d0, 1.4539d0, 1.4549d0, 1.4559d0, 1.4570d0, 1.4580d0,
     & 1.4590d0, 1.4600d0, 1.4611d0, 1.4621d0, 1.4631d0, 1.4641d0,
     & 1.4651d0, 1.4661d0, 1.4671d0, 1.4681d0, 1.4691d0, 1.4701d0,
     & 1.4711d0, 1.4722d0, 1.4732d0, 1.4742d0, 1.4752d0, 1.4763d0,
     & 1.4773d0, 1.4783d0, 1.4793d0, 1.4803d0, 1.4813d0, 1.4822d0,
     & 1.4832d0, 1.4843d0, 1.4853d0, 1.4863d0, 1.4873d0, 1.4883d0,
     & 1.4894d0, 1.4904d0, 1.4914d0, 1.4924d0, 1.4935d0, 1.4945d0,
     & 1.4955d0, 1.4965d0, 1.4974d0, 1.4984d0, 1.4994d0, 1.5004d0,
     & 1.5014d0, 1.5025d0, 1.5035d0, 1.5045d0, 1.5055d0, 1.5066d0,
     & 1.5076d0, 1.5086d0, 1.5097d0, 1.5107d0, 1.5117d0, 1.5126d0,
     & 1.5136d0, 1.5146d0, 1.5156d0, 1.5166d0, 1.5176d0, 1.5186d0,
     & 1.5197d0, 1.5207d0, 1.5217d0, 1.5227d0, 1.5238d0, 1.5248d0,
     & 1.5258d0, 1.5268d0, 1.5278d0, 1.5288d0, 1.5298d0, 1.5308d0,
     & 1.5318d0, 1.5328d0, 1.5338d0, 1.5348d0, 1.5358d0, 1.5368d0,
     & 1.5379d0, 1.5389d0, 1.5399d0, 1.5409d0, 1.5420d0, 1.5430d0,
     & 1.5440d0, 1.5450d0, 1.5460d0, 1.5470d0, 1.5480d0, 1.5490d0,
     & 1.5499d0, 1.5509d0, 1.5520d0, 1.5530d0, 1.5540d0, 1.5550d0,
     & 1.5560d0, 1.5571d0, 1.5581d0, 1.5591d0, 1.5602d0, 1.5612d0,
     & 1.5622d0, 1.5632d0, 1.5642d0, 1.5652d0, 1.5661d0, 1.5671d0,
     & 1.5681d0, 1.5691d0, 1.5701d0, 1.5711d0, 1.5722d0, 1.5732d0,
     & 1.5742d0, 1.5752d0, 1.5763d0, 1.5773d0, 1.5783d0, 1.5794d0,
     & 1.5804d0, 1.5813d0, 1.5823d0, 1.5833d0, 1.5843d0, 1.5853d0,
     & 1.5863d0, 1.5872d0, 1.5882d0, 1.5893d0, 1.5903d0, 1.5913d0,
     & 1.5923d0, 1.5933d0, 1.5944d0, 1.5954d0, 1.5964d0, 1.5975d0,
     & 1.5985d0, 1.5995d0, 1.6005d0, 1.6015d0, 1.6025d0, 1.6035d0,
     & 1.6045d0, 1.6054d0, 1.6064d0, 1.6074d0, 1.6084d0, 1.6094d0,
     & 1.6104d0, 1.6114d0, 1.6125d0, 1.6135d0, 1.6145d0, 1.6155d0,
     & 1.6166d0, 1.6176d0, 1.6186d0, 1.6197d0, 1.6207d0, 1.6216d0,
     & 1.6226d0, 1.6236d0, 1.6246d0, 1.6256d0, 1.6266d0, 1.6275d0,
     & 1.6285d0, 1.6295d0, 1.6305d0, 1.6316d0, 1.6326d0, 1.6336d0,
     & 1.6346d0, 1.6357d0, 1.6367d0, 1.6377d0, 1.6388d0, 1.6398d0,
     & 1.6408d0, 1.6418d0, 1.6428d0, 1.6438d0, 1.6448d0, 1.6458d0,
     & 1.6467d0, 1.6477d0, 1.6487d0, 1.6497d0, 1.6507d0, 1.6517d0,
     & 1.6527d0, 1.6537d0, 1.6547d0, 1.6558d0, 1.6568d0, 1.6578d0,
     & 1.6589d0, 1.6599d0, 1.6609d0, 1.6619d0, 1.6629d0, 1.6639d0,
     & 1.6649d0, 1.6659d0, 1.6669d0, 1.6679d0, 1.6689d0, 1.6698d0,
     & 1.6708d0, 1.6718d0, 1.6728d0, 1.6738d0, 1.6748d0, 1.6758d0,
     & 1.6769d0, 1.6779d0, 1.6789d0, 1.6800d0, 1.6810d0, 1.6820d0,
     & 1.6831d0, 1.6841d0, 1.6851d0, 1.6861d0, 1.6871d0, 1.6880d0,
     & 1.6890d0, 1.6900d0, 1.6910d0, 1.6920d0, 1.6929d0, 1.6939d0,
     & 1.6949d0, 1.6959d0, 1.6969d0, 1.6980d0, 1.6990d0, 1.7000d0,
     & 1.7011d0, 1.7021d0, 1.7031d0, 1.7042d0, 1.7052d0, 1.7062d0,
     & 1.7072d0, 1.7082d0, 1.7092d0, 1.7102d0, 1.7112d0, 1.7122d0,
     & 1.7131d0, 1.7141d0, 1.7151d0, 1.7161d0, 1.7170d0, 1.7180d0,
     & 1.7191d0, 1.7201d0, 1.7211d0, 1.7221d0, 1.7231d0, 1.7242d0,
     & 1.7252d0, 1.7262d0, 1.7273d0, 1.7283d0, 1.7293d0, 1.7303d0,
     & 1.7313d0, 1.7323d0, 1.7333d0, 1.7343d0, 1.7353d0, 1.7363d0,
     & 1.7372d0, 1.7382d0, 1.7392d0, 1.7402d0, 1.7412d0, 1.7422d0,
     & 1.7432d0, 1.7442d0, 1.7452d0, 1.7463d0, 1.7473d0, 1.7483d0,
     & 1.7494d0, 1.7504d0, 1.7514d0, 1.7525d0, 1.7535d0, 1.7545d0,
     & 1.7555d0, 1.7565d0, 1.7574d0, 1.7584d0, 1.7594d0, 1.7604d0,
     & 1.7614d0, 1.7623d0, 1.7633d0, 1.7643d0, 1.7653d0, 1.7663d0,
     & 1.7673d0, 1.7683d0, 1.7693d0, 1.7704d0, 1.7714d0, 1.7724d0,
     & 1.7735d0, 1.7745d0, 1.7755d0, 1.7766d0, 1.7776d0, 1.7786d0,
     & 1.7796d0, 1.7806d0, 1.7816d0, 1.7825d0, 1.7835d0, 1.7845d0,
     & 1.7855d0, 1.7865d0, 1.7874d0, 1.7884d0, 1.7894d0, 1.7904d0,
     & 1.7914d0, 1.7924d0, 1.7934d0, 1.7944d0, 1.7954d0, 1.7965d0,
     & 1.7975d0, 1.7985d0, 1.7996d0, 1.8006d0, 1.8017d0, 1.8027d0,
     & 1.8037d0, 1.8047d0, 1.8057d0, 1.8067d0, 1.8077d0, 1.8087d0,
     & 1.8097d0, 1.8106d0, 1.8116d0, 1.8126d0, 1.8136d0, 1.8145d0,
     & 1.8155d0, 1.8165d0, 1.8175d0, 1.8185d0, 1.8195d0, 1.8205d0,
     & 1.8215d0, 1.8226d0, 1.8236d0, 1.8246d0, 1.8257d0, 1.8267d0,
     & 1.8278d0, 1.8288d0, 1.8298d0, 1.8308d0, 1.8318d0, 1.8328d0,
     & 1.8338d0, 1.8348d0, 1.8358d0, 1.8368d0, 1.8377d0, 1.8387d0,
     & 1.8397d0, 1.8407d0, 1.8417d0, 1.8426d0, 1.8436d0, 1.8446d0,
     & 1.8456d0, 1.8466d0, 1.8476d0, 1.8486d0, 1.8497d0, 1.8507d0,
     & 1.8517d0, 1.8528d0, 1.8538d0, 1.8548d0, 1.8559d0, 1.8569d0,
     & 1.8579d0, 1.8589d0, 1.8599d0, 1.8609d0, 1.8619d0, 1.8629d0,
     & 1.8639d0, 1.8649d0, 1.8658d0, 1.8668d0, 1.8678d0, 1.8688d0,
     & 1.8697d0, 1.8707d0, 1.8717d0, 1.8727d0, 1.8737d0, 1.8747d0,
     & 1.8757d0, 1.8767d0, 1.8777d0, 1.8788d0, 1.8798d0, 1.8808d0,
     & 1.8819d0, 1.8829d0, 1.8840d0, 1.8850d0, 1.8860d0, 1.8870d0,
     & 1.8880d0, 1.8890d0, 1.8900d0, 1.8910d0, 1.8920d0, 1.8929d0,
     & 1.8939d0, 1.8949d0, 1.8959d0, 1.8969d0, 1.8978d0, 1.8988d0,
     & 1.8998d0, 1.9008d0, 1.9017d0, 1.9027d0, 1.9038d0, 1.9048d0,
     & 1.9058d0, 1.9069d0, 1.9079d0, 1.9089d0, 1.9100d0, 1.9110d0,
     & 1.9121d0, 1.9131d0, 1.9141d0, 1.9151d0, 1.9161d0, 1.9171d0,
     & 1.9181d0, 1.9191d0, 1.9201d0, 1.9211d0, 1.9221d0, 1.9230d0,
     & 1.9240d0, 1.9250d0, 1.9260d0, 1.9270d0, 1.9279d0, 1.9289d0,
     & 1.9299d0, 1.9309d0, 1.9319d0, 1.9329d0, 1.9339d0, 1.9349d0,
     & 1.9359d0, 1.9370d0, 1.9380d0, 1.9391d0, 1.9401d0, 1.9411d0,
     & 1.9422d0, 1.9432d0, 1.9442d0, 1.9452d0, 1.9462d0, 1.9472d0,
     & 1.9482d0, 1.9492d0, 1.9502d0, 1.9512d0, 1.9522d0, 1.9531d0,
     & 1.9541d0, 1.9551d0, 1.9561d0, 1.9571d0, 1.9580d0, 1.9590d0,
     & 1.9600d0, 1.9609d0, 1.9619d0, 1.9629d0, 1.9639d0, 1.9649d0,
     & 1.9660d0, 1.9670d0, 1.9680d0, 1.9691d0, 1.9701d0, 1.9712d0,
     & 1.9722d0, 1.9733d0, 1.9743d0, 1.9753d0, 1.9763d0, 1.9773d0,
     & 1.9783d0, 1.9793d0, 1.9803d0, 1.9813d0, 1.9823d0, 1.9833d0,
     & 1.9842d0, 1.9852d0, 1.9862d0, 1.9872d0, 1.9881d0, 1.9891d0,
     & 1.9901d0, 1.9911d0, 1.9920d0, 1.9930d0, 1.9940d0, 1.9950d0,
     & 1.9960d0, 1.9970d0, 1.9981d0, 1.9991d0, 2.0001d0, 2.0012d0,
     & 2.0022d0, 2.0033d0, 2.0043d0, 2.0054d0, 2.0064d0, 2.0074d0,
     & 2.0084d0, 2.0094d0, 2.0104d0, 2.0114d0, 2.0124d0, 2.0134d0,
     & 2.0144d0, 2.0153d0, 2.0163d0, 2.0173d0, 2.0183d0, 2.0193d0,
     & 2.0202d0, 2.0212d0, 2.0222d0, 2.0232d0, 2.0241d0, 2.0251d0,
     & 2.0261d0, 2.0271d0, 2.0281d0, 2.0291d0, 2.0302d0, 2.0312d0,
     & 2.0322d0, 2.0332d0, 2.0343d0, 2.0353d0, 2.0364d0, 2.0374d0,
     & 2.0384d0, 2.0394d0, 2.0404d0, 2.0415d0, 2.0425d0, 2.0435d0,
     & 2.0445d0, 2.0454d0, 2.0464d0, 2.0474d0, 2.0484d0, 2.0494d0,
     & 2.0504d0, 2.0513d0, 2.0523d0, 2.0533d0, 2.0543d0, 2.0552d0,
     & 2.0562d0, 2.0572d0, 2.0582d0, 2.0591d0, 2.0601d0, 2.0611d0,
     & 2.0621d0, 2.0631d0, 2.0641d0, 2.0652d0, 2.0662d0, 2.0673d0,
     & 2.0683d0, 2.0694d0, 2.0704d0, 2.0714d0, 2.0725d0, 2.0735d0,
     & 2.0746d0, 2.0756d0, 2.0766d0, 2.0776d0, 2.0786d0, 2.0795d0,
     & 2.0805d0, 2.0815d0, 2.0825d0, 2.0834d0, 2.0846d0, 2.0857d0,
     & 2.0869d0, 2.0881d0, 2.0892d0, 2.0902d0, 2.0912d0, 2.0922d0,
     & 2.0931d0, 2.0941d0, 2.0951d0, 2.0959d0, 2.0968d0, 2.0976d0,
     & 2.0985d0, 2.0993d0, 2.1004d0, 2.1015d0, 2.1026d0, 2.1036d0,
     & 2.1047d0, 2.1057d0, 2.1067d0, 2.1077d0, 2.1087d0, 2.1097d0,
     & 2.1107d0, 2.1117d0, 2.1127d0, 2.1136d0, 2.1146d0, 2.1157d0,
     & 2.1168d0, 2.1178d0, 2.1188d0, 2.1198d0, 2.1207d0, 2.1217d0,
     & 2.1227d0, 2.1235d0, 2.1245d0, 2.1255d0, 2.1263d0, 2.1272d0,
     & 2.1282d0, 2.1292d0, 2.1301d0, 2.1311d0, 2.1322d0, 2.1332d0,
     & 2.1343d0, 2.1353d0, 2.1363d0, 2.1374d0, 2.1384d0, 2.1395d0,
     & 2.1405d0, 2.1416d0, 2.1428d0, 2.1437d0, 2.1447d0, 2.1457d0,
     & 2.1467d0, 2.1477d0, 2.1487d0, 2.1497d0, 2.1507d0, 2.1516d0,
     & 2.1526d0, 2.1535d0, 2.1544d0, 2.1554d0, 2.1564d0, 2.1574d0,
     & 2.1583d0, 2.1593d0, 2.1603d0, 2.1613d0, 2.1622d0, 2.1632d0,
     & 2.1643d0, 2.1653d0, 2.1663d0, 2.1674d0, 2.1684d0, 2.1694d0,
     & 2.1704d0, 2.1714d0, 2.1725d0, 2.1735d0, 2.1746d0, 2.1756d0,
     & 2.1766d0, 2.1776d0, 2.1786d0, 2.1796d0, 2.1806d0, 2.1816d0,
     & 2.1826d0, 2.1836d0, 2.1846d0, 2.1856d0, 2.1865d0, 2.1875d0,
     & 2.1885d0, 2.1895d0, 2.1906d0, 2.1916d0, 2.1926d0, 2.1937d0,
     & 2.1947d0, 2.1958d0, 2.1967d0, 2.1977d0, 2.1987d0, 2.1996d0,
     & 2.2006d0, 2.2015d0, 2.2024d0, 2.2033d0, 2.2043d0, 2.2053d0,
     & 2.2062d0, 2.2072d0, 2.2083d0, 2.2093d0, 2.2104d0, 2.2114d0,
     & 2.2125d0, 2.2135d0, 2.2146d0, 2.2156d0, 2.2166d0, 2.2175d0,
     & 2.2186d0, 2.2196d0, 2.2206d0, 2.2216d0, 2.2226d0, 2.2236d0,
     & 2.2245d0, 2.2255d0, 2.2266d0, 2.2277d0, 2.2288d0, 2.2298d0,
     & 2.2308d0, 2.2319d0, 2.2329d0, 2.2339d0, 2.2349d0, 2.2358d0,
     & 2.2368d0, 2.2377d0, 2.2386d0, 2.2395d0, 2.2405d0, 2.2415d0,
     & 2.2424d0, 2.2434d0, 2.2444d0, 2.2454d0, 2.2465d0, 2.2475d0,
     & 2.2485d0, 2.2495d0, 2.2505d0, 2.2515d0, 2.2525d0, 2.2535d0,
     & 2.2546d0, 2.2556d0, 2.2566d0, 2.2576d0, 2.2587d0, 2.2597d0,
     & 2.2607d0, 2.2617d0, 2.2627d0, 2.2637d0, 2.2647d0, 2.2657d0,
     & 2.2668d0, 2.2678d0, 2.2689d0, 2.2698d0, 2.2708d0, 2.2717d0,
     & 2.2727d0, 2.2744d0, 2.2771d0, 2.2805d0, 2.2846d0, 2.2896d0,
     & 2.2955d0, 2.3021d0, 2.3096d0, 2.3180d0, 2.3272d0, 2.3372d0,
     & 2.3472d0, 2.3571d0, 2.3670d0, 2.3770d0, 2.3869d0, 2.3968d0,
     & 2.4068d0, 2.4168d0, 2.4268d0, 2.4367d0, 2.4466d0, 2.4566d0,
     & 2.4665d0, 2.4764d0, 2.4864d0, 2.4963d0, 2.5063d0, 2.5162d0,
     & 2.5261d0, 2.5360d0, 2.5460d0, 2.5559d0, 2.5658d0, 2.5757d0,
     & 2.5857d0, 2.5956d0, 2.6056d0, 2.6155d0, 2.6253d0, 2.6352d0,
     & 2.6451d0, 2.6550d0, 2.6649d0, 2.6748d0, 2.6847d0, 2.6946d0,
     & 2.7045d0, 2.7143d0, 2.7242d0, 2.7342d0, 2.7442d0, 2.7541d0,
     & 2.7640d0, 2.7740d0, 2.7840d0, 2.7940d0, 2.8039d0, 2.8138d0,
     & 2.8237d0, 2.8336d0, 2.8435d0, 2.8534d0, 2.8633d0, 2.8732d0,
     & 2.8830d0, 2.8929d0, 2.9027d0, 2.9127d0, 2.9226d0, 2.9325d0,
     & 2.9423d0, 2.9523d0, 2.9622d0, 2.9721d0, 2.9821d0, 2.9920d0,
     & 3.0019d0, 3.0118d0, 3.0217d0, 3.0316d0, 3.0415d0, 3.0515d0,
     & 3.0613d0, 3.0712d0, 3.0811d0, 3.0910d0, 3.1010d0, 3.1109d0,
     & 3.1208d0, 3.1306d0, 3.1405d0, 3.1505d0, 3.1603d0, 3.1702d0,
     & 3.1800d0, 3.1899d0, 3.1997d0, 3.2096d0, 3.2194d0, 3.2294d0,
     & 3.2393d0, 3.2492d0, 3.2590d0, 3.2689d0, 3.2788d0, 3.2888d0,
     & 3.2987d0, 3.3086d0, 3.3185d0, 3.3284d0, 3.3382d0, 3.3481d0,
     & 3.3580d0, 3.3679d0, 3.3778d0, 3.3876d0, 3.3974d0, 3.4073d0,
     & 3.4171d0, 3.4269d0, 3.4368d0, 3.4468d0, 3.4567d0, 3.4666d0,
     & 3.4764d0, 3.4863d0, 3.4962d0, 3.5062d0, 3.5161d0, 3.5261d0,
     & 3.5360d0, 3.5458d0, 3.5557d0, 3.5656d0, 3.5755d0, 3.5855d0,
     & 3.5954d0, 3.6053d0, 3.6151d0, 3.6249d0, 3.6349d0, 3.6447d0,
     & 3.6545d0, 3.6644d0, 3.6743d0, 3.6842d0, 3.6940d0, 3.7039d0,
     & 3.7137d0, 3.7236d0, 3.7334d0, 3.7432d0, 3.7532d0, 3.7631d0,
     & 3.7730d0, 3.7829d0, 3.7927d0, 3.8026d0, 3.8123d0, 3.8223d0,
     & 3.8322d0, 3.8422d0, 3.8521d0, 3.8619d0, 3.8718d0, 3.8817d0,
     & 3.8915d0, 3.9014d0, 3.9113d0, 3.9212d0, 3.9311d0, 3.9410d0,
     & 3.9509d0, 3.9608d0, 3.9707d0, 3.9805d0, 3.9903d0, 4.0003d0,
     & 4.0103d0, 4.0202d0, 4.0302d0, 4.0400d0, 4.0500d0, 4.0598d0,
     & 4.0697d0, 4.0796d0, 4.0896d0, 4.0996d0, 4.1095d0, 4.1193d0,
     & 4.1292d0, 4.1390d0, 4.1488d0, 4.1586d0, 4.1686d0, 4.1784d0,
     & 4.1882d0, 4.1981d0, 4.2080d0, 4.2179d0, 4.2277d0, 4.2377d0,
     & 4.2476d0, 4.2575d0, 4.2675d0, 4.2773d0, 4.2873d0, 4.2973d0,
     & 4.3073d0, 4.3171d0, 4.3271d0, 4.3369d0, 4.3468d0, 4.3566d0,
     & 4.3665d0, 4.3765d0, 4.3865d0, 4.3965d0, 4.4064d0, 4.4163d0,
     & 4.4262d0, 4.4362d0, 4.4462d0, 4.4561d0, 4.4661d0, 4.4760d0,
     & 4.4859d0, 4.4957d0, 4.5056d0, 4.5156d0, 4.5255d0, 4.5355d0,
     & 4.5454d0, 4.5553d0, 4.5653d0, 4.5753d0, 4.5852d0, 4.5953d0,
     & 4.6052d0, 4.6151d0, 4.6249d0, 4.6347d0, 4.6447d0, 4.6546d0,
     & 4.6646d0, 4.6745d0, 4.6846d0, 4.6945d0, 4.7045d0, 4.7144d0,
     & 4.7244d0, 4.7344d0, 4.7444d0, 4.7544d0, 4.7644d0, 4.7744d0,
     & 4.7843d0, 4.7943d0, 4.8043d0, 4.8142d0, 4.8242d0, 4.8343d0,
     & 4.8443d0, 4.8543d0, 4.8642d0, 4.8742d0, 4.8842d0, 4.8940d0,
     & 4.9041d0, 4.9141d0, 4.9242d0, 4.9342d0, 4.9441d0, 4.9541d0,
     & 4.9641d0, 4.9741d0, 4.9842d0, 4.9941d0, 5.0043d0, 5.0143d0,
     & 5.0244d0, 5.0344d0, 5.0445d0, 5.0546d0, 5.0647d0, 5.0747d0,
     & 5.0848d0, 5.0947d0, 5.1048d0, 5.1147d0, 5.1247d0, 5.1348d0,
     & 5.1449d0, 5.1550d0, 5.1650d0, 5.1751d0, 5.1853d0, 5.1954d0,
     & 5.2054d0, 5.2154d0, 5.2257d0, 5.2357d0, 5.2457d0, 5.2558d0,
     & 5.2659d0, 5.2761d0, 5.2863d0, 5.2964d0, 5.3066d0, 5.3169d0,
     & 5.3271d0, 5.3371d0, 5.3473d0, 5.3574d0, 5.3674d0, 5.3774d0,
     & 5.3874d0, 5.3975d0, 5.4076d0, 5.4177d0, 5.4279d0, 5.4381d0,
     & 5.4482d0, 5.4585d0, 5.4686d0, 5.4789d0, 5.4891d0, 5.4994d0,
     & 5.5094d0, 5.5195d0, 5.5295d0, 5.5396d0, 5.5496d0, 5.5597d0,
     & 5.5699d0, 5.5802d0, 5.5904d0, 5.6007d0, 5.6109d0, 5.6212d0,
     & 5.6315d0, 5.6419d0, 5.6523d0, 5.6626d0, 5.6729d0, 5.6829d0,
     & 5.6931d0, 5.7033d0, 5.7134d0, 5.7236d0, 5.7337d0, 5.7440d0,
     & 5.7542d0, 5.7645d0, 5.7748d0, 5.7852d0, 5.7957d0, 5.8061d0,
     & 5.8163d0, 5.8266d0, 5.8370d0, 5.8474d0, 5.8575d0, 5.8677d0,
     & 5.8779d0, 5.8883d0, 5.8986d0, 5.9090d0, 5.9191d0, 5.9296d0,
     & 5.9400d0, 5.9505d0, 5.9608d0, 5.9713d0, 5.9817d0, 5.9920d0,
     & 6.0023d0, 6.0126d0, 6.0228d0, 6.0333d0, 6.0435d0, 6.0538d0,
     & 6.0643d0, 6.0748d0, 6.0852d0, 6.0957d0, 6.1063d0, 6.1169d0,
     & 6.1274d0, 6.1379d0, 6.1484d0, 6.1589d0, 6.1694d0, 6.1798d0,
     & 6.1903d0, 6.2007d0, 6.2111d0, 6.2215d0, 6.2319d0, 6.2423d0,
     & 6.2528d0, 6.2631d0, 6.2738d0, 6.2843d0, 6.2948d0, 6.3054d0,
     & 6.3159d0, 6.3265d0, 6.3371d0, 6.3476d0, 6.3581d0, 6.3685d0,
     & 6.3791d0, 6.3895d0, 6.4000d0, 6.4105d0, 6.4210d0, 6.4315d0,
     & 6.4420d0, 6.4527d0, 6.4634d0, 6.4741d0, 6.4849d0, 6.4957d0,
     & 6.5065d0, 6.5173d0, 6.5281d0, 6.5389d0, 6.5496d0, 6.5603d0,
     & 6.5709d0, 6.5814d0, 6.5920d0, 6.6025d0, 6.6131d0, 6.6237d0,
     & 6.6343d0, 6.6449d0, 6.6556d0, 6.6662d0, 6.6769d0, 6.6875d0,
     & 6.6982d0, 6.7088d0, 6.7195d0, 6.7302d0, 6.7409d0, 6.7515d0,
     & 6.7621d0, 6.7728d0, 6.7835d0, 6.7944d0, 6.8053d0, 6.8164d0,
     & 6.8272d0, 6.8383d0, 6.8492d0, 6.8602d0, 6.8713d0, 6.8824d0,
     & 6.8933d0, 6.9042d0, 6.9149d0, 6.9256d0, 6.9364d0, 6.9473d0,
     & 6.9580d0, 6.9687d0, 6.9795d0, 6.9902d0, 7.0011d0, 7.0120d0,
     & 7.0229d0, 7.0339d0, 7.0450d0, 7.0558d0, 7.0668d0, 7.0780d0,
     & 7.0889d0, 7.0998d0, 7.1108d0, 7.1218d0, 7.1330d0, 7.1443d0,
     & 7.1555d0, 7.1663d0, 7.1774d0, 7.1885d0, 7.1993d0, 7.2103d0,
     & 7.2216d0, 7.2329d0, 7.2439d0, 7.2549d0, 7.2659d0, 7.2769d0,
     & 7.2881d0, 7.2991d0, 7.3104d0, 7.3218d0, 7.3330d0, 7.3442d0,
     & 7.3555d0, 7.3668d0, 7.3781d0, 7.3893d0, 7.4003d0, 7.4116d0,
     & 7.4229d0, 7.4340d0, 7.4453d0, 7.4568d0, 7.4679d0, 7.4792d0,
     & 7.4903d0, 7.5016d0, 7.5132d0, 7.5247d0, 7.5362d0, 7.5478d0,
     & 7.5594d0, 7.5708d0, 7.5822d0, 7.5938d0, 7.6052d0, 7.6166d0,
     & 7.6280d0, 7.6393d0, 7.6507d0, 7.6621d0, 7.6736d0, 7.6850d0,
     & 7.6963d0, 7.7078d0, 7.7193d0, 7.7307d0, 7.7424d0, 7.7540d0,
     & 7.7657d0, 7.7772d0, 7.7889d0, 7.8006d0, 7.8123d0, 7.8240d0,
     & 7.8355d0, 7.8468d0, 7.8583d0, 7.8698d0, 7.8812d0, 7.8925d0,
     & 7.9040d0, 7.9157d0, 7.9273d0, 7.9389d0, 7.9504d0, 7.9621d0,
     & 7.9741d0, 7.9861d0, 7.9979d0, 8.0099d0, 8.0220d0, 8.0340d0,
     & 8.0455d0, 8.0571d0, 8.0690d0, 8.0810d0, 8.0930d0, 8.1049d0,
     & 8.1168d0, 8.1289d0, 8.1409d0, 8.1527d0, 8.1645d0, 8.1767d0,
     & 8.1890d0, 8.2008d0, 8.2128d0, 8.2249d0, 8.2369d0, 8.2489d0,
     & 8.2610d0, 8.2731d0, 8.2854d0, 8.2978d0, 8.3100d0, 8.3220d0,
     & 8.3343d0, 8.3466d0, 8.3587d0, 8.3707d0, 8.3827d0, 8.3948d0,
     & 8.4070d0, 8.4192d0, 8.4312d0, 8.4434d0, 8.4556d0, 8.4680d0,
     & 8.4800d0, 8.4922d0, 8.5049d0, 8.5174d0, 8.5299d0, 8.5423d0,
     & 8.5546d0, 8.5672d0, 8.5797d0, 8.5922d0, 8.6047d0, 8.6173d0,
     & 8.6301d0, 8.6425d0, 8.6548d0, 8.6675d0, 8.6800d0, 8.6927d0,
     & 8.7054d0, 8.7181d0, 8.7308d0, 8.7434d0, 8.7562d0, 8.7687d0,
     & 8.7815d0, 8.7944d0, 8.8071d0, 8.8198d0, 8.8324d0, 8.8454d0,
     & 8.8583d0, 8.8711d0, 8.8842d0, 8.8971d0, 8.9102d0, 8.9229d0,
     & 8.9361d0, 8.9491d0, 8.9624d0, 8.9756d0, 8.9887d0, 9.0019d0,
     & 9.0152d0, 9.0283d0, 9.0416d0, 9.0548d0, 9.0681d0, 9.0811d0,
     & 9.0942d0, 9.1074d0, 9.1204d0, 9.1333d0, 9.1464d0, 9.1596d0,
     & 9.1726d0, 9.1860d0, 9.1994d0, 9.2130d0, 9.2265d0, 9.2401d0,
     & 9.2535d0, 9.2669d0, 9.2809d0, 9.2945d0, 9.3083d0, 9.3221d0,
     & 9.3353d0, 9.3491d0, 9.3627d0, 9.3763d0, 9.3899d0, 9.4036d0,
     & 9.4176d0, 9.4311d0, 9.4451d0, 9.4588d0, 9.4726d0, 9.4869d0,
     & 9.5006d0, 9.5146d0, 9.5288d0, 9.5430d0, 9.5574d0, 9.5716d0,
     & 9.5855d0, 9.5993d0, 9.6134d0, 9.6278d0, 9.6417d0, 9.6559d0,
     & 9.6704d0, 9.6848d0, 9.6987d0, 9.7126d0, 9.7266d0, 9.7412d0,
     & 9.7560d0, 9.7703d0, 9.7845d0, 9.7991d0, 9.8136d0, 9.8280d0,
     & 9.8425d0, 9.8575d0, 9.8727d0, 9.8876d0, 9.9021d0, 9.9168d0,
     & 9.9312d0, 9.9442d0, 9.9558d0, 9.9662d0, 9.9751d0, 9.9826d0,
     & 9.9887d0, 9.9934d0, 9.9968d0, 9.9993d0, 9.9999d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0, 9.9999d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,10.0000d0,
     &10.0000d0,10.0000d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0,
     & 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0, 9.9999d0
     &/
      DATA (Imax (10,I), I= 1, 1000) /
     & 0.00003228d0, 0.00003228d0, 0.00004642d0, 0.00011513d0,
     & 0.00025080d0, 0.00045980d0, 0.00077238d0, 0.00114275d0,
     & 0.00160215d0, 0.00218237d0, 0.00285804d0, 0.00360689d0,
     & 0.00455388d0, 0.00554908d0, 0.00664467d0, 0.00782855d0,
     & 0.00905721d0, 0.01030313d0, 0.01167044d0, 0.01307098d0,
     & 0.01448748d0, 0.01598109d0, 0.01756061d0, 0.01910639d0,
     & 0.02071525d0, 0.02237203d0, 0.02403986d0, 0.02575274d0,
     & 0.02748470d0, 0.02922734d0, 0.03103065d0, 0.03287616d0,
     & 0.03470214d0, 0.03652840d0, 0.03840319d0, 0.04034159d0,
     & 0.04223257d0, 0.04414468d0, 0.04607972d0, 0.04807551d0,
     & 0.05005857d0, 0.05204698d0, 0.05403737d0, 0.05607470d0,
     & 0.05811100d0, 0.06015586d0, 0.06219022d0, 0.06429208d0,
     & 0.06639085d0, 0.06849374d0, 0.07059767d0, 0.07271367d0,
     & 0.07486112d0, 0.07702418d0, 0.07917624d0, 0.08133689d0,
     & 0.08350731d0, 0.08571551d0, 0.08791532d0, 0.09011044d0,
     & 0.09231230d0, 0.09452150d0, 0.09673731d0, 0.09897542d0,
     & 0.10121769d0, 0.10346483d0, 0.10571770d0, 0.10797577d0,
     & 0.11022190d0, 0.11251024d0, 0.11482473d0, 0.11712877d0,
     & 0.11942266d0, 0.12173364d0, 0.12401567d0, 0.12634625d0,
     & 0.12869895d0, 0.13105577d0, 0.13339929d0, 0.13574395d0,
     & 0.13805258d0, 0.14040411d0, 0.14279710d0, 0.14520065d0,
     & 0.14758980d0, 0.14997928d0, 0.15233225d0, 0.15468208d0,
     & 0.15709350d0, 0.15952547d0, 0.16195801d0, 0.16437384d0,
     & 0.16676076d0, 0.16913901d0, 0.17153735d0, 0.17399170d0,
     & 0.17644837d0, 0.17890586d0, 0.18136071d0, 0.18375438d0,
     & 0.18614568d0, 0.18858346d0, 0.19107918d0, 0.19357762d0,
     & 0.19607453d0, 0.19853996d0, 0.20096587d0, 0.20339049d0,
     & 0.20583278d0, 0.20833600d0, 0.21086034d0, 0.21340005d0,
     & 0.21590894d0, 0.21835785d0, 0.22080369d0, 0.22324790d0,
     & 0.22575314d0, 0.22831012d0, 0.23086581d0, 0.23341921d0,
     & 0.23592831d0, 0.23841298d0, 0.24087866d0, 0.24334651d0,
     & 0.24590799d0, 0.24847503d0, 0.25106254d0, 0.25362411d0,
     & 0.25612989d0, 0.25863266d0, 0.26113516d0, 0.26362002d0,
     & 0.26617709d0, 0.26875991d0, 0.27139491d0, 0.27395177d0,
     & 0.27649957d0, 0.27902558d0, 0.28155255d0, 0.28408238d0,
     & 0.28667843d0, 0.28928602d0, 0.29193237d0, 0.29452255d0,
     & 0.29712230d0, 0.29966480d0, 0.30220792d0, 0.30475289d0,
     & 0.30730024d0, 0.30988556d0, 0.31253755d0, 0.31516230d0,
     & 0.31777152d0, 0.32035592d0, 0.32294020d0, 0.32552594d0,
     & 0.32809228d0, 0.33072549d0, 0.33335206d0, 0.33602229d0,
     & 0.33865237d0, 0.34127399d0, 0.34387350d0, 0.34647399d0,
     & 0.34907603d0, 0.35165915d0, 0.35426387d0, 0.35693982d0,
     & 0.35957208d0, 0.36222860d0, 0.36485651d0, 0.36752585d0,
     & 0.37013009d0, 0.37273520d0, 0.37534201d0, 0.37795129d0,
     & 0.38066691d0, 0.38336560d0, 0.38603267d0, 0.38869354d0,
     & 0.39135242d0, 0.39401081d0, 0.39662698d0, 0.39924482d0,
     & 0.40188289d0, 0.40455836d0, 0.40729755d0, 0.40994957d0,
     & 0.41259581d0, 0.41524115d0, 0.41788793d0, 0.42051437d0,
     & 0.42318842d0, 0.42584312d0, 0.42852244d0, 0.43120366d0,
     & 0.43391043d0, 0.43657449d0, 0.43925947d0, 0.44194400d0,
     & 0.44460645d0, 0.44727039d0, 0.44995821d0, 0.45262527d0,
     & 0.45531604d0, 0.45802423d0, 0.46072733d0, 0.46339300d0,
     & 0.46608123d0, 0.46876976d0, 0.47145930d0, 0.47414944d0,
     & 0.47684065d0, 0.47955793d0, 0.48223245d0, 0.48491019d0,
     & 0.48761472d0, 0.49035981d0, 0.49310344d0, 0.49579975d0,
     & 0.49847400d0, 0.50115061d0, 0.50385344d0, 0.50653589d0,
     & 0.50919706d0, 0.51186007d0, 0.51450199d0, 0.51714545d0,
     & 0.51976627d0, 0.52241421d0, 0.52503979d0, 0.52769178d0,
     & 0.53032207d0, 0.53293097d0, 0.53554189d0, 0.53813136d0,
     & 0.54074621d0, 0.54336238d0, 0.54598755d0, 0.54859799d0,
     & 0.55116427d0, 0.55375916d0, 0.55635762d0, 0.55898333d0,
     & 0.56161135d0, 0.56424111d0, 0.56684816d0, 0.56948143d0,
     & 0.57211667d0, 0.57468444d0, 0.57726920d0, 0.57989705d0,
     & 0.58253092d0, 0.58514422d0, 0.58778107d0, 0.59044588d0,
     & 0.59308922d0, 0.59576005d0, 0.59836125d0, 0.60096562d0,
     & 0.60359740d0, 0.60618722d0, 0.60874104d0, 0.61136013d0,
     & 0.61398828d0, 0.61657763d0, 0.61919737d0, 0.62184501d0,
     & 0.62449533d0, 0.62717259d0, 0.62987697d0, 0.63250941d0,
     & 0.63514394d0, 0.63778597d0, 0.64035112d0, 0.64297974d0,
     & 0.64562386d0, 0.64822477d0, 0.65083110d0, 0.65344185d0,
     & 0.65613258d0, 0.65875030d0, 0.66147053d0, 0.66419232d0,
     & 0.66686624d0, 0.66954219d0, 0.67213988d0, 0.67471331d0,
     & 0.67735595d0, 0.68001437d0, 0.68268085d0, 0.68527639d0,
     & 0.68792701d0, 0.69060761d0, 0.69323957d0, 0.69592506d0,
     & 0.69861287d0, 0.70130295d0, 0.70396954d0, 0.70655495d0,
     & 0.70914203d0, 0.71171361d0, 0.71435255d0, 0.71700221d0,
     & 0.71957976d0, 0.72221565d0, 0.72493571d0, 0.72760791d0,
     & 0.73028409d0, 0.73301506d0, 0.73574919d0, 0.73846120d0,
     & 0.74112689d0, 0.74371797d0, 0.74629372d0, 0.74890625d0,
     & 0.75157267d0, 0.75414485d0, 0.75677633d0, 0.75941318d0,
     & 0.76202857d0, 0.76464766d0, 0.76726967d0, 0.76991928d0,
     & 0.77267545d0, 0.77538162d0, 0.77804482d0, 0.78064746d0,
     & 0.78326070d0, 0.78591210d0, 0.78858745d0, 0.79127455d0,
     & 0.79396904d0, 0.79666930d0, 0.79939979d0, 0.80202991d0,
     & 0.80476791d0, 0.80750853d0, 0.81027770d0, 0.81302327d0,
     & 0.81572211d0, 0.81836480d0, 0.82099122d0, 0.82360661d0,
     & 0.82625264d0, 0.82891667d0, 0.83159077d0, 0.83424652d0,
     & 0.83690733d0, 0.83954656d0, 0.84218949d0, 0.84480911d0,
     & 0.84745765d0, 0.85021460d0, 0.85297364d0, 0.85564309d0,
     & 0.85828996d0, 0.86092263d0, 0.86351842d0, 0.86620724d0,
     & 0.86889076d0, 0.87158573d0, 0.87431550d0, 0.87705177d0,
     & 0.87968767d0, 0.88232863d0, 0.88502675d0, 0.88770223d0,
     & 0.89038181d0, 0.89306456d0, 0.89575738d0, 0.89845198d0,
     & 0.90108007d0, 0.90369856d0, 0.90640110d0, 0.90906394d0,
     & 0.91173977d0, 0.91442430d0, 0.91719753d0, 0.91997576d0,
     & 0.92273057d0, 0.92538214d0, 0.92803693d0, 0.93074751d0,
     & 0.93356824d0, 0.93629891d0, 0.93901205d0, 0.94170845d0,
     & 0.94439405d0, 0.94701600d0, 0.94970471d0, 0.95243800d0,
     & 0.95518178d0, 0.95787644d0, 0.96057755d0, 0.96323168d0,
     & 0.96589047d0, 0.96860552d0, 0.97129685d0, 0.97399098d0,
     & 0.97668767d0, 0.97942179d0, 0.98213565d0, 0.98483622d0,
     & 0.98752958d0, 0.99021477d0, 0.99290419d0, 0.99561477d0,
     & 0.99833786d0, 1.00109661d0, 1.00386131d0, 1.00657499d0,
     & 1.00921297d0, 1.01185489d0, 1.01450086d0, 1.01720381d0,
     & 1.01990950d0, 1.02255058d0, 1.02516818d0, 1.02777147d0,
     & 1.03046942d0, 1.03316045d0, 1.03595412d0, 1.03874922d0,
     & 1.04155970d0, 1.04429352d0, 1.04703712d0, 1.04978871d0,
     & 1.05254734d0, 1.05531096d0, 1.05810738d0, 1.06080294d0,
     & 1.06350219d0, 1.06615210d0, 1.06874287d0, 1.07131672d0,
     & 1.07396638d0, 1.07660592d0, 1.07934713d0, 1.08213329d0,
     & 1.08494949d0, 1.08775258d0, 1.09056556d0, 1.09335649d0,
     & 1.09609628d0, 1.09886920d0, 1.10164678d0, 1.10442829d0,
     & 1.10724127d0, 1.10994768d0, 1.11260498d0, 1.11523044d0,
     & 1.11783910d0, 1.12040854d0, 1.12299812d0, 1.12563741d0,
     & 1.12829781d0, 1.13114047d0, 1.13400149d0, 1.13681602d0,
     & 1.13963962d0, 1.14241278d0, 1.14519131d0, 1.14797497d0,
     & 1.15076220d0, 1.15355349d0, 1.15634871d0, 1.15911937d0,
     & 1.16173291d0, 1.16432512d0, 1.16693473d0, 1.16953385d0,
     & 1.17218280d0, 1.17479694d0, 1.17740524d0, 1.18025267d0,
     & 1.18312001d0, 1.18599916d0, 1.18888712d0, 1.19169593d0,
     & 1.19451189d0, 1.19733214d0, 1.20015681d0, 1.20298529d0,
     & 1.20584488d0, 1.20870733d0, 1.21132851d0, 1.21391904d0,
     & 1.21646905d0, 1.21901131d0, 1.22160542d0, 1.22419369d0,
     & 1.22674966d0, 1.22933030d0, 1.23200786d0, 1.23470986d0,
     & 1.23742688d0, 1.24012363d0, 1.24283898d0, 1.24558926d0,
     & 1.24834526d0, 1.25107706d0, 1.25381327d0, 1.25658107d0,
     & 1.25929582d0, 1.26188529d0, 1.26442277d0, 1.26694596d0,
     & 1.26951861d0, 1.27208257d0, 1.27461112d0, 1.27713275d0,
     & 1.27967823d0, 1.28219116d0, 1.28474867d0, 1.28737080d0,
     & 1.29000723d0, 1.29265451d0, 1.29540253d0, 1.29815757d0,
     & 1.30091846d0, 1.30371273d0, 1.30645370d0, 1.30919886d0,
     & 1.31194711d0, 1.31465006d0, 1.31731653d0, 1.31999552d0,
     & 1.32266307d0, 1.32523072d0, 1.32779098d0, 1.33031690d0,
     & 1.33283770d0, 1.33541214d0, 1.33795416d0, 1.34066057d0,
     & 1.34341896d0, 1.34619021d0, 1.34894085d0, 1.35169935d0,
     & 1.35443270d0, 1.35717285d0, 1.35994649d0, 1.36272430d0,
     & 1.36547697d0, 1.36826134d0, 1.37090993d0, 1.37347746d0,
     & 1.37600350d0, 1.37855136d0, 1.38109136d0, 1.38365579d0,
     & 1.38621342d0, 1.38876641d0, 1.39128697d0, 1.39383161d0,
     & 1.39643717d0, 1.39903951d0, 1.40168905d0, 1.40434909d0,
     & 1.40701914d0, 1.40972590d0, 1.41252840d0, 1.41533589d0,
     & 1.41814661d0, 1.42096043d0, 1.42375016d0, 1.42648029d0,
     & 1.42918491d0, 1.43187141d0, 1.43457639d0, 1.43727124d0,
     & 1.43992937d0, 1.44249177d0, 1.44504917d0, 1.44757473d0,
     & 1.45012581d0, 1.45270264d0, 1.45531809d0, 1.45810437d0,
     & 1.46090591d0, 1.46368778d0, 1.46647918d0, 1.46930754d0,
     & 1.47205365d0, 1.47483635d0, 1.47765374d0, 1.48044682d0,
     & 1.48324490d0, 1.48597515d0, 1.48856497d0, 1.49114096d0,
     & 1.49370897d0, 1.49626899d0, 1.49882257d0, 1.50146019d0,
     & 1.50403392d0, 1.50660479d0, 1.50920141d0, 1.51176608d0,
     & 1.51442146d0, 1.51707447d0, 1.51974690d0, 1.52246189d0,
     & 1.52515626d0, 1.52785921d0, 1.53053892d0, 1.53325379d0,
     & 1.53609169d0, 1.53893375d0, 1.54177880d0, 1.54456294d0,
     & 1.54729128d0, 1.55000079d0, 1.55269742d0, 1.55538607d0,
     & 1.55806684d0, 1.56077123d0, 1.56347001d0, 1.56601572d0,
     & 1.56855786d0, 1.57112455d0, 1.57365918d0, 1.57631791d0,
     & 1.57900715d0, 1.58171415d0, 1.58443165d0, 1.58728266d0,
     & 1.59014082d0, 1.59300339d0, 1.59587026d0, 1.59874344d0,
     & 1.60156131d0, 1.60444367d0, 1.60726154d0, 1.61002004d0,
     & 1.61276150d0, 1.61546350d0, 1.61803246d0, 1.62059486d0,
     & 1.62315309d0, 1.62570739d0, 1.62825572d0, 1.63086140d0,
     & 1.63343227d0, 1.63600004d0, 1.63859689d0, 1.64124739d0,
     & 1.64397919d0, 1.64669430d0, 1.64942157d0, 1.65215850d0,
     & 1.65505493d0, 1.65795553d0, 1.66083133d0, 1.66371357d0,
     & 1.66659987d0, 1.66942799d0, 1.67220318d0, 1.67495668d0,
     & 1.67769814d0, 1.68042827d0, 1.68314958d0, 1.68574142d0,
     & 1.68832958d0, 1.69091403d0, 1.69349265d0, 1.69606781d0,
     & 1.69864106d0, 1.70121157d0, 1.70377958d0, 1.70641863d0,
     & 1.70908821d0, 1.71177566d0, 1.71447599d0, 1.71718657d0,
     & 1.71990371d0, 1.72262824d0, 1.72532845d0, 1.72806251d0,
     & 1.73080158d0, 1.73354232d0, 1.73624647d0, 1.73889303d0,
     & 1.74161410d0, 1.74432456d0, 1.74699759d0, 1.74969554d0,
     & 1.75235891d0, 1.75495982d0, 1.75755823d0, 1.76024246d0,
     & 1.76289749d0, 1.76554728d0, 1.76822579d0, 1.77072167d0,
     & 1.77325475d0, 1.77586901d0, 1.77847290d0, 1.78112316d0,
     & 1.78387463d0, 1.78663421d0, 1.78928256d0, 1.79196787d0,
     & 1.79465973d0, 1.79726386d0, 1.79996383d0, 1.80259895d0,
     & 1.80527556d0, 1.80796432d0, 1.81060815d0, 1.81323910d0,
     & 1.81592464d0, 1.81863391d0, 1.82130671d0, 1.82400382d0,
     & 1.82672822d0, 1.82944810d0, 1.83219421d0, 1.83481634d0,
     & 1.83743560d0, 1.84008205d0, 1.84269834d0, 1.84532559d0,
     & 1.84798348d0, 1.85069013d0, 1.85334647d0, 1.85607600d0,
     & 1.85881484d0, 1.86153042d0, 1.86425185d0, 1.86697960d0,
     & 1.86971271d0, 1.87263036d0, 1.87550890d0, 1.87835848d0,
     & 1.88106990d0, 1.88380122d0, 1.88640213d0, 1.88899517d0,
     & 1.89158285d0, 1.89425576d0, 1.89692330d0, 1.89958668d0,
     & 1.90209603d0, 1.90457070d0, 1.90704298d0, 1.90960383d0,
     & 1.91216445d0, 1.91484141d0, 1.91755748d0, 1.92033648d0,
     & 1.92294037d0, 1.92556274d0, 1.92816639d0, 1.93087447d0,
     & 1.93362296d0, 1.93637848d0, 1.93913913d0, 1.94190526d0,
     & 1.94458425d0, 1.94722676d0, 1.94983876d0, 1.95253766d0,
     & 1.95522034d0, 1.95783269d0, 1.96046352d0, 1.96305525d0,
     