/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.topology.descriptor;

import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.topology.descriptor.DistanceFunction;
import org.ow2.proactive.topology.descriptor.TopologyDescriptor;

@PublicAPI
public class BestProximityDescriptor
extends TopologyDescriptor {
    protected DistanceFunction function = MAX;
    public static final DistanceFunction AVG = new DistanceFunction(){
        private static final long serialVersionUID = 84L;

        @Override
        public long distance(long d1, long d2) {
            if (d1 < 0L || d2 < 0L) {
                return -1L;
            }
            return (d1 + d2) / 2L;
        }
    };
    public static final DistanceFunction MAX = new DistanceFunction(){
        private static final long serialVersionUID = 84L;

        @Override
        public long distance(long d1, long d2) {
            if (d1 < 0L || d2 < 0L) {
                return -1L;
            }
            return Math.max(d1, d2);
        }
    };
    public static final DistanceFunction MIN = new DistanceFunction(){
        private static final long serialVersionUID = 84L;

        @Override
        public long distance(long d1, long d2) {
            return Math.min(d1, d2);
        }
    };
    private static final long serialVersionUID = 84L;

    public BestProximityDescriptor() {
        super(true);
    }

    public DistanceFunction getDistanceFunction() {
        return this.function == null ? MAX : this.function;
    }
}

