/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
public class ResultPreviewTool {
    public static Logger logger = Logger.getLogger(ResultPreviewTool.class);
    public static final String WINDOWS_HOME_ENV_VAR = "WINDOWS_HOME";
    public static final String UNIX_HOME_ENV_VAR = "UNIX_HOME";

    public static String getSystemCompliantPath(String path) {
        String winHome = System.getenv(WINDOWS_HOME_ENV_VAR);
        String unixHome = System.getenv(UNIX_HOME_ENV_VAR);
        logger.info((Object)("[RESULT_PREVIEW] WINHOME: [" + winHome + "]"));
        logger.info((Object)("[RESULT_PREVIEW] UNIXHOME: [" + unixHome + "]"));
        if (winHome == null || unixHome == null) {
            System.err.println("[RESULT_PREVIEW] Warning : home directories variables are not set !");
            return path;
        }
        if (System.getProperty("os.name").contains("Windows")) {
            if (path.contains("/") && !path.contains("\\")) {
                path = path.replace(unixHome, winHome);
                path = path.replace('/', '\\');
            }
            return path;
        }
        if (path.contains(":\\") || path.contains("\\\\")) {
            path = path.replace(winHome, unixHome);
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static class SimpleTextPanel
    extends JPanel {
        private String text;
        JTextArea textZone = new JTextArea(15, 40);
        private static final long serialVersionUID = 84L;

        public SimpleTextPanel(String text) {
            this.text = text;
            this.setBackground(Color.DARK_GRAY);
            this.setLayout(new BorderLayout());
            Font f = new Font("Arial", 1, 12);
            this.textZone.setFont(f);
            this.add((Component)this.textZone, "Center");
            this.textZone.setEditable(false);
            this.textZone.setMargin(new Insets(7, 7, 7, 7));
            this.textZone.setText(text);
            this.setBorder(BorderFactory.createEtchedBorder(1));
        }

        @Override
        public String toString() {
            return "Simple text panel for " + this.text;
        }
    }

    public static class SimpleImagePanel
    extends JPanel {
        private transient Image img;
        private String path;
        private static final long serialVersionUID = 84L;

        public SimpleImagePanel(String path) {
            this.path = path;
            this.img = new ImageIcon(path).getImage();
            this.setBackground(Color.DARK_GRAY);
            this.setDoubleBuffered(true);
            Dimension size = new Dimension(this.img.getWidth(null), this.img.getHeight(null));
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setSize(size);
            this.setBorder(BorderFactory.createEtchedBorder(1));
            this.setLayout(null);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.img, 0, 0, null);
        }

        @Override
        public String toString() {
            return "Simple image panel for " + this.path;
        }
    }
}

